/*************************************************************************************/
// -->Template Name: Bootstrap Press Admin
// -->Author: Themedesigner
// -->Email: niravjoshi87@gmail.com
// -->File: datatable_advanced_init
/*************************************************************************************/

//=============================================//
//    File export                              //
//=============================================//
//var DataTable = require('datatables.net');
var JSZip = require('jszip/dist/jszip.min');
window.JSZip = JSZip;
var pdfMake = require('pdfmake/build/pdfmake.js');
var pdfFonts = require('pdfmake/build/vfs_fonts.js');
pdfMake.vfs = pdfFonts.pdfMake.vfs;
require('@hotwired/turbo');

require('jquery');
require('jszip');
require('pdfmake');
require('datatables.net-dt');
require('datatables.net-editor-dt');
require('datatables.net-autofill-dt');
require('datatables.net-buttons-dt');
require('datatables.net-buttons/js/buttons.colVis.js');
require('datatables.net-buttons/js/buttons.html5.js');
require('datatables.net-buttons/js/buttons.print.js');
require('datatables.net-colreorder-dt');
require('datatables.net-datetime');
require('datatables.net-fixedcolumns-dt');
require('datatables.net-fixedheader-dt');
require('datatables.net-keytable-dt');
require('datatables.net-responsive-dt');
require('datatables.net-rowgroup-dt');
require('datatables.net-rowreorder-dt');
require('datatables.net-scroller-dt');
require('datatables.net-searchbuilder-dt');
require('datatables.net-searchpanes-dt');
require('datatables.net-select-dt');
require('datatables.net-staterestore-dt');





/*document.addEventListener('turbolinks:load', function() {
    // Détruire l'instance JQuery existante
    if (tableJQ) {
        tableJQ.destroy();
    }

    // Recréer la table JQuery avec les données appropriées
    tableJQ = $('#file_export').DataTable({
        // Options de configuration de la table
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    $('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary mr-1');

});*/

/*$('#file_export').DataTable({
    dom: 'Bfrtip',
    buttons: [
        'copy', 'csv', 'excel', 'pdf', 'print'
    ]
});
$('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary mr-1');*/

//==================================================//
//  Show / hide columns dynamically                 //
//==================================================//

var table = $('#show_hide_col').DataTable({
    "scrollY": "200px",
    "paging": false
});

$('a.toggle-vis').on('click', function (e) {
    e.preventDefault();

    // Get the column API object
    /*var column = table.column($(this).attr('data-column'));*/
    var column = $('#show_hide_col').dataTable().api().column($(this).attr('data-column'));
    // Toggle the visibility
    column.visible(!column.visible());
});

//=============================================//
//    Column rendering                         //
//=============================================//
$('#col_render').DataTable({
    "columnDefs": [{
        // The `data` parameter refers to the data for the cell (defined by the
        // `data` option, which defaults to the column being worked with, in
        // this case `data: 0`.
        "render": function (data, type, row) {
            return data + ' (' + row[3] + ')';
        },
        "targets": 0
    },
        {"visible": false, "targets": [3]}
    ]
});

//=============================================//
//     Row grouping                            //
//=============================================//
var table = $('#row_group').DataTable({
    "pageLength": 10,
    "columnDefs": [
        {"visible": false, "targets": 2}
    ],
    "order": [
        [2, 'asc']
    ],
    "displayLength": 25,
    "drawCallback": function (settings) {
        var api = this.api();
        var rows = api.rows({page: 'current'}).nodes();
        var last = null;

        api.column(2, {page: 'current'}).data().each(function (group, i) {
            if (last !== group) {
                $(rows).eq(i).before(
                    '<tr class="group"><td colspan="5">' + group + '</td></tr>'
                );

                last = group;
            }
        });
    }
});

//=============================================//
// Order by the grouping
//=============================================//
$('#row_group tbody').on('click', 'tr.group', function () {
    var currentOrder = table.order()[0];
    if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
        table.order([2, 'desc']).draw();
    } else {
        table.order([2, 'asc']).draw();
    }
});

//=============================================//
//    Multiple table control element           //
//=============================================//
$('#multi_control').DataTable({
    "dom": '<"top"iflp<"clear">>rt<"bottom"iflp<"clear">>'
});

//=============================================//
//    DOM/jquery events                        //
//=============================================//
var table = $('#dom_jq_event').DataTable();

$('#dom_jq_event tbody').on('click', 'tr', function () {
    var data = table.row(this).data();
    alert('You clicked on ' + data[0] + '\'s row');
});

//=============================================//
//    Language File                            //
//=============================================//
$('#lang_file').DataTable({
    "language": {
        "url": "../../dist/js/pages/datatable/German.json"
    }
});

//=============================================//
//    Complex headers with column visibility   //
//=============================================//

$('#complex_head_col').DataTable({
    "columnDefs": [{
        "visible": false,
        "targets": -1
    }]
});

//=============================================//
//    Setting defaults                         //
//=============================================//
var defaults = {
    "searching": false,
    "ordering": false
};

$('#setting_defaults').dataTable($.extend(true, {}, defaults, {}));


//=============================================//
//    Footer callback                          //
//=============================================//
$('#footer_callback').DataTable({
    "footerCallback": function (row, data, start, end, display) {
        var api = this.api(),
            data;

        // Remove the formatting to get integer data for summation
        var intVal = function (i) {
            return typeof i === 'string' ?
                i.replace(/[\$,]/g, '') * 1 :
                typeof i === 'number' ?
                    i : 0;
        };

        // Total over all pages
        total = api
            .column(4)
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0);

        // Total over this page
        pageTotal = api
            .column(4, {page: 'current'})
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0);

        // Update footer
        $(api.column(4).footer()).html(
            '$' + pageTotal + ' ( $' + total + ' total)'
        );
    }
});

//=============================================//
//    Custom toolbar elements                  //
//=============================================//

$('#custom_tool_ele').DataTable({
    "dom": '<"toolbar">frtip'
});

$("div.toolbar").html('<b>Custom tool bar! Text/images etc.</b>');


//=============================================//
//    Row created callback                     //
//=============================================//
$('#row_create_call').DataTable({
    "createdRow": function (row, data, index) {
        if (data[5].replace(/[\$,]/g, '') * 1 > 150000) {
            $('td', row).eq(5).addClass('highlight');
        }
    }
});

/*
$('#file_export').DataTable({
    dom: 'Bfrtip',
    buttons: [
        'copy', 'csv', 'excel', 'pdf', 'print'
    ]
});
$('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-primary mr-1');*/
