import '../../css/pages/pagetable.css';
/*
 * Welcome to your app's main JavaScript file!
 *
 * We recommend including the built version of this JavaScript file
 * (and its CSS file) in your base layout (base.html.twig).
 */
var $ = require('jquery');
require('jquery-ui');
// create global $ and jQuery variables
global.$ = global.jQuery = $;

require('../../plugins/popper/popper.min');

require('../../plugins/bootstrap/js/bootstrap.min');

require('../jquery.slimscroll');

require('../waves');

require('../sidebarmenu');

require('../../plugins/sticky-kit-master/dist/sticky-kit.min');

require('../../plugins/sparkline/jquery.sparkline.min');

require('../custom.min');

require('../../plugins/styleswitcher/jQuery.style.switcher');

// require('easytimer');


// WebAudioRecorderWav.min.js: worker for Waveform Audio (concatenated with encoder and recompressed)
// WebAudioRecorderOgg.min.js: worker for Ogg Vorbis (concatenated with encoder and recompressed)
// WebAudioRecorderMp3.min.js: worker for MP3 (concatenated with encoder and recompressed)
// OggVorbisEncoder.min.js.mem: memory initializer for Ogg Vorbis encoder (same file as above)
// Mp3LameEncoder.min.js.mem


// require('web-audio-recorder-js/lib/WebAudioRecorderWav');
// require('web-audio-recorder-js/lib/WebAudioRecorderOgg');
// require('web-audio-recorder-js/lib/WebAudioRecorderMp3');
// require('web-audio-recorder-js/lib/OggVorbisEncoder.min.js');
// require('web-audio-recorder-js/lib/Mp3LameEncoder.min.js');

require('web-audio-recorder-js/lib-minified/WebAudioRecorder.min');


var Timer = require('easytimer.js').Timer;
var timer = new Timer();

// console.log(timer);

$(document).ready(function () {
    URL = window.URL || window.webkitURL;

    var gumStream; 						//stream from getUserMedia()
    var recorder; 						//WebAudioRecorder object
    var input; 							//MediaStreamAudioSourceNode  we'll be recording
    var encodingType; 					//holds selected encoding for resulting audio (file)
    var encodeAfterRecord = true;       // when to encode

    // shim for AudioContext when it's not avb.
    var AudioContext = window.AudioContext || window.webkitAudioContext;
    var audioContext; //new audio context to help us record

    var encodingTypeSelect = document.getElementById("encodingTypeSelect");
    var recordButton = document.getElementById("recordButton");
    var stopButton = document.getElementById("stopButton");

    //add events to those 2 buttons
    recordButton.addEventListener("click", startRecording);
    stopButton.addEventListener("click", stopRecording);


    function startRecording() {
        // console.log("Demarrage enregistrement");

        /*
            Simple constraints object, for more advanced features see
            https://addpipe.com/blog/audio-constraints-getusermedia/
        */

        var constraints = {audio: true, video: false}

        /*
            We're using the standard promise based getUserMedia()
            https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia
        */

        navigator.mediaDevices.getUserMedia(constraints).then(function (stream) {
            __log("accès au micro, création du stream");

            /*
                create an audio context after getUserMedia is called
                sampleRate might change after getUserMedia is called, like it does on macOS when recording through AirPods
                the sampleRate defaults to the one set in your OS for your playback device
            */
            audioContext = new AudioContext();

            //update the format
            // document.getElementById("formats").innerHTML = "Format: 2 channel " + encodingTypeSelect.options[encodingTypeSelect.selectedIndex].value + " @ " + audioContext.sampleRate / 1000 + "kHz"

            //assign to gumStream for later use
            gumStream = stream;

            /* use the stream */
            input = audioContext.createMediaStreamSource(stream);

            //stop the input from playing back through the speakers
            //input.connect(audioContext.destination)

            //get the encoding
            encodingType = encodingTypeSelect.options[encodingTypeSelect.selectedIndex].value;

            //disable the encoding selector
            encodingTypeSelect.disabled = true;

            recorder = new WebAudioRecorder(input, {
                workerDir: "/js/", // must end with slash
                encoding: encodingType,
                numChannels: 2, //2 is the default, mp3 encoding supports only 2
                onEncoderLoading: function (recorder, encoding) {
                    // show "loading encoder..." display
                    __log("Chargement " + encoding + " encodeur...");
                },
                onEncoderLoaded: function (recorder, encoding) {
                    // hide "loading encoder..." display
                    __log(encoding + " encodeur chargé");
                }
            });

            recorder.onComplete = function (recorder, blob) {
                __log("Enregistrement terminé");
                createDownloadLink(blob, recorder.encoding);
                encodingTypeSelect.disabled = false;
                timer.stop();
            }

            recorder.setOptions({
                timeLimit: 1800,
                encodeAfterRecord: encodeAfterRecord,
                ogg: {quality: 0.5},
                mp3: {bitRate: 64}
            });

            //start the recording process
            timer.start();
            timer.addEventListener('secondsUpdated', function (e) {
                $('#timer_span').html(timer.getTimeValues().toString());
            });

            recorder.startRecording();


            __log("Enregistrement en cours");

        }).catch(function (err) {
            //enable the record button if getUSerMedia() fails
            __log("Une erreur s'est produite");
            __log(err);
            recordButton.disabled = false;
            stopButton.disabled = true;
            // console.log(err);
            // timer.stop();

        });

        //disable the record button
        recordButton.disabled = true;
        stopButton.disabled = false;
    }

    function stopRecording() {
        // console.log("Teminer enregistrement");

        //stop microphone access
        gumStream.getAudioTracks()[0].stop();

        //disable the stop button
        stopButton.disabled = true;
        recordButton.disabled = false;

        //tell the recorder to finish the recording (stop recording + encode the recorded audio)
        recorder.finishRecording();

        __log('Enregistrement terminé');
    }

    function createDownloadLink(blob, encoding) {


        // blob.name = chaptitle;

        // console.log(blob);

        var url = URL.createObjectURL(blob);
        var au = document.createElement('audio');
        var li = document.createElement('li');
        var link = document.createElement('a');


        var btupload = $('<button class="btn btn-success" ><i class="fa fa-upload"></i> Téléverser </button>')

        var loader = $('<div class="spinner-border text-success" role="status">\n' +
            '                                  <span class="sr-only">Loading...</span>\n' +
            '                                </div>');

        btupload.on('click', function () {
            var fd = new FormData();
            //fd.append('fname', 'test.wav');
            fd.append('data', blob, chaptitle + '.mp3');
            $(au).after(loader);
            $.ajax({
                type: 'POST',
                url: upload_to_url,
                data: fd,
                processData: false,
                contentType: false
            }).done(function (data) {
                loader.remove();
                // console.log(data);
                loader.remove();
                $(au).after('<span><i class="fa fa-check"></i>Terminé</span>');
                btupload.attr('disabled',true);
            }).error(function (jqXHR, textStatus, errorThrown ) {
                loader.remove();
            });
        });

        var btremove = $('<button class="btn btn-danger" ><i class="fa fa-trash"></i> Supprimer </button>')


        //add controls to the <audio> element
        au.controls = true;
        au.src = url;

        //link the a element to the blob
        link.href = url;
        link.download = new Date().toISOString() + '.' + encoding;
        link.innerHTML = '<i class="fa fa-download"></i> Telecharger';

        li = $(li);

        //add the new audio and a elements to the li element

        link = $(link);

        li.append(au);
        li.append($('<br/>'));
        li.append(link);
        li.append(btupload);
        li.append(btremove);


        link.addClass('btn btn-info');


        btremove.on('click', function () {
            li.remove();
        });

        //add the li element to the ordered list
        $(recordingsList).append(li);
    }


    //helper function
    function __log(e, data) {
        log.innerHTML = "\n" + e + " " + (data || '');
    }
});
