<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240322182707 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE charoit (id INT AUTO_INCREMENT NOT NULL, typecharoit_id INT DEFAULT NULL, nom VARCHAR(255) DEFAULT NULL, marque VARCHAR(255) DEFAULT NULL, model VARCHAR(255) DEFAULT NULL, numerochassis VARCHAR(255) DEFAULT NULL, numeroplaque VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, INDEX IDX_62DDB0DB0D0F6C9 (typecharoit_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE pays (id INT AUTO_INCREMENT NOT NULL, nom VARCHAR(255) DEFAULT NULL, initial VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE province (id INT AUTO_INCREMENT NOT NULL, pays_id INT DEFAULT NULL, nom VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, INDEX IDX_4ADAD40BA6E44244 (pays_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE societe (id INT AUTO_INCREMENT NOT NULL, pays_id INT DEFAULT NULL, nom VARCHAR(255) DEFAULT NULL, adresse VARCHAR(255) DEFAULT NULL, telephone VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, INDEX IDX_19653DBDA6E44244 (pays_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE type_charoit (id INT AUTO_INCREMENT NOT NULL, societe_id INT DEFAULT NULL, nom VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, INDEX IDX_2E0CB4F8FCF77503 (societe_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE `user` (id INT AUTO_INCREMENT NOT NULL, email VARCHAR(180) NOT NULL, roles JSON NOT NULL COMMENT \'(DC2Type:json)\', password VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_IDENTIFIER_EMAIL (email), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE ville (id INT AUTO_INCREMENT NOT NULL, province_id INT DEFAULT NULL, nom VARCHAR(255) DEFAULT NULL, statut TINYINT(1) DEFAULT NULL, INDEX IDX_43C3D9C3E946114A (province_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE voyage (id INT AUTO_INCREMENT NOT NULL, villedepart_id INT DEFAULT NULL, villearrive_id INT DEFAULT NULL, datedepart DATE DEFAULT NULL, datearrive DATE DEFAULT NULL, reference VARCHAR(255) DEFAULT NULL, datecreation DATE DEFAULT NULL, INDEX IDX_3F9D895542235125 (villedepart_id), INDEX IDX_3F9D895518232926 (villearrive_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE messenger_messages (id BIGINT AUTO_INCREMENT NOT NULL, body LONGTEXT NOT NULL, headers LONGTEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', available_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', delivered_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_75EA56E0FB7336F0 (queue_name), INDEX IDX_75EA56E0E3BD61CE (available_at), INDEX IDX_75EA56E016BA31DB (delivered_at), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE charoit ADD CONSTRAINT FK_62DDB0DB0D0F6C9 FOREIGN KEY (typecharoit_id) REFERENCES type_charoit (id)');
        $this->addSql('ALTER TABLE province ADD CONSTRAINT FK_4ADAD40BA6E44244 FOREIGN KEY (pays_id) REFERENCES pays (id)');
        $this->addSql('ALTER TABLE societe ADD CONSTRAINT FK_19653DBDA6E44244 FOREIGN KEY (pays_id) REFERENCES pays (id)');
        $this->addSql('ALTER TABLE type_charoit ADD CONSTRAINT FK_2E0CB4F8FCF77503 FOREIGN KEY (societe_id) REFERENCES societe (id)');
        $this->addSql('ALTER TABLE ville ADD CONSTRAINT FK_43C3D9C3E946114A FOREIGN KEY (province_id) REFERENCES province (id)');
        $this->addSql('ALTER TABLE voyage ADD CONSTRAINT FK_3F9D895542235125 FOREIGN KEY (villedepart_id) REFERENCES ville (id)');
        $this->addSql('ALTER TABLE voyage ADD CONSTRAINT FK_3F9D895518232926 FOREIGN KEY (villearrive_id) REFERENCES ville (id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE charoit DROP FOREIGN KEY FK_62DDB0DB0D0F6C9');
        $this->addSql('ALTER TABLE province DROP FOREIGN KEY FK_4ADAD40BA6E44244');
        $this->addSql('ALTER TABLE societe DROP FOREIGN KEY FK_19653DBDA6E44244');
        $this->addSql('ALTER TABLE type_charoit DROP FOREIGN KEY FK_2E0CB4F8FCF77503');
        $this->addSql('ALTER TABLE ville DROP FOREIGN KEY FK_43C3D9C3E946114A');
        $this->addSql('ALTER TABLE voyage DROP FOREIGN KEY FK_3F9D895542235125');
        $this->addSql('ALTER TABLE voyage DROP FOREIGN KEY FK_3F9D895518232926');
        $this->addSql('DROP TABLE charoit');
        $this->addSql('DROP TABLE pays');
        $this->addSql('DROP TABLE province');
        $this->addSql('DROP TABLE societe');
        $this->addSql('DROP TABLE type_charoit');
        $this->addSql('DROP TABLE `user`');
        $this->addSql('DROP TABLE ville');
        $this->addSql('DROP TABLE voyage');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
