import { Exchange, ExecutionResult, OperationContext } from '../types';
export interface ObserverLike<T> {
    next: (value: T) => void;
    error: (err: any) => void;
    complete: () => void;
}
/** An abstract observable interface conforming to: https://github.com/tc39/proposal-observable */
export interface ObservableLike<T> {
    subscribe(observer: ObserverLike<T>): {
        unsubscribe: () => void;
    };
}
export interface SubscriptionOperation {
    query: string;
    variables?: Record<string, unknown>;
    key: string;
    context: OperationContext;
}
export declare type SubscriptionForwarder = (operation: SubscriptionOperation) => ObservableLike<ExecutionResult>;
/** This is called to create a subscription and needs to be hooked up to a transport client. */
export interface SubscriptionExchangeOpts {
    forwardSubscription: SubscriptionForwarder;
    /** This flag may be turned on to allow your subscriptions-transport to handle all operation types */
    enableAllOperations?: boolean;
}
export declare const subscriptionExchange: ({ forwardSubscription, enableAllOperations, }: SubscriptionExchangeOpts) => Exchange;
