Changelog
=========

## [41.2.1](https://github.com/ckeditor/ckeditor5/compare/v41.2.0...v41.2.1) (March 18, 2024)

We are happy to announce the release of CKEditor&nbsp;5 v41.2.1.

### Bug fixes

* **[clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard)**: Fixed a recent regression where importing documents from Word with suggestions caused CKEditor 5 to crash. ([commit](https://github.com/ckeditor/ckeditor5/commit/6f0d0401e32232a3fae72a47f472dafc9f237e68))
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: Resolved a bug where loading the `ImageResize` plugin before `ImageBlock` or `ImageInline` caused the editor to crash. ([commit](https://github.com/ckeditor/ckeditor5/commit/de65bbde4b08529cbd0fcdbbca017b1b5243221b))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-paste-from-office-enhanced](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office-enhanced/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget/v/41.2.1): v41.2.0 => v41.2.1
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count/v/41.2.1): v41.2.0 => v41.2.1
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration/v/41.2.1): v41.2.0 => v41.2.1
</details>


## [41.2.0](https://github.com/ckeditor/ckeditor5/compare/v41.1.0...v41.2.0) (March 6, 2024)

We are happy to announce the release of CKEditor&nbsp;5 v41.2.0.

### Copy-paste comments

Since the beginning, collaboration has been a focal point for CKEditor 5. This release brings another highly anticipated improvement for the popular Comments feature!

Now, when you cut-paste, copy-and-paste, or drag around a piece of content that includes comments, the comments will be retained. The improvement allows users to restructure their content without losing the information or discussion available in the comments.

By default, the comments are retained only on cut-and-paste and drag-and-drop actions. You can configure this behavior to be applied also on copy-paste or you can turn it off.

### Accessibility Help Dialog

CKEditor 5 v41.2.0 introduces the [Accessibility Help Dialog](https://ckeditor.com/docs/ckeditor5/latest/features/keyboard-support.html#displaying-keyboard-shortcuts-in-the-editor). With the hit of <kbd>Alt</kbd>/<kbd>Option</kbd>+<kbd>0</kbd> in the editor, users can now access the full list of available keyboard shortcuts. A toolbar button is available as well. This feature further improves the editor's usability and accessibility. It allows all users to navigate and operate CKEditor 5 more efficiently, thereby promoting a more inclusive user experience.

The Accessibility Help Dialog is enabled by default in the `Essentials` plugin pack, making it available straight away in most integrations. If your editor build does not use the `Essentials` pack, make sure that you add the `AccessibilityHelp` plugin in your configuration.

We would also like to mention that there are further accessibility support improvements in the pipeline, so keep your eyes peeled for news in the upcoming months.

### Other improvements and bug fixes

* AI Assistant will now try to retain comments on the processed content. The comments’ markup will be included in the data passed to the AI model. The result will depend on the response generated by the AI model.
* Added the ability to declare allowed URL protocols for links, like `tel` or `sms` , by introducing the `link.allowedProtocols` configuration property. After setting up your custom protocols, your users will easily navigate to specific resources from the inside of the editor.

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Comments will now be retained in the clipboard and pasted into the content when the user performs a cut-and-paste operation. To revert to previous behavior (with no retaining), set the `comments.copyMarkers` configuration property to an empty array.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The contents of the `BlockToolbar` and `BalloonToolbar` toolbars are now filled on the `EditorUIReadyEvent` instead of `Plugin#afterInit()`.

### Features

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: AI Assistant will now try to retain comments on the processed content. The comments markup will be included in the data passed to the AI model. The result will depend on the response generated by the AI model.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: AI pre-defined commands that require context will now be disabled when the selection is within an empty block. The toolbar dropdown will be disabled if all pre-defined commands are disabled.
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Introduced the copy-paste and cut-and-paste functionalities for comment markers. By default, comment markers will be retained on cut-and-paste actions. See documentation for the new `comments.copyMarkers` configuration property to learn more.
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Brought the `editor.accessibility` namespace to the base `Editor` class as a container for accessibility-related features and systems. See [#1014](https://github.com/ckeditor/ckeditor5/issues/1014). ([commit](https://github.com/ckeditor/ckeditor5/commit/e2b2f9dc33b395e151b6c36d79b8011cdb4458f1))
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Translations can now be passed as an object in the configuration. Closes [#15713](https://github.com/ckeditor/ckeditor5/issues/15713). ([commit](https://github.com/ckeditor/ckeditor5/commit/8561da714754529b26d53ad0d0bf0d50467609b0))
* **[find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace)**: The find and replace feature will dynamically update the search results when the document content changes. Closes [#15680](https://github.com/ckeditor/ckeditor5/issues/15680). ([commit](https://github.com/ckeditor/ckeditor5/commit/c66bb4dba7b04553780bfe4bfe3f6b20ac3282b0))
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: Added the ability to specify allowed URL protocols by introducing the `link.allowedProtocols` configuration property. Closes [#14304](https://github.com/ckeditor/ckeditor5/issues/14304). ([commit](https://github.com/ckeditor/ckeditor5/commit/fe4a56bb98785cc633679b5897e97706a256fe4c))
* **[revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history)**: Added the `revisionHistory.requireRevisionName` configuration option which makes the revision name required.
* **[revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history)**: Long revision names in the sidebar will now be indicated with ellipsis and will display a tooltip when the user hovers it.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Implemented the `AccessibilityHelp` plugin that brings a dialog displaying keyboard shortcuts available in the editor. Closes [#1014](https://github.com/ckeditor/ckeditor5/issues/1014). ([commit](https://github.com/ckeditor/ckeditor5/commit/e2b2f9dc33b395e151b6c36d79b8011cdb4458f1))

### Bug fixes

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Fixed a few scenarios where AI Assistant was incorrectly showing empty responses.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Custom functions passed in the `ai.openAI.requestParameters` configuration will no longer be overwritten by default parameters.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The selected widgets (for instance, images) will now be correctly highlighted while using AI Assistant.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Incorrect Markdown syntax should be stripped from the AI responses.
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Plugin order should not matter when it comes to registering schema for the `ckboxImageId` attribute. Closes [#15581](https://github.com/ckeditor/ckeditor5/issues/15581). ([commit](https://github.com/ckeditor/ckeditor5/commit/38ff3f11e4641c5c0306870c77eaa60fad8c0a0e))
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Use `translations` from the `defaultConfig` if they were not provided in the `create` method. Closes [#15902](https://github.com/ckeditor/ckeditor5/issues/15902). ([commit](https://github.com/ckeditor/ckeditor5/commit/39c3fa7298bd515e41c329f63dcad1aa1a5ccce0))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: Background color style should be properly preserved by GHS while the `FontBackgroundColor` plugin is enabled. It should also be able to preserve a partly defined style. Closes [#15757](https://github.com/ckeditor/ckeditor5/issues/15757), [#10399](https://github.com/ckeditor/ckeditor5/issues/10399). ([commit](https://github.com/ckeditor/ckeditor5/commit/00b00d42986d7d6f93ea09d893057990d547ee97))
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: Fixes the initialization of `ImageInsertViaUrlUI` so it does not depend on the configured plugins order. Closes [#15869](https://github.com/ckeditor/ckeditor5/issues/15869). ([commit](https://github.com/ckeditor/ckeditor5/commit/a201aed2400179f7c91bcb9fa7ad72626c1224c5))
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: Fixed an issue with inline images where resizing an image to reduce its dimensions resulted in the opposite effect. Closes [#10267](https://github.com/ckeditor/ckeditor5/issues/10267). ([commit](https://github.com/ckeditor/ckeditor5/commit/44e3c434bd725a828bfcedcd5fa3f70812b40702))
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: An error message will be displayed when numbered list start index input field has an incorrect value. Closes [#14939](https://github.com/ckeditor/ckeditor5/issues/14939). ([commit](https://github.com/ckeditor/ckeditor5/commit/6fa4a521c030f23ba6f6fa33d0b0c4f4b86411db))
* **[mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention)**: Inserting a mention should not append an extra white space if there was one already present in the content. A white space should not follow a mention inserted inside a pair of empty matching brackets. Closes [#4651](https://github.com/ckeditor/ckeditor5/issues/4651). ([commit](https://github.com/ckeditor/ckeditor5/commit/048a6ce4e4606e70ee4b8348c041feeeac96eb9b))
* **[minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap)**: The Minimap feature should not throw an error if an editing view rendering is performed while the editor is getting destroyed (for example, a cleanup rendering). ([commit](https://github.com/ckeditor/ckeditor5/commit/4c08d35c2e7dc5fef4fe2cbc97c5db7e72d3a7a2))
* **[pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination)**: Fixed `model-position-before-root` error thrown sometimes by the `Pagination` plugin, especially when loading big content in real-time-editing integration.
* **[paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office)**: It now should be possible to paste charts from Microsoft Word. Closes [#15758](https://github.com/ckeditor/ckeditor5/issues/15758). ([commit](https://github.com/ckeditor/ckeditor5/commit/9a14ebfda25e8f4d20e7186c3b41129457714a75))
* **[source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing)**: Source editing should not add whitespaces to the pre-formatted code lines. Closes [#15084](https://github.com/ckeditor/ckeditor5/issues/15084). ([commit](https://github.com/ckeditor/ckeditor5/commit/2d829980767722370afdb4e2719628c31da7fcd6))
* **[table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table)**: `TableUtils#getColumns()` should exclude elements other than `tableCell` (for example, marker elements) while counting. ([commit](https://github.com/ckeditor/ckeditor5/commit/36b6108805d4aaef083997ac686f4365d96b132c))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `BlockToolbar` and `BalloonToolbar` plugins order should not matter when it comes to registering toolbar items. Closes [#15581](https://github.com/ckeditor/ckeditor5/issues/15581). ([commit](https://github.com/ckeditor/ckeditor5/commit/38ff3f11e4641c5c0306870c77eaa60fad8c0a0e))
* **[utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils)**: The exported `keyCodes` object should contain correct codes for keys related to punctuation, brackets, braces, etc. See [#1014](https://github.com/ckeditor/ckeditor5/issues/1014). ([commit](https://github.com/ckeditor/ckeditor5/commit/e2b2f9dc33b395e151b6c36d79b8011cdb4458f1))

### Other changes

* **[case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change)**: Registered the case change keystroke in the accessibility help dialog. See [ckeditor/ckeditor5#1014](https://github.com/ckeditor/ckeditor5/issues/1014).
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Deprecated the `DataApiMixin` and moved the `setData()` and `getData()` methods directly to the `Editor` class. ([commit](https://github.com/ckeditor/ckeditor5/commit/b1d801d1ec77e8ab82fcd80a08642ca9e04b1b81))
* **[essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials)**: Enabled the `AccessibilityHelp` plugin by default. See [#1014](https://github.com/ckeditor/ckeditor5/issues/1014). ([commit](https://github.com/ckeditor/ckeditor5/commit/e2b2f9dc33b395e151b6c36d79b8011cdb4458f1))
* **[heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading)**: Adjusted the types in heading configuration options to enable passing of custom heading elements. ([commit](https://github.com/ckeditor/ckeditor5/commit/83fc67fbc3b8d9f5a092833484f5098b08881834))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Mutli-line tooltips will now have `max-width` set to `200px` by default. ([commit](https://github.com/ckeditor/ckeditor5/commit/153c26dc1306fbff88cb9ce7efc96d2bb80c354d))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Tooltip will now hide if `data-cke-tooltip-text` is removed while the tooltip is open. ([commit](https://github.com/ckeditor/ckeditor5/commit/039b302d9cbbda37e83a9dcaf4c6dead47e02194))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Tooltip position will be updated if `data-cke-tooltip-position` changes while the tooltip is open. ([commit](https://github.com/ckeditor/ckeditor5/commit/039b302d9cbbda37e83a9dcaf4c6dead47e02194))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/25e58716964c255bd1ca6bc6f0d78d76405177fa), [commit](https://github.com/ckeditor/ckeditor5/commit/7f6c80c8d09c71c9206470a1d1bfff42ae16b107), [commit](https://github.com/ckeditor/ckeditor5/commit/4a217d1c9e04048985cc99921f48b0e000fea2e0), [commit](https://github.com/ckeditor/ckeditor5/commit/f47c1bd2fee7b06149c42e78d43ce93202791652))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui/v/41.2.0): v41.1.0 => v41.2.0

Releases containing new features:

* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget/v/41.2.0): v41.1.0 => v41.2.0

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-paste-from-office-enhanced](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office-enhanced/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog/v/41.2.0): v41.1.0 => v41.2.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count/v/41.2.0): v41.1.0 => v41.2.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration/v/41.2.0): v41.1.0 => v41.2.0
</details>


## [41.1.0](https://github.com/ckeditor/ckeditor5/compare/v41.0.0...v41.1.0) (February 7, 2024)

We are happy to announce the release of CKEditor&nbsp;5 v41.1.0.

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: We fixed how the missing `value` of the `"class"` and `"style"` attribute conversion is handled in the `attributeToAttribute()` upcast helper. Now while not providing the attribute's `value` to conversion the helper accepts and consumes all values. Previously those values were not consumed and left for other converters to convert. Note that you should use the `classes`, and the `styles` fields for the fine-tuned conversion of those attributes instead of a catch-all `"style"` and `"class"` specified in the `key` field.
* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: The `colorSelectorView` property will no longer be accessible from the `ColorUI` plugin in the `@ckeditor/ckeditor5-font/src/ui/colorui.ts`.
* **[source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing)**: The source editing feature will now throw an error when used with real-time collaboration as these features are not fully compatible and may lead to data loss. You will have to explicitly enable source editing for real-time collaboration by setting the `sourceEditing.allowCollaborationFeatures` configuration flag to `true`. If you want to use both these features, please read a [new guide discussing the risks](https://ckeditor.com/docs/ckeditor5/latest/features/source-editing.html#limitations-and-incompatibilities) and add the flag to your configuration.

### Features

* **[collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core)**: The local user ("me" user) avatar will now have a distinct highlight (additional border) so it is easier to spot among other avatars. The related DOM element will receive the `.ck-user_me` CSS class to customize or remove the highlight.
* **[real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration)**: Introduced the `presenceList.displayMe` configuration flag. When set to `false`, the local user ("me" user) will not be displayed in the presence list. Defaults to `true`.

### Bug fixes

* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: The `style` and `class` attributes conversion should work with `attributeToAttribute()`. Closes [#4517](https://github.com/ckeditor/ckeditor5/issues/4517). ([commit](https://github.com/ckeditor/ckeditor5/commit/f0af6d4e27a62ca58baf2186ebbb788c7bc077dd))
* **[font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font)**: The font color and font background features should work in both the main toolbar and the balloon toolbar. Closes [#15580](https://github.com/ckeditor/ckeditor5/issues/15580). ([commit](https://github.com/ckeditor/ckeditor5/commit/63aaa3e84eb642b8aebd0e52ee49b9e32cf35ab8))
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: An image should not disappear after dragging in Windows OS in Chromium browsers. [#15700](https://github.com/ckeditor/ckeditor5/issues/15700). ([commit](https://github.com/ckeditor/ckeditor5/commit/ad8fa0c6633e8ee27d60b8555179731643165979))

### Other changes

* **[real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration)**: Modified the order of users in the presence list, so that local user ("me" user) is always visible first.
* **[source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing)**: Source editing will now throw an error when used with real-time collaboration. Added the `sourceEditing.allowCollaborationFeatures` configuration flag that suppresses the error and allows to use both features together. Closes [#15764](https://github.com/ckeditor/ckeditor5/issues/15764). ([commit](https://github.com/ckeditor/ckeditor5/commit/7ed0b7cf5f2062a328161514a3a8286d064cf1b3))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/6881c8c866c4c4f8c3a91aedcb64313e2992b106))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing/v/41.1.0): v41.0.0 => v41.1.0

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-paste-from-office-enhanced](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office-enhanced/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget/v/41.1.0): v41.0.0 => v41.1.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count/v/41.1.0): v41.0.0 => v41.1.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration/v/41.1.0): v41.0.0 => v41.1.0
</details>


## [41.0.0](https://github.com/ckeditor/ckeditor5/compare/v40.2.0...v41.0.0) (January 17, 2024)

We are happy to announce the release of CKEditor&nbsp;5 v41.0.0.

#### Improved list suggestions behavior

We continue to improve the way the editor displays the formatting suggestions.

This release includes integration of the list features with the new suggestions behavior. All list-related suggestions are now visible in the editor content.

#### The dialog system

The dialogs finally come to the CKEditor&nbsp;5 UI!

Some users found using the [find and replace](https://ckeditor.com/docs/ckeditor5/latest/features/find-and-replace.html) feature through a dropdown inconvenient as it might have covered the content, including the searched text. We listened to these voices and the find and replace UI will now be using a dialog.

If you liked the earlier user interface of this feature, you can still display it inside a dropdown by setting the [`config.findAndReplace.uiType`](https://ckeditor.com/docs/ckeditor5/latest/api/module_find-and-replace_findandreplaceconfig-FindAndReplaceConfig.html) configuration option.

We have also introduced a dialog in the [AI Assistant](https://ckeditor.com/docs/ckeditor5/latest/features/ai-assistant/ai-assistant-overview.html) feature. Displaying the AI Assistant inside a balloon came with many UX hiccups, especially when you selected large content. It works great now.

The dialogs are now a part of the [CKEditor&nbsp;5 UI library](https://ckeditor.com/docs/ckeditor5/latest/framework/architecture/ui-library.html#dialogs-and-modals) so you can use them, too! Read the documentation to learn how to display your custom features inside dialogs and modals.

#### Case change

No more *selecting*, *deleting*, *retyping with Caps Lock* for long legal preambles. The case change plugin enables users to easily change text cases, applying UPPERCASE, lowercase, and Title Case. This feature simplifies text formatting by allowing quick alterations with a single click or a keyboard shortcut.

As a key component of [CKEditor&nbsp;5's Productivity Pack](https://ckeditor.com/productivity-pack/), this plugin complements and enhances the suite's editing capabilities, offering a practical tool for efficient text manipulation.

#### Improving CKEditor&nbsp;5 installation methods

We start the new year with improvements in the new installation methods project. This includes an upgrade to the latest TypeScript version, ensuring enhanced type safety.

A key part of this release is the resolution of ECMAScript Module (ESM) compliance issues. We updated all packages and their definitions to be fully ESM-compliant. This ensures smoother integration and compatibility across various development environments.

We have also renamed exports of several classes, interfaces, and helpers to eliminate naming conflicts in the code for the new bundle that will appear later this year.

Take a look at the RFC to see what is coming: [https://github.com/ckeditor/ckeditor5/issues/15502](https://github.com/ckeditor/ckeditor5/issues/15502).

#### Deprecation of lists v1

This release marks a significant change in the list feature. [As announced before](https://github.com/ckeditor/ckeditor5/issues/14767), we are phasing out the older implementation of the `List` plugin, originally designed for plain lists. We are directing the development efforts towards the more advanced list v2 feature (formerly named `DocumentList`). This change aims to eliminate confusion for integrators and optimize the number of list functionalities.

The `DocumentList` plugins, which represent the advanced lists v2 feature, will now be available under the standard name `List`. This change enables document lists across all integrations, with the new version ensuring no loss of features from the older one.

We renamed the previous `List` plugins to `LegacyList`, providing a fallback option for integrators after the update. We will keep the `LegacyList` available for a couple of releases to lower the migration impact.

The existing `DocumentList` plugins were replaced with aliases. Integrations using the older `DocumentList` will continue to function without any need for configuration changes for a couple of releases. Users will be notified via console warnings to consider updating their configurations.

Additionally, we completely removed the `ListStyle` plugin, which has been deprecated for a while. This change aligns with our goal to simplify the list features.

### Release highlights

Refer to the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-41.html) to learn more about these changes.

### MAJOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: From this release on, the UI of the AI Assistant feature is displayed in a dialog instead of a balloon. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace)**: From this release on, the UI of the find and replace feature is displayed by default in a dialog instead of a dropdown. To bring the previous user experience back, you can use the [`config.findAndReplace.uiType`](https://ckeditor.com/docs/ckeditor5/latest/api/module_core_editor_editorconfig-EditorConfig.html#member-findAndReplace) configuration option. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The `AdjacentListsSupport` plugin is moved from the `documentlist` directory to the `list` directory. See [#14942](https://github.com/ckeditor/ckeditor5/issues/14942).

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder)**: Rename export of the `UploadAdapter` class to `CKFinderUploadAdapter`. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The layout of the UI changed. Customizations based on certain CSS selectors may not work anymore because of a different DOM structure in the UI. [Learn more](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-41.html) about the scope of changes. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder)**: Moved the `browseFiles` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Moved the `browseFiles` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block)**: Moved the `codeBlock` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Bumped the TypeScript version to 5.0. See [#15452](https://github.com/ckeditor/ckeditor5/issues/15452).
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Renamed export of the `View` class to `EditingView`. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Moved the `findOptimalInsertionRange` function to the `Schema` class as a new method. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace)**: The layout of the UI changed. Customizations based on certain CSS selectors may not work anymore because of a different DOM structure in the UI. [Learn more](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-41.html) about the scope of changes. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading)**: Moved the `heading1`, `heading2`, `heading3`, `heading4`, `heading5`, and `heading6` icons to the `core` package and added them to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line)**: Moved the `horizontalLine` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed)**: Moved the `html` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent)**: Moved the `indent` and `outdent` icons to the `core` package and added them to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: Added validation to the URL field to disallow empty URLs by default. See [#12501](https://github.com/ckeditor/ckeditor5/issues/12501).
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: All old list plugins are now prefixed with `Legacy` (including directory names):  `List` -> `LegacyList`, `ListProperties` -> `LegacyListProperties`, `TodoList` -> `LegacyTodoList`, `ListEditing` -> `LegacyListEditing`, `ListUtils` -> `LegacyListUtils`, `ListPropertiesEditing` -> `LegacyListPropertiesEditing`, `TodoListEditing` -> `LegacyTodoListEditing`. See [#14942](https://github.com/ckeditor/ckeditor5/issues/14942).
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The document list plugins are no longer prefixed with `Document` (including directory names): `DocumentList` -> `List`, `DocumentListProperties` -> `ListProperties`, `TodoDocumentList` -> `TodoList`, `DocumentListEditing` -> `ListEditing`, `DocumentListUtils` -> `ListUtils`, `DocumentListPropertiesEditing` -> `ListPropertiesEditing`, `DocumentListPropertiesUtils` -> `ListPropertiesUtils`, `TodoDocumentListEditing` -> `TodoListEditing`. See [#14942](https://github.com/ckeditor/ckeditor5/issues/14942).
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The `ListStyle` plugin was removed since it had been deprecated for a while. Use the `ListProperties` plugin instead. See [#14942](https://github.com/ckeditor/ckeditor5/issues/14942).
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: Moved the `bulletedList`, `numberedList`, and `todoList` icons to the `core` package and added them to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table)**: Moved the `table` icon to the `core` package and added it to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Moved the `colorPalette`, `previousArrow`, and `nextArrow` icons to the `core` package and added them to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `--ck-z-modal` CSS custom property was renamed to `--ck-z-panel`. We recommend updating custom CSS and integrations that use this custom property to avoid presentation issues. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The view collection (`focusables`) required by [`FocusCycler#constructor()`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html#function-constructor) must only contain views implementing the [`FocusableView`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusableView.html) interface. Failing to do so will result in a TypeScript error. If your custom code creates `FocusCycler` instances, make sure that all views passed in `focusables` implement the `focus()` method. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The font size of the `FormHeaderView` component was increased. This change affects the look of the [find and replace](https://ckeditor.com/docs/ckeditor5/latest/features/find-and-replace.html) and [table styling](https://ckeditor.com/docs/ckeditor5/latest/features/tables/tables-styling.html) features as well as custom user interfaces that use this component. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The type of `AriaLiveAnnouncerPoliteness` changed (previously `enum`, now a constant `object`). See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `#next` and `#previous` properties of a [`FocusCycler`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html) will now point to the same view if there is only one focusable view (previously `null`). This change may affect integrations that use this helper to manage advanced focus navigation in dynamic UIs. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo)**: Moved the `undo` and `redo` icons to the `core` package and added them to the `icons` object exported from it. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).
* **[utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils)**: Renamed the `Position` interface to `DomPoint`. See [#15511](https://github.com/ckeditor/ckeditor5/issues/15511).

### Features

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The UI of the feature was migrated to a dialog for a better user experience. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973).
* **[case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change)**: Introduced the case change feature.
* **[find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace)**: The UI of the feature was migrated to a dialog for a better user experience. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973). ([commit](https://github.com/ckeditor/ckeditor5/commit/f8e2b1c902776a848e1ddc208b5db108628f04da))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Integrated the list feature with the new attribute suggestions. Tracked changes in lists are now immediately visible in the editor.
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: Implemented the [`Dialog`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_dialog_dialog-Dialog.html) plugin that allows for displaying dialog windows in the UI of the editor. [Learn more](https://ckeditor.com/docs/ckeditor5/latest/framework/architecture/ui-library.html#dialogs-and-modals) about using dialogs. Closes [#14973](https://github.com/ckeditor/ckeditor5/issues/14973). ([commit](https://github.com/ckeditor/ckeditor5/commit/f8e2b1c902776a848e1ddc208b5db108628f04da))

### Bug fixes

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: `AWSTextAdapter` should be able to handle many data objects returned in one update (chunk).
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: `AWSTextAdapter` should be able to handle data objects that were split between many updates (chunks).
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Replaced some toolbar icons with ones with improved alignment. Closes [#15549](https://github.com/ckeditor/ckeditor5/issues/15549). ([commit](https://github.com/ckeditor/ckeditor5/commit/ee2b91c945224b2db71f809a4e4149ecdfe750b6))
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Fixed the relative URL image editing. ([commit](https://github.com/ckeditor/ckeditor5/commit/84b012edee336907c995acd5772efb2c0a6b51cd))
* **[clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard)**: Drag and drop into the document title element should not throw errors. Closes [#15306](https://github.com/ckeditor/ckeditor5/issues/15306). ([commit](https://github.com/ckeditor/ckeditor5/commit/db3dde69e85609cb9e679b580eabfa3737a7d76f))
* **[comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments)**: Unlinked and resolved comment threads will now be correctly handled when added during the editor initialization.
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Replaced some toolbar icons with ones with improved alignment. Closes [#15549](https://github.com/ckeditor/ckeditor5/issues/15549). ([commit](https://github.com/ckeditor/ckeditor5/commit/ee2b91c945224b2db71f809a4e4149ecdfe750b6))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: The editor should not be stuck in an infinite post-fixing loop while modifying a list structure inside a GHS element. Closes [#15527](https://github.com/ckeditor/ckeditor5/issues/15527), [#15565](https://github.com/ckeditor/ckeditor5/issues/15565). ([commit](https://github.com/ckeditor/ckeditor5/commit/7d600e2c87ec9b1982359343da9188ed7eebd69f))
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: Fixed the editor crash using the `LinkImage` plugin loaded before `Image`, which ends with extending the schema definitions before they registering them. Closes [#15617](https://github.com/ckeditor/ckeditor5/issues/15617). ([commit](https://github.com/ckeditor/ckeditor5/commit/6d9ec4202f077a5dea278351f642aa04182d7c2e))
* **[media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed)**: Replaced some toolbar icons with ones with improved alignment. Closes [#15549](https://github.com/ckeditor/ckeditor5/issues/15549). ([commit](https://github.com/ckeditor/ckeditor5/commit/ee2b91c945224b2db71f809a4e4149ecdfe750b6))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The [`TextareaView`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_textarea_textareaview-TextareaView.html) component should correctly update its size if its value changes while it is invisible. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973). ([commit](https://github.com/ckeditor/ckeditor5/commit/f8e2b1c902776a848e1ddc208b5db108628f04da))
* Made all CKEditor&nbsp;5 packages valid ES Modules. See [#13673](https://github.com/ckeditor/ckeditor5/issues/13673).

### Other changes

* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Image editing should work with the on-premises CKBox. Closes [#5834](https://github.com/ckeditor/ckeditor5/issues/5834). ([commit](https://github.com/ckeditor/ckeditor5/commit/ec2d7059d4e8d038f880715572748c650c96c1c6))
* **[core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core)**: Bumped the TypeScript version to 5.0. Closes [#15452](https://github.com/ckeditor/ckeditor5/issues/15452) . ([commit](https://github.com/ckeditor/ckeditor5/commit/b5c31df8ca7f2032256513532449f424bbc023dd))
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Made the types of the `Schema.addChildCheck` and `Schema.addAttributeCheck` callbacks more specific. See [#15290](https://github.com/ckeditor/ckeditor5/issues/15290). ([commit](https://github.com/ckeditor/ckeditor5/commit/44de0ebeab9e9bbfea8afc004143b6a915d52f49))
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The document list feature was promoted to the main list feature implementation. The `Document` prefix was removed. The old list implementation was prefixed with the `Legacy` keyword. Aliases were introduced (`DocumentList`, `DocumentListProperties`, `TodoDocumentList`) for backward compatibility but those are marked as deprecated and log a warning in the browser console. Closes [#14942](https://github.com/ckeditor/ckeditor5/issues/14942). ([commit](https://github.com/ckeditor/ckeditor5/commit/b9fb73aa42beef5ad6275cd169682336b6b26a79))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The [`FocusCycler#focusables`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html#member-focusables) collection should only contain [`FocusableView`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusableView.html) instances. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973). ([commit](https://github.com/ckeditor/ckeditor5/commit/f8e2b1c902776a848e1ddc208b5db108628f04da))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The [`#next`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html#member-next) and [`#previous`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html#member-previous) properties of a [`FocusCycler`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html) instance should point to the same view if there is only one focusable view registered in the [`focusables`](https://ckeditor.com/docs/ckeditor5/latest/api/module_ui_focuscycler-FocusCycler.html#member-focusables) collection. See [#14973](https://github.com/ckeditor/ckeditor5/issues/14973). ([commit](https://github.com/ckeditor/ckeditor5/commit/f8e2b1c902776a848e1ddc208b5db108628f04da))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/1c70cdf1c90f432dd598f2aef5cc7355885a8873))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

New packages:

* [@ckeditor/ckeditor5-case-change](https://www.npmjs.com/package/@ckeditor/ckeditor5-case-change/v/41.0.0): v41.0.0

Major releases (contain major breaking changes):

* [@ckeditor/ckeditor5-ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list/v/41.0.0): v40.2.0 => v41.0.0

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui/v/41.0.0): v40.2.0 => v41.0.0

Releases containing new features:

* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark/v/41.0.0): v40.2.0 => v41.0.0

Other releases:

* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-paste-from-office-enhanced](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office-enhanced/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget/v/41.0.0): v40.2.0 => v41.0.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count/v/41.0.0): v40.2.0 => v41.0.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration/v/41.0.0): v40.2.0 => v41.0.0
</details>


## [40.2.0](https://github.com/ckeditor/ckeditor5/compare/v40.1.0...v40.2.0) (December 12, 2023)

We are happy to announce the release of CKEditor&nbsp;5 v40.2.0.

### Release highlights

#### AI Assistant: AWS and custom integrations

Enabling many AI model services was one of our priorities for the AI Assistant. We wanted everyone to be able to use a platform that they find the most convenient.

We are happy to inform you that as of this release, you can use the AI Assistant together with the Amazon Bedrock service.

What is more, you can now extend existing adapters to enable more advanced customizations, such as decorating the AI Assistant requests.

Finally, you can even create a custom adapter to connect to your custom model or any model that does not have an official adapter yet.

Visit the [new integration guide](https://ckeditor.com/docs/ckeditor5/latest/features/ai-assistant/ai-assistant-integration.html) to learn more about integrating and customizing the AI Assistant feature.

These improvements come with minor breaking changes in the editor configuration, so visit the breaking changes section and the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-40.html#update-to-ckeditor-5-v4020).

#### Image editing

CKBox’s image editing capabilities, introduced in CKBox v1.6.0, are now accessible straight from the CKEditor image toolbar. CKBox users can resize, crop, or rotate images right within CKEditor.

You can also edit images that are not added to CKBox yet (for example, hotlinked images). CKBox will automatically download the images in the background to allow users to edit them without having to leave CKEditor to manually add the image into CKBox. This dual functionality, combined with server-side processing, ensures ease of use and maintains high image quality and file integrity. It also provides a more efficient and reliable image editing experience within CKEditor.

Refer to the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-40.html#update-to-ckeditor-5-v4020) to learn more about these changes.

#### (Experimental) Paste Markdown

This release introduces the new paste Markdown feature. It will automatically format any raw Markdown source or output copied and pasted directly into the editor – without having to switch to source editing. This feature is in its experimental phase, and its behavior may change in the future. Experience this functionality firsthand by pasting Markdown content into the [demo editor](https://ckeditor.com/docs/ckeditor5/latest/features/pasting/paste-markdown.html). We welcome your feedback and observations for ongoing improvements, so share them in the [GitHub issue](https://github.com/ckeditor/ckeditor5/issues/14003).

#### (Coming soon!) New installation methods

We are excited to announce upcoming improvements to CKEditor&nbsp;5's installation process, set to release next year. Our goal is to address and resolve the accumulated pain points that you experienced over the years. For a detailed overview of our plans and the background behind them, dive into the [comprehensive proposal in the RFC](https://github.com/ckeditor/ckeditor5/issues/15502). Your feedback is crucial in refining and perfecting these improvements, and we eagerly await your input!

#### Other notable improvements

* **Improved insert image button**: The `insertImage` component now supports file managers and automatically detects if you are using CKBox. We have also changed the default icon for upload image from computer to better indicate it is an upload action, not a generic image button.
* **Paste link over text**: The editor automatically converts the selected text to a link when you paste a URL onto it.

### MINOR BREAKING CHANGES [ℹ️](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html#major-and-minor-breaking-changes)

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The configuration for AI Assistant has changed and will require an update. Additionally, a proper adapter (`OpenAIAdapter`, `AWSAdapter`, or a custom adapter) must now be explicitly added to the plugin list. See the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-40.html#update-to-ckeditor-5-v4020) for details.
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: The `ImageInsertUI` plugin internals were cleaned up, as it worked a bit magically with hard-coded dependencies. For example, it automatically enabled the behavior of inserting an image via URL. As of now, it will not enable any external behaviors. See the [update guide](https://ckeditor.com/docs/ckeditor5/latest/updating/guides/update-to-40.html#update-to-ckeditor-5-v4020) for details.
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The `CollapsibleView` was moved from the `@ckeditor/ckeditor5-list` package to `@ckeditor/ckeditor5-ui`. You can import it like this: `import { CollapsibleView } from '@ckeditor/ckeditor5-ui';`

### Features

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Introduced Amazon Bedrock support for AI Assistant. See the [AI Assistant integration guide](https://ckeditor.com/docs/ckeditor5/latest/features/ai-assistant/ai-assistant-integration.html) to learn more.
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Enabled editing of non-CKBox images in the editor. ([commit](https://github.com/ckeditor/ckeditor5/commit/448210c25f04d61e24fb0651d2f0f1ec40214b77))
* **[ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox)**: Integrated the CKBox image editing feature into the editor. ([commit](https://github.com/ckeditor/ckeditor5/commit/11f18ac8d5d60dcdf2bfb56dc89c9067cb936c0a))
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: Introduced the image insert dropdown as a consistent UI to insert images through different available integrations such as image upload, inserting an image with the asset manager, and inserting an image via URL. Closes [#15303](https://github.com/ckeditor/ckeditor5/issues/15303), [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: Links can now be applied by pasting a URL on a selected text. Closes [#5656](https://github.com/ckeditor/ckeditor5/issues/5656). ([commit](https://github.com/ckeditor/ckeditor5/commit/ba66ba1fb7ac1ce0675614d0f7ef516226d8485f))
* **[markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm)**: Added experimental support for pasting Markdown-formatted content. Closes [#2321](https://github.com/ckeditor/ckeditor5/issues/2321). ([commit](https://github.com/ckeditor/ckeditor5/commit/767e681e57c9cc8cbe5ef26076c63724f20dc1f0))
* **[media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed)**: Added support for short Dailymotion URLs (`dai.ly`) in the media embed feature. ([commit](https://github.com/ckeditor/ckeditor5/commit/da8c3ac422bef577b8a5e0766c96104a13524cd1))

  Thanks to [@Kocal](https://github.com/Kocal)!

### Bug fixes

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The fake selection marker was not always removed when the AI Assistant UI was closed.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: A user prompt containing special characters was incorrectly displayed in the prompt field (special characters were incorrectly escaped).
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: The AI Assistant error message should be cleared upon closing the balloon.
* **[engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine)**: Fixed a crash happening in a peculiar scenario involving the reconversion of an element containing a marker. Closes [#15411](https://github.com/ckeditor/ckeditor5/issues/15411). ([commit](https://github.com/ckeditor/ckeditor5/commit/db1da2dd322ba240ef8416238e854a81d7f0bb52))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: `DocumentSelection` should not store the GHS `linkA` attribute if the `linkHref` attribute was removed by the two-step caret movement feature. Closes [#15051](https://github.com/ckeditor/ckeditor5/issues/15051). ([commit](https://github.com/ckeditor/ckeditor5/commit/73c2985923c930a0a7b2503e709370100d8568c1))
* **[html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support)**: The editor should not crash when there is a `<template>` element in the content. Closes [#14933](https://github.com/ckeditor/ckeditor5/issues/14933). ([commit](https://github.com/ckeditor/ckeditor5/commit/3388cfcf2eddefec6b0fca3c259b60353fef298b))
* **[paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office)**: Content from Word documents should be pasted correctly (without HTML styles tag content) on Windows systems. Closes [#15333](https://github.com/ckeditor/ckeditor5/issues/15333), [#9002](https://github.com/ckeditor/ckeditor5/issues/9002). ([commit](https://github.com/ckeditor/ckeditor5/commit/18a88edab9f4c6f78508c766c6abaf7ac80b0497))
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Prevented joining two block format suggestions made on widgets placed next to each other, which was an undesirable behavior. Fixed a related editor crash involving two tables with resized columns.
* **[track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes)**: Fixed incorrect handling of attribute suggestions made on a paragraph-like element when the element had an insertion suggestion inside.

### Other changes

* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Introduced support for the OpenAI `gpt-3.5-turbo-1106` model in AI Assistant.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Secured AI Assistant from incorrect responses that do not begin with the processed HTML.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Introduced the `AITextAdapter` abstract class that can be extended to provide a custom adapter for AI Assistant.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Introduced `OpenAIAdapter` and `AWSAdapter` that can be extended to customize how AI Assistant's requests and responses are handled.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Reorganized the configuration parameters for AI Assistant. See the API documentation and update guide.
* **[ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai)**: Allowed to fully customize request headers by providing an object or a function to the `requestHeaders` configuration parameter. See API documentation and update guide.
* **[image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image)**: The `ImageUploadUI` plugin is loaded by default when the `ImageBlock` or `ImageInline` plugins are loaded. See [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* **[link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link)**: The logic behind the two-step caret movement was extracted to the common code in the two-step caret movement feature. ([commit](https://github.com/ckeditor/ckeditor5/commit/73c2985923c930a0a7b2503e709370100d8568c1))
* **[list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list)**: The `CollapsibleView` class was moved from the `@ckeditor/ckeditor5-list` package to `@ckeditor/ckeditor5-ui`. See [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* **[typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing)**: The logic behind the two-step caret movement was extracted to the common code in the two-step caret movement feature. ([commit](https://github.com/ckeditor/ckeditor5/commit/73c2985923c930a0a7b2503e709370100d8568c1))
* **[typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing)**: Unified the behavior of the `insertText` command for cases using the `DocumentSelection` and `Selection` as applied attributes behaved differently in those cases. ([commit](https://github.com/ckeditor/ckeditor5/commit/73c2985923c930a0a7b2503e709370100d8568c1))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `CollapsibleView` class was moved from the `@ckeditor/ckeditor5-list` package to `@ckeditor/ckeditor5-ui`. See [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* **[ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui)**: The `SplitButtonView` constructor and `createDropdown()` helper accept an instance of a `ButtonView` as an action view customization. See [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* **[upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload)**: The `FileDialogButtonView` class is now an instance of the `ButtonView`, not just a wrapper on it. See [#15149](https://github.com/ckeditor/ckeditor5/issues/15149). ([commit](https://github.com/ckeditor/ckeditor5/commit/0647ba65cd09575937a9ba8e60bc7b6837f81b40))
* The `undo` and `redo` toolbar components described in the `@ckeditor/ckeditor5-essentials/src/ckeditor5-metadata.json` file are now defined in the package that registers these buttons (`@ckeditor/ckeditor5-undo`). Closes [#15414](https://github.com/ckeditor/ckeditor5/issues/15414). ([commit](https://github.com/ckeditor/ckeditor5/commit/0b9552b4d4f14063896e2e588195cfa368734690))
* Updated translations. ([commit](https://github.com/ckeditor/ckeditor5/commit/e0f61406b8294f7d189c9c59b33d71413201aed0), [commit](https://github.com/ckeditor/ckeditor5/commit/c8379c676d691ad72bf8b8c8c9d5544ddf09f2f4), [commit](https://github.com/ckeditor/ckeditor5/commit/fb8eb673ec5c79fc26f0e8915044bcc89b908000))

### Released packages

Check out the [Versioning policy](https://ckeditor.com/docs/ckeditor5/latest/framework/guides/support/versioning-policy.html) guide for more information.

<details>
<summary>Released packages (summary)</summary>

Major releases (contain major breaking changes):

* [@ckeditor/ckeditor5-ai](https://www.npmjs.com/package/@ckeditor/ckeditor5-ai/v/40.2.0): v40.1.0 => v40.2.0

Minor releases (contain minor breaking changes):

* [@ckeditor/ckeditor5-list](https://www.npmjs.com/package/@ckeditor/ckeditor5-list/v/40.2.0): v40.1.0 => v40.2.0

Releases containing new features:

* [@ckeditor/ckeditor5-alignment](https://www.npmjs.com/package/@ckeditor/ckeditor5-alignment/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-autoformat](https://www.npmjs.com/package/@ckeditor/ckeditor5-autoformat/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-autosave](https://www.npmjs.com/package/@ckeditor/ckeditor5-autosave/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-basic-styles](https://www.npmjs.com/package/@ckeditor/ckeditor5-basic-styles/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-block-quote](https://www.npmjs.com/package/@ckeditor/ckeditor5-block-quote/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-ckbox](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckbox/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-ckfinder/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-clipboard](https://www.npmjs.com/package/@ckeditor/ckeditor5-clipboard/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-cloud-services](https://www.npmjs.com/package/@ckeditor/ckeditor5-cloud-services/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-code-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-code-block/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-core/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-find-and-replace](https://www.npmjs.com/package/@ckeditor/ckeditor5-find-and-replace/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-font](https://www.npmjs.com/package/@ckeditor/ckeditor5-font/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-heading](https://www.npmjs.com/package/@ckeditor/ckeditor5-heading/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-highlight](https://www.npmjs.com/package/@ckeditor/ckeditor5-highlight/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-horizontal-line](https://www.npmjs.com/package/@ckeditor/ckeditor5-horizontal-line/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-html-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-embed/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-html-support](https://www.npmjs.com/package/@ckeditor/ckeditor5-html-support/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-image/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-indent](https://www.npmjs.com/package/@ckeditor/ckeditor5-indent/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-language](https://www.npmjs.com/package/@ckeditor/ckeditor5-language/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-link](https://www.npmjs.com/package/@ckeditor/ckeditor5-link/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-markdown-gfm](https://www.npmjs.com/package/@ckeditor/ckeditor5-markdown-gfm/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-media-embed](https://www.npmjs.com/package/@ckeditor/ckeditor5-media-embed/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-mention](https://www.npmjs.com/package/@ckeditor/ckeditor5-mention/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-minimap](https://www.npmjs.com/package/@ckeditor/ckeditor5-minimap/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-page-break](https://www.npmjs.com/package/@ckeditor/ckeditor5-page-break/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-paste-from-office](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-remove-format](https://www.npmjs.com/package/@ckeditor/ckeditor5-remove-format/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-restricted-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-restricted-editing/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-select-all](https://www.npmjs.com/package/@ckeditor/ckeditor5-select-all/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-show-blocks](https://www.npmjs.com/package/@ckeditor/ckeditor5-show-blocks/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-source-editing](https://www.npmjs.com/package/@ckeditor/ckeditor5-source-editing/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-special-characters](https://www.npmjs.com/package/@ckeditor/ckeditor5-special-characters/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-style](https://www.npmjs.com/package/@ckeditor/ckeditor5-style/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-table](https://www.npmjs.com/package/@ckeditor/ckeditor5-table/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-theme-lark](https://www.npmjs.com/package/@ckeditor/ckeditor5-theme-lark/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-typing](https://www.npmjs.com/package/@ckeditor/ckeditor5-typing/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-ui](https://www.npmjs.com/package/@ckeditor/ckeditor5-ui/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-undo](https://www.npmjs.com/package/@ckeditor/ckeditor5-undo/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-upload](https://www.npmjs.com/package/@ckeditor/ckeditor5-upload/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-utils](https://www.npmjs.com/package/@ckeditor/ckeditor5-utils/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-word-count](https://www.npmjs.com/package/@ckeditor/ckeditor5-word-count/v/40.2.0): v40.1.0 => v40.2.0

Other releases:

* [@ckeditor/ckeditor5-adapter-ckfinder](https://www.npmjs.com/package/@ckeditor/ckeditor5-adapter-ckfinder/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-balloon-block](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-balloon-block/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-classic/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-decoupled-document](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-decoupled-document/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-inline/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-build-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-build-multi-root/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-collaboration-core](https://www.npmjs.com/package/@ckeditor/ckeditor5-collaboration-core/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-comments](https://www.npmjs.com/package/@ckeditor/ckeditor5-comments/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-document-outline](https://www.npmjs.com/package/@ckeditor/ckeditor5-document-outline/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-easy-image](https://www.npmjs.com/package/@ckeditor/ckeditor5-easy-image/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-editor-balloon](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-editor-classic](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-editor-decoupled](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-editor-inline](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-editor-multi-root](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-multi-root/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-engine](https://www.npmjs.com/package/@ckeditor/ckeditor5-engine/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-enter](https://www.npmjs.com/package/@ckeditor/ckeditor5-enter/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-essentials](https://www.npmjs.com/package/@ckeditor/ckeditor5-essentials/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-export-pdf](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-pdf/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-export-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-export-word/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-format-painter](https://www.npmjs.com/package/@ckeditor/ckeditor5-format-painter/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-import-word](https://www.npmjs.com/package/@ckeditor/ckeditor5-import-word/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-operations-compressor](https://www.npmjs.com/package/@ckeditor/ckeditor5-operations-compressor/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-pagination](https://www.npmjs.com/package/@ckeditor/ckeditor5-pagination/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-paragraph](https://www.npmjs.com/package/@ckeditor/ckeditor5-paragraph/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-paste-from-office-enhanced](https://www.npmjs.com/package/@ckeditor/ckeditor5-paste-from-office-enhanced/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-real-time-collaboration](https://www.npmjs.com/package/@ckeditor/ckeditor5-real-time-collaboration/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-revision-history](https://www.npmjs.com/package/@ckeditor/ckeditor5-revision-history/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-slash-command](https://www.npmjs.com/package/@ckeditor/ckeditor5-slash-command/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-template](https://www.npmjs.com/package/@ckeditor/ckeditor5-template/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-track-changes](https://www.npmjs.com/package/@ckeditor/ckeditor5-track-changes/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-watchdog](https://www.npmjs.com/package/@ckeditor/ckeditor5-watchdog/v/40.2.0): v40.1.0 => v40.2.0
* [@ckeditor/ckeditor5-widget](https://www.npmjs.com/package/@ckeditor/ckeditor5-widget/v/40.2.0): v40.1.0 => v40.2.0
* [ckeditor5-collaboration](https://www.npmjs.com/package/ckeditor5-collaboration/v/40.2.0): v40.1.0 => v40.2.0
</details>

---

To see all releases, visit the [release page](https://github.com/ckeditor/ckeditor5/releases).
