"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_core-js_modules_es_string_search_js-node_modules_datatables_net-buttons_-56cbc3"],{

/***/ "./node_modules/core-js/internals/same-value.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/internals/same-value.js ***!
  \******************************************************/
/***/ ((module) => {


// `SameValue` abstract operation
// https://tc39.es/ecma262/#sec-samevalue
// eslint-disable-next-line es/no-object-is -- safe
module.exports = Object.is || function is(x, y) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return x === y ? x !== 0 || 1 / x === 1 / y : x !== x && y !== y;
};


/***/ }),

/***/ "./node_modules/core-js/modules/es.string.search.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/modules/es.string.search.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(/*! ../internals/function-call */ "./node_modules/core-js/internals/function-call.js");
var fixRegExpWellKnownSymbolLogic = __webpack_require__(/*! ../internals/fix-regexp-well-known-symbol-logic */ "./node_modules/core-js/internals/fix-regexp-well-known-symbol-logic.js");
var anObject = __webpack_require__(/*! ../internals/an-object */ "./node_modules/core-js/internals/an-object.js");
var isNullOrUndefined = __webpack_require__(/*! ../internals/is-null-or-undefined */ "./node_modules/core-js/internals/is-null-or-undefined.js");
var requireObjectCoercible = __webpack_require__(/*! ../internals/require-object-coercible */ "./node_modules/core-js/internals/require-object-coercible.js");
var sameValue = __webpack_require__(/*! ../internals/same-value */ "./node_modules/core-js/internals/same-value.js");
var toString = __webpack_require__(/*! ../internals/to-string */ "./node_modules/core-js/internals/to-string.js");
var getMethod = __webpack_require__(/*! ../internals/get-method */ "./node_modules/core-js/internals/get-method.js");
var regExpExec = __webpack_require__(/*! ../internals/regexp-exec-abstract */ "./node_modules/core-js/internals/regexp-exec-abstract.js");

// @@search logic
fixRegExpWellKnownSymbolLogic('search', function (SEARCH, nativeSearch, maybeCallNative) {
  return [
    // `String.prototype.search` method
    // https://tc39.es/ecma262/#sec-string.prototype.search
    function search(regexp) {
      var O = requireObjectCoercible(this);
      var searcher = isNullOrUndefined(regexp) ? undefined : getMethod(regexp, SEARCH);
      return searcher ? call(searcher, regexp, O) : new RegExp(regexp)[SEARCH](toString(O));
    },
    // `RegExp.prototype[@@search]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@search
    function (string) {
      var rx = anObject(this);
      var S = toString(string);
      var res = maybeCallNative(nativeSearch, rx, S);

      if (res.done) return res.value;

      var previousLastIndex = rx.lastIndex;
      if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
      var result = regExpExec(rx, S);
      if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
      return result === null ? -1 : result.index;
    }
  ];
});


/***/ }),

/***/ "./node_modules/datatables.net-buttons/js/buttons.html5.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.html5.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/* harmony import */ var datatables_net_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs");
/*!
 * HTML5 export buttons for Buttons and DataTables.
 * © SpryMedia Ltd - datatables.net/license
 *
 * FileSaver.js (1.3.3) - MIT license
 * Copyright © 2016 Eli Grey - http://eligrey.com
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


// Allow the constructor to pass in JSZip and PDFMake from external requires.
// Otherwise, use globally defined variables, if they are available.
var useJszip;
var usePdfmake;

function _jsZip() {
	return useJszip || window.JSZip;
}
function _pdfMake() {
	return usePdfmake || window.pdfMake;
}

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Buttons.pdfMake = function (_) {
	if (!_) {
		return _pdfMake();
	}
	usePdfmake = _;
};

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Buttons.jszip = function (_) {
	if (!_) {
		return _jsZip();
	}
	useJszip = _;
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * FileSaver.js dependency
 */

/*jslint bitwise: true, indent: 4, laxbreak: true, laxcomma: true, smarttabs: true, plusplus: true */

var _saveAs = (function (view) {
	'use strict';
	// IE <10 is explicitly unsupported
	if (
		typeof view === 'undefined' ||
		(typeof navigator !== 'undefined' &&
			/MSIE [1-9]\./.test(navigator.userAgent))
	) {
		return;
	}
	var doc = view.document,
		// only get URL when necessary in case Blob.js hasn't overridden it yet
		get_URL = function () {
			return view.URL || view.webkitURL || view;
		},
		save_link = doc.createElementNS('http://www.w3.org/1999/xhtml', 'a'),
		can_use_save_link = 'download' in save_link,
		click = function (node) {
			var event = new MouseEvent('click');
			node.dispatchEvent(event);
		},
		is_safari = /constructor/i.test(view.HTMLElement) || view.safari,
		is_chrome_ios = /CriOS\/[\d]+/.test(navigator.userAgent),
		throw_outside = function (ex) {
			(view.setImmediate || view.setTimeout)(function () {
				throw ex;
			}, 0);
		},
		force_saveable_type = 'application/octet-stream',
		// the Blob API is fundamentally broken as there is no "downloadfinished" event to subscribe to
		arbitrary_revoke_timeout = 1000 * 40, // in ms
		revoke = function (file) {
			var revoker = function () {
				if (typeof file === 'string') {
					// file is an object URL
					get_URL().revokeObjectURL(file);
				}
				else {
					// file is a File
					file.remove();
				}
			};
			setTimeout(revoker, arbitrary_revoke_timeout);
		},
		dispatch = function (filesaver, event_types, event) {
			event_types = [].concat(event_types);
			var i = event_types.length;
			while (i--) {
				var listener = filesaver['on' + event_types[i]];
				if (typeof listener === 'function') {
					try {
						listener.call(filesaver, event || filesaver);
					} catch (ex) {
						throw_outside(ex);
					}
				}
			}
		},
		auto_bom = function (blob) {
			// prepend BOM for UTF-8 XML and text/* types (including HTML)
			// note: your browser will automatically convert UTF-16 U+FEFF to EF BB BF
			if (
				/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(
					blob.type
				)
			) {
				return new Blob([String.fromCharCode(0xfeff), blob], {
					type: blob.type
				});
			}
			return blob;
		},
		FileSaver = function (blob, name, no_auto_bom) {
			if (!no_auto_bom) {
				blob = auto_bom(blob);
			}
			// First try a.download, then web filesystem, then object URLs
			var filesaver = this,
				type = blob.type,
				force = type === force_saveable_type,
				object_url,
				dispatch_all = function () {
					dispatch(
						filesaver,
						'writestart progress write writeend'.split(' ')
					);
				},
				// on any filesys errors revert to saving with object URLs
				fs_error = function () {
					if (
						(is_chrome_ios || (force && is_safari)) &&
						view.FileReader
					) {
						// Safari doesn't allow downloading of blob urls
						var reader = new FileReader();
						reader.onloadend = function () {
							var url = is_chrome_ios
								? reader.result
								: reader.result.replace(
										/^data:[^;]*;/,
										'data:attachment/file;'
								);
							var popup = view.open(url, '_blank');
							if (!popup) view.location.href = url;
							url = undefined; // release reference before dispatching
							filesaver.readyState = filesaver.DONE;
							dispatch_all();
						};
						reader.readAsDataURL(blob);
						filesaver.readyState = filesaver.INIT;
						return;
					}
					// don't create more object URLs than needed
					if (!object_url) {
						object_url = get_URL().createObjectURL(blob);
					}
					if (force) {
						view.location.href = object_url;
					}
					else {
						var opened = view.open(object_url, '_blank');
						if (!opened) {
							// Apple does not allow window.open, see https://developer.apple.com/library/safari/documentation/Tools/Conceptual/SafariExtensionGuide/WorkingwithWindowsandTabs/WorkingwithWindowsandTabs.html
							view.location.href = object_url;
						}
					}
					filesaver.readyState = filesaver.DONE;
					dispatch_all();
					revoke(object_url);
				};
			filesaver.readyState = filesaver.INIT;

			if (can_use_save_link) {
				object_url = get_URL().createObjectURL(blob);
				setTimeout(function () {
					save_link.href = object_url;
					save_link.download = name;
					click(save_link);
					dispatch_all();
					revoke(object_url);
					filesaver.readyState = filesaver.DONE;
				});
				return;
			}

			fs_error();
		},
		FS_proto = FileSaver.prototype,
		saveAs = function (blob, name, no_auto_bom) {
			return new FileSaver(
				blob,
				name || blob.name || 'download',
				no_auto_bom
			);
		};
	// IE 10+ (native saveAs)
	if (typeof navigator !== 'undefined' && navigator.msSaveOrOpenBlob) {
		return function (blob, name, no_auto_bom) {
			name = name || blob.name || 'download';

			if (!no_auto_bom) {
				blob = auto_bom(blob);
			}
			return navigator.msSaveOrOpenBlob(blob, name);
		};
	}

	FS_proto.abort = function () {};
	FS_proto.readyState = FS_proto.INIT = 0;
	FS_proto.WRITING = 1;
	FS_proto.DONE = 2;

	FS_proto.error =
		FS_proto.onwritestart =
		FS_proto.onprogress =
		FS_proto.onwrite =
		FS_proto.onabort =
		FS_proto.onerror =
		FS_proto.onwriteend =
			null;

	return saveAs;
})(
	(typeof self !== 'undefined' && self) ||
		(typeof window !== 'undefined' && window) ||
		undefined.content
);

// Expose file saver on the DataTables API. Can't attach to `DataTables.Buttons`
// since this file can be loaded before Button's core!
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].fileSave = _saveAs;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Local (private) functions
 */

/**
 * Get the sheet name for Excel exports.
 *
 * @param {object}	config Button configuration
 */
var _sheetname = function (config) {
	var sheetName = 'Sheet1';

	if (config.sheetName) {
		sheetName = config.sheetName.replace(/[\[\]\*\/\\\?\:]/g, '');
	}

	return sheetName;
};

/**
 * Get the newline character(s)
 *
 * @param {object}	config Button configuration
 * @return {string}				Newline character
 */
var _newLine = function (config) {
	return config.newline
		? config.newline
		: navigator.userAgent.match(/Windows/)
		? '\r\n'
		: '\n';
};

/**
 * Combine the data from the `buttons.exportData` method into a string that
 * will be used in the export file.
 *
 * @param	{DataTable.Api} dt		 DataTables API instance
 * @param	{object}				config Button configuration
 * @return {object}							 The data to export
 */
var _exportData = function (dt, config) {
	var newLine = _newLine(config);
	var data = dt.buttons.exportData(config.exportOptions);
	var boundary = config.fieldBoundary;
	var separator = config.fieldSeparator;
	var reBoundary = new RegExp(boundary, 'g');
	var escapeChar = config.escapeChar !== undefined ? config.escapeChar : '\\';
	var join = function (a) {
		var s = '';

		// If there is a field boundary, then we might need to escape it in
		// the source data
		for (var i = 0, ien = a.length; i < ien; i++) {
			if (i > 0) {
				s += separator;
			}

			s += boundary
				? boundary +
				('' + a[i]).replace(reBoundary, escapeChar + boundary) +
				boundary
				: a[i];
		}

		return s;
	};

	var header = '';
	var footer = '';
	var body = [];

	if (config.header) {
		header =
			data.headerStructure
				.map(function (row) {
					return join(
						row.map(function (cell) {
							return cell ? cell.title : '';
						})
					);
				})
				.join(newLine) + newLine;
	}

	if (config.footer && data.footer) {
		footer =
			data.footerStructure
				.map(function (row) {
					return join(
						row.map(function (cell) {
							return cell ? cell.title : '';
						})
					);
				})
				.join(newLine) + newLine;
	}

	for (var i = 0, ien = data.body.length; i < ien; i++) {
		body.push(join(data.body[i]));
	}

	return {
		str: header + body.join(newLine) + newLine + footer,
		rows: body.length
	};
};

/**
 * Older versions of Safari (prior to tech preview 18) don't support the
 * download option required.
 *
 * @return {Boolean} `true` if old Safari
 */
var _isDuffSafari = function () {
	var safari =
		navigator.userAgent.indexOf('Safari') !== -1 &&
		navigator.userAgent.indexOf('Chrome') === -1 &&
		navigator.userAgent.indexOf('Opera') === -1;

	if (!safari) {
		return false;
	}

	var version = navigator.userAgent.match(/AppleWebKit\/(\d+\.\d+)/);
	if (version && version.length > 1 && version[1] * 1 < 603.1) {
		return true;
	}

	return false;
};

/**
 * Convert from numeric position to letter for column names in Excel
 * @param  {int} n Column number
 * @return {string} Column letter(s) name
 */
function createCellPos(n) {
	var ordA = 'A'.charCodeAt(0);
	var ordZ = 'Z'.charCodeAt(0);
	var len = ordZ - ordA + 1;
	var s = '';

	while (n >= 0) {
		s = String.fromCharCode((n % len) + ordA) + s;
		n = Math.floor(n / len) - 1;
	}

	return s;
}

try {
	var _serialiser = new XMLSerializer();
	var _ieExcel;
} catch (t) {
	// noop
}

/**
 * Recursively add XML files from an object's structure to a ZIP file. This
 * allows the XSLX file to be easily defined with an object's structure matching
 * the files structure.
 *
 * @param {JSZip} zip ZIP package
 * @param {object} obj Object to add (recursive)
 */
function _addToZip(zip, obj) {
	if (_ieExcel === undefined) {
		// Detect if we are dealing with IE's _awful_ serialiser by seeing if it
		// drop attributes
		_ieExcel =
			_serialiser
				.serializeToString(
					new window.DOMParser().parseFromString(
						excelStrings['xl/worksheets/sheet1.xml'],
						'text/xml'
					)
				)
				.indexOf('xmlns:r') === -1;
	}

	$.each(obj, function (name, val) {
		if ($.isPlainObject(val)) {
			var newDir = zip.folder(name);
			_addToZip(newDir, val);
		}
		else {
			if (_ieExcel) {
				// IE's XML serialiser will drop some name space attributes from
				// from the root node, so we need to save them. Do this by
				// replacing the namespace nodes with a regular attribute that
				// we convert back when serialised. Edge does not have this
				// issue
				var worksheet = val.childNodes[0];
				var i, ien;
				var attrs = [];

				for (i = worksheet.attributes.length - 1; i >= 0; i--) {
					var attrName = worksheet.attributes[i].nodeName;
					var attrValue = worksheet.attributes[i].nodeValue;

					if (attrName.indexOf(':') !== -1) {
						attrs.push({ name: attrName, value: attrValue });

						worksheet.removeAttribute(attrName);
					}
				}

				for (i = 0, ien = attrs.length; i < ien; i++) {
					var attr = val.createAttribute(
						attrs[i].name.replace(':', '_dt_b_namespace_token_')
					);
					attr.value = attrs[i].value;
					worksheet.setAttributeNode(attr);
				}
			}

			var str = _serialiser.serializeToString(val);

			// Fix IE's XML
			if (_ieExcel) {
				// IE doesn't include the XML declaration
				if (str.indexOf('<?xml') === -1) {
					str =
						'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
						str;
				}

				// Return namespace attributes to being as such
				str = str.replace(/_dt_b_namespace_token_/g, ':');

				// Remove testing name space that IE puts into the space preserve attr
				str = str.replace(/xmlns:NS[\d]+="" NS[\d]+:/g, '');
			}

			// Safari, IE and Edge will put empty name space attributes onto
			// various elements making them useless. This strips them out
			str = str.replace(/<([^<>]*?) xmlns=""([^<>]*?)>/g, '<$1 $2>');

			zip.file(name, str);
		}
	});
}

/**
 * Create an XML node and add any children, attributes, etc without needing to
 * be verbose in the DOM.
 *
 * @param  {object} doc      XML document
 * @param  {string} nodeName Node name
 * @param  {object} opts     Options - can be `attr` (attributes), `children`
 *   (child nodes) and `text` (text content)
 * @return {node}            Created node
 */
function _createNode(doc, nodeName, opts) {
	var tempNode = doc.createElement(nodeName);

	if (opts) {
		if (opts.attr) {
			$(tempNode).attr(opts.attr);
		}

		if (opts.children) {
			$.each(opts.children, function (key, value) {
				tempNode.appendChild(value);
			});
		}

		if (opts.text !== null && opts.text !== undefined) {
			tempNode.appendChild(doc.createTextNode(opts.text));
		}
	}

	return tempNode;
}

/**
 * Get the width for an Excel column based on the contents of that column
 * @param  {object} data Data for export
 * @param  {int}    col  Column index
 * @return {int}         Column width
 */
function _excelColWidth(data, col) {
	var max = data.header[col].length;
	var len, lineSplit, str;

	if (data.footer && data.footer[col] && data.footer[col].length > max) {
		max = data.footer[col].length;
	}

	for (var i = 0, ien = data.body.length; i < ien; i++) {
		var point = data.body[i][col];
		str = point !== null && point !== undefined ? point.toString() : '';

		// If there is a newline character, workout the width of the column
		// based on the longest line in the string
		if (str.indexOf('\n') !== -1) {
			lineSplit = str.split('\n');
			lineSplit.sort(function (a, b) {
				return b.length - a.length;
			});

			len = lineSplit[0].length;
		}
		else {
			len = str.length;
		}

		if (len > max) {
			max = len;
		}

		// Max width rather than having potentially massive column widths
		if (max > 40) {
			return 54; // 40 * 1.35
		}
	}

	max *= 1.35;

	// And a min width
	return max > 6 ? max : 6;
}

// Excel - Pre-defined strings to build a basic XLSX file
var excelStrings = {
	'_rels/.rels':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' +
		'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>' +
		'</Relationships>',

	'xl/_rels/workbook.xml.rels':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' +
		'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>' +
		'<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>' +
		'</Relationships>',

	'[Content_Types].xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">' +
		'<Default Extension="xml" ContentType="application/xml" />' +
		'<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" />' +
		'<Default Extension="jpeg" ContentType="image/jpeg" />' +
		'<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" />' +
		'<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />' +
		'<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" />' +
		'</Types>',

	'xl/workbook.xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">' +
		'<fileVersion appName="xl" lastEdited="5" lowestEdited="5" rupBuild="24816"/>' +
		'<workbookPr showInkAnnotation="0" autoCompressPictures="0"/>' +
		'<bookViews>' +
		'<workbookView xWindow="0" yWindow="0" windowWidth="25600" windowHeight="19020" tabRatio="500"/>' +
		'</bookViews>' +
		'<sheets>' +
		'<sheet name="Sheet1" sheetId="1" r:id="rId1"/>' +
		'</sheets>' +
		'<definedNames/>' +
		'</workbook>',

	'xl/worksheets/sheet1.xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' +
		'<sheetData/>' +
		'<mergeCells count="0"/>' +
		'</worksheet>',

	'xl/styles.xml':
		'<?xml version="1.0" encoding="UTF-8"?>' +
		'<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' +
		'<numFmts count="6">' +
		'<numFmt numFmtId="164" formatCode="[$$-409]#,##0.00;-[$$-409]#,##0.00"/>' +
		'<numFmt numFmtId="165" formatCode="&quot;£&quot;#,##0.00"/>' +
		'<numFmt numFmtId="166" formatCode="[$€-2] #,##0.00"/>' +
		'<numFmt numFmtId="167" formatCode="0.0%"/>' +
		'<numFmt numFmtId="168" formatCode="#,##0;(#,##0)"/>' +
		'<numFmt numFmtId="169" formatCode="#,##0.00;(#,##0.00)"/>' +
		'</numFmts>' +
		'<fonts count="5" x14ac:knownFonts="1">' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<color rgb="FFFFFFFF" />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<b />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<i />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<u />' +
		'</font>' +
		'</fonts>' +
		'<fills count="6">' +
		'<fill>' +
		'<patternFill patternType="none" />' +
		'</fill>' +
		'<fill>' + // Excel appears to use this as a dotted background regardless of values but
		'<patternFill patternType="none" />' + // to be valid to the schema, use a patternFill
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="FFD9D9D9" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="FFD99795" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="ffc6efce" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="ffc6cfef" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'</fills>' +
		'<borders count="2">' +
		'<border>' +
		'<left />' +
		'<right />' +
		'<top />' +
		'<bottom />' +
		'<diagonal />' +
		'</border>' +
		'<border diagonalUp="false" diagonalDown="false">' +
		'<left style="thin">' +
		'<color auto="1" />' +
		'</left>' +
		'<right style="thin">' +
		'<color auto="1" />' +
		'</right>' +
		'<top style="thin">' +
		'<color auto="1" />' +
		'</top>' +
		'<bottom style="thin">' +
		'<color auto="1" />' +
		'</bottom>' +
		'<diagonal />' +
		'</border>' +
		'</borders>' +
		'<cellStyleXfs count="1">' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" />' +
		'</cellStyleXfs>' +
		'<cellXfs count="68">' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="left"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="center"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="right"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="fill"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment textRotation="90"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment wrapText="1"/>' +
		'</xf>' +
		'<xf numFmtId="9"   fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="164" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="165" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="166" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="167" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="168" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="169" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="3" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="4" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="1" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="2" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="14" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'</cellXfs>' +
		'<cellStyles count="1">' +
		'<cellStyle name="Normal" xfId="0" builtinId="0" />' +
		'</cellStyles>' +
		'<dxfs count="0" />' +
		'<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4" />' +
		'</styleSheet>'
};
// Note we could use 3 `for` loops for the styles, but when gzipped there is
// virtually no difference in size, since the above can be easily compressed

// Pattern matching for special number formats. Perhaps this should be exposed
// via an API in future?
// Ref: section 3.8.30 - built in formatters in open spreadsheet
//   https://www.ecma-international.org/news/TC45_current_work/Office%20Open%20XML%20Part%204%20-%20Markup%20Language%20Reference.pdf
var _excelSpecials = [
	{
		match: /^\-?\d+\.\d%$/,
		style: 60,
		fmt: function (d) {
			return d / 100;
		}
	}, // Percent with d.p.
	{
		match: /^\-?\d+\.?\d*%$/,
		style: 56,
		fmt: function (d) {
			return d / 100;
		}
	}, // Percent
	{ match: /^\-?\$[\d,]+.?\d*$/, style: 57 }, // Dollars
	{ match: /^\-?£[\d,]+.?\d*$/, style: 58 }, // Pounds
	{ match: /^\-?€[\d,]+.?\d*$/, style: 59 }, // Euros
	{ match: /^\-?\d+$/, style: 65 }, // Numbers without thousand separators
	{ match: /^\-?\d+\.\d{2}$/, style: 66 }, // Numbers 2 d.p. without thousands separators
	{
		match: /^\([\d,]+\)$/,
		style: 61,
		fmt: function (d) {
			return -1 * d.replace(/[\(\)]/g, '');
		}
	}, // Negative numbers indicated by brackets
	{
		match: /^\([\d,]+\.\d{2}\)$/,
		style: 62,
		fmt: function (d) {
			return -1 * d.replace(/[\(\)]/g, '');
		}
	}, // Negative numbers indicated by brackets - 2d.p.
	{ match: /^\-?[\d,]+$/, style: 63 }, // Numbers with thousand separators
	{ match: /^\-?[\d,]+\.\d{2}$/, style: 64 },
	{
		match: /^[\d]{4}\-[01][\d]\-[0123][\d]$/,
		style: 67,
		fmt: function (d) {
			return Math.round(25569 + Date.parse(d) / (86400 * 1000));
		}
	} //Date yyyy-mm-dd
];

var _excelMergeCells = function (rels, row, column, rowspan, colspan) {
	var mergeCells = $('mergeCells', rels);

	mergeCells[0].appendChild(
		_createNode(rels, 'mergeCell', {
			attr: {
				ref:
					createCellPos(column) +
					row +
					':' +
					createCellPos(column + colspan - 1) +
					(row + rowspan - 1)
			}
		})
	);

	mergeCells.attr('count', parseFloat(mergeCells.attr('count')) + 1);
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Buttons
 */

//
// Copy to clipboard
//
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.copyHtml5 = {
	className: 'buttons-copy buttons-html5',

	text: function (dt) {
		return dt.i18n('buttons.copy', 'Copy');
	},

	action: function (e, dt, button, config, cb) {
		var exportData = _exportData(dt, config);
		var info = dt.buttons.exportInfo(config);
		var newline = _newLine(config);
		var output = exportData.str;
		var hiddenDiv = $('<div/>').css({
			height: 1,
			width: 1,
			overflow: 'hidden',
			position: 'fixed',
			top: 0,
			left: 0
		});

		if (info.title) {
			output = info.title + newline + newline + output;
		}

		if (info.messageTop) {
			output = info.messageTop + newline + newline + output;
		}

		if (info.messageBottom) {
			output = output + newline + newline + info.messageBottom;
		}

		if (config.customize) {
			output = config.customize(output, config, dt);
		}

		var textarea = $('<textarea readonly/>')
			.val(output)
			.appendTo(hiddenDiv);

		// For browsers that support the copy execCommand, try to use it
		if (document.queryCommandSupported('copy')) {
			hiddenDiv.appendTo(dt.table().container());
			textarea[0].focus();
			textarea[0].select();

			try {
				var successful = document.execCommand('copy');
				hiddenDiv.remove();

				if (successful) {
					dt.buttons.info(
						dt.i18n('buttons.copyTitle', 'Copy to clipboard'),
						dt.i18n(
							'buttons.copySuccess',
							{
								1: 'Copied one row to clipboard',
								_: 'Copied %d rows to clipboard'
							},
							exportData.rows
						),
						2000
					);

					cb();
					return;
				}
			} catch (t) {
				// noop
			}
		}

		// Otherwise we show the text box and instruct the user to use it
		var message = $(
			'<span>' +
				dt.i18n(
					'buttons.copyKeys',
					'Press <i>ctrl</i> or <i>\u2318</i> + <i>C</i> to copy the table data<br>to your system clipboard.<br><br>' +
						'To cancel, click this message or press escape.'
				) +
				'</span>'
		).append(hiddenDiv);

		dt.buttons.info(
			dt.i18n('buttons.copyTitle', 'Copy to clipboard'),
			message,
			0
		);

		// Select the text so when the user activates their system clipboard
		// it will copy that text
		textarea[0].focus();
		textarea[0].select();

		// Event to hide the message when the user is done
		var container = $(message).closest('.dt-button-info');
		var close = function () {
			container.off('click.buttons-copy');
			$(document).off('.buttons-copy');
			dt.buttons.info(false);
		};

		container.on('click.buttons-copy', close);
		$(document)
			.on('keydown.buttons-copy', function (e) {
				if (e.keyCode === 27) {
					// esc
					close();
					cb();
				}
			})
			.on('copy.buttons-copy cut.buttons-copy', function () {
				close();
				cb();
			});
	},

	async: 100,

	exportOptions: {},

	fieldSeparator: '\t',

	fieldBoundary: '',

	header: true,

	footer: true,

	title: '*',

	messageTop: '*',

	messageBottom: '*'
};

//
// CSV export
//
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.csvHtml5 = {
	bom: false,

	className: 'buttons-csv buttons-html5',

	available: function () {
		return window.FileReader !== undefined && window.Blob;
	},

	text: function (dt) {
		return dt.i18n('buttons.csv', 'CSV');
	},

	action: function (e, dt, button, config, cb) {
		// Set the text
		var output = _exportData(dt, config).str;
		var info = dt.buttons.exportInfo(config);
		var charset = config.charset;

		if (config.customize) {
			output = config.customize(output, config, dt);
		}

		if (charset !== false) {
			if (!charset) {
				charset = document.characterSet || document.charset;
			}

			if (charset) {
				charset = ';charset=' + charset;
			}
		}
		else {
			charset = '';
		}

		if (config.bom) {
			output = String.fromCharCode(0xfeff) + output;
		}

		_saveAs(
			new Blob([output], { type: 'text/csv' + charset }),
			info.filename,
			true
		);

		cb();
	},

	async: 100,

	filename: '*',

	extension: '.csv',

	exportOptions: {},

	fieldSeparator: ',',

	fieldBoundary: '"',

	escapeChar: '"',

	charset: null,

	header: true,

	footer: true
};

//
// Excel (xlsx) export
//
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.excelHtml5 = {
	className: 'buttons-excel buttons-html5',

	available: function () {
		return (
			window.FileReader !== undefined &&
			_jsZip() !== undefined &&
			!_isDuffSafari() &&
			_serialiser
		);
	},

	text: function (dt) {
		return dt.i18n('buttons.excel', 'Excel');
	},

	action: function (e, dt, button, config, cb) {
		var rowPos = 0;
		var dataStartRow, dataEndRow;
		var getXml = function (type) {
			var str = excelStrings[type];

			//str = str.replace( /xmlns:/g, 'xmlns_' ).replace( /mc:/g, 'mc_' );

			return $.parseXML(str);
		};
		var rels = getXml('xl/worksheets/sheet1.xml');
		var relsGet = rels.getElementsByTagName('sheetData')[0];

		var xlsx = {
			_rels: {
				'.rels': getXml('_rels/.rels')
			},
			xl: {
				_rels: {
					'workbook.xml.rels': getXml('xl/_rels/workbook.xml.rels')
				},
				'workbook.xml': getXml('xl/workbook.xml'),
				'styles.xml': getXml('xl/styles.xml'),
				worksheets: {
					'sheet1.xml': rels
				}
			},
			'[Content_Types].xml': getXml('[Content_Types].xml')
		};

		var data = dt.buttons.exportData(config.exportOptions);
		var currentRow, rowNode;
		var addRow = function (row) {
			currentRow = rowPos + 1;
			rowNode = _createNode(rels, 'row', { attr: { r: currentRow } });

			for (var i = 0, ien = row.length; i < ien; i++) {
				// Concat both the Cell Columns as a letter and the Row of the cell.
				var cellId = createCellPos(i) + '' + currentRow;
				var cell = null;

				// For null, undefined of blank cell, continue so it doesn't create the _createNode
				if (row[i] === null || row[i] === undefined || row[i] === '') {
					if (config.createEmptyCells === true) {
						row[i] = '';
					}
					else {
						continue;
					}
				}

				var originalContent = row[i];
				row[i] =
					typeof row[i].trim === 'function' ? row[i].trim() : row[i];

				// Special number formatting options
				for (var j = 0, jen = _excelSpecials.length; j < jen; j++) {
					var special = _excelSpecials[j];

					// TODO Need to provide the ability for the specials to say
					// if they are returning a string, since at the moment it is
					// assumed to be a number
					if (
						row[i].match &&
						!row[i].match(/^0\d+/) &&
						row[i].match(special.match)
					) {
						var val = row[i].replace(/[^\d\.\-]/g, '');

						if (special.fmt) {
							val = special.fmt(val);
						}

						cell = _createNode(rels, 'c', {
							attr: {
								r: cellId,
								s: special.style
							},
							children: [_createNode(rels, 'v', { text: val })]
						});

						break;
					}
				}

				if (!cell) {
					if (
						typeof row[i] === 'number' ||
						(row[i].match &&
							row[i].match(/^-?\d+(\.\d+)?([eE]\-?\d+)?$/) && // Includes exponential format
							!row[i].match(/^0\d+/))
					) {
						// Detect numbers - don't match numbers with leading zeros
						// or a negative anywhere but the start
						cell = _createNode(rels, 'c', {
							attr: {
								t: 'n',
								r: cellId
							},
							children: [_createNode(rels, 'v', { text: row[i] })]
						});
					}
					else {
						// String output - replace non standard characters for text output
						/*eslint no-control-regex: "off"*/
						var text = !originalContent.replace
							? originalContent
							: originalContent.replace(
									/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F-\x9F]/g,
									''
							);

						cell = _createNode(rels, 'c', {
							attr: {
								t: 'inlineStr',
								r: cellId
							},
							children: {
								row: _createNode(rels, 'is', {
									children: {
										row: _createNode(rels, 't', {
											text: text,
											attr: {
												'xml:space': 'preserve'
											}
										})
									}
								})
							}
						});
					}
				}

				rowNode.appendChild(cell);
			}

			relsGet.appendChild(rowNode);
			rowPos++;
		};

		var addHeader = function (structure) {
			structure.forEach(function (row) {
				addRow(
					row.map(function (cell) {
						return cell ? cell.title : '';
					}),
					rowPos
				);
				$('row:last c', rels).attr('s', '2'); // bold

				// Add any merge cells
				row.forEach(function (cell, columnCounter) {
					if (cell && (cell.colSpan > 1 || cell.rowSpan > 1)) {
						_excelMergeCells(
							rels,
							rowPos,
							columnCounter,
							cell.rowSpan,
							cell.colSpan
						);
					}
				});
			});
		};

		if (config.customizeData) {
			config.customizeData(data);
		}

		// Title and top messages
		var exportInfo = dt.buttons.exportInfo(config);
		if (exportInfo.title) {
			addRow([exportInfo.title], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
			$('row:last c', rels).attr('s', '51'); // centre
		}

		if (exportInfo.messageTop) {
			addRow([exportInfo.messageTop], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
		}

		// Table header
		if (config.header) {
			addHeader(data.headerStructure);
		}

		dataStartRow = rowPos;

		// Table body
		for (var n = 0, ie = data.body.length; n < ie; n++) {
			addRow(data.body[n], rowPos);
		}

		dataEndRow = rowPos;

		// Table footer
		if (config.footer && data.footer) {
			addHeader(data.footerStructure);
		}

		// Below the table
		if (exportInfo.messageBottom) {
			addRow([exportInfo.messageBottom], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
		}

		// Set column widths
		var cols = _createNode(rels, 'cols');
		$('worksheet', rels).prepend(cols);

		for (var i = 0, ien = data.header.length; i < ien; i++) {
			cols.appendChild(
				_createNode(rels, 'col', {
					attr: {
						min: i + 1,
						max: i + 1,
						width: _excelColWidth(data, i),
						customWidth: 1
					}
				})
			);
		}

		// Workbook modifications
		var workbook = xlsx.xl['workbook.xml'];

		$('sheets sheet', workbook).attr('name', _sheetname(config));

		// Auto filter for columns
		if (config.autoFilter) {
			$('mergeCells', rels).before(
				_createNode(rels, 'autoFilter', {
					attr: {
						ref:
							'A' +
							dataStartRow +
							':' +
							createCellPos(data.header.length - 1) +
							dataEndRow
					}
				})
			);

			$('definedNames', workbook).append(
				_createNode(workbook, 'definedName', {
					attr: {
						name: '_xlnm._FilterDatabase',
						localSheetId: '0',
						hidden: 1
					},
					text:
						_sheetname(config) +
						'!$A$' +
						dataStartRow +
						':' +
						createCellPos(data.header.length - 1) +
						dataEndRow
				})
			);
		}

		// Let the developer customise the document if they want to
		if (config.customize) {
			config.customize(xlsx, config, dt);
		}

		// Excel doesn't like an empty mergeCells tag
		if ($('mergeCells', rels).children().length === 0) {
			$('mergeCells', rels).remove();
		}

		var jszip = _jsZip();
		var zip = new jszip();
		var zipConfig = {
			compression: 'DEFLATE',
			type: 'blob',
			mimeType:
				'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
		};

		_addToZip(zip, xlsx);

		// Modern Excel has a 218 character limit on the file name + path of the file (why!?)
		// https://support.microsoft.com/en-us/office/excel-specifications-and-limits-1672b34d-7043-467e-8e27-269d656771c3
		// So we truncate to allow for this.
		var filename = exportInfo.filename;

		if (filename > 175) {
			filename = filename.substr(0, 175);
		}

		if (zip.generateAsync) {
			// JSZip 3+
			zip.generateAsync(zipConfig).then(function (blob) {
				_saveAs(blob, filename);
				cb();
			});
		}
		else {
			// JSZip 2.5
			_saveAs(zip.generate(zipConfig), filename);
			cb();
		}
	},

	async: 100,

	filename: '*',

	extension: '.xlsx',

	exportOptions: {},

	header: true,

	footer: true,

	title: '*',

	messageTop: '*',

	messageBottom: '*',

	createEmptyCells: false,

	autoFilter: false,

	sheetName: ''
};

//
// PDF export - using pdfMake - http://pdfmake.org
//
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.pdfHtml5 = {
	className: 'buttons-pdf buttons-html5',

	available: function () {
		return window.FileReader !== undefined && _pdfMake();
	},

	text: function (dt) {
		return dt.i18n('buttons.pdf', 'PDF');
	},

	action: function (e, dt, button, config, cb) {
		var data = dt.buttons.exportData(config.exportOptions);
		var info = dt.buttons.exportInfo(config);
		var rows = [];

		if (config.header) {
			data.headerStructure.forEach(function (row) {
				rows.push(
					row.map(function (cell) {
						return cell
							? {
									text: cell.title,
									colSpan: cell.colspan,
									rowSpan: cell.rowspan,
									style: 'tableHeader'
							}
							: {};
					})
				);
			});
		}

		for (var i = 0, ien = data.body.length; i < ien; i++) {
			rows.push(
				data.body[i].map(function (d) {
					return {
						text:
							d === null || d === undefined
								? ''
								: typeof d === 'string'
								? d
								: d.toString()
					};
				})
			);
		}

		if (config.footer) {
			data.footerStructure.forEach(function (row) {
				rows.push(
					row.map(function (cell) {
						return cell
							? {
									text: cell.title,
									colSpan: cell.colspan,
									rowSpan: cell.rowspan,
									style: 'tableHeader'
							}
							: {};
					})
				);
			});
		}

		var doc = {
			pageSize: config.pageSize,
			pageOrientation: config.orientation,
			content: [
				{
					style: 'table',
					table: {
						headerRows: data.headerStructure.length,
						footerRows: data.footerStructure.length, // Used for styling, doesn't do anything in pdfmake
						body: rows
					},
					layout: {
						hLineWidth: function (i, node) {
							if (i === 0 || i === node.table.body.length) {
								return 0;
							}
							return 0.5;
						},
						vLineWidth: function () {
							return 0;
						},
						hLineColor: function (i, node) {
							return i === node.table.headerRows ||
								i ===
									node.table.body.length -
										node.table.footerRows
								? '#333'
								: '#ddd';
						},
						fillColor: function (rowIndex) {
							if (rowIndex < data.headerStructure.length) {
								return '#fff';
							}
							return rowIndex % 2 === 0 ? '#f3f3f3' : null;
						},
						paddingTop: function () {
							return 5;
						},
						paddingBottom: function () {
							return 5;
						}
					}
				}
			],
			styles: {
				tableHeader: {
					bold: true,
					fontSize: 11,
					alignment: 'center'
				},
				tableFooter: {
					bold: true,
					fontSize: 11
				},
				table: {
					margin: [0, 5, 0, 5]
				},
				title: {
					alignment: 'center',
					fontSize: 13
				},
				message: {}
			},
			defaultStyle: {
				fontSize: 10
			}
		};

		if (info.messageTop) {
			doc.content.unshift({
				text: info.messageTop,
				style: 'message',
				margin: [0, 0, 0, 12]
			});
		}

		if (info.messageBottom) {
			doc.content.push({
				text: info.messageBottom,
				style: 'message',
				margin: [0, 0, 0, 12]
			});
		}

		if (info.title) {
			doc.content.unshift({
				text: info.title,
				style: 'title',
				margin: [0, 0, 0, 12]
			});
		}

		if (config.customize) {
			config.customize(doc, config, dt);
		}

		var pdf = _pdfMake().createPdf(doc);

		if (config.download === 'open' && !_isDuffSafari()) {
			pdf.open();
		}
		else {
			pdf.download(info.filename);
		}

		cb();
	},

	async: 100,

	title: '*',

	filename: '*',

	extension: '.pdf',

	exportOptions: {},

	orientation: 'portrait',

	// This isn't perfect, but it is close
	pageSize:
		navigator.language === 'en-US' || navigator.language === 'en-CA'
			? 'LETTER'
			: 'A4',

	header: true,

	footer: true,

	messageTop: '*',

	messageBottom: '*',

	customize: null,

	download: 'download'
};


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-buttons/js/buttons.print.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.print.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/* harmony import */ var datatables_net_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs");
/*!
 * Print button for Buttons and DataTables.
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


var _link = document.createElement('a');

/**
 * Clone link and style tags, taking into account the need to change the source
 * path.
 *
 * @param  {node}     el Element to convert
 */
var _styleToAbs = function (el) {
	var clone = $(el).clone()[0];

	if (clone.nodeName.toLowerCase() === 'link') {
		clone.href = _relToAbs(clone.href);
	}

	return clone.outerHTML;
};

/**
 * Convert a URL from a relative to an absolute address so it will work
 * correctly in the popup window which has no base URL.
 *
 * @param  {string} href URL
 */
var _relToAbs = function (href) {
	// Assign to a link on the original page so the browser will do all the
	// hard work of figuring out where the file actually is
	_link.href = href;
	var linkHost = _link.host;

	// IE doesn't have a trailing slash on the host
	// Chrome has it on the pathname
	if (linkHost.indexOf('/') === -1 && _link.pathname.indexOf('/') !== 0) {
		linkHost += '/';
	}

	return _link.protocol + '//' + linkHost + _link.pathname + _link.search;
};

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.print = {
	className: 'buttons-print',

	text: function (dt) {
		return dt.i18n('buttons.print', 'Print');
	},

	action: function (e, dt, button, config, cb) {
		var data = dt.buttons.exportData(
			$.extend({ decodeEntities: false }, config.exportOptions) // XSS protection
		);
		var exportInfo = dt.buttons.exportInfo(config);

		// Get the classes for the columns from the header cells
		var columnClasses = dt
			.columns(config.exportOptions.columns)
			.nodes()
			.map(function (n) {
				return n.className;
			})
			.toArray();

		var addRow = function (d, tag) {
			var str = '<tr>';

			for (var i = 0, ien = d.length; i < ien; i++) {
				// null and undefined aren't useful in the print output
				var dataOut = d[i] === null || d[i] === undefined ? '' : d[i];
				var classAttr = columnClasses[i]
					? 'class="' + columnClasses[i] + '"'
					: '';

				str +=
					'<' +
					tag +
					' ' +
					classAttr +
					'>' +
					dataOut +
					'</' +
					tag +
					'>';
			}

			return str + '</tr>';
		};

		// Construct a table for printing
		var html = '<table class="' + dt.table().node().className + '">';

		if (config.header) {
			var headerRows = data.headerStructure.map(function (row) {
				return (
					'<tr>' +
					row
						.map(function (cell) {
							return cell
								? '<th colspan="' +
										cell.colspan +
										'" rowspan="' +
										cell.rowspan +
										'">' +
										cell.title +
										'</th>'
								: '';
						})
						.join('') +
					'</tr>'
				);
			});

			html += '<thead>' + headerRows.join('') + '</thead>';
		}

		html += '<tbody>';
		for (var i = 0, ien = data.body.length; i < ien; i++) {
			html += addRow(data.body[i], 'td');
		}
		html += '</tbody>';

		if (config.footer && data.footer) {
			var footerRows = data.footerStructure.map(function (row) {
				return (
					'<tr>' +
					row
						.map(function (cell) {
							return cell
								? '<th colspan="' +
										cell.colspan +
										'" rowspan="' +
										cell.rowspan +
										'">' +
										cell.title +
										'</th>'
								: '';
						})
						.join('') +
					'</tr>'
				);
			});

			html += '<tfoot>' + footerRows.join('') + '</tfoot>';
		}
		html += '</table>';

		// Open a new window for the printable table
		var win = window.open('', '');

		if (!win) {
			dt.buttons.info(
				dt.i18n('buttons.printErrorTitle', 'Unable to open print view'),
				dt.i18n(
					'buttons.printErrorMsg',
					'Please allow popups in your browser for this site to be able to view the print view.'
				),
				5000
			);

			return;
		}

		win.document.close();

		// Inject the title and also a copy of the style and link tags from this
		// document so the table can retain its base styling. Note that we have
		// to use string manipulation as IE won't allow elements to be created
		// in the host document and then appended to the new window.
		var head = '<title>' + exportInfo.title + '</title>';
		$('style, link').each(function () {
			head += _styleToAbs(this);
		});

		try {
			win.document.head.innerHTML = head; // Work around for Edge
		} catch (e) {
			$(win.document.head).html(head); // Old IE
		}

		// Inject the table and other surrounding information
		win.document.body.innerHTML =
			'<h1>' +
			exportInfo.title +
			'</h1>' +
			'<div>' +
			(exportInfo.messageTop || '') +
			'</div>' +
			html +
			'<div>' +
			(exportInfo.messageBottom || '') +
			'</div>';

		$(win.document.body).addClass('dt-print-view');

		$('img', win.document.body).each(function (i, img) {
			img.setAttribute('src', _relToAbs(img.getAttribute('src')));
		});

		if (config.customize) {
			config.customize(win, config, dt);
		}

		// Allow stylesheets time to load
		var autoPrint = function () {
			if (config.autoPrint) {
				win.print(); // blocking - so close will not
				win.close(); // execute until this is done
			}
		};

		win.setTimeout(autoPrint, 1000);

		cb();
	},

	async: 100,

	title: '*',

	messageTop: '*',

	messageBottom: '*',

	exportOptions: {},

	header: true,

	footer: true,

	autoPrint: true,

	customize: null
};


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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