"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_datatables_net-buttons-bs4_js_buttons_bootstrap4_mjs-node_modules_datata-66fa25"],{

/***/ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs":
/*!**********************************************************************!*\
  !*** ./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! DataTables Bootstrap 4 integration
 * ©2011-2017 SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * DataTables integration for Bootstrap 4. This requires Bootstrap 4 and
 * DataTables 1.10 or newer.
 *
 * This file sets the defaults and adds options to DataTables to style its
 * controls using Bootstrap. See https://datatables.net/manual/styling/bootstrap
 * for further information.
 */

/* Set the defaults for DataTables initialisation */
$.extend( true, datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults, {
	renderer: 'bootstrap'
} );


/* Default class modification */
$.extend( true, datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.classes, {
	container: "dt-container dt-bootstrap4",
	search: {
		input: "form-control form-control-sm"
	},
	length: {
		select: "custom-select custom-select-sm form-control form-control-sm"
	},
	processing: {
		container: "dt-processing card"
	}
} );


/* Bootstrap paging button renderer */
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.renderer.pagingButton.bootstrap = function (settings, buttonType, content, active, disabled) {
	var btnClasses = ['dt-paging-button', 'page-item'];

	if (active) {
		btnClasses.push('active');
	}

	if (disabled) {
		btnClasses.push('disabled')
	}

	var li = $('<li>').addClass(btnClasses.join(' '));
	var a = $('<a>', {
		'href': disabled ? null : '#',
		'class': 'page-link'
	})
		.html(content)
		.appendTo(li);

	return {
		display: li,
		clicker: a
	};
};

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.renderer.pagingContainer.bootstrap = function (settings, buttonEls) {
	return $('<ul/>').addClass('pagination').append(buttonEls);
};

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.renderer.layout.bootstrap = function ( settings, container, items ) {
	var row = $( '<div/>', {
			"class": items.full ?
				'row justify-content-md-center' :
				'row justify-content-between'
		} )
		.appendTo( container );

	$.each( items, function (key, val) {
		var klass;

		// Apply left / right margins
		if (val.table) {
			klass = 'col-12';
		}
		else if (key === 'start') {
			klass = 'col-md-auto mr-auto';
		}
		else if (key === 'end') {
			klass = 'col-md-auto ml-auto';
		}
		else {
			klass = 'col-md';
		}

		$( '<div/>', {
				id: val.id || null,
				"class": klass+' '+(val.className || '')
			} )
			.append( val.contents )
			.appendTo( row );
	} );
};


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-buttons-bs4/js/buttons.bootstrap4.mjs":
/*!***************************************************************************!*\
  !*** ./node_modules/datatables.net-buttons-bs4/js/buttons.bootstrap4.mjs ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs");
/*! Bootstrap integration for DataTables' Buttons
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


$.extend(true, datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"].Buttons.defaults, {
	dom: {
		container: {
			className: 'dt-buttons btn-group flex-wrap'
		},
		button: {
			className: 'btn btn-secondary',
			active: 'active'
		},
		collection: {
			action: {
				dropHtml: ''
			},
			container: {
				tag: 'div',
				className: 'dropdown-menu dt-button-collection'
			},
			closeButton: false,
			button: {
				tag: 'a',
				className: 'dt-button dropdown-item',
				active: 'dt-button-active',
				disabled: 'disabled',
				spacer: {
					className: 'dropdown-divider',
					tag: 'hr'
				}
			}
		},
		split: {
			action: {
				tag: 'a',
				className: 'btn btn-secondary dt-button-split-drop-button',
				closeButton: false
			},
			dropdown: {
				tag: 'button',
				dropHtml: '',
				className:
					'btn btn-secondary dt-button-split-drop dropdown-toggle dropdown-toggle-split',
				closeButton: false,
				align: 'split-left',
				splitAlignClass: 'dt-button-split-left'
			},
			wrapper: {
				tag: 'div',
				className: 'dt-button-split btn-group',
				closeButton: false
			}
		}
	},
	buttonCreated: function (config, button) {
		return config.buttons ? $('<div class="btn-group"/>').append(button) : button;
	}
});

datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.collection.className += ' dropdown-toggle';
datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons.collection.rightAlignClassName = 'dropdown-menu-right';


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-colreorder-bs4/js/colReorder.bootstrap4.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/datatables.net-colreorder-bs4/js/colReorder.bootstrap4.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_colreorder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-colreorder */ "./node_modules/datatables.net-colreorder/js/dataTables.colReorder.mjs");
/*! Bootstrap 4 styling wrapper for ColReorder
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-colreorder/js/dataTables.colReorder.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/datatables.net-colreorder/js/dataTables.colReorder.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! ColReorder 2.0.0-dev
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


(function( factory ){
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( ['jquery', 'datatables.net'], function ( $ ) {
			return factory( $, window, document );
		} );
	}
	else if ( typeof exports === 'object' ) {
		// CommonJS
		var jq = require('jquery');
		var cjsRequires = function (root, $) {
			if ( ! $.fn.dataTable ) {
				require('datatables.net')(root, $);
			}
		};

		if (typeof window === 'undefined') {
			module.exports = function (root, $) {
				if ( ! root ) {
					// CommonJS environments without a window global must pass a
					// root. This will give an error otherwise
					root = window;
				}

				if ( ! $ ) {
					$ = jq( root );
				}

				cjsRequires( root, $ );
				return factory( $, root, root.document );
			};
		}
		else {
			cjsRequires( window, jq );
			module.exports = factory( jq, window, window.document );
		}
	}
	else {
		// Browser
		factory( jquery__WEBPACK_IMPORTED_MODULE_0__, window, document );
	}
}(function( $, window, document ) {
'use strict';
var DataTable = $.fn.dataTable;


/**
 * Mutate an array, moving a set of elements into a new index position
 *
 * @param arr Array to modify
 * @param from Start move index
 * @param count Number of elements to move
 * @param to Index where the start element will move to
 */
function arrayMove(arr, from, count, to) {
    var movers = arr.splice(from, count);
    // Add delete and start to the array, so we can use it for the `apply`
    movers.unshift(0); // splice delete param
    movers.unshift(to < from ? to : to - count + 1); // splice start param
    arr.splice.apply(arr, movers);
}
/**
 * Run finishing activities after one or more columns have been reordered.
 *
 * @param dt DataTable being operated on - must be a single table instance
 */
function finalise(dt) {
    // Cache invalidation. Always read from the data object rather
    // than reading back from the DOM since it could have been
    // changed by a renderer
    dt.rows().invalidate('data');
    // Redraw the header / footer. Its a little bit of a hack this, as DT
    // doesn't expose the header draw as an API method. It calls state
    // saving, so we don't need to here.
    dt.column(0).visible(dt.column(0).visible());
    dt.columns.adjust();
    // Fire an event so other plug-ins can update
    var order = dt.colReorder.order();
    dt.trigger('columns-reordered', [
        {
            order: order,
            mapping: invertKeyValues(order)
        }
    ]);
}
/**
 * Get the original indexes in their current order
 *
 * @param dt DataTable being operated on - must be a single table instance
 * @returns Original indexes in current order
 */
function getOrder(dt) {
    return dt.settings()[0].aoColumns.map(function (col) {
        return col._crOriginalIdx;
    });
}
/**
 * Manipulate a header / footer array in DataTables settings to reorder
 * the columns.
 */
function headerUpdate(structure, map, from, to) {
    var done = [];
    for (var i = 0; i < structure.length; i++) {
        var headerRow = structure[i];
        arrayMove(headerRow, from[0], from.length, to);
        for (var j = 0; j < headerRow.length; j++) {
            var cell = headerRow[j].cell;
            // Only work on a DOM element once, otherwise we risk remapping a
            // remapped value (etc).
            if (done.includes(cell)) {
                continue;
            }
            var indexes = cell.getAttribute('data-dt-column').split(',');
            var mapped = indexes
                .map(function (idx) {
                return map[idx];
            })
                .join(',');
            // Update data attributes for the new column position
            cell.setAttribute('data-dt-column', mapped);
            done.push(cell);
        }
    }
}
/**
 * Setup for ColReorder API operations
 *
 * @param dt DataTable(s) being operated on - might have multiple tables!
 */
function init(api) {
    // Assign the original column index to a parameter that we can lookup.
    // On the first pass (i.e. when the parameter hasn't yet been set), the
    // index order will be the original order, so this is quite a simple
    // assignment.
    api.columns().iterator('column', function (s, idx) {
        var columns = s.aoColumns;
        if (columns[idx]._crOriginalIdx === undefined) {
            columns[idx]._crOriginalIdx = idx;
        }
    });
}
/**
 * Switch the key value pairing of an index array to be value key (i.e. the old value is now the
 * key). For example consider [ 2, 0, 1 ] this would be returned as [ 1, 2, 0 ].
 *
 *  @param   array arr Array to switch around
 */
function invertKeyValues(arr) {
    var result = [];
    for (var i = 0; i < arr.length; i++) {
        result[arr[i]] = i;
    }
    return result;
}
/**
 * Move one or more columns from one index to another.
 *
 * This method has a lot of knowledge about how DataTables works internally.
 * If DataTables changes how it handles cells, columns, etc, then this
 * method would need to be updated accordingly.
 *
 * @param dt DataTable being operated on - must be a single table instance
 * @param from Column indexes to move
 * @param to Destination index (starting if multiple)
 */
function move(dt, from, to) {
    var i, j;
    var settings = dt.settings()[0];
    var columns = settings.aoColumns;
    var newOrder = columns.map(function (col, idx) {
        return idx;
    });
    // The to column in already inside the from column(s) (might be the same)
    // no change required
    if (from.includes(to)) {
        return;
    }
    // A reverse index array so we can look up new indexes from old
    arrayMove(newOrder, from[0], from.length, to);
    var reverseIndexes = invertKeyValues(newOrder);
    // Main column
    arrayMove(columns, from[0], from.length, to);
    // Per row manipulations
    for (i = 0; i < settings.aoData.length; i++) {
        var data = settings.aoData[i];
        var cells = data.anCells;
        if (cells) {
            // Array of cells
            arrayMove(cells, from[0], from.length, to);
            for (j = 0; j < cells.length; j++) {
                // Reinsert into the document in the new order
                if (data.nTr && cells[j] && columns[j].bVisible) {
                    data.nTr.appendChild(cells[j]);
                }
                // Update lookup index
                if (cells[j] && cells[j]._DT_CellIndex) {
                    cells[j]._DT_CellIndex.column = j;
                }
            }
        }
    }
    // Per column manipulation
    for (i = 0; i < columns.length; i++) {
        var column = columns[i];
        // Data column sorting
        for (j = 0; j < column.aDataSort.length; j++) {
            column.aDataSort[j] = reverseIndexes[column.aDataSort[j]];
        }
        // Update the column indexes
        column.idx = reverseIndexes[column.idx];
        // Reorder the colgroup > col elements for the new order
        if (column.bVisible) {
            settings.colgroup.append(column.colEl);
        }
    }
    // Header and footer
    headerUpdate(settings.aoHeader, reverseIndexes, from, to);
    headerUpdate(settings.aoFooter, reverseIndexes, from, to);
    // Search - columns
    arrayMove(settings.aoPreSearchCols, from[0], from.length, to);
    // Ordering indexes update - note that the sort listener on the
    // header works out the index to apply on each draw, so it doesn't
    // need to be updated here.
    orderingIndexes(reverseIndexes, settings.aaSorting);
    if (Array.isArray(settings.aaSortingFixed)) {
        orderingIndexes(reverseIndexes, settings.aaSortingFixed);
    }
    else if (settings.aaSortingFixed.pre) {
        orderingIndexes(reverseIndexes, settings.aaSortingFixed.pre);
    }
    else if (settings.aaSortingFixed.post) {
        orderingIndexes(reverseIndexes, settings.aaSortingFixed.pre);
    }
    settings.aLastSort.forEach(function (el) {
        el.src = reverseIndexes[el.src];
    });
    // Fire an event so other plug-ins can update
    dt.trigger('column-reorder', [
        dt.settings()[0],
        {
            from: from,
            to: to,
            mapping: reverseIndexes
        }
    ]);
}
/**
 * Update the indexing for ordering arrays
 *
 * @param map Reverse index map
 * @param order Array to update
 */
function orderingIndexes(map, order) {
    for (var i = 0; i < order.length; i++) {
        var el = order[i];
        if (typeof el === 'number') {
            // Just a number
            order[i] = map[el];
        }
        else if ($.isPlainObject(el) && el.idx !== undefined) {
            // New index in an object style
            el.idx = map[el.idx];
        }
        else if (Array.isArray(el) && typeof el[0] === 'number') {
            // The good old fixes length array
            el[0] = map[el[0]];
        }
        // No need to update if in object + .name style
    }
}
/**
 * Take an index array for the current positioned, reordered to what you want
 * them to be.
 *
 * @param dt DataTable being operated on - must be a single table instance
 * @param order Indexes from current order, positioned as you want them to be
 */
function setOrder(dt, order, original) {
    var changed = false;
    var i;
    if (order.length !== dt.columns().count()) {
        dt.error('ColReorder - column count mismatch');
        return;
    }
    // The order given is based on the original indexes, rather than the
    // existing ones, so we need to translate from the original to current
    // before then doing the order
    if (original) {
        order = transpose(dt, order, 'toCurrent');
    }
    // The API is array index as the desired position, but our algorithm below is
    // for array index as the current position. So we need to invert for it to work.
    var setOrder = invertKeyValues(order);
    // Move columns, one by one with validation disabled!
    for (i = 0; i < setOrder.length; i++) {
        var currentIndex = setOrder.indexOf(i);
        if (i !== currentIndex) {
            // Reorder our switching error
            arrayMove(setOrder, currentIndex, 1, i);
            // Do the reorder
            move(dt, [currentIndex], i);
            changed = true;
        }
    }
    // Reorder complete
    if (changed) {
        finalise(dt);
    }
}
/**
 * Convert the DataTables header structure array into a 2D array where each
 * element has a reference to its TH/TD cell (regardless of spanning).
 *
 * @param structure Header / footer structure object
 * @returns 2D array of header cells
 */
function structureFill(structure) {
    var filledIn = [];
    for (var row = 0; row < structure.length; row++) {
        filledIn.push([]);
        for (var col = 0; col < structure[row].length; col++) {
            var cell = structure[row][col];
            if (cell) {
                for (var rowInner = 0; rowInner < cell.rowspan; rowInner++) {
                    for (var colInner = 0; colInner < cell.colspan; colInner++) {
                        filledIn[row + rowInner][col + colInner] = cell.cell;
                    }
                }
            }
        }
    }
    return filledIn;
}
/**
 * Convert the index type
 *
 * @param dt DataTable to work on
 * @param idx Index to transform
 * @param dir Transform direction
 * @returns Converted number(s)
 */
function transpose(dt, idx, dir) {
    var order = dt.colReorder.order();
    var columns = dt.settings()[0].aoColumns;
    if (dir === 'toCurrent' || dir === 'fromOriginal') {
        // Given an original index, want the current
        return !Array.isArray(idx)
            ? order.indexOf(idx)
            : idx.map(function (index) {
                return order.indexOf(index);
            });
    }
    // Given a current index, want the original
    return !Array.isArray(idx)
        ? columns[idx]._crOriginalIdx
        : idx.map(function (index) {
            return columns[index]._crOriginalIdx;
        });
}
/**
 * Validate that a requested move is okay. This includes bound checking
 * and that it won't split colspan'ed cells.
 *
 * @param table API instance
 * @param from Column indexes to move
 * @param to Destination index (starting if multiple)
 * @returns Validation result
 */
function validateMove(table, from, to) {
    var columns = table.columns().count();
    // Sanity and bound checking
    if (from[0] < to && to < from[from.length]) {
        return false;
    }
    if (from[0] < 0 && from[from.length - 1] > columns) {
        return false;
    }
    if (to < 0 && to > columns) {
        return false;
    }
    // No change - it's valid
    if (from.includes(to)) {
        return true;
    }
    if (!validateStructureMove(table.table().header.structure(), from, to)) {
        return false;
    }
    if (!validateStructureMove(table.table().footer.structure(), from, to)) {
        return false;
    }
    return true;
}
/**
 * For a given structure check that the move is valid.
 * @param structure
 * @param from
 * @param to
 * @returns
 */
function validateStructureMove(structure, from, to) {
    var header = structureFill(structure);
    var i;
    // Shuffle the header cells around
    for (i = 0; i < header.length; i++) {
        arrayMove(header[i], from[0], from.length, to);
    }
    // Sanity check that the headers are next to each other
    for (i = 0; i < header.length; i++) {
        var seen = [];
        for (var j = 0; j < header[i].length; j++) {
            var cell = header[i][j];
            if (!seen.includes(cell)) {
                // Hasn't been seen before
                seen.push(cell);
            }
            else if (seen[seen.length - 1] !== cell) {
                // Has been seen before and is not the previous cell - validation failed
                return false;
            }
        }
    }
    return true;
}

/**
 * This is one possible UI for column reordering in DataTables. In this case
 * columns are reordered by clicking and dragging a column header. It calculates
 * where columns can be dropped based on the column header used to start the drag
 * and then `colReorder.move()` method to alter the DataTable.
 */
var ColReorder = /** @class */ (function () {
    function ColReorder(dt, opts) {
        this.dom = {
            drag: null
        };
        this.c = {
            columns: null,
            enable: null,
            order: null
        };
        this.s = {
            dropZones: [],
            mouse: {
                absLeft: -1,
                offset: {
                    x: -1,
                    y: -1
                },
                start: {
                    x: -1,
                    y: -1
                },
                target: null,
                targets: []
            },
            scrollInterval: null
        };
        var that = this;
        var ctx = dt.settings()[0];
        // Check if ColReorder already has been initialised on this DataTable - only
        // one can exist.
        if (ctx._colReorder) {
            return;
        }
        dt.settings()[0]._colReorder = this;
        this.dt = dt;
        $.extend(this.c, ColReorder.defaults, opts);
        init(dt);
        dt.on('stateSaveParams', function (e, s, d) {
            d.colReorder = getOrder(dt);
        });
        dt.on('destroy', function () {
            dt.off('.colReorder');
            dt.colReorder.reset();
        });
        // Initial ordering / state restoring
        var loaded = dt.state.loaded();
        var order = this.c.order;
        if (loaded && loaded.colReorder) {
            order = loaded.colReorder;
        }
        if (order) {
            dt.ready(function () {
                setOrder(dt, order, true);
            });
        }
        dt.table()
            .header.structure()
            .forEach(function (row) {
            for (var i = 0; i < row.length; i++) {
                if (row[i] && row[i].cell) {
                    that._addListener(row[i].cell);
                }
            }
        });
    }
    ColReorder.prototype.disable = function () {
        this.c.enable = false;
        return this;
    };
    ColReorder.prototype.enable = function (flag) {
        if (flag === void 0) { flag = true; }
        if (flag === false) {
            return this.disable();
        }
        this.c.enable = true;
        return this;
    };
    /**
     * Attach the mouse down listener to an element to start a column reorder action
     *
     * @param el
     */
    ColReorder.prototype._addListener = function (el) {
        var that = this;
        $(el)
            .on('selectstart.colReorder', function () {
            return false;
        })
            .on('mousedown.colReorder touchstart.colReorder', function (e) {
            // Ignore middle and right click
            if (e.type === 'mousedown' && e.which !== 1) {
                return;
            }
            // Ignore if disabled
            if (!that.c.enable) {
                return;
            }
            that._mouseDown(e, this);
        });
    };
    /**
     * Create the element that is dragged around the page
     */
    ColReorder.prototype._createDragNode = function () {
        var origCell = this.s.mouse.target;
        var origTr = origCell.parent();
        var origThead = origTr.parent();
        var origTable = origThead.parent();
        var cloneCell = origCell.clone();
        // This is a slightly odd combination of jQuery and DOM, but it is the
        // fastest and least resource intensive way I could think of cloning
        // the table with just a single header cell in it.
        this.dom.drag = $(origTable[0].cloneNode(false))
            .addClass('dtcr-cloned')
            .append($(origThead[0].cloneNode(false)).append($(origTr[0].cloneNode(false)).append(cloneCell[0])) // Not sure why  it doesn't want to append a jQuery node
        )
            .css({
            position: 'absolute',
            top: 0,
            left: 0,
            width: $(origCell).outerWidth(),
            height: $(origCell).outerHeight()
        })
            .appendTo('body');
    };
    /**
     * Get cursor position regardless of mouse or touch input
     *
     * @param e Event
     * @param prop Property name to get
     * @returns Value - assuming a number here
     */
    ColReorder.prototype._cursorPosition = function (e, prop) {
        return e.type.indexOf('touch') !== -1 ? e.originalEvent.touches[0][prop] : e[prop];
    };
    /**
     * Cache values at start
     *
     * @param e Triggering event
     * @param cell Cell that the action started on
     * @returns
     */
    ColReorder.prototype._mouseDown = function (e, cell) {
        var _this = this;
        var target = $(e.target).closest('th, td');
        var offset = target.offset();
        var moveableColumns = this.dt.columns(this.c.columns).indexes().toArray();
        var moveColumnIndexes = $(cell)
            .attr('data-dt-column')
            .split(',')
            .map(function (val) {
            return parseInt(val, 10);
        });
        // Don't do anything for columns which are not selected as moveable
        for (var j = 0; j < moveColumnIndexes.length; j++) {
            if (!moveableColumns.includes(moveColumnIndexes[j])) {
                return false;
            }
        }
        this.s.mouse.start.x = this._cursorPosition(e, 'pageX');
        this.s.mouse.start.y = this._cursorPosition(e, 'pageY');
        this.s.mouse.offset.x = this._cursorPosition(e, 'pageX') - offset.left;
        this.s.mouse.offset.y = this._cursorPosition(e, 'pageY') - offset.top;
        this.s.mouse.target = target;
        this.s.mouse.targets = moveColumnIndexes;
        // Classes to highlight the columns being moved
        for (var i = 0; i < moveColumnIndexes.length; i++) {
            var cells = this.dt
                .cells(null, moveColumnIndexes[i], { page: 'current' })
                .nodes()
                .to$();
            var klass = 'dtcr-moving';
            if (i === 0) {
                klass += ' dtcr-moving-first';
            }
            if (i === moveColumnIndexes.length - 1) {
                klass += ' dtcr-moving-last';
            }
            cells.addClass(klass);
        }
        this._regions(moveColumnIndexes);
        this._scrollRegions();
        /* Add event handlers to the document */
        $(document)
            .on('mousemove.colReorder touchmove.colReorder', function (e) {
            _this._mouseMove(e);
        })
            .on('mouseup.colReorder touchend.colReorder', function (e) {
            _this._mouseUp(e);
        });
    };
    ColReorder.prototype._mouseMove = function (e) {
        if (this.dom.drag === null) {
            // Only create the drag element if the mouse has moved a specific distance from the start
            // point - this allows the user to make small mouse movements when sorting and not have a
            // possibly confusing drag element showing up
            if (Math.pow(Math.pow(this._cursorPosition(e, 'pageX') - this.s.mouse.start.x, 2) +
                Math.pow(this._cursorPosition(e, 'pageY') - this.s.mouse.start.y, 2), 0.5) < 5) {
                return;
            }
            $(document.body).addClass('dtcr-dragging');
            this._createDragNode();
        }
        // Position the element - we respect where in the element the click occurred
        this.dom.drag.css({
            left: this._cursorPosition(e, 'pageX') - this.s.mouse.offset.x,
            top: this._cursorPosition(e, 'pageY') - this.s.mouse.offset.y
        });
        // Find cursor's left position relative to the table
        var tableOffset = $(this.dt.table().node()).offset().left;
        var cursorMouseLeft = this._cursorPosition(e, 'pageX') - tableOffset;
        var dropZone = this.s.dropZones.find(function (zone) {
            if (zone.left <= cursorMouseLeft && cursorMouseLeft <= zone.left + zone.width) {
                return true;
            }
            return false;
        });
        this.s.mouse.absLeft = this._cursorPosition(e, 'pageX');
        if (!dropZone) {
            return;
        }
        if (!dropZone.self) {
            this._move(dropZone, cursorMouseLeft);
        }
    };
    ColReorder.prototype._mouseUp = function (e) {
        $(document).off('.colReorder');
        $(document.body).removeClass('dtcr-dragging');
        if (this.dom.drag) {
            this.dom.drag.remove();
            this.dom.drag = null;
        }
        if (this.s.scrollInterval) {
            clearInterval(this.s.scrollInterval);
        }
        this.dt.cells('.dtcr-moving').nodes().to$().removeClass('dtcr-moving dtcr-moving-first dtcr-moving-last');
    };
    /**
     * Shift columns around
     *
     * @param dropZone Where to move to
     * @param cursorMouseLeft Cursor position, relative to the left of the table
     */
    ColReorder.prototype._move = function (dropZone, cursorMouseLeft) {
        var that = this;
        this.dt.colReorder.move(this.s.mouse.targets, dropZone.colIdx);
        // Update the targets
        this.s.mouse.targets = $(this.s.mouse.target)
            .attr('data-dt-column')
            .split(',')
            .map(function (val) {
            return parseInt(val, 10);
        });
        this._regions(this.s.mouse.targets);
        // If the column being moved is smaller than the column it is replacing,
        // the drop zones might need a correction to allow for this since, otherwise
        // we might immediately be changing the column order as soon as it was placed.
        // Find the drop zone for the first in the list of targets - is its
        // left greater than the mouse position. If so, it needs correcting
        var dz = this.s.dropZones.find(function (zone) {
            return zone.colIdx === that.s.mouse.targets[0];
        });
        var dzIdx = this.s.dropZones.indexOf(dz);
        if (dz.left > cursorMouseLeft) {
            var previousDiff = dz.left - cursorMouseLeft;
            var previousDz = this.s.dropZones[dzIdx - 1];
            dz.left -= previousDiff;
            dz.width += previousDiff;
            if (previousDz) {
                previousDz.width -= previousDiff;
            }
        }
        // And for the last in the list
        dz = this.s.dropZones.find(function (zone) {
            return zone.colIdx === that.s.mouse.targets[that.s.mouse.targets.length - 1];
        });
        if (dz.left + dz.width < cursorMouseLeft) {
            var nextDiff = cursorMouseLeft - (dz.left + dz.width);
            var nextDz = this.s.dropZones[dzIdx + 1];
            dz.width += nextDiff;
            if (nextDz) {
                nextDz.left += nextDiff;
                nextDz.width -= nextDiff;
            }
        }
    };
    /**
     * Determine the boundaries for where drops can happen and where they would
     * insert into.
     */
    ColReorder.prototype._regions = function (moveColumns) {
        var that = this;
        var dropZones = [];
        var totalWidth = 0;
        var negativeCorrect = 0;
        var allowedColumns = this.dt.columns(this.c.columns).indexes().toArray();
        var widths = this.dt.columns().widths();
        // Each column is a drop zone
        this.dt.columns().every(function (colIdx, tabIdx, i) {
            if (!this.visible()) {
                return;
            }
            var columnWidth = widths[colIdx];
            // Check that we are allowed to move into this column - if not, need
            // to offset the widths
            if (!allowedColumns.includes(colIdx)) {
                totalWidth += columnWidth;
                return;
            }
            var valid = validateMove(that.dt, moveColumns, colIdx);
            if (valid) {
                // New drop zone. Note that it might have it's offset moved
                // by the final condition in this logic set
                dropZones.push({
                    colIdx: colIdx,
                    left: totalWidth - negativeCorrect,
                    self: moveColumns[0] <= colIdx && colIdx <= moveColumns[moveColumns.length - 1],
                    width: columnWidth + negativeCorrect
                });
            }
            else if (colIdx < moveColumns[0]) {
                // Not valid and before the column(s) to be moved - the drop
                // zone for the previous valid drop point is extended
                if (dropZones.length) {
                    dropZones[dropZones.length - 1].width += columnWidth;
                }
            }
            else if (colIdx > moveColumns[moveColumns.length - 1]) {
                // Not valid and after the column(s) to be moved - the next
                // drop zone to be created will be extended
                negativeCorrect += columnWidth;
            }
            totalWidth += columnWidth;
        });
        this.s.dropZones = dropZones;
        // this._drawDropZones();
    };
    /**
     * Check if the table is scrolling or not. It is it the `table` isn't the same for
     * the header and body parents.
     *
     * @returns
     */
    ColReorder.prototype._isScrolling = function () {
        return this.dt.table().body().parentNode !== this.dt.table().header().parentNode;
    };
    /**
     * Set an interval clock that will check to see if the scrolling of the table body should be moved
     * as the mouse moves on the scroll (allowing a drag and drop to columns which aren't yet visible)
     */
    ColReorder.prototype._scrollRegions = function () {
        if (!this._isScrolling()) {
            // Not scrolling - nothing to do
            return;
        }
        var that = this;
        var tableLeft = $(this.dt.table().container()).position().left;
        var tableWidth = $(this.dt.table().container()).outerWidth();
        var mouseBuffer = 75;
        var scrollContainer = this.dt.table().body().parentElement.parentElement;
        this.s.scrollInterval = setInterval(function () {
            var mouseLeft = that.s.mouse.absLeft;
            if (mouseLeft < tableLeft + mouseBuffer && scrollContainer.scrollLeft) {
                scrollContainer.scrollLeft -= 5;
            }
            else if (mouseLeft > tableLeft + tableWidth - mouseBuffer &&
                scrollContainer.scrollLeft < scrollContainer.scrollWidth) {
                scrollContainer.scrollLeft += 5;
            }
        }, 25);
    };
    // This is handy for debugging where the drop zones actually are!
    // private _drawDropZones () {
    // 	let dropZones = this.s.dropZones;
    // 	$('div.allan').remove();
    // 	for (let i=0 ; i<dropZones.length ; i++) {
    // 		let zone = dropZones[i];
    // 		$(this.dt.table().container()).append(
    // 			$('<div>')
    // 				.addClass('allan')
    // 				.css({
    // 					position: 'absolute',
    // 					top: 0,
    // 					width: zone.width - 4,
    // 					height: 20,
    // 					left: zone.left + 2,
    // 					border: '1px solid red',
    // 				})
    // 		);
    // 	}
    // }
    ColReorder.defaults = {
        columns: '',
        enable: true,
        order: null
    };
    ColReorder.version = '2.0.0-dev';
    return ColReorder;
}());

/*! ColReorder 2.0.0-dev
 * © SpryMedia Ltd - datatables.net/license
 */
/**
 * @summary     ColReorder
 * @description Provide the ability to reorder columns in a DataTable
 * @version     2.0.0-dev
 * @author      SpryMedia Ltd
 * @contact     datatables.net
 * @copyright   SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */
 // declare var DataTable: any;
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * UI interaction class
 */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables API integration
 */
/** Enable mouse column reordering */
DataTable.Api.register('colReorder.enable()', function (flag) {
    return this.iterator('table', function (ctx) {
        if (ctx._colReorder) {
            ctx._colReorder.enable(flag);
        }
    });
});
/** Disable mouse column reordering */
DataTable.Api.register('colReorder.disable()', function () {
    return this.iterator('table', function (ctx) {
        if (ctx._colReorder) {
            ctx._colReorder.disable();
        }
    });
});
/**
 * Change the ordering of the columns in the DataTable.
 */
DataTable.Api.register('colReorder.move()', function (from, to) {
    init(this);
    if (!Array.isArray(from)) {
        from = [from];
    }
    if (!validateMove(this, from, to)) {
        this.error('ColReorder - invalid move');
        return this;
    }
    return this.tables().every(function () {
        move(this, from, to);
        finalise(this);
    });
});
DataTable.Api.register('colReorder.order()', function (set, original) {
    init(this);
    if (!set) {
        return this.context.length ? getOrder(this) : null;
    }
    return this.tables().every(function () {
        setOrder(this, set, original);
    });
});
DataTable.Api.register('colReorder.reset()', function () {
    init(this);
    return this.tables().every(function () {
        var order = this.columns()
            .every(function (i) {
            return i;
        })
            .flatten()
            .toArray();
        setOrder(this, order, true);
    });
});
DataTable.Api.register('colReorder.transpose()', function (idx, dir) {
    init(this);
    if (!dir) {
        dir = 'toCurrent';
    }
    return transpose(this, idx, dir);
});
DataTable.ColReorder = ColReorder;
// Called when DataTables is going to load a state. That might be
// before the table is ready (state saving) or after (state restoring).
// Also note that it happens _before_ preInit (below).
$(document).on('stateLoadInit.dt', function (e, settings, state) {
    if (e.namespace !== 'dt') {
        return;
    }
    var dt = new DataTable.Api(settings);
    if (state.colReorder) {
        if (dt.ready()) {
            // Table is fully loaded - do the column reordering here
            // so that the stored indexes are in the correct place
            // e.g. column visibility
            setOrder(dt, state.colReorder, true);
        }
        else {
            // If the table is not ready, column reordering is done
            // after it becomes fully ready. That means that saved
            // column indexes need to be updated for where those columns
            // currently are.
            var map = invertKeyValues(state.colReorder);
            // State's ordering indexes
            orderingIndexes(map, state.order);
            // State's columns array - sort by restore index
            for (var i = 0; i < state.columns.length; i++) {
                state.columns[i]._cr_sort = state.colReorder[i];
            }
            state.columns.sort(function (a, b) {
                return a._cr_sort - b._cr_sort;
            });
        }
    }
});
$(document).on('preInit.dt', function (e, settings) {
    if (e.namespace !== 'dt') {
        return;
    }
    var init = settings.oInit.colReorder;
    var defaults = DataTable.defaults.colReorder;
    if (init || defaults) {
        var opts = $.extend({}, defaults, init);
        if (init !== false) {
            var dt = new DataTable.Api(settings);
            new ColReorder(dt, opts);
        }
    }
});


return DataTable;
}));


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-fixedheader-bs4/js/fixedHeader.bootstrap4.mjs":
/*!***********************************************************************************!*\
  !*** ./node_modules/datatables.net-fixedheader-bs4/js/fixedHeader.bootstrap4.mjs ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_fixedheader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-fixedheader */ "./node_modules/datatables.net-fixedheader/js/dataTables.fixedHeader.mjs");
/*! Bootstrap 4 styling wrapper for FixedHeader
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-fixedheader/js/dataTables.fixedHeader.mjs":
/*!*******************************************************************************!*\
  !*** ./node_modules/datatables.net-fixedheader/js/dataTables.fixedHeader.mjs ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! FixedHeader 4.0.1
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * @summary     FixedHeader
 * @description Fix a table's header or footer, so it is always visible while
 *              scrolling
 * @version     4.0.1
 * @author      SpryMedia Ltd
 * @contact     datatables.net
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

var _instCounter = 0;

var FixedHeader = function (dt, config) {
	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')) {
		throw 'Warning: FixedHeader requires DataTables 2 or newer';
	}

	// Sanity check - you just know it will happen
	if (!(this instanceof FixedHeader)) {
		throw "FixedHeader must be initialised with the 'new' keyword.";
	}

	// Allow a boolean true for defaults
	if (config === true) {
		config = {};
	}

	dt = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(dt);

	this.c = $.extend(true, {}, FixedHeader.defaults, config);

	this.s = {
		dt: dt,
		position: {
			theadTop: 0,
			tbodyTop: 0,
			tfootTop: 0,
			tfootBottom: 0,
			width: 0,
			left: 0,
			tfootHeight: 0,
			theadHeight: 0,
			windowHeight: $(window).height(),
			visible: true
		},
		headerMode: null,
		footerMode: null,
		autoWidth: dt.settings()[0].oFeatures.bAutoWidth,
		namespace: '.dtfc' + _instCounter++,
		scrollLeft: {
			header: -1,
			footer: -1
		},
		enable: true,
		autoDisable: false
	};

	this.dom = {
		floatingHeader: null,
		thead: $(dt.table().header()),
		tbody: $(dt.table().body()),
		tfoot: $(dt.table().footer()),
		header: {
			host: null,
			floating: null,
			floatingParent: $('<div class="dtfh-floatingparent"><div></div></div>'),
			placeholder: null
		},
		footer: {
			host: null,
			floating: null,
			floatingParent: $('<div class="dtfh-floatingparent"><div></div></div>'),
			placeholder: null
		}
	};

	this.dom.header.host = this.dom.thead.parent();
	this.dom.footer.host = this.dom.tfoot.parent();

	var dtSettings = dt.settings()[0];
	if (dtSettings._fixedHeader) {
		throw (
			'FixedHeader already initialised on table ' + dtSettings.nTable.id
		);
	}

	dtSettings._fixedHeader = this;

	this._constructor();
};

/*
 * Variable: FixedHeader
 * Purpose:  Prototype for FixedHeader
 * Scope:    global
 */
$.extend(FixedHeader.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * API methods
	 */

	/**
	 * Kill off FH and any events
	 */
	destroy: function () {
		var dom = this.dom;

		this.s.dt.off('.dtfc');
		$(window).off(this.s.namespace);

		// Remove clones of FC blockers
		if (dom.header.rightBlocker) {
			dom.header.rightBlocker.remove();
		}
		if (dom.header.leftBlocker) {
			dom.header.leftBlocker.remove();
		}
		if (dom.footer.rightBlocker) {
			dom.footer.rightBlocker.remove();
		}
		if (dom.footer.leftBlocker) {
			dom.footer.leftBlocker.remove();
		}

		if (this.c.header) {
			this._modeChange('in-place', 'header', true);
		}

		if (this.c.footer && dom.tfoot.length) {
			this._modeChange('in-place', 'footer', true);
		}
	},

	/**
	 * Enable / disable the fixed elements
	 *
	 * @param  {boolean} enable `true` to enable, `false` to disable
	 */
	enable: function (enable, update, type) {
		this.s.enable = enable;

		this.s.enableType = type;

		if (update || update === undefined) {
			this._positions();
			this._scroll(true);
		}
	},

	/**
	 * Get enabled status
	 */
	enabled: function () {
		return this.s.enable;
	},

	/**
	 * Set header offset
	 *
	 * @param  {int} new value for headerOffset
	 */
	headerOffset: function (offset) {
		if (offset !== undefined) {
			this.c.headerOffset = offset;
			this.update();
		}

		return this.c.headerOffset;
	},

	/**
	 * Set footer offset
	 *
	 * @param  {int} new value for footerOffset
	 */
	footerOffset: function (offset) {
		if (offset !== undefined) {
			this.c.footerOffset = offset;
			this.update();
		}

		return this.c.footerOffset;
	},

	/**
	 * Recalculate the position of the fixed elements and force them into place
	 */
	update: function (force) {
		var table = this.s.dt.table().node();

		// Update should only do something if enabled by the dev.
		if (!this.s.enable && !this.s.autoDisable) {
			return;
		}

		if ($(table).is(':visible')) {
			this.s.autoDisable = false;
			this.enable(true, false);
		}
		else {
			this.s.autoDisable = true;
			this.enable(false, false);
		}

		// Don't update if header is not in the document atm (due to
		// async events)
		if ($(table).children('thead').length === 0) {
			return;
		}

		this._positions();
		this._scroll(force !== undefined ? force : true);
		this._widths(this.dom.header);
		this._widths(this.dom.footer);
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */

	/**
	 * FixedHeader constructor - adding the required event listeners and
	 * simple initialisation
	 *
	 * @private
	 */
	_constructor: function () {
		var that = this;
		var dt = this.s.dt;

		$(window)
			.on('scroll' + this.s.namespace, function () {
				that._scroll();
			})
			.on(
				'resize' + this.s.namespace,
				datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.throttle(function () {
					that.s.position.windowHeight = $(window).height();
					that.update();
				}, 50)
			);

		var autoHeader = $('.fh-fixedHeader');
		if (!this.c.headerOffset && autoHeader.length) {
			this.c.headerOffset = autoHeader.outerHeight();
		}

		var autoFooter = $('.fh-fixedFooter');
		if (!this.c.footerOffset && autoFooter.length) {
			this.c.footerOffset = autoFooter.outerHeight();
		}

		dt.on(
			'column-reorder.dt.dtfc column-visibility.dt.dtfc column-sizing.dt.dtfc responsive-display.dt.dtfc',
			function (e, ctx) {
				that.update();
			}
		).on('draw.dt.dtfc', function (e, ctx) {
			// For updates from our own table, don't reclone, but for all others, do
			that.update(ctx === dt.settings()[0] ? false : true);
		});

		dt.on('destroy.dtfc', function () {
			that.destroy();
		});

		this._positions();
		this._scroll();
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Clone a fixed item to act as a place holder for the original element
	 * which is moved into a clone of the table element, and moved around the
	 * document to give the fixed effect.
	 *
	 * @param  {string}  item  'header' or 'footer'
	 * @param  {boolean} force Force the clone to happen, or allow automatic
	 *   decision (reuse existing if available)
	 * @private
	 */
	_clone: function (item, force) {
		var that = this;
		var dt = this.s.dt;
		var itemDom = this.dom[item];
		var itemElement = item === 'header' ? this.dom.thead : this.dom.tfoot;

		// If footer and scrolling is enabled then we don't clone
		// Instead the table's height is decreased accordingly - see `_scroll()`
		if (item === 'footer' && this._scrollEnabled()) {
			return;
		}

		if (!force && itemDom.floating) {
			// existing floating element - reuse it
			itemDom.floating.removeClass(
				'fixedHeader-floating fixedHeader-locked'
			);
		}
		else {
			if (itemDom.floating) {
				if (itemDom.placeholder !== null) {
					itemDom.placeholder.remove();
				}

				itemDom.floating.children().detach();
				itemDom.floating.remove();
			}

			var tableNode = $(dt.table().node());
			var scrollBody = $(tableNode.parent());
			var scrollEnabled = this._scrollEnabled();

			itemDom.floating = $(dt.table().node().cloneNode(false))
				.attr('aria-hidden', 'true')
				.css({
					top: 0,
					left: 0
				})
				.removeAttr('id');

			itemDom.floatingParent
				.css({
					width: scrollBody[0].offsetWidth,
					overflow: 'hidden',
					height: 'fit-content',
					position: 'fixed',
					left: scrollEnabled
						? tableNode.offset().left + scrollBody.scrollLeft()
						: 0
				})
				.css(
					item === 'header'
						? {
								top: this.c.headerOffset,
								bottom: ''
						}
						: {
								top: '',
								bottom: this.c.footerOffset
						}
				)
				.addClass(
					item === 'footer'
						? 'dtfh-floatingparent-foot'
						: 'dtfh-floatingparent-head'
				)
				.appendTo('body')
				.children()
				.eq(0)
				.append(itemDom.floating);

			this._stickyPosition(itemDom.floating, '-');

			var scrollLeftUpdate = function () {
				var scrollLeft = scrollBody.scrollLeft();
				that.s.scrollLeft = { footer: scrollLeft, header: scrollLeft };
				itemDom.floatingParent.scrollLeft(that.s.scrollLeft.header);
			};

			scrollLeftUpdate();
			scrollBody.off('scroll.dtfh').on('scroll.dtfh', scrollLeftUpdate);

			// Need padding on the header's container to allow for a scrollbar,
			// just like how DataTables handles it
			itemDom.floatingParent.children().css({
				width: 'fit-content',
				paddingRight: that.s.dt.settings()[0].oBrowser.barWidth
			});

			// Blocker to hide the table behind the scrollbar - this needs to use
			// fixed positioning in the container since we don't have an outer wrapper
			let blocker = $(
				item === 'footer'
					? 'div.dtfc-bottom-blocker'
					: 'div.dtfc-top-blocker',
				dt.table().container()
			);

			if (blocker.length) {
				blocker
					.clone()
					.appendTo(itemDom.floatingParent)
					.css({
						position: 'fixed',
						right: blocker.width()
					});
			}

			// Insert a fake thead/tfoot into the DataTable to stop it jumping around
			itemDom.placeholder = itemElement.clone(false);
			itemDom.placeholder.find('*[id]').removeAttr('id');

			// Move the thead / tfoot elements around - original into the floating
			// element and clone into the original table
			itemDom.host.prepend(itemDom.placeholder);
			itemDom.floating.append(itemElement);

			this._widths(itemDom);
		}
	},

	/**
	 * This method sets the sticky position of the header elements to match fixed columns
	 * @param {JQuery<HTMLElement>} el
	 * @param {string} sign
	 */
	_stickyPosition: function (el, sign) {
		if (this._scrollEnabled()) {
			var that = this;
			var rtl = $(that.s.dt.table().node()).css('direction') === 'rtl';

			el.find('th').each(function () {
				// Find out if fixed header has previously set this column
				if ($(this).css('position') === 'sticky') {
					var right = $(this).css('right');
					var left = $(this).css('left');
					var potential;

					if (right !== 'auto' && !rtl) {
						potential = +right.replace(/px/g, '')

						$(this).css('right', potential > 0 ? potential : 0);
					}
					else if (left !== 'auto' && rtl) {
						potential = +left.replace(/px/g, '');

						$(this).css('left', potential > 0 ? potential : 0);
					}
				}
			});
		}
	},

	/**
	 * Reposition the floating elements to take account of horizontal page
	 * scroll
	 *
	 * @param  {string} item       The `header` or `footer`
	 * @param  {int}    scrollLeft Document scrollLeft
	 * @private
	 */
	_horizontal: function (item, scrollLeft) {
		var itemDom = this.dom[item];
		var lastScrollLeft = this.s.scrollLeft;

		if (itemDom.floating && lastScrollLeft[item] !== scrollLeft) {
			// If scrolling is enabled we need to match the floating header to the body
			if (this._scrollEnabled()) {
				var newScrollLeft = $(
					$(this.s.dt.table().node()).parent()
				).scrollLeft();
				itemDom.floating.scrollLeft(newScrollLeft);
				itemDom.floatingParent.scrollLeft(newScrollLeft);
			}

			lastScrollLeft[item] = scrollLeft;
		}
	},

	/**
	 * Change from one display mode to another. Each fixed item can be in one
	 * of:
	 *
	 * * `in-place` - In the main DataTable
	 * * `in` - Floating over the DataTable
	 * * `below` - (Header only) Fixed to the bottom of the table body
	 * * `above` - (Footer only) Fixed to the top of the table body
	 *
	 * @param  {string}  mode        Mode that the item should be shown in
	 * @param  {string}  item        'header' or 'footer'
	 * @param  {boolean} forceChange Force a redraw of the mode, even if already
	 *     in that mode.
	 * @private
	 */
	_modeChange: function (mode, item, forceChange) {
		var itemDom = this.dom[item];
		var position = this.s.position;

		// Just determine if scroll is enabled once
		var scrollEnabled = this._scrollEnabled();

		// If footer and scrolling is enabled then we don't clone
		// Instead the table's height is decreased accordingly - see `_scroll()`
		if (item === 'footer' && scrollEnabled) {
			return;
		}

		// It isn't trivial to add a !important css attribute...
		var importantWidth = function (w) {
			itemDom.floating[0].style.setProperty('width', w + 'px', 'important');

			// If not scrolling also have to update the floatingParent
			if (!scrollEnabled) {
				itemDom.floatingParent[0].style.setProperty('width', w + 'px', 'important');
			}
		};

		// Record focus. Browser's will cause input elements to loose focus if
		// they are inserted else where in the doc
		var tablePart = this.dom[item === 'footer' ? 'tfoot' : 'thead'];
		var focus = $.contains(tablePart[0], document.activeElement)
			? document.activeElement
			: null;
		var scrollBody = $($(this.s.dt.table().node()).parent());

		if (mode === 'in-place') {
			// Insert the header back into the table's real header
			if (itemDom.placeholder) {
				itemDom.placeholder.remove();
				itemDom.placeholder = null;
			}

			if (item === 'header') {
				itemDom.host.prepend(tablePart);
			}
			else {
				itemDom.host.append(tablePart);
			}

			if (itemDom.floating) {
				itemDom.floating.remove();
				itemDom.floating = null;
				this._stickyPosition(itemDom.host, '+');
			}

			if (itemDom.floatingParent) {
				itemDom.floatingParent.find('div.dtfc-top-blocker').remove();
				itemDom.floatingParent.remove();
			}

			$($(itemDom.host.parent()).parent()).scrollLeft(
				scrollBody.scrollLeft()
			);
		}
		else if (mode === 'in') {
			// Remove the header from the real table and insert into a fixed
			// positioned floating table clone
			this._clone(item, forceChange);

			// Get useful position values
			var scrollOffset = scrollBody.offset();
			var windowTop = $(document).scrollTop();
			var windowHeight = $(window).height();
			var windowBottom = windowTop + windowHeight;
			var bodyTop = scrollEnabled ? scrollOffset.top : position.tbodyTop;
			var bodyBottom = scrollEnabled
				? scrollOffset.top + scrollBody.outerHeight()
				: position.tfootTop;

			// Calculate the amount that the footer or header needs to be shuffled
			var shuffle;

			if (item === 'footer') {
				shuffle =
					bodyTop > windowBottom
						? position.tfootHeight // Yes - push the footer below
						: bodyTop + position.tfootHeight - windowBottom; // No
			}
			else {
				// Otherwise must be a header so get the difference from the bottom of the
				//  desired floating header and the bottom of the table body
				shuffle =
					windowTop +
					this.c.headerOffset +
					position.theadHeight -
					bodyBottom;
			}

			// Set the top or bottom based off of the offset and the shuffle value
			var prop = item === 'header' ? 'top' : 'bottom';
			var val = this.c[item + 'Offset'] - (shuffle > 0 ? shuffle : 0);

			itemDom.floating.addClass('fixedHeader-floating');
			itemDom.floatingParent
				.css(prop, val)
				.css({
					left: position.left,
					'z-index': 3
				});

			importantWidth(position.width);

			if (item === 'footer') {
				itemDom.floating.css('top', '');
			}
		}
		else if (mode === 'below') {
			// only used for the header
			// Fix the position of the floating header at base of the table body
			this._clone(item, forceChange);

			itemDom.floating.addClass('fixedHeader-locked');
			itemDom.floatingParent.css({
				position: 'absolute',
				top: position.tfootTop - position.theadHeight,
				left: position.left + 'px'
			});

			importantWidth(position.width);
		}
		else if (mode === 'above') {
			// only used for the footer
			// Fix the position of the floating footer at top of the table body
			this._clone(item, forceChange);

			itemDom.floating.addClass('fixedHeader-locked');
			itemDom.floatingParent.css({
				position: 'absolute',
				top: position.tbodyTop,
				left: position.left + 'px'
			});

			importantWidth(position.width);
		}

		// Restore focus if it was lost
		if (focus && focus !== document.activeElement) {
			setTimeout(function () {
				focus.focus();
			}, 10);
		}

		this.s.scrollLeft.header = -1;
		this.s.scrollLeft.footer = -1;
		this.s[item + 'Mode'] = mode;
	},

	/**
	 * Cache the positional information that is required for the mode
	 * calculations that FixedHeader performs.
	 *
	 * @private
	 */
	_positions: function () {
		var dt = this.s.dt;
		var table = dt.table();
		var position = this.s.position;
		var dom = this.dom;
		var tableNode = $(table.node());
		var scrollEnabled = this._scrollEnabled();

		// Need to use the header and footer that are in the main table,
		// regardless of if they are clones, since they hold the positions we
		// want to measure from
		var thead = $(dt.table().header());
		var tfoot = $(dt.table().footer());
		var tbody = dom.tbody;
		var scrollBody = tableNode.parent();

		position.visible = tableNode.is(':visible');
		position.width = tableNode.outerWidth();
		position.left = tableNode.offset().left;
		position.theadTop = thead.offset().top;
		position.tbodyTop = scrollEnabled
			? scrollBody.offset().top
			: tbody.offset().top;
		position.tbodyHeight = scrollEnabled
			? scrollBody.outerHeight()
			: tbody.outerHeight();
		position.theadHeight = thead.outerHeight();
		position.theadBottom = position.theadTop + position.theadHeight;
		position.tfootTop = position.tbodyTop + position.tbodyHeight; //tfoot.offset().top;

		if (tfoot.length) {
			position.tfootBottom = position.tfootTop + tfoot.outerHeight();
			position.tfootHeight = tfoot.outerHeight();
		}
		else {
			position.tfootBottom = position.tfootTop;
			position.tfootHeight = 0;
		}
	},

	/**
	 * Mode calculation - determine what mode the fixed items should be placed
	 * into.
	 *
	 * @param  {boolean} forceChange Force a redraw of the mode, even if already
	 *     in that mode.
	 * @private
	 */
	_scroll: function (forceChange) {
		if (this.s.dt.settings()[0].bDestroying) {
			return;
		}

		// ScrollBody details
		var scrollEnabled = this._scrollEnabled();
		var scrollBody = $(this.s.dt.table().node()).parent();
		var scrollOffset = scrollBody.offset();
		var scrollHeight = scrollBody.outerHeight();

		// Window details
		var windowLeft = $(document).scrollLeft();
		var windowTop = $(document).scrollTop();
		var windowHeight = $(window).height();
		var windowBottom = windowHeight + windowTop;

		var position = this.s.position;
		var headerMode, footerMode;

		// Body Details
		var bodyTop = scrollEnabled ? scrollOffset.top : position.tbodyTop;
		var bodyLeft = scrollEnabled ? scrollOffset.left : position.left;
		var bodyBottom = scrollEnabled
			? scrollOffset.top + scrollHeight
			: position.tfootTop;
		var bodyWidth = scrollEnabled
			? scrollBody.outerWidth()
			: position.tbodyWidth;

		if (this.c.header) {
			if (!this.s.enable) {
				headerMode = 'in-place';
			}
			// The header is in it's normal place if the body top is lower than
			//  the scroll of the window plus the headerOffset and the height of the header
			else if (
				!position.visible ||
				windowTop + this.c.headerOffset + position.theadHeight <=
					bodyTop
			) {
				headerMode = 'in-place';
			}
			// The header should be floated if
			else if (
				// The scrolling plus the header offset plus the height of the header is lower than the top of the body
				windowTop + this.c.headerOffset + position.theadHeight >
					bodyTop &&
				// And the scrolling at the top plus the header offset is above the bottom of the body
				windowTop + this.c.headerOffset + position.theadHeight <
					bodyBottom
			) {
				headerMode = 'in';

				// Further to the above, If the scrolling plus the header offset plus the header height is lower
				// than the bottom of the table a shuffle is required so have to force the calculation
				if (
					windowTop + this.c.headerOffset + position.theadHeight >
						bodyBottom ||
					this.dom.header.floatingParent === undefined
				) {
					forceChange = true;
				}
				else {
					this.dom.header.floatingParent
						.css({
							top: this.c.headerOffset,
							position: 'fixed'
						})
						.children()
						.eq(0)
						.append(this.dom.header.floating);
				}
			}
			// Anything else and the view is below the table
			else {
				headerMode = 'below';
			}

			if (forceChange || headerMode !== this.s.headerMode) {
				this._modeChange(headerMode, 'header', forceChange);
			}

			this._horizontal('header', windowLeft);
		}

		var header = {
			offset: { top: 0, left: 0 },
			height: 0
		};
		var footer = {
			offset: { top: 0, left: 0 },
			height: 0
		};

		if (
			this.c.footer &&
			this.dom.tfoot.length &&
			this.dom.tfoot.find('th, td').length
		) {
			if (!this.s.enable) {
				footerMode = 'in-place';
			}
			else if (
				!position.visible ||
				position.tfootBottom + this.c.footerOffset <= windowBottom
			) {
				footerMode = 'in-place';
			}
			else if (
				bodyBottom + position.tfootHeight + this.c.footerOffset >
					windowBottom &&
				bodyTop + this.c.footerOffset < windowBottom
			) {
				footerMode = 'in';
				forceChange = true;
			}
			else {
				footerMode = 'above';
			}

			if (forceChange || footerMode !== this.s.footerMode) {
				this._modeChange(footerMode, 'footer', forceChange);
			}

			this._horizontal('footer', windowLeft);

			var getOffsetHeight = function (el) {
				return {
					offset: el.offset(),
					height: el.outerHeight()
				};
			};

			header = this.dom.header.floating
				? getOffsetHeight(this.dom.header.floating)
				: getOffsetHeight(this.dom.thead);
			footer = this.dom.footer.floating
				? getOffsetHeight(this.dom.footer.floating)
				: getOffsetHeight(this.dom.tfoot);

			// If scrolling is enabled and the footer is off the screen
			if (scrollEnabled && footer.offset.top > windowTop) {
				// && footer.offset.top >= windowBottom) {
				// Calculate the gap between the top of the scrollBody and the top of the window
				var overlap = windowTop - scrollOffset.top;
				// The new height is the bottom of the window
				var newHeight =
					windowBottom +
					// If the gap between the top of the scrollbody and the window is more than
					//  the height of the header then the top of the table is still visible so add that gap
					// Doing this has effectively calculated the height from the top of the table to the bottom of the current page
					(overlap > -header.height ? overlap : 0) -
					// Take from that
					// The top of the header plus
					(header.offset.top +
						// The header height if the standard header is present
						(overlap < -header.height ? header.height : 0) +
						// And the height of the footer
						footer.height);

				// Don't want a negative height
				if (newHeight < 0) {
					newHeight = 0;
				}

				// At the end of the above calculation the space between the header (top of the page if floating)
				// and the point just above the footer should be the new value for the height of the table.
				scrollBody.outerHeight(newHeight);

				// Need some rounding here as sometimes very small decimal places are encountered
				// If the actual height is bigger or equal to the height we just applied then the footer is "Floating"
				if (
					Math.round(scrollBody.outerHeight()) >=
					Math.round(newHeight)
				) {
					$(this.dom.tfoot.parent()).addClass('fixedHeader-floating');
				}
				// Otherwise max-width has kicked in so it is not floating
				else {
					$(this.dom.tfoot.parent()).removeClass(
						'fixedHeader-floating'
					);
				}
			}
		}

		if (this.dom.header.floating) {
			this.dom.header.floatingParent.css('left', bodyLeft - windowLeft);
		}
		if (this.dom.footer.floating) {
			this.dom.footer.floatingParent.css('left', bodyLeft - windowLeft);
		}

		// If fixed columns is being used on this table then the blockers need to be copied across
		// Cloning these is cleaner than creating as our own as it will keep consistency with fixedColumns automatically
		// ASSUMING that the class remains the same
		if (this.s.dt.settings()[0]._fixedColumns !== undefined) {
			var adjustBlocker = function (side, end, el) {
				if (el === undefined) {
					var blocker = $(
						'div.dtfc-' + side + '-' + end + '-blocker'
					);

					el =
						blocker.length === 0
							? null
							: blocker.clone().css('z-index', 1);
				}

				if (el !== null) {
					if (headerMode === 'in' || headerMode === 'below') {
						el.appendTo('body').css({
							top:
								end === 'top'
									? header.offset.top
									: footer.offset.top,
							left:
								side === 'right'
									? bodyLeft + bodyWidth - el.width()
									: bodyLeft
						});
					}
					else {
						el.detach();
					}
				}

				return el;
			};

			// Adjust all blockers
			this.dom.header.rightBlocker = adjustBlocker(
				'right',
				'top',
				this.dom.header.rightBlocker
			);
			this.dom.header.leftBlocker = adjustBlocker(
				'left',
				'top',
				this.dom.header.leftBlocker
			);
			this.dom.footer.rightBlocker = adjustBlocker(
				'right',
				'bottom',
				this.dom.footer.rightBlocker
			);
			this.dom.footer.leftBlocker = adjustBlocker(
				'left',
				'bottom',
				this.dom.footer.leftBlocker
			);
		}
	},

	/**
	 * Function to check if scrolling is enabled on the table or not
	 * @returns Boolean value indicating if scrolling on the table is enabled or not
	 */
	_scrollEnabled: function () {
		var oScroll = this.s.dt.settings()[0].oScroll;
		if (oScroll.sY !== '' || oScroll.sX !== '') {
			return true;
		}
		return false;
	},

	/**
	 * Realign columns by using the colgroup tag and
	 * checking column widths
	 */
	_widths: function (itemDom) {
		if (! itemDom || ! itemDom.placeholder) {
			return;
		}

		// Match the table overall width
		var tableNode = $(this.s.dt.table().node());
		var scrollBody = $(tableNode.parent());

		itemDom.floatingParent.css('width', scrollBody[0].offsetWidth);
		itemDom.floating.css('width', tableNode[0].offsetWidth);

		// Strip out the old colgroup
		$('colgroup', itemDom.floating).remove();

		// Copy the `colgroup` element to define the number of columns - needed
		// for complex header cases where a column might not have a unique
		// header
		var cols = itemDom.placeholder
			.parent()
			.find('colgroup')
			.clone()
			.appendTo(itemDom.floating)
			.find('col');

		// However, the widths defined in the colgroup from the DataTable might
		// not exactly reflect the actual widths of the columns (content can
		// force it to stretch). So we need to copy the actual widths into the
		// colgroup / col's used for the floating header.
		var widths = this.s.dt.columns(':visible').widths();

		for (var i=0 ; i<widths.length ; i++) {
			cols.eq(i).css('width', widths[i]);
		}
	}
});

/**
 * Version
 * @type {String}
 * @static
 */
FixedHeader.version = '4.0.1';

/**
 * Defaults
 * @type {Object}
 * @static
 */
FixedHeader.defaults = {
	header: true,
	footer: false,
	headerOffset: 0,
	footerOffset: 0
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables interfaces
 */

// Attach for constructor access
$.fn.dataTable.FixedHeader = FixedHeader;
$.fn.DataTable.FixedHeader = FixedHeader;

// DataTables creation - check if the FixedHeader option has been defined on the
// table and if so, initialise
$(document).on('init.dt.dtfh', function (e, settings, json) {
	if (e.namespace !== 'dt') {
		return;
	}

	var init = settings.oInit.fixedHeader;
	var defaults = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.fixedHeader;

	if ((init || defaults) && !settings._fixedHeader) {
		var opts = $.extend({}, defaults, init);

		if (init !== false) {
			new FixedHeader(settings, opts);
		}
	}
});

// DataTables API methods
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader()', function () { });

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader.adjust()', function () {
	return this.iterator('table', function (ctx) {
		var fh = ctx._fixedHeader;

		if (fh) {
			fh.update();
		}
	});
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader.enable()', function (flag) {
	return this.iterator('table', function (ctx) {
		var fh = ctx._fixedHeader;

		flag = flag !== undefined ? flag : true;
		if (fh && flag !== fh.enabled()) {
			fh.enable(flag);
		}
	});
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader.enabled()', function () {
	if (this.context.length) {
		var fh = this.context[0]._fixedHeader;

		if (fh) {
			return fh.enabled();
		}
	}

	return false;
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader.disable()', function () {
	return this.iterator('table', function (ctx) {
		var fh = ctx._fixedHeader;

		if (fh && fh.enabled()) {
			fh.enable(false);
		}
	});
});

$.each(['header', 'footer'], function (i, el) {
	datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('fixedHeader.' + el + 'Offset()', function (offset) {
		var ctx = this.context;

		if (offset === undefined) {
			return ctx.length && ctx[0]._fixedHeader
				? ctx[0]._fixedHeader[el + 'Offset']()
				: undefined;
		}

		return this.iterator('table', function (ctx) {
			var fh = ctx._fixedHeader;

			if (fh) {
				fh[el + 'Offset'](offset);
			}
		});
	});
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-responsive-bs4/js/responsive.bootstrap4.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/datatables.net-responsive-bs4/js/responsive.bootstrap4.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_responsive__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-responsive */ "./node_modules/datatables.net-responsive/js/dataTables.responsive.mjs");
/*! Bootstrap 4 integration for DataTables' Responsive
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


var _display = datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"].Responsive.display;
var _original = _display.modal;
var _modal = $(
	'<div class="modal fade dtr-bs-modal" role="dialog">' +
		'<div class="modal-dialog" role="document">' +
		'<div class="modal-content">' +
		'<div class="modal-header">' +
		'<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>' +
		'</div>' +
		'<div class="modal-body"/>' +
		'</div>' +
		'</div>' +
		'</div>'
);

_display.modal = function (options) {
	return function (row, update, render, closeCallback) {
		if (!$.fn.modal) {
			return _original(row, update, render, closeCallback);
		}
		else {
			var rendered = render();

			if (rendered === false) {
				return false;
			}

			if (!update) {
				if (options && options.header) {
					var header = _modal.find('div.modal-header');
					var button = header.find('button').detach();

					header
						.empty()
						.append('<h4 class="modal-title">' + options.header(row) + '</h4>')
						.append(button);
				}

				_modal.find('div.modal-body').empty().append(rendered);

				_modal
					.data('dtr-row-idx', row.index())
					.one('hidden.bs.modal', closeCallback)
					.appendTo('body')
					.modal();
			}
			else {
				if ($.contains(document, _modal[0]) && row.index() === _modal.data('dtr-row-idx')) {
					_modal.find('div.modal-body').empty().append(rendered);
				}
				else {
					// Modal not shown - do nothing
					return null;
				}
			}

			return true;
		}
	};
};


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-responsive/js/dataTables.responsive.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/datatables.net-responsive/js/dataTables.responsive.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! Responsive 3.0.1
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * @summary     Responsive
 * @description Responsive tables plug-in for DataTables
 * @version     3.0.1
 * @author      SpryMedia Ltd
 * @copyright   SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

/**
 * Responsive is a plug-in for the DataTables library that makes use of
 * DataTables' ability to change the visibility of columns, changing the
 * visibility of columns so the displayed columns fit into the table container.
 * The end result is that complex tables will be dynamically adjusted to fit
 * into the viewport, be it on a desktop, tablet or mobile browser.
 *
 * Responsive for DataTables has two modes of operation, which can used
 * individually or combined:
 *
 * * Class name based control - columns assigned class names that match the
 *   breakpoint logic can be shown / hidden as required for each breakpoint.
 * * Automatic control - columns are automatically hidden when there is no
 *   room left to display them. Columns removed from the right.
 *
 * In additional to column visibility control, Responsive also has built into
 * options to use DataTables' child row display to show / hide the information
 * from the table that has been hidden. There are also two modes of operation
 * for this child row display:
 *
 * * Inline - when the control element that the user can use to show / hide
 *   child rows is displayed inside the first column of the table.
 * * Column - where a whole column is dedicated to be the show / hide control.
 *
 * Initialisation of Responsive is performed by:
 *
 * * Adding the class `responsive` or `dt-responsive` to the table. In this case
 *   Responsive will automatically be initialised with the default configuration
 *   options when the DataTable is created.
 * * Using the `responsive` option in the DataTables configuration options. This
 *   can also be used to specify the configuration options, or simply set to
 *   `true` to use the defaults.
 *
 *  @class
 *  @param {object} settings DataTables settings object for the host table
 *  @param {object} [opts] Configuration options
 *  @requires jQuery 1.7+
 *  @requires DataTables 1.10.3+
 *
 *  @example
 *      $('#example').DataTable( {
 *        responsive: true
 *      } );
 *    } );
 */
var Responsive = function (settings, opts) {
	// Sanity check that we are using DataTables 1.10 or newer
	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck || !datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')) {
		throw 'DataTables Responsive requires DataTables 2 or newer';
	}

	this.s = {
		childNodeStore: {},
		columns: [],
		current: [],
		dt: new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(settings)
	};

	// Check if responsive has already been initialised on this table
	if (this.s.dt.settings()[0].responsive) {
		return;
	}

	// details is an object, but for simplicity the user can give it as a string
	// or a boolean
	if (opts && typeof opts.details === 'string') {
		opts.details = { type: opts.details };
	}
	else if (opts && opts.details === false) {
		opts.details = { type: false };
	}
	else if (opts && opts.details === true) {
		opts.details = { type: 'inline' };
	}

	this.c = $.extend(
		true,
		{},
		Responsive.defaults,
		datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.responsive,
		opts
	);
	settings.responsive = this;
	this._constructor();
};

$.extend(Responsive.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */

	/**
	 * Initialise the Responsive instance
	 *
	 * @private
	 */
	_constructor: function () {
		var that = this;
		var dt = this.s.dt;
		var oldWindowWidth = $(window).innerWidth();

		dt.settings()[0]._responsive = this;

		// Use DataTables' throttle function to avoid processor thrashing
		$(window).on(
			'orientationchange.dtr',
			datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.throttle(function () {
				// iOS has a bug whereby resize can fire when only scrolling
				// See: http://stackoverflow.com/questions/8898412
				var width = $(window).innerWidth();

				if (width !== oldWindowWidth) {
					that._resize();
					oldWindowWidth = width;
				}
			})
		);

		// Handle new rows being dynamically added - needed as responsive
		// updates all rows (shown or not) a responsive change, rather than
		// per draw.
		dt.on('row-created.dtr', function (e, tr, data, idx) {
			if ($.inArray(false, that.s.current) !== -1) {
				$('>td, >th', tr).each(function (i) {
					var idx = dt.column.index('toData', i);

					if (that.s.current[idx] === false) {
						$(this).css('display', 'none');
					}
				});
			}
		});

		// Destroy event handler
		dt.on('destroy.dtr', function () {
			dt.off('.dtr');
			$(dt.table().body()).off('.dtr');
			$(window).off('resize.dtr orientationchange.dtr');
			dt.cells('.dtr-control').nodes().to$().removeClass('dtr-control');
			$(dt.table().node()).removeClass('dtr-inline collapsed');

			// Restore the columns that we've hidden
			$.each(that.s.current, function (i, val) {
				if (val === false) {
					that._setColumnVis(i, true);
				}
			});
		});

		// Reorder the breakpoints array here in case they have been added out
		// of order
		this.c.breakpoints.sort(function (a, b) {
			return a.width < b.width ? 1 : a.width > b.width ? -1 : 0;
		});

		this._classLogic();
		this._resizeAuto();

		// Details handler
		var details = this.c.details;

		if (details.type !== false) {
			that._detailsInit();

			// DataTables will trigger this event on every column it shows and
			// hides individually
			dt.on('column-visibility.dtr', function () {
				// Use a small debounce to allow multiple columns to be set together
				if (that._timer) {
					clearTimeout(that._timer);
				}

				that._timer = setTimeout(function () {
					that._timer = null;

					that._classLogic();
					that._resizeAuto();
					that._resize(true);

					that._redrawChildren();
				}, 100);
			});

			// Redraw the details box on each draw which will happen if the data
			// has changed. This is used until DataTables implements a native
			// `updated` event for rows
			dt.on('draw.dtr', function () {
				that._redrawChildren();
			});

			$(dt.table().node()).addClass('dtr-' + details.type);
		}

		dt.on('column-reorder.dtr', function (e, settings, details) {
			that._classLogic();
			that._resizeAuto();
			that._resize(true);
		});

		// Change in column sizes means we need to calc
		dt.on('column-sizing.dtr', function () {
			that._resizeAuto();
			that._resize();
		});

		// DT2 let's us tell it if we are hiding columns
		dt.on('column-calc.dt', function (e, d) {
			var curr = that.s.current;

			for (var i = 0; i < curr.length; i++) {
				var idx = d.visible.indexOf(i);

				if (curr[i] === false && idx >= 0) {
					d.visible.splice(idx, 1);
				}
			}
		});

		// On Ajax reload we want to reopen any child rows which are displayed
		// by responsive
		dt.on('preXhr.dtr', function () {
			var rowIds = [];
			dt.rows().every(function () {
				if (this.child.isShown()) {
					rowIds.push(this.id(true));
				}
			});

			dt.one('draw.dtr', function () {
				that._resizeAuto();
				that._resize();

				dt.rows(rowIds).every(function () {
					that._detailsDisplay(this, false);
				});
			});
		});

		dt.on('draw.dtr', function () {
			that._controlClass();
		}).on('init.dtr', function (e, settings, details) {
			if (e.namespace !== 'dt') {
				return;
			}

			that._resizeAuto();
			that._resize();

			// If columns were hidden, then DataTables needs to adjust the
			// column sizing
			if ($.inArray(false, that.s.current)) {
				dt.columns.adjust();
			}
		});

		// First pass - draw the table for the current viewport size
		this._resize();
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Get and store nodes from a cell - use for node moving renderers
	 *
	 * @param {*} dt DT instance
	 * @param {*} row Row index
	 * @param {*} col Column index
	 */
	_childNodes: function (dt, row, col) {
		var name = row + '-' + col;

		if (this.s.childNodeStore[name]) {
			return this.s.childNodeStore[name];
		}

		// https://jsperf.com/childnodes-array-slice-vs-loop
		var nodes = [];
		var children = dt.cell(row, col).node().childNodes;
		for (var i = 0, ien = children.length; i < ien; i++) {
			nodes.push(children[i]);
		}

		this.s.childNodeStore[name] = nodes;

		return nodes;
	},

	/**
	 * Restore nodes from the cache to a table cell
	 *
	 * @param {*} dt DT instance
	 * @param {*} row Row index
	 * @param {*} col Column index
	 */
	_childNodesRestore: function (dt, row, col) {
		var name = row + '-' + col;

		if (!this.s.childNodeStore[name]) {
			return;
		}

		var node = dt.cell(row, col).node();
		var store = this.s.childNodeStore[name];
		if (store.length > 0) {
			var parent = store[0].parentNode;
			var parentChildren = parent.childNodes;
			var a = [];

			for (var i = 0, ien = parentChildren.length; i < ien; i++) {
				a.push(parentChildren[i]);
			}

			for (var j = 0, jen = a.length; j < jen; j++) {
				node.appendChild(a[j]);
			}
		}

		this.s.childNodeStore[name] = undefined;
	},

	/**
	 * Calculate the visibility for the columns in a table for a given
	 * breakpoint. The result is pre-determined based on the class logic if
	 * class names are used to control all columns, but the width of the table
	 * is also used if there are columns which are to be automatically shown
	 * and hidden.
	 *
	 * @param  {string} breakpoint Breakpoint name to use for the calculation
	 * @return {array} Array of boolean values initiating the visibility of each
	 *   column.
	 *  @private
	 */
	_columnsVisiblity: function (breakpoint) {
		var dt = this.s.dt;
		var columns = this.s.columns;
		var i, ien;

		// Create an array that defines the column ordering based first on the
		// column's priority, and secondly the column index. This allows the
		// columns to be removed from the right if the priority matches
		var order = columns
			.map(function (col, idx) {
				return {
					columnIdx: idx,
					priority: col.priority
				};
			})
			.sort(function (a, b) {
				if (a.priority !== b.priority) {
					return a.priority - b.priority;
				}
				return a.columnIdx - b.columnIdx;
			});

		// Class logic - determine which columns are in this breakpoint based
		// on the classes. If no class control (i.e. `auto`) then `-` is used
		// to indicate this to the rest of the function
		var display = $.map(columns, function (col, i) {
			if (dt.column(i).visible() === false) {
				return 'not-visible';
			}
			return col.auto && col.minWidth === null
				? false
				: col.auto === true
				? '-'
				: $.inArray(breakpoint, col.includeIn) !== -1;
		});

		// Auto column control - first pass: how much width is taken by the
		// ones that must be included from the non-auto columns
		var requiredWidth = 0;
		for (i = 0, ien = display.length; i < ien; i++) {
			if (display[i] === true) {
				requiredWidth += columns[i].minWidth;
			}
		}

		// Second pass, use up any remaining width for other columns. For
		// scrolling tables we need to subtract the width of the scrollbar. It
		// may not be requires which makes this sub-optimal, but it would
		// require another full redraw to make complete use of those extra few
		// pixels
		var scrolling = dt.settings()[0].oScroll;
		var bar = scrolling.sY || scrolling.sX ? scrolling.iBarWidth : 0;
		var widthAvailable = dt.table().container().offsetWidth - bar;
		var usedWidth = widthAvailable - requiredWidth;

		// Control column needs to always be included. This makes it sub-
		// optimal in terms of using the available with, but to stop layout
		// thrashing or overflow. Also we need to account for the control column
		// width first so we know how much width is available for the other
		// columns, since the control column might not be the first one shown
		for (i = 0, ien = display.length; i < ien; i++) {
			if (columns[i].control) {
				usedWidth -= columns[i].minWidth;
			}
		}

		// Allow columns to be shown (counting by priority and then right to
		// left) until we run out of room
		var empty = false;
		for (i = 0, ien = order.length; i < ien; i++) {
			var colIdx = order[i].columnIdx;

			if (
				display[colIdx] === '-' &&
				!columns[colIdx].control &&
				columns[colIdx].minWidth
			) {
				// Once we've found a column that won't fit we don't let any
				// others display either, or columns might disappear in the
				// middle of the table
				if (empty || usedWidth - columns[colIdx].minWidth < 0) {
					empty = true;
					display[colIdx] = false;
				}
				else {
					display[colIdx] = true;
				}

				usedWidth -= columns[colIdx].minWidth;
			}
		}

		// Determine if the 'control' column should be shown (if there is one).
		// This is the case when there is a hidden column (that is not the
		// control column). The two loops look inefficient here, but they are
		// trivial and will fly through. We need to know the outcome from the
		// first , before the action in the second can be taken
		var showControl = false;

		for (i = 0, ien = columns.length; i < ien; i++) {
			if (
				!columns[i].control &&
				!columns[i].never &&
				display[i] === false
			) {
				showControl = true;
				break;
			}
		}

		for (i = 0, ien = columns.length; i < ien; i++) {
			if (columns[i].control) {
				display[i] = showControl;
			}

			// Replace not visible string with false from the control column detection above
			if (display[i] === 'not-visible') {
				display[i] = false;
			}
		}

		// Finally we need to make sure that there is at least one column that
		// is visible
		if ($.inArray(true, display) === -1) {
			display[0] = true;
		}

		return display;
	},

	/**
	 * Create the internal `columns` array with information about the columns
	 * for the table. This includes determining which breakpoints the column
	 * will appear in, based upon class names in the column, which makes up the
	 * vast majority of this method.
	 *
	 * @private
	 */
	_classLogic: function () {
		var that = this;
		var breakpoints = this.c.breakpoints;
		var dt = this.s.dt;
		var columns = dt
			.columns()
			.eq(0)
			.map(function (i) {
				var column = this.column(i);
				var className = column.header().className;
				var priority = column.init().responsivePriority;
				var dataPriority = column
					.header()
					.getAttribute('data-priority');

				if (priority === undefined) {
					priority =
						dataPriority === undefined || dataPriority === null
							? 10000
							: dataPriority * 1;
				}

				return {
					className: className,
					includeIn: [],
					auto: false,
					control: false,
					never: className.match(/\b(dtr\-)?never\b/) ? true : false,
					priority: priority
				};
			});

		// Simply add a breakpoint to `includeIn` array, ensuring that there are
		// no duplicates
		var add = function (colIdx, name) {
			var includeIn = columns[colIdx].includeIn;

			if ($.inArray(name, includeIn) === -1) {
				includeIn.push(name);
			}
		};

		var column = function (colIdx, name, operator, matched) {
			var size, i, ien;

			if (!operator) {
				columns[colIdx].includeIn.push(name);
			}
			else if (operator === 'max-') {
				// Add this breakpoint and all smaller
				size = that._find(name).width;

				for (i = 0, ien = breakpoints.length; i < ien; i++) {
					if (breakpoints[i].width <= size) {
						add(colIdx, breakpoints[i].name);
					}
				}
			}
			else if (operator === 'min-') {
				// Add this breakpoint and all larger
				size = that._find(name).width;

				for (i = 0, ien = breakpoints.length; i < ien; i++) {
					if (breakpoints[i].width >= size) {
						add(colIdx, breakpoints[i].name);
					}
				}
			}
			else if (operator === 'not-') {
				// Add all but this breakpoint
				for (i = 0, ien = breakpoints.length; i < ien; i++) {
					if (breakpoints[i].name.indexOf(matched) === -1) {
						add(colIdx, breakpoints[i].name);
					}
				}
			}
		};

		// Loop over each column and determine if it has a responsive control
		// class
		columns.each(function (col, i) {
			var classNames = col.className.split(' ');
			var hasClass = false;

			// Split the class name up so multiple rules can be applied if needed
			for (var k = 0, ken = classNames.length; k < ken; k++) {
				var className = classNames[k].trim();

				if (className === 'all' || className === 'dtr-all') {
					// Include in all
					hasClass = true;
					col.includeIn = $.map(breakpoints, function (a) {
						return a.name;
					});
					return;
				}
				else if (
					className === 'none' ||
					className === 'dtr-none' ||
					col.never
				) {
					// Include in none (default) and no auto
					hasClass = true;
					return;
				}
				else if (
					className === 'control' ||
					className === 'dtr-control'
				) {
					// Special column that is only visible, when one of the other
					// columns is hidden. This is used for the details control
					hasClass = true;
					col.control = true;
					return;
				}

				$.each(breakpoints, function (j, breakpoint) {
					// Does this column have a class that matches this breakpoint?
					var brokenPoint = breakpoint.name.split('-');
					var re = new RegExp(
						'(min\\-|max\\-|not\\-)?(' +
							brokenPoint[0] +
							')(\\-[_a-zA-Z0-9])?'
					);
					var match = className.match(re);

					if (match) {
						hasClass = true;

						if (
							match[2] === brokenPoint[0] &&
							match[3] === '-' + brokenPoint[1]
						) {
							// Class name matches breakpoint name fully
							column(
								i,
								breakpoint.name,
								match[1],
								match[2] + match[3]
							);
						}
						else if (match[2] === brokenPoint[0] && !match[3]) {
							// Class name matched primary breakpoint name with no qualifier
							column(i, breakpoint.name, match[1], match[2]);
						}
					}
				});
			}

			// If there was no control class, then automatic sizing is used
			if (!hasClass) {
				col.auto = true;
			}
		});

		this.s.columns = columns;
	},

	/**
	 * Update the cells to show the correct control class / button
	 * @private
	 */
	_controlClass: function () {
		if (this.c.details.type === 'inline') {
			var dt = this.s.dt;
			var columnsVis = this.s.current;
			var firstVisible = $.inArray(true, columnsVis);

			// Remove from any cells which shouldn't have it
			dt.cells(
				null,
				function (idx) {
					return idx !== firstVisible;
				},
				{ page: 'current' }
			)
				.nodes()
				.to$()
				.filter('.dtr-control')
				.removeClass('dtr-control');

			dt.cells(null, firstVisible, { page: 'current' })
				.nodes()
				.to$()
				.addClass('dtr-control');
		}
	},

	/**
	 * Show the details for the child row
	 *
	 * @param  {DataTables.Api} row    API instance for the row
	 * @param  {boolean}        update Update flag
	 * @private
	 */
	_detailsDisplay: function (row, update) {
		var that = this;
		var dt = this.s.dt;
		var details = this.c.details;
		var event = function (res) {
			$(row.node()).toggleClass('dtr-expanded', res !== false);
			$(dt.table().node()).triggerHandler('responsive-display.dt', [
				dt,
				row,
				res,
				update
			]);
		};

		if (details && details.type !== false) {
			var renderer =
				typeof details.renderer === 'string'
					? Responsive.renderer[details.renderer]()
					: details.renderer;

			var res = details.display(
				row,
				update,
				function () {
					return renderer.call(
						that,
						dt,
						row[0][0],
						that._detailsObj(row[0])
					);
				},
				function () {
					event(false);
				}
			);

			if (typeof res === 'boolean') {
				event(res);
			}
		}
	},

	/**
	 * Initialisation for the details handler
	 *
	 * @private
	 */
	_detailsInit: function () {
		var that = this;
		var dt = this.s.dt;
		var details = this.c.details;

		// The inline type always uses the first child as the target
		if (details.type === 'inline') {
			details.target = 'td.dtr-control, th.dtr-control';
		}

		// Keyboard accessibility
		dt.on('draw.dtr', function () {
			that._tabIndexes();
		});
		that._tabIndexes(); // Initial draw has already happened

		$(dt.table().body()).on('keyup.dtr', 'td, th', function (e) {
			if (e.keyCode === 13 && $(this).data('dtr-keyboard')) {
				$(this).click();
			}
		});

		// type.target can be a string jQuery selector or a column index
		var target = details.target;
		var selector = typeof target === 'string' ? target : 'td, th';

		if (target !== undefined || target !== null) {
			// Click handler to show / hide the details rows when they are available
			$(dt.table().body()).on(
				'click.dtr mousedown.dtr mouseup.dtr',
				selector,
				function (e) {
					// If the table is not collapsed (i.e. there is no hidden columns)
					// then take no action
					if (!$(dt.table().node()).hasClass('collapsed')) {
						return;
					}

					// Check that the row is actually a DataTable's controlled node
					if (
						$.inArray(
							$(this).closest('tr').get(0),
							dt.rows().nodes().toArray()
						) === -1
					) {
						return;
					}

					// For column index, we determine if we should act or not in the
					// handler - otherwise it is already okay
					if (typeof target === 'number') {
						var targetIdx =
							target < 0
								? dt.columns().eq(0).length + target
								: target;

						if (dt.cell(this).index().column !== targetIdx) {
							return;
						}
					}

					// $().closest() includes itself in its check
					var row = dt.row($(this).closest('tr'));

					// Check event type to do an action
					if (e.type === 'click') {
						// The renderer is given as a function so the caller can execute it
						// only when they need (i.e. if hiding there is no point is running
						// the renderer)
						that._detailsDisplay(row, false);
					}
					else if (e.type === 'mousedown') {
						// For mouse users, prevent the focus ring from showing
						$(this).css('outline', 'none');
					}
					else if (e.type === 'mouseup') {
						// And then re-allow at the end of the click
						$(this).trigger('blur').css('outline', '');
					}
				}
			);
		}
	},

	/**
	 * Get the details to pass to a renderer for a row
	 * @param  {int} rowIdx Row index
	 * @private
	 */
	_detailsObj: function (rowIdx) {
		var that = this;
		var dt = this.s.dt;

		return $.map(this.s.columns, function (col, i) {
			// Never and control columns should not be passed to the renderer
			if (col.never || col.control) {
				return;
			}

			var dtCol = dt.settings()[0].aoColumns[i];

			return {
				className: dtCol.sClass,
				columnIndex: i,
				data: dt.cell(rowIdx, i).render(that.c.orthogonal),
				hidden: dt.column(i).visible() && !that.s.current[i],
				rowIndex: rowIdx,
				title: dt.column(i).title()
			};
		});
	},

	/**
	 * Find a breakpoint object from a name
	 *
	 * @param  {string} name Breakpoint name to find
	 * @return {object}      Breakpoint description object
	 * @private
	 */
	_find: function (name) {
		var breakpoints = this.c.breakpoints;

		for (var i = 0, ien = breakpoints.length; i < ien; i++) {
			if (breakpoints[i].name === name) {
				return breakpoints[i];
			}
		}
	},

	/**
	 * Re-create the contents of the child rows as the display has changed in
	 * some way.
	 *
	 * @private
	 */
	_redrawChildren: function () {
		var that = this;
		var dt = this.s.dt;

		dt.rows({ page: 'current' }).iterator('row', function (settings, idx) {
			that._detailsDisplay(dt.row(idx), true);
		});
	},

	/**
	 * Alter the table display for a resized viewport. This involves first
	 * determining what breakpoint the window currently is in, getting the
	 * column visibilities to apply and then setting them.
	 *
	 * @param  {boolean} forceRedraw Force a redraw
	 * @private
	 */
	_resize: function (forceRedraw) {
		var that = this;
		var dt = this.s.dt;
		var width = $(window).innerWidth();
		var breakpoints = this.c.breakpoints;
		var breakpoint = breakpoints[0].name;
		var columns = this.s.columns;
		var i, ien;
		var oldVis = this.s.current.slice();

		// Determine what breakpoint we are currently at
		for (i = breakpoints.length - 1; i >= 0; i--) {
			if (width <= breakpoints[i].width) {
				breakpoint = breakpoints[i].name;
				break;
			}
		}

		// Show the columns for that break point
		var columnsVis = this._columnsVisiblity(breakpoint);
		this.s.current = columnsVis;

		// Set the class before the column visibility is changed so event
		// listeners know what the state is. Need to determine if there are
		// any columns that are not visible but can be shown
		var collapsedClass = false;

		for (i = 0, ien = columns.length; i < ien; i++) {
			if (
				columnsVis[i] === false &&
				!columns[i].never &&
				!columns[i].control &&
				!dt.column(i).visible() === false
			) {
				collapsedClass = true;
				break;
			}
		}

		$(dt.table().node()).toggleClass('collapsed', collapsedClass);

		var changed = false;
		var visible = 0;
		var dtSettings = dt.settings()[0];

		dt.columns()
			.eq(0)
			.each(function (colIdx, i) {
				// Do nothing on DataTables' hidden column - DT removes it from the table
				// so we need to slide back
				if (! dt.column(colIdx).visible()) {
					return;
				}

				if (columnsVis[i] === true) {
					visible++;
				}

				if (forceRedraw || columnsVis[i] !== oldVis[i]) {
					changed = true;
					that._setColumnVis(colIdx, columnsVis[i]);
				}

				// DataTables 2 uses `col` to define the width for a column
				// and this needs to run each time, as DataTables will change
				// the column width
				if (! columnsVis[i]) {
					$(dtSettings.aoColumns[colIdx].colEl).detach();
				}
			});

		if (changed) {
			this._redrawChildren();

			// Inform listeners of the change
			$(dt.table().node()).trigger('responsive-resize.dt', [
				dt,
				this._responsiveOnlyHidden()
			]);

			// If no records, update the "No records" display element
			if (dt.page.info().recordsDisplay === 0) {
				$('td', dt.table().body()).eq(0).attr('colspan', visible);
			}
		}

		that._controlClass();
	},

	/**
	 * Determine the width of each column in the table so the auto column hiding
	 * has that information to work with. This method is never going to be 100%
	 * perfect since column widths can change slightly per page, but without
	 * seriously compromising performance this is quite effective.
	 *
	 * @private
	 */
	_resizeAuto: function () {
		var dt = this.s.dt;
		var columns = this.s.columns;
		var that = this;
		var visibleColumns = dt
			.columns()
			.indexes()
			.filter(function (idx) {
				return dt.column(idx).visible();
			});

		// Are we allowed to do auto sizing?
		if (!this.c.auto) {
			return;
		}

		// Are there any columns that actually need auto-sizing, or do they all
		// have classes defined
		if (
			$.inArray(
				true,
				$.map(columns, function (c) {
					return c.auto;
				})
			) === -1
		) {
			return;
		}

		// Clone the table with the current data in it
		var clonedTable = dt.table().node().cloneNode(false);
		var clonedHeader = $(dt.table().header().cloneNode(false)).appendTo(
			clonedTable
		);
		var clonedFooter = $(dt.table().footer().cloneNode(false)).appendTo(
			clonedTable
		);
		var clonedBody = $(dt.table().body())
			.clone(false, false)
			.empty()
			.appendTo(clonedTable); // use jQuery because of IE8

		clonedTable.style.width = 'auto';

		// Header
		dt.table()
			.header.structure(visibleColumns)
			.forEach((row) => {
				var cells = row
					.filter(function (el) {
						return el ? true : false;
					})
					.map(function (el) {
						return $(el.cell)
							.clone(false)
							.css('display', 'table-cell')
							.css('width', 'auto')
							.css('min-width', 0);
					});

				$('<tr/>').append(cells).appendTo(clonedHeader);
			});

		// Always need an empty row that we can read widths from
		var emptyRow = $('<tr/>').appendTo(clonedBody);

		for (var i = 0; i < visibleColumns.count(); i++) {
			emptyRow.append('<td/>');
		}

		// Body rows - we don't need to take account of DataTables' column
		// visibility since we implement our own here (hence the `display` set)
		dt.rows({ page: 'current' }).every(function (rowIdx) {
			var node = this.node();

			if (! node) {
				return;
			}

			// We clone the table's rows and cells to create the sizing table
			var tr = node.cloneNode(false);

			dt.cells(rowIdx, '*').every(function (rowIdx2, colIdx) {
				// If nodes have been moved out (listHiddenNodes), we need to
				// clone from the store
				var store = that.s.childNodeStore[rowIdx + '-' + colIdx];

				if (store) {
					$(this.node().cloneNode(false))
						.append($(store).clone())
						.appendTo(tr);
				}
				else {
					$(this.node()).clone(false).appendTo(tr);
				}
			});

			clonedBody.append(tr);
		});

		clonedBody.find('th, td').css('display', '');

		// Footer
		dt.table()
			.footer.structure(visibleColumns)
			.forEach((row) => {
				var cells = row
					.filter(function (el) {
						return el ? true : false;
					})
					.map(function (el) {
						return $(el.cell)
							.clone(false)
							.css('display', 'table-cell')
							.css('width', 'auto')
							.css('min-width', 0);
					});

				$('<tr/>').append(cells).appendTo(clonedFooter);
			});

		// In the inline case extra padding is applied to the first column to
		// give space for the show / hide icon. We need to use this in the
		// calculation
		if (this.c.details.type === 'inline') {
			$(clonedTable).addClass('dtr-inline collapsed');
		}

		// It is unsafe to insert elements with the same name into the DOM
		// multiple times. For example, cloning and inserting a checked radio
		// clears the chcecked state of the original radio.
		$(clonedTable).find('[name]').removeAttr('name');

		// A position absolute table would take the table out of the flow of
		// our container element, bypassing the height and width (Scroller)
		$(clonedTable).css('position', 'relative');

		var inserted = $('<div/>')
			.css({
				width: 1,
				height: 1,
				overflow: 'hidden',
				clear: 'both'
			})
			.append(clonedTable);

		inserted.insertBefore(dt.table().node());

		// The cloned table now contains the smallest that each column can be
		emptyRow.children().each(function (i) {
			var idx = dt.column.index('fromVisible', i);
			columns[idx].minWidth = this.offsetWidth || 0;
		});

		inserted.remove();
	},

	/**
	 * Get the state of the current hidden columns - controlled by Responsive only
	 */
	_responsiveOnlyHidden: function () {
		var dt = this.s.dt;

		return $.map(this.s.current, function (v, i) {
			// If the column is hidden by DataTables then it can't be hidden by
			// Responsive!
			if (dt.column(i).visible() === false) {
				return true;
			}
			return v;
		});
	},

	/**
	 * Set a column's visibility.
	 *
	 * We don't use DataTables' column visibility controls in order to ensure
	 * that column visibility can Responsive can no-exist. Since only IE8+ is
	 * supported (and all evergreen browsers of course) the control of the
	 * display attribute works well.
	 *
	 * @param {integer} col      Column index
	 * @param {boolean} showHide Show or hide (true or false)
	 * @private
	 */
	_setColumnVis: function (col, showHide) {
		var that = this;
		var dt = this.s.dt;
		var display = showHide ? '' : 'none'; // empty string will remove the attr

		this._setHeaderVis(col, showHide, dt.table().header.structure());
		this._setHeaderVis(col, showHide, dt.table().footer.structure());

		dt.column(col)
			.nodes()
			.to$()
			.css('display', display)
			.toggleClass('dtr-hidden', !showHide);

		// If the are child nodes stored, we might need to reinsert them
		if (!$.isEmptyObject(this.s.childNodeStore)) {
			dt.cells(null, col)
				.indexes()
				.each(function (idx) {
					that._childNodesRestore(dt, idx.row, idx.column);
				});
		}
	},

	/**
	 * Set the a column's visibility, taking into account multiple rows
	 * in a header / footer and colspan attributes
	 * @param {*} col
	 * @param {*} showHide
	 * @param {*} structure
	 */
	_setHeaderVis: function (col, showHide, structure) {
		var that = this;
		var display = showHide ? '' : 'none';

		structure.forEach(function (row) {
			if (row[col]) {
				$(row[col].cell)
					.css('display', display)
					.toggleClass('dtr-hidden', !showHide);
			}
			else {
				// In a colspan - need to rewind calc the new span since
				// display:none elements do not count as being spanned over
				var search = col;

				while (search >= 0) {
					if (row[search]) {
						row[search].cell.colSpan = that._colspan(row, search);
						break;
					}

					search--;
				}
			}
		});
	},

	/**
	 * How many columns should this cell span
	 *
	 * @param {*} row Header structure row
	 * @param {*} idx The column index of the cell to span
	 */
	_colspan: function (row, idx) {
		var colspan = 1;

		for (var col = idx + 1; col < row.length; col++) {
			if (row[col] === null && this.s.current[col]) {
				// colspan and not hidden by Responsive
				colspan++;
			}
			else if (row[col]) {
				// Got the next cell, jump out
				break;
			}
		}

		return colspan;
	},

	/**
	 * Update the cell tab indexes for keyboard accessibility. This is called on
	 * every table draw - that is potentially inefficient, but also the least
	 * complex option given that column visibility can change on the fly. Its a
	 * shame user-focus was removed from CSS 3 UI, as it would have solved this
	 * issue with a single CSS statement.
	 *
	 * @private
	 */
	_tabIndexes: function () {
		var dt = this.s.dt;
		var cells = dt.cells({ page: 'current' }).nodes().to$();
		var ctx = dt.settings()[0];
		var target = this.c.details.target;

		cells.filter('[data-dtr-keyboard]').removeData('[data-dtr-keyboard]');

		if (typeof target === 'number') {
			dt.cells(null, target, { page: 'current' })
				.nodes()
				.to$()
				.attr('tabIndex', ctx.iTabIndex)
				.data('dtr-keyboard', 1);
		}
		else {
			// This is a bit of a hack - we need to limit the selected nodes to just
			// those of this table
			if (target === 'td:first-child, th:first-child') {
				target = '>td:first-child, >th:first-child';
			}

			$(target, dt.rows({ page: 'current' }).nodes())
				.attr('tabIndex', ctx.iTabIndex)
				.data('dtr-keyboard', 1);
		}
	}
});

/**
 * List of default breakpoints. Each item in the array is an object with two
 * properties:
 *
 * * `name` - the breakpoint name.
 * * `width` - the breakpoint width
 *
 * @name Responsive.breakpoints
 * @static
 */
Responsive.breakpoints = [
	{ name: 'desktop', width: Infinity },
	{ name: 'tablet-l', width: 1024 },
	{ name: 'tablet-p', width: 768 },
	{ name: 'mobile-l', width: 480 },
	{ name: 'mobile-p', width: 320 }
];

/**
 * Display methods - functions which define how the hidden data should be shown
 * in the table.
 *
 * @namespace
 * @name Responsive.defaults
 * @static
 */
Responsive.display = {
	childRow: function (row, update, render) {
		var rowNode = $(row.node());

		if (update) {
			if (rowNode.hasClass('dtr-expanded')) {
				row.child(render(), 'child').show();

				return true;
			}
		}
		else {
			if (!rowNode.hasClass('dtr-expanded')) {
				var rendered = render();

				if (rendered === false) {
					return false;
				}

				row.child(rendered, 'child').show();
				return true;
			}
			else {
				row.child(false);

				return false;
			}
		}
	},

	childRowImmediate: function (row, update, render) {
		var rowNode = $(row.node());

		if (
			(!update && rowNode.hasClass('dtr-expanded')) ||
			!row.responsive.hasHidden()
		) {
			// User interaction and the row is show, or nothing to show
			row.child(false);

			return false;
		}
		else {
			// Display
			var rendered = render();

			if (rendered === false) {
				return false;
			}

			row.child(rendered, 'child').show();

			return true;
		}
	},

	// This is a wrapper so the modal options for Bootstrap and jQuery UI can
	// have options passed into them. This specific one doesn't need to be a
	// function but it is for consistency in the `modal` name
	modal: function (options) {
		return function (row, update, render, closeCallback) {
			var modal;
			var rendered = render();

			if (rendered === false) {
				return false;
			}

			if (!update) {
				// Show a modal
				var close = function () {
					modal.remove(); // will tidy events for us
					$(document).off('keypress.dtr');
					$(row.node()).removeClass('dtr-expanded');

					closeCallback();
				};

				modal = $('<div class="dtr-modal"/>')
					.append(
						$('<div class="dtr-modal-display"/>')
							.append(
								$('<div class="dtr-modal-content"/>')
									.data('dtr-row-idx', row.index())
									.append(rendered)
							)
							.append(
								$(
									'<div class="dtr-modal-close">&times;</div>'
								).click(function () {
									close();
								})
							)
					)
					.append(
						$('<div class="dtr-modal-background"/>').click(
							function () {
								close();
							}
						)
					)
					.appendTo('body');

				$(row.node()).addClass('dtr-expanded');

				$(document).on('keyup.dtr', function (e) {
					if (e.keyCode === 27) {
						e.stopPropagation();

						close();
					}
				});
			}
			else {
				modal = $('div.dtr-modal-content');

				if (modal.length && row.index() === modal.data('dtr-row-idx')) {
					modal.empty().append(rendered);
				}
				else {
					// Modal not shown, nothing to update
					return null;
				}
			}

			if (options && options.header) {
				$('div.dtr-modal-content').prepend(
					'<h2>' + options.header(row) + '</h2>'
				);
			}

			return true;
		};
	}
};

/**
 * Display methods - functions which define how the hidden data should be shown
 * in the table.
 *
 * @namespace
 * @name Responsive.defaults
 * @static
 */
Responsive.renderer = {
	listHiddenNodes: function () {
		return function (api, rowIdx, columns) {
			var that = this;
			var ul = $(
				'<ul data-dtr-index="' + rowIdx + '" class="dtr-details"/>'
			);
			var found = false;

			$.each(columns, function (i, col) {
				if (col.hidden) {
					var klass = col.className
						? 'class="' + col.className + '"'
						: '';

					$(
						'<li ' +
							klass +
							' data-dtr-index="' +
							col.columnIndex +
							'" data-dt-row="' +
							col.rowIndex +
							'" data-dt-column="' +
							col.columnIndex +
							'">' +
							'<span class="dtr-title">' +
							col.title +
							'</span> ' +
							'</li>'
					)
						.append(
							$('<span class="dtr-data"/>').append(
								that._childNodes(
									api,
									col.rowIndex,
									col.columnIndex
								)
							)
						) // api.cell( col.rowIndex, col.columnIndex ).node().childNodes ) )
						.appendTo(ul);

					found = true;
				}
			});

			return found ? ul : false;
		};
	},

	listHidden: function () {
		return function (api, rowIdx, columns) {
			var data = $.map(columns, function (col) {
				var klass = col.className
					? 'class="' + col.className + '"'
					: '';

				return col.hidden
					? '<li ' +
							klass +
							' data-dtr-index="' +
							col.columnIndex +
							'" data-dt-row="' +
							col.rowIndex +
							'" data-dt-column="' +
							col.columnIndex +
							'">' +
							'<span class="dtr-title">' +
							col.title +
							'</span> ' +
							'<span class="dtr-data">' +
							col.data +
							'</span>' +
							'</li>'
					: '';
			}).join('');

			return data
				? $(
						'<ul data-dtr-index="' +
							rowIdx +
							'" class="dtr-details"/>'
				).append(data)
				: false;
		};
	},

	tableAll: function (options) {
		options = $.extend(
			{
				tableClass: ''
			},
			options
		);

		return function (api, rowIdx, columns) {
			var data = $.map(columns, function (col) {
				var klass = col.className
					? 'class="' + col.className + '"'
					: '';

				return (
					'<tr ' +
					klass +
					' data-dt-row="' +
					col.rowIndex +
					'" data-dt-column="' +
					col.columnIndex +
					'">' +
					'<td>' +
					col.title +
					':' +
					'</td> ' +
					'<td>' +
					col.data +
					'</td>' +
					'</tr>'
				);
			}).join('');

			return $(
				'<table class="' +
					options.tableClass +
					' dtr-details" width="100%"/>'
			).append(data);
		};
	}
};

/**
 * Responsive default settings for initialisation
 *
 * @namespace
 * @name Responsive.defaults
 * @static
 */
Responsive.defaults = {
	/**
	 * List of breakpoints for the instance. Note that this means that each
	 * instance can have its own breakpoints. Additionally, the breakpoints
	 * cannot be changed once an instance has been creased.
	 *
	 * @type {Array}
	 * @default Takes the value of `Responsive.breakpoints`
	 */
	breakpoints: Responsive.breakpoints,

	/**
	 * Enable / disable auto hiding calculations. It can help to increase
	 * performance slightly if you disable this option, but all columns would
	 * need to have breakpoint classes assigned to them
	 *
	 * @type {Boolean}
	 * @default  `true`
	 */
	auto: true,

	/**
	 * Details control. If given as a string value, the `type` property of the
	 * default object is set to that value, and the defaults used for the rest
	 * of the object - this is for ease of implementation.
	 *
	 * The object consists of the following properties:
	 *
	 * * `display` - A function that is used to show and hide the hidden details
	 * * `renderer` - function that is called for display of the child row data.
	 *   The default function will show the data from the hidden columns
	 * * `target` - Used as the selector for what objects to attach the child
	 *   open / close to
	 * * `type` - `false` to disable the details display, `inline` or `column`
	 *   for the two control types
	 *
	 * @type {Object|string}
	 */
	details: {
		display: Responsive.display.childRow,

		renderer: Responsive.renderer.listHidden(),

		target: 0,

		type: 'inline'
	},

	/**
	 * Orthogonal data request option. This is used to define the data type
	 * requested when Responsive gets the data to show in the child row.
	 *
	 * @type {String}
	 */
	orthogonal: 'display'
};

/*
 * API
 */
var Api = $.fn.dataTable.Api;

// Doesn't do anything - work around for a bug in DT... Not documented
Api.register('responsive()', function () {
	return this;
});

Api.register('responsive.index()', function (li) {
	li = $(li);

	return {
		column: li.data('dtr-index'),
		row: li.parent().data('dtr-index')
	};
});

Api.register('responsive.rebuild()', function () {
	return this.iterator('table', function (ctx) {
		if (ctx._responsive) {
			ctx._responsive._classLogic();
		}
	});
});

Api.register('responsive.recalc()', function () {
	return this.iterator('table', function (ctx) {
		if (ctx._responsive) {
			ctx._responsive._resizeAuto();
			ctx._responsive._resize();
		}
	});
});

Api.register('responsive.hasHidden()', function () {
	var ctx = this.context[0];

	return ctx._responsive
		? $.inArray(false, ctx._responsive._responsiveOnlyHidden()) !== -1
		: false;
});

Api.registerPlural(
	'columns().responsiveHidden()',
	'column().responsiveHidden()',
	function () {
		return this.iterator(
			'column',
			function (settings, column) {
				return settings._responsive
					? settings._responsive._responsiveOnlyHidden()[column]
					: false;
			},
			1
		);
	}
);

/**
 * Version information
 *
 * @name Responsive.version
 * @static
 */
Responsive.version = '3.0.1';

$.fn.dataTable.Responsive = Responsive;
$.fn.DataTable.Responsive = Responsive;

// Attach a listener to the document which listens for DataTables initialisation
// events so we can automatically initialise
$(document).on('preInit.dt.dtr', function (e, settings, json) {
	if (e.namespace !== 'dt') {
		return;
	}

	if (
		$(settings.nTable).hasClass('responsive') ||
		$(settings.nTable).hasClass('dt-responsive') ||
		settings.oInit.responsive ||
		datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.responsive
	) {
		var init = settings.oInit.responsive;

		if (init !== false) {
			new Responsive(settings, $.isPlainObject(init) ? init : {});
		}
	}
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-rowgroup-bs4/js/rowGroup.bootstrap4.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/datatables.net-rowgroup-bs4/js/rowGroup.bootstrap4.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_rowgroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-rowgroup */ "./node_modules/datatables.net-rowgroup/js/dataTables.rowGroup.mjs");
/*! Bootstrap 4 styling wrapper for RowGroup
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-rowgroup/js/dataTables.rowGroup.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/datatables.net-rowgroup/js/dataTables.rowGroup.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! RowGroup 1.5.0
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * @summary     RowGroup
 * @description RowGrouping for DataTables
 * @version     1.5.0
 * @author      SpryMedia Ltd (www.sprymedia.co.uk)
 * @contact     datatables.net
 * @copyright   SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

var RowGroup = function (dt, opts) {
	// Sanity check that we are using DataTables 1.10 or newer
	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck || !datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('1.11')) {
		throw 'RowGroup requires DataTables 1.11 or newer';
	}

	// User and defaults configuration object
	this.c = $.extend(true, {}, datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.rowGroup, RowGroup.defaults, opts);

	// Internal settings
	this.s = {
		dt: new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(dt)
	};

	// DOM items
	this.dom = {};

	// Check if row grouping has already been initialised on this table
	var settings = this.s.dt.settings()[0];
	var existing = settings.rowGroup;
	if (existing) {
		return existing;
	}

	settings.rowGroup = this;
	this._constructor();
};

$.extend(RowGroup.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * API methods for DataTables API interface
	 */

	/**
	 * Get/set the grouping data source - need to call draw after this is
	 * executed as a setter
	 * @returns string~RowGroup
	 */
	dataSrc: function (val) {
		if (val === undefined) {
			return this.c.dataSrc;
		}

		var dt = this.s.dt;

		this.c.dataSrc = val;

		$(dt.table().node()).triggerHandler('rowgroup-datasrc.dt', [dt, val]);

		return this;
	},

	/**
	 * Disable - need to call draw after this is executed
	 * @returns RowGroup
	 */
	disable: function () {
		this.c.enable = false;
		return this;
	},

	/**
	 * Enable - need to call draw after this is executed
	 * @returns RowGroup
	 */
	enable: function (flag) {
		if (flag === false) {
			return this.disable();
		}

		this.c.enable = true;
		return this;
	},

	/**
	 * Get enabled flag
	 * @returns boolean
	 */
	enabled: function () {
		return this.c.enable;
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */
	_constructor: function () {
		var that = this;
		var dt = this.s.dt;
		var hostSettings = dt.settings()[0];

		dt.on('draw.dtrg', function (e, s) {
			if (that.c.enable && hostSettings === s) {
				that._draw();
			}
		});

		dt.on('column-visibility.dt.dtrg responsive-resize.dt.dtrg', function () {
			that._adjustColspan();
		});

		dt.on('destroy', function () {
			dt.off('.dtrg');
		});
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Adjust column span when column visibility changes
	 * @private
	 */
	_adjustColspan: function () {
		$('tr.' + this.c.className, this.s.dt.table().body())
			.find('th:visible, td:visible')
			.attr('colspan', this._colspan());
	},

	/**
	 * Get the number of columns that a grouping row should span
	 * @private
	 */
	_colspan: function () {
		return this.s.dt
			.columns()
			.visible()
			.reduce(function (a, b) {
				return a + b;
			}, 0);
	},

	/**
	 * Update function that is called whenever we need to draw the grouping rows.
	 * This is basically a bootstrap for the self iterative _group and _groupDisplay
	 * methods
	 * @private
	 */
	_draw: function () {
		var dt = this.s.dt;
		var groupedRows = this._group(0, dt.rows({ page: 'current' }).indexes());

		this._groupDisplay(0, groupedRows);
	},

	/**
	 * Get the grouping information from a data set (index) of rows
	 * @param {number} level Nesting level
	 * @param {DataTables.Api} rows API of the rows to consider for this group
	 * @returns {object[]} Nested grouping information - it is structured like this:
	 *	{
	 *		dataPoint: 'Edinburgh',
	 *		rows: [ 1,2,3,4,5,6,7 ],
	 *		children: [ {
	 *			dataPoint: 'developer'
	 *			rows: [ 1, 2, 3 ]
	 *		},
	 *		{
	 *			dataPoint: 'support',
	 *			rows: [ 4, 5, 6, 7 ]
	 *		} ]
	 *	}
	 * @private
	 */
	_group: function (level, rows) {
		var fns = Array.isArray(this.c.dataSrc) ? this.c.dataSrc : [this.c.dataSrc];
		var fn = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.get(fns[level]);
		var dt = this.s.dt;
		var group, last;
		var i, ien;
		var data = [];
		var that = this;

		for (i = 0, ien = rows.length; i < ien; i++) {
			var rowIndex = rows[i];
			var rowData = dt.row(rowIndex).data();

			group = fn(rowData, level);

			if (group === null || group === undefined) {
				group = that.c.emptyDataGroup;
			}

			if (last === undefined || group !== last) {
				data.push({
					dataPoint: group,
					rows: []
				});

				last = group;
			}

			data[data.length - 1].rows.push(rowIndex);
		}

		if (fns[level + 1] !== undefined) {
			for (i = 0, ien = data.length; i < ien; i++) {
				data[i].children = this._group(level + 1, data[i].rows);
			}
		}

		return data;
	},

	/**
	 * Row group display - insert the rows into the document
	 * @param {number} level Nesting level
	 * @param {object[]} groups Takes the nested array from `_group`
	 * @private
	 */
	_groupDisplay: function (level, groups) {
		var dt = this.s.dt;
		var display;

		for (var i = 0, ien = groups.length; i < ien; i++) {
			var group = groups[i];
			var groupName = group.dataPoint;
			var row;
			var rows = group.rows;

			if (this.c.startRender) {
				display = this.c.startRender.call(this, dt.rows(rows), groupName, level);
				row = this._rowWrap(display, this.c.startClassName, level);

				if (row) {
					row.insertBefore(dt.row(rows[0]).node());
				}
			}

			if (this.c.endRender) {
				display = this.c.endRender.call(this, dt.rows(rows), groupName, level);
				row = this._rowWrap(display, this.c.endClassName, level);

				if (row) {
					row.insertAfter(dt.row(rows[rows.length - 1]).node());
				}
			}

			if (group.children) {
				this._groupDisplay(level + 1, group.children);
			}
		}
	},

	/**
	 * Take a rendered value from an end user and make it suitable for display
	 * as a row, by wrapping it in a row, or detecting that it is a row.
	 * @param {node|jQuery|string} display Display value
	 * @param {string} className Class to add to the row
	 * @param {array} group
	 * @param {number} group level
	 * @private
	 */
	_rowWrap: function (display, className, level) {
		var row;

		if (display === null || display === '') {
			display = this.c.emptyDataGroup;
		}

		if (display === undefined || display === null) {
			return null;
		}

		if (
			typeof display === 'object' &&
			display.nodeName &&
			display.nodeName.toLowerCase() === 'tr'
		) {
			row = $(display);
		}
		else if (
			display instanceof $ &&
			display.length &&
			display[0].nodeName.toLowerCase() === 'tr'
		) {
			row = display;
		}
		else {
			row = $('<tr/>').append(
				$('<th/>').attr('colspan', this._colspan()).attr('scope', 'row').append(display)
			);
		}

		return row
			.addClass(this.c.className)
			.addClass(className)
			.addClass('dtrg-level-' + level);
	}
});

/**
 * RowGroup default settings for initialisation
 *
 * @namespace
 * @name RowGroup.defaults
 * @static
 */
RowGroup.defaults = {
	/**
	 * Class to apply to grouping rows - applied to both the start and
	 * end grouping rows.
	 * @type string
	 */
	className: 'dtrg-group',

	/**
	 * Data property from which to read the grouping information
	 * @type string|integer|array
	 */
	dataSrc: 0,

	/**
	 * Text to show if no data is found for a group
	 * @type string
	 */
	emptyDataGroup: 'No group',

	/**
	 * Initial enablement state
	 * @boolean
	 */
	enable: true,

	/**
	 * Class name to give to the end grouping row
	 * @type string
	 */
	endClassName: 'dtrg-end',

	/**
	 * End grouping label function
	 * @function
	 */
	endRender: null,

	/**
	 * Class name to give to the start grouping row
	 * @type string
	 */
	startClassName: 'dtrg-start',

	/**
	 * Start grouping label function
	 * @function
	 */
	startRender: function (rows, group) {
		return group;
	}
};

RowGroup.version = '1.5.0';

$.fn.dataTable.RowGroup = RowGroup;
$.fn.DataTable.RowGroup = RowGroup;

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('rowGroup()', function () {
	return this;
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('rowGroup().disable()', function () {
	return this.iterator('table', function (ctx) {
		if (ctx.rowGroup) {
			ctx.rowGroup.enable(false);
		}
	});
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('rowGroup().enable()', function (opts) {
	return this.iterator('table', function (ctx) {
		if (ctx.rowGroup) {
			ctx.rowGroup.enable(opts === undefined ? true : opts);
		}
	});
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('rowGroup().enabled()', function () {
	var ctx = this.context;

	return ctx.length && ctx[0].rowGroup ? ctx[0].rowGroup.enabled() : false;
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('rowGroup().dataSrc()', function (val) {
	if (val === undefined) {
		return this.context[0].rowGroup.dataSrc();
	}

	return this.iterator('table', function (ctx) {
		if (ctx.rowGroup) {
			ctx.rowGroup.dataSrc(val);
		}
	});
});

// Attach a listener to the document which listens for DataTables initialisation
// events so we can automatically initialise
$(document).on('preInit.dt.dtrg', function (e, settings, json) {
	if (e.namespace !== 'dt') {
		return;
	}

	var init = settings.oInit.rowGroup;
	var defaults = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.rowGroup;

	if (init || defaults) {
		var opts = $.extend({}, defaults, init);

		if (init !== false) {
			new RowGroup(settings, opts);
		}
	}
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-rowreorder-bs4/js/rowReorder.bootstrap4.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/datatables.net-rowreorder-bs4/js/rowReorder.bootstrap4.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_rowreorder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-rowreorder */ "./node_modules/datatables.net-rowreorder/js/dataTables.rowReorder.mjs");
/*! Bootstrap 4 styling wrapper for RowReorder
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-rowreorder/js/dataTables.rowReorder.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/datatables.net-rowreorder/js/dataTables.rowReorder.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! RowReorder 1.5.0
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * @summary     RowReorder
 * @description Row reordering extension for DataTables
 * @version     1.5.0
 * @author      SpryMedia Ltd
 * @contact     datatables.net
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

/**
 * RowReorder provides the ability in DataTables to click and drag rows to
 * reorder them. When a row is dropped the data for the rows effected will be
 * updated to reflect the change. Normally this data point should also be the
 * column being sorted upon in the DataTable but this does not need to be the
 * case. RowReorder implements a "data swap" method - so the rows being
 * reordered take the value of the data point from the row that used to occupy
 * the row's new position.
 *
 * Initialisation is done by either:
 *
 * * `rowReorder` parameter in the DataTable initialisation object
 * * `new DataTable.RowReorder( table, opts )` after DataTables
 *   initialisation.
 *
 *  @class
 *  @param {object} settings DataTables settings object for the host table
 *  @param {object} [opts] Configuration options
 *  @requires jQuery 1.7+
 *  @requires DataTables 1.11
 */
var RowReorder = function (dt, opts) {
	// Sanity check that we are using DataTables 1.10 or newer
	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck || !datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('1.11')) {
		throw 'DataTables RowReorder requires DataTables 1.11 or newer';
	}

	// User and defaults configuration object
	this.c = $.extend(true, {}, datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.rowReorder, RowReorder.defaults, opts);

	// Internal settings
	this.s = {
		/** @type {integer} Scroll body top cache */
		bodyTop: null,

		/** @type {DataTable.Api} DataTables' API instance */
		dt: new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(dt),

		/** @type {function} Data fetch function */
		getDataFn: datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.get(this.c.dataSrc),

		/** @type {array} Pixel positions for row insertion calculation */
		middles: null,

		/** @type {Object} Cached dimension information for use in the mouse move event handler */
		scroll: {},

		/** @type {integer} Interval object used for smooth scrolling */
		scrollInterval: null,

		/** @type {function} Data set function */
		setDataFn: datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.set(this.c.dataSrc),

		/** @type {Object} Mouse down information */
		start: {
			top: 0,
			left: 0,
			offsetTop: 0,
			offsetLeft: 0,
			nodes: [],
			rowIndex: 0
		},

		/** @type {integer} Window height cached value */
		windowHeight: 0,

		/** @type {integer} Document outer height cached value */
		documentOuterHeight: 0,

		/** @type {integer} DOM clone outer height cached value */
		domCloneOuterHeight: 0,

		/** @type {integer} Flag used for signing if the drop is enabled or not */
		dropAllowed: true
	};

	// DOM items
	this.dom = {
		/** @type {jQuery} Cloned row being moved around */
		clone: null,
		cloneParent: null,

		/** @type {jQuery} DataTables scrolling container */
		dtScroll: $('div.dataTables_scrollBody, div.dt-scroll-body', this.s.dt.table().container())
	};

	// Check if row reorder has already been initialised on this table
	var settings = this.s.dt.settings()[0];
	var existing = settings.rowreorder;

	if (existing) {
		return existing;
	}

	if (!this.dom.dtScroll.length) {
		this.dom.dtScroll = $(this.s.dt.table().container(), 'tbody');
	}

	settings.rowreorder = this;
	this._constructor();
};

$.extend(RowReorder.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */

	/**
	 * Initialise the RowReorder instance
	 *
	 * @private
	 */
	_constructor: function () {
		var that = this;
		var dt = this.s.dt;
		var table = $(dt.table().node());

		// Need to be able to calculate the row positions relative to the table
		if (table.css('position') === 'static') {
			table.css('position', 'relative');
		}

		// listen for mouse down on the target column - we have to implement
		// this rather than using HTML5 drag and drop as drag and drop doesn't
		// appear to work on table rows at this time. Also mobile browsers are
		// not supported.
		// Use `table().container()` rather than just the table node for IE8 -
		// otherwise it only works once...
		$(dt.table().container()).on(
			'mousedown.rowReorder touchstart.rowReorder',
			this.c.selector,
			function (e) {
				if (!that.c.enable) {
					return;
				}

				// Ignore excluded children of the selector
				if ($(e.target).is(that.c.excludedChildren)) {
					return true;
				}

				var tr = $(this).closest('tr');
				var row = dt.row(tr);

				// Double check that it is a DataTable row
				if (row.any()) {
					that._emitEvent('pre-row-reorder', {
						node: row.node(),
						index: row.index()
					});

					that._mouseDown(e, tr);
					return false;
				}
			}
		);

		dt.on('destroy.rowReorder', function () {
			$(dt.table().container()).off('.rowReorder');
			dt.off('.rowReorder');
		});

		this._keyup = this._keyup.bind(this);
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Cache the measurements that RowReorder needs in the mouse move handler
	 * to attempt to speed things up, rather than reading from the DOM.
	 *
	 * @private
	 */
	_cachePositions: function () {
		var dt = this.s.dt;

		// Frustratingly, if we add `position:relative` to the tbody, the
		// position is still relatively to the parent. So we need to adjust
		// for that
		var headerHeight = $(dt.table().node()).find('thead').outerHeight();

		// Need to pass the nodes through jQuery to get them in document order,
		// not what DataTables thinks it is, since we have been altering the
		// order
		var nodes = $.unique(dt.rows({ page: 'current' }).nodes().toArray());
		var middles = $.map(nodes, function (node, i) {
			var top = $(node).position().top - headerHeight;

			return (top + top + $(node).outerHeight()) / 2;
		});

		this.s.middles = middles;
		this.s.bodyTop = $(dt.table().body()).offset().top;
		this.s.windowHeight = $(window).height();
		this.s.documentOuterHeight = $(document).outerHeight();
		this.s.bodyArea = this._calcBodyArea();
	},

	/**
	 * Clone a row so it can be floated around the screen
	 *
	 * @param  {jQuery} target Node to be cloned
	 * @private
	 */
	_clone: function (target) {
		var dt = this.s.dt;
		var clone = $(dt.table().node().cloneNode(false))
			.addClass('dt-rowReorder-float')
			.append('<tbody/>')
			.append(target.clone(false));

		// Match the table and column widths - read all sizes before setting
		// to reduce reflows
		var tableWidth = target.outerWidth();
		var tableHeight = target.outerHeight();
		var scrollBody = $($(this.s.dt.table().node()).parent());
		var scrollWidth = scrollBody.width();
		var scrollLeft = scrollBody.scrollLeft();
		var sizes = target.children().map(function () {
			return $(this).width();
		});

		clone
			.width(tableWidth)
			.height(tableHeight)
			.find('tr')
			.children()
			.each(function (i) {
				this.style.width = sizes[i] + 'px';
			});

		var cloneParent = $('<div>')
			.addClass('dt-rowReorder-float-parent')
			.width(scrollWidth)
			.append(clone)
			.appendTo('body')
			.scrollLeft(scrollLeft);

		// Insert into the document to have it floating around

		this.dom.clone = clone;
		this.dom.cloneParent = cloneParent;
		this.s.domCloneOuterHeight = clone.outerHeight();
	},

	/**
	 * Update the cloned item's position in the document
	 *
	 * @param  {object} e Event giving the mouse's position
	 * @private
	 */
	_clonePosition: function (e) {
		var start = this.s.start;
		var topDiff = this._eventToPage(e, 'Y') - start.top;
		var leftDiff = this._eventToPage(e, 'X') - start.left;
		var snap = this.c.snapX;
		var left;
		var top = topDiff + start.offsetTop;

		if (snap === true) {
			left = start.offsetLeft;
		}
		else if (typeof snap === 'number') {
			left = start.offsetLeft + snap;
		}
		else {
			left = leftDiff + start.offsetLeft + this.dom.cloneParent.scrollLeft();
		}

		if (top < 0) {
			top = 0;
		}
		else if (top + this.s.domCloneOuterHeight > this.s.documentOuterHeight) {
			top = this.s.documentOuterHeight - this.s.domCloneOuterHeight;
		}

		this.dom.cloneParent.css({
			top: top,
			left: left
		});
	},

	/**
	 * Emit an event on the DataTable for listeners
	 *
	 * @param  {string} name Event name
	 * @param  {array} args Event arguments
	 * @private
	 */
	_emitEvent: function ( name, args )
	{
		var ret;

		this.s.dt.iterator( 'table', function ( ctx, i ) {
			var innerRet = $(ctx.nTable).triggerHandler( name+'.dt', args );

			if (innerRet !== undefined) {
				ret = innerRet;
			}
		} );

		return ret;
	},

	/**
	 * Get pageX/Y position from an event, regardless of if it is a mouse or
	 * touch event.
	 *
	 * @param  {object} e Event
	 * @param  {string} pos X or Y (must be a capital)
	 * @private
	 */
	_eventToPage: function (e, pos) {
		if (e.type.indexOf('touch') !== -1) {
			return e.originalEvent.touches[0]['page' + pos];
		}

		return e['page' + pos];
	},

	/**
	 * Mouse down event handler. Read initial positions and add event handlers
	 * for the move.
	 *
	 * @param  {object} e      Mouse event
	 * @param  {jQuery} target TR element that is to be moved
	 * @private
	 */
	_mouseDown: function (e, target) {
		var that = this;
		var dt = this.s.dt;
		var start = this.s.start;
		var cancelable = this.c.cancelable;

		var offset = target.offset();
		start.top = this._eventToPage(e, 'Y');
		start.left = this._eventToPage(e, 'X');
		start.offsetTop = offset.top;
		start.offsetLeft = offset.left;
		start.nodes = $.unique(dt.rows({ page: 'current' }).nodes().toArray());

		this._cachePositions();
		this._clone(target);
		this._clonePosition(e);

		var bodyY = this._eventToPage(e, 'Y') - this.s.bodyTop;
		start.rowIndex = this._calcRowIndexByPos(bodyY);

		this.dom.target = target;
		target.addClass('dt-rowReorder-moving');

		$(document)
			.on('mouseup.rowReorder touchend.rowReorder', function (e) {
				that._mouseUp(e);
			})
			.on('mousemove.rowReorder touchmove.rowReorder', function (e) {
				that._mouseMove(e);
			});

		// Check if window is x-scrolling - if not, disable it for the duration
		// of the drag
		if ($(window).width() === $(document).width()) {
			$(document.body).addClass('dt-rowReorder-noOverflow');
		}

		// Cache scrolling information so mouse move doesn't need to read.
		// This assumes that the window and DT scroller will not change size
		// during an row drag, which I think is a fair assumption
		var scrollWrapper = this.dom.dtScroll;
		this.s.scroll = {
			windowHeight: $(window).height(),
			windowWidth: $(window).width(),
			dtTop: scrollWrapper.length ? scrollWrapper.offset().top : null,
			dtLeft: scrollWrapper.length ? scrollWrapper.offset().left : null,
			dtHeight: scrollWrapper.length ? scrollWrapper.outerHeight() : null,
			dtWidth: scrollWrapper.length ? scrollWrapper.outerWidth() : null
		};

		// Add keyup handler if dragging is cancelable
		if (cancelable) {
			$(document).on('keyup', this._keyup);
		}
	},

	/**
	 * Mouse move event handler - move the cloned row and shuffle the table's
	 * rows if required.
	 *
	 * @param  {object} e Mouse event
	 * @private
	 */
	_mouseMove: function (e) {
		this._clonePosition(e);

		var start = this.s.start;
		var cancelable = this.c.cancelable;

		if (cancelable) {
			var bodyArea = this.s.bodyArea;
			var cloneArea = this._calcCloneParentArea();
			this.s.dropAllowed = this._rectanglesIntersect(bodyArea, cloneArea);

			this.s.dropAllowed
				? $(this.dom.cloneParent).removeClass('drop-not-allowed')
				: $(this.dom.cloneParent).addClass('drop-not-allowed');
		}

		// Transform the mouse position into a position in the table's body
		var bodyY = this._eventToPage(e, 'Y') - this.s.bodyTop;
		var middles = this.s.middles;
		var insertPoint = null;

		// Determine where the row should be inserted based on the mouse
		// position
		for (var i = 0, ien = middles.length; i < ien; i++) {
			if (bodyY < middles[i]) {
				insertPoint = i;
				break;
			}
		}

		if (insertPoint === null) {
			insertPoint = middles.length;
		}

		if (cancelable) {
			if (!this.s.dropAllowed) {
				// Move the row back to its original position becasuse the drop is not allowed
				insertPoint =
					start.rowIndex > this.s.lastInsert ? start.rowIndex + 1 : start.rowIndex;
			}

			this.dom.target.toggleClass('dt-rowReorder-moving', this.s.dropAllowed);
		}

		this._moveTargetIntoPosition(insertPoint);

		this._shiftScroll(e);
	},

	/**
	 * Mouse up event handler - release the event handlers and perform the
	 * table updates
	 *
	 * @param  {object} e Mouse event
	 * @private
	 */
	_mouseUp: function (e) {
		var that = this;
		var dt = this.s.dt;
		var i, ien;
		var dataSrc = this.c.dataSrc;
		var dropAllowed = this.s.dropAllowed;

		if (!dropAllowed) {
			that._cancel();
			return;
		}

		// Calculate the difference
		var startNodes = this.s.start.nodes;
		var endNodes = $.unique(dt.rows({ page: 'current' }).nodes().toArray());
		var idDiff = {};
		var fullDiff = [];
		var diffNodes = [];
		var getDataFn = this.s.getDataFn;
		var setDataFn = this.s.setDataFn;

		for (i = 0, ien = startNodes.length; i < ien; i++) {
			if (startNodes[i] !== endNodes[i]) {
				var id = dt.row(endNodes[i]).id();
				var endRowData = dt.row(endNodes[i]).data();
				var startRowData = dt.row(startNodes[i]).data();

				if (id) {
					idDiff[id] = getDataFn(startRowData);
				}

				fullDiff.push({
					node: endNodes[i],
					oldData: getDataFn(endRowData),
					newData: getDataFn(startRowData),
					newPosition: i,
					oldPosition: $.inArray(endNodes[i], startNodes)
				});

				diffNodes.push(endNodes[i]);
			}
		}

		// Create event args
		var eventArgs = [
			fullDiff,
			{
				dataSrc: dataSrc,
				nodes: diffNodes,
				values: idDiff,
				triggerRow: dt.row(this.dom.target),
				originalEvent: e
			}
		];

		// Emit event
		var eventResult = this._emitEvent( 'row-reorder', eventArgs );

		if (eventResult === false) {
			that._cancel();
			return;
		}

		// Remove cloned elements, handlers, etc
		this._cleanupDragging();

		var update = function () {
			if (that.c.update) {
				for (i = 0, ien = fullDiff.length; i < ien; i++) {
					var row = dt.row(fullDiff[i].node);
					var rowData = row.data();

					setDataFn(rowData, fullDiff[i].newData);

					// Invalidate the cell that has the same data source as the dataSrc
					dt.columns().every(function () {
						if (this.dataSrc() === dataSrc) {
							dt.cell(fullDiff[i].node, this.index()).invalidate('data');
						}
					});
				}

				// Trigger row reordered event
				that._emitEvent('row-reordered', eventArgs);

				dt.draw(false);
			}
		};

		// Editor interface
		if (this.c.editor) {
			// Disable user interaction while Editor is submitting
			this.c.enable = false;

			this.c.editor
				.edit(diffNodes, false, $.extend({ submit: 'changed' }, this.c.formOptions))
				.multiSet(dataSrc, idDiff)
				.one('preSubmitCancelled.rowReorder', function () {
					that.c.enable = true;
					that.c.editor.off('.rowReorder');
					dt.draw(false);
				})
				.one('submitUnsuccessful.rowReorder', function () {
					dt.draw(false);
				})
				.one('submitSuccess.rowReorder', function () {
					update();
				})
				.one('submitComplete', function () {
					that.c.enable = true;
					that.c.editor.off('.rowReorder');
				})
				.submit();
		}
		else {
			update();
		}
	},

	/**
	 * Moves the current target into the given position within the table
	 * and caches the new positions
	 *
	 * @param  {integer} insertPoint Position
	 * @private
	 */
	_moveTargetIntoPosition: function (insertPoint) {
		var dt = this.s.dt;

		// Perform the DOM shuffle if it has changed from last time
		if (this.s.lastInsert === null || this.s.lastInsert !== insertPoint) {
			var nodes = $.unique(dt.rows({ page: 'current' }).nodes().toArray());
			var insertPlacement = '';

			if (insertPoint > this.s.lastInsert) {
				this.dom.target.insertAfter(nodes[insertPoint - 1]);
				insertPlacement = 'after';
			}
			else {
				this.dom.target.insertBefore(nodes[insertPoint]);
				insertPlacement = 'before';
			}

			this._cachePositions();

			this.s.lastInsert = insertPoint;

			this._emitEvent('row-reorder-changed', {
				insertPlacement,
				insertPoint,
				row: dt.row(this.dom.target)
			});
		}
	},

	/**
	 * Removes the cloned elements, event handlers, scrolling intervals, etc
	 *
	 * @private
	 */
	_cleanupDragging: function () {
		var cancelable = this.c.cancelable;

		this.dom.clone.remove();
		this.dom.cloneParent.remove();
		this.dom.clone = null;
		this.dom.cloneParent = null;

		this.dom.target.removeClass('dt-rowReorder-moving');
		//this.dom.target = null;

		$(document).off('.rowReorder');
		$(document.body).removeClass('dt-rowReorder-noOverflow');

		clearInterval(this.s.scrollInterval);
		this.s.scrollInterval = null;

		if (cancelable) {
			$(document).off('keyup', this._keyup);
		}
	},

	/**
	 * Move the window and DataTables scrolling during a drag to scroll new
	 * content into view.
	 *
	 * This matches the `_shiftScroll` method used in AutoFill, but only
	 * horizontal scrolling is considered here.
	 *
	 * @param  {object} e Mouse move event object
	 * @private
	 */
	_shiftScroll: function (e) {
		var that = this;
		var scroll = this.s.scroll;
		var runInterval = false;
		var scrollSpeed = 5;
		var buffer = 65;
		var windowY = e.pageY - document.body.scrollTop,
			windowVert,
			dtVert;

		// Window calculations - based on the mouse position in the window,
		// regardless of scrolling
		if (windowY < $(window).scrollTop() + buffer) {
			windowVert = scrollSpeed * -1;
		}
		else if (windowY > scroll.windowHeight + $(window).scrollTop() - buffer) {
			windowVert = scrollSpeed;
		}

		// DataTables scrolling calculations - based on the table's position in
		// the document and the mouse position on the page
		if (scroll.dtTop !== null && e.pageY < scroll.dtTop + buffer) {
			dtVert = scrollSpeed * -1;
		}
		else if (scroll.dtTop !== null && e.pageY > scroll.dtTop + scroll.dtHeight - buffer) {
			dtVert = scrollSpeed;
		}

		// This is where it gets interesting. We want to continue scrolling
		// without requiring a mouse move, so we need an interval to be
		// triggered. The interval should continue until it is no longer needed,
		// but it must also use the latest scroll commands (for example consider
		// that the mouse might move from scrolling up to scrolling left, all
		// with the same interval running. We use the `scroll` object to "pass"
		// this information to the interval. Can't use local variables as they
		// wouldn't be the ones that are used by an already existing interval!
		if (windowVert || dtVert) {
			scroll.windowVert = windowVert;
			scroll.dtVert = dtVert;
			runInterval = true;
		}
		else if (this.s.scrollInterval) {
			// Don't need to scroll - remove any existing timer
			clearInterval(this.s.scrollInterval);
			this.s.scrollInterval = null;
		}

		// If we need to run the interval to scroll and there is no existing
		// interval (if there is an existing one, it will continue to run)
		if (!this.s.scrollInterval && runInterval) {
			this.s.scrollInterval = setInterval(function () {
				// Don't need to worry about setting scroll <0 or beyond the
				// scroll bound as the browser will just reject that.
				if (scroll.windowVert) {
					var top = $(document).scrollTop();
					$(document).scrollTop(top + scroll.windowVert);

					if (top !== $(document).scrollTop()) {
						var move = parseFloat(that.dom.cloneParent.css('top'));
						that.dom.cloneParent.css('top', move + scroll.windowVert);
					}
				}

				// DataTables scrolling
				if (scroll.dtVert) {
					var scroller = that.dom.dtScroll[0];

					if (scroll.dtVert) {
						scroller.scrollTop += scroll.dtVert;
					}
				}
			}, 20);
		}
	},

	/**
	 * Calculates the current area of the table body and returns it as a rectangle
	 *
	 * @private
	 */
	_calcBodyArea: function (e) {
		var dt = this.s.dt;
		var offset = $(dt.table().body()).offset();
		var area = {
			left: offset.left,
			top: offset.top,
			right: offset.left + $(dt.table().body()).width(),
			bottom: offset.top + $(dt.table().body()).height()
		};

		return area;
	},

	/**
	 * Calculates the current area of the cloned parent element and returns it as a rectangle
	 *
	 * @private
	 */
	_calcCloneParentArea: function (e) {
		var offset = $(this.dom.cloneParent).offset();
		var area = {
			left: offset.left,
			top: offset.top,
			right: offset.left + $(this.dom.cloneParent).width(),
			bottom: offset.top + $(this.dom.cloneParent).height()
		};

		return area;
	},

	/**
	 * Returns whether the given reactangles intersect or not
	 *
	 * @private
	 */
	_rectanglesIntersect: function (a, b) {
		var noOverlap =
			a.left >= b.right || b.left >= a.right || a.top >= b.bottom || b.top >= a.bottom;

		return !noOverlap;
	},

	/**
	 * Calculates the index of the row which lays under the given Y position or
	 * returns -1 if no such row
	 *
	 * @param  {integer} insertPoint Position
	 * @private
	 */
	_calcRowIndexByPos: function (bodyY) {
		// Determine where the row is located based on the mouse
		// position

		var dt = this.s.dt;
		var nodes = $.unique(dt.rows({ page: 'current' }).nodes().toArray());
		var rowIndex = -1;
		var headerHeight = $(dt.table().node()).find('thead').outerHeight();

		$.each(nodes, function (i, node) {
			var top = $(node).position().top - headerHeight;
			var bottom = top + $(node).outerHeight();

			if (bodyY >= top && bodyY <= bottom) {
				rowIndex = i;
			}
		});

		return rowIndex;
	},

	/**
	 * Handles key up events and cancels the dragging if ESC key is pressed
	 *
	 * @param  {object} e Mouse move event object
	 * @private
	 */
	_keyup: function (e) {
		var cancelable = this.c.cancelable;

		if (cancelable && e.which === 27) {
			// ESC key is up
			e.preventDefault();
			this._cancel();
		}
	},

	/**
	 * Cancels the dragging, moves target back into its original position
	 * and cleans up the dragging
	 *
	 * @param  {object} e Mouse move event object
	 * @private
	 */
	_cancel: function () {
		var start = this.s.start;
		var insertPoint = start.rowIndex > this.s.lastInsert ? start.rowIndex + 1 : start.rowIndex;

		this._moveTargetIntoPosition(insertPoint);

		this._cleanupDragging();

		// Emit event
		this._emitEvent('row-reorder-canceled', [this.s.start.rowIndex]);
	}
});

/**
 * RowReorder default settings for initialisation
 *
 * @namespace
 * @name RowReorder.defaults
 * @static
 */
RowReorder.defaults = {
	/**
	 * Data point in the host row's data source object for where to get and set
	 * the data to reorder. This will normally also be the sorting column.
	 *
	 * @type {Number}
	 */
	dataSrc: 0,

	/**
	 * Editor instance that will be used to perform the update
	 *
	 * @type {DataTable.Editor}
	 */
	editor: null,

	/**
	 * Enable / disable RowReorder's user interaction
	 * @type {Boolean}
	 */
	enable: true,

	/**
	 * Form options to pass to Editor when submitting a change in the row order.
	 * See the Editor `from-options` object for details of the options
	 * available.
	 * @type {Object}
	 */
	formOptions: {},

	/**
	 * Drag handle selector. This defines the element that when dragged will
	 * reorder a row.
	 *
	 * @type {String}
	 */
	selector: 'td:first-child',

	/**
	 * Optionally lock the dragged row's x-position. This can be `true` to
	 * fix the position match the host table's, `false` to allow free movement
	 * of the row, or a number to define an offset from the host table.
	 *
	 * @type {Boolean|number}
	 */
	snapX: false,

	/**
	 * Update the table's data on drop
	 *
	 * @type {Boolean}
	 */
	update: true,

	/**
	 * Selector for children of the drag handle selector that mouseDown events
	 * will be passed through to and drag will not activate
	 *
	 * @type {String}
	 */
	excludedChildren: 'a',

	/**
	 * Enable / disable the canceling of the drag & drop interaction
	 *
	 * @type {Boolean}
	 */
	cancelable: false
};

/*
 * API
 */
var Api = $.fn.dataTable.Api;

// Doesn't do anything - work around for a bug in DT... Not documented
Api.register('rowReorder()', function () {
	return this;
});

Api.register('rowReorder.enable()', function (toggle) {
	if (toggle === undefined) {
		toggle = true;
	}

	return this.iterator('table', function (ctx) {
		if (ctx.rowreorder) {
			ctx.rowreorder.c.enable = toggle;
		}
	});
});

Api.register('rowReorder.disable()', function () {
	return this.iterator('table', function (ctx) {
		if (ctx.rowreorder) {
			ctx.rowreorder.c.enable = false;
		}
	});
});

/**
 * Version information
 *
 * @name RowReorder.version
 * @static
 */
RowReorder.version = '1.5.0';

$.fn.dataTable.RowReorder = RowReorder;
$.fn.DataTable.RowReorder = RowReorder;

// Attach a listener to the document which listens for DataTables initialisation
// events so we can automatically initialise
$(document).on('init.dt.dtr', function (e, settings, json) {
	if (e.namespace !== 'dt') {
		return;
	}

	var init = settings.oInit.rowReorder;
	var defaults = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.rowReorder;

	if (init || defaults) {
		var opts = $.extend({}, init, defaults);

		if (init !== false) {
			new RowReorder(settings, opts);
		}
	}
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-scroller-bs4/js/scroller.bootstrap4.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/datatables.net-scroller-bs4/js/scroller.bootstrap4.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_scroller__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-scroller */ "./node_modules/datatables.net-scroller/js/dataTables.scroller.mjs");
/*! Bootstrap 4 styling wrapper for Scroller
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-scroller/js/dataTables.scroller.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/datatables.net-scroller/js/dataTables.scroller.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! Scroller 2.4.1
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


/**
 * @summary     Scroller
 * @description Virtual rendering for DataTables
 * @version     2.4.1
 * @copyright   SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license/mit
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

/**
 * Scroller is a virtual rendering plug-in for DataTables which allows large
 * datasets to be drawn on screen very quickly. What the virtual rendering means
 * is that only the visible portion of the table (and a bit to either side to make
 * the scrolling smooth) is drawn, while the scrolling container gives the
 * visual impression that the whole table is visible. This is done by making use
 * of the pagination abilities of DataTables and moving the table around in the
 * scrolling container DataTables adds to the page. The scrolling container is
 * forced to the height it would be for the full table display using an extra
 * element.
 *
 * Note that rows in the table MUST all be the same height. Information in a cell
 * which expands on to multiple lines will cause some odd behaviour in the scrolling.
 *
 * Scroller is initialised by simply including the letter 'S' in the sDom for the
 * table you want to have this feature enabled on. Note that the 'S' must come
 * AFTER the 't' parameter in `dom`.
 *
 * Key features include:
 *   <ul class="limit_length">
 *     <li>Speed! The aim of Scroller for DataTables is to make rendering large data sets fast</li>
 *     <li>Full compatibility with deferred rendering in DataTables for maximum speed</li>
 *     <li>Display millions of rows</li>
 *     <li>Integration with state saving in DataTables (scrolling position is saved)</li>
 *     <li>Easy to use</li>
 *   </ul>
 *
 *  @class
 *  @constructor
 *  @global
 *  @param {object} dt DataTables settings object or API instance
 *  @param {object} [opts={}] Configuration object for Scroller. Options
 *    are defined by {@link Scroller.defaults}
 *
 *  @requires jQuery 1.7+
 *  @requires DataTables 1.11.0+
 */
var Scroller = function (dt, opts) {
	/* Sanity check - you just know it will happen */
	if (!(this instanceof Scroller)) {
		alert(
			"Scroller warning: Scroller must be initialised with the 'new' keyword."
		);
		return;
	}

	if (opts === undefined) {
		opts = {};
	}

	var dtApi = $.fn.dataTable.Api(dt);

	/**
	 * Settings object which contains customisable information for the Scroller instance
	 * @namespace
	 * @private
	 * @extends Scroller.defaults
	 */
	this.s = {
		/**
		 * DataTables settings object
		 *  @type     object
		 *  @default  Passed in as first parameter to constructor
		 */
		dt: dtApi.settings()[0],

		/**
		 * DataTables API instance
		 *  @type     DataTable.Api
		 */
		dtApi: dtApi,

		/**
		 * Pixel location of the top of the drawn table in the viewport
		 *  @type     int
		 *  @default  0
		 */
		tableTop: 0,

		/**
		 * Pixel location of the bottom of the drawn table in the viewport
		 *  @type     int
		 *  @default  0
		 */
		tableBottom: 0,

		/**
		 * Pixel location of the boundary for when the next data set should be loaded and drawn
		 * when scrolling up the way.
		 *  @type     int
		 *  @default  0
		 *  @private
		 */
		redrawTop: 0,

		/**
		 * Pixel location of the boundary for when the next data set should be loaded and drawn
		 * when scrolling down the way. Note that this is actually calculated as the offset from
		 * the top.
		 *  @type     int
		 *  @default  0
		 *  @private
		 */
		redrawBottom: 0,

		/**
		 * Auto row height or not indicator
		 *  @type     bool
		 *  @default  0
		 */
		autoHeight: true,

		/**
		 * Number of rows calculated as visible in the visible viewport
		 *  @type     int
		 *  @default  0
		 */
		viewportRows: 0,

		/**
		 * setTimeout reference for state saving, used when state saving is enabled in the DataTable
		 * and when the user scrolls the viewport in order to stop the cookie set taking too much
		 * CPU!
		 *  @type     int
		 *  @default  0
		 */
		stateTO: null,

		stateSaveThrottle: function () {},

		/**
		 * setTimeout reference for the redraw, used when server-side processing is enabled in the
		 * DataTables in order to prevent DoSing the server
		 *  @type     int
		 *  @default  null
		 */
		drawTO: null,

		heights: {
			jump: null,
			page: null,
			virtual: null,
			scroll: null,

			/**
			 * Height of rows in the table
			 *  @type     int
			 *  @default  0
			 */
			row: null,

			/**
			 * Pixel height of the viewport
			 *  @type     int
			 *  @default  0
			 */
			viewport: null,
			labelHeight: 0,
			xbar: 0
		},

		topRowFloat: 0,
		scrollDrawDiff: null,
		loaderVisible: false,
		forceReposition: false,
		baseRowTop: 0,
		baseScrollTop: 0,
		mousedown: false,
		lastScrollTop: 0
	};

	// @todo The defaults should extend a `c` property and the internal settings
	// only held in the `s` property. At the moment they are mixed
	this.s = $.extend(this.s, Scroller.oDefaults, opts);

	// Workaround for row height being read from height object (see above comment)
	this.s.heights.row = this.s.rowHeight;

	/**
	 * DOM elements used by the class instance
	 * @private
	 * @namespace
	 *
	 */
	this.dom = {
		force: document.createElement('div'),
		label: $('<div class="dts_label">0</div>'),
		scroller: null,
		table: null,
		loader: null
	};

	// Attach the instance to the DataTables instance so it can be accessed in
	// future. Don't initialise Scroller twice on the same table
	if (this.s.dt.oScroller) {
		return;
	}

	this.s.dt.oScroller = this;

	/* Let's do it */
	this.construct();
};

$.extend(Scroller.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Public methods - to be exposed via the DataTables API
	 */

	/**
	 * Calculate and store information about how many rows are to be displayed
	 * in the scrolling viewport, based on current dimensions in the browser's
	 * rendering. This can be particularly useful if the table is initially
	 * drawn in a hidden element - for example in a tab.
	 *  @param {bool} [redraw=true] Redraw the table automatically after the recalculation, with
	 *    the new dimensions forming the basis for the draw.
	 *  @returns {void}
	 */
	measure: function (redraw) {
		if (this.s.autoHeight) {
			this._calcRowHeight();
		}

		var heights = this.s.heights;

		if (heights.row) {
			heights.viewport = this._parseHeight(
				$(this.dom.scroller).css('max-height')
			);

			this.s.viewportRows =
				parseInt(heights.viewport / heights.row, 10) + 1;
			this.s.dt._iDisplayLength =
				this.s.viewportRows * this.s.displayBuffer;
		}

		var label = this.dom.label.outerHeight();

		heights.xbar =
			this.dom.scroller.offsetHeight - this.dom.scroller.clientHeight;
		heights.labelHeight = label;

		if (redraw === undefined || redraw) {
			this.s.dtApi.draw(false);
		}
	},

	/**
	 * Get information about current displayed record range. This corresponds to
	 * the information usually displayed in the "Info" block of the table.
	 *
	 * @returns {object} info as an object:
	 *  {
	 *      start: {int}, // the 0-indexed record at the top of the viewport
	 *      end:   {int}, // the 0-indexed record at the bottom of the viewport
	 *  }
	 */
	pageInfo: function () {
		var dt = this.s.dt,
			iScrollTop = this.dom.scroller.scrollTop,
			iTotal = dt.fnRecordsDisplay(),
			iPossibleEnd = Math.ceil(
				this.pixelsToRow(
					iScrollTop + this.s.heights.viewport,
					false,
					this.s.ani
				)
			);

		return {
			start: Math.floor(this.pixelsToRow(iScrollTop, false, this.s.ani)),
			end: iTotal < iPossibleEnd ? iTotal - 1 : iPossibleEnd - 1
		};
	},

	/**
	 * Calculate the row number that will be found at the given pixel position
	 * (y-scroll).
	 *
	 * Please note that when the height of the full table exceeds 1 million
	 * pixels, Scroller switches into a non-linear mode for the scrollbar to fit
	 * all of the records into a finite area, but this function returns a linear
	 * value (relative to the last non-linear positioning).
	 *  @param {int} pixels Offset from top to calculate the row number of
	 *  @param {int} [intParse=true] If an integer value should be returned
	 *  @param {int} [virtual=false] Perform the calculations in the virtual domain
	 *  @returns {int} Row index
	 */
	pixelsToRow: function (pixels, intParse, virtual) {
		var diff = pixels - this.s.baseScrollTop;
		var row = virtual
			? (this._domain('physicalToVirtual', this.s.baseScrollTop) + diff) /
				this.s.heights.row
			: diff / this.s.heights.row + this.s.baseRowTop;

		return intParse || intParse === undefined ? parseInt(row, 10) : row;
	},

	/**
	 * Calculate the pixel position from the top of the scrolling container for
	 * a given row
	 *  @param {int} iRow Row number to calculate the position of
	 *  @returns {int} Pixels
	 */
	rowToPixels: function (rowIdx, intParse, virtual) {
		var pixels;
		var diff = rowIdx - this.s.baseRowTop;

		if (virtual) {
			pixels = this._domain('virtualToPhysical', this.s.baseScrollTop);
			pixels += diff * this.s.heights.row;
		}
		else {
			pixels = this.s.baseScrollTop;
			pixels += diff * this.s.heights.row;
		}

		return intParse || intParse === undefined
			? parseInt(pixels, 10)
			: pixels;
	},

	/**
	 * Calculate the row number that will be found at the given pixel position (y-scroll)
	 *  @param {int} row Row index to scroll to
	 *  @param {bool} [animate=true] Animate the transition or not
	 *  @returns {void}
	 */
	scrollToRow: function (row, animate) {
		var that = this;
		var ani = false;
		var px = this.rowToPixels(row);

		// We need to know if the table will redraw or not before doing the
		// scroll. If it will not redraw, then we need to use the currently
		// displayed table, and scroll with the physical pixels. Otherwise, we
		// need to calculate the table's new position from the virtual
		// transform.
		var preRows = ((this.s.displayBuffer - 1) / 2) * this.s.viewportRows;
		var drawRow = row - preRows;
		if (drawRow < 0) {
			drawRow = 0;
		}

		if (
			(px > this.s.redrawBottom || px < this.s.redrawTop) &&
			this.s.dt._iDisplayStart !== drawRow
		) {
			ani = true;
			px = this._domain('virtualToPhysical', row * this.s.heights.row);

			// If we need records outside the current draw region, but the new
			// scrolling position is inside that (due to the non-linear nature
			// for larger numbers of records), we need to force position update.
			if (this.s.redrawTop < px && px < this.s.redrawBottom) {
				this.s.forceReposition = true;
				animate = false;
			}
		}

		if (animate === undefined || animate) {
			this.s.ani = ani;
			$(this.dom.scroller).animate(
				{
					scrollTop: px
				},
				function () {
					// This needs to happen after the animation has completed and
					// the final scroll event fired
					setTimeout(function () {
						that.s.ani = false;
					}, 250);
				}
			);
		}
		else {
			$(this.dom.scroller).scrollTop(px);
		}
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */

	/**
	 * Initialisation for Scroller
	 *  @returns {void}
	 *  @private
	 */
	construct: function () {
		var that = this;
		var dt = this.s.dtApi;

		/* Sanity check */
		if (!this.s.dt.oFeatures.bPaginate) {
			throw new Error(
				'Pagination must be enabled for Scroller to operate'
			);
		}

		/* Insert a div element that we can use to force the DT scrolling container to
		 * the height that would be required if the whole table was being displayed
		 */
		this.dom.force.style.position = 'relative';
		this.dom.force.style.top = '0px';
		this.dom.force.style.left = '0px';
		this.dom.force.style.width = '1px';

		this.dom.scroller = dt.table().node().parentNode;
		this.dom.scroller.appendChild(this.dom.force);
		this.dom.scroller.style.position = 'relative';

		this.dom.table = $('>table', this.dom.scroller)[0];
		this.dom.table.style.position = 'absolute';
		this.dom.table.style.top = '0px';
		this.dom.table.style.left = '0px';

		// Add class to 'announce' that we are a Scroller table
		$(dt.table().container()).addClass('dts DTS');

		this.dom.label.appendTo(this.dom.scroller);

		/* Initial size calculations */
		if (this.s.heights.row && this.s.heights.row != 'auto') {
			this.s.autoHeight = false;
		}

		// Scrolling callback to see if a page change is needed
		this.s.ingnoreScroll = true;
		$(this.dom.scroller).on('scroll.dt-scroller', function (e) {
			that._scroll.call(that);
		});

		// In iOS we catch the touchstart event in case the user tries to scroll
		// while the display is already scrolling
		$(this.dom.scroller).on('touchstart.dt-scroller', function () {
			that._scroll.call(that);
		});

		$(this.dom.scroller)
			.on('mousedown.dt-scroller', function () {
				that.s.mousedown = true;
			})
			.on('mouseup.dt-scroller', function () {
				that.s.labelVisible = false;
				that.s.mousedown = false;
				that.dom.label.css('display', 'none');
			});

		// On resize, update the information element, since the number of rows shown might change
		$(window).on('resize.dt-scroller', function () {
			that.measure(false);
			that._info();
		});

		// Add a state saving parameter to the DT state saving so we can restore the exact
		// position of the scrolling.
		var initialStateSave = true;
		var loadedState = dt.state.loaded();

		dt.on('stateSaveParams.scroller', function (e, settings, data) {
			if (initialStateSave && loadedState) {
				data.scroller = loadedState.scroller;
				initialStateSave = false;

				if (data.scroller) {
					that.s.lastScrollTop = data.scroller.scrollTop;
				}
			}
			else {
				// Need to used the saved position on init
				data.scroller = {
					topRow: that.s.topRowFloat,
					baseRowTop: that.s.baseRowTop
				};
			}
		});

		dt.on('stateLoadParams.scroller', function (e, settings, data) {
			if (data.scroller !== undefined) {
				that.scrollToRow(data.scroller.topRow);
			}
		});

		this.measure(false);

		if (loadedState && loadedState.scroller) {
			this.s.topRowFloat = loadedState.scroller.topRow;
			this.s.baseRowTop = loadedState.scroller.baseRowTop;

			// Reconstruct the scroll positions from the rows - it is possible the
			// row height has changed e.g. if the styling framework has changed.
			// The scroll top is used in `_draw` further down.
			this.s.baseScrollTop = this.s.baseRowTop * this.s.heights.row;			
			loadedState.scroller.scrollTop = this._domain('physicalToVirtual', this.s.topRowFloat * this.s.heights.row);
		}

		that.s.stateSaveThrottle = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.throttle(function () {
			that.s.dtApi.state.save();
		}, 500);

		dt.on('init.scroller', function () {
			that.measure(false);

			// Setting to `jump` will instruct _draw to calculate the scroll top
			// position
			that.s.scrollType = 'jump';
			that._draw();

			// Update the scroller when the DataTable is redrawn
			dt.on('draw.scroller', function () {
				that._draw();
			});
		});

		// Set height before the draw happens, allowing everything else to update
		// on draw complete without worry for roder.
		dt.on('preDraw.dt.scroller', function () {
			that._scrollForce();
		});

		// Destructor
		dt.on('destroy.scroller', function () {
			$(window).off('resize.dt-scroller');
			$(that.dom.scroller).off('.dt-scroller');
			$(that.s.dt.nTable).off('.scroller');

			$(that.s.dt.nTableWrapper).removeClass('DTS');
			$('div.DTS_Loading', that.dom.scroller.parentNode).remove();

			that.dom.table.style.position = '';
			that.dom.table.style.top = '';
			that.dom.table.style.left = '';
		});
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Automatic calculation of table row height. This is just a little tricky here as using
	 * initialisation DataTables has tale the table out of the document, so we need to create
	 * a new table and insert it into the document, calculate the row height and then whip the
	 * table out.
	 *  @returns {void}
	 *  @private
	 */
	_calcRowHeight: function () {
		var dt = this.s.dt;
		var origTable = dt.nTable;
		var nTable = origTable.cloneNode(false);
		var tbody = $('<tbody/>').appendTo(nTable);
		var dtClasses = dt.oClasses;

		// Different locations for classes in DT2
		var classes = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')
			? {
					container: dtClasses.container,
					scroller: dtClasses.scrolling.container,
					body: dtClasses.scrolling.body
			}
			: {
					container: dtClasses.sWrapper,
					scroller: dtClasses.sScrollWrapper,
					body: dtClasses.sScrollBody
			};

		var container = $(
			'<div class="' +
				classes.container +
				' DTS"><div class="' +
				classes.scroller +
				'"><div class="' +
				classes.body +
				'"></div></div></div>'
		);

		// Want 3 rows in the sizing table so :first-child and :last-child
		// CSS styles don't come into play - take the size of the middle row
		$('tbody tr:lt(4)', origTable).clone().appendTo(tbody);
		var rowsCount = $('tr', tbody).length;

		if (rowsCount === 1) {
			tbody.prepend('<tr><td>&#160;</td></tr>');
			tbody.append('<tr><td>&#160;</td></tr>');
		}
		else {
			for (; rowsCount < 3; rowsCount++) {
				tbody.append('<tr><td>&#160;</td></tr>');
			}
		}

		$('div.' + classes.body, container).append(nTable);

		// If initialised using `dom`, use the holding element as the insert point
		var insertEl = this.s.dt.nHolding || origTable.parentNode;

		if (!$(insertEl).is(':visible')) {
			insertEl = 'body';
		}

		// Remove form element links as they might select over others (particularly radio and checkboxes)
		container.find('input').removeAttr('name');

		container.appendTo(insertEl);
		this.s.heights.row = $('tr', tbody).eq(1).outerHeight();

		container.remove();
	},

	/**
	 * Draw callback function which is fired when the DataTable is redrawn. The main function of
	 * this method is to position the drawn table correctly the scrolling container for the rows
	 * that is displays as a result of the scrolling position.
	 *  @returns {void}
	 *  @private
	 */
	_draw: function () {
		var that = this,
			heights = this.s.heights,
			iScrollTop = this.dom.scroller.scrollTop,
			iTableHeight = $(this.s.dt.nTable).height(),
			displayStart = this.s.dt._iDisplayStart,
			displayLen = this.s.dt._iDisplayLength,
			displayEnd = this.s.dt.fnRecordsDisplay(),
			viewportEndY = iScrollTop + heights.viewport;

		// Disable the scroll event listener while we are updating the DOM
		this.s.skip = true;

		// If paging is reset
		if (
			(this.s.dt.bSorted || this.s.dt.bFiltered) &&
			displayStart === 0 &&
			!this.s.dt._drawHold
		) {
			this.s.topRowFloat = 0;
		}

		iScrollTop =
			this.s.scrollType === 'jump'
				? this._domain(
					'virtualToPhysical',
					this.s.topRowFloat * heights.row
				)
				: iScrollTop;

		// Store positional information so positional calculations can be based
		// upon the current table draw position
		this.s.baseScrollTop = iScrollTop;
		this.s.baseRowTop = this.s.topRowFloat;

		// Position the table in the virtual scroller
		var tableTop =
			iScrollTop - (this.s.topRowFloat - displayStart) * heights.row;
		if (displayStart === 0) {
			tableTop = 0;
		}
		else if (displayStart + displayLen >= displayEnd) {
			tableTop = heights.scroll - iTableHeight;
		}
		else {
			var iTableBottomY = tableTop + iTableHeight;
			if (iTableBottomY < viewportEndY) {
				// The last row of the data is above the end of the viewport.
				// This means the background is visible, which is not what the user expects.
				var newTableTop = viewportEndY - iTableHeight;
				var diffPx = newTableTop - tableTop;
				this.s.baseScrollTop += diffPx + 1; // Update start row number in footer.
				tableTop = newTableTop; // Move table so last line of data is at the bottom of the viewport.
			}
		}

		this.dom.table.style.top = tableTop + 'px';

		/* Cache some information for the scroller */
		this.s.tableTop = tableTop;
		this.s.tableBottom = iTableHeight + this.s.tableTop;

		// Calculate the boundaries for where a redraw will be triggered by the
		// scroll event listener
		var boundaryPx = (iScrollTop - this.s.tableTop) * this.s.boundaryScale;
		this.s.redrawTop = iScrollTop - boundaryPx;
		this.s.redrawBottom =
			iScrollTop + boundaryPx >
			heights.scroll - heights.viewport - heights.row
				? heights.scroll - heights.viewport - heights.row
				: iScrollTop + boundaryPx;

		this.s.skip = false;

		if (that.s.ingnoreScroll) {
			// Restore the scrolling position that was saved by DataTable's state
			// saving Note that this is done on the second draw when data is Ajax
			// sourced, and the first draw when DOM soured
			if (
				this.s.dt.oFeatures.bStateSave &&
				this.s.dt.oLoadedState !== null &&
				typeof this.s.dt.oLoadedState.scroller != 'undefined'
			) {
				// A quirk of DataTables is that the draw callback will occur on an
				// empty set if Ajax sourced, but not if server-side processing.
				var ajaxSourced =
					(this.s.dt.sAjaxSource || that.s.dt.ajax) &&
					!this.s.dt.oFeatures.bServerSide
						? true
						: false;

				if (
					(ajaxSourced && this.s.dt.iDraw >= 2) ||
					(!ajaxSourced && this.s.dt.iDraw >= 1)
				) {
					setTimeout(function () {
						$(that.dom.scroller).scrollTop(
							that.s.dt.oLoadedState.scroller.scrollTop
						);

						// In order to prevent layout thrashing we need another
						// small delay
						setTimeout(function () {
							that.s.ingnoreScroll = false;
						}, 0);
					}, 0);
				}
			}
			else {
				that.s.ingnoreScroll = false;
			}
		}

		// Because of the order of the DT callbacks, the info update will
		// take precedence over the one we want here. So a 'thread' break is
		// needed.  Only add the thread break if bInfo is set
		if (this.s.dt.oFeatures.bInfo) {
			setTimeout(function () {
				that._info.call(that);
			}, 0);
		}

		$(this.s.dt.nTable).triggerHandler('position.dts.dt', tableTop);
	},

	/**
	 * Convert from one domain to another. The physical domain is the actual
	 * pixel count on the screen, while the virtual is if we had browsers which
	 * had scrolling containers of infinite height (i.e. the absolute value)
	 *
	 *  @param {string} dir Domain transform direction, `virtualToPhysical` or
	 *    `physicalToVirtual`
	 *  @returns {number} Calculated transform
	 *  @private
	 */
	_domain: function (dir, val) {
		var heights = this.s.heights;
		var diff;
		var magic = 10000; // the point at which the non-linear calculations start to happen

		// If the virtual and physical height match, then we use a linear
		// transform between the two, allowing the scrollbar to be linear
		if (heights.virtual === heights.scroll) {
			return val;
		}

		// In the first 10k pixels and the last 10k pixels, we want the scrolling
		// to be linear. After that it can be non-linear. It would be unusual for
		// anyone to mouse wheel through that much.
		if (val < magic) {
			return val;
		}
		else if (
			dir === 'virtualToPhysical' &&
			val >= heights.virtual - magic
		) {
			diff = heights.virtual - val;
			return heights.scroll - diff;
		}
		else if (dir === 'physicalToVirtual' && val >= heights.scroll - magic) {
			diff = heights.scroll - val;
			return heights.virtual - diff;
		}

		// Otherwise, we want a non-linear scrollbar to take account of the
		// redrawing regions at the start and end of the table, otherwise these
		// can stutter badly - on large tables 30px (for example) scroll might
		// be hundreds of rows, so the table would be redrawing every few px at
		// the start and end. Use a simple linear eq. to stop this, effectively
		// causing a kink in the scrolling ratio. It does mean the scrollbar is
		// non-linear, but with such massive data sets, the scrollbar is going
		// to be a best guess anyway
		var m =
			(heights.virtual - magic - magic) /
			(heights.scroll - magic - magic);
		var c = magic - m * magic;

		return dir === 'virtualToPhysical' ? (val - c) / m : m * val + c;
	},

	/**
	 * Update any information elements that are controlled by the DataTable based on the scrolling
	 * viewport and what rows are visible in it. This function basically acts in the same way as
	 * _fnUpdateInfo in DataTables, and effectively replaces that function.
	 *  @returns {void}
	 *  @private
	 */
	_info: function () {
		if (!this.s.dt.oFeatures.bInfo) {
			return;
		}

		var dt = this.s.dt,
			dtApi = this.s.dtApi,
			language = dt.oLanguage,
			info = dtApi.page.info(),
			total = info.recordsDisplay,
			max = info.recordsTotal;

		// If the scroll type is `cont` (continuous) we need to use `baseRowTop`, which
		// also means we need to work out the difference between the current scroll position
		// and the "base" for when it was required
		var diffRows = (this.s.lastScrollTop - this.s.baseScrollTop) / this.s.heights.row;
		var start = Math.floor(this.s.baseRowTop + diffRows);

		// For a jump scroll type, we just use the straightforward calculation based on
		// `topRowFloat`
		if (this.s.scrollType === 'jump') {
			start = Math.floor(this.s.topRowFloat) + 1;
		}

		var
			possibleEnd = start + Math.floor(this.s.heights.viewport / this.s.heights.row),
			end = possibleEnd > total ? total : possibleEnd,
			result;

		if (total === 0 && total == max) {
			/* Empty record set */
			result = language.sInfoEmpty + language.sInfoPostFix;
		}
		else if (total === 0) {
			// Empty record set after filtering
			result =
				language.sInfoEmpty +
				' ' +
				language.sInfoFiltered +
				language.sInfoPostFix;
		}
		else if (total == max) {
			// Normal record set
			result = language.sInfo + language.sInfoPostFix;
		}
		else {
			// Record set after filtering
			result = language.sInfo + ' ' + language.sInfoFiltered + language.sInfoPostFix;
		}

		result = this._macros(result, start, end, max, total);

		var callback = language.fnInfoCallback;
		if (callback) {
			result = callback.call(
				dt.oInstance,
				dt,
				start,
				end,
				max,
				total,
				result
			);
		}

		// DT 1.x features
		var n = dt.aanFeatures.i;
		if (typeof n != 'undefined') {
			for (var i = 0, iLen = n.length; i < iLen; i++) {
				$(n[i]).html(result);
			}

			$(dt.nTable).triggerHandler('info.dt');
		}

		// DT 2.x features
		$('div.dt-info', dtApi.table().container()).each(function () {
			$(this).html(result);
			dtApi.trigger('info', [dtApi.settings()[0], this, result]);
		});
	},

	/**
	 * String replacement for info display. Basically the same as what DataTables does.
	 *
	 * @param {*} str
	 * @param {*} start
	 * @param {*} end
	 * @param {*} max
	 * @param {*} total
	 * @returns Formatted string
	 */
	_macros: function (str, start, end, max, total) {
		var api = this.s.dtApi;
		var settings = this.s.dt;
		var formatter = settings.fnFormatNumber;

		return str
			.replace(/_START_/g, formatter.call(settings, start))
			.replace(/_END_/g, formatter.call(settings, end))
			.replace(/_MAX_/g, formatter.call(settings, max))
			.replace(/_TOTAL_/g, formatter.call(settings, total))
			.replace(/_ENTRIES_/g, api.i18n('entries', ''))
			.replace(/_ENTRIES-MAX_/g, api.i18n('entries', '', max))
			.replace(/_ENTRIES-TOTAL_/g, api.i18n('entries', '', total));
	},

	/**
	 * Parse CSS height property string as number
	 *
	 * An attempt is made to parse the string as a number. Currently supported units are 'px',
	 * 'vh', and 'rem'. 'em' is partially supported; it works as long as the parent element's
	 * font size matches the body element. Zero is returned for unrecognized strings.
	 *  @param {string} cssHeight CSS height property string
	 *  @returns {number} height
	 *  @private
	 */
	_parseHeight: function (cssHeight) {
		var height;
		var matches = /^([+-]?(?:\d+(?:\.\d+)?|\.\d+))(px|em|rem|vh)$/.exec(
			cssHeight
		);

		if (matches === null) {
			return 0;
		}

		var value = parseFloat(matches[1]);
		var unit = matches[2];

		if (unit === 'px') {
			height = value;
		}
		else if (unit === 'vh') {
			height = (value / 100) * $(window).height();
		}
		else if (unit === 'rem') {
			height = value * parseFloat($(':root').css('font-size'));
		}
		else if (unit === 'em') {
			height = value * parseFloat($('body').css('font-size'));
		}

		return height ? height : 0;
	},

	/**
	 * Scrolling function - fired whenever the scrolling position is changed.
	 * This method needs to use the stored values to see if the table should be
	 * redrawn as we are moving towards the end of the information that is
	 * currently drawn or not. If needed, then it will redraw the table based on
	 * the new position.
	 *  @returns {void}
	 *  @private
	 */
	_scroll: function () {
		var that = this,
			heights = this.s.heights,
			iScrollTop = this.dom.scroller.scrollTop,
			iTopRow;

		if (this.s.skip) {
			return;
		}

		if (this.s.ingnoreScroll) {
			return;
		}

		if (iScrollTop === this.s.lastScrollTop) {
			return;
		}

		/* If the table has been sorted or filtered, then we use the redraw that
		 * DataTables as done, rather than performing our own
		 */
		if (this.s.dt.bFiltered || this.s.dt.bSorted) {
			this.s.lastScrollTop = 0;
			return;
		}

		/* We don't want to state save on every scroll event - that's heavy
		 * handed, so use a timeout to update the state saving only when the
		 * scrolling has finished
		 */
		clearTimeout(this.s.stateTO);
		this.s.stateTO = setTimeout(function () {
			that.s.dtApi.state.save();
		}, 250);

		this.s.scrollType =
			Math.abs(iScrollTop - this.s.lastScrollTop) > heights.viewport
				? 'jump'
				: 'cont';

		this.s.topRowFloat =
			this.s.scrollType === 'cont'
				? this.pixelsToRow(iScrollTop, false, false)
				: this._domain('physicalToVirtual', iScrollTop) / heights.row;

		if (this.s.topRowFloat < 0) {
			this.s.topRowFloat = 0;
		}

		/* Check if the scroll point is outside the trigger boundary which would required
		 * a DataTables redraw
		 */
		if (
			this.s.forceReposition ||
			iScrollTop < this.s.redrawTop ||
			iScrollTop > this.s.redrawBottom
		) {
			var preRows = Math.ceil(
				((this.s.displayBuffer - 1) / 2) * this.s.viewportRows
			);

			iTopRow = parseInt(this.s.topRowFloat, 10) - preRows;
			this.s.forceReposition = false;

			if (iTopRow <= 0) {
				/* At the start of the table */
				iTopRow = 0;
			}
			else if (
				iTopRow + this.s.dt._iDisplayLength >
				this.s.dt.fnRecordsDisplay()
			) {
				/* At the end of the table */
				iTopRow =
					this.s.dt.fnRecordsDisplay() - this.s.dt._iDisplayLength;
				if (iTopRow < 0) {
					iTopRow = 0;
				}
			}
			else if (iTopRow % 2 !== 0) {
				// For the row-striping classes (odd/even) we want only to start
				// on evens otherwise the stripes will change between draws and
				// look rubbish
				iTopRow++;
			}

			// Store calcuated value, in case the following condition is not met, but so
			// that the draw function will still use it.
			this.s.targetTop = iTopRow;

			if (iTopRow != this.s.dt._iDisplayStart) {
				/* Cache the new table position for quick lookups */
				this.s.tableTop = $(this.s.dt.nTable).offset().top;
				this.s.tableBottom =
					$(this.s.dt.nTable).height() + this.s.tableTop;

				var draw = function () {
					that.s.dt._iDisplayStart = that.s.targetTop;
					that.s.dtApi.draw('page');
				};

				/* Do the DataTables redraw based on the calculated start point - note that when
				 * using server-side processing we introduce a small delay to not DoS the server...
				 */
				if (this.s.dt.oFeatures.bServerSide) {
					this.s.forceReposition = true;

					// This is used only for KeyTable and is not currently publicly
					// documented. Open question - is it useful for anything else?
					$(this.s.dt.nTable).triggerHandler('scroller-will-draw.dt');

					if (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')) {
						that.s.dtApi.processing(true);
					}
					else {
						this.s.dt.oApi._fnProcessingDisplay(this.s.dt, true);
					}

					clearTimeout(this.s.drawTO);
					this.s.drawTO = setTimeout(draw, this.s.serverWait);
				}
				else {
					draw();
				}
			}
		}
		else {
			this.s.topRowFloat = this.pixelsToRow(iScrollTop, false, true);
		}

		/* Update the table's information display for what is now in the viewport */
		this._info();

		this.s.lastScrollTop = iScrollTop;
		this.s.stateSaveThrottle();

		if (this.s.scrollType === 'jump' && this.s.mousedown) {
			this.s.labelVisible = true;
		}
		if (this.s.labelVisible) {
			var labelFactor =
				(heights.viewport - heights.labelHeight - heights.xbar) /
				heights.scroll;

			this.dom.label
				.html(
					this.s.dt.fnFormatNumber(
						parseInt(this.s.topRowFloat, 10) + 1
					)
				)
				.css('top', iScrollTop + iScrollTop * labelFactor)
				.css('display', 'block');
		}
	},

	/**
	 * Force the scrolling container to have height beyond that of just the
	 * table that has been drawn so the user can scroll the whole data set.
	 *
	 * Note that if the calculated required scrolling height exceeds a maximum
	 * value (1 million pixels - hard-coded) the forcing element will be set
	 * only to that maximum value and virtual / physical domain transforms will
	 * be used to allow Scroller to display tables of any number of records.
	 *  @returns {void}
	 *  @private
	 */
	_scrollForce: function () {
		var heights = this.s.heights;
		var max = 1000000;

		heights.virtual = heights.row * this.s.dt.fnRecordsDisplay();
		heights.scroll = heights.virtual;

		if (heights.scroll > max) {
			heights.scroll = max;
		}

		// Minimum height so there is always a row visible (the 'no rows found'
		// if reduced to zero filtering)
		this.dom.force.style.height =
			heights.scroll > this.s.heights.row
				? heights.scroll + 'px'
				: this.s.heights.row + 'px';
	}
});

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Statics
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**
 * Scroller default settings for initialisation
 *  @namespace
 *  @name Scroller.defaults
 *  @static
 */
Scroller.defaults = {
	/**
	 * Scroller uses the boundary scaling factor to decide when to redraw the table - which it
	 * typically does before you reach the end of the currently loaded data set (in order to
	 * allow the data to look continuous to a user scrolling through the data). If given as 0
	 * then the table will be redrawn whenever the viewport is scrolled, while 1 would not
	 * redraw the table until the currently loaded data has all been shown. You will want
	 * something in the middle - the default factor of 0.5 is usually suitable.
	 *  @type     float
	 *  @default  0.5
	 *  @static
	 */
	boundaryScale: 0.5,

	/**
	 * The display buffer is what Scroller uses to calculate how many rows it should pre-fetch
	 * for scrolling. Scroller automatically adjusts DataTables' display length to pre-fetch
	 * rows that will be shown in "near scrolling" (i.e. just beyond the current display area).
	 * The value is based upon the number of rows that can be displayed in the viewport (i.e.
	 * a value of 1), and will apply the display range to records before before and after the
	 * current viewport - i.e. a factor of 3 will allow Scroller to pre-fetch 1 viewport's worth
	 * of rows before the current viewport, the current viewport's rows and 1 viewport's worth
	 * of rows after the current viewport. Adjusting this value can be useful for ensuring
	 * smooth scrolling based on your data set.
	 *  @type     int
	 *  @default  9
	 *  @static
	 */
	displayBuffer: 9,

	/**
	 * Scroller will attempt to automatically calculate the height of rows for it's internal
	 * calculations. However the height that is used can be overridden using this parameter.
	 *  @type     int|string
	 *  @default  auto
	 *  @static
	 */
	rowHeight: 'auto',

	/**
	 * When using server-side processing, Scroller will wait a small amount of time to allow
	 * the scrolling to finish before requesting more data from the server. This prevents
	 * you from DoSing your own server! The wait time can be configured by this parameter.
	 *  @type     int
	 *  @default  200
	 *  @static
	 */
	serverWait: 200
};

Scroller.oDefaults = Scroller.defaults;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Constants
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**
 * Scroller version
 *  @type      String
 *  @default   See code
 *  @name      Scroller.version
 *  @static
 */
Scroller.version = '2.4.1';

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Initialisation
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// Attach a listener to the document which listens for DataTables initialisation
// events so we can automatically initialise
$(document).on('preInit.dt.dtscroller', function (e, settings) {
	if (e.namespace !== 'dt') {
		return;
	}

	var init = settings.oInit.scroller;
	var defaults = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.scroller;

	if (init || defaults) {
		var opts = $.extend({}, init, defaults);

		if (init !== false) {
			new Scroller(settings, opts);
		}
	}
});

// Attach Scroller to DataTables so it can be accessed as an 'extra'
$.fn.dataTable.Scroller = Scroller;
$.fn.DataTable.Scroller = Scroller;

// DataTables 1.10 API method aliases
var Api = $.fn.dataTable.Api;

Api.register('scroller()', function () {
	return this;
});

// Undocumented and deprecated - is it actually useful at all?
Api.register('scroller().rowToPixels()', function (rowIdx, intParse, virtual) {
	var ctx = this.context;

	if (ctx.length && ctx[0].oScroller) {
		return ctx[0].oScroller.rowToPixels(rowIdx, intParse, virtual);
	}
	// undefined
});

// Undocumented and deprecated - is it actually useful at all?
Api.register('scroller().pixelsToRow()', function (pixels, intParse, virtual) {
	var ctx = this.context;

	if (ctx.length && ctx[0].oScroller) {
		return ctx[0].oScroller.pixelsToRow(pixels, intParse, virtual);
	}
	// undefined
});

// `scroller().scrollToRow()` is undocumented and deprecated. Use `scroller.toPosition()
Api.register(
	['scroller().scrollToRow()', 'scroller.toPosition()'],
	function (idx, ani) {
		this.iterator('table', function (ctx) {
			if (ctx.oScroller) {
				ctx.oScroller.scrollToRow(idx, ani);
			}
		});

		return this;
	}
);

Api.register('row().scrollTo()', function (ani) {
	var that = this;

	this.iterator('row', function (ctx, rowIdx) {
		if (ctx.oScroller) {
			var displayIdx = that
				.rows({ order: 'applied', search: 'applied' })
				.indexes()
				.indexOf(rowIdx);

			ctx.oScroller.scrollToRow(displayIdx, ani);
		}
	});

	return this;
});

Api.register('scroller.measure()', function (redraw) {
	this.iterator('table', function (ctx) {
		if (ctx.oScroller) {
			ctx.oScroller.measure(redraw);
		}
	});

	return this;
});

Api.register('scroller.page()', function () {
	var ctx = this.context;

	if (ctx.length && ctx[0].oScroller) {
		return ctx[0].oScroller.pageInfo();
	}
	// undefined
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-select-bs4/js/select.bootstrap4.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/datatables.net-select-bs4/js/select.bootstrap4.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-bs4 */ "./node_modules/datatables.net-bs4/js/dataTables.bootstrap4.mjs");
/* harmony import */ var datatables_net_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-select */ "./node_modules/datatables.net-select/js/dataTables.select.mjs");
/*! Bootstrap 4 styling wrapper for Select
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_bs4__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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