"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_datatables_net-buttons-dt_js_buttons_dataTables_mjs"],{

/***/ "./node_modules/datatables.net-buttons-dt/js/buttons.dataTables.mjs":
/*!**************************************************************************!*\
  !*** ./node_modules/datatables.net-buttons-dt/js/buttons.dataTables.mjs ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net_dt__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net-dt */ "./node_modules/datatables.net-dt/js/dataTables.dataTables.mjs");
/* harmony import */ var datatables_net_buttons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons-dt/node_modules/datatables.net-buttons/js/dataTables.buttons.mjs");
/*! DataTables styling wrapper for Buttons
 * © SpryMedia Ltd - datatables.net/license
 */





// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net_dt__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-buttons-dt/node_modules/datatables.net-buttons/js/dataTables.buttons.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/datatables.net-buttons-dt/node_modules/datatables.net-buttons/js/dataTables.buttons.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! Buttons for DataTables 3.2.6
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


// Used for namespacing events added to the document by each instance, so they
// can be removed on destroy
var _instCounter = 0;

// Button namespacing counter for namespacing events on individual buttons
var _buttonCounter = 0;

var _dtButtons = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons;

// Custom entity decoder for data export
var _entityDecoder = null;

// Allow for jQuery slim
function _fadeIn(el, duration, fn) {
	if ($.fn.animate) {
		el.stop().fadeIn(duration, fn);
	}
	else {
		el.css('display', 'block');

		if (fn) {
			fn.call(el);
		}
	}
}

function _fadeOut(el, duration, fn) {
	if ($.fn.animate) {
		el.stop().fadeOut(duration, fn);
	}
	else {
		el.css('display', 'none');

		if (fn) {
			fn.call(el);
		}
	}
}

/**
 * [Buttons description]
 * @param {[type]}
 * @param {[type]}
 */
var Buttons = function (dt, config) {
	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')) {
		throw 'Warning: Buttons requires DataTables 2 or newer';
	}

	// If not created with a `new` keyword then we return a wrapper function that
	// will take the settings object for a DT. This allows easy use of new instances
	// with the `layout` option - e.g. `topLeft: $.fn.dataTable.Buttons( ... )`.
	if (!(this instanceof Buttons)) {
		return function (settings) {
			return new Buttons(settings, dt).container();
		};
	}

	// If there is no config set it to an empty object
	if (typeof config === 'undefined') {
		config = {};
	}

	// Allow a boolean true for defaults
	if (config === true) {
		config = {};
	}

	// For easy configuration of buttons an array can be given
	if (Array.isArray(config)) {
		config = { buttons: config };
	}

	this.c = $.extend(true, {}, Buttons.defaults, config);

	// Don't want a deep copy for the buttons
	if (config.buttons) {
		this.c.buttons = config.buttons;
	}

	this.s = {
		dt: new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(dt),
		buttons: [],
		listenKeys: '',
		namespace: 'dtb' + _instCounter++
	};

	this.dom = {
		container: $('<' + this.c.dom.container.tag + '/>').addClass(
			this.c.dom.container.className
		)
	};

	this._constructor();
};

$.extend(Buttons.prototype, {
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Public methods
	 */

	/**
	 * Get the action of a button
	 * @param  {int|string} Button index
	 * @return {function}
	 */ /**
	 * Set the action of a button
	 * @param  {node} node Button element
	 * @param  {function} action Function to set
	 * @return {Buttons} Self for chaining
	 */
	action: function (node, action) {
		var button = this._nodeToButton(node);

		if (action === undefined) {
			return button.conf.action;
		}

		button.conf.action = action;

		return this;
	},

	/**
	 * Add an active class to the button to make to look active or get current
	 * active state.
	 * @param  {node} node Button element
	 * @param  {boolean} [flag] Enable / disable flag
	 * @return {Buttons} Self for chaining or boolean for getter
	 */
	active: function (node, flag) {
		var button = this._nodeToButton(node);
		var klass = this.c.dom.button.active;
		var jqNode = $(button.node);

		if (
			button.inCollection &&
			this.c.dom.collection.button &&
			this.c.dom.collection.button.active !== undefined
		) {
			klass = this.c.dom.collection.button.active;
		}

		if (flag === undefined) {
			return jqNode.hasClass(klass);
		}

		jqNode.toggleClass(klass, flag === undefined ? true : flag);

		return this;
	},

	/**
	 * Add a new button
	 * @param {object} config Button configuration object, base string name or function
	 * @param {int|string} [idx] Button index for where to insert the button
	 * @param {boolean} [draw=true] Trigger a draw. Set a false when adding
	 *   lots of buttons, until the last button.
	 * @return {Buttons} Self for chaining
	 */
	add: function (config, idx, draw) {
		var buttons = this.s.buttons;

		if (typeof idx === 'string') {
			var split = idx.split('-');
			var base = this.s;

			for (var i = 0, ien = split.length - 1; i < ien; i++) {
				base = base.buttons[split[i] * 1];
			}

			buttons = base.buttons;
			idx = split[split.length - 1] * 1;
		}

		let node = this._expandButton(
			buttons,
			config,
			config !== undefined ? config.split : undefined,
			(config === undefined ||
				config.split === undefined ||
				config.split.length === 0) &&
				base !== undefined,
			false,
			idx
		);

		if (draw === undefined || draw === true) {
			this._draw();
		}

		return node;
	},

	/**
	 * Clear buttons from a collection and then insert new buttons
	 */
	collectionRebuild: function (node, newButtons) {
		var button = this._nodeToButton(node);

		if (newButtons !== undefined) {
			var i;
			// Need to reverse the array
			for (i = button.buttons.length - 1; i >= 0; i--) {
				this.remove(button.buttons[i].node);
			}

			// If the collection has prefix and / or postfix buttons we need to add them in
			if (button.conf.prefixButtons) {
				newButtons.unshift.apply(newButtons, button.conf.prefixButtons);
			}

			if (button.conf.postfixButtons) {
				newButtons.push.apply(newButtons, button.conf.postfixButtons);
			}

			for (i = 0; i < newButtons.length; i++) {
				var newBtn = newButtons[i];

				this._expandButton(
					button.buttons,
					newBtn,
					newBtn !== undefined &&
						newBtn.config !== undefined &&
						newBtn.config.split !== undefined,
					true,
					newBtn.parentConf !== undefined &&
						newBtn.parentConf.split !== undefined,
					null,
					newBtn.parentConf
				);
			}
		}

		this._draw(button.collection, button.buttons);
	},

	/**
	 * Get the container node for the buttons
	 * @return {jQuery} Buttons node
	 */
	container: function () {
		return this.dom.container;
	},

	/**
	 * Disable a button
	 * @param  {node} node Button node
	 * @return {Buttons} Self for chaining
	 */
	disable: function (node) {
		var button = this._nodeToButton(node);

		if (button.isSplit) {
			$(button.node.childNodes[0])
				.addClass(this.c.dom.button.disabled)
				.prop('disabled', true);
		}
		else {
			$(button.node)
				.addClass(this.c.dom.button.disabled)
				.prop('disabled', true);
		}

		button.disabled = true;

		this._checkSplitEnable();

		return this;
	},

	/**
	 * Destroy the instance, cleaning up event handlers and removing DOM
	 * elements
	 * @return {Buttons} Self for chaining
	 */
	destroy: function () {
		// Key event listener
		$('body').off('keyup.' + this.s.namespace);

		// Individual button destroy (so they can remove their own events if
		// needed). Take a copy as the array is modified by `remove`
		var buttons = this.s.buttons.slice();
		var i, ien;

		for (i = 0, ien = buttons.length; i < ien; i++) {
			this.remove(buttons[i].node);
		}

		// Container
		this.dom.container.remove();

		// Remove from the settings object collection
		var buttonInsts = this.s.dt.settings()[0];

		for (i = 0, ien = buttonInsts.length; i < ien; i++) {
			if (buttonInsts.inst === this) {
				buttonInsts.splice(i, 1);
				break;
			}
		}

		return this;
	},

	/**
	 * Enable / disable a button
	 * @param  {node} node Button node
	 * @param  {boolean} [flag=true] Enable / disable flag
	 * @return {Buttons} Self for chaining
	 */
	enable: function (node, flag) {
		if (flag === false) {
			return this.disable(node);
		}

		var button = this._nodeToButton(node);

		if (button.isSplit) {
			$(button.node.childNodes[0])
				.removeClass(this.c.dom.button.disabled)
				.prop('disabled', false);
		}
		else {
			$(button.node)
				.removeClass(this.c.dom.button.disabled)
				.prop('disabled', false);
		}

		button.disabled = false;

		this._checkSplitEnable();

		return this;
	},

	/**
	 * Get a button's index
	 *
	 * This is internally recursive
	 * @param {element} node Button to get the index of
	 * @return {string} Button index
	 */
	index: function (node, nested, buttons) {
		if (!nested) {
			nested = '';
			buttons = this.s.buttons;
		}

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			var inner = buttons[i].buttons;

			if (buttons[i].node === node) {
				return nested + i;
			}

			if (inner && inner.length) {
				var match = this.index(node, i + '-', inner);

				if (match !== null) {
					return match;
				}
			}
		}

		return null;
	},

	/**
	 * Get the instance name for the button set selector
	 * @return {string} Instance name
	 */
	name: function () {
		return this.c.name;
	},

	/**
	 * Get a button's node of the buttons container if no button is given
	 * @param  {node} [node] Button node
	 * @return {jQuery} Button element, or container
	 */
	node: function (node) {
		if (!node) {
			return this.dom.container;
		}

		var button = this._nodeToButton(node);
		return $(button.node);
	},

	/**
	 * Set / get a processing class on the selected button
	 * @param {element} node Triggering button node
	 * @param  {boolean} flag true to add, false to remove, undefined to get
	 * @return {boolean|Buttons} Getter value or this if a setter.
	 */
	processing: function (node, flag) {
		var dt = this.s.dt;
		var button = this._nodeToButton(node);

		if (flag === undefined) {
			return $(button.node).hasClass('processing');
		}

		$(button.node).toggleClass('processing', flag);

		$(dt.table().node()).triggerHandler('buttons-processing.dt', [
			flag,
			dt.button(node),
			dt,
			$(node),
			button.conf
		]);

		return this;
	},

	/**
	 * Remove a button.
	 * @param  {node} node Button node
	 * @return {Buttons} Self for chaining
	 */
	remove: function (node) {
		var button = this._nodeToButton(node);
		var host = this._nodeToHost(node);
		var dt = this.s.dt;

		// Remove any child buttons first
		if (button.buttons.length) {
			for (var i = button.buttons.length - 1; i >= 0; i--) {
				this.remove(button.buttons[i].node);
			}
		}

		button.conf.destroying = true;

		// Allow the button to remove event handlers, etc
		if (button.conf.destroy) {
			button.conf.destroy.call(dt.button(node), dt, $(node), button.conf);
		}

		this._removeKey(button.conf);

		$(button.node).remove();

		if (button.inserter) {
			$(button.inserter).remove();
		}

		var idx = $.inArray(button, host);
		host.splice(idx, 1);

		return this;
	},

	/**
	 * Get the text for a button
	 * @param  {int|string} node Button index
	 * @return {string} Button text
	 */ /**
	 * Set the text for a button
	 * @param  {int|string|function} node Button index
	 * @param  {string} label Text
	 * @return {Buttons} Self for chaining
	 */
	text: function (node, label) {
		var button = this._nodeToButton(node);
		var textNode = button.textNode;
		var dt = this.s.dt;
		var jqNode = $(button.node);
		var text = function (opt) {
			return typeof opt === 'function'
				? opt(dt, jqNode, button.conf)
				: opt;
		};

		if (label === undefined) {
			return text(button.conf.text);
		}

		button.conf.text = label;
		textNode.html(text(label));

		return this;
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Constructor
	 */

	/**
	 * Buttons constructor
	 * @private
	 */
	_constructor: function () {
		var that = this;
		var dt = this.s.dt;
		var dtSettings = dt.settings()[0];
		var buttons = this.c.buttons;

		if (!dtSettings._buttons) {
			dtSettings._buttons = [];
		}

		dtSettings._buttons.push({
			inst: this,
			name: this.c.name
		});

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			this.add(buttons[i]);
		}

		dt.on('destroy', function (e, settings) {
			if (settings === dtSettings) {
				that.destroy();
			}
		});

		// Global key event binding to listen for button keys
		$('body').on('keyup.' + this.s.namespace, function (e) {
			if (
				!document.activeElement ||
				document.activeElement === document.body
			) {
				// SUse a string of characters for fast lookup of if we need to
				// handle this
				var character = String.fromCharCode(e.keyCode).toLowerCase();

				if (that.s.listenKeys.toLowerCase().indexOf(character) !== -1) {
					that._keypress(character, e);
				}
			}
		});
	},

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Private methods
	 */

	/**
	 * Add a new button to the key press listener
	 * @param {object} conf Resolved button configuration object
	 * @private
	 */
	_addKey: function (conf) {
		if (conf.key) {
			this.s.listenKeys += $.isPlainObject(conf.key)
				? conf.key.key
				: conf.key;
		}
	},

	/**
	 * Insert the buttons into the container. Call without parameters!
	 * @param  {node} [container] Recursive only - Insert point
	 * @param  {array} [buttons] Recursive only - Buttons array
	 * @private
	 */
	_draw: function (container, buttons) {
		if (!container) {
			container = this.dom.container;
			buttons = this.s.buttons;
		}

		container.children().detach();

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			container.append(buttons[i].inserter);
			container.append(' ');

			if (buttons[i].buttons && buttons[i].buttons.length) {
				this._draw(buttons[i].collection, buttons[i].buttons);
			}
		}
	},

	/**
	 * Create buttons from an array of buttons
	 * @param  {array} attachTo Buttons array to attach to
	 * @param  {object} button Button definition
	 * @param  {boolean} inCollection true if the button is in a collection
	 * @private
	 */
	_expandButton: function (
		attachTo,
		button,
		split,
		inCollection,
		inSplit,
		attachPoint,
		parentConf
	) {
		var dt = this.s.dt;
		var isSplit = false;
		var domCollection = this.c.dom.collection;
		var buttons = !Array.isArray(button) ? [button] : button;
		var lastButton;

		if (button === undefined) {
			buttons = !Array.isArray(split) ? [split] : split;
		}

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			var conf = this._resolveExtends(buttons[i]);

			if (!conf) {
				continue;
			}

			isSplit = conf.config && conf.config.split ? true : false;

			// If the configuration is an array, then expand the buttons at this
			// point
			if (Array.isArray(conf)) {
				this._expandButton(
					attachTo,
					conf,
					built !== undefined && built.conf !== undefined
						? built.conf.split
						: undefined,
					inCollection,
					parentConf !== undefined && parentConf.split !== undefined,
					attachPoint,
					parentConf
				);
				continue;
			}

			var built = this._buildButton(
				conf,
				inCollection,
				conf.split !== undefined ||
					(conf.config !== undefined &&
						conf.config.split !== undefined),
				inSplit
			);
			if (!built) {
				continue;
			}

			if (attachPoint !== undefined && attachPoint !== null) {
				attachTo.splice(attachPoint, 0, built);
				attachPoint++;
			}
			else {
				attachTo.push(built);
			}

			// Any button type can have a drop icon set
			if (built.conf.dropIcon && ! built.conf.split) {
				$(built.node)
					.addClass(this.c.dom.button.dropClass)
					.append(this.c.dom.button.dropHtml);
			}

			// Create the dropdown for a collection
			if (built.conf.buttons) {
				built.collection = $(
					'<' + domCollection.container.content.tag + '/>'
				);
				built.conf._collection = built.collection;

				this._expandButton(
					built.buttons,
					built.conf.buttons,
					built.conf.split,
					!isSplit,
					isSplit,
					attachPoint,
					built.conf
				);
			}

			// And the split collection
			if (built.conf.split) {
				built.collection = $('<' + domCollection.container.tag + '/>');
				built.conf._collection = built.collection;

				for (var j = 0; j < built.conf.split.length; j++) {
					var item = built.conf.split[j];

					if (typeof item === 'object') {
						item.parent = parentConf;

						if (item.collectionLayout === undefined) {
							item.collectionLayout = built.conf.collectionLayout;
						}

						if (item.dropup === undefined) {
							item.dropup = built.conf.dropup;
						}

						if (item.fade === undefined) {
							item.fade = built.conf.fade;
						}
					}
				}

				this._expandButton(
					built.buttons,
					built.conf.buttons,
					built.conf.split,
					!isSplit,
					isSplit,
					attachPoint,
					built.conf
				);
			}

			built.conf.parent = parentConf;

			// init call is made here, rather than buildButton as it needs to
			// be selectable, and for that it needs to be in the buttons array
			if (conf.init) {
				conf.init.call(dt.button(built.node), dt, $(built.node), conf);
			}

			lastButton = built.node;
		}

		return lastButton;
	},

	/**
	 * Create an individual button
	 * @param  {object} config            Resolved button configuration
	 * @param  {boolean} inCollection `true` if a collection button
	 * @return {object} Completed button description object
	 * @private
	 */
	_buildButton: function (config, inCollection, isSplit, inSplit) {
		var that = this;
		var configDom = this.c.dom;
		var textNode;
		var dt = this.s.dt;
		var setLinerTab = false;
		var text = function (opt) {
			return typeof opt === 'function' ? opt(dt, button, config) : opt;
		};

		// Create an object that describes the button which can be in `dom.button`, or
		// `dom.collection.button` or `dom.split.button` or `dom.collection.split.button`!
		// Each should extend from `dom.button`.
		var dom = $.extend(true, {}, configDom.button);

		if (inCollection && isSplit && configDom.collection.split) {
			$.extend(true, dom, configDom.collection.split.action);
		}
		else if (inSplit || inCollection) {
			$.extend(true, dom, configDom.collection.button);
		}
		else if (isSplit) {
			$.extend(true, dom, configDom.split.button);
		}

		// Spacers don't do much other than insert an element into the DOM
		if (config.spacer) {
			var spacer = $('<' + dom.spacer.tag + '/>')
				.addClass(
					'dt-button-spacer ' +
						config.style +
						' ' +
						dom.spacer.className
				)
				.html(text(config.text));

			return {
				conf: config,
				node: spacer,
				nodeChild: null,
				inserter: spacer,
				buttons: [],
				inCollection: inCollection,
				isSplit: isSplit,
				collection: null,
				textNode: spacer
			};
		}

		// Make sure that the button is available based on whatever requirements
		// it has. For example, PDF button require pdfmake
		if (
			config.available &&
			!config.available(dt, config) &&
			!config.html
		) {
			return false;
		}

		var button;

		if (!config.html) {
			var run = function (e, dt, button, config, done) {
				config.action.call(dt.button(button), e, dt, button, config, done);

				$(dt.table().node()).triggerHandler('buttons-action.dt', [
					dt.button(button),
					dt,
					button,
					config
				]);
			};

			var action = function(e, dt, button, config) {
				if (config.async) {
					that.processing(button[0], true);

					setTimeout(function () {
						run(e, dt, button, config, function () {
							that.processing(button[0], false);
						});
					}, config.async);
				}
				else {
					run(e, dt, button, config, function () {});
				}
			};

			var tag = config.tag || dom.tag;
			var clickBlurs =
				config.clickBlurs === undefined ? true : config.clickBlurs;

			button = $('<' + tag + '/>')
				.addClass(dom.className)
				.attr('aria-controls', this.s.dt.table().node().id)
				.on('click.dtb', function (e) {
					e.preventDefault();

					if (!button.hasClass(dom.disabled) && config.action) {
						action(e, dt, button, config);
					}

					if (clickBlurs) {
						button.trigger('blur');
					}
				})
				.on('keypress.dtb', function (e) {
					if (e.keyCode === 13) {
						e.preventDefault();

						if (!button.hasClass(dom.disabled) && config.action) {
							action(e, dt, button, config);
						}
					}
				});

			// Make `a` tags act like a link
			if (tag.toLowerCase() === 'a') {
				button.attr('href', '#');
			}

			// Button tags should have `type=button` so they don't have any default behaviour
			if (tag.toLowerCase() === 'button') {
				button.attr('type', 'button');
			}

			if (dom.liner.tag) {
				var lc = dom.liner.tag.toLowerCase();
				var liner = $('<' + lc + '/>')
					.html(text(config.text))
					.addClass(dom.liner.className);

				if (lc === 'a') {
					liner.attr('href', '#');
				}

				if (lc === 'a' || lc === 'button') {
					liner.attr('tabindex', this.s.dt.settings()[0].iTabIndex);
					setLinerTab = true;
				}

				button.append(liner);
				textNode = liner;
			}
			else {
				button.html(text(config.text));
				textNode = button;
			}

			if (! setLinerTab) {
				button.attr('tabindex', this.s.dt.settings()[0].iTabIndex)
			}

			if (config.enabled === false) {
				button.addClass(dom.disabled);
			}

			if (config.className) {
				button.addClass(config.className);
			}

			if (config.titleAttr) {
				button.attr('title', text(config.titleAttr));
			}

			if (config.attr) {
				button.attr(config.attr);
			}

			if (!config.namespace) {
				config.namespace = '.dt-button-' + _buttonCounter++;
			}

			if (config.config !== undefined && config.config.split) {
				config.split = config.config.split;
			}
		}
		else {
			button = $(config.html);
		}

		var buttonContainer = this.c.dom.buttonContainer;
		var inserter;
		if (buttonContainer && buttonContainer.tag) {
			inserter = $('<' + buttonContainer.tag + '/>')
				.addClass(buttonContainer.className)
				.append(button);
		}
		else {
			inserter = button;
		}

		this._addKey(config);

		// Style integration callback for DOM manipulation
		// Note that this is _not_ documented. It is currently
		// for style integration only
		if (this.c.buttonCreated) {
			inserter = this.c.buttonCreated(config, inserter);
		}

		var splitDiv;

		if (isSplit) {
			var dropdownConf = inCollection
				? $.extend(true, this.c.dom.split, this.c.dom.collection.split)
				: this.c.dom.split;
			var wrapperConf = dropdownConf.wrapper;

			splitDiv = $('<' + wrapperConf.tag + '/>')
				.addClass(wrapperConf.className)
				.append(button);

			var dropButtonConfig = $.extend(config, {
				autoClose: true,
				align: dropdownConf.dropdown.align,
				attr: {
					'aria-haspopup': 'dialog',
					'aria-expanded': false
				},
				className: dropdownConf.dropdown.className,
				closeButton: false,
				splitAlignClass: dropdownConf.dropdown.splitAlignClass,
				text: dropdownConf.dropdown.text
			});

			this._addKey(dropButtonConfig);

			var splitAction = function (e, dt, button, config) {
				_dtButtons.split.action.call(
					dt.button(splitDiv),
					e,
					dt,
					button,
					config
				);

				$(dt.table().node()).triggerHandler('buttons-action.dt', [
					dt.button(button),
					dt,
					button,
					config
				]);
				button.attr('aria-expanded', true);
			};

			var dropButton = $(
				'<button class="' +
					dropdownConf.dropdown.className +
					' dt-button"></button>'
			)
				.html(this.c.dom.button.dropHtml)
				.addClass(this.c.dom.button.dropClass)
				.on('click.dtb', function (e) {
					e.preventDefault();
					e.stopPropagation();

					if (!dropButton.hasClass(dom.disabled)) {
						splitAction(e, dt, dropButton, dropButtonConfig);
					}
					if (clickBlurs) {
						dropButton.trigger('blur');
					}
				})
				.on('keypress.dtb', function (e) {
					if (e.keyCode === 13) {
						e.preventDefault();

						if (!dropButton.hasClass(dom.disabled)) {
							splitAction(e, dt, dropButton, dropButtonConfig);
						}
					}
				});

			if (config.split.length === 0) {
				dropButton.addClass('dtb-hide-drop');
			}

			splitDiv.append(dropButton).attr(dropButtonConfig.attr);
		}

		var node = isSplit ? splitDiv.get(0) : button.get(0);

		return {
			conf: config,
			node: node,
			nodeChild: node && node.children && node.children.length ? node.children[0] : null,
			inserter: isSplit ? splitDiv : inserter,
			buttons: [],
			inCollection: inCollection,
			isSplit: isSplit,
			inSplit: inSplit,
			collection: null,
			textNode: textNode
		};
	},

	/**
	 * Spin over buttons checking if splits should be enabled or not.
	 * @param {*} buttons Array of buttons to check
	 */
	_checkSplitEnable: function (buttons) {
		if (! buttons) {
			buttons = this.s.buttons;
		}

		for (var i=0 ; i<buttons.length ; i++) {
			var button = buttons[i];

			// Check if the button is a split one and if so, determine
			// its state
			if (button.isSplit) {
				var splitBtn = button.node.childNodes[1];

				if (this._checkAnyEnabled(button.buttons)) {
					// Enable the split
					$(splitBtn)
						.removeClass(this.c.dom.button.disabled)
						.prop('disabled', false);
				}
				else {
					$(splitBtn)
						.addClass(this.c.dom.button.disabled)
						.prop('disabled', false);
				}
			}
			else if (button.isCollection) {
				// Nest down into collections
				this._checkSplitEnable(button.buttons);
			}
		}
	},

	/**
	 * Check an array of buttons and see if any are enabled in it
	 * @param {*} buttons Button array
	 * @returns true if a button is enabled, false otherwise
	 */
	_checkAnyEnabled: function (buttons) {
		for (var i=0 ; i<buttons.length ; i++) {
			if (! buttons[i].disabled) {
				return true;
			}
		}

		return false;
	},

	/**
	 * Get the button object from a node (recursive)
	 * @param  {node} node Button node
	 * @param  {array} [buttons] Button array, uses base if not defined
	 * @return {object} Button object
	 * @private
	 */
	_nodeToButton: function (node, buttons) {
		if (!buttons) {
			buttons = this.s.buttons;
		}

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			if (buttons[i].node === node || buttons[i].nodeChild === node) {
				return buttons[i];
			}

			if (buttons[i].buttons.length) {
				var ret = this._nodeToButton(node, buttons[i].buttons);

				if (ret) {
					return ret;
				}
			}
		}
	},

	/**
	 * Get container array for a button from a button node (recursive)
	 * @param  {node} node Button node
	 * @param  {array} [buttons] Button array, uses base if not defined
	 * @return {array} Button's host array
	 * @private
	 */
	_nodeToHost: function (node, buttons) {
		if (!buttons) {
			buttons = this.s.buttons;
		}

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			if (buttons[i].node === node) {
				return buttons;
			}

			if (buttons[i].buttons.length) {
				var ret = this._nodeToHost(node, buttons[i].buttons);

				if (ret) {
					return ret;
				}
			}
		}
	},

	/**
	 * Handle a key press - determine if any button's key configured matches
	 * what was typed and trigger the action if so.
	 * @param  {string} character The character pressed
	 * @param  {object} e Key event that triggered this call
	 * @private
	 */
	_keypress: function (character, e) {
		// Check if this button press already activated on another instance of Buttons
		if (e._buttonsHandled) {
			return;
		}

		var run = function (conf, node) {
			if (!conf.key) {
				return;
			}

			if (conf.key === character) {
				e._buttonsHandled = true;
				$(node).click();
			}
			else if ($.isPlainObject(conf.key)) {
				if (conf.key.key !== character) {
					return;
				}

				if (conf.key.shiftKey && !e.shiftKey) {
					return;
				}

				if (conf.key.altKey && !e.altKey) {
					return;
				}

				if (conf.key.ctrlKey && !e.ctrlKey) {
					return;
				}

				if (conf.key.metaKey && !e.metaKey) {
					return;
				}

				// Made it this far - it is good
				e._buttonsHandled = true;
				$(node).click();
			}
		};

		var recurse = function (a) {
			for (var i = 0, ien = a.length; i < ien; i++) {
				run(a[i].conf, a[i].node);

				if (a[i].buttons.length) {
					recurse(a[i].buttons);
				}
			}
		};

		recurse(this.s.buttons);
	},

	/**
	 * Remove a key from the key listener for this instance (to be used when a
	 * button is removed)
	 * @param  {object} conf Button configuration
	 * @private
	 */
	_removeKey: function (conf) {
		if (conf.key) {
			var character = $.isPlainObject(conf.key) ? conf.key.key : conf.key;

			// Remove only one character, as multiple buttons could have the
			// same listening key
			var a = this.s.listenKeys.split('');
			var idx = $.inArray(character, a);
			a.splice(idx, 1);
			this.s.listenKeys = a.join('');
		}
	},

	/**
	 * Resolve a button configuration
	 * @param  {string|function|object} conf Button config to resolve
	 * @return {object} Button configuration
	 * @private
	 */
	_resolveExtends: function (conf) {
		var that = this;
		var dt = this.s.dt;
		var i, ien;
		var toConfObject = function (base) {
			var loop = 0;

			// Loop until we have resolved to a button configuration, or an
			// array of button configurations (which will be iterated
			// separately)
			while (!$.isPlainObject(base) && !Array.isArray(base)) {
				if (base === undefined) {
					return;
				}

				if (typeof base === 'function') {
					base = base.call(that, dt, conf);

					if (!base) {
						return false;
					}
				}
				else if (typeof base === 'string') {
					if (!_dtButtons[base]) {
						return { html: base };
					}

					base = _dtButtons[base];
				}

				loop++;
				if (loop > 30) {
					// Protect against misconfiguration killing the browser
					throw 'Buttons: Too many iterations';
				}
			}

			return Array.isArray(base) ? base : $.extend({}, base);
		};

		conf = toConfObject(conf);

		while (conf && conf.extend) {
			// Use `toConfObject` in case the button definition being extended
			// is itself a string or a function
			if (!_dtButtons[conf.extend]) {
				throw 'Cannot extend unknown button type: ' + conf.extend;
			}

			var objArray = toConfObject(_dtButtons[conf.extend]);
			if (Array.isArray(objArray)) {
				return objArray;
			}
			else if (!objArray) {
				// This is a little brutal as it might be possible to have a
				// valid button without the extend, but if there is no extend
				// then the host button would be acting in an undefined state
				return false;
			}

			// Stash the current class name
			var originalClassName = objArray.className;

			if (conf.config !== undefined && objArray.config !== undefined) {
				conf.config = $.extend({}, objArray.config, conf.config);
			}

			conf = $.extend({}, objArray, conf);

			// The extend will have overwritten the original class name if the
			// `conf` object also assigned a class, but we want to concatenate
			// them so they are list that is combined from all extended buttons
			if (originalClassName && conf.className !== originalClassName) {
				conf.className = originalClassName + ' ' + conf.className;
			}

			// Although we want the `conf` object to overwrite almost all of
			// the properties of the object being extended, the `extend`
			// property should come from the object being extended
			conf.extend = objArray.extend;
		}

		// Buttons to be added to a collection  -gives the ability to define
		// if buttons should be added to the start or end of a collection
		var postfixButtons = conf.postfixButtons;
		if (postfixButtons) {
			if (!conf.buttons) {
				conf.buttons = [];
			}

			for (i = 0, ien = postfixButtons.length; i < ien; i++) {
				conf.buttons.push(postfixButtons[i]);
			}
		}

		var prefixButtons = conf.prefixButtons;
		if (prefixButtons) {
			if (!conf.buttons) {
				conf.buttons = [];
			}

			for (i = 0, ien = prefixButtons.length; i < ien; i++) {
				conf.buttons.splice(i, 0, prefixButtons[i]);
			}
		}

		return conf;
	},

	/**
	 * Display (and replace if there is an existing one) a popover attached to a button
	 * @param {string|node} content Content to show
	 * @param {DataTable.Api} hostButton DT API instance of the button
	 * @param {object} inOpts Options (see object below for all options)
	 */
	_popover: function (content, hostButton, inOpts) {
		var dt = hostButton;
		var c = this.c;
		var closed = false;
		var options = $.extend(
			{
				align: 'button-left', // button-right, dt-container, split-left, split-right
				autoClose: false,
				background: true,
				backgroundClassName: 'dt-button-background',
				closeButton: true,
				containerClassName: c.dom.collection.container.className,
				contentClassName: c.dom.collection.container.content.className,
				collectionLayout: '',
				collectionTitle: '',
				dropup: false,
				fade: 400,
				popoverTitle: '',
				rightAlignClassName: 'dt-button-right',
				tag: c.dom.collection.container.tag
			},
			inOpts
		);

		var containerSelector =
			options.tag + '.' + options.containerClassName.replace(/ /g, '.');
		var hostButtonNode = hostButton.node();
		var hostNode = options.collectionLayout.includes('fixed') ? $('body') : hostButton.node();

		var close = function () {
			closed = true;

			_fadeOut($(containerSelector), options.fade, function () {
				$(this).detach();
			});

			$(
				dt
					.buttons('[aria-haspopup="dialog"][aria-expanded="true"]')
					.nodes()
			).attr('aria-expanded', 'false');

			$('div.dt-button-background').off('click.dtb-collection');
			Buttons.background(
				false,
				options.backgroundClassName,
				options.fade,
				hostNode
			);

			$(window).off('resize.resize.dtb-collection');
			$('body').off('.dtb-collection');
			dt.off('buttons-action.b-internal');
			dt.off('destroy.dtb-popover');

			$('body').trigger('buttons-popover-hide.dt');
		};

		if (content === false) {
			close();
			return;
		}

		var existingExpanded = $(
			dt.buttons('[aria-haspopup="dialog"][aria-expanded="true"]').nodes()
		);
		if (existingExpanded.length) {
			// Reuse the current position if the button that was triggered is inside an existing collection
			if (hostNode.closest(containerSelector).length) {
				hostNode = existingExpanded.eq(0);
			}

			close();
		}

		// Sort buttons if defined
		if (options.sort) {
			var elements = $('button', content)
				.map(function (idx, el) {
					return {
						text: $(el).text(),
						el: el
					};
				})
				.toArray();

			elements.sort(function (a, b) {
				return a.text.localeCompare(b.text);
			});

			$(content).append(elements.map(function (v) {
				return v.el;
			}));
		}

		// Try to be smart about the layout
		var cnt = $('.dt-button', content).length;
		var mod = '';

		if (cnt === 3) {
			mod = 'dtb-b3';
		}
		else if (cnt === 2) {
			mod = 'dtb-b2';
		}
		else if (cnt === 1) {
			mod = 'dtb-b1';
		}

		var display = $('<' + options.tag + '/>')
			.addClass(options.containerClassName)
			.addClass(options.collectionLayout)
			.addClass(options.splitAlignClass)
			.addClass(mod)
			.css('display', 'none')
			.attr({
				'aria-modal': true,
				role: 'dialog'
			});

		content = $(content)
			.addClass(options.contentClassName)
			.attr('role', 'menu')
			.appendTo(display);

		hostButtonNode.attr('aria-expanded', 'true');

		if (hostNode.parents('body')[0] !== document.body) {
			hostNode = $(document.body).children('div, section, p').last();
		}

		if (options.popoverTitle) {
			display.prepend(
				'<div class="dt-button-collection-title">' +
					options.popoverTitle +
					'</div>'
			);
		}
		else if (options.collectionTitle) {
			display.prepend(
				'<div class="dt-button-collection-title">' +
					options.collectionTitle +
					'</div>'
			);
		}

		if (options.closeButton) {
			display
				.prepend('<div class="dtb-popover-close">&times;</div>')
				.addClass('dtb-collection-closeable');
		}

		_fadeIn(display.insertAfter(hostNode), options.fade);

		var tableContainer = $(hostButton.table().container());
		var position = display.css('position');

		if (options.span === 'container' || options.align === 'dt-container') {
			hostNode = hostNode.parent();
			display.css('width', tableContainer.width());
		}

		// Align the popover relative to the DataTables container
		// Useful for wide popovers such as SearchPanes
		if (position === 'absolute') {
			// Align relative to the host button
			var offsetParent = $(hostNode[0].offsetParent);
			var buttonPosition = hostNode.position();
			var buttonOffset = hostNode.offset();
			var tableSizes = offsetParent.offset();
			var containerPosition = offsetParent.position();
			var computed = window.getComputedStyle(offsetParent[0]);

			tableSizes.height = offsetParent.outerHeight();
			tableSizes.width =
				offsetParent.width() + parseFloat(computed.paddingLeft);
			tableSizes.right = tableSizes.left + tableSizes.width;
			tableSizes.bottom = tableSizes.top + tableSizes.height;

			// Set the initial position so we can read height / width
			var top = buttonPosition.top + hostNode.outerHeight();
			var left = buttonPosition.left;

			display.css({
				top: top,
				left: left
			});

			// Get the popover position
			computed = window.getComputedStyle(display[0]);
			var popoverSizes = display.offset();

			popoverSizes.height = display.outerHeight();
			popoverSizes.width = display.outerWidth();
			popoverSizes.right = popoverSizes.left + popoverSizes.width;
			popoverSizes.bottom = popoverSizes.top + popoverSizes.height;
			popoverSizes.marginTop = parseFloat(computed.marginTop);
			popoverSizes.marginBottom = parseFloat(computed.marginBottom);

			// First position per the class requirements - pop up and right align
			if (options.dropup) {
				top =
					buttonPosition.top -
					popoverSizes.height -
					popoverSizes.marginTop -
					popoverSizes.marginBottom;
			}

			if (
				options.align === 'button-right' ||
				display.hasClass(options.rightAlignClassName)
			) {
				left =
					buttonPosition.left -
					popoverSizes.width +
					hostNode.outerWidth();
			}

			// Container alignment - make sure it doesn't overflow the table container
			if (
				options.align === 'dt-container' ||
				options.align === 'container'
			) {
				if (left < buttonPosition.left) {
					left = -buttonPosition.left;
				}
			}

			// Window adjustment
			if (
				containerPosition.left + left + popoverSizes.width >
				$(window).width()
			) {
				// Overflowing the document to the right
				left =
					$(window).width() -
					popoverSizes.width -
					containerPosition.left;
			}

			if (buttonOffset.left + left < 0) {
				// Off to the left of the document
				left = -buttonOffset.left;
			}

			if (
				containerPosition.top + top + popoverSizes.height >
				$(window).height() + $(window).scrollTop()
			) {
				// Pop up if otherwise we'd need the user to scroll down
				top =
					buttonPosition.top -
					popoverSizes.height -
					popoverSizes.marginTop -
					popoverSizes.marginBottom;
			}

			if (offsetParent.offset().top + top < $(window).scrollTop()) {
				// Correction for when the top is beyond the top of the page
				top = buttonPosition.top + hostNode.outerHeight();
			}

			// Calculations all done - now set it
			display.css({
				top: top,
				left: left
			});
		}
		else {
			// Fix position - centre on screen
			var place = function () {
				var half = $(window).height() / 2;

				var top = display.height() / 2;
				if (top > half) {
					top = half;
				}

				display.css('marginTop', top * -1);
			};

			place();

			$(window).on('resize.dtb-collection', function () {
				place();
			});
		}

		if (options.background) {
			Buttons.background(
				true,
				options.backgroundClassName,
				options.fade,
				options.backgroundHost || hostNode
			);
		}

		// This is bonkers, but if we don't have a click listener on the
		// background element, iOS Safari will ignore the body click
		// listener below. An empty function here is all that is
		// required to make it work...
		$('div.dt-button-background').on(
			'click.dtb-collection',
			function () {}
		);

		if (options.autoClose) {
			setTimeout(function () {
				dt.on('buttons-action.b-internal', function (e, btn, dt, node) {
					if (node[0] === hostNode[0]) {
						return;
					}
					close();
				});
			}, 0);
		}

		$(display).trigger('buttons-popover.dt');

		dt.on('destroy.dtb-popover', close);

		setTimeout(function () {
			closed = false;
			$('body')
				.on('click.dtb-collection', function (e) {
					if (closed) {
						return;
					}

					// andSelf is deprecated in jQ1.8, but we want 1.7 compat
					var back = $.fn.addBack ? 'addBack' : 'andSelf';
					var parent = $(e.target).parent()[0];

					if (
						(!$(e.target).parents()[back]().filter(content)
							.length &&
							!$(parent).hasClass('dt-buttons')) ||
						$(e.target).hasClass('dt-button-background')
					) {
						close();
					}
				})
				.on('keyup.dtb-collection', function (e) {
					if (e.keyCode === 27) {
						close();
					}
				})
				.on('keydown.dtb-collection', function (e) {
					// Focus trap for tab key
					var elements = $('a, button', content);
					var active = document.activeElement;

					if (e.keyCode !== 9) {
						// tab
						return;
					}

					if (elements.index(active) === -1) {
						// If current focus is not inside the popover
						elements.first().focus();
						e.preventDefault();
					}
					else if (e.shiftKey) {
						// Reverse tabbing order when shift key is pressed
						if (active === elements[0]) {
							elements.last().focus();
							e.preventDefault();
						}
					}
					else {
						if (active === elements.last()[0]) {
							elements.first().focus();
							e.preventDefault();
						}
					}
				});
		}, 0);
	}
});

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Statics
 */

/**
 * Show / hide a background layer behind a collection
 * @param  {boolean} Flag to indicate if the background should be shown or
 *   hidden
 * @param  {string} Class to assign to the background
 * @static
 */
Buttons.background = function (show, className, fade, insertPoint) {
	if (fade === undefined) {
		fade = 400;
	}
	if (!insertPoint) {
		insertPoint = document.body;
	}

	if (show) {
		_fadeIn(
			$('<div/>')
				.addClass(className)
				.css('display', 'none')
				.insertAfter(insertPoint),
			fade
		);
	}
	else {
		_fadeOut($('div.' + className), fade, function () {
			$(this).removeClass(className).remove();
		});
	}
};

/**
 * Instance selector - select Buttons instances based on an instance selector
 * value from the buttons assigned to a DataTable. This is only useful if
 * multiple instances are attached to a DataTable.
 * @param  {string|int|array} Instance selector - see `instance-selector`
 *   documentation on the DataTables site
 * @param  {array} Button instance array that was attached to the DataTables
 *   settings object
 * @return {array} Buttons instances
 * @static
 */
Buttons.instanceSelector = function (group, buttons) {
	if (group === undefined || group === null) {
		return $.map(buttons, function (v) {
			return v.inst;
		});
	}

	var ret = [];
	var names = $.map(buttons, function (v) {
		return v.name;
	});

	// Flatten the group selector into an array of single options
	var process = function (input) {
		if (Array.isArray(input)) {
			for (var i = 0, ien = input.length; i < ien; i++) {
				process(input[i]);
			}
			return;
		}

		if (typeof input === 'string') {
			if (input.indexOf(',') !== -1) {
				// String selector, list of names
				process(input.split(','));
			}
			else {
				// String selector individual name
				var idx = $.inArray(input.trim(), names);

				if (idx !== -1) {
					ret.push(buttons[idx].inst);
				}
			}
		}
		else if (typeof input === 'number') {
			// Index selector
			ret.push(buttons[input].inst);
		}
		else if (typeof input === 'object' && input.nodeName) {
			// Element selector
			for (var j = 0; j < buttons.length; j++) {
				if (buttons[j].inst.dom.container[0] === input) {
					ret.push(buttons[j].inst);
				}
			}
		}
		else if (typeof input === 'object') {
			// Actual instance selector
			ret.push(input);
		}
	};

	process(group);

	return ret;
};

/**
 * Button selector - select one or more buttons from a selector input so some
 * operation can be performed on them.
 * @param  {array} Button instances array that the selector should operate on
 * @param  {string|int|node|jQuery|array} Button selector - see
 *   `button-selector` documentation on the DataTables site
 * @return {array} Array of objects containing `inst` and `idx` properties of
 *   the selected buttons so you know which instance each button belongs to.
 * @static
 */
Buttons.buttonSelector = function (insts, selector) {
	var ret = [];
	var nodeBuilder = function (a, buttons, baseIdx) {
		var button;
		var idx;

		for (var i = 0, ien = buttons.length; i < ien; i++) {
			button = buttons[i];

			if (button) {
				idx = baseIdx !== undefined ? baseIdx + i : i + '';

				a.push({
					node: button.node,
					name: button.conf.name,
					idx: idx
				});

				if (button.buttons) {
					nodeBuilder(a, button.buttons, idx + '-');
				}
			}
		}
	};

	var run = function (selector, inst) {
		var i, ien;
		var buttons = [];
		nodeBuilder(buttons, inst.s.buttons);

		var nodes = $.map(buttons, function (v) {
			return v.node;
		});

		if (Array.isArray(selector) || selector instanceof $) {
			for (i = 0, ien = selector.length; i < ien; i++) {
				run(selector[i], inst);
			}
			return;
		}

		if (selector === null || selector === undefined || selector === '*') {
			// Select all
			for (i = 0, ien = buttons.length; i < ien; i++) {
				ret.push({
					inst: inst,
					node: buttons[i].node
				});
			}
		}
		else if (typeof selector === 'number') {
			// Main button index selector
			if (inst.s.buttons[selector]) {
				ret.push({
					inst: inst,
					node: inst.s.buttons[selector].node
				});
			}
		}
		else if (typeof selector === 'string') {
			if (selector.indexOf(',') !== -1) {
				// Split
				var a = selector.split(',');

				for (i = 0, ien = a.length; i < ien; i++) {
					run(a[i].trim(), inst);
				}
			}
			else if (selector.match(/^\d+(\-\d+)*$/)) {
				// Sub-button index selector
				var indexes = $.map(buttons, function (v) {
					return v.idx;
				});

				ret.push({
					inst: inst,
					node: buttons[$.inArray(selector, indexes)].node
				});
			}
			else if (selector.indexOf(':name') !== -1) {
				// Button name selector
				var name = selector.replace(':name', '');

				for (i = 0, ien = buttons.length; i < ien; i++) {
					if (buttons[i].name === name) {
						ret.push({
							inst: inst,
							node: buttons[i].node
						});
					}
				}
			}
			else {
				// jQuery selector on the nodes
				$(nodes)
					.filter(selector)
					.each(function () {
						ret.push({
							inst: inst,
							node: this
						});
					});
			}
		}
		else if (typeof selector === 'object' && selector.nodeName) {
			// Node selector
			var idx = $.inArray(selector, nodes);

			if (idx !== -1) {
				ret.push({
					inst: inst,
					node: nodes[idx]
				});
			}
		}
	};

	for (var i = 0, ien = insts.length; i < ien; i++) {
		var inst = insts[i];

		run(selector, inst);
	}

	return ret;
};

/**
 * Default function used for formatting output data.
 * @param {*} str Data to strip
 */
Buttons.stripData = function (str, config) {
	// If the input is an HTML element, we can use the HTML from it (HTML might be stripped below).
	if (str !== null && typeof str === 'object' && str.nodeName && str.nodeType) {
		str = str.innerHTML;
	}

	if (typeof str !== 'string') {
		return str;
	}

	// Always remove script tags
	str = Buttons.stripHtmlScript(str);

	// Always remove comments
	str = Buttons.stripHtmlComments(str);

	if (!config || config.stripHtml) {
		str = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.stripHtml(str);
	}

	if (!config || config.trim) {
		str = str.trim();
	}

	if (!config || config.stripNewlines) {
		str = str.replace(/\n/g, ' ');
	}

	if (!config || config.decodeEntities) {
		if (_entityDecoder) {
			str = _entityDecoder(str);
		}
		else {
			_exportTextarea.innerHTML = str;
			str = _exportTextarea.value;
		}
	}

	// Prevent Excel from running a formula
	if (!config || config.escapeExcelFormula) {
		if (str.match(/^[=@\t\r]/)) {
			str = "'" + str;
		}
	}

	return str;
};

/**
 * Provide a custom entity decoding function - e.g. a regex one, which can be
 * much faster than the built in DOM option, but also larger code size.
 * @param {function} fn
 */
Buttons.entityDecoder = function (fn) {
	_entityDecoder = fn;
};

/**
 * Common function for stripping HTML comments
 *
 * @param {*} input 
 * @returns 
 */
Buttons.stripHtmlComments = function (input) {
	var previous;  
	
	do {  
		previous = input;
		input = input.replace(/(<!--.*?--!?>)|(<!--[\S\s]+?--!?>)|(<!--[\S\s]*?$)/g, '');
	} while (input !== previous);  

	return input;  
};

/**
 * Common function for stripping HTML script tags
 *
 * @param {*} input 
 * @returns 
 */
Buttons.stripHtmlScript = function (input) {
	var previous;  
	
	do {  
		previous = input;
		input = input.replace(/<script\b[^<]*(?:(?!<\/script[^>]*>)<[^<]*)*<\/script[^>]*>/gi, '');
	} while (input !== previous);  

	return input;  
};

/**
 * Buttons defaults. For full documentation, please refer to the docs/option
 * directory or the DataTables site.
 * @type {Object}
 * @static
 */
Buttons.defaults = {
	buttons: ['copy', 'excel', 'csv', 'pdf', 'print'],
	name: 'main',
	tabIndex: 0,
	dom: {
		container: {
			tag: 'div',
			className: 'dt-buttons'
		},
		collection: {
			container: {
				// The element used for the dropdown
				className: 'dt-button-collection',
				content: {
					className: '',
					tag: 'div'
				},
				tag: 'div'
			}
			// optionally
			// , button: IButton - buttons inside the collection container
			// , split: ISplit - splits inside the collection container
		},
		button: {
			tag: 'button',
			className: 'dt-button',
			active: 'dt-button-active', // class name
			disabled: 'disabled', // class name
			spacer: {
				className: 'dt-button-spacer',
				tag: 'span'
			},
			liner: {
				tag: 'span',
				className: ''
			},
			dropClass: '',
			dropHtml: '<span class="dt-button-down-arrow">&#x25BC;</span>'
		},
		split: {
			action: {
				// action button
				className: 'dt-button-split-drop-button dt-button',
				tag: 'button'
			},
			dropdown: {
				// button to trigger the dropdown
				align: 'split-right',
				className: 'dt-button-split-drop',
				splitAlignClass: 'dt-button-split-left',
				tag: 'button'
			},
			wrapper: {
				// wrap around both
				className: 'dt-button-split',
				tag: 'div'
			}
		}
	}
};

/**
 * Version information
 * @type {string}
 * @static
 */
Buttons.version = '3.2.6';

$.extend(_dtButtons, {
	collection: {
		text: function (dt) {
			return dt.i18n('buttons.collection', 'Collection');
		},
		className: 'buttons-collection',
		closeButton: false,
		dropIcon: true,
		init: function (dt, button) {
			button.attr('aria-expanded', false);
		},
		action: function (e, dt, button, config) {
			if (config._collection.parents('body').length) {
				this.popover(false, config);
			}
			else {
				this.popover(config._collection, config);
			}

			// When activated using a key - auto focus on the
			// first item in the popover
			if (e.type === 'keypress') {
				$('a, button', config._collection).eq(0).focus();
			}
		},
		attr: {
			'aria-haspopup': 'dialog'
		}
		// Also the popover options, defined in Buttons.popover
	},
	split: {
		text: function (dt) {
			return dt.i18n('buttons.split', 'Split');
		},
		className: 'buttons-split',
		closeButton: false,
		init: function (dt, button) {
			return button.attr('aria-expanded', false);
		},
		action: function (e, dt, button, config) {
			this.popover(config._collection, config);
		},
		attr: {
			'aria-haspopup': 'dialog'
		}
		// Also the popover options, defined in Buttons.popover
	},
	copy: function () {
		if (_dtButtons.copyHtml5) {
			return 'copyHtml5';
		}
	},
	csv: function (dt, conf) {
		if (_dtButtons.csvHtml5 && _dtButtons.csvHtml5.available(dt, conf)) {
			return 'csvHtml5';
		}
	},
	excel: function (dt, conf) {
		if (
			_dtButtons.excelHtml5 &&
			_dtButtons.excelHtml5.available(dt, conf)
		) {
			return 'excelHtml5';
		}
	},
	pdf: function (dt, conf) {
		if (_dtButtons.pdfHtml5 && _dtButtons.pdfHtml5.available(dt, conf)) {
			return 'pdfHtml5';
		}
	},
	pageLength: function (dt) {
		var lengthMenu = dt.settings()[0].aLengthMenu;
		var vals = [];
		var lang = [];
		var text = function (dt) {
			return dt.i18n(
				'buttons.pageLength',
				{
					'-1': 'Show all rows',
					_: 'Show %d rows'
				},
				dt.page.len()
			);
		};

		// Support for DataTables 1.x 2D array
		if (Array.isArray(lengthMenu[0])) {
			vals = lengthMenu[0];
			lang = lengthMenu[1];
		}
		else {
			for (var i = 0; i < lengthMenu.length; i++) {
				var option = lengthMenu[i];

				// Support for DataTables 2 object in the array
				if ($.isPlainObject(option)) {
					vals.push(option.value);
					lang.push(option.label);
				}
				else {
					vals.push(option);
					lang.push(option);
				}
			}
		}

		return {
			extend: 'collection',
			text: text,
			className: 'buttons-page-length',
			autoClose: true,
			buttons: $.map(vals, function (val, i) {
				return {
					text: lang[i],
					className: 'button-page-length',
					action: function (e, dt) {
						dt.page.len(val).draw();
					},
					init: function (dt, node, conf) {
						var that = this;
						var fn = function () {
							that.active(dt.page.len() === val);
						};

						dt.on('length.dt' + conf.namespace, fn);
						fn();
					},
					destroy: function (dt, node, conf) {
						dt.off('length.dt' + conf.namespace);
					}
				};
			}),
			init: function (dt, node, conf) {
				var that = this;
				dt.on('length.dt' + conf.namespace, function () {
					that.text(conf.text);
				});
			},
			destroy: function (dt, node, conf) {
				dt.off('length.dt' + conf.namespace);
			}
		};
	},
	spacer: {
		style: 'empty',
		spacer: true,
		text: function (dt) {
			return dt.i18n('buttons.spacer', '');
		}
	}
});

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables API
 *
 * For complete documentation, please refer to the docs/api directory or the
 * DataTables site
 */

// Buttons group and individual button selector
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons()', function (group, selector) {
	// Argument shifting
	if (selector === undefined) {
		selector = group;
		group = undefined;
	}

	this.selector.buttonGroup = group;

	var res = this.iterator(
		true,
		'table',
		function (ctx) {
			if (ctx._buttons) {
				return Buttons.buttonSelector(
					Buttons.instanceSelector(group, ctx._buttons),
					selector
				);
			}
		},
		true
	);

	res._groupSelector = group;
	return res;
});

// Individual button selector
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('button()', function (group, selector) {
	// just run buttons() and truncate
	var buttons = this.buttons(group, selector);

	if (buttons.length > 1) {
		buttons.splice(1, buttons.length);
	}

	return buttons;
});

// Active buttons
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().active()',
	'button().active()',
	function (flag) {
		if (flag === undefined) {
			return this.map(function (set) {
				return set.inst.active(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.active(set.node, flag);
		});
	}
);

// Get / set button action
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().action()',
	'button().action()',
	function (action) {
		if (action === undefined) {
			return this.map(function (set) {
				return set.inst.action(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.action(set.node, action);
		});
	}
);

// Collection control
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().collectionRebuild()',
	'button().collectionRebuild()',
	function (buttons) {
		return this.each(function (set) {
			for (var i = 0; i < buttons.length; i++) {
				if (typeof buttons[i] === 'object') {
					buttons[i].parentConf = set;
				}
			}
			set.inst.collectionRebuild(set.node, buttons);
		});
	}
);

// Enable / disable buttons
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register(
	['buttons().enable()', 'button().enable()'],
	function (flag) {
		return this.each(function (set) {
			set.inst.enable(set.node, flag);
		});
	}
);

// Disable buttons
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register(
	['buttons().disable()', 'button().disable()'],
	function () {
		return this.each(function (set) {
			set.inst.disable(set.node);
		});
	}
);

// Button index
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('button().index()', function () {
	var idx = null;

	this.each(function (set) {
		var res = set.inst.index(set.node);

		if (res !== null) {
			idx = res;
		}
	});

	return idx;
});

// Get button nodes
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().nodes()',
	'button().node()',
	function () {
		var jq = $();

		// jQuery will automatically reduce duplicates to a single entry
		$(
			this.each(function (set) {
				jq = jq.add(set.inst.node(set.node));
			})
		);

		return jq;
	}
);

// Get / set button processing state
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().processing()',
	'button().processing()',
	function (flag) {
		if (flag === undefined) {
			return this.map(function (set) {
				return set.inst.processing(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.processing(set.node, flag);
		});
	}
);

// Get / set button text (i.e. the button labels)
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().text()',
	'button().text()',
	function (label) {
		if (label === undefined) {
			return this.map(function (set) {
				return set.inst.text(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.text(set.node, label);
		});
	}
);

// Trigger a button's action
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().trigger()',
	'button().trigger()',
	function () {
		return this.each(function (set) {
			set.inst.node(set.node).trigger('click');
		});
	}
);

// Button resolver to the popover
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('button().popover()', function (content, options) {
	return this.map(function (set) {
		return set.inst._popover(content, this.button(this[0].node), options);
	});
});

// Get the container elements
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons().containers()', function () {
	var jq = $();
	var groupSelector = this._groupSelector;

	// We need to use the group selector directly, since if there are no buttons
	// the result set will be empty
	this.iterator(true, 'table', function (ctx) {
		if (ctx._buttons) {
			var insts = Buttons.instanceSelector(groupSelector, ctx._buttons);

			for (var i = 0, ien = insts.length; i < ien; i++) {
				jq = jq.add(insts[i].container());
			}
		}
	});

	return jq;
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons().container()', function () {
	// API level of nesting is `buttons()` so we can zip into the containers method
	return this.containers().eq(0);
});

// Add a new button
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('button().add()', function (idx, conf, draw) {
	var ctx = this.context;
	var node;

	// Don't use `this` as it could be empty - select the instances directly
	if (ctx.length) {
		var inst = Buttons.instanceSelector(
			this._groupSelector,
			ctx[0]._buttons
		);

		if (inst.length) {
			node = inst[0].add(conf, idx, draw);
		}
	}

	return node
		? this.button(this._groupSelector, node)
		: this;
});

// Destroy the button sets selected
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons().destroy()', function () {
	this.pluck('inst')
		.unique()
		.each(function (inst) {
			inst.destroy();
		});

	return this;
});

// Remove a button
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural(
	'buttons().remove()',
	'buttons().remove()',
	function () {
		this.each(function (set) {
			set.inst.remove(set.node);
		});

		return this;
	}
);

// Information box that can be used by buttons
var _infoTimer;
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons.info()', function (title, message, time) {
	var that = this;

	if (title === false) {
		this.off('destroy.btn-info');
		_fadeOut($('#datatables_buttons_info'), 400, function () {
			$(this).remove();
		});
		clearTimeout(_infoTimer);
		_infoTimer = null;

		return this;
	}

	if (_infoTimer) {
		clearTimeout(_infoTimer);
	}

	if ($('#datatables_buttons_info').length) {
		$('#datatables_buttons_info').remove();
	}

	title = title ? '<h2>' + title + '</h2>' : '';

	_fadeIn(
		$('<div id="datatables_buttons_info" class="dt-button-info"/>')
			.html(title)
			.append(
				$('<div/>')[typeof message === 'string' ? 'html' : 'append'](
					message
				)
			)
			.css('display', 'none')
			.appendTo('body')
	);

	if (time !== undefined && time !== 0) {
		_infoTimer = setTimeout(function () {
			that.buttons.info(false);
		}, time);
	}

	this.on('destroy.btn-info', function () {
		that.buttons.info(false);
	});

	return this;
});

// Get data from the table for export - this is common to a number of plug-in
// buttons so it is included in the Buttons core library
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons.exportData()', function (options) {
	if (this.context.length) {
		return _exportData(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(this.context[0]), options);
	}
});

// Get information about the export that is common to many of the export data
// types (DRY)
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register('buttons.exportInfo()', function (conf) {
	if (!conf) {
		conf = {};
	}

	return {
		filename: _filename(conf, this),
		title: _title(conf, this),
		messageTop: _message(this, conf, conf.message || conf.messageTop, 'top'),
		messageBottom: _message(this, conf, conf.messageBottom, 'bottom')
	};
});

/**
 * Get the file name for an exported file.
 *
 * @param {object} config Button configuration
 * @param {object} dt DataTable instance
 */
var _filename = function (config, dt) {
	// Backwards compatibility
	var filename =
		config.filename === '*' &&
		config.title !== '*' &&
		config.title !== undefined &&
		config.title !== null &&
		config.title !== ''
			? config.title
			: config.filename;

	if (typeof filename === 'function') {
		filename = filename(config, dt);
	}

	if (filename === undefined || filename === null) {
		return null;
	}

	if (filename.indexOf('*') !== -1) {
		filename = filename.replace(/\*/g, $('head > title').text()).trim();
	}

	// Strip characters which the OS will object to
	filename = filename.replace(/[^a-zA-Z0-9_\u00A1-\uFFFF\.,\-_ !\(\)]/g, '');

	var extension = _stringOrFunction(config.extension, config, dt);
	if (!extension) {
		extension = '';
	}

	return filename + extension;
};

/**
 * Simply utility method to allow parameters to be given as a function
 *
 * @param {undefined|string|function} option Option
 * @return {null|string} Resolved value
 */
var _stringOrFunction = function (option, config, dt) {
	if (option === null || option === undefined) {
		return null;
	}
	else if (typeof option === 'function') {
		return option(config, dt);
	}
	return option;
};

/**
 * Get the title for an exported file.
 *
 * @param {object} config	Button configuration
 */
var _title = function (config, dt) {
	var title = _stringOrFunction(config.title, config, dt);

	return title === null
		? null
		: title.indexOf('*') !== -1
		? title.replace(/\*/g, $('head > title').text() || 'Exported data')
		: title;
};

var _message = function (dt, config, option, position) {
	var message = _stringOrFunction(option, config, dt);
	if (message === null) {
		return null;
	}

	var caption = $('caption', dt.table().container()).eq(0);
	if (message === '*') {
		var side = caption.css('caption-side');
		if (side !== position) {
			return null;
		}

		return caption.length ? caption.text() : '';
	}

	return message;
};

var _exportTextarea = $('<textarea/>')[0];
var _exportData = function (dt, inOpts) {
	var config = $.extend(
		true,
		{},
		{
			rows: null,
			columns: '',
			modifier: {
				search: 'applied',
				order: 'applied'
			},
			orthogonal: 'display',
			stripHtml: true,
			stripNewlines: true,
			decodeEntities: true,
			escapeExcelFormula: false,
			trim: true,
			format: {
				header: function (d) {
					return Buttons.stripData(d, config);
				},
				footer: function (d) {
					return Buttons.stripData(d, config);
				},
				body: function (d) {
					return Buttons.stripData(d, config);
				}
			},
			customizeData: null,
			customizeZip: null
		},
		inOpts
	);

	var header = dt
		.columns(config.columns)
		.indexes()
		.map(function (idx) {
			var col = dt.column(idx);
			return config.format.header(col.title(), idx, col.header());
		})
		.toArray();

	var footer = dt.table().footer()
		? dt
				.columns(config.columns)
				.indexes()
				.map(function (idx) {
					var el = dt.column(idx).footer();
					var val = '';

					if (el) {
						var inner = $('.dt-column-title', el);

						val = inner.length
							? inner.html()
							: $(el).html();
					}

					return config.format.footer(val, idx, el);
				})
				.toArray()
		: null;

	// If Select is available on this table, and any rows are selected, limit the export
	// to the selected rows. If no rows are selected, all rows will be exported. Specify
	// a `selected` modifier to control directly.
	var modifier = $.extend({}, config.modifier);
	if (
		dt.select &&
		typeof dt.select.info === 'function' &&
		modifier.selected === undefined
	) {
		if (
			dt.rows(config.rows, $.extend({ selected: true }, modifier)).any()
		) {
			$.extend(modifier, { selected: true });
		}
	}

	var rowIndexes = dt.rows(config.rows, modifier).indexes().toArray();
	var selectedCells = dt.cells(rowIndexes, config.columns, {
		order: modifier.order
	});
	var cells = selectedCells.render(config.orthogonal).toArray();
	var cellNodes = selectedCells.nodes().toArray();
	var cellIndexes = selectedCells.indexes().toArray();

	var columns = dt.columns(config.columns).count();
	var rows = columns > 0 ? cells.length / columns : 0;
	var body = [];
	var cellCounter = 0;

	for (var i = 0, ien = rows; i < ien; i++) {
		var row = [columns];

		for (var j = 0; j < columns; j++) {
			row[j] = config.format.body(
				cells[cellCounter],
				cellIndexes[cellCounter].row,
				cellIndexes[cellCounter].column,
				cellNodes[cellCounter]
			);
			cellCounter++;
		}

		body[i] = row;
	}

	var data = {
		header: header,
		headerStructure: _headerFormatter(
			config.format.header,
			dt.table().header.structure(config.columns)
		),
		footer: footer,
		footerStructure: _headerFormatter(
			config.format.footer,
			dt.table().footer.structure(config.columns)
		),
		body: body
	};

	if (config.customizeData) {
		config.customizeData(data);
	}

	return data;
};

function _headerFormatter(formatter, struct) {
	for (var i=0 ; i<struct.length ; i++) {
		for (var j=0 ; j<struct[i].length ; j++) {
			var item = struct[i][j];

			if (item) {
				item.title = formatter(
					item.title,
					j,
					item.cell
				);
			}
		}
	}

	return struct;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables interface
 */

// Attach to DataTables objects for global access
$.fn.dataTable.Buttons = Buttons;
$.fn.DataTable.Buttons = Buttons;

// DataTables creation - check if the buttons have been defined for this table,
// they will have been if the `B` option was used in `dom`, otherwise we should
// create the buttons instance here so they can be inserted into the document
// using the API. Listen for `init` for compatibility with pre 1.10.10, but to
// be removed in future.
$(document).on('init.dt plugin-init.dt', function (e, settings) {
	if (e.namespace !== 'dt') {
		return;
	}

	var opts = settings.oInit.buttons || datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.buttons;

	if (opts && !settings._buttons) {
		new Buttons(settings, opts).container();
	}
});

function _init(settings, options) {
	var api = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(settings);
	var opts = options
		? options
		: api.init().buttons || datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.buttons;

	return new Buttons(api, opts).container();
}

// DataTables 1 `dom` feature option
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.feature.push({
	fnInit: _init,
	cFeature: 'B'
});

// DataTables 2 layout feature
if (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].feature) {
	datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].feature.register('buttons', _init);
}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-dt/js/dataTables.dataTables.mjs":
/*!*********************************************************************!*\
  !*** ./node_modules/datatables.net-dt/js/dataTables.dataTables.mjs ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net-dt/node_modules/datatables.net/js/dataTables.mjs");
/*! DataTables styling integration
 * © SpryMedia Ltd - datatables.net/license
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ }),

/***/ "./node_modules/datatables.net-dt/node_modules/datatables.net/js/dataTables.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/datatables.net-dt/node_modules/datatables.net/js/dataTables.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/*! DataTables 2.3.6
 * © SpryMedia Ltd - datatables.net/license
 */



// DataTables code uses $ internally, but we want to be able to
// reassign $ with the `use` method, so it is a regular var.
var $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


var DataTable = function ( selector, options )
{
	// Check if called with a window or jQuery object for DOM less applications
	// This is for backwards compatibility
	if (DataTable.factory(selector, options)) {
		return DataTable;
	}

	// When creating with `new`, create a new DataTable, returning the API instance
	if (this instanceof DataTable) {
		return $(selector).DataTable(options);
	}
	else {
		// Argument switching
		options = selector;
	}

	var _that = this;
	var emptyInit = options === undefined;
	var len = this.length;

	if ( emptyInit ) {
		options = {};
	}

	// Method to get DT API instance from jQuery object
	this.api = function ()
	{
		return new _Api( this );
	};

	this.each(function() {
		// For each initialisation we want to give it a clean initialisation
		// object that can be bashed around
		var o = {};
		var oInit = len > 1 ? // optimisation for single table case
			_fnExtend( o, options, true ) :
			options;

		
		var i=0, iLen;
		var sId = this.getAttribute( 'id' );
		var defaults = DataTable.defaults;
		var $this = $(this);
		
		// Sanity check
		if ( this.nodeName.toLowerCase() != 'table' )
		{
			_fnLog( null, 0, 'Non-table node initialisation ('+this.nodeName+')', 2 );
			return;
		}
		
		// Special case for options
		if (oInit.on && oInit.on.options) {
			_fnListener($this, 'options', oInit.on.options);	
		}
		
		$this.trigger( 'options.dt', oInit );
		
		/* Backwards compatibility for the defaults */
		_fnCompatOpts( defaults );
		_fnCompatCols( defaults.column );
		
		/* Convert the camel-case defaults to Hungarian */
		_fnCamelToHungarian( defaults, defaults, true );
		_fnCamelToHungarian( defaults.column, defaults.column, true );
		
		/* Setting up the initialisation object */
		_fnCamelToHungarian( defaults, $.extend( oInit, _fnEscapeObject($this.data()) ), true );
		
		
		
		/* Check to see if we are re-initialising a table */
		var allSettings = DataTable.settings;
		for ( i=0, iLen=allSettings.length ; i<iLen ; i++ )
		{
			var s = allSettings[i];
		
			/* Base check on table node */
			if (
				s.nTable == this ||
				(s.nTHead && s.nTHead.parentNode == this) ||
				(s.nTFoot && s.nTFoot.parentNode == this)
			) {
				var bRetrieve = oInit.bRetrieve !== undefined ? oInit.bRetrieve : defaults.bRetrieve;
				var bDestroy = oInit.bDestroy !== undefined ? oInit.bDestroy : defaults.bDestroy;
		
				if ( emptyInit || bRetrieve )
				{
					return s.oInstance;
				}
				else if ( bDestroy )
				{
					new DataTable.Api(s).destroy();
					break;
				}
				else
				{
					_fnLog( s, 0, 'Cannot reinitialise DataTable', 3 );
					return;
				}
			}
		
			/* If the element we are initialising has the same ID as a table which was previously
			 * initialised, but the table nodes don't match (from before) then we destroy the old
			 * instance by simply deleting it. This is under the assumption that the table has been
			 * destroyed by other methods. Anyone using non-id selectors will need to do this manually
			 */
			if ( s.sTableId == this.id )
			{
				allSettings.splice( i, 1 );
				break;
			}
		}
		
		/* Ensure the table has an ID - required for accessibility */
		if ( sId === null || sId === "" )
		{
			sId = "DataTables_Table_"+(DataTable.ext._unique++);
			this.id = sId;
		}
		
		// Replacing an existing colgroup with our own. Not ideal, but a merge could take a lot of code
		$this.children('colgroup').remove();
		
		/* Create the settings object for this table and set some of the default parameters */
		var oSettings = $.extend( true, {}, DataTable.models.oSettings, {
			"sDestroyWidth": $this[0].style.width,
			"sInstance":     sId,
			"sTableId":      sId,
			colgroup: $('<colgroup>'),
			fastData: function (row, column, type) {
				return _fnGetCellData(oSettings, row, column, type);
			}
		} );
		oSettings.nTable = this;
		oSettings.oInit  = oInit;
		
		allSettings.push( oSettings );
		
		// Make a single API instance available for internal handling
		oSettings.api = new _Api( oSettings );
		
		// Need to add the instance after the instance after the settings object has been added
		// to the settings array, so we can self reference the table instance if more than one
		oSettings.oInstance = (_that.length===1) ? _that : $this.dataTable();
		
		// Backwards compatibility, before we apply all the defaults
		_fnCompatOpts( oInit );
		
		// If the length menu is given, but the init display length is not, use the length menu
		if ( oInit.aLengthMenu && ! oInit.iDisplayLength )
		{
			oInit.iDisplayLength = Array.isArray(oInit.aLengthMenu[0])
				? oInit.aLengthMenu[0][0]
				: $.isPlainObject( oInit.aLengthMenu[0] )
					? oInit.aLengthMenu[0].value
					: oInit.aLengthMenu[0];
		}
		
		// Apply the defaults and init options to make a single init object will all
		// options defined from defaults and instance options.
		oInit = _fnExtend( $.extend( true, {}, defaults ), oInit );
		
		
		// Map the initialisation options onto the settings object
		_fnMap( oSettings.oFeatures, oInit, [
			"bPaginate",
			"bLengthChange",
			"bFilter",
			"bSort",
			"bSortMulti",
			"bInfo",
			"bProcessing",
			"bAutoWidth",
			"bSortClasses",
			"bServerSide",
			"bDeferRender"
		] );
		_fnMap( oSettings, oInit, [
			"ajax",
			"fnFormatNumber",
			"sServerMethod",
			"aaSorting",
			"aaSortingFixed",
			"aLengthMenu",
			"sPaginationType",
			"iStateDuration",
			"bSortCellsTop",
			"iTabIndex",
			"sDom",
			"fnStateLoadCallback",
			"fnStateSaveCallback",
			"renderer",
			"searchDelay",
			"rowId",
			"caption",
			"layout",
			"orderDescReverse",
			"orderIndicators",
			"orderHandler",
			"titleRow",
			"typeDetect",
			"columnTitleTag",
			[ "iCookieDuration", "iStateDuration" ], // backwards compat
			[ "oSearch", "oPreviousSearch" ],
			[ "aoSearchCols", "aoPreSearchCols" ],
			[ "iDisplayLength", "_iDisplayLength" ]
		] );
		_fnMap( oSettings.oScroll, oInit, [
			[ "sScrollX", "sX" ],
			[ "sScrollXInner", "sXInner" ],
			[ "sScrollY", "sY" ],
			[ "bScrollCollapse", "bCollapse" ]
		] );
		_fnMap( oSettings.oLanguage, oInit, "fnInfoCallback" );
		
		/* Callback functions which are array driven */
		_fnCallbackReg( oSettings, 'aoDrawCallback',       oInit.fnDrawCallback );
		_fnCallbackReg( oSettings, 'aoStateSaveParams',    oInit.fnStateSaveParams );
		_fnCallbackReg( oSettings, 'aoStateLoadParams',    oInit.fnStateLoadParams );
		_fnCallbackReg( oSettings, 'aoStateLoaded',        oInit.fnStateLoaded );
		_fnCallbackReg( oSettings, 'aoRowCallback',        oInit.fnRowCallback );
		_fnCallbackReg( oSettings, 'aoRowCreatedCallback', oInit.fnCreatedRow );
		_fnCallbackReg( oSettings, 'aoHeaderCallback',     oInit.fnHeaderCallback );
		_fnCallbackReg( oSettings, 'aoFooterCallback',     oInit.fnFooterCallback );
		_fnCallbackReg( oSettings, 'aoInitComplete',       oInit.fnInitComplete );
		_fnCallbackReg( oSettings, 'aoPreDrawCallback',    oInit.fnPreDrawCallback );
		
		oSettings.rowIdFn = _fnGetObjectDataFn( oInit.rowId );
		
		// Add event listeners
		if (oInit.on) {
			Object.keys(oInit.on).forEach(function (key) {
				_fnListener($this, key, oInit.on[key]);
			});
		}
		
		/* Browser support detection */
		_fnBrowserDetect( oSettings );
		
		var oClasses = oSettings.oClasses;
		
		$.extend( oClasses, DataTable.ext.classes, oInit.oClasses );
		$this.addClass( oClasses.table );
		
		if (! oSettings.oFeatures.bPaginate) {
			oInit.iDisplayStart = 0;
		}
		
		if ( oSettings.iInitDisplayStart === undefined )
		{
			/* Display start point, taking into account the save saving */
			oSettings.iInitDisplayStart = oInit.iDisplayStart;
			oSettings._iDisplayStart = oInit.iDisplayStart;
		}
		
		var defer = oInit.iDeferLoading;
		if ( defer !== null )
		{
			oSettings.deferLoading = true;
		
			var tmp = Array.isArray(defer);
			oSettings._iRecordsDisplay = tmp ? defer[0] : defer;
			oSettings._iRecordsTotal = tmp ? defer[1] : defer;
		}
		
		/*
		 * Columns
		 * See if we should load columns automatically or use defined ones
		 */
		var columnsInit = [];
		var thead = this.getElementsByTagName('thead');
		var initHeaderLayout = _fnDetectHeader( oSettings, thead[0] );
		
		// If we don't have a columns array, then generate one with nulls
		if ( oInit.aoColumns ) {
			columnsInit = oInit.aoColumns;
		}
		else if ( initHeaderLayout.length ) {
			for ( i=0, iLen=initHeaderLayout[0].length ; i<iLen ; i++ ) {
				columnsInit.push( null );
			}
		}
		
		// Add the columns
		for ( i=0, iLen=columnsInit.length ; i<iLen ; i++ ) {
			_fnAddColumn( oSettings );
		}
		
		// Apply the column definitions
		_fnApplyColumnDefs( oSettings, oInit.aoColumnDefs, columnsInit, initHeaderLayout, function (iCol, oDef) {
			_fnColumnOptions( oSettings, iCol, oDef );
		} );
		
		/* HTML5 attribute detection - build an mData object automatically if the
		 * attributes are found
		 */
		var rowOne = $this.children('tbody').find('tr:first-child').eq(0);
		
		if ( rowOne.length ) {
			var a = function ( cell, name ) {
				return cell.getAttribute( 'data-'+name ) !== null ? name : null;
			};
		
			$( rowOne[0] ).children('th, td').each( function (i, cell) {
				var col = oSettings.aoColumns[i];
		
				if (! col) {
					_fnLog( oSettings, 0, 'Incorrect column count', 18 );
				}
		
				if ( col.mData === i ) {
					var sort = a( cell, 'sort' ) || a( cell, 'order' );
					var filter = a( cell, 'filter' ) || a( cell, 'search' );
		
					if ( sort !== null || filter !== null ) {
						col.mData = {
							_:      i+'.display',
							sort:   sort !== null   ? i+'.@data-'+sort   : undefined,
							type:   sort !== null   ? i+'.@data-'+sort   : undefined,
							filter: filter !== null ? i+'.@data-'+filter : undefined
						};
						col._isArrayHost = true;
		
						_fnColumnOptions( oSettings, i );
					}
				}
			} );
		}
		
		// Must be done after everything which can be overridden by the state saving!
		_fnCallbackReg( oSettings, 'aoDrawCallback', _fnSaveState );
		
		var features = oSettings.oFeatures;
		if ( oInit.bStateSave )
		{
			features.bStateSave = true;
		}
		
		// If aaSorting is not defined, then we use the first indicator in asSorting
		// in case that has been altered, so the default sort reflects that option
		if ( oInit.aaSorting === undefined ) {
			var sorting = oSettings.aaSorting;
			for ( i=0, iLen=sorting.length ; i<iLen ; i++ ) {
				sorting[i][1] = oSettings.aoColumns[ i ].asSorting[0];
			}
		}
		
		// Do a first pass on the sorting classes (allows any size changes to be taken into
		// account, and also will apply sorting disabled classes if disabled
		_fnSortingClasses( oSettings );
		
		_fnCallbackReg( oSettings, 'aoDrawCallback', function () {
			if ( oSettings.bSorted || _fnDataSource( oSettings ) === 'ssp' || features.bDeferRender ) {
				_fnSortingClasses( oSettings );
			}
		} );
		
		
		/*
		 * Table HTML init
		 * Cache the header, body and footer as required, creating them if needed
		 */
		var caption = $this.children('caption');
		
		if ( oSettings.caption ) {
			if ( caption.length === 0 ) {
				caption = $('<caption/>').prependTo( $this );
			}
		
			caption.html( oSettings.caption );
		}
		
		// Store the caption side, so we can remove the element from the document
		// when creating the element
		if (caption.length) {
			caption[0]._captionSide = caption.css('caption-side');
			oSettings.captionNode = caption[0];
		}
		
		// Place the colgroup element in the correct location for the HTML structure
		if (caption.length) {
			oSettings.colgroup.insertAfter(caption);
		}
		else {
			oSettings.colgroup.prependTo(oSettings.nTable);
		}
		
		if ( thead.length === 0 ) {
			thead = $('<thead/>').appendTo($this);
		}
		oSettings.nTHead = thead[0];
		
		var tbody = $this.children('tbody');
		if ( tbody.length === 0 ) {
			tbody = $('<tbody/>').insertAfter(thead);
		}
		oSettings.nTBody = tbody[0];
		
		var tfoot = $this.children('tfoot');
		if ( tfoot.length === 0 ) {
			// If we are a scrolling table, and no footer has been given, then we need to create
			// a tfoot element for the caption element to be appended to
			tfoot = $('<tfoot/>').insertAfter(thead);
		}
		oSettings.nTFoot = tfoot[0];
		
		// Copy the data index array
		oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();
		
		// Initialisation complete - table can be drawn
		oSettings.bInitialised = true;
		
		// Language definitions
		var oLanguage = oSettings.oLanguage;
		$.extend( true, oLanguage, oInit.oLanguage );
		
		if ( oLanguage.sUrl ) {
			// Get the language definitions from a file
			$.ajax( {
				dataType: 'json',
				url: oLanguage.sUrl,
				success: function ( json ) {
					_fnCamelToHungarian( defaults.oLanguage, json );
					$.extend( true, oLanguage, json, oSettings.oInit.oLanguage );
		
					_fnCallbackFire( oSettings, null, 'i18n', [oSettings], true);
					_fnInitialise( oSettings );
				},
				error: function () {
					// Error occurred loading language file
					_fnLog( oSettings, 0, 'i18n file loading error', 21 );
		
					// Continue on as best we can
					_fnInitialise( oSettings );
				}
			} );
		}
		else {
			_fnCallbackFire( oSettings, null, 'i18n', [oSettings], true);
			_fnInitialise( oSettings );
		}
	} );
	_that = null;
	return this;
};



/**
 * DataTables extensions
 * 
 * This namespace acts as a collection area for plug-ins that can be used to
 * extend DataTables capabilities. Indeed many of the build in methods
 * use this method to provide their own capabilities (sorting methods for
 * example).
 *
 * Note that this namespace is aliased to `jQuery.fn.dataTableExt` for legacy
 * reasons
 *
 *  @namespace
 */
DataTable.ext = _ext = {
	/**
	 * DataTables build type (expanded by the download builder)
	 *
	 *  @type string
	 */
	builder: "-source-",

	/**
	 * Buttons. For use with the Buttons extension for DataTables. This is
	 * defined here so other extensions can define buttons regardless of load
	 * order. It is _not_ used by DataTables core.
	 *
	 *  @type object
	 *  @default {}
	 */
	buttons: {},


	/**
	 * ColumnControl buttons and content
	 *
	 *  @type object
	 */
	ccContent: {},


	/**
	 * Element class names
	 *
	 *  @type object
	 *  @default {}
	 */
	classes: {},


	/**
	 * Error reporting.
	 * 
	 * How should DataTables report an error. Can take the value 'alert',
	 * 'throw', 'none' or a function.
	 *
	 *  @type string|function
	 *  @default alert
	 */
	errMode: "alert",

	/** HTML entity escaping */
	escape: {
		/** When reading data-* attributes for initialisation options */
		attributes: false
	},

	/**
	 * Legacy so v1 plug-ins don't throw js errors on load
	 */
	feature: [],

	/**
	 * Feature plug-ins.
	 * 
	 * This is an object of callbacks which provide the features for DataTables
	 * to be initialised via the `layout` option.
	 */
	features: {},


	/**
	 * Row searching.
	 * 
	 * This method of searching is complimentary to the default type based
	 * searching, and a lot more comprehensive as it allows you complete control
	 * over the searching logic. Each element in this array is a function
	 * (parameters described below) that is called for every row in the table,
	 * and your logic decides if it should be included in the searching data set
	 * or not.
	 *
	 * Searching functions have the following input parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{array|object}` Data for the row to be processed (same as the
	 *    original format that was passed in as the data source, or an array
	 *    from a DOM data source
	 * 3. `{int}` Row index ({@link DataTable.models.oSettings.aoData}), which
	 *    can be useful to retrieve the `TR` element if you need DOM interaction.
	 *
	 * And the following return is expected:
	 *
	 * * {boolean} Include the row in the searched result set (true) or not
	 *   (false)
	 *
	 * Note that as with the main search ability in DataTables, technically this
	 * is "filtering", since it is subtractive. However, for consistency in
	 * naming we call it searching here.
	 *
	 *  @type array
	 *  @default []
	 *
	 *  @example
	 *    // The following example shows custom search being applied to the
	 *    // fourth column (i.e. the data[3] index) based on two input values
	 *    // from the end-user, matching the data in a certain range.
	 *    $.fn.dataTable.ext.search.push(
	 *      function( settings, data, dataIndex ) {
	 *        var min = document.getElementById('min').value * 1;
	 *        var max = document.getElementById('max').value * 1;
	 *        var version = data[3] == "-" ? 0 : data[3]*1;
	 *
	 *        if ( min == "" && max == "" ) {
	 *          return true;
	 *        }
	 *        else if ( min == "" && version < max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && "" == max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && version < max ) {
	 *          return true;
	 *        }
	 *        return false;
	 *      }
	 *    );
	 */
	search: [],


	/**
	 * Selector extensions
	 *
	 * The `selector` option can be used to extend the options available for the
	 * selector modifier options (`selector-modifier` object data type) that
	 * each of the three built in selector types offer (row, column and cell +
	 * their plural counterparts). For example the Select extension uses this
	 * mechanism to provide an option to select only rows, columns and cells
	 * that have been marked as selected by the end user (`{selected: true}`),
	 * which can be used in conjunction with the existing built in selector
	 * options.
	 *
	 * Each property is an array to which functions can be pushed. The functions
	 * take three attributes:
	 *
	 * * Settings object for the host table
	 * * Options object (`selector-modifier` object type)
	 * * Array of selected item indexes
	 *
	 * The return is an array of the resulting item indexes after the custom
	 * selector has been applied.
	 *
	 *  @type object
	 */
	selector: {
		cell: [],
		column: [],
		row: []
	},


	/**
	 * Legacy configuration options. Enable and disable legacy options that
	 * are available in DataTables.
	 *
	 *  @type object
	 */
	legacy: {
		/**
		 * Enable / disable DataTables 1.9 compatible server-side processing
		 * requests
		 *
		 *  @type boolean
		 *  @default null
		 */
		ajax: null
	},


	/**
	 * Pagination plug-in methods.
	 * 
	 * Each entry in this object is a function and defines which buttons should
	 * be shown by the pagination rendering method that is used for the table:
	 * {@link DataTable.ext.renderer.pageButton}. The renderer addresses how the
	 * buttons are displayed in the document, while the functions here tell it
	 * what buttons to display. This is done by returning an array of button
	 * descriptions (what each button will do).
	 *
	 * Pagination types (the four built in options and any additional plug-in
	 * options defined here) can be used through the `paginationType`
	 * initialisation parameter.
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{int} page` The current page index
	 * 2. `{int} pages` The number of pages in the table
	 *
	 * Each function is expected to return an array where each element of the
	 * array can be one of:
	 *
	 * * `first` - Jump to first page when activated
	 * * `last` - Jump to last page when activated
	 * * `previous` - Show previous page when activated
	 * * `next` - Show next page when activated
	 * * `{int}` - Show page of the index given
	 * * `{array}` - A nested array containing the above elements to add a
	 *   containing 'DIV' element (might be useful for styling).
	 *
	 * Note that DataTables v1.9- used this object slightly differently whereby
	 * an object with two functions would be defined for each plug-in. That
	 * ability is still supported by DataTables 1.10+ to provide backwards
	 * compatibility, but this option of use is now decremented and no longer
	 * documented in DataTables 1.10+.
	 *
	 *  @type object
	 *  @default {}
	 *
	 *  @example
	 *    // Show previous, next and current page buttons only
	 *    $.fn.dataTableExt.oPagination.current = function ( page, pages ) {
	 *      return [ 'previous', page, 'next' ];
	 *    };
	 */
	pager: {},


	renderer: {
		pageButton: {},
		header: {}
	},


	/**
	 * Ordering plug-ins - custom data source
	 * 
	 * The extension options for ordering of data available here is complimentary
	 * to the default type based ordering that DataTables typically uses. It
	 * allows much greater control over the data that is being used to
	 * order a column, but is necessarily therefore more complex.
	 * 
	 * This type of ordering is useful if you want to do ordering based on data
	 * live from the DOM (for example the contents of an 'input' element) rather
	 * than just the static string that DataTables knows of.
	 * 
	 * The way these plug-ins work is that you create an array of the values you
	 * wish to be ordering for the column in question and then return that
	 * array. The data in the array much be in the index order of the rows in
	 * the table (not the currently ordering order!). Which order data gathering
	 * function is run here depends on the `dt-init columns.orderDataType`
	 * parameter that is used for the column (if any).
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{int}` Target column index
	 *
	 * Each function is expected to return an array:
	 *
	 * * `{array}` Data for the column to be ordering upon
	 *
	 *  @type array
	 *
	 *  @example
	 *    // Ordering using `input` node values
	 *    $.fn.dataTable.ext.order['dom-text'] = function  ( settings, col )
	 *    {
	 *      return this.api().column( col, {order:'index'} ).nodes().map( function ( td, i ) {
	 *        return $('input', td).val();
	 *      } );
	 *    }
	 */
	order: {},


	/**
	 * Type based plug-ins.
	 *
	 * Each column in DataTables has a type assigned to it, either by automatic
	 * detection or by direct assignment using the `type` option for the column.
	 * The type of a column will effect how it is ordering and search (plug-ins
	 * can also make use of the column type if required).
	 *
	 * @namespace
	 */
	type: {
		/**
		 * Automatic column class assignment
		 */
		className: {},

		/**
		 * Type detection functions.
		 *
		 * The functions defined in this object are used to automatically detect
		 * a column's type, making initialisation of DataTables super easy, even
		 * when complex data is in the table.
		 *
		 * The functions defined take two parameters:
		 *
	     *  1. `{*}` Data from the column cell to be analysed
	     *  2. `{settings}` DataTables settings object. This can be used to
	     *     perform context specific type detection - for example detection
	     *     based on language settings such as using a comma for a decimal
	     *     place. Generally speaking the options from the settings will not
	     *     be required
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Data type detected, or null if unknown (and thus
		 *   pass it on to the other type detection functions.
		 *
		 *  @type array
		 *
		 *  @example
		 *    // Currency type detection plug-in:
		 *    $.fn.dataTable.ext.type.detect.push(
		 *      function ( data, settings ) {
		 *        // Check the numeric part
		 *        if ( ! data.substring(1).match(/[0-9]/) ) {
		 *          return null;
		 *        }
		 *
		 *        // Check prefixed by currency
		 *        if ( data.charAt(0) == '$' || data.charAt(0) == '&pound;' ) {
		 *          return 'currency';
		 *        }
		 *        return null;
		 *      }
		 *    );
		 */
		detect: [],

		/**
		 * Automatic renderer assignment
		 */
		render: {},


		/**
		 * Type based search formatting.
		 *
		 * The type based searching functions can be used to pre-format the
		 * data to be search on. For example, it can be used to strip HTML
		 * tags or to de-format telephone numbers for numeric only searching.
		 *
		 * Note that is a search is not defined for a column of a given type,
		 * no search formatting will be performed.
		 * 
		 * Pre-processing of searching data plug-ins - When you assign the sType
		 * for a column (or have it automatically detected for you by DataTables
		 * or a type detection plug-in), you will typically be using this for
		 * custom sorting, but it can also be used to provide custom searching
		 * by allowing you to pre-processing the data and returning the data in
		 * the format that should be searched upon. This is done by adding
		 * functions this object with a parameter name which matches the sType
		 * for that target column. This is the corollary of <i>afnSortData</i>
		 * for searching data.
		 *
		 * The functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for searching
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Formatted string that will be used for the searching.
		 *
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    $.fn.dataTable.ext.type.search['title-numeric'] = function ( d ) {
		 *      return d.replace(/\n/g," ").replace( /<.*?>/g, "" );
		 *    }
		 */
		search: {},


		/**
		 * Type based ordering.
		 *
		 * The column type tells DataTables what ordering to apply to the table
		 * when a column is sorted upon. The order for each type that is defined,
		 * is defined by the functions available in this object.
		 *
		 * Each ordering option can be described by three properties added to
		 * this object:
		 *
		 * * `{type}-pre` - Pre-formatting function
		 * * `{type}-asc` - Ascending order function
		 * * `{type}-desc` - Descending order function
		 *
		 * All three can be used together, only `{type}-pre` or only
		 * `{type}-asc` and `{type}-desc` together. It is generally recommended
		 * that only `{type}-pre` is used, as this provides the optimal
		 * implementation in terms of speed, although the others are provided
		 * for compatibility with existing JavaScript sort functions.
		 *
		 * `{type}-pre`: Functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for ordering
		 *
		 * And return:
		 *
		 * * `{*}` Data to be sorted upon
		 *
		 * `{type}-asc` and `{type}-desc`: Functions are typical JavaScript sort
		 * functions, taking two parameters:
		 *
	     *  1. `{*}` Data to compare to the second parameter
	     *  2. `{*}` Data to compare to the first parameter
		 *
		 * And returning:
		 *
		 * * `{*}` Ordering match: <0 if first parameter should be sorted lower
		 *   than the second parameter, ===0 if the two parameters are equal and
		 *   >0 if the first parameter should be sorted height than the second
		 *   parameter.
		 * 
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    // Numeric ordering of formatted numbers with a pre-formatter
		 *    $.extend( $.fn.dataTable.ext.type.order, {
		 *      "string-pre": function(x) {
		 *        a = (a === "-" || a === "") ? 0 : a.replace( /[^\d\-\.]/g, "" );
		 *        return parseFloat( a );
		 *      }
		 *    } );
		 *
		 *  @example
		 *    // Case-sensitive string ordering, with no pre-formatting method
		 *    $.extend( $.fn.dataTable.ext.order, {
		 *      "string-case-asc": function(x,y) {
		 *        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		 *      },
		 *      "string-case-desc": function(x,y) {
		 *        return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		 *      }
		 *    } );
		 */
		order: {}
	},

	/**
	 * Unique DataTables instance counter
	 *
	 * @type int
	 * @private
	 */
	_unique: 0,


	//
	// Depreciated
	// The following properties are retained for backwards compatibility only.
	// The should not be used in new projects and will be removed in a future
	// version
	//

	/**
	 * Version check function.
	 *  @type function
	 *  @depreciated Since 1.10
	 */
	fnVersionCheck: DataTable.fnVersionCheck,


	/**
	 * Index for what 'this' index API functions should use
	 *  @type int
	 *  @deprecated Since v1.10
	 */
	iApiIndex: 0,


	/**
	 * Software version
	 *  @type string
	 *  @deprecated Since v1.10
	 */
	sVersion: DataTable.version
};


//
// Backwards compatibility. Alias to pre 1.10 Hungarian notation counter parts
//
$.extend( _ext, {
	afnFiltering: _ext.search,
	aTypes:       _ext.type.detect,
	ofnSearch:    _ext.type.search,
	oSort:        _ext.type.order,
	afnSortData:  _ext.order,
	aoFeatures:   _ext.feature,
	oStdClasses:  _ext.classes,
	oPagination:  _ext.pager
} );


$.extend( DataTable.ext.classes, {
	container: 'dt-container',
	empty: {
		row: 'dt-empty'
	},
	info: {
		container: 'dt-info'
	},
	layout: {
		row: 'dt-layout-row',
		cell: 'dt-layout-cell',
		tableRow: 'dt-layout-table',
		tableCell: '',
		start: 'dt-layout-start',
		end: 'dt-layout-end',
		full: 'dt-layout-full'
	},
	length: {
		container: 'dt-length',
		select: 'dt-input'
	},
	order: {
		canAsc: 'dt-orderable-asc',
		canDesc: 'dt-orderable-desc',
		isAsc: 'dt-ordering-asc',
		isDesc: 'dt-ordering-desc',
		none: 'dt-orderable-none',
		position: 'sorting_'
	},
	processing: {
		container: 'dt-processing'
	},
	scrolling: {
		body: 'dt-scroll-body',
		container: 'dt-scroll',
		footer: {
			self: 'dt-scroll-foot',
			inner: 'dt-scroll-footInner'
		},
		header: {
			self: 'dt-scroll-head',
			inner: 'dt-scroll-headInner'
		}
	},
	search: {
		container: 'dt-search',
		input: 'dt-input'
	},
	table: 'dataTable',	
	tbody: {
		cell: '',
		row: ''
	},
	thead: {
		cell: '',
		row: ''
	},
	tfoot: {
		cell: '',
		row: ''
	},
	paging: {
		active: 'current',
		button: 'dt-paging-button',
		container: 'dt-paging',
		disabled: 'disabled',
		nav: ''
	}
} );


/*
 * It is useful to have variables which are scoped locally so only the
 * DataTables functions can access them and they don't leak into global space.
 * At the same time these functions are often useful over multiple files in the
 * core and API, so we list, or at least document, all variables which are used
 * by DataTables as private variables here. This also ensures that there is no
 * clashing of variable names and that they can easily referenced for reuse.
 */


// Defined else where
//  _selector_run
//  _selector_opts
//  _selector_row_indexes

var _ext; // DataTable.ext
var _Api; // DataTable.Api
var _api_register; // DataTable.Api.register
var _api_registerPlural; // DataTable.Api.registerPlural

var _re_dic = {};
var _re_new_lines = /[\r\n\u2028]/g;
var _re_html = /<([^>]*>)/g;
var _max_str_len = Math.pow(2, 28);

// This is not strict ISO8601 - Date.parse() is quite lax, although
// implementations differ between browsers.
var _re_date = /^\d{2,4}[./-]\d{1,2}[./-]\d{1,2}([T ]{1}\d{1,2}[:.]\d{2}([.:]\d{2})?)?$/;

// Escape regular expression special characters
var _re_escape_regex = new RegExp( '(\\' + [ '/', '.', '*', '+', '?', '|', '(', ')', '[', ']', '{', '}', '\\', '$', '^', '-' ].join('|\\') + ')', 'g' );

// https://en.wikipedia.org/wiki/Foreign_exchange_market
// - \u20BD - Russian ruble.
// - \u20a9 - South Korean Won
// - \u20BA - Turkish Lira
// - \u20B9 - Indian Rupee
// - R - Brazil (R$) and South Africa
// - fr - Swiss Franc
// - kr - Swedish krona, Norwegian krone and Danish krone
// - \u2009 is thin space and \u202F is narrow no-break space, both used in many
// - Ƀ - Bitcoin
// - Ξ - Ethereum
//   standards as thousands separators.
var _re_formatted_numeric = /['\u00A0,$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfkɃΞ]/gi;


var _empty = function ( d ) {
	return !d || d === true || d === '-' ? true : false;
};


var _intVal = function ( s ) {
	var integer = parseInt( s, 10 );
	return !isNaN(integer) && isFinite(s) ? integer : null;
};

// Convert from a formatted number with characters other than `.` as the
// decimal place, to a JavaScript number
var _numToDecimal = function ( num, decimalPoint ) {
	// Cache created regular expressions for speed as this function is called often
	if ( ! _re_dic[ decimalPoint ] ) {
		_re_dic[ decimalPoint ] = new RegExp( _fnEscapeRegex( decimalPoint ), 'g' );
	}
	return typeof num === 'string' && decimalPoint !== '.' ?
		num.replace( /\./g, '' ).replace( _re_dic[ decimalPoint ], '.' ) :
		num;
};


var _isNumber = function ( d, decimalPoint, formatted, allowEmpty ) {
	var type = typeof d;
	var strType = type === 'string';

	if ( type === 'number' || type === 'bigint') {
		return true;
	}

	// If empty return immediately so there must be a number if it is a
	// formatted string (this stops the string "k", or "kr", etc being detected
	// as a formatted number for currency
	if ( allowEmpty && _empty( d ) ) {
		return true;
	}

	if ( decimalPoint && strType ) {
		d = _numToDecimal( d, decimalPoint );
	}

	if ( formatted && strType ) {
		d = d.replace( _re_formatted_numeric, '' );
	}

	return !isNaN( parseFloat(d) ) && isFinite( d );
};


// A string without HTML in it can be considered to be HTML still
var _isHtml = function ( d ) {
	return _empty( d ) || typeof d === 'string';
};

// Is a string a number surrounded by HTML?
var _htmlNumeric = function ( d, decimalPoint, formatted, allowEmpty ) {
	if ( allowEmpty && _empty( d ) ) {
		return true;
	}

	// input and select strings mean that this isn't just a number
	if (typeof d === 'string' && d.match(/<(input|select)/i)) {
		return null;
	}

	var html = _isHtml( d );
	return ! html ?
		null :
		_isNumber( _stripHtml( d ), decimalPoint, formatted, allowEmpty ) ?
			true :
			null;
};


var _pluck = function ( a, prop, prop2 ) {
	var out = [];
	var i=0, iLen=a.length;

	// Could have the test in the loop for slightly smaller code, but speed
	// is essential here
	if ( prop2 !== undefined ) {
		for ( ; i<iLen ; i++ ) {
			if ( a[i] && a[i][ prop ] ) {
				out.push( a[i][ prop ][ prop2 ] );
			}
		}
	}
	else {
		for ( ; i<iLen ; i++ ) {
			if ( a[i] ) {
				out.push( a[i][ prop ] );
			}
		}
	}

	return out;
};


// Basically the same as _pluck, but rather than looping over `a` we use `order`
// as the indexes to pick from `a`
var _pluck_order = function ( a, order, prop, prop2 )
{
	var out = [];
	var i=0, iLen=order.length;

	// Could have the test in the loop for slightly smaller code, but speed
	// is essential here
	if ( prop2 !== undefined ) {
		for ( ; i<iLen ; i++ ) {
			if ( a[ order[i] ] && a[ order[i] ][ prop ] ) {
				out.push( a[ order[i] ][ prop ][ prop2 ] );
			}
		}
	}
	else {
		for ( ; i<iLen ; i++ ) {
			if ( a[ order[i] ] ) {
				out.push( a[ order[i] ][ prop ] );
			}
		}
	}

	return out;
};


var _range = function ( len, start )
{
	var out = [];
	var end;

	if ( start === undefined ) {
		start = 0;
		end = len;
	}
	else {
		end = start;
		start = len;
	}

	for ( var i=start ; i<end ; i++ ) {
		out.push( i );
	}

	return out;
};


var _removeEmpty = function ( a )
{
	var out = [];

	for ( var i=0, iLen=a.length ; i<iLen ; i++ ) {
		if ( a[i] ) { // careful - will remove all falsy values!
			out.push( a[i] );
		}
	}

	return out;
};

// Replaceable function in api.util
var _stripHtml = function (input, replacement) {
	if (! input || typeof input !== 'string') {
		return input;
	}

	// Irrelevant check to workaround CodeQL's false positive on the regex
	if (input.length > _max_str_len) {
		throw new Error('Exceeded max str len');
	}

	var previous;

	input = input.replace(_re_html, replacement || ''); // Complete tags

	// Safety for incomplete script tag - use do / while to ensure that
	// we get all instances
	do {
		previous = input;
		input = input.replace(/<script/i, '');
	} while (input !== previous);

	return previous;
};

// Replaceable function in api.util
var _escapeHtml = function ( d ) {
	if (Array.isArray(d)) {
		d = d.join(',');
	}

	return typeof d === 'string' ?
		d
			.replace(/&/g, '&amp;')
			.replace(/</g, '&lt;')
			.replace(/>/g, '&gt;')
			.replace(/"/g, '&quot;') :
		d;
};

// Remove diacritics from a string by decomposing it and then removing
// non-ascii characters
var _normalize = function (str, both) {
	if (typeof str !== 'string') {
		return str;
	}

	// It is faster to just run `normalize` than it is to check if
	// we need to with a regex! (Check as it isn't available in old
	// Safari)
	var res = str.normalize
		? str.normalize("NFD")
		: str;

	// Equally, here we check if a regex is needed or not
	return res.length !== str.length
		? (both === true ? str + ' ' : '' ) + res.replace(/[\u0300-\u036f]/g, "")
		: res;
}

/**
 * Determine if all values in the array are unique. This means we can short
 * cut the _unique method at the cost of a single loop. A sorted array is used
 * to easily check the values.
 *
 * @param  {array} src Source array
 * @return {boolean} true if all unique, false otherwise
 * @ignore
 */
var _areAllUnique = function ( src ) {
	if ( src.length < 2 ) {
		return true;
	}

	var sorted = src.slice().sort();
	var last = sorted[0];

	for ( var i=1, iLen=sorted.length ; i<iLen ; i++ ) {
		if ( sorted[i] === last ) {
			return false;
		}

		last = sorted[i];
	}

	return true;
};


/**
 * Find the unique elements in a source array.
 *
 * @param  {array} src Source array
 * @return {array} Array of unique items
 * @ignore
 */
var _unique = function ( src )
{
	if (Array.from && Set) {
		return Array.from(new Set(src));
	}

	if ( _areAllUnique( src ) ) {
		return src.slice();
	}

	// A faster unique method is to use object keys to identify used values,
	// but this doesn't work with arrays or objects, which we must also
	// consider. See jsperf.app/compare-array-unique-versions/4 for more
	// information.
	var
		out = [],
		val,
		i, iLen=src.length,
		j, k=0;

	again: for ( i=0 ; i<iLen ; i++ ) {
		val = src[i];

		for ( j=0 ; j<k ; j++ ) {
			if ( out[j] === val ) {
				continue again;
			}
		}

		out.push( val );
		k++;
	}

	return out;
};

// Surprisingly this is faster than [].concat.apply
// https://jsperf.com/flatten-an-array-loop-vs-reduce/2
var _flatten = function (out, val) {
	if (Array.isArray(val)) {
		for (var i=0 ; i<val.length ; i++) {
			_flatten(out, val[i]);
		}
	}
	else {
		out.push(val);
	}

	return out;
}

// Similar to jQuery's addClass, but use classList.add
function _addClass(el, name) {
	if (name) {
		name.split(' ').forEach(function (n) {
			if (n) {
				// `add` does deduplication, so no need to check `contains`
				el.classList.add(n);
			}
		});
	}
}

/**
 * DataTables utility methods
 * 
 * This namespace provides helper methods that DataTables uses internally to
 * create a DataTable, but which are not exclusively used only for DataTables.
 * These methods can be used by extension authors to save the duplication of
 * code.
 *
 *  @namespace
 */
DataTable.util = {
	/**
	 * Return a string with diacritic characters decomposed
	 * @param {*} mixed Function or string to normalize
	 * @param {*} both Return original string and the normalized string
	 * @returns String or undefined
	 */
	diacritics: function (mixed, both) {
		var type = typeof mixed;

		if (type !== 'function') {
			return _normalize(mixed, both);
		}
		_normalize = mixed;
	},

	/**
	 * Debounce a function
	 *
	 * @param {function} fn Function to be called
	 * @param {integer} freq Call frequency in mS
	 * @return {function} Wrapped function
	 */
	debounce: function ( fn, timeout ) {
		var timer;

		return function () {
			var that = this;
			var args = arguments;

			clearTimeout(timer);

			timer = setTimeout( function () {
				fn.apply(that, args);
			}, timeout || 250 );
		};
	},

	/**
	 * Throttle the calls to a function. Arguments and context are maintained
	 * for the throttled function.
	 *
	 * @param {function} fn Function to be called
	 * @param {integer} freq Call frequency in mS
	 * @return {function} Wrapped function
	 */
	throttle: function ( fn, freq ) {
		var
			frequency = freq !== undefined ? freq : 200,
			last,
			timer;

		return function () {
			var
				that = this,
				now  = +new Date(),
				args = arguments;

			if ( last && now < last + frequency ) {
				clearTimeout( timer );

				timer = setTimeout( function () {
					last = undefined;
					fn.apply( that, args );
				}, frequency );
			}
			else {
				last = now;
				fn.apply( that, args );
			}
		};
	},

	/**
	 * Escape a string such that it can be used in a regular expression
	 *
	 *  @param {string} val string to escape
	 *  @returns {string} escaped string
	 */
	escapeRegex: function ( val ) {
		return val.replace( _re_escape_regex, '\\$1' );
	},

	/**
	 * Create a function that will write to a nested object or array
	 * @param {*} source JSON notation string
	 * @returns Write function
	 */
	set: function ( source ) {
		if ( $.isPlainObject( source ) ) {
			/* Unlike get, only the underscore (global) option is used for for
			 * setting data since we don't know the type here. This is why an object
			 * option is not documented for `mData` (which is read/write), but it is
			 * for `mRender` which is read only.
			 */
			return DataTable.util.set( source._ );
		}
		else if ( source === null ) {
			// Nothing to do when the data source is null
			return function () {};
		}
		else if ( typeof source === 'function' ) {
			return function (data, val, meta) {
				source( data, 'set', val, meta );
			};
		}
		else if (
			typeof source === 'string' && (source.indexOf('.') !== -1 ||
			source.indexOf('[') !== -1 || source.indexOf('(') !== -1)
		) {
			// Like the get, we need to get data from a nested object
			var setData = function (data, val, src) {
				var a = _fnSplitObjNotation( src ), b;
				var aLast = a[a.length-1];
				var arrayNotation, funcNotation, o, innerSrc;
	
				for ( var i=0, iLen=a.length-1 ; i<iLen ; i++ ) {
					// Protect against prototype pollution
					if (a[i] === '__proto__' || a[i] === 'constructor') {
						throw new Error('Cannot set prototype values');
					}
	
					// Check if we are dealing with an array notation request
					arrayNotation = a[i].match(__reArray);
					funcNotation = a[i].match(__reFn);
	
					if ( arrayNotation ) {
						a[i] = a[i].replace(__reArray, '');
						data[ a[i] ] = [];
	
						// Get the remainder of the nested object to set so we can recurse
						b = a.slice();
						b.splice( 0, i+1 );
						innerSrc = b.join('.');
	
						// Traverse each entry in the array setting the properties requested
						if ( Array.isArray( val ) ) {
							for ( var j=0, jLen=val.length ; j<jLen ; j++ ) {
								o = {};
								setData( o, val[j], innerSrc );
								data[ a[i] ].push( o );
							}
						}
						else {
							// We've been asked to save data to an array, but it
							// isn't array data to be saved. Best that can be done
							// is to just save the value.
							data[ a[i] ] = val;
						}
	
						// The inner call to setData has already traversed through the remainder
						// of the source and has set the data, thus we can exit here
						return;
					}
					else if ( funcNotation ) {
						// Function call
						a[i] = a[i].replace(__reFn, '');
						data = data[ a[i] ]( val );
					}
	
					// If the nested object doesn't currently exist - since we are
					// trying to set the value - create it
					if ( data[ a[i] ] === null || data[ a[i] ] === undefined ) {
						data[ a[i] ] = {};
					}
					data = data[ a[i] ];
				}
	
				// Last item in the input - i.e, the actual set
				if ( aLast.match(__reFn ) ) {
					// Function call
					data = data[ aLast.replace(__reFn, '') ]( val );
				}
				else {
					// If array notation is used, we just want to strip it and use the property name
					// and assign the value. If it isn't used, then we get the result we want anyway
					data[ aLast.replace(__reArray, '') ] = val;
				}
			};
	
			return function (data, val) { // meta is also passed in, but not used
				return setData( data, val, source );
			};
		}
		else {
			// Array or flat object mapping
			return function (data, val) { // meta is also passed in, but not used
				data[source] = val;
			};
		}
	},

	/**
	 * Create a function that will read nested objects from arrays, based on JSON notation
	 * @param {*} source JSON notation string
	 * @returns Value read
	 */
	get: function ( source ) {
		if ( $.isPlainObject( source ) ) {
			// Build an object of get functions, and wrap them in a single call
			var o = {};
			$.each( source, function (key, val) {
				if ( val ) {
					o[key] = DataTable.util.get( val );
				}
			} );
	
			return function (data, type, row, meta) {
				var t = o[type] || o._;
				return t !== undefined ?
					t(data, type, row, meta) :
					data;
			};
		}
		else if ( source === null ) {
			// Give an empty string for rendering / sorting etc
			return function (data) { // type, row and meta also passed, but not used
				return data;
			};
		}
		else if ( typeof source === 'function' ) {
			return function (data, type, row, meta) {
				return source( data, type, row, meta );
			};
		}
		else if (
			typeof source === 'string' && (source.indexOf('.') !== -1 ||
			source.indexOf('[') !== -1 || source.indexOf('(') !== -1)
		) {
			/* If there is a . in the source string then the data source is in a
			 * nested object so we loop over the data for each level to get the next
			 * level down. On each loop we test for undefined, and if found immediately
			 * return. This allows entire objects to be missing and sDefaultContent to
			 * be used if defined, rather than throwing an error
			 */
			var fetchData = function (data, type, src) {
				var arrayNotation, funcNotation, out, innerSrc;
	
				if ( src !== "" ) {
					var a = _fnSplitObjNotation( src );
	
					for ( var i=0, iLen=a.length ; i<iLen ; i++ ) {
						// Check if we are dealing with special notation
						arrayNotation = a[i].match(__reArray);
						funcNotation = a[i].match(__reFn);
	
						if ( arrayNotation ) {
							// Array notation
							a[i] = a[i].replace(__reArray, '');
	
							// Condition allows simply [] to be passed in
							if ( a[i] !== "" ) {
								data = data[ a[i] ];
							}
							out = [];
	
							// Get the remainder of the nested object to get
							a.splice( 0, i+1 );
							innerSrc = a.join('.');
	
							// Traverse each entry in the array getting the properties requested
							if ( Array.isArray( data ) ) {
								for ( var j=0, jLen=data.length ; j<jLen ; j++ ) {
									out.push( fetchData( data[j], type, innerSrc ) );
								}
							}
	
							// If a string is given in between the array notation indicators, that
							// is used to join the strings together, otherwise an array is returned
							var join = arrayNotation[0].substring(1, arrayNotation[0].length-1);
							data = (join==="") ? out : out.join(join);
	
							// The inner call to fetchData has already traversed through the remainder
							// of the source requested, so we exit from the loop
							break;
						}
						else if ( funcNotation ) {
							// Function call
							a[i] = a[i].replace(__reFn, '');
							data = data[ a[i] ]();
							continue;
						}
	
						if (data === null || data[ a[i] ] === null) {
							return null;
						}
						else if ( data === undefined || data[ a[i] ] === undefined ) {
							return undefined;
						}

						data = data[ a[i] ];
					}
				}
	
				return data;
			};
	
			return function (data, type) { // row and meta also passed, but not used
				return fetchData( data, type, source );
			};
		}
		else {
			// Array or flat object mapping
			return function (data) { // row and meta also passed, but not used
				return data[source];
			};
		}
	},

	stripHtml: function (mixed, replacement) {
		var type = typeof mixed;

		if (type === 'function') {
			_stripHtml = mixed;
			return;
		}
		else if (type === 'string') {
			return _stripHtml(mixed, replacement);
		}
		return mixed;
	},

	escapeHtml: function (mixed) {
		var type = typeof mixed;

		if (type === 'function') {
			_escapeHtml = mixed;
			return;
		}
		else if (type === 'string' || Array.isArray(mixed)) {
			return _escapeHtml(mixed);
		}
		return mixed;
	},

	unique: _unique
};



/**
 * Create a mapping object that allows camel case parameters to be looked up
 * for their Hungarian counterparts. The mapping is stored in a private
 * parameter called `_hungarianMap` which can be accessed on the source object.
 *  @param {object} o
 *  @memberof DataTable#oApi
 */
function _fnHungarianMap ( o )
{
	var
		hungarian = 'a aa ai ao as b fn i m o s ',
		match,
		newKey,
		map = {};

	$.each( o, function (key) {
		match = key.match(/^([^A-Z]+?)([A-Z])/);

		if ( match && hungarian.indexOf(match[1]+' ') !== -1 )
		{
			newKey = key.replace( match[0], match[2].toLowerCase() );
			map[ newKey ] = key;

			if ( match[1] === 'o' )
			{
				_fnHungarianMap( o[key] );
			}
		}
	} );

	o._hungarianMap = map;
}


/**
 * Convert from camel case parameters to Hungarian, based on a Hungarian map
 * created by _fnHungarianMap.
 *  @param {object} src The model object which holds all parameters that can be
 *    mapped.
 *  @param {object} user The object to convert from camel case to Hungarian.
 *  @param {boolean} force When set to `true`, properties which already have a
 *    Hungarian value in the `user` object will be overwritten. Otherwise they
 *    won't be.
 *  @memberof DataTable#oApi
 */
function _fnCamelToHungarian ( src, user, force )
{
	if ( ! src._hungarianMap ) {
		_fnHungarianMap( src );
	}

	var hungarianKey;

	$.each( user, function (key) {
		hungarianKey = src._hungarianMap[ key ];

		if ( hungarianKey !== undefined && (force || user[hungarianKey] === undefined) )
		{
			// For objects, we need to buzz down into the object to copy parameters
			if ( hungarianKey.charAt(0) === 'o' )
			{
				// Copy the camelCase options over to the hungarian
				if ( ! user[ hungarianKey ] ) {
					user[ hungarianKey ] = {};
				}
				$.extend( true, user[hungarianKey], user[key] );

				_fnCamelToHungarian( src[hungarianKey], user[hungarianKey], force );
			}
			else {
				user[hungarianKey] = user[ key ];
			}
		}
	} );
}

/**
 * Map one parameter onto another
 *  @param {object} o Object to map
 *  @param {*} knew The new parameter name
 *  @param {*} old The old parameter name
 */
var _fnCompatMap = function ( o, knew, old ) {
	if ( o[ knew ] !== undefined ) {
		o[ old ] = o[ knew ];
	}
};


/**
 * Provide backwards compatibility for the main DT options. Note that the new
 * options are mapped onto the old parameters, so this is an external interface
 * change only.
 *  @param {object} init Object to map
 */
function _fnCompatOpts ( init )
{
	_fnCompatMap( init, 'ordering',      'bSort' );
	_fnCompatMap( init, 'orderMulti',    'bSortMulti' );
	_fnCompatMap( init, 'orderClasses',  'bSortClasses' );
	_fnCompatMap( init, 'orderCellsTop', 'bSortCellsTop' );
	_fnCompatMap( init, 'order',         'aaSorting' );
	_fnCompatMap( init, 'orderFixed',    'aaSortingFixed' );
	_fnCompatMap( init, 'paging',        'bPaginate' );
	_fnCompatMap( init, 'pagingType',    'sPaginationType' );
	_fnCompatMap( init, 'pageLength',    'iDisplayLength' );
	_fnCompatMap( init, 'searching',     'bFilter' );

	// Boolean initialisation of x-scrolling
	if ( typeof init.sScrollX === 'boolean' ) {
		init.sScrollX = init.sScrollX ? '100%' : '';
	}
	if ( typeof init.scrollX === 'boolean' ) {
		init.scrollX = init.scrollX ? '100%' : '';
	}

	// Objects for ordering
	if ( typeof init.bSort === 'object' ) {
		init.orderIndicators = init.bSort.indicators !== undefined ? init.bSort.indicators : true;
		init.orderHandler = init.bSort.handler !== undefined ? init.bSort.handler : true;
		init.bSort = true;
	}
	else if (init.bSort === false) {
		init.orderIndicators = false;
		init.orderHandler = false;
	}
	else if (init.bSort === true) {
		init.orderIndicators = true;
		init.orderHandler = true;
	}

	// Which cells are the title cells?
	if (typeof init.bSortCellsTop === 'boolean') {
		init.titleRow = init.bSortCellsTop;
	}

	// Column search objects are in an array, so it needs to be converted
	// element by element
	var searchCols = init.aoSearchCols;

	if ( searchCols ) {
		for ( var i=0, iLen=searchCols.length ; i<iLen ; i++ ) {
			if ( searchCols[i] ) {
				_fnCamelToHungarian( DataTable.models.oSearch, searchCols[i] );
			}
		}
	}

	// Enable search delay if server-side processing is enabled
	if (init.serverSide && ! init.searchDelay) {
		init.searchDelay = 400;
	}
}


/**
 * Provide backwards compatibility for column options. Note that the new options
 * are mapped onto the old parameters, so this is an external interface change
 * only.
 *  @param {object} init Object to map
 */
function _fnCompatCols ( init )
{
	_fnCompatMap( init, 'orderable',     'bSortable' );
	_fnCompatMap( init, 'orderData',     'aDataSort' );
	_fnCompatMap( init, 'orderSequence', 'asSorting' );
	_fnCompatMap( init, 'orderDataType', 'sortDataType' );

	// orderData can be given as an integer
	var dataSort = init.aDataSort;
	if ( typeof dataSort === 'number' && ! Array.isArray( dataSort ) ) {
		init.aDataSort = [ dataSort ];
	}
}


/**
 * Browser feature detection for capabilities, quirks
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnBrowserDetect( settings )
{
	// We don't need to do this every time DataTables is constructed, the values
	// calculated are specific to the browser and OS configuration which we
	// don't expect to change between initialisations
	if ( ! DataTable.__browser ) {
		var browser = {};
		DataTable.__browser = browser;

		// Scrolling feature / quirks detection
		var n = $('<div/>')
			.css( {
				position: 'fixed',
				top: 0,
				left: -1 * window.pageXOffset, // allow for scrolling
				height: 1,
				width: 1,
				overflow: 'hidden'
			} )
			.append(
				$('<div/>')
					.css( {
						position: 'absolute',
						top: 1,
						left: 1,
						width: 100,
						overflow: 'scroll'
					} )
					.append(
						$('<div/>')
							.css( {
								width: '100%',
								height: 10
							} )
					)
			)
			.appendTo( 'body' );

		var outer = n.children();
		var inner = outer.children();

		// Get scrollbar width
		browser.barWidth = outer[0].offsetWidth - outer[0].clientWidth;

		// In rtl text layout, some browsers (most, but not all) will place the
		// scrollbar on the left, rather than the right.
		browser.bScrollbarLeft = Math.round( inner.offset().left ) !== 1;

		n.remove();
	}

	$.extend( settings.oBrowser, DataTable.__browser );
	settings.oScroll.iBarWidth = DataTable.__browser.barWidth;
}

/**
 * Add a column to the list used for the table with default values
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAddColumn( oSettings )
{
	// Add column to aoColumns array
	var oDefaults = DataTable.defaults.column;
	var iCol = oSettings.aoColumns.length;
	var oCol = $.extend( {}, DataTable.models.oColumn, oDefaults, {
		"aDataSort": oDefaults.aDataSort ? oDefaults.aDataSort : [iCol],
		"mData": oDefaults.mData ? oDefaults.mData : iCol,
		idx: iCol,
		searchFixed: {},
		colEl: $('<col>').attr('data-dt-column', iCol)
	} );
	oSettings.aoColumns.push( oCol );

	// Add search object for column specific search. Note that the `searchCols[ iCol ]`
	// passed into extend can be undefined. This allows the user to give a default
	// with only some of the parameters defined, and also not give a default
	var searchCols = oSettings.aoPreSearchCols;
	searchCols[ iCol ] = $.extend( {}, DataTable.models.oSearch, searchCols[ iCol ] );
}


/**
 * Apply options for a column
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iCol column index to consider
 *  @param {object} oOptions object with sType, bVisible and bSearchable etc
 *  @memberof DataTable#oApi
 */
function _fnColumnOptions( oSettings, iCol, oOptions )
{
	var oCol = oSettings.aoColumns[ iCol ];

	/* User specified column options */
	if ( oOptions !== undefined && oOptions !== null )
	{
		// Backwards compatibility
		_fnCompatCols( oOptions );

		// Map camel case parameters to their Hungarian counterparts
		_fnCamelToHungarian( DataTable.defaults.column, oOptions, true );

		/* Backwards compatibility for mDataProp */
		if ( oOptions.mDataProp !== undefined && !oOptions.mData )
		{
			oOptions.mData = oOptions.mDataProp;
		}

		if ( oOptions.sType )
		{
			oCol._sManualType = oOptions.sType;
		}
	
		// `class` is a reserved word in JavaScript, so we need to provide
		// the ability to use a valid name for the camel case input
		if ( oOptions.className && ! oOptions.sClass )
		{
			oOptions.sClass = oOptions.className;
		}

		var origClass = oCol.sClass;

		$.extend( oCol, oOptions );
		_fnMap( oCol, oOptions, "sWidth", "sWidthOrig" );

		// Merge class from previously defined classes with this one, rather than just
		// overwriting it in the extend above
		if (origClass !== oCol.sClass) {
			oCol.sClass = origClass + ' ' + oCol.sClass;
		}

		/* iDataSort to be applied (backwards compatibility), but aDataSort will take
		 * priority if defined
		 */
		if ( oOptions.iDataSort !== undefined )
		{
			oCol.aDataSort = [ oOptions.iDataSort ];
		}
		_fnMap( oCol, oOptions, "aDataSort" );
	}

	/* Cache the data get and set functions for speed */
	var mDataSrc = oCol.mData;
	var mData = _fnGetObjectDataFn( mDataSrc );

	// The `render` option can be given as an array to access the helper rendering methods.
	// The first element is the rendering method to use, the rest are the parameters to pass
	if ( oCol.mRender && Array.isArray( oCol.mRender ) ) {
		var copy = oCol.mRender.slice();
		var name = copy.shift();

		oCol.mRender = DataTable.render[name].apply(window, copy);
	}

	oCol._render = oCol.mRender ? _fnGetObjectDataFn( oCol.mRender ) : null;

	var attrTest = function( src ) {
		return typeof src === 'string' && src.indexOf('@') !== -1;
	};
	oCol._bAttrSrc = $.isPlainObject( mDataSrc ) && (
		attrTest(mDataSrc.sort) || attrTest(mDataSrc.type) || attrTest(mDataSrc.filter)
	);
	oCol._setter = null;

	oCol.fnGetData = function (rowData, type, meta) {
		var innerData = mData( rowData, type, undefined, meta );

		return oCol._render && type ?
			oCol._render( innerData, type, rowData, meta ) :
			innerData;
	};
	oCol.fnSetData = function ( rowData, val, meta ) {
		return _fnSetObjectDataFn( mDataSrc )( rowData, val, meta );
	};

	// Indicate if DataTables should read DOM data as an object or array
	// Used in _fnGetRowElements
	if ( typeof mDataSrc !== 'number' && ! oCol._isArrayHost ) {
		oSettings._rowReadObject = true;
	}

	/* Feature sorting overrides column specific when off */
	if ( !oSettings.oFeatures.bSort )
	{
		oCol.bSortable = false;
	}
}


/**
 * Adjust the table column widths for new data. Note: you would probably want to
 * do a redraw after calling this function!
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAdjustColumnSizing ( settings )
{
	_fnCalculateColumnWidths( settings );
	_fnColumnSizes( settings );

	var scroll = settings.oScroll;
	if ( scroll.sY !== '' || scroll.sX !== '') {
		_fnScrollDraw( settings );
	}

	_fnCallbackFire( settings, null, 'column-sizing', [settings] );
}

/**
 * Apply column sizes
 *
 * @param {*} settings DataTables settings object
 */
function _fnColumnSizes ( settings )
{
	var cols = settings.aoColumns;

	for (var i=0 ; i<cols.length ; i++) {
		var width = _fnColumnsSumWidth(settings, [i], false, false);

		cols[i].colEl.css('width', width);

		if (settings.oScroll.sX) {
			cols[i].colEl.css('min-width', width);
		}
	}
}


/**
 * Convert the index of a visible column to the index in the data array (take account
 * of hidden columns)
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iMatch Visible column index to lookup
 *  @returns {int} i the data index
 *  @memberof DataTable#oApi
 */
function _fnVisibleToColumnIndex( oSettings, iMatch )
{
	var aiVis = _fnGetColumns( oSettings, 'bVisible' );

	return typeof aiVis[iMatch] === 'number' ?
		aiVis[iMatch] :
		null;
}


/**
 * Convert the index of an index in the data array and convert it to the visible
 *   column index (take account of hidden columns)
 *  @param {int} iMatch Column index to lookup
 *  @param {object} oSettings dataTables settings object
 *  @returns {int} i the data index
 *  @memberof DataTable#oApi
 */
function _fnColumnIndexToVisible( oSettings, iMatch )
{
	var aiVis = _fnGetColumns( oSettings, 'bVisible' );
	var iPos = aiVis.indexOf(iMatch);

	return iPos !== -1 ? iPos : null;
}


/**
 * Get the number of visible columns
 *  @param {object} oSettings dataTables settings object
 *  @returns {int} i the number of visible columns
 *  @memberof DataTable#oApi
 */
function _fnVisibleColumns( settings )
{
	var layout = settings.aoHeader;
	var columns = settings.aoColumns;
	var vis = 0;

	if ( layout.length ) {
		for ( var i=0, iLen=layout[0].length ; i<iLen ; i++ ) {
			if ( columns[i].bVisible && $(layout[0][i].cell).css('display') !== 'none' ) {
				vis++;
			}
		}
	}

	return vis;
}


/**
 * Get an array of column indexes that match a given property
 *  @param {object} oSettings dataTables settings object
 *  @param {string} sParam Parameter in aoColumns to look for - typically
 *    bVisible or bSearchable
 *  @returns {array} Array of indexes with matched properties
 *  @memberof DataTable#oApi
 */
function _fnGetColumns( oSettings, sParam )
{
	var a = [];

	oSettings.aoColumns.map( function(val, i) {
		if ( val[sParam] ) {
			a.push( i );
		}
	} );

	return a;
}

/**
 * Allow the result from a type detection function to be `true` while
 * translating that into a string. Old type detection functions will
 * return the type name if it passes. An object store would be better,
 * but not backwards compatible.
 *
 * @param {*} typeDetect Object or function for type detection
 * @param {*} res Result from the type detection function
 * @returns Type name or false
 */
function _typeResult (typeDetect, res) {
	return res === true
		? typeDetect._name
		: res;
}

/**
 * Calculate the 'type' of a column
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnColumnTypes ( settings )
{
	var columns = settings.aoColumns;
	var data = settings.aoData;
	var types = DataTable.ext.type.detect;
	var i, iLen, j, jen, k, ken;
	var col, detectedType, cache;

	// For each column, spin over the data type detection functions, seeing if one matches
	for ( i=0, iLen=columns.length ; i<iLen ; i++ ) {
		col = columns[i];
		cache = [];

		if ( ! col.sType && col._sManualType ) {
			col.sType = col._sManualType;
		}
		else if ( ! col.sType ) {
			// With SSP type detection can be unreliable and error prone, so we provide a way
			// to turn it off.
			if (! settings.typeDetect) {
				return;
			}

			for ( j=0, jen=types.length ; j<jen ; j++ ) {
				var typeDetect = types[j];

				// There can be either one, or three type detection functions
				var oneOf = typeDetect.oneOf;
				var allOf = typeDetect.allOf || typeDetect;
				var init = typeDetect.init;
				var one = false;

				detectedType = null;

				// Fast detect based on column assignment
				if (init) {
					detectedType = _typeResult(typeDetect, init(settings, col, i));

					if (detectedType) {
						col.sType = detectedType;
						break;
					}
				}

				for ( k=0, ken=data.length ; k<ken ; k++ ) {
					if (! data[k]) {
						continue;
					}

					// Use a cache array so we only need to get the type data
					// from the formatter once (when using multiple detectors)
					if ( cache[k] === undefined ) {
						cache[k] = _fnGetCellData( settings, k, i, 'type' );
					}

					// Only one data point in the column needs to match this function
					if (oneOf && ! one) {
						one = _typeResult(typeDetect, oneOf( cache[k], settings ));
					}

					// All data points need to match this function
					detectedType = _typeResult(typeDetect, allOf( cache[k], settings ));

					// If null, then this type can't apply to this column, so
					// rather than testing all cells, break out. There is an
					// exception for the last type which is `html`. We need to
					// scan all rows since it is possible to mix string and HTML
					// types
					if ( ! detectedType && j !== types.length-3 ) {
						break;
					}

					// Only a single match is needed for html type since it is
					// bottom of the pile and very similar to string - but it
					// must not be empty
					if ( detectedType === 'html' && ! _empty(cache[k]) ) {
						break;
					}
				}

				// Type is valid for all data points in the column - use this
				// type
				if ( (oneOf && one && detectedType) || (!oneOf && detectedType) ) {
					col.sType = detectedType;
					break;
				}
			}

			// Fall back - if no type was detected, always use string
			if ( ! col.sType ) {
				col.sType = 'string';
			}
		}

		// Set class names for header / footer for auto type classes
		var autoClass = _ext.type.className[col.sType];

		if (autoClass) {
			_columnAutoClass(settings.aoHeader, i, autoClass);
			_columnAutoClass(settings.aoFooter, i, autoClass);
		}

		var renderer = _ext.type.render[col.sType];

		// This can only happen once! There is no way to remove
		// a renderer. After the first time the renderer has
		// already been set so createTr will run the renderer itself.
		if (renderer && ! col._render) {
			col._render = DataTable.util.get(renderer);

			_columnAutoRender(settings, i);
		}
	}
}

/**
 * Apply an auto detected renderer to data which doesn't yet have
 * a renderer
 */
function _columnAutoRender(settings, colIdx) {
	var data = settings.aoData;

	for (var i=0 ; i<data.length ; i++) {
		if (data[i].nTr) {
			// We have to update the display here since there is no
			// invalidation check for the data
			var display = _fnGetCellData( settings, i, colIdx, 'display' );

			data[i].displayData[colIdx] = display;
			_fnWriteCell(data[i].anCells[colIdx], display);

			// No need to update sort / filter data since it has
			// been invalidated and will be re-read with the
			// renderer now applied
		}
	}
}

/**
 * Apply a class name to a column's header cells
 */
function _columnAutoClass(container, colIdx, className) {
	container.forEach(function (row) {
		if (row[colIdx] && row[colIdx].unique) {
			_addClass(row[colIdx].cell, className);
		}
	});
}

/**
 * Take the column definitions and static columns arrays and calculate how
 * they relate to column indexes. The callback function will then apply the
 * definition found for a column to a suitable configuration object.
 *  @param {object} oSettings dataTables settings object
 *  @param {array} aoColDefs The aoColumnDefs array that is to be applied
 *  @param {array} aoCols The aoColumns array that defines columns individually
 *  @param {array} headerLayout Layout for header as it was loaded
 *  @param {function} fn Callback function - takes two parameters, the calculated
 *    column index and the definition for that column.
 *  @memberof DataTable#oApi
 */
function _fnApplyColumnDefs( oSettings, aoColDefs, aoCols, headerLayout, fn )
{
	var i, iLen, j, jLen, k, kLen, def;
	var columns = oSettings.aoColumns;

	if ( aoCols ) {
		for ( i=0, iLen=aoCols.length ; i<iLen ; i++ ) {
			if (aoCols[i] && aoCols[i].name) {
				columns[i].sName = aoCols[i].name;
			}
		}
	}

	// Column definitions with aTargets
	if ( aoColDefs )
	{
		/* Loop over the definitions array - loop in reverse so first instance has priority */
		for ( i=aoColDefs.length-1 ; i>=0 ; i-- )
		{
			def = aoColDefs[i];

			/* Each definition can target multiple columns, as it is an array */
			var aTargets = def.target !== undefined
				? def.target
				: def.targets !== undefined
					? def.targets
					: def.aTargets;

			if ( ! Array.isArray( aTargets ) )
			{
				aTargets = [ aTargets ];
			}

			for ( j=0, jLen=aTargets.length ; j<jLen ; j++ )
			{
				var target = aTargets[j];

				if ( typeof target === 'number' && target >= 0 )
				{
					/* Add columns that we don't yet know about */
					while( columns.length <= target )
					{
						_fnAddColumn( oSettings );
					}

					/* Integer, basic index */
					fn( target, def );
				}
				else if ( typeof target === 'number' && target < 0 )
				{
					/* Negative integer, right to left column counting */
					fn( columns.length+target, def );
				}
				else if ( typeof target === 'string' )
				{
					for ( k=0, kLen=columns.length ; k<kLen ; k++ ) {
						if (target === '_all') {
							// Apply to all columns
							fn( k, def );
						}
						else if (target.indexOf(':name') !== -1) {
							// Column selector
							if (columns[k].sName === target.replace(':name', '')) {
								fn( k, def );
							}
						}
						else {
							// Cell selector
							headerLayout.forEach(function (row) {
								if (row[k]) {
									var cell = $(row[k].cell);

									// Legacy support. Note that it means that we don't support
									// an element name selector only, since they are treated as
									// class names for 1.x compat.
									if (target.match(/^[a-z][\w-]*$/i)) {
										target = '.' + target;
									}

									if (cell.is( target )) {
										fn( k, def );
									}
								}
							});
						}
					}
				}
			}
		}
	}

	// Statically defined columns array
	if ( aoCols ) {
		for ( i=0, iLen=aoCols.length ; i<iLen ; i++ ) {
			fn( i, aoCols[i] );
		}
	}
}


/**
 * Get the width for a given set of columns
 *
 * @param {*} settings DataTables settings object
 * @param {*} targets Columns - comma separated string or array of numbers
 * @param {*} original Use the original width (true) or calculated (false)
 * @param {*} incVisible Include visible columns (true) or not (false)
 * @returns Combined CSS value
 */
function _fnColumnsSumWidth( settings, targets, original, incVisible ) {
	if ( ! Array.isArray( targets ) ) {
		targets = _fnColumnsFromHeader( targets );
	}

	var sum = 0;
	var unit;
	var columns = settings.aoColumns;
	
	for ( var i=0, iLen=targets.length ; i<iLen ; i++ ) {
		var column = columns[ targets[i] ];
		var definedWidth = original ?
			column.sWidthOrig :
			column.sWidth;

		if ( ! incVisible && column.bVisible === false ) {
			continue;
		}

		if ( definedWidth === null || definedWidth === undefined ) {
			return null; // can't determine a defined width - browser defined
		}
		else if ( typeof definedWidth === 'number' ) {
			unit = 'px';
			sum += definedWidth;
		}
		else {
			var matched = definedWidth.match(/([\d\.]+)([^\d]*)/);

			if ( matched ) {
				sum += matched[1] * 1;
				unit = matched.length === 3 ?
					matched[2] :
					'px';
			}
		}
	}

	return sum + unit;
}

function _fnColumnsFromHeader( cell )
{
	var attr = $(cell).closest('[data-dt-column]').attr('data-dt-column');

	if ( ! attr ) {
		return [];
	}

	return attr.split(',').map( function (val) {
		return val * 1;
	} );
}
/**
 * Add a data array to the table, creating DOM node etc. This is the parallel to
 * _fnGatherData, but for adding rows from a JavaScript source, rather than a
 * DOM source.
 *  @param {object} settings dataTables settings object
 *  @param {array} data data array to be added
 *  @param {node} [tr] TR element to add to the table - optional. If not given,
 *    DataTables will create a row automatically
 *  @param {array} [tds] Array of TD|TH elements for the row - must be given
 *    if nTr is.
 *  @returns {int} >=0 if successful (index of new aoData entry), -1 if failed
 *  @memberof DataTable#oApi
 */
function _fnAddData ( settings, dataIn, tr, tds )
{
	/* Create the object for storing information about this new row */
	var rowIdx = settings.aoData.length;
	var rowModel = $.extend( true, {}, DataTable.models.oRow, {
		src: tr ? 'dom' : 'data',
		idx: rowIdx
	} );

	rowModel._aData = dataIn;
	settings.aoData.push( rowModel );

	var columns = settings.aoColumns;

	for ( var i=0, iLen=columns.length ; i<iLen ; i++ )
	{
		// Invalidate the column types as the new data needs to be revalidated
		columns[i].sType = null;
	}

	/* Add to the display array */
	settings.aiDisplayMaster.push( rowIdx );

	var id = settings.rowIdFn( dataIn );
	if ( id !== undefined ) {
		settings.aIds[ id ] = rowModel;
	}

	/* Create the DOM information, or register it if already present */
	if ( tr || ! settings.oFeatures.bDeferRender )
	{
		_fnCreateTr( settings, rowIdx, tr, tds );
	}

	return rowIdx;
}


/**
 * Add one or more TR elements to the table. Generally we'd expect to
 * use this for reading data from a DOM sourced table, but it could be
 * used for an TR element. Note that if a TR is given, it is used (i.e.
 * it is not cloned).
 *  @param {object} settings dataTables settings object
 *  @param {array|node|jQuery} trs The TR element(s) to add to the table
 *  @returns {array} Array of indexes for the added rows
 *  @memberof DataTable#oApi
 */
function _fnAddTr( settings, trs )
{
	var row;

	// Allow an individual node to be passed in
	if ( ! (trs instanceof $) ) {
		trs = $(trs);
	}

	return trs.map( function (i, el) {
		row = _fnGetRowElements( settings, el );
		return _fnAddData( settings, row.data, el, row.cells );
	} );
}


/**
 * Get the data for a given cell from the internal cache, taking into account data mapping
 *  @param {object} settings dataTables settings object
 *  @param {int} rowIdx aoData row id
 *  @param {int} colIdx Column index
 *  @param {string} type data get type ('display', 'type' 'filter|search' 'sort|order')
 *  @returns {*} Cell data
 *  @memberof DataTable#oApi
 */
function _fnGetCellData( settings, rowIdx, colIdx, type )
{
	if (type === 'search') {
		type = 'filter';
	}
	else if (type === 'order') {
		type = 'sort';
	}

	var row = settings.aoData[rowIdx];

	if (! row) {
		return undefined;
	}

	var draw           = settings.iDraw;
	var col            = settings.aoColumns[colIdx];
	var rowData        = row._aData;
	var defaultContent = col.sDefaultContent;
	var cellData       = col.fnGetData( rowData, type, {
		settings: settings,
		row:      rowIdx,
		col:      colIdx
	} );

	// Allow for a node being returned for non-display types
	if (type !== 'display' && cellData && typeof cellData === 'object' && cellData.nodeName) {
		cellData = cellData.innerHTML;
	}

	if ( cellData === undefined ) {
		if ( settings.iDrawError != draw && defaultContent === null ) {
			_fnLog( settings, 0, "Requested unknown parameter "+
				(typeof col.mData=='function' ? '{function}' : "'"+col.mData+"'")+
				" for row "+rowIdx+", column "+colIdx, 4 );
			settings.iDrawError = draw;
		}
		return defaultContent;
	}

	// When the data source is null and a specific data type is requested (i.e.
	// not the original data), we can use default column data
	if ( (cellData === rowData || cellData === null) && defaultContent !== null && type !== undefined ) {
		cellData = defaultContent;
	}
	else if ( typeof cellData === 'function' ) {
		// If the data source is a function, then we run it and use the return,
		// executing in the scope of the data object (for instances)
		return cellData.call( rowData );
	}

	if ( cellData === null && type === 'display' ) {
		return '';
	}

	if ( type === 'filter' ) {
		var formatters = DataTable.ext.type.search;

		if ( formatters[ col.sType ] ) {
			cellData = formatters[ col.sType ]( cellData );
		}
	}

	return cellData;
}


/**
 * Set the value for a specific cell, into the internal data cache
 *  @param {object} settings dataTables settings object
 *  @param {int} rowIdx aoData row id
 *  @param {int} colIdx Column index
 *  @param {*} val Value to set
 *  @memberof DataTable#oApi
 */
function _fnSetCellData( settings, rowIdx, colIdx, val )
{
	var col     = settings.aoColumns[colIdx];
	var rowData = settings.aoData[rowIdx]._aData;

	col.fnSetData( rowData, val, {
		settings: settings,
		row:      rowIdx,
		col:      colIdx
	}  );
}

/**
 * Write a value to a cell
 * @param {*} td Cell
 * @param {*} val Value
 */
function _fnWriteCell(td, val)
{
	if (val && typeof val === 'object' && val.nodeName) {
		$(td)
			.empty()
			.append(val);
	}
	else {
		td.innerHTML = val;
	}
}


// Private variable that is used to match action syntax in the data property object
var __reArray = /\[.*?\]$/;
var __reFn = /\(\)$/;

/**
 * Split string on periods, taking into account escaped periods
 * @param  {string} str String to split
 * @return {array} Split string
 */
function _fnSplitObjNotation( str )
{
	var parts = str.match(/(\\.|[^.])+/g) || [''];

	return parts.map( function ( s ) {
		return s.replace(/\\\./g, '.');
	} );
}


/**
 * Return a function that can be used to get data from a source object, taking
 * into account the ability to use nested objects as a source
 *  @param {string|int|function} mSource The data source for the object
 *  @returns {function} Data get function
 *  @memberof DataTable#oApi
 */
var _fnGetObjectDataFn = DataTable.util.get;


/**
 * Return a function that can be used to set data from a source object, taking
 * into account the ability to use nested objects as a source
 *  @param {string|int|function} mSource The data source for the object
 *  @returns {function} Data set function
 *  @memberof DataTable#oApi
 */
var _fnSetObjectDataFn = DataTable.util.set;


/**
 * Return an array with the full table data
 *  @param {object} oSettings dataTables settings object
 *  @returns array {array} aData Master data array
 *  @memberof DataTable#oApi
 */
function _fnGetDataMaster ( settings )
{
	return _pluck( settings.aoData, '_aData' );
}


/**
 * Nuke the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnClearTable( settings )
{
	settings.aoData.length = 0;
	settings.aiDisplayMaster.length = 0;
	settings.aiDisplay.length = 0;
	settings.aIds = {};
}


/**
 * Mark cached data as invalid such that a re-read of the data will occur when
 * the cached data is next requested. Also update from the data source object.
 *
 * @param {object} settings DataTables settings object
 * @param {int}    rowIdx   Row index to invalidate
 * @param {string} [src]    Source to invalidate from: undefined, 'auto', 'dom'
 *     or 'data'
 * @param {int}    [colIdx] Column index to invalidate. If undefined the whole
 *     row will be invalidated
 * @memberof DataTable#oApi
 *
 * @todo For the modularisation of v1.11 this will need to become a callback, so
 *   the sort and filter methods can subscribe to it. That will required
 *   initialisation options for sorting, which is why it is not already baked in
 */
function _fnInvalidate( settings, rowIdx, src, colIdx )
{
	var row = settings.aoData[ rowIdx ];
	var i, iLen;

	// Remove the cached data for the row
	row._aSortData = null;
	row._aFilterData = null;
	row.displayData = null;

	// Are we reading last data from DOM or the data object?
	if ( src === 'dom' || ((! src || src === 'auto') && row.src === 'dom') ) {
		// Read the data from the DOM
		row._aData = _fnGetRowElements(
				settings, row, colIdx, colIdx === undefined ? undefined : row._aData
			)
			.data;
	}
	else {
		// Reading from data object, update the DOM
		var cells = row.anCells;
		var display = _fnGetRowDisplay(settings, rowIdx);

		if ( cells ) {
			if ( colIdx !== undefined ) {
				_fnWriteCell(cells[colIdx], display[colIdx]);
			}
			else {
				for ( i=0, iLen=cells.length ; i<iLen ; i++ ) {
					_fnWriteCell(cells[i], display[i]);
				}
			}
		}
	}

	// Column specific invalidation
	var cols = settings.aoColumns;
	if ( colIdx !== undefined ) {
		// Type - the data might have changed
		cols[ colIdx ].sType = null;

		// Max length string. Its a fairly cheep recalculation, so not worth
		// something more complicated
		cols[ colIdx ].wideStrings = null;
	}
	else {
		for ( i=0, iLen=cols.length ; i<iLen ; i++ ) {
			cols[i].sType = null;
			cols[i].wideStrings = null;
		}

		// Update DataTables special `DT_*` attributes for the row
		_fnRowAttributes( settings, row );
	}
}


/**
 * Build a data source object from an HTML row, reading the contents of the
 * cells that are in the row.
 *
 * @param {object} settings DataTables settings object
 * @param {node|object} TR element from which to read data or existing row
 *   object from which to re-read the data from the cells
 * @param {int} [colIdx] Optional column index
 * @param {array|object} [d] Data source object. If `colIdx` is given then this
 *   parameter should also be given and will be used to write the data into.
 *   Only the column in question will be written
 * @returns {object} Object with two parameters: `data` the data read, in
 *   document order, and `cells` and array of nodes (they can be useful to the
 *   caller, so rather than needing a second traversal to get them, just return
 *   them from here).
 * @memberof DataTable#oApi
 */
function _fnGetRowElements( settings, row, colIdx, d )
{
	var
		tds = [],
		td = row.firstChild,
		name, col, i=0, contents,
		columns = settings.aoColumns,
		objectRead = settings._rowReadObject;

	// Allow the data object to be passed in, or construct
	d = d !== undefined ?
		d :
		objectRead ?
			{} :
			[];

	var attr = function ( str, td  ) {
		if ( typeof str === 'string' ) {
			var idx = str.indexOf('@');

			if ( idx !== -1 ) {
				var attr = str.substring( idx+1 );
				var setter = _fnSetObjectDataFn( str );
				setter( d, td.getAttribute( attr ) );
			}
		}
	};

	// Read data from a cell and store into the data object
	var cellProcess = function ( cell ) {
		if ( colIdx === undefined || colIdx === i ) {
			col = columns[i];
			contents = (cell.innerHTML).trim();

			if ( col && col._bAttrSrc ) {
				var setter = _fnSetObjectDataFn( col.mData._ );
				setter( d, contents );

				attr( col.mData.sort, cell );
				attr( col.mData.type, cell );
				attr( col.mData.filter, cell );
			}
			else {
				// Depending on the `data` option for the columns the data can
				// be read to either an object or an array.
				if ( objectRead ) {
					if ( ! col._setter ) {
						// Cache the setter function
						col._setter = _fnSetObjectDataFn( col.mData );
					}
					col._setter( d, contents );
				}
				else {
					d[i] = contents;
				}
			}
		}

		i++;
	};

	if ( td ) {
		// `tr` element was passed in
		while ( td ) {
			name = td.nodeName.toUpperCase();

			if ( name == "TD" || name == "TH" ) {
				cellProcess( td );
				tds.push( td );
			}

			td = td.nextSibling;
		}
	}
	else {
		// Existing row object passed in
		tds = row.anCells;

		for ( var j=0, jen=tds.length ; j<jen ; j++ ) {
			cellProcess( tds[j] );
		}
	}

	// Read the ID from the DOM if present
	var rowNode = row.firstChild ? row : row.nTr;

	if ( rowNode ) {
		var id = rowNode.getAttribute( 'id' );

		if ( id ) {
			_fnSetObjectDataFn( settings.rowId )( d, id );
		}
	}

	return {
		data: d,
		cells: tds
	};
}

/**
 * Render and cache a row's display data for the columns, if required
 * @returns 
 */
function _fnGetRowDisplay (settings, rowIdx) {
	var rowModal = settings.aoData[rowIdx];
	var columns = settings.aoColumns;

	if (! rowModal.displayData) {
		// Need to render and cache
		rowModal.displayData = [];
	
		for ( var colIdx=0, len=columns.length ; colIdx<len ; colIdx++ ) {
			rowModal.displayData.push(
				_fnGetCellData( settings, rowIdx, colIdx, 'display' )
			);
		}
	}

	return rowModal.displayData;
}

/**
 * Create a new TR element (and it's TD children) for a row
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iRow Row to consider
 *  @param {node} [nTrIn] TR element to add to the table - optional. If not given,
 *    DataTables will create a row automatically
 *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
 *    if nTr is.
 *  @memberof DataTable#oApi
 */
function _fnCreateTr ( oSettings, iRow, nTrIn, anTds )
{
	var
		row = oSettings.aoData[iRow],
		rowData = row._aData,
		cells = [],
		nTr, nTd, oCol,
		i, iLen, create,
		trClass = oSettings.oClasses.tbody.row;

	if ( row.nTr === null )
	{
		nTr = nTrIn || document.createElement('tr');

		row.nTr = nTr;
		row.anCells = cells;

		_addClass(nTr, trClass);

		/* Use a private property on the node to allow reserve mapping from the node
		 * to the aoData array for fast look up
		 */
		nTr._DT_RowIndex = iRow;

		/* Special parameters can be given by the data source to be used on the row */
		_fnRowAttributes( oSettings, row );

		/* Process each column */
		for ( i=0, iLen=oSettings.aoColumns.length ; i<iLen ; i++ )
		{
			oCol = oSettings.aoColumns[i];
			create = nTrIn && anTds[i] ? false : true;

			nTd = create ? document.createElement( oCol.sCellType ) : anTds[i];

			if (! nTd) {
				_fnLog( oSettings, 0, 'Incorrect column count', 18 );
			}

			nTd._DT_CellIndex = {
				row: iRow,
				column: i
			};
			
			cells.push( nTd );
			
			var display = _fnGetRowDisplay(oSettings, iRow);

			// Need to create the HTML if new, or if a rendering function is defined
			if (
				create ||
				(
					(oCol.mRender || oCol.mData !== i) &&
					(!$.isPlainObject(oCol.mData) || oCol.mData._ !== i+'.display')
				)
			) {
				_fnWriteCell(nTd, display[i]);
			}

			// column class
			_addClass(nTd, oCol.sClass);

			// Visibility - add or remove as required
			if ( oCol.bVisible && create )
			{
				nTr.appendChild( nTd );
			}
			else if ( ! oCol.bVisible && ! create )
			{
				nTd.parentNode.removeChild( nTd );
			}

			if ( oCol.fnCreatedCell )
			{
				oCol.fnCreatedCell.call( oSettings.oInstance,
					nTd, _fnGetCellData( oSettings, iRow, i ), rowData, iRow, i
				);
			}
		}

		_fnCallbackFire( oSettings, 'aoRowCreatedCallback', 'row-created', [nTr, rowData, iRow, cells] );
	}
	else {
		_addClass(row.nTr, trClass);
	}
}


/**
 * Add attributes to a row based on the special `DT_*` parameters in a data
 * source object.
 *  @param {object} settings DataTables settings object
 *  @param {object} DataTables row object for the row to be modified
 *  @memberof DataTable#oApi
 */
function _fnRowAttributes( settings, row )
{
	var tr = row.nTr;
	var data = row._aData;

	if ( tr ) {
		var id = settings.rowIdFn( data );

		if ( id ) {
			tr.id = id;
		}

		if ( data.DT_RowClass ) {
			// Remove any classes added by DT_RowClass before
			var a = data.DT_RowClass.split(' ');
			row.__rowc = row.__rowc ?
				_unique( row.__rowc.concat( a ) ) :
				a;

			$(tr)
				.removeClass( row.__rowc.join(' ') )
				.addClass( data.DT_RowClass );
		}

		if ( data.DT_RowAttr ) {
			$(tr).attr( data.DT_RowAttr );
		}

		if ( data.DT_RowData ) {
			$(tr).data( data.DT_RowData );
		}
	}
}


/**
 * Create the HTML header for the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnBuildHead( settings, side )
{
	var classes = settings.oClasses;
	var columns = settings.aoColumns;
	var i, iLen, row;
	var target = side === 'header'
		? settings.nTHead
		: settings.nTFoot;
	var titleProp = side === 'header' ? 'sTitle' : side;

	// Footer might be defined
	if (! target) {
		return;
	}

	// If no cells yet and we have content for them, then create
	if (side === 'header' || _pluck(settings.aoColumns, titleProp).join('')) {
		row = $('tr', target);

		// Add a row if needed
		if (! row.length) {
			row = $('<tr/>').appendTo(target)
		}

		// Add the number of cells needed to make up to the number of columns
		if (row.length === 1) {
			var cellCount = 0;
			
			$('td, th', row).each(function () {
				cellCount += this.colSpan;
			});

			for ( i=cellCount, iLen=columns.length ; i<iLen ; i++ ) {
				$('<th/>')
					.html( columns[i][titleProp] || '' )
					.appendTo( row );
			}
		}
	}

	var detected = _fnDetectHeader( settings, target, true );

	if (side === 'header') {
		settings.aoHeader = detected;
		$('tr', target).addClass(classes.thead.row);
	}
	else {
		settings.aoFooter = detected;
		$('tr', target).addClass(classes.tfoot.row);
	}

	// Every cell needs to be passed through the renderer
	$(target).children('tr').children('th, td')
		.each( function () {
			_fnRenderer( settings, side )(
				settings, $(this), classes
			);
		} );
}

/**
 * Build a layout structure for a header or footer
 *
 * @param {*} settings DataTables settings
 * @param {*} source Source layout array
 * @param {*} incColumns What columns should be included
 * @returns Layout array in column index order
 */
function _fnHeaderLayout( settings, source, incColumns )
{
	var row, column, cell;
	var local = [];
	var structure = [];
	var columns = settings.aoColumns;
	var columnCount = columns.length;
	var rowspan, colspan;

	if ( ! source ) {
		return;
	}

	// Default is to work on only visible columns
	if ( ! incColumns ) {
		incColumns = _range(columnCount)
			.filter(function (idx) {
				return columns[idx].bVisible;
			});
	}

	// Make a copy of the master layout array, but with only the columns we want
	for ( row=0 ; row<source.length ; row++ ) {
		// Remove any columns we haven't selected
		local[row] = source[row].slice().filter(function (cell, i) {
			return incColumns.includes(i);
		});

		// Prep the structure array - it needs an element for each row
		structure.push( [] );
	}

	for ( row=0 ; row<local.length ; row++ ) {
		for ( column=0 ; column<local[row].length ; column++ ) {
			rowspan = 1;
			colspan = 1;

			// Check to see if there is already a cell (row/colspan) covering our target
			// insert point. If there is, then there is nothing to do.
			if ( structure[row][column] === undefined ) {
				cell = local[row][column].cell;

				// Expand for rowspan
				while (
					local[row+rowspan] !== undefined &&
					local[row][column].cell == local[row+rowspan][column].cell
				) {
					structure[row+rowspan][column] = null;
					rowspan++;
				}

				// And for colspan
				while (
					local[row][column+colspan] !== undefined &&
					local[row][column].cell == local[row][column+colspan].cell
				) {
					// Which also needs to go over rows
					for ( var k=0 ; k<rowspan ; k++ ) {
						structure[row+k][column+colspan] = null;
					}

					colspan++;
				}

				var titleSpan = $('.dt-column-title', cell);

				structure[row][column] = {
					cell: cell,
					colspan: colspan,
					rowspan: rowspan,
					title: titleSpan.length
						? titleSpan.html()
						: $(cell).html()
				};
			}
		}
	}

	return structure;
}


/**
 * Draw the header (or footer) element based on the column visibility states.
 *
 *  @param object oSettings dataTables settings object
 *  @param array aoSource Layout array from _fnDetectHeader
 *  @memberof DataTable#oApi
 */
function _fnDrawHead( settings, source )
{
	var layout = _fnHeaderLayout(settings, source);
	var tr, n;

	for ( var row=0 ; row<source.length ; row++ ) {
		tr = source[row].row;

		// All cells are going to be replaced, so empty out the row
		// Can't use $().empty() as that kills event handlers
		if (tr) {
			while( (n = tr.firstChild) ) {
				tr.removeChild( n );
			}
		}

		for ( var column=0 ; column<layout[row].length ; column++ ) {
			var point = layout[row][column];

			if (point) {
				$(point.cell)
					.appendTo(tr)
					.attr('rowspan', point.rowspan)
					.attr('colspan', point.colspan);
			}
		}
	}
}


/**
 * Insert the required TR nodes into the table for display
 *  @param {object} oSettings dataTables settings object
 *  @param ajaxComplete true after ajax call to complete rendering
 *  @memberof DataTable#oApi
 */
function _fnDraw( oSettings, ajaxComplete )
{
	// Allow for state saving and a custom start position
	_fnStart( oSettings );

	/* Provide a pre-callback function which can be used to cancel the draw is false is returned */
	var aPreDraw = _fnCallbackFire( oSettings, 'aoPreDrawCallback', 'preDraw', [oSettings] );
	if ( aPreDraw.indexOf(false) !== -1 )
	{
		_fnProcessingDisplay( oSettings, false );
		return;
	}

	var anRows = [];
	var iRowCount = 0;
	var bServerSide = _fnDataSource( oSettings ) == 'ssp';
	var aiDisplay = oSettings.aiDisplay;
	var iDisplayStart = oSettings._iDisplayStart;
	var iDisplayEnd = oSettings.fnDisplayEnd();
	var columns = oSettings.aoColumns;
	var body = $(oSettings.nTBody);

	oSettings.bDrawing = true;

	/* Server-side processing draw intercept */
	if ( oSettings.deferLoading )
	{
		oSettings.deferLoading = false;
		oSettings.iDraw++;
		_fnProcessingDisplay( oSettings, false );
	}
	else if ( !bServerSide )
	{
		oSettings.iDraw++;
	}
	else if ( !oSettings.bDestroying && !ajaxComplete)
	{
		// Show loading message for server-side processing
		if (oSettings.iDraw === 0) {
			body.empty().append(_emptyRow(oSettings));
		}

		_fnAjaxUpdate( oSettings );
		return;
	}

	if ( aiDisplay.length !== 0 )
	{
		var iStart = bServerSide ? 0 : iDisplayStart;
		var iEnd = bServerSide ? oSettings.aoData.length : iDisplayEnd;

		for ( var j=iStart ; j<iEnd ; j++ )
		{
			var iDataIndex = aiDisplay[j];
			var aoData = oSettings.aoData[ iDataIndex ];

			// Row has been deleted - can't be displayed
			if (aoData === null)
			{
				continue;
			}

			// Row node hasn't been created yet
			if ( aoData.nTr === null )
			{
				_fnCreateTr( oSettings, iDataIndex );
			}

			var nRow = aoData.nTr;

			// Add various classes as needed
			for (var i=0 ; i<columns.length ; i++) {
				var col = columns[i];
				var td = aoData.anCells[i];

				_addClass(td, _ext.type.className[col.sType]); // auto class
				_addClass(td, oSettings.oClasses.tbody.cell); // all cells
			}

			// Row callback functions - might want to manipulate the row
			// iRowCount and j are not currently documented. Are they at all
			// useful?
			_fnCallbackFire( oSettings, 'aoRowCallback', null,
				[nRow, aoData._aData, iRowCount, j, iDataIndex] );

			anRows.push( nRow );
			iRowCount++;
		}
	}
	else
	{
		anRows[ 0 ] = _emptyRow(oSettings);
	}

	/* Header and footer callbacks */
	_fnCallbackFire( oSettings, 'aoHeaderCallback', 'header', [ $(oSettings.nTHead).children('tr')[0],
		_fnGetDataMaster( oSettings ), iDisplayStart, iDisplayEnd, aiDisplay ] );

	_fnCallbackFire( oSettings, 'aoFooterCallback', 'footer', [ $(oSettings.nTFoot).children('tr')[0],
		_fnGetDataMaster( oSettings ), iDisplayStart, iDisplayEnd, aiDisplay ] );

	// replaceChildren is faster, but only became widespread in 2020,
	// so a fall back in jQuery is provided for older browsers.
	if (body[0].replaceChildren) {
		body[0].replaceChildren.apply(body[0], anRows);
	}
	else {
		body.children().detach();
		body.append( $(anRows) );
	}

	// Empty table needs a specific class
	$(oSettings.nTableWrapper).toggleClass('dt-empty-footer', $('tr', oSettings.nTFoot).length === 0);

	/* Call all required callback functions for the end of a draw */
	_fnCallbackFire( oSettings, 'aoDrawCallback', 'draw', [oSettings], true );

	/* Draw is complete, sorting and filtering must be as well */
	oSettings.bSorted = false;
	oSettings.bFiltered = false;
	oSettings.bDrawing = false;
}


/**
 * Redraw the table - taking account of the various features which are enabled
 *  @param {object} oSettings dataTables settings object
 *  @param {boolean} [holdPosition] Keep the current paging position. By default
 *    the paging is reset to the first page
 *  @memberof DataTable#oApi
 */
function _fnReDraw( settings, holdPosition, recompute )
{
	var
		features = settings.oFeatures,
		sort     = features.bSort,
		filter   = features.bFilter;

	if (recompute === undefined || recompute === true) {
		// Resolve any column types that are unknown due to addition or invalidation
		_fnColumnTypes( settings );

		if ( sort ) {
			_fnSort( settings );
		}

		if ( filter ) {
			_fnFilterComplete( settings, settings.oPreviousSearch );
		}
		else {
			// No filtering, so we want to just use the display master
			settings.aiDisplay = settings.aiDisplayMaster.slice();
		}
	}

	if ( holdPosition !== true ) {
		settings._iDisplayStart = 0;
	}

	// Let any modules know about the draw hold position state (used by
	// scrolling internally)
	settings._drawHold = holdPosition;

	_fnDraw( settings );

	settings.api.one('draw', function () {
		settings._drawHold = false;
	});
}


/*
 * Table is empty - create a row with an empty message in it
 */
function _emptyRow ( settings ) {
	var oLang = settings.oLanguage;
	var zero = oLang.sZeroRecords;
	var dataSrc = _fnDataSource( settings );

	// Make use of the fact that settings.json is only set once the initial data has
	// been loaded. Show loading when that isn't the case
	if ((dataSrc === 'ssp' || dataSrc === 'ajax') && ! settings.json) {
		zero = oLang.sLoadingRecords;
	}
	else if ( oLang.sEmptyTable && settings.fnRecordsTotal() === 0 )
	{
		zero = oLang.sEmptyTable;
	}

	return $( '<tr/>' )
		.append( $('<td />', {
			'colSpan': _fnVisibleColumns( settings ),
			'class':   settings.oClasses.empty.row
		} ).html( zero ) )[0];
}


/**
 * Expand the layout items into an object for the rendering function
 */
function _layoutItems (row, align, items) {
	if ( Array.isArray(items)) {
		for (var i=0 ; i<items.length ; i++) {
			_layoutItems(row, align, items[i]);
		}

		return;
	}

	var rowCell = row[align];

	// If it is an object, then there can be multiple features contained in it
	if ( $.isPlainObject( items ) ) {
		// A feature plugin cannot be named "features" due to this check
		if (items.features) {
			if (items.rowId) {
				row.id = items.rowId;
			}
			if (items.rowClass) {
				row.className = items.rowClass;
			}

			rowCell.id = items.id;
			rowCell.className = items.className;

			_layoutItems(row, align, items.features);
		}
		else {
			Object.keys(items).map(function (key) {
				rowCell.contents.push( {
					feature: key,
					opts: items[key]
				});
			});
		}
	}
	else {
		rowCell.contents.push(items);
	}
}

/**
 * Find, or create a layout row
 */
function _layoutGetRow(rows, rowNum, align) {
	var row;

	// Find existing rows
	for (var i=0; i<rows.length; i++) {
		row = rows[i];

		if (row.rowNum === rowNum) {
			// full is on its own, but start and end share a row
			if (
				(align === 'full' && row.full) ||
				((align === 'start' || align === 'end') && (row.start || row.end))
			) {
				if (! row[align]) {
					row[align] = {
						contents: []
					};
				}

				return row;
			}
		}
	}

	// If we get this far, then there was no match, create a new row
	row = {
		rowNum: rowNum	
	};

	row[align] = {
		contents: []
	};

	rows.push(row);

	return row;
}

/**
 * Convert a `layout` object given by a user to the object structure needed
 * for the renderer. This is done twice, once for above and once for below
 * the table. Ordering must also be considered.
 *
 * @param {*} settings DataTables settings object
 * @param {*} layout Layout object to convert
 * @param {string} side `top` or `bottom`
 * @returns Converted array structure - one item for each row.
 */
function _layoutArray ( settings, layout, side ) {
	var rows = [];
	
	// Split out into an array
	$.each( layout, function ( pos, items ) {
		if (items === null) {
			return;
		}

		var parts = pos.match(/^([a-z]+)([0-9]*)([A-Za-z]*)$/);
		var rowNum = parts[2]
			? parts[2] * 1
			: 0;
		var align = parts[3]
			? parts[3].toLowerCase()
			: 'full';

		// Filter out the side we aren't interested in
		if (parts[1] !== side) {
			return;
		}

		// Get or create the row we should attach to
		var row = _layoutGetRow(rows, rowNum, align);

		_layoutItems(row, align, items);
	});

	// Order by item identifier
	rows.sort( function ( a, b ) {
		var order1 = a.rowNum;
		var order2 = b.rowNum;

		// If both in the same row, then the row with `full` comes first
		if (order1 === order2) {
			var ret = a.full && ! b.full ? -1 : 1;

			return side === 'bottom'
				? ret * -1
				: ret;
		}

		return order2 - order1;
	} );

	// Invert for below the table
	if ( side === 'bottom' ) {
		rows.reverse();
	}

	for (var row = 0; row<rows.length; row++) {
		delete rows[row].rowNum;

		_layoutResolve(settings, rows[row]);
	}

	return rows;
}


/**
 * Convert the contents of a row's layout object to nodes that can be inserted
 * into the document by a renderer. Execute functions, look up plug-ins, etc.
 *
 * @param {*} settings DataTables settings object
 * @param {*} row Layout object for this row
 */
function _layoutResolve( settings, row ) {
	var getFeature = function (feature, opts) {
		if ( ! _ext.features[ feature ] ) {
			_fnLog( settings, 0, 'Unknown feature: '+ feature );
		}

		return _ext.features[ feature ].apply( this, [settings, opts] );
	};

	var resolve = function ( item ) {
		if (! row[ item ]) {
			return;
		}

		var line = row[ item ].contents;

		for ( var i=0, iLen=line.length ; i<iLen ; i++ ) {
			if ( ! line[i] ) {
				continue;
			}
			else if ( typeof line[i] === 'string' ) {
				line[i] = getFeature( line[i], null );
			}
			else if ( $.isPlainObject(line[i]) ) {
				// If it's an object, it just has feature and opts properties from
				// the transform in _layoutArray
				line[i] = getFeature(line[i].feature, line[i].opts);
			}
			else if ( typeof line[i].node === 'function' ) {
				line[i] = line[i].node( settings );
			}
			else if ( typeof line[i] === 'function' ) {
				var inst = line[i]( settings );

				line[i] = typeof inst.node === 'function' ?
					inst.node() :
					inst;
			}
		}
	};

	resolve('start');
	resolve('end');
	resolve('full');
}


/**
 * Add the options to the page HTML for the table
 *  @param {object} settings DataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAddOptionsHtml ( settings )
{
	var classes = settings.oClasses;
	var table = $(settings.nTable);

	// Wrapper div around everything DataTables controls
	var insert = $('<div/>')
		.attr({
			id:      settings.sTableId+'_wrapper',
			'class': classes.container
		})
		.insertBefore(table);

	settings.nTableWrapper = insert[0];

	if (settings.sDom) {
		// Legacy
		_fnLayoutDom(settings, settings.sDom, insert);
	}
	else {
		var top = _layoutArray( settings, settings.layout, 'top' );
		var bottom = _layoutArray( settings, settings.layout, 'bottom' );
		var renderer = _fnRenderer( settings, 'layout' );
	
		// Everything above - the renderer will actually insert the contents into the document
		top.forEach(function (item) {
			renderer( settings, insert, item );
		});

		// The table - always the center of attention
		renderer( settings, insert, {
			full: {
				table: true,
				contents: [ _fnFeatureHtmlTable(settings) ]
			}
		} );

		// Everything below
		bottom.forEach(function (item) {
			renderer( settings, insert, item );
		});
	}

	// Processing floats on top, so it isn't an inserted feature
	_processingHtml( settings );
}

/**
 * Draw the table with the legacy DOM property
 * @param {*} settings DT settings object
 * @param {*} dom DOM string
 * @param {*} insert Insert point
 */
function _fnLayoutDom( settings, dom, insert )
{
	var parts = dom.match(/(".*?")|('.*?')|./g);
	var featureNode, option, newNode, next, attr;

	for ( var i=0 ; i<parts.length ; i++ ) {
		featureNode = null;
		option = parts[i];

		if ( option == '<' ) {
			// New container div
			newNode = $('<div/>');

			// Check to see if we should append an id and/or a class name to the container
			next = parts[i+1];

			if ( next[0] == "'" || next[0] == '"' ) {
				attr = next.replace(/['"]/g, '');

				var id = '', className;

				/* The attribute can be in the format of "#id.class", "#id" or "class" This logic
				 * breaks the string into parts and applies them as needed
				 */
				if ( attr.indexOf('.') != -1 ) {
					var split = attr.split('.');

					id = split[0];
					className = split[1];
				}
				else if ( attr[0] == "#" ) {
					id = attr;
				}
				else {
					className = attr;
				}

				newNode
					.attr('id', id.substring(1))
					.addClass(className);

				i++; // Move along the position array
			}

			insert.append( newNode );
			insert = newNode;
		}
		else if ( option == '>' ) {
			// End container div
			insert = insert.parent();
		}
		else if ( option == 't' ) {
			// Table
			featureNode = _fnFeatureHtmlTable( settings );
		}
		else
		{
			DataTable.ext.feature.forEach(function(feature) {
				if ( option == feature.cFeature ) {
					featureNode = feature.fnInit( settings );
				}
			});
		}

		// Add to the display
		if ( featureNode ) {
			insert.append( featureNode );
		}
	}
}


/**
 * Use the DOM source to create up an array of header cells. The idea here is to
 * create a layout grid (array) of rows x columns, which contains a reference
 * to the cell at that point in the grid (regardless of col/rowspan), such that
 * any column / row could be removed and the new grid constructed
 *  @param {node} thead The header/footer element for the table
 *  @returns {array} Calculated layout array
 *  @memberof DataTable#oApi
 */
function _fnDetectHeader ( settings, thead, write )
{
	var columns = settings.aoColumns;
	var rows = $(thead).children('tr');
	var row, cell;
	var i, k, l, iLen, shifted, column, colspan, rowspan;
	var titleRow = settings.titleRow;
	var isHeader = thead && thead.nodeName.toLowerCase() === 'thead';
	var layout = [];
	var unique;
	var shift = function ( a, i, j ) {
		var k = a[i];
		while ( k[j] ) {
			j++;
		}
		return j;
	};

	// We know how many rows there are in the layout - so prep it
	for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
		layout.push( [] );
	}

	for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
		row = rows[i];
		column = 0;

		// For every cell in the row..
		cell = row.firstChild;
		while ( cell ) {
			if (
				cell.nodeName.toUpperCase() == 'TD' ||
				cell.nodeName.toUpperCase() == 'TH'
			) {
				var cols = [];
				var jqCell = $(cell);

				// Get the col and rowspan attributes from the DOM and sanitise them
				colspan = cell.getAttribute('colspan') * 1;
				rowspan = cell.getAttribute('rowspan') * 1;
				colspan = (!colspan || colspan===0 || colspan===1) ? 1 : colspan;
				rowspan = (!rowspan || rowspan===0 || rowspan===1) ? 1 : rowspan;

				// There might be colspan cells already in this row, so shift our target
				// accordingly
				shifted = shift( layout, i, column );

				// Cache calculation for unique columns
				unique = colspan === 1 ?
					true :
					false;
				
				// Perform header setup
				if ( write ) {
					if (unique) {
						// Allow column options to be set from HTML attributes
						_fnColumnOptions( settings, shifted, _fnEscapeObject(jqCell.data()) );
						
						// Get the width for the column. This can be defined from the
						// width attribute, style attribute or `columns.width` option
						var columnDef = columns[shifted];
						var width = cell.getAttribute('width') || null;
						var t = cell.style.width.match(/width:\s*(\d+[pxem%]+)/);
						if ( t ) {
							width = t[1];
						}

						columnDef.sWidthOrig = columnDef.sWidth || width;

						if (isHeader) {
							// Column title handling - can be user set, or read from the DOM
							// This happens before the render, so the original is still in place
							if ( columnDef.sTitle !== null && ! columnDef.autoTitle ) {
								if (
									(titleRow === true && i === 0) || // top row
									(titleRow === false && i === rows.length -1) || // bottom row
									(titleRow === i) || // specific row
									(titleRow === null)
								) {
									cell.innerHTML = columnDef.sTitle;
								}
							}

							if (! columnDef.sTitle && unique) {
								columnDef.sTitle = _stripHtml(cell.innerHTML);
								columnDef.autoTitle = true;
							}
						}
						else {
							// Footer specific operations
							if (columnDef.footer) {
								cell.innerHTML = columnDef.footer;
							}
						}

						// Fall back to the aria-label attribute on the table header if no ariaTitle is
						// provided.
						if (! columnDef.ariaTitle) {
							columnDef.ariaTitle = jqCell.attr("aria-label") || columnDef.sTitle;
						}

						// Column specific class names
						if ( columnDef.className ) {
							jqCell.addClass( columnDef.className );
						}
					}

					// Wrap the column title so we can write to it in future
					if ( $('.dt-column-title', cell).length === 0) {
						$(document.createElement(settings.columnTitleTag))
							.addClass('dt-column-title')
							.append(cell.childNodes)
							.appendTo(cell);
					}

					if (
						settings.orderIndicators &&
						isHeader &&
						jqCell.filter(':not([data-dt-order=disable])').length !== 0 &&
						jqCell.parent(':not([data-dt-order=disable])').length !== 0 &&
						$('.dt-column-order', cell).length === 0
					) {
						$(document.createElement(settings.columnTitleTag))
							.addClass('dt-column-order')
							.appendTo(cell);
					}

					// We need to wrap the elements in the header in another element to use flexbox
					// layout for those elements
					var headerFooter = isHeader ? 'header' : 'footer';

					if ( $('div.dt-column-' + headerFooter, cell).length === 0) {
						$('<div>')
							.addClass('dt-column-' + headerFooter)
							.append(cell.childNodes)
							.appendTo(cell);
					}
				}

				// If there is col / rowspan, copy the information into the layout grid
				for ( l=0 ; l<colspan ; l++ ) {
					for ( k=0 ; k<rowspan ; k++ ) {
						layout[i+k][shifted+l] = {
							cell: cell,
							unique: unique
						};

						layout[i+k].row = row;
					}

					cols.push( shifted+l );
				}

				// Assign an attribute so spanning cells can still be identified
				// as belonging to a column
				cell.setAttribute('data-dt-column', _unique(cols).join(','));
			}

			cell = cell.nextSibling;
		}
	}

	return layout;
}

/**
 * Set the start position for draw
 *  @param {object} oSettings dataTables settings object
 */
function _fnStart( oSettings )
{
	var bServerSide = _fnDataSource( oSettings ) == 'ssp';
	var iInitDisplayStart = oSettings.iInitDisplayStart;

	// Check and see if we have an initial draw position from state saving
	if ( iInitDisplayStart !== undefined && iInitDisplayStart !== -1 )
	{
		oSettings._iDisplayStart = bServerSide ?
			iInitDisplayStart :
			iInitDisplayStart >= oSettings.fnRecordsDisplay() ?
				0 :
				iInitDisplayStart;

		oSettings.iInitDisplayStart = -1;
	}
}

/**
 * Create an Ajax call based on the table's settings, taking into account that
 * parameters can have multiple forms, and backwards compatibility.
 *
 * @param {object} oSettings dataTables settings object
 * @param {array} data Data to send to the server, required by
 *     DataTables - may be augmented by developer callbacks
 * @param {function} fn Callback function to run when data is obtained
 */
function _fnBuildAjax(oSettings, data, fn) {
	var ajaxData;
	var ajax = oSettings.ajax;
	var instance = oSettings.oInstance;
	var callback = function (json) {
		var status = oSettings.jqXHR ? oSettings.jqXHR.status : null;

		if (json === null || (typeof status === 'number' && status == 204)) {
			json = {};
			_fnAjaxDataSrc(oSettings, json, []);
		}

		var error = json.error || json.sError;
		if (error) {
			_fnLog(oSettings, 0, error);
		}

		// Microsoft often wrap JSON as a string in another JSON object
		// Let's handle that automatically
		if (json.d && typeof json.d === 'string') {
			try {
				json = JSON.parse(json.d);
			} catch (e) {
				// noop
			}
		}

		oSettings.json = json;

		_fnCallbackFire(oSettings, null, 'xhr', [oSettings, json, oSettings.jqXHR], true);
		fn(json);
	};

	if ($.isPlainObject(ajax) && ajax.data) {
		ajaxData = ajax.data;

		var newData =
			typeof ajaxData === 'function'
				? ajaxData(data, oSettings) // fn can manipulate data or return
				: ajaxData; // an object or array to merge

		// If the function returned something, use that alone
		data = typeof ajaxData === 'function' && newData ? newData : $.extend(true, data, newData);

		// Remove the data property as we've resolved it already and don't want
		// jQuery to do it again (it is restored at the end of the function)
		delete ajax.data;
	}

	var baseAjax = {
		url: typeof ajax === 'string' ? ajax : '',
		data: data,
		success: callback,
		dataType: 'json',
		cache: false,
		type: oSettings.sServerMethod,
		error: function (xhr, error) {
			var ret = _fnCallbackFire(
				oSettings,
				null,
				'xhr',
				[oSettings, null, oSettings.jqXHR],
				true
			);

			if (ret.indexOf(true) === -1) {
				if (error == 'parsererror') {
					_fnLog(oSettings, 0, 'Invalid JSON response', 1);
				}
				else if (xhr.readyState === 4) {
					_fnLog(oSettings, 0, 'Ajax error', 7);
				}
			}

			_fnProcessingDisplay(oSettings, false);
		}
	};

	// If `ajax` option is an object, extend and override our default base
	if ($.isPlainObject(ajax)) {
		$.extend(baseAjax, ajax);
	}

	// Store the data submitted for the API
	oSettings.oAjaxData = data;

	// Allow plug-ins and external processes to modify the data
	_fnCallbackFire(oSettings, null, 'preXhr', [oSettings, data, baseAjax], true);

	// Custom Ajax option to submit the parameters as a JSON string
	if (baseAjax.submitAs === 'json' && typeof data === 'object') {
		baseAjax.data = JSON.stringify(data);

		if (!baseAjax.contentType) {
			baseAjax.contentType = 'application/json; charset=utf-8';
		}
	}

	if (typeof ajax === 'function') {
		// Is a function - let the caller define what needs to be done
		oSettings.jqXHR = ajax.call(instance, data, callback, oSettings);
	}
	else if (ajax.url === '') {
		// No url, so don't load any data. Just apply an empty data array
		// to the object for the callback.
		var empty = {};

		_fnAjaxDataSrc(oSettings, empty, []);
		callback(empty);
	}
	else {
		// Object to extend the base settings
		oSettings.jqXHR = $.ajax(baseAjax);
	}

	// Restore for next time around
	if (ajaxData) {
		ajax.data = ajaxData;
	}
}

/**
 * Update the table using an Ajax call
 *  @param {object} settings dataTables settings object
 *  @returns {boolean} Block the table drawing or not
 *  @memberof DataTable#oApi
 */
function _fnAjaxUpdate(settings) {
	settings.iDraw++;
	_fnProcessingDisplay(settings, true);

	_fnBuildAjax(settings, _fnAjaxParameters(settings), function (json) {
		_fnAjaxUpdateDraw(settings, json);
	});
}

/**
 * Build up the parameters in an object needed for a server-side processing
 * request.
 *  @param {object} oSettings dataTables settings object
 *  @returns {bool} block the table drawing or not
 *  @memberof DataTable#oApi
 */
function _fnAjaxParameters(settings) {
	var columns = settings.aoColumns,
		features = settings.oFeatures,
		preSearch = settings.oPreviousSearch,
		preColSearch = settings.aoPreSearchCols,
		colData = function (idx, prop) {
			return typeof columns[idx][prop] === 'function' ? 'function' : columns[idx][prop];
		};

	return {
		draw: settings.iDraw,
		columns: columns.map(function (column, i) {
			return {
				data: colData(i, 'mData'),
				name: column.sName,
				searchable: column.bSearchable,
				orderable: column.bSortable,
				search: {
					value: preColSearch[i].search,
					regex: preColSearch[i].regex,
					fixed: Object.keys(column.searchFixed)
						.map(function (name) {
							return {
								name: name,
								term: typeof column.searchFixed[name] !== 'function'
									? column.searchFixed[name].toString()
									: 'function'
								};
						})
				}
			};
		}),
		order: _fnSortFlatten(settings).map(function (val) {
			return {
				column: val.col,
				dir: val.dir,
				name: colData(val.col, 'sName')
			};
		}),
		start: settings._iDisplayStart,
		length: features.bPaginate ? settings._iDisplayLength : -1,
		search: {
			value: preSearch.search,
			regex: preSearch.regex,
			fixed: Object.keys(settings.searchFixed)
				.map(function (name) {
					return {
						name: name,
						term: typeof settings.searchFixed[name] !== 'function'
							? settings.searchFixed[name].toString()
							: 'function'
					};
				})
		}
	};
}

/**
 * Data the data from the server (nuking the old) and redraw the table
 *  @param {object} oSettings dataTables settings object
 *  @param {object} json json data return from the server.
 *  @param {string} json.sEcho Tracking flag for DataTables to match requests
 *  @param {int} json.iTotalRecords Number of records in the data set, not accounting for filtering
 *  @param {int} json.iTotalDisplayRecords Number of records in the data set, accounting for filtering
 *  @param {array} json.aaData The data to display on this page
 *  @param {string} [json.sColumns] Column ordering (sName, comma separated)
 *  @memberof DataTable#oApi
 */
function _fnAjaxUpdateDraw(settings, json) {
	var data = _fnAjaxDataSrc(settings, json);
	var draw = _fnAjaxDataSrcParam(settings, 'draw', json);
	var recordsTotal = _fnAjaxDataSrcParam(settings, 'recordsTotal', json);
	var recordsFiltered = _fnAjaxDataSrcParam(settings, 'recordsFiltered', json);

	if (draw !== undefined) {
		// Protect against out of sequence returns
		if (draw * 1 < settings.iDraw) {
			return;
		}
		settings.iDraw = draw * 1;
	}

	// No data in returned object, so rather than an array, we show an empty table
	if (!data) {
		data = [];
	}

	_fnClearTable(settings);
	settings._iRecordsTotal = parseInt(recordsTotal, 10);
	settings._iRecordsDisplay = parseInt(recordsFiltered, 10);

	for (var i = 0, iLen = data.length; i < iLen; i++) {
		_fnAddData(settings, data[i]);
	}
	settings.aiDisplay = settings.aiDisplayMaster.slice();

	_fnColumnTypes(settings);
	_fnDraw(settings, true);
	_fnInitComplete(settings);
	_fnProcessingDisplay(settings, false);
}

/**
 * Get the data from the JSON data source to use for drawing a table. Using
 * `_fnGetObjectDataFn` allows the data to be sourced from a property of the
 * source object, or from a processing function.
 *  @param {object} settings dataTables settings object
 *  @param  {object} json Data source object / array from the server
 *  @return {array} Array of data to use
 */
function _fnAjaxDataSrc(settings, json, write) {
	var dataProp = 'data';

	if ($.isPlainObject(settings.ajax) && settings.ajax.dataSrc !== undefined) {
		// Could in inside a `dataSrc` object, or not!
		var dataSrc = settings.ajax.dataSrc;

		// string, function and object are valid types
		if (typeof dataSrc === 'string' || typeof dataSrc === 'function') {
			dataProp = dataSrc;
		}
		else if (dataSrc.data !== undefined) {
			dataProp = dataSrc.data;
		}
	}

	if (!write) {
		if (dataProp === 'data') {
			// If the default, then we still want to support the old style, and safely ignore
			// it if possible
			return json.aaData || json[dataProp];
		}

		return dataProp !== '' ? _fnGetObjectDataFn(dataProp)(json) : json;
	}

	// set
	_fnSetObjectDataFn(dataProp)(json, write);
}

/**
 * Very similar to _fnAjaxDataSrc, but for the other SSP properties
 * @param {*} settings DataTables settings object
 * @param {*} param Target parameter
 * @param {*} json JSON data
 * @returns Resolved value
 */
function _fnAjaxDataSrcParam(settings, param, json) {
	var dataSrc = $.isPlainObject(settings.ajax) ? settings.ajax.dataSrc : null;

	if (dataSrc && dataSrc[param]) {
		// Get from custom location
		return _fnGetObjectDataFn(dataSrc[param])(json);
	}

	// else - Default behaviour
	var old = '';

	// Legacy support
	if (param === 'draw') {
		old = 'sEcho';
	}
	else if (param === 'recordsTotal') {
		old = 'iTotalRecords';
	}
	else if (param === 'recordsFiltered') {
		old = 'iTotalDisplayRecords';
	}

	return json[old] !== undefined ? json[old] : json[param];
}


/**
 * Filter the table using both the global filter and column based filtering
 *  @param {object} settings dataTables settings object
 *  @param {object} input search information
 *  @memberof DataTable#oApi
 */
function _fnFilterComplete ( settings, input )
{
	var columnsSearch = settings.aoPreSearchCols;

	// In server-side processing all filtering is done by the server, so no point hanging around here
	if ( _fnDataSource( settings ) != 'ssp' )
	{
		// Check if any of the rows were invalidated
		_fnFilterData( settings );

		// Start from the full data set
		settings.aiDisplay = settings.aiDisplayMaster.slice();

		// Global filter first
		_fnFilter( settings.aiDisplay, settings, input.search, input );

		$.each(settings.searchFixed, function (name, term) {
			_fnFilter(settings.aiDisplay, settings, term, {});
		});

		// Then individual column filters
		for ( var i=0 ; i<columnsSearch.length ; i++ )
		{
			var col = columnsSearch[i];

			_fnFilter(
				settings.aiDisplay,
				settings,
				col.search,
				col,
				i
			);

			$.each(settings.aoColumns[i].searchFixed, function (name, term) {
				_fnFilter(settings.aiDisplay, settings, term, {}, i);
			});
		}

		// And finally global filtering
		_fnFilterCustom( settings );
	}

	// Tell the draw function we have been filtering
	settings.bFiltered = true;

	_fnCallbackFire( settings, null, 'search', [settings] );
}


/**
 * Apply custom filtering functions
 * 
 * This is legacy now that we have named functions, but it is widely used
 * from 1.x, so it is not yet deprecated.
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnFilterCustom( settings )
{
	var filters = DataTable.ext.search;
	var displayRows = settings.aiDisplay;
	var row, rowIdx;

	for ( var i=0, iLen=filters.length ; i<iLen ; i++ ) {
		var rows = [];

		// Loop over each row and see if it should be included
		for ( var j=0, jen=displayRows.length ; j<jen ; j++ ) {
			rowIdx = displayRows[ j ];
			row = settings.aoData[ rowIdx ];

			if ( filters[i]( settings, row._aFilterData, rowIdx, row._aData, j ) ) {
				rows.push( rowIdx );
			}
		}

		// So the array reference doesn't break set the results into the
		// existing array
		displayRows.length = 0;
		_fnArrayApply(displayRows, rows);
	}
}


/**
 * Filter the data table based on user input and draw the table
 */
function _fnFilter( searchRows, settings, input, options, column )
{
	if ( input === '' ) {
		return;
	}

	var i = 0;
	var matched = [];

	// Search term can be a function, regex or string - if a string we apply our
	// smart filtering regex (assuming the options require that)
	var searchFunc = typeof input === 'function' ? input : null;
	var rpSearch = input instanceof RegExp
		? input
		: searchFunc
			? null
			: _fnFilterCreateSearch( input, options );

	// Then for each row, does the test pass. If not, lop the row from the array
	for (i=0 ; i<searchRows.length ; i++) {
		var row = settings.aoData[ searchRows[i] ];
		var data = column === undefined
			? row._sFilterRow
			: row._aFilterData[ column ];

		if ( (searchFunc && searchFunc(data, row._aData, searchRows[i], column)) || (rpSearch && rpSearch.test(data)) ) {
			matched.push(searchRows[i]);
		}
	}

	// Mutate the searchRows array
	searchRows.length = matched.length;

	for (i=0 ; i<matched.length ; i++) {
		searchRows[i] = matched[i];
	}
}


/**
 * Build a regular expression object suitable for searching a table
 *  @param {string} sSearch string to search for
 *  @param {bool} bRegex treat as a regular expression or not
 *  @param {bool} bSmart perform smart filtering or not
 *  @param {bool} bCaseInsensitive Do case-insensitive matching or not
 *  @returns {RegExp} constructed object
 *  @memberof DataTable#oApi
 */
function _fnFilterCreateSearch( search, inOpts )
{
	var not = [];
	var options = $.extend({}, {
		boundary: false,
		caseInsensitive: true,
		exact: false,
		regex: false,
		smart: true
	}, inOpts);

	if (typeof search !== 'string') {
		search = search.toString();
	}

	// Remove diacritics if normalize is set up to do so
	search = _normalize(search);

	if (options.exact) {
		return new RegExp(
			'^'+_fnEscapeRegex(search)+'$',
			options.caseInsensitive ? 'i' : ''
		);
	}

	search = options.regex ?
		search :
		_fnEscapeRegex( search );
	
	if ( options.smart ) {
		/* For smart filtering we want to allow the search to work regardless of
		 * word order. We also want double quoted text to be preserved, so word
		 * order is important - a la google. And a negative look around for
		 * finding rows which don't contain a given string.
		 * 
		 * So this is the sort of thing we want to generate:
		 * 
		 * ^(?=.*?\bone\b)(?=.*?\btwo three\b)(?=.*?\bfour\b).*$
		 */
		var parts = search.match( /!?["\u201C][^"\u201D]+["\u201D]|[^ ]+/g ) || [''];
		var a = parts.map( function ( word ) {
			var negative = false;
			var m;

			// Determine if it is a "does not include"
			if ( word.charAt(0) === '!' ) {
				negative = true;
				word = word.substring(1);
			}

			// Strip the quotes from around matched phrases
			if ( word.charAt(0) === '"' ) {
				m = word.match( /^"(.*)"$/ );
				word = m ? m[1] : word;
			}
			else if ( word.charAt(0) === '\u201C' ) {
				// Smart quote match (iPhone users)
				m = word.match( /^\u201C(.*)\u201D$/ );
				word = m ? m[1] : word;
			}

			// For our "not" case, we need to modify the string that is
			// allowed to match at the end of the expression.
			if (negative) {
				if (word.length > 1) {
					not.push('(?!'+word+')');
				}

				word = '';
			}

			return word.replace(/"/g, '');
		} );

		var match = not.length
			? not.join('')
			: '';

		var boundary = options.boundary
			? '\\b'
			: '';

		search = '^(?=.*?'+boundary+a.join( ')(?=.*?'+boundary )+')('+match+'.)*$';
	}

	return new RegExp( search, options.caseInsensitive ? 'i' : '' );
}


/**
 * Escape a string such that it can be used in a regular expression
 *  @param {string} sVal string to escape
 *  @returns {string} escaped string
 *  @memberof DataTable#oApi
 */
var _fnEscapeRegex = DataTable.util.escapeRegex;

var __filter_div = $('<div>')[0];
var __filter_div_textContent = __filter_div.textContent !== undefined;

// Update the filtering data for each row if needed (by invalidation or first run)
function _fnFilterData ( settings )
{
	var columns = settings.aoColumns;
	var data = settings.aoData;
	var column;
	var j, jen, filterData, cellData, row;
	var wasInvalidated = false;

	for ( var rowIdx=0 ; rowIdx<data.length ; rowIdx++ ) {
		if (! data[rowIdx]) {
			continue;
		}

		row = data[rowIdx];

		if ( ! row._aFilterData ) {
			filterData = [];

			for ( j=0, jen=columns.length ; j<jen ; j++ ) {
				column = columns[j];

				if ( column.bSearchable ) {
					cellData = _fnGetCellData( settings, rowIdx, j, 'filter' );

					// Search in DataTables is string based
					if ( cellData === null ) {
						cellData = '';
					}

					if ( typeof cellData !== 'string' && cellData.toString ) {
						cellData = cellData.toString();
					}
				}
				else {
					cellData = '';
				}

				// If it looks like there is an HTML entity in the string,
				// attempt to decode it so sorting works as expected. Note that
				// we could use a single line of jQuery to do this, but the DOM
				// method used here is much faster https://jsperf.com/html-decode
				if ( cellData.indexOf && cellData.indexOf('&') !== -1 ) {
					__filter_div.innerHTML = cellData;
					cellData = __filter_div_textContent ?
						__filter_div.textContent :
						__filter_div.innerText;
				}

				if ( cellData.replace ) {
					cellData = cellData.replace(/[\r\n\u2028]/g, '');
				}

				filterData.push( cellData );
			}

			row._aFilterData = filterData;
			row._sFilterRow = filterData.join('  ');
			wasInvalidated = true;
		}
	}

	return wasInvalidated;
}


/**
 * Draw the table for the first time, adding all required features
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnInitialise ( settings )
{
	var i;
	var init = settings.oInit;
	var deferLoading = settings.deferLoading;
	var dataSrc = _fnDataSource( settings );

	// Ensure that the table data is fully initialised
	if ( ! settings.bInitialised ) {
		setTimeout( function(){ _fnInitialise( settings ); }, 200 );
		return;
	}

	// Build the header / footer for the table
	_fnBuildHead( settings, 'header' );
	_fnBuildHead( settings, 'footer' );

	// Load the table's state (if needed) and then render around it and draw
	_fnLoadState( settings, init, function () {
		// Then draw the header / footer
		_fnDrawHead( settings, settings.aoHeader );
		_fnDrawHead( settings, settings.aoFooter );

		// Cache the paging start point, as the first redraw will reset it
		var iAjaxStart = settings.iInitDisplayStart

		// Local data load
		// Check if there is data passing into the constructor
		if ( init.aaData ) {
			for ( i=0 ; i<init.aaData.length ; i++ ) {
				_fnAddData( settings, init.aaData[ i ] );
			}
		}
		else if ( deferLoading || dataSrc == 'dom' ) {
			// Grab the data from the page
			_fnAddTr( settings, $(settings.nTBody).children('tr') );
		}

		// Filter not yet applied - copy the display master
		settings.aiDisplay = settings.aiDisplayMaster.slice();

		// Enable features
		_fnAddOptionsHtml( settings );
		_fnSortInit( settings );

		_colGroup( settings );

		/* Okay to show that something is going on now */
		_fnProcessingDisplay( settings, true );

		_fnCallbackFire( settings, null, 'preInit', [settings], true );

		// If there is default sorting required - let's do it. The sort function
		// will do the drawing for us. Otherwise we draw the table regardless of the
		// Ajax source - this allows the table to look initialised for Ajax sourcing
		// data (show 'loading' message possibly)
		_fnReDraw( settings );

		// Server-side processing init complete is done by _fnAjaxUpdateDraw
		if ( dataSrc != 'ssp' || deferLoading ) {
			// if there is an ajax source load the data
			if ( dataSrc == 'ajax' ) {
				_fnBuildAjax( settings, {}, function(json) {
					var aData = _fnAjaxDataSrc( settings, json );

					// Got the data - add it to the table
					for ( i=0 ; i<aData.length ; i++ ) {
						_fnAddData( settings, aData[i] );
					}

					// Reset the init display for cookie saving. We've already done
					// a filter, and therefore cleared it before. So we need to make
					// it appear 'fresh'
					settings.iInitDisplayStart = iAjaxStart;

					_fnReDraw( settings );
					_fnProcessingDisplay( settings, false );
					_fnInitComplete( settings );
				}, settings );
			}
			else {
				_fnInitComplete( settings );
				_fnProcessingDisplay( settings, false );
			}
		}
	} );
}


/**
 * Draw the table for the first time, adding all required features
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnInitComplete ( settings )
{
	if (settings._bInitComplete) {
		return;
	}

	var args = [settings, settings.json];

	settings._bInitComplete = true;

	// Table is fully set up and we have data, so calculate the
	// column widths
	_fnAdjustColumnSizing( settings );

	_fnCallbackFire( settings, null, 'plugin-init', args, true );
	_fnCallbackFire( settings, 'aoInitComplete', 'init', args, true );
}

function _fnLengthChange ( settings, val )
{
	var len = parseInt( val, 10 );
	settings._iDisplayLength = len;

	_fnLengthOverflow( settings );

	// Fire length change event
	_fnCallbackFire( settings, null, 'length', [settings, len] );
}

/**
 * Alter the display settings to change the page
 *  @param {object} settings DataTables settings object
 *  @param {string|int} action Paging action to take: "first", "previous",
 *    "next" or "last" or page number to jump to (integer)
 *  @param [bool] redraw Automatically draw the update or not
 *  @returns {bool} true page has changed, false - no change
 *  @memberof DataTable#oApi
 */
function _fnPageChange ( settings, action, redraw )
{
	var
		start     = settings._iDisplayStart,
		len       = settings._iDisplayLength,
		records   = settings.fnRecordsDisplay();

	if ( records === 0 || len === -1 )
	{
		start = 0;
	}
	else if ( typeof action === "number" )
	{
		start = action * len;

		if ( start > records )
		{
			start = 0;
		}
	}
	else if ( action == "first" )
	{
		start = 0;
	}
	else if ( action == "previous" )
	{
		start = len >= 0 ?
			start - len :
			0;

		if ( start < 0 )
		{
			start = 0;
		}
	}
	else if ( action == "next" )
	{
		if ( start + len < records )
		{
			start += len;
		}
	}
	else if ( action == "last" )
	{
		start = Math.floor( (records-1) / len) * len;
	}
	else if ( action === 'ellipsis' )
	{
		return;
	}
	else
	{
		_fnLog( settings, 0, "Unknown paging action: "+action, 5 );
	}

	var changed = settings._iDisplayStart !== start;
	settings._iDisplayStart = start;

	_fnCallbackFire( settings, null, changed ? 'page' : 'page-nc', [settings] );

	if ( changed && redraw ) {
		_fnDraw( settings );
	}

	return changed;
}


/**
 * Generate the node required for the processing node
 *  @param {object} settings DataTables settings object
 */
function _processingHtml ( settings )
{
	var table = settings.nTable;
	var scrolling = settings.oScroll.sX !== '' || settings.oScroll.sY !== '';

	if ( settings.oFeatures.bProcessing ) {
		var n = $('<div/>', {
				'id': settings.sTableId + '_processing',
				'class': settings.oClasses.processing.container,
				'role': 'status'
			} )
			.html( settings.oLanguage.sProcessing )
			.append('<div><div></div><div></div><div></div><div></div></div>');

		// Different positioning depending on if scrolling is enabled or not
		if (scrolling) {
			n.prependTo( $('div.dt-scroll', settings.nTableWrapper) );
		}
		else {
			n.insertBefore( table );
		}

		$(table).on( 'processing.dt.DT', function (e, s, show) {
			n.css( 'display', show ? 'block' : 'none' );
		} );
	}
}


/**
 * Display or hide the processing indicator
 *  @param {object} settings DataTables settings object
 *  @param {bool} show Show the processing indicator (true) or not (false)
 */
function _fnProcessingDisplay ( settings, show )
{
	// Ignore cases when we are still redrawing
	if (settings.bDrawing && show === false) {
		return;
	}

	_fnCallbackFire( settings, null, 'processing', [settings, show] );
}

/**
 * Show the processing element if an action takes longer than a given time
 *
 * @param {*} settings DataTables settings object
 * @param {*} enable Do (true) or not (false) async processing (local feature enablement)
 * @param {*} run Function to run
 */
function _fnProcessingRun( settings, enable, run ) {
	if (! enable) {
		// Immediate execution, synchronous
		run();
	}
	else {
		_fnProcessingDisplay(settings, true);
		
		// Allow the processing display to show if needed
		setTimeout(function () {
			run();

			_fnProcessingDisplay(settings, false);
		}, 0);
	}
}
/**
 * Add any control elements for the table - specifically scrolling
 *  @param {object} settings dataTables settings object
 *  @returns {node} Node to add to the DOM
 *  @memberof DataTable#oApi
 */
function _fnFeatureHtmlTable ( settings )
{
	var table = $(settings.nTable);

	// Scrolling from here on in
	var scroll = settings.oScroll;

	if ( scroll.sX === '' && scroll.sY === '' ) {
		return settings.nTable;
	}

	var scrollX = scroll.sX;
	var scrollY = scroll.sY;
	var classes = settings.oClasses.scrolling;
	var caption = settings.captionNode;
	var captionSide = caption ? caption._captionSide : null;
	var headerClone = $( table[0].cloneNode(false) );
	var footerClone = $( table[0].cloneNode(false) );
	var footer = table.children('tfoot');
	var _div = '<div/>';
	var size = function ( s ) {
		return !s ? null : _fnStringToCss( s );
	};

	if ( ! footer.length ) {
		footer = null;
	}

	/*
	 * The HTML structure that we want to generate in this function is:
	 *  div - scroller
	 *    div - scroll head
	 *      div - scroll head inner
	 *        table - scroll head table
	 *          thead - thead
	 *    div - scroll body
	 *      table - table (master table)
	 *        thead - thead clone for sizing
	 *        tbody - tbody
	 *    div - scroll foot
	 *      div - scroll foot inner
	 *        table - scroll foot table
	 *          tfoot - tfoot
	 */
	var scroller = $( _div, { 'class': classes.container } )
		.append(
			$(_div, { 'class': classes.header.self } )
				.css( {
					overflow: 'hidden',
					position: 'relative',
					border: 0,
					width: scrollX ? size(scrollX) : '100%'
				} )
				.append(
					$(_div, { 'class': classes.header.inner } )
						.css( {
							'box-sizing': 'content-box',
							width: scroll.sXInner || '100%'
						} )
						.append(
							headerClone
								.removeAttr('id')
								.css( 'margin-left', 0 )
								.append( captionSide === 'top' ? caption : null )
								.append(
									table.children('thead')
								)
						)
				)
		)
		.append(
			$(_div, { 'class': classes.body } )
				.css( {
					position: 'relative',
					overflow: 'auto',
					width: size( scrollX )
				} )
				.append( table )
		);

	if ( footer ) {
		scroller.append(
			$(_div, { 'class': classes.footer.self } )
				.css( {
					overflow: 'hidden',
					border: 0,
					width: scrollX ? size(scrollX) : '100%'
				} )
				.append(
					$(_div, { 'class': classes.footer.inner } )
						.append(
							footerClone
								.removeAttr('id')
								.css( 'margin-left', 0 )
								.append( captionSide === 'bottom' ? caption : null )
								.append(
									table.children('tfoot')
								)
						)
				)
		);
	}

	var children = scroller.children();
	var scrollHead = children[0];
	var scrollBody = children[1];
	var scrollFoot = footer ? children[2] : null;

	// When the body is scrolled, then we also want to scroll the headers
	$(scrollBody).on( 'scroll.DT', function () {
		var scrollLeft = this.scrollLeft;

		scrollHead.scrollLeft = scrollLeft;

		if ( footer ) {
			scrollFoot.scrollLeft = scrollLeft;
		}
	} );

	// When focus is put on the header cells, we might need to scroll the body
	$('th, td', scrollHead).on('focus', function () {
		var scrollLeft = scrollHead.scrollLeft;

		scrollBody.scrollLeft = scrollLeft;

		if ( footer ) {
			scrollBody.scrollLeft = scrollLeft;
		}
	});

	$(scrollBody).css('max-height', scrollY);
	if (! scroll.bCollapse) {
		$(scrollBody).css('height', scrollY);
	}

	settings.nScrollHead = scrollHead;
	settings.nScrollBody = scrollBody;
	settings.nScrollFoot = scrollFoot;

	// On redraw - align columns
	settings.aoDrawCallback.push(_fnScrollDraw);

	return scroller[0];
}



/**
 * Update the header, footer and body tables for resizing - i.e. column
 * alignment.
 *
 * Welcome to the most horrible function DataTables. The process that this
 * function follows is basically:
 *   1. Re-create the table inside the scrolling div
 *   2. Correct colgroup > col values if needed
 *   3. Copy colgroup > col over to header and footer
 *   4. Clean up
 *
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnScrollDraw ( settings )
{
	// Given that this is such a monster function, a lot of variables are use
	// to try and keep the minimised size as small as possible
	var
		scroll         = settings.oScroll,
		barWidth       = scroll.iBarWidth,
		divHeader      = $(settings.nScrollHead),
		divHeaderInner = divHeader.children('div'),
		divHeaderTable = divHeaderInner.children('table'),
		divBodyEl      = settings.nScrollBody,
		divBody        = $(divBodyEl),
		divFooter      = $(settings.nScrollFoot),
		divFooterInner = divFooter.children('div'),
		divFooterTable = divFooterInner.children('table'),
		header         = $(settings.nTHead),
		table          = $(settings.nTable),
		footer         = settings.nTFoot && $('th, td', settings.nTFoot).length ? $(settings.nTFoot) : null,
		browser        = settings.oBrowser,
		headerCopy, footerCopy;

	// If the scrollbar visibility has changed from the last draw, we need to
	// adjust the column sizes as the table width will have changed to account
	// for the scrollbar
	var scrollBarVis = divBodyEl.scrollHeight > divBodyEl.clientHeight;
	
	if ( settings.scrollBarVis !== scrollBarVis && settings.scrollBarVis !== undefined ) {
		settings.scrollBarVis = scrollBarVis;
		_fnAdjustColumnSizing( settings );
		return; // adjust column sizing will call this function again
	}
	else {
		settings.scrollBarVis = scrollBarVis;
	}

	// 1. Re-create the table inside the scrolling div
	// Remove the old minimised thead and tfoot elements in the inner table
	table.children('thead, tfoot').remove();

	// Clone the current header and footer elements and then place it into the inner table
	headerCopy = header.clone().prependTo( table );
	headerCopy.find('th, td').removeAttr('tabindex');
	headerCopy.find('[id]').removeAttr('id');

	if ( footer ) {
		footerCopy = footer.clone().prependTo( table );
		footerCopy.find('[id]').removeAttr('id');
	}

	// 2. Correct colgroup > col values if needed
	// It is possible that the cell sizes are smaller than the content, so we need to
	// correct colgroup>col for such cases. This can happen if the auto width detection
	// uses a cell which has a longer string, but isn't the widest! For example 
	// "Chief Executive Officer (CEO)" is the longest string in the demo, but
	// "Systems Administrator" is actually the widest string since it doesn't collapse.
	// Note the use of translating into a column index to get the `col` element. This
	// is because of Responsive which might remove `col` elements, knocking the alignment
	// of the indexes out.
	if (settings.aiDisplay.length) {
		// Get the column sizes from the first row in the table. This should really be a
		// [].find, but it wasn't supported in Chrome until Sept 2015, and DT has 10 year
		// browser support
		var firstTr = null;
		var start = _fnDataSource( settings ) !== 'ssp'
			? settings._iDisplayStart
			: 0;

		for (i=start ; i<start + settings.aiDisplay.length ; i++) {
			var idx = settings.aiDisplay[i];
			var tr = settings.aoData[idx].nTr;

			if (tr) {
				firstTr = tr;
				break;
			}
		}

		if (firstTr) {
			var colSizes = $(firstTr).children('th, td').map(function (vis) {
				return {
					idx: _fnVisibleToColumnIndex(settings, vis),
					width: $(this).outerWidth()
				};
			});

			// Check against what the colgroup > col is set to and correct if needed
			for (var i=0 ; i<colSizes.length ; i++) {
				var colEl = settings.aoColumns[ colSizes[i].idx ].colEl[0];
				var colWidth = colEl.style.width.replace('px', '');

				if (colWidth !== colSizes[i].width) {
					colEl.style.width = colSizes[i].width + 'px';

					if (scroll.sX) {
						colEl.style.minWidth = colSizes[i].width + 'px';
					}
				}
			}
		}
	}

	// 3. Copy the colgroup over to the header and footer
	divHeaderTable
		.find('colgroup')
		.remove();

	divHeaderTable.append(settings.colgroup.clone());

	if ( footer ) {
		divFooterTable
			.find('colgroup')
			.remove();

		divFooterTable.append(settings.colgroup.clone());
	}

	// "Hide" the header and footer that we used for the sizing. We need to keep
	// the content of the cell so that the width applied to the header and body
	// both match, but we want to hide it completely.
	$('th, td', headerCopy).each(function () {
		$(this.childNodes).wrapAll('<div class="dt-scroll-sizing">');
	});

	if ( footer ) {
		$('th, td', footerCopy).each(function () {
			$(this.childNodes).wrapAll('<div class="dt-scroll-sizing">');
		});
	}

	// 4. Clean up
	// Figure out if there are scrollbar present - if so then we need the header and footer to
	// provide a bit more space to allow "overflow" scrolling (i.e. past the scrollbar)
	var isScrolling = Math.floor(table.height()) > divBodyEl.clientHeight || divBody.css('overflow-y') == "scroll";
	var paddingSide = 'padding' + (browser.bScrollbarLeft ? 'Left' : 'Right' );

	// Set the width's of the header and footer tables
	var outerWidth = table.outerWidth();

	divHeaderTable.css('width', _fnStringToCss( outerWidth ));
	divHeaderInner
		.css('width', _fnStringToCss( outerWidth ))
		.css(paddingSide, isScrolling ? barWidth+"px" : "0px");

	if ( footer ) {
		divFooterTable.css('width', _fnStringToCss( outerWidth ));
		divFooterInner
			.css('width', _fnStringToCss( outerWidth ))
			.css(paddingSide, isScrolling ? barWidth+"px" : "0px");
	}

	// Correct DOM ordering for colgroup - comes before the thead
	table.children('colgroup').prependTo(table);

	// Adjust the position of the header in case we loose the y-scrollbar
	divBody.trigger('scroll');

	// If sorting or filtering has occurred, jump the scrolling back to the top
	// only if we aren't holding the position
	if ( (settings.bSorted || settings.bFiltered) && ! settings._drawHold ) {
		divBodyEl.scrollTop = 0;
	}
}

/**
 * Calculate the width of columns for the table
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnCalculateColumnWidths ( settings )
{
	// Not interested in doing column width calculation if auto-width is disabled
	if (! settings.oFeatures.bAutoWidth) {
		return;
	}

	var
		table = settings.nTable,
		columns = settings.aoColumns,
		scroll = settings.oScroll,
		scrollY = scroll.sY,
		scrollX = scroll.sX,
		scrollXInner = scroll.sXInner,
		visibleColumns = _fnGetColumns( settings, 'bVisible' ),
		tableWidthAttr = table.getAttribute('width'), // from DOM element
		tableContainer = table.parentNode,
		i, j, column, columnIdx;
		
	var styleWidth = table.style.width;
	var containerWidth = _fnWrapperWidth(settings);

	// Don't re-run for the same width as the last time
	if (containerWidth === settings.containerWidth) {
		return false;
	}

	settings.containerWidth = containerWidth;

	// If there is no width applied as a CSS style or as an attribute, we assume that
	// the width is intended to be 100%, which is usually is in CSS, but it is very
	// difficult to correctly parse the rules to get the final result.
	if ( ! styleWidth && ! tableWidthAttr) {
		table.style.width = '100%';
		styleWidth = '100%';
	}

	if ( styleWidth && styleWidth.indexOf('%') !== -1 ) {
		tableWidthAttr = styleWidth;
	}

	// Let plug-ins know that we are doing a recalc, in case they have changed any of the
	// visible columns their own way (e.g. Responsive uses display:none).
	_fnCallbackFire(
		settings,
		null,
		'column-calc',
		{visible: visibleColumns},
		false
	);

	// Construct a worst case table with the widest, assign any user defined
	// widths, then insert it into  the DOM and allow the browser to do all
	// the hard work of calculating table widths
	var tmpTable = $(table.cloneNode())
		.css( 'visibility', 'hidden' )
		.css( 'margin', 0 )
		.removeAttr( 'id' );

	// Clean up the table body
	tmpTable.append('<tbody/>')

	// Clone the table header and footer - we can't use the header / footer
	// from the cloned table, since if scrolling is active, the table's
	// real header and footer are contained in different table tags
	tmpTable
		.append( $(settings.nTHead).clone() )
		.append( $(settings.nTFoot).clone() );

	// Remove any assigned widths from the footer (from scrolling)
	tmpTable.find('tfoot th, tfoot td').css('width', '');

	// Apply custom sizing to the cloned header
	tmpTable.find('thead th, thead td').each( function () {
		// Get the `width` from the header layout
		var width = _fnColumnsSumWidth( settings, this, true, false );

		if ( width ) {
			this.style.width = width;

			// For scrollX we need to force the column width otherwise the
			// browser will collapse it. If this width is smaller than the
			// width the column requires, then it will have no effect
			if ( scrollX ) {
				this.style.minWidth = width;

				$( this ).append( $('<div/>').css( {
					width: width,
					margin: 0,
					padding: 0,
					border: 0,
					height: 1
				} ) );
			}
		}
		else {
			this.style.width = '';
		}
	} );

	// Get the widest strings for each of the visible columns and add them to
	// our table to create a "worst case"
	var longestData = [];

	for ( i=0 ; i<visibleColumns.length ; i++ ) {
		longestData.push(_fnGetWideStrings(settings, visibleColumns[i]));
	}

	if (longestData.length) {
		for ( i=0 ; i<longestData[0].length ; i++ ) {
			var tr = $('<tr/>').appendTo( tmpTable.find('tbody') );

			for ( j=0 ; j<visibleColumns.length ; j++ ) {
				columnIdx = visibleColumns[j];
				column = columns[ columnIdx ];

				var longest = longestData[j][i] || '';
				var autoClass = _ext.type.className[column.sType];
				var padding = column.sContentPadding || (scrollX ? '-' : '');
				var text = longest + padding;
				var insert = longest.indexOf('<') === -1 && longest.indexOf('&') === -1
					? document.createTextNode(text)
					: text

				$('<td/>')
					.addClass(autoClass)
					.addClass(column.sClass)
					.append(insert)
					.appendTo(tr);
			}
		}
	}

	// Tidy the temporary table - remove name attributes so there aren't
	// duplicated in the dom (radio elements for example)
	$('[name]', tmpTable).removeAttr('name');

	// Table has been built, attach to the document so we can work with it.
	// A holding element is used, positioned at the top of the container
	// with minimal height, so it has no effect on if the container scrolls
	// or not. Otherwise it might trigger scrolling when it actually isn't
	// needed
	var holder = $('<div/>').css( scrollX || scrollY ?
			{
				position: 'absolute',
				top: 0,
				left: 0,
				height: 1,
				right: 0,
				overflow: 'hidden'
			} :
			{}
		)
		.append( tmpTable )
		.appendTo( tableContainer );

	// When scrolling (X or Y) we want to set the width of the table as 
	// appropriate. However, when not scrolling leave the table width as it
	// is. This results in slightly different, but I think correct behaviour
	if ( scrollX && scrollXInner ) {
		tmpTable.width( scrollXInner );
	}
	else if ( scrollX ) {
		tmpTable.css( 'width', 'auto' );
		tmpTable.removeAttr('width');

		// If there is no width attribute or style, then allow the table to
		// collapse
		if ( tmpTable.outerWidth() < tableContainer.clientWidth && tableWidthAttr ) {
			tmpTable.outerWidth( tableContainer.clientWidth );
		}
	}
	else if ( scrollY ) {
		tmpTable.outerWidth( tableContainer.clientWidth );
	}
	else if ( tableWidthAttr ) {
		tmpTable.outerWidth( tableWidthAttr );
	}

	// Get the width of each column in the constructed table
	var total = 0;
	var bodyCells = tmpTable.find('tbody tr').eq(0).children();

	for ( i=0 ; i<visibleColumns.length ; i++ ) {
		// Use getBounding for sub-pixel accuracy, which we then want to round up!
		var bounding = bodyCells[i].getBoundingClientRect().width;

		// Total is tracked to remove any sub-pixel errors as the outerWidth
		// of the table might not equal the total given here
		total += bounding;

		// Width for each column to use
		columns[ visibleColumns[i] ].sWidth = _fnStringToCss( bounding );
	}

	table.style.width = _fnStringToCss( total );

	// Finished with the table - ditch it
	holder.remove();

	// If there is a width attr, we want to attach an event listener which
	// allows the table sizing to automatically adjust when the window is
	// resized. Use the width attr rather than CSS, since we can't know if the
	// CSS is a relative value or absolute - DOM read is always px.
	if ( tableWidthAttr ) {
		table.style.width = _fnStringToCss( tableWidthAttr );
	}

	if ( (tableWidthAttr || scrollX) && ! settings._reszEvt ) {
		var resize = DataTable.util.throttle( function () {
			var newWidth = _fnWrapperWidth(settings);

			// Don't do it if destroying or the container width is 0
			if (! settings.bDestroying && newWidth !== 0) {
				_fnAdjustColumnSizing( settings );
			}
		} );

		// For browsers that support it (~2020 onwards for wide support) we can watch for the
		// container changing width.
		if (window.ResizeObserver) {
			// This is a tricky beast - if the element is visible when `.observe()` is called,
			// then the callback is immediately run. Which we don't want. If the element isn't
			// visible, then it isn't run, but we want it to run when it is then made visible.
			// This flag allows the above to be satisfied.
			var first = $(settings.nTableWrapper).is(':visible');

			// Use an empty div to attach the observer so it isn't impacted by height changes
			var resizer = $('<div>')
				.css({
					width: '100%',
					height: 0
				})
				.addClass('dt-autosize')
				.appendTo(settings.nTableWrapper);

			settings.resizeObserver = new ResizeObserver(function (e) {
				if (first) {
					first = false;
				}
				else {
					resize();
				}
			});

			settings.resizeObserver.observe(resizer[0]);
		}
		else {
			// For old browsers, the best we can do is listen for a window resize
			$(window).on('resize.DT-'+settings.sInstance, resize);
		}

		settings._reszEvt = true;
	}
}

/**
 * Get the width of the DataTables wrapper element
 *
 * @param {*} settings DataTables settings object
 * @returns Width
 */
function _fnWrapperWidth(settings) {
	return $(settings.nTableWrapper).is(':visible')
		? $(settings.nTableWrapper).width()
		: 0;
}

/**
 * Get the widest strings for each column.
 *
 * It is very difficult to determine what the widest string actually is due to variable character
 * width and kerning. Doing an exact calculation with the DOM or even Canvas would kill performance
 * and this is a critical point, so we use two techniques to determine a collection of the longest
 * strings from the column, which will likely contain the widest strings:
 *
 * 1) Get the top three longest strings from the column
 * 2) Get the top three widest words (i.e. an unbreakable phrase)
 *
 *  @param {object} settings dataTables settings object
 *  @param {int} colIdx column of interest
 *  @returns {string[]} Array of the longest strings
 *  @memberof DataTable#oApi
 */
function _fnGetWideStrings( settings, colIdx )
{
	var column = settings.aoColumns[colIdx];

	// Do we need to recalculate (i.e. was invalidated), or just use the cached data?
	if (! column.wideStrings) {
		var allStrings = [];
		var collection = [];

		// Create an array with the string information for the column
		for ( var i=0, iLen=settings.aiDisplayMaster.length ; i<iLen ; i++ ) {
			var rowIdx = settings.aiDisplayMaster[i];
			var data = _fnGetRowDisplay(settings, rowIdx)[colIdx];

			var cellString = data && typeof data === 'object' && data.nodeType
				? data.innerHTML
				: data+'';

			// Remove id / name attributes from elements so they
			// don't interfere with existing elements
			cellString = cellString
				.replace(/id=".*?"/g, '')
				.replace(/name=".*?"/g, '');

			// Don't want Javascript at all in these calculation cells.
			cellString = cellString.replace(/<script.*?<\/script>/gi, ' ');

			var noHtml = _stripHtml(cellString, ' ')
				.replace( /&nbsp;/g, ' ' );
	
			// The length is calculated on the text only, but we keep the HTML
			// in the string so it can be used in the calculation table
			collection.push({
				str: cellString,
				len: noHtml.length
			});

			allStrings.push(noHtml);
		}

		// Order and then cut down to the size we need
		collection
			.sort(function (a, b) {
				return b.len - a.len;
			})
			.splice(3);

		column.wideStrings = collection.map(function (item) {
			return item.str;
		});

		// Longest unbroken string
		let parts = allStrings.join(' ').split(' ');

		parts.sort(function (a, b) {
			return b.length - a.length;
		});

		if (parts.length) {
			column.wideStrings.push(parts[0]);
		}

		if (parts.length > 1) {
			column.wideStrings.push(parts[1]);
		}

		if (parts.length > 2) {
			column.wideStrings.push(parts[3]);
		}
	}

	return column.wideStrings;
}


/**
 * Append a CSS unit (only if required) to a string
 *  @param {string} value to css-ify
 *  @returns {string} value with css unit
 *  @memberof DataTable#oApi
 */
function _fnStringToCss( s )
{
	if ( s === null ) {
		return '0px';
	}

	if ( typeof s == 'number' ) {
		return s < 0 ?
			'0px' :
			s+'px';
	}

	// Check it has a unit character already
	return s.match(/\d$/) ?
		s+'px' :
		s;
}

/**
 * Re-insert the `col` elements for current visibility
 *
 * @param {*} settings DT settings
 */
function _colGroup( settings ) {
	var cols = settings.aoColumns;

	settings.colgroup.empty();

	for (i=0 ; i<cols.length ; i++) {
		if (cols[i].bVisible) {
			settings.colgroup.append(cols[i].colEl);
		}
	}
}


function _fnSortInit( settings ) {
	var target = settings.nTHead;
	var headerRows = target.querySelectorAll('tr');
	var titleRow = settings.titleRow;
	var notSelector = ':not([data-dt-order="disable"]):not([data-dt-order="icon-only"])';
	
	// Legacy support for `orderCellsTop`
	if (titleRow === true) {
		target = headerRows[0];
	}
	else if (titleRow === false) {
		target = headerRows[ headerRows.length - 1 ];
	}
	else if (titleRow !== null) {
		target = headerRows[titleRow];
	}
	// else - all rows

	if (settings.orderHandler) {
		_fnSortAttachListener(
			settings,
			target,
			target === settings.nTHead
				? 'tr'+notSelector+' th'+notSelector+', tr'+notSelector+' td'+notSelector
				: 'th'+notSelector+', td'+notSelector
		);
	}

	// Need to resolve the user input array into our internal structure
	var order = [];
	_fnSortResolve( settings, order, settings.aaSorting );

	settings.aaSorting = order;
}


function _fnSortAttachListener(settings, node, selector, column, callback) {
	_fnBindAction( node, selector, function (e) {
		var run = false;
		var columns = column === undefined
			? _fnColumnsFromHeader( e.target )
			: typeof column === 'function'
				? column()
				: Array.isArray(column)
					? column
					: [column];

		if ( columns.length ) {
			for ( var i=0, iLen=columns.length ; i<iLen ; i++ ) {
				var ret = _fnSortAdd( settings, columns[i], i, e.shiftKey );

				if (ret !== false) {
					run = true;
				}					

				// If the first entry is no sort, then subsequent
				// sort columns are ignored
				if (settings.aaSorting.length === 1 && settings.aaSorting[0][1] === '') {
					break;
				}
			}

			if (run) {
				_fnProcessingRun(settings, true, function () {
					_fnSort( settings );
					_fnSortDisplay( settings, settings.aiDisplay );

					_fnReDraw( settings, false, false );

					if (callback) {
						callback();
					}
				});
			}
		}
	} );
}

/**
 * Sort the display array to match the master's order
 * @param {*} settings
 */
function _fnSortDisplay(settings, display) {
	if (display.length < 2) {
		return;
	}

	var master = settings.aiDisplayMaster;
	var masterMap = {};
	var map = {};
	var i;

	// Rather than needing an `indexOf` on master array, we can create a map
	for (i=0 ; i<master.length ; i++) {
		masterMap[master[i]] = i;
	}

	// And then cache what would be the indexOf from the display
	for (i=0 ; i<display.length ; i++) {
		map[display[i]] = masterMap[display[i]];
	}

	display.sort(function(a, b){
		// Short version of this function is simply `master.indexOf(a) - master.indexOf(b);`
		return map[a] - map[b];
	});
}


function _fnSortResolve (settings, nestedSort, sort) {
	var push = function ( a ) {
		if ($.isPlainObject(a)) {
			if (a.idx !== undefined) {
				// Index based ordering
				nestedSort.push([a.idx, a.dir]);
			}
			else if (a.name) {
				// Name based ordering
				var cols = _pluck( settings.aoColumns, 'sName');
				var idx = cols.indexOf(a.name);

				if (idx !== -1) {
					nestedSort.push([idx, a.dir]);
				}
			}
		}
		else {
			// Plain column index and direction pair
			nestedSort.push(a);
		}
	};

	if ( $.isPlainObject(sort) ) {
		// Object
		push(sort);
	}
	else if ( sort.length && typeof sort[0] === 'number' ) {
		// 1D array
		push(sort);
	}
	else if ( sort.length ) {
		// 2D array
		for (var z=0; z<sort.length; z++) {
			push(sort[z]); // Object or array
		}
	}
}


function _fnSortFlatten ( settings )
{
	var
		i, k, kLen,
		aSort = [],
		extSort = DataTable.ext.type.order,
		aoColumns = settings.aoColumns,
		aDataSort, iCol, sType, srcCol,
		fixed = settings.aaSortingFixed,
		fixedObj = $.isPlainObject( fixed ),
		nestedSort = [];
	
	if ( ! settings.oFeatures.bSort ) {
		return aSort;
	}

	// Build the sort array, with pre-fix and post-fix options if they have been
	// specified
	if ( Array.isArray( fixed ) ) {
		_fnSortResolve( settings, nestedSort, fixed );
	}

	if ( fixedObj && fixed.pre ) {
		_fnSortResolve( settings, nestedSort, fixed.pre );
	}

	_fnSortResolve( settings, nestedSort, settings.aaSorting );

	if (fixedObj && fixed.post ) {
		_fnSortResolve( settings, nestedSort, fixed.post );
	}

	for ( i=0 ; i<nestedSort.length ; i++ )
	{
		srcCol = nestedSort[i][0];

		if ( aoColumns[ srcCol ] ) {
			aDataSort = aoColumns[ srcCol ].aDataSort;

			for ( k=0, kLen=aDataSort.length ; k<kLen ; k++ )
			{
				iCol = aDataSort[k];
				sType = aoColumns[ iCol ].sType || 'string';

				if ( nestedSort[i]._idx === undefined ) {
					nestedSort[i]._idx = aoColumns[iCol].asSorting.indexOf(nestedSort[i][1]);
				}

				if ( nestedSort[i][1] ) {
					aSort.push( {
						src:       srcCol,
						col:       iCol,
						dir:       nestedSort[i][1],
						index:     nestedSort[i]._idx,
						type:      sType,
						formatter: extSort[ sType+"-pre" ],
						sorter:    extSort[ sType+"-"+nestedSort[i][1] ]
					} );
				}
			}
		}
	}

	return aSort;
}

/**
 * Change the order of the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnSort ( oSettings, col, dir )
{
	var
		i, iLen,
		aiOrig = [],
		extSort = DataTable.ext.type.order,
		aoData = oSettings.aoData,
		sortCol,
		displayMaster = oSettings.aiDisplayMaster,
		aSort;

	// Make sure the columns all have types defined
	_fnColumnTypes(oSettings);

	// Allow a specific column to be sorted, which will _not_ alter the display
	// master
	if (col !== undefined) {
		var srcCol = oSettings.aoColumns[col];

		aSort = [{
			src:       col,
			col:       col,
			dir:       dir,
			index:     0,
			type:      srcCol.sType,
			formatter: extSort[ srcCol.sType+"-pre" ],
			sorter:    extSort[ srcCol.sType+"-"+dir ]
		}];
		displayMaster = displayMaster.slice();
	}
	else {
		aSort = _fnSortFlatten( oSettings );
	}

	for ( i=0, iLen=aSort.length ; i<iLen ; i++ ) {
		sortCol = aSort[i];

		// Load the data needed for the sort, for each cell
		_fnSortData( oSettings, sortCol.col );
	}

	/* No sorting required if server-side or no sorting array */
	if ( _fnDataSource( oSettings ) != 'ssp' && aSort.length !== 0 )
	{
		// Reset the initial positions on each pass so we get a stable sort
		for ( i=0, iLen=displayMaster.length ; i<iLen ; i++ ) {
			aiOrig[ i ] = i;
		}

		// If the first sort is desc, then reverse the array to preserve original
		// order, just in reverse
		if (aSort.length && aSort[0].dir === 'desc' && oSettings.orderDescReverse) {
			aiOrig.reverse();
		}

		/* Do the sort - here we want multi-column sorting based on a given data source (column)
		 * and sorting function (from oSort) in a certain direction. It's reasonably complex to
		 * follow on its own, but this is what we want (example two column sorting):
		 *  fnLocalSorting = function(a,b){
		 *    var test;
		 *    test = oSort['string-asc']('data11', 'data12');
		 *      if (test !== 0)
		 *        return test;
		 *    test = oSort['numeric-desc']('data21', 'data22');
		 *    if (test !== 0)
		 *      return test;
		 *    return oSort['numeric-asc']( aiOrig[a], aiOrig[b] );
		 *  }
		 * Basically we have a test for each sorting column, if the data in that column is equal,
		 * test the next column. If all columns match, then we use a numeric sort on the row
		 * positions in the original data array to provide a stable sort.
		 */
		displayMaster.sort( function ( a, b ) {
			var
				x, y, k, test, sort,
				len=aSort.length,
				dataA = aoData[a]._aSortData,
				dataB = aoData[b]._aSortData;

			for ( k=0 ; k<len ; k++ ) {
				sort = aSort[k];

				// Data, which may have already been through a `-pre` function
				x = dataA[ sort.col ];
				y = dataB[ sort.col ];

				if (sort.sorter) {
					// If there is a custom sorter (`-asc` or `-desc`) for this
					// data type, use it
					test = sort.sorter(x, y);

					if ( test !== 0 ) {
						return test;
					}
				}
				else {
					// Otherwise, use generic sorting
					test = x<y ? -1 : x>y ? 1 : 0;

					if ( test !== 0 ) {
						return sort.dir === 'asc' ? test : -test;
					}
				}
			}

			x = aiOrig[a];
			y = aiOrig[b];

			return x<y ? -1 : x>y ? 1 : 0;
		} );
	}
	else if ( aSort.length === 0 ) {
		// Apply index order
		displayMaster.sort(function (x, y) {
			return x<y ? -1 : x>y ? 1 : 0;
		});
	}

	if (col === undefined) {
		// Tell the draw function that we have sorted the data
		oSettings.bSorted = true;
		oSettings.sortDetails = aSort;

		_fnCallbackFire( oSettings, null, 'order', [oSettings, aSort] );
	}

	return displayMaster;
}


/**
 * Function to run on user sort request
 *  @param {object} settings dataTables settings object
 *  @param {node} attachTo node to attach the handler to
 *  @param {int} colIdx column sorting index
 *  @param {int} addIndex Counter
 *  @param {boolean} [shift=false] Shift click add
 *  @param {function} [callback] callback function
 *  @memberof DataTable#oApi
 */
function _fnSortAdd ( settings, colIdx, addIndex, shift )
{
	var col = settings.aoColumns[ colIdx ];
	var sorting = settings.aaSorting;
	var asSorting = col.asSorting;
	var nextSortIdx;
	var next = function ( a, overflow ) {
		var idx = a._idx;
		if ( idx === undefined ) {
			idx = asSorting.indexOf(a[1]);
		}

		return idx+1 < asSorting.length ?
			idx+1 :
			overflow ?
				null :
				0;
	};

	if ( ! col.bSortable ) {
		return false;
	}

	// Convert to 2D array if needed
	if ( typeof sorting[0] === 'number' ) {
		sorting = settings.aaSorting = [ sorting ];
	}

	// If appending the sort then we are multi-column sorting
	if ( (shift || addIndex) && settings.oFeatures.bSortMulti ) {
		// Are we already doing some kind of sort on this column?
		var sortIdx = _pluck(sorting, '0').indexOf(colIdx);

		if ( sortIdx !== -1 ) {
			// Yes, modify the sort
			nextSortIdx = next( sorting[sortIdx], true );

			if ( nextSortIdx === null && sorting.length === 1 ) {
				nextSortIdx = 0; // can't remove sorting completely
			}

			if ( nextSortIdx === null || asSorting[ nextSortIdx ] === '' ) {
				sorting.splice( sortIdx, 1 );
			}
			else {
				sorting[sortIdx][1] = asSorting[ nextSortIdx ];
				sorting[sortIdx]._idx = nextSortIdx;
			}
		}
		else if (shift) {
			// No sort on this column yet, being added by shift click
			// add it as itself
			sorting.push( [ colIdx, asSorting[0], 0 ] );
			sorting[sorting.length-1]._idx = 0;
		}
		else {
			// No sort on this column yet, being added from a colspan
			// so add with same direction as first column
			sorting.push( [ colIdx, sorting[0][1], 0 ] );
			sorting[sorting.length-1]._idx = 0;
		}
	}
	else if ( sorting.length && sorting[0][0] == colIdx ) {
		// Single column - already sorting on this column, modify the sort
		nextSortIdx = next( sorting[0] );

		sorting.length = 1;
		sorting[0][1] = asSorting[ nextSortIdx ];
		sorting[0]._idx = nextSortIdx;
	}
	else {
		// Single column - sort only on this column
		sorting.length = 0;
		sorting.push( [ colIdx, asSorting[0] ] );
		sorting[0]._idx = 0;
	}
}


/**
 * Set the sorting classes on table's body, Note: it is safe to call this function
 * when bSort and bSortClasses are false
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnSortingClasses( settings )
{
	var oldSort = settings.aLastSort;
	var sortClass = settings.oClasses.order.position;
	var sort = _fnSortFlatten( settings );
	var features = settings.oFeatures;
	var i, iLen, colIdx;

	if ( features.bSort && features.bSortClasses ) {
		// Remove old sorting classes
		for ( i=0, iLen=oldSort.length ; i<iLen ; i++ ) {
			colIdx = oldSort[i].src;

			// Remove column sorting
			$( _pluck( settings.aoData, 'anCells', colIdx ) )
				.removeClass( sortClass + (i<2 ? i+1 : 3) );
		}

		// Add new column sorting
		for ( i=0, iLen=sort.length ; i<iLen ; i++ ) {
			colIdx = sort[i].src;

			$( _pluck( settings.aoData, 'anCells', colIdx ) )
				.addClass( sortClass + (i<2 ? i+1 : 3) );
		}
	}

	settings.aLastSort = sort;
}


// Get the data to sort a column, be it from cache, fresh (populating the
// cache), or from a sort formatter
function _fnSortData( settings, colIdx )
{
	// Custom sorting function - provided by the sort data type
	var column = settings.aoColumns[ colIdx ];
	var customSort = DataTable.ext.order[ column.sSortDataType ];
	var customData;

	if ( customSort ) {
		customData = customSort.call( settings.oInstance, settings, colIdx,
			_fnColumnIndexToVisible( settings, colIdx )
		);
	}

	// Use / populate cache
	var row, cellData;
	var formatter = DataTable.ext.type.order[ column.sType+"-pre" ];
	var data = settings.aoData;

	for ( var rowIdx=0 ; rowIdx<data.length ; rowIdx++ ) {
		// Sparse array
		if (! data[rowIdx]) {
			continue;
		}

		row = data[rowIdx];

		if ( ! row._aSortData ) {
			row._aSortData = [];
		}

		if ( ! row._aSortData[colIdx] || customSort ) {
			cellData = customSort ?
				customData[rowIdx] : // If there was a custom sort function, use data from there
				_fnGetCellData( settings, rowIdx, colIdx, 'sort' );

			row._aSortData[ colIdx ] = formatter ?
				formatter( cellData, settings ) :
				cellData;
		}
	}
}


/**
 * State information for a table
 *
 * @param {*} settings
 * @returns State object
 */
function _fnSaveState ( settings )
{
	if (settings._bLoadingState) {
		return;
	}

	// Sort state saving uses [[idx, order]] structure.
	var sorting = [];
	_fnSortResolve(settings, sorting, settings.aaSorting );

	/* Store the interesting variables */
	var columns = settings.aoColumns;
	var state = {
		time:    +new Date(),
		start:   settings._iDisplayStart,
		length:  settings._iDisplayLength,
		order:   sorting.map(function (sort) {
			// If a column name is available, use it
			return columns[sort[0]] && columns[sort[0]].sName
				? [ columns[sort[0]].sName, sort[1] ]
				: sort.slice();
		} ),
		search:  $.extend({}, settings.oPreviousSearch),
		columns: settings.aoColumns.map( function ( col, i ) {
			return {
				name: col.sName,
				visible: col.bVisible,
				search: $.extend({}, settings.aoPreSearchCols[i])
			};
		} )
	};

	settings.oSavedState = state;
	_fnCallbackFire( settings, "aoStateSaveParams", 'stateSaveParams', [settings, state] );
	
	if ( settings.oFeatures.bStateSave && !settings.bDestroying )
	{
		settings.fnStateSaveCallback.call( settings.oInstance, settings, state );
	}	
}


/**
 * Attempt to load a saved table state
 *  @param {object} oSettings dataTables settings object
 *  @param {object} oInit DataTables init object so we can override settings
 *  @param {function} callback Callback to execute when the state has been loaded
 *  @memberof DataTable#oApi
 */
function _fnLoadState ( settings, init, callback )
{
	if ( ! settings.oFeatures.bStateSave ) {
		callback();
		return;
	}

	var loaded = function(state) {
		_fnImplementState(settings, state, callback);
	}

	var state = settings.fnStateLoadCallback.call( settings.oInstance, settings, loaded );

	if ( state !== undefined ) {
		_fnImplementState( settings, state, callback );
	}
	// otherwise, wait for the loaded callback to be executed

	return true;
}

function _fnImplementState ( settings, s, callback) {
	var i, iLen;
	var columns = settings.aoColumns;
	var currentNames = _pluck(settings.aoColumns, 'sName');

	settings._bLoadingState = true;

	// When StateRestore was introduced the state could now be implemented at any time
	// Not just initialisation. To do this an api instance is required in some places
	var api = settings._bInitComplete ? new DataTable.Api(settings) : null;

	if ( ! s || ! s.time ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Reject old data
	var duration = settings.iStateDuration;
	if ( duration > 0 && s.time < +new Date() - (duration*1000) ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Allow custom and plug-in manipulation functions to alter the saved data set and
	// cancelling of loading by returning false
	var abStateLoad = _fnCallbackFire( settings, 'aoStateLoadParams', 'stateLoadParams', [settings, s] );
	if ( abStateLoad.indexOf(false) !== -1 ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Store the saved state so it might be accessed at any time
	settings.oLoadedState = $.extend( true, {}, s );

	// This is needed for ColReorder, which has to happen first to allow all
	// the stored indexes to be usable. It is not publicly documented.
	_fnCallbackFire( settings, null, 'stateLoadInit', [settings, s], true );

	// Page Length
	if ( s.length !== undefined ) {
		// If already initialised just set the value directly so that the select element is also updated
		if (api) {
			api.page.len(s.length)
		}
		else {
			settings._iDisplayLength   = s.length;
		}
	}

	// Restore key features
	if ( s.start !== undefined ) {
		if(api === null) {
			settings._iDisplayStart    = s.start;
			settings.iInitDisplayStart = s.start;
		}
		else {
			_fnPageChange(settings, s.start/settings._iDisplayLength);
		}
	}

	// Order
	if ( s.order !== undefined ) {
		settings.aaSorting = [];
		$.each( s.order, function ( i, col ) {
			var set = [ col[0], col[1] ];

			// A column name was stored and should be used for restore
			if (typeof col[0] === 'string') {
				// Find the name from the current list of column names
				var idx = currentNames.indexOf(col[0]);

				if (idx < 0) {
					// If the column was not found ignore it and continue
					return;
				}

				set[0] = idx;
			}
			else if (set[0] >= columns.length) {
				// If the column index is out of bounds ignore it and continue
				return;
			}

			settings.aaSorting.push(set);
		} );
	}

	// Search
	if ( s.search !== undefined ) {
		$.extend( settings.oPreviousSearch, s.search );
	}

	// Columns
	if ( s.columns ) {
		var set = s.columns;
		var incoming = _pluck(s.columns, 'name');

		// Check if it is a 2.2 style state object with a `name` property for the columns, and if
		// the name was defined. If so, then create a new array that will map the state object
		// given, to the current columns (don't bother if they are already matching tho).
		if (incoming.join('').length && incoming.join('') !== currentNames.join('')) {
			set = [];

			// For each column, try to find the name in the incoming array
			for (i=0 ; i<currentNames.length ; i++) {
				if (currentNames[i] != '') {
					var idx = incoming.indexOf(currentNames[i]);

					if (idx >= 0) {
						set.push(s.columns[idx]);
					}
					else {
						// No matching column name in the state's columns, so this might be a new
						// column and thus can't have a state already.
						set.push({});
					}
				}
				else {
					// If no name, but other columns did have a name, then there is no knowing
					// where this one came from originally so it can't be restored.
					set.push({});
				}
			}
		}

		// If the number of columns to restore is different from current, then all bets are off.
		if (set.length === columns.length) {
			for ( i=0, iLen=set.length ; i<iLen ; i++ ) {
				var col = set[i];

				// Visibility
				if ( col.visible !== undefined ) {
					// If the api is defined, the table has been initialised so we need to use it rather than internal settings
					if (api) {
						// Don't redraw the columns on every iteration of this loop, we will do this at the end instead
						api.column(i).visible(col.visible, false);
					}
					else {
						columns[i].bVisible = col.visible;
					}
				}

				// Search
				if ( col.search !== undefined ) {
					$.extend( settings.aoPreSearchCols[i], col.search );
				}
			}

			// If the api is defined then we need to adjust the columns once the visibility has been changed
			if (api) {
				api.one('draw', function () {
					api.columns.adjust();
				});
			}
		}
	}

	settings._bLoadingState = false;
	_fnCallbackFire( settings, 'aoStateLoaded', 'stateLoaded', [settings, s] );
	callback();
}

/**
 * Log an error message
 *  @param {object} settings dataTables settings object
 *  @param {int} level log error messages, or display them to the user
 *  @param {string} msg error message
 *  @param {int} tn Technical note id to get more information about the error.
 *  @memberof DataTable#oApi
 */
function _fnLog( settings, level, msg, tn )
{
	msg = 'DataTables warning: '+
		(settings ? 'table id='+settings.sTableId+' - ' : '')+msg;

	if ( tn ) {
		msg += '. For more information about this error, please see '+
		'https://datatables.net/tn/'+tn;
	}

	if ( ! level  ) {
		// Backwards compatibility pre 1.10
		var ext = DataTable.ext;
		var type = ext.sErrMode || ext.errMode;

		if ( settings ) {
			_fnCallbackFire( settings, null, 'dt-error', [ settings, tn, msg ], true );
		}

		if ( type == 'alert' ) {
			alert( msg );
		}
		else if ( type == 'throw' ) {
			throw new Error(msg);
		}
		else if ( typeof type == 'function' ) {
			type( settings, tn, msg );
		}
	}
	else if ( window.console && console.log ) {
		console.log( msg );
	}
}


/**
 * See if a property is defined on one object, if so assign it to the other object
 *  @param {object} ret target object
 *  @param {object} src source object
 *  @param {string} name property
 *  @param {string} [mappedName] name to map too - optional, name used if not given
 *  @memberof DataTable#oApi
 */
function _fnMap( ret, src, name, mappedName )
{
	if ( Array.isArray( name ) ) {
		$.each( name, function (i, val) {
			if ( Array.isArray( val ) ) {
				_fnMap( ret, src, val[0], val[1] );
			}
			else {
				_fnMap( ret, src, val );
			}
		} );

		return;
	}

	if ( mappedName === undefined ) {
		mappedName = name;
	}

	if ( src[name] !== undefined ) {
		ret[mappedName] = src[name];
	}
}


/**
 * Extend objects - very similar to jQuery.extend, but deep copy objects, and
 * shallow copy arrays. The reason we need to do this, is that we don't want to
 * deep copy array init values (such as aaSorting) since the dev wouldn't be
 * able to override them, but we do want to deep copy arrays.
 *  @param {object} out Object to extend
 *  @param {object} extender Object from which the properties will be applied to
 *      out
 *  @param {boolean} breakRefs If true, then arrays will be sliced to take an
 *      independent copy with the exception of the `data` or `aaData` parameters
 *      if they are present. This is so you can pass in a collection to
 *      DataTables and have that used as your data source without breaking the
 *      references
 *  @returns {object} out Reference, just for convenience - out === the return.
 *  @memberof DataTable#oApi
 *  @todo This doesn't take account of arrays inside the deep copied objects.
 */
function _fnExtend( out, extender, breakRefs )
{
	var val;

	for ( var prop in extender ) {
		if ( Object.prototype.hasOwnProperty.call(extender, prop) ) {
			val = extender[prop];

			if ( $.isPlainObject( val ) ) {
				if ( ! $.isPlainObject( out[prop] ) ) {
					out[prop] = {};
				}
				$.extend( true, out[prop], val );
			}
			else if ( breakRefs && prop !== 'data' && prop !== 'aaData' && Array.isArray(val) ) {
				out[prop] = val.slice();
			}
			else {
				out[prop] = val;
			}
		}
	}

	return out;
}


/**
 * Bind an event handler to allow a click or return key to activate the callback.
 * This is good for accessibility since a return on the keyboard will have the
 * same effect as a click, if the element has focus.
 *  @param {element} n Element to bind the action to
 *  @param {object|string} selector Selector (for delegated events) or data object
 *   to pass to the triggered function
 *  @param {function} fn Callback function for when the event is triggered
 *  @memberof DataTable#oApi
 */
function _fnBindAction( n, selector, fn )
{
	$(n)
		.on( 'click.DT', selector, function (e) {
			fn(e);
		} )
		.on( 'keypress.DT', selector, function (e){
			if ( e.which === 13 ) {
				e.preventDefault();
				fn(e);
			}
		} )
		.on( 'selectstart.DT', selector, function () {
			// Don't want a double click resulting in text selection
			return false;
		} );
}


/**
 * Register a callback function. Easily allows a callback function to be added to
 * an array store of callback functions that can then all be called together.
 *  @param {object} settings dataTables settings object
 *  @param {string} store Name of the array storage for the callbacks in oSettings
 *  @param {function} fn Function to be called back
 *  @memberof DataTable#oApi
 */
function _fnCallbackReg( settings, store, fn )
{
	if ( fn ) {
		settings[store].push(fn);
	}
}


/**
 * Fire callback functions and trigger events. Note that the loop over the
 * callback array store is done backwards! Further note that you do not want to
 * fire off triggers in time sensitive applications (for example cell creation)
 * as its slow.
 *  @param {object} settings dataTables settings object
 *  @param {string} callbackArr Name of the array storage for the callbacks in
 *      oSettings
 *  @param {string} eventName Name of the jQuery custom event to trigger. If
 *      null no trigger is fired
 *  @param {array} args Array of arguments to pass to the callback function /
 *      trigger
 *  @param {boolean} [bubbles] True if the event should bubble
 *  @memberof DataTable#oApi
 */
function _fnCallbackFire( settings, callbackArr, eventName, args, bubbles )
{
	var ret = [];

	if ( callbackArr ) {
		ret = settings[callbackArr].slice().reverse().map( function (val) {
			return val.apply( settings.oInstance, args );
		} );
	}

	if ( eventName !== null) {
		var e = $.Event( eventName+'.dt' );
		var table = $(settings.nTable);
		
		// Expose the DataTables API on the event object for easy access
		e.dt = settings.api;

		table[bubbles ?  'trigger' : 'triggerHandler']( e, args );

		// If not yet attached to the document, trigger the event
		// on the body directly to sort of simulate the bubble
		if (bubbles && table.parents('body').length === 0) {
			$('body').trigger( e, args );
		}

		ret.push( e.result );
	}

	return ret;
}


function _fnLengthOverflow ( settings )
{
	var
		start = settings._iDisplayStart,
		end = settings.fnDisplayEnd(),
		len = settings._iDisplayLength;

	/* If we have space to show extra rows (backing up from the end point - then do so */
	if ( start >= end )
	{
		start = end - len;
	}

	// Keep the start record on the current page
	start -= (start % len);

	if ( len === -1 || start < 0 )
	{
		start = 0;
	}

	settings._iDisplayStart = start;
}


function _fnRenderer( settings, type )
{
	var renderer = settings.renderer;
	var host = DataTable.ext.renderer[type];

	if ( $.isPlainObject( renderer ) && renderer[type] ) {
		// Specific renderer for this type. If available use it, otherwise use
		// the default.
		return host[renderer[type]] || host._;
	}
	else if ( typeof renderer === 'string' ) {
		// Common renderer - if there is one available for this type use it,
		// otherwise use the default
		return host[renderer] || host._;
	}

	// Use the default
	return host._;
}


/**
 * Detect the data source being used for the table. Used to simplify the code
 * a little (ajax) and to make it compress a little smaller.
 *
 *  @param {object} settings dataTables settings object
 *  @returns {string} Data source
 *  @memberof DataTable#oApi
 */
function _fnDataSource ( settings )
{
	if ( settings.oFeatures.bServerSide ) {
		return 'ssp';
	}
	else if ( settings.ajax ) {
		return 'ajax';
	}
	return 'dom';
}

/**
 * Common replacement for language strings
 *
 * @param {*} settings DT settings object
 * @param {*} str String with values to replace
 * @param {*} entries Plural number for _ENTRIES_ - can be undefined
 * @returns String
 */
function _fnMacros ( settings, str, entries )
{
	// When infinite scrolling, we are always starting at 1. _iDisplayStart is
	// used only internally
	var
		formatter  = settings.fnFormatNumber,
		start      = settings._iDisplayStart+1,
		len        = settings._iDisplayLength,
		vis        = settings.fnRecordsDisplay(),
		max        = settings.fnRecordsTotal(),
		all        = len === -1;

	return str.
		replace(/_START_/g, formatter.call( settings, start ) ).
		replace(/_END_/g,   formatter.call( settings, settings.fnDisplayEnd() ) ).
		replace(/_MAX_/g,   formatter.call( settings, max ) ).
		replace(/_TOTAL_/g, formatter.call( settings, vis ) ).
		replace(/_PAGE_/g,  formatter.call( settings, all ? 1 : Math.ceil( start / len ) ) ).
		replace(/_PAGES_/g, formatter.call( settings, all ? 1 : Math.ceil( vis / len ) ) ).
		replace(/_ENTRIES_/g, settings.api.i18n('entries', '', entries) ).
		replace(/_ENTRIES-MAX_/g, settings.api.i18n('entries', '', max) ).
		replace(/_ENTRIES-TOTAL_/g, settings.api.i18n('entries', '', vis) );
}

/**
 * Add elements to an array as quickly as possible, but stack safe.
 *
 * @param {*} arr Array to add the data to
 * @param {*} data Data array that is to be added
 * @returns 
 */
function _fnArrayApply(arr, data) {
	if (! data) {
		return;
	}

	// Chrome can throw a max stack error if apply is called with
	// too large an array, but apply is faster.
	if (data.length < 10000) {
		arr.push.apply(arr, data);
	}
	else {
		for (i=0 ; i<data.length ; i++) {
			arr.push(data[i]);
		}
	}
}

/**
 * Add one or more listeners to the table
 *
 * @param {*} that JQ for the table
 * @param {*} name Event name
 * @param {*} src Listener(s)
 */
function _fnListener(that, name, src) {
	if (!Array.isArray(src)) {
		src = [src];
	}

	for (i=0 ; i<src.length ; i++) {
		that.on(name + '.dt', src[i]);
	}
}

/**
 * Escape HTML entities in strings, in an object
 */
function _fnEscapeObject(obj) {
	if (DataTable.ext.escape.attributes) {
		$.each(obj, function (key, val) {
			obj[key] = _escapeHtml(val);
		})
	}

	return obj;
}



/**
 * Computed structure of the DataTables API, defined by the options passed to
 * `DataTable.Api.register()` when building the API.
 *
 * The structure is built in order to speed creation and extension of the Api
 * objects since the extensions are effectively pre-parsed.
 *
 * The array is an array of objects with the following structure, where this
 * base array represents the Api prototype base:
 *
 *     [
 *       {
 *         name:      'data'                -- string   - Property name
 *         val:       function () {},       -- function - Api method (or undefined if just an object
 *         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
 *         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
 *       },
 *       {
 *         name:     'row'
 *         val:       {},
 *         methodExt: [ ... ],
 *         propExt:   [
 *           {
 *             name:      'data'
 *             val:       function () {},
 *             methodExt: [ ... ],
 *             propExt:   [ ... ]
 *           },
 *           ...
 *         ]
 *       }
 *     ]
 *
 * @type {Array}
 * @ignore
 */
var __apiStruct = [];


/**
 * `Array.prototype` reference.
 *
 * @type object
 * @ignore
 */
var __arrayProto = Array.prototype;


/**
 * Abstraction for `context` parameter of the `Api` constructor to allow it to
 * take several different forms for ease of use.
 *
 * Each of the input parameter types will be converted to a DataTables settings
 * object where possible.
 *
 * @param  {string|node|jQuery|object} mixed DataTable identifier. Can be one
 *   of:
 *
 *   * `string` - jQuery selector. Any DataTables' matching the given selector
 *     with be found and used.
 *   * `node` - `TABLE` node which has already been formed into a DataTable.
 *   * `jQuery` - A jQuery object of `TABLE` nodes.
 *   * `object` - DataTables settings object
 *   * `DataTables.Api` - API instance
 * @return {array|null} Matching DataTables settings objects. `null` or
 *   `undefined` is returned if no matching DataTable is found.
 * @ignore
 */
var _toSettings = function ( mixed )
{
	var idx, jq;
	var settings = DataTable.settings;
	var tables = _pluck(settings, 'nTable');

	if ( ! mixed ) {
		return [];
	}
	else if ( mixed.nTable && mixed.oFeatures ) {
		// DataTables settings object
		return [ mixed ];
	}
	else if ( mixed.nodeName && mixed.nodeName.toLowerCase() === 'table' ) {
		// Table node
		idx = tables.indexOf(mixed);
		return idx !== -1 ? [ settings[idx] ] : null;
	}
	else if ( mixed && typeof mixed.settings === 'function' ) {
		return mixed.settings().toArray();
	}
	else if ( typeof mixed === 'string' ) {
		// jQuery selector
		jq = $(mixed).get();
	}
	else if ( mixed instanceof $ ) {
		// jQuery object (also DataTables instance)
		jq = mixed.get();
	}

	if ( jq ) {
		return settings.filter(function (v, idx) {
			return jq.includes(tables[idx]);
		});
	}
};


/**
 * DataTables API class - used to control and interface with  one or more
 * DataTables enhanced tables.
 *
 * The API class is heavily based on jQuery, presenting a chainable interface
 * that you can use to interact with tables. Each instance of the API class has
 * a "context" - i.e. the tables that it will operate on. This could be a single
 * table, all tables on a page or a sub-set thereof.
 *
 * Additionally the API is designed to allow you to easily work with the data in
 * the tables, retrieving and manipulating it as required. This is done by
 * presenting the API class as an array like interface. The contents of the
 * array depend upon the actions requested by each method (for example
 * `rows().nodes()` will return an array of nodes, while `rows().data()` will
 * return an array of objects or arrays depending upon your table's
 * configuration). The API object has a number of array like methods (`push`,
 * `pop`, `reverse` etc) as well as additional helper methods (`each`, `pluck`,
 * `unique` etc) to assist your working with the data held in a table.
 *
 * Most methods (those which return an Api instance) are chainable, which means
 * the return from a method call also has all of the methods available that the
 * top level object had. For example, these two calls are equivalent:
 *
 *     // Not chained
 *     api.row.add( {...} );
 *     api.draw();
 *
 *     // Chained
 *     api.row.add( {...} ).draw();
 *
 * @class DataTable.Api
 * @param {array|object|string|jQuery} context DataTable identifier. This is
 *   used to define which DataTables enhanced tables this API will operate on.
 *   Can be one of:
 *
 *   * `string` - jQuery selector. Any DataTables' matching the given selector
 *     with be found and used.
 *   * `node` - `TABLE` node which has already been formed into a DataTable.
 *   * `jQuery` - A jQuery object of `TABLE` nodes.
 *   * `object` - DataTables settings object
 * @param {array} [data] Data to initialise the Api instance with.
 *
 * @example
 *   // Direct initialisation during DataTables construction
 *   var api = $('#example').DataTable();
 *
 * @example
 *   // Initialisation using a DataTables jQuery object
 *   var api = $('#example').dataTable().api();
 *
 * @example
 *   // Initialisation as a constructor
 *   var api = new DataTable.Api( 'table.dataTable' );
 */
_Api = function ( context, data )
{
	if ( ! (this instanceof _Api) ) {
		return new _Api( context, data );
	}

	var i;
	var settings = [];
	var ctxSettings = function ( o ) {
		var a = _toSettings( o );
		if ( a ) {
			settings.push.apply( settings, a );
		}
	};

	if ( Array.isArray( context ) ) {
		for ( i=0 ; i<context.length ; i++ ) {
			ctxSettings( context[i] );
		}
	}
	else {
		ctxSettings( context );
	}

	// Remove duplicates
	this.context = settings.length > 1
		? _unique( settings )
		: settings;

	// Initial data
	_fnArrayApply(this, data);

	// selector
	this.selector = {
		rows: null,
		cols: null,
		opts: null
	};

	_Api.extend( this, this, __apiStruct );
};

DataTable.Api = _Api;

// Don't destroy the existing prototype, just extend it. Required for jQuery 2's
// isPlainObject.
$.extend( _Api.prototype, {
	any: function ()
	{
		return this.count() !== 0;
	},

	context: [], // array of table settings objects

	count: function ()
	{
		return this.flatten().length;
	},

	each: function ( fn )
	{
		for ( var i=0, iLen=this.length ; i<iLen; i++ ) {
			fn.call( this, this[i], i, this );
		}

		return this;
	},

	eq: function ( idx )
	{
		var ctx = this.context;

		return ctx.length > idx ?
			new _Api( ctx[idx], this[idx] ) :
			null;
	},

	filter: function ( fn )
	{
		var a = __arrayProto.filter.call( this, fn, this );

		return new _Api( this.context, a );
	},

	flatten: function ()
	{
		var a = [];

		return new _Api( this.context, a.concat.apply( a, this.toArray() ) );
	},

	get: function ( idx )
	{
		return this[ idx ];
	},

	join:    __arrayProto.join,

	includes: function ( find ) {
		return this.indexOf( find ) === -1 ? false : true;
	},

	indexOf: __arrayProto.indexOf,

	iterator: function ( flatten, type, fn, alwaysNew ) {
		var
			a = [], ret,
			i, iLen, j, jen,
			context = this.context,
			rows, items, item,
			selector = this.selector;

		// Argument shifting
		if ( typeof flatten === 'string' ) {
			alwaysNew = fn;
			fn = type;
			type = flatten;
			flatten = false;
		}

		for ( i=0, iLen=context.length ; i<iLen ; i++ ) {
			var apiInst = new _Api( context[i] );

			if ( type === 'table' ) {
				ret = fn.call( apiInst, context[i], i );

				if ( ret !== undefined ) {
					a.push( ret );
				}
			}
			else if ( type === 'columns' || type === 'rows' ) {
				// this has same length as context - one entry for each table
				ret = fn.call( apiInst, context[i], this[i], i );

				if ( ret !== undefined ) {
					a.push( ret );
				}
			}
			else if ( type === 'every' || type === 'column' || type === 'column-rows' || type === 'row' || type === 'cell' ) {
				// columns and rows share the same structure.
				// 'this' is an array of column indexes for each context
				items = this[i];

				if ( type === 'column-rows' ) {
					rows = _selector_row_indexes( context[i], selector.opts );
				}

				for ( j=0, jen=items.length ; j<jen ; j++ ) {
					item = items[j];

					if ( type === 'cell' ) {
						ret = fn.call( apiInst, context[i], item.row, item.column, i, j );
					}
					else {
						ret = fn.call( apiInst, context[i], item, i, j, rows );
					}

					if ( ret !== undefined ) {
						a.push( ret );
					}
				}
			}
		}

		if ( a.length || alwaysNew ) {
			var api = new _Api( context, flatten ? a.concat.apply( [], a ) : a );
			var apiSelector = api.selector;
			apiSelector.rows = selector.rows;
			apiSelector.cols = selector.cols;
			apiSelector.opts = selector.opts;
			return api;
		}
		return this;
	},

	lastIndexOf: __arrayProto.lastIndexOf,

	length:  0,

	map: function ( fn )
	{
		var a = __arrayProto.map.call( this, fn, this );

		return new _Api( this.context, a );
	},

	pluck: function ( prop )
	{
		var fn = DataTable.util.get(prop);

		return this.map( function ( el ) {
			return fn(el);
		} );
	},

	pop:     __arrayProto.pop,

	push:    __arrayProto.push,

	reduce: __arrayProto.reduce,

	reduceRight: __arrayProto.reduceRight,

	reverse: __arrayProto.reverse,

	// Object with rows, columns and opts
	selector: null,

	shift:   __arrayProto.shift,

	slice: function () {
		return new _Api( this.context, this );
	},

	sort:    __arrayProto.sort,

	splice:  __arrayProto.splice,

	toArray: function ()
	{
		return __arrayProto.slice.call( this );
	},

	to$: function ()
	{
		return $( this );
	},

	toJQuery: function ()
	{
		return $( this );
	},

	unique: function ()
	{
		return new _Api( this.context, _unique(this.toArray()) );
	},

	unshift: __arrayProto.unshift
} );


function _api_scope( scope, fn, struct ) {
	return function () {
		var ret = fn.apply( scope || this, arguments );

		// Method extension
		_Api.extend( ret, ret, struct.methodExt );
		return ret;
	};
}

function _api_find( src, name ) {
	for ( var i=0, iLen=src.length ; i<iLen ; i++ ) {
		if ( src[i].name === name ) {
			return src[i];
		}
	}
	return null;
}

window.__apiStruct = __apiStruct;

_Api.extend = function ( scope, obj, ext )
{
	// Only extend API instances and static properties of the API
	if ( ! ext.length || ! obj || ( ! (obj instanceof _Api) && ! obj.__dt_wrapper ) ) {
		return;
	}

	var
		i, iLen,
		struct;

	for ( i=0, iLen=ext.length ; i<iLen ; i++ ) {
		struct = ext[i];

		if (struct.name === '__proto__') {
			continue;
		}

		// Value
		obj[ struct.name ] = struct.type === 'function' ?
			_api_scope( scope, struct.val, struct ) :
			struct.type === 'object' ?
				{} :
				struct.val;

		obj[ struct.name ].__dt_wrapper = true;

		// Property extension
		_Api.extend( scope, obj[ struct.name ], struct.propExt );
	}
};

//     [
//       {
//         name:      'data'                -- string   - Property name
//         val:       function () {},       -- function - Api method (or undefined if just an object
//         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
//         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
//       },
//       {
//         name:     'row'
//         val:       {},
//         methodExt: [ ... ],
//         propExt:   [
//           {
//             name:      'data'
//             val:       function () {},
//             methodExt: [ ... ],
//             propExt:   [ ... ]
//           },
//           ...
//         ]
//       }
//     ]


_Api.register = _api_register = function ( name, val )
{
	if ( Array.isArray( name ) ) {
		for ( var j=0, jen=name.length ; j<jen ; j++ ) {
			_Api.register( name[j], val );
		}
		return;
	}

	var
		i, iLen,
		heir = name.split('.'),
		struct = __apiStruct,
		key, method;

	for ( i=0, iLen=heir.length ; i<iLen ; i++ ) {
		method = heir[i].indexOf('()') !== -1;
		key = method ?
			heir[i].replace('()', '') :
			heir[i];

		var src = _api_find( struct, key );
		if ( ! src ) {
			src = {
				name:      key,
				val:       {},
				methodExt: [],
				propExt:   [],
				type:      'object'
			};
			struct.push( src );
		}

		if ( i === iLen-1 ) {
			src.val = val;
			src.type = typeof val === 'function' ?
				'function' :
				$.isPlainObject( val ) ?
					'object' :
					'other';
		}
		else {
			struct = method ?
				src.methodExt :
				src.propExt;
		}
	}
};

_Api.registerPlural = _api_registerPlural = function ( pluralName, singularName, val ) {
	_Api.register( pluralName, val );

	_Api.register( singularName, function () {
		var ret = val.apply( this, arguments );

		if ( ret === this ) {
			// Returned item is the API instance that was passed in, return it
			return this;
		}
		else if ( ret instanceof _Api ) {
			// New API instance returned, want the value from the first item
			// in the returned array for the singular result.
			return ret.length ?
				Array.isArray( ret[0] ) ?
					new _Api( ret.context, ret[0] ) : // Array results are 'enhanced'
					ret[0] :
				undefined;
		}

		// Non-API return - just fire it back
		return ret;
	} );
};


/**
 * Selector for HTML tables. Apply the given selector to the give array of
 * DataTables settings objects.
 *
 * @param {string|integer} [selector] jQuery selector string or integer
 * @param  {array} Array of DataTables settings objects to be filtered
 * @return {array}
 * @ignore
 */
var __table_selector = function ( selector, a )
{
	if ( Array.isArray(selector) ) {
		var result = [];

		selector.forEach(function (sel) {
			var inner = __table_selector(sel, a);

			_fnArrayApply(result, inner);
		});

		return result.filter( function (item) {
			return item;
		});
	}

	// Integer is used to pick out a table by index
	if ( typeof selector === 'number' ) {
		return [ a[ selector ] ];
	}

	// Perform a jQuery selector on the table nodes
	var nodes = a.map( function (el) {
		return el.nTable;
	} );

	return $(nodes)
		.filter( selector )
		.map( function () {
			// Need to translate back from the table node to the settings
			var idx = nodes.indexOf(this);
			return a[ idx ];
		} )
		.toArray();
};



/**
 * Context selector for the API's context (i.e. the tables the API instance
 * refers to.
 *
 * @name    DataTable.Api#tables
 * @param {string|integer} [selector] Selector to pick which tables the iterator
 *   should operate on. If not given, all tables in the current context are
 *   used. This can be given as a jQuery selector (for example `':gt(0)'`) to
 *   select multiple tables or as an integer to select a single table.
 * @returns {DataTable.Api} Returns a new API instance if a selector is given.
 */
_api_register( 'tables()', function ( selector ) {
	// A new instance is created if there was a selector specified
	return selector !== undefined && selector !== null ?
		new _Api( __table_selector( selector, this.context ) ) :
		this;
} );


_api_register( 'table()', function ( selector ) {
	var tables = this.tables( selector );
	var ctx = tables.context;

	// Truncate to the first matched table
	return ctx.length ?
		new _Api( ctx[0] ) :
		tables;
} );

// Common methods, combined to reduce size
[
	['nodes', 'node', 'nTable'],
	['body', 'body', 'nTBody'],
	['header', 'header', 'nTHead'],
	['footer', 'footer', 'nTFoot'],
].forEach(function (item) {
	_api_registerPlural(
		'tables().' + item[0] + '()',
		'table().' + item[1] + '()' ,
		function () {
			return this.iterator( 'table', function ( ctx ) {
				return ctx[item[2]];
			}, 1 );
		}
	);
});

// Structure methods
[
	['header', 'aoHeader'],
	['footer', 'aoFooter'],
].forEach(function (item) {
	_api_register( 'table().' + item[0] + '.structure()' , function (selector) {
		var indexes = this.columns(selector).indexes().flatten().toArray();
		var ctx = this.context[0];
		var structure = _fnHeaderLayout(ctx, ctx[item[1]], indexes);

		// The structure is in column index order - but from this method we want the return to be
		// in the columns() selector API order. In order to do that we need to map from one form
		// to the other
		var orderedIndexes = indexes.slice().sort(function (a, b) {
			return a - b;
		});

		return structure.map(function (row) {
			return indexes.map(function (colIdx) {
				return row[orderedIndexes.indexOf(colIdx)];
			});
		});
	});
});


_api_registerPlural( 'tables().containers()', 'table().container()' , function () {
	return this.iterator( 'table', function ( ctx ) {
		return ctx.nTableWrapper;
	}, 1 );
} );

_api_register( 'tables().every()', function ( fn ) {
	var that = this;

	return this.iterator('table', function (s, i) {
		fn.call(that.table(i), i);
	});
});

_api_register( 'caption()', function ( value, side ) {
	var context = this.context;

	// Getter - return existing node's content
	if ( value === undefined ) {
		var caption = context[0].captionNode;

		return caption && context.length ?
			caption.innerHTML : 
			null;
	}

	return this.iterator( 'table', function ( ctx ) {
		var table = $(ctx.nTable);
		var caption = $(ctx.captionNode);
		var container = $(ctx.nTableWrapper);

		// Create the node if it doesn't exist yet
		if ( ! caption.length ) {
			caption = $('<caption/>').html( value );
			ctx.captionNode = caption[0];

			// If side isn't set, we need to insert into the document to let the
			// CSS decide so we can read it back, otherwise there is no way to
			// know if the CSS would put it top or bottom for scrolling
			if (! side) {
				table.prepend(caption);

				side = caption.css('caption-side');
			}
		}

		caption.html( value );

		if ( side ) {
			caption.css( 'caption-side', side );
			caption[0]._captionSide = side;
		}

		if (container.find('div.dataTables_scroll').length) {
			var selector = (side === 'top' ? 'Head' : 'Foot');

			container.find('div.dataTables_scroll'+ selector +' table').prepend(caption);
		}
		else {
			table.prepend(caption);
		}
	}, 1 );
} );

_api_register( 'caption.node()', function () {
	var ctx = this.context;

	return ctx.length ? ctx[0].captionNode : null;
} );


/**
 * Redraw the tables in the current context.
 */
_api_register( 'draw()', function ( paging ) {
	return this.iterator( 'table', function ( settings ) {
		if ( paging === 'page' ) {
			_fnDraw( settings );
		}
		else {
			if ( typeof paging === 'string' ) {
				paging = paging === 'full-hold' ?
					false :
					true;
			}

			_fnReDraw( settings, paging===false );
		}
	} );
} );



/**
 * Get the current page index.
 *
 * @return {integer} Current page index (zero based)
 *//**
 * Set the current page.
 *
 * Note that if you attempt to show a page which does not exist, DataTables will
 * not throw an error, but rather reset the paging.
 *
 * @param {integer|string} action The paging action to take. This can be one of:
 *  * `integer` - The page index to jump to
 *  * `string` - An action to take:
 *    * `first` - Jump to first page.
 *    * `next` - Jump to the next page
 *    * `previous` - Jump to previous page
 *    * `last` - Jump to the last page.
 * @returns {DataTables.Api} this
 */
_api_register( 'page()', function ( action ) {
	if ( action === undefined ) {
		return this.page.info().page; // not an expensive call
	}

	// else, have an action to take on all tables
	return this.iterator( 'table', function ( settings ) {
		_fnPageChange( settings, action );
	} );
} );


/**
 * Paging information for the first table in the current context.
 *
 * If you require paging information for another table, use the `table()` method
 * with a suitable selector.
 *
 * @return {object} Object with the following properties set:
 *  * `page` - Current page index (zero based - i.e. the first page is `0`)
 *  * `pages` - Total number of pages
 *  * `start` - Display index for the first record shown on the current page
 *  * `end` - Display index for the last record shown on the current page
 *  * `length` - Display length (number of records). Note that generally `start
 *    + length = end`, but this is not always true, for example if there are
 *    only 2 records to show on the final page, with a length of 10.
 *  * `recordsTotal` - Full data set length
 *  * `recordsDisplay` - Data set length once the current filtering criterion
 *    are applied.
 */
_api_register( 'page.info()', function () {
	if ( this.context.length === 0 ) {
		return undefined;
	}

	var
		settings   = this.context[0],
		start      = settings._iDisplayStart,
		len        = settings.oFeatures.bPaginate ? settings._iDisplayLength : -1,
		visRecords = settings.fnRecordsDisplay(),
		all        = len === -1;

	return {
		"page":           all ? 0 : Math.floor( start / len ),
		"pages":          all ? 1 : Math.ceil( visRecords / len ),
		"start":          start,
		"end":            settings.fnDisplayEnd(),
		"length":         len,
		"recordsTotal":   settings.fnRecordsTotal(),
		"recordsDisplay": visRecords,
		"serverSide":     _fnDataSource( settings ) === 'ssp'
	};
} );


/**
 * Get the current page length.
 *
 * @return {integer} Current page length. Note `-1` indicates that all records
 *   are to be shown.
 *//**
 * Set the current page length.
 *
 * @param {integer} Page length to set. Use `-1` to show all records.
 * @returns {DataTables.Api} this
 */
_api_register( 'page.len()', function ( len ) {
	// Note that we can't call this function 'length()' because `length`
	// is a JavaScript property of functions which defines how many arguments
	// the function expects.
	if ( len === undefined ) {
		return this.context.length !== 0 ?
			this.context[0]._iDisplayLength :
			undefined;
	}

	// else, set the page length
	return this.iterator( 'table', function ( settings ) {
		_fnLengthChange( settings, len );
	} );
} );



var __reload = function ( settings, holdPosition, callback ) {
	// Use the draw event to trigger a callback
	if ( callback ) {
		var api = new _Api( settings );

		api.one( 'draw', function () {
			callback( api.ajax.json() );
		} );
	}

	if ( _fnDataSource( settings ) == 'ssp' ) {
		_fnReDraw( settings, holdPosition );
	}
	else {
		_fnProcessingDisplay( settings, true );

		// Cancel an existing request
		var xhr = settings.jqXHR;
		if ( xhr && xhr.readyState !== 4 ) {
			xhr.abort();
		}

		// Trigger xhr
		_fnBuildAjax( settings, {}, function( json ) {
			_fnClearTable( settings );

			var data = _fnAjaxDataSrc( settings, json );
			for ( var i=0, iLen=data.length ; i<iLen ; i++ ) {
				_fnAddData( settings, data[i] );
			}

			_fnReDraw( settings, holdPosition );
			_fnInitComplete( settings );
			_fnProcessingDisplay( settings, false );
		} );
	}
};


/**
 * Get the JSON response from the last Ajax request that DataTables made to the
 * server. Note that this returns the JSON from the first table in the current
 * context.
 *
 * @return {object} JSON received from the server.
 */
_api_register( 'ajax.json()', function () {
	var ctx = this.context;

	if ( ctx.length > 0 ) {
		return ctx[0].json;
	}

	// else return undefined;
} );


/**
 * Get the data submitted in the last Ajax request
 */
_api_register( 'ajax.params()', function () {
	var ctx = this.context;

	if ( ctx.length > 0 ) {
		return ctx[0].oAjaxData;
	}

	// else return undefined;
} );


/**
 * Reload tables from the Ajax data source. Note that this function will
 * automatically re-draw the table when the remote data has been loaded.
 *
 * @param {boolean} [reset=true] Reset (default) or hold the current paging
 *   position. A full re-sort and re-filter is performed when this method is
 *   called, which is why the pagination reset is the default action.
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.reload()', function ( callback, resetPaging ) {
	return this.iterator( 'table', function (settings) {
		__reload( settings, resetPaging===false, callback );
	} );
} );


/**
 * Get the current Ajax URL. Note that this returns the URL from the first
 * table in the current context.
 *
 * @return {string} Current Ajax source URL
 *//**
 * Set the Ajax URL. Note that this will set the URL for all tables in the
 * current context.
 *
 * @param {string} url URL to set.
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.url()', function ( url ) {
	var ctx = this.context;

	if ( url === undefined ) {
		// get
		if ( ctx.length === 0 ) {
			return undefined;
		}
		ctx = ctx[0];

		return $.isPlainObject( ctx.ajax ) ?
			ctx.ajax.url :
			ctx.ajax;
	}

	// set
	return this.iterator( 'table', function ( settings ) {
		if ( $.isPlainObject( settings.ajax ) ) {
			settings.ajax.url = url;
		}
		else {
			settings.ajax = url;
		}
	} );
} );


/**
 * Load data from the newly set Ajax URL. Note that this method is only
 * available when `ajax.url()` is used to set a URL. Additionally, this method
 * has the same effect as calling `ajax.reload()` but is provided for
 * convenience when setting a new URL. Like `ajax.reload()` it will
 * automatically redraw the table once the remote data has been loaded.
 *
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.url().load()', function ( callback, resetPaging ) {
	// Same as a reload, but makes sense to present it for easy access after a
	// url change
	return this.iterator( 'table', function ( ctx ) {
		__reload( ctx, resetPaging===false, callback );
	} );
} );




var _selector_run = function ( type, selector, selectFn, settings, opts )
{
	var
		out = [], res,
		i, iLen,
		selectorType = typeof selector;

	// Can't just check for isArray here, as an API or jQuery instance might be
	// given with their array like look
	if ( ! selector || selectorType === 'string' || selectorType === 'function' || selector.length === undefined ) {
		selector = [ selector ];
	}

	for ( i=0, iLen=selector.length ; i<iLen ; i++ ) {
		res = selectFn( typeof selector[i] === 'string' ? selector[i].trim() : selector[i] );

		// Remove empty items
		res = res.filter( function (item) {
			return item !== null && item !== undefined;
		});

		if ( res && res.length ) {
			out = out.concat( res );
		}
	}

	// selector extensions
	var ext = _ext.selector[ type ];
	if ( ext.length ) {
		for ( i=0, iLen=ext.length ; i<iLen ; i++ ) {
			out = ext[i]( settings, opts, out );
		}
	}

	return _unique( out );
};


var _selector_opts = function ( opts )
{
	if ( ! opts ) {
		opts = {};
	}

	// Backwards compatibility for 1.9- which used the terminology filter rather
	// than search
	if ( opts.filter && opts.search === undefined ) {
		opts.search = opts.filter;
	}

	return $.extend( {
		columnOrder: 'implied',
		search: 'none',
		order: 'current',
		page: 'all'
	}, opts );
};


// Reduce the API instance to the first item found
var _selector_first = function ( old )
{
	var inst = new _Api(old.context[0]);

	// Use a push rather than passing to the constructor, since it will
	// merge arrays down automatically, which isn't what is wanted here
	if (old.length) {
		inst.push( old[0] );
	}

	inst.selector = old.selector;

	// Limit to a single row / column / cell
	if (inst.length && inst[0].length > 1) {
		inst[0].splice(1);
	}

	return inst;
};


var _selector_row_indexes = function ( settings, opts )
{
	var
		i, iLen, tmp, a=[],
		displayFiltered = settings.aiDisplay,
		displayMaster = settings.aiDisplayMaster;

	var
		search = opts.search,  // none, applied, removed
		order  = opts.order,   // applied, current, index (original - compatibility with 1.9)
		page   = opts.page;    // all, current

	if ( _fnDataSource( settings ) == 'ssp' ) {
		// In server-side processing mode, most options are irrelevant since
		// rows not shown don't exist and the index order is the applied order
		// Removed is a special case - for consistency just return an empty
		// array
		return search === 'removed' ?
			[] :
			_range( 0, displayMaster.length );
	}

	if ( page == 'current' ) {
		// Current page implies that order=current and filter=applied, since it is
		// fairly senseless otherwise, regardless of what order and search actually
		// are
		for ( i=settings._iDisplayStart, iLen=settings.fnDisplayEnd() ; i<iLen ; i++ ) {
			a.push( displayFiltered[i] );
		}
	}
	else if ( order == 'current' || order == 'applied' ) {
		if ( search == 'none') {
			a = displayMaster.slice();
		}
		else if ( search == 'applied' ) {
			a = displayFiltered.slice();
		}
		else if ( search == 'removed' ) {
			// O(n+m) solution by creating a hash map
			var displayFilteredMap = {};

			for ( i=0, iLen=displayFiltered.length ; i<iLen ; i++ ) {
				displayFilteredMap[displayFiltered[i]] = null;
			}

			displayMaster.forEach(function (item) {
				if (! Object.prototype.hasOwnProperty.call(displayFilteredMap, item)) {
					a.push(item);
				}
			});
		}
	}
	else if ( order == 'index' || order == 'original' ) {
		for ( i=0, iLen=settings.aoData.length ; i<iLen ; i++ ) {
			if (! settings.aoData[i]) {
				continue;
			}

			if ( search == 'none' ) {
				a.push( i );
			}
			else { // applied | removed
				tmp = displayFiltered.indexOf(i);

				if ((tmp === -1 && search == 'removed') ||
					(tmp >= 0   && search == 'applied') )
				{
					a.push( i );
				}
			}
		}
	}
	else if ( typeof order === 'number' ) {
		// Order the rows by the given column
		var ordered = _fnSort(settings, order, 'asc');

		if (search === 'none') {
			a = ordered;
		}
		else { // applied | removed
			for (i=0; i<ordered.length; i++) {
				tmp = displayFiltered.indexOf(ordered[i]);

				if ((tmp === -1 && search == 'removed') ||
					(tmp >= 0   && search == 'applied') )
				{
					a.push( ordered[i] );
				}
			}
		}
	}

	return a;
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Rows
 *
 * {}          - no selector - use all available rows
 * {integer}   - row aoData index
 * {node}      - TR node
 * {string}    - jQuery selector to apply to the TR elements
 * {array}     - jQuery array of nodes, or simply an array of TR nodes
 *
 */
var __row_selector = function ( settings, selector, opts )
{
	var rows;
	var run = function ( sel ) {
		var selInt = _intVal( sel );
		var aoData = settings.aoData;

		// Short cut - selector is a number and no options provided (default is
		// all records, so no need to check if the index is in there, since it
		// must be - dev error if the index doesn't exist).
		if ( selInt !== null && ! opts ) {
			return [ selInt ];
		}

		if ( ! rows ) {
			rows = _selector_row_indexes( settings, opts );
		}

		if ( selInt !== null && rows.indexOf(selInt) !== -1 ) {
			// Selector - integer
			return [ selInt ];
		}
		else if ( sel === null || sel === undefined || sel === '' ) {
			// Selector - none
			return rows;
		}

		// Selector - function
		if ( typeof sel === 'function' ) {
			return rows.map( function (idx) {
				var row = aoData[ idx ];
				return sel( idx, row._aData, row.nTr ) ? idx : null;
			} );
		}

		// Selector - node
		if ( sel.nodeName ) {
			var rowIdx = sel._DT_RowIndex;  // Property added by DT for fast lookup
			var cellIdx = sel._DT_CellIndex;

			if ( rowIdx !== undefined ) {
				// Make sure that the row is actually still present in the table
				return aoData[ rowIdx ] && aoData[ rowIdx ].nTr === sel ?
					[ rowIdx ] :
					[];
			}
			else if ( cellIdx ) {
				return aoData[ cellIdx.row ] && aoData[ cellIdx.row ].nTr === sel.parentNode ?
					[ cellIdx.row ] :
					[];
			}
			else {
				var host = $(sel).closest('*[data-dt-row]');
				return host.length ?
					[ host.data('dt-row') ] :
					[];
			}
		}

		// ID selector. Want to always be able to select rows by id, regardless
		// of if the tr element has been created or not, so can't rely upon
		// jQuery here - hence a custom implementation. This does not match
		// Sizzle's fast selector or HTML4 - in HTML5 the ID can be anything,
		// but to select it using a CSS selector engine (like Sizzle or
		// querySelect) it would need to need to be escaped for some characters.
		// DataTables simplifies this for row selectors since you can select
		// only a row. A # indicates an id any anything that follows is the id -
		// unescaped.
		if ( typeof sel === 'string' && sel.charAt(0) === '#' ) {
			// get row index from id
			var rowObj = settings.aIds[ sel.replace( /^#/, '' ) ];
			if ( rowObj !== undefined ) {
				return [ rowObj.idx ];
			}

			// need to fall through to jQuery in case there is DOM id that
			// matches
		}
		
		// Get nodes in the order from the `rows` array with null values removed
		var nodes = _removeEmpty(
			_pluck_order( settings.aoData, rows, 'nTr' )
		);

		// Selector - jQuery selector string, array of nodes or jQuery object/
		// As jQuery's .filter() allows jQuery objects to be passed in filter,
		// it also allows arrays, so this will cope with all three options
		return $(nodes)
			.filter( sel )
			.map( function () {
				return this._DT_RowIndex;
			} )
			.toArray();
	};

	var matched = _selector_run( 'row', selector, run, settings, opts );

	if (opts.order === 'current' || opts.order === 'applied') {
		_fnSortDisplay(settings, matched);
	}

	return matched;
};


_api_register( 'rows()', function ( selector, opts ) {
	// argument shifting
	if ( selector === undefined ) {
		selector = '';
	}
	else if ( $.isPlainObject( selector ) ) {
		opts = selector;
		selector = '';
	}

	opts = _selector_opts( opts );

	var inst = this.iterator( 'table', function ( settings ) {
		return __row_selector( settings, selector, opts );
	}, 1 );

	// Want argument shifting here and in __row_selector?
	inst.selector.rows = selector;
	inst.selector.opts = opts;

	return inst;
} );

_api_register( 'rows().nodes()', function () {
	return this.iterator( 'row', function ( settings, row ) {
		return settings.aoData[ row ].nTr || undefined;
	}, 1 );
} );

_api_register( 'rows().data()', function () {
	return this.iterator( true, 'rows', function ( settings, rows ) {
		return _pluck_order( settings.aoData, rows, '_aData' );
	}, 1 );
} );

_api_registerPlural( 'rows().cache()', 'row().cache()', function ( type ) {
	return this.iterator( 'row', function ( settings, row ) {
		var r = settings.aoData[ row ];
		return type === 'search' ? r._aFilterData : r._aSortData;
	}, 1 );
} );

_api_registerPlural( 'rows().invalidate()', 'row().invalidate()', function ( src ) {
	return this.iterator( 'row', function ( settings, row ) {
		_fnInvalidate( settings, row, src );
	} );
} );

_api_registerPlural( 'rows().indexes()', 'row().index()', function () {
	return this.iterator( 'row', function ( settings, row ) {
		return row;
	}, 1 );
} );

_api_registerPlural( 'rows().ids()', 'row().id()', function ( hash ) {
	var a = [];
	var context = this.context;

	// `iterator` will drop undefined values, but in this case we want them
	for ( var i=0, iLen=context.length ; i<iLen ; i++ ) {
		for ( var j=0, jen=this[i].length ; j<jen ; j++ ) {
			var id = context[i].rowIdFn( context[i].aoData[ this[i][j] ]._aData );
			a.push( (hash === true ? '#' : '' )+ id );
		}
	}

	return new _Api( context, a );
} );

_api_registerPlural( 'rows().remove()', 'row().remove()', function () {
	this.iterator( 'row', function ( settings, row ) {
		var data = settings.aoData;
		var rowData = data[ row ];

		// Delete from the display arrays
		var idx = settings.aiDisplayMaster.indexOf(row);
		if (idx !== -1) {
			settings.aiDisplayMaster.splice(idx, 1);
		}

		// For server-side processing tables - subtract the deleted row from the count
		if ( settings._iRecordsDisplay > 0 ) {
			settings._iRecordsDisplay--;
		}

		// Check for an 'overflow' they case for displaying the table
		_fnLengthOverflow( settings );

		// Remove the row's ID reference if there is one
		var id = settings.rowIdFn( rowData._aData );
		if ( id !== undefined ) {
			delete settings.aIds[ id ];
		}

		data[row] = null;
	} );

	return this;
} );


_api_register( 'rows.add()', function ( rows ) {
	var newRows = this.iterator( 'table', function ( settings ) {
			var row, i, iLen;
			var out = [];

			for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
				row = rows[i];

				if ( row.nodeName && row.nodeName.toUpperCase() === 'TR' ) {
					out.push( _fnAddTr( settings, row )[0] );
				}
				else {
					out.push( _fnAddData( settings, row ) );
				}
			}

			return out;
		}, 1 );

	// Return an Api.rows() extended instance, so rows().nodes() etc can be used
	var modRows = this.rows( -1 );
	modRows.pop();
	_fnArrayApply(modRows, newRows);

	return modRows;
} );





/**
 *
 */
_api_register( 'row()', function ( selector, opts ) {
	return _selector_first( this.rows( selector, opts ) );
} );


_api_register( 'row().data()', function ( data ) {
	var ctx = this.context;

	if ( data === undefined ) {
		// Get
		return ctx.length && this.length && this[0].length ?
			ctx[0].aoData[ this[0] ]._aData :
			undefined;
	}

	// Set
	var row = ctx[0].aoData[ this[0] ];
	row._aData = data;

	// If the DOM has an id, and the data source is an array
	if ( Array.isArray( data ) && row.nTr && row.nTr.id ) {
		_fnSetObjectDataFn( ctx[0].rowId )( data, row.nTr.id );
	}

	// Automatically invalidate
	_fnInvalidate( ctx[0], this[0], 'data' );

	return this;
} );


_api_register( 'row().node()', function () {
	var ctx = this.context;

	if (ctx.length && this.length && this[0].length) {
		var row = ctx[0].aoData[ this[0] ];

		if (row && row.nTr) {
			return row.nTr;
		}
	}

	return null;
} );


_api_register( 'row.add()', function ( row ) {
	// Allow a jQuery object to be passed in - only a single row is added from
	// it though - the first element in the set
	if ( row instanceof $ && row.length ) {
		row = row[0];
	}

	var rows = this.iterator( 'table', function ( settings ) {
		if ( row.nodeName && row.nodeName.toUpperCase() === 'TR' ) {
			return _fnAddTr( settings, row )[0];
		}
		return _fnAddData( settings, row );
	} );

	// Return an Api.rows() extended instance, with the newly added row selected
	return this.row( rows[0] );
} );


$(document).on('plugin-init.dt', function (e, context) {
	var api = new _Api( context );

	api.on( 'stateSaveParams.DT', function ( e, settings, d ) {
		// This could be more compact with the API, but it is a lot faster as a simple
		// internal loop
		var idFn = settings.rowIdFn;
		var rows = settings.aiDisplayMaster;
		var ids = [];

		for (var i=0 ; i<rows.length ; i++) {
			var rowIdx = rows[i];
			var data = settings.aoData[rowIdx];

			if (data._detailsShow) {
				ids.push( '#' + idFn(data._aData) );
			}
		}

		d.childRows = ids;
	});

	// For future state loads (e.g. with StateRestore)
	api.on( 'stateLoaded.DT', function (e, settings, state) {
		__details_state_load( api, state );
	});

	// And the initial load state
	__details_state_load( api, api.state.loaded() );
});

var __details_state_load = function (api, state)
{
	if ( state && state.childRows ) {
		api
			.rows( state.childRows.map(function (id) {
				// Escape any `:` characters from the row id. Accounts for
				// already escaped characters.
				return id.replace(/([^:\\]*(?:\\.[^:\\]*)*):/g, "$1\\:");
			}) )
			.every( function () {
				_fnCallbackFire( api.settings()[0], null, 'requestChild', [ this ] )
			});
	}
}

var __details_add = function ( ctx, row, data, klass )
{
	// Convert to array of TR elements
	var rows = [];
	var addRow = function ( r, k ) {
		// Recursion to allow for arrays of jQuery objects
		if ( Array.isArray( r ) || r instanceof $ ) {
			for ( var i=0, iLen=r.length ; i<iLen ; i++ ) {
				addRow( r[i], k );
			}
			return;
		}

		// If we get a TR element, then just add it directly - up to the dev
		// to add the correct number of columns etc
		if ( r.nodeName && r.nodeName.toLowerCase() === 'tr' ) {
			r.setAttribute( 'data-dt-row', row.idx );
			rows.push( r );
		}
		else {
			// Otherwise create a row with a wrapper
			var created = $('<tr><td></td></tr>')
				.attr( 'data-dt-row', row.idx )
				.addClass( k );
			
			$('td', created)
				.addClass( k )
				.html( r )[0].colSpan = _fnVisibleColumns( ctx );

			rows.push( created[0] );
		}
	};

	addRow( data, klass );

	if ( row._details ) {
		row._details.detach();
	}

	row._details = $(rows);

	// If the children were already shown, that state should be retained
	if ( row._detailsShow ) {
		row._details.insertAfter( row.nTr );
	}
};


// Make state saving of child row details async to allow them to be batch processed
var __details_state = DataTable.util.throttle(
	function (ctx) {
		_fnSaveState( ctx[0] )
	},
	500
);


var __details_remove = function ( api, idx )
{
	var ctx = api.context;

	if ( ctx.length ) {
		var row = ctx[0].aoData[ idx !== undefined ? idx : api[0] ];

		if ( row && row._details ) {
			row._details.detach();

			row._detailsShow = undefined;
			row._details = undefined;
			$( row.nTr ).removeClass( 'dt-hasChild' );
			__details_state( ctx );
		}
	}
};


var __details_display = function ( api, show ) {
	var ctx = api.context;

	if ( ctx.length && api.length ) {
		var row = ctx[0].aoData[ api[0] ];

		if ( row._details ) {
			row._detailsShow = show;

			if ( show ) {
				row._details.insertAfter( row.nTr );
				$( row.nTr ).addClass( 'dt-hasChild' );
			}
			else {
				row._details.detach();
				$( row.nTr ).removeClass( 'dt-hasChild' );
			}

			_fnCallbackFire( ctx[0], null, 'childRow', [ show, api.row( api[0] ) ] )

			__details_events( ctx[0] );
			__details_state( ctx );
		}
	}
};


var __details_events = function ( settings )
{
	var api = new _Api( settings );
	var namespace = '.dt.DT_details';
	var drawEvent = 'draw'+namespace;
	var colvisEvent = 'column-sizing'+namespace;
	var destroyEvent = 'destroy'+namespace;
	var data = settings.aoData;

	api.off( drawEvent +' '+ colvisEvent +' '+ destroyEvent );

	if ( _pluck( data, '_details' ).length > 0 ) {
		// On each draw, insert the required elements into the document
		api.on( drawEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			api.rows( {page:'current'} ).eq(0).each( function (idx) {
				// Internal data grab
				var row = data[ idx ];

				if ( row._detailsShow ) {
					row._details.insertAfter( row.nTr );
				}
			} );
		} );

		// Column visibility change - update the colspan
		api.on( colvisEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			// Update the colspan for the details rows (note, only if it already has
			// a colspan)
			var row, visible = _fnVisibleColumns( ctx );

			for ( var i=0, iLen=data.length ; i<iLen ; i++ ) {
				row = data[i];

				if ( row && row._details ) {
					row._details.each(function () {
						var el = $(this).children('td');

						if (el.length == 1) {
							el.attr('colspan', visible);
						}
					});
				}
			}
		} );

		// Table destroyed - nuke any child rows
		api.on( destroyEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			for ( var i=0, iLen=data.length ; i<iLen ; i++ ) {
				if ( data[i] && data[i]._details ) {
					__details_remove( api, i );
				}
			}
		} );
	}
};

// Strings for the method names to help minification
var _emp = '';
var _child_obj = _emp+'row().child';
var _child_mth = _child_obj+'()';

// data can be:
//  tr
//  string
//  jQuery or array of any of the above
_api_register( _child_mth, function ( data, klass ) {
	var ctx = this.context;

	if ( data === undefined ) {
		// get
		return ctx.length && this.length && ctx[0].aoData[ this[0] ]
			? ctx[0].aoData[ this[0] ]._details
			: undefined;
	}
	else if ( data === true ) {
		// show
		this.child.show();
	}
	else if ( data === false ) {
		// remove
		__details_remove( this );
	}
	else if ( ctx.length && this.length ) {
		// set
		__details_add( ctx[0], ctx[0].aoData[ this[0] ], data, klass );
	}

	return this;
} );


_api_register( [
	_child_obj+'.show()',
	_child_mth+'.show()' // only when `child()` was called with parameters (without
], function () {         // it returns an object and this method is not executed)
	__details_display( this, true );
	return this;
} );


_api_register( [
	_child_obj+'.hide()',
	_child_mth+'.hide()' // only when `child()` was called with parameters (without
], function () {         // it returns an object and this method is not executed)
	__details_display( this, false );
	return this;
} );


_api_register( [
	_child_obj+'.remove()',
	_child_mth+'.remove()' // only when `child()` was called with parameters (without
], function () {           // it returns an object and this method is not executed)
	__details_remove( this );
	return this;
} );


_api_register( _child_obj+'.isShown()', function () {
	var ctx = this.context;

	if ( ctx.length && this.length && ctx[0].aoData[ this[0] ] ) {
		// _detailsShown as false or undefined will fall through to return false
		return ctx[0].aoData[ this[0] ]._detailsShow || false;
	}
	return false;
} );



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Columns
 *
 * {integer}           - column index (>=0 count from left, <0 count from right)
 * "{integer}:visIdx"  - visible column index (i.e. translate to column index)  (>=0 count from left, <0 count from right)
 * "{integer}:visible" - alias for {integer}:visIdx  (>=0 count from left, <0 count from right)
 * "{string}:name"     - column name
 * "{string}"          - jQuery selector on column header nodes
 *
 */

// can be an array of these items, comma separated list, or an array of comma
// separated lists

var __re_column_selector = /^([^:]+)?:(name|title|visIdx|visible)$/;


// r1 and r2 are redundant - but it means that the parameters match for the
// iterator callback in columns().data()
var __columnData = function ( settings, column, r1, r2, rows, type ) {
	var a = [];
	for ( var row=0, iLen=rows.length ; row<iLen ; row++ ) {
		a.push( _fnGetCellData( settings, rows[row], column, type ) );
	}
	return a;
};


var __column_header = function ( settings, column, row ) {
	var header = settings.aoHeader;
	var titleRow = settings.titleRow;
	var target = null;

	if (row !== undefined) {
		target = row;
	}
	else if (titleRow === true) { // legacy orderCellsTop support
		target = 0;
	}
	else if (titleRow === false) {
		target = header.length - 1;
	}
	else if (titleRow !== null) {
		target = titleRow;
	}
	else {
		// Automatic - find the _last_ unique cell from the top that is not empty (last for
		// backwards compatibility)
		for (var i=0 ; i<header.length ; i++) {
			if (header[i][column].unique && $('.dt-column-title', header[i][column].cell).text()) {
				target = i;
			}
		}

		if (target === null) {
			target = 0;
		}
	}

	return header[target][column].cell;
};

var __column_header_cells = function (header) {
	var out = [];

	for (var i=0 ; i<header.length ; i++) {
		for (var j=0 ; j<header[i].length ; j++) {
			var cell = header[i][j].cell;

			if (!out.includes(cell)) {
				out.push(cell);
			}
		}
	}

	return out;
}

var __column_selector = function ( settings, selector, opts )
{
	var
		columns = settings.aoColumns,
		names, titles,
		nodes = __column_header_cells(settings.aoHeader);
	
	var run = function ( s ) {
		var selInt = _intVal( s );

		// Selector - all
		if ( s === '' ) {
			return _range( columns.length );
		}

		// Selector - index
		if ( selInt !== null ) {
			return [ selInt >= 0 ?
				selInt : // Count from left
				columns.length + selInt // Count from right (+ because its a negative value)
			];
		}

		// Selector = function
		if ( typeof s === 'function' ) {
			var rows = _selector_row_indexes( settings, opts );

			return columns.map(function (col, idx) {
				return s(
						idx,
						__columnData( settings, idx, 0, 0, rows ),
						__column_header( settings, idx )
					) ? idx : null;
			});
		}

		// jQuery or string selector
		var match = typeof s === 'string' ?
			s.match( __re_column_selector ) :
			'';

		if ( match ) {
			switch( match[2] ) {
				case 'visIdx':
				case 'visible':
					// Selector is a column index
					if (match[1] && match[1].match(/^\d+$/)) {
						var idx = parseInt( match[1], 10 );

						// Visible index given, convert to column index
						if ( idx < 0 ) {
							// Counting from the right
							var visColumns = columns.map( function (col,i) {
								return col.bVisible ? i : null;
							} );
							return [ visColumns[ visColumns.length + idx ] ];
						}
						// Counting from the left
						return [ _fnVisibleToColumnIndex( settings, idx ) ];
					}
					
					return columns.map( function (col, idx) {
						// Not visible, can't match
						if (! col.bVisible) {
							return null;
						}

						// Selector
						if (match[1]) {
							return $(nodes[idx]).filter(match[1]).length > 0 ? idx : null;
						}

						// `:visible` on its own
						return idx;
					} );

				case 'name':
					// Don't get names, unless needed, and only get once if it is
					if (!names) {
						names = _pluck( columns, 'sName' );
					}

					// match by name. `names` is column index complete and in order
					return names.map( function (name, i) {
						return name === match[1] ? i : null;
					} );

				case 'title':
					if (!titles) {
						titles = _pluck( columns, 'sTitle' );
					}

					// match by column title
					return titles.map( function (title, i) {
						return title === match[1] ? i : null;
					} );

				default:
					return [];
			}
		}

		// Cell in the table body
		if ( s.nodeName && s._DT_CellIndex ) {
			return [ s._DT_CellIndex.column ];
		}

		// jQuery selector on the TH elements for the columns
		var jqResult = $( nodes )
			.filter( s )
			.map( function () {
				return _fnColumnsFromHeader( this ); // `nodes` is column index complete and in order
			} )
			.toArray()
			.sort(function (a, b) {
				return a - b;
			});

		if ( jqResult.length || ! s.nodeName ) {
			return jqResult;
		}

		// Otherwise a node which might have a `dt-column` data attribute, or be
		// a child or such an element
		var host = $(s).closest('*[data-dt-column]');
		return host.length ?
			[ host.data('dt-column') ] :
			[];
	};

	var selected = _selector_run( 'column', selector, run, settings, opts );

	return opts.columnOrder && opts.columnOrder === 'index'
		? selected.sort(function (a, b) { return a - b; })
		: selected; // implied
};


var __setColumnVis = function ( settings, column, vis ) {
	var
		cols = settings.aoColumns,
		col  = cols[ column ],
		data = settings.aoData,
		cells, i, iLen, tr;

	// Get
	if ( vis === undefined ) {
		return col.bVisible;
	}

	// Set
	// No change
	if ( col.bVisible === vis ) {
		return false;
	}

	if ( vis ) {
		// Insert column
		// Need to decide if we should use appendChild or insertBefore
		var insertBefore = _pluck(cols, 'bVisible').indexOf(true, column+1);

		for ( i=0, iLen=data.length ; i<iLen ; i++ ) {
			if (data[i]) {
				tr = data[i].nTr;
				cells = data[i].anCells;

				if ( tr ) {
					// insertBefore can act like appendChild if 2nd arg is null
					tr.insertBefore( cells[ column ], cells[ insertBefore ] || null );
				}
			}
		}
	}
	else {
		// Remove column
		$( _pluck( settings.aoData, 'anCells', column ) ).detach();
	}

	// Common actions
	col.bVisible = vis;

	_colGroup(settings);
	
	return true;
};


_api_register( 'columns()', function ( selector, opts ) {
	// argument shifting
	if ( selector === undefined ) {
		selector = '';
	}
	else if ( $.isPlainObject( selector ) ) {
		opts = selector;
		selector = '';
	}

	opts = _selector_opts( opts );

	var inst = this.iterator( 'table', function ( settings ) {
		return __column_selector( settings, selector, opts );
	}, 1 );

	// Want argument shifting here and in _row_selector?
	inst.selector.cols = selector;
	inst.selector.opts = opts;

	return inst;
} );

_api_registerPlural( 'columns().header()', 'column().header()', function ( row ) {
	return this.iterator( 'column', function (settings, column) {
		return __column_header(settings, column, row);
	}, 1 );
} );

_api_registerPlural( 'columns().footer()', 'column().footer()', function ( row ) {
	return this.iterator( 'column', function ( settings, column ) {
		var footer = settings.aoFooter;

		if (! footer.length) {
			return null;
		}

		return settings.aoFooter[row !== undefined ? row : 0][column].cell;
	}, 1 );
} );

_api_registerPlural( 'columns().data()', 'column().data()', function () {
	return this.iterator( 'column-rows', __columnData, 1 );
} );

_api_registerPlural( 'columns().render()', 'column().render()', function ( type ) {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return __columnData( settings, column, i, j, rows, type );
	}, 1 );
} );

_api_registerPlural( 'columns().dataSrc()', 'column().dataSrc()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		return settings.aoColumns[column].mData;
	}, 1 );
} );

_api_registerPlural( 'columns().cache()', 'column().cache()', function ( type ) {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return _pluck_order( settings.aoData, rows,
			type === 'search' ? '_aFilterData' : '_aSortData', column
		);
	}, 1 );
} );

_api_registerPlural( 'columns().init()', 'column().init()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		return settings.aoColumns[column];
	}, 1 );
} );

_api_registerPlural( 'columns().names()', 'column().name()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		return settings.aoColumns[column].sName;
	}, 1 );
} );

_api_registerPlural( 'columns().nodes()', 'column().nodes()', function () {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return _pluck_order( settings.aoData, rows, 'anCells', column ) ;
	}, 1 );
} );

_api_registerPlural( 'columns().titles()', 'column().title()', function (title, row) {
	return this.iterator( 'column', function ( settings, column ) {
		// Argument shifting
		if (typeof title === 'number') {
			row = title;
			title = undefined;
		}

		var span = $('.dt-column-title', this.column(column).header(row));

		if (title !== undefined) {
			span.html(title);
			return this;
		}

		return span.html();
	}, 1 );
} );

_api_registerPlural( 'columns().types()', 'column().type()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		var colObj = settings.aoColumns[column]
		var type = colObj.sType;

		// If the type was invalidated, then resolve it. This actually does
		// all columns at the moment. Would only happen once if getting all
		// column's data types.
		if (! type) {
			_fnColumnTypes(settings);

			type = colObj.sType;
		}

		return type;
	}, 1 );
} );

_api_registerPlural( 'columns().visible()', 'column().visible()', function ( vis, calc ) {
	var that = this;
	var changed = [];
	var ret = this.iterator( 'column', function ( settings, column ) {
		if ( vis === undefined ) {
			return settings.aoColumns[ column ].bVisible;
		} // else
		
		if (__setColumnVis( settings, column, vis )) {
			changed.push(column);
		}
	} );

	// Group the column visibility changes
	if ( vis !== undefined ) {
		this.iterator( 'table', function ( settings ) {
			// Redraw the header after changes
			_fnDrawHead( settings, settings.aoHeader );
			_fnDrawHead( settings, settings.aoFooter );
	
			// Update colspan for no records display. Child rows and extensions will use their own
			// listeners to do this - only need to update the empty table item here
			if ( ! settings.aiDisplay.length ) {
				$(settings.nTBody).find('td[colspan]').attr('colspan', _fnVisibleColumns(settings));
			}
	
			_fnSaveState( settings );

			// Second loop once the first is done for events
			that.iterator( 'column', function ( settings, column ) {
				if (changed.includes(column)) {
					_fnCallbackFire( settings, null, 'column-visibility', [settings, column, vis, calc] );
				}
			} );

			if ( changed.length && (calc === undefined || calc) ) {
				that.columns.adjust();
			}
		});
	}

	return ret;
} );

_api_registerPlural( 'columns().widths()', 'column().width()', function () {
	// Injects a fake row into the table for just a moment so the widths can
	// be read, regardless of colspan in the header and rows being present in
	// the body
	var columns = this.columns(':visible').count();
	var row = $('<tr>').html('<td>' + Array(columns).join('</td><td>') + '</td>');

	$(this.table().body()).append(row);

	var widths = row.children().map(function () {
		return $(this).outerWidth();
	});

	row.remove();
	
	return this.iterator( 'column', function ( settings, column ) {
		var visIdx = _fnColumnIndexToVisible( settings, column );

		return visIdx !== null ? widths[visIdx] : 0;
	}, 1);
} );

_api_registerPlural( 'columns().indexes()', 'column().index()', function ( type ) {
	return this.iterator( 'column', function ( settings, column ) {
		return type === 'visible' ?
			_fnColumnIndexToVisible( settings, column ) :
			column;
	}, 1 );
} );

_api_register( 'columns.adjust()', function () {
	return this.iterator( 'table', function ( settings ) {
		// Force a column sizing to happen with a manual call - otherwise it can skip
		// if the size hasn't changed
		settings.containerWidth = -1;

		_fnAdjustColumnSizing( settings );
	}, 1 );
} );

_api_register( 'column.index()', function ( type, idx ) {
	if ( this.context.length !== 0 ) {
		var ctx = this.context[0];

		if ( type === 'fromVisible' || type === 'toData' ) {
			return _fnVisibleToColumnIndex( ctx, idx );
		}
		else if ( type === 'fromData' || type === 'toVisible' ) {
			return _fnColumnIndexToVisible( ctx, idx );
		}
	}
} );

_api_register( 'column()', function ( selector, opts ) {
	return _selector_first( this.columns( selector, opts ) );
} );

var __cell_selector = function ( settings, selector, opts )
{
	var data = settings.aoData;
	var rows = _selector_row_indexes( settings, opts );
	var cells = _removeEmpty( _pluck_order( data, rows, 'anCells' ) );
	var allCells = $(_flatten( [], cells ));
	var row;
	var columns = settings.aoColumns.length;
	var a, i, iLen, j, o, host;

	var run = function ( s ) {
		var fnSelector = typeof s === 'function';

		if ( s === null || s === undefined || fnSelector ) {
			// All cells and function selectors
			a = [];

			for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
				row = rows[i];

				for ( j=0 ; j<columns ; j++ ) {
					o = {
						row: row,
						column: j
					};

					if ( fnSelector ) {
						// Selector - function
						host = data[ row ];

						if ( s( o, _fnGetCellData(settings, row, j), host.anCells ? host.anCells[j] : null ) ) {
							a.push( o );
						}
					}
					else {
						// Selector - all
						a.push( o );
					}
				}
			}

			return a;
		}
		
		// Selector - index
		if ( $.isPlainObject( s ) ) {
			// Valid cell index and its in the array of selectable rows
			return s.column !== undefined && s.row !== undefined && rows.indexOf(s.row) !== -1 ?
				[s] :
				[];
		}

		// Selector - jQuery filtered cells
		var jqResult = allCells
			.filter( s )
			.map( function (i, el) {
				return { // use a new object, in case someone changes the values
					row:    el._DT_CellIndex.row,
					column: el._DT_CellIndex.column
				};
			} )
			.toArray();

		if ( jqResult.length || ! s.nodeName ) {
			return jqResult;
		}

		// Otherwise the selector is a node, and there is one last option - the
		// element might be a child of an element which has dt-row and dt-column
		// data attributes
		host = $(s).closest('*[data-dt-row]');
		return host.length ?
			[ {
				row: host.data('dt-row'),
				column: host.data('dt-column')
			} ] :
			[];
	};

	return _selector_run( 'cell', selector, run, settings, opts );
};




_api_register( 'cells()', function ( rowSelector, columnSelector, opts ) {
	// Argument shifting
	if ( $.isPlainObject( rowSelector ) ) {
		// Indexes
		if ( rowSelector.row === undefined ) {
			// Selector options in first parameter
			opts = rowSelector;
			rowSelector = null;
		}
		else {
			// Cell index objects in first parameter
			opts = columnSelector;
			columnSelector = null;
		}
	}
	if ( $.isPlainObject( columnSelector ) ) {
		opts = columnSelector;
		columnSelector = null;
	}

	// Cell selector
	if ( columnSelector === null || columnSelector === undefined ) {
		return this.iterator( 'table', function ( settings ) {
			return __cell_selector( settings, rowSelector, _selector_opts( opts ) );
		} );
	}

	// The default built in options need to apply to row and columns
	var internalOpts = opts ? {
		page: opts.page,
		order: opts.order,
		search: opts.search
	} : {};

	// Row + column selector
	var columns = this.columns( columnSelector, internalOpts );
	var rows = this.rows( rowSelector, internalOpts );
	var i, iLen, j, jen;

	var cellsNoOpts = this.iterator( 'table', function ( settings, idx ) {
		var a = [];

		for ( i=0, iLen=rows[idx].length ; i<iLen ; i++ ) {
			for ( j=0, jen=columns[idx].length ; j<jen ; j++ ) {
				a.push( {
					row:    rows[idx][i],
					column: columns[idx][j]
				} );
			}
		}

		return a;
	}, 1 );

	// There is currently only one extension which uses a cell selector extension
	// It is a _major_ performance drag to run this if it isn't needed, so this is
	// an extension specific check at the moment
	var cells = opts && opts.selected ?
		this.cells( cellsNoOpts, opts ) :
		cellsNoOpts;

	$.extend( cells.selector, {
		cols: columnSelector,
		rows: rowSelector,
		opts: opts
	} );

	return cells;
} );


_api_registerPlural( 'cells().nodes()', 'cell().node()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		var data = settings.aoData[ row ];

		return data && data.anCells ?
			data.anCells[ column ] :
			undefined;
	}, 1 );
} );


_api_register( 'cells().data()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return _fnGetCellData( settings, row, column );
	}, 1 );
} );


_api_registerPlural( 'cells().cache()', 'cell().cache()', function ( type ) {
	type = type === 'search' ? '_aFilterData' : '_aSortData';

	return this.iterator( 'cell', function ( settings, row, column ) {
		return settings.aoData[ row ][ type ][ column ];
	}, 1 );
} );


_api_registerPlural( 'cells().render()', 'cell().render()', function ( type ) {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return _fnGetCellData( settings, row, column, type );
	}, 1 );
} );


_api_registerPlural( 'cells().indexes()', 'cell().index()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return {
			row: row,
			column: column,
			columnVisible: _fnColumnIndexToVisible( settings, column )
		};
	}, 1 );
} );


_api_registerPlural( 'cells().invalidate()', 'cell().invalidate()', function ( src ) {
	return this.iterator( 'cell', function ( settings, row, column ) {
		_fnInvalidate( settings, row, src, column );
	} );
} );



_api_register( 'cell()', function ( rowSelector, columnSelector, opts ) {
	return _selector_first( this.cells( rowSelector, columnSelector, opts ) );
} );


_api_register( 'cell().data()', function ( data ) {
	var ctx = this.context;
	var cell = this[0];

	if ( data === undefined ) {
		// Get
		return ctx.length && cell.length ?
			_fnGetCellData( ctx[0], cell[0].row, cell[0].column ) :
			undefined;
	}

	// Set
	_fnSetCellData( ctx[0], cell[0].row, cell[0].column, data );
	_fnInvalidate( ctx[0], cell[0].row, 'data', cell[0].column );

	return this;
} );



/**
 * Get current ordering (sorting) that has been applied to the table.
 *
 * @returns {array} 2D array containing the sorting information for the first
 *   table in the current context. Each element in the parent array represents
 *   a column being sorted upon (i.e. multi-sorting with two columns would have
 *   2 inner arrays). The inner arrays may have 2 or 3 elements. The first is
 *   the column index that the sorting condition applies to, the second is the
 *   direction of the sort (`desc` or `asc`) and, optionally, the third is the
 *   index of the sorting order from the `column.sorting` initialisation array.
 *//**
 * Set the ordering for the table.
 *
 * @param {integer} order Column index to sort upon.
 * @param {string} direction Direction of the sort to be applied (`asc` or `desc`)
 * @returns {DataTables.Api} this
 *//**
 * Set the ordering for the table.
 *
 * @param {array} order 1D array of sorting information to be applied.
 * @param {array} [...] Optional additional sorting conditions
 * @returns {DataTables.Api} this
 *//**
 * Set the ordering for the table.
 *
 * @param {array} order 2D array of sorting information to be applied.
 * @returns {DataTables.Api} this
 */
_api_register( 'order()', function ( order, dir ) {
	var ctx = this.context;
	var args = Array.prototype.slice.call( arguments );

	if ( order === undefined ) {
		// get
		return ctx.length !== 0 ?
			ctx[0].aaSorting :
			undefined;
	}

	// set
	if ( typeof order === 'number' ) {
		// Simple column / direction passed in
		order = [ [ order, dir ] ];
	}
	else if ( args.length > 1 ) {
		// Arguments passed in (list of 1D arrays)
		order = args;
	}
	// otherwise a 2D array was passed in

	return this.iterator( 'table', function ( settings ) {
		var resolved = [];
		_fnSortResolve(settings, resolved, order);

		settings.aaSorting = resolved;
	} );
} );


/**
 * Attach a sort listener to an element for a given column
 *
 * @param {node|jQuery|string} node Identifier for the element(s) to attach the
 *   listener to. This can take the form of a single DOM node, a jQuery
 *   collection of nodes or a jQuery selector which will identify the node(s).
 * @param {integer} column the column that a click on this node will sort on
 * @param {function} [callback] callback function when sort is run
 * @returns {DataTables.Api} this
 */
_api_register( 'order.listener()', function ( node, column, callback ) {
	return this.iterator( 'table', function ( settings ) {
		_fnSortAttachListener(settings, node, {}, column, callback);
	} );
} );


_api_register( 'order.fixed()', function ( set ) {
	if ( ! set ) {
		var ctx = this.context;
		var fixed = ctx.length ?
			ctx[0].aaSortingFixed :
			undefined;

		return Array.isArray( fixed ) ?
			{ pre: fixed } :
			fixed;
	}

	return this.iterator( 'table', function ( settings ) {
		settings.aaSortingFixed = $.extend( true, {}, set );
	} );
} );


// Order by the selected column(s)
_api_register( [
	'columns().order()',
	'column().order()'
], function ( dir ) {
	var that = this;

	if ( ! dir ) {
		return this.iterator( 'column', function ( settings, idx ) {
			var sort = _fnSortFlatten( settings );

			for ( var i=0, iLen=sort.length ; i<iLen ; i++ ) {
				if ( sort[i].col === idx ) {
					return sort[i].dir;
				}
			}

			return null;
		}, 1 );
	}
	else {
		return this.iterator( 'table', function ( settings, i ) {
			settings.aaSorting = that[i].map( function (col) {
				return [ col, dir ];
			} );
		} );
	}
} );

_api_registerPlural('columns().orderable()', 'column().orderable()', function ( directions ) {
	return this.iterator( 'column', function ( settings, idx ) {
		var col = settings.aoColumns[idx];

		return directions ?
			col.asSorting :
			col.bSortable;
	}, 1 );
} );


_api_register( 'processing()', function ( show ) {
	return this.iterator( 'table', function ( ctx ) {
		_fnProcessingDisplay( ctx, show );
	} );
} );


_api_register( 'search()', function ( input, regex, smart, caseInsen ) {
	var ctx = this.context;

	if ( input === undefined ) {
		// get
		return ctx.length !== 0 ?
			ctx[0].oPreviousSearch.search :
			undefined;
	}

	// set
	return this.iterator( 'table', function ( settings ) {
		if ( ! settings.oFeatures.bFilter ) {
			return;
		}

		if (typeof regex === 'object') {
			// New style options to pass to the search builder
			_fnFilterComplete( settings, $.extend( settings.oPreviousSearch, regex, {
				search: input
			} ) );
		}
		else {
			// Compat for the old options
			_fnFilterComplete( settings, $.extend( settings.oPreviousSearch, {
				search: input,
				regex:  regex === null ? false : regex,
				smart:  smart === null ? true  : smart,
				caseInsensitive: caseInsen === null ? true : caseInsen
			} ) );
		}
	} );
} );

_api_register( 'search.fixed()', function ( name, search ) {
	var ret = this.iterator( true, 'table', function ( settings ) {
		var fixed = settings.searchFixed;

		if (! name) {
			return Object.keys(fixed);
		}
		else if (search === undefined) {
			return fixed[name];
		}
		else if (search === null) {
			delete fixed[name];
		}
		else {
			fixed[name] = search;
		}

		return this;
	} );

	return name !== undefined && search === undefined
		? ret[0]
		: ret;
} );

_api_registerPlural(
	'columns().search()',
	'column().search()',
	function ( input, regex, smart, caseInsen ) {
		return this.iterator( 'column', function ( settings, column ) {
			var preSearch = settings.aoPreSearchCols;

			if ( input === undefined ) {
				// get
				return preSearch[ column ].search;
			}

			// set
			if ( ! settings.oFeatures.bFilter ) {
				return;
			}

			if (typeof regex === 'object') {
				// New style options to pass to the search builder
				$.extend( preSearch[ column ], regex, {
					search: input
				} );
			}
			else {
				// Old style (with not all options available)
				$.extend( preSearch[ column ], {
					search: input,
					regex:  regex === null ? false : regex,
					smart:  smart === null ? true  : smart,
					caseInsensitive: caseInsen === null ? true : caseInsen
				} );
			}

			_fnFilterComplete( settings, settings.oPreviousSearch );
		} );
	}
);

_api_register([
		'columns().search.fixed()',
		'column().search.fixed()'
	],
	function ( name, search ) {
		var ret = this.iterator( true, 'column', function ( settings, colIdx ) {
			var fixed = settings.aoColumns[colIdx].searchFixed;

			if (! name) {
				return Object.keys(fixed);
			}
			else if (search === undefined) {
				return fixed[name] || null;
			}
			else if (search === null) {
				delete fixed[name];
			}
			else {
				fixed[name] = search;
			}

			return this;
		} );

		return name !== undefined && search === undefined
			? ret[0]
			: ret;
	}
);
/*
 * State API methods
 */

_api_register( 'state()', function ( set, ignoreTime ) {
	// getter
	if ( ! set ) {
		return this.context.length ?
			this.context[0].oSavedState :
			null;
	}

	var setMutate = $.extend( true, {}, set );

	// setter
	return this.iterator( 'table', function ( settings ) {
		if ( ignoreTime !== false ) {
			setMutate.time = +new Date() + 100;
		}

		_fnImplementState( settings, setMutate, function(){} );
	} );
} );


_api_register( 'state.clear()', function () {
	return this.iterator( 'table', function ( settings ) {
		// Save an empty object
		settings.fnStateSaveCallback.call( settings.oInstance, settings, {} );
	} );
} );


_api_register( 'state.loaded()', function () {
	return this.context.length ?
		this.context[0].oLoadedState :
		null;
} );


_api_register( 'state.save()', function () {
	return this.iterator( 'table', function ( settings ) {
		_fnSaveState( settings );
	} );
} );

// Can be assigned in DateTable.use() - note luxon and moment vars are in helpers.js
var __bootstrap;
var __foundation;

/**
 * Set the libraries that DataTables uses, or the global objects.
 * Note that the arguments can be either way around (legacy support)
 * and the second is optional. See docs.
 */
DataTable.use = function (arg1, arg2) {
	// Reverse arguments for legacy support
	var module = typeof arg1 === 'string'
		? arg2
		: arg1;
	var type = typeof arg2 === 'string'
		? arg2
		: arg1;

	// Getter
	if (module === undefined && typeof type === 'string') {
		switch (type) {
			case 'lib':
			case 'jq':
				return $;

			case 'win':
				return window;

			case 'datetime':
				return DataTable.DateTime;

			case 'luxon':
				return __luxon;

			case 'moment':
				return __moment;

			case 'bootstrap':
				// Use local if set, otherwise try window, which could be undefined
				return __bootstrap || window.bootstrap;

			case 'foundation':
				// Ditto
				return __foundation || window.Foundation;

			default:
				return null;
		}
	}

	// Setter
	if (type === 'lib' || type === 'jq' || (module && module.fn && module.fn.jquery)) {
		$ = module;
	}
	else if (type === 'win' || (module && module.document)) {
		window = module;
		document = module.document;
	}
	else if (type === 'datetime' || (module && module.type === 'DateTime')) {
		DataTable.DateTime = module;
	}
	else if (type === 'luxon' || (module && module.FixedOffsetZone)) {
		__luxon = module;
	}
	else if (type === 'moment' || (module && module.isMoment)) {
		__moment = module;
	}
	else if (type === 'bootstrap' || (module && module.Modal && module.Modal.NAME === 'modal'))
	{
		// This is currently for BS5 only. BS3/4 attach to jQuery, so no need to use `.use()`
		__bootstrap = module;
	}
	else if (type === 'foundation' || (module && module.Reveal)) {
		__foundation = module;
	}
}

/**
 * CommonJS factory function pass through. This will check if the arguments
 * given are a window object or a jQuery object. If so they are set
 * accordingly.
 * @param {*} root Window
 * @param {*} jq jQUery
 * @returns {boolean} Indicator
 */
DataTable.factory = function (root, jq) {
	var is = false;

	// Test if the first parameter is a window object
	if (root && root.document) {
		window = root;
		document = root.document;
	}

	// Test if the second parameter is a jQuery object
	if (jq && jq.fn && jq.fn.jquery) {
		$ = jq;
		is = true;
	}

	return is;
}

/**
 * Provide a common method for plug-ins to check the version of DataTables being
 * used, in order to ensure compatibility.
 *
 *  @param {string} version Version string to check for, in the format "X.Y.Z".
 *    Note that the formats "X" and "X.Y" are also acceptable.
 *  @param {string} [version2=current DataTables version] As above, but optional.
 *   If not given the current DataTables version will be used.
 *  @returns {boolean} true if this version of DataTables is greater or equal to
 *    the required version, or false if this version of DataTales is not
 *    suitable
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    alert( $.fn.dataTable.versionCheck( '1.9.0' ) );
 */
DataTable.versionCheck = function( version, version2 )
{
	var aThis = version2 ?
		version2.split('.') :
		DataTable.version.split('.');
	var aThat = version.split('.');
	var iThis, iThat;

	for ( var i=0, iLen=aThat.length ; i<iLen ; i++ ) {
		iThis = parseInt( aThis[i], 10 ) || 0;
		iThat = parseInt( aThat[i], 10 ) || 0;

		// Parts are the same, keep comparing
		if (iThis === iThat) {
			continue;
		}

		// Parts are different, return immediately
		return iThis > iThat;
	}

	return true;
};


/**
 * Check if a `<table>` node is a DataTable table already or not.
 *
 *  @param {node|jquery|string} table Table node, jQuery object or jQuery
 *      selector for the table to test. Note that if more than more than one
 *      table is passed on, only the first will be checked
 *  @returns {boolean} true the table given is a DataTable, or false otherwise
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    if ( ! $.fn.DataTable.isDataTable( '#example' ) ) {
 *      $('#example').dataTable();
 *    }
 */
DataTable.isDataTable = function ( table )
{
	var t = $(table).get(0);
	var is = false;

	if ( table instanceof DataTable.Api ) {
		return true;
	}

	$.each( DataTable.settings, function (i, o) {
		var head = o.nScrollHead ? $('table', o.nScrollHead)[0] : null;
		var foot = o.nScrollFoot ? $('table', o.nScrollFoot)[0] : null;

		if ( o.nTable === t || head === t || foot === t ) {
			is = true;
		}
	} );

	return is;
};


/**
 * Get all DataTable tables that have been initialised - optionally you can
 * select to get only currently visible tables.
 *
 *  @param {boolean} [visible=false] Flag to indicate if you want all (default)
 *    or visible tables only.
 *  @returns {array} Array of `table` nodes (not DataTable instances) which are
 *    DataTables
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    $.each( $.fn.dataTable.tables(true), function () {
 *      $(table).DataTable().columns.adjust();
 *    } );
 */
DataTable.tables = function ( visible )
{
	var api = false;

	if ( $.isPlainObject( visible ) ) {
		api = visible.api;
		visible = visible.visible;
	}

	var a = DataTable.settings
		.filter( function (o) {
			return !visible || (visible && $(o.nTable).is(':visible')) 
				? true
				: false;
		} )
		.map( function (o) {
			return o.nTable;
		});

	return api ?
		new _Api( a ) :
		a;
};


/**
 * Convert from camel case parameters to Hungarian notation. This is made public
 * for the extensions to provide the same ability as DataTables core to accept
 * either the 1.9 style Hungarian notation, or the 1.10+ style camelCase
 * parameters.
 *
 *  @param {object} src The model object which holds all parameters that can be
 *    mapped.
 *  @param {object} user The object to convert from camel case to Hungarian.
 *  @param {boolean} force When set to `true`, properties which already have a
 *    Hungarian value in the `user` object will be overwritten. Otherwise they
 *    won't be.
 */
DataTable.camelToHungarian = _fnCamelToHungarian;



/**
 *
 */
_api_register( '$()', function ( selector, opts ) {
	var
		rows   = this.rows( opts ).nodes(), // Get all rows
		jqRows = $(rows);

	return $( [].concat(
		jqRows.filter( selector ).toArray(),
		jqRows.find( selector ).toArray()
	) );
} );


// jQuery functions to operate on the tables
$.each( [ 'on', 'one', 'off' ], function (i, key) {
	_api_register( key+'()', function ( /* event, handler */ ) {
		var args = Array.prototype.slice.call(arguments);

		// Add the `dt` namespace automatically if it isn't already present
		args[0] = args[0].split( /\s/ ).map( function ( e ) {
			return ! e.match(/\.dt\b/) ?
				e+'.dt' :
				e;
			} ).join( ' ' );

		var inst = $( this.tables().nodes() );
		inst[key].apply( inst, args );
		return this;
	} );
} );


_api_register( 'clear()', function () {
	return this.iterator( 'table', function ( settings ) {
		_fnClearTable( settings );
	} );
} );


_api_register( 'error()', function (msg) {
	return this.iterator( 'table', function ( settings ) {
		_fnLog( settings, 0, msg );
	} );
} );


_api_register( 'settings()', function () {
	return new _Api( this.context, this.context );
} );


_api_register( 'init()', function () {
	var ctx = this.context;
	return ctx.length ? ctx[0].oInit : null;
} );


_api_register( 'data()', function () {
	return this.iterator( 'table', function ( settings ) {
		return _pluck( settings.aoData, '_aData' );
	} ).flatten();
} );


_api_register( 'trigger()', function ( name, args, bubbles ) {
	return this.iterator( 'table', function ( settings ) {
		return _fnCallbackFire( settings, null, name, args, bubbles );
	} ).flatten();
} );


_api_register( 'ready()', function ( fn ) {
	var ctx = this.context;

	// Get status of first table
	if (! fn) {
		return ctx.length
			? (ctx[0]._bInitComplete || false)
			: null;
	}

	// Function to run either once the table becomes ready or
	// immediately if it is already ready.
	return this.tables().every(function () {
		var api = this;

		if (this.context[0]._bInitComplete) {
			fn.call(api);
		}
		else {
			this.on('init.dt.DT', function () {
				fn.call(api);
			});
		}
	} );
} );


_api_register( 'destroy()', function ( remove ) {
	remove = remove || false;

	return this.iterator( 'table', function ( settings ) {
		var classes   = settings.oClasses;
		var table     = settings.nTable;
		var tbody     = settings.nTBody;
		var thead     = settings.nTHead;
		var tfoot     = settings.nTFoot;
		var jqTable   = $(table);
		var jqTbody   = $(tbody);
		var jqWrapper = $(settings.nTableWrapper);
		var rows      = settings.aoData.map( function (r) { return r ? r.nTr : null; } );
		var orderClasses = classes.order;

		// Flag to note that the table is currently being destroyed - no action
		// should be taken
		settings.bDestroying = true;

		// Fire off the destroy callbacks for plug-ins etc
		_fnCallbackFire( settings, "aoDestroyCallback", "destroy", [settings], true );

		// If not being removed from the document, make all columns visible
		if ( ! remove ) {
			new _Api( settings ).columns().visible( true );
		}

		// Container width change listener
		if (settings.resizeObserver) {
			settings.resizeObserver.disconnect();
		}

		// Blitz all `DT` namespaced events (these are internal events, the
		// lowercase, `dt` events are user subscribed and they are responsible
		// for removing them
		jqWrapper.off('.DT').find(':not(tbody *)').off('.DT');
		$(window).off('.DT-'+settings.sInstance);

		// When scrolling we had to break the table up - restore it
		if ( table != thead.parentNode ) {
			jqTable.children('thead').detach();
			jqTable.append( thead );
		}

		if ( tfoot && table != tfoot.parentNode ) {
			jqTable.children('tfoot').detach();
			jqTable.append( tfoot );
		}

		// Clean up the header / footer
		cleanHeader(thead, 'header');
		cleanHeader(tfoot, 'footer');
		settings.colgroup.remove();

		settings.aaSorting = [];
		settings.aaSortingFixed = [];
		_fnSortingClasses( settings );

		$(jqTable).find('th, td').removeClass(
			$.map(DataTable.ext.type.className, function (v) {
				return v;
			}).join(' ')
		);

		$('th, td', thead)
			.removeClass(
				orderClasses.none + ' ' +
				orderClasses.canAsc + ' ' +
				orderClasses.canDesc + ' ' +
				orderClasses.isAsc + ' ' +
				orderClasses.isDesc
			)
			.css('width', '')
			.removeAttr('aria-sort');

		// Add the TR elements back into the table in their original order
		jqTbody.children().detach();
		jqTbody.append( rows );

		var orig = settings.nTableWrapper.parentNode;
		var insertBefore = settings.nTableWrapper.nextSibling;

		// Remove the DataTables generated nodes, events and classes
		var removedMethod = remove ? 'remove' : 'detach';
		jqTable[ removedMethod ]();
		jqWrapper[ removedMethod ]();

		// If we need to reattach the table to the document
		if ( ! remove && orig ) {
			// insertBefore acts like appendChild if !arg[1]
			orig.insertBefore( table, insertBefore );

			// Restore the width of the original table - was read from the style property,
			// so we can restore directly to that
			jqTable
				.css( 'width', settings.sDestroyWidth )
				.removeClass( classes.table );
		}

		/* Remove the settings object from the settings array */
		var idx = DataTable.settings.indexOf(settings);
		if ( idx !== -1 ) {
			DataTable.settings.splice( idx, 1 );
		}
	} );
} );


// Add the `every()` method for rows, columns and cells in a compact form
$.each( [ 'column', 'row', 'cell' ], function ( i, type ) {
	_api_register( type+'s().every()', function ( fn ) {
		var opts = this.selector.opts;
		var api = this;
		var inst;
		var counter = 0;

		return this.iterator( 'every', function ( settings, selectedIdx, tableIdx ) {
			inst = api[ type ](selectedIdx, opts);

			if (type === 'cell') {
				fn.call(inst, inst[0][0].row, inst[0][0].column, tableIdx, counter);
			}
			else {
				fn.call(inst, selectedIdx, tableIdx, counter);
			}

			counter++;
		} );
	} );
} );


// i18n method for extensions to be able to use the language object from the
// DataTable
_api_register( 'i18n()', function ( token, def, plural ) {
	var ctx = this.context[0];
	var resolved = _fnGetObjectDataFn( token )( ctx.oLanguage );

	if ( resolved === undefined ) {
		resolved = def;
	}

	if ( $.isPlainObject( resolved ) ) {
		resolved = plural !== undefined && resolved[ plural ] !== undefined
			? resolved[ plural ]
			: plural === false
				? resolved
				: resolved._;
	}

	return typeof resolved === 'string'
		? resolved.replace( '%d', plural ) // nb: plural might be undefined,
		: resolved;
} );

// Needed for header and footer, so pulled into its own function
function cleanHeader(node, className) {
	$(node).find('.dt-column-order').remove();
	$(node).find('.dt-column-title').each(function () {
		var title = $(this).html();
		$(this).parent().parent().append(title);
		$(this).remove();
	});
	$(node).find('div.dt-column-' + className).remove();

	$('th, td', node).removeAttr('data-dt-column');
}

/**
 * Version string for plug-ins to check compatibility. Allowed format is
 * `a.b.c-d` where: a:int, b:int, c:int, d:string(dev|beta|alpha). `d` is used
 * only for non-release builds. See https://semver.org/ for more information.
 *  @member
 *  @type string
 *  @default Version number
 */
DataTable.version = "2.3.6";

/**
 * Private data store, containing all of the settings objects that are
 * created for the tables on a given page.
 *
 * Note that the `DataTable.settings` object is aliased to
 * `jQuery.fn.dataTableExt` through which it may be accessed and
 * manipulated, or `jQuery.fn.dataTable.settings`.
 *  @member
 *  @type array
 *  @default []
 *  @private
 */
DataTable.settings = [];

/**
 * Object models container, for the various models that DataTables has
 * available to it. These models define the objects that are used to hold
 * the active state and configuration of the table.
 *  @namespace
 */
DataTable.models = {};



/**
 * Template object for the way in which DataTables holds information about
 * search information for the global filter and individual column filters.
 *  @namespace
 */
DataTable.models.oSearch = {
	/**
	 * Flag to whether or not the filtering should be case-insensitive
	 */
	"caseInsensitive": true,

	/**
	 * Applied search term
	 */
	"search": "",

	/**
	 * Flag to indicate if the search term should be interpreted as a
	 * regular expression (true) or not (false) and therefore and special
	 * regex characters escaped.
	 */
	"regex": false,

	/**
	 * Flag to indicate if DataTables is to use its smart filtering or not.
	 */
	"smart": true,

	/**
	 * Flag to indicate if DataTables should only trigger a search when
	 * the return key is pressed.
	 */
	"return": false
};




/**
 * Template object for the way in which DataTables holds information about
 * each individual row. This is the object format used for the settings
 * aoData array.
 *  @namespace
 */
DataTable.models.oRow = {
	/**
	 * TR element for the row
	 */
	"nTr": null,

	/**
	 * Array of TD elements for each row. This is null until the row has been
	 * created.
	 */
	"anCells": null,

	/**
	 * Data object from the original data source for the row. This is either
	 * an array if using the traditional form of DataTables, or an object if
	 * using mData options. The exact type will depend on the passed in
	 * data from the data source, or will be an array if using DOM a data
	 * source.
	 */
	"_aData": [],

	/**
	 * Sorting data cache - this array is ostensibly the same length as the
	 * number of columns (although each index is generated only as it is
	 * needed), and holds the data that is used for sorting each column in the
	 * row. We do this cache generation at the start of the sort in order that
	 * the formatting of the sort data need be done only once for each cell
	 * per sort. This array should not be read from or written to by anything
	 * other than the master sorting methods.
	 */
	"_aSortData": null,

	/**
	 * Per cell filtering data cache. As per the sort data cache, used to
	 * increase the performance of the filtering in DataTables
	 */
	"_aFilterData": null,

	/**
	 * Filtering data cache. This is the same as the cell filtering cache, but
	 * in this case a string rather than an array. This is easily computed with
	 * a join on `_aFilterData`, but is provided as a cache so the join isn't
	 * needed on every search (memory traded for performance)
	 */
	"_sFilterRow": null,

	/**
	 * Denote if the original data source was from the DOM, or the data source
	 * object. This is used for invalidating data, so DataTables can
	 * automatically read data from the original source, unless uninstructed
	 * otherwise.
	 */
	"src": null,

	/**
	 * Index in the aoData array. This saves an indexOf lookup when we have the
	 * object, but want to know the index
	 */
	"idx": -1,

	/**
	 * Cached display value
	 */
	displayData: null
};


/**
 * Template object for the column information object in DataTables. This object
 * is held in the settings aoColumns array and contains all the information that
 * DataTables needs about each individual column.
 *
 * Note that this object is related to {@link DataTable.defaults.column}
 * but this one is the internal data store for DataTables's cache of columns.
 * It should NOT be manipulated outside of DataTables. Any configuration should
 * be done through the initialisation options.
 *  @namespace
 */
DataTable.models.oColumn = {
	/**
	 * Column index.
	 */
	"idx": null,

	/**
	 * A list of the columns that sorting should occur on when this column
	 * is sorted. That this property is an array allows multi-column sorting
	 * to be defined for a column (for example first name / last name columns
	 * would benefit from this). The values are integers pointing to the
	 * columns to be sorted on (typically it will be a single integer pointing
	 * at itself, but that doesn't need to be the case).
	 */
	"aDataSort": null,

	/**
	 * Define the sorting directions that are applied to the column, in sequence
	 * as the column is repeatedly sorted upon - i.e. the first value is used
	 * as the sorting direction when the column if first sorted (clicked on).
	 * Sort it again (click again) and it will move on to the next index.
	 * Repeat until loop.
	 */
	"asSorting": null,

	/**
	 * Flag to indicate if the column is searchable, and thus should be included
	 * in the filtering or not.
	 */
	"bSearchable": null,

	/**
	 * Flag to indicate if the column is sortable or not.
	 */
	"bSortable": null,

	/**
	 * Flag to indicate if the column is currently visible in the table or not
	 */
	"bVisible": null,

	/**
	 * Store for manual type assignment using the `column.type` option. This
	 * is held in store so we can manipulate the column's `sType` property.
	 */
	"_sManualType": null,

	/**
	 * Flag to indicate if HTML5 data attributes should be used as the data
	 * source for filtering or sorting. True is either are.
	 */
	"_bAttrSrc": false,

	/**
	 * Developer definable function that is called whenever a cell is created (Ajax source,
	 * etc) or processed for input (DOM source). This can be used as a compliment to mRender
	 * allowing you to modify the DOM element (add background colour for example) when the
	 * element is available.
	 */
	"fnCreatedCell": null,

	/**
	 * Function to get data from a cell in a column. You should <b>never</b>
	 * access data directly through _aData internally in DataTables - always use
	 * the method attached to this property. It allows mData to function as
	 * required. This function is automatically assigned by the column
	 * initialisation method
	 */
	"fnGetData": null,

	/**
	 * Function to set data for a cell in the column. You should <b>never</b>
	 * set the data directly to _aData internally in DataTables - always use
	 * this method. It allows mData to function as required. This function
	 * is automatically assigned by the column initialisation method
	 */
	"fnSetData": null,

	/**
	 * Property to read the value for the cells in the column from the data
	 * source array / object. If null, then the default content is used, if a
	 * function is given then the return from the function is used.
	 */
	"mData": null,

	/**
	 * Partner property to mData which is used (only when defined) to get
	 * the data - i.e. it is basically the same as mData, but without the
	 * 'set' option, and also the data fed to it is the result from mData.
	 * This is the rendering method to match the data method of mData.
	 */
	"mRender": null,

	/**
	 * The class to apply to all TD elements in the table's TBODY for the column
	 */
	"sClass": null,

	/**
	 * When DataTables calculates the column widths to assign to each column,
	 * it finds the longest string in each column and then constructs a
	 * temporary table and reads the widths from that. The problem with this
	 * is that "mmm" is much wider then "iiii", but the latter is a longer
	 * string - thus the calculation can go wrong (doing it properly and putting
	 * it into an DOM object and measuring that is horribly(!) slow). Thus as
	 * a "work around" we provide this option. It will append its value to the
	 * text that is found to be the longest string for the column - i.e. padding.
	 */
	"sContentPadding": null,

	/**
	 * Allows a default value to be given for a column's data, and will be used
	 * whenever a null data source is encountered (this can be because mData
	 * is set to null, or because the data source itself is null).
	 */
	"sDefaultContent": null,

	/**
	 * Name for the column, allowing reference to the column by name as well as
	 * by index (needs a lookup to work by name).
	 */
	"sName": null,

	/**
	 * Custom sorting data type - defines which of the available plug-ins in
	 * afnSortData the custom sorting will use - if any is defined.
	 */
	"sSortDataType": 'std',

	/**
	 * Class to be applied to the header element when sorting on this column
	 */
	"sSortingClass": null,

	/**
	 * Title of the column - what is seen in the TH element (nTh).
	 */
	"sTitle": null,

	/**
	 * Column sorting and filtering type
	 */
	"sType": null,

	/**
	 * Width of the column
	 */
	"sWidth": null,

	/**
	 * Width of the column when it was first "encountered"
	 */
	"sWidthOrig": null,

	/** Cached longest strings from a column */
	wideStrings: null,

	/**
	 * Store for named searches
	 */
	searchFixed: null
};


/*
 * Developer note: The properties of the object below are given in Hungarian
 * notation, that was used as the interface for DataTables prior to v1.10, however
 * from v1.10 onwards the primary interface is camel case. In order to avoid
 * breaking backwards compatibility utterly with this change, the Hungarian
 * version is still, internally the primary interface, but is is not documented
 * - hence the @name tags in each doc comment. This allows a JavaScript function
 * to create a map from Hungarian notation to camel case (going the other direction
 * would require each property to be listed, which would add around 3K to the size
 * of DataTables, while this method is about a 0.5K hit).
 *
 * Ultimately this does pave the way for Hungarian notation to be dropped
 * completely, but that is a massive amount of work and will break current
 * installs (therefore is on-hold until v2).
 */

/**
 * Initialisation options that can be given to DataTables at initialisation
 * time.
 *  @namespace
 */
DataTable.defaults = {
	/**
	 * An array of data to use for the table, passed in at initialisation which
	 * will be used in preference to any data which is already in the DOM. This is
	 * particularly useful for constructing tables purely in JavaScript, for
	 * example with a custom Ajax call.
	 */
	"aaData": null,


	/**
	 * If ordering is enabled, then DataTables will perform a first pass sort on
	 * initialisation. You can define which column(s) the sort is performed
	 * upon, and the sorting direction, with this variable. The `sorting` array
	 * should contain an array for each column to be sorted initially containing
	 * the column's index and a direction string ('asc' or 'desc').
	 */
	"aaSorting": [[0,'asc']],


	/**
	 * This parameter is basically identical to the `sorting` parameter, but
	 * cannot be overridden by user interaction with the table. What this means
	 * is that you could have a column (visible or hidden) which the sorting
	 * will always be forced on first - any sorting after that (from the user)
	 * will then be performed as required. This can be useful for grouping rows
	 * together.
	 */
	"aaSortingFixed": [],


	/**
	 * DataTables can be instructed to load data to display in the table from a
	 * Ajax source. This option defines how that Ajax call is made and where to.
	 *
	 * The `ajax` property has three different modes of operation, depending on
	 * how it is defined. These are:
	 *
	 * * `string` - Set the URL from where the data should be loaded from.
	 * * `object` - Define properties for `jQuery.ajax`.
	 * * `function` - Custom data get function
	 *
	 * `string`
	 * --------
	 *
	 * As a string, the `ajax` property simply defines the URL from which
	 * DataTables will load data.
	 *
	 * `object`
	 * --------
	 *
	 * As an object, the parameters in the object are passed to
	 * [jQuery.ajax](https://api.jquery.com/jQuery.ajax/) allowing fine control
	 * of the Ajax request. DataTables has a number of default parameters which
	 * you can override using this option. Please refer to the jQuery
	 * documentation for a full description of the options available, although
	 * the following parameters provide additional options in DataTables or
	 * require special consideration:
	 *
	 * * `data` - As with jQuery, `data` can be provided as an object, but it
	 *   can also be used as a function to manipulate the data DataTables sends
	 *   to the server. The function takes a single parameter, an object of
	 *   parameters with the values that DataTables has readied for sending. An
	 *   object may be returned which will be merged into the DataTables
	 *   defaults, or you can add the items to the object that was passed in and
	 *   not return anything from the function. This supersedes `fnServerParams`
	 *   from DataTables 1.9-.
	 *
	 * * `dataSrc` - By default DataTables will look for the property `data` (or
	 *   `aaData` for compatibility with DataTables 1.9-) when obtaining data
	 *   from an Ajax source or for server-side processing - this parameter
	 *   allows that property to be changed. You can use JavaScript dotted
	 *   object notation to get a data source for multiple levels of nesting, or
	 *   it my be used as a function. As a function it takes a single parameter,
	 *   the JSON returned from the server, which can be manipulated as
	 *   required, with the returned value being that used by DataTables as the
	 *   data source for the table.
	 *
	 * * `success` - Should not be overridden it is used internally in
	 *   DataTables. To manipulate / transform the data returned by the server
	 *   use `ajax.dataSrc`, or use `ajax` as a function (see below).
	 *
	 * `function`
	 * ----------
	 *
	 * As a function, making the Ajax call is left up to yourself allowing
	 * complete control of the Ajax request. Indeed, if desired, a method other
	 * than Ajax could be used to obtain the required data, such as Web storage
	 * or an AIR database.
	 *
	 * The function is given four parameters and no return is required. The
	 * parameters are:
	 *
	 * 1. _object_ - Data to send to the server
	 * 2. _function_ - Callback function that must be executed when the required
	 *    data has been obtained. That data should be passed into the callback
	 *    as the only parameter
	 * 3. _object_ - DataTables settings object for the table
	 */
	"ajax": null,


	/**
	 * This parameter allows you to readily specify the entries in the length drop
	 * down menu that DataTables shows when pagination is enabled. It can be
	 * either a 1D array of options which will be used for both the displayed
	 * option and the value, or a 2D array which will use the array in the first
	 * position as the value, and the array in the second position as the
	 * displayed options (useful for language strings such as 'All').
	 *
	 * Note that the `pageLength` property will be automatically set to the
	 * first value given in this array, unless `pageLength` is also provided.
	 */
	"aLengthMenu": [ 10, 25, 50, 100 ],


	/**
	 * The `columns` option in the initialisation parameter allows you to define
	 * details about the way individual columns behave. For a full list of
	 * column options that can be set, please see
	 * {@link DataTable.defaults.column}. Note that if you use `columns` to
	 * define your columns, you must have an entry in the array for every single
	 * column that you have in your table (these can be null if you don't which
	 * to specify any options).
	 */
	"aoColumns": null,

	/**
	 * Very similar to `columns`, `columnDefs` allows you to target a specific
	 * column, multiple columns, or all columns, using the `targets` property of
	 * each object in the array. This allows great flexibility when creating
	 * tables, as the `columnDefs` arrays can be of any length, targeting the
	 * columns you specifically want. `columnDefs` may use any of the column
	 * options available: {@link DataTable.defaults.column}, but it _must_
	 * have `targets` defined in each object in the array. Values in the `targets`
	 * array may be:
	 *   <ul>
	 *     <li>a string - class name will be matched on the TH for the column</li>
	 *     <li>0 or a positive integer - column index counting from the left</li>
	 *     <li>a negative integer - column index counting from the right</li>
	 *     <li>the string "_all" - all columns (i.e. assign a default)</li>
	 *   </ul>
	 */
	"aoColumnDefs": null,


	/**
	 * Basically the same as `search`, this parameter defines the individual column
	 * filtering state at initialisation time. The array must be of the same size
	 * as the number of columns, and each element be an object with the parameters
	 * `search` and `escapeRegex` (the latter is optional). 'null' is also
	 * accepted and the default will be used.
	 */
	"aoSearchCols": [],


	/**
	 * Enable or disable automatic column width calculation. This can be disabled
	 * as an optimisation (it takes some time to calculate the widths) if the
	 * tables widths are passed in using `columns`.
	 */
	"bAutoWidth": true,


	/**
	 * Deferred rendering can provide DataTables with a huge speed boost when you
	 * are using an Ajax or JS data source for the table. This option, when set to
	 * true, will cause DataTables to defer the creation of the table elements for
	 * each row until they are needed for a draw - saving a significant amount of
	 * time.
	 */
	"bDeferRender": true,


	/**
	 * Replace a DataTable which matches the given selector and replace it with
	 * one which has the properties of the new initialisation object passed. If no
	 * table matches the selector, then the new DataTable will be constructed as
	 * per normal.
	 */
	"bDestroy": false,


	/**
	 * Enable or disable filtering of data. Filtering in DataTables is "smart" in
	 * that it allows the end user to input multiple words (space separated) and
	 * will match a row containing those words, even if not in the order that was
	 * specified (this allow matching across multiple columns). Note that if you
	 * wish to use filtering in DataTables this must remain 'true' - to remove the
	 * default filtering input box and retain filtering abilities, please use
	 * {@link DataTable.defaults.dom}.
	 */
	"bFilter": true,

	/**
	 * Used only for compatibility with DT1
	 * @deprecated
	 */
	"bInfo": true,

	/**
	 * Used only for compatibility with DT1
	 * @deprecated
	 */
	"bLengthChange": true,

	/**
	 * Enable or disable pagination.
	 */
	"bPaginate": true,


	/**
	 * Enable or disable the display of a 'processing' indicator when the table is
	 * being processed (e.g. a sort). This is particularly useful for tables with
	 * large amounts of data where it can take a noticeable amount of time to sort
	 * the entries.
	 */
	"bProcessing": false,


	/**
	 * Retrieve the DataTables object for the given selector. Note that if the
	 * table has already been initialised, this parameter will cause DataTables
	 * to simply return the object that has already been set up - it will not take
	 * account of any changes you might have made to the initialisation object
	 * passed to DataTables (setting this parameter to true is an acknowledgement
	 * that you understand this). `destroy` can be used to reinitialise a table if
	 * you need.
	 */
	"bRetrieve": false,


	/**
	 * When vertical (y) scrolling is enabled, DataTables will force the height of
	 * the table's viewport to the given height at all times (useful for layout).
	 * However, this can look odd when filtering data down to a small data set,
	 * and the footer is left "floating" further down. This parameter (when
	 * enabled) will cause DataTables to collapse the table's viewport down when
	 * the result set will fit within the given Y height.
	 */
	"bScrollCollapse": false,


	/**
	 * Configure DataTables to use server-side processing. Note that the
	 * `ajax` parameter must also be given in order to give DataTables a
	 * source to obtain the required data for each draw.
	 */
	"bServerSide": false,


	/**
	 * Enable or disable sorting of columns. Sorting of individual columns can be
	 * disabled by the `sortable` option for each column.
	 */
	"bSort": true,


	/**
	 * Enable or display DataTables' ability to sort multiple columns at the
	 * same time (activated by shift-click by the user).
	 */
	"bSortMulti": true,


	/**
	 * Allows control over whether DataTables should use the top (true) unique
	 * cell that is found for a single column, or the bottom (false - default).
	 * This is useful when using complex headers.
	 */
	"bSortCellsTop": null,


	/** Specify which row is the title row in the header. Replacement for bSortCellsTop */
	titleRow: null,


	/**
	 * Enable or disable the addition of the classes `sorting\_1`, `sorting\_2` and
	 * `sorting\_3` to the columns which are currently being sorted on. This is
	 * presented as a feature switch as it can increase processing time (while
	 * classes are removed and added) so for large data sets you might want to
	 * turn this off.
	 */
	"bSortClasses": true,


	/**
	 * Enable or disable state saving. When enabled HTML5 `localStorage` will be
	 * used to save table display information such as pagination information,
	 * display length, filtering and sorting. As such when the end user reloads
	 * the page the display will match what thy had previously set up.
	 */
	"bStateSave": false,


	/**
	 * This function is called when a TR element is created (and all TD child
	 * elements have been inserted), or registered if using a DOM source, allowing
	 * manipulation of the TR element (adding classes etc).
	 */
	"fnCreatedRow": null,


	/**
	 * This function is called on every 'draw' event, and allows you to
	 * dynamically modify any aspect you want about the created DOM.
	 */
	"fnDrawCallback": null,


	/**
	 * Identical to fnHeaderCallback() but for the table footer this function
	 * allows you to modify the table footer on every 'draw' event.
	 */
	"fnFooterCallback": null,


	/**
	 * When rendering large numbers in the information element for the table
	 * (i.e. "Showing 1 to 10 of 57 entries") DataTables will render large numbers
	 * to have a comma separator for the 'thousands' units (e.g. 1 million is
	 * rendered as "1,000,000") to help readability for the end user. This
	 * function will override the default method DataTables uses.
	 */
	"fnFormatNumber": function ( toFormat ) {
		return toFormat.toString().replace(
			/\B(?=(\d{3})+(?!\d))/g,
			this.oLanguage.sThousands
		);
	},


	/**
	 * This function is called on every 'draw' event, and allows you to
	 * dynamically modify the header row. This can be used to calculate and
	 * display useful information about the table.
	 */
	"fnHeaderCallback": null,


	/**
	 * The information element can be used to convey information about the current
	 * state of the table. Although the internationalisation options presented by
	 * DataTables are quite capable of dealing with most customisations, there may
	 * be times where you wish to customise the string further. This callback
	 * allows you to do exactly that.
	 */
	"fnInfoCallback": null,


	/**
	 * Called when the table has been initialised. Normally DataTables will
	 * initialise sequentially and there will be no need for this function,
	 * however, this does not hold true when using external language information
	 * since that is obtained using an async XHR call.
	 */
	"fnInitComplete": null,


	/**
	 * Called at the very start of each table draw and can be used to cancel the
	 * draw by returning false, any other return (including undefined) results in
	 * the full draw occurring).
	 */
	"fnPreDrawCallback": null,


	/**
	 * This function allows you to 'post process' each row after it have been
	 * generated for each table draw, but before it is rendered on screen. This
	 * function might be used for setting the row class name etc.
	 */
	"fnRowCallback": null,


	/**
	 * Load the table state. With this function you can define from where, and how, the
	 * state of a table is loaded. By default DataTables will load from `localStorage`
	 * but you might wish to use a server-side database or cookies.
	 */
	"fnStateLoadCallback": function ( settings ) {
		try {
			return JSON.parse(
				(settings.iStateDuration === -1 ? sessionStorage : localStorage).getItem(
					'DataTables_'+settings.sInstance+'_'+location.pathname
				)
			);
		} catch (e) {
			return {};
		}
	},


	/**
	 * Callback which allows modification of the saved state prior to loading that state.
	 * This callback is called when the table is loading state from the stored data, but
	 * prior to the settings object being modified by the saved state. Note that for
	 * plug-in authors, you should use the `stateLoadParams` event to load parameters for
	 * a plug-in.
	 */
	"fnStateLoadParams": null,


	/**
	 * Callback that is called when the state has been loaded from the state saving method
	 * and the DataTables settings object has been modified as a result of the loaded state.
	 */
	"fnStateLoaded": null,


	/**
	 * Save the table state. This function allows you to define where and how the state
	 * information for the table is stored By default DataTables will use `localStorage`
	 * but you might wish to use a server-side database or cookies.
	 */
	"fnStateSaveCallback": function ( settings, data ) {
		try {
			(settings.iStateDuration === -1 ? sessionStorage : localStorage).setItem(
				'DataTables_'+settings.sInstance+'_'+location.pathname,
				JSON.stringify( data )
			);
		} catch (e) {
			// noop
		}
	},


	/**
	 * Callback which allows modification of the state to be saved. Called when the table
	 * has changed state a new state save is required. This method allows modification of
	 * the state saving object prior to actually doing the save, including addition or
	 * other state properties or modification. Note that for plug-in authors, you should
	 * use the `stateSaveParams` event to save parameters for a plug-in.
	 */
	"fnStateSaveParams": null,


	/**
	 * Duration for which the saved state information is considered valid. After this period
	 * has elapsed the state will be returned to the default.
	 * Value is given in seconds.
	 */
	"iStateDuration": 7200,


	/**
	 * Number of rows to display on a single page when using pagination. If
	 * feature enabled (`lengthChange`) then the end user will be able to override
	 * this to a custom setting using a pop-up menu.
	 */
	"iDisplayLength": 10,


	/**
	 * Define the starting point for data display when using DataTables with
	 * pagination. Note that this parameter is the number of records, rather than
	 * the page number, so if you have 10 records per page and want to start on
	 * the third page, it should be "20".
	 */
	"iDisplayStart": 0,


	/**
	 * By default DataTables allows keyboard navigation of the table (sorting, paging,
	 * and filtering) by adding a `tabindex` attribute to the required elements. This
	 * allows you to tab through the controls and press the enter key to activate them.
	 * The tabindex is default 0, meaning that the tab follows the flow of the document.
	 * You can overrule this using this parameter if you wish. Use a value of -1 to
	 * disable built-in keyboard navigation.
	 */
	"iTabIndex": 0,


	/**
	 * Classes that DataTables assigns to the various components and features
	 * that it adds to the HTML table. This allows classes to be configured
	 * during initialisation in addition to through the static
	 * {@link DataTable.ext.oStdClasses} object).
	 */
	"oClasses": {},


	/**
	 * All strings that DataTables uses in the user interface that it creates
	 * are defined in this object, allowing you to modified them individually or
	 * completely replace them all as required.
	 */
	"oLanguage": {
		/**
		 * Strings that are used for WAI-ARIA labels and controls only (these are not
		 * actually visible on the page, but will be read by screenreaders, and thus
		 * must be internationalised as well).
		 */
		"oAria": {
			/**
			 * ARIA label that is added to the table headers when the column may be sorted
			 */
			"orderable": ": Activate to sort",

			/**
			 * ARIA label that is added to the table headers when the column is currently being sorted
			 */
			"orderableReverse": ": Activate to invert sorting",

			/**
			 * ARIA label that is added to the table headers when the column is currently being 
			 * sorted and next step is to remove sorting
			 */
			"orderableRemove": ": Activate to remove sorting",

			paginate: {
				first: 'First',
				last: 'Last',
				next: 'Next',
				previous: 'Previous',
				number: ''
			}
		},

		/**
		 * Pagination string used by DataTables for the built-in pagination
		 * control types.
		 */
		"oPaginate": {
			/**
			 * Label and character for first page button («)
			 */
			"sFirst": "\u00AB",

			/**
			 * Last page button (»)
			 */
			"sLast": "\u00BB",

			/**
			 * Next page button (›)
			 */
			"sNext": "\u203A",

			/**
			 * Previous page button (‹)
			 */
			"sPrevious": "\u2039",
		},

		/**
		 * Plural object for the data type the table is showing
		 */
		entries: {
			_: "entries",
			1: "entry"
		},

		/**
		 * Page length options
		 */
		lengthLabels: {
			'-1': 'All'
		},

		/**
		 * This string is shown in preference to `zeroRecords` when the table is
		 * empty of data (regardless of filtering). Note that this is an optional
		 * parameter - if it is not given, the value of `zeroRecords` will be used
		 * instead (either the default or given value).
		 */
		"sEmptyTable": "No data available in table",


		/**
		 * This string gives information to the end user about the information
		 * that is current on display on the page. The following tokens can be
		 * used in the string and will be dynamically replaced as the table
		 * display updates. This tokens can be placed anywhere in the string, or
		 * removed as needed by the language requires:
		 *
		 * * `\_START\_` - Display index of the first record on the current page
		 * * `\_END\_` - Display index of the last record on the current page
		 * * `\_TOTAL\_` - Number of records in the table after filtering
		 * * `\_MAX\_` - Number of records in the table without filtering
		 * * `\_PAGE\_` - Current page number
		 * * `\_PAGES\_` - Total number of pages of data in the table
		 */
		"sInfo": "Showing _START_ to _END_ of _TOTAL_ _ENTRIES-TOTAL_",


		/**
		 * Display information string for when the table is empty. Typically the
		 * format of this string should match `info`.
		 */
		"sInfoEmpty": "Showing 0 to 0 of 0 _ENTRIES-TOTAL_",


		/**
		 * When a user filters the information in a table, this string is appended
		 * to the information (`info`) to give an idea of how strong the filtering
		 * is. The variable _MAX_ is dynamically updated.
		 */
		"sInfoFiltered": "(filtered from _MAX_ total _ENTRIES-MAX_)",


		/**
		 * If can be useful to append extra information to the info string at times,
		 * and this variable does exactly that. This information will be appended to
		 * the `info` (`infoEmpty` and `infoFiltered` in whatever combination they are
		 * being used) at all times.
		 */
		"sInfoPostFix": "",


		/**
		 * This decimal place operator is a little different from the other
		 * language options since DataTables doesn't output floating point
		 * numbers, so it won't ever use this for display of a number. Rather,
		 * what this parameter does is modify the sort methods of the table so
		 * that numbers which are in a format which has a character other than
		 * a period (`.`) as a decimal place will be sorted numerically.
		 *
		 * Note that numbers with different decimal places cannot be shown in
		 * the same table and still be sortable, the table must be consistent.
		 * However, multiple different tables on the page can use different
		 * decimal place characters.
		 */
		"sDecimal": "",


		/**
		 * DataTables has a build in number formatter (`formatNumber`) which is
		 * used to format large numbers that are used in the table information.
		 * By default a comma is used, but this can be trivially changed to any
		 * character you wish with this parameter.
		 */
		"sThousands": ",",


		/**
		 * Detail the action that will be taken when the drop down menu for the
		 * pagination length option is changed. The '_MENU_' variable is replaced
		 * with a default select list of 10, 25, 50 and 100, and can be replaced
		 * with a custom select box if required.
		 */
		"sLengthMenu": "_MENU_ _ENTRIES_ per page",


		/**
		 * When using Ajax sourced data and during the first draw when DataTables is
		 * gathering the data, this message is shown in an empty row in the table to
		 * indicate to the end user the data is being loaded. Note that this
		 * parameter is not used when loading data by server-side processing, just
		 * Ajax sourced data with client-side processing.
		 */
		"sLoadingRecords": "Loading...",


		/**
		 * Text which is displayed when the table is processing a user action
		 * (usually a sort command or similar).
		 */
		"sProcessing": "",


		/**
		 * Details the actions that will be taken when the user types into the
		 * filtering input text box. The variable "_INPUT_", if used in the string,
		 * is replaced with the HTML text box for the filtering input allowing
		 * control over where it appears in the string. If "_INPUT_" is not given
		 * then the input box is appended to the string automatically.
		 */
		"sSearch": "Search:",


		/**
		 * Assign a `placeholder` attribute to the search `input` element
		 *  @type string
		 *  @default 
		 *
		 *  @dtopt Language
		 *  @name DataTable.defaults.language.searchPlaceholder
		 */
		"sSearchPlaceholder": "",


		/**
		 * All of the language information can be stored in a file on the
		 * server-side, which DataTables will look up if this parameter is passed.
		 * It must store the URL of the language file, which is in a JSON format,
		 * and the object has the same properties as the oLanguage object in the
		 * initialiser object (i.e. the above parameters). Please refer to one of
		 * the example language files to see how this works in action.
		 */
		"sUrl": "",


		/**
		 * Text shown inside the table records when the is no information to be
		 * displayed after filtering. `emptyTable` is shown when there is simply no
		 * information in the table at all (regardless of filtering).
		 */
		"sZeroRecords": "No matching records found"
	},


	/** The initial data order is reversed when `desc` ordering */
	orderDescReverse: true,


	/**
	 * This parameter allows you to have define the global filtering state at
	 * initialisation time. As an object the `search` parameter must be
	 * defined, but all other parameters are optional. When `regex` is true,
	 * the search string will be treated as a regular expression, when false
	 * (default) it will be treated as a straight string. When `smart`
	 * DataTables will use it's smart filtering methods (to word match at
	 * any point in the data), when false this will not be done.
	 */
	"oSearch": $.extend( {}, DataTable.models.oSearch ),


	/**
	 * Table and control layout. This replaces the legacy `dom` option.
	 */
	layout: {
		topStart: 'pageLength',
		topEnd: 'search',
		bottomStart: 'info',
		bottomEnd: 'paging'
	},


	/**
	 * Legacy DOM layout option
	 */
	"sDom": null,


	/**
	 * Search delay option. This will throttle full table searches that use the
	 * DataTables provided search input element (it does not effect calls to
	 * `dt-api search()`, providing a delay before the search is made.
	 */
	"searchDelay": null,


	/**
	 * DataTables features six different built-in options for the buttons to
	 * display for pagination control:
	 *
	 * * `numbers` - Page number buttons only
	 * * `simple` - 'Previous' and 'Next' buttons only
	 * * 'simple_numbers` - 'Previous' and 'Next' buttons, plus page numbers
	 * * `full` - 'First', 'Previous', 'Next' and 'Last' buttons
	 * * `full_numbers` - 'First', 'Previous', 'Next' and 'Last' buttons, plus page numbers
	 * * `first_last_numbers` - 'First' and 'Last' buttons, plus page numbers
	 */
	"sPaginationType": "",


	/**
	 * Enable horizontal scrolling. When a table is too wide to fit into a
	 * certain layout, or you have a large number of columns in the table, you
	 * can enable x-scrolling to show the table in a viewport, which can be
	 * scrolled. This property can be `true` which will allow the table to
	 * scroll horizontally when needed, or any CSS unit, or a number (in which
	 * case it will be treated as a pixel measurement). Setting as simply `true`
	 * is recommended.
	 */
	"sScrollX": "",


	/**
	 * This property can be used to force a DataTable to use more width than it
	 * might otherwise do when x-scrolling is enabled. For example if you have a
	 * table which requires to be well spaced, this parameter is useful for
	 * "over-sizing" the table, and thus forcing scrolling. This property can by
	 * any CSS unit, or a number (in which case it will be treated as a pixel
	 * measurement).
	 */
	"sScrollXInner": "",


	/**
	 * Enable vertical scrolling. Vertical scrolling will constrain the DataTable
	 * to the given height, and enable scrolling for any data which overflows the
	 * current viewport. This can be used as an alternative to paging to display
	 * a lot of data in a small area (although paging and scrolling can both be
	 * enabled at the same time). This property can be any CSS unit, or a number
	 * (in which case it will be treated as a pixel measurement).
	 */
	"sScrollY": "",


	/**
	 * __Deprecated__ The functionality provided by this parameter has now been
	 * superseded by that provided through `ajax`, which should be used instead.
	 *
	 * Set the HTTP method that is used to make the Ajax call for server-side
	 * processing or Ajax sourced data.
	 */
	"sServerMethod": "GET",


	/**
	 * DataTables makes use of renderers when displaying HTML elements for
	 * a table. These renderers can be added or modified by plug-ins to
	 * generate suitable mark-up for a site. For example the Bootstrap
	 * integration plug-in for DataTables uses a paging button renderer to
	 * display pagination buttons in the mark-up required by Bootstrap.
	 *
	 * For further information about the renderers available see
	 * DataTable.ext.renderer
	 */
	"renderer": null,


	/**
	 * Set the data property name that DataTables should use to get a row's id
	 * to set as the `id` property in the node.
	 */
	"rowId": "DT_RowId",


	/**
	 * Caption value
	 */
	"caption": null,


	/**
	 * For server-side processing - use the data from the DOM for the first draw
	 */
	iDeferLoading: null,

	/** Event listeners */
	on: null,

	/** Title wrapper element type */
	columnTitleTag: 'span'
};

_fnHungarianMap( DataTable.defaults );



/*
 * Developer note - See note in model.defaults.js about the use of Hungarian
 * notation and camel case.
 */

/**
 * Column options that can be given to DataTables at initialisation time.
 *  @namespace
 */
DataTable.defaults.column = {
	/**
	 * Define which column(s) an order will occur on for this column. This
	 * allows a column's ordering to take multiple columns into account when
	 * doing a sort or use the data from a different column. For example first
	 * name / last name columns make sense to do a multi-column sort over the
	 * two columns.
	 */
	"aDataSort": null,
	"iDataSort": -1,

	ariaTitle: '',


	/**
	 * You can control the default ordering direction, and even alter the
	 * behaviour of the sort handler (i.e. only allow ascending ordering etc)
	 * using this parameter.
	 */
	"asSorting": [ 'asc', 'desc', '' ],


	/**
	 * Enable or disable filtering on the data in this column.
	 */
	"bSearchable": true,


	/**
	 * Enable or disable ordering on this column.
	 */
	"bSortable": true,


	/**
	 * Enable or disable the display of this column.
	 */
	"bVisible": true,


	/**
	 * Developer definable function that is called whenever a cell is created (Ajax source,
	 * etc) or processed for input (DOM source). This can be used as a compliment to mRender
	 * allowing you to modify the DOM element (add background colour for example) when the
	 * element is available.
	 */
	"fnCreatedCell": null,


	/**
	 * This property can be used to read data from any data source property,
	 * including deeply nested objects / properties. `data` can be given in a
	 * number of different ways which effect its behaviour:
	 *
	 * * `integer` - treated as an array index for the data source. This is the
	 *   default that DataTables uses (incrementally increased for each column).
	 * * `string` - read an object property from the data source. There are
	 *   three 'special' options that can be used in the string to alter how
	 *   DataTables reads the data from the source object:
	 *    * `.` - Dotted JavaScript notation. Just as you use a `.` in
	 *      JavaScript to read from nested objects, so to can the options
	 *      specified in `data`. For example: `browser.version` or
	 *      `browser.name`. If your object parameter name contains a period, use
	 *      `\\` to escape it - i.e. `first\\.name`.
	 *    * `[]` - Array notation. DataTables can automatically combine data
	 *      from and array source, joining the data with the characters provided
	 *      between the two brackets. For example: `name[, ]` would provide a
	 *      comma-space separated list from the source array. If no characters
	 *      are provided between the brackets, the original array source is
	 *      returned.
	 *    * `()` - Function notation. Adding `()` to the end of a parameter will
	 *      execute a function of the name given. For example: `browser()` for a
	 *      simple function on the data source, `browser.version()` for a
	 *      function in a nested property or even `browser().version` to get an
	 *      object property if the function called returns an object. Note that
	 *      function notation is recommended for use in `render` rather than
	 *      `data` as it is much simpler to use as a renderer.
	 * * `null` - use the original data source for the row rather than plucking
	 *   data directly from it. This action has effects on two other
	 *   initialisation options:
	 *    * `defaultContent` - When null is given as the `data` option and
	 *      `defaultContent` is specified for the column, the value defined by
	 *      `defaultContent` will be used for the cell.
	 *    * `render` - When null is used for the `data` option and the `render`
	 *      option is specified for the column, the whole data source for the
	 *      row is used for the renderer.
	 * * `function` - the function given will be executed whenever DataTables
	 *   needs to set or get the data for a cell in the column. The function
	 *   takes three parameters:
	 *    * Parameters:
	 *      * `{array|object}` The data source for the row
	 *      * `{string}` The type call data requested - this will be 'set' when
	 *        setting data or 'filter', 'display', 'type', 'sort' or undefined
	 *        when gathering data. Note that when `undefined` is given for the
	 *        type DataTables expects to get the raw data for the object back<
	 *      * `{*}` Data to set when the second parameter is 'set'.
	 *    * Return:
	 *      * The return value from the function is not required when 'set' is
	 *        the type of call, but otherwise the return is what will be used
	 *        for the data requested.
	 *
	 * Note that `data` is a getter and setter option. If you just require
	 * formatting of data for output, you will likely want to use `render` which
	 * is simply a getter and thus simpler to use.
	 *
	 * Note that prior to DataTables 1.9.2 `data` was called `mDataProp`. The
	 * name change reflects the flexibility of this property and is consistent
	 * with the naming of mRender. If 'mDataProp' is given, then it will still
	 * be used by DataTables, as it automatically maps the old name to the new
	 * if required.
	 */
	"mData": null,


	/**
	 * This property is the rendering partner to `data` and it is suggested that
	 * when you want to manipulate data for display (including filtering,
	 * sorting etc) without altering the underlying data for the table, use this
	 * property. `render` can be considered to be the read only companion to
	 * `data` which is read / write (then as such more complex). Like `data`
	 * this option can be given in a number of different ways to effect its
	 * behaviour:
	 *
	 * * `integer` - treated as an array index for the data source. This is the
	 *   default that DataTables uses (incrementally increased for each column).
	 * * `string` - read an object property from the data source. There are
	 *   three 'special' options that can be used in the string to alter how
	 *   DataTables reads the data from the source object:
	 *    * `.` - Dotted JavaScript notation. Just as you use a `.` in
	 *      JavaScript to read from nested objects, so to can the options
	 *      specified in `data`. For example: `browser.version` or
	 *      `browser.name`. If your object parameter name contains a period, use
	 *      `\\` to escape it - i.e. `first\\.name`.
	 *    * `[]` - Array notation. DataTables can automatically combine data
	 *      from and array source, joining the data with the characters provided
	 *      between the two brackets. For example: `name[, ]` would provide a
	 *      comma-space separated list from the source array. If no characters
	 *      are provided between the brackets, the original array source is
	 *      returned.
	 *    * `()` - Function notation. Adding `()` to the end of a parameter will
	 *      execute a function of the name given. For example: `browser()` for a
	 *      simple function on the data source, `browser.version()` for a
	 *      function in a nested property or even `browser().version` to get an
	 *      object property if the function called returns an object.
	 * * `object` - use different data for the different data types requested by
	 *   DataTables ('filter', 'display', 'type' or 'sort'). The property names
	 *   of the object is the data type the property refers to and the value can
	 *   defined using an integer, string or function using the same rules as
	 *   `render` normally does. Note that an `_` option _must_ be specified.
	 *   This is the default value to use if you haven't specified a value for
	 *   the data type requested by DataTables.
	 * * `function` - the function given will be executed whenever DataTables
	 *   needs to set or get the data for a cell in the column. The function
	 *   takes three parameters:
	 *    * Parameters:
	 *      * {array|object} The data source for the row (based on `data`)
	 *      * {string} The type call data requested - this will be 'filter',
	 *        'display', 'type' or 'sort'.
	 *      * {array|object} The full data source for the row (not based on
	 *        `data`)
	 *    * Return:
	 *      * The return value from the function is what will be used for the
	 *        data requested.
	 */
	"mRender": null,


	/**
	 * Change the cell type created for the column - either TD cells or TH cells. This
	 * can be useful as TH cells have semantic meaning in the table body, allowing them
	 * to act as a header for a row (you may wish to add scope='row' to the TH elements).
	 */
	"sCellType": "td",


	/**
	 * Class to give to each cell in this column.
	 */
	"sClass": "",

	/**
	 * When DataTables calculates the column widths to assign to each column,
	 * it finds the longest string in each column and then constructs a
	 * temporary table and reads the widths from that. The problem with this
	 * is that "mmm" is much wider then "iiii", but the latter is a longer
	 * string - thus the calculation can go wrong (doing it properly and putting
	 * it into an DOM object and measuring that is horribly(!) slow). Thus as
	 * a "work around" we provide this option. It will append its value to the
	 * text that is found to be the longest string for the column - i.e. padding.
	 * Generally you shouldn't need this!
	 */
	"sContentPadding": "",


	/**
	 * Allows a default value to be given for a column's data, and will be used
	 * whenever a null data source is encountered (this can be because `data`
	 * is set to null, or because the data source itself is null).
	 */
	"sDefaultContent": null,


	/**
	 * This parameter is only used in DataTables' server-side processing. It can
	 * be exceptionally useful to know what columns are being displayed on the
	 * client side, and to map these to database fields. When defined, the names
	 * also allow DataTables to reorder information from the server if it comes
	 * back in an unexpected order (i.e. if you switch your columns around on the
	 * client-side, your server-side code does not also need updating).
	 */
	"sName": "",


	/**
	 * Defines a data source type for the ordering which can be used to read
	 * real-time information from the table (updating the internally cached
	 * version) prior to ordering. This allows ordering to occur on user
	 * editable elements such as form inputs.
	 */
	"sSortDataType": "std",


	/**
	 * The title of this column.
	 */
	"sTitle": null,


	/**
	 * The type allows you to specify how the data for this column will be
	 * ordered. Four types (string, numeric, date and html (which will strip
	 * HTML tags before ordering)) are currently available. Note that only date
	 * formats understood by JavaScript's Date() object will be accepted as type
	 * date. For example: "Mar 26, 2008 5:03 PM". May take the values: 'string',
	 * 'numeric', 'date' or 'html' (by default). Further types can be adding
	 * through plug-ins.
	 */
	"sType": null,


	/**
	 * Defining the width of the column, this parameter may take any CSS value
	 * (3em, 20px etc). DataTables applies 'smart' widths to columns which have not
	 * been given a specific width through this interface ensuring that the table
	 * remains readable.
	 */
	"sWidth": null
};

_fnHungarianMap( DataTable.defaults.column );



/**
 * DataTables settings object - this holds all the information needed for a
 * given table, including configuration, data and current application of the
 * table options. DataTables does not have a single instance for each DataTable
 * with the settings attached to that instance, but rather instances of the
 * DataTable "class" are created on-the-fly as needed (typically by a
 * $().dataTable() call) and the settings object is then applied to that
 * instance.
 *
 * Note that this object is related to {@link DataTable.defaults} but this
 * one is the internal data store for DataTables's cache of columns. It should
 * NOT be manipulated outside of DataTables. Any configuration should be done
 * through the initialisation options.
 */
DataTable.models.oSettings = {
	/**
	 * Primary features of DataTables and their enablement state.
	 */
	"oFeatures": {

		/**
		 * Flag to say if DataTables should automatically try to calculate the
		 * optimum table and columns widths (true) or not (false).
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bAutoWidth": null,

		/**
		 * Delay the creation of TR and TD elements until they are actually
		 * needed by a driven page draw. This can give a significant speed
		 * increase for Ajax source and JavaScript source data, but makes no
		 * difference at all for DOM and server-side processing tables.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bDeferRender": null,

		/**
		 * Enable filtering on the table or not. Note that if this is disabled
		 * then there is no filtering at all on the table, including fnFilter.
		 * To just remove the filtering input use sDom and remove the 'f' option.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bFilter": null,

		/**
		 * Used only for compatibility with DT1
		 * @deprecated
		 */
		"bInfo": true,

		/**
		 * Used only for compatibility with DT1
		 * @deprecated
		 */
		"bLengthChange": true,

		/**
		 * Pagination enabled or not. Note that if this is disabled then length
		 * changing must also be disabled.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bPaginate": null,

		/**
		 * Processing indicator enable flag whenever DataTables is enacting a
		 * user request - typically an Ajax request for server-side processing.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bProcessing": null,

		/**
		 * Server-side processing enabled flag - when enabled DataTables will
		 * get all data from the server for every draw - there is no filtering,
		 * sorting or paging done on the client-side.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bServerSide": null,

		/**
		 * Sorting enablement flag.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSort": null,

		/**
		 * Multi-column sorting
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSortMulti": null,

		/**
		 * Apply a class to the columns which are being sorted to provide a
		 * visual highlight or not. This can slow things down when enabled since
		 * there is a lot of DOM interaction.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSortClasses": null,

		/**
		 * State saving enablement flag.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bStateSave": null
	},


	/**
	 * Scrolling settings for a table.
	 */
	"oScroll": {
		/**
		 * When the table is shorter in height than sScrollY, collapse the
		 * table container down to the height of the table (when true).
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bCollapse": null,

		/**
		 * Width of the scrollbar for the web-browser's platform. Calculated
		 * during table initialisation.
		 */
		"iBarWidth": 0,

		/**
		 * Viewport width for horizontal scrolling. Horizontal scrolling is
		 * disabled if an empty string.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"sX": null,

		/**
		 * Width to expand the table to when using x-scrolling. Typically you
		 * should not need to use this.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 *  @deprecated
		 */
		"sXInner": null,

		/**
		 * Viewport height for vertical scrolling. Vertical scrolling is disabled
		 * if an empty string.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"sY": null
	},

	/**
	 * Language information for the table.
	 */
	"oLanguage": {
		/**
		 * Information callback function. See
		 * {@link DataTable.defaults.fnInfoCallback}
		 */
		"fnInfoCallback": null
	},

	/**
	 * Browser support parameters
	 */
	"oBrowser": {
		/**
		 * Determine if the vertical scrollbar is on the right or left of the
		 * scrolling container - needed for rtl language layout, although not
		 * all browsers move the scrollbar (Safari).
		 */
		"bScrollbarLeft": false,

		/**
		 * Browser scrollbar width
		 */
		"barWidth": 0
	},


	"ajax": null,


	/**
	 * Array referencing the nodes which are used for the features. The
	 * parameters of this object match what is allowed by sDom - i.e.
	 *   <ul>
	 *     <li>'l' - Length changing</li>
	 *     <li>'f' - Filtering input</li>
	 *     <li>'t' - The table!</li>
	 *     <li>'i' - Information</li>
	 *     <li>'p' - Pagination</li>
	 *     <li>'r' - pRocessing</li>
	 *   </ul>
	 */
	"aanFeatures": [],

	/**
	 * Store data information - see {@link DataTable.models.oRow} for detailed
	 * information.
	 */
	"aoData": [],

	/**
	 * Array of indexes which are in the current display (after filtering etc)
	 */
	"aiDisplay": [],

	/**
	 * Array of indexes for display - no filtering
	 */
	"aiDisplayMaster": [],

	/**
	 * Map of row ids to data indexes
	 */
	"aIds": {},

	/**
	 * Store information about each column that is in use
	 */
	"aoColumns": [],

	/**
	 * Store information about the table's header
	 */
	"aoHeader": [],

	/**
	 * Store information about the table's footer
	 */
	"aoFooter": [],

	/**
	 * Store the applied global search information in case we want to force a
	 * research or compare the old search to a new one.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"oPreviousSearch": {},

	/**
	 * Store for named searches
	 */
	searchFixed: {},

	/**
	 * Store the applied search for each column - see
	 * {@link DataTable.models.oSearch} for the format that is used for the
	 * filtering information for each column.
	 */
	"aoPreSearchCols": [],

	/**
	 * Sorting that is applied to the table. Note that the inner arrays are
	 * used in the following manner:
	 * <ul>
	 *   <li>Index 0 - column number</li>
	 *   <li>Index 1 - current sorting direction</li>
	 * </ul>
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aaSorting": null,

	/**
	 * Sorting that is always applied to the table (i.e. prefixed in front of
	 * aaSorting).
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aaSortingFixed": [],

	/**
	 * If restoring a table - we should restore its width
	 */
	"sDestroyWidth": 0,

	/**
	 * Callback functions array for every time a row is inserted (i.e. on a draw).
	 */
	"aoRowCallback": [],

	/**
	 * Callback functions for the header on each draw.
	 */
	"aoHeaderCallback": [],

	/**
	 * Callback function for the footer on each draw.
	 */
	"aoFooterCallback": [],

	/**
	 * Array of callback functions for draw callback functions
	 */
	"aoDrawCallback": [],

	/**
	 * Array of callback functions for row created function
	 */
	"aoRowCreatedCallback": [],

	/**
	 * Callback functions for just before the table is redrawn. A return of
	 * false will be used to cancel the draw.
	 */
	"aoPreDrawCallback": [],

	/**
	 * Callback functions for when the table has been initialised.
	 */
	"aoInitComplete": [],


	/**
	 * Callbacks for modifying the settings to be stored for state saving, prior to
	 * saving state.
	 */
	"aoStateSaveParams": [],

	/**
	 * Callbacks for modifying the settings that have been stored for state saving
	 * prior to using the stored values to restore the state.
	 */
	"aoStateLoadParams": [],

	/**
	 * Callbacks for operating on the settings object once the saved state has been
	 * loaded
	 */
	"aoStateLoaded": [],

	/**
	 * Cache the table ID for quick access
	 */
	"sTableId": "",

	/**
	 * The TABLE node for the main table
	 */
	"nTable": null,

	/**
	 * Permanent ref to the thead element
	 */
	"nTHead": null,

	/**
	 * Permanent ref to the tfoot element - if it exists
	 */
	"nTFoot": null,

	/**
	 * Permanent ref to the tbody element
	 */
	"nTBody": null,

	/**
	 * Cache the wrapper node (contains all DataTables controlled elements)
	 */
	"nTableWrapper": null,

	/**
	 * Indicate if all required information has been read in
	 */
	"bInitialised": false,

	/**
	 * Information about open rows. Each object in the array has the parameters
	 * 'nTr' and 'nParent'
	 */
	"aoOpenRows": [],

	/**
	 * Dictate the positioning of DataTables' control elements - see
	 * {@link DataTable.model.oInit.sDom}.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sDom": null,

	/**
	 * Search delay (in mS)
	 */
	"searchDelay": null,

	/**
	 * Which type of pagination should be used.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sPaginationType": "two_button",

	/**
	 * Number of paging controls on the page. Only used for backwards compatibility
	 */
	pagingControls: 0,

	/**
	 * The state duration (for `stateSave`) in seconds.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"iStateDuration": 0,

	/**
	 * Array of callback functions for state saving. Each array element is an
	 * object with the following parameters:
	 *   <ul>
	 *     <li>function:fn - function to call. Takes two parameters, oSettings
	 *       and the JSON string to save that has been thus far created. Returns
	 *       a JSON string to be inserted into a json object
	 *       (i.e. '"param": [ 0, 1, 2]')</li>
	 *     <li>string:sName - name of callback</li>
	 *   </ul>
	 */
	"aoStateSave": [],

	/**
	 * Array of callback functions for state loading. Each array element is an
	 * object with the following parameters:
	 *   <ul>
	 *     <li>function:fn - function to call. Takes two parameters, oSettings
	 *       and the object stored. May return false to cancel state loading</li>
	 *     <li>string:sName - name of callback</li>
	 *   </ul>
	 */
	"aoStateLoad": [],

	/**
	 * State that was saved. Useful for back reference
	 */
	"oSavedState": null,

	/**
	 * State that was loaded. Useful for back reference
	 */
	"oLoadedState": null,

	/**
	 * Note if draw should be blocked while getting data
	 */
	"bAjaxDataGet": true,

	/**
	 * The last jQuery XHR object that was used for server-side data gathering.
	 * This can be used for working with the XHR information in one of the
	 * callbacks
	 */
	"jqXHR": null,

	/**
	 * JSON returned from the server in the last Ajax request
	 */
	"json": undefined,

	/**
	 * Data submitted as part of the last Ajax request
	 */
	"oAjaxData": undefined,

	/**
	 * Send the XHR HTTP method - GET or POST (could be PUT or DELETE if
	 * required).
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sServerMethod": null,

	/**
	 * Format numbers for display.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"fnFormatNumber": null,

	/**
	 * List of options that can be used for the user selectable length menu.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aLengthMenu": null,

	/**
	 * Counter for the draws that the table does. Also used as a tracker for
	 * server-side processing
	 */
	"iDraw": 0,

	/**
	 * Indicate if a redraw is being done - useful for Ajax
	 */
	"bDrawing": false,

	/**
	 * Draw index (iDraw) of the last error when parsing the returned data
	 */
	"iDrawError": -1,

	/**
	 * Paging display length
	 */
	"_iDisplayLength": 10,

	/**
	 * Paging start point - aiDisplay index
	 */
	"_iDisplayStart": 0,

	/**
	 * Server-side processing - number of records in the result set
	 * (i.e. before filtering), Use fnRecordsTotal rather than
	 * this property to get the value of the number of records, regardless of
	 * the server-side processing setting.
	 */
	"_iRecordsTotal": 0,

	/**
	 * Server-side processing - number of records in the current display set
	 * (i.e. after filtering). Use fnRecordsDisplay rather than
	 * this property to get the value of the number of records, regardless of
	 * the server-side processing setting.
	 */
	"_iRecordsDisplay": 0,

	/**
	 * The classes to use for the table
	 */
	"oClasses": {},

	/**
	 * Flag attached to the settings object so you can check in the draw
	 * callback if filtering has been done in the draw. Deprecated in favour of
	 * events.
	 *  @deprecated
	 */
	"bFiltered": false,

	/**
	 * Flag attached to the settings object so you can check in the draw
	 * callback if sorting has been done in the draw. Deprecated in favour of
	 * events.
	 *  @deprecated
	 */
	"bSorted": false,

	/**
	 * Indicate that if multiple rows are in the header and there is more than
	 * one unique cell per column. Replaced by titleRow
	 */
	"bSortCellsTop": null,

	/**
	 * Initialisation object that is used for the table
	 */
	"oInit": null,

	/**
	 * Destroy callback functions - for plug-ins to attach themselves to the
	 * destroy so they can clean up markup and events.
	 */
	"aoDestroyCallback": [],


	/**
	 * Get the number of records in the current record set, before filtering
	 */
	"fnRecordsTotal": function ()
	{
		return _fnDataSource( this ) == 'ssp' ?
			this._iRecordsTotal * 1 :
			this.aiDisplayMaster.length;
	},

	/**
	 * Get the number of records in the current record set, after filtering
	 */
	"fnRecordsDisplay": function ()
	{
		return _fnDataSource( this ) == 'ssp' ?
			this._iRecordsDisplay * 1 :
			this.aiDisplay.length;
	},

	/**
	 * Get the display end point - aiDisplay index
	 */
	"fnDisplayEnd": function ()
	{
		var
			len      = this._iDisplayLength,
			start    = this._iDisplayStart,
			calc     = start + len,
			records  = this.aiDisplay.length,
			features = this.oFeatures,
			paginate = features.bPaginate;

		if ( features.bServerSide ) {
			return paginate === false || len === -1 ?
				start + records :
				Math.min( start+len, this._iRecordsDisplay );
		}
		else {
			return ! paginate || calc>records || len===-1 ?
				records :
				calc;
		}
	},

	/**
	 * The DataTables object for this table
	 */
	"oInstance": null,

	/**
	 * Unique identifier for each instance of the DataTables object. If there
	 * is an ID on the table node, then it takes that value, otherwise an
	 * incrementing internal counter is used.
	 */
	"sInstance": null,

	/**
	 * tabindex attribute value that is added to DataTables control elements, allowing
	 * keyboard navigation of the table and its controls.
	 */
	"iTabIndex": 0,

	/**
	 * DIV container for the footer scrolling table if scrolling
	 */
	"nScrollHead": null,

	/**
	 * DIV container for the footer scrolling table if scrolling
	 */
	"nScrollFoot": null,

	/**
	 * Last applied sort
	 */
	"aLastSort": [],

	/**
	 * Stored plug-in instances
	 */
	"oPlugins": {},

	/**
	 * Function used to get a row's id from the row's data
	 */
	"rowIdFn": null,

	/**
	 * Data location where to store a row's id
	 */
	"rowId": null,

	caption: '',

	captionNode: null,

	colgroup: null,

	/** Delay loading of data */
	deferLoading: null,

	/** Allow auto type detection */
	typeDetect: true,

	/** ResizeObserver for the container div */
	resizeObserver: null,

	/** Keep a record of the last size of the container, so we can skip duplicates */
	containerWidth: -1,

	/** Reverse the initial order of the data set on desc ordering */
	orderDescReverse: null,

	/** Show / hide ordering indicators in headers */
	orderIndicators: true,

	/** Default ordering listener */
	orderHandler: true,

	/** Title row indicator */
	titleRow: null,

	/** Title wrapper element type */
	columnTitleTag: 'span'
};

/**
 * Extension object for DataTables that is used to provide all extension
 * options.
 *
 * Note that the `DataTable.ext` object is available through
 * `jQuery.fn.dataTable.ext` where it may be accessed and manipulated. It is
 * also aliased to `jQuery.fn.dataTableExt` for historic reasons.
 *  @namespace
 *  @extends DataTable.models.ext
 */


var extPagination = DataTable.ext.pager;

// Paging buttons configuration
$.extend( extPagination, {
	simple: function () {
		return [ 'previous', 'next' ];
	},

	full: function () {
		return [ 'first', 'previous', 'next', 'last' ];
	},

	numbers: function () {
		return [ 'numbers' ];
	},

	simple_numbers: function () {
		return [ 'previous', 'numbers', 'next' ];
	},

	full_numbers: function () {
		return [ 'first', 'previous', 'numbers', 'next', 'last' ];
	},

	first_last: function () {
		return ['first', 'last'];
	},

	first_last_numbers: function () {
		return ['first', 'numbers', 'last'];
	},

	// For testing and plug-ins to use
	_numbers: _pagingNumbers,

	// Number of number buttons - legacy, use `numbers` option for paging feature
	numbers_length: 7
} );


$.extend( true, DataTable.ext.renderer, {
	pagingButton: {
		_: function (settings, buttonType, content, active, disabled) {
			var classes = settings.oClasses.paging;
			var btnClasses = [classes.button];
			var btn;

			if (active) {
				btnClasses.push(classes.active);
			}

			if (disabled) {
				btnClasses.push(classes.disabled)
			}

			if (buttonType === 'ellipsis') {
				btn = $('<span class="ellipsis"></span>').html(content)[0];
			}
			else {
				btn = $('<button>', {
					class: btnClasses.join(' '),
					role: 'link',
					type: 'button'
				}).html(content);
			}

			return {
				display: btn,
				clicker: btn
			}
		}
	},

	pagingContainer: {
		_: function (settings, buttons) {
			// No wrapping element - just append directly to the host
			return buttons;
		}
	}
} );

// Common function to remove new lines, strip HTML and diacritic control
var _filterString = function (stripHtml, normalize) {
	return function (str) {
		if (_empty(str) || typeof str !== 'string') {
			return str;
		}

		str = str.replace( _re_new_lines, " " );

		if (stripHtml) {
			str = _stripHtml(str);
		}

		if (normalize) {
			str = _normalize(str, false);
		}

		return str;
	};
}

/*
 * Public helper functions. These aren't used internally by DataTables, or
 * called by any of the options passed into DataTables, but they can be used
 * externally by developers working with DataTables. They are helper functions
 * to make working with DataTables a little bit easier.
 */

/**
 * Common logic for moment, luxon or a date action.
 *
 * Happens after __mldObj, so don't need to call `resolveWindowsLibs` again
 */
function __mld( dtLib, momentFn, luxonFn, dateFn, arg1 ) {
	if (__moment) {
		return dtLib[momentFn]( arg1 );
	}
	else if (__luxon) {
		return dtLib[luxonFn]( arg1 );
	}
	
	return dateFn ? dtLib[dateFn]( arg1 ) : dtLib;
}


var __mlWarning = false;
var __luxon; // Can be assigned in DateTable.use()
var __moment; // Can be assigned in DateTable.use()

/**
 * 
 */
function resolveWindowLibs() {
	if (window.luxon && ! __luxon) {
		__luxon = window.luxon;
	}
	
	if (window.moment && ! __moment) {
		__moment = window.moment;
	}
}

function __mldObj (d, format, locale) {
	var dt;

	resolveWindowLibs();

	if (__moment) {
		dt = __moment.utc( d, format, locale, true );

		if (! dt.isValid()) {
			return null;
		}
	}
	else if (__luxon) {
		dt = format && typeof d === 'string'
			? __luxon.DateTime.fromFormat( d, format )
			: __luxon.DateTime.fromISO( d );

		if (! dt.isValid) {
			return null;
		}

		dt = dt.setLocale(locale);
	}
	else if (! format) {
		// No format given, must be ISO
		dt = new Date(d);
	}
	else {
		if (! __mlWarning) {
			alert('DataTables warning: Formatted date without Moment.js or Luxon - https://datatables.net/tn/17');
		}

		__mlWarning = true;
	}

	return dt;
}

// Wrapper for date, datetime and time which all operate the same way with the exception of
// the output string for auto locale support
function __mlHelper (localeString) {
	return function ( from, to, locale, def ) {
		// Luxon and Moment support
		// Argument shifting
		if ( arguments.length === 0 ) {
			locale = 'en';
			to = null; // means toLocaleString
			from = null; // means iso8601
		}
		else if ( arguments.length === 1 ) {
			locale = 'en';
			to = from;
			from = null;
		}
		else if ( arguments.length === 2 ) {
			locale = to;
			to = from;
			from = null;
		}

		var typeName = 'datetime' + (to ? '-' + to : '');

		// Add type detection and sorting specific to this date format - we need to be able to identify
		// date type columns as such, rather than as numbers in extensions. Hence the need for this.
		if (! DataTable.ext.type.order[typeName + '-pre']) {
			DataTable.type(typeName, {
				detect: function (d) {
					// The renderer will give the value to type detect as the type!
					return d === typeName ? typeName : false;
				},
				order: {
					pre: function (d) {
						// The renderer gives us Moment, Luxon or Date objects for the sorting, all of which have a
						// `valueOf` which gives milliseconds epoch
						return d.valueOf();
					}
				},
				className: 'dt-right'
			});
		}
	
		return function ( d, type ) {
			// Allow for a default value
			if (d === null || d === undefined) {
				if (def === '--now') {
					// We treat everything as UTC further down, so no changes are
					// made, as such need to get the local date / time as if it were
					// UTC
					var local = new Date();
					d = new Date( Date.UTC(
						local.getFullYear(), local.getMonth(), local.getDate(),
						local.getHours(), local.getMinutes(), local.getSeconds()
					) );
				}
				else {
					d = '';
				}
			}

			if (type === 'type') {
				// Typing uses the type name for fast matching
				return typeName;
			}

			if (d === '') {
				return type !== 'sort'
					? ''
					: __mldObj('0000-01-01 00:00:00', null, locale);
			}

			// Shortcut. If `from` and `to` are the same, we are using the renderer to
			// format for ordering, not display - its already in the display format.
			if ( to !== null && from === to && type !== 'sort' && type !== 'type' && ! (d instanceof Date) ) {
				return d;
			}

			var dt = __mldObj(d, from, locale);

			if (dt === null) {
				return d;
			}

			if (type === 'sort') {
				return dt;
			}
			
			var formatted = to === null
				? __mld(dt, 'toDate', 'toJSDate', '')[localeString](
					navigator.language,
					{ timeZone: "UTC" }
				)
				: __mld(dt, 'format', 'toFormat', 'toISOString', to);

			// XSS protection
			return type === 'display' ?
				_escapeHtml( formatted ) :
				formatted;
		};
	}
}

// Based on locale, determine standard number formatting
// Fallback for legacy browsers is US English
var __thousands = ',';
var __decimal = '.';

if (window.Intl !== undefined) {
	try {
		var num = new Intl.NumberFormat().formatToParts(100000.1);
	
		for (var i=0 ; i<num.length ; i++) {
			if (num[i].type === 'group') {
				__thousands = num[i].value;
			}
			else if (num[i].type === 'decimal') {
				__decimal = num[i].value;
			}
		}
	}
	catch (e) {
		// noop
	}
}

// Formatted date time detection - use by declaring the formats you are going to use
DataTable.datetime = function ( format, locale ) {
	var typeName = 'datetime-' + format;

	if (! locale) {
		locale = 'en';
	}

	if (! DataTable.ext.type.order[typeName]) {
		DataTable.type(typeName, {
			detect: function (d) {
				var dt = __mldObj(d, format, locale);
				return d === '' || dt ? typeName : false;
			},
			order: {
				pre: function (d) {
					return __mldObj(d, format, locale) || 0;
				}
			},
			className: 'dt-right'
		});
	}
}

/**
 * Helpers for `columns.render`.
 *
 * The options defined here can be used with the `columns.render` initialisation
 * option to provide a display renderer. The following functions are defined:
 *
 * * `moment` - Uses the MomentJS library to convert from a given format into another.
 * This renderer has three overloads:
 *   * 1 parameter:
 *     * `string` - Format to convert to (assumes input is ISO8601 and locale is `en`)
 *   * 2 parameters:
 *     * `string` - Format to convert from
 *     * `string` - Format to convert to. Assumes `en` locale
 *   * 3 parameters:
 *     * `string` - Format to convert from
 *     * `string` - Format to convert to
 *     * `string` - Locale
 * * `number` - Will format numeric data (defined by `columns.data`) for
 *   display, retaining the original unformatted data for sorting and filtering.
 *   It takes 5 parameters:
 *   * `string` - Thousands grouping separator
 *   * `string` - Decimal point indicator
 *   * `integer` - Number of decimal points to show
 *   * `string` (optional) - Prefix.
 *   * `string` (optional) - Postfix (/suffix).
 * * `text` - Escape HTML to help prevent XSS attacks. It has no optional
 *   parameters.
 *
 * @example
 *   // Column definition using the number renderer
 *   {
 *     data: "salary",
 *     render: $.fn.dataTable.render.number( '\'', '.', 0, '$' )
 *   }
 *
 * @namespace
 */
DataTable.render = {
	date: __mlHelper('toLocaleDateString'),
	datetime: __mlHelper('toLocaleString'),
	time: __mlHelper('toLocaleTimeString'),
	number: function ( thousands, decimal, precision, prefix, postfix ) {
		// Auto locale detection
		if (thousands === null || thousands === undefined) {
			thousands = __thousands;
		}

		if (decimal === null || decimal === undefined) {
			decimal = __decimal;
		}

		return {
			display: function ( d ) {
				if ( typeof d !== 'number' && typeof d !== 'string' ) {
					return d;
				}

				if (d === '' || d === null) {
					return d;
				}

				var negative = d < 0 ? '-' : '';
				var flo = parseFloat( d );
				var abs = Math.abs(flo);

				// Scientific notation for large and small numbers
				if (abs >= 100000000000 || (abs < 0.0001 && abs !== 0) ) {
					var exp = flo.toExponential(precision).split(/e\+?/);
					return exp[0] + ' x 10<sup>' + exp[1] + '</sup>';
				}

				// If NaN then there isn't much formatting that we can do - just
				// return immediately, escaping any HTML (this was supposed to
				// be a number after all)
				if ( isNaN( flo ) ) {
					return _escapeHtml( d );
				}

				flo = flo.toFixed( precision );
				d = Math.abs( flo );

				var intPart = parseInt( d, 10 );
				var floatPart = precision ?
					decimal+(d - intPart).toFixed( precision ).substring( 2 ):
					'';

				// If zero, then can't have a negative prefix
				if (intPart === 0 && parseFloat(floatPart) === 0) {
					negative = '';
				}

				return negative + (prefix||'') +
					intPart.toString().replace(
						/\B(?=(\d{3})+(?!\d))/g, thousands
					) +
					floatPart +
					(postfix||'');
			}
		};
	},

	text: function () {
		return {
			display: _escapeHtml,
			filter: _escapeHtml
		};
	}
};


var _extTypes = DataTable.ext.type;

// Get / set type
DataTable.type = function (name, prop, val) {
	if (! prop) {
		return {
			className: _extTypes.className[name],
			detect: _extTypes.detect.find(function (fn) {
				return fn._name === name;
			}),
			order: {
				pre: _extTypes.order[name + '-pre'],
				asc: _extTypes.order[name + '-asc'],
				desc: _extTypes.order[name + '-desc']
			},
			render: _extTypes.render[name],
			search: _extTypes.search[name]
		};
	}

	var setProp = function(prop, propVal) {
		_extTypes[prop][name] = propVal;
	};
	var setDetect = function (detect) {
		// `detect` can be a function or an object - we set a name
		// property for either - that is used for the detection
		Object.defineProperty(detect, "_name", {value: name});

		var idx = _extTypes.detect.findIndex(function (item) {
			return item._name === name;
		});

		if (idx === -1) {
			_extTypes.detect.unshift(detect);
		}
		else {
			_extTypes.detect.splice(idx, 1, detect);
		}
	};
	var setOrder = function (obj) {
		_extTypes.order[name + '-pre'] = obj.pre; // can be undefined
		_extTypes.order[name + '-asc'] = obj.asc; // can be undefined
		_extTypes.order[name + '-desc'] = obj.desc; // can be undefined
	};

	// prop is optional
	if (val === undefined) {
		val = prop;
		prop = null;
	}

	if (prop === 'className') {
		setProp('className', val);
	}
	else if (prop === 'detect') {
		setDetect(val);
	}
	else if (prop === 'order') {
		setOrder(val);
	}
	else if (prop === 'render') {
		setProp('render', val);
	}
	else if (prop === 'search') {
		setProp('search', val);
	}
	else if (! prop) {
		if (val.className) {
			setProp('className', val.className);
		}

		if (val.detect !== undefined) {
			setDetect(val.detect);
		}

		if (val.order) {
			setOrder(val.order);
		}

		if (val.render !== undefined) {
			setProp('render', val.render);
		}

		if (val.search !== undefined) {
			setProp('search', val.search);
		}
	}
}

// Get a list of types
DataTable.types = function () {
	return _extTypes.detect.map(function (fn) {
		return fn._name;
	});
};

var __diacriticSort = function (a, b) {
	a = a !== null && a !== undefined ? a.toString().toLowerCase() : '';
	b = b !== null && b !== undefined ? b.toString().toLowerCase() : '';

	// Checked for `navigator.languages` support in `oneOf` so this code can't execute in old
	// Safari and thus can disable this check
	// eslint-disable-next-line compat/compat
	return a.localeCompare(b, navigator.languages[0] || navigator.language, {
		numeric: true,
		ignorePunctuation: true,
	});
}

var __diacriticHtmlSort = function (a, b) {
	a = _stripHtml(a);
	b = _stripHtml(b);

	return __diacriticSort(a, b);
}

//
// Built in data types
//

DataTable.type('string', {
	detect: function () {
		return 'string';
	},
	order: {
		pre: function ( a ) {
			// This is a little complex, but faster than always calling toString,
			// http://jsperf.com/tostring-v-check
			return _empty(a) && typeof a !== 'boolean' ?
				'' :
				typeof a === 'string' ?
					a.toLowerCase() :
					! a.toString ?
						'' :
						a.toString();
		}
	},
	search: _filterString(false, true)
});

DataTable.type('string-utf8', {
	detect: {
		allOf: function ( d ) {
			return true;
		},
		oneOf: function ( d ) {
			// At least one data point must contain a non-ASCII character
			// This line will also check if navigator.languages is supported or not. If not (Safari 10.0-)
			// this data type won't be supported.
			// eslint-disable-next-line compat/compat
			return ! _empty( d ) && navigator.languages && typeof d === 'string' && d.match(/[^\x00-\x7F]/);
		}
	},
	order: {
		asc: __diacriticSort,
		desc: function (a, b) {
			return __diacriticSort(a, b) * -1;
		}
	},
	search: _filterString(false, true)
});


DataTable.type('html', {
	detect: {
		allOf: function ( d ) {
			return _empty( d ) || (typeof d === 'string' && d.indexOf('<') !== -1);
		},
		oneOf: function ( d ) {
			// At least one data point must contain a `<`
			return ! _empty( d ) && typeof d === 'string' && d.indexOf('<') !== -1;
		}
	},
	order: {
		pre: function ( a ) {
			return _empty(a) ?
				'' :
				a.replace ?
					_stripHtml(a).trim().toLowerCase() :
					a+'';
		}
	},
	search: _filterString(true, true)
});


DataTable.type('html-utf8', {
	detect: {
		allOf: function ( d ) {
			return _empty( d ) || (typeof d === 'string' && d.indexOf('<') !== -1);
		},
		oneOf: function ( d ) {
			// At least one data point must contain a `<` and a non-ASCII character
			// eslint-disable-next-line compat/compat
			return navigator.languages &&
				! _empty( d ) &&
				typeof d === 'string' &&
				d.indexOf('<') !== -1 &&
				typeof d === 'string' && d.match(/[^\x00-\x7F]/);
		}
	},
	order: {
		asc: __diacriticHtmlSort,
		desc: function (a, b) {
			return __diacriticHtmlSort(a, b) * -1;
		}
	},
	search: _filterString(true, true)
});


DataTable.type('date', {
	className: 'dt-type-date',
	detect: {
		allOf: function ( d ) {
			// V8 tries _very_ hard to make a string passed into `Date.parse()`
			// valid, so we need to use a regex to restrict date formats. Use a
			// plug-in for anything other than ISO8601 style strings
			if ( d && !(d instanceof Date) && ! _re_date.test(d) ) {
				return null;
			}
			var parsed = Date.parse(d);
			return (parsed !== null && !isNaN(parsed)) || _empty(d);
		},
		oneOf: function ( d ) {
			// At least one entry must be a date or a string with a date
			return (d instanceof Date) || (typeof d === 'string' && _re_date.test(d));
		}
	},
	order: {
		pre: function ( d ) {
			var ts = Date.parse( d );
			return isNaN(ts) ? -Infinity : ts;
		}
	}
});


DataTable.type('html-num-fmt', {
	className: 'dt-type-numeric',
	detect: {
		allOf: function ( d, settings ) {
			var decimal = settings.oLanguage.sDecimal;
			return _htmlNumeric( d, decimal, true, false );
		},
		oneOf: function (d, settings) {
			// At least one data point must contain a numeric value
			var decimal = settings.oLanguage.sDecimal;
			return _htmlNumeric( d, decimal, true, false );
		}
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_html, _re_formatted_numeric );
		}
	},
	search: _filterString(true, true)
});


DataTable.type('html-num', {
	className: 'dt-type-numeric',
	detect: {
		allOf: function ( d, settings ) {
			var decimal = settings.oLanguage.sDecimal;
			return _htmlNumeric( d, decimal, false, true );
		},
		oneOf: function (d, settings) {
			// At least one data point must contain a numeric value
			var decimal = settings.oLanguage.sDecimal;
			return _htmlNumeric( d, decimal, false, false );
		}
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_html );
		}
	},
	search: _filterString(true, true)
});


DataTable.type('num-fmt', {
	className: 'dt-type-numeric',
	detect: {
		allOf: function ( d, settings ) {
			var decimal = settings.oLanguage.sDecimal;
			return _isNumber( d, decimal, true, true );
		},
		oneOf: function (d, settings) {
			// At least one data point must contain a numeric value
			var decimal = settings.oLanguage.sDecimal;
			return _isNumber( d, decimal, true, false );
		}
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_formatted_numeric );
		}
	}
});


DataTable.type('num', {
	className: 'dt-type-numeric',
	detect: {
		allOf: function ( d, settings ) {
			var decimal = settings.oLanguage.sDecimal;
			return _isNumber( d, decimal, false, true );
		},
		oneOf: function (d, settings) {
			// At least one data point must contain a numeric value
			var decimal = settings.oLanguage.sDecimal;
			return _isNumber( d, decimal, false, false );
		}
	},
	order: {
		pre: function (d, s) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp );
		}
	}
});




var __numericReplace = function ( d, decimalPlace, re1, re2 ) {
	if ( d !== 0 && (!d || d === '-') ) {
		return -Infinity;
	}
	
	var type = typeof d;

	if (type === 'number' || type === 'bigint') {
		return d;
	}

	// If a decimal place other than `.` is used, it needs to be given to the
	// function so we can detect it and replace with a `.` which is the only
	// decimal place JavaScript recognises - it is not locale aware.
	if ( decimalPlace ) {
		d = _numToDecimal( d, decimalPlace );
	}

	if ( d.replace ) {
		if ( re1 ) {
			d = d.replace( re1, '' );
		}

		if ( re2 ) {
			d = d.replace( re2, '' );
		}
	}

	return d * 1;
};


$.extend( true, DataTable.ext.renderer, {
	footer: {
		_: function ( settings, cell, classes ) {
			cell.addClass(classes.tfoot.cell);
		}
	},

	header: {
		_: function ( settings, cell, classes ) {
			cell.addClass(classes.thead.cell);

			if (! settings.oFeatures.bSort) {
				cell.addClass(classes.order.none);
			}

			var titleRow = settings.titleRow;
			var headerRows = cell.closest('thead').find('tr');
			var rowIdx = cell.parent().index();

			// Conditions to not apply the ordering icons
			if (
				// Cells and rows which have the attribute to disable the icons
				cell.attr('data-dt-order') === 'disable' ||
				cell.parent().attr('data-dt-order') === 'disable' ||

				// titleRow support, for defining a specific row in the header
				(titleRow === true && rowIdx !== 0) ||
				(titleRow === false && rowIdx !== headerRows.length - 1) ||
				(typeof titleRow === 'number' && rowIdx !== titleRow)
			) {
				return;
			}

			// No additional mark-up required
			// Attach a sort listener to update on sort - note that using the
			// `DT` namespace will allow the event to be removed automatically
			// on destroy, while the `dt` namespaced event is the one we are
			// listening for
			$(settings.nTable).on( 'order.dt.DT column-visibility.dt.DT', function ( e, ctx, column ) {
				if ( settings !== ctx ) { // need to check if this is the host
					return;               // table, not a nested one
				}

				var sorting = ctx.sortDetails;

				if (! sorting) {
					return;
				}

				var orderedColumns = _pluck(sorting, 'col');

				// This handler is only needed on column visibility if the column is part of the
				// ordering. If it isn't, then we can bail out to save performance. It could be a
				// separate event handler, but this is a balance between code reuse / size and performance
				// console.log(e, e.name, column, orderedColumns, orderedColumns.includes(column))
				if (e.type === 'column-visibility' && ! orderedColumns.includes(column)) {
					return;
				}

				var i;
				var orderClasses = classes.order;
				var columns = ctx.api.columns( cell );
				var col = settings.aoColumns[columns.flatten()[0]];
				var orderable = columns.orderable().includes(true);
				var ariaType = '';
				var indexes = columns.indexes();
				var sortDirs = columns.orderable(true).flatten();
				var tabIndex = settings.iTabIndex;
				var canOrder = ctx.orderHandler && orderable;

				cell
					.removeClass(
						orderClasses.isAsc +' '+
						orderClasses.isDesc
					)
					.toggleClass( orderClasses.none, ! orderable )
					.toggleClass( orderClasses.canAsc, canOrder && sortDirs.includes('asc') )
					.toggleClass( orderClasses.canDesc, canOrder && sortDirs.includes('desc') );

				// Determine if all of the columns that this cell covers are included in the
				// current ordering
				var isOrdering = true;
				
				for (i=0; i<indexes.length; i++) {
					if (! orderedColumns.includes(indexes[i])) {
						isOrdering = false;
					}
				}

				if ( isOrdering ) {
					// Get the ordering direction for the columns under this cell
					// Note that it is possible for a cell to be asc and desc sorting
					// (column spanning cells)
					var orderDirs = columns.order();

					cell.addClass(
						orderDirs.includes('asc') ? orderClasses.isAsc : '' +
						orderDirs.includes('desc') ? orderClasses.isDesc : ''
					);
				}

				// Find the first visible column that has ordering applied to it - it get's
				// the aria information, as the ARIA spec says that only one column should
				// be marked with aria-sort
				var firstVis = -1; // column index

				for (i=0; i<orderedColumns.length; i++) {
					if (settings.aoColumns[orderedColumns[i]].bVisible) {
						firstVis = orderedColumns[i];
						break;
					}
				}

				if (indexes[0] == firstVis) {
					var firstSort = sorting[0];
					var sortOrder = col.asSorting;

					cell.attr('aria-sort', firstSort.dir === 'asc' ? 'ascending' : 'descending');

					// Determine if the next click will remove sorting or change the sort
					ariaType = ! sortOrder[firstSort.index + 1] ? 'Remove' : 'Reverse';
				}
				else {
					cell.removeAttr('aria-sort');
				}

				// Make the headers tab-able for keyboard navigation
				if (orderable) {
					var orderSpan = cell.find('.dt-column-order');
					
					orderSpan
						.attr('role', 'button')
						.attr('aria-label', orderable
							? col.ariaTitle + ctx.api.i18n('oAria.orderable' + ariaType)
							: col.ariaTitle
						);

					if (tabIndex !== -1) {
						orderSpan.attr('tabindex', tabIndex);
					}
				}
			} );
		}
	},

	layout: {
		_: function ( settings, container, items ) {
			var classes = settings.oClasses.layout;
			var row = $('<div/>')
				.attr('id', items.id || null)
				.addClass(items.className || classes.row)
				.appendTo( container );

			DataTable.ext.renderer.layout._forLayoutRow(items, function (key, val) {
				if (key === 'id' || key === 'className') {
					return;
				}

				var klass = '';

				if (val.table) {
					row.addClass(classes.tableRow);
					klass += classes.tableCell + ' ';
				}

				if (key === 'start') {
					klass += classes.start;
				}
				else if (key === 'end') {
					klass += classes.end;
				}
				else {
					klass += classes.full;
				}

				$('<div/>')
					.attr({
						id: val.id || null,
						"class": val.className
							? val.className
							: classes.cell + ' ' + klass
					})
					.append( val.contents )
					.appendTo( row );
			});
		},

		// Shared for use by the styling frameworks
		_forLayoutRow: function (items, fn) {
			// As we are inserting dom elements, we need start / end in a
			// specific order, this function is used for sorting the layout
			// keys.
			var layoutEnum = function (x) {
				switch (x) {
					case '': return 0;
					case 'start': return 1;
					case 'end': return 2;
					default: return 3;
				}
			};

			Object
				.keys(items)
				.sort(function (a, b) {
					return layoutEnum(a) - layoutEnum(b);
				})
				.forEach(function (key) {
					fn(key, items[key]);
				});
		}
	}
} );


DataTable.feature = {};

// Third parameter is internal only!
DataTable.feature.register = function ( name, cb, legacy ) {
	DataTable.ext.features[ name ] = cb;

	if (legacy) {
		_ext.feature.push({
			cFeature: legacy,
			fnInit: cb
		});
	}
};

function _divProp(el, prop, val) {
	if (val) {
		el[prop] = val;
	}
}

DataTable.feature.register( 'div', function ( settings, opts ) {
	var n = $('<div>')[0];

	if (opts) {
		_divProp(n, 'className', opts.className);
		_divProp(n, 'id', opts.id);
		_divProp(n, 'innerHTML', opts.html);
		_divProp(n, 'textContent', opts.text);
	}

	return n;
} );

DataTable.feature.register( 'info', function ( settings, opts ) {
	// For compatibility with the legacy `info` top level option
	if (! settings.oFeatures.bInfo) {
		return null;
	}

	var
		lang  = settings.oLanguage,
		tid = settings.sTableId,
		n = $('<div/>', {
			'class': settings.oClasses.info.container,
		} );

	opts = $.extend({
		callback: lang.fnInfoCallback,
		empty: lang.sInfoEmpty,
		postfix: lang.sInfoPostFix,
		search: lang.sInfoFiltered,
		text: lang.sInfo,
	}, opts);


	// Update display on each draw
	settings.aoDrawCallback.push(function (s) {
		_fnUpdateInfo(s, opts, n);
	});

	// For the first info display in the table, we add a callback and aria information.
	if (! settings._infoEl) {
		n.attr({
			'aria-live': 'polite',
			id: tid+'_info',
			role: 'status'
		});

		// Table is described by our info div
		$(settings.nTable).attr( 'aria-describedby', tid+'_info' );

		settings._infoEl = n;
	}

	return n;
}, 'i' );

/**
 * Update the information elements in the display
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnUpdateInfo ( settings, opts, node )
{
	var
		start = settings._iDisplayStart+1,
		end   = settings.fnDisplayEnd(),
		max   = settings.fnRecordsTotal(),
		total = settings.fnRecordsDisplay(),
		out   = total
			? opts.text
			: opts.empty;

	if ( total !== max ) {
		// Record set after filtering
		out += ' ' + opts.search;
	}

	// Convert the macros
	out += opts.postfix;
	out = _fnMacros( settings, out );

	if ( opts.callback ) {
		out = opts.callback.call( settings.oInstance,
			settings, start, end, max, total, out
		);
	}

	node.html( out );

	_fnCallbackFire(settings, null, 'info', [settings, node[0], out]);
}

var __searchCounter = 0;

// opts
// - text
// - placeholder
DataTable.feature.register( 'search', function ( settings, opts ) {
	// Don't show the input if filtering isn't available on the table
	if (! settings.oFeatures.bFilter) {
		return null;
	}

	var classes = settings.oClasses.search;
	var tableId = settings.sTableId;
	var language = settings.oLanguage;
	var previousSearch = settings.oPreviousSearch;
	var input = '<input type="search" class="'+classes.input+'"/>';

	opts = $.extend({
		placeholder: language.sSearchPlaceholder,
		processing: false,
		text: language.sSearch
	}, opts);

	// The _INPUT_ is optional - is appended if not present
	if (opts.text.indexOf('_INPUT_') === -1) {
		opts.text += '_INPUT_';
	}

	opts.text = _fnMacros(settings, opts.text);

	// We can put the <input> outside of the label if it is at the start or end
	// which helps improve accessability (not all screen readers like implicit
	// for elements).
	var end = opts.text.match(/_INPUT_$/);
	var start = opts.text.match(/^_INPUT_/);
	var removed = opts.text.replace(/_INPUT_/, '');
	var str = '<label>' + opts.text + '</label>';

	if (start) {
		str = '_INPUT_<label>' + removed + '</label>';
	}
	else if (end) {
		str = '<label>' + removed + '</label>_INPUT_';
	}

	var filter = $('<div>')
		.addClass(classes.container)
		.append(str.replace(/_INPUT_/, input));

	// add for and id to label and input
	filter.find('label').attr('for', 'dt-search-' + __searchCounter);
	filter.find('input').attr('id', 'dt-search-' + __searchCounter);
	__searchCounter++;

	var searchFn = function(event) {
		var val = this.value;

		if(previousSearch.return && event.key !== "Enter") {
			return;
		}

		/* Now do the filter */
		if ( val != previousSearch.search ) {
			_fnProcessingRun(settings, opts.processing, function () {
				previousSearch.search = val;
		
				_fnFilterComplete( settings, previousSearch );
		
				// Need to redraw, without resorting
				settings._iDisplayStart = 0;
				_fnDraw( settings );
			});
		}
	};

	var searchDelay = settings.searchDelay !== null ?
		settings.searchDelay :
		0;

	var jqFilter = $('input', filter)
		.val( previousSearch.search )
		.attr( 'placeholder', opts.placeholder )
		.on(
			'keyup.DT search.DT input.DT paste.DT cut.DT',
			searchDelay ?
				DataTable.util.debounce( searchFn, searchDelay ) :
				searchFn
		)
		.on( 'mouseup.DT', function(e) {
			// Edge fix! Edge 17 does not trigger anything other than mouse events when clicking
			// on the clear icon (Edge bug 17584515). This is safe in other browsers as `searchFn`
			// checks the value to see if it has changed. In other browsers it won't have.
			setTimeout( function () {
				searchFn.call(jqFilter[0], e);
			}, 10);
		} )
		.on( 'keypress.DT', function(e) {
			/* Prevent form submission */
			if ( e.keyCode == 13 ) {
				return false;
			}
		} )
		.attr('aria-controls', tableId);

	// Update the input elements whenever the table is filtered
	$(settings.nTable).on( 'search.dt.DT', function ( ev, s ) {
		if ( settings === s && jqFilter[0] !== document.activeElement ) {
			jqFilter.val( typeof previousSearch.search !== 'function'
				? previousSearch.search
				: ''
			);
		}
	} );

	return filter;
}, 'f' );

// opts
// - type - button configuration
// - buttons - number of buttons to show - must be odd
DataTable.feature.register( 'paging', function ( settings, opts ) {
	// Don't show the paging input if the table doesn't have paging enabled
	if (! settings.oFeatures.bPaginate) {
		return null;
	}

	opts = $.extend({
		buttons: DataTable.ext.pager.numbers_length,
		type: settings.sPaginationType,
		boundaryNumbers: true,
		firstLast: true,
		previousNext: true,
		numbers: true
	}, opts);

	var host = $('<div/>')
		.addClass(settings.oClasses.paging.container + (opts.type ? ' paging_' + opts.type : ''))
		.append(
			$('<nav>')
				.attr('aria-label', 'pagination')
				.addClass(settings.oClasses.paging.nav)
		);
	var draw = function () {
		_pagingDraw(settings, host.children(), opts);
	};

	settings.aoDrawCallback.push(draw);

	// Responsive redraw of paging control
	$(settings.nTable).on('column-sizing.dt.DT', draw);

	return host;
}, 'p' );

/**
 * Dynamically create the button type array based on the configuration options.
 * This will only happen if the paging type is not defined.
 */
function _pagingDynamic(opts) {
	var out = [];

	if (opts.numbers) {
		out.push('numbers');
	}

	if (opts.previousNext) {
		out.unshift('previous');
		out.push('next');
	}

	if (opts.firstLast) {
		out.unshift('first');
		out.push('last');
	}

	return out;
}

function _pagingDraw(settings, host, opts) {
	if (! settings._bInitComplete) {
		return;
	}

	var
		plugin = opts.type
			? DataTable.ext.pager[ opts.type ]
			: _pagingDynamic,
		aria = settings.oLanguage.oAria.paginate || {},
		start      = settings._iDisplayStart,
		len        = settings._iDisplayLength,
		visRecords = settings.fnRecordsDisplay(),
		all        = len === -1,
		page = all ? 0 : Math.ceil( start / len ),
		pages = all ? 1 : Math.ceil( visRecords / len ),
		buttons = [],
		buttonEls = [],
		buttonsNested = plugin(opts)
			.map(function (val) {
				return val === 'numbers'
					? _pagingNumbers(page, pages, opts.buttons, opts.boundaryNumbers)
					: val;
			});

	// .flat() would be better, but not supported in old Safari
	buttons = buttons.concat.apply(buttons, buttonsNested);

	for (var i=0 ; i<buttons.length ; i++) {
		var button = buttons[i];

		var btnInfo = _pagingButtonInfo(settings, button, page, pages);
		var btn = _fnRenderer( settings, 'pagingButton' )(
			settings,
			button,
			btnInfo.display,
			btnInfo.active,
			btnInfo.disabled
		);

		var ariaLabel = typeof button === 'string'
			? aria[ button ]
			: aria.number
				? aria.number + (button+1)
				: null;

		// Common attributes
		$(btn.clicker).attr({
			'aria-controls': settings.sTableId,
			'aria-disabled': btnInfo.disabled ? 'true' : null,
			'aria-current': btnInfo.active ? 'page' : null,
			'aria-label': ariaLabel,
			'data-dt-idx': button,
			'tabIndex': btnInfo.disabled
				? -1
				: settings.iTabIndex && btn.clicker[0].nodeName.toLowerCase() !== 'span'
					? settings.iTabIndex
					: null, // `0` doesn't need a tabIndex since it is the default
		});

		if (typeof button !== 'number') {
			$(btn.clicker).addClass(button);
		}

		_fnBindAction(
			btn.clicker, {action: button}, function(e) {
				e.preventDefault();

				_fnPageChange( settings, e.data.action, true );
			}
		);

		buttonEls.push(btn.display);
	}

	var wrapped = _fnRenderer(settings, 'pagingContainer')(
		settings, buttonEls
	);

	var activeEl = host.find(document.activeElement).data('dt-idx');

	host.empty().append(wrapped);

	if ( activeEl !== undefined ) {
		host.find( '[data-dt-idx='+activeEl+']' ).trigger('focus');
	}

	// Responsive - check if the buttons are over two lines based on the
	// height of the buttons and the container.
	if (buttonEls.length) {
		var outerHeight = $(buttonEls[0]).outerHeight();
	
		if (
			opts.buttons > 1 && // prevent infinite
			outerHeight > 0 && // will be 0 if hidden
			$(host).height() >= (outerHeight * 2) - 10
		) {
			_pagingDraw(settings, host, $.extend({}, opts, { buttons: opts.buttons - 2 }));
		}
	}
}

/**
 * Get properties for a button based on the current paging state of the table
 *
 * @param {*} settings DT settings object
 * @param {*} button The button type in question
 * @param {*} page Table's current page
 * @param {*} pages Number of pages
 * @returns Info object
 */
function _pagingButtonInfo(settings, button, page, pages) {
	var lang = settings.oLanguage.oPaginate;
	var o = {
		display: '',
		active: false,
		disabled: false
	};

	switch ( button ) {
		case 'ellipsis':
			o.display = '&#x2026;';
			break;

		case 'first':
			o.display = lang.sFirst;

			if (page === 0) {
				o.disabled = true;
			}
			break;

		case 'previous':
			o.display = lang.sPrevious;

			if ( page === 0 ) {
				o.disabled = true;
			}
			break;

		case 'next':
			o.display = lang.sNext;

			if ( pages === 0 || page === pages-1 ) {
				o.disabled = true;
			}
			break;

		case 'last':
			o.display = lang.sLast;

			if ( pages === 0 || page === pages-1 ) {
				o.disabled = true;
			}
			break;

		default:
			if ( typeof button === 'number' ) {
				o.display = settings.fnFormatNumber( button + 1 );
				
				if (page === button) {
					o.active = true;
				}
			}
			break;
	}

	return o;
}

/**
 * Compute what number buttons to show in the paging control
 *
 * @param {*} page Current page
 * @param {*} pages Total number of pages
 * @param {*} buttons Target number of number buttons
 * @param {boolean} addFirstLast Indicate if page 1 and end should be included
 * @returns Buttons to show
 */
function _pagingNumbers ( page, pages, buttons, addFirstLast ) {
	var
		numbers = [],
		half = Math.floor(buttons / 2),
		before = addFirstLast ? 2 : 1,
		after = addFirstLast ? 1 : 0;

	if ( pages <= buttons ) {
		numbers = _range(0, pages);
	}
	else if (buttons === 1) {
		// Single button - current page only
		numbers = [page];
	}
	else if (buttons === 3) {
		// Special logic for just three buttons
		if (page <= 1) {
			numbers = [0, 1, 'ellipsis'];
		}
		else if (page >= pages - 2) {
			numbers = _range(pages-2, pages);
			numbers.unshift('ellipsis');
		}
		else {
			numbers = ['ellipsis', page, 'ellipsis'];
		}
	}
	else if ( page <= half ) {
		numbers = _range(0, buttons-before);
		numbers.push('ellipsis');

		if (addFirstLast) {
			numbers.push(pages-1);
		}
	}
	else if ( page >= pages - 1 - half ) {
		numbers = _range(pages-(buttons-before), pages);
		numbers.unshift('ellipsis');

		if (addFirstLast) {
			numbers.unshift(0);
		}
	}
	else {
		numbers = _range(page-half+before, page+half-after);
		numbers.push('ellipsis');
		numbers.unshift('ellipsis');

		if (addFirstLast) {
			numbers.push(pages-1);
			numbers.unshift(0);
		}
	}

	return numbers;
}

var __lengthCounter = 0;

// opts
// - menu
// - text
DataTable.feature.register( 'pageLength', function ( settings, opts ) {
	var features = settings.oFeatures;

	// For compatibility with the legacy `pageLength` top level option
	if (! features.bPaginate || ! features.bLengthChange) {
		return null;
	}

	opts = $.extend({
		menu: settings.aLengthMenu,
		text: settings.oLanguage.sLengthMenu
	}, opts);

	var
		classes  = settings.oClasses.length,
		tableId  = settings.sTableId,
		menu     = opts.menu,
		lengths  = [],
		language = [],
		i;

	// Options can be given in a number of ways
	if (Array.isArray( menu[0] )) {
		// Old 1.x style - 2D array
		lengths = menu[0];
		language = menu[1];
	}
	else {
		for ( i=0 ; i<menu.length ; i++ ) {
			// An object with different label and value
			if ($.isPlainObject(menu[i])) {
				lengths.push(menu[i].value);
				language.push(menu[i].label);
			}
			else {
				// Or just a number to display and use
				lengths.push(menu[i]);
				language.push(menu[i]);
			}
		}
	}

	// We can put the <select> outside of the label if it is at the start or
	// end which helps improve accessability (not all screen readers like
	// implicit for elements).
	var end = opts.text.match(/_MENU_$/);
	var start = opts.text.match(/^_MENU_/);
	var removed = opts.text.replace(/_MENU_/, '');
	var str = '<label>' + opts.text + '</label>';

	if (start) {
		str = '_MENU_<label>' + removed + '</label>';
	}
	else if (end) {
		str = '<label>' + removed + '</label>_MENU_';
	}

	// Wrapper element - use a span as a holder for where the select will go
	var tmpId = 'tmp-' + (+new Date())
	var div = $('<div/>')
		.addClass( classes.container )
		.append(
			str.replace( '_MENU_', '<span id="'+tmpId+'"></span>' )
		);

	// Save text node content for macro updating
	var textNodes = [];
	Array.prototype.slice.call(div.find('label')[0].childNodes).forEach(function (el) {
		if (el.nodeType === Node.TEXT_NODE) {
			textNodes.push({
				el: el,
				text: el.textContent
			});
		}
	});

	// Update the label text in case it has an entries value
	var updateEntries = function (len) {
		textNodes.forEach(function (node) {
			node.el.textContent = _fnMacros(settings, node.text, len);
		});
	}

	// Next, the select itself, along with the options
	var select = $('<select/>', {
		'aria-controls': tableId,
		'class':         classes.select
	} );

	for ( i=0 ; i<lengths.length ; i++ ) {
		// Attempt to look up the length from the i18n options
		var label = settings.api.i18n('lengthLabels.' + lengths[i], null);

		if (label === null) {
			// If not present, fallback to old style
			label = typeof language[i] === 'number' ?
				settings.fnFormatNumber( language[i] ) :
				language[i];
		}

		select[0][ i ] = new Option(label, lengths[i]);
	}

	// add for and id to label and input
	div.find('label').attr('for', 'dt-length-' + __lengthCounter);
	select.attr('id', 'dt-length-' + __lengthCounter);
	__lengthCounter++;

	// Swap in the select list
	div.find('#' + tmpId).replaceWith(select);

	// Can't use `select` variable as user might provide their own and the
	// reference is broken by the use of outerHTML
	$('select', div)
		.val( settings._iDisplayLength )
		.on( 'change.DT', function() {
			_fnLengthChange( settings, $(this).val() );
			_fnDraw( settings );
		} );

	// Update node value whenever anything changes the table's length
	$(settings.nTable).on( 'length.dt.DT', function (e, s, len) {
		if ( settings === s ) {
			$('select', div).val( len );

			// Resolve plurals in the text for the new length
			updateEntries(len);
		}
	} );

	updateEntries(settings._iDisplayLength);

	return div;
}, 'l' );

// jQuery access
$.fn.dataTable = DataTable;

// Provide access to the host jQuery object (circular reference)
DataTable.$ = $;

// Legacy aliases
$.fn.dataTableSettings = DataTable.settings;
$.fn.dataTableExt = DataTable.ext;

// With a capital `D` we return a DataTables API instance rather than a
// jQuery object
$.fn.DataTable = function ( opts ) {
	return $(this).dataTable( opts ).api();
};

// All properties that are available to $.fn.dataTable should also be
// available on $.fn.DataTable
$.each( DataTable, function ( prop, val ) {
	$.fn.DataTable[ prop ] = val;
} );

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DataTable);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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