(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_datatables_net-buttons_js_buttons_colVis_js-node_modules_datatables_net--33bcf0"],{

/***/ "./node_modules/datatables.net-buttons/js/buttons.colVis.js":
/*!******************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.colVis.js ***!
  \******************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Column visibility buttons for Buttons and DataTables.
 * © SpryMedia Ltd - datatables.net/license
 */

(function( factory ){
	if ( true ) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs"), __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ( $ ) {
			return factory( $, window, document );
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	}
	else { var cjsRequires, jq; }
}(function( $, window, document ) {
'use strict';
var DataTable = $.fn.dataTable;



$.extend(DataTable.ext.buttons, {
	// A collection of column visibility buttons
	colvis: function (dt, conf) {
		var node = null;
		var buttonConf = {
			extend: 'collection',
			init: function (dt, n) {
				node = n;
			},
			text: function (dt) {
				return dt.i18n('buttons.colvis', 'Column visibility');
			},
			className: 'buttons-colvis',
			closeButton: false,
			buttons: [
				{
					extend: 'columnsToggle',
					columns: conf.columns,
					columnText: conf.columnText
				}
			]
		};

		// Rebuild the collection with the new column structure if columns are reordered
		dt.on('column-reorder.dt' + conf.namespace, function () {
			dt.button(null, dt.button(null, node).node()).collectionRebuild([
				{
					extend: 'columnsToggle',
					columns: conf.columns,
					columnText: conf.columnText
				}
			]);
		});

		return buttonConf;
	},

	// Selected columns with individual buttons - toggle column visibility
	columnsToggle: function (dt, conf) {
		var columns = dt
			.columns(conf.columns)
			.indexes()
			.map(function (idx) {
				return {
					extend: 'columnToggle',
					columns: idx,
					columnText: conf.columnText
				};
			})
			.toArray();

		return columns;
	},

	// Single button to toggle column visibility
	columnToggle: function (dt, conf) {
		return {
			extend: 'columnVisibility',
			columns: conf.columns,
			columnText: conf.columnText
		};
	},

	// Selected columns with individual buttons - set column visibility
	columnsVisibility: function (dt, conf) {
		var columns = dt
			.columns(conf.columns)
			.indexes()
			.map(function (idx) {
				return {
					extend: 'columnVisibility',
					columns: idx,
					visibility: conf.visibility,
					columnText: conf.columnText
				};
			})
			.toArray();

		return columns;
	},

	// Single button to set column visibility
	columnVisibility: {
		columns: undefined, // column selector
		text: function (dt, button, conf) {
			return conf._columnText(dt, conf);
		},
		className: 'buttons-columnVisibility',
		action: function (e, dt, button, conf) {
			var col = dt.columns(conf.columns);
			var curr = col.visible();

			col.visible(
				conf.visibility !== undefined ? conf.visibility : !(curr.length ? curr[0] : false)
			);
		},
		init: function (dt, button, conf) {
			var that = this;
			button.attr('data-cv-idx', conf.columns);

			dt.on('column-visibility.dt' + conf.namespace, function (e, settings) {
				if (!settings.bDestroying && settings.nTable == dt.settings()[0].nTable) {
					that.active(dt.column(conf.columns).visible());
				}
			}).on('column-reorder.dt' + conf.namespace, function () {
				// Button has been removed from the DOM
				if (conf.destroying) {
					return;
				}

				if (dt.columns(conf.columns).count() !== 1) {
					return;
				}

				// This button controls the same column index but the text for the column has
				// changed
				that.text(conf._columnText(dt, conf));

				// Since its a different column, we need to check its visibility
				that.active(dt.column(conf.columns).visible());
			});

			this.active(dt.column(conf.columns).visible());
		},
		destroy: function (dt, button, conf) {
			dt.off('column-visibility.dt' + conf.namespace).off(
				'column-reorder.dt' + conf.namespace
			);
		},

		_columnText: function (dt, conf) {
			if (typeof conf.text === 'string') {
				return conf.text;
			}

			// Use DataTables' internal data structure until this is presented
			// is a public API. The other option is to use
			// `$( column(col).node() ).text()` but the node might not have been
			// populated when Buttons is constructed.
			var idx = dt.column(conf.columns).index();
			var title = dt.settings()[0].aoColumns[idx].sTitle;

			if (!title) {
				title = dt.column(idx).header().innerHTML;
			}

			title = title
				.replace(/\n/g, ' ') // remove new lines
				.replace(/<br\s*\/?>/gi, ' ') // replace line breaks with spaces
				.replace(/<select(.*?)<\/select>/g, '') // remove select tags, including options text
				.replace(/<!\-\-.*?\-\->/g, '') // strip HTML comments
				.replace(/<.*?>/g, '') // strip HTML
				.replace(/^\s+|\s+$/g, ''); // trim

			return conf.columnText ? conf.columnText(dt, idx, title) : title;
		}
	},

	colvisRestore: {
		className: 'buttons-colvisRestore',

		text: function (dt) {
			return dt.i18n('buttons.colvisRestore', 'Restore visibility');
		},

		init: function (dt, button, conf) {
			// Use a private parameter on the column. This gets moved around with the
			// column if ColReorder changes the order
			dt.columns().every(function () {
				var init = this.init();

				if (init.__visOriginal === undefined) {
					init.__visOriginal = this.visible();
				}
			});
		},

		action: function (e, dt, button, conf) {
			dt.columns().every(function (i) {
				var init = this.init();

				this.visible(init.__visOriginal);
			});
		}
	},

	colvisGroup: {
		className: 'buttons-colvisGroup',

		action: function (e, dt, button, conf) {
			dt.columns(conf.show).visible(true, false);
			dt.columns(conf.hide).visible(false, false);

			dt.columns.adjust();
		},

		show: [],

		hide: []
	}
});


return DataTable;
}));


/***/ }),

/***/ "./node_modules/datatables.net-buttons/js/buttons.flash.js":
/*!*****************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.flash.js ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Flash export buttons for Buttons and DataTables.
 * 2015 SpryMedia Ltd - datatables.net/license
 *
 * ZeroClipbaord - MIT license
 * Copyright (c) 2012 Joseph Huckaby
 */

(function( factory ){
	if ( true ) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs"), __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ( $ ) {
			return factory( $, window, document );
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	}
	else {}
}(function( $, window, document, undefined ) {
'use strict';
var DataTable = $.fn.dataTable;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * ZeroClipboard dependency
 */

/*
 * ZeroClipboard 1.0.4 with modifications
 * Author: Joseph Huckaby
 * License: MIT
 *
 * Copyright (c) 2012 Joseph Huckaby
 */
var ZeroClipboard_TableTools = {
	version: "1.0.4-TableTools2",
	clients: {}, // registered upload clients on page, indexed by id
	moviePath: '', // URL to movie
	nextId: 1, // ID of next movie

	$: function(thingy) {
		// simple DOM lookup utility function
		if (typeof(thingy) == 'string') {
			thingy = document.getElementById(thingy);
		}
		if (!thingy.addClass) {
			// extend element with a few useful methods
			thingy.hide = function() { this.style.display = 'none'; };
			thingy.show = function() { this.style.display = ''; };
			thingy.addClass = function(name) { this.removeClass(name); this.className += ' ' + name; };
			thingy.removeClass = function(name) {
				this.className = this.className.replace( new RegExp("\\s*" + name + "\\s*"), " ").replace(/^\s+/, '').replace(/\s+$/, '');
			};
			thingy.hasClass = function(name) {
				return !!this.className.match( new RegExp("\\s*" + name + "\\s*") );
			};
		}
		return thingy;
	},

	setMoviePath: function(path) {
		// set path to ZeroClipboard.swf
		this.moviePath = path;
	},

	dispatch: function(id, eventName, args) {
		// receive event from flash movie, send to client
		var client = this.clients[id];
		if (client) {
			client.receiveEvent(eventName, args);
		}
	},

	log: function ( str ) {
		console.log( 'Flash: '+str );
	},

	register: function(id, client) {
		// register new client to receive events
		this.clients[id] = client;
	},

	getDOMObjectPosition: function(obj) {
		// get absolute coordinates for dom element
		var info = {
			left: 0,
			top: 0,
			width: obj.width ? obj.width : obj.offsetWidth,
			height: obj.height ? obj.height : obj.offsetHeight
		};

		if ( obj.style.width !== "" ) {
			info.width = obj.style.width.replace("px","");
		}

		if ( obj.style.height !== "" ) {
			info.height = obj.style.height.replace("px","");
		}

		while (obj) {
			info.left += obj.offsetLeft;
			info.top += obj.offsetTop;
			obj = obj.offsetParent;
		}

		return info;
	},

	Client: function(elem) {
		// constructor for new simple upload client
		this.handlers = {};

		// unique ID
		this.id = ZeroClipboard_TableTools.nextId++;
		this.movieId = 'ZeroClipboard_TableToolsMovie_' + this.id;

		// register client with singleton to receive flash events
		ZeroClipboard_TableTools.register(this.id, this);

		// create movie
		if (elem) {
			this.glue(elem);
		}
	}
};

ZeroClipboard_TableTools.Client.prototype = {

	id: 0, // unique ID for us
	ready: false, // whether movie is ready to receive events or not
	movie: null, // reference to movie object
	clipText: '', // text to copy to clipboard
	fileName: '', // default file save name
	action: 'copy', // action to perform
	handCursorEnabled: true, // whether to show hand cursor, or default pointer cursor
	cssEffects: true, // enable CSS mouse effects on dom container
	handlers: null, // user event handlers
	sized: false,
	sheetName: '', // default sheet name for excel export

	glue: function(elem, title) {
		// glue to DOM element
		// elem can be ID or actual DOM element object
		this.domElement = ZeroClipboard_TableTools.$(elem);

		// float just above object, or zIndex 99 if dom element isn't set
		var zIndex = 99;
		if (this.domElement.style.zIndex) {
			zIndex = parseInt(this.domElement.style.zIndex, 10) + 1;
		}

		// find X/Y position of domElement
		var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement);

		// create floating DIV above element
		this.div = document.createElement('div');
		var style = this.div.style;
		style.position = 'absolute';
		style.left = '0px';
		style.top = '0px';
		style.width = (box.width) + 'px';
		style.height = box.height + 'px';
		style.zIndex = zIndex;

		if ( typeof title != "undefined" && title !== "" ) {
			this.div.title = title;
		}
		if ( box.width !== 0 && box.height !== 0 ) {
			this.sized = true;
		}

		// style.backgroundColor = '#f00'; // debug
		if ( this.domElement ) {
			this.domElement.appendChild(this.div);
			this.div.innerHTML = this.getHTML( box.width, box.height ).replace(/&/g, '&amp;');
		}
	},

	positionElement: function() {
		var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement);
		var style = this.div.style;

		style.position = 'absolute';
		//style.left = (this.domElement.offsetLeft)+'px';
		//style.top = this.domElement.offsetTop+'px';
		style.width = box.width + 'px';
		style.height = box.height + 'px';

		if ( box.width !== 0 && box.height !== 0 ) {
			this.sized = true;
		} else {
			return;
		}

		var flash = this.div.childNodes[0];
		flash.width = box.width;
		flash.height = box.height;
	},

	getHTML: function(width, height) {
		// return HTML for movie
		var html = '';
		var flashvars = 'id=' + this.id +
			'&width=' + width +
			'&height=' + height;

		if (navigator.userAgent.match(/MSIE/)) {
			// IE gets an OBJECT tag
			var protocol = location.href.match(/^https/i) ? 'https://' : 'http://';
			html += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="'+protocol+'download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" width="'+width+'" height="'+height+'" id="'+this.movieId+'" align="middle"><param name="allowScriptAccess" value="always" /><param name="allowFullScreen" value="false" /><param name="movie" value="'+ZeroClipboard_TableTools.moviePath+'" /><param name="loop" value="false" /><param name="menu" value="false" /><param name="quality" value="best" /><param name="bgcolor" value="#ffffff" /><param name="flashvars" value="'+flashvars+'"/><param name="wmode" value="transparent"/></object>';
		}
		else {
			// all other browsers get an EMBED tag
			html += '<embed id="'+this.movieId+'" src="'+ZeroClipboard_TableTools.moviePath+'" loop="false" menu="false" quality="best" bgcolor="#ffffff" width="'+width+'" height="'+height+'" name="'+this.movieId+'" align="middle" allowScriptAccess="always" allowFullScreen="false" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" flashvars="'+flashvars+'" wmode="transparent" />';
		}
		return html;
	},

	hide: function() {
		// temporarily hide floater offscreen
		if (this.div) {
			this.div.style.left = '-2000px';
		}
	},

	show: function() {
		// show ourselves after a call to hide()
		this.reposition();
	},

	destroy: function() {
		// destroy control and floater
		var that = this;

		if (this.domElement && this.div) {
			$(this.div).remove();

			this.domElement = null;
			this.div = null;

			$.each( ZeroClipboard_TableTools.clients, function ( id, client ) {
				if ( client === that ) {
					delete ZeroClipboard_TableTools.clients[ id ];
				}
			} );
		}
	},

	reposition: function(elem) {
		// reposition our floating div, optionally to new container
		// warning: container CANNOT change size, only position
		if (elem) {
			this.domElement = ZeroClipboard_TableTools.$(elem);
			if (!this.domElement) {
				this.hide();
			}
		}

		if (this.domElement && this.div) {
			var box = ZeroClipboard_TableTools.getDOMObjectPosition(this.domElement);
			var style = this.div.style;
			style.left = '' + box.left + 'px';
			style.top = '' + box.top + 'px';
		}
	},

	clearText: function() {
		// clear the text to be copy / saved
		this.clipText = '';
		if (this.ready) {
			this.movie.clearText();
		}
	},

	appendText: function(newText) {
		// append text to that which is to be copied / saved
		this.clipText += newText;
		if (this.ready) { this.movie.appendText(newText) ;}
	},

	setText: function(newText) {
		// set text to be copied to be copied / saved
		this.clipText = newText;
		if (this.ready) { this.movie.setText(newText) ;}
	},

	setFileName: function(newText) {
		// set the file name
		this.fileName = newText;
		if (this.ready) {
			this.movie.setFileName(newText);
		}
	},

	setSheetData: function(data) {
		// set the xlsx sheet data
		if (this.ready) {
			this.movie.setSheetData( JSON.stringify( data ) );
		}
	},

	setAction: function(newText) {
		// set action (save or copy)
		this.action = newText;
		if (this.ready) {
			this.movie.setAction(newText);
		}
	},

	addEventListener: function(eventName, func) {
		// add user event listener for event
		// event types: load, queueStart, fileStart, fileComplete, queueComplete, progress, error, cancel
		eventName = eventName.toString().toLowerCase().replace(/^on/, '');
		if (!this.handlers[eventName]) {
			this.handlers[eventName] = [];
		}
		this.handlers[eventName].push(func);
	},

	setHandCursor: function(enabled) {
		// enable hand cursor (true), or default arrow cursor (false)
		this.handCursorEnabled = enabled;
		if (this.ready) {
			this.movie.setHandCursor(enabled);
		}
	},

	setCSSEffects: function(enabled) {
		// enable or disable CSS effects on DOM container
		this.cssEffects = !!enabled;
	},

	receiveEvent: function(eventName, args) {
		var self;

		// receive event from flash
		eventName = eventName.toString().toLowerCase().replace(/^on/, '');

		// special behavior for certain events
		switch (eventName) {
			case 'load':
				// movie claims it is ready, but in IE this isn't always the case...
				// bug fix: Cannot extend EMBED DOM elements in Firefox, must use traditional function
				this.movie = document.getElementById(this.movieId);
				if (!this.movie) {
					self = this;
					setTimeout( function() { self.receiveEvent('load', null); }, 1 );
					return;
				}

				// firefox on pc needs a "kick" in order to set these in certain cases
				if (!this.ready && navigator.userAgent.match(/Firefox/) && navigator.userAgent.match(/Windows/)) {
					self = this;
					setTimeout( function() { self.receiveEvent('load', null); }, 100 );
					this.ready = true;
					return;
				}

				this.ready = true;
				this.movie.clearText();
				this.movie.appendText( this.clipText );
				this.movie.setFileName( this.fileName );
				this.movie.setAction( this.action );
				this.movie.setHandCursor( this.handCursorEnabled );
				break;

			case 'mouseover':
				if (this.domElement && this.cssEffects) {
					//this.domElement.addClass('hover');
					if (this.recoverActive) {
						this.domElement.addClass('active');
					}
				}
				break;

			case 'mouseout':
				if (this.domElement && this.cssEffects) {
					this.recoverActive = false;
					if (this.domElement.hasClass('active')) {
						this.domElement.removeClass('active');
						this.recoverActive = true;
					}
					//this.domElement.removeClass('hover');
				}
				break;

			case 'mousedown':
				if (this.domElement && this.cssEffects) {
					this.domElement.addClass('active');
				}
				break;

			case 'mouseup':
				if (this.domElement && this.cssEffects) {
					this.domElement.removeClass('active');
					this.recoverActive = false;
				}
				break;
		} // switch eventName

		if (this.handlers[eventName]) {
			for (var idx = 0, len = this.handlers[eventName].length; idx < len; idx++) {
				var func = this.handlers[eventName][idx];

				if (typeof(func) == 'function') {
					// actual function reference
					func(this, args);
				}
				else if ((typeof(func) == 'object') && (func.length == 2)) {
					// PHP style object + method, i.e. [myObject, 'myMethod']
					func[0][ func[1] ](this, args);
				}
				else if (typeof(func) == 'string') {
					// name of function
					window[func](this, args);
				}
			} // foreach event handler defined
		} // user defined handler for event
	}
};

ZeroClipboard_TableTools.hasFlash = function ()
{
	try {
		var fo = new ActiveXObject('ShockwaveFlash.ShockwaveFlash');
		if (fo) {
			return true;
		}
	}
	catch (e) {
		if (
			navigator.mimeTypes &&
			navigator.mimeTypes['application/x-shockwave-flash'] !== undefined &&
			navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin
		) {
			return true;
		}
	}

	return false;
};

// For the Flash binding to work, ZeroClipboard_TableTools must be on the global
// object list
window.ZeroClipboard_TableTools = ZeroClipboard_TableTools;



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Local (private) functions
 */

/**
 * If a Buttons instance is initlaised before it is placed into the DOM, Flash
 * won't be able to bind to it, so we need to wait until it is available, this
 * method abstracts that out.
 *
 * @param {ZeroClipboard} flash ZeroClipboard instance
 * @param {jQuery} node  Button
 */
var _glue = function ( flash, node )
{
	var id = node.attr('id');

	if ( node.parents('html').length ) {
		flash.glue( node[0], '' );
	}
	else {
		setTimeout( function () {
			_glue( flash, node );
		}, 500 );
	}
};

/**
 * Get the file name for an exported file.
 *
 * @param {object}  config       Button configuration
 * @param {boolean} incExtension Include the file name extension
 */
var _filename = function ( config, incExtension )
{
	// Backwards compatibility
	var filename = config.filename === '*' && config.title !== '*' && config.title !== undefined ?
		config.title :
		config.filename;

	if ( typeof filename === 'function' ) {
		filename = filename();
	}

	if ( filename.indexOf( '*' ) !== -1 ) {
		filename = $.trim( filename.replace( '*', $('title').text() ) );
	}

	// Strip characters which the OS will object to
	filename = filename.replace(/[^a-zA-Z0-9_\u00A1-\uFFFF\.,\-_ !\(\)]/g, "");

	return incExtension === undefined || incExtension === true ?
		filename+config.extension :
		filename;
};

/**
 * Get the sheet name for Excel exports.
 *
 * @param {object}  config       Button configuration
 */
var _sheetname = function ( config )
{
	var sheetName = 'Sheet1';

	if ( config.sheetName ) {
		sheetName = config.sheetName.replace(/[\[\]\*\/\\\?\:]/g, '');
	}

	return sheetName;
};

/**
 * Get the title for an exported file.
 *
 * @param {object}  config  Button configuration
 */
var _title = function ( config )
{
	var title = config.title;

	if ( typeof title === 'function' ) {
		title = title();
	}

	return title.indexOf( '*' ) !== -1 ?
		title.replace( '*', $('title').text() || 'Exported data' ) :
		title;
};

/**
 * Set the flash text. This has to be broken up into chunks as the Javascript /
 * Flash bridge has a size limit. There is no indication in the Flash
 * documentation what this is, and it probably depends upon the browser.
 * Experimentation shows that the point is around 50k when data starts to get
 * lost, so an 8K limit used here is safe.
 *
 * @param {ZeroClipboard} flash ZeroClipboard instance
 * @param {string}        data  Data to send to Flash
 */
var _setText = function ( flash, data )
{
	var parts = data.match(/[\s\S]{1,8192}/g) || [];

	flash.clearText();
	for ( var i=0, len=parts.length ; i<len ; i++ )
	{
		flash.appendText( parts[i] );
	}
};

/**
 * Get the newline character(s)
 *
 * @param {object}  config Button configuration
 * @return {string}        Newline character
 */
var _newLine = function ( config )
{
	return config.newline ?
		config.newline :
		navigator.userAgent.match(/Windows/) ?
			'\r\n' :
			'\n';
};

/**
 * Combine the data from the `buttons.exportData` method into a string that
 * will be used in the export file.
 *
 * @param  {DataTable.Api} dt     DataTables API instance
 * @param  {object}        config Button configuration
 * @return {object}               The data to export
 */
var _exportData = function ( dt, config )
{
	var newLine = _newLine( config );
	var data = dt.buttons.exportData( config.exportOptions );
	var boundary = config.fieldBoundary;
	var separator = config.fieldSeparator;
	var reBoundary = new RegExp( boundary, 'g' );
	var escapeChar = config.escapeChar !== undefined ?
		config.escapeChar :
		'\\';
	var join = function ( a ) {
		var s = '';

		// If there is a field boundary, then we might need to escape it in
		// the source data
		for ( var i=0, ien=a.length ; i<ien ; i++ ) {
			if ( i > 0 ) {
				s += separator;
			}

			s += boundary ?
				boundary + ('' + a[i]).replace( reBoundary, escapeChar+boundary ) + boundary :
				a[i];
		}

		return s;
	};

	var header = config.header ? join( data.header )+newLine : '';
	var footer = config.footer && data.footer ? newLine+join( data.footer ) : '';
	var body = [];

	for ( var i=0, ien=data.body.length ; i<ien ; i++ ) {
		body.push( join( data.body[i] ) );
	}

	return {
		str: header + body.join( newLine ) + footer,
		rows: body.length
	};
};


// Basic initialisation for the buttons is common between them
var flashButton = {
	available: function () {
		return ZeroClipboard_TableTools.hasFlash();
	},

	init: function ( dt, button, config ) {
		// Insert the Flash movie
		ZeroClipboard_TableTools.moviePath = DataTable.Buttons.swfPath;
		var flash = new ZeroClipboard_TableTools.Client();

		flash.setHandCursor( true );
		flash.addEventListener('mouseDown', function(client) {
			config._fromFlash = true;
			dt.button( button[0] ).trigger();
			config._fromFlash = false;
		} );

		_glue( flash, button );

		config._flash = flash;
	},

	destroy: function ( dt, button, config ) {
		config._flash.destroy();
	},

	fieldSeparator: ',',

	fieldBoundary: '"',

	exportOptions: {},

	title: '*',

	filename: '*',

	extension: '.csv',

	header: true,

	footer: false
};


/**
 * Convert from numeric position to letter for column names in Excel
 * @param  {int} n Column number
 * @return {string} Column letter(s) name
 */
function createCellPos( n ){
	var ordA = 'A'.charCodeAt(0);
	var ordZ = 'Z'.charCodeAt(0);
	var len = ordZ - ordA + 1;
	var s = "";

	while( n >= 0 ) {
		s = String.fromCharCode(n % len + ordA) + s;
		n = Math.floor(n / len) - 1;
	}

	return s;
}

/**
 * Create an XML node and add any children, attributes, etc without needing to
 * be verbose in the DOM.
 *
 * @param  {object} doc      XML document
 * @param  {string} nodeName Node name
 * @param  {object} opts     Options - can be `attr` (attributes), `children`
 *   (child nodes) and `text` (text content)
 * @return {node}            Created node
 */
function _createNode( doc, nodeName, opts ){
	var tempNode = doc.createElement( nodeName );

	if ( opts ) {
		if ( opts.attr ) {
			$(tempNode).attr( opts.attr );
		}

		if( opts.children ) {
			$.each( opts.children, function ( key, value ) {
				tempNode.appendChild( value );
			});
		}

		if( opts.text ) {
			tempNode.appendChild( doc.createTextNode( opts.text ) );
		}
	}

	return tempNode;
}

/**
 * Get the width for an Excel column based on the contents of that column
 * @param  {object} data Data for export
 * @param  {int}    col  Column index
 * @return {int}         Column width
 */
function _excelColWidth( data, col ) {
	var max = data.header[col].length;
	var len, lineSplit, str;

	if ( data.footer && data.footer[col].length > max ) {
		max = data.footer[col].length;
	}

	for ( var i=0, ien=data.body.length ; i<ien ; i++ ) {
		var point = data.body[i][col];
		str = point !== null && point !== undefined ?
			point.toString() :
			'';

		// If there is a newline character, workout the width of the column
		// based on the longest line in the string
		if ( str.indexOf('\n') !== -1 ) {
			lineSplit = str.split('\n');
			lineSplit.sort( function (a, b) {
				return b.length - a.length;
			} );

			len = lineSplit[0].length;
		}
		else {
			len = str.length;
		}

		if ( len > max ) {
			max = len;
		}

		// Max width rather than having potentially massive column widths
		if ( max > 40 ) {
			return 52; // 40 * 1.3
		}
	}

	max *= 1.3;

	// And a min width
	return max > 6 ? max : 6;
}

  var _serialiser = "";
    if (typeof window.XMLSerializer === 'undefined') {
        _serialiser = new function () {
            this.serializeToString = function (input) {
                return input.xml
            }
        };
    } else {
        _serialiser =  new XMLSerializer();
    }

    var _ieExcel;


/**
 * Convert XML documents in an object to strings
 * @param  {object} obj XLSX document object
 */
function _xlsxToStrings( obj ) {
	if ( _ieExcel === undefined ) {
		// Detect if we are dealing with IE's _awful_ serialiser by seeing if it
		// drop attributes
		_ieExcel = _serialiser
			.serializeToString(
				$.parseXML( excelStrings['xl/worksheets/sheet1.xml'] )
			)
			.indexOf( 'xmlns:r' ) === -1;
	}

	$.each( obj, function ( name, val ) {
		if ( $.isPlainObject( val ) ) {
			_xlsxToStrings( val );
		}
		else {
			if ( _ieExcel ) {
				// IE's XML serialiser will drop some name space attributes from
				// from the root node, so we need to save them. Do this by
				// replacing the namespace nodes with a regular attribute that
				// we convert back when serialised. Edge does not have this
				// issue
				var worksheet = val.childNodes[0];
				var i, ien;
				var attrs = [];

				for ( i=worksheet.attributes.length-1 ; i>=0 ; i-- ) {
					var attrName = worksheet.attributes[i].nodeName;
					var attrValue = worksheet.attributes[i].nodeValue;

					if ( attrName.indexOf( ':' ) !== -1 ) {
						attrs.push( { name: attrName, value: attrValue } );

						worksheet.removeAttribute( attrName );
					}
				}

				for ( i=0, ien=attrs.length ; i<ien ; i++ ) {
					var attr = val.createAttribute( attrs[i].name.replace( ':', '_dt_b_namespace_token_' ) );
					attr.value = attrs[i].value;
					worksheet.setAttributeNode( attr );
				}
			}

			var str = _serialiser.serializeToString(val);

			// Fix IE's XML
			if ( _ieExcel ) {
				// IE doesn't include the XML declaration
				if ( str.indexOf( '<?xml' ) === -1 ) {
					str = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+str;
				}

				// Return namespace attributes to being as such
				str = str.replace( /_dt_b_namespace_token_/g, ':' );
			}

			// Safari, IE and Edge will put empty name space attributes onto
			// various elements making them useless. This strips them out
			str = str.replace( /<([^<>]*?) xmlns=""([^<>]*?)>/g, '<$1 $2>' );

			obj[ name ] = str;
		}
	} );
}

// Excel - Pre-defined strings to build a basic XLSX file
var excelStrings = {
	"_rels/.rels":
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">'+
			'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>'+
		'</Relationships>',

	"xl/_rels/workbook.xml.rels":
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">'+
			'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>'+
			'<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>'+
		'</Relationships>',

	"[Content_Types].xml":
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+
		'<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">'+
			'<Default Extension="xml" ContentType="application/xml" />'+
			'<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" />'+
			'<Default Extension="jpeg" ContentType="image/jpeg" />'+
			'<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" />'+
			'<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />'+
			'<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" />'+
		'</Types>',

	"xl/workbook.xml":
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+
		'<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">'+
			'<fileVersion appName="xl" lastEdited="5" lowestEdited="5" rupBuild="24816"/>'+
			'<workbookPr showInkAnnotation="0" autoCompressPictures="0"/>'+
			'<bookViews>'+
				'<workbookView xWindow="0" yWindow="0" windowWidth="25600" windowHeight="19020" tabRatio="500"/>'+
			'</bookViews>'+
			'<sheets>'+
				'<sheet name="" sheetId="1" r:id="rId1"/>'+
			'</sheets>'+
		'</workbook>',

	"xl/worksheets/sheet1.xml":
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+
		'<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">'+
			'<sheetData/>'+
		'</worksheet>',

	"xl/styles.xml":
		'<?xml version="1.0" encoding="UTF-8"?>'+
		'<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">'+
			'<numFmts count="6">'+
				'<numFmt numFmtId="164" formatCode="#,##0.00_-\ [$$-45C]"/>'+
				'<numFmt numFmtId="165" formatCode="&quot;£&quot;#,##0.00"/>'+
				'<numFmt numFmtId="166" formatCode="[$€-2]\ #,##0.00"/>'+
				'<numFmt numFmtId="167" formatCode="0.0%"/>'+
				'<numFmt numFmtId="168" formatCode="#,##0;(#,##0)"/>'+
				'<numFmt numFmtId="169" formatCode="#,##0.00;(#,##0.00)"/>'+
			'</numFmts>'+
			'<fonts count="5" x14ac:knownFonts="1">'+
				'<font>'+
					'<sz val="11" />'+
					'<name val="Calibri" />'+
				'</font>'+
				'<font>'+
					'<sz val="11" />'+
					'<name val="Calibri" />'+
					'<color rgb="FFFFFFFF" />'+
				'</font>'+
				'<font>'+
					'<sz val="11" />'+
					'<name val="Calibri" />'+
					'<b />'+
				'</font>'+
				'<font>'+
					'<sz val="11" />'+
					'<name val="Calibri" />'+
					'<i />'+
				'</font>'+
				'<font>'+
					'<sz val="11" />'+
					'<name val="Calibri" />'+
					'<u />'+
				'</font>'+
			'</fonts>'+
			'<fills count="6">'+
				'<fill>'+
					'<patternFill patternType="none" />'+
				'</fill>'+
				'<fill/>'+ // Excel appears to use this as a dotted background regardless of values
				'<fill>'+
					'<patternFill patternType="solid">'+
						'<fgColor rgb="FFD9D9D9" />'+
						'<bgColor indexed="64" />'+
					'</patternFill>'+
				'</fill>'+
				'<fill>'+
					'<patternFill patternType="solid">'+
						'<fgColor rgb="FFD99795" />'+
						'<bgColor indexed="64" />'+
					'</patternFill>'+
				'</fill>'+
				'<fill>'+
					'<patternFill patternType="solid">'+
						'<fgColor rgb="ffc6efce" />'+
						'<bgColor indexed="64" />'+
					'</patternFill>'+
				'</fill>'+
				'<fill>'+
					'<patternFill patternType="solid">'+
						'<fgColor rgb="ffc6cfef" />'+
						'<bgColor indexed="64" />'+
					'</patternFill>'+
				'</fill>'+
			'</fills>'+
			'<borders count="2">'+
				'<border>'+
					'<left />'+
					'<right />'+
					'<top />'+
					'<bottom />'+
					'<diagonal />'+
				'</border>'+
				'<border diagonalUp="false" diagonalDown="false">'+
					'<left style="thin">'+
						'<color auto="1" />'+
					'</left>'+
					'<right style="thin">'+
						'<color auto="1" />'+
					'</right>'+
					'<top style="thin">'+
						'<color auto="1" />'+
					'</top>'+
					'<bottom style="thin">'+
						'<color auto="1" />'+
					'</bottom>'+
					'<diagonal />'+
				'</border>'+
			'</borders>'+
			'<cellStyleXfs count="1">'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" />'+
			'</cellStyleXfs>'+
			'<cellXfs count="61">'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="1" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="2" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="3" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="4" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment horizontal="left"/>'+
				'</xf>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment horizontal="center"/>'+
				'</xf>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment horizontal="right"/>'+
				'</xf>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment horizontal="fill"/>'+
				'</xf>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment textRotation="90"/>'+
				'</xf>'+
				'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">'+
					'<alignment wrapText="1"/>'+
				'</xf>'+
				'<xf numFmtId="9"   fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="164" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="165" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="166" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="167" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="168" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="169" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="3" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
				'<xf numFmtId="4" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>'+
			'</cellXfs>'+
			'<cellStyles count="1">'+
				'<cellStyle name="Normal" xfId="0" builtinId="0" />'+
			'</cellStyles>'+
			'<dxfs count="0" />'+
			'<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4" />'+
		'</styleSheet>'
};
// Note we could use 3 `for` loops for the styles, but when gzipped there is
// virtually no difference in size, since the above can be easily compressed

// Pattern matching for special number formats. Perhaps this should be exposed
// via an API in future?
var _excelSpecials = [
	{ match: /^\-?\d+\.\d%$/,       style: 60, fmt: function (d) { return d/100; } }, // Precent with d.p.
	{ match: /^\-?\d+\.?\d*%$/,     style: 56, fmt: function (d) { return d/100; } }, // Percent
	{ match: /^\-?\$[\d,]+.?\d*$/,  style: 57 }, // Dollars
	{ match: /^\-?£[\d,]+.?\d*$/,   style: 58 }, // Pounds
	{ match: /^\-?€[\d,]+.?\d*$/,   style: 59 }, // Euros
	{ match: /^\([\d,]+\)$/,        style: 61, fmt: function (d) { return -1 * d.replace(/[\(\)]/g, ''); } },  // Negative numbers indicated by brackets
	{ match: /^\([\d,]+\.\d{2}\)$/, style: 62, fmt: function (d) { return -1 * d.replace(/[\(\)]/g, ''); } },  // Negative numbers indicated by brackets - 2d.p.
	{ match: /^[\d,]+$/,            style: 63 }, // Numbers with thousand separators
	{ match: /^[\d,]+\.\d{2}$/,     style: 64 }  // Numbers with 2d.p. and thousands separators
];



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables options and methods
 */

// Set the default SWF path
DataTable.Buttons.swfPath = '//cdn.datatables.net/buttons/1.2.4/swf/flashExport.swf';

// Method to allow Flash buttons to be resized when made visible - as they are
// of zero height and width if initialised hidden
DataTable.Api.register( 'buttons.resize()', function () {
	$.each( ZeroClipboard_TableTools.clients, function ( i, client ) {
		if ( client.domElement !== undefined && client.domElement.parentNode ) {
			client.positionElement();
		}
	} );
} );


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Button definitions
 */

// Copy to clipboard
DataTable.ext.buttons.copyFlash = $.extend( {}, flashButton, {
	className: 'buttons-copy buttons-flash',

	text: function ( dt ) {
		return dt.i18n( 'buttons.copy', 'Copy' );
	},

	action: function ( e, dt, button, config ) {
		// Check that the trigger did actually occur due to a Flash activation
		if ( ! config._fromFlash ) {
			return;
		}

		this.processing( true );

		var flash = config._flash;
		var data = _exportData( dt, config );
		var output = config.customize ?
			config.customize( data.str, config ) :
			data.str;

		flash.setAction( 'copy' );
		_setText( flash, output );

		this.processing( false );

		dt.buttons.info(
			dt.i18n( 'buttons.copyTitle', 'Copy to clipboard' ),
			dt.i18n( 'buttons.copySuccess', {
				_: 'Copied %d rows to clipboard',
				1: 'Copied 1 row to clipboard'
			}, data.rows ),
			3000
		);
	},

	fieldSeparator: '\t',

	fieldBoundary: ''
} );

// CSV save file
DataTable.ext.buttons.csvFlash = $.extend( {}, flashButton, {
	className: 'buttons-csv buttons-flash',

	text: function ( dt ) {
		return dt.i18n( 'buttons.csv', 'CSV' );
	},

	action: function ( e, dt, button, config ) {
		// Set the text
		var flash = config._flash;
		var data = _exportData( dt, config );
		var output = config.customize ?
			config.customize( data.str, config ) :
			data.str;

		flash.setAction( 'csv' );
		flash.setFileName( _filename( config ) );
		_setText( flash, output );
	},

	escapeChar: '"'
} );

// Excel save file - this is really a CSV file using UTF-8 that Excel can read
DataTable.ext.buttons.excelFlash = $.extend( {}, flashButton, {
	className: 'buttons-excel buttons-flash',

	text: function ( dt ) {
		return dt.i18n( 'buttons.excel', 'Excel' );
	},

	action: function ( e, dt, button, config ) {
		this.processing( true );

		var flash = config._flash;
		var rowPos = 0;
		var rels = $.parseXML( excelStrings['xl/worksheets/sheet1.xml'] ) ; //Parses xml
		var relsGet = rels.getElementsByTagName( "sheetData" )[0];

		var xlsx = {
			_rels: {
				".rels": $.parseXML( excelStrings['_rels/.rels'] )
			},
			xl: {
				_rels: {
					"workbook.xml.rels": $.parseXML( excelStrings['xl/_rels/workbook.xml.rels'] )
				},
				"workbook.xml": $.parseXML( excelStrings['xl/workbook.xml'] ),
				"styles.xml": $.parseXML( excelStrings['xl/styles.xml'] ),
				"worksheets": {
					"sheet1.xml": rels
				}

			},
			"[Content_Types].xml": $.parseXML( excelStrings['[Content_Types].xml'])
		};

		var data = dt.buttons.exportData( config.exportOptions );
		var currentRow, rowNode;
		var addRow = function ( row ) {
			currentRow = rowPos+1;
			rowNode = _createNode( rels, "row", { attr: {r:currentRow} } );

			for ( var i=0, ien=row.length ; i<ien ; i++ ) {
				// Concat both the Cell Columns as a letter and the Row of the cell.
				var cellId = createCellPos(i) + '' + currentRow;
				var cell = null;

				// For null, undefined of blank cell, continue so it doesn't create the _createNode
				if ( row[i] === null || row[i] === undefined || row[i] === '' ) {
					continue;
				}

				row[i] = $.trim( row[i] );

				// Special number formatting options
				for ( var j=0, jen=_excelSpecials.length ; j<jen ; j++ ) {
					var special = _excelSpecials[j];

					// TODO Need to provide the ability for the specials to say
					// if they are returning a string, since at the moment it is
					// assumed to be a number
					if ( row[i].match && ! row[i].match(/^0\d+/) && row[i].match( special.match ) ) {
						var val = row[i].replace(/[^\d\.\-]/g, '');

						if ( special.fmt ) {
							val = special.fmt( val );
						}

						cell = _createNode( rels, 'c', {
							attr: {
								r: cellId,
								s: special.style
							},
							children: [
								_createNode( rels, 'v', { text: val } )
							]
						} );

						break;
					}
				}

				if ( ! cell ) {
					if ( typeof row[i] === 'number' || (
						row[i].match &&
						row[i].match(/^-?\d+(\.\d+)?$/) &&
						! row[i].match(/^0\d+/) )
					) {
						// Detect numbers - don't match numbers with leading zeros
						// or a negative anywhere but the start
						cell = _createNode( rels, 'c', {
							attr: {
								t: 'n',
								r: cellId
							},
							children: [
								_createNode( rels, 'v', { text: row[i] } )
							]
						} );
					}
					else {
						// String output - replace non standard characters for text output
						var text = ! row[i].replace ?
							row[i] :
							row[i].replace(/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F-\x9F]/g, '');

						cell = _createNode( rels, 'c', {
							attr: {
								t: 'inlineStr',
								r: cellId
							},
							children:{
								row: _createNode( rels, 'is', {
									children: {
										row: _createNode( rels, 't', {
											text: text
										} )
									}
								} )
							}
						} );
					}
				}

				rowNode.appendChild( cell );
			}

			relsGet.appendChild(rowNode);
			rowPos++;
		};

		$( 'sheets sheet', xlsx.xl['workbook.xml'] ).attr( 'name', _sheetname( config ) );

		if ( config.customizeData ) {
			config.customizeData( data );
		}

		if ( config.header ) {
			addRow( data.header, rowPos );
			$('row c', rels).attr( 's', '2' ); // bold
		}

		for ( var n=0, ie=data.body.length ; n<ie ; n++ ) {
			addRow( data.body[n], rowPos );
		}

		if ( config.footer && data.footer ) {
			addRow( data.footer, rowPos);
			$('row:last c', rels).attr( 's', '2' ); // bold
		}

		// Set column widths
		var cols = _createNode( rels, 'cols' );
		$('worksheet', rels).prepend( cols );

		for ( var i=0, ien=data.header.length ; i<ien ; i++ ) {
			cols.appendChild( _createNode( rels, 'col', {
				attr: {
					min: i+1,
					max: i+1,
					width: _excelColWidth( data, i ),
					customWidth: 1
				}
			} ) );
		}

		// Let the developer customise the document if they want to
		if ( config.customize ) {
			config.customize( xlsx );
		}

		_xlsxToStrings( xlsx );

		flash.setAction( 'excel' );
		flash.setFileName( _filename( config ) );
		flash.setSheetData( xlsx );
		_setText( flash, '' );

		this.processing( false );
	},

	extension: '.xlsx'
} );



// PDF export
DataTable.ext.buttons.pdfFlash = $.extend( {}, flashButton, {
	className: 'buttons-pdf buttons-flash',

	text: function ( dt ) {
		return dt.i18n( 'buttons.pdf', 'PDF' );
	},

	action: function ( e, dt, button, config ) {
		this.processing( true );

		// Set the text
		var flash = config._flash;
		var data = dt.buttons.exportData( config.exportOptions );
		var totalWidth = dt.table().node().offsetWidth;

		// Calculate the column width ratios for layout of the table in the PDF
		var ratios = dt.columns( config.columns ).indexes().map( function ( idx ) {
			return dt.column( idx ).header().offsetWidth / totalWidth;
		} );

		flash.setAction( 'pdf' );
		flash.setFileName( _filename( config ) );

		_setText( flash, JSON.stringify( {
			title:       _filename(config, false),
			message: typeof config.message == 'function' ? config.message(dt, button, config) : config.message,
			colWidth:    ratios.toArray(),
			orientation: config.orientation,
			size:        config.pageSize,
			header:      config.header ? data.header : null,
			footer:      config.footer ? data.footer : null,
			body:        data.body
		} ) );

		this.processing( false );
	},

	extension: '.pdf',

	orientation: 'portrait',

	pageSize: 'A4',

	message: '',

	newline: '\n'
} );


return DataTable.Buttons;
}));


/***/ }),

/***/ "./node_modules/datatables.net-buttons/js/buttons.html5.js":
/*!*****************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.html5.js ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * HTML5 export buttons for Buttons and DataTables.
 * © SpryMedia Ltd - datatables.net/license
 *
 * FileSaver.js (1.3.3) - MIT license
 * Copyright © 2016 Eli Grey - http://eligrey.com
 */

(function( factory ){
	if ( true ) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs"), __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ( $ ) {
			return factory( $, window, document );
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	}
	else { var cjsRequires, jq; }
}(function( $, window, document ) {
'use strict';
var DataTable = $.fn.dataTable;



// Allow the constructor to pass in JSZip and PDFMake from external requires.
// Otherwise, use globally defined variables, if they are available.
var useJszip;
var usePdfmake;

function _jsZip() {
	return useJszip || window.JSZip;
}
function _pdfMake() {
	return usePdfmake || window.pdfMake;
}

DataTable.Buttons.pdfMake = function (_) {
	if (!_) {
		return _pdfMake();
	}
	usePdfmake = _;
};

DataTable.Buttons.jszip = function (_) {
	if (!_) {
		return _jsZip();
	}
	useJszip = _;
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * FileSaver.js dependency
 */

/*jslint bitwise: true, indent: 4, laxbreak: true, laxcomma: true, smarttabs: true, plusplus: true */

var _saveAs = (function (view) {
	'use strict';
	// IE <10 is explicitly unsupported
	if (
		typeof view === 'undefined' ||
		(typeof navigator !== 'undefined' &&
			/MSIE [1-9]\./.test(navigator.userAgent))
	) {
		return;
	}
	var doc = view.document,
		// only get URL when necessary in case Blob.js hasn't overridden it yet
		get_URL = function () {
			return view.URL || view.webkitURL || view;
		},
		save_link = doc.createElementNS('http://www.w3.org/1999/xhtml', 'a'),
		can_use_save_link = 'download' in save_link,
		click = function (node) {
			var event = new MouseEvent('click');
			node.dispatchEvent(event);
		},
		is_safari = /constructor/i.test(view.HTMLElement) || view.safari,
		is_chrome_ios = /CriOS\/[\d]+/.test(navigator.userAgent),
		throw_outside = function (ex) {
			(view.setImmediate || view.setTimeout)(function () {
				throw ex;
			}, 0);
		},
		force_saveable_type = 'application/octet-stream',
		// the Blob API is fundamentally broken as there is no "downloadfinished" event to subscribe to
		arbitrary_revoke_timeout = 1000 * 40, // in ms
		revoke = function (file) {
			var revoker = function () {
				if (typeof file === 'string') {
					// file is an object URL
					get_URL().revokeObjectURL(file);
				}
				else {
					// file is a File
					file.remove();
				}
			};
			setTimeout(revoker, arbitrary_revoke_timeout);
		},
		dispatch = function (filesaver, event_types, event) {
			event_types = [].concat(event_types);
			var i = event_types.length;
			while (i--) {
				var listener = filesaver['on' + event_types[i]];
				if (typeof listener === 'function') {
					try {
						listener.call(filesaver, event || filesaver);
					} catch (ex) {
						throw_outside(ex);
					}
				}
			}
		},
		auto_bom = function (blob) {
			// prepend BOM for UTF-8 XML and text/* types (including HTML)
			// note: your browser will automatically convert UTF-16 U+FEFF to EF BB BF
			if (
				/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(
					blob.type
				)
			) {
				return new Blob([String.fromCharCode(0xfeff), blob], {
					type: blob.type
				});
			}
			return blob;
		},
		FileSaver = function (blob, name, no_auto_bom) {
			if (!no_auto_bom) {
				blob = auto_bom(blob);
			}
			// First try a.download, then web filesystem, then object URLs
			var filesaver = this,
				type = blob.type,
				force = type === force_saveable_type,
				object_url,
				dispatch_all = function () {
					dispatch(
						filesaver,
						'writestart progress write writeend'.split(' ')
					);
				},
				// on any filesys errors revert to saving with object URLs
				fs_error = function () {
					if (
						(is_chrome_ios || (force && is_safari)) &&
						view.FileReader
					) {
						// Safari doesn't allow downloading of blob urls
						var reader = new FileReader();
						reader.onloadend = function () {
							var url = is_chrome_ios
								? reader.result
								: reader.result.replace(
										/^data:[^;]*;/,
										'data:attachment/file;'
								);
							var popup = view.open(url, '_blank');
							if (!popup) view.location.href = url;
							url = undefined; // release reference before dispatching
							filesaver.readyState = filesaver.DONE;
							dispatch_all();
						};
						reader.readAsDataURL(blob);
						filesaver.readyState = filesaver.INIT;
						return;
					}
					// don't create more object URLs than needed
					if (!object_url) {
						object_url = get_URL().createObjectURL(blob);
					}
					if (force) {
						view.location.href = object_url;
					}
					else {
						var opened = view.open(object_url, '_blank');
						if (!opened) {
							// Apple does not allow window.open, see https://developer.apple.com/library/safari/documentation/Tools/Conceptual/SafariExtensionGuide/WorkingwithWindowsandTabs/WorkingwithWindowsandTabs.html
							view.location.href = object_url;
						}
					}
					filesaver.readyState = filesaver.DONE;
					dispatch_all();
					revoke(object_url);
				};
			filesaver.readyState = filesaver.INIT;

			if (can_use_save_link) {
				object_url = get_URL().createObjectURL(blob);
				setTimeout(function () {
					save_link.href = object_url;
					save_link.download = name;
					click(save_link);
					dispatch_all();
					revoke(object_url);
					filesaver.readyState = filesaver.DONE;
				});
				return;
			}

			fs_error();
		},
		FS_proto = FileSaver.prototype,
		saveAs = function (blob, name, no_auto_bom) {
			return new FileSaver(
				blob,
				name || blob.name || 'download',
				no_auto_bom
			);
		};
	// IE 10+ (native saveAs)
	if (typeof navigator !== 'undefined' && navigator.msSaveOrOpenBlob) {
		return function (blob, name, no_auto_bom) {
			name = name || blob.name || 'download';

			if (!no_auto_bom) {
				blob = auto_bom(blob);
			}
			return navigator.msSaveOrOpenBlob(blob, name);
		};
	}

	FS_proto.abort = function () {};
	FS_proto.readyState = FS_proto.INIT = 0;
	FS_proto.WRITING = 1;
	FS_proto.DONE = 2;

	FS_proto.error =
		FS_proto.onwritestart =
		FS_proto.onprogress =
		FS_proto.onwrite =
		FS_proto.onabort =
		FS_proto.onerror =
		FS_proto.onwriteend =
			null;

	return saveAs;
})(
	(typeof self !== 'undefined' && self) ||
		(typeof window !== 'undefined' && window) ||
		this.content
);

// Expose file saver on the DataTables API. Can't attach to `DataTables.Buttons`
// since this file can be loaded before Button's core!
DataTable.fileSave = _saveAs;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Local (private) functions
 */

/**
 * Get the sheet name for Excel exports.
 *
 * @param {object}	config Button configuration
 */
var _sheetname = function (config) {
	var sheetName = 'Sheet1';

	if (config.sheetName) {
		sheetName = config.sheetName.replace(/[\[\]\*\/\\\?\:]/g, '');
	}

	return sheetName;
};

/**
 * Get the newline character(s)
 *
 * @param {object}	config Button configuration
 * @return {string}				Newline character
 */
var _newLine = function (config) {
	return config.newline
		? config.newline
		: navigator.userAgent.match(/Windows/)
		? '\r\n'
		: '\n';
};

/**
 * Combine the data from the `buttons.exportData` method into a string that
 * will be used in the export file.
 *
 * @param	{DataTable.Api} dt		 DataTables API instance
 * @param	{object}				config Button configuration
 * @return {object}							 The data to export
 */
var _exportData = function (dt, config) {
	var newLine = _newLine(config);
	var data = dt.buttons.exportData(config.exportOptions);
	var boundary = config.fieldBoundary;
	var separator = config.fieldSeparator;
	var reBoundary = new RegExp(boundary, 'g');
	var escapeChar = config.escapeChar !== undefined ? config.escapeChar : '\\';
	var join = function (a) {
		var s = '';

		// If there is a field boundary, then we might need to escape it in
		// the source data
		for (var i = 0, ien = a.length; i < ien; i++) {
			if (i > 0) {
				s += separator;
			}

			s += boundary
				? boundary +
				('' + a[i]).replace(reBoundary, escapeChar + boundary) +
				boundary
				: a[i];
		}

		return s;
	};

	var header = '';
	var footer = '';
	var body = [];

	if (config.header) {
		header =
			data.headerStructure
				.map(function (row) {
					return join(
						row.map(function (cell) {
							return cell ? cell.title : '';
						})
					);
				})
				.join(newLine) + newLine;
	}

	if (config.footer && data.footer) {
		footer =
			data.footerStructure
				.map(function (row) {
					return join(
						row.map(function (cell) {
							return cell ? cell.title : '';
						})
					);
				})
				.join(newLine) + newLine;
	}

	for (var i = 0, ien = data.body.length; i < ien; i++) {
		body.push(join(data.body[i]));
	}

	return {
		str: header + body.join(newLine) + newLine + footer,
		rows: body.length
	};
};

/**
 * Older versions of Safari (prior to tech preview 18) don't support the
 * download option required.
 *
 * @return {Boolean} `true` if old Safari
 */
var _isDuffSafari = function () {
	var safari =
		navigator.userAgent.indexOf('Safari') !== -1 &&
		navigator.userAgent.indexOf('Chrome') === -1 &&
		navigator.userAgent.indexOf('Opera') === -1;

	if (!safari) {
		return false;
	}

	var version = navigator.userAgent.match(/AppleWebKit\/(\d+\.\d+)/);
	if (version && version.length > 1 && version[1] * 1 < 603.1) {
		return true;
	}

	return false;
};

/**
 * Convert from numeric position to letter for column names in Excel
 * @param  {int} n Column number
 * @return {string} Column letter(s) name
 */
function createCellPos(n) {
	var ordA = 'A'.charCodeAt(0);
	var ordZ = 'Z'.charCodeAt(0);
	var len = ordZ - ordA + 1;
	var s = '';

	while (n >= 0) {
		s = String.fromCharCode((n % len) + ordA) + s;
		n = Math.floor(n / len) - 1;
	}

	return s;
}

try {
	var _serialiser = new XMLSerializer();
	var _ieExcel;
} catch (t) {
	// noop
}

/**
 * Recursively add XML files from an object's structure to a ZIP file. This
 * allows the XSLX file to be easily defined with an object's structure matching
 * the files structure.
 *
 * @param {JSZip} zip ZIP package
 * @param {object} obj Object to add (recursive)
 */
function _addToZip(zip, obj) {
	if (_ieExcel === undefined) {
		// Detect if we are dealing with IE's _awful_ serialiser by seeing if it
		// drop attributes
		_ieExcel =
			_serialiser
				.serializeToString(
					new window.DOMParser().parseFromString(
						excelStrings['xl/worksheets/sheet1.xml'],
						'text/xml'
					)
				)
				.indexOf('xmlns:r') === -1;
	}

	$.each(obj, function (name, val) {
		if ($.isPlainObject(val)) {
			var newDir = zip.folder(name);
			_addToZip(newDir, val);
		}
		else {
			if (_ieExcel) {
				// IE's XML serialiser will drop some name space attributes from
				// from the root node, so we need to save them. Do this by
				// replacing the namespace nodes with a regular attribute that
				// we convert back when serialised. Edge does not have this
				// issue
				var worksheet = val.childNodes[0];
				var i, ien;
				var attrs = [];

				for (i = worksheet.attributes.length - 1; i >= 0; i--) {
					var attrName = worksheet.attributes[i].nodeName;
					var attrValue = worksheet.attributes[i].nodeValue;

					if (attrName.indexOf(':') !== -1) {
						attrs.push({ name: attrName, value: attrValue });

						worksheet.removeAttribute(attrName);
					}
				}

				for (i = 0, ien = attrs.length; i < ien; i++) {
					var attr = val.createAttribute(
						attrs[i].name.replace(':', '_dt_b_namespace_token_')
					);
					attr.value = attrs[i].value;
					worksheet.setAttributeNode(attr);
				}
			}

			var str = _serialiser.serializeToString(val);

			// Fix IE's XML
			if (_ieExcel) {
				// IE doesn't include the XML declaration
				if (str.indexOf('<?xml') === -1) {
					str =
						'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
						str;
				}

				// Return namespace attributes to being as such
				str = str.replace(/_dt_b_namespace_token_/g, ':');

				// Remove testing name space that IE puts into the space preserve attr
				str = str.replace(/xmlns:NS[\d]+="" NS[\d]+:/g, '');
			}

			// Safari, IE and Edge will put empty name space attributes onto
			// various elements making them useless. This strips them out
			str = str.replace(/<([^<>]*?) xmlns=""([^<>]*?)>/g, '<$1 $2>');

			zip.file(name, str);
		}
	});
}

/**
 * Create an XML node and add any children, attributes, etc without needing to
 * be verbose in the DOM.
 *
 * @param  {object} doc      XML document
 * @param  {string} nodeName Node name
 * @param  {object} opts     Options - can be `attr` (attributes), `children`
 *   (child nodes) and `text` (text content)
 * @return {node}            Created node
 */
function _createNode(doc, nodeName, opts) {
	var tempNode = doc.createElement(nodeName);

	if (opts) {
		if (opts.attr) {
			$(tempNode).attr(opts.attr);
		}

		if (opts.children) {
			$.each(opts.children, function (key, value) {
				tempNode.appendChild(value);
			});
		}

		if (opts.text !== null && opts.text !== undefined) {
			tempNode.appendChild(doc.createTextNode(opts.text));
		}
	}

	return tempNode;
}

/**
 * Get the width for an Excel column based on the contents of that column
 * @param  {object} data Data for export
 * @param  {int}    col  Column index
 * @return {int}         Column width
 */
function _excelColWidth(data, col) {
	var max = data.header[col].length;
	var len, lineSplit, str;

	if (data.footer && data.footer[col] && data.footer[col].length > max) {
		max = data.footer[col].length;
	}

	for (var i = 0, ien = data.body.length; i < ien; i++) {
		var point = data.body[i][col];
		str = point !== null && point !== undefined ? point.toString() : '';

		// If there is a newline character, workout the width of the column
		// based on the longest line in the string
		if (str.indexOf('\n') !== -1) {
			lineSplit = str.split('\n');
			lineSplit.sort(function (a, b) {
				return b.length - a.length;
			});

			len = lineSplit[0].length;
		}
		else {
			len = str.length;
		}

		if (len > max) {
			max = len;
		}

		// Max width rather than having potentially massive column widths
		if (max > 40) {
			return 54; // 40 * 1.35
		}
	}

	max *= 1.35;

	// And a min width
	return max > 6 ? max : 6;
}

// Excel - Pre-defined strings to build a basic XLSX file
var excelStrings = {
	'_rels/.rels':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' +
		'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>' +
		'</Relationships>',

	'xl/_rels/workbook.xml.rels':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">' +
		'<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>' +
		'<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>' +
		'</Relationships>',

	'[Content_Types].xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">' +
		'<Default Extension="xml" ContentType="application/xml" />' +
		'<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" />' +
		'<Default Extension="jpeg" ContentType="image/jpeg" />' +
		'<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" />' +
		'<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />' +
		'<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" />' +
		'</Types>',

	'xl/workbook.xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">' +
		'<fileVersion appName="xl" lastEdited="5" lowestEdited="5" rupBuild="24816"/>' +
		'<workbookPr showInkAnnotation="0" autoCompressPictures="0"/>' +
		'<bookViews>' +
		'<workbookView xWindow="0" yWindow="0" windowWidth="25600" windowHeight="19020" tabRatio="500"/>' +
		'</bookViews>' +
		'<sheets>' +
		'<sheet name="Sheet1" sheetId="1" r:id="rId1"/>' +
		'</sheets>' +
		'<definedNames/>' +
		'</workbook>',

	'xl/worksheets/sheet1.xml':
		'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
		'<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' +
		'<sheetData/>' +
		'<mergeCells count="0"/>' +
		'</worksheet>',

	'xl/styles.xml':
		'<?xml version="1.0" encoding="UTF-8"?>' +
		'<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">' +
		'<numFmts count="6">' +
		'<numFmt numFmtId="164" formatCode="[$$-409]#,##0.00;-[$$-409]#,##0.00"/>' +
		'<numFmt numFmtId="165" formatCode="&quot;£&quot;#,##0.00"/>' +
		'<numFmt numFmtId="166" formatCode="[$€-2] #,##0.00"/>' +
		'<numFmt numFmtId="167" formatCode="0.0%"/>' +
		'<numFmt numFmtId="168" formatCode="#,##0;(#,##0)"/>' +
		'<numFmt numFmtId="169" formatCode="#,##0.00;(#,##0.00)"/>' +
		'</numFmts>' +
		'<fonts count="5" x14ac:knownFonts="1">' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<color rgb="FFFFFFFF" />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<b />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<i />' +
		'</font>' +
		'<font>' +
		'<sz val="11" />' +
		'<name val="Calibri" />' +
		'<u />' +
		'</font>' +
		'</fonts>' +
		'<fills count="6">' +
		'<fill>' +
		'<patternFill patternType="none" />' +
		'</fill>' +
		'<fill>' + // Excel appears to use this as a dotted background regardless of values but
		'<patternFill patternType="none" />' + // to be valid to the schema, use a patternFill
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="FFD9D9D9" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="FFD99795" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="ffc6efce" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'<fill>' +
		'<patternFill patternType="solid">' +
		'<fgColor rgb="ffc6cfef" />' +
		'<bgColor indexed="64" />' +
		'</patternFill>' +
		'</fill>' +
		'</fills>' +
		'<borders count="2">' +
		'<border>' +
		'<left />' +
		'<right />' +
		'<top />' +
		'<bottom />' +
		'<diagonal />' +
		'</border>' +
		'<border diagonalUp="false" diagonalDown="false">' +
		'<left style="thin">' +
		'<color auto="1" />' +
		'</left>' +
		'<right style="thin">' +
		'<color auto="1" />' +
		'</right>' +
		'<top style="thin">' +
		'<color auto="1" />' +
		'</top>' +
		'<bottom style="thin">' +
		'<color auto="1" />' +
		'</bottom>' +
		'<diagonal />' +
		'</border>' +
		'</borders>' +
		'<cellStyleXfs count="1">' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" />' +
		'</cellStyleXfs>' +
		'<cellXfs count="68">' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="2" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="3" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="4" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="5" borderId="0" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="0" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="2" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="3" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="4" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="1" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="2" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="3" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="4" fillId="5" borderId="1" applyFont="1" applyFill="1" applyBorder="1"/>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="left"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="center"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="right"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment horizontal="fill"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment textRotation="90"/>' +
		'</xf>' +
		'<xf numFmtId="0" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyAlignment="1">' +
		'<alignment wrapText="1"/>' +
		'</xf>' +
		'<xf numFmtId="9"   fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="164" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="165" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="166" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="167" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="168" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="169" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="3" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="4" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="1" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="2" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'<xf numFmtId="14" fontId="0" fillId="0" borderId="0" applyFont="1" applyFill="1" applyBorder="1" xfId="0" applyNumberFormat="1"/>' +
		'</cellXfs>' +
		'<cellStyles count="1">' +
		'<cellStyle name="Normal" xfId="0" builtinId="0" />' +
		'</cellStyles>' +
		'<dxfs count="0" />' +
		'<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4" />' +
		'</styleSheet>'
};
// Note we could use 3 `for` loops for the styles, but when gzipped there is
// virtually no difference in size, since the above can be easily compressed

// Pattern matching for special number formats. Perhaps this should be exposed
// via an API in future?
// Ref: section 3.8.30 - built in formatters in open spreadsheet
//   https://www.ecma-international.org/news/TC45_current_work/Office%20Open%20XML%20Part%204%20-%20Markup%20Language%20Reference.pdf
var _excelSpecials = [
	{
		match: /^\-?\d+\.\d%$/,
		style: 60,
		fmt: function (d) {
			return d / 100;
		}
	}, // Percent with d.p.
	{
		match: /^\-?\d+\.?\d*%$/,
		style: 56,
		fmt: function (d) {
			return d / 100;
		}
	}, // Percent
	{ match: /^\-?\$[\d,]+.?\d*$/, style: 57 }, // Dollars
	{ match: /^\-?£[\d,]+.?\d*$/, style: 58 }, // Pounds
	{ match: /^\-?€[\d,]+.?\d*$/, style: 59 }, // Euros
	{ match: /^\-?\d+$/, style: 65 }, // Numbers without thousand separators
	{ match: /^\-?\d+\.\d{2}$/, style: 66 }, // Numbers 2 d.p. without thousands separators
	{
		match: /^\([\d,]+\)$/,
		style: 61,
		fmt: function (d) {
			return -1 * d.replace(/[\(\)]/g, '');
		}
	}, // Negative numbers indicated by brackets
	{
		match: /^\([\d,]+\.\d{2}\)$/,
		style: 62,
		fmt: function (d) {
			return -1 * d.replace(/[\(\)]/g, '');
		}
	}, // Negative numbers indicated by brackets - 2d.p.
	{ match: /^\-?[\d,]+$/, style: 63 }, // Numbers with thousand separators
	{ match: /^\-?[\d,]+\.\d{2}$/, style: 64 },
	{
		match: /^[\d]{4}\-[01][\d]\-[0123][\d]$/,
		style: 67,
		fmt: function (d) {
			return Math.round(25569 + Date.parse(d) / (86400 * 1000));
		}
	} //Date yyyy-mm-dd
];

var _excelMergeCells = function (rels, row, column, rowspan, colspan) {
	var mergeCells = $('mergeCells', rels);

	mergeCells[0].appendChild(
		_createNode(rels, 'mergeCell', {
			attr: {
				ref:
					createCellPos(column) +
					row +
					':' +
					createCellPos(column + colspan - 1) +
					(row + rowspan - 1)
			}
		})
	);

	mergeCells.attr('count', parseFloat(mergeCells.attr('count')) + 1);
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Buttons
 */

//
// Copy to clipboard
//
DataTable.ext.buttons.copyHtml5 = {
	className: 'buttons-copy buttons-html5',

	text: function (dt) {
		return dt.i18n('buttons.copy', 'Copy');
	},

	action: function (e, dt, button, config, cb) {
		var exportData = _exportData(dt, config);
		var info = dt.buttons.exportInfo(config);
		var newline = _newLine(config);
		var output = exportData.str;
		var hiddenDiv = $('<div/>').css({
			height: 1,
			width: 1,
			overflow: 'hidden',
			position: 'fixed',
			top: 0,
			left: 0
		});

		if (info.title) {
			output = info.title + newline + newline + output;
		}

		if (info.messageTop) {
			output = info.messageTop + newline + newline + output;
		}

		if (info.messageBottom) {
			output = output + newline + newline + info.messageBottom;
		}

		if (config.customize) {
			output = config.customize(output, config, dt);
		}

		var textarea = $('<textarea readonly/>')
			.val(output)
			.appendTo(hiddenDiv);

		// For browsers that support the copy execCommand, try to use it
		if (document.queryCommandSupported('copy')) {
			hiddenDiv.appendTo(dt.table().container());
			textarea[0].focus();
			textarea[0].select();

			try {
				var successful = document.execCommand('copy');
				hiddenDiv.remove();

				if (successful) {
					dt.buttons.info(
						dt.i18n('buttons.copyTitle', 'Copy to clipboard'),
						dt.i18n(
							'buttons.copySuccess',
							{
								1: 'Copied one row to clipboard',
								_: 'Copied %d rows to clipboard'
							},
							exportData.rows
						),
						2000
					);

					cb();
					return;
				}
			} catch (t) {
				// noop
			}
		}

		// Otherwise we show the text box and instruct the user to use it
		var message = $(
			'<span>' +
				dt.i18n(
					'buttons.copyKeys',
					'Press <i>ctrl</i> or <i>\u2318</i> + <i>C</i> to copy the table data<br>to your system clipboard.<br><br>' +
						'To cancel, click this message or press escape.'
				) +
				'</span>'
		).append(hiddenDiv);

		dt.buttons.info(
			dt.i18n('buttons.copyTitle', 'Copy to clipboard'),
			message,
			0
		);

		// Select the text so when the user activates their system clipboard
		// it will copy that text
		textarea[0].focus();
		textarea[0].select();

		// Event to hide the message when the user is done
		var container = $(message).closest('.dt-button-info');
		var close = function () {
			container.off('click.buttons-copy');
			$(document).off('.buttons-copy');
			dt.buttons.info(false);
		};

		container.on('click.buttons-copy', close);
		$(document)
			.on('keydown.buttons-copy', function (e) {
				if (e.keyCode === 27) {
					// esc
					close();
					cb();
				}
			})
			.on('copy.buttons-copy cut.buttons-copy', function () {
				close();
				cb();
			});
	},

	async: 100,

	exportOptions: {},

	fieldSeparator: '\t',

	fieldBoundary: '',

	header: true,

	footer: true,

	title: '*',

	messageTop: '*',

	messageBottom: '*'
};

//
// CSV export
//
DataTable.ext.buttons.csvHtml5 = {
	bom: false,

	className: 'buttons-csv buttons-html5',

	available: function () {
		return window.FileReader !== undefined && window.Blob;
	},

	text: function (dt) {
		return dt.i18n('buttons.csv', 'CSV');
	},

	action: function (e, dt, button, config, cb) {
		// Set the text
		var output = _exportData(dt, config).str;
		var info = dt.buttons.exportInfo(config);
		var charset = config.charset;

		if (config.customize) {
			output = config.customize(output, config, dt);
		}

		if (charset !== false) {
			if (!charset) {
				charset = document.characterSet || document.charset;
			}

			if (charset) {
				charset = ';charset=' + charset;
			}
		}
		else {
			charset = '';
		}

		if (config.bom) {
			output = String.fromCharCode(0xfeff) + output;
		}

		_saveAs(
			new Blob([output], { type: 'text/csv' + charset }),
			info.filename,
			true
		);

		cb();
	},

	async: 100,

	filename: '*',

	extension: '.csv',

	exportOptions: {},

	fieldSeparator: ',',

	fieldBoundary: '"',

	escapeChar: '"',

	charset: null,

	header: true,

	footer: true
};

//
// Excel (xlsx) export
//
DataTable.ext.buttons.excelHtml5 = {
	className: 'buttons-excel buttons-html5',

	available: function () {
		return (
			window.FileReader !== undefined &&
			_jsZip() !== undefined &&
			!_isDuffSafari() &&
			_serialiser
		);
	},

	text: function (dt) {
		return dt.i18n('buttons.excel', 'Excel');
	},

	action: function (e, dt, button, config, cb) {
		var rowPos = 0;
		var dataStartRow, dataEndRow;
		var getXml = function (type) {
			var str = excelStrings[type];

			//str = str.replace( /xmlns:/g, 'xmlns_' ).replace( /mc:/g, 'mc_' );

			return $.parseXML(str);
		};
		var rels = getXml('xl/worksheets/sheet1.xml');
		var relsGet = rels.getElementsByTagName('sheetData')[0];

		var xlsx = {
			_rels: {
				'.rels': getXml('_rels/.rels')
			},
			xl: {
				_rels: {
					'workbook.xml.rels': getXml('xl/_rels/workbook.xml.rels')
				},
				'workbook.xml': getXml('xl/workbook.xml'),
				'styles.xml': getXml('xl/styles.xml'),
				worksheets: {
					'sheet1.xml': rels
				}
			},
			'[Content_Types].xml': getXml('[Content_Types].xml')
		};

		var data = dt.buttons.exportData(config.exportOptions);
		var currentRow, rowNode;
		var addRow = function (row) {
			currentRow = rowPos + 1;
			rowNode = _createNode(rels, 'row', { attr: { r: currentRow } });

			for (var i = 0, ien = row.length; i < ien; i++) {
				// Concat both the Cell Columns as a letter and the Row of the cell.
				var cellId = createCellPos(i) + '' + currentRow;
				var cell = null;

				// For null, undefined of blank cell, continue so it doesn't create the _createNode
				if (row[i] === null || row[i] === undefined || row[i] === '') {
					if (config.createEmptyCells === true) {
						row[i] = '';
					}
					else {
						continue;
					}
				}

				var originalContent = row[i];
				row[i] =
					typeof row[i].trim === 'function' ? row[i].trim() : row[i];

				// Special number formatting options
				for (var j = 0, jen = _excelSpecials.length; j < jen; j++) {
					var special = _excelSpecials[j];

					// TODO Need to provide the ability for the specials to say
					// if they are returning a string, since at the moment it is
					// assumed to be a number
					if (
						row[i].match &&
						!row[i].match(/^0\d+/) &&
						row[i].match(special.match)
					) {
						var val = row[i].replace(/[^\d\.\-]/g, '');

						if (special.fmt) {
							val = special.fmt(val);
						}

						cell = _createNode(rels, 'c', {
							attr: {
								r: cellId,
								s: special.style
							},
							children: [_createNode(rels, 'v', { text: val })]
						});

						break;
					}
				}

				if (!cell) {
					if (
						typeof row[i] === 'number' ||
						(row[i].match &&
							row[i].match(/^-?\d+(\.\d+)?([eE]\-?\d+)?$/) && // Includes exponential format
							!row[i].match(/^0\d+/))
					) {
						// Detect numbers - don't match numbers with leading zeros
						// or a negative anywhere but the start
						cell = _createNode(rels, 'c', {
							attr: {
								t: 'n',
								r: cellId
							},
							children: [_createNode(rels, 'v', { text: row[i] })]
						});
					}
					else {
						// String output - replace non standard characters for text output
						/*eslint no-control-regex: "off"*/
						var text = !originalContent.replace
							? originalContent
							: originalContent.replace(
									/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F-\x9F]/g,
									''
							);

						cell = _createNode(rels, 'c', {
							attr: {
								t: 'inlineStr',
								r: cellId
							},
							children: {
								row: _createNode(rels, 'is', {
									children: {
										row: _createNode(rels, 't', {
											text: text,
											attr: {
												'xml:space': 'preserve'
											}
										})
									}
								})
							}
						});
					}
				}

				rowNode.appendChild(cell);
			}

			relsGet.appendChild(rowNode);
			rowPos++;
		};

		var addHeader = function (structure) {
			structure.forEach(function (row) {
				addRow(
					row.map(function (cell) {
						return cell ? cell.title : '';
					}),
					rowPos
				);
				$('row:last c', rels).attr('s', '2'); // bold

				// Add any merge cells
				row.forEach(function (cell, columnCounter) {
					if (cell && (cell.colSpan > 1 || cell.rowSpan > 1)) {
						_excelMergeCells(
							rels,
							rowPos,
							columnCounter,
							cell.rowSpan,
							cell.colSpan
						);
					}
				});
			});
		};

		if (config.customizeData) {
			config.customizeData(data);
		}

		// Title and top messages
		var exportInfo = dt.buttons.exportInfo(config);
		if (exportInfo.title) {
			addRow([exportInfo.title], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
			$('row:last c', rels).attr('s', '51'); // centre
		}

		if (exportInfo.messageTop) {
			addRow([exportInfo.messageTop], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
		}

		// Table header
		if (config.header) {
			addHeader(data.headerStructure);
		}

		dataStartRow = rowPos;

		// Table body
		for (var n = 0, ie = data.body.length; n < ie; n++) {
			addRow(data.body[n], rowPos);
		}

		dataEndRow = rowPos;

		// Table footer
		if (config.footer && data.footer) {
			addHeader(data.footerStructure);
		}

		// Below the table
		if (exportInfo.messageBottom) {
			addRow([exportInfo.messageBottom], rowPos);
			_excelMergeCells(rels, rowPos, 0, 1, data.header.length);
		}

		// Set column widths
		var cols = _createNode(rels, 'cols');
		$('worksheet', rels).prepend(cols);

		for (var i = 0, ien = data.header.length; i < ien; i++) {
			cols.appendChild(
				_createNode(rels, 'col', {
					attr: {
						min: i + 1,
						max: i + 1,
						width: _excelColWidth(data, i),
						customWidth: 1
					}
				})
			);
		}

		// Workbook modifications
		var workbook = xlsx.xl['workbook.xml'];

		$('sheets sheet', workbook).attr('name', _sheetname(config));

		// Auto filter for columns
		if (config.autoFilter) {
			$('mergeCells', rels).before(
				_createNode(rels, 'autoFilter', {
					attr: {
						ref:
							'A' +
							dataStartRow +
							':' +
							createCellPos(data.header.length - 1) +
							dataEndRow
					}
				})
			);

			$('definedNames', workbook).append(
				_createNode(workbook, 'definedName', {
					attr: {
						name: '_xlnm._FilterDatabase',
						localSheetId: '0',
						hidden: 1
					},
					text:
						_sheetname(config) +
						'!$A$' +
						dataStartRow +
						':' +
						createCellPos(data.header.length - 1) +
						dataEndRow
				})
			);
		}

		// Let the developer customise the document if they want to
		if (config.customize) {
			config.customize(xlsx, config, dt);
		}

		// Excel doesn't like an empty mergeCells tag
		if ($('mergeCells', rels).children().length === 0) {
			$('mergeCells', rels).remove();
		}

		var jszip = _jsZip();
		var zip = new jszip();
		var zipConfig = {
			compression: 'DEFLATE',
			type: 'blob',
			mimeType:
				'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
		};

		_addToZip(zip, xlsx);

		// Modern Excel has a 218 character limit on the file name + path of the file (why!?)
		// https://support.microsoft.com/en-us/office/excel-specifications-and-limits-1672b34d-7043-467e-8e27-269d656771c3
		// So we truncate to allow for this.
		var filename = exportInfo.filename;

		if (filename > 175) {
			filename = filename.substr(0, 175);
		}

		if (zip.generateAsync) {
			// JSZip 3+
			zip.generateAsync(zipConfig).then(function (blob) {
				_saveAs(blob, filename);
				cb();
			});
		}
		else {
			// JSZip 2.5
			_saveAs(zip.generate(zipConfig), filename);
			cb();
		}
	},

	async: 100,

	filename: '*',

	extension: '.xlsx',

	exportOptions: {},

	header: true,

	footer: true,

	title: '*',

	messageTop: '*',

	messageBottom: '*',

	createEmptyCells: false,

	autoFilter: false,

	sheetName: ''
};

//
// PDF export - using pdfMake - http://pdfmake.org
//
DataTable.ext.buttons.pdfHtml5 = {
	className: 'buttons-pdf buttons-html5',

	available: function () {
		return window.FileReader !== undefined && _pdfMake();
	},

	text: function (dt) {
		return dt.i18n('buttons.pdf', 'PDF');
	},

	action: function (e, dt, button, config, cb) {
		var data = dt.buttons.exportData(config.exportOptions);
		var info = dt.buttons.exportInfo(config);
		var rows = [];

		if (config.header) {
			data.headerStructure.forEach(function (row) {
				rows.push(
					row.map(function (cell) {
						return cell
							? {
									text: cell.title,
									colSpan: cell.colspan,
									rowSpan: cell.rowspan,
									style: 'tableHeader'
							}
							: {};
					})
				);
			});
		}

		for (var i = 0, ien = data.body.length; i < ien; i++) {
			rows.push(
				data.body[i].map(function (d) {
					return {
						text:
							d === null || d === undefined
								? ''
								: typeof d === 'string'
								? d
								: d.toString()
					};
				})
			);
		}

		if (config.footer) {
			data.footerStructure.forEach(function (row) {
				rows.push(
					row.map(function (cell) {
						return cell
							? {
									text: cell.title,
									colSpan: cell.colspan,
									rowSpan: cell.rowspan,
									style: 'tableHeader'
							}
							: {};
					})
				);
			});
		}

		var doc = {
			pageSize: config.pageSize,
			pageOrientation: config.orientation,
			content: [
				{
					style: 'table',
					table: {
						headerRows: data.headerStructure.length,
						footerRows: data.footerStructure.length, // Used for styling, doesn't do anything in pdfmake
						body: rows
					},
					layout: {
						hLineWidth: function (i, node) {
							if (i === 0 || i === node.table.body.length) {
								return 0;
							}
							return 0.5;
						},
						vLineWidth: function () {
							return 0;
						},
						hLineColor: function (i, node) {
							return i === node.table.headerRows ||
								i ===
									node.table.body.length -
										node.table.footerRows
								? '#333'
								: '#ddd';
						},
						fillColor: function (rowIndex) {
							if (rowIndex < data.headerStructure.length) {
								return '#fff';
							}
							return rowIndex % 2 === 0 ? '#f3f3f3' : null;
						},
						paddingTop: function () {
							return 5;
						},
						paddingBottom: function () {
							return 5;
						}
					}
				}
			],
			styles: {
				tableHeader: {
					bold: true,
					fontSize: 11,
					alignment: 'center'
				},
				tableFooter: {
					bold: true,
					fontSize: 11
				},
				table: {
					margin: [0, 5, 0, 5]
				},
				title: {
					alignment: 'center',
					fontSize: 13
				},
				message: {}
			},
			defaultStyle: {
				fontSize: 10
			}
		};

		if (info.messageTop) {
			doc.content.unshift({
				text: info.messageTop,
				style: 'message',
				margin: [0, 0, 0, 12]
			});
		}

		if (info.messageBottom) {
			doc.content.push({
				text: info.messageBottom,
				style: 'message',
				margin: [0, 0, 0, 12]
			});
		}

		if (info.title) {
			doc.content.unshift({
				text: info.title,
				style: 'title',
				margin: [0, 0, 0, 12]
			});
		}

		if (config.customize) {
			config.customize(doc, config, dt);
		}

		var pdf = _pdfMake().createPdf(doc);

		if (config.download === 'open' && !_isDuffSafari()) {
			pdf.open();
		}
		else {
			pdf.download(info.filename);
		}

		cb();
	},

	async: 100,

	title: '*',

	filename: '*',

	extension: '.pdf',

	exportOptions: {},

	orientation: 'portrait',

	// This isn't perfect, but it is close
	pageSize:
		navigator.language === 'en-US' || navigator.language === 'en-CA'
			? 'LETTER'
			: 'A4',

	header: true,

	footer: true,

	messageTop: '*',

	messageBottom: '*',

	customize: null,

	download: 'download'
};


return DataTable;
}));


/***/ }),

/***/ "./node_modules/datatables.net-buttons/js/buttons.print.js":
/*!*****************************************************************!*\
  !*** ./node_modules/datatables.net-buttons/js/buttons.print.js ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * Print button for Buttons and DataTables.
 * © SpryMedia Ltd - datatables.net/license
 */

(function( factory ){
	if ( true ) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs"), __webpack_require__(/*! datatables.net-buttons */ "./node_modules/datatables.net-buttons/js/dataTables.buttons.mjs")], __WEBPACK_AMD_DEFINE_RESULT__ = (function ( $ ) {
			return factory( $, window, document );
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	}
	else { var cjsRequires, jq; }
}(function( $, window, document ) {
'use strict';
var DataTable = $.fn.dataTable;



var _link = document.createElement('a');

/**
 * Clone link and style tags, taking into account the need to change the source
 * path.
 *
 * @param  {node}     el Element to convert
 */
var _styleToAbs = function (el) {
	var clone = $(el).clone()[0];

	if (clone.nodeName.toLowerCase() === 'link') {
		clone.href = _relToAbs(clone.href);
	}

	return clone.outerHTML;
};

/**
 * Convert a URL from a relative to an absolute address so it will work
 * correctly in the popup window which has no base URL.
 *
 * @param  {string} href URL
 */
var _relToAbs = function (href) {
	// Assign to a link on the original page so the browser will do all the
	// hard work of figuring out where the file actually is
	_link.href = href;
	var linkHost = _link.host;

	// IE doesn't have a trailing slash on the host
	// Chrome has it on the pathname
	if (linkHost.indexOf('/') === -1 && _link.pathname.indexOf('/') !== 0) {
		linkHost += '/';
	}

	return _link.protocol + '//' + linkHost + _link.pathname + _link.search;
};

DataTable.ext.buttons.print = {
	className: 'buttons-print',

	text: function (dt) {
		return dt.i18n('buttons.print', 'Print');
	},

	action: function (e, dt, button, config, cb) {
		var data = dt.buttons.exportData(
			$.extend({ decodeEntities: false }, config.exportOptions) // XSS protection
		);
		var exportInfo = dt.buttons.exportInfo(config);

		// Get the classes for the columns from the header cells
		var columnClasses = dt
			.columns(config.exportOptions.columns)
			.nodes()
			.map(function (n) {
				return n.className;
			})
			.toArray();

		var addRow = function (d, tag) {
			var str = '<tr>';

			for (var i = 0, ien = d.length; i < ien; i++) {
				// null and undefined aren't useful in the print output
				var dataOut = d[i] === null || d[i] === undefined ? '' : d[i];
				var classAttr = columnClasses[i]
					? 'class="' + columnClasses[i] + '"'
					: '';

				str +=
					'<' +
					tag +
					' ' +
					classAttr +
					'>' +
					dataOut +
					'</' +
					tag +
					'>';
			}

			return str + '</tr>';
		};

		// Construct a table for printing
		var html = '<table class="' + dt.table().node().className + '">';

		if (config.header) {
			var headerRows = data.headerStructure.map(function (row) {
				return (
					'<tr>' +
					row
						.map(function (cell) {
							return cell
								? '<th colspan="' +
										cell.colspan +
										'" rowspan="' +
										cell.rowspan +
										'">' +
										cell.title +
										'</th>'
								: '';
						})
						.join('') +
					'</tr>'
				);
			});

			html += '<thead>' + headerRows.join('') + '</thead>';
		}

		html += '<tbody>';
		for (var i = 0, ien = data.body.length; i < ien; i++) {
			html += addRow(data.body[i], 'td');
		}
		html += '</tbody>';

		if (config.footer && data.footer) {
			var footerRows = data.footerStructure.map(function (row) {
				return (
					'<tr>' +
					row
						.map(function (cell) {
							return cell
								? '<th colspan="' +
										cell.colspan +
										'" rowspan="' +
										cell.rowspan +
										'">' +
										cell.title +
										'</th>'
								: '';
						})
						.join('') +
					'</tr>'
				);
			});

			html += '<tfoot>' + footerRows.join('') + '</tfoot>';
		}
		html += '</table>';

		// Open a new window for the printable table
		var win = window.open('', '');

		if (!win) {
			dt.buttons.info(
				dt.i18n('buttons.printErrorTitle', 'Unable to open print view'),
				dt.i18n(
					'buttons.printErrorMsg',
					'Please allow popups in your browser for this site to be able to view the print view.'
				),
				5000
			);

			return;
		}

		win.document.close();

		// Inject the title and also a copy of the style and link tags from this
		// document so the table can retain its base styling. Note that we have
		// to use string manipulation as IE won't allow elements to be created
		// in the host document and then appended to the new window.
		var head = '<title>' + exportInfo.title + '</title>';
		$('style, link').each(function () {
			head += _styleToAbs(this);
		});

		try {
			win.document.head.innerHTML = head; // Work around for Edge
		} catch (e) {
			$(win.document.head).html(head); // Old IE
		}

		// Inject the table and other surrounding information
		win.document.body.innerHTML =
			'<h1>' +
			exportInfo.title +
			'</h1>' +
			'<div>' +
			(exportInfo.messageTop || '') +
			'</div>' +
			html +
			'<div>' +
			(exportInfo.messageBottom || '') +
			'</div>';

		$(win.document.body).addClass('dt-print-view');

		$('img', win.document.body).each(function (i, img) {
			img.setAttribute('src', _relToAbs(img.getAttribute('src')));
		});

		if (config.customize) {
			config.customize(win, config, dt);
		}

		// Allow stylesheets time to load
		var autoPrint = function () {
			if (config.autoPrint) {
				win.print(); // blocking - so close will not
				win.close(); // execute until this is done
			}
		};

		win.setTimeout(autoPrint, 1000);

		cb();
	},

	async: 100,

	title: '*',

	messageTop: '*',

	messageBottom: '*',

	exportOptions: {},

	header: true,

	footer: true,

	autoPrint: true,

	customize: null
};


return DataTable;
}));


/***/ }),

/***/ "./node_modules/datatables.net-select/js/dataTables.select.mjs":
/*!*********************************************************************!*\
  !*** ./node_modules/datatables.net-select/js/dataTables.select.mjs ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var datatables_net__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! datatables.net */ "./node_modules/datatables.net/js/dataTables.mjs");
/*! Select for DataTables 2.0.0
 * © SpryMedia Ltd - datatables.net/license/mit
 */




// Allow reassignment of the $ variable
let $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


// Version information for debugger
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select = {};

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select.version = '2.0.0';

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select.init = function (dt) {
	var ctx = dt.settings()[0];

	if (!datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].versionCheck('2')) {
		throw 'Warning: Select requires DataTables 2 or newer';
	}

	if (ctx._select) {
		return;
	}

	var savedSelected = dt.state.loaded();

	var selectAndSave = function (e, settings, data) {
		if (data === null || data.select === undefined) {
			return;
		}

		// Clear any currently selected rows, before restoring state
		// None will be selected on first initialisation
		if (dt.rows({ selected: true }).any()) {
			dt.rows().deselect();
		}
		if (data.select.rows !== undefined) {
			dt.rows(data.select.rows).select();
		}

		if (dt.columns({ selected: true }).any()) {
			dt.columns().deselect();
		}
		if (data.select.columns !== undefined) {
			dt.columns(data.select.columns).select();
		}

		if (dt.cells({ selected: true }).any()) {
			dt.cells().deselect();
		}
		if (data.select.cells !== undefined) {
			for (var i = 0; i < data.select.cells.length; i++) {
				dt.cell(data.select.cells[i].row, data.select.cells[i].column).select();
			}
		}

		dt.state.save();
	};

	dt.on('stateSaveParams', function (e, settings, data) {
		data.select = {};
		data.select.rows = dt.rows({ selected: true }).ids(true).toArray();
		data.select.columns = dt.columns({ selected: true })[0];
		data.select.cells = dt.cells({ selected: true })[0].map(function (coords) {
			return { row: dt.row(coords.row).id(true), column: coords.column };
		});
	})
		.on('stateLoadParams', selectAndSave)
		.one('init', function () {
			selectAndSave(undefined, undefined, savedSelected);
		});

	var init = ctx.oInit.select;
	var defaults = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.select;
	var opts = init === undefined ? defaults : init;

	// Set defaults
	var items = 'row';
	var style = 'api';
	var blurable = false;
	var toggleable = true;
	var info = true;
	var selector = 'td, th';
	var className = 'selected';
	var headerCheckbox = true;
	var setStyle = false;

	ctx._select = {
		infoEls: []
	};

	// Initialisation customisations
	if (opts === true) {
		style = 'os';
		setStyle = true;
	}
	else if (typeof opts === 'string') {
		style = opts;
		setStyle = true;
	}
	else if ($.isPlainObject(opts)) {
		if (opts.blurable !== undefined) {
			blurable = opts.blurable;
		}

		if (opts.toggleable !== undefined) {
			toggleable = opts.toggleable;
		}

		if (opts.info !== undefined) {
			info = opts.info;
		}

		if (opts.items !== undefined) {
			items = opts.items;
		}

		if (opts.style !== undefined) {
			style = opts.style;
			setStyle = true;
		}
		else {
			style = 'os';
			setStyle = true;
		}

		if (opts.selector !== undefined) {
			selector = opts.selector;
		}

		if (opts.className !== undefined) {
			className = opts.className;
		}

		if (opts.headerCheckbox !== undefined) {
			headerCheckbox = opts.headerCheckbox;
		}
	}

	dt.select.selector(selector);
	dt.select.items(items);
	dt.select.style(style);
	dt.select.blurable(blurable);
	dt.select.toggleable(toggleable);
	dt.select.info(info);
	ctx._select.className = className;

	// If the init options haven't enabled select, but there is a selectable
	// class name, then enable
	if (!setStyle && $(dt.table().node()).hasClass('selectable')) {
		dt.select.style('os');
	}

	// Insert a checkbox into the header if needed - might need to wait
	// for init complete, or it might already be done
	if (headerCheckbox) {
		initCheckboxHeader(dt);

		dt.on('init', function () {
			initCheckboxHeader(dt);
		});
	}
};

/*

Select is a collection of API methods, event handlers, event emitters and
buttons (for the `Buttons` extension) for DataTables. It provides the following
features, with an overview of how they are implemented:

## Selection of rows, columns and cells. Whether an item is selected or not is
   stored in:

* rows: a `_select_selected` property which contains a boolean value of the
  DataTables' `aoData` object for each row
* columns: a `_select_selected` property which contains a boolean value of the
  DataTables' `aoColumns` object for each column
* cells: a `_selected_cells` property which contains an array of boolean values
  of the `aoData` object for each row. The array is the same length as the
  columns array, with each element of it representing a cell.

This method of using boolean flags allows Select to operate when nodes have not
been created for rows / cells (DataTables' defer rendering feature).

## API methods

A range of API methods are available for triggering selection and de-selection
of rows. Methods are also available to configure the selection events that can
be triggered by an end user (such as which items are to be selected). To a large
extent, these of API methods *is* Select. It is basically a collection of helper
functions that can be used to select items in a DataTable.

Configuration of select is held in the object `_select` which is attached to the
DataTables settings object on initialisation. Select being available on a table
is not optional when Select is loaded, but its default is for selection only to
be available via the API - so the end user wouldn't be able to select rows
without additional configuration.

The `_select` object contains the following properties:

```
{
	items:string       - Can be `rows`, `columns` or `cells`. Defines what item 
	                     will be selected if the user is allowed to activate row
	                     selection using the mouse.
	style:string       - Can be `none`, `single`, `multi` or `os`. Defines the
	                     interaction style when selecting items
	blurable:boolean   - If row selection can be cleared by clicking outside of
	                     the table
	toggleable:boolean - If row selection can be cancelled by repeated clicking
	                     on the row
	info:boolean       - If the selection summary should be shown in the table
	                     information elements
	infoEls:element[]  - List of HTML elements with info elements for a table
}
```

In addition to the API methods, Select also extends the DataTables selector
options for rows, columns and cells adding a `selected` option to the selector
options object, allowing the developer to select only selected items or
unselected items.

## Mouse selection of items

Clicking on items can be used to select items. This is done by a simple event
handler that will select the items using the API methods.

 */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Local functions
 */

/**
 * Add one or more cells to the selection when shift clicking in OS selection
 * style cell selection.
 *
 * Cell range is more complicated than row and column as we want to select
 * in the visible grid rather than by index in sequence. For example, if you
 * click first in cell 1-1 and then shift click in 2-2 - cells 1-2 and 2-1
 * should also be selected (and not 1-3, 1-4. etc)
 *
 * @param  {DataTable.Api} dt   DataTable
 * @param  {object}        idx  Cell index to select to
 * @param  {object}        last Cell index to select from
 * @private
 */
function cellRange(dt, idx, last) {
	var indexes;
	var columnIndexes;
	var rowIndexes;
	var selectColumns = function (start, end) {
		if (start > end) {
			var tmp = end;
			end = start;
			start = tmp;
		}

		var record = false;
		return dt
			.columns(':visible')
			.indexes()
			.filter(function (i) {
				if (i === start) {
					record = true;
				}

				if (i === end) {
					// not else if, as start might === end
					record = false;
					return true;
				}

				return record;
			});
	};

	var selectRows = function (start, end) {
		var indexes = dt.rows({ search: 'applied' }).indexes();

		// Which comes first - might need to swap
		if (indexes.indexOf(start) > indexes.indexOf(end)) {
			var tmp = end;
			end = start;
			start = tmp;
		}

		var record = false;
		return indexes.filter(function (i) {
			if (i === start) {
				record = true;
			}

			if (i === end) {
				record = false;
				return true;
			}

			return record;
		});
	};

	if (!dt.cells({ selected: true }).any() && !last) {
		// select from the top left cell to this one
		columnIndexes = selectColumns(0, idx.column);
		rowIndexes = selectRows(0, idx.row);
	}
	else {
		// Get column indexes between old and new
		columnIndexes = selectColumns(last.column, idx.column);
		rowIndexes = selectRows(last.row, idx.row);
	}

	indexes = dt.cells(rowIndexes, columnIndexes).flatten();

	if (!dt.cells(idx, { selected: true }).any()) {
		// Select range
		dt.cells(indexes).select();
	}
	else {
		// Deselect range
		dt.cells(indexes).deselect();
	}
}

/**
 * Disable mouse selection by removing the selectors
 *
 * @param {DataTable.Api} dt DataTable to remove events from
 * @private
 */
function disableMouseSelection(dt) {
	var ctx = dt.settings()[0];
	var selector = ctx._select.selector;

	$(dt.table().container())
		.off('mousedown.dtSelect', selector)
		.off('mouseup.dtSelect', selector)
		.off('click.dtSelect', selector);

	$('body').off('click.dtSelect' + _safeId(dt.table().node()));
}

/**
 * Attach mouse listeners to the table to allow mouse selection of items
 *
 * @param {DataTable.Api} dt DataTable to remove events from
 * @private
 */
function enableMouseSelection(dt) {
	var container = $(dt.table().container());
	var ctx = dt.settings()[0];
	var selector = ctx._select.selector;
	var matchSelection;

	container
		.on('mousedown.dtSelect', selector, function (e) {
			// Disallow text selection for shift clicking on the table so multi
			// element selection doesn't look terrible!
			if (e.shiftKey || e.metaKey || e.ctrlKey) {
				container
					.css('-moz-user-select', 'none')
					.one('selectstart.dtSelect', selector, function () {
						return false;
					});
			}

			if (window.getSelection) {
				matchSelection = window.getSelection();
			}
		})
		.on('mouseup.dtSelect', selector, function () {
			// Allow text selection to occur again, Mozilla style (tested in FF
			// 35.0.1 - still required)
			container.css('-moz-user-select', '');
		})
		.on('click.dtSelect', selector, function (e) {
			var items = dt.select.items();
			var idx;

			// If text was selected (click and drag), then we shouldn't change
			// the row's selected state
			if (matchSelection) {
				var selection = window.getSelection();

				// If the element that contains the selection is not in the table, we can ignore it
				// This can happen if the developer selects text from the click event
				if (
					!selection.anchorNode ||
					$(selection.anchorNode).closest('table')[0] === dt.table().node()
				) {
					if (selection !== matchSelection) {
						return;
					}
				}
			}

			var ctx = dt.settings()[0];
			var container = dt.table().container();

			// Ignore clicks inside a sub-table
			if ($(e.target).closest('div.dt-container')[0] != container) {
				return;
			}

			var cell = dt.cell($(e.target).closest('td, th'));

			// Check the cell actually belongs to the host DataTable (so child
			// rows, etc, are ignored)
			if (!cell.any()) {
				return;
			}

			var event = $.Event('user-select.dt');
			eventTrigger(dt, event, [items, cell, e]);

			if (event.isDefaultPrevented()) {
				return;
			}

			var cellIndex = cell.index();
			if (items === 'row') {
				idx = cellIndex.row;
				typeSelect(e, dt, ctx, 'row', idx);
			}
			else if (items === 'column') {
				idx = cell.index().column;
				typeSelect(e, dt, ctx, 'column', idx);
			}
			else if (items === 'cell') {
				idx = cell.index();
				typeSelect(e, dt, ctx, 'cell', idx);
			}

			ctx._select_lastCell = cellIndex;
		});

	// Blurable
	$('body').on('click.dtSelect' + _safeId(dt.table().node()), function (e) {
		if (ctx._select.blurable) {
			// If the click was inside the DataTables container, don't blur
			if ($(e.target).parents().filter(dt.table().container()).length) {
				return;
			}

			// Ignore elements which have been removed from the DOM (i.e. paging
			// buttons)
			if ($(e.target).parents('html').length === 0) {
				return;
			}

			// Don't blur in Editor form
			if ($(e.target).parents('div.DTE').length) {
				return;
			}

			var event = $.Event('select-blur.dt');
			eventTrigger(dt, event, [e.target, e]);

			if (event.isDefaultPrevented()) {
				return;
			}

			clear(ctx, true);
		}
	});
}

/**
 * Trigger an event on a DataTable
 *
 * @param {DataTable.Api} api      DataTable to trigger events on
 * @param  {boolean}      selected true if selected, false if deselected
 * @param  {string}       type     Item type acting on
 * @param  {boolean}      any      Require that there are values before
 *     triggering
 * @private
 */
function eventTrigger(api, type, args, any) {
	if (any && !api.flatten().length) {
		return;
	}

	if (typeof type === 'string') {
		type = type + '.dt';
	}

	args.unshift(api);

	$(api.table().node()).trigger(type, args);
}

/**
 * Update the information element of the DataTable showing information about the
 * items selected. This is done by adding tags to the existing text
 *
 * @param {DataTable.Api} api DataTable to update
 * @private
 */
function info(api, node) {
	if (api.select.style() === 'api' || api.select.info() === false) {
		return;
	}

	var rows = api.rows({ selected: true }).flatten().length;
	var columns = api.columns({ selected: true }).flatten().length;
	var cells = api.cells({ selected: true }).flatten().length;

	var add = function (el, name, num) {
		el.append(
			$('<span class="select-item"/>').append(
				api.i18n(
					'select.' + name + 's',
					{ _: '%d ' + name + 's selected', 0: '', 1: '1 ' + name + ' selected' },
					num
				)
			)
		);
	};

	var el = $(node);
	var output = $('<span class="select-info"/>');

	add(output, 'row', rows);
	add(output, 'column', columns);
	add(output, 'cell', cells);

	var existing = el.children('span.select-info');

	if (existing.length) {
		existing.remove();
	}

	if (output.text() !== '') {
		el.append(output);
	}
}

/**
 * Add a checkbox to the header for checkbox columns, allowing all rows to
 * be selected, deselected or just to show the state.
 *
 * @param {*} dt API
 */
function initCheckboxHeader( dt ) {
	// Find any checkbox column(s)
	dt.columns('.dt-select').every(function () {
		var header = this.header();

		if (! $('input', header).length) {
			// If no checkbox yet, insert one
			var input = $('<input>')
				.attr({
					class: 'dt-select-checkbox',
					type: 'checkbox',
					'aria-label': dt.i18n('select.aria.headerCheckbox') || 'Select all rows'
				})
				.appendTo(header)
				.on('change', function () {
					if (this.checked) {
						dt.rows({search: 'applied'}).select();
					}
					else {
						dt.rows({selected: true}).deselect();
					}
				})
				.on('click', function (e) {
					e.stopPropagation();
				});
	
			// Update the header checkbox's state when the selection in the
			// table changes
			dt.on('draw select deselect', function (e, pass, type) {
				if (type === 'row' || ! type) {
					var count = dt.rows({selected: true}).count();
					var search = dt.rows({search: 'applied', selected: true}).count();
					var available = dt.rows({search: 'applied'}).count();

					if (search && search <= count && search === available) {
						input
							.prop('checked', true)
							.prop('indeterminate', false);
					}
					else if (search === 0 && count === 0) {
						input
							.prop('checked', false)
							.prop('indeterminate', false);
					}
					else {
						input
							.prop('checked', false)
							.prop('indeterminate', true);
					}
				}
			});
		}
	});
}

/**
 * Initialisation of a new table. Attach event handlers and callbacks to allow
 * Select to operate correctly.
 *
 * This will occur _after_ the initial DataTables initialisation, although
 * before Ajax data is rendered, if there is ajax data
 *
 * @param  {DataTable.settings} ctx Settings object to operate on
 * @private
 */
function init(ctx) {
	var api = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx);
	ctx._select_init = true;

	// Row callback so that classes can be added to rows and cells if the item
	// was selected before the element was created. This will happen with the
	// `deferRender` option enabled.
	//
	// This method of attaching to `aoRowCreatedCallback` is a hack until
	// DataTables has proper events for row manipulation If you are reviewing
	// this code to create your own plug-ins, please do not do this!
	ctx.aoRowCreatedCallback.push(function (row, data, index) {
			var i, ien;
			var d = ctx.aoData[index];

			// Row
			if (d._select_selected) {
				$(row).addClass(ctx._select.className);
			}

			// Cells and columns - if separated out, we would need to do two
			// loops, so it makes sense to combine them into a single one
			for (i = 0, ien = ctx.aoColumns.length; i < ien; i++) {
				if (
					ctx.aoColumns[i]._select_selected ||
					(d._selected_cells && d._selected_cells[i])
				) {
					$(d.anCells[i]).addClass(ctx._select.className);
				}
			}
		}
	);

	// On Ajax reload we want to reselect all rows which are currently selected,
	// if there is an rowId (i.e. a unique value to identify each row with)
	api.on('preXhr.dt.dtSelect', function (e, settings) {
		if (settings !== api.settings()[0]) {
			// Not triggered by our DataTable!
			return;
		}

		// note that column selection doesn't need to be cached and then
		// reselected, as they are already selected
		var rows = api
			.rows({ selected: true })
			.ids(true)
			.filter(function (d) {
				return d !== undefined;
			});

		var cells = api
			.cells({ selected: true })
			.eq(0)
			.map(function (cellIdx) {
				var id = api.row(cellIdx.row).id(true);
				return id ? { row: id, column: cellIdx.column } : undefined;
			})
			.filter(function (d) {
				return d !== undefined;
			});

		// On the next draw, reselect the currently selected items
		api.one('draw.dt.dtSelect', function () {
			api.rows(rows).select();

			// `cells` is not a cell index selector, so it needs a loop
			if (cells.any()) {
				cells.each(function (id) {
					api.cells(id.row, id.column).select();
				});
			}
		});
	});

	// Update the table information element with selected item summary
	api.on('info.dt', function (e, ctx, node) {
		// Store the info node for updating on select / deselect
		if (!ctx._select.infoEls.includes(node)) {
			ctx._select.infoEls.push(node);
		}

		info(api, node);
	});

	api.on('select.dtSelect.dt deselect.dtSelect.dt', function () {
		ctx._select.infoEls.forEach(function (el) {
			info(api, el);
		});

		api.state.save();
	});

	// Clean up and release
	api.on('destroy.dtSelect', function () {
		// Remove class directly rather than calling deselect - which would trigger events
		$(api.rows({ selected: true }).nodes()).removeClass(api.settings()[0]._select.className);

		disableMouseSelection(api);
		api.off('.dtSelect');
		$('body').off('.dtSelect' + _safeId(api.table().node()));
	});
}

/**
 * Add one or more items (rows or columns) to the selection when shift clicking
 * in OS selection style
 *
 * @param  {DataTable.Api} dt   DataTable
 * @param  {string}        type Row or column range selector
 * @param  {object}        idx  Item index to select to
 * @param  {object}        last Item index to select from
 * @private
 */
function rowColumnRange(dt, type, idx, last) {
	// Add a range of rows from the last selected row to this one
	var indexes = dt[type + 's']({ search: 'applied' }).indexes();
	var idx1 = indexes.indexOf(last);
	var idx2 = indexes.indexOf(idx);

	if (!dt[type + 's']({ selected: true }).any() && idx1 === -1) {
		// select from top to here - slightly odd, but both Windows and Mac OS
		// do this
		indexes.splice(indexes.indexOf(idx) + 1, indexes.length);
	}
	else {
		// reverse so we can shift click 'up' as well as down
		if (idx1 > idx2) {
			var tmp = idx2;
			idx2 = idx1;
			idx1 = tmp;
		}

		indexes.splice(idx2 + 1, indexes.length);
		indexes.splice(0, idx1);
	}

	if (!dt[type](idx, { selected: true }).any()) {
		// Select range
		dt[type + 's'](indexes).select();
	}
	else {
		// Deselect range - need to keep the clicked on row selected
		indexes.splice(indexes.indexOf(idx), 1);
		dt[type + 's'](indexes).deselect();
	}
}

/**
 * Clear all selected items
 *
 * @param  {DataTable.settings} ctx Settings object of the host DataTable
 * @param  {boolean} [force=false] Force the de-selection to happen, regardless
 *     of selection style
 * @private
 */
function clear(ctx, force) {
	if (force || ctx._select.style === 'single') {
		var api = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx);

		api.rows({ selected: true }).deselect();
		api.columns({ selected: true }).deselect();
		api.cells({ selected: true }).deselect();
	}
}

/**
 * Select items based on the current configuration for style and items.
 *
 * @param  {object}             e    Mouse event object
 * @param  {DataTables.Api}     dt   DataTable
 * @param  {DataTable.settings} ctx  Settings object of the host DataTable
 * @param  {string}             type Items to select
 * @param  {int|object}         idx  Index of the item to select
 * @private
 */
function typeSelect(e, dt, ctx, type, idx) {
	var style = dt.select.style();
	var toggleable = dt.select.toggleable();
	var isSelected = dt[type](idx, { selected: true }).any();

	if (isSelected && !toggleable) {
		return;
	}

	if (style === 'os') {
		if (e.ctrlKey || e.metaKey) {
			// Add or remove from the selection
			dt[type](idx).select(!isSelected);
		}
		else if (e.shiftKey) {
			if (type === 'cell') {
				cellRange(dt, idx, ctx._select_lastCell || null);
			}
			else {
				rowColumnRange(
					dt,
					type,
					idx,
					ctx._select_lastCell ? ctx._select_lastCell[type] : null
				);
			}
		}
		else {
			// No cmd or shift click - deselect if selected, or select
			// this row only
			var selected = dt[type + 's']({ selected: true });

			if (isSelected && selected.flatten().length === 1) {
				dt[type](idx).deselect();
			}
			else {
				selected.deselect();
				dt[type](idx).select();
			}
		}
	}
	else if (style == 'multi+shift') {
		if (e.shiftKey) {
			if (type === 'cell') {
				cellRange(dt, idx, ctx._select_lastCell || null);
			}
			else {
				rowColumnRange(
					dt,
					type,
					idx,
					ctx._select_lastCell ? ctx._select_lastCell[type] : null
				);
			}
		}
		else {
			dt[type](idx).select(!isSelected);
		}
	}
	else {
		dt[type](idx).select(!isSelected);
	}
}

function _safeId(node) {
	return node.id.replace(/[^a-zA-Z0-9\-\_]/g, '-');
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables selectors
 */

// row and column are basically identical just assigned to different properties
// and checking a different array, so we can dynamically create the functions to
// reduce the code size
$.each(
	[
		{ type: 'row', prop: 'aoData' },
		{ type: 'column', prop: 'aoColumns' }
	],
	function (i, o) {
		datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.selector[o.type].push(function (settings, opts, indexes) {
			var selected = opts.selected;
			var data;
			var out = [];

			if (selected !== true && selected !== false) {
				return indexes;
			}

			for (var i = 0, ien = indexes.length; i < ien; i++) {
				data = settings[o.prop][indexes[i]];

				if (
					data && (
						(selected === true && data._select_selected === true) ||
						(selected === false && !data._select_selected)
					)
				) {
					out.push(indexes[i]);
				}
			}

			return out;
		});
	}
);

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.selector.cell.push(function (settings, opts, cells) {
	var selected = opts.selected;
	var rowData;
	var out = [];

	if (selected === undefined) {
		return cells;
	}

	for (var i = 0, ien = cells.length; i < ien; i++) {
		rowData = settings.aoData[cells[i].row];

		if (
			rowData && (
				(selected === true &&
					rowData._selected_cells &&
					rowData._selected_cells[cells[i].column] === true) ||
				(selected === false &&
					(!rowData._selected_cells || !rowData._selected_cells[cells[i].column]))
			)
		) {
			out.push(cells[i]);
		}
	}

	return out;
});

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * DataTables API
 *
 * For complete documentation, please refer to the docs/api directory or the
 * DataTables site
 */

// Local variables to improve compression
var apiRegister = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.register;
var apiRegisterPlural = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api.registerPlural;

apiRegister('select()', function () {
	return this.iterator('table', function (ctx) {
		datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select.init(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx));
	});
});

apiRegister('select.blurable()', function (flag) {
	if (flag === undefined) {
		return this.context[0]._select.blurable;
	}

	return this.iterator('table', function (ctx) {
		ctx._select.blurable = flag;
	});
});

apiRegister('select.toggleable()', function (flag) {
	if (flag === undefined) {
		return this.context[0]._select.toggleable;
	}

	return this.iterator('table', function (ctx) {
		ctx._select.toggleable = flag;
	});
});

apiRegister('select.info()', function (flag) {
	if (flag === undefined) {
		return this.context[0]._select.info;
	}

	return this.iterator('table', function (ctx) {
		ctx._select.info = flag;
	});
});

apiRegister('select.items()', function (items) {
	if (items === undefined) {
		return this.context[0]._select.items;
	}

	return this.iterator('table', function (ctx) {
		ctx._select.items = items;

		eventTrigger(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx), 'selectItems', [items]);
	});
});

// Takes effect from the _next_ selection. None disables future selection, but
// does not clear the current selection. Use the `deselect` methods for that
apiRegister('select.style()', function (style) {
	if (style === undefined) {
		return this.context[0]._select.style;
	}

	return this.iterator('table', function (ctx) {
		if (!ctx._select) {
			datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select.init(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx));
		}

		if (!ctx._select_init) {
			init(ctx);
		}

		ctx._select.style = style;

		// Add / remove mouse event handlers. They aren't required when only
		// API selection is available
		var dt = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx);
		disableMouseSelection(dt);

		if (style !== 'api') {
			enableMouseSelection(dt);
		}

		eventTrigger(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx), 'selectStyle', [style]);
	});
});

apiRegister('select.selector()', function (selector) {
	if (selector === undefined) {
		return this.context[0]._select.selector;
	}

	return this.iterator('table', function (ctx) {
		disableMouseSelection(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx));

		ctx._select.selector = selector;

		if (ctx._select.style !== 'api') {
			enableMouseSelection(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx));
		}
	});
});

apiRegister('select.last()', function (set) {
	let ctx = this.context[0];

	if (set) {
		ctx._select_lastCell = set;
		return this;
	}

	return ctx._select_lastCell;
});

apiRegisterPlural('rows().select()', 'row().select()', function (select) {
	var api = this;

	if (select === false) {
		return this.deselect();
	}

	this.iterator('row', function (ctx, idx) {
		clear(ctx);

		// There is a good amount of knowledge of DataTables internals in
		// this function. It _could_ be done without that, but it would hurt
		// performance (or DT would need new APIs for this work)
		var dtData = ctx.aoData[idx];
		var dtColumns = ctx.aoColumns;

		$(dtData.nTr).addClass(ctx._select.className);
		dtData._select_selected = true;

		for (var i=0 ; i<dtColumns.length ; i++) {
			var col = dtColumns[i];

			if (col.sType === 'select-checkbox') {
				// Make sure the checkbox shows the right state
				$('input.dt-select-checkbox', dtData.anCells[i]).prop('checked', true);

				// Invalidate the sort data for this column
				dtData._aSortData[i] = null;
			}
		}
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'select', ['row', api[i]], true);
	});

	return this;
});

apiRegister('row().selected()', function () {
	var ctx = this.context[0];

	if (ctx && this.length && ctx.aoData[this[0]] && ctx.aoData[this[0]]._select_selected) {
		return true;
	}

	return false;
});

apiRegisterPlural('columns().select()', 'column().select()', function (select) {
	var api = this;

	if (select === false) {
		return this.deselect();
	}

	this.iterator('column', function (ctx, idx) {
		clear(ctx);

		ctx.aoColumns[idx]._select_selected = true;

		var column = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx).column(idx);

		$(column.header()).addClass(ctx._select.className);
		$(column.footer()).addClass(ctx._select.className);

		column.nodes().to$().addClass(ctx._select.className);
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'select', ['column', api[i]], true);
	});

	return this;
});

apiRegister('column().selected()', function () {
	var ctx = this.context[0];

	if (ctx && this.length && ctx.aoColumns[this[0]] && ctx.aoColumns[this[0]]._select_selected) {
		return true;
	}

	return false;
});

apiRegisterPlural('cells().select()', 'cell().select()', function (select) {
	var api = this;

	if (select === false) {
		return this.deselect();
	}

	this.iterator('cell', function (ctx, rowIdx, colIdx) {
		clear(ctx);

		var data = ctx.aoData[rowIdx];

		if (data._selected_cells === undefined) {
			data._selected_cells = [];
		}

		data._selected_cells[colIdx] = true;

		if (data.anCells) {
			$(data.anCells[colIdx]).addClass(ctx._select.className);
		}
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'select', ['cell', api.cells(api[i]).indexes().toArray()], true);
	});

	return this;
});

apiRegister('cell().selected()', function () {
	var ctx = this.context[0];

	if (ctx && this.length) {
		var row = ctx.aoData[this[0][0].row];

		if (row && row._selected_cells && row._selected_cells[this[0][0].column]) {
			return true;
		}
	}

	return false;
});

apiRegisterPlural('rows().deselect()', 'row().deselect()', function () {
	var api = this;

	this.iterator('row', function (ctx, idx) {
		// Like the select action, this has a lot of knowledge about DT internally
		var dtData = ctx.aoData[idx];
		var dtColumns = ctx.aoColumns;

		$(dtData.nTr).removeClass(ctx._select.className);
		dtData._select_selected = false;
		ctx._select_lastCell = null;

		for (var i=0 ; i<dtColumns.length ; i++) {
			var col = dtColumns[i];

			if (col.sType === 'select-checkbox') {
				// Make sure the checkbox shows the right state
				$('input.dt-select-checkbox', dtData.anCells[i]).prop('checked', false);

				// Invalidate the sort data for this column
				dtData._aSortData[i] = null;
			}
		}
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'deselect', ['row', api[i]], true);
	});

	return this;
});

apiRegisterPlural('columns().deselect()', 'column().deselect()', function () {
	var api = this;

	this.iterator('column', function (ctx, idx) {
		ctx.aoColumns[idx]._select_selected = false;

		var api = new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx);
		var column = api.column(idx);

		$(column.header()).removeClass(ctx._select.className);
		$(column.footer()).removeClass(ctx._select.className);

		// Need to loop over each cell, rather than just using
		// `column().nodes()` as cells which are individually selected should
		// not have the `selected` class removed from them
		api.cells(null, idx)
			.indexes()
			.each(function (cellIdx) {
				var data = ctx.aoData[cellIdx.row];
				var cellSelected = data._selected_cells;

				if (data.anCells && (!cellSelected || !cellSelected[cellIdx.column])) {
					$(data.anCells[cellIdx.column]).removeClass(ctx._select.className);
				}
			});
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'deselect', ['column', api[i]], true);
	});

	return this;
});

apiRegisterPlural('cells().deselect()', 'cell().deselect()', function () {
	var api = this;

	this.iterator('cell', function (ctx, rowIdx, colIdx) {
		var data = ctx.aoData[rowIdx];

		if (data._selected_cells !== undefined) {
			data._selected_cells[colIdx] = false;
		}

		// Remove class only if the cells exist, and the cell is not column
		// selected, in which case the class should remain (since it is selected
		// in the column)
		if (data.anCells && !ctx.aoColumns[colIdx]._select_selected) {
			$(data.anCells[colIdx]).removeClass(ctx._select.className);
		}
	});

	this.iterator('table', function (ctx, i) {
		eventTrigger(api, 'deselect', ['cell', api[i]], true);
	});

	return this;
});

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Buttons
 */
function i18n(label, def) {
	return function (dt) {
		return dt.i18n('buttons.' + label, def);
	};
}

// Common events with suitable namespaces
function namespacedEvents(config) {
	var unique = config._eventNamespace;

	return 'draw.dt.DT' + unique + ' select.dt.DT' + unique + ' deselect.dt.DT' + unique;
}

function enabled(dt, config) {
	if (config.limitTo.indexOf('rows') !== -1 && dt.rows({ selected: true }).any()) {
		return true;
	}

	if (config.limitTo.indexOf('columns') !== -1 && dt.columns({ selected: true }).any()) {
		return true;
	}

	if (config.limitTo.indexOf('cells') !== -1 && dt.cells({ selected: true }).any()) {
		return true;
	}

	return false;
}

var _buttonNamespace = 0;

$.extend(datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons, {
	selected: {
		text: i18n('selected', 'Selected'),
		className: 'buttons-selected',
		limitTo: ['rows', 'columns', 'cells'],
		init: function (dt, node, config) {
			var that = this;
			config._eventNamespace = '.select' + _buttonNamespace++;

			// .DT namespace listeners are removed by DataTables automatically
			// on table destroy
			dt.on(namespacedEvents(config), function () {
				that.enable(enabled(dt, config));
			});

			this.disable();
		},
		destroy: function (dt, node, config) {
			dt.off(config._eventNamespace);
		}
	},
	selectedSingle: {
		text: i18n('selectedSingle', 'Selected single'),
		className: 'buttons-selected-single',
		init: function (dt, node, config) {
			var that = this;
			config._eventNamespace = '.select' + _buttonNamespace++;

			dt.on(namespacedEvents(config), function () {
				var count =
					dt.rows({ selected: true }).flatten().length +
					dt.columns({ selected: true }).flatten().length +
					dt.cells({ selected: true }).flatten().length;

				that.enable(count === 1);
			});

			this.disable();
		},
		destroy: function (dt, node, config) {
			dt.off(config._eventNamespace);
		}
	},
	selectAll: {
		text: i18n('selectAll', 'Select all'),
		className: 'buttons-select-all',
		action: function (e, dt, node, config) {
			var items = this.select.items();
			var mod = config.selectorModifier;
			
			if (mod) {
				if (typeof mod === 'function') {
					mod = mod.call(dt, e, dt, node, config);
				}

				this[items + 's'](mod).select();
			}
			else {
				this[items + 's']().select();
			}
		}
		// selectorModifier can be specified
	},
	selectNone: {
		text: i18n('selectNone', 'Deselect all'),
		className: 'buttons-select-none',
		action: function () {
			clear(this.settings()[0], true);
		},
		init: function (dt, node, config) {
			var that = this;
			config._eventNamespace = '.select' + _buttonNamespace++;

			dt.on(namespacedEvents(config), function () {
				var count =
					dt.rows({ selected: true }).flatten().length +
					dt.columns({ selected: true }).flatten().length +
					dt.cells({ selected: true }).flatten().length;

				that.enable(count > 0);
			});

			this.disable();
		},
		destroy: function (dt, node, config) {
			dt.off(config._eventNamespace);
		}
	},
	showSelected: {
		text: i18n('showSelected', 'Show only selected'),
		className: 'buttons-show-selected',
		action: function (e, dt) {
			if (dt.search.fixed('dt-select')) {
				// Remove existing function
				dt.search.fixed('dt-select', null);

				this.active(false);
			}
			else {
				// Use a fixed filtering function to match on selected rows
				// This needs to reference the internal aoData since that is
				// where Select stores its reference for the selected state
				var dataSrc = dt.settings()[0].aoData;

				dt.search.fixed('dt-select', function (text, data, idx) {
					// _select_selected is set by Select on the data object for the row
					return dataSrc[idx]._select_selected;
				});

				this.active(true);
			}

			dt.draw();
		}
	}
});

$.each(['Row', 'Column', 'Cell'], function (i, item) {
	var lc = item.toLowerCase();

	datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.buttons['select' + item + 's'] = {
		text: i18n('select' + item + 's', 'Select ' + lc + 's'),
		className: 'buttons-select-' + lc + 's',
		action: function () {
			this.select.items(lc);
		},
		init: function (dt) {
			var that = this;

			dt.on('selectItems.dt.DT', function (e, ctx, items) {
				that.active(items === lc);
			});
		}
	};
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].type('select-checkbox', {
	className: 'dt-select',
	detect: function (data) {
		// Rendering function will tell us if it is a checkbox type
		return data === 'select-checkbox' ? data : false;
	},
	order: {
		pre: function (d) {
			return d === 'X' ? -1 : 0;
		}
	}
});

$.extend(true, datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].defaults.oLanguage, {
	select: {
		aria: {
			rowCheckbox: 'Select row'
		}
	}
});

datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].render.select = function (valueProp, nameProp) {
	var valueFn = valueProp ? datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.get(valueProp) : null;
	var nameFn = nameProp ? datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].util.get(nameProp) : null;

	return function (data, type, row, meta) {
		var dtRow = meta.settings.aoData[meta.row];
		var selected = dtRow._select_selected;
		var ariaLabel = meta.settings.oLanguage.select.aria.rowCheckbox;

		if (type === 'display') {
			return $('<input>')
				.attr({
					'aria-label': ariaLabel,
					class: 'dt-select-checkbox',
					name: nameFn ? nameFn(row) : null,
					type: 'checkbox',
					value: valueFn ? valueFn(row) : null,
					checked: selected
				})[0];
		}
		else if (type === 'type') {
			return 'select-checkbox';
		}
		else if (type === 'filter') {
			return '';
		}

		return selected ? 'X' : '';
	}
}

// Legacy checkbox ordering
datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].ext.order['select-checkbox'] = function (settings, col) {
	return this.api()
		.column(col, { order: 'index' })
		.nodes()
		.map(function (td) {
			if (settings._select.items === 'row') {
				return $(td).parent().hasClass(settings._select.className);
			}
			else if (settings._select.items === 'cell') {
				return $(td).hasClass(settings._select.className);
			}
			return false;
		});
};

$.fn.DataTable.select = datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Initialisation
 */

// DataTables creation - check if select has been defined in the options. Note
// this required that the table be in the document! If it isn't then something
// needs to trigger this method unfortunately. The next major release of
// DataTables will rework the events and address this.
$(document).on('preInit.dt.dtSelect', function (e, ctx) {
	if (e.namespace !== 'dt') {
		return;
	}

	datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].select.init(new datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"].Api(ctx));
});


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (datatables_net__WEBPACK_IMPORTED_MODULE_1__["default"]);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVuZG9ycy1ub2RlX21vZHVsZXNfZGF0YXRhYmxlc19uZXQtYnV0dG9uc19qc19idXR0b25zX2NvbFZpc19qcy1ub2RlX21vZHVsZXNfZGF0YXRhYmxlc19uZXQtLTMzYmNmMC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsTUFBTSxJQUEwQztBQUNoRDtBQUNBLEVBQUUsaUNBQVEsQ0FBQyx5RUFBUSxFQUFFLDRGQUFnQixFQUFFLG9IQUF3QixDQUFDLG1DQUFFO0FBQ2xFO0FBQ0EsR0FBRztBQUFBLGtHQUFFO0FBQ0w7QUFDQSxNQUFNLHdCQXFDSjtBQUNGLENBQUM7QUFDRDtBQUNBOzs7O0FBSUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7O0FBRUg7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7O0FBRUE7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7O0FBRUE7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxJQUFJOztBQUVKO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGdDQUFnQzs7QUFFaEM7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSixHQUFHOztBQUVIO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLElBQUk7QUFDSjtBQUNBLEVBQUU7O0FBRUY7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxHQUFHOztBQUVIOztBQUVBO0FBQ0E7QUFDQSxDQUFDOzs7QUFHRDtBQUNBLENBQUM7Ozs7Ozs7Ozs7O0FDcFFEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsTUFBTSxJQUEwQztBQUNoRDtBQUNBLEVBQUUsaUNBQVEsQ0FBQyx5RUFBUSxFQUFFLDRGQUFnQixFQUFFLG9IQUF3QixDQUFDLG1DQUFFO0FBQ2xFO0FBQ0EsR0FBRztBQUFBLGtHQUFFO0FBQ0w7QUFDQSxNQUFNLEVBcUJKO0FBQ0YsQ0FBQztBQUNEO0FBQ0E7OztBQUdBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZO0FBQ1o7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDhCQUE4QjtBQUM5Qiw4QkFBOEI7QUFDOUIsc0NBQXNDLHdCQUF3QjtBQUM5RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLHFDQUFxQztBQUNyQztBQUNBO0FBQ0Esa0ZBQWtGO0FBQ2xGO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQSxvQkFBb0I7QUFDcEIsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQSxvQkFBb0I7QUFDcEIsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsOEJBQThCLGtDQUFrQztBQUNoRTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLDhCQUE4QixrQ0FBa0M7QUFDaEU7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJOztBQUVKO0FBQ0EsNERBQTRELFdBQVc7QUFDdkU7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMLElBQUk7QUFDSjtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7Ozs7QUFJQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsZUFBZTtBQUMxQixXQUFXLFFBQVE7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCLFdBQVcsU0FBUztBQUNwQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxTQUFTO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsU0FBUztBQUNwQjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLGVBQWU7QUFDMUIsV0FBVyxlQUFlO0FBQzFCO0FBQ0E7QUFDQTtBQUNBLGdDQUFnQyxPQUFPOztBQUV2QztBQUNBLG1DQUFtQyxRQUFRO0FBQzNDO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsU0FBUztBQUNwQixZQUFZLGVBQWU7QUFDM0I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsWUFBWSxlQUFlO0FBQzNCLFlBQVksZUFBZTtBQUMzQixZQUFZLHNCQUFzQjtBQUNsQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsZ0NBQWdDLFFBQVE7QUFDeEM7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLHVDQUF1QyxRQUFRO0FBQy9DO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7O0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJOztBQUVKOztBQUVBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0EsRUFBRTs7QUFFRjs7QUFFQTs7QUFFQSxrQkFBa0I7O0FBRWxCOztBQUVBOztBQUVBOztBQUVBOztBQUVBO0FBQ0E7OztBQUdBO0FBQ0E7QUFDQSxZQUFZLEtBQUs7QUFDakIsWUFBWSxRQUFRO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsWUFBWSxRQUFRO0FBQ3BCLFlBQVksUUFBUTtBQUNwQixZQUFZLFFBQVE7QUFDcEI7QUFDQSxZQUFZLGlCQUFpQjtBQUM3QjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLFlBQVksUUFBUTtBQUNwQixZQUFZLFFBQVE7QUFDcEIsWUFBWSxhQUFhO0FBQ3pCO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSx1Q0FBdUMsUUFBUTtBQUMvQztBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLOztBQUVMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTs7QUFFQTs7O0FBR0E7QUFDQTtBQUNBLFlBQVksUUFBUTtBQUNwQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsNENBQTRDLE9BQU87QUFDbkQ7QUFDQTs7QUFFQTtBQUNBLG9CQUFvQixtQ0FBbUM7O0FBRXZEO0FBQ0E7QUFDQTs7QUFFQSxrQ0FBa0MsUUFBUTtBQUMxQztBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw4Q0FBOEMsT0FBTztBQUNyRDtBQUNBO0FBQ0EsOENBQThDO0FBQzlDLGlEQUFpRDtBQUNqRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxHQUFHLDZEQUE2RCxpQkFBaUI7QUFDakYsR0FBRyw2REFBNkQsaUJBQWlCO0FBQ2pGLEdBQUcseUNBQXlDO0FBQzVDLEdBQUcseUNBQXlDO0FBQzVDLEdBQUcseUNBQXlDO0FBQzVDLEdBQUcsNkRBQTZELHlDQUF5QztBQUN6RyxHQUFHLHNCQUFzQixFQUFFLHFDQUFxQyx5Q0FBeUM7QUFDekcsR0FBRyx5Q0FBeUM7QUFDNUMsR0FBRyxvQkFBb0IsRUFBRSxxQkFBcUI7QUFDOUM7Ozs7QUFJQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSCxFQUFFOzs7QUFHRjtBQUNBO0FBQ0E7O0FBRUE7QUFDQSw4Q0FBOEM7QUFDOUM7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0EsRUFBRTs7QUFFRjs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7QUFDQSw2Q0FBNkM7QUFDN0M7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBLEVBQUU7O0FBRUY7QUFDQSwrQ0FBK0M7QUFDL0M7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTs7QUFFQTtBQUNBO0FBQ0Esc0VBQXNFO0FBQ3RFOztBQUVBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxJQUFJO0FBQ0o7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlDQUF5QyxPQUFPLGdCQUFnQjs7QUFFaEUsbUNBQW1DLFFBQVE7QUFDM0M7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0EsK0NBQStDLFFBQVE7QUFDdkQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQSxrQ0FBa0MsWUFBWTtBQUM5QztBQUNBLFFBQVE7O0FBRVI7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBLGtDQUFrQyxlQUFlO0FBQ2pEO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsWUFBWTtBQUNaO0FBQ0EsVUFBVTtBQUNWO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxzQ0FBc0M7QUFDdEM7O0FBRUEsdUNBQXVDLE9BQU87QUFDOUM7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsMkNBQTJDO0FBQzNDOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSwwQ0FBMEMsUUFBUTtBQUNsRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7QUFDQSxFQUFFOzs7O0FBSUY7QUFDQSw2Q0FBNkM7QUFDN0M7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxJQUFJOztBQUVKO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBLEVBQUU7O0FBRUY7O0FBRUE7O0FBRUE7O0FBRUE7O0FBRUE7QUFDQSxFQUFFOzs7QUFHRjtBQUNBLENBQUM7Ozs7Ozs7Ozs7O0FDaDZDRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLE1BQU0sSUFBMEM7QUFDaEQ7QUFDQSxFQUFFLGlDQUFRLENBQUMseUVBQVEsRUFBRSw0RkFBZ0IsRUFBRSxvSEFBd0IsQ0FBQyxtQ0FBRTtBQUNsRTtBQUNBLEdBQUc7QUFBQSxrR0FBRTtBQUNMO0FBQ0EsTUFBTSx3QkFxQ0o7QUFDRixDQUFDO0FBQ0Q7QUFDQTs7OztBQUlBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSixHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5REFBeUQ7QUFDekQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esb0JBQW9CLEdBQUc7QUFDdkIsZ0NBQWdDO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBLHdCQUF3QjtBQUN4QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBOztBQUVBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLENBQUM7QUFDRDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLFlBQVksV0FBVztBQUN2QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxlQUFlO0FBQzFCLFdBQVcsV0FBVztBQUN0QixZQUFZLGVBQWU7QUFDM0I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLGtDQUFrQyxTQUFTO0FBQzNDO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQSxLQUFLO0FBQ0w7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBLEtBQUs7QUFDTDtBQUNBOztBQUVBLHlDQUF5QyxTQUFTO0FBQ2xEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFlBQVksU0FBUztBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLFlBQVksS0FBSztBQUNqQixZQUFZLFFBQVE7QUFDcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsRUFBRTtBQUNGO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQixXQUFXLFFBQVE7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSw4Q0FBOEMsUUFBUTtBQUN0RDtBQUNBOztBQUVBO0FBQ0EsbUJBQW1CLGtDQUFrQzs7QUFFckQ7QUFDQTtBQUNBOztBQUVBLG9DQUFvQyxTQUFTO0FBQzdDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLFFBQVE7QUFDcEIsWUFBWSxRQUFRO0FBQ3BCLFlBQVksUUFBUTtBQUNwQjtBQUNBLFlBQVksaUJBQWlCO0FBQzdCO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsWUFBWSxRQUFRO0FBQ3BCLFlBQVksUUFBUTtBQUNwQixZQUFZLGFBQWE7QUFDekI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLHlDQUF5QyxTQUFTO0FBQ2xEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsY0FBYztBQUNkO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSx1REFBdUQ7QUFDdkQsNENBQTRDLE9BQU87QUFDbkQ7QUFDQTtBQUNBLDRDQUE0QztBQUM1QywrQ0FBK0M7QUFDL0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTtBQUNGLEdBQUcsd0NBQXdDO0FBQzNDLEdBQUcsdUNBQXVDO0FBQzFDLEdBQUcsdUNBQXVDO0FBQzFDLEdBQUcsOEJBQThCO0FBQ2pDLEdBQUcsb0JBQW9CLEVBQUUsZUFBZTtBQUN4QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7QUFDQSx3QkFBd0IsRUFBRTtBQUMxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7QUFDRixHQUFHLGlDQUFpQztBQUNwQyxHQUFHLHVCQUF1QixFQUFFLGVBQWU7QUFDM0M7QUFDQSxnQkFBZ0IsRUFBRTtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKLEVBQUU7O0FBRUY7O0FBRUEsa0JBQWtCOztBQUVsQjs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxnQkFBZ0I7QUFDaEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSx3QkFBd0IsNEJBQTRCO0FBQ3BEO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7O0FBRUE7O0FBRUE7O0FBRUEsa0JBQWtCOztBQUVsQjs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3Q0FBd0MsUUFBUSxpQkFBaUI7O0FBRWpFLHFDQUFxQyxTQUFTO0FBQzlDO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0EsaURBQWlELFNBQVM7QUFDMUQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUiwyQ0FBMkMsV0FBVztBQUN0RCxPQUFPOztBQUVQO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUiwyQ0FBMkMsY0FBYztBQUN6RCxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVc7QUFDWDtBQUNBLFNBQVM7QUFDVDtBQUNBLE9BQU87QUFDUDtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBLDBDQUEwQzs7QUFFMUM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTCxJQUFJO0FBQ0o7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSwwQ0FBMEM7QUFDMUM7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQSx5Q0FBeUMsUUFBUTtBQUNqRDtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLDRDQUE0QyxTQUFTO0FBQ3JEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTs7QUFFQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7O0FBRUE7O0FBRUE7O0FBRUEsa0JBQWtCOztBQUVsQjs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsSUFBSTtBQUNKOztBQUVBLDBDQUEwQyxTQUFTO0FBQ25EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsSUFBSTtBQUNKOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTtBQUNKOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsRUFBRTs7QUFFRjs7QUFFQTs7QUFFQTs7QUFFQTs7QUFFQSxrQkFBa0I7O0FBRWxCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7O0FBRUE7O0FBRUE7O0FBRUE7O0FBRUE7QUFDQTs7O0FBR0E7QUFDQSxDQUFDOzs7Ozs7Ozs7OztBQ3RwREQ7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxNQUFNLElBQTBDO0FBQ2hEO0FBQ0EsRUFBRSxpQ0FBUSxDQUFDLHlFQUFRLEVBQUUsNEZBQWdCLEVBQUUsb0hBQXdCLENBQUMsbUNBQUU7QUFDbEU7QUFDQSxHQUFHO0FBQUEsa0dBQUU7QUFDTDtBQUNBLE1BQU0sd0JBcUNKO0FBQ0YsQ0FBQztBQUNEO0FBQ0E7Ozs7QUFJQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFlBQVksVUFBVTtBQUN0QjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLFFBQVE7QUFDcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQSxjQUFjLHVCQUF1QjtBQUNyQztBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLElBQUk7QUFDSjs7QUFFQTtBQUNBOztBQUVBLG1DQUFtQyxTQUFTO0FBQzVDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQTtBQUNBLElBQUk7O0FBRUo7QUFDQTs7QUFFQTtBQUNBLDBDQUEwQyxTQUFTO0FBQ25EO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7O0FBRUg7QUFDQSx1Q0FBdUM7QUFDdkMsSUFBSTtBQUNKLG9DQUFvQztBQUNwQzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBLEdBQUc7O0FBRUg7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQixpQkFBaUI7QUFDakI7QUFDQTs7QUFFQTs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7O0FBRUE7O0FBRUE7O0FBRUE7O0FBRUEsa0JBQWtCOztBQUVsQjs7QUFFQTs7QUFFQTs7QUFFQTtBQUNBOzs7QUFHQTtBQUNBLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2xTRDtBQUNBO0FBQ0E7O0FBRTRCO0FBQ1c7O0FBRXZDO0FBQ0EsUUFBUSxtQ0FBTTs7O0FBR2Q7QUFDQSxzREFBUzs7QUFFVCxzREFBUzs7QUFFVCxzREFBUztBQUNUOztBQUVBLE1BQU0sc0RBQVM7QUFDZjtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsZ0JBQWdCLGdCQUFnQjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLG1CQUFtQixnQkFBZ0I7QUFDbkM7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxpQkFBaUIsZ0JBQWdCO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBLG1CQUFtQiw4QkFBOEI7QUFDakQ7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLCtCQUErQixnQkFBZ0I7QUFDL0MscUNBQXFDLGdCQUFnQjtBQUNyRCxpQ0FBaUMsZ0JBQWdCO0FBQ2pELFlBQVk7QUFDWixHQUFHO0FBQ0gsRUFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBLEdBQUc7O0FBRUg7QUFDQSxnQkFBZ0Isc0RBQVM7QUFDekI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLGVBQWU7QUFDM0IsWUFBWSxlQUFlO0FBQzNCLFlBQVksZUFBZTtBQUMzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsSUFBSTtBQUNKOztBQUVBO0FBQ0EsMEJBQTBCLG1CQUFtQjs7QUFFN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxHQUFHO0FBQ0g7O0FBRUEsaUJBQWlCLGdCQUFnQjtBQUNqQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUEsc0JBQXNCLGdCQUFnQjtBQUN0QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsZUFBZTtBQUMxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxlQUFlO0FBQzFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxlQUFlO0FBQzFCLFlBQVksY0FBYztBQUMxQixZQUFZLGNBQWM7QUFDMUIsWUFBWSxjQUFjO0FBQzFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxlQUFlO0FBQzFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSx1QkFBdUIsZ0JBQWdCO0FBQ3ZDLDZCQUE2QixnQkFBZ0I7QUFDN0MseUJBQXlCLGdCQUFnQjs7QUFFekM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU8scUVBQXFFO0FBQzVFO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxHQUFHO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQSxlQUFlLGtCQUFrQjtBQUNqQztBQUNBO0FBQ0EsZUFBZSxlQUFlO0FBQzlCO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDBCQUEwQixlQUFlO0FBQ3pDLDJCQUEyQixrQ0FBa0M7QUFDN0QsOEJBQThCLGtCQUFrQjs7QUFFaEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0o7QUFDQSxFQUFFO0FBQ0Y7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLG9CQUFvQjtBQUNoQztBQUNBO0FBQ0E7QUFDQSxlQUFlLHNEQUFTO0FBQ3hCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSwyQ0FBMkMsU0FBUztBQUNwRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxnQkFBZ0I7QUFDM0I7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBLFlBQVksZ0JBQWdCO0FBQzVCO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixrQ0FBa0M7QUFDcEQsSUFBSTtBQUNKO0FBQ0E7QUFDQSxJQUFJOztBQUVKO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLEdBQUc7QUFDSCxFQUFFOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0EsR0FBRzs7QUFFSDtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBO0FBQ0EsZUFBZSxnQkFBZ0I7O0FBRS9CO0FBQ0E7QUFDQTtBQUNBLEVBQUU7QUFDRjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFlBQVksZUFBZTtBQUMzQixZQUFZLGVBQWU7QUFDM0IsWUFBWSxlQUFlO0FBQzNCLFlBQVksZUFBZTtBQUMzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBLGdDQUFnQyxtQkFBbUI7QUFDbkQ7QUFDQTs7QUFFQSx1QkFBdUIsZ0JBQWdCO0FBQ3ZDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLHNCQUFzQixnQkFBZ0I7QUFDdEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLFlBQVksb0JBQW9CO0FBQ2hDLFlBQVksU0FBUztBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsZ0JBQWdCLHNEQUFTOztBQUV6QixhQUFhLGdCQUFnQjtBQUM3QixnQkFBZ0IsZ0JBQWdCO0FBQ2hDLGNBQWMsZ0JBQWdCO0FBQzlCO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsWUFBWSxvQkFBb0I7QUFDaEMsWUFBWSxvQkFBb0I7QUFDaEMsWUFBWSxvQkFBb0I7QUFDaEMsWUFBWSxvQkFBb0I7QUFDaEMsWUFBWSxvQkFBb0I7QUFDaEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtDQUFrQyxnQkFBZ0I7O0FBRWxEO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxtQ0FBbUMsZ0JBQWdCOztBQUVuRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFJLDZCQUE2QjtBQUNqQyxJQUFJO0FBQ0o7QUFDQTtBQUNBLEVBQUUsc0RBQVM7QUFDWDtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLHlDQUF5QyxTQUFTO0FBQ2xEOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLEdBQUc7QUFDSDtBQUNBOztBQUVBLHNEQUFTO0FBQ1Q7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxxQ0FBcUMsU0FBUztBQUM5Qzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLGtCQUFrQixzREFBUztBQUMzQix3QkFBd0Isc0RBQVM7O0FBRWpDO0FBQ0E7QUFDQSxFQUFFLHNEQUFTLGlCQUFpQixzREFBUztBQUNyQyxFQUFFO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsRUFBRTtBQUNGLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLEVBQUU7QUFDRixDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxFQUFFO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLG1CQUFtQixzREFBUztBQUM1QixFQUFFO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLEdBQUcsc0RBQVMsaUJBQWlCLHNEQUFTO0FBQ3RDOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0EsZUFBZSxzREFBUztBQUN4Qjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsbUJBQW1CLHNEQUFTO0FBQzVCLEVBQUU7QUFDRixDQUFDOztBQUVEO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsNEJBQTRCLHNEQUFTOztBQUVyQzs7QUFFQTtBQUNBLDRCQUE0QixzREFBUztBQUNyQztBQUNBLEVBQUU7QUFDRixDQUFDOztBQUVEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxDQUFDOztBQUVEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBLGlCQUFpQixxQkFBcUI7QUFDdEM7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBLENBQUM7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxDQUFDOztBQUVEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7O0FBRUEsbUJBQW1CLHNEQUFTOztBQUU1QjtBQUNBOztBQUVBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBLENBQUM7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxDQUFDOztBQUVEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBOztBQUVBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQTtBQUNBLEVBQUU7O0FBRUY7QUFDQSxDQUFDOztBQUVEO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLENBQUM7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsaUJBQWlCLHFCQUFxQjtBQUN0Qzs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0EsQ0FBQzs7QUFFRDtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsZ0JBQWdCLHNEQUFTO0FBQ3pCOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxJQUFJO0FBQ0osRUFBRTs7QUFFRjtBQUNBO0FBQ0EsRUFBRTs7QUFFRjtBQUNBLENBQUM7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0E7QUFDQSxFQUFFOztBQUVGO0FBQ0EsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0Esd0RBQXdELGdCQUFnQjtBQUN4RTtBQUNBOztBQUVBLDhEQUE4RCxnQkFBZ0I7QUFDOUU7QUFDQTs7QUFFQSwwREFBMEQsZ0JBQWdCO0FBQzFFO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTs7QUFFQSxTQUFTLHNEQUFTO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsSUFBSTs7QUFFSjtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxlQUFlLGdCQUFnQjtBQUMvQixrQkFBa0IsZ0JBQWdCO0FBQ2xDLGdCQUFnQixnQkFBZ0I7O0FBRWhDO0FBQ0EsSUFBSTs7QUFFSjtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxFQUFFO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBQUU7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0EsZUFBZSxnQkFBZ0I7QUFDL0Isa0JBQWtCLGdCQUFnQjtBQUNsQyxnQkFBZ0IsZ0JBQWdCOztBQUVoQztBQUNBLElBQUk7O0FBRUo7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0EsRUFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7O0FBRUw7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxDQUFDOztBQUVEO0FBQ0E7O0FBRUEsQ0FBQyxzREFBUztBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLElBQUk7QUFDSjtBQUNBO0FBQ0EsQ0FBQzs7QUFFRCxzREFBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxDQUFDOztBQUVELGVBQWUsc0RBQVM7QUFDeEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUM7O0FBRUQsc0RBQVM7QUFDVCwyQkFBMkIsc0RBQVM7QUFDcEMseUJBQXlCLHNEQUFTOztBQUVsQztBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0Esc0RBQVM7QUFDVDtBQUNBLGlCQUFpQixnQkFBZ0I7QUFDakM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIOztBQUVBLHdCQUF3QixzREFBUzs7QUFFakM7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsQ0FBQyxzREFBUyxpQkFBaUIsc0RBQVM7QUFDcEMsQ0FBQzs7O0FBR0QsaUVBQWUsc0RBQVMsRUFBQyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9kYXRhdGFibGVzLm5ldC1idXR0b25zL2pzL2J1dHRvbnMuY29sVmlzLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9kYXRhdGFibGVzLm5ldC1idXR0b25zL2pzL2J1dHRvbnMuZmxhc2guanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2RhdGF0YWJsZXMubmV0LWJ1dHRvbnMvanMvYnV0dG9ucy5odG1sNS5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZGF0YXRhYmxlcy5uZXQtYnV0dG9ucy9qcy9idXR0b25zLnByaW50LmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9kYXRhdGFibGVzLm5ldC1zZWxlY3QvanMvZGF0YVRhYmxlcy5zZWxlY3QubWpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qIVxuICogQ29sdW1uIHZpc2liaWxpdHkgYnV0dG9ucyBmb3IgQnV0dG9ucyBhbmQgRGF0YVRhYmxlcy5cbiAqIMKpIFNwcnlNZWRpYSBMdGQgLSBkYXRhdGFibGVzLm5ldC9saWNlbnNlXG4gKi9cblxuKGZ1bmN0aW9uKCBmYWN0b3J5ICl7XG5cdGlmICggdHlwZW9mIGRlZmluZSA9PT0gJ2Z1bmN0aW9uJyAmJiBkZWZpbmUuYW1kICkge1xuXHRcdC8vIEFNRFxuXHRcdGRlZmluZSggWydqcXVlcnknLCAnZGF0YXRhYmxlcy5uZXQnLCAnZGF0YXRhYmxlcy5uZXQtYnV0dG9ucyddLCBmdW5jdGlvbiAoICQgKSB7XG5cdFx0XHRyZXR1cm4gZmFjdG9yeSggJCwgd2luZG93LCBkb2N1bWVudCApO1xuXHRcdH0gKTtcblx0fVxuXHRlbHNlIGlmICggdHlwZW9mIGV4cG9ydHMgPT09ICdvYmplY3QnICkge1xuXHRcdC8vIENvbW1vbkpTXG5cdFx0dmFyIGpxID0gcmVxdWlyZSgnanF1ZXJ5Jyk7XG5cdFx0dmFyIGNqc1JlcXVpcmVzID0gZnVuY3Rpb24gKHJvb3QsICQpIHtcblx0XHRcdGlmICggISAkLmZuLmRhdGFUYWJsZSApIHtcblx0XHRcdFx0cmVxdWlyZSgnZGF0YXRhYmxlcy5uZXQnKShyb290LCAkKTtcblx0XHRcdH1cblxuXHRcdFx0aWYgKCAhICQuZm4uZGF0YVRhYmxlLkJ1dHRvbnMgKSB7XG5cdFx0XHRcdHJlcXVpcmUoJ2RhdGF0YWJsZXMubmV0LWJ1dHRvbnMnKShyb290LCAkKTtcblx0XHRcdH1cblx0XHR9O1xuXG5cdFx0aWYgKHR5cGVvZiB3aW5kb3cgPT09ICd1bmRlZmluZWQnKSB7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIChyb290LCAkKSB7XG5cdFx0XHRcdGlmICggISByb290ICkge1xuXHRcdFx0XHRcdC8vIENvbW1vbkpTIGVudmlyb25tZW50cyB3aXRob3V0IGEgd2luZG93IGdsb2JhbCBtdXN0IHBhc3MgYVxuXHRcdFx0XHRcdC8vIHJvb3QuIFRoaXMgd2lsbCBnaXZlIGFuIGVycm9yIG90aGVyd2lzZVxuXHRcdFx0XHRcdHJvb3QgPSB3aW5kb3c7XG5cdFx0XHRcdH1cblxuXHRcdFx0XHRpZiAoICEgJCApIHtcblx0XHRcdFx0XHQkID0ganEoIHJvb3QgKTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdGNqc1JlcXVpcmVzKCByb290LCAkICk7XG5cdFx0XHRcdHJldHVybiBmYWN0b3J5KCAkLCByb290LCByb290LmRvY3VtZW50ICk7XG5cdFx0XHR9O1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGNqc1JlcXVpcmVzKCB3aW5kb3csIGpxICk7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZhY3RvcnkoIGpxLCB3aW5kb3csIHdpbmRvdy5kb2N1bWVudCApO1xuXHRcdH1cblx0fVxuXHRlbHNlIHtcblx0XHQvLyBCcm93c2VyXG5cdFx0ZmFjdG9yeSggalF1ZXJ5LCB3aW5kb3csIGRvY3VtZW50ICk7XG5cdH1cbn0oZnVuY3Rpb24oICQsIHdpbmRvdywgZG9jdW1lbnQgKSB7XG4ndXNlIHN0cmljdCc7XG52YXIgRGF0YVRhYmxlID0gJC5mbi5kYXRhVGFibGU7XG5cblxuXG4kLmV4dGVuZChEYXRhVGFibGUuZXh0LmJ1dHRvbnMsIHtcblx0Ly8gQSBjb2xsZWN0aW9uIG9mIGNvbHVtbiB2aXNpYmlsaXR5IGJ1dHRvbnNcblx0Y29sdmlzOiBmdW5jdGlvbiAoZHQsIGNvbmYpIHtcblx0XHR2YXIgbm9kZSA9IG51bGw7XG5cdFx0dmFyIGJ1dHRvbkNvbmYgPSB7XG5cdFx0XHRleHRlbmQ6ICdjb2xsZWN0aW9uJyxcblx0XHRcdGluaXQ6IGZ1bmN0aW9uIChkdCwgbikge1xuXHRcdFx0XHRub2RlID0gbjtcblx0XHRcdH0sXG5cdFx0XHR0ZXh0OiBmdW5jdGlvbiAoZHQpIHtcblx0XHRcdFx0cmV0dXJuIGR0LmkxOG4oJ2J1dHRvbnMuY29sdmlzJywgJ0NvbHVtbiB2aXNpYmlsaXR5Jyk7XG5cdFx0XHR9LFxuXHRcdFx0Y2xhc3NOYW1lOiAnYnV0dG9ucy1jb2x2aXMnLFxuXHRcdFx0Y2xvc2VCdXR0b246IGZhbHNlLFxuXHRcdFx0YnV0dG9uczogW1xuXHRcdFx0XHR7XG5cdFx0XHRcdFx0ZXh0ZW5kOiAnY29sdW1uc1RvZ2dsZScsXG5cdFx0XHRcdFx0Y29sdW1uczogY29uZi5jb2x1bW5zLFxuXHRcdFx0XHRcdGNvbHVtblRleHQ6IGNvbmYuY29sdW1uVGV4dFxuXHRcdFx0XHR9XG5cdFx0XHRdXG5cdFx0fTtcblxuXHRcdC8vIFJlYnVpbGQgdGhlIGNvbGxlY3Rpb24gd2l0aCB0aGUgbmV3IGNvbHVtbiBzdHJ1Y3R1cmUgaWYgY29sdW1ucyBhcmUgcmVvcmRlcmVkXG5cdFx0ZHQub24oJ2NvbHVtbi1yZW9yZGVyLmR0JyArIGNvbmYubmFtZXNwYWNlLCBmdW5jdGlvbiAoKSB7XG5cdFx0XHRkdC5idXR0b24obnVsbCwgZHQuYnV0dG9uKG51bGwsIG5vZGUpLm5vZGUoKSkuY29sbGVjdGlvblJlYnVpbGQoW1xuXHRcdFx0XHR7XG5cdFx0XHRcdFx0ZXh0ZW5kOiAnY29sdW1uc1RvZ2dsZScsXG5cdFx0XHRcdFx0Y29sdW1uczogY29uZi5jb2x1bW5zLFxuXHRcdFx0XHRcdGNvbHVtblRleHQ6IGNvbmYuY29sdW1uVGV4dFxuXHRcdFx0XHR9XG5cdFx0XHRdKTtcblx0XHR9KTtcblxuXHRcdHJldHVybiBidXR0b25Db25mO1xuXHR9LFxuXG5cdC8vIFNlbGVjdGVkIGNvbHVtbnMgd2l0aCBpbmRpdmlkdWFsIGJ1dHRvbnMgLSB0b2dnbGUgY29sdW1uIHZpc2liaWxpdHlcblx0Y29sdW1uc1RvZ2dsZTogZnVuY3Rpb24gKGR0LCBjb25mKSB7XG5cdFx0dmFyIGNvbHVtbnMgPSBkdFxuXHRcdFx0LmNvbHVtbnMoY29uZi5jb2x1bW5zKVxuXHRcdFx0LmluZGV4ZXMoKVxuXHRcdFx0Lm1hcChmdW5jdGlvbiAoaWR4KSB7XG5cdFx0XHRcdHJldHVybiB7XG5cdFx0XHRcdFx0ZXh0ZW5kOiAnY29sdW1uVG9nZ2xlJyxcblx0XHRcdFx0XHRjb2x1bW5zOiBpZHgsXG5cdFx0XHRcdFx0Y29sdW1uVGV4dDogY29uZi5jb2x1bW5UZXh0XG5cdFx0XHRcdH07XG5cdFx0XHR9KVxuXHRcdFx0LnRvQXJyYXkoKTtcblxuXHRcdHJldHVybiBjb2x1bW5zO1xuXHR9LFxuXG5cdC8vIFNpbmdsZSBidXR0b24gdG8gdG9nZ2xlIGNvbHVtbiB2aXNpYmlsaXR5XG5cdGNvbHVtblRvZ2dsZTogZnVuY3Rpb24gKGR0LCBjb25mKSB7XG5cdFx0cmV0dXJuIHtcblx0XHRcdGV4dGVuZDogJ2NvbHVtblZpc2liaWxpdHknLFxuXHRcdFx0Y29sdW1uczogY29uZi5jb2x1bW5zLFxuXHRcdFx0Y29sdW1uVGV4dDogY29uZi5jb2x1bW5UZXh0XG5cdFx0fTtcblx0fSxcblxuXHQvLyBTZWxlY3RlZCBjb2x1bW5zIHdpdGggaW5kaXZpZHVhbCBidXR0b25zIC0gc2V0IGNvbHVtbiB2aXNpYmlsaXR5XG5cdGNvbHVtbnNWaXNpYmlsaXR5OiBmdW5jdGlvbiAoZHQsIGNvbmYpIHtcblx0XHR2YXIgY29sdW1ucyA9IGR0XG5cdFx0XHQuY29sdW1ucyhjb25mLmNvbHVtbnMpXG5cdFx0XHQuaW5kZXhlcygpXG5cdFx0XHQubWFwKGZ1bmN0aW9uIChpZHgpIHtcblx0XHRcdFx0cmV0dXJuIHtcblx0XHRcdFx0XHRleHRlbmQ6ICdjb2x1bW5WaXNpYmlsaXR5Jyxcblx0XHRcdFx0XHRjb2x1bW5zOiBpZHgsXG5cdFx0XHRcdFx0dmlzaWJpbGl0eTogY29uZi52aXNpYmlsaXR5LFxuXHRcdFx0XHRcdGNvbHVtblRleHQ6IGNvbmYuY29sdW1uVGV4dFxuXHRcdFx0XHR9O1xuXHRcdFx0fSlcblx0XHRcdC50b0FycmF5KCk7XG5cblx0XHRyZXR1cm4gY29sdW1ucztcblx0fSxcblxuXHQvLyBTaW5nbGUgYnV0dG9uIHRvIHNldCBjb2x1bW4gdmlzaWJpbGl0eVxuXHRjb2x1bW5WaXNpYmlsaXR5OiB7XG5cdFx0Y29sdW1uczogdW5kZWZpbmVkLCAvLyBjb2x1bW4gc2VsZWN0b3Jcblx0XHR0ZXh0OiBmdW5jdGlvbiAoZHQsIGJ1dHRvbiwgY29uZikge1xuXHRcdFx0cmV0dXJuIGNvbmYuX2NvbHVtblRleHQoZHQsIGNvbmYpO1xuXHRcdH0sXG5cdFx0Y2xhc3NOYW1lOiAnYnV0dG9ucy1jb2x1bW5WaXNpYmlsaXR5Jyxcblx0XHRhY3Rpb246IGZ1bmN0aW9uIChlLCBkdCwgYnV0dG9uLCBjb25mKSB7XG5cdFx0XHR2YXIgY29sID0gZHQuY29sdW1ucyhjb25mLmNvbHVtbnMpO1xuXHRcdFx0dmFyIGN1cnIgPSBjb2wudmlzaWJsZSgpO1xuXG5cdFx0XHRjb2wudmlzaWJsZShcblx0XHRcdFx0Y29uZi52aXNpYmlsaXR5ICE9PSB1bmRlZmluZWQgPyBjb25mLnZpc2liaWxpdHkgOiAhKGN1cnIubGVuZ3RoID8gY3VyclswXSA6IGZhbHNlKVxuXHRcdFx0KTtcblx0XHR9LFxuXHRcdGluaXQ6IGZ1bmN0aW9uIChkdCwgYnV0dG9uLCBjb25mKSB7XG5cdFx0XHR2YXIgdGhhdCA9IHRoaXM7XG5cdFx0XHRidXR0b24uYXR0cignZGF0YS1jdi1pZHgnLCBjb25mLmNvbHVtbnMpO1xuXG5cdFx0XHRkdC5vbignY29sdW1uLXZpc2liaWxpdHkuZHQnICsgY29uZi5uYW1lc3BhY2UsIGZ1bmN0aW9uIChlLCBzZXR0aW5ncykge1xuXHRcdFx0XHRpZiAoIXNldHRpbmdzLmJEZXN0cm95aW5nICYmIHNldHRpbmdzLm5UYWJsZSA9PSBkdC5zZXR0aW5ncygpWzBdLm5UYWJsZSkge1xuXHRcdFx0XHRcdHRoYXQuYWN0aXZlKGR0LmNvbHVtbihjb25mLmNvbHVtbnMpLnZpc2libGUoKSk7XG5cdFx0XHRcdH1cblx0XHRcdH0pLm9uKCdjb2x1bW4tcmVvcmRlci5kdCcgKyBjb25mLm5hbWVzcGFjZSwgZnVuY3Rpb24gKCkge1xuXHRcdFx0XHQvLyBCdXR0b24gaGFzIGJlZW4gcmVtb3ZlZCBmcm9tIHRoZSBET01cblx0XHRcdFx0aWYgKGNvbmYuZGVzdHJveWluZykge1xuXHRcdFx0XHRcdHJldHVybjtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdGlmIChkdC5jb2x1bW5zKGNvbmYuY29sdW1ucykuY291bnQoKSAhPT0gMSkge1xuXHRcdFx0XHRcdHJldHVybjtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdC8vIFRoaXMgYnV0dG9uIGNvbnRyb2xzIHRoZSBzYW1lIGNvbHVtbiBpbmRleCBidXQgdGhlIHRleHQgZm9yIHRoZSBjb2x1bW4gaGFzXG5cdFx0XHRcdC8vIGNoYW5nZWRcblx0XHRcdFx0dGhhdC50ZXh0KGNvbmYuX2NvbHVtblRleHQoZHQsIGNvbmYpKTtcblxuXHRcdFx0XHQvLyBTaW5jZSBpdHMgYSBkaWZmZXJlbnQgY29sdW1uLCB3ZSBuZWVkIHRvIGNoZWNrIGl0cyB2aXNpYmlsaXR5XG5cdFx0XHRcdHRoYXQuYWN0aXZlKGR0LmNvbHVtbihjb25mLmNvbHVtbnMpLnZpc2libGUoKSk7XG5cdFx0XHR9KTtcblxuXHRcdFx0dGhpcy5hY3RpdmUoZHQuY29sdW1uKGNvbmYuY29sdW1ucykudmlzaWJsZSgpKTtcblx0XHR9LFxuXHRcdGRlc3Ryb3k6IGZ1bmN0aW9uIChkdCwgYnV0dG9uLCBjb25mKSB7XG5cdFx0XHRkdC5vZmYoJ2NvbHVtbi12aXNpYmlsaXR5LmR0JyArIGNvbmYubmFtZXNwYWNlKS5vZmYoXG5cdFx0XHRcdCdjb2x1bW4tcmVvcmRlci5kdCcgKyBjb25mLm5hbWVzcGFjZVxuXHRcdFx0KTtcblx0XHR9LFxuXG5cdFx0X2NvbHVtblRleHQ6IGZ1bmN0aW9uIChkdCwgY29uZikge1xuXHRcdFx0aWYgKHR5cGVvZiBjb25mLnRleHQgPT09ICdzdHJpbmcnKSB7XG5cdFx0XHRcdHJldHVybiBjb25mLnRleHQ7XG5cdFx0XHR9XG5cblx0XHRcdC8vIFVzZSBEYXRhVGFibGVzJyBpbnRlcm5hbCBkYXRhIHN0cnVjdHVyZSB1bnRpbCB0aGlzIGlzIHByZXNlbnRlZFxuXHRcdFx0Ly8gaXMgYSBwdWJsaWMgQVBJLiBUaGUgb3RoZXIgb3B0aW9uIGlzIHRvIHVzZVxuXHRcdFx0Ly8gYCQoIGNvbHVtbihjb2wpLm5vZGUoKSApLnRleHQoKWAgYnV0IHRoZSBub2RlIG1pZ2h0IG5vdCBoYXZlIGJlZW5cblx0XHRcdC8vIHBvcHVsYXRlZCB3aGVuIEJ1dHRvbnMgaXMgY29uc3RydWN0ZWQuXG5cdFx0XHR2YXIgaWR4ID0gZHQuY29sdW1uKGNvbmYuY29sdW1ucykuaW5kZXgoKTtcblx0XHRcdHZhciB0aXRsZSA9IGR0LnNldHRpbmdzKClbMF0uYW9Db2x1bW5zW2lkeF0uc1RpdGxlO1xuXG5cdFx0XHRpZiAoIXRpdGxlKSB7XG5cdFx0XHRcdHRpdGxlID0gZHQuY29sdW1uKGlkeCkuaGVhZGVyKCkuaW5uZXJIVE1MO1xuXHRcdFx0fVxuXG5cdFx0XHR0aXRsZSA9IHRpdGxlXG5cdFx0XHRcdC5yZXBsYWNlKC9cXG4vZywgJyAnKSAvLyByZW1vdmUgbmV3IGxpbmVzXG5cdFx0XHRcdC5yZXBsYWNlKC88YnJcXHMqXFwvPz4vZ2ksICcgJykgLy8gcmVwbGFjZSBsaW5lIGJyZWFrcyB3aXRoIHNwYWNlc1xuXHRcdFx0XHQucmVwbGFjZSgvPHNlbGVjdCguKj8pPFxcL3NlbGVjdD4vZywgJycpIC8vIHJlbW92ZSBzZWxlY3QgdGFncywgaW5jbHVkaW5nIG9wdGlvbnMgdGV4dFxuXHRcdFx0XHQucmVwbGFjZSgvPCFcXC1cXC0uKj9cXC1cXC0+L2csICcnKSAvLyBzdHJpcCBIVE1MIGNvbW1lbnRzXG5cdFx0XHRcdC5yZXBsYWNlKC88Lio/Pi9nLCAnJykgLy8gc3RyaXAgSFRNTFxuXHRcdFx0XHQucmVwbGFjZSgvXlxccyt8XFxzKyQvZywgJycpOyAvLyB0cmltXG5cblx0XHRcdHJldHVybiBjb25mLmNvbHVtblRleHQgPyBjb25mLmNvbHVtblRleHQoZHQsIGlkeCwgdGl0bGUpIDogdGl0bGU7XG5cdFx0fVxuXHR9LFxuXG5cdGNvbHZpc1Jlc3RvcmU6IHtcblx0XHRjbGFzc05hbWU6ICdidXR0b25zLWNvbHZpc1Jlc3RvcmUnLFxuXG5cdFx0dGV4dDogZnVuY3Rpb24gKGR0KSB7XG5cdFx0XHRyZXR1cm4gZHQuaTE4bignYnV0dG9ucy5jb2x2aXNSZXN0b3JlJywgJ1Jlc3RvcmUgdmlzaWJpbGl0eScpO1xuXHRcdH0sXG5cblx0XHRpbml0OiBmdW5jdGlvbiAoZHQsIGJ1dHRvbiwgY29uZikge1xuXHRcdFx0Ly8gVXNlIGEgcHJpdmF0ZSBwYXJhbWV0ZXIgb24gdGhlIGNvbHVtbi4gVGhpcyBnZXRzIG1vdmVkIGFyb3VuZCB3aXRoIHRoZVxuXHRcdFx0Ly8gY29sdW1uIGlmIENvbFJlb3JkZXIgY2hhbmdlcyB0aGUgb3JkZXJcblx0XHRcdGR0LmNvbHVtbnMoKS5ldmVyeShmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdHZhciBpbml0ID0gdGhpcy5pbml0KCk7XG5cblx0XHRcdFx0aWYgKGluaXQuX192aXNPcmlnaW5hbCA9PT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRcdFx0aW5pdC5fX3Zpc09yaWdpbmFsID0gdGhpcy52aXNpYmxlKCk7XG5cdFx0XHRcdH1cblx0XHRcdH0pO1xuXHRcdH0sXG5cblx0XHRhY3Rpb246IGZ1bmN0aW9uIChlLCBkdCwgYnV0dG9uLCBjb25mKSB7XG5cdFx0XHRkdC5jb2x1bW5zKCkuZXZlcnkoZnVuY3Rpb24gKGkpIHtcblx0XHRcdFx0dmFyIGluaXQgPSB0aGlzLmluaXQoKTtcblxuXHRcdFx0XHR0aGlzLnZpc2libGUoaW5pdC5fX3Zpc09yaWdpbmFsKTtcblx0XHRcdH0pO1xuXHRcdH1cblx0fSxcblxuXHRjb2x2aXNHcm91cDoge1xuXHRcdGNsYXNzTmFtZTogJ2J1dHRvbnMtY29sdmlzR3JvdXAnLFxuXG5cdFx0YWN0aW9uOiBmdW5jdGlvbiAoZSwgZHQsIGJ1dHRvbiwgY29uZikge1xuXHRcdFx0ZHQuY29sdW1ucyhjb25mLnNob3cpLnZpc2libGUodHJ1ZSwgZmFsc2UpO1xuXHRcdFx0ZHQuY29sdW1ucyhjb25mLmhpZGUpLnZpc2libGUoZmFsc2UsIGZhbHNlKTtcblxuXHRcdFx0ZHQuY29sdW1ucy5hZGp1c3QoKTtcblx0XHR9LFxuXG5cdFx0c2hvdzogW10sXG5cblx0XHRoaWRlOiBbXVxuXHR9XG59KTtcblxuXG5yZXR1cm4gRGF0YVRhYmxlO1xufSkpO1xuIiwiLyohXG4gKiBGbGFzaCBleHBvcnQgYnV0dG9ucyBmb3IgQnV0dG9ucyBhbmQgRGF0YVRhYmxlcy5cbiAqIDIwMTUgU3ByeU1lZGlhIEx0ZCAtIGRhdGF0YWJsZXMubmV0L2xpY2Vuc2VcbiAqXG4gKiBaZXJvQ2xpcGJhb3JkIC0gTUlUIGxpY2Vuc2VcbiAqIENvcHlyaWdodCAoYykgMjAxMiBKb3NlcGggSHVja2FieVxuICovXG5cbihmdW5jdGlvbiggZmFjdG9yeSApe1xuXHRpZiAoIHR5cGVvZiBkZWZpbmUgPT09ICdmdW5jdGlvbicgJiYgZGVmaW5lLmFtZCApIHtcblx0XHQvLyBBTURcblx0XHRkZWZpbmUoIFsnanF1ZXJ5JywgJ2RhdGF0YWJsZXMubmV0JywgJ2RhdGF0YWJsZXMubmV0LWJ1dHRvbnMnXSwgZnVuY3Rpb24gKCAkICkge1xuXHRcdFx0cmV0dXJuIGZhY3RvcnkoICQsIHdpbmRvdywgZG9jdW1lbnQgKTtcblx0XHR9ICk7XG5cdH1cblx0ZWxzZSBpZiAoIHR5cGVvZiBleHBvcnRzID09PSAnb2JqZWN0JyApIHtcblx0XHQvLyBDb21tb25KU1xuXHRcdG1vZHVsZS5leHBvcnRzID0gZnVuY3Rpb24gKHJvb3QsICQpIHtcblx0XHRcdGlmICggISByb290ICkge1xuXHRcdFx0XHRyb290ID0gd2luZG93O1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAoICEgJCB8fCAhICQuZm4uZGF0YVRhYmxlICkge1xuXHRcdFx0XHQkID0gcmVxdWlyZSgnZGF0YXRhYmxlcy5uZXQnKShyb290LCAkKS4kO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAoICEgJC5mbi5kYXRhVGFibGUuQnV0dG9ucyApIHtcblx0XHRcdFx0cmVxdWlyZSgnZGF0YXRhYmxlcy5uZXQtYnV0dG9ucycpKHJvb3QsICQpO1xuXHRcdFx0fVxuXG5cdFx0XHRyZXR1cm4gZmFjdG9yeSggJCwgcm9vdCwgcm9vdC5kb2N1bWVudCApO1xuXHRcdH07XG5cdH1cblx0ZWxzZSB7XG5cdFx0Ly8gQnJvd3NlclxuXHRcdGZhY3RvcnkoIGpRdWVyeSwgd2luZG93LCBkb2N1bWVudCApO1xuXHR9XG59KGZ1bmN0aW9uKCAkLCB3aW5kb3csIGRvY3VtZW50LCB1bmRlZmluZWQgKSB7XG4ndXNlIHN0cmljdCc7XG52YXIgRGF0YVRhYmxlID0gJC5mbi5kYXRhVGFibGU7XG5cblxuLyogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqXG4gKiBaZXJvQ2xpcGJvYXJkIGRlcGVuZGVuY3lcbiAqL1xuXG4vKlxuICogWmVyb0NsaXBib2FyZCAxLjAuNCB3aXRoIG1vZGlmaWNhdGlvbnNcbiAqIEF1dGhvcjogSm9zZXBoIEh1Y2thYnlcbiAqIExpY2Vuc2U6IE1JVFxuICpcbiAqIENvcHlyaWdodCAoYykgMjAxMiBKb3NlcGggSHVja2FieVxuICovXG52YXIgWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzID0ge1xuXHR2ZXJzaW9uOiBcIjEuMC40LVRhYmxlVG9vbHMyXCIsXG5cdGNsaWVudHM6IHt9LCAvLyByZWdpc3RlcmVkIHVwbG9hZCBjbGllbnRzIG9uIHBhZ2UsIGluZGV4ZWQgYnkgaWRcblx0bW92aWVQYXRoOiAnJywgLy8gVVJMIHRvIG1vdmllXG5cdG5leHRJZDogMSwgLy8gSUQgb2YgbmV4dCBtb3ZpZVxuXG5cdCQ6IGZ1bmN0aW9uKHRoaW5neSkge1xuXHRcdC8vIHNpbXBsZSBET00gbG9va3VwIHV0aWxpdHkgZnVuY3Rpb25cblx0XHRpZiAodHlwZW9mKHRoaW5neSkgPT0gJ3N0cmluZycpIHtcblx0XHRcdHRoaW5neSA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKHRoaW5neSk7XG5cdFx0fVxuXHRcdGlmICghdGhpbmd5LmFkZENsYXNzKSB7XG5cdFx0XHQvLyBleHRlbmQgZWxlbWVudCB3aXRoIGEgZmV3IHVzZWZ1bCBtZXRob2RzXG5cdFx0XHR0aGluZ3kuaGlkZSA9IGZ1bmN0aW9uKCkgeyB0aGlzLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSc7IH07XG5cdFx0XHR0aGluZ3kuc2hvdyA9IGZ1bmN0aW9uKCkgeyB0aGlzLnN0eWxlLmRpc3BsYXkgPSAnJzsgfTtcblx0XHRcdHRoaW5neS5hZGRDbGFzcyA9IGZ1bmN0aW9uKG5hbWUpIHsgdGhpcy5yZW1vdmVDbGFzcyhuYW1lKTsgdGhpcy5jbGFzc05hbWUgKz0gJyAnICsgbmFtZTsgfTtcblx0XHRcdHRoaW5neS5yZW1vdmVDbGFzcyA9IGZ1bmN0aW9uKG5hbWUpIHtcblx0XHRcdFx0dGhpcy5jbGFzc05hbWUgPSB0aGlzLmNsYXNzTmFtZS5yZXBsYWNlKCBuZXcgUmVnRXhwKFwiXFxcXHMqXCIgKyBuYW1lICsgXCJcXFxccypcIiksIFwiIFwiKS5yZXBsYWNlKC9eXFxzKy8sICcnKS5yZXBsYWNlKC9cXHMrJC8sICcnKTtcblx0XHRcdH07XG5cdFx0XHR0aGluZ3kuaGFzQ2xhc3MgPSBmdW5jdGlvbihuYW1lKSB7XG5cdFx0XHRcdHJldHVybiAhIXRoaXMuY2xhc3NOYW1lLm1hdGNoKCBuZXcgUmVnRXhwKFwiXFxcXHMqXCIgKyBuYW1lICsgXCJcXFxccypcIikgKTtcblx0XHRcdH07XG5cdFx0fVxuXHRcdHJldHVybiB0aGluZ3k7XG5cdH0sXG5cblx0c2V0TW92aWVQYXRoOiBmdW5jdGlvbihwYXRoKSB7XG5cdFx0Ly8gc2V0IHBhdGggdG8gWmVyb0NsaXBib2FyZC5zd2Zcblx0XHR0aGlzLm1vdmllUGF0aCA9IHBhdGg7XG5cdH0sXG5cblx0ZGlzcGF0Y2g6IGZ1bmN0aW9uKGlkLCBldmVudE5hbWUsIGFyZ3MpIHtcblx0XHQvLyByZWNlaXZlIGV2ZW50IGZyb20gZmxhc2ggbW92aWUsIHNlbmQgdG8gY2xpZW50XG5cdFx0dmFyIGNsaWVudCA9IHRoaXMuY2xpZW50c1tpZF07XG5cdFx0aWYgKGNsaWVudCkge1xuXHRcdFx0Y2xpZW50LnJlY2VpdmVFdmVudChldmVudE5hbWUsIGFyZ3MpO1xuXHRcdH1cblx0fSxcblxuXHRsb2c6IGZ1bmN0aW9uICggc3RyICkge1xuXHRcdGNvbnNvbGUubG9nKCAnRmxhc2g6ICcrc3RyICk7XG5cdH0sXG5cblx0cmVnaXN0ZXI6IGZ1bmN0aW9uKGlkLCBjbGllbnQpIHtcblx0XHQvLyByZWdpc3RlciBuZXcgY2xpZW50IHRvIHJlY2VpdmUgZXZlbnRzXG5cdFx0dGhpcy5jbGllbnRzW2lkXSA9IGNsaWVudDtcblx0fSxcblxuXHRnZXRET01PYmplY3RQb3NpdGlvbjogZnVuY3Rpb24ob2JqKSB7XG5cdFx0Ly8gZ2V0IGFic29sdXRlIGNvb3JkaW5hdGVzIGZvciBkb20gZWxlbWVudFxuXHRcdHZhciBpbmZvID0ge1xuXHRcdFx0bGVmdDogMCxcblx0XHRcdHRvcDogMCxcblx0XHRcdHdpZHRoOiBvYmoud2lkdGggPyBvYmoud2lkdGggOiBvYmoub2Zmc2V0V2lkdGgsXG5cdFx0XHRoZWlnaHQ6IG9iai5oZWlnaHQgPyBvYmouaGVpZ2h0IDogb2JqLm9mZnNldEhlaWdodFxuXHRcdH07XG5cblx0XHRpZiAoIG9iai5zdHlsZS53aWR0aCAhPT0gXCJcIiApIHtcblx0XHRcdGluZm8ud2lkdGggPSBvYmouc3R5bGUud2lkdGgucmVwbGFjZShcInB4XCIsXCJcIik7XG5cdFx0fVxuXG5cdFx0aWYgKCBvYmouc3R5bGUuaGVpZ2h0ICE9PSBcIlwiICkge1xuXHRcdFx0aW5mby5oZWlnaHQgPSBvYmouc3R5bGUuaGVpZ2h0LnJlcGxhY2UoXCJweFwiLFwiXCIpO1xuXHRcdH1cblxuXHRcdHdoaWxlIChvYmopIHtcblx0XHRcdGluZm8ubGVmdCArPSBvYmoub2Zmc2V0TGVmdDtcblx0XHRcdGluZm8udG9wICs9IG9iai5vZmZzZXRUb3A7XG5cdFx0XHRvYmogPSBvYmoub2Zmc2V0UGFyZW50O1xuXHRcdH1cblxuXHRcdHJldHVybiBpbmZvO1xuXHR9LFxuXG5cdENsaWVudDogZnVuY3Rpb24oZWxlbSkge1xuXHRcdC8vIGNvbnN0cnVjdG9yIGZvciBuZXcgc2ltcGxlIHVwbG9hZCBjbGllbnRcblx0XHR0aGlzLmhhbmRsZXJzID0ge307XG5cblx0XHQvLyB1bmlxdWUgSURcblx0XHR0aGlzLmlkID0gWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLm5leHRJZCsrO1xuXHRcdHRoaXMubW92aWVJZCA9ICdaZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHNNb3ZpZV8nICsgdGhpcy5pZDtcblxuXHRcdC8vIHJlZ2lzdGVyIGNsaWVudCB3aXRoIHNpbmdsZXRvbiB0byByZWNlaXZlIGZsYXNoIGV2ZW50c1xuXHRcdFplcm9DbGlwYm9hcmRfVGFibGVUb29scy5yZWdpc3Rlcih0aGlzLmlkLCB0aGlzKTtcblxuXHRcdC8vIGNyZWF0ZSBtb3ZpZVxuXHRcdGlmIChlbGVtKSB7XG5cdFx0XHR0aGlzLmdsdWUoZWxlbSk7XG5cdFx0fVxuXHR9XG59O1xuXG5aZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHMuQ2xpZW50LnByb3RvdHlwZSA9IHtcblxuXHRpZDogMCwgLy8gdW5pcXVlIElEIGZvciB1c1xuXHRyZWFkeTogZmFsc2UsIC8vIHdoZXRoZXIgbW92aWUgaXMgcmVhZHkgdG8gcmVjZWl2ZSBldmVudHMgb3Igbm90XG5cdG1vdmllOiBudWxsLCAvLyByZWZlcmVuY2UgdG8gbW92aWUgb2JqZWN0XG5cdGNsaXBUZXh0OiAnJywgLy8gdGV4dCB0byBjb3B5IHRvIGNsaXBib2FyZFxuXHRmaWxlTmFtZTogJycsIC8vIGRlZmF1bHQgZmlsZSBzYXZlIG5hbWVcblx0YWN0aW9uOiAnY29weScsIC8vIGFjdGlvbiB0byBwZXJmb3JtXG5cdGhhbmRDdXJzb3JFbmFibGVkOiB0cnVlLCAvLyB3aGV0aGVyIHRvIHNob3cgaGFuZCBjdXJzb3IsIG9yIGRlZmF1bHQgcG9pbnRlciBjdXJzb3Jcblx0Y3NzRWZmZWN0czogdHJ1ZSwgLy8gZW5hYmxlIENTUyBtb3VzZSBlZmZlY3RzIG9uIGRvbSBjb250YWluZXJcblx0aGFuZGxlcnM6IG51bGwsIC8vIHVzZXIgZXZlbnQgaGFuZGxlcnNcblx0c2l6ZWQ6IGZhbHNlLFxuXHRzaGVldE5hbWU6ICcnLCAvLyBkZWZhdWx0IHNoZWV0IG5hbWUgZm9yIGV4Y2VsIGV4cG9ydFxuXG5cdGdsdWU6IGZ1bmN0aW9uKGVsZW0sIHRpdGxlKSB7XG5cdFx0Ly8gZ2x1ZSB0byBET00gZWxlbWVudFxuXHRcdC8vIGVsZW0gY2FuIGJlIElEIG9yIGFjdHVhbCBET00gZWxlbWVudCBvYmplY3Rcblx0XHR0aGlzLmRvbUVsZW1lbnQgPSBaZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHMuJChlbGVtKTtcblxuXHRcdC8vIGZsb2F0IGp1c3QgYWJvdmUgb2JqZWN0LCBvciB6SW5kZXggOTkgaWYgZG9tIGVsZW1lbnQgaXNuJ3Qgc2V0XG5cdFx0dmFyIHpJbmRleCA9IDk5O1xuXHRcdGlmICh0aGlzLmRvbUVsZW1lbnQuc3R5bGUuekluZGV4KSB7XG5cdFx0XHR6SW5kZXggPSBwYXJzZUludCh0aGlzLmRvbUVsZW1lbnQuc3R5bGUuekluZGV4LCAxMCkgKyAxO1xuXHRcdH1cblxuXHRcdC8vIGZpbmQgWC9ZIHBvc2l0aW9uIG9mIGRvbUVsZW1lbnRcblx0XHR2YXIgYm94ID0gWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmdldERPTU9iamVjdFBvc2l0aW9uKHRoaXMuZG9tRWxlbWVudCk7XG5cblx0XHQvLyBjcmVhdGUgZmxvYXRpbmcgRElWIGFib3ZlIGVsZW1lbnRcblx0XHR0aGlzLmRpdiA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpO1xuXHRcdHZhciBzdHlsZSA9IHRoaXMuZGl2LnN0eWxlO1xuXHRcdHN0eWxlLnBvc2l0aW9uID0gJ2Fic29sdXRlJztcblx0XHRzdHlsZS5sZWZ0ID0gJzBweCc7XG5cdFx0c3R5bGUudG9wID0gJzBweCc7XG5cdFx0c3R5bGUud2lkdGggPSAoYm94LndpZHRoKSArICdweCc7XG5cdFx0c3R5bGUuaGVpZ2h0ID0gYm94LmhlaWdodCArICdweCc7XG5cdFx0c3R5bGUuekluZGV4ID0gekluZGV4O1xuXG5cdFx0aWYgKCB0eXBlb2YgdGl0bGUgIT0gXCJ1bmRlZmluZWRcIiAmJiB0aXRsZSAhPT0gXCJcIiApIHtcblx0XHRcdHRoaXMuZGl2LnRpdGxlID0gdGl0bGU7XG5cdFx0fVxuXHRcdGlmICggYm94LndpZHRoICE9PSAwICYmIGJveC5oZWlnaHQgIT09IDAgKSB7XG5cdFx0XHR0aGlzLnNpemVkID0gdHJ1ZTtcblx0XHR9XG5cblx0XHQvLyBzdHlsZS5iYWNrZ3JvdW5kQ29sb3IgPSAnI2YwMCc7IC8vIGRlYnVnXG5cdFx0aWYgKCB0aGlzLmRvbUVsZW1lbnQgKSB7XG5cdFx0XHR0aGlzLmRvbUVsZW1lbnQuYXBwZW5kQ2hpbGQodGhpcy5kaXYpO1xuXHRcdFx0dGhpcy5kaXYuaW5uZXJIVE1MID0gdGhpcy5nZXRIVE1MKCBib3gud2lkdGgsIGJveC5oZWlnaHQgKS5yZXBsYWNlKC8mL2csICcmYW1wOycpO1xuXHRcdH1cblx0fSxcblxuXHRwb3NpdGlvbkVsZW1lbnQ6IGZ1bmN0aW9uKCkge1xuXHRcdHZhciBib3ggPSBaZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHMuZ2V0RE9NT2JqZWN0UG9zaXRpb24odGhpcy5kb21FbGVtZW50KTtcblx0XHR2YXIgc3R5bGUgPSB0aGlzLmRpdi5zdHlsZTtcblxuXHRcdHN0eWxlLnBvc2l0aW9uID0gJ2Fic29sdXRlJztcblx0XHQvL3N0eWxlLmxlZnQgPSAodGhpcy5kb21FbGVtZW50Lm9mZnNldExlZnQpKydweCc7XG5cdFx0Ly9zdHlsZS50b3AgPSB0aGlzLmRvbUVsZW1lbnQub2Zmc2V0VG9wKydweCc7XG5cdFx0c3R5bGUud2lkdGggPSBib3gud2lkdGggKyAncHgnO1xuXHRcdHN0eWxlLmhlaWdodCA9IGJveC5oZWlnaHQgKyAncHgnO1xuXG5cdFx0aWYgKCBib3gud2lkdGggIT09IDAgJiYgYm94LmhlaWdodCAhPT0gMCApIHtcblx0XHRcdHRoaXMuc2l6ZWQgPSB0cnVlO1xuXHRcdH0gZWxzZSB7XG5cdFx0XHRyZXR1cm47XG5cdFx0fVxuXG5cdFx0dmFyIGZsYXNoID0gdGhpcy5kaXYuY2hpbGROb2Rlc1swXTtcblx0XHRmbGFzaC53aWR0aCA9IGJveC53aWR0aDtcblx0XHRmbGFzaC5oZWlnaHQgPSBib3guaGVpZ2h0O1xuXHR9LFxuXG5cdGdldEhUTUw6IGZ1bmN0aW9uKHdpZHRoLCBoZWlnaHQpIHtcblx0XHQvLyByZXR1cm4gSFRNTCBmb3IgbW92aWVcblx0XHR2YXIgaHRtbCA9ICcnO1xuXHRcdHZhciBmbGFzaHZhcnMgPSAnaWQ9JyArIHRoaXMuaWQgK1xuXHRcdFx0JyZ3aWR0aD0nICsgd2lkdGggK1xuXHRcdFx0JyZoZWlnaHQ9JyArIGhlaWdodDtcblxuXHRcdGlmIChuYXZpZ2F0b3IudXNlckFnZW50Lm1hdGNoKC9NU0lFLykpIHtcblx0XHRcdC8vIElFIGdldHMgYW4gT0JKRUNUIHRhZ1xuXHRcdFx0dmFyIHByb3RvY29sID0gbG9jYXRpb24uaHJlZi5tYXRjaCgvXmh0dHBzL2kpID8gJ2h0dHBzOi8vJyA6ICdodHRwOi8vJztcblx0XHRcdGh0bWwgKz0gJzxvYmplY3QgY2xhc3NpZD1cImNsc2lkOkQyN0NEQjZFLUFFNkQtMTFjZi05NkI4LTQ0NDU1MzU0MDAwMFwiIGNvZGViYXNlPVwiJytwcm90b2NvbCsnZG93bmxvYWQubWFjcm9tZWRpYS5jb20vcHViL3Nob2Nrd2F2ZS9jYWJzL2ZsYXNoL3N3Zmxhc2guY2FiI3ZlcnNpb249MTAsMCwwLDBcIiB3aWR0aD1cIicrd2lkdGgrJ1wiIGhlaWdodD1cIicraGVpZ2h0KydcIiBpZD1cIicrdGhpcy5tb3ZpZUlkKydcIiBhbGlnbj1cIm1pZGRsZVwiPjxwYXJhbSBuYW1lPVwiYWxsb3dTY3JpcHRBY2Nlc3NcIiB2YWx1ZT1cImFsd2F5c1wiIC8+PHBhcmFtIG5hbWU9XCJhbGxvd0Z1bGxTY3JlZW5cIiB2YWx1ZT1cImZhbHNlXCIgLz48cGFyYW0gbmFtZT1cIm1vdmllXCIgdmFsdWU9XCInK1plcm9DbGlwYm9hcmRfVGFibGVUb29scy5tb3ZpZVBhdGgrJ1wiIC8+PHBhcmFtIG5hbWU9XCJsb29wXCIgdmFsdWU9XCJmYWxzZVwiIC8+PHBhcmFtIG5hbWU9XCJtZW51XCIgdmFsdWU9XCJmYWxzZVwiIC8+PHBhcmFtIG5hbWU9XCJxdWFsaXR5XCIgdmFsdWU9XCJiZXN0XCIgLz48cGFyYW0gbmFtZT1cImJnY29sb3JcIiB2YWx1ZT1cIiNmZmZmZmZcIiAvPjxwYXJhbSBuYW1lPVwiZmxhc2h2YXJzXCIgdmFsdWU9XCInK2ZsYXNodmFycysnXCIvPjxwYXJhbSBuYW1lPVwid21vZGVcIiB2YWx1ZT1cInRyYW5zcGFyZW50XCIvPjwvb2JqZWN0Pic7XG5cdFx0fVxuXHRcdGVsc2Uge1xuXHRcdFx0Ly8gYWxsIG90aGVyIGJyb3dzZXJzIGdldCBhbiBFTUJFRCB0YWdcblx0XHRcdGh0bWwgKz0gJzxlbWJlZCBpZD1cIicrdGhpcy5tb3ZpZUlkKydcIiBzcmM9XCInK1plcm9DbGlwYm9hcmRfVGFibGVUb29scy5tb3ZpZVBhdGgrJ1wiIGxvb3A9XCJmYWxzZVwiIG1lbnU9XCJmYWxzZVwiIHF1YWxpdHk9XCJiZXN0XCIgYmdjb2xvcj1cIiNmZmZmZmZcIiB3aWR0aD1cIicrd2lkdGgrJ1wiIGhlaWdodD1cIicraGVpZ2h0KydcIiBuYW1lPVwiJyt0aGlzLm1vdmllSWQrJ1wiIGFsaWduPVwibWlkZGxlXCIgYWxsb3dTY3JpcHRBY2Nlc3M9XCJhbHdheXNcIiBhbGxvd0Z1bGxTY3JlZW49XCJmYWxzZVwiIHR5cGU9XCJhcHBsaWNhdGlvbi94LXNob2Nrd2F2ZS1mbGFzaFwiIHBsdWdpbnNwYWdlPVwiaHR0cDovL3d3dy5tYWNyb21lZGlhLmNvbS9nby9nZXRmbGFzaHBsYXllclwiIGZsYXNodmFycz1cIicrZmxhc2h2YXJzKydcIiB3bW9kZT1cInRyYW5zcGFyZW50XCIgLz4nO1xuXHRcdH1cblx0XHRyZXR1cm4gaHRtbDtcblx0fSxcblxuXHRoaWRlOiBmdW5jdGlvbigpIHtcblx0XHQvLyB0ZW1wb3JhcmlseSBoaWRlIGZsb2F0ZXIgb2Zmc2NyZWVuXG5cdFx0aWYgKHRoaXMuZGl2KSB7XG5cdFx0XHR0aGlzLmRpdi5zdHlsZS5sZWZ0ID0gJy0yMDAwcHgnO1xuXHRcdH1cblx0fSxcblxuXHRzaG93OiBmdW5jdGlvbigpIHtcblx0XHQvLyBzaG93IG91cnNlbHZlcyBhZnRlciBhIGNhbGwgdG8gaGlkZSgpXG5cdFx0dGhpcy5yZXBvc2l0aW9uKCk7XG5cdH0sXG5cblx0ZGVzdHJveTogZnVuY3Rpb24oKSB7XG5cdFx0Ly8gZGVzdHJveSBjb250cm9sIGFuZCBmbG9hdGVyXG5cdFx0dmFyIHRoYXQgPSB0aGlzO1xuXG5cdFx0aWYgKHRoaXMuZG9tRWxlbWVudCAmJiB0aGlzLmRpdikge1xuXHRcdFx0JCh0aGlzLmRpdikucmVtb3ZlKCk7XG5cblx0XHRcdHRoaXMuZG9tRWxlbWVudCA9IG51bGw7XG5cdFx0XHR0aGlzLmRpdiA9IG51bGw7XG5cblx0XHRcdCQuZWFjaCggWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmNsaWVudHMsIGZ1bmN0aW9uICggaWQsIGNsaWVudCApIHtcblx0XHRcdFx0aWYgKCBjbGllbnQgPT09IHRoYXQgKSB7XG5cdFx0XHRcdFx0ZGVsZXRlIFplcm9DbGlwYm9hcmRfVGFibGVUb29scy5jbGllbnRzWyBpZCBdO1xuXHRcdFx0XHR9XG5cdFx0XHR9ICk7XG5cdFx0fVxuXHR9LFxuXG5cdHJlcG9zaXRpb246IGZ1bmN0aW9uKGVsZW0pIHtcblx0XHQvLyByZXBvc2l0aW9uIG91ciBmbG9hdGluZyBkaXYsIG9wdGlvbmFsbHkgdG8gbmV3IGNvbnRhaW5lclxuXHRcdC8vIHdhcm5pbmc6IGNvbnRhaW5lciBDQU5OT1QgY2hhbmdlIHNpemUsIG9ubHkgcG9zaXRpb25cblx0XHRpZiAoZWxlbSkge1xuXHRcdFx0dGhpcy5kb21FbGVtZW50ID0gWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLiQoZWxlbSk7XG5cdFx0XHRpZiAoIXRoaXMuZG9tRWxlbWVudCkge1xuXHRcdFx0XHR0aGlzLmhpZGUoKTtcblx0XHRcdH1cblx0XHR9XG5cblx0XHRpZiAodGhpcy5kb21FbGVtZW50ICYmIHRoaXMuZGl2KSB7XG5cdFx0XHR2YXIgYm94ID0gWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmdldERPTU9iamVjdFBvc2l0aW9uKHRoaXMuZG9tRWxlbWVudCk7XG5cdFx0XHR2YXIgc3R5bGUgPSB0aGlzLmRpdi5zdHlsZTtcblx0XHRcdHN0eWxlLmxlZnQgPSAnJyArIGJveC5sZWZ0ICsgJ3B4Jztcblx0XHRcdHN0eWxlLnRvcCA9ICcnICsgYm94LnRvcCArICdweCc7XG5cdFx0fVxuXHR9LFxuXG5cdGNsZWFyVGV4dDogZnVuY3Rpb24oKSB7XG5cdFx0Ly8gY2xlYXIgdGhlIHRleHQgdG8gYmUgY29weSAvIHNhdmVkXG5cdFx0dGhpcy5jbGlwVGV4dCA9ICcnO1xuXHRcdGlmICh0aGlzLnJlYWR5KSB7XG5cdFx0XHR0aGlzLm1vdmllLmNsZWFyVGV4dCgpO1xuXHRcdH1cblx0fSxcblxuXHRhcHBlbmRUZXh0OiBmdW5jdGlvbihuZXdUZXh0KSB7XG5cdFx0Ly8gYXBwZW5kIHRleHQgdG8gdGhhdCB3aGljaCBpcyB0byBiZSBjb3BpZWQgLyBzYXZlZFxuXHRcdHRoaXMuY2xpcFRleHQgKz0gbmV3VGV4dDtcblx0XHRpZiAodGhpcy5yZWFkeSkgeyB0aGlzLm1vdmllLmFwcGVuZFRleHQobmV3VGV4dCkgO31cblx0fSxcblxuXHRzZXRUZXh0OiBmdW5jdGlvbihuZXdUZXh0KSB7XG5cdFx0Ly8gc2V0IHRleHQgdG8gYmUgY29waWVkIHRvIGJlIGNvcGllZCAvIHNhdmVkXG5cdFx0dGhpcy5jbGlwVGV4dCA9IG5ld1RleHQ7XG5cdFx0aWYgKHRoaXMucmVhZHkpIHsgdGhpcy5tb3ZpZS5zZXRUZXh0KG5ld1RleHQpIDt9XG5cdH0sXG5cblx0c2V0RmlsZU5hbWU6IGZ1bmN0aW9uKG5ld1RleHQpIHtcblx0XHQvLyBzZXQgdGhlIGZpbGUgbmFtZVxuXHRcdHRoaXMuZmlsZU5hbWUgPSBuZXdUZXh0O1xuXHRcdGlmICh0aGlzLnJlYWR5KSB7XG5cdFx0XHR0aGlzLm1vdmllLnNldEZpbGVOYW1lKG5ld1RleHQpO1xuXHRcdH1cblx0fSxcblxuXHRzZXRTaGVldERhdGE6IGZ1bmN0aW9uKGRhdGEpIHtcblx0XHQvLyBzZXQgdGhlIHhsc3ggc2hlZXQgZGF0YVxuXHRcdGlmICh0aGlzLnJlYWR5KSB7XG5cdFx0XHR0aGlzLm1vdmllLnNldFNoZWV0RGF0YSggSlNPTi5zdHJpbmdpZnkoIGRhdGEgKSApO1xuXHRcdH1cblx0fSxcblxuXHRzZXRBY3Rpb246IGZ1bmN0aW9uKG5ld1RleHQpIHtcblx0XHQvLyBzZXQgYWN0aW9uIChzYXZlIG9yIGNvcHkpXG5cdFx0dGhpcy5hY3Rpb24gPSBuZXdUZXh0O1xuXHRcdGlmICh0aGlzLnJlYWR5KSB7XG5cdFx0XHR0aGlzLm1vdmllLnNldEFjdGlvbihuZXdUZXh0KTtcblx0XHR9XG5cdH0sXG5cblx0YWRkRXZlbnRMaXN0ZW5lcjogZnVuY3Rpb24oZXZlbnROYW1lLCBmdW5jKSB7XG5cdFx0Ly8gYWRkIHVzZXIgZXZlbnQgbGlzdGVuZXIgZm9yIGV2ZW50XG5cdFx0Ly8gZXZlbnQgdHlwZXM6IGxvYWQsIHF1ZXVlU3RhcnQsIGZpbGVTdGFydCwgZmlsZUNvbXBsZXRlLCBxdWV1ZUNvbXBsZXRlLCBwcm9ncmVzcywgZXJyb3IsIGNhbmNlbFxuXHRcdGV2ZW50TmFtZSA9IGV2ZW50TmFtZS50b1N0cmluZygpLnRvTG93ZXJDYXNlKCkucmVwbGFjZSgvXm9uLywgJycpO1xuXHRcdGlmICghdGhpcy5oYW5kbGVyc1tldmVudE5hbWVdKSB7XG5cdFx0XHR0aGlzLmhhbmRsZXJzW2V2ZW50TmFtZV0gPSBbXTtcblx0XHR9XG5cdFx0dGhpcy5oYW5kbGVyc1tldmVudE5hbWVdLnB1c2goZnVuYyk7XG5cdH0sXG5cblx0c2V0SGFuZEN1cnNvcjogZnVuY3Rpb24oZW5hYmxlZCkge1xuXHRcdC8vIGVuYWJsZSBoYW5kIGN1cnNvciAodHJ1ZSksIG9yIGRlZmF1bHQgYXJyb3cgY3Vyc29yIChmYWxzZSlcblx0XHR0aGlzLmhhbmRDdXJzb3JFbmFibGVkID0gZW5hYmxlZDtcblx0XHRpZiAodGhpcy5yZWFkeSkge1xuXHRcdFx0dGhpcy5tb3ZpZS5zZXRIYW5kQ3Vyc29yKGVuYWJsZWQpO1xuXHRcdH1cblx0fSxcblxuXHRzZXRDU1NFZmZlY3RzOiBmdW5jdGlvbihlbmFibGVkKSB7XG5cdFx0Ly8gZW5hYmxlIG9yIGRpc2FibGUgQ1NTIGVmZmVjdHMgb24gRE9NIGNvbnRhaW5lclxuXHRcdHRoaXMuY3NzRWZmZWN0cyA9ICEhZW5hYmxlZDtcblx0fSxcblxuXHRyZWNlaXZlRXZlbnQ6IGZ1bmN0aW9uKGV2ZW50TmFtZSwgYXJncykge1xuXHRcdHZhciBzZWxmO1xuXG5cdFx0Ly8gcmVjZWl2ZSBldmVudCBmcm9tIGZsYXNoXG5cdFx0ZXZlbnROYW1lID0gZXZlbnROYW1lLnRvU3RyaW5nKCkudG9Mb3dlckNhc2UoKS5yZXBsYWNlKC9eb24vLCAnJyk7XG5cblx0XHQvLyBzcGVjaWFsIGJlaGF2aW9yIGZvciBjZXJ0YWluIGV2ZW50c1xuXHRcdHN3aXRjaCAoZXZlbnROYW1lKSB7XG5cdFx0XHRjYXNlICdsb2FkJzpcblx0XHRcdFx0Ly8gbW92aWUgY2xhaW1zIGl0IGlzIHJlYWR5LCBidXQgaW4gSUUgdGhpcyBpc24ndCBhbHdheXMgdGhlIGNhc2UuLi5cblx0XHRcdFx0Ly8gYnVnIGZpeDogQ2Fubm90IGV4dGVuZCBFTUJFRCBET00gZWxlbWVudHMgaW4gRmlyZWZveCwgbXVzdCB1c2UgdHJhZGl0aW9uYWwgZnVuY3Rpb25cblx0XHRcdFx0dGhpcy5tb3ZpZSA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKHRoaXMubW92aWVJZCk7XG5cdFx0XHRcdGlmICghdGhpcy5tb3ZpZSkge1xuXHRcdFx0XHRcdHNlbGYgPSB0aGlzO1xuXHRcdFx0XHRcdHNldFRpbWVvdXQoIGZ1bmN0aW9uKCkgeyBzZWxmLnJlY2VpdmVFdmVudCgnbG9hZCcsIG51bGwpOyB9LCAxICk7XG5cdFx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0XHR9XG5cblx0XHRcdFx0Ly8gZmlyZWZveCBvbiBwYyBuZWVkcyBhIFwia2lja1wiIGluIG9yZGVyIHRvIHNldCB0aGVzZSBpbiBjZXJ0YWluIGNhc2VzXG5cdFx0XHRcdGlmICghdGhpcy5yZWFkeSAmJiBuYXZpZ2F0b3IudXNlckFnZW50Lm1hdGNoKC9GaXJlZm94LykgJiYgbmF2aWdhdG9yLnVzZXJBZ2VudC5tYXRjaCgvV2luZG93cy8pKSB7XG5cdFx0XHRcdFx0c2VsZiA9IHRoaXM7XG5cdFx0XHRcdFx0c2V0VGltZW91dCggZnVuY3Rpb24oKSB7IHNlbGYucmVjZWl2ZUV2ZW50KCdsb2FkJywgbnVsbCk7IH0sIDEwMCApO1xuXHRcdFx0XHRcdHRoaXMucmVhZHkgPSB0cnVlO1xuXHRcdFx0XHRcdHJldHVybjtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdHRoaXMucmVhZHkgPSB0cnVlO1xuXHRcdFx0XHR0aGlzLm1vdmllLmNsZWFyVGV4dCgpO1xuXHRcdFx0XHR0aGlzLm1vdmllLmFwcGVuZFRleHQoIHRoaXMuY2xpcFRleHQgKTtcblx0XHRcdFx0dGhpcy5tb3ZpZS5zZXRGaWxlTmFtZSggdGhpcy5maWxlTmFtZSApO1xuXHRcdFx0XHR0aGlzLm1vdmllLnNldEFjdGlvbiggdGhpcy5hY3Rpb24gKTtcblx0XHRcdFx0dGhpcy5tb3ZpZS5zZXRIYW5kQ3Vyc29yKCB0aGlzLmhhbmRDdXJzb3JFbmFibGVkICk7XG5cdFx0XHRcdGJyZWFrO1xuXG5cdFx0XHRjYXNlICdtb3VzZW92ZXInOlxuXHRcdFx0XHRpZiAodGhpcy5kb21FbGVtZW50ICYmIHRoaXMuY3NzRWZmZWN0cykge1xuXHRcdFx0XHRcdC8vdGhpcy5kb21FbGVtZW50LmFkZENsYXNzKCdob3ZlcicpO1xuXHRcdFx0XHRcdGlmICh0aGlzLnJlY292ZXJBY3RpdmUpIHtcblx0XHRcdFx0XHRcdHRoaXMuZG9tRWxlbWVudC5hZGRDbGFzcygnYWN0aXZlJyk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9XG5cdFx0XHRcdGJyZWFrO1xuXG5cdFx0XHRjYXNlICdtb3VzZW91dCc6XG5cdFx0XHRcdGlmICh0aGlzLmRvbUVsZW1lbnQgJiYgdGhpcy5jc3NFZmZlY3RzKSB7XG5cdFx0XHRcdFx0dGhpcy5yZWNvdmVyQWN0aXZlID0gZmFsc2U7XG5cdFx0XHRcdFx0aWYgKHRoaXMuZG9tRWxlbWVudC5oYXNDbGFzcygnYWN0aXZlJykpIHtcblx0XHRcdFx0XHRcdHRoaXMuZG9tRWxlbWVudC5yZW1vdmVDbGFzcygnYWN0aXZlJyk7XG5cdFx0XHRcdFx0XHR0aGlzLnJlY292ZXJBY3RpdmUgPSB0cnVlO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0XHQvL3RoaXMuZG9tRWxlbWVudC5yZW1vdmVDbGFzcygnaG92ZXInKTtcblx0XHRcdFx0fVxuXHRcdFx0XHRicmVhaztcblxuXHRcdFx0Y2FzZSAnbW91c2Vkb3duJzpcblx0XHRcdFx0aWYgKHRoaXMuZG9tRWxlbWVudCAmJiB0aGlzLmNzc0VmZmVjdHMpIHtcblx0XHRcdFx0XHR0aGlzLmRvbUVsZW1lbnQuYWRkQ2xhc3MoJ2FjdGl2ZScpO1xuXHRcdFx0XHR9XG5cdFx0XHRcdGJyZWFrO1xuXG5cdFx0XHRjYXNlICdtb3VzZXVwJzpcblx0XHRcdFx0aWYgKHRoaXMuZG9tRWxlbWVudCAmJiB0aGlzLmNzc0VmZmVjdHMpIHtcblx0XHRcdFx0XHR0aGlzLmRvbUVsZW1lbnQucmVtb3ZlQ2xhc3MoJ2FjdGl2ZScpO1xuXHRcdFx0XHRcdHRoaXMucmVjb3ZlckFjdGl2ZSA9IGZhbHNlO1xuXHRcdFx0XHR9XG5cdFx0XHRcdGJyZWFrO1xuXHRcdH0gLy8gc3dpdGNoIGV2ZW50TmFtZVxuXG5cdFx0aWYgKHRoaXMuaGFuZGxlcnNbZXZlbnROYW1lXSkge1xuXHRcdFx0Zm9yICh2YXIgaWR4ID0gMCwgbGVuID0gdGhpcy5oYW5kbGVyc1tldmVudE5hbWVdLmxlbmd0aDsgaWR4IDwgbGVuOyBpZHgrKykge1xuXHRcdFx0XHR2YXIgZnVuYyA9IHRoaXMuaGFuZGxlcnNbZXZlbnROYW1lXVtpZHhdO1xuXG5cdFx0XHRcdGlmICh0eXBlb2YoZnVuYykgPT0gJ2Z1bmN0aW9uJykge1xuXHRcdFx0XHRcdC8vIGFjdHVhbCBmdW5jdGlvbiByZWZlcmVuY2Vcblx0XHRcdFx0XHRmdW5jKHRoaXMsIGFyZ3MpO1xuXHRcdFx0XHR9XG5cdFx0XHRcdGVsc2UgaWYgKCh0eXBlb2YoZnVuYykgPT0gJ29iamVjdCcpICYmIChmdW5jLmxlbmd0aCA9PSAyKSkge1xuXHRcdFx0XHRcdC8vIFBIUCBzdHlsZSBvYmplY3QgKyBtZXRob2QsIGkuZS4gW215T2JqZWN0LCAnbXlNZXRob2QnXVxuXHRcdFx0XHRcdGZ1bmNbMF1bIGZ1bmNbMV0gXSh0aGlzLCBhcmdzKTtcblx0XHRcdFx0fVxuXHRcdFx0XHRlbHNlIGlmICh0eXBlb2YoZnVuYykgPT0gJ3N0cmluZycpIHtcblx0XHRcdFx0XHQvLyBuYW1lIG9mIGZ1bmN0aW9uXG5cdFx0XHRcdFx0d2luZG93W2Z1bmNdKHRoaXMsIGFyZ3MpO1xuXHRcdFx0XHR9XG5cdFx0XHR9IC8vIGZvcmVhY2ggZXZlbnQgaGFuZGxlciBkZWZpbmVkXG5cdFx0fSAvLyB1c2VyIGRlZmluZWQgaGFuZGxlciBmb3IgZXZlbnRcblx0fVxufTtcblxuWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmhhc0ZsYXNoID0gZnVuY3Rpb24gKClcbntcblx0dHJ5IHtcblx0XHR2YXIgZm8gPSBuZXcgQWN0aXZlWE9iamVjdCgnU2hvY2t3YXZlRmxhc2guU2hvY2t3YXZlRmxhc2gnKTtcblx0XHRpZiAoZm8pIHtcblx0XHRcdHJldHVybiB0cnVlO1xuXHRcdH1cblx0fVxuXHRjYXRjaCAoZSkge1xuXHRcdGlmIChcblx0XHRcdG5hdmlnYXRvci5taW1lVHlwZXMgJiZcblx0XHRcdG5hdmlnYXRvci5taW1lVHlwZXNbJ2FwcGxpY2F0aW9uL3gtc2hvY2t3YXZlLWZsYXNoJ10gIT09IHVuZGVmaW5lZCAmJlxuXHRcdFx0bmF2aWdhdG9yLm1pbWVUeXBlc1snYXBwbGljYXRpb24veC1zaG9ja3dhdmUtZmxhc2gnXS5lbmFibGVkUGx1Z2luXG5cdFx0KSB7XG5cdFx0XHRyZXR1cm4gdHJ1ZTtcblx0XHR9XG5cdH1cblxuXHRyZXR1cm4gZmFsc2U7XG59O1xuXG4vLyBGb3IgdGhlIEZsYXNoIGJpbmRpbmcgdG8gd29yaywgWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzIG11c3QgYmUgb24gdGhlIGdsb2JhbFxuLy8gb2JqZWN0IGxpc3RcbndpbmRvdy5aZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHMgPSBaZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHM7XG5cblxuXG4vKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICpcbiAqIExvY2FsIChwcml2YXRlKSBmdW5jdGlvbnNcbiAqL1xuXG4vKipcbiAqIElmIGEgQnV0dG9ucyBpbnN0YW5jZSBpcyBpbml0bGFpc2VkIGJlZm9yZSBpdCBpcyBwbGFjZWQgaW50byB0aGUgRE9NLCBGbGFzaFxuICogd29uJ3QgYmUgYWJsZSB0byBiaW5kIHRvIGl0LCBzbyB3ZSBuZWVkIHRvIHdhaXQgdW50aWwgaXQgaXMgYXZhaWxhYmxlLCB0aGlzXG4gKiBtZXRob2QgYWJzdHJhY3RzIHRoYXQgb3V0LlxuICpcbiAqIEBwYXJhbSB7WmVyb0NsaXBib2FyZH0gZmxhc2ggWmVyb0NsaXBib2FyZCBpbnN0YW5jZVxuICogQHBhcmFtIHtqUXVlcnl9IG5vZGUgIEJ1dHRvblxuICovXG52YXIgX2dsdWUgPSBmdW5jdGlvbiAoIGZsYXNoLCBub2RlIClcbntcblx0dmFyIGlkID0gbm9kZS5hdHRyKCdpZCcpO1xuXG5cdGlmICggbm9kZS5wYXJlbnRzKCdodG1sJykubGVuZ3RoICkge1xuXHRcdGZsYXNoLmdsdWUoIG5vZGVbMF0sICcnICk7XG5cdH1cblx0ZWxzZSB7XG5cdFx0c2V0VGltZW91dCggZnVuY3Rpb24gKCkge1xuXHRcdFx0X2dsdWUoIGZsYXNoLCBub2RlICk7XG5cdFx0fSwgNTAwICk7XG5cdH1cbn07XG5cbi8qKlxuICogR2V0IHRoZSBmaWxlIG5hbWUgZm9yIGFuIGV4cG9ydGVkIGZpbGUuXG4gKlxuICogQHBhcmFtIHtvYmplY3R9ICBjb25maWcgICAgICAgQnV0dG9uIGNvbmZpZ3VyYXRpb25cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gaW5jRXh0ZW5zaW9uIEluY2x1ZGUgdGhlIGZpbGUgbmFtZSBleHRlbnNpb25cbiAqL1xudmFyIF9maWxlbmFtZSA9IGZ1bmN0aW9uICggY29uZmlnLCBpbmNFeHRlbnNpb24gKVxue1xuXHQvLyBCYWNrd2FyZHMgY29tcGF0aWJpbGl0eVxuXHR2YXIgZmlsZW5hbWUgPSBjb25maWcuZmlsZW5hbWUgPT09ICcqJyAmJiBjb25maWcudGl0bGUgIT09ICcqJyAmJiBjb25maWcudGl0bGUgIT09IHVuZGVmaW5lZCA/XG5cdFx0Y29uZmlnLnRpdGxlIDpcblx0XHRjb25maWcuZmlsZW5hbWU7XG5cblx0aWYgKCB0eXBlb2YgZmlsZW5hbWUgPT09ICdmdW5jdGlvbicgKSB7XG5cdFx0ZmlsZW5hbWUgPSBmaWxlbmFtZSgpO1xuXHR9XG5cblx0aWYgKCBmaWxlbmFtZS5pbmRleE9mKCAnKicgKSAhPT0gLTEgKSB7XG5cdFx0ZmlsZW5hbWUgPSAkLnRyaW0oIGZpbGVuYW1lLnJlcGxhY2UoICcqJywgJCgndGl0bGUnKS50ZXh0KCkgKSApO1xuXHR9XG5cblx0Ly8gU3RyaXAgY2hhcmFjdGVycyB3aGljaCB0aGUgT1Mgd2lsbCBvYmplY3QgdG9cblx0ZmlsZW5hbWUgPSBmaWxlbmFtZS5yZXBsYWNlKC9bXmEtekEtWjAtOV9cXHUwMEExLVxcdUZGRkZcXC4sXFwtXyAhXFwoXFwpXS9nLCBcIlwiKTtcblxuXHRyZXR1cm4gaW5jRXh0ZW5zaW9uID09PSB1bmRlZmluZWQgfHwgaW5jRXh0ZW5zaW9uID09PSB0cnVlID9cblx0XHRmaWxlbmFtZStjb25maWcuZXh0ZW5zaW9uIDpcblx0XHRmaWxlbmFtZTtcbn07XG5cbi8qKlxuICogR2V0IHRoZSBzaGVldCBuYW1lIGZvciBFeGNlbCBleHBvcnRzLlxuICpcbiAqIEBwYXJhbSB7b2JqZWN0fSAgY29uZmlnICAgICAgIEJ1dHRvbiBjb25maWd1cmF0aW9uXG4gKi9cbnZhciBfc2hlZXRuYW1lID0gZnVuY3Rpb24gKCBjb25maWcgKVxue1xuXHR2YXIgc2hlZXROYW1lID0gJ1NoZWV0MSc7XG5cblx0aWYgKCBjb25maWcuc2hlZXROYW1lICkge1xuXHRcdHNoZWV0TmFtZSA9IGNvbmZpZy5zaGVldE5hbWUucmVwbGFjZSgvW1xcW1xcXVxcKlxcL1xcXFxcXD9cXDpdL2csICcnKTtcblx0fVxuXG5cdHJldHVybiBzaGVldE5hbWU7XG59O1xuXG4vKipcbiAqIEdldCB0aGUgdGl0bGUgZm9yIGFuIGV4cG9ydGVkIGZpbGUuXG4gKlxuICogQHBhcmFtIHtvYmplY3R9ICBjb25maWcgIEJ1dHRvbiBjb25maWd1cmF0aW9uXG4gKi9cbnZhciBfdGl0bGUgPSBmdW5jdGlvbiAoIGNvbmZpZyApXG57XG5cdHZhciB0aXRsZSA9IGNvbmZpZy50aXRsZTtcblxuXHRpZiAoIHR5cGVvZiB0aXRsZSA9PT0gJ2Z1bmN0aW9uJyApIHtcblx0XHR0aXRsZSA9IHRpdGxlKCk7XG5cdH1cblxuXHRyZXR1cm4gdGl0bGUuaW5kZXhPZiggJyonICkgIT09IC0xID9cblx0XHR0aXRsZS5yZXBsYWNlKCAnKicsICQoJ3RpdGxlJykudGV4dCgpIHx8ICdFeHBvcnRlZCBkYXRhJyApIDpcblx0XHR0aXRsZTtcbn07XG5cbi8qKlxuICogU2V0IHRoZSBmbGFzaCB0ZXh0LiBUaGlzIGhhcyB0byBiZSBicm9rZW4gdXAgaW50byBjaHVua3MgYXMgdGhlIEphdmFzY3JpcHQgL1xuICogRmxhc2ggYnJpZGdlIGhhcyBhIHNpemUgbGltaXQuIFRoZXJlIGlzIG5vIGluZGljYXRpb24gaW4gdGhlIEZsYXNoXG4gKiBkb2N1bWVudGF0aW9uIHdoYXQgdGhpcyBpcywgYW5kIGl0IHByb2JhYmx5IGRlcGVuZHMgdXBvbiB0aGUgYnJvd3Nlci5cbiAqIEV4cGVyaW1lbnRhdGlvbiBzaG93cyB0aGF0IHRoZSBwb2ludCBpcyBhcm91bmQgNTBrIHdoZW4gZGF0YSBzdGFydHMgdG8gZ2V0XG4gKiBsb3N0LCBzbyBhbiA4SyBsaW1pdCB1c2VkIGhlcmUgaXMgc2FmZS5cbiAqXG4gKiBAcGFyYW0ge1plcm9DbGlwYm9hcmR9IGZsYXNoIFplcm9DbGlwYm9hcmQgaW5zdGFuY2VcbiAqIEBwYXJhbSB7c3RyaW5nfSAgICAgICAgZGF0YSAgRGF0YSB0byBzZW5kIHRvIEZsYXNoXG4gKi9cbnZhciBfc2V0VGV4dCA9IGZ1bmN0aW9uICggZmxhc2gsIGRhdGEgKVxue1xuXHR2YXIgcGFydHMgPSBkYXRhLm1hdGNoKC9bXFxzXFxTXXsxLDgxOTJ9L2cpIHx8IFtdO1xuXG5cdGZsYXNoLmNsZWFyVGV4dCgpO1xuXHRmb3IgKCB2YXIgaT0wLCBsZW49cGFydHMubGVuZ3RoIDsgaTxsZW4gOyBpKysgKVxuXHR7XG5cdFx0Zmxhc2guYXBwZW5kVGV4dCggcGFydHNbaV0gKTtcblx0fVxufTtcblxuLyoqXG4gKiBHZXQgdGhlIG5ld2xpbmUgY2hhcmFjdGVyKHMpXG4gKlxuICogQHBhcmFtIHtvYmplY3R9ICBjb25maWcgQnV0dG9uIGNvbmZpZ3VyYXRpb25cbiAqIEByZXR1cm4ge3N0cmluZ30gICAgICAgIE5ld2xpbmUgY2hhcmFjdGVyXG4gKi9cbnZhciBfbmV3TGluZSA9IGZ1bmN0aW9uICggY29uZmlnIClcbntcblx0cmV0dXJuIGNvbmZpZy5uZXdsaW5lID9cblx0XHRjb25maWcubmV3bGluZSA6XG5cdFx0bmF2aWdhdG9yLnVzZXJBZ2VudC5tYXRjaCgvV2luZG93cy8pID9cblx0XHRcdCdcXHJcXG4nIDpcblx0XHRcdCdcXG4nO1xufTtcblxuLyoqXG4gKiBDb21iaW5lIHRoZSBkYXRhIGZyb20gdGhlIGBidXR0b25zLmV4cG9ydERhdGFgIG1ldGhvZCBpbnRvIGEgc3RyaW5nIHRoYXRcbiAqIHdpbGwgYmUgdXNlZCBpbiB0aGUgZXhwb3J0IGZpbGUuXG4gKlxuICogQHBhcmFtICB7RGF0YVRhYmxlLkFwaX0gZHQgICAgIERhdGFUYWJsZXMgQVBJIGluc3RhbmNlXG4gKiBAcGFyYW0gIHtvYmplY3R9ICAgICAgICBjb25maWcgQnV0dG9uIGNvbmZpZ3VyYXRpb25cbiAqIEByZXR1cm4ge29iamVjdH0gICAgICAgICAgICAgICBUaGUgZGF0YSB0byBleHBvcnRcbiAqL1xudmFyIF9leHBvcnREYXRhID0gZnVuY3Rpb24gKCBkdCwgY29uZmlnIClcbntcblx0dmFyIG5ld0xpbmUgPSBfbmV3TGluZSggY29uZmlnICk7XG5cdHZhciBkYXRhID0gZHQuYnV0dG9ucy5leHBvcnREYXRhKCBjb25maWcuZXhwb3J0T3B0aW9ucyApO1xuXHR2YXIgYm91bmRhcnkgPSBjb25maWcuZmllbGRCb3VuZGFyeTtcblx0dmFyIHNlcGFyYXRvciA9IGNvbmZpZy5maWVsZFNlcGFyYXRvcjtcblx0dmFyIHJlQm91bmRhcnkgPSBuZXcgUmVnRXhwKCBib3VuZGFyeSwgJ2cnICk7XG5cdHZhciBlc2NhcGVDaGFyID0gY29uZmlnLmVzY2FwZUNoYXIgIT09IHVuZGVmaW5lZCA/XG5cdFx0Y29uZmlnLmVzY2FwZUNoYXIgOlxuXHRcdCdcXFxcJztcblx0dmFyIGpvaW4gPSBmdW5jdGlvbiAoIGEgKSB7XG5cdFx0dmFyIHMgPSAnJztcblxuXHRcdC8vIElmIHRoZXJlIGlzIGEgZmllbGQgYm91bmRhcnksIHRoZW4gd2UgbWlnaHQgbmVlZCB0byBlc2NhcGUgaXQgaW5cblx0XHQvLyB0aGUgc291cmNlIGRhdGFcblx0XHRmb3IgKCB2YXIgaT0wLCBpZW49YS5sZW5ndGggOyBpPGllbiA7IGkrKyApIHtcblx0XHRcdGlmICggaSA+IDAgKSB7XG5cdFx0XHRcdHMgKz0gc2VwYXJhdG9yO1xuXHRcdFx0fVxuXG5cdFx0XHRzICs9IGJvdW5kYXJ5ID9cblx0XHRcdFx0Ym91bmRhcnkgKyAoJycgKyBhW2ldKS5yZXBsYWNlKCByZUJvdW5kYXJ5LCBlc2NhcGVDaGFyK2JvdW5kYXJ5ICkgKyBib3VuZGFyeSA6XG5cdFx0XHRcdGFbaV07XG5cdFx0fVxuXG5cdFx0cmV0dXJuIHM7XG5cdH07XG5cblx0dmFyIGhlYWRlciA9IGNvbmZpZy5oZWFkZXIgPyBqb2luKCBkYXRhLmhlYWRlciApK25ld0xpbmUgOiAnJztcblx0dmFyIGZvb3RlciA9IGNvbmZpZy5mb290ZXIgJiYgZGF0YS5mb290ZXIgPyBuZXdMaW5lK2pvaW4oIGRhdGEuZm9vdGVyICkgOiAnJztcblx0dmFyIGJvZHkgPSBbXTtcblxuXHRmb3IgKCB2YXIgaT0wLCBpZW49ZGF0YS5ib2R5Lmxlbmd0aCA7IGk8aWVuIDsgaSsrICkge1xuXHRcdGJvZHkucHVzaCggam9pbiggZGF0YS5ib2R5W2ldICkgKTtcblx0fVxuXG5cdHJldHVybiB7XG5cdFx0c3RyOiBoZWFkZXIgKyBib2R5LmpvaW4oIG5ld0xpbmUgKSArIGZvb3Rlcixcblx0XHRyb3dzOiBib2R5Lmxlbmd0aFxuXHR9O1xufTtcblxuXG4vLyBCYXNpYyBpbml0aWFsaXNhdGlvbiBmb3IgdGhlIGJ1dHRvbnMgaXMgY29tbW9uIGJldHdlZW4gdGhlbVxudmFyIGZsYXNoQnV0dG9uID0ge1xuXHRhdmFpbGFibGU6IGZ1bmN0aW9uICgpIHtcblx0XHRyZXR1cm4gWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmhhc0ZsYXNoKCk7XG5cdH0sXG5cblx0aW5pdDogZnVuY3Rpb24gKCBkdCwgYnV0dG9uLCBjb25maWcgKSB7XG5cdFx0Ly8gSW5zZXJ0IHRoZSBGbGFzaCBtb3ZpZVxuXHRcdFplcm9DbGlwYm9hcmRfVGFibGVUb29scy5tb3ZpZVBhdGggPSBEYXRhVGFibGUuQnV0dG9ucy5zd2ZQYXRoO1xuXHRcdHZhciBmbGFzaCA9IG5ldyBaZXJvQ2xpcGJvYXJkX1RhYmxlVG9vbHMuQ2xpZW50KCk7XG5cblx0XHRmbGFzaC5zZXRIYW5kQ3Vyc29yKCB0cnVlICk7XG5cdFx0Zmxhc2guYWRkRXZlbnRMaXN0ZW5lcignbW91c2VEb3duJywgZnVuY3Rpb24oY2xpZW50KSB7XG5cdFx0XHRjb25maWcuX2Zyb21GbGFzaCA9IHRydWU7XG5cdFx0XHRkdC5idXR0b24oIGJ1dHRvblswXSApLnRyaWdnZXIoKTtcblx0XHRcdGNvbmZpZy5fZnJvbUZsYXNoID0gZmFsc2U7XG5cdFx0fSApO1xuXG5cdFx0X2dsdWUoIGZsYXNoLCBidXR0b24gKTtcblxuXHRcdGNvbmZpZy5fZmxhc2ggPSBmbGFzaDtcblx0fSxcblxuXHRkZXN0cm95OiBmdW5jdGlvbiAoIGR0LCBidXR0b24sIGNvbmZpZyApIHtcblx0XHRjb25maWcuX2ZsYXNoLmRlc3Ryb3koKTtcblx0fSxcblxuXHRmaWVsZFNlcGFyYXRvcjogJywnLFxuXG5cdGZpZWxkQm91bmRhcnk6ICdcIicsXG5cblx0ZXhwb3J0T3B0aW9uczoge30sXG5cblx0dGl0bGU6ICcqJyxcblxuXHRmaWxlbmFtZTogJyonLFxuXG5cdGV4dGVuc2lvbjogJy5jc3YnLFxuXG5cdGhlYWRlcjogdHJ1ZSxcblxuXHRmb290ZXI6IGZhbHNlXG59O1xuXG5cbi8qKlxuICogQ29udmVydCBmcm9tIG51bWVyaWMgcG9zaXRpb24gdG8gbGV0dGVyIGZvciBjb2x1bW4gbmFtZXMgaW4gRXhjZWxcbiAqIEBwYXJhbSAge2ludH0gbiBDb2x1bW4gbnVtYmVyXG4gKiBAcmV0dXJuIHtzdHJpbmd9IENvbHVtbiBsZXR0ZXIocykgbmFtZVxuICovXG5mdW5jdGlvbiBjcmVhdGVDZWxsUG9zKCBuICl7XG5cdHZhciBvcmRBID0gJ0EnLmNoYXJDb2RlQXQoMCk7XG5cdHZhciBvcmRaID0gJ1onLmNoYXJDb2RlQXQoMCk7XG5cdHZhciBsZW4gPSBvcmRaIC0gb3JkQSArIDE7XG5cdHZhciBzID0gXCJcIjtcblxuXHR3aGlsZSggbiA+PSAwICkge1xuXHRcdHMgPSBTdHJpbmcuZnJvbUNoYXJDb2RlKG4gJSBsZW4gKyBvcmRBKSArIHM7XG5cdFx0biA9IE1hdGguZmxvb3IobiAvIGxlbikgLSAxO1xuXHR9XG5cblx0cmV0dXJuIHM7XG59XG5cbi8qKlxuICogQ3JlYXRlIGFuIFhNTCBub2RlIGFuZCBhZGQgYW55IGNoaWxkcmVuLCBhdHRyaWJ1dGVzLCBldGMgd2l0aG91dCBuZWVkaW5nIHRvXG4gKiBiZSB2ZXJib3NlIGluIHRoZSBET00uXG4gKlxuICogQHBhcmFtICB7b2JqZWN0fSBkb2MgICAgICBYTUwgZG9jdW1lbnRcbiAqIEBwYXJhbSAge3N0cmluZ30gbm9kZU5hbWUgTm9kZSBuYW1lXG4gKiBAcGFyYW0gIHtvYmplY3R9IG9wdHMgICAgIE9wdGlvbnMgLSBjYW4gYmUgYGF0dHJgIChhdHRyaWJ1dGVzKSwgYGNoaWxkcmVuYFxuICogICAoY2hpbGQgbm9kZXMpIGFuZCBgdGV4dGAgKHRleHQgY29udGVudClcbiAqIEByZXR1cm4ge25vZGV9ICAgICAgICAgICAgQ3JlYXRlZCBub2RlXG4gKi9cbmZ1bmN0aW9uIF9jcmVhdGVOb2RlKCBkb2MsIG5vZGVOYW1lLCBvcHRzICl7XG5cdHZhciB0ZW1wTm9kZSA9IGRvYy5jcmVhdGVFbGVtZW50KCBub2RlTmFtZSApO1xuXG5cdGlmICggb3B0cyApIHtcblx0XHRpZiAoIG9wdHMuYXR0ciApIHtcblx0XHRcdCQodGVtcE5vZGUpLmF0dHIoIG9wdHMuYXR0ciApO1xuXHRcdH1cblxuXHRcdGlmKCBvcHRzLmNoaWxkcmVuICkge1xuXHRcdFx0JC5lYWNoKCBvcHRzLmNoaWxkcmVuLCBmdW5jdGlvbiAoIGtleSwgdmFsdWUgKSB7XG5cdFx0XHRcdHRlbXBOb2RlLmFwcGVuZENoaWxkKCB2YWx1ZSApO1xuXHRcdFx0fSk7XG5cdFx0fVxuXG5cdFx0aWYoIG9wdHMudGV4dCApIHtcblx0XHRcdHRlbXBOb2RlLmFwcGVuZENoaWxkKCBkb2MuY3JlYXRlVGV4dE5vZGUoIG9wdHMudGV4dCApICk7XG5cdFx0fVxuXHR9XG5cblx0cmV0dXJuIHRlbXBOb2RlO1xufVxuXG4vKipcbiAqIEdldCB0aGUgd2lkdGggZm9yIGFuIEV4Y2VsIGNvbHVtbiBiYXNlZCBvbiB0aGUgY29udGVudHMgb2YgdGhhdCBjb2x1bW5cbiAqIEBwYXJhbSAge29iamVjdH0gZGF0YSBEYXRhIGZvciBleHBvcnRcbiAqIEBwYXJhbSAge2ludH0gICAgY29sICBDb2x1bW4gaW5kZXhcbiAqIEByZXR1cm4ge2ludH0gICAgICAgICBDb2x1bW4gd2lkdGhcbiAqL1xuZnVuY3Rpb24gX2V4Y2VsQ29sV2lkdGgoIGRhdGEsIGNvbCApIHtcblx0dmFyIG1heCA9IGRhdGEuaGVhZGVyW2NvbF0ubGVuZ3RoO1xuXHR2YXIgbGVuLCBsaW5lU3BsaXQsIHN0cjtcblxuXHRpZiAoIGRhdGEuZm9vdGVyICYmIGRhdGEuZm9vdGVyW2NvbF0ubGVuZ3RoID4gbWF4ICkge1xuXHRcdG1heCA9IGRhdGEuZm9vdGVyW2NvbF0ubGVuZ3RoO1xuXHR9XG5cblx0Zm9yICggdmFyIGk9MCwgaWVuPWRhdGEuYm9keS5sZW5ndGggOyBpPGllbiA7IGkrKyApIHtcblx0XHR2YXIgcG9pbnQgPSBkYXRhLmJvZHlbaV1bY29sXTtcblx0XHRzdHIgPSBwb2ludCAhPT0gbnVsbCAmJiBwb2ludCAhPT0gdW5kZWZpbmVkID9cblx0XHRcdHBvaW50LnRvU3RyaW5nKCkgOlxuXHRcdFx0Jyc7XG5cblx0XHQvLyBJZiB0aGVyZSBpcyBhIG5ld2xpbmUgY2hhcmFjdGVyLCB3b3Jrb3V0IHRoZSB3aWR0aCBvZiB0aGUgY29sdW1uXG5cdFx0Ly8gYmFzZWQgb24gdGhlIGxvbmdlc3QgbGluZSBpbiB0aGUgc3RyaW5nXG5cdFx0aWYgKCBzdHIuaW5kZXhPZignXFxuJykgIT09IC0xICkge1xuXHRcdFx0bGluZVNwbGl0ID0gc3RyLnNwbGl0KCdcXG4nKTtcblx0XHRcdGxpbmVTcGxpdC5zb3J0KCBmdW5jdGlvbiAoYSwgYikge1xuXHRcdFx0XHRyZXR1cm4gYi5sZW5ndGggLSBhLmxlbmd0aDtcblx0XHRcdH0gKTtcblxuXHRcdFx0bGVuID0gbGluZVNwbGl0WzBdLmxlbmd0aDtcblx0XHR9XG5cdFx0ZWxzZSB7XG5cdFx0XHRsZW4gPSBzdHIubGVuZ3RoO1xuXHRcdH1cblxuXHRcdGlmICggbGVuID4gbWF4ICkge1xuXHRcdFx0bWF4ID0gbGVuO1xuXHRcdH1cblxuXHRcdC8vIE1heCB3aWR0aCByYXRoZXIgdGhhbiBoYXZpbmcgcG90ZW50aWFsbHkgbWFzc2l2ZSBjb2x1bW4gd2lkdGhzXG5cdFx0aWYgKCBtYXggPiA0MCApIHtcblx0XHRcdHJldHVybiA1MjsgLy8gNDAgKiAxLjNcblx0XHR9XG5cdH1cblxuXHRtYXggKj0gMS4zO1xuXG5cdC8vIEFuZCBhIG1pbiB3aWR0aFxuXHRyZXR1cm4gbWF4ID4gNiA/IG1heCA6IDY7XG59XG5cbiAgdmFyIF9zZXJpYWxpc2VyID0gXCJcIjtcbiAgICBpZiAodHlwZW9mIHdpbmRvdy5YTUxTZXJpYWxpemVyID09PSAndW5kZWZpbmVkJykge1xuICAgICAgICBfc2VyaWFsaXNlciA9IG5ldyBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbGl6ZVRvU3RyaW5nID0gZnVuY3Rpb24gKGlucHV0KSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGlucHV0LnhtbFxuICAgICAgICAgICAgfVxuICAgICAgICB9O1xuICAgIH0gZWxzZSB7XG4gICAgICAgIF9zZXJpYWxpc2VyID0gIG5ldyBYTUxTZXJpYWxpemVyKCk7XG4gICAgfVxuXG4gICAgdmFyIF9pZUV4Y2VsO1xuXG5cbi8qKlxuICogQ29udmVydCBYTUwgZG9jdW1lbnRzIGluIGFuIG9iamVjdCB0byBzdHJpbmdzXG4gKiBAcGFyYW0gIHtvYmplY3R9IG9iaiBYTFNYIGRvY3VtZW50IG9iamVjdFxuICovXG5mdW5jdGlvbiBfeGxzeFRvU3RyaW5ncyggb2JqICkge1xuXHRpZiAoIF9pZUV4Y2VsID09PSB1bmRlZmluZWQgKSB7XG5cdFx0Ly8gRGV0ZWN0IGlmIHdlIGFyZSBkZWFsaW5nIHdpdGggSUUncyBfYXdmdWxfIHNlcmlhbGlzZXIgYnkgc2VlaW5nIGlmIGl0XG5cdFx0Ly8gZHJvcCBhdHRyaWJ1dGVzXG5cdFx0X2llRXhjZWwgPSBfc2VyaWFsaXNlclxuXHRcdFx0LnNlcmlhbGl6ZVRvU3RyaW5nKFxuXHRcdFx0XHQkLnBhcnNlWE1MKCBleGNlbFN0cmluZ3NbJ3hsL3dvcmtzaGVldHMvc2hlZXQxLnhtbCddIClcblx0XHRcdClcblx0XHRcdC5pbmRleE9mKCAneG1sbnM6cicgKSA9PT0gLTE7XG5cdH1cblxuXHQkLmVhY2goIG9iaiwgZnVuY3Rpb24gKCBuYW1lLCB2YWwgKSB7XG5cdFx0aWYgKCAkLmlzUGxhaW5PYmplY3QoIHZhbCApICkge1xuXHRcdFx0X3hsc3hUb1N0cmluZ3MoIHZhbCApO1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGlmICggX2llRXhjZWwgKSB7XG5cdFx0XHRcdC8vIElFJ3MgWE1MIHNlcmlhbGlzZXIgd2lsbCBkcm9wIHNvbWUgbmFtZSBzcGFjZSBhdHRyaWJ1dGVzIGZyb21cblx0XHRcdFx0Ly8gZnJvbSB0aGUgcm9vdCBub2RlLCBzbyB3ZSBuZWVkIHRvIHNhdmUgdGhlbS4gRG8gdGhpcyBieVxuXHRcdFx0XHQvLyByZXBsYWNpbmcgdGhlIG5hbWVzcGFjZSBub2RlcyB3aXRoIGEgcmVndWxhciBhdHRyaWJ1dGUgdGhhdFxuXHRcdFx0XHQvLyB3ZSBjb252ZXJ0IGJhY2sgd2hlbiBzZXJpYWxpc2VkLiBFZGdlIGRvZXMgbm90IGhhdmUgdGhpc1xuXHRcdFx0XHQvLyBpc3N1ZVxuXHRcdFx0XHR2YXIgd29ya3NoZWV0ID0gdmFsLmNoaWxkTm9kZXNbMF07XG5cdFx0XHRcdHZhciBpLCBpZW47XG5cdFx0XHRcdHZhciBhdHRycyA9IFtdO1xuXG5cdFx0XHRcdGZvciAoIGk9d29ya3NoZWV0LmF0dHJpYnV0ZXMubGVuZ3RoLTEgOyBpPj0wIDsgaS0tICkge1xuXHRcdFx0XHRcdHZhciBhdHRyTmFtZSA9IHdvcmtzaGVldC5hdHRyaWJ1dGVzW2ldLm5vZGVOYW1lO1xuXHRcdFx0XHRcdHZhciBhdHRyVmFsdWUgPSB3b3Jrc2hlZXQuYXR0cmlidXRlc1tpXS5ub2RlVmFsdWU7XG5cblx0XHRcdFx0XHRpZiAoIGF0dHJOYW1lLmluZGV4T2YoICc6JyApICE9PSAtMSApIHtcblx0XHRcdFx0XHRcdGF0dHJzLnB1c2goIHsgbmFtZTogYXR0ck5hbWUsIHZhbHVlOiBhdHRyVmFsdWUgfSApO1xuXG5cdFx0XHRcdFx0XHR3b3Jrc2hlZXQucmVtb3ZlQXR0cmlidXRlKCBhdHRyTmFtZSApO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fVxuXG5cdFx0XHRcdGZvciAoIGk9MCwgaWVuPWF0dHJzLmxlbmd0aCA7IGk8aWVuIDsgaSsrICkge1xuXHRcdFx0XHRcdHZhciBhdHRyID0gdmFsLmNyZWF0ZUF0dHJpYnV0ZSggYXR0cnNbaV0ubmFtZS5yZXBsYWNlKCAnOicsICdfZHRfYl9uYW1lc3BhY2VfdG9rZW5fJyApICk7XG5cdFx0XHRcdFx0YXR0ci52YWx1ZSA9IGF0dHJzW2ldLnZhbHVlO1xuXHRcdFx0XHRcdHdvcmtzaGVldC5zZXRBdHRyaWJ1dGVOb2RlKCBhdHRyICk7XG5cdFx0XHRcdH1cblx0XHRcdH1cblxuXHRcdFx0dmFyIHN0ciA9IF9zZXJpYWxpc2VyLnNlcmlhbGl6ZVRvU3RyaW5nKHZhbCk7XG5cblx0XHRcdC8vIEZpeCBJRSdzIFhNTFxuXHRcdFx0aWYgKCBfaWVFeGNlbCApIHtcblx0XHRcdFx0Ly8gSUUgZG9lc24ndCBpbmNsdWRlIHRoZSBYTUwgZGVjbGFyYXRpb25cblx0XHRcdFx0aWYgKCBzdHIuaW5kZXhPZiggJzw/eG1sJyApID09PSAtMSApIHtcblx0XHRcdFx0XHRzdHIgPSAnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/Picrc3RyO1xuXHRcdFx0XHR9XG5cblx0XHRcdFx0Ly8gUmV0dXJuIG5hbWVzcGFjZSBhdHRyaWJ1dGVzIHRvIGJlaW5nIGFzIHN1Y2hcblx0XHRcdFx0c3RyID0gc3RyLnJlcGxhY2UoIC9fZHRfYl9uYW1lc3BhY2VfdG9rZW5fL2csICc6JyApO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBTYWZhcmksIElFIGFuZCBFZGdlIHdpbGwgcHV0IGVtcHR5IG5hbWUgc3BhY2UgYXR0cmlidXRlcyBvbnRvXG5cdFx0XHQvLyB2YXJpb3VzIGVsZW1lbnRzIG1ha2luZyB0aGVtIHVzZWxlc3MuIFRoaXMgc3RyaXBzIHRoZW0gb3V0XG5cdFx0XHRzdHIgPSBzdHIucmVwbGFjZSggLzwoW148Pl0qPykgeG1sbnM9XCJcIihbXjw+XSo/KT4vZywgJzwkMSAkMj4nICk7XG5cblx0XHRcdG9ialsgbmFtZSBdID0gc3RyO1xuXHRcdH1cblx0fSApO1xufVxuXG4vLyBFeGNlbCAtIFByZS1kZWZpbmVkIHN0cmluZ3MgdG8gYnVpbGQgYSBiYXNpYyBYTFNYIGZpbGVcbnZhciBleGNlbFN0cmluZ3MgPSB7XG5cdFwiX3JlbHMvLnJlbHNcIjpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicrXG5cdFx0JzxSZWxhdGlvbnNoaXBzIHhtbG5zPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL3BhY2thZ2UvMjAwNi9yZWxhdGlvbnNoaXBzXCI+Jytcblx0XHRcdCc8UmVsYXRpb25zaGlwIElkPVwicklkMVwiIFR5cGU9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvb2ZmaWNlRG9jdW1lbnQvMjAwNi9yZWxhdGlvbnNoaXBzL29mZmljZURvY3VtZW50XCIgVGFyZ2V0PVwieGwvd29ya2Jvb2sueG1sXCIvPicrXG5cdFx0JzwvUmVsYXRpb25zaGlwcz4nLFxuXG5cdFwieGwvX3JlbHMvd29ya2Jvb2sueG1sLnJlbHNcIjpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicrXG5cdFx0JzxSZWxhdGlvbnNoaXBzIHhtbG5zPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL3BhY2thZ2UvMjAwNi9yZWxhdGlvbnNoaXBzXCI+Jytcblx0XHRcdCc8UmVsYXRpb25zaGlwIElkPVwicklkMVwiIFR5cGU9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvb2ZmaWNlRG9jdW1lbnQvMjAwNi9yZWxhdGlvbnNoaXBzL3dvcmtzaGVldFwiIFRhcmdldD1cIndvcmtzaGVldHMvc2hlZXQxLnhtbFwiLz4nK1xuXHRcdFx0JzxSZWxhdGlvbnNoaXAgSWQ9XCJySWQyXCIgVHlwZT1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9vZmZpY2VEb2N1bWVudC8yMDA2L3JlbGF0aW9uc2hpcHMvc3R5bGVzXCIgVGFyZ2V0PVwic3R5bGVzLnhtbFwiLz4nK1xuXHRcdCc8L1JlbGF0aW9uc2hpcHM+JyxcblxuXHRcIltDb250ZW50X1R5cGVzXS54bWxcIjpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicrXG5cdFx0JzxUeXBlcyB4bWxucz1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9wYWNrYWdlLzIwMDYvY29udGVudC10eXBlc1wiPicrXG5cdFx0XHQnPERlZmF1bHQgRXh0ZW5zaW9uPVwieG1sXCIgQ29udGVudFR5cGU9XCJhcHBsaWNhdGlvbi94bWxcIiAvPicrXG5cdFx0XHQnPERlZmF1bHQgRXh0ZW5zaW9uPVwicmVsc1wiIENvbnRlbnRUeXBlPVwiYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLXBhY2thZ2UucmVsYXRpb25zaGlwcyt4bWxcIiAvPicrXG5cdFx0XHQnPERlZmF1bHQgRXh0ZW5zaW9uPVwianBlZ1wiIENvbnRlbnRUeXBlPVwiaW1hZ2UvanBlZ1wiIC8+Jytcblx0XHRcdCc8T3ZlcnJpZGUgUGFydE5hbWU9XCIveGwvd29ya2Jvb2sueG1sXCIgQ29udGVudFR5cGU9XCJhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQuc3ByZWFkc2hlZXRtbC5zaGVldC5tYWluK3htbFwiIC8+Jytcblx0XHRcdCc8T3ZlcnJpZGUgUGFydE5hbWU9XCIveGwvd29ya3NoZWV0cy9zaGVldDEueG1sXCIgQ29udGVudFR5cGU9XCJhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQuc3ByZWFkc2hlZXRtbC53b3Jrc2hlZXQreG1sXCIgLz4nK1xuXHRcdFx0JzxPdmVycmlkZSBQYXJ0TmFtZT1cIi94bC9zdHlsZXMueG1sXCIgQ29udGVudFR5cGU9XCJhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQuc3ByZWFkc2hlZXRtbC5zdHlsZXMreG1sXCIgLz4nK1xuXHRcdCc8L1R5cGVzPicsXG5cblx0XCJ4bC93b3JrYm9vay54bWxcIjpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicrXG5cdFx0Jzx3b3JrYm9vayB4bWxucz1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9zcHJlYWRzaGVldG1sLzIwMDYvbWFpblwiIHhtbG5zOnI9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvb2ZmaWNlRG9jdW1lbnQvMjAwNi9yZWxhdGlvbnNoaXBzXCI+Jytcblx0XHRcdCc8ZmlsZVZlcnNpb24gYXBwTmFtZT1cInhsXCIgbGFzdEVkaXRlZD1cIjVcIiBsb3dlc3RFZGl0ZWQ9XCI1XCIgcnVwQnVpbGQ9XCIyNDgxNlwiLz4nK1xuXHRcdFx0Jzx3b3JrYm9va1ByIHNob3dJbmtBbm5vdGF0aW9uPVwiMFwiIGF1dG9Db21wcmVzc1BpY3R1cmVzPVwiMFwiLz4nK1xuXHRcdFx0Jzxib29rVmlld3M+Jytcblx0XHRcdFx0Jzx3b3JrYm9va1ZpZXcgeFdpbmRvdz1cIjBcIiB5V2luZG93PVwiMFwiIHdpbmRvd1dpZHRoPVwiMjU2MDBcIiB3aW5kb3dIZWlnaHQ9XCIxOTAyMFwiIHRhYlJhdGlvPVwiNTAwXCIvPicrXG5cdFx0XHQnPC9ib29rVmlld3M+Jytcblx0XHRcdCc8c2hlZXRzPicrXG5cdFx0XHRcdCc8c2hlZXQgbmFtZT1cIlwiIHNoZWV0SWQ9XCIxXCIgcjppZD1cInJJZDFcIi8+Jytcblx0XHRcdCc8L3NoZWV0cz4nK1xuXHRcdCc8L3dvcmtib29rPicsXG5cblx0XCJ4bC93b3Jrc2hlZXRzL3NoZWV0MS54bWxcIjpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicrXG5cdFx0Jzx3b3Jrc2hlZXQgeG1sbnM9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvc3ByZWFkc2hlZXRtbC8yMDA2L21haW5cIiB4bWxuczpyPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL29mZmljZURvY3VtZW50LzIwMDYvcmVsYXRpb25zaGlwc1wiIHhtbG5zOm1jPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL21hcmt1cC1jb21wYXRpYmlsaXR5LzIwMDZcIiBtYzpJZ25vcmFibGU9XCJ4MTRhY1wiIHhtbG5zOngxNGFjPVwiaHR0cDovL3NjaGVtYXMubWljcm9zb2Z0LmNvbS9vZmZpY2Uvc3ByZWFkc2hlZXRtbC8yMDA5LzkvYWNcIj4nK1xuXHRcdFx0JzxzaGVldERhdGEvPicrXG5cdFx0Jzwvd29ya3NoZWV0PicsXG5cblx0XCJ4bC9zdHlsZXMueG1sXCI6XG5cdFx0Jzw/eG1sIHZlcnNpb249XCIxLjBcIiBlbmNvZGluZz1cIlVURi04XCI/PicrXG5cdFx0JzxzdHlsZVNoZWV0IHhtbG5zPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL3NwcmVhZHNoZWV0bWwvMjAwNi9tYWluXCIgeG1sbnM6bWM9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvbWFya3VwLWNvbXBhdGliaWxpdHkvMjAwNlwiIG1jOklnbm9yYWJsZT1cIngxNGFjXCIgeG1sbnM6eDE0YWM9XCJodHRwOi8vc2NoZW1hcy5taWNyb3NvZnQuY29tL29mZmljZS9zcHJlYWRzaGVldG1sLzIwMDkvOS9hY1wiPicrXG5cdFx0XHQnPG51bUZtdHMgY291bnQ9XCI2XCI+Jytcblx0XHRcdFx0JzxudW1GbXQgbnVtRm10SWQ9XCIxNjRcIiBmb3JtYXRDb2RlPVwiIywjIzAuMDBfLVxcIFskJC00NUNdXCIvPicrXG5cdFx0XHRcdCc8bnVtRm10IG51bUZtdElkPVwiMTY1XCIgZm9ybWF0Q29kZT1cIiZxdW90O8KjJnF1b3Q7IywjIzAuMDBcIi8+Jytcblx0XHRcdFx0JzxudW1GbXQgbnVtRm10SWQ9XCIxNjZcIiBmb3JtYXRDb2RlPVwiWyTigqwtMl1cXCAjLCMjMC4wMFwiLz4nK1xuXHRcdFx0XHQnPG51bUZtdCBudW1GbXRJZD1cIjE2N1wiIGZvcm1hdENvZGU9XCIwLjAlXCIvPicrXG5cdFx0XHRcdCc8bnVtRm10IG51bUZtdElkPVwiMTY4XCIgZm9ybWF0Q29kZT1cIiMsIyMwOygjLCMjMClcIi8+Jytcblx0XHRcdFx0JzxudW1GbXQgbnVtRm10SWQ9XCIxNjlcIiBmb3JtYXRDb2RlPVwiIywjIzAuMDA7KCMsIyMwLjAwKVwiLz4nK1xuXHRcdFx0JzwvbnVtRm10cz4nK1xuXHRcdFx0Jzxmb250cyBjb3VudD1cIjVcIiB4MTRhYzprbm93bkZvbnRzPVwiMVwiPicrXG5cdFx0XHRcdCc8Zm9udD4nK1xuXHRcdFx0XHRcdCc8c3ogdmFsPVwiMTFcIiAvPicrXG5cdFx0XHRcdFx0JzxuYW1lIHZhbD1cIkNhbGlicmlcIiAvPicrXG5cdFx0XHRcdCc8L2ZvbnQ+Jytcblx0XHRcdFx0Jzxmb250PicrXG5cdFx0XHRcdFx0JzxzeiB2YWw9XCIxMVwiIC8+Jytcblx0XHRcdFx0XHQnPG5hbWUgdmFsPVwiQ2FsaWJyaVwiIC8+Jytcblx0XHRcdFx0XHQnPGNvbG9yIHJnYj1cIkZGRkZGRkZGXCIgLz4nK1xuXHRcdFx0XHQnPC9mb250PicrXG5cdFx0XHRcdCc8Zm9udD4nK1xuXHRcdFx0XHRcdCc8c3ogdmFsPVwiMTFcIiAvPicrXG5cdFx0XHRcdFx0JzxuYW1lIHZhbD1cIkNhbGlicmlcIiAvPicrXG5cdFx0XHRcdFx0JzxiIC8+Jytcblx0XHRcdFx0JzwvZm9udD4nK1xuXHRcdFx0XHQnPGZvbnQ+Jytcblx0XHRcdFx0XHQnPHN6IHZhbD1cIjExXCIgLz4nK1xuXHRcdFx0XHRcdCc8bmFtZSB2YWw9XCJDYWxpYnJpXCIgLz4nK1xuXHRcdFx0XHRcdCc8aSAvPicrXG5cdFx0XHRcdCc8L2ZvbnQ+Jytcblx0XHRcdFx0Jzxmb250PicrXG5cdFx0XHRcdFx0JzxzeiB2YWw9XCIxMVwiIC8+Jytcblx0XHRcdFx0XHQnPG5hbWUgdmFsPVwiQ2FsaWJyaVwiIC8+Jytcblx0XHRcdFx0XHQnPHUgLz4nK1xuXHRcdFx0XHQnPC9mb250PicrXG5cdFx0XHQnPC9mb250cz4nK1xuXHRcdFx0JzxmaWxscyBjb3VudD1cIjZcIj4nK1xuXHRcdFx0XHQnPGZpbGw+Jytcblx0XHRcdFx0XHQnPHBhdHRlcm5GaWxsIHBhdHRlcm5UeXBlPVwibm9uZVwiIC8+Jytcblx0XHRcdFx0JzwvZmlsbD4nK1xuXHRcdFx0XHQnPGZpbGwvPicrIC8vIEV4Y2VsIGFwcGVhcnMgdG8gdXNlIHRoaXMgYXMgYSBkb3R0ZWQgYmFja2dyb3VuZCByZWdhcmRsZXNzIG9mIHZhbHVlc1xuXHRcdFx0XHQnPGZpbGw+Jytcblx0XHRcdFx0XHQnPHBhdHRlcm5GaWxsIHBhdHRlcm5UeXBlPVwic29saWRcIj4nK1xuXHRcdFx0XHRcdFx0JzxmZ0NvbG9yIHJnYj1cIkZGRDlEOUQ5XCIgLz4nK1xuXHRcdFx0XHRcdFx0JzxiZ0NvbG9yIGluZGV4ZWQ9XCI2NFwiIC8+Jytcblx0XHRcdFx0XHQnPC9wYXR0ZXJuRmlsbD4nK1xuXHRcdFx0XHQnPC9maWxsPicrXG5cdFx0XHRcdCc8ZmlsbD4nK1xuXHRcdFx0XHRcdCc8cGF0dGVybkZpbGwgcGF0dGVyblR5cGU9XCJzb2xpZFwiPicrXG5cdFx0XHRcdFx0XHQnPGZnQ29sb3IgcmdiPVwiRkZEOTk3OTVcIiAvPicrXG5cdFx0XHRcdFx0XHQnPGJnQ29sb3IgaW5kZXhlZD1cIjY0XCIgLz4nK1xuXHRcdFx0XHRcdCc8L3BhdHRlcm5GaWxsPicrXG5cdFx0XHRcdCc8L2ZpbGw+Jytcblx0XHRcdFx0JzxmaWxsPicrXG5cdFx0XHRcdFx0JzxwYXR0ZXJuRmlsbCBwYXR0ZXJuVHlwZT1cInNvbGlkXCI+Jytcblx0XHRcdFx0XHRcdCc8ZmdDb2xvciByZ2I9XCJmZmM2ZWZjZVwiIC8+Jytcblx0XHRcdFx0XHRcdCc8YmdDb2xvciBpbmRleGVkPVwiNjRcIiAvPicrXG5cdFx0XHRcdFx0JzwvcGF0dGVybkZpbGw+Jytcblx0XHRcdFx0JzwvZmlsbD4nK1xuXHRcdFx0XHQnPGZpbGw+Jytcblx0XHRcdFx0XHQnPHBhdHRlcm5GaWxsIHBhdHRlcm5UeXBlPVwic29saWRcIj4nK1xuXHRcdFx0XHRcdFx0JzxmZ0NvbG9yIHJnYj1cImZmYzZjZmVmXCIgLz4nK1xuXHRcdFx0XHRcdFx0JzxiZ0NvbG9yIGluZGV4ZWQ9XCI2NFwiIC8+Jytcblx0XHRcdFx0XHQnPC9wYXR0ZXJuRmlsbD4nK1xuXHRcdFx0XHQnPC9maWxsPicrXG5cdFx0XHQnPC9maWxscz4nK1xuXHRcdFx0Jzxib3JkZXJzIGNvdW50PVwiMlwiPicrXG5cdFx0XHRcdCc8Ym9yZGVyPicrXG5cdFx0XHRcdFx0JzxsZWZ0IC8+Jytcblx0XHRcdFx0XHQnPHJpZ2h0IC8+Jytcblx0XHRcdFx0XHQnPHRvcCAvPicrXG5cdFx0XHRcdFx0Jzxib3R0b20gLz4nK1xuXHRcdFx0XHRcdCc8ZGlhZ29uYWwgLz4nK1xuXHRcdFx0XHQnPC9ib3JkZXI+Jytcblx0XHRcdFx0Jzxib3JkZXIgZGlhZ29uYWxVcD1cImZhbHNlXCIgZGlhZ29uYWxEb3duPVwiZmFsc2VcIj4nK1xuXHRcdFx0XHRcdCc8bGVmdCBzdHlsZT1cInRoaW5cIj4nK1xuXHRcdFx0XHRcdFx0Jzxjb2xvciBhdXRvPVwiMVwiIC8+Jytcblx0XHRcdFx0XHQnPC9sZWZ0PicrXG5cdFx0XHRcdFx0JzxyaWdodCBzdHlsZT1cInRoaW5cIj4nK1xuXHRcdFx0XHRcdFx0Jzxjb2xvciBhdXRvPVwiMVwiIC8+Jytcblx0XHRcdFx0XHQnPC9yaWdodD4nK1xuXHRcdFx0XHRcdCc8dG9wIHN0eWxlPVwidGhpblwiPicrXG5cdFx0XHRcdFx0XHQnPGNvbG9yIGF1dG89XCIxXCIgLz4nK1xuXHRcdFx0XHRcdCc8L3RvcD4nK1xuXHRcdFx0XHRcdCc8Ym90dG9tIHN0eWxlPVwidGhpblwiPicrXG5cdFx0XHRcdFx0XHQnPGNvbG9yIGF1dG89XCIxXCIgLz4nK1xuXHRcdFx0XHRcdCc8L2JvdHRvbT4nK1xuXHRcdFx0XHRcdCc8ZGlhZ29uYWwgLz4nK1xuXHRcdFx0XHQnPC9ib3JkZXI+Jytcblx0XHRcdCc8L2JvcmRlcnM+Jytcblx0XHRcdCc8Y2VsbFN0eWxlWGZzIGNvdW50PVwiMVwiPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiAvPicrXG5cdFx0XHQnPC9jZWxsU3R5bGVYZnM+Jytcblx0XHRcdCc8Y2VsbFhmcyBjb3VudD1cIjYxXCI+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5QWxpZ25tZW50PVwiMVwiPicrXG5cdFx0XHRcdFx0JzxhbGlnbm1lbnQgaG9yaXpvbnRhbD1cImxlZnRcIi8+Jytcblx0XHRcdFx0JzwveGY+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseUFsaWdubWVudD1cIjFcIj4nK1xuXHRcdFx0XHRcdCc8YWxpZ25tZW50IGhvcml6b250YWw9XCJjZW50ZXJcIi8+Jytcblx0XHRcdFx0JzwveGY+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseUFsaWdubWVudD1cIjFcIj4nK1xuXHRcdFx0XHRcdCc8YWxpZ25tZW50IGhvcml6b250YWw9XCJyaWdodFwiLz4nK1xuXHRcdFx0XHQnPC94Zj4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5QWxpZ25tZW50PVwiMVwiPicrXG5cdFx0XHRcdFx0JzxhbGlnbm1lbnQgaG9yaXpvbnRhbD1cImZpbGxcIi8+Jytcblx0XHRcdFx0JzwveGY+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseUFsaWdubWVudD1cIjFcIj4nK1xuXHRcdFx0XHRcdCc8YWxpZ25tZW50IHRleHRSb3RhdGlvbj1cIjkwXCIvPicrXG5cdFx0XHRcdCc8L3hmPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlBbGlnbm1lbnQ9XCIxXCI+Jytcblx0XHRcdFx0XHQnPGFsaWdubWVudCB3cmFwVGV4dD1cIjFcIi8+Jytcblx0XHRcdFx0JzwveGY+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjlcIiAgIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMTY0XCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIxNjVcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseU51bWJlckZvcm1hdD1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjE2NlwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiMTY3XCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicrXG5cdFx0XHRcdCc8eGYgbnVtRm10SWQ9XCIxNjhcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseU51bWJlckZvcm1hdD1cIjFcIi8+Jytcblx0XHRcdFx0Jzx4ZiBudW1GbXRJZD1cIjE2OVwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiM1wiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nK1xuXHRcdFx0XHQnPHhmIG51bUZtdElkPVwiNFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nK1xuXHRcdFx0JzwvY2VsbFhmcz4nK1xuXHRcdFx0JzxjZWxsU3R5bGVzIGNvdW50PVwiMVwiPicrXG5cdFx0XHRcdCc8Y2VsbFN0eWxlIG5hbWU9XCJOb3JtYWxcIiB4ZklkPVwiMFwiIGJ1aWx0aW5JZD1cIjBcIiAvPicrXG5cdFx0XHQnPC9jZWxsU3R5bGVzPicrXG5cdFx0XHQnPGR4ZnMgY291bnQ9XCIwXCIgLz4nK1xuXHRcdFx0Jzx0YWJsZVN0eWxlcyBjb3VudD1cIjBcIiBkZWZhdWx0VGFibGVTdHlsZT1cIlRhYmxlU3R5bGVNZWRpdW05XCIgZGVmYXVsdFBpdm90U3R5bGU9XCJQaXZvdFN0eWxlTWVkaXVtNFwiIC8+Jytcblx0XHQnPC9zdHlsZVNoZWV0Pidcbn07XG4vLyBOb3RlIHdlIGNvdWxkIHVzZSAzIGBmb3JgIGxvb3BzIGZvciB0aGUgc3R5bGVzLCBidXQgd2hlbiBnemlwcGVkIHRoZXJlIGlzXG4vLyB2aXJ0dWFsbHkgbm8gZGlmZmVyZW5jZSBpbiBzaXplLCBzaW5jZSB0aGUgYWJvdmUgY2FuIGJlIGVhc2lseSBjb21wcmVzc2VkXG5cbi8vIFBhdHRlcm4gbWF0Y2hpbmcgZm9yIHNwZWNpYWwgbnVtYmVyIGZvcm1hdHMuIFBlcmhhcHMgdGhpcyBzaG91bGQgYmUgZXhwb3NlZFxuLy8gdmlhIGFuIEFQSSBpbiBmdXR1cmU/XG52YXIgX2V4Y2VsU3BlY2lhbHMgPSBbXG5cdHsgbWF0Y2g6IC9eXFwtP1xcZCtcXC5cXGQlJC8sICAgICAgIHN0eWxlOiA2MCwgZm10OiBmdW5jdGlvbiAoZCkgeyByZXR1cm4gZC8xMDA7IH0gfSwgLy8gUHJlY2VudCB3aXRoIGQucC5cblx0eyBtYXRjaDogL15cXC0/XFxkK1xcLj9cXGQqJSQvLCAgICAgc3R5bGU6IDU2LCBmbXQ6IGZ1bmN0aW9uIChkKSB7IHJldHVybiBkLzEwMDsgfSB9LCAvLyBQZXJjZW50XG5cdHsgbWF0Y2g6IC9eXFwtP1xcJFtcXGQsXSsuP1xcZCokLywgIHN0eWxlOiA1NyB9LCAvLyBEb2xsYXJzXG5cdHsgbWF0Y2g6IC9eXFwtP8KjW1xcZCxdKy4/XFxkKiQvLCAgIHN0eWxlOiA1OCB9LCAvLyBQb3VuZHNcblx0eyBtYXRjaDogL15cXC0/4oKsW1xcZCxdKy4/XFxkKiQvLCAgIHN0eWxlOiA1OSB9LCAvLyBFdXJvc1xuXHR7IG1hdGNoOiAvXlxcKFtcXGQsXStcXCkkLywgICAgICAgIHN0eWxlOiA2MSwgZm10OiBmdW5jdGlvbiAoZCkgeyByZXR1cm4gLTEgKiBkLnJlcGxhY2UoL1tcXChcXCldL2csICcnKTsgfSB9LCAgLy8gTmVnYXRpdmUgbnVtYmVycyBpbmRpY2F0ZWQgYnkgYnJhY2tldHNcblx0eyBtYXRjaDogL15cXChbXFxkLF0rXFwuXFxkezJ9XFwpJC8sIHN0eWxlOiA2MiwgZm10OiBmdW5jdGlvbiAoZCkgeyByZXR1cm4gLTEgKiBkLnJlcGxhY2UoL1tcXChcXCldL2csICcnKTsgfSB9LCAgLy8gTmVnYXRpdmUgbnVtYmVycyBpbmRpY2F0ZWQgYnkgYnJhY2tldHMgLSAyZC5wLlxuXHR7IG1hdGNoOiAvXltcXGQsXSskLywgICAgICAgICAgICBzdHlsZTogNjMgfSwgLy8gTnVtYmVycyB3aXRoIHRob3VzYW5kIHNlcGFyYXRvcnNcblx0eyBtYXRjaDogL15bXFxkLF0rXFwuXFxkezJ9JC8sICAgICBzdHlsZTogNjQgfSAgLy8gTnVtYmVycyB3aXRoIDJkLnAuIGFuZCB0aG91c2FuZHMgc2VwYXJhdG9yc1xuXTtcblxuXG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogRGF0YVRhYmxlcyBvcHRpb25zIGFuZCBtZXRob2RzXG4gKi9cblxuLy8gU2V0IHRoZSBkZWZhdWx0IFNXRiBwYXRoXG5EYXRhVGFibGUuQnV0dG9ucy5zd2ZQYXRoID0gJy8vY2RuLmRhdGF0YWJsZXMubmV0L2J1dHRvbnMvMS4yLjQvc3dmL2ZsYXNoRXhwb3J0LnN3Zic7XG5cbi8vIE1ldGhvZCB0byBhbGxvdyBGbGFzaCBidXR0b25zIHRvIGJlIHJlc2l6ZWQgd2hlbiBtYWRlIHZpc2libGUgLSBhcyB0aGV5IGFyZVxuLy8gb2YgemVybyBoZWlnaHQgYW5kIHdpZHRoIGlmIGluaXRpYWxpc2VkIGhpZGRlblxuRGF0YVRhYmxlLkFwaS5yZWdpc3RlciggJ2J1dHRvbnMucmVzaXplKCknLCBmdW5jdGlvbiAoKSB7XG5cdCQuZWFjaCggWmVyb0NsaXBib2FyZF9UYWJsZVRvb2xzLmNsaWVudHMsIGZ1bmN0aW9uICggaSwgY2xpZW50ICkge1xuXHRcdGlmICggY2xpZW50LmRvbUVsZW1lbnQgIT09IHVuZGVmaW5lZCAmJiBjbGllbnQuZG9tRWxlbWVudC5wYXJlbnROb2RlICkge1xuXHRcdFx0Y2xpZW50LnBvc2l0aW9uRWxlbWVudCgpO1xuXHRcdH1cblx0fSApO1xufSApO1xuXG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogQnV0dG9uIGRlZmluaXRpb25zXG4gKi9cblxuLy8gQ29weSB0byBjbGlwYm9hcmRcbkRhdGFUYWJsZS5leHQuYnV0dG9ucy5jb3B5Rmxhc2ggPSAkLmV4dGVuZCgge30sIGZsYXNoQnV0dG9uLCB7XG5cdGNsYXNzTmFtZTogJ2J1dHRvbnMtY29weSBidXR0b25zLWZsYXNoJyxcblxuXHR0ZXh0OiBmdW5jdGlvbiAoIGR0ICkge1xuXHRcdHJldHVybiBkdC5pMThuKCAnYnV0dG9ucy5jb3B5JywgJ0NvcHknICk7XG5cdH0sXG5cblx0YWN0aW9uOiBmdW5jdGlvbiAoIGUsIGR0LCBidXR0b24sIGNvbmZpZyApIHtcblx0XHQvLyBDaGVjayB0aGF0IHRoZSB0cmlnZ2VyIGRpZCBhY3R1YWxseSBvY2N1ciBkdWUgdG8gYSBGbGFzaCBhY3RpdmF0aW9uXG5cdFx0aWYgKCAhIGNvbmZpZy5fZnJvbUZsYXNoICkge1xuXHRcdFx0cmV0dXJuO1xuXHRcdH1cblxuXHRcdHRoaXMucHJvY2Vzc2luZyggdHJ1ZSApO1xuXG5cdFx0dmFyIGZsYXNoID0gY29uZmlnLl9mbGFzaDtcblx0XHR2YXIgZGF0YSA9IF9leHBvcnREYXRhKCBkdCwgY29uZmlnICk7XG5cdFx0dmFyIG91dHB1dCA9IGNvbmZpZy5jdXN0b21pemUgP1xuXHRcdFx0Y29uZmlnLmN1c3RvbWl6ZSggZGF0YS5zdHIsIGNvbmZpZyApIDpcblx0XHRcdGRhdGEuc3RyO1xuXG5cdFx0Zmxhc2guc2V0QWN0aW9uKCAnY29weScgKTtcblx0XHRfc2V0VGV4dCggZmxhc2gsIG91dHB1dCApO1xuXG5cdFx0dGhpcy5wcm9jZXNzaW5nKCBmYWxzZSApO1xuXG5cdFx0ZHQuYnV0dG9ucy5pbmZvKFxuXHRcdFx0ZHQuaTE4biggJ2J1dHRvbnMuY29weVRpdGxlJywgJ0NvcHkgdG8gY2xpcGJvYXJkJyApLFxuXHRcdFx0ZHQuaTE4biggJ2J1dHRvbnMuY29weVN1Y2Nlc3MnLCB7XG5cdFx0XHRcdF86ICdDb3BpZWQgJWQgcm93cyB0byBjbGlwYm9hcmQnLFxuXHRcdFx0XHQxOiAnQ29waWVkIDEgcm93IHRvIGNsaXBib2FyZCdcblx0XHRcdH0sIGRhdGEucm93cyApLFxuXHRcdFx0MzAwMFxuXHRcdCk7XG5cdH0sXG5cblx0ZmllbGRTZXBhcmF0b3I6ICdcXHQnLFxuXG5cdGZpZWxkQm91bmRhcnk6ICcnXG59ICk7XG5cbi8vIENTViBzYXZlIGZpbGVcbkRhdGFUYWJsZS5leHQuYnV0dG9ucy5jc3ZGbGFzaCA9ICQuZXh0ZW5kKCB7fSwgZmxhc2hCdXR0b24sIHtcblx0Y2xhc3NOYW1lOiAnYnV0dG9ucy1jc3YgYnV0dG9ucy1mbGFzaCcsXG5cblx0dGV4dDogZnVuY3Rpb24gKCBkdCApIHtcblx0XHRyZXR1cm4gZHQuaTE4biggJ2J1dHRvbnMuY3N2JywgJ0NTVicgKTtcblx0fSxcblxuXHRhY3Rpb246IGZ1bmN0aW9uICggZSwgZHQsIGJ1dHRvbiwgY29uZmlnICkge1xuXHRcdC8vIFNldCB0aGUgdGV4dFxuXHRcdHZhciBmbGFzaCA9IGNvbmZpZy5fZmxhc2g7XG5cdFx0dmFyIGRhdGEgPSBfZXhwb3J0RGF0YSggZHQsIGNvbmZpZyApO1xuXHRcdHZhciBvdXRwdXQgPSBjb25maWcuY3VzdG9taXplID9cblx0XHRcdGNvbmZpZy5jdXN0b21pemUoIGRhdGEuc3RyLCBjb25maWcgKSA6XG5cdFx0XHRkYXRhLnN0cjtcblxuXHRcdGZsYXNoLnNldEFjdGlvbiggJ2NzdicgKTtcblx0XHRmbGFzaC5zZXRGaWxlTmFtZSggX2ZpbGVuYW1lKCBjb25maWcgKSApO1xuXHRcdF9zZXRUZXh0KCBmbGFzaCwgb3V0cHV0ICk7XG5cdH0sXG5cblx0ZXNjYXBlQ2hhcjogJ1wiJ1xufSApO1xuXG4vLyBFeGNlbCBzYXZlIGZpbGUgLSB0aGlzIGlzIHJlYWxseSBhIENTViBmaWxlIHVzaW5nIFVURi04IHRoYXQgRXhjZWwgY2FuIHJlYWRcbkRhdGFUYWJsZS5leHQuYnV0dG9ucy5leGNlbEZsYXNoID0gJC5leHRlbmQoIHt9LCBmbGFzaEJ1dHRvbiwge1xuXHRjbGFzc05hbWU6ICdidXR0b25zLWV4Y2VsIGJ1dHRvbnMtZmxhc2gnLFxuXG5cdHRleHQ6IGZ1bmN0aW9uICggZHQgKSB7XG5cdFx0cmV0dXJuIGR0LmkxOG4oICdidXR0b25zLmV4Y2VsJywgJ0V4Y2VsJyApO1xuXHR9LFxuXG5cdGFjdGlvbjogZnVuY3Rpb24gKCBlLCBkdCwgYnV0dG9uLCBjb25maWcgKSB7XG5cdFx0dGhpcy5wcm9jZXNzaW5nKCB0cnVlICk7XG5cblx0XHR2YXIgZmxhc2ggPSBjb25maWcuX2ZsYXNoO1xuXHRcdHZhciByb3dQb3MgPSAwO1xuXHRcdHZhciByZWxzID0gJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWyd4bC93b3Jrc2hlZXRzL3NoZWV0MS54bWwnXSApIDsgLy9QYXJzZXMgeG1sXG5cdFx0dmFyIHJlbHNHZXQgPSByZWxzLmdldEVsZW1lbnRzQnlUYWdOYW1lKCBcInNoZWV0RGF0YVwiIClbMF07XG5cblx0XHR2YXIgeGxzeCA9IHtcblx0XHRcdF9yZWxzOiB7XG5cdFx0XHRcdFwiLnJlbHNcIjogJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWydfcmVscy8ucmVscyddIClcblx0XHRcdH0sXG5cdFx0XHR4bDoge1xuXHRcdFx0XHRfcmVsczoge1xuXHRcdFx0XHRcdFwid29ya2Jvb2sueG1sLnJlbHNcIjogJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWyd4bC9fcmVscy93b3JrYm9vay54bWwucmVscyddIClcblx0XHRcdFx0fSxcblx0XHRcdFx0XCJ3b3JrYm9vay54bWxcIjogJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWyd4bC93b3JrYm9vay54bWwnXSApLFxuXHRcdFx0XHRcInN0eWxlcy54bWxcIjogJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWyd4bC9zdHlsZXMueG1sJ10gKSxcblx0XHRcdFx0XCJ3b3Jrc2hlZXRzXCI6IHtcblx0XHRcdFx0XHRcInNoZWV0MS54bWxcIjogcmVsc1xuXHRcdFx0XHR9XG5cblx0XHRcdH0sXG5cdFx0XHRcIltDb250ZW50X1R5cGVzXS54bWxcIjogJC5wYXJzZVhNTCggZXhjZWxTdHJpbmdzWydbQ29udGVudF9UeXBlc10ueG1sJ10pXG5cdFx0fTtcblxuXHRcdHZhciBkYXRhID0gZHQuYnV0dG9ucy5leHBvcnREYXRhKCBjb25maWcuZXhwb3J0T3B0aW9ucyApO1xuXHRcdHZhciBjdXJyZW50Um93LCByb3dOb2RlO1xuXHRcdHZhciBhZGRSb3cgPSBmdW5jdGlvbiAoIHJvdyApIHtcblx0XHRcdGN1cnJlbnRSb3cgPSByb3dQb3MrMTtcblx0XHRcdHJvd05vZGUgPSBfY3JlYXRlTm9kZSggcmVscywgXCJyb3dcIiwgeyBhdHRyOiB7cjpjdXJyZW50Um93fSB9ICk7XG5cblx0XHRcdGZvciAoIHZhciBpPTAsIGllbj1yb3cubGVuZ3RoIDsgaTxpZW4gOyBpKysgKSB7XG5cdFx0XHRcdC8vIENvbmNhdCBib3RoIHRoZSBDZWxsIENvbHVtbnMgYXMgYSBsZXR0ZXIgYW5kIHRoZSBSb3cgb2YgdGhlIGNlbGwuXG5cdFx0XHRcdHZhciBjZWxsSWQgPSBjcmVhdGVDZWxsUG9zKGkpICsgJycgKyBjdXJyZW50Um93O1xuXHRcdFx0XHR2YXIgY2VsbCA9IG51bGw7XG5cblx0XHRcdFx0Ly8gRm9yIG51bGwsIHVuZGVmaW5lZCBvZiBibGFuayBjZWxsLCBjb250aW51ZSBzbyBpdCBkb2Vzbid0IGNyZWF0ZSB0aGUgX2NyZWF0ZU5vZGVcblx0XHRcdFx0aWYgKCByb3dbaV0gPT09IG51bGwgfHwgcm93W2ldID09PSB1bmRlZmluZWQgfHwgcm93W2ldID09PSAnJyApIHtcblx0XHRcdFx0XHRjb250aW51ZTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdHJvd1tpXSA9ICQudHJpbSggcm93W2ldICk7XG5cblx0XHRcdFx0Ly8gU3BlY2lhbCBudW1iZXIgZm9ybWF0dGluZyBvcHRpb25zXG5cdFx0XHRcdGZvciAoIHZhciBqPTAsIGplbj1fZXhjZWxTcGVjaWFscy5sZW5ndGggOyBqPGplbiA7IGorKyApIHtcblx0XHRcdFx0XHR2YXIgc3BlY2lhbCA9IF9leGNlbFNwZWNpYWxzW2pdO1xuXG5cdFx0XHRcdFx0Ly8gVE9ETyBOZWVkIHRvIHByb3ZpZGUgdGhlIGFiaWxpdHkgZm9yIHRoZSBzcGVjaWFscyB0byBzYXlcblx0XHRcdFx0XHQvLyBpZiB0aGV5IGFyZSByZXR1cm5pbmcgYSBzdHJpbmcsIHNpbmNlIGF0IHRoZSBtb21lbnQgaXQgaXNcblx0XHRcdFx0XHQvLyBhc3N1bWVkIHRvIGJlIGEgbnVtYmVyXG5cdFx0XHRcdFx0aWYgKCByb3dbaV0ubWF0Y2ggJiYgISByb3dbaV0ubWF0Y2goL14wXFxkKy8pICYmIHJvd1tpXS5tYXRjaCggc3BlY2lhbC5tYXRjaCApICkge1xuXHRcdFx0XHRcdFx0dmFyIHZhbCA9IHJvd1tpXS5yZXBsYWNlKC9bXlxcZFxcLlxcLV0vZywgJycpO1xuXG5cdFx0XHRcdFx0XHRpZiAoIHNwZWNpYWwuZm10ICkge1xuXHRcdFx0XHRcdFx0XHR2YWwgPSBzcGVjaWFsLmZtdCggdmFsICk7XG5cdFx0XHRcdFx0XHR9XG5cblx0XHRcdFx0XHRcdGNlbGwgPSBfY3JlYXRlTm9kZSggcmVscywgJ2MnLCB7XG5cdFx0XHRcdFx0XHRcdGF0dHI6IHtcblx0XHRcdFx0XHRcdFx0XHRyOiBjZWxsSWQsXG5cdFx0XHRcdFx0XHRcdFx0czogc3BlY2lhbC5zdHlsZVxuXHRcdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0XHRjaGlsZHJlbjogW1xuXHRcdFx0XHRcdFx0XHRcdF9jcmVhdGVOb2RlKCByZWxzLCAndicsIHsgdGV4dDogdmFsIH0gKVxuXHRcdFx0XHRcdFx0XHRdXG5cdFx0XHRcdFx0XHR9ICk7XG5cblx0XHRcdFx0XHRcdGJyZWFrO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fVxuXG5cdFx0XHRcdGlmICggISBjZWxsICkge1xuXHRcdFx0XHRcdGlmICggdHlwZW9mIHJvd1tpXSA9PT0gJ251bWJlcicgfHwgKFxuXHRcdFx0XHRcdFx0cm93W2ldLm1hdGNoICYmXG5cdFx0XHRcdFx0XHRyb3dbaV0ubWF0Y2goL14tP1xcZCsoXFwuXFxkKyk/JC8pICYmXG5cdFx0XHRcdFx0XHQhIHJvd1tpXS5tYXRjaCgvXjBcXGQrLykgKVxuXHRcdFx0XHRcdCkge1xuXHRcdFx0XHRcdFx0Ly8gRGV0ZWN0IG51bWJlcnMgLSBkb24ndCBtYXRjaCBudW1iZXJzIHdpdGggbGVhZGluZyB6ZXJvc1xuXHRcdFx0XHRcdFx0Ly8gb3IgYSBuZWdhdGl2ZSBhbnl3aGVyZSBidXQgdGhlIHN0YXJ0XG5cdFx0XHRcdFx0XHRjZWxsID0gX2NyZWF0ZU5vZGUoIHJlbHMsICdjJywge1xuXHRcdFx0XHRcdFx0XHRhdHRyOiB7XG5cdFx0XHRcdFx0XHRcdFx0dDogJ24nLFxuXHRcdFx0XHRcdFx0XHRcdHI6IGNlbGxJZFxuXHRcdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0XHRjaGlsZHJlbjogW1xuXHRcdFx0XHRcdFx0XHRcdF9jcmVhdGVOb2RlKCByZWxzLCAndicsIHsgdGV4dDogcm93W2ldIH0gKVxuXHRcdFx0XHRcdFx0XHRdXG5cdFx0XHRcdFx0XHR9ICk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdGVsc2Uge1xuXHRcdFx0XHRcdFx0Ly8gU3RyaW5nIG91dHB1dCAtIHJlcGxhY2Ugbm9uIHN0YW5kYXJkIGNoYXJhY3RlcnMgZm9yIHRleHQgb3V0cHV0XG5cdFx0XHRcdFx0XHR2YXIgdGV4dCA9ICEgcm93W2ldLnJlcGxhY2UgP1xuXHRcdFx0XHRcdFx0XHRyb3dbaV0gOlxuXHRcdFx0XHRcdFx0XHRyb3dbaV0ucmVwbGFjZSgvW1xceDAwLVxceDA5XFx4MEJcXHgwQ1xceDBFLVxceDFGXFx4N0YtXFx4OUZdL2csICcnKTtcblxuXHRcdFx0XHRcdFx0Y2VsbCA9IF9jcmVhdGVOb2RlKCByZWxzLCAnYycsIHtcblx0XHRcdFx0XHRcdFx0YXR0cjoge1xuXHRcdFx0XHRcdFx0XHRcdHQ6ICdpbmxpbmVTdHInLFxuXHRcdFx0XHRcdFx0XHRcdHI6IGNlbGxJZFxuXHRcdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0XHRjaGlsZHJlbjp7XG5cdFx0XHRcdFx0XHRcdFx0cm93OiBfY3JlYXRlTm9kZSggcmVscywgJ2lzJywge1xuXHRcdFx0XHRcdFx0XHRcdFx0Y2hpbGRyZW46IHtcblx0XHRcdFx0XHRcdFx0XHRcdFx0cm93OiBfY3JlYXRlTm9kZSggcmVscywgJ3QnLCB7XG5cdFx0XHRcdFx0XHRcdFx0XHRcdFx0dGV4dDogdGV4dFxuXHRcdFx0XHRcdFx0XHRcdFx0XHR9IClcblx0XHRcdFx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHRcdFx0XHR9IClcblx0XHRcdFx0XHRcdFx0fVxuXHRcdFx0XHRcdFx0fSApO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fVxuXG5cdFx0XHRcdHJvd05vZGUuYXBwZW5kQ2hpbGQoIGNlbGwgKTtcblx0XHRcdH1cblxuXHRcdFx0cmVsc0dldC5hcHBlbmRDaGlsZChyb3dOb2RlKTtcblx0XHRcdHJvd1BvcysrO1xuXHRcdH07XG5cblx0XHQkKCAnc2hlZXRzIHNoZWV0JywgeGxzeC54bFsnd29ya2Jvb2sueG1sJ10gKS5hdHRyKCAnbmFtZScsIF9zaGVldG5hbWUoIGNvbmZpZyApICk7XG5cblx0XHRpZiAoIGNvbmZpZy5jdXN0b21pemVEYXRhICkge1xuXHRcdFx0Y29uZmlnLmN1c3RvbWl6ZURhdGEoIGRhdGEgKTtcblx0XHR9XG5cblx0XHRpZiAoIGNvbmZpZy5oZWFkZXIgKSB7XG5cdFx0XHRhZGRSb3coIGRhdGEuaGVhZGVyLCByb3dQb3MgKTtcblx0XHRcdCQoJ3JvdyBjJywgcmVscykuYXR0ciggJ3MnLCAnMicgKTsgLy8gYm9sZFxuXHRcdH1cblxuXHRcdGZvciAoIHZhciBuPTAsIGllPWRhdGEuYm9keS5sZW5ndGggOyBuPGllIDsgbisrICkge1xuXHRcdFx0YWRkUm93KCBkYXRhLmJvZHlbbl0sIHJvd1BvcyApO1xuXHRcdH1cblxuXHRcdGlmICggY29uZmlnLmZvb3RlciAmJiBkYXRhLmZvb3RlciApIHtcblx0XHRcdGFkZFJvdyggZGF0YS5mb290ZXIsIHJvd1Bvcyk7XG5cdFx0XHQkKCdyb3c6bGFzdCBjJywgcmVscykuYXR0ciggJ3MnLCAnMicgKTsgLy8gYm9sZFxuXHRcdH1cblxuXHRcdC8vIFNldCBjb2x1bW4gd2lkdGhzXG5cdFx0dmFyIGNvbHMgPSBfY3JlYXRlTm9kZSggcmVscywgJ2NvbHMnICk7XG5cdFx0JCgnd29ya3NoZWV0JywgcmVscykucHJlcGVuZCggY29scyApO1xuXG5cdFx0Zm9yICggdmFyIGk9MCwgaWVuPWRhdGEuaGVhZGVyLmxlbmd0aCA7IGk8aWVuIDsgaSsrICkge1xuXHRcdFx0Y29scy5hcHBlbmRDaGlsZCggX2NyZWF0ZU5vZGUoIHJlbHMsICdjb2wnLCB7XG5cdFx0XHRcdGF0dHI6IHtcblx0XHRcdFx0XHRtaW46IGkrMSxcblx0XHRcdFx0XHRtYXg6IGkrMSxcblx0XHRcdFx0XHR3aWR0aDogX2V4Y2VsQ29sV2lkdGgoIGRhdGEsIGkgKSxcblx0XHRcdFx0XHRjdXN0b21XaWR0aDogMVxuXHRcdFx0XHR9XG5cdFx0XHR9ICkgKTtcblx0XHR9XG5cblx0XHQvLyBMZXQgdGhlIGRldmVsb3BlciBjdXN0b21pc2UgdGhlIGRvY3VtZW50IGlmIHRoZXkgd2FudCB0b1xuXHRcdGlmICggY29uZmlnLmN1c3RvbWl6ZSApIHtcblx0XHRcdGNvbmZpZy5jdXN0b21pemUoIHhsc3ggKTtcblx0XHR9XG5cblx0XHRfeGxzeFRvU3RyaW5ncyggeGxzeCApO1xuXG5cdFx0Zmxhc2guc2V0QWN0aW9uKCAnZXhjZWwnICk7XG5cdFx0Zmxhc2guc2V0RmlsZU5hbWUoIF9maWxlbmFtZSggY29uZmlnICkgKTtcblx0XHRmbGFzaC5zZXRTaGVldERhdGEoIHhsc3ggKTtcblx0XHRfc2V0VGV4dCggZmxhc2gsICcnICk7XG5cblx0XHR0aGlzLnByb2Nlc3NpbmcoIGZhbHNlICk7XG5cdH0sXG5cblx0ZXh0ZW5zaW9uOiAnLnhsc3gnXG59ICk7XG5cblxuXG4vLyBQREYgZXhwb3J0XG5EYXRhVGFibGUuZXh0LmJ1dHRvbnMucGRmRmxhc2ggPSAkLmV4dGVuZCgge30sIGZsYXNoQnV0dG9uLCB7XG5cdGNsYXNzTmFtZTogJ2J1dHRvbnMtcGRmIGJ1dHRvbnMtZmxhc2gnLFxuXG5cdHRleHQ6IGZ1bmN0aW9uICggZHQgKSB7XG5cdFx0cmV0dXJuIGR0LmkxOG4oICdidXR0b25zLnBkZicsICdQREYnICk7XG5cdH0sXG5cblx0YWN0aW9uOiBmdW5jdGlvbiAoIGUsIGR0LCBidXR0b24sIGNvbmZpZyApIHtcblx0XHR0aGlzLnByb2Nlc3NpbmcoIHRydWUgKTtcblxuXHRcdC8vIFNldCB0aGUgdGV4dFxuXHRcdHZhciBmbGFzaCA9IGNvbmZpZy5fZmxhc2g7XG5cdFx0dmFyIGRhdGEgPSBkdC5idXR0b25zLmV4cG9ydERhdGEoIGNvbmZpZy5leHBvcnRPcHRpb25zICk7XG5cdFx0dmFyIHRvdGFsV2lkdGggPSBkdC50YWJsZSgpLm5vZGUoKS5vZmZzZXRXaWR0aDtcblxuXHRcdC8vIENhbGN1bGF0ZSB0aGUgY29sdW1uIHdpZHRoIHJhdGlvcyBmb3IgbGF5b3V0IG9mIHRoZSB0YWJsZSBpbiB0aGUgUERGXG5cdFx0dmFyIHJhdGlvcyA9IGR0LmNvbHVtbnMoIGNvbmZpZy5jb2x1bW5zICkuaW5kZXhlcygpLm1hcCggZnVuY3Rpb24gKCBpZHggKSB7XG5cdFx0XHRyZXR1cm4gZHQuY29sdW1uKCBpZHggKS5oZWFkZXIoKS5vZmZzZXRXaWR0aCAvIHRvdGFsV2lkdGg7XG5cdFx0fSApO1xuXG5cdFx0Zmxhc2guc2V0QWN0aW9uKCAncGRmJyApO1xuXHRcdGZsYXNoLnNldEZpbGVOYW1lKCBfZmlsZW5hbWUoIGNvbmZpZyApICk7XG5cblx0XHRfc2V0VGV4dCggZmxhc2gsIEpTT04uc3RyaW5naWZ5KCB7XG5cdFx0XHR0aXRsZTogICAgICAgX2ZpbGVuYW1lKGNvbmZpZywgZmFsc2UpLFxuXHRcdFx0bWVzc2FnZTogdHlwZW9mIGNvbmZpZy5tZXNzYWdlID09ICdmdW5jdGlvbicgPyBjb25maWcubWVzc2FnZShkdCwgYnV0dG9uLCBjb25maWcpIDogY29uZmlnLm1lc3NhZ2UsXG5cdFx0XHRjb2xXaWR0aDogICAgcmF0aW9zLnRvQXJyYXkoKSxcblx0XHRcdG9yaWVudGF0aW9uOiBjb25maWcub3JpZW50YXRpb24sXG5cdFx0XHRzaXplOiAgICAgICAgY29uZmlnLnBhZ2VTaXplLFxuXHRcdFx0aGVhZGVyOiAgICAgIGNvbmZpZy5oZWFkZXIgPyBkYXRhLmhlYWRlciA6IG51bGwsXG5cdFx0XHRmb290ZXI6ICAgICAgY29uZmlnLmZvb3RlciA/IGRhdGEuZm9vdGVyIDogbnVsbCxcblx0XHRcdGJvZHk6ICAgICAgICBkYXRhLmJvZHlcblx0XHR9ICkgKTtcblxuXHRcdHRoaXMucHJvY2Vzc2luZyggZmFsc2UgKTtcblx0fSxcblxuXHRleHRlbnNpb246ICcucGRmJyxcblxuXHRvcmllbnRhdGlvbjogJ3BvcnRyYWl0JyxcblxuXHRwYWdlU2l6ZTogJ0E0JyxcblxuXHRtZXNzYWdlOiAnJyxcblxuXHRuZXdsaW5lOiAnXFxuJ1xufSApO1xuXG5cbnJldHVybiBEYXRhVGFibGUuQnV0dG9ucztcbn0pKTtcbiIsIi8qIVxuICogSFRNTDUgZXhwb3J0IGJ1dHRvbnMgZm9yIEJ1dHRvbnMgYW5kIERhdGFUYWJsZXMuXG4gKiDCqSBTcHJ5TWVkaWEgTHRkIC0gZGF0YXRhYmxlcy5uZXQvbGljZW5zZVxuICpcbiAqIEZpbGVTYXZlci5qcyAoMS4zLjMpIC0gTUlUIGxpY2Vuc2VcbiAqIENvcHlyaWdodCDCqSAyMDE2IEVsaSBHcmV5IC0gaHR0cDovL2VsaWdyZXkuY29tXG4gKi9cblxuKGZ1bmN0aW9uKCBmYWN0b3J5ICl7XG5cdGlmICggdHlwZW9mIGRlZmluZSA9PT0gJ2Z1bmN0aW9uJyAmJiBkZWZpbmUuYW1kICkge1xuXHRcdC8vIEFNRFxuXHRcdGRlZmluZSggWydqcXVlcnknLCAnZGF0YXRhYmxlcy5uZXQnLCAnZGF0YXRhYmxlcy5uZXQtYnV0dG9ucyddLCBmdW5jdGlvbiAoICQgKSB7XG5cdFx0XHRyZXR1cm4gZmFjdG9yeSggJCwgd2luZG93LCBkb2N1bWVudCApO1xuXHRcdH0gKTtcblx0fVxuXHRlbHNlIGlmICggdHlwZW9mIGV4cG9ydHMgPT09ICdvYmplY3QnICkge1xuXHRcdC8vIENvbW1vbkpTXG5cdFx0dmFyIGpxID0gcmVxdWlyZSgnanF1ZXJ5Jyk7XG5cdFx0dmFyIGNqc1JlcXVpcmVzID0gZnVuY3Rpb24gKHJvb3QsICQpIHtcblx0XHRcdGlmICggISAkLmZuLmRhdGFUYWJsZSApIHtcblx0XHRcdFx0cmVxdWlyZSgnZGF0YXRhYmxlcy5uZXQnKShyb290LCAkKTtcblx0XHRcdH1cblxuXHRcdFx0aWYgKCAhICQuZm4uZGF0YVRhYmxlLkJ1dHRvbnMgKSB7XG5cdFx0XHRcdHJlcXVpcmUoJ2RhdGF0YWJsZXMubmV0LWJ1dHRvbnMnKShyb290LCAkKTtcblx0XHRcdH1cblx0XHR9O1xuXG5cdFx0aWYgKHR5cGVvZiB3aW5kb3cgPT09ICd1bmRlZmluZWQnKSB7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIChyb290LCAkKSB7XG5cdFx0XHRcdGlmICggISByb290ICkge1xuXHRcdFx0XHRcdC8vIENvbW1vbkpTIGVudmlyb25tZW50cyB3aXRob3V0IGEgd2luZG93IGdsb2JhbCBtdXN0IHBhc3MgYVxuXHRcdFx0XHRcdC8vIHJvb3QuIFRoaXMgd2lsbCBnaXZlIGFuIGVycm9yIG90aGVyd2lzZVxuXHRcdFx0XHRcdHJvb3QgPSB3aW5kb3c7XG5cdFx0XHRcdH1cblxuXHRcdFx0XHRpZiAoICEgJCApIHtcblx0XHRcdFx0XHQkID0ganEoIHJvb3QgKTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdGNqc1JlcXVpcmVzKCByb290LCAkICk7XG5cdFx0XHRcdHJldHVybiBmYWN0b3J5KCAkLCByb290LCByb290LmRvY3VtZW50ICk7XG5cdFx0XHR9O1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGNqc1JlcXVpcmVzKCB3aW5kb3csIGpxICk7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZhY3RvcnkoIGpxLCB3aW5kb3csIHdpbmRvdy5kb2N1bWVudCApO1xuXHRcdH1cblx0fVxuXHRlbHNlIHtcblx0XHQvLyBCcm93c2VyXG5cdFx0ZmFjdG9yeSggalF1ZXJ5LCB3aW5kb3csIGRvY3VtZW50ICk7XG5cdH1cbn0oZnVuY3Rpb24oICQsIHdpbmRvdywgZG9jdW1lbnQgKSB7XG4ndXNlIHN0cmljdCc7XG52YXIgRGF0YVRhYmxlID0gJC5mbi5kYXRhVGFibGU7XG5cblxuXG4vLyBBbGxvdyB0aGUgY29uc3RydWN0b3IgdG8gcGFzcyBpbiBKU1ppcCBhbmQgUERGTWFrZSBmcm9tIGV4dGVybmFsIHJlcXVpcmVzLlxuLy8gT3RoZXJ3aXNlLCB1c2UgZ2xvYmFsbHkgZGVmaW5lZCB2YXJpYWJsZXMsIGlmIHRoZXkgYXJlIGF2YWlsYWJsZS5cbnZhciB1c2VKc3ppcDtcbnZhciB1c2VQZGZtYWtlO1xuXG5mdW5jdGlvbiBfanNaaXAoKSB7XG5cdHJldHVybiB1c2VKc3ppcCB8fCB3aW5kb3cuSlNaaXA7XG59XG5mdW5jdGlvbiBfcGRmTWFrZSgpIHtcblx0cmV0dXJuIHVzZVBkZm1ha2UgfHwgd2luZG93LnBkZk1ha2U7XG59XG5cbkRhdGFUYWJsZS5CdXR0b25zLnBkZk1ha2UgPSBmdW5jdGlvbiAoXykge1xuXHRpZiAoIV8pIHtcblx0XHRyZXR1cm4gX3BkZk1ha2UoKTtcblx0fVxuXHR1c2VQZGZtYWtlID0gXztcbn07XG5cbkRhdGFUYWJsZS5CdXR0b25zLmpzemlwID0gZnVuY3Rpb24gKF8pIHtcblx0aWYgKCFfKSB7XG5cdFx0cmV0dXJuIF9qc1ppcCgpO1xuXHR9XG5cdHVzZUpzemlwID0gXztcbn07XG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogRmlsZVNhdmVyLmpzIGRlcGVuZGVuY3lcbiAqL1xuXG4vKmpzbGludCBiaXR3aXNlOiB0cnVlLCBpbmRlbnQ6IDQsIGxheGJyZWFrOiB0cnVlLCBsYXhjb21tYTogdHJ1ZSwgc21hcnR0YWJzOiB0cnVlLCBwbHVzcGx1czogdHJ1ZSAqL1xuXG52YXIgX3NhdmVBcyA9IChmdW5jdGlvbiAodmlldykge1xuXHQndXNlIHN0cmljdCc7XG5cdC8vIElFIDwxMCBpcyBleHBsaWNpdGx5IHVuc3VwcG9ydGVkXG5cdGlmIChcblx0XHR0eXBlb2YgdmlldyA9PT0gJ3VuZGVmaW5lZCcgfHxcblx0XHQodHlwZW9mIG5hdmlnYXRvciAhPT0gJ3VuZGVmaW5lZCcgJiZcblx0XHRcdC9NU0lFIFsxLTldXFwuLy50ZXN0KG5hdmlnYXRvci51c2VyQWdlbnQpKVxuXHQpIHtcblx0XHRyZXR1cm47XG5cdH1cblx0dmFyIGRvYyA9IHZpZXcuZG9jdW1lbnQsXG5cdFx0Ly8gb25seSBnZXQgVVJMIHdoZW4gbmVjZXNzYXJ5IGluIGNhc2UgQmxvYi5qcyBoYXNuJ3Qgb3ZlcnJpZGRlbiBpdCB5ZXRcblx0XHRnZXRfVVJMID0gZnVuY3Rpb24gKCkge1xuXHRcdFx0cmV0dXJuIHZpZXcuVVJMIHx8IHZpZXcud2Via2l0VVJMIHx8IHZpZXc7XG5cdFx0fSxcblx0XHRzYXZlX2xpbmsgPSBkb2MuY3JlYXRlRWxlbWVudE5TKCdodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hodG1sJywgJ2EnKSxcblx0XHRjYW5fdXNlX3NhdmVfbGluayA9ICdkb3dubG9hZCcgaW4gc2F2ZV9saW5rLFxuXHRcdGNsaWNrID0gZnVuY3Rpb24gKG5vZGUpIHtcblx0XHRcdHZhciBldmVudCA9IG5ldyBNb3VzZUV2ZW50KCdjbGljaycpO1xuXHRcdFx0bm9kZS5kaXNwYXRjaEV2ZW50KGV2ZW50KTtcblx0XHR9LFxuXHRcdGlzX3NhZmFyaSA9IC9jb25zdHJ1Y3Rvci9pLnRlc3Qodmlldy5IVE1MRWxlbWVudCkgfHwgdmlldy5zYWZhcmksXG5cdFx0aXNfY2hyb21lX2lvcyA9IC9DcmlPU1xcL1tcXGRdKy8udGVzdChuYXZpZ2F0b3IudXNlckFnZW50KSxcblx0XHR0aHJvd19vdXRzaWRlID0gZnVuY3Rpb24gKGV4KSB7XG5cdFx0XHQodmlldy5zZXRJbW1lZGlhdGUgfHwgdmlldy5zZXRUaW1lb3V0KShmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdHRocm93IGV4O1xuXHRcdFx0fSwgMCk7XG5cdFx0fSxcblx0XHRmb3JjZV9zYXZlYWJsZV90eXBlID0gJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbScsXG5cdFx0Ly8gdGhlIEJsb2IgQVBJIGlzIGZ1bmRhbWVudGFsbHkgYnJva2VuIGFzIHRoZXJlIGlzIG5vIFwiZG93bmxvYWRmaW5pc2hlZFwiIGV2ZW50IHRvIHN1YnNjcmliZSB0b1xuXHRcdGFyYml0cmFyeV9yZXZva2VfdGltZW91dCA9IDEwMDAgKiA0MCwgLy8gaW4gbXNcblx0XHRyZXZva2UgPSBmdW5jdGlvbiAoZmlsZSkge1xuXHRcdFx0dmFyIHJldm9rZXIgPSBmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdGlmICh0eXBlb2YgZmlsZSA9PT0gJ3N0cmluZycpIHtcblx0XHRcdFx0XHQvLyBmaWxlIGlzIGFuIG9iamVjdCBVUkxcblx0XHRcdFx0XHRnZXRfVVJMKCkucmV2b2tlT2JqZWN0VVJMKGZpbGUpO1xuXHRcdFx0XHR9XG5cdFx0XHRcdGVsc2Uge1xuXHRcdFx0XHRcdC8vIGZpbGUgaXMgYSBGaWxlXG5cdFx0XHRcdFx0ZmlsZS5yZW1vdmUoKTtcblx0XHRcdFx0fVxuXHRcdFx0fTtcblx0XHRcdHNldFRpbWVvdXQocmV2b2tlciwgYXJiaXRyYXJ5X3Jldm9rZV90aW1lb3V0KTtcblx0XHR9LFxuXHRcdGRpc3BhdGNoID0gZnVuY3Rpb24gKGZpbGVzYXZlciwgZXZlbnRfdHlwZXMsIGV2ZW50KSB7XG5cdFx0XHRldmVudF90eXBlcyA9IFtdLmNvbmNhdChldmVudF90eXBlcyk7XG5cdFx0XHR2YXIgaSA9IGV2ZW50X3R5cGVzLmxlbmd0aDtcblx0XHRcdHdoaWxlIChpLS0pIHtcblx0XHRcdFx0dmFyIGxpc3RlbmVyID0gZmlsZXNhdmVyWydvbicgKyBldmVudF90eXBlc1tpXV07XG5cdFx0XHRcdGlmICh0eXBlb2YgbGlzdGVuZXIgPT09ICdmdW5jdGlvbicpIHtcblx0XHRcdFx0XHR0cnkge1xuXHRcdFx0XHRcdFx0bGlzdGVuZXIuY2FsbChmaWxlc2F2ZXIsIGV2ZW50IHx8IGZpbGVzYXZlcik7XG5cdFx0XHRcdFx0fSBjYXRjaCAoZXgpIHtcblx0XHRcdFx0XHRcdHRocm93X291dHNpZGUoZXgpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fVxuXHRcdFx0fVxuXHRcdH0sXG5cdFx0YXV0b19ib20gPSBmdW5jdGlvbiAoYmxvYikge1xuXHRcdFx0Ly8gcHJlcGVuZCBCT00gZm9yIFVURi04IFhNTCBhbmQgdGV4dC8qIHR5cGVzIChpbmNsdWRpbmcgSFRNTClcblx0XHRcdC8vIG5vdGU6IHlvdXIgYnJvd3NlciB3aWxsIGF1dG9tYXRpY2FsbHkgY29udmVydCBVVEYtMTYgVStGRUZGIHRvIEVGIEJCIEJGXG5cdFx0XHRpZiAoXG5cdFx0XHRcdC9eXFxzKig/OnRleHRcXC9cXFMqfGFwcGxpY2F0aW9uXFwveG1sfFxcUypcXC9cXFMqXFwreG1sKVxccyo7LipjaGFyc2V0XFxzKj1cXHMqdXRmLTgvaS50ZXN0KFxuXHRcdFx0XHRcdGJsb2IudHlwZVxuXHRcdFx0XHQpXG5cdFx0XHQpIHtcblx0XHRcdFx0cmV0dXJuIG5ldyBCbG9iKFtTdHJpbmcuZnJvbUNoYXJDb2RlKDB4ZmVmZiksIGJsb2JdLCB7XG5cdFx0XHRcdFx0dHlwZTogYmxvYi50eXBlXG5cdFx0XHRcdH0pO1xuXHRcdFx0fVxuXHRcdFx0cmV0dXJuIGJsb2I7XG5cdFx0fSxcblx0XHRGaWxlU2F2ZXIgPSBmdW5jdGlvbiAoYmxvYiwgbmFtZSwgbm9fYXV0b19ib20pIHtcblx0XHRcdGlmICghbm9fYXV0b19ib20pIHtcblx0XHRcdFx0YmxvYiA9IGF1dG9fYm9tKGJsb2IpO1xuXHRcdFx0fVxuXHRcdFx0Ly8gRmlyc3QgdHJ5IGEuZG93bmxvYWQsIHRoZW4gd2ViIGZpbGVzeXN0ZW0sIHRoZW4gb2JqZWN0IFVSTHNcblx0XHRcdHZhciBmaWxlc2F2ZXIgPSB0aGlzLFxuXHRcdFx0XHR0eXBlID0gYmxvYi50eXBlLFxuXHRcdFx0XHRmb3JjZSA9IHR5cGUgPT09IGZvcmNlX3NhdmVhYmxlX3R5cGUsXG5cdFx0XHRcdG9iamVjdF91cmwsXG5cdFx0XHRcdGRpc3BhdGNoX2FsbCA9IGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0XHRkaXNwYXRjaChcblx0XHRcdFx0XHRcdGZpbGVzYXZlcixcblx0XHRcdFx0XHRcdCd3cml0ZXN0YXJ0IHByb2dyZXNzIHdyaXRlIHdyaXRlZW5kJy5zcGxpdCgnICcpXG5cdFx0XHRcdFx0KTtcblx0XHRcdFx0fSxcblx0XHRcdFx0Ly8gb24gYW55IGZpbGVzeXMgZXJyb3JzIHJldmVydCB0byBzYXZpbmcgd2l0aCBvYmplY3QgVVJMc1xuXHRcdFx0XHRmc19lcnJvciA9IGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0XHRpZiAoXG5cdFx0XHRcdFx0XHQoaXNfY2hyb21lX2lvcyB8fCAoZm9yY2UgJiYgaXNfc2FmYXJpKSkgJiZcblx0XHRcdFx0XHRcdHZpZXcuRmlsZVJlYWRlclxuXHRcdFx0XHRcdCkge1xuXHRcdFx0XHRcdFx0Ly8gU2FmYXJpIGRvZXNuJ3QgYWxsb3cgZG93bmxvYWRpbmcgb2YgYmxvYiB1cmxzXG5cdFx0XHRcdFx0XHR2YXIgcmVhZGVyID0gbmV3IEZpbGVSZWFkZXIoKTtcblx0XHRcdFx0XHRcdHJlYWRlci5vbmxvYWRlbmQgPSBmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdFx0XHRcdHZhciB1cmwgPSBpc19jaHJvbWVfaW9zXG5cdFx0XHRcdFx0XHRcdFx0PyByZWFkZXIucmVzdWx0XG5cdFx0XHRcdFx0XHRcdFx0OiByZWFkZXIucmVzdWx0LnJlcGxhY2UoXG5cdFx0XHRcdFx0XHRcdFx0XHRcdC9eZGF0YTpbXjtdKjsvLFxuXHRcdFx0XHRcdFx0XHRcdFx0XHQnZGF0YTphdHRhY2htZW50L2ZpbGU7J1xuXHRcdFx0XHRcdFx0XHRcdCk7XG5cdFx0XHRcdFx0XHRcdHZhciBwb3B1cCA9IHZpZXcub3Blbih1cmwsICdfYmxhbmsnKTtcblx0XHRcdFx0XHRcdFx0aWYgKCFwb3B1cCkgdmlldy5sb2NhdGlvbi5ocmVmID0gdXJsO1xuXHRcdFx0XHRcdFx0XHR1cmwgPSB1bmRlZmluZWQ7IC8vIHJlbGVhc2UgcmVmZXJlbmNlIGJlZm9yZSBkaXNwYXRjaGluZ1xuXHRcdFx0XHRcdFx0XHRmaWxlc2F2ZXIucmVhZHlTdGF0ZSA9IGZpbGVzYXZlci5ET05FO1xuXHRcdFx0XHRcdFx0XHRkaXNwYXRjaF9hbGwoKTtcblx0XHRcdFx0XHRcdH07XG5cdFx0XHRcdFx0XHRyZWFkZXIucmVhZEFzRGF0YVVSTChibG9iKTtcblx0XHRcdFx0XHRcdGZpbGVzYXZlci5yZWFkeVN0YXRlID0gZmlsZXNhdmVyLklOSVQ7XG5cdFx0XHRcdFx0XHRyZXR1cm47XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdC8vIGRvbid0IGNyZWF0ZSBtb3JlIG9iamVjdCBVUkxzIHRoYW4gbmVlZGVkXG5cdFx0XHRcdFx0aWYgKCFvYmplY3RfdXJsKSB7XG5cdFx0XHRcdFx0XHRvYmplY3RfdXJsID0gZ2V0X1VSTCgpLmNyZWF0ZU9iamVjdFVSTChibG9iKTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0aWYgKGZvcmNlKSB7XG5cdFx0XHRcdFx0XHR2aWV3LmxvY2F0aW9uLmhyZWYgPSBvYmplY3RfdXJsO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0XHRlbHNlIHtcblx0XHRcdFx0XHRcdHZhciBvcGVuZWQgPSB2aWV3Lm9wZW4ob2JqZWN0X3VybCwgJ19ibGFuaycpO1xuXHRcdFx0XHRcdFx0aWYgKCFvcGVuZWQpIHtcblx0XHRcdFx0XHRcdFx0Ly8gQXBwbGUgZG9lcyBub3QgYWxsb3cgd2luZG93Lm9wZW4sIHNlZSBodHRwczovL2RldmVsb3Blci5hcHBsZS5jb20vbGlicmFyeS9zYWZhcmkvZG9jdW1lbnRhdGlvbi9Ub29scy9Db25jZXB0dWFsL1NhZmFyaUV4dGVuc2lvbkd1aWRlL1dvcmtpbmd3aXRoV2luZG93c2FuZFRhYnMvV29ya2luZ3dpdGhXaW5kb3dzYW5kVGFicy5odG1sXG5cdFx0XHRcdFx0XHRcdHZpZXcubG9jYXRpb24uaHJlZiA9IG9iamVjdF91cmw7XG5cdFx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdGZpbGVzYXZlci5yZWFkeVN0YXRlID0gZmlsZXNhdmVyLkRPTkU7XG5cdFx0XHRcdFx0ZGlzcGF0Y2hfYWxsKCk7XG5cdFx0XHRcdFx0cmV2b2tlKG9iamVjdF91cmwpO1xuXHRcdFx0XHR9O1xuXHRcdFx0ZmlsZXNhdmVyLnJlYWR5U3RhdGUgPSBmaWxlc2F2ZXIuSU5JVDtcblxuXHRcdFx0aWYgKGNhbl91c2Vfc2F2ZV9saW5rKSB7XG5cdFx0XHRcdG9iamVjdF91cmwgPSBnZXRfVVJMKCkuY3JlYXRlT2JqZWN0VVJMKGJsb2IpO1xuXHRcdFx0XHRzZXRUaW1lb3V0KGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0XHRzYXZlX2xpbmsuaHJlZiA9IG9iamVjdF91cmw7XG5cdFx0XHRcdFx0c2F2ZV9saW5rLmRvd25sb2FkID0gbmFtZTtcblx0XHRcdFx0XHRjbGljayhzYXZlX2xpbmspO1xuXHRcdFx0XHRcdGRpc3BhdGNoX2FsbCgpO1xuXHRcdFx0XHRcdHJldm9rZShvYmplY3RfdXJsKTtcblx0XHRcdFx0XHRmaWxlc2F2ZXIucmVhZHlTdGF0ZSA9IGZpbGVzYXZlci5ET05FO1xuXHRcdFx0XHR9KTtcblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHRmc19lcnJvcigpO1xuXHRcdH0sXG5cdFx0RlNfcHJvdG8gPSBGaWxlU2F2ZXIucHJvdG90eXBlLFxuXHRcdHNhdmVBcyA9IGZ1bmN0aW9uIChibG9iLCBuYW1lLCBub19hdXRvX2JvbSkge1xuXHRcdFx0cmV0dXJuIG5ldyBGaWxlU2F2ZXIoXG5cdFx0XHRcdGJsb2IsXG5cdFx0XHRcdG5hbWUgfHwgYmxvYi5uYW1lIHx8ICdkb3dubG9hZCcsXG5cdFx0XHRcdG5vX2F1dG9fYm9tXG5cdFx0XHQpO1xuXHRcdH07XG5cdC8vIElFIDEwKyAobmF0aXZlIHNhdmVBcylcblx0aWYgKHR5cGVvZiBuYXZpZ2F0b3IgIT09ICd1bmRlZmluZWQnICYmIG5hdmlnYXRvci5tc1NhdmVPck9wZW5CbG9iKSB7XG5cdFx0cmV0dXJuIGZ1bmN0aW9uIChibG9iLCBuYW1lLCBub19hdXRvX2JvbSkge1xuXHRcdFx0bmFtZSA9IG5hbWUgfHwgYmxvYi5uYW1lIHx8ICdkb3dubG9hZCc7XG5cblx0XHRcdGlmICghbm9fYXV0b19ib20pIHtcblx0XHRcdFx0YmxvYiA9IGF1dG9fYm9tKGJsb2IpO1xuXHRcdFx0fVxuXHRcdFx0cmV0dXJuIG5hdmlnYXRvci5tc1NhdmVPck9wZW5CbG9iKGJsb2IsIG5hbWUpO1xuXHRcdH07XG5cdH1cblxuXHRGU19wcm90by5hYm9ydCA9IGZ1bmN0aW9uICgpIHt9O1xuXHRGU19wcm90by5yZWFkeVN0YXRlID0gRlNfcHJvdG8uSU5JVCA9IDA7XG5cdEZTX3Byb3RvLldSSVRJTkcgPSAxO1xuXHRGU19wcm90by5ET05FID0gMjtcblxuXHRGU19wcm90by5lcnJvciA9XG5cdFx0RlNfcHJvdG8ub253cml0ZXN0YXJ0ID1cblx0XHRGU19wcm90by5vbnByb2dyZXNzID1cblx0XHRGU19wcm90by5vbndyaXRlID1cblx0XHRGU19wcm90by5vbmFib3J0ID1cblx0XHRGU19wcm90by5vbmVycm9yID1cblx0XHRGU19wcm90by5vbndyaXRlZW5kID1cblx0XHRcdG51bGw7XG5cblx0cmV0dXJuIHNhdmVBcztcbn0pKFxuXHQodHlwZW9mIHNlbGYgIT09ICd1bmRlZmluZWQnICYmIHNlbGYpIHx8XG5cdFx0KHR5cGVvZiB3aW5kb3cgIT09ICd1bmRlZmluZWQnICYmIHdpbmRvdykgfHxcblx0XHR0aGlzLmNvbnRlbnRcbik7XG5cbi8vIEV4cG9zZSBmaWxlIHNhdmVyIG9uIHRoZSBEYXRhVGFibGVzIEFQSS4gQ2FuJ3QgYXR0YWNoIHRvIGBEYXRhVGFibGVzLkJ1dHRvbnNgXG4vLyBzaW5jZSB0aGlzIGZpbGUgY2FuIGJlIGxvYWRlZCBiZWZvcmUgQnV0dG9uJ3MgY29yZSFcbkRhdGFUYWJsZS5maWxlU2F2ZSA9IF9zYXZlQXM7XG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogTG9jYWwgKHByaXZhdGUpIGZ1bmN0aW9uc1xuICovXG5cbi8qKlxuICogR2V0IHRoZSBzaGVldCBuYW1lIGZvciBFeGNlbCBleHBvcnRzLlxuICpcbiAqIEBwYXJhbSB7b2JqZWN0fVx0Y29uZmlnIEJ1dHRvbiBjb25maWd1cmF0aW9uXG4gKi9cbnZhciBfc2hlZXRuYW1lID0gZnVuY3Rpb24gKGNvbmZpZykge1xuXHR2YXIgc2hlZXROYW1lID0gJ1NoZWV0MSc7XG5cblx0aWYgKGNvbmZpZy5zaGVldE5hbWUpIHtcblx0XHRzaGVldE5hbWUgPSBjb25maWcuc2hlZXROYW1lLnJlcGxhY2UoL1tcXFtcXF1cXCpcXC9cXFxcXFw/XFw6XS9nLCAnJyk7XG5cdH1cblxuXHRyZXR1cm4gc2hlZXROYW1lO1xufTtcblxuLyoqXG4gKiBHZXQgdGhlIG5ld2xpbmUgY2hhcmFjdGVyKHMpXG4gKlxuICogQHBhcmFtIHtvYmplY3R9XHRjb25maWcgQnV0dG9uIGNvbmZpZ3VyYXRpb25cbiAqIEByZXR1cm4ge3N0cmluZ31cdFx0XHRcdE5ld2xpbmUgY2hhcmFjdGVyXG4gKi9cbnZhciBfbmV3TGluZSA9IGZ1bmN0aW9uIChjb25maWcpIHtcblx0cmV0dXJuIGNvbmZpZy5uZXdsaW5lXG5cdFx0PyBjb25maWcubmV3bGluZVxuXHRcdDogbmF2aWdhdG9yLnVzZXJBZ2VudC5tYXRjaCgvV2luZG93cy8pXG5cdFx0PyAnXFxyXFxuJ1xuXHRcdDogJ1xcbic7XG59O1xuXG4vKipcbiAqIENvbWJpbmUgdGhlIGRhdGEgZnJvbSB0aGUgYGJ1dHRvbnMuZXhwb3J0RGF0YWAgbWV0aG9kIGludG8gYSBzdHJpbmcgdGhhdFxuICogd2lsbCBiZSB1c2VkIGluIHRoZSBleHBvcnQgZmlsZS5cbiAqXG4gKiBAcGFyYW1cdHtEYXRhVGFibGUuQXBpfSBkdFx0XHQgRGF0YVRhYmxlcyBBUEkgaW5zdGFuY2VcbiAqIEBwYXJhbVx0e29iamVjdH1cdFx0XHRcdGNvbmZpZyBCdXR0b24gY29uZmlndXJhdGlvblxuICogQHJldHVybiB7b2JqZWN0fVx0XHRcdFx0XHRcdFx0IFRoZSBkYXRhIHRvIGV4cG9ydFxuICovXG52YXIgX2V4cG9ydERhdGEgPSBmdW5jdGlvbiAoZHQsIGNvbmZpZykge1xuXHR2YXIgbmV3TGluZSA9IF9uZXdMaW5lKGNvbmZpZyk7XG5cdHZhciBkYXRhID0gZHQuYnV0dG9ucy5leHBvcnREYXRhKGNvbmZpZy5leHBvcnRPcHRpb25zKTtcblx0dmFyIGJvdW5kYXJ5ID0gY29uZmlnLmZpZWxkQm91bmRhcnk7XG5cdHZhciBzZXBhcmF0b3IgPSBjb25maWcuZmllbGRTZXBhcmF0b3I7XG5cdHZhciByZUJvdW5kYXJ5ID0gbmV3IFJlZ0V4cChib3VuZGFyeSwgJ2cnKTtcblx0dmFyIGVzY2FwZUNoYXIgPSBjb25maWcuZXNjYXBlQ2hhciAhPT0gdW5kZWZpbmVkID8gY29uZmlnLmVzY2FwZUNoYXIgOiAnXFxcXCc7XG5cdHZhciBqb2luID0gZnVuY3Rpb24gKGEpIHtcblx0XHR2YXIgcyA9ICcnO1xuXG5cdFx0Ly8gSWYgdGhlcmUgaXMgYSBmaWVsZCBib3VuZGFyeSwgdGhlbiB3ZSBtaWdodCBuZWVkIHRvIGVzY2FwZSBpdCBpblxuXHRcdC8vIHRoZSBzb3VyY2UgZGF0YVxuXHRcdGZvciAodmFyIGkgPSAwLCBpZW4gPSBhLmxlbmd0aDsgaSA8IGllbjsgaSsrKSB7XG5cdFx0XHRpZiAoaSA+IDApIHtcblx0XHRcdFx0cyArPSBzZXBhcmF0b3I7XG5cdFx0XHR9XG5cblx0XHRcdHMgKz0gYm91bmRhcnlcblx0XHRcdFx0PyBib3VuZGFyeSArXG5cdFx0XHRcdCgnJyArIGFbaV0pLnJlcGxhY2UocmVCb3VuZGFyeSwgZXNjYXBlQ2hhciArIGJvdW5kYXJ5KSArXG5cdFx0XHRcdGJvdW5kYXJ5XG5cdFx0XHRcdDogYVtpXTtcblx0XHR9XG5cblx0XHRyZXR1cm4gcztcblx0fTtcblxuXHR2YXIgaGVhZGVyID0gJyc7XG5cdHZhciBmb290ZXIgPSAnJztcblx0dmFyIGJvZHkgPSBbXTtcblxuXHRpZiAoY29uZmlnLmhlYWRlcikge1xuXHRcdGhlYWRlciA9XG5cdFx0XHRkYXRhLmhlYWRlclN0cnVjdHVyZVxuXHRcdFx0XHQubWFwKGZ1bmN0aW9uIChyb3cpIHtcblx0XHRcdFx0XHRyZXR1cm4gam9pbihcblx0XHRcdFx0XHRcdHJvdy5tYXAoZnVuY3Rpb24gKGNlbGwpIHtcblx0XHRcdFx0XHRcdFx0cmV0dXJuIGNlbGwgPyBjZWxsLnRpdGxlIDogJyc7XG5cdFx0XHRcdFx0XHR9KVxuXHRcdFx0XHRcdCk7XG5cdFx0XHRcdH0pXG5cdFx0XHRcdC5qb2luKG5ld0xpbmUpICsgbmV3TGluZTtcblx0fVxuXG5cdGlmIChjb25maWcuZm9vdGVyICYmIGRhdGEuZm9vdGVyKSB7XG5cdFx0Zm9vdGVyID1cblx0XHRcdGRhdGEuZm9vdGVyU3RydWN0dXJlXG5cdFx0XHRcdC5tYXAoZnVuY3Rpb24gKHJvdykge1xuXHRcdFx0XHRcdHJldHVybiBqb2luKFxuXHRcdFx0XHRcdFx0cm93Lm1hcChmdW5jdGlvbiAoY2VsbCkge1xuXHRcdFx0XHRcdFx0XHRyZXR1cm4gY2VsbCA/IGNlbGwudGl0bGUgOiAnJztcblx0XHRcdFx0XHRcdH0pXG5cdFx0XHRcdFx0KTtcblx0XHRcdFx0fSlcblx0XHRcdFx0LmpvaW4obmV3TGluZSkgKyBuZXdMaW5lO1xuXHR9XG5cblx0Zm9yICh2YXIgaSA9IDAsIGllbiA9IGRhdGEuYm9keS5sZW5ndGg7IGkgPCBpZW47IGkrKykge1xuXHRcdGJvZHkucHVzaChqb2luKGRhdGEuYm9keVtpXSkpO1xuXHR9XG5cblx0cmV0dXJuIHtcblx0XHRzdHI6IGhlYWRlciArIGJvZHkuam9pbihuZXdMaW5lKSArIG5ld0xpbmUgKyBmb290ZXIsXG5cdFx0cm93czogYm9keS5sZW5ndGhcblx0fTtcbn07XG5cbi8qKlxuICogT2xkZXIgdmVyc2lvbnMgb2YgU2FmYXJpIChwcmlvciB0byB0ZWNoIHByZXZpZXcgMTgpIGRvbid0IHN1cHBvcnQgdGhlXG4gKiBkb3dubG9hZCBvcHRpb24gcmVxdWlyZWQuXG4gKlxuICogQHJldHVybiB7Qm9vbGVhbn0gYHRydWVgIGlmIG9sZCBTYWZhcmlcbiAqL1xudmFyIF9pc0R1ZmZTYWZhcmkgPSBmdW5jdGlvbiAoKSB7XG5cdHZhciBzYWZhcmkgPVxuXHRcdG5hdmlnYXRvci51c2VyQWdlbnQuaW5kZXhPZignU2FmYXJpJykgIT09IC0xICYmXG5cdFx0bmF2aWdhdG9yLnVzZXJBZ2VudC5pbmRleE9mKCdDaHJvbWUnKSA9PT0gLTEgJiZcblx0XHRuYXZpZ2F0b3IudXNlckFnZW50LmluZGV4T2YoJ09wZXJhJykgPT09IC0xO1xuXG5cdGlmICghc2FmYXJpKSB7XG5cdFx0cmV0dXJuIGZhbHNlO1xuXHR9XG5cblx0dmFyIHZlcnNpb24gPSBuYXZpZ2F0b3IudXNlckFnZW50Lm1hdGNoKC9BcHBsZVdlYktpdFxcLyhcXGQrXFwuXFxkKykvKTtcblx0aWYgKHZlcnNpb24gJiYgdmVyc2lvbi5sZW5ndGggPiAxICYmIHZlcnNpb25bMV0gKiAxIDwgNjAzLjEpIHtcblx0XHRyZXR1cm4gdHJ1ZTtcblx0fVxuXG5cdHJldHVybiBmYWxzZTtcbn07XG5cbi8qKlxuICogQ29udmVydCBmcm9tIG51bWVyaWMgcG9zaXRpb24gdG8gbGV0dGVyIGZvciBjb2x1bW4gbmFtZXMgaW4gRXhjZWxcbiAqIEBwYXJhbSAge2ludH0gbiBDb2x1bW4gbnVtYmVyXG4gKiBAcmV0dXJuIHtzdHJpbmd9IENvbHVtbiBsZXR0ZXIocykgbmFtZVxuICovXG5mdW5jdGlvbiBjcmVhdGVDZWxsUG9zKG4pIHtcblx0dmFyIG9yZEEgPSAnQScuY2hhckNvZGVBdCgwKTtcblx0dmFyIG9yZFogPSAnWicuY2hhckNvZGVBdCgwKTtcblx0dmFyIGxlbiA9IG9yZFogLSBvcmRBICsgMTtcblx0dmFyIHMgPSAnJztcblxuXHR3aGlsZSAobiA+PSAwKSB7XG5cdFx0cyA9IFN0cmluZy5mcm9tQ2hhckNvZGUoKG4gJSBsZW4pICsgb3JkQSkgKyBzO1xuXHRcdG4gPSBNYXRoLmZsb29yKG4gLyBsZW4pIC0gMTtcblx0fVxuXG5cdHJldHVybiBzO1xufVxuXG50cnkge1xuXHR2YXIgX3NlcmlhbGlzZXIgPSBuZXcgWE1MU2VyaWFsaXplcigpO1xuXHR2YXIgX2llRXhjZWw7XG59IGNhdGNoICh0KSB7XG5cdC8vIG5vb3Bcbn1cblxuLyoqXG4gKiBSZWN1cnNpdmVseSBhZGQgWE1MIGZpbGVzIGZyb20gYW4gb2JqZWN0J3Mgc3RydWN0dXJlIHRvIGEgWklQIGZpbGUuIFRoaXNcbiAqIGFsbG93cyB0aGUgWFNMWCBmaWxlIHRvIGJlIGVhc2lseSBkZWZpbmVkIHdpdGggYW4gb2JqZWN0J3Mgc3RydWN0dXJlIG1hdGNoaW5nXG4gKiB0aGUgZmlsZXMgc3RydWN0dXJlLlxuICpcbiAqIEBwYXJhbSB7SlNaaXB9IHppcCBaSVAgcGFja2FnZVxuICogQHBhcmFtIHtvYmplY3R9IG9iaiBPYmplY3QgdG8gYWRkIChyZWN1cnNpdmUpXG4gKi9cbmZ1bmN0aW9uIF9hZGRUb1ppcCh6aXAsIG9iaikge1xuXHRpZiAoX2llRXhjZWwgPT09IHVuZGVmaW5lZCkge1xuXHRcdC8vIERldGVjdCBpZiB3ZSBhcmUgZGVhbGluZyB3aXRoIElFJ3MgX2F3ZnVsXyBzZXJpYWxpc2VyIGJ5IHNlZWluZyBpZiBpdFxuXHRcdC8vIGRyb3AgYXR0cmlidXRlc1xuXHRcdF9pZUV4Y2VsID1cblx0XHRcdF9zZXJpYWxpc2VyXG5cdFx0XHRcdC5zZXJpYWxpemVUb1N0cmluZyhcblx0XHRcdFx0XHRuZXcgd2luZG93LkRPTVBhcnNlcigpLnBhcnNlRnJvbVN0cmluZyhcblx0XHRcdFx0XHRcdGV4Y2VsU3RyaW5nc1sneGwvd29ya3NoZWV0cy9zaGVldDEueG1sJ10sXG5cdFx0XHRcdFx0XHQndGV4dC94bWwnXG5cdFx0XHRcdFx0KVxuXHRcdFx0XHQpXG5cdFx0XHRcdC5pbmRleE9mKCd4bWxuczpyJykgPT09IC0xO1xuXHR9XG5cblx0JC5lYWNoKG9iaiwgZnVuY3Rpb24gKG5hbWUsIHZhbCkge1xuXHRcdGlmICgkLmlzUGxhaW5PYmplY3QodmFsKSkge1xuXHRcdFx0dmFyIG5ld0RpciA9IHppcC5mb2xkZXIobmFtZSk7XG5cdFx0XHRfYWRkVG9aaXAobmV3RGlyLCB2YWwpO1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGlmIChfaWVFeGNlbCkge1xuXHRcdFx0XHQvLyBJRSdzIFhNTCBzZXJpYWxpc2VyIHdpbGwgZHJvcCBzb21lIG5hbWUgc3BhY2UgYXR0cmlidXRlcyBmcm9tXG5cdFx0XHRcdC8vIGZyb20gdGhlIHJvb3Qgbm9kZSwgc28gd2UgbmVlZCB0byBzYXZlIHRoZW0uIERvIHRoaXMgYnlcblx0XHRcdFx0Ly8gcmVwbGFjaW5nIHRoZSBuYW1lc3BhY2Ugbm9kZXMgd2l0aCBhIHJlZ3VsYXIgYXR0cmlidXRlIHRoYXRcblx0XHRcdFx0Ly8gd2UgY29udmVydCBiYWNrIHdoZW4gc2VyaWFsaXNlZC4gRWRnZSBkb2VzIG5vdCBoYXZlIHRoaXNcblx0XHRcdFx0Ly8gaXNzdWVcblx0XHRcdFx0dmFyIHdvcmtzaGVldCA9IHZhbC5jaGlsZE5vZGVzWzBdO1xuXHRcdFx0XHR2YXIgaSwgaWVuO1xuXHRcdFx0XHR2YXIgYXR0cnMgPSBbXTtcblxuXHRcdFx0XHRmb3IgKGkgPSB3b3Jrc2hlZXQuYXR0cmlidXRlcy5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xuXHRcdFx0XHRcdHZhciBhdHRyTmFtZSA9IHdvcmtzaGVldC5hdHRyaWJ1dGVzW2ldLm5vZGVOYW1lO1xuXHRcdFx0XHRcdHZhciBhdHRyVmFsdWUgPSB3b3Jrc2hlZXQuYXR0cmlidXRlc1tpXS5ub2RlVmFsdWU7XG5cblx0XHRcdFx0XHRpZiAoYXR0ck5hbWUuaW5kZXhPZignOicpICE9PSAtMSkge1xuXHRcdFx0XHRcdFx0YXR0cnMucHVzaCh7IG5hbWU6IGF0dHJOYW1lLCB2YWx1ZTogYXR0clZhbHVlIH0pO1xuXG5cdFx0XHRcdFx0XHR3b3Jrc2hlZXQucmVtb3ZlQXR0cmlidXRlKGF0dHJOYW1lKTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdH1cblxuXHRcdFx0XHRmb3IgKGkgPSAwLCBpZW4gPSBhdHRycy5sZW5ndGg7IGkgPCBpZW47IGkrKykge1xuXHRcdFx0XHRcdHZhciBhdHRyID0gdmFsLmNyZWF0ZUF0dHJpYnV0ZShcblx0XHRcdFx0XHRcdGF0dHJzW2ldLm5hbWUucmVwbGFjZSgnOicsICdfZHRfYl9uYW1lc3BhY2VfdG9rZW5fJylcblx0XHRcdFx0XHQpO1xuXHRcdFx0XHRcdGF0dHIudmFsdWUgPSBhdHRyc1tpXS52YWx1ZTtcblx0XHRcdFx0XHR3b3Jrc2hlZXQuc2V0QXR0cmlidXRlTm9kZShhdHRyKTtcblx0XHRcdFx0fVxuXHRcdFx0fVxuXG5cdFx0XHR2YXIgc3RyID0gX3NlcmlhbGlzZXIuc2VyaWFsaXplVG9TdHJpbmcodmFsKTtcblxuXHRcdFx0Ly8gRml4IElFJ3MgWE1MXG5cdFx0XHRpZiAoX2llRXhjZWwpIHtcblx0XHRcdFx0Ly8gSUUgZG9lc24ndCBpbmNsdWRlIHRoZSBYTUwgZGVjbGFyYXRpb25cblx0XHRcdFx0aWYgKHN0ci5pbmRleE9mKCc8P3htbCcpID09PSAtMSkge1xuXHRcdFx0XHRcdHN0ciA9XG5cdFx0XHRcdFx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicgK1xuXHRcdFx0XHRcdFx0c3RyO1xuXHRcdFx0XHR9XG5cblx0XHRcdFx0Ly8gUmV0dXJuIG5hbWVzcGFjZSBhdHRyaWJ1dGVzIHRvIGJlaW5nIGFzIHN1Y2hcblx0XHRcdFx0c3RyID0gc3RyLnJlcGxhY2UoL19kdF9iX25hbWVzcGFjZV90b2tlbl8vZywgJzonKTtcblxuXHRcdFx0XHQvLyBSZW1vdmUgdGVzdGluZyBuYW1lIHNwYWNlIHRoYXQgSUUgcHV0cyBpbnRvIHRoZSBzcGFjZSBwcmVzZXJ2ZSBhdHRyXG5cdFx0XHRcdHN0ciA9IHN0ci5yZXBsYWNlKC94bWxuczpOU1tcXGRdKz1cIlwiIE5TW1xcZF0rOi9nLCAnJyk7XG5cdFx0XHR9XG5cblx0XHRcdC8vIFNhZmFyaSwgSUUgYW5kIEVkZ2Ugd2lsbCBwdXQgZW1wdHkgbmFtZSBzcGFjZSBhdHRyaWJ1dGVzIG9udG9cblx0XHRcdC8vIHZhcmlvdXMgZWxlbWVudHMgbWFraW5nIHRoZW0gdXNlbGVzcy4gVGhpcyBzdHJpcHMgdGhlbSBvdXRcblx0XHRcdHN0ciA9IHN0ci5yZXBsYWNlKC88KFtePD5dKj8pIHhtbG5zPVwiXCIoW148Pl0qPyk+L2csICc8JDEgJDI+Jyk7XG5cblx0XHRcdHppcC5maWxlKG5hbWUsIHN0cik7XG5cdFx0fVxuXHR9KTtcbn1cblxuLyoqXG4gKiBDcmVhdGUgYW4gWE1MIG5vZGUgYW5kIGFkZCBhbnkgY2hpbGRyZW4sIGF0dHJpYnV0ZXMsIGV0YyB3aXRob3V0IG5lZWRpbmcgdG9cbiAqIGJlIHZlcmJvc2UgaW4gdGhlIERPTS5cbiAqXG4gKiBAcGFyYW0gIHtvYmplY3R9IGRvYyAgICAgIFhNTCBkb2N1bWVudFxuICogQHBhcmFtICB7c3RyaW5nfSBub2RlTmFtZSBOb2RlIG5hbWVcbiAqIEBwYXJhbSAge29iamVjdH0gb3B0cyAgICAgT3B0aW9ucyAtIGNhbiBiZSBgYXR0cmAgKGF0dHJpYnV0ZXMpLCBgY2hpbGRyZW5gXG4gKiAgIChjaGlsZCBub2RlcykgYW5kIGB0ZXh0YCAodGV4dCBjb250ZW50KVxuICogQHJldHVybiB7bm9kZX0gICAgICAgICAgICBDcmVhdGVkIG5vZGVcbiAqL1xuZnVuY3Rpb24gX2NyZWF0ZU5vZGUoZG9jLCBub2RlTmFtZSwgb3B0cykge1xuXHR2YXIgdGVtcE5vZGUgPSBkb2MuY3JlYXRlRWxlbWVudChub2RlTmFtZSk7XG5cblx0aWYgKG9wdHMpIHtcblx0XHRpZiAob3B0cy5hdHRyKSB7XG5cdFx0XHQkKHRlbXBOb2RlKS5hdHRyKG9wdHMuYXR0cik7XG5cdFx0fVxuXG5cdFx0aWYgKG9wdHMuY2hpbGRyZW4pIHtcblx0XHRcdCQuZWFjaChvcHRzLmNoaWxkcmVuLCBmdW5jdGlvbiAoa2V5LCB2YWx1ZSkge1xuXHRcdFx0XHR0ZW1wTm9kZS5hcHBlbmRDaGlsZCh2YWx1ZSk7XG5cdFx0XHR9KTtcblx0XHR9XG5cblx0XHRpZiAob3B0cy50ZXh0ICE9PSBudWxsICYmIG9wdHMudGV4dCAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHR0ZW1wTm9kZS5hcHBlbmRDaGlsZChkb2MuY3JlYXRlVGV4dE5vZGUob3B0cy50ZXh0KSk7XG5cdFx0fVxuXHR9XG5cblx0cmV0dXJuIHRlbXBOb2RlO1xufVxuXG4vKipcbiAqIEdldCB0aGUgd2lkdGggZm9yIGFuIEV4Y2VsIGNvbHVtbiBiYXNlZCBvbiB0aGUgY29udGVudHMgb2YgdGhhdCBjb2x1bW5cbiAqIEBwYXJhbSAge29iamVjdH0gZGF0YSBEYXRhIGZvciBleHBvcnRcbiAqIEBwYXJhbSAge2ludH0gICAgY29sICBDb2x1bW4gaW5kZXhcbiAqIEByZXR1cm4ge2ludH0gICAgICAgICBDb2x1bW4gd2lkdGhcbiAqL1xuZnVuY3Rpb24gX2V4Y2VsQ29sV2lkdGgoZGF0YSwgY29sKSB7XG5cdHZhciBtYXggPSBkYXRhLmhlYWRlcltjb2xdLmxlbmd0aDtcblx0dmFyIGxlbiwgbGluZVNwbGl0LCBzdHI7XG5cblx0aWYgKGRhdGEuZm9vdGVyICYmIGRhdGEuZm9vdGVyW2NvbF0gJiYgZGF0YS5mb290ZXJbY29sXS5sZW5ndGggPiBtYXgpIHtcblx0XHRtYXggPSBkYXRhLmZvb3Rlcltjb2xdLmxlbmd0aDtcblx0fVxuXG5cdGZvciAodmFyIGkgPSAwLCBpZW4gPSBkYXRhLmJvZHkubGVuZ3RoOyBpIDwgaWVuOyBpKyspIHtcblx0XHR2YXIgcG9pbnQgPSBkYXRhLmJvZHlbaV1bY29sXTtcblx0XHRzdHIgPSBwb2ludCAhPT0gbnVsbCAmJiBwb2ludCAhPT0gdW5kZWZpbmVkID8gcG9pbnQudG9TdHJpbmcoKSA6ICcnO1xuXG5cdFx0Ly8gSWYgdGhlcmUgaXMgYSBuZXdsaW5lIGNoYXJhY3Rlciwgd29ya291dCB0aGUgd2lkdGggb2YgdGhlIGNvbHVtblxuXHRcdC8vIGJhc2VkIG9uIHRoZSBsb25nZXN0IGxpbmUgaW4gdGhlIHN0cmluZ1xuXHRcdGlmIChzdHIuaW5kZXhPZignXFxuJykgIT09IC0xKSB7XG5cdFx0XHRsaW5lU3BsaXQgPSBzdHIuc3BsaXQoJ1xcbicpO1xuXHRcdFx0bGluZVNwbGl0LnNvcnQoZnVuY3Rpb24gKGEsIGIpIHtcblx0XHRcdFx0cmV0dXJuIGIubGVuZ3RoIC0gYS5sZW5ndGg7XG5cdFx0XHR9KTtcblxuXHRcdFx0bGVuID0gbGluZVNwbGl0WzBdLmxlbmd0aDtcblx0XHR9XG5cdFx0ZWxzZSB7XG5cdFx0XHRsZW4gPSBzdHIubGVuZ3RoO1xuXHRcdH1cblxuXHRcdGlmIChsZW4gPiBtYXgpIHtcblx0XHRcdG1heCA9IGxlbjtcblx0XHR9XG5cblx0XHQvLyBNYXggd2lkdGggcmF0aGVyIHRoYW4gaGF2aW5nIHBvdGVudGlhbGx5IG1hc3NpdmUgY29sdW1uIHdpZHRoc1xuXHRcdGlmIChtYXggPiA0MCkge1xuXHRcdFx0cmV0dXJuIDU0OyAvLyA0MCAqIDEuMzVcblx0XHR9XG5cdH1cblxuXHRtYXggKj0gMS4zNTtcblxuXHQvLyBBbmQgYSBtaW4gd2lkdGhcblx0cmV0dXJuIG1heCA+IDYgPyBtYXggOiA2O1xufVxuXG4vLyBFeGNlbCAtIFByZS1kZWZpbmVkIHN0cmluZ3MgdG8gYnVpbGQgYSBiYXNpYyBYTFNYIGZpbGVcbnZhciBleGNlbFN0cmluZ3MgPSB7XG5cdCdfcmVscy8ucmVscyc6XG5cdFx0Jzw/eG1sIHZlcnNpb249XCIxLjBcIiBlbmNvZGluZz1cIlVURi04XCIgc3RhbmRhbG9uZT1cInllc1wiPz4nICtcblx0XHQnPFJlbGF0aW9uc2hpcHMgeG1sbnM9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvcGFja2FnZS8yMDA2L3JlbGF0aW9uc2hpcHNcIj4nICtcblx0XHQnPFJlbGF0aW9uc2hpcCBJZD1cInJJZDFcIiBUeXBlPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL29mZmljZURvY3VtZW50LzIwMDYvcmVsYXRpb25zaGlwcy9vZmZpY2VEb2N1bWVudFwiIFRhcmdldD1cInhsL3dvcmtib29rLnhtbFwiLz4nICtcblx0XHQnPC9SZWxhdGlvbnNoaXBzPicsXG5cblx0J3hsL19yZWxzL3dvcmtib29rLnhtbC5yZWxzJzpcblx0XHQnPD94bWwgdmVyc2lvbj1cIjEuMFwiIGVuY29kaW5nPVwiVVRGLThcIiBzdGFuZGFsb25lPVwieWVzXCI/PicgK1xuXHRcdCc8UmVsYXRpb25zaGlwcyB4bWxucz1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9wYWNrYWdlLzIwMDYvcmVsYXRpb25zaGlwc1wiPicgK1xuXHRcdCc8UmVsYXRpb25zaGlwIElkPVwicklkMVwiIFR5cGU9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvb2ZmaWNlRG9jdW1lbnQvMjAwNi9yZWxhdGlvbnNoaXBzL3dvcmtzaGVldFwiIFRhcmdldD1cIndvcmtzaGVldHMvc2hlZXQxLnhtbFwiLz4nICtcblx0XHQnPFJlbGF0aW9uc2hpcCBJZD1cInJJZDJcIiBUeXBlPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL29mZmljZURvY3VtZW50LzIwMDYvcmVsYXRpb25zaGlwcy9zdHlsZXNcIiBUYXJnZXQ9XCJzdHlsZXMueG1sXCIvPicgK1xuXHRcdCc8L1JlbGF0aW9uc2hpcHM+JyxcblxuXHQnW0NvbnRlbnRfVHlwZXNdLnhtbCc6XG5cdFx0Jzw/eG1sIHZlcnNpb249XCIxLjBcIiBlbmNvZGluZz1cIlVURi04XCIgc3RhbmRhbG9uZT1cInllc1wiPz4nICtcblx0XHQnPFR5cGVzIHhtbG5zPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL3BhY2thZ2UvMjAwNi9jb250ZW50LXR5cGVzXCI+JyArXG5cdFx0JzxEZWZhdWx0IEV4dGVuc2lvbj1cInhtbFwiIENvbnRlbnRUeXBlPVwiYXBwbGljYXRpb24veG1sXCIgLz4nICtcblx0XHQnPERlZmF1bHQgRXh0ZW5zaW9uPVwicmVsc1wiIENvbnRlbnRUeXBlPVwiYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLXBhY2thZ2UucmVsYXRpb25zaGlwcyt4bWxcIiAvPicgK1xuXHRcdCc8RGVmYXVsdCBFeHRlbnNpb249XCJqcGVnXCIgQ29udGVudFR5cGU9XCJpbWFnZS9qcGVnXCIgLz4nICtcblx0XHQnPE92ZXJyaWRlIFBhcnROYW1lPVwiL3hsL3dvcmtib29rLnhtbFwiIENvbnRlbnRUeXBlPVwiYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLW9mZmljZWRvY3VtZW50LnNwcmVhZHNoZWV0bWwuc2hlZXQubWFpbit4bWxcIiAvPicgK1xuXHRcdCc8T3ZlcnJpZGUgUGFydE5hbWU9XCIveGwvd29ya3NoZWV0cy9zaGVldDEueG1sXCIgQ29udGVudFR5cGU9XCJhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQuc3ByZWFkc2hlZXRtbC53b3Jrc2hlZXQreG1sXCIgLz4nICtcblx0XHQnPE92ZXJyaWRlIFBhcnROYW1lPVwiL3hsL3N0eWxlcy54bWxcIiBDb250ZW50VHlwZT1cImFwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnN0eWxlcyt4bWxcIiAvPicgK1xuXHRcdCc8L1R5cGVzPicsXG5cblx0J3hsL3dvcmtib29rLnhtbCc6XG5cdFx0Jzw/eG1sIHZlcnNpb249XCIxLjBcIiBlbmNvZGluZz1cIlVURi04XCIgc3RhbmRhbG9uZT1cInllc1wiPz4nICtcblx0XHQnPHdvcmtib29rIHhtbG5zPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL3NwcmVhZHNoZWV0bWwvMjAwNi9tYWluXCIgeG1sbnM6cj1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9vZmZpY2VEb2N1bWVudC8yMDA2L3JlbGF0aW9uc2hpcHNcIj4nICtcblx0XHQnPGZpbGVWZXJzaW9uIGFwcE5hbWU9XCJ4bFwiIGxhc3RFZGl0ZWQ9XCI1XCIgbG93ZXN0RWRpdGVkPVwiNVwiIHJ1cEJ1aWxkPVwiMjQ4MTZcIi8+JyArXG5cdFx0Jzx3b3JrYm9va1ByIHNob3dJbmtBbm5vdGF0aW9uPVwiMFwiIGF1dG9Db21wcmVzc1BpY3R1cmVzPVwiMFwiLz4nICtcblx0XHQnPGJvb2tWaWV3cz4nICtcblx0XHQnPHdvcmtib29rVmlldyB4V2luZG93PVwiMFwiIHlXaW5kb3c9XCIwXCIgd2luZG93V2lkdGg9XCIyNTYwMFwiIHdpbmRvd0hlaWdodD1cIjE5MDIwXCIgdGFiUmF0aW89XCI1MDBcIi8+JyArXG5cdFx0JzwvYm9va1ZpZXdzPicgK1xuXHRcdCc8c2hlZXRzPicgK1xuXHRcdCc8c2hlZXQgbmFtZT1cIlNoZWV0MVwiIHNoZWV0SWQ9XCIxXCIgcjppZD1cInJJZDFcIi8+JyArXG5cdFx0Jzwvc2hlZXRzPicgK1xuXHRcdCc8ZGVmaW5lZE5hbWVzLz4nICtcblx0XHQnPC93b3JrYm9vaz4nLFxuXG5cdCd4bC93b3Jrc2hlZXRzL3NoZWV0MS54bWwnOlxuXHRcdCc8P3htbCB2ZXJzaW9uPVwiMS4wXCIgZW5jb2Rpbmc9XCJVVEYtOFwiIHN0YW5kYWxvbmU9XCJ5ZXNcIj8+JyArXG5cdFx0Jzx3b3Jrc2hlZXQgeG1sbnM9XCJodHRwOi8vc2NoZW1hcy5vcGVueG1sZm9ybWF0cy5vcmcvc3ByZWFkc2hlZXRtbC8yMDA2L21haW5cIiB4bWxuczpyPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL29mZmljZURvY3VtZW50LzIwMDYvcmVsYXRpb25zaGlwc1wiIHhtbG5zOm1jPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL21hcmt1cC1jb21wYXRpYmlsaXR5LzIwMDZcIiBtYzpJZ25vcmFibGU9XCJ4MTRhY1wiIHhtbG5zOngxNGFjPVwiaHR0cDovL3NjaGVtYXMubWljcm9zb2Z0LmNvbS9vZmZpY2Uvc3ByZWFkc2hlZXRtbC8yMDA5LzkvYWNcIj4nICtcblx0XHQnPHNoZWV0RGF0YS8+JyArXG5cdFx0JzxtZXJnZUNlbGxzIGNvdW50PVwiMFwiLz4nICtcblx0XHQnPC93b3Jrc2hlZXQ+JyxcblxuXHQneGwvc3R5bGVzLnhtbCc6XG5cdFx0Jzw/eG1sIHZlcnNpb249XCIxLjBcIiBlbmNvZGluZz1cIlVURi04XCI/PicgK1xuXHRcdCc8c3R5bGVTaGVldCB4bWxucz1cImh0dHA6Ly9zY2hlbWFzLm9wZW54bWxmb3JtYXRzLm9yZy9zcHJlYWRzaGVldG1sLzIwMDYvbWFpblwiIHhtbG5zOm1jPVwiaHR0cDovL3NjaGVtYXMub3BlbnhtbGZvcm1hdHMub3JnL21hcmt1cC1jb21wYXRpYmlsaXR5LzIwMDZcIiBtYzpJZ25vcmFibGU9XCJ4MTRhY1wiIHhtbG5zOngxNGFjPVwiaHR0cDovL3NjaGVtYXMubWljcm9zb2Z0LmNvbS9vZmZpY2Uvc3ByZWFkc2hlZXRtbC8yMDA5LzkvYWNcIj4nICtcblx0XHQnPG51bUZtdHMgY291bnQ9XCI2XCI+JyArXG5cdFx0JzxudW1GbXQgbnVtRm10SWQ9XCIxNjRcIiBmb3JtYXRDb2RlPVwiWyQkLTQwOV0jLCMjMC4wMDstWyQkLTQwOV0jLCMjMC4wMFwiLz4nICtcblx0XHQnPG51bUZtdCBudW1GbXRJZD1cIjE2NVwiIGZvcm1hdENvZGU9XCImcXVvdDvCoyZxdW90OyMsIyMwLjAwXCIvPicgK1xuXHRcdCc8bnVtRm10IG51bUZtdElkPVwiMTY2XCIgZm9ybWF0Q29kZT1cIlsk4oKsLTJdICMsIyMwLjAwXCIvPicgK1xuXHRcdCc8bnVtRm10IG51bUZtdElkPVwiMTY3XCIgZm9ybWF0Q29kZT1cIjAuMCVcIi8+JyArXG5cdFx0JzxudW1GbXQgbnVtRm10SWQ9XCIxNjhcIiBmb3JtYXRDb2RlPVwiIywjIzA7KCMsIyMwKVwiLz4nICtcblx0XHQnPG51bUZtdCBudW1GbXRJZD1cIjE2OVwiIGZvcm1hdENvZGU9XCIjLCMjMC4wMDsoIywjIzAuMDApXCIvPicgK1xuXHRcdCc8L251bUZtdHM+JyArXG5cdFx0Jzxmb250cyBjb3VudD1cIjVcIiB4MTRhYzprbm93bkZvbnRzPVwiMVwiPicgK1xuXHRcdCc8Zm9udD4nICtcblx0XHQnPHN6IHZhbD1cIjExXCIgLz4nICtcblx0XHQnPG5hbWUgdmFsPVwiQ2FsaWJyaVwiIC8+JyArXG5cdFx0JzwvZm9udD4nICtcblx0XHQnPGZvbnQ+JyArXG5cdFx0JzxzeiB2YWw9XCIxMVwiIC8+JyArXG5cdFx0JzxuYW1lIHZhbD1cIkNhbGlicmlcIiAvPicgK1xuXHRcdCc8Y29sb3IgcmdiPVwiRkZGRkZGRkZcIiAvPicgK1xuXHRcdCc8L2ZvbnQ+JyArXG5cdFx0Jzxmb250PicgK1xuXHRcdCc8c3ogdmFsPVwiMTFcIiAvPicgK1xuXHRcdCc8bmFtZSB2YWw9XCJDYWxpYnJpXCIgLz4nICtcblx0XHQnPGIgLz4nICtcblx0XHQnPC9mb250PicgK1xuXHRcdCc8Zm9udD4nICtcblx0XHQnPHN6IHZhbD1cIjExXCIgLz4nICtcblx0XHQnPG5hbWUgdmFsPVwiQ2FsaWJyaVwiIC8+JyArXG5cdFx0JzxpIC8+JyArXG5cdFx0JzwvZm9udD4nICtcblx0XHQnPGZvbnQ+JyArXG5cdFx0JzxzeiB2YWw9XCIxMVwiIC8+JyArXG5cdFx0JzxuYW1lIHZhbD1cIkNhbGlicmlcIiAvPicgK1xuXHRcdCc8dSAvPicgK1xuXHRcdCc8L2ZvbnQ+JyArXG5cdFx0JzwvZm9udHM+JyArXG5cdFx0JzxmaWxscyBjb3VudD1cIjZcIj4nICtcblx0XHQnPGZpbGw+JyArXG5cdFx0JzxwYXR0ZXJuRmlsbCBwYXR0ZXJuVHlwZT1cIm5vbmVcIiAvPicgK1xuXHRcdCc8L2ZpbGw+JyArXG5cdFx0JzxmaWxsPicgKyAvLyBFeGNlbCBhcHBlYXJzIHRvIHVzZSB0aGlzIGFzIGEgZG90dGVkIGJhY2tncm91bmQgcmVnYXJkbGVzcyBvZiB2YWx1ZXMgYnV0XG5cdFx0JzxwYXR0ZXJuRmlsbCBwYXR0ZXJuVHlwZT1cIm5vbmVcIiAvPicgKyAvLyB0byBiZSB2YWxpZCB0byB0aGUgc2NoZW1hLCB1c2UgYSBwYXR0ZXJuRmlsbFxuXHRcdCc8L2ZpbGw+JyArXG5cdFx0JzxmaWxsPicgK1xuXHRcdCc8cGF0dGVybkZpbGwgcGF0dGVyblR5cGU9XCJzb2xpZFwiPicgK1xuXHRcdCc8ZmdDb2xvciByZ2I9XCJGRkQ5RDlEOVwiIC8+JyArXG5cdFx0JzxiZ0NvbG9yIGluZGV4ZWQ9XCI2NFwiIC8+JyArXG5cdFx0JzwvcGF0dGVybkZpbGw+JyArXG5cdFx0JzwvZmlsbD4nICtcblx0XHQnPGZpbGw+JyArXG5cdFx0JzxwYXR0ZXJuRmlsbCBwYXR0ZXJuVHlwZT1cInNvbGlkXCI+JyArXG5cdFx0JzxmZ0NvbG9yIHJnYj1cIkZGRDk5Nzk1XCIgLz4nICtcblx0XHQnPGJnQ29sb3IgaW5kZXhlZD1cIjY0XCIgLz4nICtcblx0XHQnPC9wYXR0ZXJuRmlsbD4nICtcblx0XHQnPC9maWxsPicgK1xuXHRcdCc8ZmlsbD4nICtcblx0XHQnPHBhdHRlcm5GaWxsIHBhdHRlcm5UeXBlPVwic29saWRcIj4nICtcblx0XHQnPGZnQ29sb3IgcmdiPVwiZmZjNmVmY2VcIiAvPicgK1xuXHRcdCc8YmdDb2xvciBpbmRleGVkPVwiNjRcIiAvPicgK1xuXHRcdCc8L3BhdHRlcm5GaWxsPicgK1xuXHRcdCc8L2ZpbGw+JyArXG5cdFx0JzxmaWxsPicgK1xuXHRcdCc8cGF0dGVybkZpbGwgcGF0dGVyblR5cGU9XCJzb2xpZFwiPicgK1xuXHRcdCc8ZmdDb2xvciByZ2I9XCJmZmM2Y2ZlZlwiIC8+JyArXG5cdFx0JzxiZ0NvbG9yIGluZGV4ZWQ9XCI2NFwiIC8+JyArXG5cdFx0JzwvcGF0dGVybkZpbGw+JyArXG5cdFx0JzwvZmlsbD4nICtcblx0XHQnPC9maWxscz4nICtcblx0XHQnPGJvcmRlcnMgY291bnQ9XCIyXCI+JyArXG5cdFx0Jzxib3JkZXI+JyArXG5cdFx0JzxsZWZ0IC8+JyArXG5cdFx0JzxyaWdodCAvPicgK1xuXHRcdCc8dG9wIC8+JyArXG5cdFx0Jzxib3R0b20gLz4nICtcblx0XHQnPGRpYWdvbmFsIC8+JyArXG5cdFx0JzwvYm9yZGVyPicgK1xuXHRcdCc8Ym9yZGVyIGRpYWdvbmFsVXA9XCJmYWxzZVwiIGRpYWdvbmFsRG93bj1cImZhbHNlXCI+JyArXG5cdFx0JzxsZWZ0IHN0eWxlPVwidGhpblwiPicgK1xuXHRcdCc8Y29sb3IgYXV0bz1cIjFcIiAvPicgK1xuXHRcdCc8L2xlZnQ+JyArXG5cdFx0JzxyaWdodCBzdHlsZT1cInRoaW5cIj4nICtcblx0XHQnPGNvbG9yIGF1dG89XCIxXCIgLz4nICtcblx0XHQnPC9yaWdodD4nICtcblx0XHQnPHRvcCBzdHlsZT1cInRoaW5cIj4nICtcblx0XHQnPGNvbG9yIGF1dG89XCIxXCIgLz4nICtcblx0XHQnPC90b3A+JyArXG5cdFx0Jzxib3R0b20gc3R5bGU9XCJ0aGluXCI+JyArXG5cdFx0Jzxjb2xvciBhdXRvPVwiMVwiIC8+JyArXG5cdFx0JzwvYm90dG9tPicgK1xuXHRcdCc8ZGlhZ29uYWwgLz4nICtcblx0XHQnPC9ib3JkZXI+JyArXG5cdFx0JzwvYm9yZGVycz4nICtcblx0XHQnPGNlbGxTdHlsZVhmcyBjb3VudD1cIjFcIj4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgLz4nICtcblx0XHQnPC9jZWxsU3R5bGVYZnM+JyArXG5cdFx0JzxjZWxsWGZzIGNvdW50PVwiNjhcIj4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjJcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCIyXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiMlwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjFcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIyXCIgZmlsbElkPVwiM1wiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiM1wiIGZpbGxJZD1cIjNcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjRcIiBmaWxsSWQ9XCIzXCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMVwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjJcIiBmaWxsSWQ9XCI0XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIzXCIgZmlsbElkPVwiNFwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiNFwiIGZpbGxJZD1cIjRcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIxXCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMlwiIGZpbGxJZD1cIjVcIiBib3JkZXJJZD1cIjFcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjNcIiBmaWxsSWQ9XCI1XCIgYm9yZGVySWQ9XCIxXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCI0XCIgZmlsbElkPVwiNVwiIGJvcmRlcklkPVwiMVwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlBbGlnbm1lbnQ9XCIxXCI+JyArXG5cdFx0JzxhbGlnbm1lbnQgaG9yaXpvbnRhbD1cImxlZnRcIi8+JyArXG5cdFx0JzwveGY+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseUFsaWdubWVudD1cIjFcIj4nICtcblx0XHQnPGFsaWdubWVudCBob3Jpem9udGFsPVwiY2VudGVyXCIvPicgK1xuXHRcdCc8L3hmPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlBbGlnbm1lbnQ9XCIxXCI+JyArXG5cdFx0JzxhbGlnbm1lbnQgaG9yaXpvbnRhbD1cInJpZ2h0XCIvPicgK1xuXHRcdCc8L3hmPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIwXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlBbGlnbm1lbnQ9XCIxXCI+JyArXG5cdFx0JzxhbGlnbm1lbnQgaG9yaXpvbnRhbD1cImZpbGxcIi8+JyArXG5cdFx0JzwveGY+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjBcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseUFsaWdubWVudD1cIjFcIj4nICtcblx0XHQnPGFsaWdubWVudCB0ZXh0Um90YXRpb249XCI5MFwiLz4nICtcblx0XHQnPC94Zj4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5QWxpZ25tZW50PVwiMVwiPicgK1xuXHRcdCc8YWxpZ25tZW50IHdyYXBUZXh0PVwiMVwiLz4nICtcblx0XHQnPC94Zj4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiOVwiICAgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIxNjRcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseU51bWJlckZvcm1hdD1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjE2NVwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMTY2XCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIxNjdcIiBmb250SWQ9XCIwXCIgZmlsbElkPVwiMFwiIGJvcmRlcklkPVwiMFwiIGFwcGx5Rm9udD1cIjFcIiBhcHBseUZpbGw9XCIxXCIgYXBwbHlCb3JkZXI9XCIxXCIgeGZJZD1cIjBcIiBhcHBseU51bWJlckZvcm1hdD1cIjFcIi8+JyArXG5cdFx0Jzx4ZiBudW1GbXRJZD1cIjE2OFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nICtcblx0XHQnPHhmIG51bUZtdElkPVwiMTY5XCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIzXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCI0XCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIxXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIyXCIgZm9udElkPVwiMFwiIGZpbGxJZD1cIjBcIiBib3JkZXJJZD1cIjBcIiBhcHBseUZvbnQ9XCIxXCIgYXBwbHlGaWxsPVwiMVwiIGFwcGx5Qm9yZGVyPVwiMVwiIHhmSWQ9XCIwXCIgYXBwbHlOdW1iZXJGb3JtYXQ9XCIxXCIvPicgK1xuXHRcdCc8eGYgbnVtRm10SWQ9XCIxNFwiIGZvbnRJZD1cIjBcIiBmaWxsSWQ9XCIwXCIgYm9yZGVySWQ9XCIwXCIgYXBwbHlGb250PVwiMVwiIGFwcGx5RmlsbD1cIjFcIiBhcHBseUJvcmRlcj1cIjFcIiB4ZklkPVwiMFwiIGFwcGx5TnVtYmVyRm9ybWF0PVwiMVwiLz4nICtcblx0XHQnPC9jZWxsWGZzPicgK1xuXHRcdCc8Y2VsbFN0eWxlcyBjb3VudD1cIjFcIj4nICtcblx0XHQnPGNlbGxTdHlsZSBuYW1lPVwiTm9ybWFsXCIgeGZJZD1cIjBcIiBidWlsdGluSWQ9XCIwXCIgLz4nICtcblx0XHQnPC9jZWxsU3R5bGVzPicgK1xuXHRcdCc8ZHhmcyBjb3VudD1cIjBcIiAvPicgK1xuXHRcdCc8dGFibGVTdHlsZXMgY291bnQ9XCIwXCIgZGVmYXVsdFRhYmxlU3R5bGU9XCJUYWJsZVN0eWxlTWVkaXVtOVwiIGRlZmF1bHRQaXZvdFN0eWxlPVwiUGl2b3RTdHlsZU1lZGl1bTRcIiAvPicgK1xuXHRcdCc8L3N0eWxlU2hlZXQ+J1xufTtcbi8vIE5vdGUgd2UgY291bGQgdXNlIDMgYGZvcmAgbG9vcHMgZm9yIHRoZSBzdHlsZXMsIGJ1dCB3aGVuIGd6aXBwZWQgdGhlcmUgaXNcbi8vIHZpcnR1YWxseSBubyBkaWZmZXJlbmNlIGluIHNpemUsIHNpbmNlIHRoZSBhYm92ZSBjYW4gYmUgZWFzaWx5IGNvbXByZXNzZWRcblxuLy8gUGF0dGVybiBtYXRjaGluZyBmb3Igc3BlY2lhbCBudW1iZXIgZm9ybWF0cy4gUGVyaGFwcyB0aGlzIHNob3VsZCBiZSBleHBvc2VkXG4vLyB2aWEgYW4gQVBJIGluIGZ1dHVyZT9cbi8vIFJlZjogc2VjdGlvbiAzLjguMzAgLSBidWlsdCBpbiBmb3JtYXR0ZXJzIGluIG9wZW4gc3ByZWFkc2hlZXRcbi8vICAgaHR0cHM6Ly93d3cuZWNtYS1pbnRlcm5hdGlvbmFsLm9yZy9uZXdzL1RDNDVfY3VycmVudF93b3JrL09mZmljZSUyME9wZW4lMjBYTUwlMjBQYXJ0JTIwNCUyMC0lMjBNYXJrdXAlMjBMYW5ndWFnZSUyMFJlZmVyZW5jZS5wZGZcbnZhciBfZXhjZWxTcGVjaWFscyA9IFtcblx0e1xuXHRcdG1hdGNoOiAvXlxcLT9cXGQrXFwuXFxkJSQvLFxuXHRcdHN0eWxlOiA2MCxcblx0XHRmbXQ6IGZ1bmN0aW9uIChkKSB7XG5cdFx0XHRyZXR1cm4gZCAvIDEwMDtcblx0XHR9XG5cdH0sIC8vIFBlcmNlbnQgd2l0aCBkLnAuXG5cdHtcblx0XHRtYXRjaDogL15cXC0/XFxkK1xcLj9cXGQqJSQvLFxuXHRcdHN0eWxlOiA1Nixcblx0XHRmbXQ6IGZ1bmN0aW9uIChkKSB7XG5cdFx0XHRyZXR1cm4gZCAvIDEwMDtcblx0XHR9XG5cdH0sIC8vIFBlcmNlbnRcblx0eyBtYXRjaDogL15cXC0/XFwkW1xcZCxdKy4/XFxkKiQvLCBzdHlsZTogNTcgfSwgLy8gRG9sbGFyc1xuXHR7IG1hdGNoOiAvXlxcLT/Co1tcXGQsXSsuP1xcZCokLywgc3R5bGU6IDU4IH0sIC8vIFBvdW5kc1xuXHR7IG1hdGNoOiAvXlxcLT/igqxbXFxkLF0rLj9cXGQqJC8sIHN0eWxlOiA1OSB9LCAvLyBFdXJvc1xuXHR7IG1hdGNoOiAvXlxcLT9cXGQrJC8sIHN0eWxlOiA2NSB9LCAvLyBOdW1iZXJzIHdpdGhvdXQgdGhvdXNhbmQgc2VwYXJhdG9yc1xuXHR7IG1hdGNoOiAvXlxcLT9cXGQrXFwuXFxkezJ9JC8sIHN0eWxlOiA2NiB9LCAvLyBOdW1iZXJzIDIgZC5wLiB3aXRob3V0IHRob3VzYW5kcyBzZXBhcmF0b3JzXG5cdHtcblx0XHRtYXRjaDogL15cXChbXFxkLF0rXFwpJC8sXG5cdFx0c3R5bGU6IDYxLFxuXHRcdGZtdDogZnVuY3Rpb24gKGQpIHtcblx0XHRcdHJldHVybiAtMSAqIGQucmVwbGFjZSgvW1xcKFxcKV0vZywgJycpO1xuXHRcdH1cblx0fSwgLy8gTmVnYXRpdmUgbnVtYmVycyBpbmRpY2F0ZWQgYnkgYnJhY2tldHNcblx0e1xuXHRcdG1hdGNoOiAvXlxcKFtcXGQsXStcXC5cXGR7Mn1cXCkkLyxcblx0XHRzdHlsZTogNjIsXG5cdFx0Zm10OiBmdW5jdGlvbiAoZCkge1xuXHRcdFx0cmV0dXJuIC0xICogZC5yZXBsYWNlKC9bXFwoXFwpXS9nLCAnJyk7XG5cdFx0fVxuXHR9LCAvLyBOZWdhdGl2ZSBudW1iZXJzIGluZGljYXRlZCBieSBicmFja2V0cyAtIDJkLnAuXG5cdHsgbWF0Y2g6IC9eXFwtP1tcXGQsXSskLywgc3R5bGU6IDYzIH0sIC8vIE51bWJlcnMgd2l0aCB0aG91c2FuZCBzZXBhcmF0b3JzXG5cdHsgbWF0Y2g6IC9eXFwtP1tcXGQsXStcXC5cXGR7Mn0kLywgc3R5bGU6IDY0IH0sXG5cdHtcblx0XHRtYXRjaDogL15bXFxkXXs0fVxcLVswMV1bXFxkXVxcLVswMTIzXVtcXGRdJC8sXG5cdFx0c3R5bGU6IDY3LFxuXHRcdGZtdDogZnVuY3Rpb24gKGQpIHtcblx0XHRcdHJldHVybiBNYXRoLnJvdW5kKDI1NTY5ICsgRGF0ZS5wYXJzZShkKSAvICg4NjQwMCAqIDEwMDApKTtcblx0XHR9XG5cdH0gLy9EYXRlIHl5eXktbW0tZGRcbl07XG5cbnZhciBfZXhjZWxNZXJnZUNlbGxzID0gZnVuY3Rpb24gKHJlbHMsIHJvdywgY29sdW1uLCByb3dzcGFuLCBjb2xzcGFuKSB7XG5cdHZhciBtZXJnZUNlbGxzID0gJCgnbWVyZ2VDZWxscycsIHJlbHMpO1xuXG5cdG1lcmdlQ2VsbHNbMF0uYXBwZW5kQ2hpbGQoXG5cdFx0X2NyZWF0ZU5vZGUocmVscywgJ21lcmdlQ2VsbCcsIHtcblx0XHRcdGF0dHI6IHtcblx0XHRcdFx0cmVmOlxuXHRcdFx0XHRcdGNyZWF0ZUNlbGxQb3MoY29sdW1uKSArXG5cdFx0XHRcdFx0cm93ICtcblx0XHRcdFx0XHQnOicgK1xuXHRcdFx0XHRcdGNyZWF0ZUNlbGxQb3MoY29sdW1uICsgY29sc3BhbiAtIDEpICtcblx0XHRcdFx0XHQocm93ICsgcm93c3BhbiAtIDEpXG5cdFx0XHR9XG5cdFx0fSlcblx0KTtcblxuXHRtZXJnZUNlbGxzLmF0dHIoJ2NvdW50JywgcGFyc2VGbG9hdChtZXJnZUNlbGxzLmF0dHIoJ2NvdW50JykpICsgMSk7XG59O1xuXG4vKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICpcbiAqIEJ1dHRvbnNcbiAqL1xuXG4vL1xuLy8gQ29weSB0byBjbGlwYm9hcmRcbi8vXG5EYXRhVGFibGUuZXh0LmJ1dHRvbnMuY29weUh0bWw1ID0ge1xuXHRjbGFzc05hbWU6ICdidXR0b25zLWNvcHkgYnV0dG9ucy1odG1sNScsXG5cblx0dGV4dDogZnVuY3Rpb24gKGR0KSB7XG5cdFx0cmV0dXJuIGR0LmkxOG4oJ2J1dHRvbnMuY29weScsICdDb3B5Jyk7XG5cdH0sXG5cblx0YWN0aW9uOiBmdW5jdGlvbiAoZSwgZHQsIGJ1dHRvbiwgY29uZmlnLCBjYikge1xuXHRcdHZhciBleHBvcnREYXRhID0gX2V4cG9ydERhdGEoZHQsIGNvbmZpZyk7XG5cdFx0dmFyIGluZm8gPSBkdC5idXR0b25zLmV4cG9ydEluZm8oY29uZmlnKTtcblx0XHR2YXIgbmV3bGluZSA9IF9uZXdMaW5lKGNvbmZpZyk7XG5cdFx0dmFyIG91dHB1dCA9IGV4cG9ydERhdGEuc3RyO1xuXHRcdHZhciBoaWRkZW5EaXYgPSAkKCc8ZGl2Lz4nKS5jc3Moe1xuXHRcdFx0aGVpZ2h0OiAxLFxuXHRcdFx0d2lkdGg6IDEsXG5cdFx0XHRvdmVyZmxvdzogJ2hpZGRlbicsXG5cdFx0XHRwb3NpdGlvbjogJ2ZpeGVkJyxcblx0XHRcdHRvcDogMCxcblx0XHRcdGxlZnQ6IDBcblx0XHR9KTtcblxuXHRcdGlmIChpbmZvLnRpdGxlKSB7XG5cdFx0XHRvdXRwdXQgPSBpbmZvLnRpdGxlICsgbmV3bGluZSArIG5ld2xpbmUgKyBvdXRwdXQ7XG5cdFx0fVxuXG5cdFx0aWYgKGluZm8ubWVzc2FnZVRvcCkge1xuXHRcdFx0b3V0cHV0ID0gaW5mby5tZXNzYWdlVG9wICsgbmV3bGluZSArIG5ld2xpbmUgKyBvdXRwdXQ7XG5cdFx0fVxuXG5cdFx0aWYgKGluZm8ubWVzc2FnZUJvdHRvbSkge1xuXHRcdFx0b3V0cHV0ID0gb3V0cHV0ICsgbmV3bGluZSArIG5ld2xpbmUgKyBpbmZvLm1lc3NhZ2VCb3R0b207XG5cdFx0fVxuXG5cdFx0aWYgKGNvbmZpZy5jdXN0b21pemUpIHtcblx0XHRcdG91dHB1dCA9IGNvbmZpZy5jdXN0b21pemUob3V0cHV0LCBjb25maWcsIGR0KTtcblx0XHR9XG5cblx0XHR2YXIgdGV4dGFyZWEgPSAkKCc8dGV4dGFyZWEgcmVhZG9ubHkvPicpXG5cdFx0XHQudmFsKG91dHB1dClcblx0XHRcdC5hcHBlbmRUbyhoaWRkZW5EaXYpO1xuXG5cdFx0Ly8gRm9yIGJyb3dzZXJzIHRoYXQgc3VwcG9ydCB0aGUgY29weSBleGVjQ29tbWFuZCwgdHJ5IHRvIHVzZSBpdFxuXHRcdGlmIChkb2N1bWVudC5xdWVyeUNvbW1hbmRTdXBwb3J0ZWQoJ2NvcHknKSkge1xuXHRcdFx0aGlkZGVuRGl2LmFwcGVuZFRvKGR0LnRhYmxlKCkuY29udGFpbmVyKCkpO1xuXHRcdFx0dGV4dGFyZWFbMF0uZm9jdXMoKTtcblx0XHRcdHRleHRhcmVhWzBdLnNlbGVjdCgpO1xuXG5cdFx0XHR0cnkge1xuXHRcdFx0XHR2YXIgc3VjY2Vzc2Z1bCA9IGRvY3VtZW50LmV4ZWNDb21tYW5kKCdjb3B5Jyk7XG5cdFx0XHRcdGhpZGRlbkRpdi5yZW1vdmUoKTtcblxuXHRcdFx0XHRpZiAoc3VjY2Vzc2Z1bCkge1xuXHRcdFx0XHRcdGR0LmJ1dHRvbnMuaW5mbyhcblx0XHRcdFx0XHRcdGR0LmkxOG4oJ2J1dHRvbnMuY29weVRpdGxlJywgJ0NvcHkgdG8gY2xpcGJvYXJkJyksXG5cdFx0XHRcdFx0XHRkdC5pMThuKFxuXHRcdFx0XHRcdFx0XHQnYnV0dG9ucy5jb3B5U3VjY2VzcycsXG5cdFx0XHRcdFx0XHRcdHtcblx0XHRcdFx0XHRcdFx0XHQxOiAnQ29waWVkIG9uZSByb3cgdG8gY2xpcGJvYXJkJyxcblx0XHRcdFx0XHRcdFx0XHRfOiAnQ29waWVkICVkIHJvd3MgdG8gY2xpcGJvYXJkJ1xuXHRcdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0XHRleHBvcnREYXRhLnJvd3Ncblx0XHRcdFx0XHRcdCksXG5cdFx0XHRcdFx0XHQyMDAwXG5cdFx0XHRcdFx0KTtcblxuXHRcdFx0XHRcdGNiKCk7XG5cdFx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0XHR9XG5cdFx0XHR9IGNhdGNoICh0KSB7XG5cdFx0XHRcdC8vIG5vb3Bcblx0XHRcdH1cblx0XHR9XG5cblx0XHQvLyBPdGhlcndpc2Ugd2Ugc2hvdyB0aGUgdGV4dCBib3ggYW5kIGluc3RydWN0IHRoZSB1c2VyIHRvIHVzZSBpdFxuXHRcdHZhciBtZXNzYWdlID0gJChcblx0XHRcdCc8c3Bhbj4nICtcblx0XHRcdFx0ZHQuaTE4bihcblx0XHRcdFx0XHQnYnV0dG9ucy5jb3B5S2V5cycsXG5cdFx0XHRcdFx0J1ByZXNzIDxpPmN0cmw8L2k+IG9yIDxpPlxcdTIzMTg8L2k+ICsgPGk+QzwvaT4gdG8gY29weSB0aGUgdGFibGUgZGF0YTxicj50byB5b3VyIHN5c3RlbSBjbGlwYm9hcmQuPGJyPjxicj4nICtcblx0XHRcdFx0XHRcdCdUbyBjYW5jZWwsIGNsaWNrIHRoaXMgbWVzc2FnZSBvciBwcmVzcyBlc2NhcGUuJ1xuXHRcdFx0XHQpICtcblx0XHRcdFx0Jzwvc3Bhbj4nXG5cdFx0KS5hcHBlbmQoaGlkZGVuRGl2KTtcblxuXHRcdGR0LmJ1dHRvbnMuaW5mbyhcblx0XHRcdGR0LmkxOG4oJ2J1dHRvbnMuY29weVRpdGxlJywgJ0NvcHkgdG8gY2xpcGJvYXJkJyksXG5cdFx0XHRtZXNzYWdlLFxuXHRcdFx0MFxuXHRcdCk7XG5cblx0XHQvLyBTZWxlY3QgdGhlIHRleHQgc28gd2hlbiB0aGUgdXNlciBhY3RpdmF0ZXMgdGhlaXIgc3lzdGVtIGNsaXBib2FyZFxuXHRcdC8vIGl0IHdpbGwgY29weSB0aGF0IHRleHRcblx0XHR0ZXh0YXJlYVswXS5mb2N1cygpO1xuXHRcdHRleHRhcmVhWzBdLnNlbGVjdCgpO1xuXG5cdFx0Ly8gRXZlbnQgdG8gaGlkZSB0aGUgbWVzc2FnZSB3aGVuIHRoZSB1c2VyIGlzIGRvbmVcblx0XHR2YXIgY29udGFpbmVyID0gJChtZXNzYWdlKS5jbG9zZXN0KCcuZHQtYnV0dG9uLWluZm8nKTtcblx0XHR2YXIgY2xvc2UgPSBmdW5jdGlvbiAoKSB7XG5cdFx0XHRjb250YWluZXIub2ZmKCdjbGljay5idXR0b25zLWNvcHknKTtcblx0XHRcdCQoZG9jdW1lbnQpLm9mZignLmJ1dHRvbnMtY29weScpO1xuXHRcdFx0ZHQuYnV0dG9ucy5pbmZvKGZhbHNlKTtcblx0XHR9O1xuXG5cdFx0Y29udGFpbmVyLm9uKCdjbGljay5idXR0b25zLWNvcHknLCBjbG9zZSk7XG5cdFx0JChkb2N1bWVudClcblx0XHRcdC5vbigna2V5ZG93bi5idXR0b25zLWNvcHknLCBmdW5jdGlvbiAoZSkge1xuXHRcdFx0XHRpZiAoZS5rZXlDb2RlID09PSAyNykge1xuXHRcdFx0XHRcdC8vIGVzY1xuXHRcdFx0XHRcdGNsb3NlKCk7XG5cdFx0XHRcdFx0Y2IoKTtcblx0XHRcdFx0fVxuXHRcdFx0fSlcblx0XHRcdC5vbignY29weS5idXR0b25zLWNvcHkgY3V0LmJ1dHRvbnMtY29weScsIGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0Y2xvc2UoKTtcblx0XHRcdFx0Y2IoKTtcblx0XHRcdH0pO1xuXHR9LFxuXG5cdGFzeW5jOiAxMDAsXG5cblx0ZXhwb3J0T3B0aW9uczoge30sXG5cblx0ZmllbGRTZXBhcmF0b3I6ICdcXHQnLFxuXG5cdGZpZWxkQm91bmRhcnk6ICcnLFxuXG5cdGhlYWRlcjogdHJ1ZSxcblxuXHRmb290ZXI6IHRydWUsXG5cblx0dGl0bGU6ICcqJyxcblxuXHRtZXNzYWdlVG9wOiAnKicsXG5cblx0bWVzc2FnZUJvdHRvbTogJyonXG59O1xuXG4vL1xuLy8gQ1NWIGV4cG9ydFxuLy9cbkRhdGFUYWJsZS5leHQuYnV0dG9ucy5jc3ZIdG1sNSA9IHtcblx0Ym9tOiBmYWxzZSxcblxuXHRjbGFzc05hbWU6ICdidXR0b25zLWNzdiBidXR0b25zLWh0bWw1JyxcblxuXHRhdmFpbGFibGU6IGZ1bmN0aW9uICgpIHtcblx0XHRyZXR1cm4gd2luZG93LkZpbGVSZWFkZXIgIT09IHVuZGVmaW5lZCAmJiB3aW5kb3cuQmxvYjtcblx0fSxcblxuXHR0ZXh0OiBmdW5jdGlvbiAoZHQpIHtcblx0XHRyZXR1cm4gZHQuaTE4bignYnV0dG9ucy5jc3YnLCAnQ1NWJyk7XG5cdH0sXG5cblx0YWN0aW9uOiBmdW5jdGlvbiAoZSwgZHQsIGJ1dHRvbiwgY29uZmlnLCBjYikge1xuXHRcdC8vIFNldCB0aGUgdGV4dFxuXHRcdHZhciBvdXRwdXQgPSBfZXhwb3J0RGF0YShkdCwgY29uZmlnKS5zdHI7XG5cdFx0dmFyIGluZm8gPSBkdC5idXR0b25zLmV4cG9ydEluZm8oY29uZmlnKTtcblx0XHR2YXIgY2hhcnNldCA9IGNvbmZpZy5jaGFyc2V0O1xuXG5cdFx0aWYgKGNvbmZpZy5jdXN0b21pemUpIHtcblx0XHRcdG91dHB1dCA9IGNvbmZpZy5jdXN0b21pemUob3V0cHV0LCBjb25maWcsIGR0KTtcblx0XHR9XG5cblx0XHRpZiAoY2hhcnNldCAhPT0gZmFsc2UpIHtcblx0XHRcdGlmICghY2hhcnNldCkge1xuXHRcdFx0XHRjaGFyc2V0ID0gZG9jdW1lbnQuY2hhcmFjdGVyU2V0IHx8IGRvY3VtZW50LmNoYXJzZXQ7XG5cdFx0XHR9XG5cblx0XHRcdGlmIChjaGFyc2V0KSB7XG5cdFx0XHRcdGNoYXJzZXQgPSAnO2NoYXJzZXQ9JyArIGNoYXJzZXQ7XG5cdFx0XHR9XG5cdFx0fVxuXHRcdGVsc2Uge1xuXHRcdFx0Y2hhcnNldCA9ICcnO1xuXHRcdH1cblxuXHRcdGlmIChjb25maWcuYm9tKSB7XG5cdFx0XHRvdXRwdXQgPSBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4ZmVmZikgKyBvdXRwdXQ7XG5cdFx0fVxuXG5cdFx0X3NhdmVBcyhcblx0XHRcdG5ldyBCbG9iKFtvdXRwdXRdLCB7IHR5cGU6ICd0ZXh0L2NzdicgKyBjaGFyc2V0IH0pLFxuXHRcdFx0aW5mby5maWxlbmFtZSxcblx0XHRcdHRydWVcblx0XHQpO1xuXG5cdFx0Y2IoKTtcblx0fSxcblxuXHRhc3luYzogMTAwLFxuXG5cdGZpbGVuYW1lOiAnKicsXG5cblx0ZXh0ZW5zaW9uOiAnLmNzdicsXG5cblx0ZXhwb3J0T3B0aW9uczoge30sXG5cblx0ZmllbGRTZXBhcmF0b3I6ICcsJyxcblxuXHRmaWVsZEJvdW5kYXJ5OiAnXCInLFxuXG5cdGVzY2FwZUNoYXI6ICdcIicsXG5cblx0Y2hhcnNldDogbnVsbCxcblxuXHRoZWFkZXI6IHRydWUsXG5cblx0Zm9vdGVyOiB0cnVlXG59O1xuXG4vL1xuLy8gRXhjZWwgKHhsc3gpIGV4cG9ydFxuLy9cbkRhdGFUYWJsZS5leHQuYnV0dG9ucy5leGNlbEh0bWw1ID0ge1xuXHRjbGFzc05hbWU6ICdidXR0b25zLWV4Y2VsIGJ1dHRvbnMtaHRtbDUnLFxuXG5cdGF2YWlsYWJsZTogZnVuY3Rpb24gKCkge1xuXHRcdHJldHVybiAoXG5cdFx0XHR3aW5kb3cuRmlsZVJlYWRlciAhPT0gdW5kZWZpbmVkICYmXG5cdFx0XHRfanNaaXAoKSAhPT0gdW5kZWZpbmVkICYmXG5cdFx0XHQhX2lzRHVmZlNhZmFyaSgpICYmXG5cdFx0XHRfc2VyaWFsaXNlclxuXHRcdCk7XG5cdH0sXG5cblx0dGV4dDogZnVuY3Rpb24gKGR0KSB7XG5cdFx0cmV0dXJuIGR0LmkxOG4oJ2J1dHRvbnMuZXhjZWwnLCAnRXhjZWwnKTtcblx0fSxcblxuXHRhY3Rpb246IGZ1bmN0aW9uIChlLCBkdCwgYnV0dG9uLCBjb25maWcsIGNiKSB7XG5cdFx0dmFyIHJvd1BvcyA9IDA7XG5cdFx0dmFyIGRhdGFTdGFydFJvdywgZGF0YUVuZFJvdztcblx0XHR2YXIgZ2V0WG1sID0gZnVuY3Rpb24gKHR5cGUpIHtcblx0XHRcdHZhciBzdHIgPSBleGNlbFN0cmluZ3NbdHlwZV07XG5cblx0XHRcdC8vc3RyID0gc3RyLnJlcGxhY2UoIC94bWxuczovZywgJ3htbG5zXycgKS5yZXBsYWNlKCAvbWM6L2csICdtY18nICk7XG5cblx0XHRcdHJldHVybiAkLnBhcnNlWE1MKHN0cik7XG5cdFx0fTtcblx0XHR2YXIgcmVscyA9IGdldFhtbCgneGwvd29ya3NoZWV0cy9zaGVldDEueG1sJyk7XG5cdFx0dmFyIHJlbHNHZXQgPSByZWxzLmdldEVsZW1lbnRzQnlUYWdOYW1lKCdzaGVldERhdGEnKVswXTtcblxuXHRcdHZhciB4bHN4ID0ge1xuXHRcdFx0X3JlbHM6IHtcblx0XHRcdFx0Jy5yZWxzJzogZ2V0WG1sKCdfcmVscy8ucmVscycpXG5cdFx0XHR9LFxuXHRcdFx0eGw6IHtcblx0XHRcdFx0X3JlbHM6IHtcblx0XHRcdFx0XHQnd29ya2Jvb2sueG1sLnJlbHMnOiBnZXRYbWwoJ3hsL19yZWxzL3dvcmtib29rLnhtbC5yZWxzJylcblx0XHRcdFx0fSxcblx0XHRcdFx0J3dvcmtib29rLnhtbCc6IGdldFhtbCgneGwvd29ya2Jvb2sueG1sJyksXG5cdFx0XHRcdCdzdHlsZXMueG1sJzogZ2V0WG1sKCd4bC9zdHlsZXMueG1sJyksXG5cdFx0XHRcdHdvcmtzaGVldHM6IHtcblx0XHRcdFx0XHQnc2hlZXQxLnhtbCc6IHJlbHNcblx0XHRcdFx0fVxuXHRcdFx0fSxcblx0XHRcdCdbQ29udGVudF9UeXBlc10ueG1sJzogZ2V0WG1sKCdbQ29udGVudF9UeXBlc10ueG1sJylcblx0XHR9O1xuXG5cdFx0dmFyIGRhdGEgPSBkdC5idXR0b25zLmV4cG9ydERhdGEoY29uZmlnLmV4cG9ydE9wdGlvbnMpO1xuXHRcdHZhciBjdXJyZW50Um93LCByb3dOb2RlO1xuXHRcdHZhciBhZGRSb3cgPSBmdW5jdGlvbiAocm93KSB7XG5cdFx0XHRjdXJyZW50Um93ID0gcm93UG9zICsgMTtcblx0XHRcdHJvd05vZGUgPSBfY3JlYXRlTm9kZShyZWxzLCAncm93JywgeyBhdHRyOiB7IHI6IGN1cnJlbnRSb3cgfSB9KTtcblxuXHRcdFx0Zm9yICh2YXIgaSA9IDAsIGllbiA9IHJvdy5sZW5ndGg7IGkgPCBpZW47IGkrKykge1xuXHRcdFx0XHQvLyBDb25jYXQgYm90aCB0aGUgQ2VsbCBDb2x1bW5zIGFzIGEgbGV0dGVyIGFuZCB0aGUgUm93IG9mIHRoZSBjZWxsLlxuXHRcdFx0XHR2YXIgY2VsbElkID0gY3JlYXRlQ2VsbFBvcyhpKSArICcnICsgY3VycmVudFJvdztcblx0XHRcdFx0dmFyIGNlbGwgPSBudWxsO1xuXG5cdFx0XHRcdC8vIEZvciBudWxsLCB1bmRlZmluZWQgb2YgYmxhbmsgY2VsbCwgY29udGludWUgc28gaXQgZG9lc24ndCBjcmVhdGUgdGhlIF9jcmVhdGVOb2RlXG5cdFx0XHRcdGlmIChyb3dbaV0gPT09IG51bGwgfHwgcm93W2ldID09PSB1bmRlZmluZWQgfHwgcm93W2ldID09PSAnJykge1xuXHRcdFx0XHRcdGlmIChjb25maWcuY3JlYXRlRW1wdHlDZWxscyA9PT0gdHJ1ZSkge1xuXHRcdFx0XHRcdFx0cm93W2ldID0gJyc7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdGVsc2Uge1xuXHRcdFx0XHRcdFx0Y29udGludWU7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9XG5cblx0XHRcdFx0dmFyIG9yaWdpbmFsQ29udGVudCA9IHJvd1tpXTtcblx0XHRcdFx0cm93W2ldID1cblx0XHRcdFx0XHR0eXBlb2Ygcm93W2ldLnRyaW0gPT09ICdmdW5jdGlvbicgPyByb3dbaV0udHJpbSgpIDogcm93W2ldO1xuXG5cdFx0XHRcdC8vIFNwZWNpYWwgbnVtYmVyIGZvcm1hdHRpbmcgb3B0aW9uc1xuXHRcdFx0XHRmb3IgKHZhciBqID0gMCwgamVuID0gX2V4Y2VsU3BlY2lhbHMubGVuZ3RoOyBqIDwgamVuOyBqKyspIHtcblx0XHRcdFx0XHR2YXIgc3BlY2lhbCA9IF9leGNlbFNwZWNpYWxzW2pdO1xuXG5cdFx0XHRcdFx0Ly8gVE9ETyBOZWVkIHRvIHByb3ZpZGUgdGhlIGFiaWxpdHkgZm9yIHRoZSBzcGVjaWFscyB0byBzYXlcblx0XHRcdFx0XHQvLyBpZiB0aGV5IGFyZSByZXR1cm5pbmcgYSBzdHJpbmcsIHNpbmNlIGF0IHRoZSBtb21lbnQgaXQgaXNcblx0XHRcdFx0XHQvLyBhc3N1bWVkIHRvIGJlIGEgbnVtYmVyXG5cdFx0XHRcdFx0aWYgKFxuXHRcdFx0XHRcdFx0cm93W2ldLm1hdGNoICYmXG5cdFx0XHRcdFx0XHQhcm93W2ldLm1hdGNoKC9eMFxcZCsvKSAmJlxuXHRcdFx0XHRcdFx0cm93W2ldLm1hdGNoKHNwZWNpYWwubWF0Y2gpXG5cdFx0XHRcdFx0KSB7XG5cdFx0XHRcdFx0XHR2YXIgdmFsID0gcm93W2ldLnJlcGxhY2UoL1teXFxkXFwuXFwtXS9nLCAnJyk7XG5cblx0XHRcdFx0XHRcdGlmIChzcGVjaWFsLmZtdCkge1xuXHRcdFx0XHRcdFx0XHR2YWwgPSBzcGVjaWFsLmZtdCh2YWwpO1xuXHRcdFx0XHRcdFx0fVxuXG5cdFx0XHRcdFx0XHRjZWxsID0gX2NyZWF0ZU5vZGUocmVscywgJ2MnLCB7XG5cdFx0XHRcdFx0XHRcdGF0dHI6IHtcblx0XHRcdFx0XHRcdFx0XHRyOiBjZWxsSWQsXG5cdFx0XHRcdFx0XHRcdFx0czogc3BlY2lhbC5zdHlsZVxuXHRcdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0XHRjaGlsZHJlbjogW19jcmVhdGVOb2RlKHJlbHMsICd2JywgeyB0ZXh0OiB2YWwgfSldXG5cdFx0XHRcdFx0XHR9KTtcblxuXHRcdFx0XHRcdFx0YnJlYWs7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9XG5cblx0XHRcdFx0aWYgKCFjZWxsKSB7XG5cdFx0XHRcdFx0aWYgKFxuXHRcdFx0XHRcdFx0dHlwZW9mIHJvd1tpXSA9PT0gJ251bWJlcicgfHxcblx0XHRcdFx0XHRcdChyb3dbaV0ubWF0Y2ggJiZcblx0XHRcdFx0XHRcdFx0cm93W2ldLm1hdGNoKC9eLT9cXGQrKFxcLlxcZCspPyhbZUVdXFwtP1xcZCspPyQvKSAmJiAvLyBJbmNsdWRlcyBleHBvbmVudGlhbCBmb3JtYXRcblx0XHRcdFx0XHRcdFx0IXJvd1tpXS5tYXRjaCgvXjBcXGQrLykpXG5cdFx0XHRcdFx0KSB7XG5cdFx0XHRcdFx0XHQvLyBEZXRlY3QgbnVtYmVycyAtIGRvbid0IG1hdGNoIG51bWJlcnMgd2l0aCBsZWFkaW5nIHplcm9zXG5cdFx0XHRcdFx0XHQvLyBvciBhIG5lZ2F0aXZlIGFueXdoZXJlIGJ1dCB0aGUgc3RhcnRcblx0XHRcdFx0XHRcdGNlbGwgPSBfY3JlYXRlTm9kZShyZWxzLCAnYycsIHtcblx0XHRcdFx0XHRcdFx0YXR0cjoge1xuXHRcdFx0XHRcdFx0XHRcdHQ6ICduJyxcblx0XHRcdFx0XHRcdFx0XHRyOiBjZWxsSWRcblx0XHRcdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRcdFx0Y2hpbGRyZW46IFtfY3JlYXRlTm9kZShyZWxzLCAndicsIHsgdGV4dDogcm93W2ldIH0pXVxuXHRcdFx0XHRcdFx0fSk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdGVsc2Uge1xuXHRcdFx0XHRcdFx0Ly8gU3RyaW5nIG91dHB1dCAtIHJlcGxhY2Ugbm9uIHN0YW5kYXJkIGNoYXJhY3RlcnMgZm9yIHRleHQgb3V0cHV0XG5cdFx0XHRcdFx0XHQvKmVzbGludCBuby1jb250cm9sLXJlZ2V4OiBcIm9mZlwiKi9cblx0XHRcdFx0XHRcdHZhciB0ZXh0ID0gIW9yaWdpbmFsQ29udGVudC5yZXBsYWNlXG5cdFx0XHRcdFx0XHRcdD8gb3JpZ2luYWxDb250ZW50XG5cdFx0XHRcdFx0XHRcdDogb3JpZ2luYWxDb250ZW50LnJlcGxhY2UoXG5cdFx0XHRcdFx0XHRcdFx0XHQvW1xceDAwLVxceDA5XFx4MEJcXHgwQ1xceDBFLVxceDFGXFx4N0YtXFx4OUZdL2csXG5cdFx0XHRcdFx0XHRcdFx0XHQnJ1xuXHRcdFx0XHRcdFx0XHQpO1xuXG5cdFx0XHRcdFx0XHRjZWxsID0gX2NyZWF0ZU5vZGUocmVscywgJ2MnLCB7XG5cdFx0XHRcdFx0XHRcdGF0dHI6IHtcblx0XHRcdFx0XHRcdFx0XHR0OiAnaW5saW5lU3RyJyxcblx0XHRcdFx0XHRcdFx0XHRyOiBjZWxsSWRcblx0XHRcdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRcdFx0Y2hpbGRyZW46IHtcblx0XHRcdFx0XHRcdFx0XHRyb3c6IF9jcmVhdGVOb2RlKHJlbHMsICdpcycsIHtcblx0XHRcdFx0XHRcdFx0XHRcdGNoaWxkcmVuOiB7XG5cdFx0XHRcdFx0XHRcdFx0XHRcdHJvdzogX2NyZWF0ZU5vZGUocmVscywgJ3QnLCB7XG5cdFx0XHRcdFx0XHRcdFx0XHRcdFx0dGV4dDogdGV4dCxcblx0XHRcdFx0XHRcdFx0XHRcdFx0XHRhdHRyOiB7XG5cdFx0XHRcdFx0XHRcdFx0XHRcdFx0XHQneG1sOnNwYWNlJzogJ3ByZXNlcnZlJ1xuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHRcdFx0XHRcdFx0fSlcblx0XHRcdFx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHRcdFx0XHR9KVxuXHRcdFx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0XHR9KTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdH1cblxuXHRcdFx0XHRyb3dOb2RlLmFwcGVuZENoaWxkKGNlbGwpO1xuXHRcdFx0fVxuXG5cdFx0XHRyZWxzR2V0LmFwcGVuZENoaWxkKHJvd05vZGUpO1xuXHRcdFx0cm93UG9zKys7XG5cdFx0fTtcblxuXHRcdHZhciBhZGRIZWFkZXIgPSBmdW5jdGlvbiAoc3RydWN0dXJlKSB7XG5cdFx0XHRzdHJ1Y3R1cmUuZm9yRWFjaChmdW5jdGlvbiAocm93KSB7XG5cdFx0XHRcdGFkZFJvdyhcblx0XHRcdFx0XHRyb3cubWFwKGZ1bmN0aW9uIChjZWxsKSB7XG5cdFx0XHRcdFx0XHRyZXR1cm4gY2VsbCA/IGNlbGwudGl0bGUgOiAnJztcblx0XHRcdFx0XHR9KSxcblx0XHRcdFx0XHRyb3dQb3Ncblx0XHRcdFx0KTtcblx0XHRcdFx0JCgncm93Omxhc3QgYycsIHJlbHMpLmF0dHIoJ3MnLCAnMicpOyAvLyBib2xkXG5cblx0XHRcdFx0Ly8gQWRkIGFueSBtZXJnZSBjZWxsc1xuXHRcdFx0XHRyb3cuZm9yRWFjaChmdW5jdGlvbiAoY2VsbCwgY29sdW1uQ291bnRlcikge1xuXHRcdFx0XHRcdGlmIChjZWxsICYmIChjZWxsLmNvbFNwYW4gPiAxIHx8IGNlbGwucm93U3BhbiA+IDEpKSB7XG5cdFx0XHRcdFx0XHRfZXhjZWxNZXJnZUNlbGxzKFxuXHRcdFx0XHRcdFx0XHRyZWxzLFxuXHRcdFx0XHRcdFx0XHRyb3dQb3MsXG5cdFx0XHRcdFx0XHRcdGNvbHVtbkNvdW50ZXIsXG5cdFx0XHRcdFx0XHRcdGNlbGwucm93U3Bhbixcblx0XHRcdFx0XHRcdFx0Y2VsbC5jb2xTcGFuXG5cdFx0XHRcdFx0XHQpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9O1xuXG5cdFx0aWYgKGNvbmZpZy5jdXN0b21pemVEYXRhKSB7XG5cdFx0XHRjb25maWcuY3VzdG9taXplRGF0YShkYXRhKTtcblx0XHR9XG5cblx0XHQvLyBUaXRsZSBhbmQgdG9wIG1lc3NhZ2VzXG5cdFx0dmFyIGV4cG9ydEluZm8gPSBkdC5idXR0b25zLmV4cG9ydEluZm8oY29uZmlnKTtcblx0XHRpZiAoZXhwb3J0SW5mby50aXRsZSkge1xuXHRcdFx0YWRkUm93KFtleHBvcnRJbmZvLnRpdGxlXSwgcm93UG9zKTtcblx0XHRcdF9leGNlbE1lcmdlQ2VsbHMocmVscywgcm93UG9zLCAwLCAxLCBkYXRhLmhlYWRlci5sZW5ndGgpO1xuXHRcdFx0JCgncm93Omxhc3QgYycsIHJlbHMpLmF0dHIoJ3MnLCAnNTEnKTsgLy8gY2VudHJlXG5cdFx0fVxuXG5cdFx0aWYgKGV4cG9ydEluZm8ubWVzc2FnZVRvcCkge1xuXHRcdFx0YWRkUm93KFtleHBvcnRJbmZvLm1lc3NhZ2VUb3BdLCByb3dQb3MpO1xuXHRcdFx0X2V4Y2VsTWVyZ2VDZWxscyhyZWxzLCByb3dQb3MsIDAsIDEsIGRhdGEuaGVhZGVyLmxlbmd0aCk7XG5cdFx0fVxuXG5cdFx0Ly8gVGFibGUgaGVhZGVyXG5cdFx0aWYgKGNvbmZpZy5oZWFkZXIpIHtcblx0XHRcdGFkZEhlYWRlcihkYXRhLmhlYWRlclN0cnVjdHVyZSk7XG5cdFx0fVxuXG5cdFx0ZGF0YVN0YXJ0Um93ID0gcm93UG9zO1xuXG5cdFx0Ly8gVGFibGUgYm9keVxuXHRcdGZvciAodmFyIG4gPSAwLCBpZSA9IGRhdGEuYm9keS5sZW5ndGg7IG4gPCBpZTsgbisrKSB7XG5cdFx0XHRhZGRSb3coZGF0YS5ib2R5W25dLCByb3dQb3MpO1xuXHRcdH1cblxuXHRcdGRhdGFFbmRSb3cgPSByb3dQb3M7XG5cblx0XHQvLyBUYWJsZSBmb290ZXJcblx0XHRpZiAoY29uZmlnLmZvb3RlciAmJiBkYXRhLmZvb3Rlcikge1xuXHRcdFx0YWRkSGVhZGVyKGRhdGEuZm9vdGVyU3RydWN0dXJlKTtcblx0XHR9XG5cblx0XHQvLyBCZWxvdyB0aGUgdGFibGVcblx0XHRpZiAoZXhwb3J0SW5mby5tZXNzYWdlQm90dG9tKSB7XG5cdFx0XHRhZGRSb3coW2V4cG9ydEluZm8ubWVzc2FnZUJvdHRvbV0sIHJvd1Bvcyk7XG5cdFx0XHRfZXhjZWxNZXJnZUNlbGxzKHJlbHMsIHJvd1BvcywgMCwgMSwgZGF0YS5oZWFkZXIubGVuZ3RoKTtcblx0XHR9XG5cblx0XHQvLyBTZXQgY29sdW1uIHdpZHRoc1xuXHRcdHZhciBjb2xzID0gX2NyZWF0ZU5vZGUocmVscywgJ2NvbHMnKTtcblx0XHQkKCd3b3Jrc2hlZXQnLCByZWxzKS5wcmVwZW5kKGNvbHMpO1xuXG5cdFx0Zm9yICh2YXIgaSA9IDAsIGllbiA9IGRhdGEuaGVhZGVyLmxlbmd0aDsgaSA8IGllbjsgaSsrKSB7XG5cdFx0XHRjb2xzLmFwcGVuZENoaWxkKFxuXHRcdFx0XHRfY3JlYXRlTm9kZShyZWxzLCAnY29sJywge1xuXHRcdFx0XHRcdGF0dHI6IHtcblx0XHRcdFx0XHRcdG1pbjogaSArIDEsXG5cdFx0XHRcdFx0XHRtYXg6IGkgKyAxLFxuXHRcdFx0XHRcdFx0d2lkdGg6IF9leGNlbENvbFdpZHRoKGRhdGEsIGkpLFxuXHRcdFx0XHRcdFx0Y3VzdG9tV2lkdGg6IDFcblx0XHRcdFx0XHR9XG5cdFx0XHRcdH0pXG5cdFx0XHQpO1xuXHRcdH1cblxuXHRcdC8vIFdvcmtib29rIG1vZGlmaWNhdGlvbnNcblx0XHR2YXIgd29ya2Jvb2sgPSB4bHN4LnhsWyd3b3JrYm9vay54bWwnXTtcblxuXHRcdCQoJ3NoZWV0cyBzaGVldCcsIHdvcmtib29rKS5hdHRyKCduYW1lJywgX3NoZWV0bmFtZShjb25maWcpKTtcblxuXHRcdC8vIEF1dG8gZmlsdGVyIGZvciBjb2x1bW5zXG5cdFx0aWYgKGNvbmZpZy5hdXRvRmlsdGVyKSB7XG5cdFx0XHQkKCdtZXJnZUNlbGxzJywgcmVscykuYmVmb3JlKFxuXHRcdFx0XHRfY3JlYXRlTm9kZShyZWxzLCAnYXV0b0ZpbHRlcicsIHtcblx0XHRcdFx0XHRhdHRyOiB7XG5cdFx0XHRcdFx0XHRyZWY6XG5cdFx0XHRcdFx0XHRcdCdBJyArXG5cdFx0XHRcdFx0XHRcdGRhdGFTdGFydFJvdyArXG5cdFx0XHRcdFx0XHRcdCc6JyArXG5cdFx0XHRcdFx0XHRcdGNyZWF0ZUNlbGxQb3MoZGF0YS5oZWFkZXIubGVuZ3RoIC0gMSkgK1xuXHRcdFx0XHRcdFx0XHRkYXRhRW5kUm93XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9KVxuXHRcdFx0KTtcblxuXHRcdFx0JCgnZGVmaW5lZE5hbWVzJywgd29ya2Jvb2spLmFwcGVuZChcblx0XHRcdFx0X2NyZWF0ZU5vZGUod29ya2Jvb2ssICdkZWZpbmVkTmFtZScsIHtcblx0XHRcdFx0XHRhdHRyOiB7XG5cdFx0XHRcdFx0XHRuYW1lOiAnX3hsbm0uX0ZpbHRlckRhdGFiYXNlJyxcblx0XHRcdFx0XHRcdGxvY2FsU2hlZXRJZDogJzAnLFxuXHRcdFx0XHRcdFx0aGlkZGVuOiAxXG5cdFx0XHRcdFx0fSxcblx0XHRcdFx0XHR0ZXh0OlxuXHRcdFx0XHRcdFx0X3NoZWV0bmFtZShjb25maWcpICtcblx0XHRcdFx0XHRcdCchJEEkJyArXG5cdFx0XHRcdFx0XHRkYXRhU3RhcnRSb3cgK1xuXHRcdFx0XHRcdFx0JzonICtcblx0XHRcdFx0XHRcdGNyZWF0ZUNlbGxQb3MoZGF0YS5oZWFkZXIubGVuZ3RoIC0gMSkgK1xuXHRcdFx0XHRcdFx0ZGF0YUVuZFJvd1xuXHRcdFx0XHR9KVxuXHRcdFx0KTtcblx0XHR9XG5cblx0XHQvLyBMZXQgdGhlIGRldmVsb3BlciBjdXN0b21pc2UgdGhlIGRvY3VtZW50IGlmIHRoZXkgd2FudCB0b1xuXHRcdGlmIChjb25maWcuY3VzdG9taXplKSB7XG5cdFx0XHRjb25maWcuY3VzdG9taXplKHhsc3gsIGNvbmZpZywgZHQpO1xuXHRcdH1cblxuXHRcdC8vIEV4Y2VsIGRvZXNuJ3QgbGlrZSBhbiBlbXB0eSBtZXJnZUNlbGxzIHRhZ1xuXHRcdGlmICgkKCdtZXJnZUNlbGxzJywgcmVscykuY2hpbGRyZW4oKS5sZW5ndGggPT09IDApIHtcblx0XHRcdCQoJ21lcmdlQ2VsbHMnLCByZWxzKS5yZW1vdmUoKTtcblx0XHR9XG5cblx0XHR2YXIganN6aXAgPSBfanNaaXAoKTtcblx0XHR2YXIgemlwID0gbmV3IGpzemlwKCk7XG5cdFx0dmFyIHppcENvbmZpZyA9IHtcblx0XHRcdGNvbXByZXNzaW9uOiAnREVGTEFURScsXG5cdFx0XHR0eXBlOiAnYmxvYicsXG5cdFx0XHRtaW1lVHlwZTpcblx0XHRcdFx0J2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnNoZWV0J1xuXHRcdH07XG5cblx0XHRfYWRkVG9aaXAoemlwLCB4bHN4KTtcblxuXHRcdC8vIE1vZGVybiBFeGNlbCBoYXMgYSAyMTggY2hhcmFjdGVyIGxpbWl0IG9uIHRoZSBmaWxlIG5hbWUgKyBwYXRoIG9mIHRoZSBmaWxlICh3aHkhPylcblx0XHQvLyBodHRwczovL3N1cHBvcnQubWljcm9zb2Z0LmNvbS9lbi11cy9vZmZpY2UvZXhjZWwtc3BlY2lmaWNhdGlvbnMtYW5kLWxpbWl0cy0xNjcyYjM0ZC03MDQzLTQ2N2UtOGUyNy0yNjlkNjU2NzcxYzNcblx0XHQvLyBTbyB3ZSB0cnVuY2F0ZSB0byBhbGxvdyBmb3IgdGhpcy5cblx0XHR2YXIgZmlsZW5hbWUgPSBleHBvcnRJbmZvLmZpbGVuYW1lO1xuXG5cdFx0aWYgKGZpbGVuYW1lID4gMTc1KSB7XG5cdFx0XHRmaWxlbmFtZSA9IGZpbGVuYW1lLnN1YnN0cigwLCAxNzUpO1xuXHRcdH1cblxuXHRcdGlmICh6aXAuZ2VuZXJhdGVBc3luYykge1xuXHRcdFx0Ly8gSlNaaXAgMytcblx0XHRcdHppcC5nZW5lcmF0ZUFzeW5jKHppcENvbmZpZykudGhlbihmdW5jdGlvbiAoYmxvYikge1xuXHRcdFx0XHRfc2F2ZUFzKGJsb2IsIGZpbGVuYW1lKTtcblx0XHRcdFx0Y2IoKTtcblx0XHRcdH0pO1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdC8vIEpTWmlwIDIuNVxuXHRcdFx0X3NhdmVBcyh6aXAuZ2VuZXJhdGUoemlwQ29uZmlnKSwgZmlsZW5hbWUpO1xuXHRcdFx0Y2IoKTtcblx0XHR9XG5cdH0sXG5cblx0YXN5bmM6IDEwMCxcblxuXHRmaWxlbmFtZTogJyonLFxuXG5cdGV4dGVuc2lvbjogJy54bHN4JyxcblxuXHRleHBvcnRPcHRpb25zOiB7fSxcblxuXHRoZWFkZXI6IHRydWUsXG5cblx0Zm9vdGVyOiB0cnVlLFxuXG5cdHRpdGxlOiAnKicsXG5cblx0bWVzc2FnZVRvcDogJyonLFxuXG5cdG1lc3NhZ2VCb3R0b206ICcqJyxcblxuXHRjcmVhdGVFbXB0eUNlbGxzOiBmYWxzZSxcblxuXHRhdXRvRmlsdGVyOiBmYWxzZSxcblxuXHRzaGVldE5hbWU6ICcnXG59O1xuXG4vL1xuLy8gUERGIGV4cG9ydCAtIHVzaW5nIHBkZk1ha2UgLSBodHRwOi8vcGRmbWFrZS5vcmdcbi8vXG5EYXRhVGFibGUuZXh0LmJ1dHRvbnMucGRmSHRtbDUgPSB7XG5cdGNsYXNzTmFtZTogJ2J1dHRvbnMtcGRmIGJ1dHRvbnMtaHRtbDUnLFxuXG5cdGF2YWlsYWJsZTogZnVuY3Rpb24gKCkge1xuXHRcdHJldHVybiB3aW5kb3cuRmlsZVJlYWRlciAhPT0gdW5kZWZpbmVkICYmIF9wZGZNYWtlKCk7XG5cdH0sXG5cblx0dGV4dDogZnVuY3Rpb24gKGR0KSB7XG5cdFx0cmV0dXJuIGR0LmkxOG4oJ2J1dHRvbnMucGRmJywgJ1BERicpO1xuXHR9LFxuXG5cdGFjdGlvbjogZnVuY3Rpb24gKGUsIGR0LCBidXR0b24sIGNvbmZpZywgY2IpIHtcblx0XHR2YXIgZGF0YSA9IGR0LmJ1dHRvbnMuZXhwb3J0RGF0YShjb25maWcuZXhwb3J0T3B0aW9ucyk7XG5cdFx0dmFyIGluZm8gPSBkdC5idXR0b25zLmV4cG9ydEluZm8oY29uZmlnKTtcblx0XHR2YXIgcm93cyA9IFtdO1xuXG5cdFx0aWYgKGNvbmZpZy5oZWFkZXIpIHtcblx0XHRcdGRhdGEuaGVhZGVyU3RydWN0dXJlLmZvckVhY2goZnVuY3Rpb24gKHJvdykge1xuXHRcdFx0XHRyb3dzLnB1c2goXG5cdFx0XHRcdFx0cm93Lm1hcChmdW5jdGlvbiAoY2VsbCkge1xuXHRcdFx0XHRcdFx0cmV0dXJuIGNlbGxcblx0XHRcdFx0XHRcdFx0PyB7XG5cdFx0XHRcdFx0XHRcdFx0XHR0ZXh0OiBjZWxsLnRpdGxlLFxuXHRcdFx0XHRcdFx0XHRcdFx0Y29sU3BhbjogY2VsbC5jb2xzcGFuLFxuXHRcdFx0XHRcdFx0XHRcdFx0cm93U3BhbjogY2VsbC5yb3dzcGFuLFxuXHRcdFx0XHRcdFx0XHRcdFx0c3R5bGU6ICd0YWJsZUhlYWRlcidcblx0XHRcdFx0XHRcdFx0fVxuXHRcdFx0XHRcdFx0XHQ6IHt9O1xuXHRcdFx0XHRcdH0pXG5cdFx0XHRcdCk7XG5cdFx0XHR9KTtcblx0XHR9XG5cblx0XHRmb3IgKHZhciBpID0gMCwgaWVuID0gZGF0YS5ib2R5Lmxlbmd0aDsgaSA8IGllbjsgaSsrKSB7XG5cdFx0XHRyb3dzLnB1c2goXG5cdFx0XHRcdGRhdGEuYm9keVtpXS5tYXAoZnVuY3Rpb24gKGQpIHtcblx0XHRcdFx0XHRyZXR1cm4ge1xuXHRcdFx0XHRcdFx0dGV4dDpcblx0XHRcdFx0XHRcdFx0ZCA9PT0gbnVsbCB8fCBkID09PSB1bmRlZmluZWRcblx0XHRcdFx0XHRcdFx0XHQ/ICcnXG5cdFx0XHRcdFx0XHRcdFx0OiB0eXBlb2YgZCA9PT0gJ3N0cmluZydcblx0XHRcdFx0XHRcdFx0XHQ/IGRcblx0XHRcdFx0XHRcdFx0XHQ6IGQudG9TdHJpbmcoKVxuXHRcdFx0XHRcdH07XG5cdFx0XHRcdH0pXG5cdFx0XHQpO1xuXHRcdH1cblxuXHRcdGlmIChjb25maWcuZm9vdGVyKSB7XG5cdFx0XHRkYXRhLmZvb3RlclN0cnVjdHVyZS5mb3JFYWNoKGZ1bmN0aW9uIChyb3cpIHtcblx0XHRcdFx0cm93cy5wdXNoKFxuXHRcdFx0XHRcdHJvdy5tYXAoZnVuY3Rpb24gKGNlbGwpIHtcblx0XHRcdFx0XHRcdHJldHVybiBjZWxsXG5cdFx0XHRcdFx0XHRcdD8ge1xuXHRcdFx0XHRcdFx0XHRcdFx0dGV4dDogY2VsbC50aXRsZSxcblx0XHRcdFx0XHRcdFx0XHRcdGNvbFNwYW46IGNlbGwuY29sc3Bhbixcblx0XHRcdFx0XHRcdFx0XHRcdHJvd1NwYW46IGNlbGwucm93c3Bhbixcblx0XHRcdFx0XHRcdFx0XHRcdHN0eWxlOiAndGFibGVIZWFkZXInXG5cdFx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHRcdFx0OiB7fTtcblx0XHRcdFx0XHR9KVxuXHRcdFx0XHQpO1xuXHRcdFx0fSk7XG5cdFx0fVxuXG5cdFx0dmFyIGRvYyA9IHtcblx0XHRcdHBhZ2VTaXplOiBjb25maWcucGFnZVNpemUsXG5cdFx0XHRwYWdlT3JpZW50YXRpb246IGNvbmZpZy5vcmllbnRhdGlvbixcblx0XHRcdGNvbnRlbnQ6IFtcblx0XHRcdFx0e1xuXHRcdFx0XHRcdHN0eWxlOiAndGFibGUnLFxuXHRcdFx0XHRcdHRhYmxlOiB7XG5cdFx0XHRcdFx0XHRoZWFkZXJSb3dzOiBkYXRhLmhlYWRlclN0cnVjdHVyZS5sZW5ndGgsXG5cdFx0XHRcdFx0XHRmb290ZXJSb3dzOiBkYXRhLmZvb3RlclN0cnVjdHVyZS5sZW5ndGgsIC8vIFVzZWQgZm9yIHN0eWxpbmcsIGRvZXNuJ3QgZG8gYW55dGhpbmcgaW4gcGRmbWFrZVxuXHRcdFx0XHRcdFx0Ym9keTogcm93c1xuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0bGF5b3V0OiB7XG5cdFx0XHRcdFx0XHRoTGluZVdpZHRoOiBmdW5jdGlvbiAoaSwgbm9kZSkge1xuXHRcdFx0XHRcdFx0XHRpZiAoaSA9PT0gMCB8fCBpID09PSBub2RlLnRhYmxlLmJvZHkubGVuZ3RoKSB7XG5cdFx0XHRcdFx0XHRcdFx0cmV0dXJuIDA7XG5cdFx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHRcdFx0cmV0dXJuIDAuNTtcblx0XHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0XHR2TGluZVdpZHRoOiBmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdFx0XHRcdHJldHVybiAwO1xuXHRcdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRcdGhMaW5lQ29sb3I6IGZ1bmN0aW9uIChpLCBub2RlKSB7XG5cdFx0XHRcdFx0XHRcdHJldHVybiBpID09PSBub2RlLnRhYmxlLmhlYWRlclJvd3MgfHxcblx0XHRcdFx0XHRcdFx0XHRpID09PVxuXHRcdFx0XHRcdFx0XHRcdFx0bm9kZS50YWJsZS5ib2R5Lmxlbmd0aCAtXG5cdFx0XHRcdFx0XHRcdFx0XHRcdG5vZGUudGFibGUuZm9vdGVyUm93c1xuXHRcdFx0XHRcdFx0XHRcdD8gJyMzMzMnXG5cdFx0XHRcdFx0XHRcdFx0OiAnI2RkZCc7XG5cdFx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdFx0ZmlsbENvbG9yOiBmdW5jdGlvbiAocm93SW5kZXgpIHtcblx0XHRcdFx0XHRcdFx0aWYgKHJvd0luZGV4IDwgZGF0YS5oZWFkZXJTdHJ1Y3R1cmUubGVuZ3RoKSB7XG5cdFx0XHRcdFx0XHRcdFx0cmV0dXJuICcjZmZmJztcblx0XHRcdFx0XHRcdFx0fVxuXHRcdFx0XHRcdFx0XHRyZXR1cm4gcm93SW5kZXggJSAyID09PSAwID8gJyNmM2YzZjMnIDogbnVsbDtcblx0XHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0XHRwYWRkaW5nVG9wOiBmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdFx0XHRcdHJldHVybiA1O1xuXHRcdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRcdHBhZGRpbmdCb3R0b206IGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0XHRcdFx0cmV0dXJuIDU7XG5cdFx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9XG5cdFx0XHRdLFxuXHRcdFx0c3R5bGVzOiB7XG5cdFx0XHRcdHRhYmxlSGVhZGVyOiB7XG5cdFx0XHRcdFx0Ym9sZDogdHJ1ZSxcblx0XHRcdFx0XHRmb250U2l6ZTogMTEsXG5cdFx0XHRcdFx0YWxpZ25tZW50OiAnY2VudGVyJ1xuXHRcdFx0XHR9LFxuXHRcdFx0XHR0YWJsZUZvb3Rlcjoge1xuXHRcdFx0XHRcdGJvbGQ6IHRydWUsXG5cdFx0XHRcdFx0Zm9udFNpemU6IDExXG5cdFx0XHRcdH0sXG5cdFx0XHRcdHRhYmxlOiB7XG5cdFx0XHRcdFx0bWFyZ2luOiBbMCwgNSwgMCwgNV1cblx0XHRcdFx0fSxcblx0XHRcdFx0dGl0bGU6IHtcblx0XHRcdFx0XHRhbGlnbm1lbnQ6ICdjZW50ZXInLFxuXHRcdFx0XHRcdGZvbnRTaXplOiAxM1xuXHRcdFx0XHR9LFxuXHRcdFx0XHRtZXNzYWdlOiB7fVxuXHRcdFx0fSxcblx0XHRcdGRlZmF1bHRTdHlsZToge1xuXHRcdFx0XHRmb250U2l6ZTogMTBcblx0XHRcdH1cblx0XHR9O1xuXG5cdFx0aWYgKGluZm8ubWVzc2FnZVRvcCkge1xuXHRcdFx0ZG9jLmNvbnRlbnQudW5zaGlmdCh7XG5cdFx0XHRcdHRleHQ6IGluZm8ubWVzc2FnZVRvcCxcblx0XHRcdFx0c3R5bGU6ICdtZXNzYWdlJyxcblx0XHRcdFx0bWFyZ2luOiBbMCwgMCwgMCwgMTJdXG5cdFx0XHR9KTtcblx0XHR9XG5cblx0XHRpZiAoaW5mby5tZXNzYWdlQm90dG9tKSB7XG5cdFx0XHRkb2MuY29udGVudC5wdXNoKHtcblx0XHRcdFx0dGV4dDogaW5mby5tZXNzYWdlQm90dG9tLFxuXHRcdFx0XHRzdHlsZTogJ21lc3NhZ2UnLFxuXHRcdFx0XHRtYXJnaW46IFswLCAwLCAwLCAxMl1cblx0XHRcdH0pO1xuXHRcdH1cblxuXHRcdGlmIChpbmZvLnRpdGxlKSB7XG5cdFx0XHRkb2MuY29udGVudC51bnNoaWZ0KHtcblx0XHRcdFx0dGV4dDogaW5mby50aXRsZSxcblx0XHRcdFx0c3R5bGU6ICd0aXRsZScsXG5cdFx0XHRcdG1hcmdpbjogWzAsIDAsIDAsIDEyXVxuXHRcdFx0fSk7XG5cdFx0fVxuXG5cdFx0aWYgKGNvbmZpZy5jdXN0b21pemUpIHtcblx0XHRcdGNvbmZpZy5jdXN0b21pemUoZG9jLCBjb25maWcsIGR0KTtcblx0XHR9XG5cblx0XHR2YXIgcGRmID0gX3BkZk1ha2UoKS5jcmVhdGVQZGYoZG9jKTtcblxuXHRcdGlmIChjb25maWcuZG93bmxvYWQgPT09ICdvcGVuJyAmJiAhX2lzRHVmZlNhZmFyaSgpKSB7XG5cdFx0XHRwZGYub3BlbigpO1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdHBkZi5kb3dubG9hZChpbmZvLmZpbGVuYW1lKTtcblx0XHR9XG5cblx0XHRjYigpO1xuXHR9LFxuXG5cdGFzeW5jOiAxMDAsXG5cblx0dGl0bGU6ICcqJyxcblxuXHRmaWxlbmFtZTogJyonLFxuXG5cdGV4dGVuc2lvbjogJy5wZGYnLFxuXG5cdGV4cG9ydE9wdGlvbnM6IHt9LFxuXG5cdG9yaWVudGF0aW9uOiAncG9ydHJhaXQnLFxuXG5cdC8vIFRoaXMgaXNuJ3QgcGVyZmVjdCwgYnV0IGl0IGlzIGNsb3NlXG5cdHBhZ2VTaXplOlxuXHRcdG5hdmlnYXRvci5sYW5ndWFnZSA9PT0gJ2VuLVVTJyB8fCBuYXZpZ2F0b3IubGFuZ3VhZ2UgPT09ICdlbi1DQSdcblx0XHRcdD8gJ0xFVFRFUidcblx0XHRcdDogJ0E0JyxcblxuXHRoZWFkZXI6IHRydWUsXG5cblx0Zm9vdGVyOiB0cnVlLFxuXG5cdG1lc3NhZ2VUb3A6ICcqJyxcblxuXHRtZXNzYWdlQm90dG9tOiAnKicsXG5cblx0Y3VzdG9taXplOiBudWxsLFxuXG5cdGRvd25sb2FkOiAnZG93bmxvYWQnXG59O1xuXG5cbnJldHVybiBEYXRhVGFibGU7XG59KSk7XG4iLCIvKiFcbiAqIFByaW50IGJ1dHRvbiBmb3IgQnV0dG9ucyBhbmQgRGF0YVRhYmxlcy5cbiAqIMKpIFNwcnlNZWRpYSBMdGQgLSBkYXRhdGFibGVzLm5ldC9saWNlbnNlXG4gKi9cblxuKGZ1bmN0aW9uKCBmYWN0b3J5ICl7XG5cdGlmICggdHlwZW9mIGRlZmluZSA9PT0gJ2Z1bmN0aW9uJyAmJiBkZWZpbmUuYW1kICkge1xuXHRcdC8vIEFNRFxuXHRcdGRlZmluZSggWydqcXVlcnknLCAnZGF0YXRhYmxlcy5uZXQnLCAnZGF0YXRhYmxlcy5uZXQtYnV0dG9ucyddLCBmdW5jdGlvbiAoICQgKSB7XG5cdFx0XHRyZXR1cm4gZmFjdG9yeSggJCwgd2luZG93LCBkb2N1bWVudCApO1xuXHRcdH0gKTtcblx0fVxuXHRlbHNlIGlmICggdHlwZW9mIGV4cG9ydHMgPT09ICdvYmplY3QnICkge1xuXHRcdC8vIENvbW1vbkpTXG5cdFx0dmFyIGpxID0gcmVxdWlyZSgnanF1ZXJ5Jyk7XG5cdFx0dmFyIGNqc1JlcXVpcmVzID0gZnVuY3Rpb24gKHJvb3QsICQpIHtcblx0XHRcdGlmICggISAkLmZuLmRhdGFUYWJsZSApIHtcblx0XHRcdFx0cmVxdWlyZSgnZGF0YXRhYmxlcy5uZXQnKShyb290LCAkKTtcblx0XHRcdH1cblxuXHRcdFx0aWYgKCAhICQuZm4uZGF0YVRhYmxlLkJ1dHRvbnMgKSB7XG5cdFx0XHRcdHJlcXVpcmUoJ2RhdGF0YWJsZXMubmV0LWJ1dHRvbnMnKShyb290LCAkKTtcblx0XHRcdH1cblx0XHR9O1xuXG5cdFx0aWYgKHR5cGVvZiB3aW5kb3cgPT09ICd1bmRlZmluZWQnKSB7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIChyb290LCAkKSB7XG5cdFx0XHRcdGlmICggISByb290ICkge1xuXHRcdFx0XHRcdC8vIENvbW1vbkpTIGVudmlyb25tZW50cyB3aXRob3V0IGEgd2luZG93IGdsb2JhbCBtdXN0IHBhc3MgYVxuXHRcdFx0XHRcdC8vIHJvb3QuIFRoaXMgd2lsbCBnaXZlIGFuIGVycm9yIG90aGVyd2lzZVxuXHRcdFx0XHRcdHJvb3QgPSB3aW5kb3c7XG5cdFx0XHRcdH1cblxuXHRcdFx0XHRpZiAoICEgJCApIHtcblx0XHRcdFx0XHQkID0ganEoIHJvb3QgKTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdGNqc1JlcXVpcmVzKCByb290LCAkICk7XG5cdFx0XHRcdHJldHVybiBmYWN0b3J5KCAkLCByb290LCByb290LmRvY3VtZW50ICk7XG5cdFx0XHR9O1xuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGNqc1JlcXVpcmVzKCB3aW5kb3csIGpxICk7XG5cdFx0XHRtb2R1bGUuZXhwb3J0cyA9IGZhY3RvcnkoIGpxLCB3aW5kb3csIHdpbmRvdy5kb2N1bWVudCApO1xuXHRcdH1cblx0fVxuXHRlbHNlIHtcblx0XHQvLyBCcm93c2VyXG5cdFx0ZmFjdG9yeSggalF1ZXJ5LCB3aW5kb3csIGRvY3VtZW50ICk7XG5cdH1cbn0oZnVuY3Rpb24oICQsIHdpbmRvdywgZG9jdW1lbnQgKSB7XG4ndXNlIHN0cmljdCc7XG52YXIgRGF0YVRhYmxlID0gJC5mbi5kYXRhVGFibGU7XG5cblxuXG52YXIgX2xpbmsgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdhJyk7XG5cbi8qKlxuICogQ2xvbmUgbGluayBhbmQgc3R5bGUgdGFncywgdGFraW5nIGludG8gYWNjb3VudCB0aGUgbmVlZCB0byBjaGFuZ2UgdGhlIHNvdXJjZVxuICogcGF0aC5cbiAqXG4gKiBAcGFyYW0gIHtub2RlfSAgICAgZWwgRWxlbWVudCB0byBjb252ZXJ0XG4gKi9cbnZhciBfc3R5bGVUb0FicyA9IGZ1bmN0aW9uIChlbCkge1xuXHR2YXIgY2xvbmUgPSAkKGVsKS5jbG9uZSgpWzBdO1xuXG5cdGlmIChjbG9uZS5ub2RlTmFtZS50b0xvd2VyQ2FzZSgpID09PSAnbGluaycpIHtcblx0XHRjbG9uZS5ocmVmID0gX3JlbFRvQWJzKGNsb25lLmhyZWYpO1xuXHR9XG5cblx0cmV0dXJuIGNsb25lLm91dGVySFRNTDtcbn07XG5cbi8qKlxuICogQ29udmVydCBhIFVSTCBmcm9tIGEgcmVsYXRpdmUgdG8gYW4gYWJzb2x1dGUgYWRkcmVzcyBzbyBpdCB3aWxsIHdvcmtcbiAqIGNvcnJlY3RseSBpbiB0aGUgcG9wdXAgd2luZG93IHdoaWNoIGhhcyBubyBiYXNlIFVSTC5cbiAqXG4gKiBAcGFyYW0gIHtzdHJpbmd9IGhyZWYgVVJMXG4gKi9cbnZhciBfcmVsVG9BYnMgPSBmdW5jdGlvbiAoaHJlZikge1xuXHQvLyBBc3NpZ24gdG8gYSBsaW5rIG9uIHRoZSBvcmlnaW5hbCBwYWdlIHNvIHRoZSBicm93c2VyIHdpbGwgZG8gYWxsIHRoZVxuXHQvLyBoYXJkIHdvcmsgb2YgZmlndXJpbmcgb3V0IHdoZXJlIHRoZSBmaWxlIGFjdHVhbGx5IGlzXG5cdF9saW5rLmhyZWYgPSBocmVmO1xuXHR2YXIgbGlua0hvc3QgPSBfbGluay5ob3N0O1xuXG5cdC8vIElFIGRvZXNuJ3QgaGF2ZSBhIHRyYWlsaW5nIHNsYXNoIG9uIHRoZSBob3N0XG5cdC8vIENocm9tZSBoYXMgaXQgb24gdGhlIHBhdGhuYW1lXG5cdGlmIChsaW5rSG9zdC5pbmRleE9mKCcvJykgPT09IC0xICYmIF9saW5rLnBhdGhuYW1lLmluZGV4T2YoJy8nKSAhPT0gMCkge1xuXHRcdGxpbmtIb3N0ICs9ICcvJztcblx0fVxuXG5cdHJldHVybiBfbGluay5wcm90b2NvbCArICcvLycgKyBsaW5rSG9zdCArIF9saW5rLnBhdGhuYW1lICsgX2xpbmsuc2VhcmNoO1xufTtcblxuRGF0YVRhYmxlLmV4dC5idXR0b25zLnByaW50ID0ge1xuXHRjbGFzc05hbWU6ICdidXR0b25zLXByaW50JyxcblxuXHR0ZXh0OiBmdW5jdGlvbiAoZHQpIHtcblx0XHRyZXR1cm4gZHQuaTE4bignYnV0dG9ucy5wcmludCcsICdQcmludCcpO1xuXHR9LFxuXG5cdGFjdGlvbjogZnVuY3Rpb24gKGUsIGR0LCBidXR0b24sIGNvbmZpZywgY2IpIHtcblx0XHR2YXIgZGF0YSA9IGR0LmJ1dHRvbnMuZXhwb3J0RGF0YShcblx0XHRcdCQuZXh0ZW5kKHsgZGVjb2RlRW50aXRpZXM6IGZhbHNlIH0sIGNvbmZpZy5leHBvcnRPcHRpb25zKSAvLyBYU1MgcHJvdGVjdGlvblxuXHRcdCk7XG5cdFx0dmFyIGV4cG9ydEluZm8gPSBkdC5idXR0b25zLmV4cG9ydEluZm8oY29uZmlnKTtcblxuXHRcdC8vIEdldCB0aGUgY2xhc3NlcyBmb3IgdGhlIGNvbHVtbnMgZnJvbSB0aGUgaGVhZGVyIGNlbGxzXG5cdFx0dmFyIGNvbHVtbkNsYXNzZXMgPSBkdFxuXHRcdFx0LmNvbHVtbnMoY29uZmlnLmV4cG9ydE9wdGlvbnMuY29sdW1ucylcblx0XHRcdC5ub2RlcygpXG5cdFx0XHQubWFwKGZ1bmN0aW9uIChuKSB7XG5cdFx0XHRcdHJldHVybiBuLmNsYXNzTmFtZTtcblx0XHRcdH0pXG5cdFx0XHQudG9BcnJheSgpO1xuXG5cdFx0dmFyIGFkZFJvdyA9IGZ1bmN0aW9uIChkLCB0YWcpIHtcblx0XHRcdHZhciBzdHIgPSAnPHRyPic7XG5cblx0XHRcdGZvciAodmFyIGkgPSAwLCBpZW4gPSBkLmxlbmd0aDsgaSA8IGllbjsgaSsrKSB7XG5cdFx0XHRcdC8vIG51bGwgYW5kIHVuZGVmaW5lZCBhcmVuJ3QgdXNlZnVsIGluIHRoZSBwcmludCBvdXRwdXRcblx0XHRcdFx0dmFyIGRhdGFPdXQgPSBkW2ldID09PSBudWxsIHx8IGRbaV0gPT09IHVuZGVmaW5lZCA/ICcnIDogZFtpXTtcblx0XHRcdFx0dmFyIGNsYXNzQXR0ciA9IGNvbHVtbkNsYXNzZXNbaV1cblx0XHRcdFx0XHQ/ICdjbGFzcz1cIicgKyBjb2x1bW5DbGFzc2VzW2ldICsgJ1wiJ1xuXHRcdFx0XHRcdDogJyc7XG5cblx0XHRcdFx0c3RyICs9XG5cdFx0XHRcdFx0JzwnICtcblx0XHRcdFx0XHR0YWcgK1xuXHRcdFx0XHRcdCcgJyArXG5cdFx0XHRcdFx0Y2xhc3NBdHRyICtcblx0XHRcdFx0XHQnPicgK1xuXHRcdFx0XHRcdGRhdGFPdXQgK1xuXHRcdFx0XHRcdCc8LycgK1xuXHRcdFx0XHRcdHRhZyArXG5cdFx0XHRcdFx0Jz4nO1xuXHRcdFx0fVxuXG5cdFx0XHRyZXR1cm4gc3RyICsgJzwvdHI+Jztcblx0XHR9O1xuXG5cdFx0Ly8gQ29uc3RydWN0IGEgdGFibGUgZm9yIHByaW50aW5nXG5cdFx0dmFyIGh0bWwgPSAnPHRhYmxlIGNsYXNzPVwiJyArIGR0LnRhYmxlKCkubm9kZSgpLmNsYXNzTmFtZSArICdcIj4nO1xuXG5cdFx0aWYgKGNvbmZpZy5oZWFkZXIpIHtcblx0XHRcdHZhciBoZWFkZXJSb3dzID0gZGF0YS5oZWFkZXJTdHJ1Y3R1cmUubWFwKGZ1bmN0aW9uIChyb3cpIHtcblx0XHRcdFx0cmV0dXJuIChcblx0XHRcdFx0XHQnPHRyPicgK1xuXHRcdFx0XHRcdHJvd1xuXHRcdFx0XHRcdFx0Lm1hcChmdW5jdGlvbiAoY2VsbCkge1xuXHRcdFx0XHRcdFx0XHRyZXR1cm4gY2VsbFxuXHRcdFx0XHRcdFx0XHRcdD8gJzx0aCBjb2xzcGFuPVwiJyArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGNlbGwuY29sc3BhbiArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCdcIiByb3dzcGFuPVwiJyArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGNlbGwucm93c3BhbiArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCdcIj4nICtcblx0XHRcdFx0XHRcdFx0XHRcdFx0Y2VsbC50aXRsZSArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCc8L3RoPidcblx0XHRcdFx0XHRcdFx0XHQ6ICcnO1xuXHRcdFx0XHRcdFx0fSlcblx0XHRcdFx0XHRcdC5qb2luKCcnKSArXG5cdFx0XHRcdFx0JzwvdHI+J1xuXHRcdFx0XHQpO1xuXHRcdFx0fSk7XG5cblx0XHRcdGh0bWwgKz0gJzx0aGVhZD4nICsgaGVhZGVyUm93cy5qb2luKCcnKSArICc8L3RoZWFkPic7XG5cdFx0fVxuXG5cdFx0aHRtbCArPSAnPHRib2R5Pic7XG5cdFx0Zm9yICh2YXIgaSA9IDAsIGllbiA9IGRhdGEuYm9keS5sZW5ndGg7IGkgPCBpZW47IGkrKykge1xuXHRcdFx0aHRtbCArPSBhZGRSb3coZGF0YS5ib2R5W2ldLCAndGQnKTtcblx0XHR9XG5cdFx0aHRtbCArPSAnPC90Ym9keT4nO1xuXG5cdFx0aWYgKGNvbmZpZy5mb290ZXIgJiYgZGF0YS5mb290ZXIpIHtcblx0XHRcdHZhciBmb290ZXJSb3dzID0gZGF0YS5mb290ZXJTdHJ1Y3R1cmUubWFwKGZ1bmN0aW9uIChyb3cpIHtcblx0XHRcdFx0cmV0dXJuIChcblx0XHRcdFx0XHQnPHRyPicgK1xuXHRcdFx0XHRcdHJvd1xuXHRcdFx0XHRcdFx0Lm1hcChmdW5jdGlvbiAoY2VsbCkge1xuXHRcdFx0XHRcdFx0XHRyZXR1cm4gY2VsbFxuXHRcdFx0XHRcdFx0XHRcdD8gJzx0aCBjb2xzcGFuPVwiJyArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGNlbGwuY29sc3BhbiArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCdcIiByb3dzcGFuPVwiJyArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGNlbGwucm93c3BhbiArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCdcIj4nICtcblx0XHRcdFx0XHRcdFx0XHRcdFx0Y2VsbC50aXRsZSArXG5cdFx0XHRcdFx0XHRcdFx0XHRcdCc8L3RoPidcblx0XHRcdFx0XHRcdFx0XHQ6ICcnO1xuXHRcdFx0XHRcdFx0fSlcblx0XHRcdFx0XHRcdC5qb2luKCcnKSArXG5cdFx0XHRcdFx0JzwvdHI+J1xuXHRcdFx0XHQpO1xuXHRcdFx0fSk7XG5cblx0XHRcdGh0bWwgKz0gJzx0Zm9vdD4nICsgZm9vdGVyUm93cy5qb2luKCcnKSArICc8L3Rmb290Pic7XG5cdFx0fVxuXHRcdGh0bWwgKz0gJzwvdGFibGU+JztcblxuXHRcdC8vIE9wZW4gYSBuZXcgd2luZG93IGZvciB0aGUgcHJpbnRhYmxlIHRhYmxlXG5cdFx0dmFyIHdpbiA9IHdpbmRvdy5vcGVuKCcnLCAnJyk7XG5cblx0XHRpZiAoIXdpbikge1xuXHRcdFx0ZHQuYnV0dG9ucy5pbmZvKFxuXHRcdFx0XHRkdC5pMThuKCdidXR0b25zLnByaW50RXJyb3JUaXRsZScsICdVbmFibGUgdG8gb3BlbiBwcmludCB2aWV3JyksXG5cdFx0XHRcdGR0LmkxOG4oXG5cdFx0XHRcdFx0J2J1dHRvbnMucHJpbnRFcnJvck1zZycsXG5cdFx0XHRcdFx0J1BsZWFzZSBhbGxvdyBwb3B1cHMgaW4geW91ciBicm93c2VyIGZvciB0aGlzIHNpdGUgdG8gYmUgYWJsZSB0byB2aWV3IHRoZSBwcmludCB2aWV3Lidcblx0XHRcdFx0KSxcblx0XHRcdFx0NTAwMFxuXHRcdFx0KTtcblxuXHRcdFx0cmV0dXJuO1xuXHRcdH1cblxuXHRcdHdpbi5kb2N1bWVudC5jbG9zZSgpO1xuXG5cdFx0Ly8gSW5qZWN0IHRoZSB0aXRsZSBhbmQgYWxzbyBhIGNvcHkgb2YgdGhlIHN0eWxlIGFuZCBsaW5rIHRhZ3MgZnJvbSB0aGlzXG5cdFx0Ly8gZG9jdW1lbnQgc28gdGhlIHRhYmxlIGNhbiByZXRhaW4gaXRzIGJhc2Ugc3R5bGluZy4gTm90ZSB0aGF0IHdlIGhhdmVcblx0XHQvLyB0byB1c2Ugc3RyaW5nIG1hbmlwdWxhdGlvbiBhcyBJRSB3b24ndCBhbGxvdyBlbGVtZW50cyB0byBiZSBjcmVhdGVkXG5cdFx0Ly8gaW4gdGhlIGhvc3QgZG9jdW1lbnQgYW5kIHRoZW4gYXBwZW5kZWQgdG8gdGhlIG5ldyB3aW5kb3cuXG5cdFx0dmFyIGhlYWQgPSAnPHRpdGxlPicgKyBleHBvcnRJbmZvLnRpdGxlICsgJzwvdGl0bGU+Jztcblx0XHQkKCdzdHlsZSwgbGluaycpLmVhY2goZnVuY3Rpb24gKCkge1xuXHRcdFx0aGVhZCArPSBfc3R5bGVUb0Ficyh0aGlzKTtcblx0XHR9KTtcblxuXHRcdHRyeSB7XG5cdFx0XHR3aW4uZG9jdW1lbnQuaGVhZC5pbm5lckhUTUwgPSBoZWFkOyAvLyBXb3JrIGFyb3VuZCBmb3IgRWRnZVxuXHRcdH0gY2F0Y2ggKGUpIHtcblx0XHRcdCQod2luLmRvY3VtZW50LmhlYWQpLmh0bWwoaGVhZCk7IC8vIE9sZCBJRVxuXHRcdH1cblxuXHRcdC8vIEluamVjdCB0aGUgdGFibGUgYW5kIG90aGVyIHN1cnJvdW5kaW5nIGluZm9ybWF0aW9uXG5cdFx0d2luLmRvY3VtZW50LmJvZHkuaW5uZXJIVE1MID1cblx0XHRcdCc8aDE+JyArXG5cdFx0XHRleHBvcnRJbmZvLnRpdGxlICtcblx0XHRcdCc8L2gxPicgK1xuXHRcdFx0JzxkaXY+JyArXG5cdFx0XHQoZXhwb3J0SW5mby5tZXNzYWdlVG9wIHx8ICcnKSArXG5cdFx0XHQnPC9kaXY+JyArXG5cdFx0XHRodG1sICtcblx0XHRcdCc8ZGl2PicgK1xuXHRcdFx0KGV4cG9ydEluZm8ubWVzc2FnZUJvdHRvbSB8fCAnJykgK1xuXHRcdFx0JzwvZGl2Pic7XG5cblx0XHQkKHdpbi5kb2N1bWVudC5ib2R5KS5hZGRDbGFzcygnZHQtcHJpbnQtdmlldycpO1xuXG5cdFx0JCgnaW1nJywgd2luLmRvY3VtZW50LmJvZHkpLmVhY2goZnVuY3Rpb24gKGksIGltZykge1xuXHRcdFx0aW1nLnNldEF0dHJpYnV0ZSgnc3JjJywgX3JlbFRvQWJzKGltZy5nZXRBdHRyaWJ1dGUoJ3NyYycpKSk7XG5cdFx0fSk7XG5cblx0XHRpZiAoY29uZmlnLmN1c3RvbWl6ZSkge1xuXHRcdFx0Y29uZmlnLmN1c3RvbWl6ZSh3aW4sIGNvbmZpZywgZHQpO1xuXHRcdH1cblxuXHRcdC8vIEFsbG93IHN0eWxlc2hlZXRzIHRpbWUgdG8gbG9hZFxuXHRcdHZhciBhdXRvUHJpbnQgPSBmdW5jdGlvbiAoKSB7XG5cdFx0XHRpZiAoY29uZmlnLmF1dG9QcmludCkge1xuXHRcdFx0XHR3aW4ucHJpbnQoKTsgLy8gYmxvY2tpbmcgLSBzbyBjbG9zZSB3aWxsIG5vdFxuXHRcdFx0XHR3aW4uY2xvc2UoKTsgLy8gZXhlY3V0ZSB1bnRpbCB0aGlzIGlzIGRvbmVcblx0XHRcdH1cblx0XHR9O1xuXG5cdFx0d2luLnNldFRpbWVvdXQoYXV0b1ByaW50LCAxMDAwKTtcblxuXHRcdGNiKCk7XG5cdH0sXG5cblx0YXN5bmM6IDEwMCxcblxuXHR0aXRsZTogJyonLFxuXG5cdG1lc3NhZ2VUb3A6ICcqJyxcblxuXHRtZXNzYWdlQm90dG9tOiAnKicsXG5cblx0ZXhwb3J0T3B0aW9uczoge30sXG5cblx0aGVhZGVyOiB0cnVlLFxuXG5cdGZvb3RlcjogdHJ1ZSxcblxuXHRhdXRvUHJpbnQ6IHRydWUsXG5cblx0Y3VzdG9taXplOiBudWxsXG59O1xuXG5cbnJldHVybiBEYXRhVGFibGU7XG59KSk7XG4iLCIvKiEgU2VsZWN0IGZvciBEYXRhVGFibGVzIDIuMC4wXG4gKiDCqSBTcHJ5TWVkaWEgTHRkIC0gZGF0YXRhYmxlcy5uZXQvbGljZW5zZS9taXRcbiAqL1xuXG5pbXBvcnQgalF1ZXJ5IGZyb20gJ2pxdWVyeSc7XG5pbXBvcnQgRGF0YVRhYmxlIGZyb20gJ2RhdGF0YWJsZXMubmV0JztcblxuLy8gQWxsb3cgcmVhc3NpZ25tZW50IG9mIHRoZSAkIHZhcmlhYmxlXG5sZXQgJCA9IGpRdWVyeTtcblxuXG4vLyBWZXJzaW9uIGluZm9ybWF0aW9uIGZvciBkZWJ1Z2dlclxuRGF0YVRhYmxlLnNlbGVjdCA9IHt9O1xuXG5EYXRhVGFibGUuc2VsZWN0LnZlcnNpb24gPSAnMi4wLjAnO1xuXG5EYXRhVGFibGUuc2VsZWN0LmluaXQgPSBmdW5jdGlvbiAoZHQpIHtcblx0dmFyIGN0eCA9IGR0LnNldHRpbmdzKClbMF07XG5cblx0aWYgKCFEYXRhVGFibGUudmVyc2lvbkNoZWNrKCcyJykpIHtcblx0XHR0aHJvdyAnV2FybmluZzogU2VsZWN0IHJlcXVpcmVzIERhdGFUYWJsZXMgMiBvciBuZXdlcic7XG5cdH1cblxuXHRpZiAoY3R4Ll9zZWxlY3QpIHtcblx0XHRyZXR1cm47XG5cdH1cblxuXHR2YXIgc2F2ZWRTZWxlY3RlZCA9IGR0LnN0YXRlLmxvYWRlZCgpO1xuXG5cdHZhciBzZWxlY3RBbmRTYXZlID0gZnVuY3Rpb24gKGUsIHNldHRpbmdzLCBkYXRhKSB7XG5cdFx0aWYgKGRhdGEgPT09IG51bGwgfHwgZGF0YS5zZWxlY3QgPT09IHVuZGVmaW5lZCkge1xuXHRcdFx0cmV0dXJuO1xuXHRcdH1cblxuXHRcdC8vIENsZWFyIGFueSBjdXJyZW50bHkgc2VsZWN0ZWQgcm93cywgYmVmb3JlIHJlc3RvcmluZyBzdGF0ZVxuXHRcdC8vIE5vbmUgd2lsbCBiZSBzZWxlY3RlZCBvbiBmaXJzdCBpbml0aWFsaXNhdGlvblxuXHRcdGlmIChkdC5yb3dzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuYW55KCkpIHtcblx0XHRcdGR0LnJvd3MoKS5kZXNlbGVjdCgpO1xuXHRcdH1cblx0XHRpZiAoZGF0YS5zZWxlY3Qucm93cyAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRkdC5yb3dzKGRhdGEuc2VsZWN0LnJvd3MpLnNlbGVjdCgpO1xuXHRcdH1cblxuXHRcdGlmIChkdC5jb2x1bW5zKHsgc2VsZWN0ZWQ6IHRydWUgfSkuYW55KCkpIHtcblx0XHRcdGR0LmNvbHVtbnMoKS5kZXNlbGVjdCgpO1xuXHRcdH1cblx0XHRpZiAoZGF0YS5zZWxlY3QuY29sdW1ucyAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRkdC5jb2x1bW5zKGRhdGEuc2VsZWN0LmNvbHVtbnMpLnNlbGVjdCgpO1xuXHRcdH1cblxuXHRcdGlmIChkdC5jZWxscyh7IHNlbGVjdGVkOiB0cnVlIH0pLmFueSgpKSB7XG5cdFx0XHRkdC5jZWxscygpLmRlc2VsZWN0KCk7XG5cdFx0fVxuXHRcdGlmIChkYXRhLnNlbGVjdC5jZWxscyAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRmb3IgKHZhciBpID0gMDsgaSA8IGRhdGEuc2VsZWN0LmNlbGxzLmxlbmd0aDsgaSsrKSB7XG5cdFx0XHRcdGR0LmNlbGwoZGF0YS5zZWxlY3QuY2VsbHNbaV0ucm93LCBkYXRhLnNlbGVjdC5jZWxsc1tpXS5jb2x1bW4pLnNlbGVjdCgpO1xuXHRcdFx0fVxuXHRcdH1cblxuXHRcdGR0LnN0YXRlLnNhdmUoKTtcblx0fTtcblxuXHRkdC5vbignc3RhdGVTYXZlUGFyYW1zJywgZnVuY3Rpb24gKGUsIHNldHRpbmdzLCBkYXRhKSB7XG5cdFx0ZGF0YS5zZWxlY3QgPSB7fTtcblx0XHRkYXRhLnNlbGVjdC5yb3dzID0gZHQucm93cyh7IHNlbGVjdGVkOiB0cnVlIH0pLmlkcyh0cnVlKS50b0FycmF5KCk7XG5cdFx0ZGF0YS5zZWxlY3QuY29sdW1ucyA9IGR0LmNvbHVtbnMoeyBzZWxlY3RlZDogdHJ1ZSB9KVswXTtcblx0XHRkYXRhLnNlbGVjdC5jZWxscyA9IGR0LmNlbGxzKHsgc2VsZWN0ZWQ6IHRydWUgfSlbMF0ubWFwKGZ1bmN0aW9uIChjb29yZHMpIHtcblx0XHRcdHJldHVybiB7IHJvdzogZHQucm93KGNvb3Jkcy5yb3cpLmlkKHRydWUpLCBjb2x1bW46IGNvb3Jkcy5jb2x1bW4gfTtcblx0XHR9KTtcblx0fSlcblx0XHQub24oJ3N0YXRlTG9hZFBhcmFtcycsIHNlbGVjdEFuZFNhdmUpXG5cdFx0Lm9uZSgnaW5pdCcsIGZ1bmN0aW9uICgpIHtcblx0XHRcdHNlbGVjdEFuZFNhdmUodW5kZWZpbmVkLCB1bmRlZmluZWQsIHNhdmVkU2VsZWN0ZWQpO1xuXHRcdH0pO1xuXG5cdHZhciBpbml0ID0gY3R4Lm9Jbml0LnNlbGVjdDtcblx0dmFyIGRlZmF1bHRzID0gRGF0YVRhYmxlLmRlZmF1bHRzLnNlbGVjdDtcblx0dmFyIG9wdHMgPSBpbml0ID09PSB1bmRlZmluZWQgPyBkZWZhdWx0cyA6IGluaXQ7XG5cblx0Ly8gU2V0IGRlZmF1bHRzXG5cdHZhciBpdGVtcyA9ICdyb3cnO1xuXHR2YXIgc3R5bGUgPSAnYXBpJztcblx0dmFyIGJsdXJhYmxlID0gZmFsc2U7XG5cdHZhciB0b2dnbGVhYmxlID0gdHJ1ZTtcblx0dmFyIGluZm8gPSB0cnVlO1xuXHR2YXIgc2VsZWN0b3IgPSAndGQsIHRoJztcblx0dmFyIGNsYXNzTmFtZSA9ICdzZWxlY3RlZCc7XG5cdHZhciBoZWFkZXJDaGVja2JveCA9IHRydWU7XG5cdHZhciBzZXRTdHlsZSA9IGZhbHNlO1xuXG5cdGN0eC5fc2VsZWN0ID0ge1xuXHRcdGluZm9FbHM6IFtdXG5cdH07XG5cblx0Ly8gSW5pdGlhbGlzYXRpb24gY3VzdG9taXNhdGlvbnNcblx0aWYgKG9wdHMgPT09IHRydWUpIHtcblx0XHRzdHlsZSA9ICdvcyc7XG5cdFx0c2V0U3R5bGUgPSB0cnVlO1xuXHR9XG5cdGVsc2UgaWYgKHR5cGVvZiBvcHRzID09PSAnc3RyaW5nJykge1xuXHRcdHN0eWxlID0gb3B0cztcblx0XHRzZXRTdHlsZSA9IHRydWU7XG5cdH1cblx0ZWxzZSBpZiAoJC5pc1BsYWluT2JqZWN0KG9wdHMpKSB7XG5cdFx0aWYgKG9wdHMuYmx1cmFibGUgIT09IHVuZGVmaW5lZCkge1xuXHRcdFx0Ymx1cmFibGUgPSBvcHRzLmJsdXJhYmxlO1xuXHRcdH1cblxuXHRcdGlmIChvcHRzLnRvZ2dsZWFibGUgIT09IHVuZGVmaW5lZCkge1xuXHRcdFx0dG9nZ2xlYWJsZSA9IG9wdHMudG9nZ2xlYWJsZTtcblx0XHR9XG5cblx0XHRpZiAob3B0cy5pbmZvICE9PSB1bmRlZmluZWQpIHtcblx0XHRcdGluZm8gPSBvcHRzLmluZm87XG5cdFx0fVxuXG5cdFx0aWYgKG9wdHMuaXRlbXMgIT09IHVuZGVmaW5lZCkge1xuXHRcdFx0aXRlbXMgPSBvcHRzLml0ZW1zO1xuXHRcdH1cblxuXHRcdGlmIChvcHRzLnN0eWxlICE9PSB1bmRlZmluZWQpIHtcblx0XHRcdHN0eWxlID0gb3B0cy5zdHlsZTtcblx0XHRcdHNldFN0eWxlID0gdHJ1ZTtcblx0XHR9XG5cdFx0ZWxzZSB7XG5cdFx0XHRzdHlsZSA9ICdvcyc7XG5cdFx0XHRzZXRTdHlsZSA9IHRydWU7XG5cdFx0fVxuXG5cdFx0aWYgKG9wdHMuc2VsZWN0b3IgIT09IHVuZGVmaW5lZCkge1xuXHRcdFx0c2VsZWN0b3IgPSBvcHRzLnNlbGVjdG9yO1xuXHRcdH1cblxuXHRcdGlmIChvcHRzLmNsYXNzTmFtZSAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRjbGFzc05hbWUgPSBvcHRzLmNsYXNzTmFtZTtcblx0XHR9XG5cblx0XHRpZiAob3B0cy5oZWFkZXJDaGVja2JveCAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRoZWFkZXJDaGVja2JveCA9IG9wdHMuaGVhZGVyQ2hlY2tib3g7XG5cdFx0fVxuXHR9XG5cblx0ZHQuc2VsZWN0LnNlbGVjdG9yKHNlbGVjdG9yKTtcblx0ZHQuc2VsZWN0Lml0ZW1zKGl0ZW1zKTtcblx0ZHQuc2VsZWN0LnN0eWxlKHN0eWxlKTtcblx0ZHQuc2VsZWN0LmJsdXJhYmxlKGJsdXJhYmxlKTtcblx0ZHQuc2VsZWN0LnRvZ2dsZWFibGUodG9nZ2xlYWJsZSk7XG5cdGR0LnNlbGVjdC5pbmZvKGluZm8pO1xuXHRjdHguX3NlbGVjdC5jbGFzc05hbWUgPSBjbGFzc05hbWU7XG5cblx0Ly8gSWYgdGhlIGluaXQgb3B0aW9ucyBoYXZlbid0IGVuYWJsZWQgc2VsZWN0LCBidXQgdGhlcmUgaXMgYSBzZWxlY3RhYmxlXG5cdC8vIGNsYXNzIG5hbWUsIHRoZW4gZW5hYmxlXG5cdGlmICghc2V0U3R5bGUgJiYgJChkdC50YWJsZSgpLm5vZGUoKSkuaGFzQ2xhc3MoJ3NlbGVjdGFibGUnKSkge1xuXHRcdGR0LnNlbGVjdC5zdHlsZSgnb3MnKTtcblx0fVxuXG5cdC8vIEluc2VydCBhIGNoZWNrYm94IGludG8gdGhlIGhlYWRlciBpZiBuZWVkZWQgLSBtaWdodCBuZWVkIHRvIHdhaXRcblx0Ly8gZm9yIGluaXQgY29tcGxldGUsIG9yIGl0IG1pZ2h0IGFscmVhZHkgYmUgZG9uZVxuXHRpZiAoaGVhZGVyQ2hlY2tib3gpIHtcblx0XHRpbml0Q2hlY2tib3hIZWFkZXIoZHQpO1xuXG5cdFx0ZHQub24oJ2luaXQnLCBmdW5jdGlvbiAoKSB7XG5cdFx0XHRpbml0Q2hlY2tib3hIZWFkZXIoZHQpO1xuXHRcdH0pO1xuXHR9XG59O1xuXG4vKlxuXG5TZWxlY3QgaXMgYSBjb2xsZWN0aW9uIG9mIEFQSSBtZXRob2RzLCBldmVudCBoYW5kbGVycywgZXZlbnQgZW1pdHRlcnMgYW5kXG5idXR0b25zIChmb3IgdGhlIGBCdXR0b25zYCBleHRlbnNpb24pIGZvciBEYXRhVGFibGVzLiBJdCBwcm92aWRlcyB0aGUgZm9sbG93aW5nXG5mZWF0dXJlcywgd2l0aCBhbiBvdmVydmlldyBvZiBob3cgdGhleSBhcmUgaW1wbGVtZW50ZWQ6XG5cbiMjIFNlbGVjdGlvbiBvZiByb3dzLCBjb2x1bW5zIGFuZCBjZWxscy4gV2hldGhlciBhbiBpdGVtIGlzIHNlbGVjdGVkIG9yIG5vdCBpc1xuICAgc3RvcmVkIGluOlxuXG4qIHJvd3M6IGEgYF9zZWxlY3Rfc2VsZWN0ZWRgIHByb3BlcnR5IHdoaWNoIGNvbnRhaW5zIGEgYm9vbGVhbiB2YWx1ZSBvZiB0aGVcbiAgRGF0YVRhYmxlcycgYGFvRGF0YWAgb2JqZWN0IGZvciBlYWNoIHJvd1xuKiBjb2x1bW5zOiBhIGBfc2VsZWN0X3NlbGVjdGVkYCBwcm9wZXJ0eSB3aGljaCBjb250YWlucyBhIGJvb2xlYW4gdmFsdWUgb2YgdGhlXG4gIERhdGFUYWJsZXMnIGBhb0NvbHVtbnNgIG9iamVjdCBmb3IgZWFjaCBjb2x1bW5cbiogY2VsbHM6IGEgYF9zZWxlY3RlZF9jZWxsc2AgcHJvcGVydHkgd2hpY2ggY29udGFpbnMgYW4gYXJyYXkgb2YgYm9vbGVhbiB2YWx1ZXNcbiAgb2YgdGhlIGBhb0RhdGFgIG9iamVjdCBmb3IgZWFjaCByb3cuIFRoZSBhcnJheSBpcyB0aGUgc2FtZSBsZW5ndGggYXMgdGhlXG4gIGNvbHVtbnMgYXJyYXksIHdpdGggZWFjaCBlbGVtZW50IG9mIGl0IHJlcHJlc2VudGluZyBhIGNlbGwuXG5cblRoaXMgbWV0aG9kIG9mIHVzaW5nIGJvb2xlYW4gZmxhZ3MgYWxsb3dzIFNlbGVjdCB0byBvcGVyYXRlIHdoZW4gbm9kZXMgaGF2ZSBub3RcbmJlZW4gY3JlYXRlZCBmb3Igcm93cyAvIGNlbGxzIChEYXRhVGFibGVzJyBkZWZlciByZW5kZXJpbmcgZmVhdHVyZSkuXG5cbiMjIEFQSSBtZXRob2RzXG5cbkEgcmFuZ2Ugb2YgQVBJIG1ldGhvZHMgYXJlIGF2YWlsYWJsZSBmb3IgdHJpZ2dlcmluZyBzZWxlY3Rpb24gYW5kIGRlLXNlbGVjdGlvblxub2Ygcm93cy4gTWV0aG9kcyBhcmUgYWxzbyBhdmFpbGFibGUgdG8gY29uZmlndXJlIHRoZSBzZWxlY3Rpb24gZXZlbnRzIHRoYXQgY2FuXG5iZSB0cmlnZ2VyZWQgYnkgYW4gZW5kIHVzZXIgKHN1Y2ggYXMgd2hpY2ggaXRlbXMgYXJlIHRvIGJlIHNlbGVjdGVkKS4gVG8gYSBsYXJnZVxuZXh0ZW50LCB0aGVzZSBvZiBBUEkgbWV0aG9kcyAqaXMqIFNlbGVjdC4gSXQgaXMgYmFzaWNhbGx5IGEgY29sbGVjdGlvbiBvZiBoZWxwZXJcbmZ1bmN0aW9ucyB0aGF0IGNhbiBiZSB1c2VkIHRvIHNlbGVjdCBpdGVtcyBpbiBhIERhdGFUYWJsZS5cblxuQ29uZmlndXJhdGlvbiBvZiBzZWxlY3QgaXMgaGVsZCBpbiB0aGUgb2JqZWN0IGBfc2VsZWN0YCB3aGljaCBpcyBhdHRhY2hlZCB0byB0aGVcbkRhdGFUYWJsZXMgc2V0dGluZ3Mgb2JqZWN0IG9uIGluaXRpYWxpc2F0aW9uLiBTZWxlY3QgYmVpbmcgYXZhaWxhYmxlIG9uIGEgdGFibGVcbmlzIG5vdCBvcHRpb25hbCB3aGVuIFNlbGVjdCBpcyBsb2FkZWQsIGJ1dCBpdHMgZGVmYXVsdCBpcyBmb3Igc2VsZWN0aW9uIG9ubHkgdG9cbmJlIGF2YWlsYWJsZSB2aWEgdGhlIEFQSSAtIHNvIHRoZSBlbmQgdXNlciB3b3VsZG4ndCBiZSBhYmxlIHRvIHNlbGVjdCByb3dzXG53aXRob3V0IGFkZGl0aW9uYWwgY29uZmlndXJhdGlvbi5cblxuVGhlIGBfc2VsZWN0YCBvYmplY3QgY29udGFpbnMgdGhlIGZvbGxvd2luZyBwcm9wZXJ0aWVzOlxuXG5gYGBcbntcblx0aXRlbXM6c3RyaW5nICAgICAgIC0gQ2FuIGJlIGByb3dzYCwgYGNvbHVtbnNgIG9yIGBjZWxsc2AuIERlZmluZXMgd2hhdCBpdGVtIFxuXHQgICAgICAgICAgICAgICAgICAgICB3aWxsIGJlIHNlbGVjdGVkIGlmIHRoZSB1c2VyIGlzIGFsbG93ZWQgdG8gYWN0aXZhdGUgcm93XG5cdCAgICAgICAgICAgICAgICAgICAgIHNlbGVjdGlvbiB1c2luZyB0aGUgbW91c2UuXG5cdHN0eWxlOnN0cmluZyAgICAgICAtIENhbiBiZSBgbm9uZWAsIGBzaW5nbGVgLCBgbXVsdGlgIG9yIGBvc2AuIERlZmluZXMgdGhlXG5cdCAgICAgICAgICAgICAgICAgICAgIGludGVyYWN0aW9uIHN0eWxlIHdoZW4gc2VsZWN0aW5nIGl0ZW1zXG5cdGJsdXJhYmxlOmJvb2xlYW4gICAtIElmIHJvdyBzZWxlY3Rpb24gY2FuIGJlIGNsZWFyZWQgYnkgY2xpY2tpbmcgb3V0c2lkZSBvZlxuXHQgICAgICAgICAgICAgICAgICAgICB0aGUgdGFibGVcblx0dG9nZ2xlYWJsZTpib29sZWFuIC0gSWYgcm93IHNlbGVjdGlvbiBjYW4gYmUgY2FuY2VsbGVkIGJ5IHJlcGVhdGVkIGNsaWNraW5nXG5cdCAgICAgICAgICAgICAgICAgICAgIG9uIHRoZSByb3dcblx0aW5mbzpib29sZWFuICAgICAgIC0gSWYgdGhlIHNlbGVjdGlvbiBzdW1tYXJ5IHNob3VsZCBiZSBzaG93biBpbiB0aGUgdGFibGVcblx0ICAgICAgICAgICAgICAgICAgICAgaW5mb3JtYXRpb24gZWxlbWVudHNcblx0aW5mb0VsczplbGVtZW50W10gIC0gTGlzdCBvZiBIVE1MIGVsZW1lbnRzIHdpdGggaW5mbyBlbGVtZW50cyBmb3IgYSB0YWJsZVxufVxuYGBgXG5cbkluIGFkZGl0aW9uIHRvIHRoZSBBUEkgbWV0aG9kcywgU2VsZWN0IGFsc28gZXh0ZW5kcyB0aGUgRGF0YVRhYmxlcyBzZWxlY3Rvclxub3B0aW9ucyBmb3Igcm93cywgY29sdW1ucyBhbmQgY2VsbHMgYWRkaW5nIGEgYHNlbGVjdGVkYCBvcHRpb24gdG8gdGhlIHNlbGVjdG9yXG5vcHRpb25zIG9iamVjdCwgYWxsb3dpbmcgdGhlIGRldmVsb3BlciB0byBzZWxlY3Qgb25seSBzZWxlY3RlZCBpdGVtcyBvclxudW5zZWxlY3RlZCBpdGVtcy5cblxuIyMgTW91c2Ugc2VsZWN0aW9uIG9mIGl0ZW1zXG5cbkNsaWNraW5nIG9uIGl0ZW1zIGNhbiBiZSB1c2VkIHRvIHNlbGVjdCBpdGVtcy4gVGhpcyBpcyBkb25lIGJ5IGEgc2ltcGxlIGV2ZW50XG5oYW5kbGVyIHRoYXQgd2lsbCBzZWxlY3QgdGhlIGl0ZW1zIHVzaW5nIHRoZSBBUEkgbWV0aG9kcy5cblxuICovXG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqXG4gKiBMb2NhbCBmdW5jdGlvbnNcbiAqL1xuXG4vKipcbiAqIEFkZCBvbmUgb3IgbW9yZSBjZWxscyB0byB0aGUgc2VsZWN0aW9uIHdoZW4gc2hpZnQgY2xpY2tpbmcgaW4gT1Mgc2VsZWN0aW9uXG4gKiBzdHlsZSBjZWxsIHNlbGVjdGlvbi5cbiAqXG4gKiBDZWxsIHJhbmdlIGlzIG1vcmUgY29tcGxpY2F0ZWQgdGhhbiByb3cgYW5kIGNvbHVtbiBhcyB3ZSB3YW50IHRvIHNlbGVjdFxuICogaW4gdGhlIHZpc2libGUgZ3JpZCByYXRoZXIgdGhhbiBieSBpbmRleCBpbiBzZXF1ZW5jZS4gRm9yIGV4YW1wbGUsIGlmIHlvdVxuICogY2xpY2sgZmlyc3QgaW4gY2VsbCAxLTEgYW5kIHRoZW4gc2hpZnQgY2xpY2sgaW4gMi0yIC0gY2VsbHMgMS0yIGFuZCAyLTFcbiAqIHNob3VsZCBhbHNvIGJlIHNlbGVjdGVkIChhbmQgbm90IDEtMywgMS00LiBldGMpXG4gKlxuICogQHBhcmFtICB7RGF0YVRhYmxlLkFwaX0gZHQgICBEYXRhVGFibGVcbiAqIEBwYXJhbSAge29iamVjdH0gICAgICAgIGlkeCAgQ2VsbCBpbmRleCB0byBzZWxlY3QgdG9cbiAqIEBwYXJhbSAge29iamVjdH0gICAgICAgIGxhc3QgQ2VsbCBpbmRleCB0byBzZWxlY3QgZnJvbVxuICogQHByaXZhdGVcbiAqL1xuZnVuY3Rpb24gY2VsbFJhbmdlKGR0LCBpZHgsIGxhc3QpIHtcblx0dmFyIGluZGV4ZXM7XG5cdHZhciBjb2x1bW5JbmRleGVzO1xuXHR2YXIgcm93SW5kZXhlcztcblx0dmFyIHNlbGVjdENvbHVtbnMgPSBmdW5jdGlvbiAoc3RhcnQsIGVuZCkge1xuXHRcdGlmIChzdGFydCA+IGVuZCkge1xuXHRcdFx0dmFyIHRtcCA9IGVuZDtcblx0XHRcdGVuZCA9IHN0YXJ0O1xuXHRcdFx0c3RhcnQgPSB0bXA7XG5cdFx0fVxuXG5cdFx0dmFyIHJlY29yZCA9IGZhbHNlO1xuXHRcdHJldHVybiBkdFxuXHRcdFx0LmNvbHVtbnMoJzp2aXNpYmxlJylcblx0XHRcdC5pbmRleGVzKClcblx0XHRcdC5maWx0ZXIoZnVuY3Rpb24gKGkpIHtcblx0XHRcdFx0aWYgKGkgPT09IHN0YXJ0KSB7XG5cdFx0XHRcdFx0cmVjb3JkID0gdHJ1ZTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdGlmIChpID09PSBlbmQpIHtcblx0XHRcdFx0XHQvLyBub3QgZWxzZSBpZiwgYXMgc3RhcnQgbWlnaHQgPT09IGVuZFxuXHRcdFx0XHRcdHJlY29yZCA9IGZhbHNlO1xuXHRcdFx0XHRcdHJldHVybiB0cnVlO1xuXHRcdFx0XHR9XG5cblx0XHRcdFx0cmV0dXJuIHJlY29yZDtcblx0XHRcdH0pO1xuXHR9O1xuXG5cdHZhciBzZWxlY3RSb3dzID0gZnVuY3Rpb24gKHN0YXJ0LCBlbmQpIHtcblx0XHR2YXIgaW5kZXhlcyA9IGR0LnJvd3MoeyBzZWFyY2g6ICdhcHBsaWVkJyB9KS5pbmRleGVzKCk7XG5cblx0XHQvLyBXaGljaCBjb21lcyBmaXJzdCAtIG1pZ2h0IG5lZWQgdG8gc3dhcFxuXHRcdGlmIChpbmRleGVzLmluZGV4T2Yoc3RhcnQpID4gaW5kZXhlcy5pbmRleE9mKGVuZCkpIHtcblx0XHRcdHZhciB0bXAgPSBlbmQ7XG5cdFx0XHRlbmQgPSBzdGFydDtcblx0XHRcdHN0YXJ0ID0gdG1wO1xuXHRcdH1cblxuXHRcdHZhciByZWNvcmQgPSBmYWxzZTtcblx0XHRyZXR1cm4gaW5kZXhlcy5maWx0ZXIoZnVuY3Rpb24gKGkpIHtcblx0XHRcdGlmIChpID09PSBzdGFydCkge1xuXHRcdFx0XHRyZWNvcmQgPSB0cnVlO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAoaSA9PT0gZW5kKSB7XG5cdFx0XHRcdHJlY29yZCA9IGZhbHNlO1xuXHRcdFx0XHRyZXR1cm4gdHJ1ZTtcblx0XHRcdH1cblxuXHRcdFx0cmV0dXJuIHJlY29yZDtcblx0XHR9KTtcblx0fTtcblxuXHRpZiAoIWR0LmNlbGxzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuYW55KCkgJiYgIWxhc3QpIHtcblx0XHQvLyBzZWxlY3QgZnJvbSB0aGUgdG9wIGxlZnQgY2VsbCB0byB0aGlzIG9uZVxuXHRcdGNvbHVtbkluZGV4ZXMgPSBzZWxlY3RDb2x1bW5zKDAsIGlkeC5jb2x1bW4pO1xuXHRcdHJvd0luZGV4ZXMgPSBzZWxlY3RSb3dzKDAsIGlkeC5yb3cpO1xuXHR9XG5cdGVsc2Uge1xuXHRcdC8vIEdldCBjb2x1bW4gaW5kZXhlcyBiZXR3ZWVuIG9sZCBhbmQgbmV3XG5cdFx0Y29sdW1uSW5kZXhlcyA9IHNlbGVjdENvbHVtbnMobGFzdC5jb2x1bW4sIGlkeC5jb2x1bW4pO1xuXHRcdHJvd0luZGV4ZXMgPSBzZWxlY3RSb3dzKGxhc3Qucm93LCBpZHgucm93KTtcblx0fVxuXG5cdGluZGV4ZXMgPSBkdC5jZWxscyhyb3dJbmRleGVzLCBjb2x1bW5JbmRleGVzKS5mbGF0dGVuKCk7XG5cblx0aWYgKCFkdC5jZWxscyhpZHgsIHsgc2VsZWN0ZWQ6IHRydWUgfSkuYW55KCkpIHtcblx0XHQvLyBTZWxlY3QgcmFuZ2Vcblx0XHRkdC5jZWxscyhpbmRleGVzKS5zZWxlY3QoKTtcblx0fVxuXHRlbHNlIHtcblx0XHQvLyBEZXNlbGVjdCByYW5nZVxuXHRcdGR0LmNlbGxzKGluZGV4ZXMpLmRlc2VsZWN0KCk7XG5cdH1cbn1cblxuLyoqXG4gKiBEaXNhYmxlIG1vdXNlIHNlbGVjdGlvbiBieSByZW1vdmluZyB0aGUgc2VsZWN0b3JzXG4gKlxuICogQHBhcmFtIHtEYXRhVGFibGUuQXBpfSBkdCBEYXRhVGFibGUgdG8gcmVtb3ZlIGV2ZW50cyBmcm9tXG4gKiBAcHJpdmF0ZVxuICovXG5mdW5jdGlvbiBkaXNhYmxlTW91c2VTZWxlY3Rpb24oZHQpIHtcblx0dmFyIGN0eCA9IGR0LnNldHRpbmdzKClbMF07XG5cdHZhciBzZWxlY3RvciA9IGN0eC5fc2VsZWN0LnNlbGVjdG9yO1xuXG5cdCQoZHQudGFibGUoKS5jb250YWluZXIoKSlcblx0XHQub2ZmKCdtb3VzZWRvd24uZHRTZWxlY3QnLCBzZWxlY3Rvcilcblx0XHQub2ZmKCdtb3VzZXVwLmR0U2VsZWN0Jywgc2VsZWN0b3IpXG5cdFx0Lm9mZignY2xpY2suZHRTZWxlY3QnLCBzZWxlY3Rvcik7XG5cblx0JCgnYm9keScpLm9mZignY2xpY2suZHRTZWxlY3QnICsgX3NhZmVJZChkdC50YWJsZSgpLm5vZGUoKSkpO1xufVxuXG4vKipcbiAqIEF0dGFjaCBtb3VzZSBsaXN0ZW5lcnMgdG8gdGhlIHRhYmxlIHRvIGFsbG93IG1vdXNlIHNlbGVjdGlvbiBvZiBpdGVtc1xuICpcbiAqIEBwYXJhbSB7RGF0YVRhYmxlLkFwaX0gZHQgRGF0YVRhYmxlIHRvIHJlbW92ZSBldmVudHMgZnJvbVxuICogQHByaXZhdGVcbiAqL1xuZnVuY3Rpb24gZW5hYmxlTW91c2VTZWxlY3Rpb24oZHQpIHtcblx0dmFyIGNvbnRhaW5lciA9ICQoZHQudGFibGUoKS5jb250YWluZXIoKSk7XG5cdHZhciBjdHggPSBkdC5zZXR0aW5ncygpWzBdO1xuXHR2YXIgc2VsZWN0b3IgPSBjdHguX3NlbGVjdC5zZWxlY3Rvcjtcblx0dmFyIG1hdGNoU2VsZWN0aW9uO1xuXG5cdGNvbnRhaW5lclxuXHRcdC5vbignbW91c2Vkb3duLmR0U2VsZWN0Jywgc2VsZWN0b3IsIGZ1bmN0aW9uIChlKSB7XG5cdFx0XHQvLyBEaXNhbGxvdyB0ZXh0IHNlbGVjdGlvbiBmb3Igc2hpZnQgY2xpY2tpbmcgb24gdGhlIHRhYmxlIHNvIG11bHRpXG5cdFx0XHQvLyBlbGVtZW50IHNlbGVjdGlvbiBkb2Vzbid0IGxvb2sgdGVycmlibGUhXG5cdFx0XHRpZiAoZS5zaGlmdEtleSB8fCBlLm1ldGFLZXkgfHwgZS5jdHJsS2V5KSB7XG5cdFx0XHRcdGNvbnRhaW5lclxuXHRcdFx0XHRcdC5jc3MoJy1tb3otdXNlci1zZWxlY3QnLCAnbm9uZScpXG5cdFx0XHRcdFx0Lm9uZSgnc2VsZWN0c3RhcnQuZHRTZWxlY3QnLCBzZWxlY3RvciwgZnVuY3Rpb24gKCkge1xuXHRcdFx0XHRcdFx0cmV0dXJuIGZhbHNlO1xuXHRcdFx0XHRcdH0pO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAod2luZG93LmdldFNlbGVjdGlvbikge1xuXHRcdFx0XHRtYXRjaFNlbGVjdGlvbiA9IHdpbmRvdy5nZXRTZWxlY3Rpb24oKTtcblx0XHRcdH1cblx0XHR9KVxuXHRcdC5vbignbW91c2V1cC5kdFNlbGVjdCcsIHNlbGVjdG9yLCBmdW5jdGlvbiAoKSB7XG5cdFx0XHQvLyBBbGxvdyB0ZXh0IHNlbGVjdGlvbiB0byBvY2N1ciBhZ2FpbiwgTW96aWxsYSBzdHlsZSAodGVzdGVkIGluIEZGXG5cdFx0XHQvLyAzNS4wLjEgLSBzdGlsbCByZXF1aXJlZClcblx0XHRcdGNvbnRhaW5lci5jc3MoJy1tb3otdXNlci1zZWxlY3QnLCAnJyk7XG5cdFx0fSlcblx0XHQub24oJ2NsaWNrLmR0U2VsZWN0Jywgc2VsZWN0b3IsIGZ1bmN0aW9uIChlKSB7XG5cdFx0XHR2YXIgaXRlbXMgPSBkdC5zZWxlY3QuaXRlbXMoKTtcblx0XHRcdHZhciBpZHg7XG5cblx0XHRcdC8vIElmIHRleHQgd2FzIHNlbGVjdGVkIChjbGljayBhbmQgZHJhZyksIHRoZW4gd2Ugc2hvdWxkbid0IGNoYW5nZVxuXHRcdFx0Ly8gdGhlIHJvdydzIHNlbGVjdGVkIHN0YXRlXG5cdFx0XHRpZiAobWF0Y2hTZWxlY3Rpb24pIHtcblx0XHRcdFx0dmFyIHNlbGVjdGlvbiA9IHdpbmRvdy5nZXRTZWxlY3Rpb24oKTtcblxuXHRcdFx0XHQvLyBJZiB0aGUgZWxlbWVudCB0aGF0IGNvbnRhaW5zIHRoZSBzZWxlY3Rpb24gaXMgbm90IGluIHRoZSB0YWJsZSwgd2UgY2FuIGlnbm9yZSBpdFxuXHRcdFx0XHQvLyBUaGlzIGNhbiBoYXBwZW4gaWYgdGhlIGRldmVsb3BlciBzZWxlY3RzIHRleHQgZnJvbSB0aGUgY2xpY2sgZXZlbnRcblx0XHRcdFx0aWYgKFxuXHRcdFx0XHRcdCFzZWxlY3Rpb24uYW5jaG9yTm9kZSB8fFxuXHRcdFx0XHRcdCQoc2VsZWN0aW9uLmFuY2hvck5vZGUpLmNsb3Nlc3QoJ3RhYmxlJylbMF0gPT09IGR0LnRhYmxlKCkubm9kZSgpXG5cdFx0XHRcdCkge1xuXHRcdFx0XHRcdGlmIChzZWxlY3Rpb24gIT09IG1hdGNoU2VsZWN0aW9uKSB7XG5cdFx0XHRcdFx0XHRyZXR1cm47XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHR9XG5cdFx0XHR9XG5cblx0XHRcdHZhciBjdHggPSBkdC5zZXR0aW5ncygpWzBdO1xuXHRcdFx0dmFyIGNvbnRhaW5lciA9IGR0LnRhYmxlKCkuY29udGFpbmVyKCk7XG5cblx0XHRcdC8vIElnbm9yZSBjbGlja3MgaW5zaWRlIGEgc3ViLXRhYmxlXG5cdFx0XHRpZiAoJChlLnRhcmdldCkuY2xvc2VzdCgnZGl2LmR0LWNvbnRhaW5lcicpWzBdICE9IGNvbnRhaW5lcikge1xuXHRcdFx0XHRyZXR1cm47XG5cdFx0XHR9XG5cblx0XHRcdHZhciBjZWxsID0gZHQuY2VsbCgkKGUudGFyZ2V0KS5jbG9zZXN0KCd0ZCwgdGgnKSk7XG5cblx0XHRcdC8vIENoZWNrIHRoZSBjZWxsIGFjdHVhbGx5IGJlbG9uZ3MgdG8gdGhlIGhvc3QgRGF0YVRhYmxlIChzbyBjaGlsZFxuXHRcdFx0Ly8gcm93cywgZXRjLCBhcmUgaWdub3JlZClcblx0XHRcdGlmICghY2VsbC5hbnkoKSkge1xuXHRcdFx0XHRyZXR1cm47XG5cdFx0XHR9XG5cblx0XHRcdHZhciBldmVudCA9ICQuRXZlbnQoJ3VzZXItc2VsZWN0LmR0Jyk7XG5cdFx0XHRldmVudFRyaWdnZXIoZHQsIGV2ZW50LCBbaXRlbXMsIGNlbGwsIGVdKTtcblxuXHRcdFx0aWYgKGV2ZW50LmlzRGVmYXVsdFByZXZlbnRlZCgpKSB7XG5cdFx0XHRcdHJldHVybjtcblx0XHRcdH1cblxuXHRcdFx0dmFyIGNlbGxJbmRleCA9IGNlbGwuaW5kZXgoKTtcblx0XHRcdGlmIChpdGVtcyA9PT0gJ3JvdycpIHtcblx0XHRcdFx0aWR4ID0gY2VsbEluZGV4LnJvdztcblx0XHRcdFx0dHlwZVNlbGVjdChlLCBkdCwgY3R4LCAncm93JywgaWR4KTtcblx0XHRcdH1cblx0XHRcdGVsc2UgaWYgKGl0ZW1zID09PSAnY29sdW1uJykge1xuXHRcdFx0XHRpZHggPSBjZWxsLmluZGV4KCkuY29sdW1uO1xuXHRcdFx0XHR0eXBlU2VsZWN0KGUsIGR0LCBjdHgsICdjb2x1bW4nLCBpZHgpO1xuXHRcdFx0fVxuXHRcdFx0ZWxzZSBpZiAoaXRlbXMgPT09ICdjZWxsJykge1xuXHRcdFx0XHRpZHggPSBjZWxsLmluZGV4KCk7XG5cdFx0XHRcdHR5cGVTZWxlY3QoZSwgZHQsIGN0eCwgJ2NlbGwnLCBpZHgpO1xuXHRcdFx0fVxuXG5cdFx0XHRjdHguX3NlbGVjdF9sYXN0Q2VsbCA9IGNlbGxJbmRleDtcblx0XHR9KTtcblxuXHQvLyBCbHVyYWJsZVxuXHQkKCdib2R5Jykub24oJ2NsaWNrLmR0U2VsZWN0JyArIF9zYWZlSWQoZHQudGFibGUoKS5ub2RlKCkpLCBmdW5jdGlvbiAoZSkge1xuXHRcdGlmIChjdHguX3NlbGVjdC5ibHVyYWJsZSkge1xuXHRcdFx0Ly8gSWYgdGhlIGNsaWNrIHdhcyBpbnNpZGUgdGhlIERhdGFUYWJsZXMgY29udGFpbmVyLCBkb24ndCBibHVyXG5cdFx0XHRpZiAoJChlLnRhcmdldCkucGFyZW50cygpLmZpbHRlcihkdC50YWJsZSgpLmNvbnRhaW5lcigpKS5sZW5ndGgpIHtcblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBJZ25vcmUgZWxlbWVudHMgd2hpY2ggaGF2ZSBiZWVuIHJlbW92ZWQgZnJvbSB0aGUgRE9NIChpLmUuIHBhZ2luZ1xuXHRcdFx0Ly8gYnV0dG9ucylcblx0XHRcdGlmICgkKGUudGFyZ2V0KS5wYXJlbnRzKCdodG1sJykubGVuZ3RoID09PSAwKSB7XG5cdFx0XHRcdHJldHVybjtcblx0XHRcdH1cblxuXHRcdFx0Ly8gRG9uJ3QgYmx1ciBpbiBFZGl0b3IgZm9ybVxuXHRcdFx0aWYgKCQoZS50YXJnZXQpLnBhcmVudHMoJ2Rpdi5EVEUnKS5sZW5ndGgpIHtcblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHR2YXIgZXZlbnQgPSAkLkV2ZW50KCdzZWxlY3QtYmx1ci5kdCcpO1xuXHRcdFx0ZXZlbnRUcmlnZ2VyKGR0LCBldmVudCwgW2UudGFyZ2V0LCBlXSk7XG5cblx0XHRcdGlmIChldmVudC5pc0RlZmF1bHRQcmV2ZW50ZWQoKSkge1xuXHRcdFx0XHRyZXR1cm47XG5cdFx0XHR9XG5cblx0XHRcdGNsZWFyKGN0eCwgdHJ1ZSk7XG5cdFx0fVxuXHR9KTtcbn1cblxuLyoqXG4gKiBUcmlnZ2VyIGFuIGV2ZW50IG9uIGEgRGF0YVRhYmxlXG4gKlxuICogQHBhcmFtIHtEYXRhVGFibGUuQXBpfSBhcGkgICAgICBEYXRhVGFibGUgdG8gdHJpZ2dlciBldmVudHMgb25cbiAqIEBwYXJhbSAge2Jvb2xlYW59ICAgICAgc2VsZWN0ZWQgdHJ1ZSBpZiBzZWxlY3RlZCwgZmFsc2UgaWYgZGVzZWxlY3RlZFxuICogQHBhcmFtICB7c3RyaW5nfSAgICAgICB0eXBlICAgICBJdGVtIHR5cGUgYWN0aW5nIG9uXG4gKiBAcGFyYW0gIHtib29sZWFufSAgICAgIGFueSAgICAgIFJlcXVpcmUgdGhhdCB0aGVyZSBhcmUgdmFsdWVzIGJlZm9yZVxuICogICAgIHRyaWdnZXJpbmdcbiAqIEBwcml2YXRlXG4gKi9cbmZ1bmN0aW9uIGV2ZW50VHJpZ2dlcihhcGksIHR5cGUsIGFyZ3MsIGFueSkge1xuXHRpZiAoYW55ICYmICFhcGkuZmxhdHRlbigpLmxlbmd0aCkge1xuXHRcdHJldHVybjtcblx0fVxuXG5cdGlmICh0eXBlb2YgdHlwZSA9PT0gJ3N0cmluZycpIHtcblx0XHR0eXBlID0gdHlwZSArICcuZHQnO1xuXHR9XG5cblx0YXJncy51bnNoaWZ0KGFwaSk7XG5cblx0JChhcGkudGFibGUoKS5ub2RlKCkpLnRyaWdnZXIodHlwZSwgYXJncyk7XG59XG5cbi8qKlxuICogVXBkYXRlIHRoZSBpbmZvcm1hdGlvbiBlbGVtZW50IG9mIHRoZSBEYXRhVGFibGUgc2hvd2luZyBpbmZvcm1hdGlvbiBhYm91dCB0aGVcbiAqIGl0ZW1zIHNlbGVjdGVkLiBUaGlzIGlzIGRvbmUgYnkgYWRkaW5nIHRhZ3MgdG8gdGhlIGV4aXN0aW5nIHRleHRcbiAqXG4gKiBAcGFyYW0ge0RhdGFUYWJsZS5BcGl9IGFwaSBEYXRhVGFibGUgdG8gdXBkYXRlXG4gKiBAcHJpdmF0ZVxuICovXG5mdW5jdGlvbiBpbmZvKGFwaSwgbm9kZSkge1xuXHRpZiAoYXBpLnNlbGVjdC5zdHlsZSgpID09PSAnYXBpJyB8fCBhcGkuc2VsZWN0LmluZm8oKSA9PT0gZmFsc2UpIHtcblx0XHRyZXR1cm47XG5cdH1cblxuXHR2YXIgcm93cyA9IGFwaS5yb3dzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZmxhdHRlbigpLmxlbmd0aDtcblx0dmFyIGNvbHVtbnMgPSBhcGkuY29sdW1ucyh7IHNlbGVjdGVkOiB0cnVlIH0pLmZsYXR0ZW4oKS5sZW5ndGg7XG5cdHZhciBjZWxscyA9IGFwaS5jZWxscyh7IHNlbGVjdGVkOiB0cnVlIH0pLmZsYXR0ZW4oKS5sZW5ndGg7XG5cblx0dmFyIGFkZCA9IGZ1bmN0aW9uIChlbCwgbmFtZSwgbnVtKSB7XG5cdFx0ZWwuYXBwZW5kKFxuXHRcdFx0JCgnPHNwYW4gY2xhc3M9XCJzZWxlY3QtaXRlbVwiLz4nKS5hcHBlbmQoXG5cdFx0XHRcdGFwaS5pMThuKFxuXHRcdFx0XHRcdCdzZWxlY3QuJyArIG5hbWUgKyAncycsXG5cdFx0XHRcdFx0eyBfOiAnJWQgJyArIG5hbWUgKyAncyBzZWxlY3RlZCcsIDA6ICcnLCAxOiAnMSAnICsgbmFtZSArICcgc2VsZWN0ZWQnIH0sXG5cdFx0XHRcdFx0bnVtXG5cdFx0XHRcdClcblx0XHRcdClcblx0XHQpO1xuXHR9O1xuXG5cdHZhciBlbCA9ICQobm9kZSk7XG5cdHZhciBvdXRwdXQgPSAkKCc8c3BhbiBjbGFzcz1cInNlbGVjdC1pbmZvXCIvPicpO1xuXG5cdGFkZChvdXRwdXQsICdyb3cnLCByb3dzKTtcblx0YWRkKG91dHB1dCwgJ2NvbHVtbicsIGNvbHVtbnMpO1xuXHRhZGQob3V0cHV0LCAnY2VsbCcsIGNlbGxzKTtcblxuXHR2YXIgZXhpc3RpbmcgPSBlbC5jaGlsZHJlbignc3Bhbi5zZWxlY3QtaW5mbycpO1xuXG5cdGlmIChleGlzdGluZy5sZW5ndGgpIHtcblx0XHRleGlzdGluZy5yZW1vdmUoKTtcblx0fVxuXG5cdGlmIChvdXRwdXQudGV4dCgpICE9PSAnJykge1xuXHRcdGVsLmFwcGVuZChvdXRwdXQpO1xuXHR9XG59XG5cbi8qKlxuICogQWRkIGEgY2hlY2tib3ggdG8gdGhlIGhlYWRlciBmb3IgY2hlY2tib3ggY29sdW1ucywgYWxsb3dpbmcgYWxsIHJvd3MgdG9cbiAqIGJlIHNlbGVjdGVkLCBkZXNlbGVjdGVkIG9yIGp1c3QgdG8gc2hvdyB0aGUgc3RhdGUuXG4gKlxuICogQHBhcmFtIHsqfSBkdCBBUElcbiAqL1xuZnVuY3Rpb24gaW5pdENoZWNrYm94SGVhZGVyKCBkdCApIHtcblx0Ly8gRmluZCBhbnkgY2hlY2tib3ggY29sdW1uKHMpXG5cdGR0LmNvbHVtbnMoJy5kdC1zZWxlY3QnKS5ldmVyeShmdW5jdGlvbiAoKSB7XG5cdFx0dmFyIGhlYWRlciA9IHRoaXMuaGVhZGVyKCk7XG5cblx0XHRpZiAoISAkKCdpbnB1dCcsIGhlYWRlcikubGVuZ3RoKSB7XG5cdFx0XHQvLyBJZiBubyBjaGVja2JveCB5ZXQsIGluc2VydCBvbmVcblx0XHRcdHZhciBpbnB1dCA9ICQoJzxpbnB1dD4nKVxuXHRcdFx0XHQuYXR0cih7XG5cdFx0XHRcdFx0Y2xhc3M6ICdkdC1zZWxlY3QtY2hlY2tib3gnLFxuXHRcdFx0XHRcdHR5cGU6ICdjaGVja2JveCcsXG5cdFx0XHRcdFx0J2FyaWEtbGFiZWwnOiBkdC5pMThuKCdzZWxlY3QuYXJpYS5oZWFkZXJDaGVja2JveCcpIHx8ICdTZWxlY3QgYWxsIHJvd3MnXG5cdFx0XHRcdH0pXG5cdFx0XHRcdC5hcHBlbmRUbyhoZWFkZXIpXG5cdFx0XHRcdC5vbignY2hhbmdlJywgZnVuY3Rpb24gKCkge1xuXHRcdFx0XHRcdGlmICh0aGlzLmNoZWNrZWQpIHtcblx0XHRcdFx0XHRcdGR0LnJvd3Moe3NlYXJjaDogJ2FwcGxpZWQnfSkuc2VsZWN0KCk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdGVsc2Uge1xuXHRcdFx0XHRcdFx0ZHQucm93cyh7c2VsZWN0ZWQ6IHRydWV9KS5kZXNlbGVjdCgpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSlcblx0XHRcdFx0Lm9uKCdjbGljaycsIGZ1bmN0aW9uIChlKSB7XG5cdFx0XHRcdFx0ZS5zdG9wUHJvcGFnYXRpb24oKTtcblx0XHRcdFx0fSk7XG5cdFxuXHRcdFx0Ly8gVXBkYXRlIHRoZSBoZWFkZXIgY2hlY2tib3gncyBzdGF0ZSB3aGVuIHRoZSBzZWxlY3Rpb24gaW4gdGhlXG5cdFx0XHQvLyB0YWJsZSBjaGFuZ2VzXG5cdFx0XHRkdC5vbignZHJhdyBzZWxlY3QgZGVzZWxlY3QnLCBmdW5jdGlvbiAoZSwgcGFzcywgdHlwZSkge1xuXHRcdFx0XHRpZiAodHlwZSA9PT0gJ3JvdycgfHwgISB0eXBlKSB7XG5cdFx0XHRcdFx0dmFyIGNvdW50ID0gZHQucm93cyh7c2VsZWN0ZWQ6IHRydWV9KS5jb3VudCgpO1xuXHRcdFx0XHRcdHZhciBzZWFyY2ggPSBkdC5yb3dzKHtzZWFyY2g6ICdhcHBsaWVkJywgc2VsZWN0ZWQ6IHRydWV9KS5jb3VudCgpO1xuXHRcdFx0XHRcdHZhciBhdmFpbGFibGUgPSBkdC5yb3dzKHtzZWFyY2g6ICdhcHBsaWVkJ30pLmNvdW50KCk7XG5cblx0XHRcdFx0XHRpZiAoc2VhcmNoICYmIHNlYXJjaCA8PSBjb3VudCAmJiBzZWFyY2ggPT09IGF2YWlsYWJsZSkge1xuXHRcdFx0XHRcdFx0aW5wdXRcblx0XHRcdFx0XHRcdFx0LnByb3AoJ2NoZWNrZWQnLCB0cnVlKVxuXHRcdFx0XHRcdFx0XHQucHJvcCgnaW5kZXRlcm1pbmF0ZScsIGZhbHNlKTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0ZWxzZSBpZiAoc2VhcmNoID09PSAwICYmIGNvdW50ID09PSAwKSB7XG5cdFx0XHRcdFx0XHRpbnB1dFxuXHRcdFx0XHRcdFx0XHQucHJvcCgnY2hlY2tlZCcsIGZhbHNlKVxuXHRcdFx0XHRcdFx0XHQucHJvcCgnaW5kZXRlcm1pbmF0ZScsIGZhbHNlKTtcblx0XHRcdFx0XHR9XG5cdFx0XHRcdFx0ZWxzZSB7XG5cdFx0XHRcdFx0XHRpbnB1dFxuXHRcdFx0XHRcdFx0XHQucHJvcCgnY2hlY2tlZCcsIGZhbHNlKVxuXHRcdFx0XHRcdFx0XHQucHJvcCgnaW5kZXRlcm1pbmF0ZScsIHRydWUpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fVxuXHRcdFx0fSk7XG5cdFx0fVxuXHR9KTtcbn1cblxuLyoqXG4gKiBJbml0aWFsaXNhdGlvbiBvZiBhIG5ldyB0YWJsZS4gQXR0YWNoIGV2ZW50IGhhbmRsZXJzIGFuZCBjYWxsYmFja3MgdG8gYWxsb3dcbiAqIFNlbGVjdCB0byBvcGVyYXRlIGNvcnJlY3RseS5cbiAqXG4gKiBUaGlzIHdpbGwgb2NjdXIgX2FmdGVyXyB0aGUgaW5pdGlhbCBEYXRhVGFibGVzIGluaXRpYWxpc2F0aW9uLCBhbHRob3VnaFxuICogYmVmb3JlIEFqYXggZGF0YSBpcyByZW5kZXJlZCwgaWYgdGhlcmUgaXMgYWpheCBkYXRhXG4gKlxuICogQHBhcmFtICB7RGF0YVRhYmxlLnNldHRpbmdzfSBjdHggU2V0dGluZ3Mgb2JqZWN0IHRvIG9wZXJhdGUgb25cbiAqIEBwcml2YXRlXG4gKi9cbmZ1bmN0aW9uIGluaXQoY3R4KSB7XG5cdHZhciBhcGkgPSBuZXcgRGF0YVRhYmxlLkFwaShjdHgpO1xuXHRjdHguX3NlbGVjdF9pbml0ID0gdHJ1ZTtcblxuXHQvLyBSb3cgY2FsbGJhY2sgc28gdGhhdCBjbGFzc2VzIGNhbiBiZSBhZGRlZCB0byByb3dzIGFuZCBjZWxscyBpZiB0aGUgaXRlbVxuXHQvLyB3YXMgc2VsZWN0ZWQgYmVmb3JlIHRoZSBlbGVtZW50IHdhcyBjcmVhdGVkLiBUaGlzIHdpbGwgaGFwcGVuIHdpdGggdGhlXG5cdC8vIGBkZWZlclJlbmRlcmAgb3B0aW9uIGVuYWJsZWQuXG5cdC8vXG5cdC8vIFRoaXMgbWV0aG9kIG9mIGF0dGFjaGluZyB0byBgYW9Sb3dDcmVhdGVkQ2FsbGJhY2tgIGlzIGEgaGFjayB1bnRpbFxuXHQvLyBEYXRhVGFibGVzIGhhcyBwcm9wZXIgZXZlbnRzIGZvciByb3cgbWFuaXB1bGF0aW9uIElmIHlvdSBhcmUgcmV2aWV3aW5nXG5cdC8vIHRoaXMgY29kZSB0byBjcmVhdGUgeW91ciBvd24gcGx1Zy1pbnMsIHBsZWFzZSBkbyBub3QgZG8gdGhpcyFcblx0Y3R4LmFvUm93Q3JlYXRlZENhbGxiYWNrLnB1c2goZnVuY3Rpb24gKHJvdywgZGF0YSwgaW5kZXgpIHtcblx0XHRcdHZhciBpLCBpZW47XG5cdFx0XHR2YXIgZCA9IGN0eC5hb0RhdGFbaW5kZXhdO1xuXG5cdFx0XHQvLyBSb3dcblx0XHRcdGlmIChkLl9zZWxlY3Rfc2VsZWN0ZWQpIHtcblx0XHRcdFx0JChyb3cpLmFkZENsYXNzKGN0eC5fc2VsZWN0LmNsYXNzTmFtZSk7XG5cdFx0XHR9XG5cblx0XHRcdC8vIENlbGxzIGFuZCBjb2x1bW5zIC0gaWYgc2VwYXJhdGVkIG91dCwgd2Ugd291bGQgbmVlZCB0byBkbyB0d29cblx0XHRcdC8vIGxvb3BzLCBzbyBpdCBtYWtlcyBzZW5zZSB0byBjb21iaW5lIHRoZW0gaW50byBhIHNpbmdsZSBvbmVcblx0XHRcdGZvciAoaSA9IDAsIGllbiA9IGN0eC5hb0NvbHVtbnMubGVuZ3RoOyBpIDwgaWVuOyBpKyspIHtcblx0XHRcdFx0aWYgKFxuXHRcdFx0XHRcdGN0eC5hb0NvbHVtbnNbaV0uX3NlbGVjdF9zZWxlY3RlZCB8fFxuXHRcdFx0XHRcdChkLl9zZWxlY3RlZF9jZWxscyAmJiBkLl9zZWxlY3RlZF9jZWxsc1tpXSlcblx0XHRcdFx0KSB7XG5cdFx0XHRcdFx0JChkLmFuQ2VsbHNbaV0pLmFkZENsYXNzKGN0eC5fc2VsZWN0LmNsYXNzTmFtZSk7XG5cdFx0XHRcdH1cblx0XHRcdH1cblx0XHR9XG5cdCk7XG5cblx0Ly8gT24gQWpheCByZWxvYWQgd2Ugd2FudCB0byByZXNlbGVjdCBhbGwgcm93cyB3aGljaCBhcmUgY3VycmVudGx5IHNlbGVjdGVkLFxuXHQvLyBpZiB0aGVyZSBpcyBhbiByb3dJZCAoaS5lLiBhIHVuaXF1ZSB2YWx1ZSB0byBpZGVudGlmeSBlYWNoIHJvdyB3aXRoKVxuXHRhcGkub24oJ3ByZVhoci5kdC5kdFNlbGVjdCcsIGZ1bmN0aW9uIChlLCBzZXR0aW5ncykge1xuXHRcdGlmIChzZXR0aW5ncyAhPT0gYXBpLnNldHRpbmdzKClbMF0pIHtcblx0XHRcdC8vIE5vdCB0cmlnZ2VyZWQgYnkgb3VyIERhdGFUYWJsZSFcblx0XHRcdHJldHVybjtcblx0XHR9XG5cblx0XHQvLyBub3RlIHRoYXQgY29sdW1uIHNlbGVjdGlvbiBkb2Vzbid0IG5lZWQgdG8gYmUgY2FjaGVkIGFuZCB0aGVuXG5cdFx0Ly8gcmVzZWxlY3RlZCwgYXMgdGhleSBhcmUgYWxyZWFkeSBzZWxlY3RlZFxuXHRcdHZhciByb3dzID0gYXBpXG5cdFx0XHQucm93cyh7IHNlbGVjdGVkOiB0cnVlIH0pXG5cdFx0XHQuaWRzKHRydWUpXG5cdFx0XHQuZmlsdGVyKGZ1bmN0aW9uIChkKSB7XG5cdFx0XHRcdHJldHVybiBkICE9PSB1bmRlZmluZWQ7XG5cdFx0XHR9KTtcblxuXHRcdHZhciBjZWxscyA9IGFwaVxuXHRcdFx0LmNlbGxzKHsgc2VsZWN0ZWQ6IHRydWUgfSlcblx0XHRcdC5lcSgwKVxuXHRcdFx0Lm1hcChmdW5jdGlvbiAoY2VsbElkeCkge1xuXHRcdFx0XHR2YXIgaWQgPSBhcGkucm93KGNlbGxJZHgucm93KS5pZCh0cnVlKTtcblx0XHRcdFx0cmV0dXJuIGlkID8geyByb3c6IGlkLCBjb2x1bW46IGNlbGxJZHguY29sdW1uIH0gOiB1bmRlZmluZWQ7XG5cdFx0XHR9KVxuXHRcdFx0LmZpbHRlcihmdW5jdGlvbiAoZCkge1xuXHRcdFx0XHRyZXR1cm4gZCAhPT0gdW5kZWZpbmVkO1xuXHRcdFx0fSk7XG5cblx0XHQvLyBPbiB0aGUgbmV4dCBkcmF3LCByZXNlbGVjdCB0aGUgY3VycmVudGx5IHNlbGVjdGVkIGl0ZW1zXG5cdFx0YXBpLm9uZSgnZHJhdy5kdC5kdFNlbGVjdCcsIGZ1bmN0aW9uICgpIHtcblx0XHRcdGFwaS5yb3dzKHJvd3MpLnNlbGVjdCgpO1xuXG5cdFx0XHQvLyBgY2VsbHNgIGlzIG5vdCBhIGNlbGwgaW5kZXggc2VsZWN0b3IsIHNvIGl0IG5lZWRzIGEgbG9vcFxuXHRcdFx0aWYgKGNlbGxzLmFueSgpKSB7XG5cdFx0XHRcdGNlbGxzLmVhY2goZnVuY3Rpb24gKGlkKSB7XG5cdFx0XHRcdFx0YXBpLmNlbGxzKGlkLnJvdywgaWQuY29sdW1uKS5zZWxlY3QoKTtcblx0XHRcdFx0fSk7XG5cdFx0XHR9XG5cdFx0fSk7XG5cdH0pO1xuXG5cdC8vIFVwZGF0ZSB0aGUgdGFibGUgaW5mb3JtYXRpb24gZWxlbWVudCB3aXRoIHNlbGVjdGVkIGl0ZW0gc3VtbWFyeVxuXHRhcGkub24oJ2luZm8uZHQnLCBmdW5jdGlvbiAoZSwgY3R4LCBub2RlKSB7XG5cdFx0Ly8gU3RvcmUgdGhlIGluZm8gbm9kZSBmb3IgdXBkYXRpbmcgb24gc2VsZWN0IC8gZGVzZWxlY3Rcblx0XHRpZiAoIWN0eC5fc2VsZWN0LmluZm9FbHMuaW5jbHVkZXMobm9kZSkpIHtcblx0XHRcdGN0eC5fc2VsZWN0LmluZm9FbHMucHVzaChub2RlKTtcblx0XHR9XG5cblx0XHRpbmZvKGFwaSwgbm9kZSk7XG5cdH0pO1xuXG5cdGFwaS5vbignc2VsZWN0LmR0U2VsZWN0LmR0IGRlc2VsZWN0LmR0U2VsZWN0LmR0JywgZnVuY3Rpb24gKCkge1xuXHRcdGN0eC5fc2VsZWN0LmluZm9FbHMuZm9yRWFjaChmdW5jdGlvbiAoZWwpIHtcblx0XHRcdGluZm8oYXBpLCBlbCk7XG5cdFx0fSk7XG5cblx0XHRhcGkuc3RhdGUuc2F2ZSgpO1xuXHR9KTtcblxuXHQvLyBDbGVhbiB1cCBhbmQgcmVsZWFzZVxuXHRhcGkub24oJ2Rlc3Ryb3kuZHRTZWxlY3QnLCBmdW5jdGlvbiAoKSB7XG5cdFx0Ly8gUmVtb3ZlIGNsYXNzIGRpcmVjdGx5IHJhdGhlciB0aGFuIGNhbGxpbmcgZGVzZWxlY3QgLSB3aGljaCB3b3VsZCB0cmlnZ2VyIGV2ZW50c1xuXHRcdCQoYXBpLnJvd3MoeyBzZWxlY3RlZDogdHJ1ZSB9KS5ub2RlcygpKS5yZW1vdmVDbGFzcyhhcGkuc2V0dGluZ3MoKVswXS5fc2VsZWN0LmNsYXNzTmFtZSk7XG5cblx0XHRkaXNhYmxlTW91c2VTZWxlY3Rpb24oYXBpKTtcblx0XHRhcGkub2ZmKCcuZHRTZWxlY3QnKTtcblx0XHQkKCdib2R5Jykub2ZmKCcuZHRTZWxlY3QnICsgX3NhZmVJZChhcGkudGFibGUoKS5ub2RlKCkpKTtcblx0fSk7XG59XG5cbi8qKlxuICogQWRkIG9uZSBvciBtb3JlIGl0ZW1zIChyb3dzIG9yIGNvbHVtbnMpIHRvIHRoZSBzZWxlY3Rpb24gd2hlbiBzaGlmdCBjbGlja2luZ1xuICogaW4gT1Mgc2VsZWN0aW9uIHN0eWxlXG4gKlxuICogQHBhcmFtICB7RGF0YVRhYmxlLkFwaX0gZHQgICBEYXRhVGFibGVcbiAqIEBwYXJhbSAge3N0cmluZ30gICAgICAgIHR5cGUgUm93IG9yIGNvbHVtbiByYW5nZSBzZWxlY3RvclxuICogQHBhcmFtICB7b2JqZWN0fSAgICAgICAgaWR4ICBJdGVtIGluZGV4IHRvIHNlbGVjdCB0b1xuICogQHBhcmFtICB7b2JqZWN0fSAgICAgICAgbGFzdCBJdGVtIGluZGV4IHRvIHNlbGVjdCBmcm9tXG4gKiBAcHJpdmF0ZVxuICovXG5mdW5jdGlvbiByb3dDb2x1bW5SYW5nZShkdCwgdHlwZSwgaWR4LCBsYXN0KSB7XG5cdC8vIEFkZCBhIHJhbmdlIG9mIHJvd3MgZnJvbSB0aGUgbGFzdCBzZWxlY3RlZCByb3cgdG8gdGhpcyBvbmVcblx0dmFyIGluZGV4ZXMgPSBkdFt0eXBlICsgJ3MnXSh7IHNlYXJjaDogJ2FwcGxpZWQnIH0pLmluZGV4ZXMoKTtcblx0dmFyIGlkeDEgPSBpbmRleGVzLmluZGV4T2YobGFzdCk7XG5cdHZhciBpZHgyID0gaW5kZXhlcy5pbmRleE9mKGlkeCk7XG5cblx0aWYgKCFkdFt0eXBlICsgJ3MnXSh7IHNlbGVjdGVkOiB0cnVlIH0pLmFueSgpICYmIGlkeDEgPT09IC0xKSB7XG5cdFx0Ly8gc2VsZWN0IGZyb20gdG9wIHRvIGhlcmUgLSBzbGlnaHRseSBvZGQsIGJ1dCBib3RoIFdpbmRvd3MgYW5kIE1hYyBPU1xuXHRcdC8vIGRvIHRoaXNcblx0XHRpbmRleGVzLnNwbGljZShpbmRleGVzLmluZGV4T2YoaWR4KSArIDEsIGluZGV4ZXMubGVuZ3RoKTtcblx0fVxuXHRlbHNlIHtcblx0XHQvLyByZXZlcnNlIHNvIHdlIGNhbiBzaGlmdCBjbGljayAndXAnIGFzIHdlbGwgYXMgZG93blxuXHRcdGlmIChpZHgxID4gaWR4Mikge1xuXHRcdFx0dmFyIHRtcCA9IGlkeDI7XG5cdFx0XHRpZHgyID0gaWR4MTtcblx0XHRcdGlkeDEgPSB0bXA7XG5cdFx0fVxuXG5cdFx0aW5kZXhlcy5zcGxpY2UoaWR4MiArIDEsIGluZGV4ZXMubGVuZ3RoKTtcblx0XHRpbmRleGVzLnNwbGljZSgwLCBpZHgxKTtcblx0fVxuXG5cdGlmICghZHRbdHlwZV0oaWR4LCB7IHNlbGVjdGVkOiB0cnVlIH0pLmFueSgpKSB7XG5cdFx0Ly8gU2VsZWN0IHJhbmdlXG5cdFx0ZHRbdHlwZSArICdzJ10oaW5kZXhlcykuc2VsZWN0KCk7XG5cdH1cblx0ZWxzZSB7XG5cdFx0Ly8gRGVzZWxlY3QgcmFuZ2UgLSBuZWVkIHRvIGtlZXAgdGhlIGNsaWNrZWQgb24gcm93IHNlbGVjdGVkXG5cdFx0aW5kZXhlcy5zcGxpY2UoaW5kZXhlcy5pbmRleE9mKGlkeCksIDEpO1xuXHRcdGR0W3R5cGUgKyAncyddKGluZGV4ZXMpLmRlc2VsZWN0KCk7XG5cdH1cbn1cblxuLyoqXG4gKiBDbGVhciBhbGwgc2VsZWN0ZWQgaXRlbXNcbiAqXG4gKiBAcGFyYW0gIHtEYXRhVGFibGUuc2V0dGluZ3N9IGN0eCBTZXR0aW5ncyBvYmplY3Qgb2YgdGhlIGhvc3QgRGF0YVRhYmxlXG4gKiBAcGFyYW0gIHtib29sZWFufSBbZm9yY2U9ZmFsc2VdIEZvcmNlIHRoZSBkZS1zZWxlY3Rpb24gdG8gaGFwcGVuLCByZWdhcmRsZXNzXG4gKiAgICAgb2Ygc2VsZWN0aW9uIHN0eWxlXG4gKiBAcHJpdmF0ZVxuICovXG5mdW5jdGlvbiBjbGVhcihjdHgsIGZvcmNlKSB7XG5cdGlmIChmb3JjZSB8fCBjdHguX3NlbGVjdC5zdHlsZSA9PT0gJ3NpbmdsZScpIHtcblx0XHR2YXIgYXBpID0gbmV3IERhdGFUYWJsZS5BcGkoY3R4KTtcblxuXHRcdGFwaS5yb3dzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZGVzZWxlY3QoKTtcblx0XHRhcGkuY29sdW1ucyh7IHNlbGVjdGVkOiB0cnVlIH0pLmRlc2VsZWN0KCk7XG5cdFx0YXBpLmNlbGxzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZGVzZWxlY3QoKTtcblx0fVxufVxuXG4vKipcbiAqIFNlbGVjdCBpdGVtcyBiYXNlZCBvbiB0aGUgY3VycmVudCBjb25maWd1cmF0aW9uIGZvciBzdHlsZSBhbmQgaXRlbXMuXG4gKlxuICogQHBhcmFtICB7b2JqZWN0fSAgICAgICAgICAgICBlICAgIE1vdXNlIGV2ZW50IG9iamVjdFxuICogQHBhcmFtICB7RGF0YVRhYmxlcy5BcGl9ICAgICBkdCAgIERhdGFUYWJsZVxuICogQHBhcmFtICB7RGF0YVRhYmxlLnNldHRpbmdzfSBjdHggIFNldHRpbmdzIG9iamVjdCBvZiB0aGUgaG9zdCBEYXRhVGFibGVcbiAqIEBwYXJhbSAge3N0cmluZ30gICAgICAgICAgICAgdHlwZSBJdGVtcyB0byBzZWxlY3RcbiAqIEBwYXJhbSAge2ludHxvYmplY3R9ICAgICAgICAgaWR4ICBJbmRleCBvZiB0aGUgaXRlbSB0byBzZWxlY3RcbiAqIEBwcml2YXRlXG4gKi9cbmZ1bmN0aW9uIHR5cGVTZWxlY3QoZSwgZHQsIGN0eCwgdHlwZSwgaWR4KSB7XG5cdHZhciBzdHlsZSA9IGR0LnNlbGVjdC5zdHlsZSgpO1xuXHR2YXIgdG9nZ2xlYWJsZSA9IGR0LnNlbGVjdC50b2dnbGVhYmxlKCk7XG5cdHZhciBpc1NlbGVjdGVkID0gZHRbdHlwZV0oaWR4LCB7IHNlbGVjdGVkOiB0cnVlIH0pLmFueSgpO1xuXG5cdGlmIChpc1NlbGVjdGVkICYmICF0b2dnbGVhYmxlKSB7XG5cdFx0cmV0dXJuO1xuXHR9XG5cblx0aWYgKHN0eWxlID09PSAnb3MnKSB7XG5cdFx0aWYgKGUuY3RybEtleSB8fCBlLm1ldGFLZXkpIHtcblx0XHRcdC8vIEFkZCBvciByZW1vdmUgZnJvbSB0aGUgc2VsZWN0aW9uXG5cdFx0XHRkdFt0eXBlXShpZHgpLnNlbGVjdCghaXNTZWxlY3RlZCk7XG5cdFx0fVxuXHRcdGVsc2UgaWYgKGUuc2hpZnRLZXkpIHtcblx0XHRcdGlmICh0eXBlID09PSAnY2VsbCcpIHtcblx0XHRcdFx0Y2VsbFJhbmdlKGR0LCBpZHgsIGN0eC5fc2VsZWN0X2xhc3RDZWxsIHx8IG51bGwpO1xuXHRcdFx0fVxuXHRcdFx0ZWxzZSB7XG5cdFx0XHRcdHJvd0NvbHVtblJhbmdlKFxuXHRcdFx0XHRcdGR0LFxuXHRcdFx0XHRcdHR5cGUsXG5cdFx0XHRcdFx0aWR4LFxuXHRcdFx0XHRcdGN0eC5fc2VsZWN0X2xhc3RDZWxsID8gY3R4Ll9zZWxlY3RfbGFzdENlbGxbdHlwZV0gOiBudWxsXG5cdFx0XHRcdCk7XG5cdFx0XHR9XG5cdFx0fVxuXHRcdGVsc2Uge1xuXHRcdFx0Ly8gTm8gY21kIG9yIHNoaWZ0IGNsaWNrIC0gZGVzZWxlY3QgaWYgc2VsZWN0ZWQsIG9yIHNlbGVjdFxuXHRcdFx0Ly8gdGhpcyByb3cgb25seVxuXHRcdFx0dmFyIHNlbGVjdGVkID0gZHRbdHlwZSArICdzJ10oeyBzZWxlY3RlZDogdHJ1ZSB9KTtcblxuXHRcdFx0aWYgKGlzU2VsZWN0ZWQgJiYgc2VsZWN0ZWQuZmxhdHRlbigpLmxlbmd0aCA9PT0gMSkge1xuXHRcdFx0XHRkdFt0eXBlXShpZHgpLmRlc2VsZWN0KCk7XG5cdFx0XHR9XG5cdFx0XHRlbHNlIHtcblx0XHRcdFx0c2VsZWN0ZWQuZGVzZWxlY3QoKTtcblx0XHRcdFx0ZHRbdHlwZV0oaWR4KS5zZWxlY3QoKTtcblx0XHRcdH1cblx0XHR9XG5cdH1cblx0ZWxzZSBpZiAoc3R5bGUgPT0gJ211bHRpK3NoaWZ0Jykge1xuXHRcdGlmIChlLnNoaWZ0S2V5KSB7XG5cdFx0XHRpZiAodHlwZSA9PT0gJ2NlbGwnKSB7XG5cdFx0XHRcdGNlbGxSYW5nZShkdCwgaWR4LCBjdHguX3NlbGVjdF9sYXN0Q2VsbCB8fCBudWxsKTtcblx0XHRcdH1cblx0XHRcdGVsc2Uge1xuXHRcdFx0XHRyb3dDb2x1bW5SYW5nZShcblx0XHRcdFx0XHRkdCxcblx0XHRcdFx0XHR0eXBlLFxuXHRcdFx0XHRcdGlkeCxcblx0XHRcdFx0XHRjdHguX3NlbGVjdF9sYXN0Q2VsbCA/IGN0eC5fc2VsZWN0X2xhc3RDZWxsW3R5cGVdIDogbnVsbFxuXHRcdFx0XHQpO1xuXHRcdFx0fVxuXHRcdH1cblx0XHRlbHNlIHtcblx0XHRcdGR0W3R5cGVdKGlkeCkuc2VsZWN0KCFpc1NlbGVjdGVkKTtcblx0XHR9XG5cdH1cblx0ZWxzZSB7XG5cdFx0ZHRbdHlwZV0oaWR4KS5zZWxlY3QoIWlzU2VsZWN0ZWQpO1xuXHR9XG59XG5cbmZ1bmN0aW9uIF9zYWZlSWQobm9kZSkge1xuXHRyZXR1cm4gbm9kZS5pZC5yZXBsYWNlKC9bXmEtekEtWjAtOVxcLVxcX10vZywgJy0nKTtcbn1cblxuLyogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICpcbiAqIERhdGFUYWJsZXMgc2VsZWN0b3JzXG4gKi9cblxuLy8gcm93IGFuZCBjb2x1bW4gYXJlIGJhc2ljYWxseSBpZGVudGljYWwganVzdCBhc3NpZ25lZCB0byBkaWZmZXJlbnQgcHJvcGVydGllc1xuLy8gYW5kIGNoZWNraW5nIGEgZGlmZmVyZW50IGFycmF5LCBzbyB3ZSBjYW4gZHluYW1pY2FsbHkgY3JlYXRlIHRoZSBmdW5jdGlvbnMgdG9cbi8vIHJlZHVjZSB0aGUgY29kZSBzaXplXG4kLmVhY2goXG5cdFtcblx0XHR7IHR5cGU6ICdyb3cnLCBwcm9wOiAnYW9EYXRhJyB9LFxuXHRcdHsgdHlwZTogJ2NvbHVtbicsIHByb3A6ICdhb0NvbHVtbnMnIH1cblx0XSxcblx0ZnVuY3Rpb24gKGksIG8pIHtcblx0XHREYXRhVGFibGUuZXh0LnNlbGVjdG9yW28udHlwZV0ucHVzaChmdW5jdGlvbiAoc2V0dGluZ3MsIG9wdHMsIGluZGV4ZXMpIHtcblx0XHRcdHZhciBzZWxlY3RlZCA9IG9wdHMuc2VsZWN0ZWQ7XG5cdFx0XHR2YXIgZGF0YTtcblx0XHRcdHZhciBvdXQgPSBbXTtcblxuXHRcdFx0aWYgKHNlbGVjdGVkICE9PSB0cnVlICYmIHNlbGVjdGVkICE9PSBmYWxzZSkge1xuXHRcdFx0XHRyZXR1cm4gaW5kZXhlcztcblx0XHRcdH1cblxuXHRcdFx0Zm9yICh2YXIgaSA9IDAsIGllbiA9IGluZGV4ZXMubGVuZ3RoOyBpIDwgaWVuOyBpKyspIHtcblx0XHRcdFx0ZGF0YSA9IHNldHRpbmdzW28ucHJvcF1baW5kZXhlc1tpXV07XG5cblx0XHRcdFx0aWYgKFxuXHRcdFx0XHRcdGRhdGEgJiYgKFxuXHRcdFx0XHRcdFx0KHNlbGVjdGVkID09PSB0cnVlICYmIGRhdGEuX3NlbGVjdF9zZWxlY3RlZCA9PT0gdHJ1ZSkgfHxcblx0XHRcdFx0XHRcdChzZWxlY3RlZCA9PT0gZmFsc2UgJiYgIWRhdGEuX3NlbGVjdF9zZWxlY3RlZClcblx0XHRcdFx0XHQpXG5cdFx0XHRcdCkge1xuXHRcdFx0XHRcdG91dC5wdXNoKGluZGV4ZXNbaV0pO1xuXHRcdFx0XHR9XG5cdFx0XHR9XG5cblx0XHRcdHJldHVybiBvdXQ7XG5cdFx0fSk7XG5cdH1cbik7XG5cbkRhdGFUYWJsZS5leHQuc2VsZWN0b3IuY2VsbC5wdXNoKGZ1bmN0aW9uIChzZXR0aW5ncywgb3B0cywgY2VsbHMpIHtcblx0dmFyIHNlbGVjdGVkID0gb3B0cy5zZWxlY3RlZDtcblx0dmFyIHJvd0RhdGE7XG5cdHZhciBvdXQgPSBbXTtcblxuXHRpZiAoc2VsZWN0ZWQgPT09IHVuZGVmaW5lZCkge1xuXHRcdHJldHVybiBjZWxscztcblx0fVxuXG5cdGZvciAodmFyIGkgPSAwLCBpZW4gPSBjZWxscy5sZW5ndGg7IGkgPCBpZW47IGkrKykge1xuXHRcdHJvd0RhdGEgPSBzZXR0aW5ncy5hb0RhdGFbY2VsbHNbaV0ucm93XTtcblxuXHRcdGlmIChcblx0XHRcdHJvd0RhdGEgJiYgKFxuXHRcdFx0XHQoc2VsZWN0ZWQgPT09IHRydWUgJiZcblx0XHRcdFx0XHRyb3dEYXRhLl9zZWxlY3RlZF9jZWxscyAmJlxuXHRcdFx0XHRcdHJvd0RhdGEuX3NlbGVjdGVkX2NlbGxzW2NlbGxzW2ldLmNvbHVtbl0gPT09IHRydWUpIHx8XG5cdFx0XHRcdChzZWxlY3RlZCA9PT0gZmFsc2UgJiZcblx0XHRcdFx0XHQoIXJvd0RhdGEuX3NlbGVjdGVkX2NlbGxzIHx8ICFyb3dEYXRhLl9zZWxlY3RlZF9jZWxsc1tjZWxsc1tpXS5jb2x1bW5dKSlcblx0XHRcdClcblx0XHQpIHtcblx0XHRcdG91dC5wdXNoKGNlbGxzW2ldKTtcblx0XHR9XG5cdH1cblxuXHRyZXR1cm4gb3V0O1xufSk7XG5cbi8qICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqXG4gKiBEYXRhVGFibGVzIEFQSVxuICpcbiAqIEZvciBjb21wbGV0ZSBkb2N1bWVudGF0aW9uLCBwbGVhc2UgcmVmZXIgdG8gdGhlIGRvY3MvYXBpIGRpcmVjdG9yeSBvciB0aGVcbiAqIERhdGFUYWJsZXMgc2l0ZVxuICovXG5cbi8vIExvY2FsIHZhcmlhYmxlcyB0byBpbXByb3ZlIGNvbXByZXNzaW9uXG52YXIgYXBpUmVnaXN0ZXIgPSBEYXRhVGFibGUuQXBpLnJlZ2lzdGVyO1xudmFyIGFwaVJlZ2lzdGVyUGx1cmFsID0gRGF0YVRhYmxlLkFwaS5yZWdpc3RlclBsdXJhbDtcblxuYXBpUmVnaXN0ZXIoJ3NlbGVjdCgpJywgZnVuY3Rpb24gKCkge1xuXHRyZXR1cm4gdGhpcy5pdGVyYXRvcigndGFibGUnLCBmdW5jdGlvbiAoY3R4KSB7XG5cdFx0RGF0YVRhYmxlLnNlbGVjdC5pbml0KG5ldyBEYXRhVGFibGUuQXBpKGN0eCkpO1xuXHR9KTtcbn0pO1xuXG5hcGlSZWdpc3Rlcignc2VsZWN0LmJsdXJhYmxlKCknLCBmdW5jdGlvbiAoZmxhZykge1xuXHRpZiAoZmxhZyA9PT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIHRoaXMuY29udGV4dFswXS5fc2VsZWN0LmJsdXJhYmxlO1xuXHR9XG5cblx0cmV0dXJuIHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCkge1xuXHRcdGN0eC5fc2VsZWN0LmJsdXJhYmxlID0gZmxhZztcblx0fSk7XG59KTtcblxuYXBpUmVnaXN0ZXIoJ3NlbGVjdC50b2dnbGVhYmxlKCknLCBmdW5jdGlvbiAoZmxhZykge1xuXHRpZiAoZmxhZyA9PT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIHRoaXMuY29udGV4dFswXS5fc2VsZWN0LnRvZ2dsZWFibGU7XG5cdH1cblxuXHRyZXR1cm4gdGhpcy5pdGVyYXRvcigndGFibGUnLCBmdW5jdGlvbiAoY3R4KSB7XG5cdFx0Y3R4Ll9zZWxlY3QudG9nZ2xlYWJsZSA9IGZsYWc7XG5cdH0pO1xufSk7XG5cbmFwaVJlZ2lzdGVyKCdzZWxlY3QuaW5mbygpJywgZnVuY3Rpb24gKGZsYWcpIHtcblx0aWYgKGZsYWcgPT09IHVuZGVmaW5lZCkge1xuXHRcdHJldHVybiB0aGlzLmNvbnRleHRbMF0uX3NlbGVjdC5pbmZvO1xuXHR9XG5cblx0cmV0dXJuIHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCkge1xuXHRcdGN0eC5fc2VsZWN0LmluZm8gPSBmbGFnO1xuXHR9KTtcbn0pO1xuXG5hcGlSZWdpc3Rlcignc2VsZWN0Lml0ZW1zKCknLCBmdW5jdGlvbiAoaXRlbXMpIHtcblx0aWYgKGl0ZW1zID09PSB1bmRlZmluZWQpIHtcblx0XHRyZXR1cm4gdGhpcy5jb250ZXh0WzBdLl9zZWxlY3QuaXRlbXM7XG5cdH1cblxuXHRyZXR1cm4gdGhpcy5pdGVyYXRvcigndGFibGUnLCBmdW5jdGlvbiAoY3R4KSB7XG5cdFx0Y3R4Ll9zZWxlY3QuaXRlbXMgPSBpdGVtcztcblxuXHRcdGV2ZW50VHJpZ2dlcihuZXcgRGF0YVRhYmxlLkFwaShjdHgpLCAnc2VsZWN0SXRlbXMnLCBbaXRlbXNdKTtcblx0fSk7XG59KTtcblxuLy8gVGFrZXMgZWZmZWN0IGZyb20gdGhlIF9uZXh0XyBzZWxlY3Rpb24uIE5vbmUgZGlzYWJsZXMgZnV0dXJlIHNlbGVjdGlvbiwgYnV0XG4vLyBkb2VzIG5vdCBjbGVhciB0aGUgY3VycmVudCBzZWxlY3Rpb24uIFVzZSB0aGUgYGRlc2VsZWN0YCBtZXRob2RzIGZvciB0aGF0XG5hcGlSZWdpc3Rlcignc2VsZWN0LnN0eWxlKCknLCBmdW5jdGlvbiAoc3R5bGUpIHtcblx0aWYgKHN0eWxlID09PSB1bmRlZmluZWQpIHtcblx0XHRyZXR1cm4gdGhpcy5jb250ZXh0WzBdLl9zZWxlY3Quc3R5bGU7XG5cdH1cblxuXHRyZXR1cm4gdGhpcy5pdGVyYXRvcigndGFibGUnLCBmdW5jdGlvbiAoY3R4KSB7XG5cdFx0aWYgKCFjdHguX3NlbGVjdCkge1xuXHRcdFx0RGF0YVRhYmxlLnNlbGVjdC5pbml0KG5ldyBEYXRhVGFibGUuQXBpKGN0eCkpO1xuXHRcdH1cblxuXHRcdGlmICghY3R4Ll9zZWxlY3RfaW5pdCkge1xuXHRcdFx0aW5pdChjdHgpO1xuXHRcdH1cblxuXHRcdGN0eC5fc2VsZWN0LnN0eWxlID0gc3R5bGU7XG5cblx0XHQvLyBBZGQgLyByZW1vdmUgbW91c2UgZXZlbnQgaGFuZGxlcnMuIFRoZXkgYXJlbid0IHJlcXVpcmVkIHdoZW4gb25seVxuXHRcdC8vIEFQSSBzZWxlY3Rpb24gaXMgYXZhaWxhYmxlXG5cdFx0dmFyIGR0ID0gbmV3IERhdGFUYWJsZS5BcGkoY3R4KTtcblx0XHRkaXNhYmxlTW91c2VTZWxlY3Rpb24oZHQpO1xuXG5cdFx0aWYgKHN0eWxlICE9PSAnYXBpJykge1xuXHRcdFx0ZW5hYmxlTW91c2VTZWxlY3Rpb24oZHQpO1xuXHRcdH1cblxuXHRcdGV2ZW50VHJpZ2dlcihuZXcgRGF0YVRhYmxlLkFwaShjdHgpLCAnc2VsZWN0U3R5bGUnLCBbc3R5bGVdKTtcblx0fSk7XG59KTtcblxuYXBpUmVnaXN0ZXIoJ3NlbGVjdC5zZWxlY3RvcigpJywgZnVuY3Rpb24gKHNlbGVjdG9yKSB7XG5cdGlmIChzZWxlY3RvciA9PT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIHRoaXMuY29udGV4dFswXS5fc2VsZWN0LnNlbGVjdG9yO1xuXHR9XG5cblx0cmV0dXJuIHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCkge1xuXHRcdGRpc2FibGVNb3VzZVNlbGVjdGlvbihuZXcgRGF0YVRhYmxlLkFwaShjdHgpKTtcblxuXHRcdGN0eC5fc2VsZWN0LnNlbGVjdG9yID0gc2VsZWN0b3I7XG5cblx0XHRpZiAoY3R4Ll9zZWxlY3Quc3R5bGUgIT09ICdhcGknKSB7XG5cdFx0XHRlbmFibGVNb3VzZVNlbGVjdGlvbihuZXcgRGF0YVRhYmxlLkFwaShjdHgpKTtcblx0XHR9XG5cdH0pO1xufSk7XG5cbmFwaVJlZ2lzdGVyKCdzZWxlY3QubGFzdCgpJywgZnVuY3Rpb24gKHNldCkge1xuXHRsZXQgY3R4ID0gdGhpcy5jb250ZXh0WzBdO1xuXG5cdGlmIChzZXQpIHtcblx0XHRjdHguX3NlbGVjdF9sYXN0Q2VsbCA9IHNldDtcblx0XHRyZXR1cm4gdGhpcztcblx0fVxuXG5cdHJldHVybiBjdHguX3NlbGVjdF9sYXN0Q2VsbDtcbn0pO1xuXG5hcGlSZWdpc3RlclBsdXJhbCgncm93cygpLnNlbGVjdCgpJywgJ3JvdygpLnNlbGVjdCgpJywgZnVuY3Rpb24gKHNlbGVjdCkge1xuXHR2YXIgYXBpID0gdGhpcztcblxuXHRpZiAoc2VsZWN0ID09PSBmYWxzZSkge1xuXHRcdHJldHVybiB0aGlzLmRlc2VsZWN0KCk7XG5cdH1cblxuXHR0aGlzLml0ZXJhdG9yKCdyb3cnLCBmdW5jdGlvbiAoY3R4LCBpZHgpIHtcblx0XHRjbGVhcihjdHgpO1xuXG5cdFx0Ly8gVGhlcmUgaXMgYSBnb29kIGFtb3VudCBvZiBrbm93bGVkZ2Ugb2YgRGF0YVRhYmxlcyBpbnRlcm5hbHMgaW5cblx0XHQvLyB0aGlzIGZ1bmN0aW9uLiBJdCBfY291bGRfIGJlIGRvbmUgd2l0aG91dCB0aGF0LCBidXQgaXQgd291bGQgaHVydFxuXHRcdC8vIHBlcmZvcm1hbmNlIChvciBEVCB3b3VsZCBuZWVkIG5ldyBBUElzIGZvciB0aGlzIHdvcmspXG5cdFx0dmFyIGR0RGF0YSA9IGN0eC5hb0RhdGFbaWR4XTtcblx0XHR2YXIgZHRDb2x1bW5zID0gY3R4LmFvQ29sdW1ucztcblxuXHRcdCQoZHREYXRhLm5UcikuYWRkQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHRkdERhdGEuX3NlbGVjdF9zZWxlY3RlZCA9IHRydWU7XG5cblx0XHRmb3IgKHZhciBpPTAgOyBpPGR0Q29sdW1ucy5sZW5ndGggOyBpKyspIHtcblx0XHRcdHZhciBjb2wgPSBkdENvbHVtbnNbaV07XG5cblx0XHRcdGlmIChjb2wuc1R5cGUgPT09ICdzZWxlY3QtY2hlY2tib3gnKSB7XG5cdFx0XHRcdC8vIE1ha2Ugc3VyZSB0aGUgY2hlY2tib3ggc2hvd3MgdGhlIHJpZ2h0IHN0YXRlXG5cdFx0XHRcdCQoJ2lucHV0LmR0LXNlbGVjdC1jaGVja2JveCcsIGR0RGF0YS5hbkNlbGxzW2ldKS5wcm9wKCdjaGVja2VkJywgdHJ1ZSk7XG5cblx0XHRcdFx0Ly8gSW52YWxpZGF0ZSB0aGUgc29ydCBkYXRhIGZvciB0aGlzIGNvbHVtblxuXHRcdFx0XHRkdERhdGEuX2FTb3J0RGF0YVtpXSA9IG51bGw7XG5cdFx0XHR9XG5cdFx0fVxuXHR9KTtcblxuXHR0aGlzLml0ZXJhdG9yKCd0YWJsZScsIGZ1bmN0aW9uIChjdHgsIGkpIHtcblx0XHRldmVudFRyaWdnZXIoYXBpLCAnc2VsZWN0JywgWydyb3cnLCBhcGlbaV1dLCB0cnVlKTtcblx0fSk7XG5cblx0cmV0dXJuIHRoaXM7XG59KTtcblxuYXBpUmVnaXN0ZXIoJ3JvdygpLnNlbGVjdGVkKCknLCBmdW5jdGlvbiAoKSB7XG5cdHZhciBjdHggPSB0aGlzLmNvbnRleHRbMF07XG5cblx0aWYgKGN0eCAmJiB0aGlzLmxlbmd0aCAmJiBjdHguYW9EYXRhW3RoaXNbMF1dICYmIGN0eC5hb0RhdGFbdGhpc1swXV0uX3NlbGVjdF9zZWxlY3RlZCkge1xuXHRcdHJldHVybiB0cnVlO1xuXHR9XG5cblx0cmV0dXJuIGZhbHNlO1xufSk7XG5cbmFwaVJlZ2lzdGVyUGx1cmFsKCdjb2x1bW5zKCkuc2VsZWN0KCknLCAnY29sdW1uKCkuc2VsZWN0KCknLCBmdW5jdGlvbiAoc2VsZWN0KSB7XG5cdHZhciBhcGkgPSB0aGlzO1xuXG5cdGlmIChzZWxlY3QgPT09IGZhbHNlKSB7XG5cdFx0cmV0dXJuIHRoaXMuZGVzZWxlY3QoKTtcblx0fVxuXG5cdHRoaXMuaXRlcmF0b3IoJ2NvbHVtbicsIGZ1bmN0aW9uIChjdHgsIGlkeCkge1xuXHRcdGNsZWFyKGN0eCk7XG5cblx0XHRjdHguYW9Db2x1bW5zW2lkeF0uX3NlbGVjdF9zZWxlY3RlZCA9IHRydWU7XG5cblx0XHR2YXIgY29sdW1uID0gbmV3IERhdGFUYWJsZS5BcGkoY3R4KS5jb2x1bW4oaWR4KTtcblxuXHRcdCQoY29sdW1uLmhlYWRlcigpKS5hZGRDbGFzcyhjdHguX3NlbGVjdC5jbGFzc05hbWUpO1xuXHRcdCQoY29sdW1uLmZvb3RlcigpKS5hZGRDbGFzcyhjdHguX3NlbGVjdC5jbGFzc05hbWUpO1xuXG5cdFx0Y29sdW1uLm5vZGVzKCkudG8kKCkuYWRkQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0fSk7XG5cblx0dGhpcy5pdGVyYXRvcigndGFibGUnLCBmdW5jdGlvbiAoY3R4LCBpKSB7XG5cdFx0ZXZlbnRUcmlnZ2VyKGFwaSwgJ3NlbGVjdCcsIFsnY29sdW1uJywgYXBpW2ldXSwgdHJ1ZSk7XG5cdH0pO1xuXG5cdHJldHVybiB0aGlzO1xufSk7XG5cbmFwaVJlZ2lzdGVyKCdjb2x1bW4oKS5zZWxlY3RlZCgpJywgZnVuY3Rpb24gKCkge1xuXHR2YXIgY3R4ID0gdGhpcy5jb250ZXh0WzBdO1xuXG5cdGlmIChjdHggJiYgdGhpcy5sZW5ndGggJiYgY3R4LmFvQ29sdW1uc1t0aGlzWzBdXSAmJiBjdHguYW9Db2x1bW5zW3RoaXNbMF1dLl9zZWxlY3Rfc2VsZWN0ZWQpIHtcblx0XHRyZXR1cm4gdHJ1ZTtcblx0fVxuXG5cdHJldHVybiBmYWxzZTtcbn0pO1xuXG5hcGlSZWdpc3RlclBsdXJhbCgnY2VsbHMoKS5zZWxlY3QoKScsICdjZWxsKCkuc2VsZWN0KCknLCBmdW5jdGlvbiAoc2VsZWN0KSB7XG5cdHZhciBhcGkgPSB0aGlzO1xuXG5cdGlmIChzZWxlY3QgPT09IGZhbHNlKSB7XG5cdFx0cmV0dXJuIHRoaXMuZGVzZWxlY3QoKTtcblx0fVxuXG5cdHRoaXMuaXRlcmF0b3IoJ2NlbGwnLCBmdW5jdGlvbiAoY3R4LCByb3dJZHgsIGNvbElkeCkge1xuXHRcdGNsZWFyKGN0eCk7XG5cblx0XHR2YXIgZGF0YSA9IGN0eC5hb0RhdGFbcm93SWR4XTtcblxuXHRcdGlmIChkYXRhLl9zZWxlY3RlZF9jZWxscyA9PT0gdW5kZWZpbmVkKSB7XG5cdFx0XHRkYXRhLl9zZWxlY3RlZF9jZWxscyA9IFtdO1xuXHRcdH1cblxuXHRcdGRhdGEuX3NlbGVjdGVkX2NlbGxzW2NvbElkeF0gPSB0cnVlO1xuXG5cdFx0aWYgKGRhdGEuYW5DZWxscykge1xuXHRcdFx0JChkYXRhLmFuQ2VsbHNbY29sSWR4XSkuYWRkQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHR9XG5cdH0pO1xuXG5cdHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCwgaSkge1xuXHRcdGV2ZW50VHJpZ2dlcihhcGksICdzZWxlY3QnLCBbJ2NlbGwnLCBhcGkuY2VsbHMoYXBpW2ldKS5pbmRleGVzKCkudG9BcnJheSgpXSwgdHJ1ZSk7XG5cdH0pO1xuXG5cdHJldHVybiB0aGlzO1xufSk7XG5cbmFwaVJlZ2lzdGVyKCdjZWxsKCkuc2VsZWN0ZWQoKScsIGZ1bmN0aW9uICgpIHtcblx0dmFyIGN0eCA9IHRoaXMuY29udGV4dFswXTtcblxuXHRpZiAoY3R4ICYmIHRoaXMubGVuZ3RoKSB7XG5cdFx0dmFyIHJvdyA9IGN0eC5hb0RhdGFbdGhpc1swXVswXS5yb3ddO1xuXG5cdFx0aWYgKHJvdyAmJiByb3cuX3NlbGVjdGVkX2NlbGxzICYmIHJvdy5fc2VsZWN0ZWRfY2VsbHNbdGhpc1swXVswXS5jb2x1bW5dKSB7XG5cdFx0XHRyZXR1cm4gdHJ1ZTtcblx0XHR9XG5cdH1cblxuXHRyZXR1cm4gZmFsc2U7XG59KTtcblxuYXBpUmVnaXN0ZXJQbHVyYWwoJ3Jvd3MoKS5kZXNlbGVjdCgpJywgJ3JvdygpLmRlc2VsZWN0KCknLCBmdW5jdGlvbiAoKSB7XG5cdHZhciBhcGkgPSB0aGlzO1xuXG5cdHRoaXMuaXRlcmF0b3IoJ3JvdycsIGZ1bmN0aW9uIChjdHgsIGlkeCkge1xuXHRcdC8vIExpa2UgdGhlIHNlbGVjdCBhY3Rpb24sIHRoaXMgaGFzIGEgbG90IG9mIGtub3dsZWRnZSBhYm91dCBEVCBpbnRlcm5hbGx5XG5cdFx0dmFyIGR0RGF0YSA9IGN0eC5hb0RhdGFbaWR4XTtcblx0XHR2YXIgZHRDb2x1bW5zID0gY3R4LmFvQ29sdW1ucztcblxuXHRcdCQoZHREYXRhLm5UcikucmVtb3ZlQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHRkdERhdGEuX3NlbGVjdF9zZWxlY3RlZCA9IGZhbHNlO1xuXHRcdGN0eC5fc2VsZWN0X2xhc3RDZWxsID0gbnVsbDtcblxuXHRcdGZvciAodmFyIGk9MCA7IGk8ZHRDb2x1bW5zLmxlbmd0aCA7IGkrKykge1xuXHRcdFx0dmFyIGNvbCA9IGR0Q29sdW1uc1tpXTtcblxuXHRcdFx0aWYgKGNvbC5zVHlwZSA9PT0gJ3NlbGVjdC1jaGVja2JveCcpIHtcblx0XHRcdFx0Ly8gTWFrZSBzdXJlIHRoZSBjaGVja2JveCBzaG93cyB0aGUgcmlnaHQgc3RhdGVcblx0XHRcdFx0JCgnaW5wdXQuZHQtc2VsZWN0LWNoZWNrYm94JywgZHREYXRhLmFuQ2VsbHNbaV0pLnByb3AoJ2NoZWNrZWQnLCBmYWxzZSk7XG5cblx0XHRcdFx0Ly8gSW52YWxpZGF0ZSB0aGUgc29ydCBkYXRhIGZvciB0aGlzIGNvbHVtblxuXHRcdFx0XHRkdERhdGEuX2FTb3J0RGF0YVtpXSA9IG51bGw7XG5cdFx0XHR9XG5cdFx0fVxuXHR9KTtcblxuXHR0aGlzLml0ZXJhdG9yKCd0YWJsZScsIGZ1bmN0aW9uIChjdHgsIGkpIHtcblx0XHRldmVudFRyaWdnZXIoYXBpLCAnZGVzZWxlY3QnLCBbJ3JvdycsIGFwaVtpXV0sIHRydWUpO1xuXHR9KTtcblxuXHRyZXR1cm4gdGhpcztcbn0pO1xuXG5hcGlSZWdpc3RlclBsdXJhbCgnY29sdW1ucygpLmRlc2VsZWN0KCknLCAnY29sdW1uKCkuZGVzZWxlY3QoKScsIGZ1bmN0aW9uICgpIHtcblx0dmFyIGFwaSA9IHRoaXM7XG5cblx0dGhpcy5pdGVyYXRvcignY29sdW1uJywgZnVuY3Rpb24gKGN0eCwgaWR4KSB7XG5cdFx0Y3R4LmFvQ29sdW1uc1tpZHhdLl9zZWxlY3Rfc2VsZWN0ZWQgPSBmYWxzZTtcblxuXHRcdHZhciBhcGkgPSBuZXcgRGF0YVRhYmxlLkFwaShjdHgpO1xuXHRcdHZhciBjb2x1bW4gPSBhcGkuY29sdW1uKGlkeCk7XG5cblx0XHQkKGNvbHVtbi5oZWFkZXIoKSkucmVtb3ZlQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHQkKGNvbHVtbi5mb290ZXIoKSkucmVtb3ZlQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblxuXHRcdC8vIE5lZWQgdG8gbG9vcCBvdmVyIGVhY2ggY2VsbCwgcmF0aGVyIHRoYW4ganVzdCB1c2luZ1xuXHRcdC8vIGBjb2x1bW4oKS5ub2RlcygpYCBhcyBjZWxscyB3aGljaCBhcmUgaW5kaXZpZHVhbGx5IHNlbGVjdGVkIHNob3VsZFxuXHRcdC8vIG5vdCBoYXZlIHRoZSBgc2VsZWN0ZWRgIGNsYXNzIHJlbW92ZWQgZnJvbSB0aGVtXG5cdFx0YXBpLmNlbGxzKG51bGwsIGlkeClcblx0XHRcdC5pbmRleGVzKClcblx0XHRcdC5lYWNoKGZ1bmN0aW9uIChjZWxsSWR4KSB7XG5cdFx0XHRcdHZhciBkYXRhID0gY3R4LmFvRGF0YVtjZWxsSWR4LnJvd107XG5cdFx0XHRcdHZhciBjZWxsU2VsZWN0ZWQgPSBkYXRhLl9zZWxlY3RlZF9jZWxscztcblxuXHRcdFx0XHRpZiAoZGF0YS5hbkNlbGxzICYmICghY2VsbFNlbGVjdGVkIHx8ICFjZWxsU2VsZWN0ZWRbY2VsbElkeC5jb2x1bW5dKSkge1xuXHRcdFx0XHRcdCQoZGF0YS5hbkNlbGxzW2NlbGxJZHguY29sdW1uXSkucmVtb3ZlQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHRcdFx0fVxuXHRcdFx0fSk7XG5cdH0pO1xuXG5cdHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCwgaSkge1xuXHRcdGV2ZW50VHJpZ2dlcihhcGksICdkZXNlbGVjdCcsIFsnY29sdW1uJywgYXBpW2ldXSwgdHJ1ZSk7XG5cdH0pO1xuXG5cdHJldHVybiB0aGlzO1xufSk7XG5cbmFwaVJlZ2lzdGVyUGx1cmFsKCdjZWxscygpLmRlc2VsZWN0KCknLCAnY2VsbCgpLmRlc2VsZWN0KCknLCBmdW5jdGlvbiAoKSB7XG5cdHZhciBhcGkgPSB0aGlzO1xuXG5cdHRoaXMuaXRlcmF0b3IoJ2NlbGwnLCBmdW5jdGlvbiAoY3R4LCByb3dJZHgsIGNvbElkeCkge1xuXHRcdHZhciBkYXRhID0gY3R4LmFvRGF0YVtyb3dJZHhdO1xuXG5cdFx0aWYgKGRhdGEuX3NlbGVjdGVkX2NlbGxzICE9PSB1bmRlZmluZWQpIHtcblx0XHRcdGRhdGEuX3NlbGVjdGVkX2NlbGxzW2NvbElkeF0gPSBmYWxzZTtcblx0XHR9XG5cblx0XHQvLyBSZW1vdmUgY2xhc3Mgb25seSBpZiB0aGUgY2VsbHMgZXhpc3QsIGFuZCB0aGUgY2VsbCBpcyBub3QgY29sdW1uXG5cdFx0Ly8gc2VsZWN0ZWQsIGluIHdoaWNoIGNhc2UgdGhlIGNsYXNzIHNob3VsZCByZW1haW4gKHNpbmNlIGl0IGlzIHNlbGVjdGVkXG5cdFx0Ly8gaW4gdGhlIGNvbHVtbilcblx0XHRpZiAoZGF0YS5hbkNlbGxzICYmICFjdHguYW9Db2x1bW5zW2NvbElkeF0uX3NlbGVjdF9zZWxlY3RlZCkge1xuXHRcdFx0JChkYXRhLmFuQ2VsbHNbY29sSWR4XSkucmVtb3ZlQ2xhc3MoY3R4Ll9zZWxlY3QuY2xhc3NOYW1lKTtcblx0XHR9XG5cdH0pO1xuXG5cdHRoaXMuaXRlcmF0b3IoJ3RhYmxlJywgZnVuY3Rpb24gKGN0eCwgaSkge1xuXHRcdGV2ZW50VHJpZ2dlcihhcGksICdkZXNlbGVjdCcsIFsnY2VsbCcsIGFwaVtpXV0sIHRydWUpO1xuXHR9KTtcblxuXHRyZXR1cm4gdGhpcztcbn0pO1xuXG4vKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogQnV0dG9uc1xuICovXG5mdW5jdGlvbiBpMThuKGxhYmVsLCBkZWYpIHtcblx0cmV0dXJuIGZ1bmN0aW9uIChkdCkge1xuXHRcdHJldHVybiBkdC5pMThuKCdidXR0b25zLicgKyBsYWJlbCwgZGVmKTtcblx0fTtcbn1cblxuLy8gQ29tbW9uIGV2ZW50cyB3aXRoIHN1aXRhYmxlIG5hbWVzcGFjZXNcbmZ1bmN0aW9uIG5hbWVzcGFjZWRFdmVudHMoY29uZmlnKSB7XG5cdHZhciB1bmlxdWUgPSBjb25maWcuX2V2ZW50TmFtZXNwYWNlO1xuXG5cdHJldHVybiAnZHJhdy5kdC5EVCcgKyB1bmlxdWUgKyAnIHNlbGVjdC5kdC5EVCcgKyB1bmlxdWUgKyAnIGRlc2VsZWN0LmR0LkRUJyArIHVuaXF1ZTtcbn1cblxuZnVuY3Rpb24gZW5hYmxlZChkdCwgY29uZmlnKSB7XG5cdGlmIChjb25maWcubGltaXRUby5pbmRleE9mKCdyb3dzJykgIT09IC0xICYmIGR0LnJvd3MoeyBzZWxlY3RlZDogdHJ1ZSB9KS5hbnkoKSkge1xuXHRcdHJldHVybiB0cnVlO1xuXHR9XG5cblx0aWYgKGNvbmZpZy5saW1pdFRvLmluZGV4T2YoJ2NvbHVtbnMnKSAhPT0gLTEgJiYgZHQuY29sdW1ucyh7IHNlbGVjdGVkOiB0cnVlIH0pLmFueSgpKSB7XG5cdFx0cmV0dXJuIHRydWU7XG5cdH1cblxuXHRpZiAoY29uZmlnLmxpbWl0VG8uaW5kZXhPZignY2VsbHMnKSAhPT0gLTEgJiYgZHQuY2VsbHMoeyBzZWxlY3RlZDogdHJ1ZSB9KS5hbnkoKSkge1xuXHRcdHJldHVybiB0cnVlO1xuXHR9XG5cblx0cmV0dXJuIGZhbHNlO1xufVxuXG52YXIgX2J1dHRvbk5hbWVzcGFjZSA9IDA7XG5cbiQuZXh0ZW5kKERhdGFUYWJsZS5leHQuYnV0dG9ucywge1xuXHRzZWxlY3RlZDoge1xuXHRcdHRleHQ6IGkxOG4oJ3NlbGVjdGVkJywgJ1NlbGVjdGVkJyksXG5cdFx0Y2xhc3NOYW1lOiAnYnV0dG9ucy1zZWxlY3RlZCcsXG5cdFx0bGltaXRUbzogWydyb3dzJywgJ2NvbHVtbnMnLCAnY2VsbHMnXSxcblx0XHRpbml0OiBmdW5jdGlvbiAoZHQsIG5vZGUsIGNvbmZpZykge1xuXHRcdFx0dmFyIHRoYXQgPSB0aGlzO1xuXHRcdFx0Y29uZmlnLl9ldmVudE5hbWVzcGFjZSA9ICcuc2VsZWN0JyArIF9idXR0b25OYW1lc3BhY2UrKztcblxuXHRcdFx0Ly8gLkRUIG5hbWVzcGFjZSBsaXN0ZW5lcnMgYXJlIHJlbW92ZWQgYnkgRGF0YVRhYmxlcyBhdXRvbWF0aWNhbGx5XG5cdFx0XHQvLyBvbiB0YWJsZSBkZXN0cm95XG5cdFx0XHRkdC5vbihuYW1lc3BhY2VkRXZlbnRzKGNvbmZpZyksIGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0dGhhdC5lbmFibGUoZW5hYmxlZChkdCwgY29uZmlnKSk7XG5cdFx0XHR9KTtcblxuXHRcdFx0dGhpcy5kaXNhYmxlKCk7XG5cdFx0fSxcblx0XHRkZXN0cm95OiBmdW5jdGlvbiAoZHQsIG5vZGUsIGNvbmZpZykge1xuXHRcdFx0ZHQub2ZmKGNvbmZpZy5fZXZlbnROYW1lc3BhY2UpO1xuXHRcdH1cblx0fSxcblx0c2VsZWN0ZWRTaW5nbGU6IHtcblx0XHR0ZXh0OiBpMThuKCdzZWxlY3RlZFNpbmdsZScsICdTZWxlY3RlZCBzaW5nbGUnKSxcblx0XHRjbGFzc05hbWU6ICdidXR0b25zLXNlbGVjdGVkLXNpbmdsZScsXG5cdFx0aW5pdDogZnVuY3Rpb24gKGR0LCBub2RlLCBjb25maWcpIHtcblx0XHRcdHZhciB0aGF0ID0gdGhpcztcblx0XHRcdGNvbmZpZy5fZXZlbnROYW1lc3BhY2UgPSAnLnNlbGVjdCcgKyBfYnV0dG9uTmFtZXNwYWNlKys7XG5cblx0XHRcdGR0Lm9uKG5hbWVzcGFjZWRFdmVudHMoY29uZmlnKSwgZnVuY3Rpb24gKCkge1xuXHRcdFx0XHR2YXIgY291bnQgPVxuXHRcdFx0XHRcdGR0LnJvd3MoeyBzZWxlY3RlZDogdHJ1ZSB9KS5mbGF0dGVuKCkubGVuZ3RoICtcblx0XHRcdFx0XHRkdC5jb2x1bW5zKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZmxhdHRlbigpLmxlbmd0aCArXG5cdFx0XHRcdFx0ZHQuY2VsbHMoeyBzZWxlY3RlZDogdHJ1ZSB9KS5mbGF0dGVuKCkubGVuZ3RoO1xuXG5cdFx0XHRcdHRoYXQuZW5hYmxlKGNvdW50ID09PSAxKTtcblx0XHRcdH0pO1xuXG5cdFx0XHR0aGlzLmRpc2FibGUoKTtcblx0XHR9LFxuXHRcdGRlc3Ryb3k6IGZ1bmN0aW9uIChkdCwgbm9kZSwgY29uZmlnKSB7XG5cdFx0XHRkdC5vZmYoY29uZmlnLl9ldmVudE5hbWVzcGFjZSk7XG5cdFx0fVxuXHR9LFxuXHRzZWxlY3RBbGw6IHtcblx0XHR0ZXh0OiBpMThuKCdzZWxlY3RBbGwnLCAnU2VsZWN0IGFsbCcpLFxuXHRcdGNsYXNzTmFtZTogJ2J1dHRvbnMtc2VsZWN0LWFsbCcsXG5cdFx0YWN0aW9uOiBmdW5jdGlvbiAoZSwgZHQsIG5vZGUsIGNvbmZpZykge1xuXHRcdFx0dmFyIGl0ZW1zID0gdGhpcy5zZWxlY3QuaXRlbXMoKTtcblx0XHRcdHZhciBtb2QgPSBjb25maWcuc2VsZWN0b3JNb2RpZmllcjtcblx0XHRcdFxuXHRcdFx0aWYgKG1vZCkge1xuXHRcdFx0XHRpZiAodHlwZW9mIG1vZCA9PT0gJ2Z1bmN0aW9uJykge1xuXHRcdFx0XHRcdG1vZCA9IG1vZC5jYWxsKGR0LCBlLCBkdCwgbm9kZSwgY29uZmlnKTtcblx0XHRcdFx0fVxuXG5cdFx0XHRcdHRoaXNbaXRlbXMgKyAncyddKG1vZCkuc2VsZWN0KCk7XG5cdFx0XHR9XG5cdFx0XHRlbHNlIHtcblx0XHRcdFx0dGhpc1tpdGVtcyArICdzJ10oKS5zZWxlY3QoKTtcblx0XHRcdH1cblx0XHR9XG5cdFx0Ly8gc2VsZWN0b3JNb2RpZmllciBjYW4gYmUgc3BlY2lmaWVkXG5cdH0sXG5cdHNlbGVjdE5vbmU6IHtcblx0XHR0ZXh0OiBpMThuKCdzZWxlY3ROb25lJywgJ0Rlc2VsZWN0IGFsbCcpLFxuXHRcdGNsYXNzTmFtZTogJ2J1dHRvbnMtc2VsZWN0LW5vbmUnLFxuXHRcdGFjdGlvbjogZnVuY3Rpb24gKCkge1xuXHRcdFx0Y2xlYXIodGhpcy5zZXR0aW5ncygpWzBdLCB0cnVlKTtcblx0XHR9LFxuXHRcdGluaXQ6IGZ1bmN0aW9uIChkdCwgbm9kZSwgY29uZmlnKSB7XG5cdFx0XHR2YXIgdGhhdCA9IHRoaXM7XG5cdFx0XHRjb25maWcuX2V2ZW50TmFtZXNwYWNlID0gJy5zZWxlY3QnICsgX2J1dHRvbk5hbWVzcGFjZSsrO1xuXG5cdFx0XHRkdC5vbihuYW1lc3BhY2VkRXZlbnRzKGNvbmZpZyksIGZ1bmN0aW9uICgpIHtcblx0XHRcdFx0dmFyIGNvdW50ID1cblx0XHRcdFx0XHRkdC5yb3dzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZmxhdHRlbigpLmxlbmd0aCArXG5cdFx0XHRcdFx0ZHQuY29sdW1ucyh7IHNlbGVjdGVkOiB0cnVlIH0pLmZsYXR0ZW4oKS5sZW5ndGggK1xuXHRcdFx0XHRcdGR0LmNlbGxzKHsgc2VsZWN0ZWQ6IHRydWUgfSkuZmxhdHRlbigpLmxlbmd0aDtcblxuXHRcdFx0XHR0aGF0LmVuYWJsZShjb3VudCA+IDApO1xuXHRcdFx0fSk7XG5cblx0XHRcdHRoaXMuZGlzYWJsZSgpO1xuXHRcdH0sXG5cdFx0ZGVzdHJveTogZnVuY3Rpb24gKGR0LCBub2RlLCBjb25maWcpIHtcblx0XHRcdGR0Lm9mZihjb25maWcuX2V2ZW50TmFtZXNwYWNlKTtcblx0XHR9XG5cdH0sXG5cdHNob3dTZWxlY3RlZDoge1xuXHRcdHRleHQ6IGkxOG4oJ3Nob3dTZWxlY3RlZCcsICdTaG93IG9ubHkgc2VsZWN0ZWQnKSxcblx0XHRjbGFzc05hbWU6ICdidXR0b25zLXNob3ctc2VsZWN0ZWQnLFxuXHRcdGFjdGlvbjogZnVuY3Rpb24gKGUsIGR0KSB7XG5cdFx0XHRpZiAoZHQuc2VhcmNoLmZpeGVkKCdkdC1zZWxlY3QnKSkge1xuXHRcdFx0XHQvLyBSZW1vdmUgZXhpc3RpbmcgZnVuY3Rpb25cblx0XHRcdFx0ZHQuc2VhcmNoLmZpeGVkKCdkdC1zZWxlY3QnLCBudWxsKTtcblxuXHRcdFx0XHR0aGlzLmFjdGl2ZShmYWxzZSk7XG5cdFx0XHR9XG5cdFx0XHRlbHNlIHtcblx0XHRcdFx0Ly8gVXNlIGEgZml4ZWQgZmlsdGVyaW5nIGZ1bmN0aW9uIHRvIG1hdGNoIG9uIHNlbGVjdGVkIHJvd3Ncblx0XHRcdFx0Ly8gVGhpcyBuZWVkcyB0byByZWZlcmVuY2UgdGhlIGludGVybmFsIGFvRGF0YSBzaW5jZSB0aGF0IGlzXG5cdFx0XHRcdC8vIHdoZXJlIFNlbGVjdCBzdG9yZXMgaXRzIHJlZmVyZW5jZSBmb3IgdGhlIHNlbGVjdGVkIHN0YXRlXG5cdFx0XHRcdHZhciBkYXRhU3JjID0gZHQuc2V0dGluZ3MoKVswXS5hb0RhdGE7XG5cblx0XHRcdFx0ZHQuc2VhcmNoLmZpeGVkKCdkdC1zZWxlY3QnLCBmdW5jdGlvbiAodGV4dCwgZGF0YSwgaWR4KSB7XG5cdFx0XHRcdFx0Ly8gX3NlbGVjdF9zZWxlY3RlZCBpcyBzZXQgYnkgU2VsZWN0IG9uIHRoZSBkYXRhIG9iamVjdCBmb3IgdGhlIHJvd1xuXHRcdFx0XHRcdHJldHVybiBkYXRhU3JjW2lkeF0uX3NlbGVjdF9zZWxlY3RlZDtcblx0XHRcdFx0fSk7XG5cblx0XHRcdFx0dGhpcy5hY3RpdmUodHJ1ZSk7XG5cdFx0XHR9XG5cblx0XHRcdGR0LmRyYXcoKTtcblx0XHR9XG5cdH1cbn0pO1xuXG4kLmVhY2goWydSb3cnLCAnQ29sdW1uJywgJ0NlbGwnXSwgZnVuY3Rpb24gKGksIGl0ZW0pIHtcblx0dmFyIGxjID0gaXRlbS50b0xvd2VyQ2FzZSgpO1xuXG5cdERhdGFUYWJsZS5leHQuYnV0dG9uc1snc2VsZWN0JyArIGl0ZW0gKyAncyddID0ge1xuXHRcdHRleHQ6IGkxOG4oJ3NlbGVjdCcgKyBpdGVtICsgJ3MnLCAnU2VsZWN0ICcgKyBsYyArICdzJyksXG5cdFx0Y2xhc3NOYW1lOiAnYnV0dG9ucy1zZWxlY3QtJyArIGxjICsgJ3MnLFxuXHRcdGFjdGlvbjogZnVuY3Rpb24gKCkge1xuXHRcdFx0dGhpcy5zZWxlY3QuaXRlbXMobGMpO1xuXHRcdH0sXG5cdFx0aW5pdDogZnVuY3Rpb24gKGR0KSB7XG5cdFx0XHR2YXIgdGhhdCA9IHRoaXM7XG5cblx0XHRcdGR0Lm9uKCdzZWxlY3RJdGVtcy5kdC5EVCcsIGZ1bmN0aW9uIChlLCBjdHgsIGl0ZW1zKSB7XG5cdFx0XHRcdHRoYXQuYWN0aXZlKGl0ZW1zID09PSBsYyk7XG5cdFx0XHR9KTtcblx0XHR9XG5cdH07XG59KTtcblxuRGF0YVRhYmxlLnR5cGUoJ3NlbGVjdC1jaGVja2JveCcsIHtcblx0Y2xhc3NOYW1lOiAnZHQtc2VsZWN0Jyxcblx0ZGV0ZWN0OiBmdW5jdGlvbiAoZGF0YSkge1xuXHRcdC8vIFJlbmRlcmluZyBmdW5jdGlvbiB3aWxsIHRlbGwgdXMgaWYgaXQgaXMgYSBjaGVja2JveCB0eXBlXG5cdFx0cmV0dXJuIGRhdGEgPT09ICdzZWxlY3QtY2hlY2tib3gnID8gZGF0YSA6IGZhbHNlO1xuXHR9LFxuXHRvcmRlcjoge1xuXHRcdHByZTogZnVuY3Rpb24gKGQpIHtcblx0XHRcdHJldHVybiBkID09PSAnWCcgPyAtMSA6IDA7XG5cdFx0fVxuXHR9XG59KTtcblxuJC5leHRlbmQodHJ1ZSwgRGF0YVRhYmxlLmRlZmF1bHRzLm9MYW5ndWFnZSwge1xuXHRzZWxlY3Q6IHtcblx0XHRhcmlhOiB7XG5cdFx0XHRyb3dDaGVja2JveDogJ1NlbGVjdCByb3cnXG5cdFx0fVxuXHR9XG59KTtcblxuRGF0YVRhYmxlLnJlbmRlci5zZWxlY3QgPSBmdW5jdGlvbiAodmFsdWVQcm9wLCBuYW1lUHJvcCkge1xuXHR2YXIgdmFsdWVGbiA9IHZhbHVlUHJvcCA/IERhdGFUYWJsZS51dGlsLmdldCh2YWx1ZVByb3ApIDogbnVsbDtcblx0dmFyIG5hbWVGbiA9IG5hbWVQcm9wID8gRGF0YVRhYmxlLnV0aWwuZ2V0KG5hbWVQcm9wKSA6IG51bGw7XG5cblx0cmV0dXJuIGZ1bmN0aW9uIChkYXRhLCB0eXBlLCByb3csIG1ldGEpIHtcblx0XHR2YXIgZHRSb3cgPSBtZXRhLnNldHRpbmdzLmFvRGF0YVttZXRhLnJvd107XG5cdFx0dmFyIHNlbGVjdGVkID0gZHRSb3cuX3NlbGVjdF9zZWxlY3RlZDtcblx0XHR2YXIgYXJpYUxhYmVsID0gbWV0YS5zZXR0aW5ncy5vTGFuZ3VhZ2Uuc2VsZWN0LmFyaWEucm93Q2hlY2tib3g7XG5cblx0XHRpZiAodHlwZSA9PT0gJ2Rpc3BsYXknKSB7XG5cdFx0XHRyZXR1cm4gJCgnPGlucHV0PicpXG5cdFx0XHRcdC5hdHRyKHtcblx0XHRcdFx0XHQnYXJpYS1sYWJlbCc6IGFyaWFMYWJlbCxcblx0XHRcdFx0XHRjbGFzczogJ2R0LXNlbGVjdC1jaGVja2JveCcsXG5cdFx0XHRcdFx0bmFtZTogbmFtZUZuID8gbmFtZUZuKHJvdykgOiBudWxsLFxuXHRcdFx0XHRcdHR5cGU6ICdjaGVja2JveCcsXG5cdFx0XHRcdFx0dmFsdWU6IHZhbHVlRm4gPyB2YWx1ZUZuKHJvdykgOiBudWxsLFxuXHRcdFx0XHRcdGNoZWNrZWQ6IHNlbGVjdGVkXG5cdFx0XHRcdH0pWzBdO1xuXHRcdH1cblx0XHRlbHNlIGlmICh0eXBlID09PSAndHlwZScpIHtcblx0XHRcdHJldHVybiAnc2VsZWN0LWNoZWNrYm94Jztcblx0XHR9XG5cdFx0ZWxzZSBpZiAodHlwZSA9PT0gJ2ZpbHRlcicpIHtcblx0XHRcdHJldHVybiAnJztcblx0XHR9XG5cblx0XHRyZXR1cm4gc2VsZWN0ZWQgPyAnWCcgOiAnJztcblx0fVxufVxuXG4vLyBMZWdhY3kgY2hlY2tib3ggb3JkZXJpbmdcbkRhdGFUYWJsZS5leHQub3JkZXJbJ3NlbGVjdC1jaGVja2JveCddID0gZnVuY3Rpb24gKHNldHRpbmdzLCBjb2wpIHtcblx0cmV0dXJuIHRoaXMuYXBpKClcblx0XHQuY29sdW1uKGNvbCwgeyBvcmRlcjogJ2luZGV4JyB9KVxuXHRcdC5ub2RlcygpXG5cdFx0Lm1hcChmdW5jdGlvbiAodGQpIHtcblx0XHRcdGlmIChzZXR0aW5ncy5fc2VsZWN0Lml0ZW1zID09PSAncm93Jykge1xuXHRcdFx0XHRyZXR1cm4gJCh0ZCkucGFyZW50KCkuaGFzQ2xhc3Moc2V0dGluZ3MuX3NlbGVjdC5jbGFzc05hbWUpO1xuXHRcdFx0fVxuXHRcdFx0ZWxzZSBpZiAoc2V0dGluZ3MuX3NlbGVjdC5pdGVtcyA9PT0gJ2NlbGwnKSB7XG5cdFx0XHRcdHJldHVybiAkKHRkKS5oYXNDbGFzcyhzZXR0aW5ncy5fc2VsZWN0LmNsYXNzTmFtZSk7XG5cdFx0XHR9XG5cdFx0XHRyZXR1cm4gZmFsc2U7XG5cdFx0fSk7XG59O1xuXG4kLmZuLkRhdGFUYWJsZS5zZWxlY3QgPSBEYXRhVGFibGUuc2VsZWN0O1xuXG4vKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKiAqICogKlxuICogSW5pdGlhbGlzYXRpb25cbiAqL1xuXG4vLyBEYXRhVGFibGVzIGNyZWF0aW9uIC0gY2hlY2sgaWYgc2VsZWN0IGhhcyBiZWVuIGRlZmluZWQgaW4gdGhlIG9wdGlvbnMuIE5vdGVcbi8vIHRoaXMgcmVxdWlyZWQgdGhhdCB0aGUgdGFibGUgYmUgaW4gdGhlIGRvY3VtZW50ISBJZiBpdCBpc24ndCB0aGVuIHNvbWV0aGluZ1xuLy8gbmVlZHMgdG8gdHJpZ2dlciB0aGlzIG1ldGhvZCB1bmZvcnR1bmF0ZWx5LiBUaGUgbmV4dCBtYWpvciByZWxlYXNlIG9mXG4vLyBEYXRhVGFibGVzIHdpbGwgcmV3b3JrIHRoZSBldmVudHMgYW5kIGFkZHJlc3MgdGhpcy5cbiQoZG9jdW1lbnQpLm9uKCdwcmVJbml0LmR0LmR0U2VsZWN0JywgZnVuY3Rpb24gKGUsIGN0eCkge1xuXHRpZiAoZS5uYW1lc3BhY2UgIT09ICdkdCcpIHtcblx0XHRyZXR1cm47XG5cdH1cblxuXHREYXRhVGFibGUuc2VsZWN0LmluaXQobmV3IERhdGFUYWJsZS5BcGkoY3R4KSk7XG59KTtcblxuXG5leHBvcnQgZGVmYXVsdCBEYXRhVGFibGU7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=