"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_datatables_net_js_dataTables_mjs"],{

/***/ "./node_modules/datatables.net/js/dataTables.mjs":
/*!*******************************************************!*\
  !*** ./node_modules/datatables.net/js/dataTables.mjs ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/*! DataTables 2.0.3
 * © SpryMedia Ltd - datatables.net/license
 */



// DataTables code uses $ internally, but we want to be able to
// reassign $ with the `use` method, so it is a regular var.
var $ = jquery__WEBPACK_IMPORTED_MODULE_0__;


var DataTable = function ( selector, options )
{
	// Check if called with a window or jQuery object for DOM less applications
	// This is for backwards compatibility
	if (DataTable.factory(selector, options)) {
		return DataTable;
	}

	// When creating with `new`, create a new DataTable, returning the API instance
	if (this instanceof DataTable) {
		return $(selector).DataTable(options);
	}
	else {
		// Argument switching
		options = selector;
	}

	var _that = this;
	var emptyInit = options === undefined;
	var len = this.length;

	if ( emptyInit ) {
		options = {};
	}

	// Method to get DT API instance from jQuery object
	this.api = function ()
	{
		return new _Api( this );
	};

	this.each(function() {
		// For each initialisation we want to give it a clean initialisation
		// object that can be bashed around
		var o = {};
		var oInit = len > 1 ? // optimisation for single table case
			_fnExtend( o, options, true ) :
			options;

		
		var i=0, iLen;
		var sId = this.getAttribute( 'id' );
		var bInitHandedOff = false;
		var defaults = DataTable.defaults;
		var $this = $(this);
		
		
		/* Sanity check */
		if ( this.nodeName.toLowerCase() != 'table' )
		{
			_fnLog( null, 0, 'Non-table node initialisation ('+this.nodeName+')', 2 );
			return;
		}
		
		$(this).trigger( 'options.dt', oInit );
		
		/* Backwards compatibility for the defaults */
		_fnCompatOpts( defaults );
		_fnCompatCols( defaults.column );
		
		/* Convert the camel-case defaults to Hungarian */
		_fnCamelToHungarian( defaults, defaults, true );
		_fnCamelToHungarian( defaults.column, defaults.column, true );
		
		/* Setting up the initialisation object */
		_fnCamelToHungarian( defaults, $.extend( oInit, $this.data() ), true );
		
		
		
		/* Check to see if we are re-initialising a table */
		var allSettings = DataTable.settings;
		for ( i=0, iLen=allSettings.length ; i<iLen ; i++ )
		{
			var s = allSettings[i];
		
			/* Base check on table node */
			if (
				s.nTable == this ||
				(s.nTHead && s.nTHead.parentNode == this) ||
				(s.nTFoot && s.nTFoot.parentNode == this)
			) {
				var bRetrieve = oInit.bRetrieve !== undefined ? oInit.bRetrieve : defaults.bRetrieve;
				var bDestroy = oInit.bDestroy !== undefined ? oInit.bDestroy : defaults.bDestroy;
		
				if ( emptyInit || bRetrieve )
				{
					return s.oInstance;
				}
				else if ( bDestroy )
				{
					new DataTable.Api(s).destroy();
					break;
				}
				else
				{
					_fnLog( s, 0, 'Cannot reinitialise DataTable', 3 );
					return;
				}
			}
		
			/* If the element we are initialising has the same ID as a table which was previously
			 * initialised, but the table nodes don't match (from before) then we destroy the old
			 * instance by simply deleting it. This is under the assumption that the table has been
			 * destroyed by other methods. Anyone using non-id selectors will need to do this manually
			 */
			if ( s.sTableId == this.id )
			{
				allSettings.splice( i, 1 );
				break;
			}
		}
		
		/* Ensure the table has an ID - required for accessibility */
		if ( sId === null || sId === "" )
		{
			sId = "DataTables_Table_"+(DataTable.ext._unique++);
			this.id = sId;
		}
		
		/* Create the settings object for this table and set some of the default parameters */
		var oSettings = $.extend( true, {}, DataTable.models.oSettings, {
			"sDestroyWidth": $this[0].style.width,
			"sInstance":     sId,
			"sTableId":      sId,
			colgroup: $('<colgroup>').prependTo(this),
			fastData: function (row, column, type) {
				return _fnGetCellData(oSettings, row, column, type);
			}
		} );
		oSettings.nTable = this;
		oSettings.oInit  = oInit;
		
		allSettings.push( oSettings );
		
		// Make a single API instance available for internal handling
		oSettings.api = new _Api( oSettings );
		
		// Need to add the instance after the instance after the settings object has been added
		// to the settings array, so we can self reference the table instance if more than one
		oSettings.oInstance = (_that.length===1) ? _that : $this.dataTable();
		
		// Backwards compatibility, before we apply all the defaults
		_fnCompatOpts( oInit );
		
		// If the length menu is given, but the init display length is not, use the length menu
		if ( oInit.aLengthMenu && ! oInit.iDisplayLength )
		{
			oInit.iDisplayLength = Array.isArray(oInit.aLengthMenu[0])
				? oInit.aLengthMenu[0][0]
				: $.isPlainObject( oInit.aLengthMenu[0] )
					? oInit.aLengthMenu[0].value
					: oInit.aLengthMenu[0];
		}
		
		// Apply the defaults and init options to make a single init object will all
		// options defined from defaults and instance options.
		oInit = _fnExtend( $.extend( true, {}, defaults ), oInit );
		
		
		// Map the initialisation options onto the settings object
		_fnMap( oSettings.oFeatures, oInit, [
			"bPaginate",
			"bLengthChange",
			"bFilter",
			"bSort",
			"bSortMulti",
			"bInfo",
			"bProcessing",
			"bAutoWidth",
			"bSortClasses",
			"bServerSide",
			"bDeferRender"
		] );
		_fnMap( oSettings, oInit, [
			"ajax",
			"fnFormatNumber",
			"sServerMethod",
			"aaSorting",
			"aaSortingFixed",
			"aLengthMenu",
			"sPaginationType",
			"iStateDuration",
			"bSortCellsTop",
			"iTabIndex",
			"sDom",
			"fnStateLoadCallback",
			"fnStateSaveCallback",
			"renderer",
			"searchDelay",
			"rowId",
			"caption",
			"layout",
			[ "iCookieDuration", "iStateDuration" ], // backwards compat
			[ "oSearch", "oPreviousSearch" ],
			[ "aoSearchCols", "aoPreSearchCols" ],
			[ "iDisplayLength", "_iDisplayLength" ]
		] );
		_fnMap( oSettings.oScroll, oInit, [
			[ "sScrollX", "sX" ],
			[ "sScrollXInner", "sXInner" ],
			[ "sScrollY", "sY" ],
			[ "bScrollCollapse", "bCollapse" ]
		] );
		_fnMap( oSettings.oLanguage, oInit, "fnInfoCallback" );
		
		/* Callback functions which are array driven */
		_fnCallbackReg( oSettings, 'aoDrawCallback',       oInit.fnDrawCallback );
		_fnCallbackReg( oSettings, 'aoStateSaveParams',    oInit.fnStateSaveParams );
		_fnCallbackReg( oSettings, 'aoStateLoadParams',    oInit.fnStateLoadParams );
		_fnCallbackReg( oSettings, 'aoStateLoaded',        oInit.fnStateLoaded );
		_fnCallbackReg( oSettings, 'aoRowCallback',        oInit.fnRowCallback );
		_fnCallbackReg( oSettings, 'aoRowCreatedCallback', oInit.fnCreatedRow );
		_fnCallbackReg( oSettings, 'aoHeaderCallback',     oInit.fnHeaderCallback );
		_fnCallbackReg( oSettings, 'aoFooterCallback',     oInit.fnFooterCallback );
		_fnCallbackReg( oSettings, 'aoInitComplete',       oInit.fnInitComplete );
		_fnCallbackReg( oSettings, 'aoPreDrawCallback',    oInit.fnPreDrawCallback );
		
		oSettings.rowIdFn = _fnGetObjectDataFn( oInit.rowId );
		
		/* Browser support detection */
		_fnBrowserDetect( oSettings );
		
		var oClasses = oSettings.oClasses;
		
		$.extend( oClasses, DataTable.ext.classes, oInit.oClasses );
		$this.addClass( oClasses.table );
		
		if (! oSettings.oFeatures.bPaginate) {
			oInit.iDisplayStart = 0;
		}
		
		if ( oSettings.iInitDisplayStart === undefined )
		{
			/* Display start point, taking into account the save saving */
			oSettings.iInitDisplayStart = oInit.iDisplayStart;
			oSettings._iDisplayStart = oInit.iDisplayStart;
		}
		
		/* Language definitions */
		var oLanguage = oSettings.oLanguage;
		$.extend( true, oLanguage, oInit.oLanguage );
		
		if ( oLanguage.sUrl )
		{
			/* Get the language definitions from a file - because this Ajax call makes the language
			 * get async to the remainder of this function we use bInitHandedOff to indicate that
			 * _fnInitialise will be fired by the returned Ajax handler, rather than the constructor
			 */
			$.ajax( {
				dataType: 'json',
				url: oLanguage.sUrl,
				success: function ( json ) {
					_fnCamelToHungarian( defaults.oLanguage, json );
					$.extend( true, oLanguage, json, oSettings.oInit.oLanguage );
		
					_fnCallbackFire( oSettings, null, 'i18n', [oSettings], true);
					_fnInitialise( oSettings );
				},
				error: function () {
					// Error occurred loading language file
					_fnLog( oSettings, 0, 'i18n file loading error', 21 );
		
					// continue on as best we can
					_fnInitialise( oSettings );
				}
			} );
			bInitHandedOff = true;
		}
		else {
			_fnCallbackFire( oSettings, null, 'i18n', [oSettings]);
		}
		
		/*
		 * Columns
		 * See if we should load columns automatically or use defined ones
		 */
		var columnsInit = [];
		var thead = this.getElementsByTagName('thead');
		var initHeaderLayout = _fnDetectHeader( oSettings, thead[0] );
		
		// If we don't have a columns array, then generate one with nulls
		if ( oInit.aoColumns ) {
			columnsInit = oInit.aoColumns;
		}
		else if ( initHeaderLayout.length ) {
			for ( i=0, iLen=initHeaderLayout[0].length ; i<iLen ; i++ ) {
				columnsInit.push( null );
			}
		}
		
		// Add the columns
		for ( i=0, iLen=columnsInit.length ; i<iLen ; i++ ) {
			_fnAddColumn( oSettings );
		}
		
		// Apply the column definitions
		_fnApplyColumnDefs( oSettings, oInit.aoColumnDefs, columnsInit, initHeaderLayout, function (iCol, oDef) {
			_fnColumnOptions( oSettings, iCol, oDef );
		} );
		
		/* HTML5 attribute detection - build an mData object automatically if the
		 * attributes are found
		 */
		var rowOne = $this.children('tbody').find('tr').eq(0);
		
		if ( rowOne.length ) {
			var a = function ( cell, name ) {
				return cell.getAttribute( 'data-'+name ) !== null ? name : null;
			};
		
			$( rowOne[0] ).children('th, td').each( function (i, cell) {
				var col = oSettings.aoColumns[i];
		
				if (! col) {
					_fnLog( oSettings, 0, 'Incorrect column count', 18 );
				}
		
				if ( col.mData === i ) {
					var sort = a( cell, 'sort' ) || a( cell, 'order' );
					var filter = a( cell, 'filter' ) || a( cell, 'search' );
		
					if ( sort !== null || filter !== null ) {
						col.mData = {
							_:      i+'.display',
							sort:   sort !== null   ? i+'.@data-'+sort   : undefined,
							type:   sort !== null   ? i+'.@data-'+sort   : undefined,
							filter: filter !== null ? i+'.@data-'+filter : undefined
						};
						col._isArrayHost = true;
		
						_fnColumnOptions( oSettings, i );
					}
				}
			} );
		}
		
		var features = oSettings.oFeatures;
		var loadedInit = function () {
			/*
			 * Sorting
			 * @todo For modularisation (1.11) this needs to do into a sort start up handler
			 */
		
			// If aaSorting is not defined, then we use the first indicator in asSorting
			// in case that has been altered, so the default sort reflects that option
			if ( oInit.aaSorting === undefined ) {
				var sorting = oSettings.aaSorting;
				for ( i=0, iLen=sorting.length ; i<iLen ; i++ ) {
					sorting[i][1] = oSettings.aoColumns[ i ].asSorting[0];
				}
			}
		
			/* Do a first pass on the sorting classes (allows any size changes to be taken into
			 * account, and also will apply sorting disabled classes if disabled
			 */
			_fnSortingClasses( oSettings );
		
			_fnCallbackReg( oSettings, 'aoDrawCallback', function () {
				if ( oSettings.bSorted || _fnDataSource( oSettings ) === 'ssp' || features.bDeferRender ) {
					_fnSortingClasses( oSettings );
				}
			} );
		
		
			/*
			 * Final init
			 * Cache the header, body and footer as required, creating them if needed
			 */
			var caption = $this.children('caption');
		
			if ( oSettings.caption ) {
				if ( caption.length === 0 ) {
					caption = $('<caption/>').appendTo( $this );
				}
		
				caption.html( oSettings.caption );
			}
		
			// Store the caption side, so we can remove the element from the document
			// when creating the element
			if (caption.length) {
				caption[0]._captionSide = caption.css('caption-side');
				oSettings.captionNode = caption[0];
			}
		
			if ( thead.length === 0 ) {
				thead = $('<thead/>').appendTo($this);
			}
			oSettings.nTHead = thead[0];
			$('tr', thead).addClass(oClasses.thead.row);
		
			var tbody = $this.children('tbody');
			if ( tbody.length === 0 ) {
				tbody = $('<tbody/>').insertAfter(thead);
			}
			oSettings.nTBody = tbody[0];
		
			var tfoot = $this.children('tfoot');
			if ( tfoot.length === 0 ) {
				// If we are a scrolling table, and no footer has been given, then we need to create
				// a tfoot element for the caption element to be appended to
				tfoot = $('<tfoot/>').appendTo($this);
			}
			oSettings.nTFoot = tfoot[0];
			$('tr', tfoot).addClass(oClasses.tfoot.row);
		
			// Check if there is data passing into the constructor
			if ( oInit.aaData ) {
				for ( i=0 ; i<oInit.aaData.length ; i++ ) {
					_fnAddData( oSettings, oInit.aaData[ i ] );
				}
			}
			else if ( _fnDataSource( oSettings ) == 'dom' ) {
				// Grab the data from the page
				_fnAddTr( oSettings, $(oSettings.nTBody).children('tr') );
			}
		
			/* Copy the data index array */
			oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();
		
			/* Initialisation complete - table can be drawn */
			oSettings.bInitialised = true;
		
			/* Check if we need to initialise the table (it might not have been handed off to the
			 * language processor)
			 */
			if ( bInitHandedOff === false ) {
				_fnInitialise( oSettings );
			}
		};
		
		/* Must be done after everything which can be overridden by the state saving! */
		_fnCallbackReg( oSettings, 'aoDrawCallback', _fnSaveState );
		
		if ( oInit.bStateSave )
		{
			features.bStateSave = true;
			_fnLoadState( oSettings, oInit, loadedInit );
		}
		else {
			loadedInit();
		}
		
	} );
	_that = null;
	return this;
};



/**
 * DataTables extensions
 * 
 * This namespace acts as a collection area for plug-ins that can be used to
 * extend DataTables capabilities. Indeed many of the build in methods
 * use this method to provide their own capabilities (sorting methods for
 * example).
 *
 * Note that this namespace is aliased to `jQuery.fn.dataTableExt` for legacy
 * reasons
 *
 *  @namespace
 */
DataTable.ext = _ext = {
	/**
	 * Buttons. For use with the Buttons extension for DataTables. This is
	 * defined here so other extensions can define buttons regardless of load
	 * order. It is _not_ used by DataTables core.
	 *
	 *  @type object
	 *  @default {}
	 */
	buttons: {},


	/**
	 * Element class names
	 *
	 *  @type object
	 *  @default {}
	 */
	classes: {},


	/**
	 * DataTables build type (expanded by the download builder)
	 *
	 *  @type string
	 */
	builder: "-source-",


	/**
	 * Error reporting.
	 * 
	 * How should DataTables report an error. Can take the value 'alert',
	 * 'throw', 'none' or a function.
	 *
	 *  @type string|function
	 *  @default alert
	 */
	errMode: "alert",


	/**
	 * Legacy so v1 plug-ins don't throw js errors on load
	 */
	feature: [],

	/**
	 * Feature plug-ins.
	 * 
	 * This is an object of callbacks which provide the features for DataTables
	 * to be initialised via the `layout` option.
	 */
	features: {},


	/**
	 * Row searching.
	 * 
	 * This method of searching is complimentary to the default type based
	 * searching, and a lot more comprehensive as it allows you complete control
	 * over the searching logic. Each element in this array is a function
	 * (parameters described below) that is called for every row in the table,
	 * and your logic decides if it should be included in the searching data set
	 * or not.
	 *
	 * Searching functions have the following input parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{array|object}` Data for the row to be processed (same as the
	 *    original format that was passed in as the data source, or an array
	 *    from a DOM data source
	 * 3. `{int}` Row index ({@link DataTable.models.oSettings.aoData}), which
	 *    can be useful to retrieve the `TR` element if you need DOM interaction.
	 *
	 * And the following return is expected:
	 *
	 * * {boolean} Include the row in the searched result set (true) or not
	 *   (false)
	 *
	 * Note that as with the main search ability in DataTables, technically this
	 * is "filtering", since it is subtractive. However, for consistency in
	 * naming we call it searching here.
	 *
	 *  @type array
	 *  @default []
	 *
	 *  @example
	 *    // The following example shows custom search being applied to the
	 *    // fourth column (i.e. the data[3] index) based on two input values
	 *    // from the end-user, matching the data in a certain range.
	 *    $.fn.dataTable.ext.search.push(
	 *      function( settings, data, dataIndex ) {
	 *        var min = document.getElementById('min').value * 1;
	 *        var max = document.getElementById('max').value * 1;
	 *        var version = data[3] == "-" ? 0 : data[3]*1;
	 *
	 *        if ( min == "" && max == "" ) {
	 *          return true;
	 *        }
	 *        else if ( min == "" && version < max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && "" == max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && version < max ) {
	 *          return true;
	 *        }
	 *        return false;
	 *      }
	 *    );
	 */
	search: [],


	/**
	 * Selector extensions
	 *
	 * The `selector` option can be used to extend the options available for the
	 * selector modifier options (`selector-modifier` object data type) that
	 * each of the three built in selector types offer (row, column and cell +
	 * their plural counterparts). For example the Select extension uses this
	 * mechanism to provide an option to select only rows, columns and cells
	 * that have been marked as selected by the end user (`{selected: true}`),
	 * which can be used in conjunction with the existing built in selector
	 * options.
	 *
	 * Each property is an array to which functions can be pushed. The functions
	 * take three attributes:
	 *
	 * * Settings object for the host table
	 * * Options object (`selector-modifier` object type)
	 * * Array of selected item indexes
	 *
	 * The return is an array of the resulting item indexes after the custom
	 * selector has been applied.
	 *
	 *  @type object
	 */
	selector: {
		cell: [],
		column: [],
		row: []
	},


	/**
	 * Legacy configuration options. Enable and disable legacy options that
	 * are available in DataTables.
	 *
	 *  @type object
	 */
	legacy: {
		/**
		 * Enable / disable DataTables 1.9 compatible server-side processing
		 * requests
		 *
		 *  @type boolean
		 *  @default null
		 */
		ajax: null
	},


	/**
	 * Pagination plug-in methods.
	 * 
	 * Each entry in this object is a function and defines which buttons should
	 * be shown by the pagination rendering method that is used for the table:
	 * {@link DataTable.ext.renderer.pageButton}. The renderer addresses how the
	 * buttons are displayed in the document, while the functions here tell it
	 * what buttons to display. This is done by returning an array of button
	 * descriptions (what each button will do).
	 *
	 * Pagination types (the four built in options and any additional plug-in
	 * options defined here) can be used through the `paginationType`
	 * initialisation parameter.
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{int} page` The current page index
	 * 2. `{int} pages` The number of pages in the table
	 *
	 * Each function is expected to return an array where each element of the
	 * array can be one of:
	 *
	 * * `first` - Jump to first page when activated
	 * * `last` - Jump to last page when activated
	 * * `previous` - Show previous page when activated
	 * * `next` - Show next page when activated
	 * * `{int}` - Show page of the index given
	 * * `{array}` - A nested array containing the above elements to add a
	 *   containing 'DIV' element (might be useful for styling).
	 *
	 * Note that DataTables v1.9- used this object slightly differently whereby
	 * an object with two functions would be defined for each plug-in. That
	 * ability is still supported by DataTables 1.10+ to provide backwards
	 * compatibility, but this option of use is now decremented and no longer
	 * documented in DataTables 1.10+.
	 *
	 *  @type object
	 *  @default {}
	 *
	 *  @example
	 *    // Show previous, next and current page buttons only
	 *    $.fn.dataTableExt.oPagination.current = function ( page, pages ) {
	 *      return [ 'previous', page, 'next' ];
	 *    };
	 */
	pager: {},


	renderer: {
		pageButton: {},
		header: {}
	},


	/**
	 * Ordering plug-ins - custom data source
	 * 
	 * The extension options for ordering of data available here is complimentary
	 * to the default type based ordering that DataTables typically uses. It
	 * allows much greater control over the the data that is being used to
	 * order a column, but is necessarily therefore more complex.
	 * 
	 * This type of ordering is useful if you want to do ordering based on data
	 * live from the DOM (for example the contents of an 'input' element) rather
	 * than just the static string that DataTables knows of.
	 * 
	 * The way these plug-ins work is that you create an array of the values you
	 * wish to be ordering for the column in question and then return that
	 * array. The data in the array much be in the index order of the rows in
	 * the table (not the currently ordering order!). Which order data gathering
	 * function is run here depends on the `dt-init columns.orderDataType`
	 * parameter that is used for the column (if any).
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{int}` Target column index
	 *
	 * Each function is expected to return an array:
	 *
	 * * `{array}` Data for the column to be ordering upon
	 *
	 *  @type array
	 *
	 *  @example
	 *    // Ordering using `input` node values
	 *    $.fn.dataTable.ext.order['dom-text'] = function  ( settings, col )
	 *    {
	 *      return this.api().column( col, {order:'index'} ).nodes().map( function ( td, i ) {
	 *        return $('input', td).val();
	 *      } );
	 *    }
	 */
	order: {},


	/**
	 * Type based plug-ins.
	 *
	 * Each column in DataTables has a type assigned to it, either by automatic
	 * detection or by direct assignment using the `type` option for the column.
	 * The type of a column will effect how it is ordering and search (plug-ins
	 * can also make use of the column type if required).
	 *
	 * @namespace
	 */
	type: {
		/**
		 * Automatic column class assignment
		 */
		className: {},

		/**
		 * Type detection functions.
		 *
		 * The functions defined in this object are used to automatically detect
		 * a column's type, making initialisation of DataTables super easy, even
		 * when complex data is in the table.
		 *
		 * The functions defined take two parameters:
		 *
	     *  1. `{*}` Data from the column cell to be analysed
	     *  2. `{settings}` DataTables settings object. This can be used to
	     *     perform context specific type detection - for example detection
	     *     based on language settings such as using a comma for a decimal
	     *     place. Generally speaking the options from the settings will not
	     *     be required
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Data type detected, or null if unknown (and thus
		 *   pass it on to the other type detection functions.
		 *
		 *  @type array
		 *
		 *  @example
		 *    // Currency type detection plug-in:
		 *    $.fn.dataTable.ext.type.detect.push(
		 *      function ( data, settings ) {
		 *        // Check the numeric part
		 *        if ( ! data.substring(1).match(/[0-9]/) ) {
		 *          return null;
		 *        }
		 *
		 *        // Check prefixed by currency
		 *        if ( data.charAt(0) == '$' || data.charAt(0) == '&pound;' ) {
		 *          return 'currency';
		 *        }
		 *        return null;
		 *      }
		 *    );
		 */
		detect: [],

		/**
		 * Automatic renderer assignment
		 */
		render: {},


		/**
		 * Type based search formatting.
		 *
		 * The type based searching functions can be used to pre-format the
		 * data to be search on. For example, it can be used to strip HTML
		 * tags or to de-format telephone numbers for numeric only searching.
		 *
		 * Note that is a search is not defined for a column of a given type,
		 * no search formatting will be performed.
		 * 
		 * Pre-processing of searching data plug-ins - When you assign the sType
		 * for a column (or have it automatically detected for you by DataTables
		 * or a type detection plug-in), you will typically be using this for
		 * custom sorting, but it can also be used to provide custom searching
		 * by allowing you to pre-processing the data and returning the data in
		 * the format that should be searched upon. This is done by adding
		 * functions this object with a parameter name which matches the sType
		 * for that target column. This is the corollary of <i>afnSortData</i>
		 * for searching data.
		 *
		 * The functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for searching
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Formatted string that will be used for the searching.
		 *
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    $.fn.dataTable.ext.type.search['title-numeric'] = function ( d ) {
		 *      return d.replace(/\n/g," ").replace( /<.*?>/g, "" );
		 *    }
		 */
		search: {},


		/**
		 * Type based ordering.
		 *
		 * The column type tells DataTables what ordering to apply to the table
		 * when a column is sorted upon. The order for each type that is defined,
		 * is defined by the functions available in this object.
		 *
		 * Each ordering option can be described by three properties added to
		 * this object:
		 *
		 * * `{type}-pre` - Pre-formatting function
		 * * `{type}-asc` - Ascending order function
		 * * `{type}-desc` - Descending order function
		 *
		 * All three can be used together, only `{type}-pre` or only
		 * `{type}-asc` and `{type}-desc` together. It is generally recommended
		 * that only `{type}-pre` is used, as this provides the optimal
		 * implementation in terms of speed, although the others are provided
		 * for compatibility with existing Javascript sort functions.
		 *
		 * `{type}-pre`: Functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for ordering
		 *
		 * And return:
		 *
		 * * `{*}` Data to be sorted upon
		 *
		 * `{type}-asc` and `{type}-desc`: Functions are typical Javascript sort
		 * functions, taking two parameters:
		 *
	     *  1. `{*}` Data to compare to the second parameter
	     *  2. `{*}` Data to compare to the first parameter
		 *
		 * And returning:
		 *
		 * * `{*}` Ordering match: <0 if first parameter should be sorted lower
		 *   than the second parameter, ===0 if the two parameters are equal and
		 *   >0 if the first parameter should be sorted height than the second
		 *   parameter.
		 * 
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    // Numeric ordering of formatted numbers with a pre-formatter
		 *    $.extend( $.fn.dataTable.ext.type.order, {
		 *      "string-pre": function(x) {
		 *        a = (a === "-" || a === "") ? 0 : a.replace( /[^\d\-\.]/g, "" );
		 *        return parseFloat( a );
		 *      }
		 *    } );
		 *
		 *  @example
		 *    // Case-sensitive string ordering, with no pre-formatting method
		 *    $.extend( $.fn.dataTable.ext.order, {
		 *      "string-case-asc": function(x,y) {
		 *        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		 *      },
		 *      "string-case-desc": function(x,y) {
		 *        return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		 *      }
		 *    } );
		 */
		order: {}
	},

	/**
	 * Unique DataTables instance counter
	 *
	 * @type int
	 * @private
	 */
	_unique: 0,


	//
	// Depreciated
	// The following properties are retained for backwards compatibility only.
	// The should not be used in new projects and will be removed in a future
	// version
	//

	/**
	 * Version check function.
	 *  @type function
	 *  @depreciated Since 1.10
	 */
	fnVersionCheck: DataTable.fnVersionCheck,


	/**
	 * Index for what 'this' index API functions should use
	 *  @type int
	 *  @deprecated Since v1.10
	 */
	iApiIndex: 0,


	/**
	 * Software version
	 *  @type string
	 *  @deprecated Since v1.10
	 */
	sVersion: DataTable.version
};


//
// Backwards compatibility. Alias to pre 1.10 Hungarian notation counter parts
//
$.extend( _ext, {
	afnFiltering: _ext.search,
	aTypes:       _ext.type.detect,
	ofnSearch:    _ext.type.search,
	oSort:        _ext.type.order,
	afnSortData:  _ext.order,
	aoFeatures:   _ext.feature,
	oStdClasses:  _ext.classes,
	oPagination:  _ext.pager
} );


$.extend( DataTable.ext.classes, {
	container: 'dt-container',
	empty: {
		row: 'dt-empty'
	},
	info: {
		container: 'dt-info'
	},
	length: {
		container: 'dt-length',
		select: 'dt-input'
	},
	order: {
		canAsc: 'dt-orderable-asc',
		canDesc: 'dt-orderable-desc',
		isAsc: 'dt-ordering-asc',
		isDesc: 'dt-ordering-desc',
		none: 'dt-orderable-none',
		position: 'sorting_'
	},
	processing: {
		container: 'dt-processing'
	},
	scrolling: {
		body: 'dt-scroll-body',
		container: 'dt-scroll',
		footer: {
			self: 'dt-scroll-foot',
			inner: 'dt-scroll-footInner'
		},
		header: {
			self: 'dt-scroll-head',
			inner: 'dt-scroll-headInner'
		}
	},
	search: {
		container: 'dt-search',
		input: 'dt-input'
	},
	table: 'dataTable',	
	tbody: {
		cell: '',
		row: ''
	},
	thead: {
		cell: '',
		row: ''
	},
	tfoot: {
		cell: '',
		row: ''
	},
	paging: {
		active: 'current',
		button: 'dt-paging-button',
		container: 'dt-paging',
		disabled: 'disabled'
	}
} );


/*
 * It is useful to have variables which are scoped locally so only the
 * DataTables functions can access them and they don't leak into global space.
 * At the same time these functions are often useful over multiple files in the
 * core and API, so we list, or at least document, all variables which are used
 * by DataTables as private variables here. This also ensures that there is no
 * clashing of variable names and that they can easily referenced for reuse.
 */


// Defined else where
//  _selector_run
//  _selector_opts
//  _selector_row_indexes

var _ext; // DataTable.ext
var _Api; // DataTable.Api
var _api_register; // DataTable.Api.register
var _api_registerPlural; // DataTable.Api.registerPlural

var _re_dic = {};
var _re_new_lines = /[\r\n\u2028]/g;
var _re_html = /<.*?>/g;

// This is not strict ISO8601 - Date.parse() is quite lax, although
// implementations differ between browsers.
var _re_date = /^\d{2,4}[./-]\d{1,2}[./-]\d{1,2}([T ]{1}\d{1,2}[:.]\d{2}([.:]\d{2})?)?$/;

// Escape regular expression special characters
var _re_escape_regex = new RegExp( '(\\' + [ '/', '.', '*', '+', '?', '|', '(', ')', '[', ']', '{', '}', '\\', '$', '^', '-' ].join('|\\') + ')', 'g' );

// https://en.wikipedia.org/wiki/Foreign_exchange_market
// - \u20BD - Russian ruble.
// - \u20a9 - South Korean Won
// - \u20BA - Turkish Lira
// - \u20B9 - Indian Rupee
// - R - Brazil (R$) and South Africa
// - fr - Swiss Franc
// - kr - Swedish krona, Norwegian krone and Danish krone
// - \u2009 is thin space and \u202F is narrow no-break space, both used in many
// - Ƀ - Bitcoin
// - Ξ - Ethereum
//   standards as thousands separators.
var _re_formatted_numeric = /['\u00A0,$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfkɃΞ]/gi;


var _empty = function ( d ) {
	return !d || d === true || d === '-' ? true : false;
};


var _intVal = function ( s ) {
	var integer = parseInt( s, 10 );
	return !isNaN(integer) && isFinite(s) ? integer : null;
};

// Convert from a formatted number with characters other than `.` as the
// decimal place, to a Javascript number
var _numToDecimal = function ( num, decimalPoint ) {
	// Cache created regular expressions for speed as this function is called often
	if ( ! _re_dic[ decimalPoint ] ) {
		_re_dic[ decimalPoint ] = new RegExp( _fnEscapeRegex( decimalPoint ), 'g' );
	}
	return typeof num === 'string' && decimalPoint !== '.' ?
		num.replace( /\./g, '' ).replace( _re_dic[ decimalPoint ], '.' ) :
		num;
};


var _isNumber = function ( d, decimalPoint, formatted ) {
	var type = typeof d;
	var strType = type === 'string';

	if ( type === 'number' || type === 'bigint') {
		return true;
	}

	// If empty return immediately so there must be a number if it is a
	// formatted string (this stops the string "k", or "kr", etc being detected
	// as a formatted number for currency
	if ( _empty( d ) ) {
		return true;
	}

	if ( decimalPoint && strType ) {
		d = _numToDecimal( d, decimalPoint );
	}

	if ( formatted && strType ) {
		d = d.replace( _re_formatted_numeric, '' );
	}

	return !isNaN( parseFloat(d) ) && isFinite( d );
};


// A string without HTML in it can be considered to be HTML still
var _isHtml = function ( d ) {
	return _empty( d ) || typeof d === 'string';
};

// Is a string a number surrounded by HTML?
var _htmlNumeric = function ( d, decimalPoint, formatted ) {
	if ( _empty( d ) ) {
		return true;
	}

	// input and select strings mean that this isn't just a number
	if (typeof d === 'string' && d.match(/<(input|select)/i)) {
		return null;
	}

	var html = _isHtml( d );
	return ! html ?
		null :
		_isNumber( _stripHtml( d ), decimalPoint, formatted ) ?
			true :
			null;
};


var _pluck = function ( a, prop, prop2 ) {
	var out = [];
	var i=0, ien=a.length;

	// Could have the test in the loop for slightly smaller code, but speed
	// is essential here
	if ( prop2 !== undefined ) {
		for ( ; i<ien ; i++ ) {
			if ( a[i] && a[i][ prop ] ) {
				out.push( a[i][ prop ][ prop2 ] );
			}
		}
	}
	else {
		for ( ; i<ien ; i++ ) {
			if ( a[i] ) {
				out.push( a[i][ prop ] );
			}
		}
	}

	return out;
};


// Basically the same as _pluck, but rather than looping over `a` we use `order`
// as the indexes to pick from `a`
var _pluck_order = function ( a, order, prop, prop2 )
{
	var out = [];
	var i=0, ien=order.length;

	// Could have the test in the loop for slightly smaller code, but speed
	// is essential here
	if ( prop2 !== undefined ) {
		for ( ; i<ien ; i++ ) {
			if ( a[ order[i] ][ prop ] ) {
				out.push( a[ order[i] ][ prop ][ prop2 ] );
			}
		}
	}
	else {
		for ( ; i<ien ; i++ ) {
			if ( a[ order[i] ] ) {
				out.push( a[ order[i] ][ prop ] );
			}
		}
	}

	return out;
};


var _range = function ( len, start )
{
	var out = [];
	var end;

	if ( start === undefined ) {
		start = 0;
		end = len;
	}
	else {
		end = start;
		start = len;
	}

	for ( var i=start ; i<end ; i++ ) {
		out.push( i );
	}

	return out;
};


var _removeEmpty = function ( a )
{
	var out = [];

	for ( var i=0, ien=a.length ; i<ien ; i++ ) {
		if ( a[i] ) { // careful - will remove all falsy values!
			out.push( a[i] );
		}
	}

	return out;
};

// Replaceable function in api.util
var _stripHtml = function ( d ) {
	return d
		.replace( _re_html, '' ) // Complete tags
		.replace(/<script/i, ''); // Safety for incomplete script tag
};

// Replaceable function in api.util
var _escapeHtml = function ( d ) {
	if (Array.isArray(d)) {
		d = d.join(',');
	}

	return typeof d === 'string' ?
		d
			.replace(/&/g, '&amp;')
			.replace(/</g, '&lt;')
			.replace(/>/g, '&gt;')
			.replace(/"/g, '&quot;') :
		d;
};

// Remove diacritics from a string by decomposing it and then removing
// non-ascii characters
var _normalize = function (str, both) {
	if (typeof str !== 'string') {
		return str;
	}

	// It is faster to just run `normalize` than it is to check if
	// we need to with a regex!
	var res = str.normalize("NFD");

	// Equally, here we check if a regex is needed or not
	return res.length !== str.length
		? (both === true ? str + ' ' : '' ) + res.replace(/[\u0300-\u036f]/g, "")
		: res;
}

/**
 * Determine if all values in the array are unique. This means we can short
 * cut the _unique method at the cost of a single loop. A sorted array is used
 * to easily check the values.
 *
 * @param  {array} src Source array
 * @return {boolean} true if all unique, false otherwise
 * @ignore
 */
var _areAllUnique = function ( src ) {
	if ( src.length < 2 ) {
		return true;
	}

	var sorted = src.slice().sort();
	var last = sorted[0];

	for ( var i=1, ien=sorted.length ; i<ien ; i++ ) {
		if ( sorted[i] === last ) {
			return false;
		}

		last = sorted[i];
	}

	return true;
};


/**
 * Find the unique elements in a source array.
 *
 * @param  {array} src Source array
 * @return {array} Array of unique items
 * @ignore
 */
var _unique = function ( src )
{
	if (Array.from && Set) {
		return Array.from(new Set(src));
	}

	if ( _areAllUnique( src ) ) {
		return src.slice();
	}

	// A faster unique method is to use object keys to identify used values,
	// but this doesn't work with arrays or objects, which we must also
	// consider. See jsperf.app/compare-array-unique-versions/4 for more
	// information.
	var
		out = [],
		val,
		i, ien=src.length,
		j, k=0;

	again: for ( i=0 ; i<ien ; i++ ) {
		val = src[i];

		for ( j=0 ; j<k ; j++ ) {
			if ( out[j] === val ) {
				continue again;
			}
		}

		out.push( val );
		k++;
	}

	return out;
};

// Surprisingly this is faster than [].concat.apply
// https://jsperf.com/flatten-an-array-loop-vs-reduce/2
var _flatten = function (out, val) {
	if (Array.isArray(val)) {
		for (var i=0 ; i<val.length ; i++) {
			_flatten(out, val[i]);
		}
	}
	else {
		out.push(val);
	}

	return out;
}

// Similar to jQuery's addClass, but use classList.add
function _addClass(el, name) {
	if (name) {
		name.split(' ').forEach(function (n) {
			if (n) {
				// `add` does deduplication, so no need to check `contains`
				el.classList.add(n);
			}
		});
	}
}

/**
 * DataTables utility methods
 * 
 * This namespace provides helper methods that DataTables uses internally to
 * create a DataTable, but which are not exclusively used only for DataTables.
 * These methods can be used by extension authors to save the duplication of
 * code.
 *
 *  @namespace
 */
DataTable.util = {
	/**
	 * Return a string with diacritic characters decomposed
	 * @param {*} mixed Function or string to normalize
	 * @param {*} both Return original string and the normalized string
	 * @returns String or undefined
	 */
	diacritics: function (mixed, both) {
		var type = typeof mixed;

		if (type !== 'function') {
			return _normalize(mixed, both);
		}
		_normalize = mixed;
	},

	/**
	 * Debounce a function
	 *
	 * @param {function} fn Function to be called
	 * @param {integer} freq Call frequency in mS
	 * @return {function} Wrapped function
	 */
	debounce: function ( fn, timeout ) {
		var timer;

		return function () {
			var that = this;
			var args = arguments;

			clearTimeout(timer);

			timer = setTimeout( function () {
				fn.apply(that, args);
			}, timeout || 250 );
		};
	},

	/**
	 * Throttle the calls to a function. Arguments and context are maintained
	 * for the throttled function.
	 *
	 * @param {function} fn Function to be called
	 * @param {integer} freq Call frequency in mS
	 * @return {function} Wrapped function
	 */
	throttle: function ( fn, freq ) {
		var
			frequency = freq !== undefined ? freq : 200,
			last,
			timer;

		return function () {
			var
				that = this,
				now  = +new Date(),
				args = arguments;

			if ( last && now < last + frequency ) {
				clearTimeout( timer );

				timer = setTimeout( function () {
					last = undefined;
					fn.apply( that, args );
				}, frequency );
			}
			else {
				last = now;
				fn.apply( that, args );
			}
		};
	},

	/**
	 * Escape a string such that it can be used in a regular expression
	 *
	 *  @param {string} val string to escape
	 *  @returns {string} escaped string
	 */
	escapeRegex: function ( val ) {
		return val.replace( _re_escape_regex, '\\$1' );
	},

	/**
	 * Create a function that will write to a nested object or array
	 * @param {*} source JSON notation string
	 * @returns Write function
	 */
	set: function ( source ) {
		if ( $.isPlainObject( source ) ) {
			/* Unlike get, only the underscore (global) option is used for for
			 * setting data since we don't know the type here. This is why an object
			 * option is not documented for `mData` (which is read/write), but it is
			 * for `mRender` which is read only.
			 */
			return DataTable.util.set( source._ );
		}
		else if ( source === null ) {
			// Nothing to do when the data source is null
			return function () {};
		}
		else if ( typeof source === 'function' ) {
			return function (data, val, meta) {
				source( data, 'set', val, meta );
			};
		}
		else if (
			typeof source === 'string' && (source.indexOf('.') !== -1 ||
			source.indexOf('[') !== -1 || source.indexOf('(') !== -1)
		) {
			// Like the get, we need to get data from a nested object
			var setData = function (data, val, src) {
				var a = _fnSplitObjNotation( src ), b;
				var aLast = a[a.length-1];
				var arrayNotation, funcNotation, o, innerSrc;
	
				for ( var i=0, iLen=a.length-1 ; i<iLen ; i++ ) {
					// Protect against prototype pollution
					if (a[i] === '__proto__' || a[i] === 'constructor') {
						throw new Error('Cannot set prototype values');
					}
	
					// Check if we are dealing with an array notation request
					arrayNotation = a[i].match(__reArray);
					funcNotation = a[i].match(__reFn);
	
					if ( arrayNotation ) {
						a[i] = a[i].replace(__reArray, '');
						data[ a[i] ] = [];
	
						// Get the remainder of the nested object to set so we can recurse
						b = a.slice();
						b.splice( 0, i+1 );
						innerSrc = b.join('.');
	
						// Traverse each entry in the array setting the properties requested
						if ( Array.isArray( val ) ) {
							for ( var j=0, jLen=val.length ; j<jLen ; j++ ) {
								o = {};
								setData( o, val[j], innerSrc );
								data[ a[i] ].push( o );
							}
						}
						else {
							// We've been asked to save data to an array, but it
							// isn't array data to be saved. Best that can be done
							// is to just save the value.
							data[ a[i] ] = val;
						}
	
						// The inner call to setData has already traversed through the remainder
						// of the source and has set the data, thus we can exit here
						return;
					}
					else if ( funcNotation ) {
						// Function call
						a[i] = a[i].replace(__reFn, '');
						data = data[ a[i] ]( val );
					}
	
					// If the nested object doesn't currently exist - since we are
					// trying to set the value - create it
					if ( data[ a[i] ] === null || data[ a[i] ] === undefined ) {
						data[ a[i] ] = {};
					}
					data = data[ a[i] ];
				}
	
				// Last item in the input - i.e, the actual set
				if ( aLast.match(__reFn ) ) {
					// Function call
					data = data[ aLast.replace(__reFn, '') ]( val );
				}
				else {
					// If array notation is used, we just want to strip it and use the property name
					// and assign the value. If it isn't used, then we get the result we want anyway
					data[ aLast.replace(__reArray, '') ] = val;
				}
			};
	
			return function (data, val) { // meta is also passed in, but not used
				return setData( data, val, source );
			};
		}
		else {
			// Array or flat object mapping
			return function (data, val) { // meta is also passed in, but not used
				data[source] = val;
			};
		}
	},

	/**
	 * Create a function that will read nested objects from arrays, based on JSON notation
	 * @param {*} source JSON notation string
	 * @returns Value read
	 */
	get: function ( source ) {
		if ( $.isPlainObject( source ) ) {
			// Build an object of get functions, and wrap them in a single call
			var o = {};
			$.each( source, function (key, val) {
				if ( val ) {
					o[key] = DataTable.util.get( val );
				}
			} );
	
			return function (data, type, row, meta) {
				var t = o[type] || o._;
				return t !== undefined ?
					t(data, type, row, meta) :
					data;
			};
		}
		else if ( source === null ) {
			// Give an empty string for rendering / sorting etc
			return function (data) { // type, row and meta also passed, but not used
				return data;
			};
		}
		else if ( typeof source === 'function' ) {
			return function (data, type, row, meta) {
				return source( data, type, row, meta );
			};
		}
		else if (
			typeof source === 'string' && (source.indexOf('.') !== -1 ||
			source.indexOf('[') !== -1 || source.indexOf('(') !== -1)
		) {
			/* If there is a . in the source string then the data source is in a
			 * nested object so we loop over the data for each level to get the next
			 * level down. On each loop we test for undefined, and if found immediately
			 * return. This allows entire objects to be missing and sDefaultContent to
			 * be used if defined, rather than throwing an error
			 */
			var fetchData = function (data, type, src) {
				var arrayNotation, funcNotation, out, innerSrc;
	
				if ( src !== "" ) {
					var a = _fnSplitObjNotation( src );
	
					for ( var i=0, iLen=a.length ; i<iLen ; i++ ) {
						// Check if we are dealing with special notation
						arrayNotation = a[i].match(__reArray);
						funcNotation = a[i].match(__reFn);
	
						if ( arrayNotation ) {
							// Array notation
							a[i] = a[i].replace(__reArray, '');
	
							// Condition allows simply [] to be passed in
							if ( a[i] !== "" ) {
								data = data[ a[i] ];
							}
							out = [];
	
							// Get the remainder of the nested object to get
							a.splice( 0, i+1 );
							innerSrc = a.join('.');
	
							// Traverse each entry in the array getting the properties requested
							if ( Array.isArray( data ) ) {
								for ( var j=0, jLen=data.length ; j<jLen ; j++ ) {
									out.push( fetchData( data[j], type, innerSrc ) );
								}
							}
	
							// If a string is given in between the array notation indicators, that
							// is used to join the strings together, otherwise an array is returned
							var join = arrayNotation[0].substring(1, arrayNotation[0].length-1);
							data = (join==="") ? out : out.join(join);
	
							// The inner call to fetchData has already traversed through the remainder
							// of the source requested, so we exit from the loop
							break;
						}
						else if ( funcNotation ) {
							// Function call
							a[i] = a[i].replace(__reFn, '');
							data = data[ a[i] ]();
							continue;
						}
	
						if (data === null || data[ a[i] ] === null) {
							return null;
						}
						else if ( data === undefined || data[ a[i] ] === undefined ) {
							return undefined;
						}

						data = data[ a[i] ];
					}
				}
	
				return data;
			};
	
			return function (data, type) { // row and meta also passed, but not used
				return fetchData( data, type, source );
			};
		}
		else {
			// Array or flat object mapping
			return function (data) { // row and meta also passed, but not used
				return data[source];
			};
		}
	},

	stripHtml: function (mixed) {
		var type = typeof mixed;

		if (type === 'function') {
			_stripHtml = mixed;
			return;
		}
		else if (type === 'string') {
			return _stripHtml(mixed);
		}
		return mixed;
	},

	escapeHtml: function (mixed) {
		var type = typeof mixed;

		if (type === 'function') {
			_escapeHtml = mixed;
			return;
		}
		else if (type === 'string' || Array.isArray(mixed)) {
			return _escapeHtml(mixed);
		}
		return mixed;
	},

	unique: _unique
};



/**
 * Create a mapping object that allows camel case parameters to be looked up
 * for their Hungarian counterparts. The mapping is stored in a private
 * parameter called `_hungarianMap` which can be accessed on the source object.
 *  @param {object} o
 *  @memberof DataTable#oApi
 */
function _fnHungarianMap ( o )
{
	var
		hungarian = 'a aa ai ao as b fn i m o s ',
		match,
		newKey,
		map = {};

	$.each( o, function (key) {
		match = key.match(/^([^A-Z]+?)([A-Z])/);

		if ( match && hungarian.indexOf(match[1]+' ') !== -1 )
		{
			newKey = key.replace( match[0], match[2].toLowerCase() );
			map[ newKey ] = key;

			if ( match[1] === 'o' )
			{
				_fnHungarianMap( o[key] );
			}
		}
	} );

	o._hungarianMap = map;
}


/**
 * Convert from camel case parameters to Hungarian, based on a Hungarian map
 * created by _fnHungarianMap.
 *  @param {object} src The model object which holds all parameters that can be
 *    mapped.
 *  @param {object} user The object to convert from camel case to Hungarian.
 *  @param {boolean} force When set to `true`, properties which already have a
 *    Hungarian value in the `user` object will be overwritten. Otherwise they
 *    won't be.
 *  @memberof DataTable#oApi
 */
function _fnCamelToHungarian ( src, user, force )
{
	if ( ! src._hungarianMap ) {
		_fnHungarianMap( src );
	}

	var hungarianKey;

	$.each( user, function (key) {
		hungarianKey = src._hungarianMap[ key ];

		if ( hungarianKey !== undefined && (force || user[hungarianKey] === undefined) )
		{
			// For objects, we need to buzz down into the object to copy parameters
			if ( hungarianKey.charAt(0) === 'o' )
			{
				// Copy the camelCase options over to the hungarian
				if ( ! user[ hungarianKey ] ) {
					user[ hungarianKey ] = {};
				}
				$.extend( true, user[hungarianKey], user[key] );

				_fnCamelToHungarian( src[hungarianKey], user[hungarianKey], force );
			}
			else {
				user[hungarianKey] = user[ key ];
			}
		}
	} );
}

/**
 * Map one parameter onto another
 *  @param {object} o Object to map
 *  @param {*} knew The new parameter name
 *  @param {*} old The old parameter name
 */
var _fnCompatMap = function ( o, knew, old ) {
	if ( o[ knew ] !== undefined ) {
		o[ old ] = o[ knew ];
	}
};


/**
 * Provide backwards compatibility for the main DT options. Note that the new
 * options are mapped onto the old parameters, so this is an external interface
 * change only.
 *  @param {object} init Object to map
 */
function _fnCompatOpts ( init )
{
	_fnCompatMap( init, 'ordering',      'bSort' );
	_fnCompatMap( init, 'orderMulti',    'bSortMulti' );
	_fnCompatMap( init, 'orderClasses',  'bSortClasses' );
	_fnCompatMap( init, 'orderCellsTop', 'bSortCellsTop' );
	_fnCompatMap( init, 'order',         'aaSorting' );
	_fnCompatMap( init, 'orderFixed',    'aaSortingFixed' );
	_fnCompatMap( init, 'paging',        'bPaginate' );
	_fnCompatMap( init, 'pagingType',    'sPaginationType' );
	_fnCompatMap( init, 'pageLength',    'iDisplayLength' );
	_fnCompatMap( init, 'searching',     'bFilter' );

	// Boolean initialisation of x-scrolling
	if ( typeof init.sScrollX === 'boolean' ) {
		init.sScrollX = init.sScrollX ? '100%' : '';
	}
	if ( typeof init.scrollX === 'boolean' ) {
		init.scrollX = init.scrollX ? '100%' : '';
	}

	// Column search objects are in an array, so it needs to be converted
	// element by element
	var searchCols = init.aoSearchCols;

	if ( searchCols ) {
		for ( var i=0, ien=searchCols.length ; i<ien ; i++ ) {
			if ( searchCols[i] ) {
				_fnCamelToHungarian( DataTable.models.oSearch, searchCols[i] );
			}
		}
	}

	// Enable search delay if server-side processing is enabled
	if (init.serverSide && ! init.searchDelay) {
		init.searchDelay = 400;
	}
}


/**
 * Provide backwards compatibility for column options. Note that the new options
 * are mapped onto the old parameters, so this is an external interface change
 * only.
 *  @param {object} init Object to map
 */
function _fnCompatCols ( init )
{
	_fnCompatMap( init, 'orderable',     'bSortable' );
	_fnCompatMap( init, 'orderData',     'aDataSort' );
	_fnCompatMap( init, 'orderSequence', 'asSorting' );
	_fnCompatMap( init, 'orderDataType', 'sortDataType' );

	// orderData can be given as an integer
	var dataSort = init.aDataSort;
	if ( typeof dataSort === 'number' && ! Array.isArray( dataSort ) ) {
		init.aDataSort = [ dataSort ];
	}
}


/**
 * Browser feature detection for capabilities, quirks
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnBrowserDetect( settings )
{
	// We don't need to do this every time DataTables is constructed, the values
	// calculated are specific to the browser and OS configuration which we
	// don't expect to change between initialisations
	if ( ! DataTable.__browser ) {
		var browser = {};
		DataTable.__browser = browser;

		// Scrolling feature / quirks detection
		var n = $('<div/>')
			.css( {
				position: 'fixed',
				top: 0,
				left: -1 * window.pageXOffset, // allow for scrolling
				height: 1,
				width: 1,
				overflow: 'hidden'
			} )
			.append(
				$('<div/>')
					.css( {
						position: 'absolute',
						top: 1,
						left: 1,
						width: 100,
						overflow: 'scroll'
					} )
					.append(
						$('<div/>')
							.css( {
								width: '100%',
								height: 10
							} )
					)
			)
			.appendTo( 'body' );

		var outer = n.children();
		var inner = outer.children();

		// Get scrollbar width
		browser.barWidth = outer[0].offsetWidth - outer[0].clientWidth;

		// In rtl text layout, some browsers (most, but not all) will place the
		// scrollbar on the left, rather than the right.
		browser.bScrollbarLeft = Math.round( inner.offset().left ) !== 1;

		n.remove();
	}

	$.extend( settings.oBrowser, DataTable.__browser );
	settings.oScroll.iBarWidth = DataTable.__browser.barWidth;
}

/**
 * Add a column to the list used for the table with default values
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAddColumn( oSettings )
{
	// Add column to aoColumns array
	var oDefaults = DataTable.defaults.column;
	var iCol = oSettings.aoColumns.length;
	var oCol = $.extend( {}, DataTable.models.oColumn, oDefaults, {
		"aDataSort": oDefaults.aDataSort ? oDefaults.aDataSort : [iCol],
		"mData": oDefaults.mData ? oDefaults.mData : iCol,
		idx: iCol,
		searchFixed: {},
		colEl: $('<col>')
	} );
	oSettings.aoColumns.push( oCol );

	// Add search object for column specific search. Note that the `searchCols[ iCol ]`
	// passed into extend can be undefined. This allows the user to give a default
	// with only some of the parameters defined, and also not give a default
	var searchCols = oSettings.aoPreSearchCols;
	searchCols[ iCol ] = $.extend( {}, DataTable.models.oSearch, searchCols[ iCol ] );
}


/**
 * Apply options for a column
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iCol column index to consider
 *  @param {object} oOptions object with sType, bVisible and bSearchable etc
 *  @memberof DataTable#oApi
 */
function _fnColumnOptions( oSettings, iCol, oOptions )
{
	var oCol = oSettings.aoColumns[ iCol ];

	/* User specified column options */
	if ( oOptions !== undefined && oOptions !== null )
	{
		// Backwards compatibility
		_fnCompatCols( oOptions );

		// Map camel case parameters to their Hungarian counterparts
		_fnCamelToHungarian( DataTable.defaults.column, oOptions, true );

		/* Backwards compatibility for mDataProp */
		if ( oOptions.mDataProp !== undefined && !oOptions.mData )
		{
			oOptions.mData = oOptions.mDataProp;
		}

		if ( oOptions.sType )
		{
			oCol._sManualType = oOptions.sType;
		}
	
		// `class` is a reserved word in Javascript, so we need to provide
		// the ability to use a valid name for the camel case input
		if ( oOptions.className && ! oOptions.sClass )
		{
			oOptions.sClass = oOptions.className;
		}

		var origClass = oCol.sClass;

		$.extend( oCol, oOptions );
		_fnMap( oCol, oOptions, "sWidth", "sWidthOrig" );

		// Merge class from previously defined classes with this one, rather than just
		// overwriting it in the extend above
		if (origClass !== oCol.sClass) {
			oCol.sClass = origClass + ' ' + oCol.sClass;
		}

		/* iDataSort to be applied (backwards compatibility), but aDataSort will take
		 * priority if defined
		 */
		if ( oOptions.iDataSort !== undefined )
		{
			oCol.aDataSort = [ oOptions.iDataSort ];
		}
		_fnMap( oCol, oOptions, "aDataSort" );
	}

	/* Cache the data get and set functions for speed */
	var mDataSrc = oCol.mData;
	var mData = _fnGetObjectDataFn( mDataSrc );

	// The `render` option can be given as an array to access the helper rendering methods.
	// The first element is the rendering method to use, the rest are the parameters to pass
	if ( oCol.mRender && Array.isArray( oCol.mRender ) ) {
		var copy = oCol.mRender.slice();
		var name = copy.shift();

		oCol.mRender = DataTable.render[name].apply(window, copy);
	}

	oCol._render = oCol.mRender ? _fnGetObjectDataFn( oCol.mRender ) : null;

	var attrTest = function( src ) {
		return typeof src === 'string' && src.indexOf('@') !== -1;
	};
	oCol._bAttrSrc = $.isPlainObject( mDataSrc ) && (
		attrTest(mDataSrc.sort) || attrTest(mDataSrc.type) || attrTest(mDataSrc.filter)
	);
	oCol._setter = null;

	oCol.fnGetData = function (rowData, type, meta) {
		var innerData = mData( rowData, type, undefined, meta );

		return oCol._render && type ?
			oCol._render( innerData, type, rowData, meta ) :
			innerData;
	};
	oCol.fnSetData = function ( rowData, val, meta ) {
		return _fnSetObjectDataFn( mDataSrc )( rowData, val, meta );
	};

	// Indicate if DataTables should read DOM data as an object or array
	// Used in _fnGetRowElements
	if ( typeof mDataSrc !== 'number' && ! oCol._isArrayHost ) {
		oSettings._rowReadObject = true;
	}

	/* Feature sorting overrides column specific when off */
	if ( !oSettings.oFeatures.bSort )
	{
		oCol.bSortable = false;
	}
}


/**
 * Adjust the table column widths for new data. Note: you would probably want to
 * do a redraw after calling this function!
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAdjustColumnSizing ( settings )
{
	_fnCalculateColumnWidths( settings );
	_fnColumnSizes( settings );

	var scroll = settings.oScroll;
	if ( scroll.sY !== '' || scroll.sX !== '') {
		_fnScrollDraw( settings );
	}

	_fnCallbackFire( settings, null, 'column-sizing', [settings] );
}

/**
 * Apply column sizes
 *
 * @param {*} settings DataTables settings object
 */
function _fnColumnSizes ( settings )
{
	var cols = settings.aoColumns;

	for (var i=0 ; i<cols.length ; i++) {
		var width = _fnColumnsSumWidth(settings, [i], false, false);

		cols[i].colEl.css('width', width);
	}
}


/**
 * Convert the index of a visible column to the index in the data array (take account
 * of hidden columns)
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iMatch Visible column index to lookup
 *  @returns {int} i the data index
 *  @memberof DataTable#oApi
 */
function _fnVisibleToColumnIndex( oSettings, iMatch )
{
	var aiVis = _fnGetColumns( oSettings, 'bVisible' );

	return typeof aiVis[iMatch] === 'number' ?
		aiVis[iMatch] :
		null;
}


/**
 * Convert the index of an index in the data array and convert it to the visible
 *   column index (take account of hidden columns)
 *  @param {int} iMatch Column index to lookup
 *  @param {object} oSettings dataTables settings object
 *  @returns {int} i the data index
 *  @memberof DataTable#oApi
 */
function _fnColumnIndexToVisible( oSettings, iMatch )
{
	var aiVis = _fnGetColumns( oSettings, 'bVisible' );
	var iPos = aiVis.indexOf(iMatch);

	return iPos !== -1 ? iPos : null;
}


/**
 * Get the number of visible columns
 *  @param {object} oSettings dataTables settings object
 *  @returns {int} i the number of visible columns
 *  @memberof DataTable#oApi
 */
function _fnVisbleColumns( settings )
{
	var layout = settings.aoHeader;
	var columns = settings.aoColumns;
	var vis = 0;

	if ( layout.length ) {
		for ( var i=0, ien=layout[0].length ; i<ien ; i++ ) {
			if ( columns[i].bVisible && $(layout[0][i].cell).css('display') !== 'none' ) {
				vis++;
			}
		}
	}

	return vis;
}


/**
 * Get an array of column indexes that match a given property
 *  @param {object} oSettings dataTables settings object
 *  @param {string} sParam Parameter in aoColumns to look for - typically
 *    bVisible or bSearchable
 *  @returns {array} Array of indexes with matched properties
 *  @memberof DataTable#oApi
 */
function _fnGetColumns( oSettings, sParam )
{
	var a = [];

	oSettings.aoColumns.map( function(val, i) {
		if ( val[sParam] ) {
			a.push( i );
		}
	} );

	return a;
}


/**
 * Calculate the 'type' of a column
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnColumnTypes ( settings )
{
	var columns = settings.aoColumns;
	var data = settings.aoData;
	var types = DataTable.ext.type.detect;
	var i, ien, j, jen, k, ken;
	var col, detectedType, cache;

	// For each column, spin over the 
	for ( i=0, ien=columns.length ; i<ien ; i++ ) {
		col = columns[i];
		cache = [];

		if ( ! col.sType && col._sManualType ) {
			col.sType = col._sManualType;
		}
		else if ( ! col.sType ) {
			for ( j=0, jen=types.length ; j<jen ; j++ ) {
				for ( k=0, ken=data.length ; k<ken ; k++ ) {

					if (! data[k]) {
						continue;
					}

					// Use a cache array so we only need to get the type data
					// from the formatter once (when using multiple detectors)
					if ( cache[k] === undefined ) {
						cache[k] = _fnGetCellData( settings, k, i, 'type' );
					}

					detectedType = types[j]( cache[k], settings );

					// If null, then this type can't apply to this column, so
					// rather than testing all cells, break out. There is an
					// exception for the last type which is `html`. We need to
					// scan all rows since it is possible to mix string and HTML
					// types
					if ( ! detectedType && j !== types.length-2 ) {
						break;
					}

					// Only a single match is needed for html type since it is
					// bottom of the pile and very similar to string - but it
					// must not be empty
					if ( detectedType === 'html' && ! _empty(cache[k]) ) {
						break;
					}
				}

				// Type is valid for all data points in the column - use this
				// type
				if ( detectedType ) {
					col.sType = detectedType;
					break;
				}
			}

			// Fall back - if no type was detected, always use string
			if ( ! col.sType ) {
				col.sType = 'string';
			}
		}

		// Set class names for header / footer for auto type classes
		var autoClass = _ext.type.className[col.sType];

		if (autoClass) {
			_columnAutoClass(settings.aoHeader, i, autoClass);
			_columnAutoClass(settings.aoFooter, i, autoClass);
		}

		var renderer = _ext.type.render[col.sType];

		// This can only happen once! There is no way to remover
		// a renderer. After the first time the renderer has
		// already been set so createTr will run the renderer itself.
		if (renderer && ! col._render) {
			col._render = DataTable.util.get(renderer);

			_columnAutoRender(settings, i);
		}
	}
}

/**
 * Apply an auto detected renderer to data which doesn't yet have
 * a renderer
 */
function _columnAutoRender(settings, colIdx) {
	var data = settings.aoData;

	for (var i=0 ; i<data.length ; i++) {
		if (data[i].nTr) {
			// We have to update the display here since there is no
			// invalidation check for the data
			var display = _fnGetCellData( settings, i, colIdx, 'display' );

			data[i].displayData[colIdx] = display;
			_fnWriteCell(data[i].anCells[colIdx], display);

			// No need to update sort / filter data since it has
			// been invalidated and will be re-read with the
			// renderer now applied
		}
	}
}

/**
 * Apply a class name to a column's header cells
 */
function _columnAutoClass(container, colIdx, className) {
	container.forEach(function (row) {
		if (row[colIdx] && row[colIdx].unique) {
			_addClass(row[colIdx].cell, className);
		}
	});
}

/**
 * Take the column definitions and static columns arrays and calculate how
 * they relate to column indexes. The callback function will then apply the
 * definition found for a column to a suitable configuration object.
 *  @param {object} oSettings dataTables settings object
 *  @param {array} aoColDefs The aoColumnDefs array that is to be applied
 *  @param {array} aoCols The aoColumns array that defines columns individually
 *  @param {array} headerLayout Layout for header as it was loaded
 *  @param {function} fn Callback function - takes two parameters, the calculated
 *    column index and the definition for that column.
 *  @memberof DataTable#oApi
 */
function _fnApplyColumnDefs( oSettings, aoColDefs, aoCols, headerLayout, fn )
{
	var i, iLen, j, jLen, k, kLen, def;
	var columns = oSettings.aoColumns;

	if ( aoCols ) {
		for ( i=0, iLen=aoCols.length ; i<iLen ; i++ ) {
			if (aoCols[i] && aoCols[i].name) {
				columns[i].sName = aoCols[i].name;
			}
		}
	}

	// Column definitions with aTargets
	if ( aoColDefs )
	{
		/* Loop over the definitions array - loop in reverse so first instance has priority */
		for ( i=aoColDefs.length-1 ; i>=0 ; i-- )
		{
			def = aoColDefs[i];

			/* Each definition can target multiple columns, as it is an array */
			var aTargets = def.target !== undefined
				? def.target
				: def.targets !== undefined
					? def.targets
					: def.aTargets;

			if ( ! Array.isArray( aTargets ) )
			{
				aTargets = [ aTargets ];
			}

			for ( j=0, jLen=aTargets.length ; j<jLen ; j++ )
			{
				var target = aTargets[j];

				if ( typeof target === 'number' && target >= 0 )
				{
					/* Add columns that we don't yet know about */
					while( columns.length <= target )
					{
						_fnAddColumn( oSettings );
					}

					/* Integer, basic index */
					fn( target, def );
				}
				else if ( typeof target === 'number' && target < 0 )
				{
					/* Negative integer, right to left column counting */
					fn( columns.length+target, def );
				}
				else if ( typeof target === 'string' )
				{
					for ( k=0, kLen=columns.length ; k<kLen ; k++ ) {
						if (target === '_all') {
							// Apply to all columns
							fn( k, def );
						}
						else if (target.indexOf(':name') !== -1) {
							// Column selector
							if (columns[k].sName === target.replace(':name', '')) {
								fn( k, def );
							}
						}
						else {
							// Cell selector
							headerLayout.forEach(function (row) {
								if (row[k]) {
									var cell = $(row[k].cell);

									// Legacy support. Note that it means that we don't support
									// an element name selector only, since they are treated as
									// class names for 1.x compat.
									if (target.match(/^[a-z][\w-]*$/i)) {
										target = '.' + target;
									}

									if (cell.is( target )) {
										fn( k, def );
									}
								}
							});
						}
					}
				}
			}
		}
	}

	// Statically defined columns array
	if ( aoCols ) {
		for ( i=0, iLen=aoCols.length ; i<iLen ; i++ ) {
			fn( i, aoCols[i] );
		}
	}
}


/**
 * Get the width for a given set of columns
 *
 * @param {*} settings DataTables settings object
 * @param {*} targets Columns - comma separated string or array of numbers
 * @param {*} original Use the original width (true) or calculated (false)
 * @param {*} incVisible Include visible columns (true) or not (false)
 * @returns Combined CSS value
 */
function _fnColumnsSumWidth( settings, targets, original, incVisible ) {
	if ( ! Array.isArray( targets ) ) {
		targets = _fnColumnsFromHeader( targets );
	}

	var sum = 0;
	var unit;
	var columns = settings.aoColumns;
	
	for ( var i=0, ien=targets.length ; i<ien ; i++ ) {
		var column = columns[ targets[i] ];
		var definedWidth = original ?
			column.sWidthOrig :
			column.sWidth;

		if ( ! incVisible && column.bVisible === false ) {
			continue;
		}

		if ( definedWidth === null || definedWidth === undefined ) {
			return null; // can't determine a defined width - browser defined
		}
		else if ( typeof definedWidth === 'number' ) {
			unit = 'px';
			sum += definedWidth;
		}
		else {
			var matched = definedWidth.match(/([\d\.]+)([^\d]*)/);

			if ( matched ) {
				sum += matched[1] * 1;
				unit = matched.length === 3 ?
					matched[2] :
					'px';
			}
		}
	}

	return sum + unit;
}

function _fnColumnsFromHeader( cell )
{
	var attr = $(cell).closest('[data-dt-column]').attr('data-dt-column');

	if ( ! attr ) {
		return [];
	}

	return attr.split(',').map( function (val) {
		return val * 1;
	} );
}
/**
 * Add a data array to the table, creating DOM node etc. This is the parallel to
 * _fnGatherData, but for adding rows from a Javascript source, rather than a
 * DOM source.
 *  @param {object} settings dataTables settings object
 *  @param {array} data data array to be added
 *  @param {node} [tr] TR element to add to the table - optional. If not given,
 *    DataTables will create a row automatically
 *  @param {array} [tds] Array of TD|TH elements for the row - must be given
 *    if nTr is.
 *  @returns {int} >=0 if successful (index of new aoData entry), -1 if failed
 *  @memberof DataTable#oApi
 */
function _fnAddData ( settings, dataIn, tr, tds )
{
	/* Create the object for storing information about this new row */
	var rowIdx = settings.aoData.length;
	var rowModel = $.extend( true, {}, DataTable.models.oRow, {
		src: tr ? 'dom' : 'data',
		idx: rowIdx
	} );

	rowModel._aData = dataIn;
	settings.aoData.push( rowModel );

	var columns = settings.aoColumns;

	for ( var i=0, iLen=columns.length ; i<iLen ; i++ )
	{
		// Invalidate the column types as the new data needs to be revalidated
		columns[i].sType = null;
	}

	/* Add to the display array */
	settings.aiDisplayMaster.push( rowIdx );

	var id = settings.rowIdFn( dataIn );
	if ( id !== undefined ) {
		settings.aIds[ id ] = rowModel;
	}

	/* Create the DOM information, or register it if already present */
	if ( tr || ! settings.oFeatures.bDeferRender )
	{
		_fnCreateTr( settings, rowIdx, tr, tds );
	}

	return rowIdx;
}


/**
 * Add one or more TR elements to the table. Generally we'd expect to
 * use this for reading data from a DOM sourced table, but it could be
 * used for an TR element. Note that if a TR is given, it is used (i.e.
 * it is not cloned).
 *  @param {object} settings dataTables settings object
 *  @param {array|node|jQuery} trs The TR element(s) to add to the table
 *  @returns {array} Array of indexes for the added rows
 *  @memberof DataTable#oApi
 */
function _fnAddTr( settings, trs )
{
	var row;

	// Allow an individual node to be passed in
	if ( ! (trs instanceof $) ) {
		trs = $(trs);
	}

	return trs.map( function (i, el) {
		row = _fnGetRowElements( settings, el );
		return _fnAddData( settings, row.data, el, row.cells );
	} );
}


/**
 * Get the data for a given cell from the internal cache, taking into account data mapping
 *  @param {object} settings dataTables settings object
 *  @param {int} rowIdx aoData row id
 *  @param {int} colIdx Column index
 *  @param {string} type data get type ('display', 'type' 'filter|search' 'sort|order')
 *  @returns {*} Cell data
 *  @memberof DataTable#oApi
 */
function _fnGetCellData( settings, rowIdx, colIdx, type )
{
	if (type === 'search') {
		type = 'filter';
	}
	else if (type === 'order') {
		type = 'sort';
	}

	var draw           = settings.iDraw;
	var col            = settings.aoColumns[colIdx];
	var rowData        = settings.aoData[rowIdx]._aData;
	var defaultContent = col.sDefaultContent;
	var cellData       = col.fnGetData( rowData, type, {
		settings: settings,
		row:      rowIdx,
		col:      colIdx
	} );

	// Allow for a node being returned for non-display types
	if (type !== 'display' && cellData && typeof cellData === 'object' && cellData.nodeName) {
		cellData = cellData.innerHTML;
	}

	if ( cellData === undefined ) {
		if ( settings.iDrawError != draw && defaultContent === null ) {
			_fnLog( settings, 0, "Requested unknown parameter "+
				(typeof col.mData=='function' ? '{function}' : "'"+col.mData+"'")+
				" for row "+rowIdx+", column "+colIdx, 4 );
			settings.iDrawError = draw;
		}
		return defaultContent;
	}

	// When the data source is null and a specific data type is requested (i.e.
	// not the original data), we can use default column data
	if ( (cellData === rowData || cellData === null) && defaultContent !== null && type !== undefined ) {
		cellData = defaultContent;
	}
	else if ( typeof cellData === 'function' ) {
		// If the data source is a function, then we run it and use the return,
		// executing in the scope of the data object (for instances)
		return cellData.call( rowData );
	}

	if ( cellData === null && type === 'display' ) {
		return '';
	}

	if ( type === 'filter' ) {
		var fomatters = DataTable.ext.type.search;

		if ( fomatters[ col.sType ] ) {
			cellData = fomatters[ col.sType ]( cellData );
		}
	}

	return cellData;
}


/**
 * Set the value for a specific cell, into the internal data cache
 *  @param {object} settings dataTables settings object
 *  @param {int} rowIdx aoData row id
 *  @param {int} colIdx Column index
 *  @param {*} val Value to set
 *  @memberof DataTable#oApi
 */
function _fnSetCellData( settings, rowIdx, colIdx, val )
{
	var col     = settings.aoColumns[colIdx];
	var rowData = settings.aoData[rowIdx]._aData;

	col.fnSetData( rowData, val, {
		settings: settings,
		row:      rowIdx,
		col:      colIdx
	}  );
}

/**
 * Write a value to a cell
 * @param {*} td Cell
 * @param {*} val Value
 */
function _fnWriteCell(td, val)
{
	if (val && typeof val === 'object' && val.nodeName) {
		$(td)
			.empty()
			.append(val);
	}
	else {
		td.innerHTML = val;
	}
}


// Private variable that is used to match action syntax in the data property object
var __reArray = /\[.*?\]$/;
var __reFn = /\(\)$/;

/**
 * Split string on periods, taking into account escaped periods
 * @param  {string} str String to split
 * @return {array} Split string
 */
function _fnSplitObjNotation( str )
{
	var parts = str.match(/(\\.|[^.])+/g) || [''];

	return parts.map( function ( s ) {
		return s.replace(/\\\./g, '.');
	} );
}


/**
 * Return a function that can be used to get data from a source object, taking
 * into account the ability to use nested objects as a source
 *  @param {string|int|function} mSource The data source for the object
 *  @returns {function} Data get function
 *  @memberof DataTable#oApi
 */
var _fnGetObjectDataFn = DataTable.util.get;


/**
 * Return a function that can be used to set data from a source object, taking
 * into account the ability to use nested objects as a source
 *  @param {string|int|function} mSource The data source for the object
 *  @returns {function} Data set function
 *  @memberof DataTable#oApi
 */
var _fnSetObjectDataFn = DataTable.util.set;


/**
 * Return an array with the full table data
 *  @param {object} oSettings dataTables settings object
 *  @returns array {array} aData Master data array
 *  @memberof DataTable#oApi
 */
function _fnGetDataMaster ( settings )
{
	return _pluck( settings.aoData, '_aData' );
}


/**
 * Nuke the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnClearTable( settings )
{
	settings.aoData.length = 0;
	settings.aiDisplayMaster.length = 0;
	settings.aiDisplay.length = 0;
	settings.aIds = {};
}


/**
 * Mark cached data as invalid such that a re-read of the data will occur when
 * the cached data is next requested. Also update from the data source object.
 *
 * @param {object} settings DataTables settings object
 * @param {int}    rowIdx   Row index to invalidate
 * @param {string} [src]    Source to invalidate from: undefined, 'auto', 'dom'
 *     or 'data'
 * @param {int}    [colIdx] Column index to invalidate. If undefined the whole
 *     row will be invalidated
 * @memberof DataTable#oApi
 *
 * @todo For the modularisation of v1.11 this will need to become a callback, so
 *   the sort and filter methods can subscribe to it. That will required
 *   initialisation options for sorting, which is why it is not already baked in
 */
function _fnInvalidate( settings, rowIdx, src, colIdx )
{
	var row = settings.aoData[ rowIdx ];
	var i, ien;

	// Remove the cached data for the row
	row._aSortData = null;
	row._aFilterData = null;
	row.displayData = null;

	// Are we reading last data from DOM or the data object?
	if ( src === 'dom' || ((! src || src === 'auto') && row.src === 'dom') ) {
		// Read the data from the DOM
		row._aData = _fnGetRowElements(
				settings, row, colIdx, colIdx === undefined ? undefined : row._aData
			)
			.data;
	}
	else {
		// Reading from data object, update the DOM
		var cells = row.anCells;
		var display = _fnGetRowDisplay(settings, rowIdx);

		if ( cells ) {
			if ( colIdx !== undefined ) {
				_fnWriteCell(cells[colIdx], display[colIdx]);
			}
			else {
				for ( i=0, ien=cells.length ; i<ien ; i++ ) {
					_fnWriteCell(cells[i], display[i]);
				}
			}
		}
	}

	// Column specific invalidation
	var cols = settings.aoColumns;
	if ( colIdx !== undefined ) {
		// Type - the data might have changed
		cols[ colIdx ].sType = null;

		// Max length string. Its a fairly cheep recalculation, so not worth
		// something more complicated
		cols[ colIdx ].maxLenString = null;
	}
	else {
		for ( i=0, ien=cols.length ; i<ien ; i++ ) {
			cols[i].sType = null;
			cols[i].maxLenString = null;
		}

		// Update DataTables special `DT_*` attributes for the row
		_fnRowAttributes( settings, row );
	}
}


/**
 * Build a data source object from an HTML row, reading the contents of the
 * cells that are in the row.
 *
 * @param {object} settings DataTables settings object
 * @param {node|object} TR element from which to read data or existing row
 *   object from which to re-read the data from the cells
 * @param {int} [colIdx] Optional column index
 * @param {array|object} [d] Data source object. If `colIdx` is given then this
 *   parameter should also be given and will be used to write the data into.
 *   Only the column in question will be written
 * @returns {object} Object with two parameters: `data` the data read, in
 *   document order, and `cells` and array of nodes (they can be useful to the
 *   caller, so rather than needing a second traversal to get them, just return
 *   them from here).
 * @memberof DataTable#oApi
 */
function _fnGetRowElements( settings, row, colIdx, d )
{
	var
		tds = [],
		td = row.firstChild,
		name, col, i=0, contents,
		columns = settings.aoColumns,
		objectRead = settings._rowReadObject;

	// Allow the data object to be passed in, or construct
	d = d !== undefined ?
		d :
		objectRead ?
			{} :
			[];

	var attr = function ( str, td  ) {
		if ( typeof str === 'string' ) {
			var idx = str.indexOf('@');

			if ( idx !== -1 ) {
				var attr = str.substring( idx+1 );
				var setter = _fnSetObjectDataFn( str );
				setter( d, td.getAttribute( attr ) );
			}
		}
	};

	// Read data from a cell and store into the data object
	var cellProcess = function ( cell ) {
		if ( colIdx === undefined || colIdx === i ) {
			col = columns[i];
			contents = (cell.innerHTML).trim();

			if ( col && col._bAttrSrc ) {
				var setter = _fnSetObjectDataFn( col.mData._ );
				setter( d, contents );

				attr( col.mData.sort, cell );
				attr( col.mData.type, cell );
				attr( col.mData.filter, cell );
			}
			else {
				// Depending on the `data` option for the columns the data can
				// be read to either an object or an array.
				if ( objectRead ) {
					if ( ! col._setter ) {
						// Cache the setter function
						col._setter = _fnSetObjectDataFn( col.mData );
					}
					col._setter( d, contents );
				}
				else {
					d[i] = contents;
				}
			}
		}

		i++;
	};

	if ( td ) {
		// `tr` element was passed in
		while ( td ) {
			name = td.nodeName.toUpperCase();

			if ( name == "TD" || name == "TH" ) {
				cellProcess( td );
				tds.push( td );
			}

			td = td.nextSibling;
		}
	}
	else {
		// Existing row object passed in
		tds = row.anCells;

		for ( var j=0, jen=tds.length ; j<jen ; j++ ) {
			cellProcess( tds[j] );
		}
	}

	// Read the ID from the DOM if present
	var rowNode = row.firstChild ? row : row.nTr;

	if ( rowNode ) {
		var id = rowNode.getAttribute( 'id' );

		if ( id ) {
			_fnSetObjectDataFn( settings.rowId )( d, id );
		}
	}

	return {
		data: d,
		cells: tds
	};
}

/**
 * Render and cache a row's display data for the columns, if required
 * @returns 
 */
function _fnGetRowDisplay (settings, rowIdx) {
	let rowModal = settings.aoData[rowIdx];
	let columns = settings.aoColumns;

	if (! rowModal.displayData) {
		// Need to render and cache
		rowModal.displayData = [];
	
		for ( var colIdx=0, len=columns.length ; colIdx<len ; colIdx++ ) {
			rowModal.displayData.push(
				_fnGetCellData( settings, rowIdx, colIdx, 'display' )
			);
		}
	}

	return rowModal.displayData;
}

/**
 * Create a new TR element (and it's TD children) for a row
 *  @param {object} oSettings dataTables settings object
 *  @param {int} iRow Row to consider
 *  @param {node} [nTrIn] TR element to add to the table - optional. If not given,
 *    DataTables will create a row automatically
 *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
 *    if nTr is.
 *  @memberof DataTable#oApi
 */
function _fnCreateTr ( oSettings, iRow, nTrIn, anTds )
{
	var
		row = oSettings.aoData[iRow],
		rowData = row._aData,
		cells = [],
		nTr, nTd, oCol,
		i, iLen, create,
		trClass = oSettings.oClasses.tbody.row;

	if ( row.nTr === null )
	{
		nTr = nTrIn || document.createElement('tr');

		row.nTr = nTr;
		row.anCells = cells;

		_addClass(nTr, trClass);

		/* Use a private property on the node to allow reserve mapping from the node
		 * to the aoData array for fast look up
		 */
		nTr._DT_RowIndex = iRow;

		/* Special parameters can be given by the data source to be used on the row */
		_fnRowAttributes( oSettings, row );

		/* Process each column */
		for ( i=0, iLen=oSettings.aoColumns.length ; i<iLen ; i++ )
		{
			oCol = oSettings.aoColumns[i];
			create = nTrIn && anTds[i] ? false : true;

			nTd = create ? document.createElement( oCol.sCellType ) : anTds[i];

			if (! nTd) {
				_fnLog( oSettings, 0, 'Incorrect column count', 18 );
			}

			nTd._DT_CellIndex = {
				row: iRow,
				column: i
			};
			
			cells.push( nTd );
			
			var display = _fnGetRowDisplay(oSettings, iRow);

			// Need to create the HTML if new, or if a rendering function is defined
			if (
				create ||
				(
					(oCol.mRender || oCol.mData !== i) &&
					(!$.isPlainObject(oCol.mData) || oCol.mData._ !== i+'.display')
				)
			) {
				_fnWriteCell(nTd, display[i]);
			}

			// Visibility - add or remove as required
			if ( oCol.bVisible && create )
			{
				nTr.appendChild( nTd );
			}
			else if ( ! oCol.bVisible && ! create )
			{
				nTd.parentNode.removeChild( nTd );
			}

			if ( oCol.fnCreatedCell )
			{
				oCol.fnCreatedCell.call( oSettings.oInstance,
					nTd, _fnGetCellData( oSettings, iRow, i ), rowData, iRow, i
				);
			}
		}

		_fnCallbackFire( oSettings, 'aoRowCreatedCallback', 'row-created', [nTr, rowData, iRow, cells] );
	}
	else {
		_addClass(row.nTr, trClass);
	}
}


/**
 * Add attributes to a row based on the special `DT_*` parameters in a data
 * source object.
 *  @param {object} settings DataTables settings object
 *  @param {object} DataTables row object for the row to be modified
 *  @memberof DataTable#oApi
 */
function _fnRowAttributes( settings, row )
{
	var tr = row.nTr;
	var data = row._aData;

	if ( tr ) {
		var id = settings.rowIdFn( data );

		if ( id ) {
			tr.id = id;
		}

		if ( data.DT_RowClass ) {
			// Remove any classes added by DT_RowClass before
			var a = data.DT_RowClass.split(' ');
			row.__rowc = row.__rowc ?
				_unique( row.__rowc.concat( a ) ) :
				a;

			$(tr)
				.removeClass( row.__rowc.join(' ') )
				.addClass( data.DT_RowClass );
		}

		if ( data.DT_RowAttr ) {
			$(tr).attr( data.DT_RowAttr );
		}

		if ( data.DT_RowData ) {
			$(tr).data( data.DT_RowData );
		}
	}
}


/**
 * Create the HTML header for the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnBuildHead( settings, side )
{
	var classes = settings.oClasses;
	var columns = settings.aoColumns;
	var i, ien, row;
	var target = side === 'header'
		? settings.nTHead
		: settings.nTFoot;
	var titleProp = side === 'header' ? 'sTitle' : side;

	// Footer might be defined
	if (! target) {
		return;
	}

	// If no cells yet and we have content for them, then create
	if (side === 'header' || _pluck(settings.aoColumns, titleProp).join('')) {
		row = $('tr', target);

		// Add a row if needed
		if (! row.length) {
			row = $('<tr/>').appendTo(target)
		}

		// Add the number of cells needed to make up to the number of columns
		if (row.length === 1) {
			var cells = $('td, th', row);

			for ( i=cells.length, ien=columns.length ; i<ien ; i++ ) {
				$('<th/>')
					.html( columns[i][titleProp] || '' )
					.appendTo( row );
			}
		}
	}

	var detected = _fnDetectHeader( settings, target, true );

	if (side === 'header') {
		settings.aoHeader = detected;
	}
	else {
		settings.aoFooter = detected;
	}

	// ARIA role for the rows
	$(target).children('tr').attr('role', 'row');

	// Every cell needs to be passed through the renderer
	$(target).children('tr').children('th, td')
		.each( function () {
			_fnRenderer( settings, side )(
				settings, $(this), classes
			);
		} );
}

/**
 * Build a layout structure for a header or footer
 *
 * @param {*} settings DataTables settings
 * @param {*} source Source layout array
 * @param {*} incColumns What columns should be included
 * @returns Layout array
 */
function _fnHeaderLayout( settings, source, incColumns )
{
	var row, column, cell;
	var local = [];
	var structure = [];
	var columns = settings.aoColumns;
	var columnCount = columns.length;
	var rowspan, colspan;

	if ( ! source ) {
		return;
	}

	// Default is to work on only visible columns
	if ( ! incColumns ) {
		incColumns = _range(columnCount)
			.filter(function (idx) {
				return columns[idx].bVisible;
			});
	}

	// Make a copy of the master layout array, but with only the columns we want
	for ( row=0 ; row<source.length ; row++ ) {
		// Remove any columns we haven't selected
		local[row] = source[row].slice().filter(function (cell, i) {
			return incColumns.includes(i);
		});

		// Prep the structure array - it needs an element for each row
		structure.push( [] );
	}

	for ( row=0 ; row<local.length ; row++ ) {
		for ( column=0 ; column<local[row].length ; column++ ) {
			rowspan = 1;
			colspan = 1;

			// Check to see if there is already a cell (row/colspan) covering our target
			// insert point. If there is, then there is nothing to do.
			if ( structure[row][column] === undefined ) {
				cell = local[row][column].cell;

				// Expand for rowspan
				while (
					local[row+rowspan] !== undefined &&
					local[row][column].cell == local[row+rowspan][column].cell
				) {
					structure[row+rowspan][column] = null;
					rowspan++;
				}

				// And for colspan
				while (
					local[row][column+colspan] !== undefined &&
					local[row][column].cell == local[row][column+colspan].cell
				) {
					// Which also needs to go over rows
					for ( var k=0 ; k<rowspan ; k++ ) {
						structure[row+k][column+colspan] = null;
					}

					colspan++;
				}

				var titleSpan = $('span.dt-column-title', cell);

				structure[row][column] = {
					cell: cell,
					colspan: colspan,
					rowspan: rowspan,
					title: titleSpan.length
						? titleSpan.html()
						: $(cell).html()
				};
			}
		}
	}

	return structure;
}


/**
 * Draw the header (or footer) element based on the column visibility states.
 *
 *  @param object oSettings dataTables settings object
 *  @param array aoSource Layout array from _fnDetectHeader
 *  @memberof DataTable#oApi
 */
function _fnDrawHead( settings, source )
{
	var layout = _fnHeaderLayout(settings, source);
	var tr, n;

	for ( var row=0 ; row<source.length ; row++ ) {
		tr = source[row].row;

		// All cells are going to be replaced, so empty out the row
		// Can't use $().empty() as that kills event handlers
		if (tr) {
			while( (n = tr.firstChild) ) {
				tr.removeChild( n );
			}
		}

		for ( var column=0 ; column<layout[row].length ; column++ ) {
			var point = layout[row][column];

			if (point) {
				$(point.cell)
					.appendTo(tr)
					.attr('rowspan', point.rowspan)
					.attr('colspan', point.colspan);
			}
		}
	}
}


/**
 * Insert the required TR nodes into the table for display
 *  @param {object} oSettings dataTables settings object
 *  @param ajaxComplete true after ajax call to complete rendering
 *  @memberof DataTable#oApi
 */
function _fnDraw( oSettings, ajaxComplete )
{
	// Allow for state saving and a custom start position
	_fnStart( oSettings );

	/* Provide a pre-callback function which can be used to cancel the draw is false is returned */
	var aPreDraw = _fnCallbackFire( oSettings, 'aoPreDrawCallback', 'preDraw', [oSettings] );
	if ( aPreDraw.indexOf(false) !== -1 )
	{
		_fnProcessingDisplay( oSettings, false );
		return;
	}

	var anRows = [];
	var iRowCount = 0;
	var bServerSide = _fnDataSource( oSettings ) == 'ssp';
	var aiDisplay = oSettings.aiDisplay;
	var iDisplayStart = oSettings._iDisplayStart;
	var iDisplayEnd = oSettings.fnDisplayEnd();
	var columns = oSettings.aoColumns;
	var body = $(oSettings.nTBody);

	oSettings.bDrawing = true;

	/* Server-side processing draw intercept */
	if ( !bServerSide )
	{
		oSettings.iDraw++;
	}
	else if ( !oSettings.bDestroying && !ajaxComplete)
	{
		// Show loading message for server-side processing
		if (oSettings.iDraw === 0) {
			body.empty().append(_emptyRow(oSettings));
		}

		_fnAjaxUpdate( oSettings );
		return;
	}

	if ( aiDisplay.length !== 0 )
	{
		var iStart = bServerSide ? 0 : iDisplayStart;
		var iEnd = bServerSide ? oSettings.aoData.length : iDisplayEnd;

		for ( var j=iStart ; j<iEnd ; j++ )
		{
			var iDataIndex = aiDisplay[j];
			var aoData = oSettings.aoData[ iDataIndex ];
			if ( aoData.nTr === null )
			{
				_fnCreateTr( oSettings, iDataIndex );
			}

			var nRow = aoData.nTr;

			// Add various classes as needed
			for (var i=0 ; i<columns.length ; i++) {
				var col = columns[i];
				var td = aoData.anCells[i];

				_addClass(td, _ext.type.className[col.sType]); // auto class
				_addClass(td, col.sClass); // column class
				_addClass(td, oSettings.oClasses.tbody.cell); // all cells
			}

			// Row callback functions - might want to manipulate the row
			// iRowCount and j are not currently documented. Are they at all
			// useful?
			_fnCallbackFire( oSettings, 'aoRowCallback', null,
				[nRow, aoData._aData, iRowCount, j, iDataIndex] );

			anRows.push( nRow );
			iRowCount++;
		}
	}
	else
	{
		anRows[ 0 ] = _emptyRow(oSettings);
	}

	/* Header and footer callbacks */
	_fnCallbackFire( oSettings, 'aoHeaderCallback', 'header', [ $(oSettings.nTHead).children('tr')[0],
		_fnGetDataMaster( oSettings ), iDisplayStart, iDisplayEnd, aiDisplay ] );

	_fnCallbackFire( oSettings, 'aoFooterCallback', 'footer', [ $(oSettings.nTFoot).children('tr')[0],
		_fnGetDataMaster( oSettings ), iDisplayStart, iDisplayEnd, aiDisplay ] );

	// replaceChildren is faster, but only became widespread in 2020,
	// so a fall back in jQuery is provided for older browsers.
	if (body[0].replaceChildren) {
		body[0].replaceChildren.apply(body[0], anRows);
	}
	else {
		body.children().detach();
		body.append( $(anRows) );
	}

	// Empty table needs a specific class
	$(oSettings.nTableWrapper).toggleClass('dt-empty-footer', $('tr', oSettings.nTFoot).length === 0);

	/* Call all required callback functions for the end of a draw */
	_fnCallbackFire( oSettings, 'aoDrawCallback', 'draw', [oSettings], true );

	/* Draw is complete, sorting and filtering must be as well */
	oSettings.bSorted = false;
	oSettings.bFiltered = false;
	oSettings.bDrawing = false;
}


/**
 * Redraw the table - taking account of the various features which are enabled
 *  @param {object} oSettings dataTables settings object
 *  @param {boolean} [holdPosition] Keep the current paging position. By default
 *    the paging is reset to the first page
 *  @memberof DataTable#oApi
 */
function _fnReDraw( settings, holdPosition, recompute )
{
	var
		features = settings.oFeatures,
		sort     = features.bSort,
		filter   = features.bFilter;

	if (recompute === undefined || recompute === true) {
		if ( sort ) {
			_fnSort( settings );
		}

		if ( filter ) {
			_fnFilterComplete( settings, settings.oPreviousSearch );
		}
		else {
			// No filtering, so we want to just use the display master
			settings.aiDisplay = settings.aiDisplayMaster.slice();
		}
	}

	if ( holdPosition !== true ) {
		settings._iDisplayStart = 0;
	}

	// Let any modules know about the draw hold position state (used by
	// scrolling internally)
	settings._drawHold = holdPosition;

	_fnDraw( settings );

	settings._drawHold = false;
}


/*
 * Table is empty - create a row with an empty message in it
 */
function _emptyRow ( settings ) {
	var oLang = settings.oLanguage;
	var zero = oLang.sZeroRecords;
	var dataSrc = _fnDataSource( settings );

	if (
		(settings.iDraw < 1 && dataSrc === 'ssp') ||
		(settings.iDraw <= 1 && dataSrc === 'ajax')
	) {
		zero = oLang.sLoadingRecords;
	}
	else if ( oLang.sEmptyTable && settings.fnRecordsTotal() === 0 )
	{
		zero = oLang.sEmptyTable;
	}

	return $( '<tr/>' )
		.append( $('<td />', {
			'colSpan': _fnVisbleColumns( settings ),
			'class':   settings.oClasses.empty.row
		} ).html( zero ) )[0];
}


/**
 * Convert a `layout` object given by a user to the object structure needed
 * for the renderer. This is done twice, once for above and once for below
 * the table. Ordering must also be considered.
 *
 * @param {*} settings DataTables settings object
 * @param {*} layout Layout object to convert
 * @param {string} side `top` or `bottom`
 * @returns Converted array structure - one item for each row.
 */
function _layoutArray ( settings, layout, side )
{
	var groups = {};

	// Combine into like groups (e.g. `top`, `top2`, etc)
	$.each( layout, function ( pos, val ) {
		if (val === null) {
			return;
		}

		var splitPos = pos.replace(/([A-Z])/g, ' $1').split(' ');

		if ( ! groups[ splitPos[0] ] ) {
			groups[ splitPos[0] ] = {};
		}

		var align = splitPos.length === 1 ?
			'full' :
			splitPos[1].toLowerCase();
		var group = groups[ splitPos[0] ];
		var groupRun = function (contents, innerVal) {
			// If it is an object, then there can be multiple features contained in it
			if ( $.isPlainObject( innerVal ) ) {
				Object.keys(innerVal).map(function (key) {
					contents.push( {
						feature: key,
						opts: innerVal[key]
					});
				});
			}
			else {
				contents.push(innerVal);
			}
		}

		// Transform to an object with a contents property
		if (! group[align] || ! group[align].contents) {
			group[align] = { contents: [] };
		}

		// Allow for an array or just a single object
		if ( Array.isArray(val)) {
			for (var i=0 ; i<val.length ; i++) {
				groupRun(group[align].contents, val[i]);
			}
		}
		else {
			groupRun(group[ align ].contents, val);
		}

		// And make contents an array
		if ( ! Array.isArray( group[ align ].contents ) ) {
			group[ align ].contents = [ group[ align ].contents ];
		}
	} );

	var filtered = Object.keys(groups)
		.map( function ( pos ) {
			// Filter to only the side we need
			if ( pos.indexOf(side) !== 0 ) {
				return null;
			}

			return {
				name: pos,
				val: groups[pos]
			};
		} )
		.filter( function (item) {
			return item !== null;
		});

	// Order by item identifier
	filtered.sort( function ( a, b ) {
		var order1 = a.name.replace(/[^0-9]/g, '') * 1;
		var order2 = b.name.replace(/[^0-9]/g, '') * 1;

		return order2 - order1;
	} );
	
	if ( side === 'bottom' ) {
		filtered.reverse();
	}

	// Split into rows
	var rows = [];
	for ( var i=0, ien=filtered.length ; i<ien ; i++ ) {
		if (  filtered[i].val.full ) {
			rows.push( { full: filtered[i].val.full } );
			_layoutResolve( settings, rows[ rows.length - 1 ] );

			delete filtered[i].val.full;
		}

		if ( Object.keys(filtered[i].val).length ) {
			rows.push( filtered[i].val );
			_layoutResolve( settings, rows[ rows.length - 1 ] );
		}
	}

	return rows;
}


/**
 * Convert the contents of a row's layout object to nodes that can be inserted
 * into the document by a renderer. Execute functions, look up plug-ins, etc.
 *
 * @param {*} settings DataTables settings object
 * @param {*} row Layout object for this row
 */
function _layoutResolve( settings, row ) {
	var getFeature = function (feature, opts) {
		if ( ! _ext.features[ feature ] ) {
			_fnLog( settings, 0, 'Unknown feature: '+ feature );
		}

		return _ext.features[ feature ].apply( this, [settings, opts] );
	};

	var resolve = function ( item ) {
		var line = row[ item ].contents;

		for ( var i=0, ien=line.length ; i<ien ; i++ ) {
			if ( ! line[i] ) {
				continue;
			}
			else if ( typeof line[i] === 'string' ) {
				line[i] = getFeature( line[i], null );
			}
			else if ( $.isPlainObject(line[i]) ) {
				// If it's an object, it just has feature and opts properties from
				// the transform in _layoutArray
				line[i] = getFeature(line[i].feature, line[i].opts);
			}
			else if ( typeof line[i].node === 'function' ) {
				line[i] = line[i].node( settings );
			}
			else if ( typeof line[i] === 'function' ) {
				var inst = line[i]( settings );

				line[i] = typeof inst.node === 'function' ?
					inst.node() :
					inst;
			}
		}
	};

	$.each( row, function ( key ) {
		resolve( key );
	} );
}


/**
 * Add the options to the page HTML for the table
 *  @param {object} settings DataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnAddOptionsHtml ( settings )
{
	var classes = settings.oClasses;
	var table = $(settings.nTable);

	// Wrapper div around everything DataTables controls
	var insert = $('<div/>')
		.attr({
			id:      settings.sTableId+'_wrapper',
			'class': classes.container
		})
		.insertBefore(table);

	settings.nTableWrapper = insert[0];

	if (settings.sDom) {
		// Legacy
		_fnLayoutDom(settings, settings.sDom, insert);
	}
	else {
		var top = _layoutArray( settings, settings.layout, 'top' );
		var bottom = _layoutArray( settings, settings.layout, 'bottom' );
		var renderer = _fnRenderer( settings, 'layout' );
	
		// Everything above - the renderer will actually insert the contents into the document
		top.forEach(function (item) {
			renderer( settings, insert, item );
		});

		// The table - always the center of attention
		renderer( settings, insert, {
			full: {
				table: true,
				contents: [ _fnFeatureHtmlTable(settings) ]
			}
		} );

		// Everything below
		bottom.forEach(function (item) {
			renderer( settings, insert, item );
		});
	}

	// Processing floats on top, so it isn't an inserted feature
	_processingHtml( settings );
}

/**
 * Draw the table with the legacy DOM property
 * @param {*} settings DT settings object
 * @param {*} dom DOM string
 * @param {*} insert Insert point
 */
function _fnLayoutDom( settings, dom, insert )
{
	var parts = dom.match(/(".*?")|('.*?')|./g);
	var featureNode, option, newNode, next, attr;

	for ( var i=0 ; i<parts.length ; i++ ) {
		featureNode = null;
		option = parts[i];

		if ( option == '<' ) {
			// New container div
			newNode = $('<div/>');

			// Check to see if we should append an id and/or a class name to the container
			next = parts[i+1];

			if ( next[0] == "'" || next[0] == '"' ) {
				attr = next.replace(/['"]/g, '');

				var id = '', className;

				/* The attribute can be in the format of "#id.class", "#id" or "class" This logic
				 * breaks the string into parts and applies them as needed
				 */
				if ( attr.indexOf('.') != -1 ) {
					var split = attr.split('.');

					id = split[0];
					className = split[1];
				}
				else if ( attr[0] == "#" ) {
					id = attr;
				}
				else {
					className = attr;
				}

				newNode
					.attr('id', id.substring(1))
					.addClass(className);

				i++; // Move along the position array
			}

			insert.append( newNode );
			insert = newNode;
		}
		else if ( option == '>' ) {
			// End container div
			insert = insert.parent();
		}
		else if ( option == 't' ) {
			// Table
			featureNode = _fnFeatureHtmlTable( settings );
		}
		else
		{
			DataTable.ext.feature.forEach(function(feature) {
				if ( option == feature.cFeature ) {
					featureNode = feature.fnInit( settings );
				}
			});
		}

		// Add to the display
		if ( featureNode ) {
			insert.append( featureNode );
		}
	}
}


/**
 * Use the DOM source to create up an array of header cells. The idea here is to
 * create a layout grid (array) of rows x columns, which contains a reference
 * to the cell that that point in the grid (regardless of col/rowspan), such that
 * any column / row could be removed and the new grid constructed
 *  @param {node} thead The header/footer element for the table
 *  @returns {array} Calculated layout array
 *  @memberof DataTable#oApi
 */
function _fnDetectHeader ( settings, thead, write )
{
	var columns = settings.aoColumns;
	var rows = $(thead).children('tr');
	var row, cell;
	var i, k, l, iLen, shifted, column, colspan, rowspan;
	var isHeader = thead && thead.nodeName.toLowerCase() === 'thead';
	var layout = [];
	var unique;
	var shift = function ( a, i, j ) {
		var k = a[i];
		while ( k[j] ) {
			j++;
		}
		return j;
	};

	// We know how many rows there are in the layout - so prep it
	for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
		layout.push( [] );
	}

	for ( i=0, iLen=rows.length ; i<iLen ; i++ ) {
		row = rows[i];
		column = 0;

		// For every cell in the row..
		cell = row.firstChild;
		while ( cell ) {
			if (
				cell.nodeName.toUpperCase() == 'TD' ||
				cell.nodeName.toUpperCase() == 'TH'
			) {
				var cols = [];

				// Get the col and rowspan attributes from the DOM and sanitise them
				colspan = cell.getAttribute('colspan') * 1;
				rowspan = cell.getAttribute('rowspan') * 1;
				colspan = (!colspan || colspan===0 || colspan===1) ? 1 : colspan;
				rowspan = (!rowspan || rowspan===0 || rowspan===1) ? 1 : rowspan;

				// There might be colspan cells already in this row, so shift our target
				// accordingly
				shifted = shift( layout, i, column );

				// Cache calculation for unique columns
				unique = colspan === 1 ?
					true :
					false;
				
				// Perform header setup
				if ( write ) {
					if (unique) {
						// Allow column options to be set from HTML attributes
						_fnColumnOptions( settings, shifted, $(cell).data() );
						
						// Get the width for the column. This can be defined from the
						// width attribute, style attribute or `columns.width` option
						var columnDef = columns[shifted];
						var width = cell.getAttribute('width') || null;
						var t = cell.style.width.match(/width:\s*(\d+[pxem%]+)/);
						if ( t ) {
							width = t[1];
						}

						columnDef.sWidthOrig = columnDef.sWidth || width;

						if (isHeader) {
							// Column title handling - can be user set, or read from the DOM
							// This happens before the render, so the original is still in place
							if ( columnDef.sTitle !== null && ! columnDef.autoTitle ) {
								cell.innerHTML = columnDef.sTitle;
							}

							if (! columnDef.sTitle && unique) {
								columnDef.sTitle = cell.innerHTML.replace( /<.*?>/g, "" );
								columnDef.autoTitle = true;
							}
						}
						else {
							// Footer specific operations
							if (columnDef.footer) {
								cell.innerHTML = columnDef.footer;
							}
						}

						// Fall back to the aria-label attribute on the table header if no ariaTitle is
						// provided.
						if (! columnDef.ariaTitle) {
							columnDef.ariaTitle = $(cell).attr("aria-label") || columnDef.sTitle;
						}

						// Column specific class names
						if ( columnDef.className ) {
							$(cell).addClass( columnDef.className );
						}
					}

					// Wrap the column title so we can write to it in future
					if ( $('span.dt-column-title', cell).length === 0) {
						$('<span>')
							.addClass('dt-column-title')
							.append(cell.childNodes)
							.appendTo(cell);
					}

					if ( isHeader && $('span.dt-column-order', cell).length === 0) {
						$('<span>')
							.addClass('dt-column-order')
							.appendTo(cell);
					}
				}

				// If there is col / rowspan, copy the information into the layout grid
				for ( l=0 ; l<colspan ; l++ ) {
					for ( k=0 ; k<rowspan ; k++ ) {
						layout[i+k][shifted+l] = {
							cell: cell,
							unique: unique
						};

						layout[i+k].row = row;
					}

					cols.push( shifted+l );
				}

				// Assign an attribute so spanning cells can still be identified
				// as belonging to a column
				cell.setAttribute('data-dt-column', _unique(cols).join(','));
			}

			cell = cell.nextSibling;
		}
	}

	return layout;
}

/**
 * Set the start position for draw
 *  @param {object} oSettings dataTables settings object
 */
function _fnStart( oSettings )
{
	var bServerSide = _fnDataSource( oSettings ) == 'ssp';
	var iInitDisplayStart = oSettings.iInitDisplayStart;

	// Check and see if we have an initial draw position from state saving
	if ( iInitDisplayStart !== undefined && iInitDisplayStart !== -1 )
	{
		oSettings._iDisplayStart = bServerSide ?
			iInitDisplayStart :
			iInitDisplayStart >= oSettings.fnRecordsDisplay() ?
				0 :
				iInitDisplayStart;

		oSettings.iInitDisplayStart = -1;
	}
}

/**
 * Create an Ajax call based on the table's settings, taking into account that
 * parameters can have multiple forms, and backwards compatibility.
 *
 * @param {object} oSettings dataTables settings object
 * @param {array} data Data to send to the server, required by
 *     DataTables - may be augmented by developer callbacks
 * @param {function} fn Callback function to run when data is obtained
 */
function _fnBuildAjax( oSettings, data, fn )
{
	var ajaxData;
	var ajax = oSettings.ajax;
	var instance = oSettings.oInstance;
	var callback = function ( json ) {
		var status = oSettings.jqXHR
			? oSettings.jqXHR.status
			: null;

		if ( json === null || (typeof status === 'number' && status == 204 ) ) {
			json = {};
			_fnAjaxDataSrc( oSettings, json, [] );
		}

		var error = json.error || json.sError;
		if ( error ) {
			_fnLog( oSettings, 0, error );
		}

		oSettings.json = json;

		_fnCallbackFire( oSettings, null, 'xhr', [oSettings, json, oSettings.jqXHR], true );
		fn( json );
	};

	if ( $.isPlainObject( ajax ) && ajax.data )
	{
		ajaxData = ajax.data;

		var newData = typeof ajaxData === 'function' ?
			ajaxData( data, oSettings ) :  // fn can manipulate data or return
			ajaxData;                      // an object object or array to merge

		// If the function returned something, use that alone
		data = typeof ajaxData === 'function' && newData ?
			newData :
			$.extend( true, data, newData );

		// Remove the data property as we've resolved it already and don't want
		// jQuery to do it again (it is restored at the end of the function)
		delete ajax.data;
	}

	var baseAjax = {
		"url": typeof ajax === 'string' ?
			ajax :
			'',
		"data": data,
		"success": callback,
		"dataType": "json",
		"cache": false,
		"type": oSettings.sServerMethod,
		"error": function (xhr, error) {
			var ret = _fnCallbackFire( oSettings, null, 'xhr', [oSettings, null, oSettings.jqXHR], true );

			if ( ret.indexOf(true) === -1 ) {
				if ( error == "parsererror" ) {
					_fnLog( oSettings, 0, 'Invalid JSON response', 1 );
				}
				else if ( xhr.readyState === 4 ) {
					_fnLog( oSettings, 0, 'Ajax error', 7 );
				}
			}

			_fnProcessingDisplay( oSettings, false );
		}
	};

	// If `ajax` option is an object, extend and override our default base
	if ( $.isPlainObject( ajax ) ) {
		$.extend( baseAjax, ajax )
	}

	// Store the data submitted for the API
	oSettings.oAjaxData = data;

	// Allow plug-ins and external processes to modify the data
	_fnCallbackFire( oSettings, null, 'preXhr', [oSettings, data, baseAjax], true );

	if ( typeof ajax === 'function' )
	{
		// Is a function - let the caller define what needs to be done
		oSettings.jqXHR = ajax.call( instance, data, callback, oSettings );
	}
	else if (ajax.url === '') {
		// No url, so don't load any data. Just apply an empty data array
		// to the object for the callback.
		var empty = {};

		DataTable.util.set(ajax.dataSrc)(empty, []);
		callback(empty);
	}
	else {
		// Object to extend the base settings
		oSettings.jqXHR = $.ajax( baseAjax );

		// Restore for next time around
		if ( ajaxData ) {
			ajax.data = ajaxData;
		}
	}
}


/**
 * Update the table using an Ajax call
 *  @param {object} settings dataTables settings object
 *  @returns {boolean} Block the table drawing or not
 *  @memberof DataTable#oApi
 */
function _fnAjaxUpdate( settings )
{
	settings.iDraw++;
	_fnProcessingDisplay( settings, true );

	_fnBuildAjax(
		settings,
		_fnAjaxParameters( settings ),
		function(json) {
			_fnAjaxUpdateDraw( settings, json );
		}
	);
}


/**
 * Build up the parameters in an object needed for a server-side processing
 * request.
 *  @param {object} oSettings dataTables settings object
 *  @returns {bool} block the table drawing or not
 *  @memberof DataTable#oApi
 */
function _fnAjaxParameters( settings )
{
	var
		columns = settings.aoColumns,
		features = settings.oFeatures,
		preSearch = settings.oPreviousSearch,
		preColSearch = settings.aoPreSearchCols,
		colData = function ( idx, prop ) {
			return typeof columns[idx][prop] === 'function' ?
				'function' :
				columns[idx][prop];
		};

	return {
		draw: settings.iDraw,
		columns: columns.map( function ( column, i ) {
			return {
				data: colData(i, 'mData'),
				name: column.sName,
				searchable: column.bSearchable,
				orderable: column.bSortable,
				search: {
					value: preColSearch[i].search,
					regex: preColSearch[i].regex,
					fixed: Object.keys(column.searchFixed).map( function(name) {
						return {
							name: name,
							term: column.searchFixed[name].toString()
						}
					})
				}
			};
		} ),
		order: _fnSortFlatten( settings ).map( function ( val ) {
			return {
				column: val.col,
				dir: val.dir,
				name: colData(val.col, 'sName')
			};
		} ),
		start: settings._iDisplayStart,
		length: features.bPaginate ?
			settings._iDisplayLength :
			-1,
		search: {
			value: preSearch.search,
			regex: preSearch.regex,
			fixed: Object.keys(settings.searchFixed).map( function(name) {
				return {
					name: name,
					term: settings.searchFixed[name].toString()
				}
			})
		}
	};
}


/**
 * Data the data from the server (nuking the old) and redraw the table
 *  @param {object} oSettings dataTables settings object
 *  @param {object} json json data return from the server.
 *  @param {string} json.sEcho Tracking flag for DataTables to match requests
 *  @param {int} json.iTotalRecords Number of records in the data set, not accounting for filtering
 *  @param {int} json.iTotalDisplayRecords Number of records in the data set, accounting for filtering
 *  @param {array} json.aaData The data to display on this page
 *  @param {string} [json.sColumns] Column ordering (sName, comma separated)
 *  @memberof DataTable#oApi
 */
function _fnAjaxUpdateDraw ( settings, json )
{
	var data = _fnAjaxDataSrc(settings, json);
	var draw = _fnAjaxDataSrcParam(settings, 'draw', json);
	var recordsTotal = _fnAjaxDataSrcParam(settings, 'recordsTotal', json);
	var recordsFiltered = _fnAjaxDataSrcParam(settings, 'recordsFiltered', json);

	if ( draw !== undefined ) {
		// Protect against out of sequence returns
		if ( draw*1 < settings.iDraw ) {
			return;
		}
		settings.iDraw = draw * 1;
	}

	// No data in returned object, so rather than an array, we show an empty table
	if ( ! data ) {
		data = [];
	}

	_fnClearTable( settings );
	settings._iRecordsTotal   = parseInt(recordsTotal, 10);
	settings._iRecordsDisplay = parseInt(recordsFiltered, 10);

	for ( var i=0, ien=data.length ; i<ien ; i++ ) {
		_fnAddData( settings, data[i] );
	}
	settings.aiDisplay = settings.aiDisplayMaster.slice();

	_fnDraw( settings, true );
	_fnInitComplete( settings );
	_fnProcessingDisplay( settings, false );
}


/**
 * Get the data from the JSON data source to use for drawing a table. Using
 * `_fnGetObjectDataFn` allows the data to be sourced from a property of the
 * source object, or from a processing function.
 *  @param {object} settings dataTables settings object
 *  @param  {object} json Data source object / array from the server
 *  @return {array} Array of data to use
 */
function _fnAjaxDataSrc ( settings, json, write )
{
	var dataProp = 'data';

	if ($.isPlainObject( settings.ajax ) && settings.ajax.dataSrc !== undefined) {
		// Could in inside a `dataSrc` object, or not!
		var dataSrc = settings.ajax.dataSrc;

		// string, function and object are valid types
		if (typeof dataSrc === 'string' || typeof dataSrc === 'function') {
			dataProp = dataSrc;
		}
		else if (dataSrc.data !== undefined) {
			dataProp = dataSrc.data;
		}
	}

	if ( ! write ) {
		if ( dataProp === 'data' ) {
			// If the default, then we still want to support the old style, and safely ignore
			// it if possible
			return json.aaData || json[dataProp];
		}

		return dataProp !== "" ?
			_fnGetObjectDataFn( dataProp )( json ) :
			json;
	}
	
	// set
	_fnSetObjectDataFn( dataProp )( json, write );
}

/**
 * Very similar to _fnAjaxDataSrc, but for the other SSP properties
 * @param {*} settings DataTables settings object
 * @param {*} param Target parameter
 * @param {*} json JSON data
 * @returns Resolved value
 */
function _fnAjaxDataSrcParam (settings, param, json) {
	var dataSrc = $.isPlainObject( settings.ajax )
		? settings.ajax.dataSrc
		: null;

	if (dataSrc && dataSrc[param]) {
		// Get from custom location
		return _fnGetObjectDataFn( dataSrc[param] )( json );
	}

	// else - Default behaviour
	var old = '';

	// Legacy support
	if (param === 'draw') {
		old = 'sEcho';
	}
	else if (param === 'recordsTotal') {
		old = 'iTotalRecords';
	}
	else if (param === 'recordsFiltered') {
		old = 'iTotalDisplayRecords';
	}

	return json[old] !== undefined
		? json[old]
		: json[param];
}


/**
 * Filter the table using both the global filter and column based filtering
 *  @param {object} settings dataTables settings object
 *  @param {object} input search information
 *  @memberof DataTable#oApi
 */
function _fnFilterComplete ( settings, input )
{
	var columnsSearch = settings.aoPreSearchCols;

	// Resolve any column types that are unknown due to addition or invalidation
	// @todo As per sort - can this be moved into an event handler?
	_fnColumnTypes( settings );

	// In server-side processing all filtering is done by the server, so no point hanging around here
	if ( _fnDataSource( settings ) != 'ssp' )
	{
		// Check if any of the rows were invalidated
		_fnFilterData( settings );

		// Start from the full data set
		settings.aiDisplay = settings.aiDisplayMaster.slice();

		// Global filter first
		_fnFilter( settings.aiDisplay, settings, input.search, input );

		$.each(settings.searchFixed, function (name, term) {
			_fnFilter(settings.aiDisplay, settings, term, {});
		});

		// Then individual column filters
		for ( var i=0 ; i<columnsSearch.length ; i++ )
		{
			var col = columnsSearch[i];

			_fnFilter(
				settings.aiDisplay,
				settings,
				col.search,
				col,
				i
			);

			$.each(settings.aoColumns[i].searchFixed, function (name, term) {
				_fnFilter(settings.aiDisplay, settings, term, {}, i);
			});
		}

		// And finally global filtering
		_fnFilterCustom( settings );
	}

	// Tell the draw function we have been filtering
	settings.bFiltered = true;

	_fnCallbackFire( settings, null, 'search', [settings] );
}


/**
 * Apply custom filtering functions
 * 
 * This is legacy now that we have named functions, but it is widely used
 * from 1.x, so it is not yet deprecated.
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnFilterCustom( settings )
{
	var filters = DataTable.ext.search;
	var displayRows = settings.aiDisplay;
	var row, rowIdx;

	for ( var i=0, ien=filters.length ; i<ien ; i++ ) {
		var rows = [];

		// Loop over each row and see if it should be included
		for ( var j=0, jen=displayRows.length ; j<jen ; j++ ) {
			rowIdx = displayRows[ j ];
			row = settings.aoData[ rowIdx ];

			if ( filters[i]( settings, row._aFilterData, rowIdx, row._aData, j ) ) {
				rows.push( rowIdx );
			}
		}

		// So the array reference doesn't break set the results into the
		// existing array
		displayRows.length = 0;
		displayRows.push.apply(displayRows, rows);
	}
}


/**
 * Filter the data table based on user input and draw the table
 */
function _fnFilter( searchRows, settings, input, options, column )
{
	if ( input === '' ) {
		return;
	}

	var i = 0;

	// Search term can be a function, regex or string - if a string we apply our
	// smart filtering regex (assuming the options require that)
	var searchFunc = typeof input === 'function' ? input : null;
	var rpSearch = input instanceof RegExp
		? input
		: searchFunc
			? null
			: _fnFilterCreateSearch( input, options );

	// Then for each row, does the test pass. If not, lop the row from the array
	while (i < searchRows.length) {
		var row = settings.aoData[ searchRows[i] ];
		var data = column === undefined
			? row._sFilterRow
			: row._aFilterData[ column ];

		if ( (searchFunc && ! searchFunc(data, row._aData, searchRows[i], column)) || (rpSearch && ! rpSearch.test(data)) ) {
			searchRows.splice(i, 1);
			i--;
		}

		i++;
	}
}


/**
 * Build a regular expression object suitable for searching a table
 *  @param {string} sSearch string to search for
 *  @param {bool} bRegex treat as a regular expression or not
 *  @param {bool} bSmart perform smart filtering or not
 *  @param {bool} bCaseInsensitive Do case insensitive matching or not
 *  @returns {RegExp} constructed object
 *  @memberof DataTable#oApi
 */
function _fnFilterCreateSearch( search, inOpts )
{
	var not = [];
	var options = $.extend({}, {
		boundary: false,
		caseInsensitive: true,
		exact: false,
		regex: false,
		smart: true
	}, inOpts);

	if (typeof search !== 'string') {
		search = search.toString();
	}

	// Remove diacritics if normalize is set up to do so
	search = _normalize(search);

	if (options.exact) {
		return new RegExp(
			'^'+_fnEscapeRegex(search)+'$',
			options.caseInsensitive ? 'i' : ''
		);
	}

	search = options.regex ?
		search :
		_fnEscapeRegex( search );
	
	if ( options.smart ) {
		/* For smart filtering we want to allow the search to work regardless of
		 * word order. We also want double quoted text to be preserved, so word
		 * order is important - a la google. And a negative look around for
		 * finding rows which don't contain a given string.
		 * 
		 * So this is the sort of thing we want to generate:
		 * 
		 * ^(?=.*?\bone\b)(?=.*?\btwo three\b)(?=.*?\bfour\b).*$
		 */
		var parts = search.match( /!?["\u201C][^"\u201D]+["\u201D]|[^ ]+/g ) || [''];
		var a = parts.map( function ( word ) {
			var negative = false;
			var m;

			// Determine if it is a "does not include"
			if ( word.charAt(0) === '!' ) {
				negative = true;
				word = word.substring(1);
			}

			// Strip the quotes from around matched phrases
			if ( word.charAt(0) === '"' ) {
				m = word.match( /^"(.*)"$/ );
				word = m ? m[1] : word;
			}
			else if ( word.charAt(0) === '\u201C' ) {
				// Smart quote match (iPhone users)
				m = word.match( /^\u201C(.*)\u201D$/ );
				word = m ? m[1] : word;
			}

			// For our "not" case, we need to modify the string that is
			// allowed to match at the end of the expression.
			if (negative) {
				if (word.length > 1) {
					not.push('(?!'+word+')');
				}

				word = '';
			}

			return word.replace('"', '');
		} );

		var match = not.length
			? not.join('')
			: '';

		var boundary = options.boundary
			? '\\b'
			: '';

		search = '^(?=.*?'+boundary+a.join( ')(?=.*?'+boundary )+')('+match+'.)*$';
	}

	return new RegExp( search, options.caseInsensitive ? 'i' : '' );
}


/**
 * Escape a string such that it can be used in a regular expression
 *  @param {string} sVal string to escape
 *  @returns {string} escaped string
 *  @memberof DataTable#oApi
 */
var _fnEscapeRegex = DataTable.util.escapeRegex;

var __filter_div = $('<div>')[0];
var __filter_div_textContent = __filter_div.textContent !== undefined;

// Update the filtering data for each row if needed (by invalidation or first run)
function _fnFilterData ( settings )
{
	var columns = settings.aoColumns;
	var data = settings.aoData;
	var column;
	var j, jen, filterData, cellData, row;
	var wasInvalidated = false;

	for ( var rowIdx=0 ; rowIdx<data.length ; rowIdx++ ) {
		if (! data[rowIdx]) {
			continue;
		}

		row = data[rowIdx];

		if ( ! row._aFilterData ) {
			filterData = [];

			for ( j=0, jen=columns.length ; j<jen ; j++ ) {
				column = columns[j];

				if ( column.bSearchable ) {
					cellData = _fnGetCellData( settings, rowIdx, j, 'filter' );

					// Search in DataTables is string based
					if ( cellData === null ) {
						cellData = '';
					}

					if ( typeof cellData !== 'string' && cellData.toString ) {
						cellData = cellData.toString();
					}
				}
				else {
					cellData = '';
				}

				// If it looks like there is an HTML entity in the string,
				// attempt to decode it so sorting works as expected. Note that
				// we could use a single line of jQuery to do this, but the DOM
				// method used here is much faster https://jsperf.com/html-decode
				if ( cellData.indexOf && cellData.indexOf('&') !== -1 ) {
					__filter_div.innerHTML = cellData;
					cellData = __filter_div_textContent ?
						__filter_div.textContent :
						__filter_div.innerText;
				}

				if ( cellData.replace ) {
					cellData = cellData.replace(/[\r\n\u2028]/g, '');
				}

				filterData.push( cellData );
			}

			row._aFilterData = filterData;
			row._sFilterRow = filterData.join('  ');
			wasInvalidated = true;
		}
	}

	return wasInvalidated;
}


/**
 * Draw the table for the first time, adding all required features
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnInitialise ( settings )
{
	var i, iAjaxStart=settings.iInitDisplayStart;

	/* Ensure that the table data is fully initialised */
	if ( ! settings.bInitialised ) {
		setTimeout( function(){ _fnInitialise( settings ); }, 200 );
		return;
	}

	/* Build and draw the header / footer for the table */
	_fnBuildHead( settings, 'header' );
	_fnBuildHead( settings, 'footer' );
	_fnDrawHead( settings, settings.aoHeader );
	_fnDrawHead( settings, settings.aoFooter );

	// Enable features
	_fnAddOptionsHtml( settings );
	_fnSortInit( settings );

	_colGroup( settings );

	/* Okay to show that something is going on now */
	_fnProcessingDisplay( settings, true );

	_fnCallbackFire( settings, null, 'preInit', [settings], true );

	// If there is default sorting required - let's do it. The sort function
	// will do the drawing for us. Otherwise we draw the table regardless of the
	// Ajax source - this allows the table to look initialised for Ajax sourcing
	// data (show 'loading' message possibly)
	_fnReDraw( settings );

	var dataSrc = _fnDataSource( settings );

	// Server-side processing init complete is done by _fnAjaxUpdateDraw
	if ( dataSrc != 'ssp' ) {
		// if there is an ajax source load the data
		if ( dataSrc == 'ajax' ) {
			_fnBuildAjax( settings, {}, function(json) {
				var aData = _fnAjaxDataSrc( settings, json );

				// Got the data - add it to the table
				for ( i=0 ; i<aData.length ; i++ ) {
					_fnAddData( settings, aData[i] );
				}

				// Reset the init display for cookie saving. We've already done
				// a filter, and therefore cleared it before. So we need to make
				// it appear 'fresh'
				settings.iInitDisplayStart = iAjaxStart;

				_fnReDraw( settings );
				_fnProcessingDisplay( settings, false );
				_fnInitComplete( settings );
			}, settings );
		}
		else {
			_fnInitComplete( settings );
			_fnProcessingDisplay( settings, false );
		}
	}
}


/**
 * Draw the table for the first time, adding all required features
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnInitComplete ( settings )
{
	if (settings._bInitComplete) {
		return;
	}

	var args = [settings, settings.json];

	settings._bInitComplete = true;

	// Table is fully set up and we have data, so calculate the
	// column widths
	_fnAdjustColumnSizing( settings );

	_fnCallbackFire( settings, null, 'plugin-init', args, true );
	_fnCallbackFire( settings, 'aoInitComplete', 'init', args, true );
}

function _fnLengthChange ( settings, val )
{
	var len = parseInt( val, 10 );
	settings._iDisplayLength = len;

	_fnLengthOverflow( settings );

	// Fire length change event
	_fnCallbackFire( settings, null, 'length', [settings, len] );
}

/**
 * Alter the display settings to change the page
 *  @param {object} settings DataTables settings object
 *  @param {string|int} action Paging action to take: "first", "previous",
 *    "next" or "last" or page number to jump to (integer)
 *  @param [bool] redraw Automatically draw the update or not
 *  @returns {bool} true page has changed, false - no change
 *  @memberof DataTable#oApi
 */
function _fnPageChange ( settings, action, redraw )
{
	var
		start     = settings._iDisplayStart,
		len       = settings._iDisplayLength,
		records   = settings.fnRecordsDisplay();

	if ( records === 0 || len === -1 )
	{
		start = 0;
	}
	else if ( typeof action === "number" )
	{
		start = action * len;

		if ( start > records )
		{
			start = 0;
		}
	}
	else if ( action == "first" )
	{
		start = 0;
	}
	else if ( action == "previous" )
	{
		start = len >= 0 ?
			start - len :
			0;

		if ( start < 0 )
		{
			start = 0;
		}
	}
	else if ( action == "next" )
	{
		if ( start + len < records )
		{
			start += len;
		}
	}
	else if ( action == "last" )
	{
		start = Math.floor( (records-1) / len) * len;
	}
	else if ( action === 'ellipsis' )
	{
		return;
	}
	else
	{
		_fnLog( settings, 0, "Unknown paging action: "+action, 5 );
	}

	var changed = settings._iDisplayStart !== start;
	settings._iDisplayStart = start;

	_fnCallbackFire( settings, null, changed ? 'page' : 'page-nc', [settings] );

	if ( changed && redraw ) {
		_fnDraw( settings );
	}

	return changed;
}


/**
 * Generate the node required for the processing node
 *  @param {object} settings DataTables settings object
 */
function _processingHtml ( settings )
{
	var table = settings.nTable;

	if ( settings.oFeatures.bProcessing ) {
		var n = $('<div/>', {
				'id': settings.sTableId + '_processing',
				'class': settings.oClasses.processing.container,
				'role': 'status'
			} )
			.html( settings.oLanguage.sProcessing )
			.append('<div><div></div><div></div><div></div><div></div></div>')
			.insertBefore( table );
		
		$(table).on( 'processing.dt.DT', function (e, s, show) {
			n.css( 'display', show ? 'block' : 'none' );
		} );
	}
}


/**
 * Display or hide the processing indicator
 *  @param {object} settings DataTables settings object
 *  @param {bool} show Show the processing indicator (true) or not (false)
 */
function _fnProcessingDisplay ( settings, show )
{
	_fnCallbackFire( settings, null, 'processing', [settings, show] );
}
/**
 * Add any control elements for the table - specifically scrolling
 *  @param {object} settings dataTables settings object
 *  @returns {node} Node to add to the DOM
 *  @memberof DataTable#oApi
 */
function _fnFeatureHtmlTable ( settings )
{
	var table = $(settings.nTable);

	// Scrolling from here on in
	var scroll = settings.oScroll;

	if ( scroll.sX === '' && scroll.sY === '' ) {
		return settings.nTable;
	}

	var scrollX = scroll.sX;
	var scrollY = scroll.sY;
	var classes = settings.oClasses.scrolling;
	var caption = settings.captionNode;
	var captionSide = caption ? caption._captionSide : null;
	var headerClone = $( table[0].cloneNode(false) );
	var footerClone = $( table[0].cloneNode(false) );
	var footer = table.children('tfoot');
	var _div = '<div/>';
	var size = function ( s ) {
		return !s ? null : _fnStringToCss( s );
	};

	if ( ! footer.length ) {
		footer = null;
	}

	/*
	 * The HTML structure that we want to generate in this function is:
	 *  div - scroller
	 *    div - scroll head
	 *      div - scroll head inner
	 *        table - scroll head table
	 *          thead - thead
	 *    div - scroll body
	 *      table - table (master table)
	 *        thead - thead clone for sizing
	 *        tbody - tbody
	 *    div - scroll foot
	 *      div - scroll foot inner
	 *        table - scroll foot table
	 *          tfoot - tfoot
	 */
	var scroller = $( _div, { 'class': classes.container } )
		.append(
			$(_div, { 'class': classes.header.self } )
				.css( {
					overflow: 'hidden',
					position: 'relative',
					border: 0,
					width: scrollX ? size(scrollX) : '100%'
				} )
				.append(
					$(_div, { 'class': classes.header.inner } )
						.css( {
							'box-sizing': 'content-box',
							width: scroll.sXInner || '100%'
						} )
						.append(
							headerClone
								.removeAttr('id')
								.css( 'margin-left', 0 )
								.append( captionSide === 'top' ? caption : null )
								.append(
									table.children('thead')
								)
						)
				)
		)
		.append(
			$(_div, { 'class': classes.body } )
				.css( {
					position: 'relative',
					overflow: 'auto',
					width: size( scrollX )
				} )
				.append( table )
		);

	if ( footer ) {
		scroller.append(
			$(_div, { 'class': classes.footer.self } )
				.css( {
					overflow: 'hidden',
					border: 0,
					width: scrollX ? size(scrollX) : '100%'
				} )
				.append(
					$(_div, { 'class': classes.footer.inner } )
						.append(
							footerClone
								.removeAttr('id')
								.css( 'margin-left', 0 )
								.append( captionSide === 'bottom' ? caption : null )
								.append(
									table.children('tfoot')
								)
						)
				)
		);
	}

	var children = scroller.children();
	var scrollHead = children[0];
	var scrollBody = children[1];
	var scrollFoot = footer ? children[2] : null;

	// When the body is scrolled, then we also want to scroll the headers
	$(scrollBody).on( 'scroll.DT', function () {
		var scrollLeft = this.scrollLeft;

		scrollHead.scrollLeft = scrollLeft;

		if ( footer ) {
			scrollFoot.scrollLeft = scrollLeft;
		}
	} );

	// When focus is put on the header cells, we might need to scroll the body
	$('th, td', scrollHead).on('focus', function () {
		var scrollLeft = scrollHead.scrollLeft;

		scrollBody.scrollLeft = scrollLeft;

		if ( footer ) {
			scrollBody.scrollLeft = scrollLeft;
		}
	});

	$(scrollBody).css('max-height', scrollY);
	if (! scroll.bCollapse) {
		$(scrollBody).css('height', scrollY);
	}

	settings.nScrollHead = scrollHead;
	settings.nScrollBody = scrollBody;
	settings.nScrollFoot = scrollFoot;

	// On redraw - align columns
	settings.aoDrawCallback.push(_fnScrollDraw);

	return scroller[0];
}



/**
 * Update the header, footer and body tables for resizing - i.e. column
 * alignment.
 *
 * Welcome to the most horrible function DataTables. The process that this
 * function follows is basically:
 *   1. Re-create the table inside the scrolling div
 *   2. Correct colgroup > col values if needed
 *   3. Copy colgroup > col over to header and footer
 *   4. Clean up
 *
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnScrollDraw ( settings )
{
	// Given that this is such a monster function, a lot of variables are use
	// to try and keep the minimised size as small as possible
	var
		scroll         = settings.oScroll,
		barWidth       = scroll.iBarWidth,
		divHeader      = $(settings.nScrollHead),
		divHeaderInner = divHeader.children('div'),
		divHeaderTable = divHeaderInner.children('table'),
		divBodyEl      = settings.nScrollBody,
		divBody        = $(divBodyEl),
		divFooter      = $(settings.nScrollFoot),
		divFooterInner = divFooter.children('div'),
		divFooterTable = divFooterInner.children('table'),
		header         = $(settings.nTHead),
		table          = $(settings.nTable),
		footer         = settings.nTFoot && $('th, td', settings.nTFoot).length ? $(settings.nTFoot) : null,
		browser        = settings.oBrowser,
		headerCopy, footerCopy;

	// If the scrollbar visibility has changed from the last draw, we need to
	// adjust the column sizes as the table width will have changed to account
	// for the scrollbar
	var scrollBarVis = divBodyEl.scrollHeight > divBodyEl.clientHeight;
	
	if ( settings.scrollBarVis !== scrollBarVis && settings.scrollBarVis !== undefined ) {
		settings.scrollBarVis = scrollBarVis;
		_fnAdjustColumnSizing( settings );
		return; // adjust column sizing will call this function again
	}
	else {
		settings.scrollBarVis = scrollBarVis;
	}

	// 1. Re-create the table inside the scrolling div
	// Remove the old minimised thead and tfoot elements in the inner table
	table.children('thead, tfoot').remove();

	// Clone the current header and footer elements and then place it into the inner table
	headerCopy = header.clone().prependTo( table );
	headerCopy.find('th, td').removeAttr('tabindex');
	headerCopy.find('[id]').removeAttr('id');

	if ( footer ) {
		footerCopy = footer.clone().prependTo( table );
		footerCopy.find('[id]').removeAttr('id');
	}

	// 2. Correct colgroup > col values if needed
	// It is possible that the cell sizes are smaller than the content, so we need to
	// correct colgroup>col for such cases. This can happen if the auto width detection
	// uses a cell which has a longer string, but isn't the widest! For example 
	// "Chief Executive Officer (CEO)" is the longest string in the demo, but
	// "Systems Administrator" is actually the widest string since it doesn't collapse.
	if (settings.aiDisplay.length) {
		// Get the column sizes from the first row in the table
		var colSizes = table.find('tbody tr').eq(0).find('th, td').map(function () {
			return $(this).outerWidth();
		});

		// Check against what the colgroup > col is set to and correct if needed
		$('col', settings.colgroup).each(function (i) {
			var colWidth = this.style.width.replace('px', '');

			if (colWidth !== colSizes[i]) {
				this.style.width = colSizes[i] + 'px';
			}
		});
	}

	// 3. Copy the colgroup over to the header and footer
	divHeaderTable
		.find('colgroup')
		.remove();

	divHeaderTable.append(settings.colgroup.clone());

	if ( footer ) {
		divFooterTable
			.find('colgroup')
			.remove();

		divFooterTable.append(settings.colgroup.clone());
	}

	// "Hide" the header and footer that we used for the sizing. We need to keep
	// the content of the cell so that the width applied to the header and body
	// both match, but we want to hide it completely.
	$('th, td', headerCopy).each(function () {
		$(this.childNodes).wrapAll('<div class="dt-scroll-sizing">');
	});

	if ( footer ) {
		$('th, td', footerCopy).each(function () {
			$(this.childNodes).wrapAll('<div class="dt-scroll-sizing">');
		});
	}

	// 4. Clean up
	// Figure out if there are scrollbar present - if so then we need a the header and footer to
	// provide a bit more space to allow "overflow" scrolling (i.e. past the scrollbar)
	var isScrolling = Math.floor(table.height()) > divBodyEl.clientHeight || divBody.css('overflow-y') == "scroll";
	var paddingSide = 'padding' + (browser.bScrollbarLeft ? 'Left' : 'Right' );

	// Set the width's of the header and footer tables
	var outerWidth = table.outerWidth();

	divHeaderTable.css('width', _fnStringToCss( outerWidth ));
	divHeaderInner
		.css('width', _fnStringToCss( outerWidth ))
		.css(paddingSide, isScrolling ? barWidth+"px" : "0px");

	if ( footer ) {
		divFooterTable.css('width', _fnStringToCss( outerWidth ));
		divFooterInner
			.css('width', _fnStringToCss( outerWidth ))
			.css(paddingSide, isScrolling ? barWidth+"px" : "0px");
	}

	// Correct DOM ordering for colgroup - comes before the thead
	table.children('colgroup').prependTo(table);

	// Adjust the position of the header in case we loose the y-scrollbar
	divBody.trigger('scroll');

	// If sorting or filtering has occurred, jump the scrolling back to the top
	// only if we aren't holding the position
	if ( (settings.bSorted || settings.bFiltered) && ! settings._drawHold ) {
		divBodyEl.scrollTop = 0;
	}
}

/**
 * Calculate the width of columns for the table
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnCalculateColumnWidths ( settings )
{
	// Not interested in doing column width calculation if auto-width is disabled
	if (! settings.oFeatures.bAutoWidth) {
		return;
	}

	var
		table = settings.nTable,
		columns = settings.aoColumns,
		scroll = settings.oScroll,
		scrollY = scroll.sY,
		scrollX = scroll.sX,
		scrollXInner = scroll.sXInner,
		visibleColumns = _fnGetColumns( settings, 'bVisible' ),
		tableWidthAttr = table.getAttribute('width'), // from DOM element
		tableContainer = table.parentNode,
		i, column, columnIdx;

	var styleWidth = table.style.width;
	if ( styleWidth && styleWidth.indexOf('%') !== -1 ) {
		tableWidthAttr = styleWidth;
	}

	// Let plug-ins know that we are doing a recalc, in case they have changed any of the
	// visible columns their own way (e.g. Responsive uses display:none).
	_fnCallbackFire(
		settings,
		null,
		'column-calc',
		{visible: visibleColumns},
		false
	);

	// Construct a single row, worst case, table with the widest
	// node in the data, assign any user defined widths, then insert it into
	// the DOM and allow the browser to do all the hard work of calculating
	// table widths
	var tmpTable = $(table.cloneNode())
		.css( 'visibility', 'hidden' )
		.removeAttr( 'id' );

	// Clean up the table body
	tmpTable.append('<tbody>')
	var tr = $('<tr/>').appendTo( tmpTable.find('tbody') );

	// Clone the table header and footer - we can't use the header / footer
	// from the cloned table, since if scrolling is active, the table's
	// real header and footer are contained in different table tags
	tmpTable
		.append( $(settings.nTHead).clone() )
		.append( $(settings.nTFoot).clone() );

	// Remove any assigned widths from the footer (from scrolling)
	tmpTable.find('tfoot th, tfoot td').css('width', '');

	// Apply custom sizing to the cloned header
	tmpTable.find('thead th, thead td').each( function () {
		// Get the `width` from the header layout
		var width = _fnColumnsSumWidth( settings, this, true, false );

		if ( width ) {
			this.style.width = width;

			// For scrollX we need to force the column width otherwise the
			// browser will collapse it. If this width is smaller than the
			// width the column requires, then it will have no effect
			if ( scrollX ) {
				$( this ).append( $('<div/>').css( {
					width: width,
					margin: 0,
					padding: 0,
					border: 0,
					height: 1
				} ) );
			}
		}
		else {
			this.style.width = '';
		}
	} );

	// Find the widest piece of data for each column and put it into the table
	for ( i=0 ; i<visibleColumns.length ; i++ ) {
		columnIdx = visibleColumns[i];
		column = columns[ columnIdx ];

		var longest = _fnGetMaxLenString(settings, columnIdx);
		var autoClass = _ext.type.className[column.sType];
		var text = longest + column.sContentPadding;
		var insert = longest.indexOf('<') === -1
			? document.createTextNode(text)
			: text
		
		$('<td/>')
			.addClass(autoClass)
			.addClass(column.sClass)
			.append(insert)
			.appendTo(tr);
	}

	// Tidy the temporary table - remove name attributes so there aren't
	// duplicated in the dom (radio elements for example)
	$('[name]', tmpTable).removeAttr('name');

	// Table has been built, attach to the document so we can work with it.
	// A holding element is used, positioned at the top of the container
	// with minimal height, so it has no effect on if the container scrolls
	// or not. Otherwise it might trigger scrolling when it actually isn't
	// needed
	var holder = $('<div/>').css( scrollX || scrollY ?
			{
				position: 'absolute',
				top: 0,
				left: 0,
				height: 1,
				right: 0,
				overflow: 'hidden'
			} :
			{}
		)
		.append( tmpTable )
		.appendTo( tableContainer );

	// When scrolling (X or Y) we want to set the width of the table as 
	// appropriate. However, when not scrolling leave the table width as it
	// is. This results in slightly different, but I think correct behaviour
	if ( scrollX && scrollXInner ) {
		tmpTable.width( scrollXInner );
	}
	else if ( scrollX ) {
		tmpTable.css( 'width', 'auto' );
		tmpTable.removeAttr('width');

		// If there is no width attribute or style, then allow the table to
		// collapse
		if ( tmpTable.width() < tableContainer.clientWidth && tableWidthAttr ) {
			tmpTable.width( tableContainer.clientWidth );
		}
	}
	else if ( scrollY ) {
		tmpTable.width( tableContainer.clientWidth );
	}
	else if ( tableWidthAttr ) {
		tmpTable.width( tableWidthAttr );
	}

	// Get the width of each column in the constructed table
	var total = 0;
	var bodyCells = tmpTable.find('tbody tr').eq(0).children();

	for ( i=0 ; i<visibleColumns.length ; i++ ) {
		// Use getBounding for sub-pixel accuracy, which we then want to round up!
		var bounding = bodyCells[i].getBoundingClientRect().width;

		// Total is tracked to remove any sub-pixel errors as the outerWidth
		// of the table might not equal the total given here
		total += bounding;

		// Width for each column to use
		columns[ visibleColumns[i] ].sWidth = _fnStringToCss( bounding );
	}

	table.style.width = _fnStringToCss( total );

	// Finished with the table - ditch it
	holder.remove();

	// If there is a width attr, we want to attach an event listener which
	// allows the table sizing to automatically adjust when the window is
	// resized. Use the width attr rather than CSS, since we can't know if the
	// CSS is a relative value or absolute - DOM read is always px.
	if ( tableWidthAttr ) {
		table.style.width = _fnStringToCss( tableWidthAttr );
	}

	if ( (tableWidthAttr || scrollX) && ! settings._reszEvt ) {
		var bindResize = function () {
			$(window).on('resize.DT-'+settings.sInstance, DataTable.util.throttle( function () {
				if (! settings.bDestroying) {
					_fnAdjustColumnSizing( settings );
				}
			} ) );
		};

		bindResize();

		settings._reszEvt = true;
	}
}


/**
 * Get the maximum strlen for each data column
 *  @param {object} settings dataTables settings object
 *  @param {int} colIdx column of interest
 *  @returns {string} string of the max length
 *  @memberof DataTable#oApi
 */
function _fnGetMaxLenString( settings, colIdx )
{
	var column = settings.aoColumns[colIdx];

	if (! column.maxLenString) {
		var s, max='', maxLen = -1;
	
		for ( var i=0, ien=settings.aiDisplayMaster.length ; i<ien ; i++ ) {
			var rowIdx = settings.aiDisplayMaster[i];
			var data = _fnGetRowDisplay(settings, rowIdx)[colIdx];

			var cellString = data && typeof data === 'object' && data.nodeType
				? data.innerHTML
				: data+'';

			// Remove id / name attributes from elements so they
			// don't interfere with existing elements
			cellString = cellString
				.replace(/id=".*?"/g, '')
				.replace(/name=".*?"/g, '');

			s = _stripHtml(cellString)
				.replace( /&nbsp;/g, ' ' );
	
			if ( s.length > maxLen ) {
				// We want the HTML in the string, but the length that
				// is important is the stripped string
				max = cellString;
				maxLen = s.length;
			}
		}

		column.maxLenString = max;
	}

	return column.maxLenString;
}


/**
 * Append a CSS unit (only if required) to a string
 *  @param {string} value to css-ify
 *  @returns {string} value with css unit
 *  @memberof DataTable#oApi
 */
function _fnStringToCss( s )
{
	if ( s === null ) {
		return '0px';
	}

	if ( typeof s == 'number' ) {
		return s < 0 ?
			'0px' :
			s+'px';
	}

	// Check it has a unit character already
	return s.match(/\d$/) ?
		s+'px' :
		s;
}

/**
 * Re-insert the `col` elements for current visibility
 *
 * @param {*} settings DT settings
 */
function _colGroup( settings ) {
	var cols = settings.aoColumns;

	settings.colgroup.empty();

	for (i=0 ; i<cols.length ; i++) {
		if (cols[i].bVisible) {
			settings.colgroup.append(cols[i].colEl);
		}
	}
}


function _fnSortInit( settings ) {
	var target = settings.nTHead;
	var headerRows = target.querySelectorAll('tr');
	var legacyTop = settings.bSortCellsTop;
	var notSelector = ':not([data-dt-order="disable"]):not([data-dt-order="icon-only"])';
	
	// Legacy support for `orderCellsTop`
	if (legacyTop === true) {
		target = headerRows[0];
	}
	else if (legacyTop === false) {
		target = headerRows[ headerRows.length - 1 ];
	}

	_fnSortAttachListener(
		settings,
		target,
		target === settings.nTHead
			? 'tr'+notSelector+' th'+notSelector+', tr'+notSelector+' td'+notSelector
			: 'th'+notSelector+', td'+notSelector
	);

	// Need to resolve the user input array into our internal structure
	var order = [];
	_fnSortResolve( settings, order, settings.aaSorting );

	settings.aaSorting = order;
}


function _fnSortAttachListener(settings, node, selector, column, callback) {
	_fnBindAction( node, selector, function (e) {
		var run = false;
		var columns = column === undefined
			? _fnColumnsFromHeader( e.target )
			: [column];

		if ( columns.length ) {
			for ( var i=0, ien=columns.length ; i<ien ; i++ ) {
				var ret = _fnSortAdd( settings, columns[i], i, e.shiftKey );

				if (ret !== false) {
					run = true;
				}					

				// If the first entry is no sort, then subsequent
				// sort columns are ignored
				if (settings.aaSorting.length === 1 && settings.aaSorting[0][1] === '') {
					break;
				}
			}

			if (run) {
				_fnProcessingDisplay( settings, true );

				// Allow the processing display to show
				setTimeout( function () {
					_fnSort( settings );
					_fnSortDisplay( settings, settings.aiDisplay );

					// Sort processing done - redraw has its own processing display
					_fnProcessingDisplay( settings, false );

					_fnReDraw( settings, false, false );

					if (callback) {
						callback();
					}
				}, 0);
			}
		}
	} );
}

/**
 * Sort the display array to match the master's order
 * @param {*} settings
 */
function _fnSortDisplay(settings, display) {
	var master = settings.aiDisplayMaster;
	var masterMap = {};
	var map = {};
	var i;

	// Rather than needing an `indexOf` on master array, we can create a map
	for (i=0 ; i<master.length ; i++) {
		masterMap[master[i]] = i;
	}

	// And then cache what would be the indexOf fom the display
	for (i=0 ; i<display.length ; i++) {
		map[display[i]] = masterMap[display[i]];
	}

	display.sort(function(a, b){
		// Short version of this function is simply `master.indexOf(a) - master.indexOf(b);`
		return map[a] - map[b];
	});
}


function _fnSortResolve (settings, nestedSort, sort) {
	var push = function ( a ) {
		if ($.isPlainObject(a)) {
			if (a.idx !== undefined) {
				// Index based ordering
				nestedSort.push([a.idx, a.dir]);
			}
			else if (a.name) {
				// Name based ordering
				var cols = _pluck( settings.aoColumns, 'sName');
				var idx = cols.indexOf(a.name);

				if (idx !== -1) {
					nestedSort.push([idx, a.dir]);
				}
			}
		}
		else {
			// Plain column index and direction pair
			nestedSort.push(a);
		}
	};

	if ( $.isPlainObject(sort) ) {
		// Object
		push(sort);
	}
	else if ( sort.length && typeof sort[0] === 'number' ) {
		// 1D array
		push(sort);
	}
	else if ( sort.length ) {
		// 2D array
		for (var z=0; z<sort.length; z++) {
			push(sort[z]); // Object or array
		}
	}
}


function _fnSortFlatten ( settings )
{
	var
		i, k, kLen,
		aSort = [],
		extSort = DataTable.ext.type.order,
		aoColumns = settings.aoColumns,
		aDataSort, iCol, sType, srcCol,
		fixed = settings.aaSortingFixed,
		fixedObj = $.isPlainObject( fixed ),
		nestedSort = [];
	
	if ( ! settings.oFeatures.bSort ) {
		return aSort;
	}

	// Build the sort array, with pre-fix and post-fix options if they have been
	// specified
	if ( Array.isArray( fixed ) ) {
		_fnSortResolve( settings, nestedSort, fixed );
	}

	if ( fixedObj && fixed.pre ) {
		_fnSortResolve( settings, nestedSort, fixed.pre );
	}

	_fnSortResolve( settings, nestedSort, settings.aaSorting );

	if (fixedObj && fixed.post ) {
		_fnSortResolve( settings, nestedSort, fixed.post );
	}

	for ( i=0 ; i<nestedSort.length ; i++ )
	{
		srcCol = nestedSort[i][0];

		if ( aoColumns[ srcCol ] ) {
			aDataSort = aoColumns[ srcCol ].aDataSort;

			for ( k=0, kLen=aDataSort.length ; k<kLen ; k++ )
			{
				iCol = aDataSort[k];
				sType = aoColumns[ iCol ].sType || 'string';

				if ( nestedSort[i]._idx === undefined ) {
					nestedSort[i]._idx = aoColumns[iCol].asSorting.indexOf(nestedSort[i][1]);
				}

				if ( nestedSort[i][1] ) {
					aSort.push( {
						src:       srcCol,
						col:       iCol,
						dir:       nestedSort[i][1],
						index:     nestedSort[i]._idx,
						type:      sType,
						formatter: extSort[ sType+"-pre" ],
						sorter:    extSort[ sType+"-"+nestedSort[i][1] ]
					} );
				}
			}
		}
	}

	return aSort;
}

/**
 * Change the order of the table
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnSort ( oSettings, col, dir )
{
	var
		i, ien, iLen,
		aiOrig = [],
		extSort = DataTable.ext.type.order,
		aoData = oSettings.aoData,
		sortCol,
		displayMaster = oSettings.aiDisplayMaster,
		aSort;

	// Resolve any column types that are unknown due to addition or invalidation
	// @todo Can this be moved into a 'data-ready' handler which is called when
	//   data is going to be used in the table?
	_fnColumnTypes( oSettings );

	// Allow a specific column to be sorted, which will _not_ alter the display
	// master
	if (col !== undefined) {
		var srcCol = oSettings.aoColumns[col];
		aSort = [{
			src:       col,
			col:       col,
			dir:       dir,
			index:     0,
			type:      srcCol.sType,
			formatter: extSort[ srcCol.sType+"-pre" ],
			sorter:    extSort[ srcCol.sType+"-"+dir ]
		}];
		displayMaster = displayMaster.slice();
	}
	else {
		aSort = _fnSortFlatten( oSettings );
	}

	for ( i=0, ien=aSort.length ; i<ien ; i++ ) {
		sortCol = aSort[i];

		// Load the data needed for the sort, for each cell
		_fnSortData( oSettings, sortCol.col );
	}

	/* No sorting required if server-side or no sorting array */
	if ( _fnDataSource( oSettings ) != 'ssp' && aSort.length !== 0 )
	{
		// Reset the initial positions on each pass so we get a stable sort
		for ( i=0, iLen=displayMaster.length ; i<iLen ; i++ ) {
			aiOrig[ i ] = i;
		}

		// If the first sort is desc, then reverse the array to preserve original
		// order, just in reverse
		if (aSort.length && aSort[0].dir === 'desc') {
			aiOrig.reverse();
		}

		/* Do the sort - here we want multi-column sorting based on a given data source (column)
		 * and sorting function (from oSort) in a certain direction. It's reasonably complex to
		 * follow on it's own, but this is what we want (example two column sorting):
		 *  fnLocalSorting = function(a,b){
		 *    var test;
		 *    test = oSort['string-asc']('data11', 'data12');
		 *      if (test !== 0)
		 *        return test;
		 *    test = oSort['numeric-desc']('data21', 'data22');
		 *    if (test !== 0)
		 *      return test;
		 *    return oSort['numeric-asc']( aiOrig[a], aiOrig[b] );
		 *  }
		 * Basically we have a test for each sorting column, if the data in that column is equal,
		 * test the next column. If all columns match, then we use a numeric sort on the row
		 * positions in the original data array to provide a stable sort.
		 */
		displayMaster.sort( function ( a, b ) {
			var
				x, y, k, test, sort,
				len=aSort.length,
				dataA = aoData[a]._aSortData,
				dataB = aoData[b]._aSortData;

			for ( k=0 ; k<len ; k++ ) {
				sort = aSort[k];

				// Data, which may have already been through a `-pre` function
				x = dataA[ sort.col ];
				y = dataB[ sort.col ];

				if (sort.sorter) {
					// If there is a custom sorter (`-asc` or `-desc`) for this
					// data type, use it
					test = sort.sorter(x, y);

					if ( test !== 0 ) {
						return test;
					}
				}
				else {
					// Otherwise, use generic sorting
					test = x<y ? -1 : x>y ? 1 : 0;

					if ( test !== 0 ) {
						return sort.dir === 'asc' ? test : -test;
					}
				}
			}

			x = aiOrig[a];
			y = aiOrig[b];

			return x<y ? -1 : x>y ? 1 : 0;
		} );
	}
	else if ( aSort.length === 0 ) {
		// Apply index order
		displayMaster.sort(function (x, y) {
			return x<y ? -1 : x>y ? 1 : 0;
		});
	}

	if (col === undefined) {
		// Tell the draw function that we have sorted the data
		oSettings.bSorted = true;

		_fnCallbackFire( oSettings, null, 'order', [oSettings, aSort] );
	}

	return displayMaster;
}


/**
 * Function to run on user sort request
 *  @param {object} settings dataTables settings object
 *  @param {node} attachTo node to attach the handler to
 *  @param {int} colIdx column sorting index
 *  @param {int} addIndex Counter
 *  @param {boolean} [shift=false] Shift click add
 *  @param {function} [callback] callback function
 *  @memberof DataTable#oApi
 */
function _fnSortAdd ( settings, colIdx, addIndex, shift )
{
	var col = settings.aoColumns[ colIdx ];
	var sorting = settings.aaSorting;
	var asSorting = col.asSorting;
	var nextSortIdx;
	var next = function ( a, overflow ) {
		var idx = a._idx;
		if ( idx === undefined ) {
			idx = asSorting.indexOf(a[1]);
		}

		return idx+1 < asSorting.length ?
			idx+1 :
			overflow ?
				null :
				0;
	};

	if ( ! col.bSortable ) {
		return false;
	}

	// Convert to 2D array if needed
	if ( typeof sorting[0] === 'number' ) {
		sorting = settings.aaSorting = [ sorting ];
	}

	// If appending the sort then we are multi-column sorting
	if ( (shift || addIndex) && settings.oFeatures.bSortMulti ) {
		// Are we already doing some kind of sort on this column?
		var sortIdx = _pluck(sorting, '0').indexOf(colIdx);

		if ( sortIdx !== -1 ) {
			// Yes, modify the sort
			nextSortIdx = next( sorting[sortIdx], true );

			if ( nextSortIdx === null && sorting.length === 1 ) {
				nextSortIdx = 0; // can't remove sorting completely
			}

			if ( nextSortIdx === null ) {
				sorting.splice( sortIdx, 1 );
			}
			else {
				sorting[sortIdx][1] = asSorting[ nextSortIdx ];
				sorting[sortIdx]._idx = nextSortIdx;
			}
		}
		else if (shift) {
			// No sort on this column yet, being added by shift click
			// add it as itself
			sorting.push( [ colIdx, asSorting[0], 0 ] );
			sorting[sorting.length-1]._idx = 0;
		}
		else {
			// No sort on this column yet, being added from a colspan
			// so add with same direction as first column
			sorting.push( [ colIdx, sorting[0][1], 0 ] );
			sorting[sorting.length-1]._idx = 0;
		}
	}
	else if ( sorting.length && sorting[0][0] == colIdx ) {
		// Single column - already sorting on this column, modify the sort
		nextSortIdx = next( sorting[0] );

		sorting.length = 1;
		sorting[0][1] = asSorting[ nextSortIdx ];
		sorting[0]._idx = nextSortIdx;
	}
	else {
		// Single column - sort only on this column
		sorting.length = 0;
		sorting.push( [ colIdx, asSorting[0] ] );
		sorting[0]._idx = 0;
	}
}


/**
 * Set the sorting classes on table's body, Note: it is safe to call this function
 * when bSort and bSortClasses are false
 *  @param {object} oSettings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnSortingClasses( settings )
{
	var oldSort = settings.aLastSort;
	var sortClass = settings.oClasses.order.position;
	var sort = _fnSortFlatten( settings );
	var features = settings.oFeatures;
	var i, ien, colIdx;

	if ( features.bSort && features.bSortClasses ) {
		// Remove old sorting classes
		for ( i=0, ien=oldSort.length ; i<ien ; i++ ) {
			colIdx = oldSort[i].src;

			// Remove column sorting
			$( _pluck( settings.aoData, 'anCells', colIdx ) )
				.removeClass( sortClass + (i<2 ? i+1 : 3) );
		}

		// Add new column sorting
		for ( i=0, ien=sort.length ; i<ien ; i++ ) {
			colIdx = sort[i].src;

			$( _pluck( settings.aoData, 'anCells', colIdx ) )
				.addClass( sortClass + (i<2 ? i+1 : 3) );
		}
	}

	settings.aLastSort = sort;
}


// Get the data to sort a column, be it from cache, fresh (populating the
// cache), or from a sort formatter
function _fnSortData( settings, colIdx )
{
	// Custom sorting function - provided by the sort data type
	var column = settings.aoColumns[ colIdx ];
	var customSort = DataTable.ext.order[ column.sSortDataType ];
	var customData;

	if ( customSort ) {
		customData = customSort.call( settings.oInstance, settings, colIdx,
			_fnColumnIndexToVisible( settings, colIdx )
		);
	}

	// Use / populate cache
	var row, cellData;
	var formatter = DataTable.ext.type.order[ column.sType+"-pre" ];
	var data = settings.aoData;

	for ( var rowIdx=0 ; rowIdx<data.length ; rowIdx++ ) {
		// Sparse array
		if (! data[rowIdx]) {
			continue;
		}

		row = data[rowIdx];

		if ( ! row._aSortData ) {
			row._aSortData = [];
		}

		if ( ! row._aSortData[colIdx] || customSort ) {
			cellData = customSort ?
				customData[rowIdx] : // If there was a custom sort function, use data from there
				_fnGetCellData( settings, rowIdx, colIdx, 'sort' );

			row._aSortData[ colIdx ] = formatter ?
				formatter( cellData, settings ) :
				cellData;
		}
	}
}


/**
 * State information for a table
 *
 * @param {*} settings
 * @returns State object
 */
function _fnSaveState ( settings )
{
	if (settings._bLoadingState) {
		return;
	}

	/* Store the interesting variables */
	var state = {
		time:    +new Date(),
		start:   settings._iDisplayStart,
		length:  settings._iDisplayLength,
		order:   $.extend( true, [], settings.aaSorting ),
		search:  $.extend({}, settings.oPreviousSearch),
		columns: settings.aoColumns.map( function ( col, i ) {
			return {
				visible: col.bVisible,
				search: $.extend({}, settings.aoPreSearchCols[i])
			};
		} )
	};

	settings.oSavedState = state;
	_fnCallbackFire( settings, "aoStateSaveParams", 'stateSaveParams', [settings, state] );
	
	if ( settings.oFeatures.bStateSave && !settings.bDestroying )
	{
		settings.fnStateSaveCallback.call( settings.oInstance, settings, state );
	}	
}


/**
 * Attempt to load a saved table state
 *  @param {object} oSettings dataTables settings object
 *  @param {object} oInit DataTables init object so we can override settings
 *  @param {function} callback Callback to execute when the state has been loaded
 *  @memberof DataTable#oApi
 */
function _fnLoadState ( settings, init, callback )
{
	if ( ! settings.oFeatures.bStateSave ) {
		callback();
		return;
	}

	var loaded = function(state) {
		_fnImplementState(settings, state, callback);
	}

	var state = settings.fnStateLoadCallback.call( settings.oInstance, settings, loaded );

	if ( state !== undefined ) {
		_fnImplementState( settings, state, callback );
	}
	// otherwise, wait for the loaded callback to be executed

	return true;
}

function _fnImplementState ( settings, s, callback) {
	var i, ien;
	var columns = settings.aoColumns;
	settings._bLoadingState = true;

	// When StateRestore was introduced the state could now be implemented at any time
	// Not just initialisation. To do this an api instance is required in some places
	var api = settings._bInitComplete ? new DataTable.Api(settings) : null;

	if ( ! s || ! s.time ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Reject old data
	var duration = settings.iStateDuration;
	if ( duration > 0 && s.time < +new Date() - (duration*1000) ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Allow custom and plug-in manipulation functions to alter the saved data set and
	// cancelling of loading by returning false
	var abStateLoad = _fnCallbackFire( settings, 'aoStateLoadParams', 'stateLoadParams', [settings, s] );
	if ( abStateLoad.indexOf(false) !== -1 ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Number of columns have changed - all bets are off, no restore of settings
	if ( s.columns && columns.length !== s.columns.length ) {
		settings._bLoadingState = false;
		callback();
		return;
	}

	// Store the saved state so it might be accessed at any time
	settings.oLoadedState = $.extend( true, {}, s );

	// This is needed for ColReorder, which has to happen first to allow all
	// the stored indexes to be usable. It is not publicly documented.
	_fnCallbackFire( settings, null, 'stateLoadInit', [settings, s], true );

	// Page Length
	if ( s.length !== undefined ) {
		// If already initialised just set the value directly so that the select element is also updated
		if (api) {
			api.page.len(s.length)
		}
		else {
			settings._iDisplayLength   = s.length;
		}
	}

	// Restore key features - todo - for 1.11 this needs to be done by
	// subscribed events
	if ( s.start !== undefined ) {
		if(api === null) {
			settings._iDisplayStart    = s.start;
			settings.iInitDisplayStart = s.start;
		}
		else {
			_fnPageChange(settings, s.start/settings._iDisplayLength);
		}
	}

	// Order
	if ( s.order !== undefined ) {
		settings.aaSorting = [];
		$.each( s.order, function ( i, col ) {
			settings.aaSorting.push( col[0] >= columns.length ?
				[ 0, col[1] ] :
				col
			);
		} );
	}

	// Search
	if ( s.search !== undefined ) {
		$.extend( settings.oPreviousSearch, s.search );
	}

	// Columns
	if ( s.columns ) {
		for ( i=0, ien=s.columns.length ; i<ien ; i++ ) {
			var col = s.columns[i];

			// Visibility
			if ( col.visible !== undefined ) {
				// If the api is defined, the table has been initialised so we need to use it rather than internal settings
				if (api) {
					// Don't redraw the columns on every iteration of this loop, we will do this at the end instead
					api.column(i).visible(col.visible, false);
				}
				else {
					columns[i].bVisible = col.visible;
				}
			}

			// Search
			if ( col.search !== undefined ) {
				$.extend( settings.aoPreSearchCols[i], col.search );
			}
		}
		
		// If the api is defined then we need to adjust the columns once the visibility has been changed
		if (api) {
			api.columns.adjust();
		}
	}

	settings._bLoadingState = false;
	_fnCallbackFire( settings, 'aoStateLoaded', 'stateLoaded', [settings, s] );
	callback();
}

/**
 * Log an error message
 *  @param {object} settings dataTables settings object
 *  @param {int} level log error messages, or display them to the user
 *  @param {string} msg error message
 *  @param {int} tn Technical note id to get more information about the error.
 *  @memberof DataTable#oApi
 */
function _fnLog( settings, level, msg, tn )
{
	msg = 'DataTables warning: '+
		(settings ? 'table id='+settings.sTableId+' - ' : '')+msg;

	if ( tn ) {
		msg += '. For more information about this error, please see '+
		'https://datatables.net/tn/'+tn;
	}

	if ( ! level  ) {
		// Backwards compatibility pre 1.10
		var ext = DataTable.ext;
		var type = ext.sErrMode || ext.errMode;

		if ( settings ) {
			_fnCallbackFire( settings, null, 'dt-error', [ settings, tn, msg ], true );
		}

		if ( type == 'alert' ) {
			alert( msg );
		}
		else if ( type == 'throw' ) {
			throw new Error(msg);
		}
		else if ( typeof type == 'function' ) {
			type( settings, tn, msg );
		}
	}
	else if ( window.console && console.log ) {
		console.log( msg );
	}
}


/**
 * See if a property is defined on one object, if so assign it to the other object
 *  @param {object} ret target object
 *  @param {object} src source object
 *  @param {string} name property
 *  @param {string} [mappedName] name to map too - optional, name used if not given
 *  @memberof DataTable#oApi
 */
function _fnMap( ret, src, name, mappedName )
{
	if ( Array.isArray( name ) ) {
		$.each( name, function (i, val) {
			if ( Array.isArray( val ) ) {
				_fnMap( ret, src, val[0], val[1] );
			}
			else {
				_fnMap( ret, src, val );
			}
		} );

		return;
	}

	if ( mappedName === undefined ) {
		mappedName = name;
	}

	if ( src[name] !== undefined ) {
		ret[mappedName] = src[name];
	}
}


/**
 * Extend objects - very similar to jQuery.extend, but deep copy objects, and
 * shallow copy arrays. The reason we need to do this, is that we don't want to
 * deep copy array init values (such as aaSorting) since the dev wouldn't be
 * able to override them, but we do want to deep copy arrays.
 *  @param {object} out Object to extend
 *  @param {object} extender Object from which the properties will be applied to
 *      out
 *  @param {boolean} breakRefs If true, then arrays will be sliced to take an
 *      independent copy with the exception of the `data` or `aaData` parameters
 *      if they are present. This is so you can pass in a collection to
 *      DataTables and have that used as your data source without breaking the
 *      references
 *  @returns {object} out Reference, just for convenience - out === the return.
 *  @memberof DataTable#oApi
 *  @todo This doesn't take account of arrays inside the deep copied objects.
 */
function _fnExtend( out, extender, breakRefs )
{
	var val;

	for ( var prop in extender ) {
		if ( Object.prototype.hasOwnProperty.call(extender, prop) ) {
			val = extender[prop];

			if ( $.isPlainObject( val ) ) {
				if ( ! $.isPlainObject( out[prop] ) ) {
					out[prop] = {};
				}
				$.extend( true, out[prop], val );
			}
			else if ( breakRefs && prop !== 'data' && prop !== 'aaData' && Array.isArray(val) ) {
				out[prop] = val.slice();
			}
			else {
				out[prop] = val;
			}
		}
	}

	return out;
}


/**
 * Bind an event handers to allow a click or return key to activate the callback.
 * This is good for accessibility since a return on the keyboard will have the
 * same effect as a click, if the element has focus.
 *  @param {element} n Element to bind the action to
 *  @param {object|string} selector Selector (for delegated events) or data object
 *   to pass to the triggered function
 *  @param {function} fn Callback function for when the event is triggered
 *  @memberof DataTable#oApi
 */
function _fnBindAction( n, selector, fn )
{
	$(n)
		.on( 'click.DT', selector, function (e) {
			fn(e);
		} )
		.on( 'keypress.DT', selector, function (e){
			if ( e.which === 13 ) {
				e.preventDefault();
				fn(e);
			}
		} )
		.on( 'selectstart.DT', selector, function () {
			// Don't want a double click resulting in text selection
			return false;
		} );
}


/**
 * Register a callback function. Easily allows a callback function to be added to
 * an array store of callback functions that can then all be called together.
 *  @param {object} settings dataTables settings object
 *  @param {string} store Name of the array storage for the callbacks in oSettings
 *  @param {function} fn Function to be called back
 *  @memberof DataTable#oApi
 */
function _fnCallbackReg( settings, store, fn )
{
	if ( fn ) {
		settings[store].push(fn);
	}
}


/**
 * Fire callback functions and trigger events. Note that the loop over the
 * callback array store is done backwards! Further note that you do not want to
 * fire off triggers in time sensitive applications (for example cell creation)
 * as its slow.
 *  @param {object} settings dataTables settings object
 *  @param {string} callbackArr Name of the array storage for the callbacks in
 *      oSettings
 *  @param {string} eventName Name of the jQuery custom event to trigger. If
 *      null no trigger is fired
 *  @param {array} args Array of arguments to pass to the callback function /
 *      trigger
 *  @param {boolean} [bubbles] True if the event should bubble
 *  @memberof DataTable#oApi
 */
function _fnCallbackFire( settings, callbackArr, eventName, args, bubbles )
{
	var ret = [];

	if ( callbackArr ) {
		ret = settings[callbackArr].slice().reverse().map( function (val) {
			return val.apply( settings.oInstance, args );
		} );
	}

	if ( eventName !== null) {
		var e = $.Event( eventName+'.dt' );
		var table = $(settings.nTable);
		
		// Expose the DataTables API on the event object for easy access
		e.dt = settings.api;

		table[bubbles ?  'trigger' : 'triggerHandler']( e, args );

		// If not yet attached to the document, trigger the event
		// on the body directly to sort of simulate the bubble
		if (bubbles && table.parents('body').length === 0) {
			$('body').trigger( e, args );
		}

		ret.push( e.result );
	}

	return ret;
}


function _fnLengthOverflow ( settings )
{
	var
		start = settings._iDisplayStart,
		end = settings.fnDisplayEnd(),
		len = settings._iDisplayLength;

	/* If we have space to show extra rows (backing up from the end point - then do so */
	if ( start >= end )
	{
		start = end - len;
	}

	// Keep the start record on the current page
	start -= (start % len);

	if ( len === -1 || start < 0 )
	{
		start = 0;
	}

	settings._iDisplayStart = start;
}


function _fnRenderer( settings, type )
{
	var renderer = settings.renderer;
	var host = DataTable.ext.renderer[type];

	if ( $.isPlainObject( renderer ) && renderer[type] ) {
		// Specific renderer for this type. If available use it, otherwise use
		// the default.
		return host[renderer[type]] || host._;
	}
	else if ( typeof renderer === 'string' ) {
		// Common renderer - if there is one available for this type use it,
		// otherwise use the default
		return host[renderer] || host._;
	}

	// Use the default
	return host._;
}


/**
 * Detect the data source being used for the table. Used to simplify the code
 * a little (ajax) and to make it compress a little smaller.
 *
 *  @param {object} settings dataTables settings object
 *  @returns {string} Data source
 *  @memberof DataTable#oApi
 */
function _fnDataSource ( settings )
{
	if ( settings.oFeatures.bServerSide ) {
		return 'ssp';
	}
	else if ( settings.ajax ) {
		return 'ajax';
	}
	return 'dom';
}

/**
 * Common replacement for language strings
 *
 * @param {*} settings DT settings object
 * @param {*} str String with values to replace
 * @param {*} entries Plural number for _ENTRIES_ - can be undefined
 * @returns String
 */
function _fnMacros ( settings, str, entries )
{
	// When infinite scrolling, we are always starting at 1. _iDisplayStart is
	// used only internally
	var
		formatter  = settings.fnFormatNumber,
		start      = settings._iDisplayStart+1,
		len        = settings._iDisplayLength,
		vis        = settings.fnRecordsDisplay(),
		max        = settings.fnRecordsTotal(),
		all        = len === -1;

	return str.
		replace(/_START_/g, formatter.call( settings, start ) ).
		replace(/_END_/g,   formatter.call( settings, settings.fnDisplayEnd() ) ).
		replace(/_MAX_/g,   formatter.call( settings, max ) ).
		replace(/_TOTAL_/g, formatter.call( settings, vis ) ).
		replace(/_PAGE_/g,  formatter.call( settings, all ? 1 : Math.ceil( start / len ) ) ).
		replace(/_PAGES_/g, formatter.call( settings, all ? 1 : Math.ceil( vis / len ) ) ).
		replace(/_ENTRIES_/g, settings.api.i18n('entries', '', entries) ).
		replace(/_ENTRIES-MAX_/g, settings.api.i18n('entries', '', max) ).
		replace(/_ENTRIES-TOTAL_/g, settings.api.i18n('entries', '', vis) );
}



/**
 * Computed structure of the DataTables API, defined by the options passed to
 * `DataTable.Api.register()` when building the API.
 *
 * The structure is built in order to speed creation and extension of the Api
 * objects since the extensions are effectively pre-parsed.
 *
 * The array is an array of objects with the following structure, where this
 * base array represents the Api prototype base:
 *
 *     [
 *       {
 *         name:      'data'                -- string   - Property name
 *         val:       function () {},       -- function - Api method (or undefined if just an object
 *         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
 *         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
 *       },
 *       {
 *         name:     'row'
 *         val:       {},
 *         methodExt: [ ... ],
 *         propExt:   [
 *           {
 *             name:      'data'
 *             val:       function () {},
 *             methodExt: [ ... ],
 *             propExt:   [ ... ]
 *           },
 *           ...
 *         ]
 *       }
 *     ]
 *
 * @type {Array}
 * @ignore
 */
var __apiStruct = [];


/**
 * `Array.prototype` reference.
 *
 * @type object
 * @ignore
 */
var __arrayProto = Array.prototype;


/**
 * Abstraction for `context` parameter of the `Api` constructor to allow it to
 * take several different forms for ease of use.
 *
 * Each of the input parameter types will be converted to a DataTables settings
 * object where possible.
 *
 * @param  {string|node|jQuery|object} mixed DataTable identifier. Can be one
 *   of:
 *
 *   * `string` - jQuery selector. Any DataTables' matching the given selector
 *     with be found and used.
 *   * `node` - `TABLE` node which has already been formed into a DataTable.
 *   * `jQuery` - A jQuery object of `TABLE` nodes.
 *   * `object` - DataTables settings object
 *   * `DataTables.Api` - API instance
 * @return {array|null} Matching DataTables settings objects. `null` or
 *   `undefined` is returned if no matching DataTable is found.
 * @ignore
 */
var _toSettings = function ( mixed )
{
	var idx, jq;
	var settings = DataTable.settings;
	var tables = _pluck(settings, 'nTable');

	if ( ! mixed ) {
		return [];
	}
	else if ( mixed.nTable && mixed.oFeatures ) {
		// DataTables settings object
		return [ mixed ];
	}
	else if ( mixed.nodeName && mixed.nodeName.toLowerCase() === 'table' ) {
		// Table node
		idx = tables.indexOf(mixed);
		return idx !== -1 ? [ settings[idx] ] : null;
	}
	else if ( mixed && typeof mixed.settings === 'function' ) {
		return mixed.settings().toArray();
	}
	else if ( typeof mixed === 'string' ) {
		// jQuery selector
		jq = $(mixed).get();
	}
	else if ( mixed instanceof $ ) {
		// jQuery object (also DataTables instance)
		jq = mixed.get();
	}

	if ( jq ) {
		return settings.filter(function (v, idx) {
			return jq.includes(tables[idx]);
		});
	}
};


/**
 * DataTables API class - used to control and interface with  one or more
 * DataTables enhanced tables.
 *
 * The API class is heavily based on jQuery, presenting a chainable interface
 * that you can use to interact with tables. Each instance of the API class has
 * a "context" - i.e. the tables that it will operate on. This could be a single
 * table, all tables on a page or a sub-set thereof.
 *
 * Additionally the API is designed to allow you to easily work with the data in
 * the tables, retrieving and manipulating it as required. This is done by
 * presenting the API class as an array like interface. The contents of the
 * array depend upon the actions requested by each method (for example
 * `rows().nodes()` will return an array of nodes, while `rows().data()` will
 * return an array of objects or arrays depending upon your table's
 * configuration). The API object has a number of array like methods (`push`,
 * `pop`, `reverse` etc) as well as additional helper methods (`each`, `pluck`,
 * `unique` etc) to assist your working with the data held in a table.
 *
 * Most methods (those which return an Api instance) are chainable, which means
 * the return from a method call also has all of the methods available that the
 * top level object had. For example, these two calls are equivalent:
 *
 *     // Not chained
 *     api.row.add( {...} );
 *     api.draw();
 *
 *     // Chained
 *     api.row.add( {...} ).draw();
 *
 * @class DataTable.Api
 * @param {array|object|string|jQuery} context DataTable identifier. This is
 *   used to define which DataTables enhanced tables this API will operate on.
 *   Can be one of:
 *
 *   * `string` - jQuery selector. Any DataTables' matching the given selector
 *     with be found and used.
 *   * `node` - `TABLE` node which has already been formed into a DataTable.
 *   * `jQuery` - A jQuery object of `TABLE` nodes.
 *   * `object` - DataTables settings object
 * @param {array} [data] Data to initialise the Api instance with.
 *
 * @example
 *   // Direct initialisation during DataTables construction
 *   var api = $('#example').DataTable();
 *
 * @example
 *   // Initialisation using a DataTables jQuery object
 *   var api = $('#example').dataTable().api();
 *
 * @example
 *   // Initialisation as a constructor
 *   var api = new DataTable.Api( 'table.dataTable' );
 */
_Api = function ( context, data )
{
	if ( ! (this instanceof _Api) ) {
		return new _Api( context, data );
	}

	var settings = [];
	var ctxSettings = function ( o ) {
		var a = _toSettings( o );
		if ( a ) {
			settings.push.apply( settings, a );
		}
	};

	if ( Array.isArray( context ) ) {
		for ( var i=0, ien=context.length ; i<ien ; i++ ) {
			ctxSettings( context[i] );
		}
	}
	else {
		ctxSettings( context );
	}

	// Remove duplicates
	this.context = settings.length > 1
		? _unique( settings )
		: settings;

	// Initial data
	if ( data ) {
		this.push.apply(this, data);
	}

	// selector
	this.selector = {
		rows: null,
		cols: null,
		opts: null
	};

	_Api.extend( this, this, __apiStruct );
};

DataTable.Api = _Api;

// Don't destroy the existing prototype, just extend it. Required for jQuery 2's
// isPlainObject.
$.extend( _Api.prototype, {
	any: function ()
	{
		return this.count() !== 0;
	},

	context: [], // array of table settings objects

	count: function ()
	{
		return this.flatten().length;
	},

	each: function ( fn )
	{
		for ( var i=0, ien=this.length ; i<ien; i++ ) {
			fn.call( this, this[i], i, this );
		}

		return this;
	},

	eq: function ( idx )
	{
		var ctx = this.context;

		return ctx.length > idx ?
			new _Api( ctx[idx], this[idx] ) :
			null;
	},

	filter: function ( fn )
	{
		var a = __arrayProto.filter.call( this, fn, this );

		return new _Api( this.context, a );
	},

	flatten: function ()
	{
		var a = [];

		return new _Api( this.context, a.concat.apply( a, this.toArray() ) );
	},

	get: function ( idx )
	{
		return this[ idx ];
	},

	join:    __arrayProto.join,

	includes: function ( find ) {
		return this.indexOf( find ) === -1 ? false : true;
	},

	indexOf: __arrayProto.indexOf,

	iterator: function ( flatten, type, fn, alwaysNew ) {
		var
			a = [], ret,
			i, ien, j, jen,
			context = this.context,
			rows, items, item,
			selector = this.selector;

		// Argument shifting
		if ( typeof flatten === 'string' ) {
			alwaysNew = fn;
			fn = type;
			type = flatten;
			flatten = false;
		}

		for ( i=0, ien=context.length ; i<ien ; i++ ) {
			var apiInst = new _Api( context[i] );

			if ( type === 'table' ) {
				ret = fn.call( apiInst, context[i], i );

				if ( ret !== undefined ) {
					a.push( ret );
				}
			}
			else if ( type === 'columns' || type === 'rows' ) {
				// this has same length as context - one entry for each table
				ret = fn.call( apiInst, context[i], this[i], i );

				if ( ret !== undefined ) {
					a.push( ret );
				}
			}
			else if ( type === 'every' || type === 'column' || type === 'column-rows' || type === 'row' || type === 'cell' ) {
				// columns and rows share the same structure.
				// 'this' is an array of column indexes for each context
				items = this[i];

				if ( type === 'column-rows' ) {
					rows = _selector_row_indexes( context[i], selector.opts );
				}

				for ( j=0, jen=items.length ; j<jen ; j++ ) {
					item = items[j];

					if ( type === 'cell' ) {
						ret = fn.call( apiInst, context[i], item.row, item.column, i, j );
					}
					else {
						ret = fn.call( apiInst, context[i], item, i, j, rows );
					}

					if ( ret !== undefined ) {
						a.push( ret );
					}
				}
			}
		}

		if ( a.length || alwaysNew ) {
			var api = new _Api( context, flatten ? a.concat.apply( [], a ) : a );
			var apiSelector = api.selector;
			apiSelector.rows = selector.rows;
			apiSelector.cols = selector.cols;
			apiSelector.opts = selector.opts;
			return api;
		}
		return this;
	},

	lastIndexOf: __arrayProto.lastIndexOf,

	length:  0,

	map: function ( fn )
	{
		var a = __arrayProto.map.call( this, fn, this );

		return new _Api( this.context, a );
	},

	pluck: function ( prop )
	{
		var fn = DataTable.util.get(prop);

		return this.map( function ( el ) {
			return fn(el);
		} );
	},

	pop:     __arrayProto.pop,

	push:    __arrayProto.push,

	reduce: __arrayProto.reduce,

	reduceRight: __arrayProto.reduceRight,

	reverse: __arrayProto.reverse,

	// Object with rows, columns and opts
	selector: null,

	shift:   __arrayProto.shift,

	slice: function () {
		return new _Api( this.context, this );
	},

	sort:    __arrayProto.sort,

	splice:  __arrayProto.splice,

	toArray: function ()
	{
		return __arrayProto.slice.call( this );
	},

	to$: function ()
	{
		return $( this );
	},

	toJQuery: function ()
	{
		return $( this );
	},

	unique: function ()
	{
		return new _Api( this.context, _unique(this.toArray()) );
	},

	unshift: __arrayProto.unshift
} );


function _api_scope( scope, fn, struc ) {
	return function () {
		var ret = fn.apply( scope || this, arguments );

		// Method extension
		_Api.extend( ret, ret, struc.methodExt );
		return ret;
	};
}

function _api_find( src, name ) {
	for ( var i=0, ien=src.length ; i<ien ; i++ ) {
		if ( src[i].name === name ) {
			return src[i];
		}
	}
	return null;
}

window.__apiStruct = __apiStruct;

_Api.extend = function ( scope, obj, ext )
{
	// Only extend API instances and static properties of the API
	if ( ! ext.length || ! obj || ( ! (obj instanceof _Api) && ! obj.__dt_wrapper ) ) {
		return;
	}

	var
		i, ien,
		struct;

	for ( i=0, ien=ext.length ; i<ien ; i++ ) {
		struct = ext[i];

		// Value
		obj[ struct.name ] = struct.type === 'function' ?
			_api_scope( scope, struct.val, struct ) :
			struct.type === 'object' ?
				{} :
				struct.val;

		obj[ struct.name ].__dt_wrapper = true;

		// Property extension
		_Api.extend( scope, obj[ struct.name ], struct.propExt );
	}
};

//     [
//       {
//         name:      'data'                -- string   - Property name
//         val:       function () {},       -- function - Api method (or undefined if just an object
//         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
//         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
//       },
//       {
//         name:     'row'
//         val:       {},
//         methodExt: [ ... ],
//         propExt:   [
//           {
//             name:      'data'
//             val:       function () {},
//             methodExt: [ ... ],
//             propExt:   [ ... ]
//           },
//           ...
//         ]
//       }
//     ]


_Api.register = _api_register = function ( name, val )
{
	if ( Array.isArray( name ) ) {
		for ( var j=0, jen=name.length ; j<jen ; j++ ) {
			_Api.register( name[j], val );
		}
		return;
	}

	var
		i, ien,
		heir = name.split('.'),
		struct = __apiStruct,
		key, method;

	for ( i=0, ien=heir.length ; i<ien ; i++ ) {
		method = heir[i].indexOf('()') !== -1;
		key = method ?
			heir[i].replace('()', '') :
			heir[i];

		var src = _api_find( struct, key );
		if ( ! src ) {
			src = {
				name:      key,
				val:       {},
				methodExt: [],
				propExt:   [],
				type:      'object'
			};
			struct.push( src );
		}

		if ( i === ien-1 ) {
			src.val = val;
			src.type = typeof val === 'function' ?
				'function' :
				$.isPlainObject( val ) ?
					'object' :
					'other';
		}
		else {
			struct = method ?
				src.methodExt :
				src.propExt;
		}
	}
};

_Api.registerPlural = _api_registerPlural = function ( pluralName, singularName, val ) {
	_Api.register( pluralName, val );

	_Api.register( singularName, function () {
		var ret = val.apply( this, arguments );

		if ( ret === this ) {
			// Returned item is the API instance that was passed in, return it
			return this;
		}
		else if ( ret instanceof _Api ) {
			// New API instance returned, want the value from the first item
			// in the returned array for the singular result.
			return ret.length ?
				Array.isArray( ret[0] ) ?
					new _Api( ret.context, ret[0] ) : // Array results are 'enhanced'
					ret[0] :
				undefined;
		}

		// Non-API return - just fire it back
		return ret;
	} );
};


/**
 * Selector for HTML tables. Apply the given selector to the give array of
 * DataTables settings objects.
 *
 * @param {string|integer} [selector] jQuery selector string or integer
 * @param  {array} Array of DataTables settings objects to be filtered
 * @return {array}
 * @ignore
 */
var __table_selector = function ( selector, a )
{
	if ( Array.isArray(selector) ) {
		var result = [];

		selector.forEach(function (sel) {
			var inner = __table_selector(sel, a);

			result.push.apply(result, inner);
		});

		return result.filter( function (item) {
			return item;
		});
	}

	// Integer is used to pick out a table by index
	if ( typeof selector === 'number' ) {
		return [ a[ selector ] ];
	}

	// Perform a jQuery selector on the table nodes
	var nodes = a.map( function (el) {
		return el.nTable;
	} );

	return $(nodes)
		.filter( selector )
		.map( function () {
			// Need to translate back from the table node to the settings
			var idx = nodes.indexOf(this);
			return a[ idx ];
		} )
		.toArray();
};



/**
 * Context selector for the API's context (i.e. the tables the API instance
 * refers to.
 *
 * @name    DataTable.Api#tables
 * @param {string|integer} [selector] Selector to pick which tables the iterator
 *   should operate on. If not given, all tables in the current context are
 *   used. This can be given as a jQuery selector (for example `':gt(0)'`) to
 *   select multiple tables or as an integer to select a single table.
 * @returns {DataTable.Api} Returns a new API instance if a selector is given.
 */
_api_register( 'tables()', function ( selector ) {
	// A new instance is created if there was a selector specified
	return selector !== undefined && selector !== null ?
		new _Api( __table_selector( selector, this.context ) ) :
		this;
} );


_api_register( 'table()', function ( selector ) {
	var tables = this.tables( selector );
	var ctx = tables.context;

	// Truncate to the first matched table
	return ctx.length ?
		new _Api( ctx[0] ) :
		tables;
} );

// Common methods, combined to reduce size
[
	['nodes', 'node', 'nTable'],
	['body', 'body', 'nTBody'],
	['header', 'header', 'nTHead'],
	['footer', 'footer', 'nTFoot'],
].forEach(function (item) {
	_api_registerPlural(
		'tables().' + item[0] + '()',
		'table().' + item[1] + '()' ,
		function () {
			return this.iterator( 'table', function ( ctx ) {
				return ctx[item[2]];
			}, 1 );
		}
	);
});

// Structure methods
[
	['header', 'aoHeader'],
	['footer', 'aoFooter'],
].forEach(function (item) {
	_api_register( 'table().' + item[0] + '.structure()' , function (selector) {
		var indexes = this.columns(selector).indexes().flatten();
		var ctx = this.context[0];
		
		return _fnHeaderLayout(ctx, ctx[item[1]], indexes);
	} );
})


_api_registerPlural( 'tables().containers()', 'table().container()' , function () {
	return this.iterator( 'table', function ( ctx ) {
		return ctx.nTableWrapper;
	}, 1 );
} );

_api_register( 'tables().every()', function ( fn ) {
	var that = this;

	return this.iterator('table', function (s, i) {
		fn.call(that.table(i), i);
	});
});

_api_register( 'caption()', function ( value, side ) {
	var context = this.context;

	// Getter - return existing node's content
	if ( value === undefined ) {
		var caption = context[0].captionNode;

		return caption && context.length ?
			caption.innerHTML : 
			null;
	}

	return this.iterator( 'table', function ( ctx ) {
		var table = $(ctx.nTable);
		var caption = $(ctx.captionNode);
		var container = $(ctx.nTableWrapper);

		// Create the node if it doesn't exist yet
		if ( ! caption.length ) {
			caption = $('<caption/>').html( value );
			ctx.captionNode = caption[0];

			// If side isn't set, we need to insert into the document to let the
			// CSS decide so we can read it back, otherwise there is no way to
			// know if the CSS would put it top or bottom for scrolling
			if (! side) {
				table.prepend(caption);

				side = caption.css('caption-side');
			}
		}

		caption.html( value );

		if ( side ) {
			caption.css( 'caption-side', side );
			caption[0]._captionSide = side;
		}

		if (container.find('div.dataTables_scroll').length) {
			var selector = (side === 'top' ? 'Head' : 'Foot');

			container.find('div.dataTables_scroll'+ selector +' table').prepend(caption);
		}
		else {
			table.prepend(caption);
		}
	}, 1 );
} );

_api_register( 'caption.node()', function () {
	var ctx = this.context;

	return ctx.length ? ctx[0].captionNode : null;
} );


/**
 * Redraw the tables in the current context.
 */
_api_register( 'draw()', function ( paging ) {
	return this.iterator( 'table', function ( settings ) {
		if ( paging === 'page' ) {
			_fnDraw( settings );
		}
		else {
			if ( typeof paging === 'string' ) {
				paging = paging === 'full-hold' ?
					false :
					true;
			}

			_fnReDraw( settings, paging===false );
		}
	} );
} );



/**
 * Get the current page index.
 *
 * @return {integer} Current page index (zero based)
 *//**
 * Set the current page.
 *
 * Note that if you attempt to show a page which does not exist, DataTables will
 * not throw an error, but rather reset the paging.
 *
 * @param {integer|string} action The paging action to take. This can be one of:
 *  * `integer` - The page index to jump to
 *  * `string` - An action to take:
 *    * `first` - Jump to first page.
 *    * `next` - Jump to the next page
 *    * `previous` - Jump to previous page
 *    * `last` - Jump to the last page.
 * @returns {DataTables.Api} this
 */
_api_register( 'page()', function ( action ) {
	if ( action === undefined ) {
		return this.page.info().page; // not an expensive call
	}

	// else, have an action to take on all tables
	return this.iterator( 'table', function ( settings ) {
		_fnPageChange( settings, action );
	} );
} );


/**
 * Paging information for the first table in the current context.
 *
 * If you require paging information for another table, use the `table()` method
 * with a suitable selector.
 *
 * @return {object} Object with the following properties set:
 *  * `page` - Current page index (zero based - i.e. the first page is `0`)
 *  * `pages` - Total number of pages
 *  * `start` - Display index for the first record shown on the current page
 *  * `end` - Display index for the last record shown on the current page
 *  * `length` - Display length (number of records). Note that generally `start
 *    + length = end`, but this is not always true, for example if there are
 *    only 2 records to show on the final page, with a length of 10.
 *  * `recordsTotal` - Full data set length
 *  * `recordsDisplay` - Data set length once the current filtering criterion
 *    are applied.
 */
_api_register( 'page.info()', function () {
	if ( this.context.length === 0 ) {
		return undefined;
	}

	var
		settings   = this.context[0],
		start      = settings._iDisplayStart,
		len        = settings.oFeatures.bPaginate ? settings._iDisplayLength : -1,
		visRecords = settings.fnRecordsDisplay(),
		all        = len === -1;

	return {
		"page":           all ? 0 : Math.floor( start / len ),
		"pages":          all ? 1 : Math.ceil( visRecords / len ),
		"start":          start,
		"end":            settings.fnDisplayEnd(),
		"length":         len,
		"recordsTotal":   settings.fnRecordsTotal(),
		"recordsDisplay": visRecords,
		"serverSide":     _fnDataSource( settings ) === 'ssp'
	};
} );


/**
 * Get the current page length.
 *
 * @return {integer} Current page length. Note `-1` indicates that all records
 *   are to be shown.
 *//**
 * Set the current page length.
 *
 * @param {integer} Page length to set. Use `-1` to show all records.
 * @returns {DataTables.Api} this
 */
_api_register( 'page.len()', function ( len ) {
	// Note that we can't call this function 'length()' because `length`
	// is a Javascript property of functions which defines how many arguments
	// the function expects.
	if ( len === undefined ) {
		return this.context.length !== 0 ?
			this.context[0]._iDisplayLength :
			undefined;
	}

	// else, set the page length
	return this.iterator( 'table', function ( settings ) {
		_fnLengthChange( settings, len );
	} );
} );



var __reload = function ( settings, holdPosition, callback ) {
	// Use the draw event to trigger a callback
	if ( callback ) {
		var api = new _Api( settings );

		api.one( 'draw', function () {
			callback( api.ajax.json() );
		} );
	}

	if ( _fnDataSource( settings ) == 'ssp' ) {
		_fnReDraw( settings, holdPosition );
	}
	else {
		_fnProcessingDisplay( settings, true );

		// Cancel an existing request
		var xhr = settings.jqXHR;
		if ( xhr && xhr.readyState !== 4 ) {
			xhr.abort();
		}

		// Trigger xhr
		_fnBuildAjax( settings, {}, function( json ) {
			_fnClearTable( settings );

			var data = _fnAjaxDataSrc( settings, json );
			for ( var i=0, ien=data.length ; i<ien ; i++ ) {
				_fnAddData( settings, data[i] );
			}

			_fnReDraw( settings, holdPosition );
			_fnInitComplete( settings );
			_fnProcessingDisplay( settings, false );
		} );
	}
};


/**
 * Get the JSON response from the last Ajax request that DataTables made to the
 * server. Note that this returns the JSON from the first table in the current
 * context.
 *
 * @return {object} JSON received from the server.
 */
_api_register( 'ajax.json()', function () {
	var ctx = this.context;

	if ( ctx.length > 0 ) {
		return ctx[0].json;
	}

	// else return undefined;
} );


/**
 * Get the data submitted in the last Ajax request
 */
_api_register( 'ajax.params()', function () {
	var ctx = this.context;

	if ( ctx.length > 0 ) {
		return ctx[0].oAjaxData;
	}

	// else return undefined;
} );


/**
 * Reload tables from the Ajax data source. Note that this function will
 * automatically re-draw the table when the remote data has been loaded.
 *
 * @param {boolean} [reset=true] Reset (default) or hold the current paging
 *   position. A full re-sort and re-filter is performed when this method is
 *   called, which is why the pagination reset is the default action.
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.reload()', function ( callback, resetPaging ) {
	return this.iterator( 'table', function (settings) {
		__reload( settings, resetPaging===false, callback );
	} );
} );


/**
 * Get the current Ajax URL. Note that this returns the URL from the first
 * table in the current context.
 *
 * @return {string} Current Ajax source URL
 *//**
 * Set the Ajax URL. Note that this will set the URL for all tables in the
 * current context.
 *
 * @param {string} url URL to set.
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.url()', function ( url ) {
	var ctx = this.context;

	if ( url === undefined ) {
		// get
		if ( ctx.length === 0 ) {
			return undefined;
		}
		ctx = ctx[0];

		return $.isPlainObject( ctx.ajax ) ?
			ctx.ajax.url :
			ctx.ajax;
	}

	// set
	return this.iterator( 'table', function ( settings ) {
		if ( $.isPlainObject( settings.ajax ) ) {
			settings.ajax.url = url;
		}
		else {
			settings.ajax = url;
		}
	} );
} );


/**
 * Load data from the newly set Ajax URL. Note that this method is only
 * available when `ajax.url()` is used to set a URL. Additionally, this method
 * has the same effect as calling `ajax.reload()` but is provided for
 * convenience when setting a new URL. Like `ajax.reload()` it will
 * automatically redraw the table once the remote data has been loaded.
 *
 * @returns {DataTables.Api} this
 */
_api_register( 'ajax.url().load()', function ( callback, resetPaging ) {
	// Same as a reload, but makes sense to present it for easy access after a
	// url change
	return this.iterator( 'table', function ( ctx ) {
		__reload( ctx, resetPaging===false, callback );
	} );
} );




var _selector_run = function ( type, selector, selectFn, settings, opts )
{
	var
		out = [], res,
		a, i, ien, j, jen,
		selectorType = typeof selector;

	// Can't just check for isArray here, as an API or jQuery instance might be
	// given with their array like look
	if ( ! selector || selectorType === 'string' || selectorType === 'function' || selector.length === undefined ) {
		selector = [ selector ];
	}

	for ( i=0, ien=selector.length ; i<ien ; i++ ) {
		// Only split on simple strings - complex expressions will be jQuery selectors
		a = selector[i] && selector[i].split && ! selector[i].match(/[[(:]/) ?
			selector[i].split(',') :
			[ selector[i] ];

		for ( j=0, jen=a.length ; j<jen ; j++ ) {
			res = selectFn( typeof a[j] === 'string' ? (a[j]).trim() : a[j] );

			// Remove empty items
			res = res.filter( function (item) {
				return item !== null && item !== undefined;
			});

			if ( res && res.length ) {
				out = out.concat( res );
			}
		}
	}

	// selector extensions
	var ext = _ext.selector[ type ];
	if ( ext.length ) {
		for ( i=0, ien=ext.length ; i<ien ; i++ ) {
			out = ext[i]( settings, opts, out );
		}
	}

	return _unique( out );
};


var _selector_opts = function ( opts )
{
	if ( ! opts ) {
		opts = {};
	}

	// Backwards compatibility for 1.9- which used the terminology filter rather
	// than search
	if ( opts.filter && opts.search === undefined ) {
		opts.search = opts.filter;
	}

	return $.extend( {
		search: 'none',
		order: 'current',
		page: 'all'
	}, opts );
};


// Reduce the API instance to the first item found
var _selector_first = function ( old )
{
	let inst = new _Api(old.context[0]);

	// Use a push rather than passing to the constructor, since it will
	// merge arrays down automatically, which isn't what is wanted here
	if (old.length) {
		inst.push( old[0] );
	}

	inst.selector = old.selector;

	// Limit to a single row / column / cell
	if (inst.length && inst[0].length > 1) {
		inst[0].splice(1);
	}

	return inst;
};


var _selector_row_indexes = function ( settings, opts )
{
	var
		i, ien, tmp, a=[],
		displayFiltered = settings.aiDisplay,
		displayMaster = settings.aiDisplayMaster;

	var
		search = opts.search,  // none, applied, removed
		order  = opts.order,   // applied, current, index (original - compatibility with 1.9)
		page   = opts.page;    // all, current

	if ( _fnDataSource( settings ) == 'ssp' ) {
		// In server-side processing mode, most options are irrelevant since
		// rows not shown don't exist and the index order is the applied order
		// Removed is a special case - for consistency just return an empty
		// array
		return search === 'removed' ?
			[] :
			_range( 0, displayMaster.length );
	}
	else if ( page == 'current' ) {
		// Current page implies that order=current and filter=applied, since it is
		// fairly senseless otherwise, regardless of what order and search actually
		// are
		for ( i=settings._iDisplayStart, ien=settings.fnDisplayEnd() ; i<ien ; i++ ) {
			a.push( displayFiltered[i] );
		}
	}
	else if ( order == 'current' || order == 'applied' ) {
		if ( search == 'none') {
			a = displayMaster.slice();
		}
		else if ( search == 'applied' ) {
			a = displayFiltered.slice();
		}
		else if ( search == 'removed' ) {
			// O(n+m) solution by creating a hash map
			var displayFilteredMap = {};

			for ( i=0, ien=displayFiltered.length ; i<ien ; i++ ) {
				displayFilteredMap[displayFiltered[i]] = null;
			}

			displayMaster.forEach(function (item) {
				if (! Object.prototype.hasOwnProperty.call(displayFilteredMap, item)) {
					a.push(item);
				}
			});
		}
	}
	else if ( order == 'index' || order == 'original' ) {
		for ( i=0, ien=settings.aoData.length ; i<ien ; i++ ) {
			if (! settings.aoData[i]) {
				continue;
			}

			if ( search == 'none' ) {
				a.push( i );
			}
			else { // applied | removed
				tmp = displayFiltered.indexOf(i);

				if ((tmp === -1 && search == 'removed') ||
					(tmp >= 0   && search == 'applied') )
				{
					a.push( i );
				}
			}
		}
	}
	else if ( typeof order === 'number' ) {
		// Order the rows by the given column
		var ordered = _fnSort(settings, order, 'asc');

		if (search === 'none') {
			a = ordered;
		}
		else { // applied | removed
			for (i=0; i<ordered.length; i++) {
				tmp = displayFiltered.indexOf(ordered[i]);

				if ((tmp === -1 && search == 'removed') ||
					(tmp >= 0   && search == 'applied') )
				{
					a.push( ordered[i] );
				}
			}
		}
	}

	return a;
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Rows
 *
 * {}          - no selector - use all available rows
 * {integer}   - row aoData index
 * {node}      - TR node
 * {string}    - jQuery selector to apply to the TR elements
 * {array}     - jQuery array of nodes, or simply an array of TR nodes
 *
 */
var __row_selector = function ( settings, selector, opts )
{
	var rows;
	var run = function ( sel ) {
		var selInt = _intVal( sel );
		var aoData = settings.aoData;

		// Short cut - selector is a number and no options provided (default is
		// all records, so no need to check if the index is in there, since it
		// must be - dev error if the index doesn't exist).
		if ( selInt !== null && ! opts ) {
			return [ selInt ];
		}

		if ( ! rows ) {
			rows = _selector_row_indexes( settings, opts );
		}

		if ( selInt !== null && rows.indexOf(selInt) !== -1 ) {
			// Selector - integer
			return [ selInt ];
		}
		else if ( sel === null || sel === undefined || sel === '' ) {
			// Selector - none
			return rows;
		}

		// Selector - function
		if ( typeof sel === 'function' ) {
			return rows.map( function (idx) {
				var row = aoData[ idx ];
				return sel( idx, row._aData, row.nTr ) ? idx : null;
			} );
		}

		// Selector - node
		if ( sel.nodeName ) {
			var rowIdx = sel._DT_RowIndex;  // Property added by DT for fast lookup
			var cellIdx = sel._DT_CellIndex;

			if ( rowIdx !== undefined ) {
				// Make sure that the row is actually still present in the table
				return aoData[ rowIdx ] && aoData[ rowIdx ].nTr === sel ?
					[ rowIdx ] :
					[];
			}
			else if ( cellIdx ) {
				return aoData[ cellIdx.row ] && aoData[ cellIdx.row ].nTr === sel.parentNode ?
					[ cellIdx.row ] :
					[];
			}
			else {
				var host = $(sel).closest('*[data-dt-row]');
				return host.length ?
					[ host.data('dt-row') ] :
					[];
			}
		}

		// ID selector. Want to always be able to select rows by id, regardless
		// of if the tr element has been created or not, so can't rely upon
		// jQuery here - hence a custom implementation. This does not match
		// Sizzle's fast selector or HTML4 - in HTML5 the ID can be anything,
		// but to select it using a CSS selector engine (like Sizzle or
		// querySelect) it would need to need to be escaped for some characters.
		// DataTables simplifies this for row selectors since you can select
		// only a row. A # indicates an id any anything that follows is the id -
		// unescaped.
		if ( typeof sel === 'string' && sel.charAt(0) === '#' ) {
			// get row index from id
			var rowObj = settings.aIds[ sel.replace( /^#/, '' ) ];
			if ( rowObj !== undefined ) {
				return [ rowObj.idx ];
			}

			// need to fall through to jQuery in case there is DOM id that
			// matches
		}
		
		// Get nodes in the order from the `rows` array with null values removed
		var nodes = _removeEmpty(
			_pluck_order( settings.aoData, rows, 'nTr' )
		);

		// Selector - jQuery selector string, array of nodes or jQuery object/
		// As jQuery's .filter() allows jQuery objects to be passed in filter,
		// it also allows arrays, so this will cope with all three options
		return $(nodes)
			.filter( sel )
			.map( function () {
				return this._DT_RowIndex;
			} )
			.toArray();
	};

	var matched = _selector_run( 'row', selector, run, settings, opts );

	if (opts.order === 'current' || opts.order === 'applied') {
		_fnSortDisplay(settings, matched);
	}

	return matched;
};


_api_register( 'rows()', function ( selector, opts ) {
	// argument shifting
	if ( selector === undefined ) {
		selector = '';
	}
	else if ( $.isPlainObject( selector ) ) {
		opts = selector;
		selector = '';
	}

	opts = _selector_opts( opts );

	var inst = this.iterator( 'table', function ( settings ) {
		return __row_selector( settings, selector, opts );
	}, 1 );

	// Want argument shifting here and in __row_selector?
	inst.selector.rows = selector;
	inst.selector.opts = opts;

	return inst;
} );

_api_register( 'rows().nodes()', function () {
	return this.iterator( 'row', function ( settings, row ) {
		return settings.aoData[ row ].nTr || undefined;
	}, 1 );
} );

_api_register( 'rows().data()', function () {
	return this.iterator( true, 'rows', function ( settings, rows ) {
		return _pluck_order( settings.aoData, rows, '_aData' );
	}, 1 );
} );

_api_registerPlural( 'rows().cache()', 'row().cache()', function ( type ) {
	return this.iterator( 'row', function ( settings, row ) {
		var r = settings.aoData[ row ];
		return type === 'search' ? r._aFilterData : r._aSortData;
	}, 1 );
} );

_api_registerPlural( 'rows().invalidate()', 'row().invalidate()', function ( src ) {
	return this.iterator( 'row', function ( settings, row ) {
		_fnInvalidate( settings, row, src );
	} );
} );

_api_registerPlural( 'rows().indexes()', 'row().index()', function () {
	return this.iterator( 'row', function ( settings, row ) {
		return row;
	}, 1 );
} );

_api_registerPlural( 'rows().ids()', 'row().id()', function ( hash ) {
	var a = [];
	var context = this.context;

	// `iterator` will drop undefined values, but in this case we want them
	for ( var i=0, ien=context.length ; i<ien ; i++ ) {
		for ( var j=0, jen=this[i].length ; j<jen ; j++ ) {
			var id = context[i].rowIdFn( context[i].aoData[ this[i][j] ]._aData );
			a.push( (hash === true ? '#' : '' )+ id );
		}
	}

	return new _Api( context, a );
} );

_api_registerPlural( 'rows().remove()', 'row().remove()', function () {
	this.iterator( 'row', function ( settings, row ) {
		var data = settings.aoData;
		var rowData = data[ row ];

		// Delete from the display arrays
		var idx = settings.aiDisplayMaster.indexOf(row);
		if (idx !== -1) {
			settings.aiDisplayMaster.splice(idx, 1);
		}

		idx = settings.aiDisplay.indexOf(row);
		if (idx !== -1) {
			settings.aiDisplay.splice(idx, 1);
		}

		// For server-side processing tables - subtract the deleted row from the count
		if ( settings._iRecordsDisplay > 0 ) {
			settings._iRecordsDisplay--;
		}

		// Check for an 'overflow' they case for displaying the table
		_fnLengthOverflow( settings );

		// Remove the row's ID reference if there is one
		var id = settings.rowIdFn( rowData._aData );
		if ( id !== undefined ) {
			delete settings.aIds[ id ];
		}

		data[row] = null;
	} );

	return this;
} );


_api_register( 'rows.add()', function ( rows ) {
	var newRows = this.iterator( 'table', function ( settings ) {
			var row, i, ien;
			var out = [];

			for ( i=0, ien=rows.length ; i<ien ; i++ ) {
				row = rows[i];

				if ( row.nodeName && row.nodeName.toUpperCase() === 'TR' ) {
					out.push( _fnAddTr( settings, row )[0] );
				}
				else {
					out.push( _fnAddData( settings, row ) );
				}
			}

			return out;
		}, 1 );

	// Return an Api.rows() extended instance, so rows().nodes() etc can be used
	var modRows = this.rows( -1 );
	modRows.pop();
	modRows.push.apply(modRows, newRows);

	return modRows;
} );





/**
 *
 */
_api_register( 'row()', function ( selector, opts ) {
	return _selector_first( this.rows( selector, opts ) );
} );


_api_register( 'row().data()', function ( data ) {
	var ctx = this.context;

	if ( data === undefined ) {
		// Get
		return ctx.length && this.length && this[0].length ?
			ctx[0].aoData[ this[0] ]._aData :
			undefined;
	}

	// Set
	var row = ctx[0].aoData[ this[0] ];
	row._aData = data;

	// If the DOM has an id, and the data source is an array
	if ( Array.isArray( data ) && row.nTr && row.nTr.id ) {
		_fnSetObjectDataFn( ctx[0].rowId )( data, row.nTr.id );
	}

	// Automatically invalidate
	_fnInvalidate( ctx[0], this[0], 'data' );

	return this;
} );


_api_register( 'row().node()', function () {
	var ctx = this.context;

	return ctx.length && this.length && this[0].length ?
		ctx[0].aoData[ this[0] ].nTr || null :
		null;
} );


_api_register( 'row.add()', function ( row ) {
	// Allow a jQuery object to be passed in - only a single row is added from
	// it though - the first element in the set
	if ( row instanceof $ && row.length ) {
		row = row[0];
	}

	var rows = this.iterator( 'table', function ( settings ) {
		if ( row.nodeName && row.nodeName.toUpperCase() === 'TR' ) {
			return _fnAddTr( settings, row )[0];
		}
		return _fnAddData( settings, row );
	} );

	// Return an Api.rows() extended instance, with the newly added row selected
	return this.row( rows[0] );
} );


$(document).on('plugin-init.dt', function (e, context) {
	var api = new _Api( context );

	api.on( 'stateSaveParams.DT', function ( e, settings, d ) {
		// This could be more compact with the API, but it is a lot faster as a simple
		// internal loop
		var idFn = settings.rowIdFn;
		var rows = settings.aiDisplayMaster;
		var ids = [];

		for (var i=0 ; i<rows.length ; i++) {
			var rowIdx = rows[i];
			var data = settings.aoData[rowIdx];

			if (data._detailsShow) {
				ids.push( '#' + idFn(data._aData) );
			}
		}

		d.childRows = ids;
	});

	// For future state loads (e.g. with StateRestore)
	api.on( 'stateLoaded.DT', function (e, settings, state) {
		__details_state_load( api, state );
	});

	// And the initial load state
	__details_state_load( api, api.state.loaded() );
});

var __details_state_load = function (api, state)
{
	if ( state && state.childRows ) {
		api
			.rows( state.childRows.map(function (id){
				return id.replace(/:/g, '\\:')
			}) )
			.every( function () {
				_fnCallbackFire( api.settings()[0], null, 'requestChild', [ this ] )
			});
	}
}

var __details_add = function ( ctx, row, data, klass )
{
	// Convert to array of TR elements
	var rows = [];
	var addRow = function ( r, k ) {
		// Recursion to allow for arrays of jQuery objects
		if ( Array.isArray( r ) || r instanceof $ ) {
			for ( var i=0, ien=r.length ; i<ien ; i++ ) {
				addRow( r[i], k );
			}
			return;
		}

		// If we get a TR element, then just add it directly - up to the dev
		// to add the correct number of columns etc
		if ( r.nodeName && r.nodeName.toLowerCase() === 'tr' ) {
			r.setAttribute( 'data-dt-row', row.idx );
			rows.push( r );
		}
		else {
			// Otherwise create a row with a wrapper
			var created = $('<tr><td></td></tr>')
				.attr( 'data-dt-row', row.idx )
				.addClass( k );
			
			$('td', created)
				.addClass( k )
				.html( r )[0].colSpan = _fnVisbleColumns( ctx );

			rows.push( created[0] );
		}
	};

	addRow( data, klass );

	if ( row._details ) {
		row._details.detach();
	}

	row._details = $(rows);

	// If the children were already shown, that state should be retained
	if ( row._detailsShow ) {
		row._details.insertAfter( row.nTr );
	}
};


// Make state saving of child row details async to allow them to be batch processed
var __details_state = DataTable.util.throttle(
	function (ctx) {
		_fnSaveState( ctx[0] )
	},
	500
);


var __details_remove = function ( api, idx )
{
	var ctx = api.context;

	if ( ctx.length ) {
		var row = ctx[0].aoData[ idx !== undefined ? idx : api[0] ];

		if ( row && row._details ) {
			row._details.remove();

			row._detailsShow = undefined;
			row._details = undefined;
			$( row.nTr ).removeClass( 'dt-hasChild' );
			__details_state( ctx );
		}
	}
};


var __details_display = function ( api, show ) {
	var ctx = api.context;

	if ( ctx.length && api.length ) {
		var row = ctx[0].aoData[ api[0] ];

		if ( row._details ) {
			row._detailsShow = show;

			if ( show ) {
				row._details.insertAfter( row.nTr );
				$( row.nTr ).addClass( 'dt-hasChild' );
			}
			else {
				row._details.detach();
				$( row.nTr ).removeClass( 'dt-hasChild' );
			}

			_fnCallbackFire( ctx[0], null, 'childRow', [ show, api.row( api[0] ) ] )

			__details_events( ctx[0] );
			__details_state( ctx );
		}
	}
};


var __details_events = function ( settings )
{
	var api = new _Api( settings );
	var namespace = '.dt.DT_details';
	var drawEvent = 'draw'+namespace;
	var colvisEvent = 'column-sizing'+namespace;
	var destroyEvent = 'destroy'+namespace;
	var data = settings.aoData;

	api.off( drawEvent +' '+ colvisEvent +' '+ destroyEvent );

	if ( _pluck( data, '_details' ).length > 0 ) {
		// On each draw, insert the required elements into the document
		api.on( drawEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			api.rows( {page:'current'} ).eq(0).each( function (idx) {
				// Internal data grab
				var row = data[ idx ];

				if ( row._detailsShow ) {
					row._details.insertAfter( row.nTr );
				}
			} );
		} );

		// Column visibility change - update the colspan
		api.on( colvisEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			// Update the colspan for the details rows (note, only if it already has
			// a colspan)
			var row, visible = _fnVisbleColumns( ctx );

			for ( var i=0, ien=data.length ; i<ien ; i++ ) {
				row = data[i];

				if ( row && row._details ) {
					row._details.each(function () {
						var el = $(this).children('td');

						if (el.length == 1) {
							el.attr('colspan', visible);
						}
					});
				}
			}
		} );

		// Table destroyed - nuke any child rows
		api.on( destroyEvent, function ( e, ctx ) {
			if ( settings !== ctx ) {
				return;
			}

			for ( var i=0, ien=data.length ; i<ien ; i++ ) {
				if ( data[i] && data[i]._details ) {
					__details_remove( api, i );
				}
			}
		} );
	}
};

// Strings for the method names to help minification
var _emp = '';
var _child_obj = _emp+'row().child';
var _child_mth = _child_obj+'()';

// data can be:
//  tr
//  string
//  jQuery or array of any of the above
_api_register( _child_mth, function ( data, klass ) {
	var ctx = this.context;

	if ( data === undefined ) {
		// get
		return ctx.length && this.length && ctx[0].aoData[ this[0] ]
			? ctx[0].aoData[ this[0] ]._details
			: undefined;
	}
	else if ( data === true ) {
		// show
		this.child.show();
	}
	else if ( data === false ) {
		// remove
		__details_remove( this );
	}
	else if ( ctx.length && this.length ) {
		// set
		__details_add( ctx[0], ctx[0].aoData[ this[0] ], data, klass );
	}

	return this;
} );


_api_register( [
	_child_obj+'.show()',
	_child_mth+'.show()' // only when `child()` was called with parameters (without
], function () {         // it returns an object and this method is not executed)
	__details_display( this, true );
	return this;
} );


_api_register( [
	_child_obj+'.hide()',
	_child_mth+'.hide()' // only when `child()` was called with parameters (without
], function () {         // it returns an object and this method is not executed)
	__details_display( this, false );
	return this;
} );


_api_register( [
	_child_obj+'.remove()',
	_child_mth+'.remove()' // only when `child()` was called with parameters (without
], function () {           // it returns an object and this method is not executed)
	__details_remove( this );
	return this;
} );


_api_register( _child_obj+'.isShown()', function () {
	var ctx = this.context;

	if ( ctx.length && this.length ) {
		// _detailsShown as false or undefined will fall through to return false
		return ctx[0].aoData[ this[0] ]._detailsShow || false;
	}
	return false;
} );



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Columns
 *
 * {integer}           - column index (>=0 count from left, <0 count from right)
 * "{integer}:visIdx"  - visible column index (i.e. translate to column index)  (>=0 count from left, <0 count from right)
 * "{integer}:visible" - alias for {integer}:visIdx  (>=0 count from left, <0 count from right)
 * "{string}:name"     - column name
 * "{string}"          - jQuery selector on column header nodes
 *
 */

// can be an array of these items, comma separated list, or an array of comma
// separated lists

var __re_column_selector = /^([^:]+):(name|title|visIdx|visible)$/;


// r1 and r2 are redundant - but it means that the parameters match for the
// iterator callback in columns().data()
var __columnData = function ( settings, column, r1, r2, rows, type ) {
	var a = [];
	for ( var row=0, ien=rows.length ; row<ien ; row++ ) {
		a.push( _fnGetCellData( settings, rows[row], column, type ) );
	}
	return a;
};


var __column_selector = function ( settings, selector, opts )
{
	var
		columns = settings.aoColumns,
		names = _pluck( columns, 'sName' ),
		titles = _pluck( columns, 'sTitle' ),
		cells = DataTable.util.get('[].[].cell')(settings.aoHeader),
		nodes = _unique( _flatten([], cells) );
	
	var run = function ( s ) {
		var selInt = _intVal( s );

		// Selector - all
		if ( s === '' ) {
			return _range( columns.length );
		}

		// Selector - index
		if ( selInt !== null ) {
			return [ selInt >= 0 ?
				selInt : // Count from left
				columns.length + selInt // Count from right (+ because its a negative value)
			];
		}

		// Selector = function
		if ( typeof s === 'function' ) {
			var rows = _selector_row_indexes( settings, opts );

			return columns.map(function (col, idx) {
				return s(
						idx,
						__columnData( settings, idx, 0, 0, rows )
					) ? idx : null;
			});
		}

		// jQuery or string selector
		var match = typeof s === 'string' ?
			s.match( __re_column_selector ) :
			'';

		if ( match ) {
			switch( match[2] ) {
				case 'visIdx':
				case 'visible':
					var idx = parseInt( match[1], 10 );
					// Visible index given, convert to column index
					if ( idx < 0 ) {
						// Counting from the right
						var visColumns = columns.map( function (col,i) {
							return col.bVisible ? i : null;
						} );
						return [ visColumns[ visColumns.length + idx ] ];
					}
					// Counting from the left
					return [ _fnVisibleToColumnIndex( settings, idx ) ];

				case 'name':
					// match by name. `names` is column index complete and in order
					return names.map( function (name, i) {
						return name === match[1] ? i : null;
					} );

				case 'title':
					// match by column title
					return titles.map( function (title, i) {
						return title === match[1] ? i : null;
					} );

				default:
					return [];
			}
		}

		// Cell in the table body
		if ( s.nodeName && s._DT_CellIndex ) {
			return [ s._DT_CellIndex.column ];
		}

		// jQuery selector on the TH elements for the columns
		var jqResult = $( nodes )
			.filter( s )
			.map( function () {
				return _fnColumnsFromHeader( this ); // `nodes` is column index complete and in order
			} )
			.toArray();

		if ( jqResult.length || ! s.nodeName ) {
			return jqResult;
		}

		// Otherwise a node which might have a `dt-column` data attribute, or be
		// a child or such an element
		var host = $(s).closest('*[data-dt-column]');
		return host.length ?
			[ host.data('dt-column') ] :
			[];
	};

	return _selector_run( 'column', selector, run, settings, opts );
};


var __setColumnVis = function ( settings, column, vis ) {
	var
		cols = settings.aoColumns,
		col  = cols[ column ],
		data = settings.aoData,
		cells, i, ien, tr;

	// Get
	if ( vis === undefined ) {
		return col.bVisible;
	}

	// Set
	// No change
	if ( col.bVisible === vis ) {
		return false;
	}

	if ( vis ) {
		// Insert column
		// Need to decide if we should use appendChild or insertBefore
		var insertBefore = _pluck(cols, 'bVisible').indexOf(true, column+1);

		for ( i=0, ien=data.length ; i<ien ; i++ ) {
			if (data[i]) {
				tr = data[i].nTr;
				cells = data[i].anCells;

				if ( tr ) {
					// insertBefore can act like appendChild if 2nd arg is null
					tr.insertBefore( cells[ column ], cells[ insertBefore ] || null );
				}
			}
		}
	}
	else {
		// Remove column
		$( _pluck( settings.aoData, 'anCells', column ) ).detach();
	}

	// Common actions
	col.bVisible = vis;

	_colGroup(settings);
	
	return true;
};


_api_register( 'columns()', function ( selector, opts ) {
	// argument shifting
	if ( selector === undefined ) {
		selector = '';
	}
	else if ( $.isPlainObject( selector ) ) {
		opts = selector;
		selector = '';
	}

	opts = _selector_opts( opts );

	var inst = this.iterator( 'table', function ( settings ) {
		return __column_selector( settings, selector, opts );
	}, 1 );

	// Want argument shifting here and in _row_selector?
	inst.selector.cols = selector;
	inst.selector.opts = opts;

	return inst;
} );

_api_registerPlural( 'columns().header()', 'column().header()', function ( row ) {
	return this.iterator( 'column', function ( settings, column ) {
		var header = settings.aoHeader;
		var target = row !== undefined
			? row
			: settings.bSortCellsTop // legacy support
				? 0
				: header.length - 1;

		return header[target][column].cell;
	}, 1 );
} );

_api_registerPlural( 'columns().footer()', 'column().footer()', function ( row ) {
	return this.iterator( 'column', function ( settings, column ) {
		var footer = settings.aoFooter;

		if (! footer.length) {
			return null;
		}

		return settings.aoFooter[row !== undefined ? row : 0][column].cell;
	}, 1 );
} );

_api_registerPlural( 'columns().data()', 'column().data()', function () {
	return this.iterator( 'column-rows', __columnData, 1 );
} );

_api_registerPlural( 'columns().render()', 'column().render()', function ( type ) {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return __columnData( settings, column, i, j, rows, type );
	}, 1 );
} );

_api_registerPlural( 'columns().dataSrc()', 'column().dataSrc()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		return settings.aoColumns[column].mData;
	}, 1 );
} );

_api_registerPlural( 'columns().cache()', 'column().cache()', function ( type ) {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return _pluck_order( settings.aoData, rows,
			type === 'search' ? '_aFilterData' : '_aSortData', column
		);
	}, 1 );
} );

_api_registerPlural( 'columns().init()', 'column().init()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		return settings.aoColumns[column];
	}, 1 );
} );

_api_registerPlural( 'columns().nodes()', 'column().nodes()', function () {
	return this.iterator( 'column-rows', function ( settings, column, i, j, rows ) {
		return _pluck_order( settings.aoData, rows, 'anCells', column ) ;
	}, 1 );
} );

_api_registerPlural( 'columns().titles()', 'column().title()', function (title, row) {
	return this.iterator( 'column', function ( settings, column ) {
		// Argument shifting
		if (typeof title === 'number') {
			row = title;
			title = undefined;
		}

		var span = $('span.dt-column-title', this.column(column).header(row));

		if (title !== undefined) {
			span.html(title);
			return this;
		}

		return span.html();
	}, 1 );
} );

_api_registerPlural( 'columns().types()', 'column().type()', function () {
	return this.iterator( 'column', function ( settings, column ) {
		var type = settings.aoColumns[column].sType;

		// If the type was invalidated, then resolve it. This actually does
		// all columns at the moment. Would only happen once if getting all
		// column's data types.
		if (! type) {
			_fnColumnTypes(settings);
		}

		return type;
	}, 1 );
} );

_api_registerPlural( 'columns().visible()', 'column().visible()', function ( vis, calc ) {
	var that = this;
	var changed = [];
	var ret = this.iterator( 'column', function ( settings, column ) {
		if ( vis === undefined ) {
			return settings.aoColumns[ column ].bVisible;
		} // else
		
		if (__setColumnVis( settings, column, vis )) {
			changed.push(column);
		}
	} );

	// Group the column visibility changes
	if ( vis !== undefined ) {
		this.iterator( 'table', function ( settings ) {
			// Redraw the header after changes
			_fnDrawHead( settings, settings.aoHeader );
			_fnDrawHead( settings, settings.aoFooter );
	
			// Update colspan for no records display. Child rows and extensions will use their own
			// listeners to do this - only need to update the empty table item here
			if ( ! settings.aiDisplay.length ) {
				$(settings.nTBody).find('td[colspan]').attr('colspan', _fnVisbleColumns(settings));
			}
	
			_fnSaveState( settings );

			// Second loop once the first is done for events
			that.iterator( 'column', function ( settings, column ) {
				if (changed.includes(column)) {
					_fnCallbackFire( settings, null, 'column-visibility', [settings, column, vis, calc] );
				}
			} );

			if ( changed.length && (calc === undefined || calc) ) {
				that.columns.adjust();
			}
		});
	}

	return ret;
} );

_api_registerPlural( 'columns().widths()', 'column().width()', function () {
	// Injects a fake row into the table for just a moment so the widths can
	// be read, regardless of colspan in the header and rows being present in
	// the body
	var columns = this.columns(':visible').count();
	var row = $('<tr>').html('<td>' + Array(columns).join('</td><td>') + '</td>');

	$(this.table().body()).append(row);

	var widths = row.children().map(function () {
		return $(this).outerWidth();
	});

	row.remove();
	
	return this.iterator( 'column', function ( settings, column ) {
		var visIdx = _fnColumnIndexToVisible( settings, column );

		return visIdx !== null ? widths[visIdx] : 0;
	}, 1);
} );

_api_registerPlural( 'columns().indexes()', 'column().index()', function ( type ) {
	return this.iterator( 'column', function ( settings, column ) {
		return type === 'visible' ?
			_fnColumnIndexToVisible( settings, column ) :
			column;
	}, 1 );
} );

_api_register( 'columns.adjust()', function () {
	return this.iterator( 'table', function ( settings ) {
		_fnAdjustColumnSizing( settings );
	}, 1 );
} );

_api_register( 'column.index()', function ( type, idx ) {
	if ( this.context.length !== 0 ) {
		var ctx = this.context[0];

		if ( type === 'fromVisible' || type === 'toData' ) {
			return _fnVisibleToColumnIndex( ctx, idx );
		}
		else if ( type === 'fromData' || type === 'toVisible' ) {
			return _fnColumnIndexToVisible( ctx, idx );
		}
	}
} );

_api_register( 'column()', function ( selector, opts ) {
	return _selector_first( this.columns( selector, opts ) );
} );

var __cell_selector = function ( settings, selector, opts )
{
	var data = settings.aoData;
	var rows = _selector_row_indexes( settings, opts );
	var cells = _removeEmpty( _pluck_order( data, rows, 'anCells' ) );
	var allCells = $(_flatten( [], cells ));
	var row;
	var columns = settings.aoColumns.length;
	var a, i, ien, j, o, host;

	var run = function ( s ) {
		var fnSelector = typeof s === 'function';

		if ( s === null || s === undefined || fnSelector ) {
			// All cells and function selectors
			a = [];

			for ( i=0, ien=rows.length ; i<ien ; i++ ) {
				row = rows[i];

				for ( j=0 ; j<columns ; j++ ) {
					o = {
						row: row,
						column: j
					};

					if ( fnSelector ) {
						// Selector - function
						host = data[ row ];

						if ( s( o, _fnGetCellData(settings, row, j), host.anCells ? host.anCells[j] : null ) ) {
							a.push( o );
						}
					}
					else {
						// Selector - all
						a.push( o );
					}
				}
			}

			return a;
		}
		
		// Selector - index
		if ( $.isPlainObject( s ) ) {
			// Valid cell index and its in the array of selectable rows
			return s.column !== undefined && s.row !== undefined && rows.indexOf(s.row) !== -1 ?
				[s] :
				[];
		}

		// Selector - jQuery filtered cells
		var jqResult = allCells
			.filter( s )
			.map( function (i, el) {
				return { // use a new object, in case someone changes the values
					row:    el._DT_CellIndex.row,
					column: el._DT_CellIndex.column
				};
			} )
			.toArray();

		if ( jqResult.length || ! s.nodeName ) {
			return jqResult;
		}

		// Otherwise the selector is a node, and there is one last option - the
		// element might be a child of an element which has dt-row and dt-column
		// data attributes
		host = $(s).closest('*[data-dt-row]');
		return host.length ?
			[ {
				row: host.data('dt-row'),
				column: host.data('dt-column')
			} ] :
			[];
	};

	return _selector_run( 'cell', selector, run, settings, opts );
};




_api_register( 'cells()', function ( rowSelector, columnSelector, opts ) {
	// Argument shifting
	if ( $.isPlainObject( rowSelector ) ) {
		// Indexes
		if ( rowSelector.row === undefined ) {
			// Selector options in first parameter
			opts = rowSelector;
			rowSelector = null;
		}
		else {
			// Cell index objects in first parameter
			opts = columnSelector;
			columnSelector = null;
		}
	}
	if ( $.isPlainObject( columnSelector ) ) {
		opts = columnSelector;
		columnSelector = null;
	}

	// Cell selector
	if ( columnSelector === null || columnSelector === undefined ) {
		return this.iterator( 'table', function ( settings ) {
			return __cell_selector( settings, rowSelector, _selector_opts( opts ) );
		} );
	}

	// The default built in options need to apply to row and columns
	var internalOpts = opts ? {
		page: opts.page,
		order: opts.order,
		search: opts.search
	} : {};

	// Row + column selector
	var columns = this.columns( columnSelector, internalOpts );
	var rows = this.rows( rowSelector, internalOpts );
	var i, ien, j, jen;

	var cellsNoOpts = this.iterator( 'table', function ( settings, idx ) {
		var a = [];

		for ( i=0, ien=rows[idx].length ; i<ien ; i++ ) {
			for ( j=0, jen=columns[idx].length ; j<jen ; j++ ) {
				a.push( {
					row:    rows[idx][i],
					column: columns[idx][j]
				} );
			}
		}

		return a;
	}, 1 );

	// There is currently only one extension which uses a cell selector extension
	// It is a _major_ performance drag to run this if it isn't needed, so this is
	// an extension specific check at the moment
	var cells = opts && opts.selected ?
		this.cells( cellsNoOpts, opts ) :
		cellsNoOpts;

	$.extend( cells.selector, {
		cols: columnSelector,
		rows: rowSelector,
		opts: opts
	} );

	return cells;
} );


_api_registerPlural( 'cells().nodes()', 'cell().node()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		var data = settings.aoData[ row ];

		return data && data.anCells ?
			data.anCells[ column ] :
			undefined;
	}, 1 );
} );


_api_register( 'cells().data()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return _fnGetCellData( settings, row, column );
	}, 1 );
} );


_api_registerPlural( 'cells().cache()', 'cell().cache()', function ( type ) {
	type = type === 'search' ? '_aFilterData' : '_aSortData';

	return this.iterator( 'cell', function ( settings, row, column ) {
		return settings.aoData[ row ][ type ][ column ];
	}, 1 );
} );


_api_registerPlural( 'cells().render()', 'cell().render()', function ( type ) {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return _fnGetCellData( settings, row, column, type );
	}, 1 );
} );


_api_registerPlural( 'cells().indexes()', 'cell().index()', function () {
	return this.iterator( 'cell', function ( settings, row, column ) {
		return {
			row: row,
			column: column,
			columnVisible: _fnColumnIndexToVisible( settings, column )
		};
	}, 1 );
} );


_api_registerPlural( 'cells().invalidate()', 'cell().invalidate()', function ( src ) {
	return this.iterator( 'cell', function ( settings, row, column ) {
		_fnInvalidate( settings, row, src, column );
	} );
} );



_api_register( 'cell()', function ( rowSelector, columnSelector, opts ) {
	return _selector_first( this.cells( rowSelector, columnSelector, opts ) );
} );


_api_register( 'cell().data()', function ( data ) {
	var ctx = this.context;
	var cell = this[0];

	if ( data === undefined ) {
		// Get
		return ctx.length && cell.length ?
			_fnGetCellData( ctx[0], cell[0].row, cell[0].column ) :
			undefined;
	}

	// Set
	_fnSetCellData( ctx[0], cell[0].row, cell[0].column, data );
	_fnInvalidate( ctx[0], cell[0].row, 'data', cell[0].column );

	return this;
} );



/**
 * Get current ordering (sorting) that has been applied to the table.
 *
 * @returns {array} 2D array containing the sorting information for the first
 *   table in the current context. Each element in the parent array represents
 *   a column being sorted upon (i.e. multi-sorting with two columns would have
 *   2 inner arrays). The inner arrays may have 2 or 3 elements. The first is
 *   the column index that the sorting condition applies to, the second is the
 *   direction of the sort (`desc` or `asc`) and, optionally, the third is the
 *   index of the sorting order from the `column.sorting` initialisation array.
 *//**
 * Set the ordering for the table.
 *
 * @param {integer} order Column index to sort upon.
 * @param {string} direction Direction of the sort to be applied (`asc` or `desc`)
 * @returns {DataTables.Api} this
 *//**
 * Set the ordering for the table.
 *
 * @param {array} order 1D array of sorting information to be applied.
 * @param {array} [...] Optional additional sorting conditions
 * @returns {DataTables.Api} this
 *//**
 * Set the ordering for the table.
 *
 * @param {array} order 2D array of sorting information to be applied.
 * @returns {DataTables.Api} this
 */
_api_register( 'order()', function ( order, dir ) {
	var ctx = this.context;
	var args = Array.prototype.slice.call( arguments );

	if ( order === undefined ) {
		// get
		return ctx.length !== 0 ?
			ctx[0].aaSorting :
			undefined;
	}

	// set
	if ( typeof order === 'number' ) {
		// Simple column / direction passed in
		order = [ [ order, dir ] ];
	}
	else if ( args.length > 1 ) {
		// Arguments passed in (list of 1D arrays)
		order = args;
	}
	// otherwise a 2D array was passed in

	return this.iterator( 'table', function ( settings ) {
		settings.aaSorting = Array.isArray(order) ? order.slice() : order;
	} );
} );


/**
 * Attach a sort listener to an element for a given column
 *
 * @param {node|jQuery|string} node Identifier for the element(s) to attach the
 *   listener to. This can take the form of a single DOM node, a jQuery
 *   collection of nodes or a jQuery selector which will identify the node(s).
 * @param {integer} column the column that a click on this node will sort on
 * @param {function} [callback] callback function when sort is run
 * @returns {DataTables.Api} this
 */
_api_register( 'order.listener()', function ( node, column, callback ) {
	return this.iterator( 'table', function ( settings ) {
		_fnSortAttachListener(settings, node, {}, column, callback);
	} );
} );


_api_register( 'order.fixed()', function ( set ) {
	if ( ! set ) {
		var ctx = this.context;
		var fixed = ctx.length ?
			ctx[0].aaSortingFixed :
			undefined;

		return Array.isArray( fixed ) ?
			{ pre: fixed } :
			fixed;
	}

	return this.iterator( 'table', function ( settings ) {
		settings.aaSortingFixed = $.extend( true, {}, set );
	} );
} );


// Order by the selected column(s)
_api_register( [
	'columns().order()',
	'column().order()'
], function ( dir ) {
	var that = this;

	if ( ! dir ) {
		return this.iterator( 'column', function ( settings, idx ) {
			var sort = _fnSortFlatten( settings );

			for ( var i=0, ien=sort.length ; i<ien ; i++ ) {
				if ( sort[i].col === idx ) {
					return sort[i].dir;
				}
			}

			return null;
		}, 1 );
	}
	else {
		return this.iterator( 'table', function ( settings, i ) {
			settings.aaSorting = that[i].map( function (col) {
				return [ col, dir ];
			} );
		} );
	}
} );

_api_registerPlural('columns().orderable()', 'column().orderable()', function ( directions ) {
	return this.iterator( 'column', function ( settings, idx ) {
		var col = settings.aoColumns[idx];

		return directions ?
			col.asSorting :
			col.bSortable;
	}, 1 );
} );


_api_register( 'processing()', function ( show ) {
	return this.iterator( 'table', function ( ctx ) {
		_fnProcessingDisplay( ctx, show );
	} );
} );


_api_register( 'search()', function ( input, regex, smart, caseInsen ) {
	var ctx = this.context;

	if ( input === undefined ) {
		// get
		return ctx.length !== 0 ?
			ctx[0].oPreviousSearch.search :
			undefined;
	}

	// set
	return this.iterator( 'table', function ( settings ) {
		if ( ! settings.oFeatures.bFilter ) {
			return;
		}

		if (typeof regex === 'object') {
			// New style options to pass to the search builder
			_fnFilterComplete( settings, $.extend( settings.oPreviousSearch, regex, {
				search: input
			} ) );
		}
		else {
			// Compat for the old options
			_fnFilterComplete( settings, $.extend( settings.oPreviousSearch, {
				search: input,
				regex:  regex === null ? false : regex,
				smart:  smart === null ? true  : smart,
				caseInsensitive: caseInsen === null ? true : caseInsen
			} ) );
		}
	} );
} );

_api_register( 'search.fixed()', function ( name, search ) {
	var ret = this.iterator( true, 'table', function ( settings ) {
		var fixed = settings.searchFixed;

		if (! name) {
			return Object.keys(fixed)
		}
		else if (search === undefined) {
			return fixed[name];
		}
		else if (search === null) {
			delete fixed[name];
		}
		else {
			fixed[name] = search;
		}

		return this;
	} );

	return name !== undefined && search === undefined
		? ret[0]
		: ret;
} );

_api_registerPlural(
	'columns().search()',
	'column().search()',
	function ( input, regex, smart, caseInsen ) {
		return this.iterator( 'column', function ( settings, column ) {
			var preSearch = settings.aoPreSearchCols;

			if ( input === undefined ) {
				// get
				return preSearch[ column ].search;
			}

			// set
			if ( ! settings.oFeatures.bFilter ) {
				return;
			}

			if (typeof regex === 'object') {
				// New style options to pass to the search builder
				$.extend( preSearch[ column ], regex, {
					search: input
				} );
			}
			else {
				// Old style (with not all options available)
				$.extend( preSearch[ column ], {
					search: input,
					regex:  regex === null ? false : regex,
					smart:  smart === null ? true  : smart,
					caseInsensitive: caseInsen === null ? true : caseInsen
				} );
			}

			_fnFilterComplete( settings, settings.oPreviousSearch );
		} );
	}
);

_api_register([
		'columns().search.fixed()',
		'column().search.fixed()'
	],
	function ( name, search ) {
		var ret = this.iterator( true, 'column', function ( settings, colIdx ) {
			var fixed = settings.aoColumns[colIdx].searchFixed;

			if (! name) {
				return Object.keys(fixed)
			}
			else if (search === undefined) {
				return fixed[name];
			}
			else if (search === null) {
				delete fixed[name];
			}
			else {
				fixed[name] = search;
			}

			return this;
		} );

		return name !== undefined && search === undefined
			? ret[0]
			: ret;
	}
);
/*
 * State API methods
 */

_api_register( 'state()', function ( set, ignoreTime ) {
	// getter
	if ( ! set ) {
		return this.context.length ?
			this.context[0].oSavedState :
			null;
	}

	var setMutate = $.extend( true, {}, set );

	// setter
	return this.iterator( 'table', function ( settings ) {
		if ( ignoreTime !== false ) {
			setMutate.time = +new Date() + 100;
		}

		_fnImplementState( settings, setMutate, function(){} );
	} );
} );


_api_register( 'state.clear()', function () {
	return this.iterator( 'table', function ( settings ) {
		// Save an empty object
		settings.fnStateSaveCallback.call( settings.oInstance, settings, {} );
	} );
} );


_api_register( 'state.loaded()', function () {
	return this.context.length ?
		this.context[0].oLoadedState :
		null;
} );


_api_register( 'state.save()', function () {
	return this.iterator( 'table', function ( settings ) {
		_fnSaveState( settings );
	} );
} );

/**
 * Set the jQuery or window object to be used by DataTables
 *
 * @param {*} module Library / container object
 * @param {string} [type] Library or container type `lib`, `win` or `datetime`.
 *   If not provided, automatic detection is attempted.
 */
DataTable.use = function (module, type) {
	if (type === 'lib' || module.fn) {
		$ = module;
	}
	else if (type == 'win' || module.document) {
		window = module;
		document = module.document;
	}
	else if (type === 'datetime' || module.type === 'DateTime') {
		DataTable.DateTime = module;
	}
}

/**
 * CommonJS factory function pass through. This will check if the arguments
 * given are a window object or a jQuery object. If so they are set
 * accordingly.
 * @param {*} root Window
 * @param {*} jq jQUery
 * @returns {boolean} Indicator
 */
DataTable.factory = function (root, jq) {
	var is = false;

	// Test if the first parameter is a window object
	if (root && root.document) {
		window = root;
		document = root.document;
	}

	// Test if the second parameter is a jQuery object
	if (jq && jq.fn && jq.fn.jquery) {
		$ = jq;
		is = true;
	}

	return is;
}

/**
 * Provide a common method for plug-ins to check the version of DataTables being
 * used, in order to ensure compatibility.
 *
 *  @param {string} version Version string to check for, in the format "X.Y.Z".
 *    Note that the formats "X" and "X.Y" are also acceptable.
 *  @param {string} [version2=current DataTables version] As above, but optional.
 *   If not given the current DataTables version will be used.
 *  @returns {boolean} true if this version of DataTables is greater or equal to
 *    the required version, or false if this version of DataTales is not
 *    suitable
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    alert( $.fn.dataTable.versionCheck( '1.9.0' ) );
 */
DataTable.versionCheck = function( version, version2 )
{
	var aThis = version2 ?
		version2.split('.') :
		DataTable.version.split('.');
	var aThat = version.split('.');
	var iThis, iThat;

	for ( var i=0, iLen=aThat.length ; i<iLen ; i++ ) {
		iThis = parseInt( aThis[i], 10 ) || 0;
		iThat = parseInt( aThat[i], 10 ) || 0;

		// Parts are the same, keep comparing
		if (iThis === iThat) {
			continue;
		}

		// Parts are different, return immediately
		return iThis > iThat;
	}

	return true;
};


/**
 * Check if a `<table>` node is a DataTable table already or not.
 *
 *  @param {node|jquery|string} table Table node, jQuery object or jQuery
 *      selector for the table to test. Note that if more than more than one
 *      table is passed on, only the first will be checked
 *  @returns {boolean} true the table given is a DataTable, or false otherwise
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    if ( ! $.fn.DataTable.isDataTable( '#example' ) ) {
 *      $('#example').dataTable();
 *    }
 */
DataTable.isDataTable = function ( table )
{
	var t = $(table).get(0);
	var is = false;

	if ( table instanceof DataTable.Api ) {
		return true;
	}

	$.each( DataTable.settings, function (i, o) {
		var head = o.nScrollHead ? $('table', o.nScrollHead)[0] : null;
		var foot = o.nScrollFoot ? $('table', o.nScrollFoot)[0] : null;

		if ( o.nTable === t || head === t || foot === t ) {
			is = true;
		}
	} );

	return is;
};


/**
 * Get all DataTable tables that have been initialised - optionally you can
 * select to get only currently visible tables.
 *
 *  @param {boolean} [visible=false] Flag to indicate if you want all (default)
 *    or visible tables only.
 *  @returns {array} Array of `table` nodes (not DataTable instances) which are
 *    DataTables
 *  @static
 *  @dtopt API-Static
 *
 *  @example
 *    $.each( $.fn.dataTable.tables(true), function () {
 *      $(table).DataTable().columns.adjust();
 *    } );
 */
DataTable.tables = function ( visible )
{
	var api = false;

	if ( $.isPlainObject( visible ) ) {
		api = visible.api;
		visible = visible.visible;
	}

	var a = DataTable.settings
		.filter( function (o) {
			return !visible || (visible && $(o.nTable).is(':visible')) 
				? true
				: false;
		} )
		.map( function (o) {
			return o.nTable;
		});

	return api ?
		new _Api( a ) :
		a;
};


/**
 * Convert from camel case parameters to Hungarian notation. This is made public
 * for the extensions to provide the same ability as DataTables core to accept
 * either the 1.9 style Hungarian notation, or the 1.10+ style camelCase
 * parameters.
 *
 *  @param {object} src The model object which holds all parameters that can be
 *    mapped.
 *  @param {object} user The object to convert from camel case to Hungarian.
 *  @param {boolean} force When set to `true`, properties which already have a
 *    Hungarian value in the `user` object will be overwritten. Otherwise they
 *    won't be.
 */
DataTable.camelToHungarian = _fnCamelToHungarian;



/**
 *
 */
_api_register( '$()', function ( selector, opts ) {
	var
		rows   = this.rows( opts ).nodes(), // Get all rows
		jqRows = $(rows);

	return $( [].concat(
		jqRows.filter( selector ).toArray(),
		jqRows.find( selector ).toArray()
	) );
} );


// jQuery functions to operate on the tables
$.each( [ 'on', 'one', 'off' ], function (i, key) {
	_api_register( key+'()', function ( /* event, handler */ ) {
		var args = Array.prototype.slice.call(arguments);

		// Add the `dt` namespace automatically if it isn't already present
		args[0] = args[0].split( /\s/ ).map( function ( e ) {
			return ! e.match(/\.dt\b/) ?
				e+'.dt' :
				e;
			} ).join( ' ' );

		var inst = $( this.tables().nodes() );
		inst[key].apply( inst, args );
		return this;
	} );
} );


_api_register( 'clear()', function () {
	return this.iterator( 'table', function ( settings ) {
		_fnClearTable( settings );
	} );
} );


_api_register( 'error()', function (msg) {
	return this.iterator( 'table', function ( settings ) {
		_fnLog( settings, 0, msg );
	} );
} );


_api_register( 'settings()', function () {
	return new _Api( this.context, this.context );
} );


_api_register( 'init()', function () {
	var ctx = this.context;
	return ctx.length ? ctx[0].oInit : null;
} );


_api_register( 'data()', function () {
	return this.iterator( 'table', function ( settings ) {
		return _pluck( settings.aoData, '_aData' );
	} ).flatten();
} );


_api_register( 'trigger()', function ( name, args, bubbles ) {
	return this.iterator( 'table', function ( settings ) {
		return _fnCallbackFire( settings, null, name, args, bubbles );
	} ).flatten();
} );


_api_register( 'ready()', function ( fn ) {
	var ctx = this.context;

	// Get status of first table
	if (! fn) {
		return ctx.length
			? (ctx[0]._bInitComplete || false)
			: null;
	}

	// Function to run either once the table becomes ready or
	// immediately if it is already ready.
	return this.tables().every(function () {
		if (this.context[0]._bInitComplete) {
			fn.call(this);
		}
		else {
			this.on('init', function () {
				fn.call(this);
			});
		}
	} );
} );


_api_register( 'destroy()', function ( remove ) {
	remove = remove || false;

	return this.iterator( 'table', function ( settings ) {
		var classes   = settings.oClasses;
		var table     = settings.nTable;
		var tbody     = settings.nTBody;
		var thead     = settings.nTHead;
		var tfoot     = settings.nTFoot;
		var jqTable   = $(table);
		var jqTbody   = $(tbody);
		var jqWrapper = $(settings.nTableWrapper);
		var rows      = settings.aoData.map( function (r) { return r ? r.nTr : null; } );
		var orderClasses = classes.order;

		// Flag to note that the table is currently being destroyed - no action
		// should be taken
		settings.bDestroying = true;

		// Fire off the destroy callbacks for plug-ins etc
		_fnCallbackFire( settings, "aoDestroyCallback", "destroy", [settings], true );

		// If not being removed from the document, make all columns visible
		if ( ! remove ) {
			new _Api( settings ).columns().visible( true );
		}

		// Blitz all `DT` namespaced events (these are internal events, the
		// lowercase, `dt` events are user subscribed and they are responsible
		// for removing them
		jqWrapper.off('.DT').find(':not(tbody *)').off('.DT');
		$(window).off('.DT-'+settings.sInstance);

		// When scrolling we had to break the table up - restore it
		if ( table != thead.parentNode ) {
			jqTable.children('thead').detach();
			jqTable.append( thead );
		}

		if ( tfoot && table != tfoot.parentNode ) {
			jqTable.children('tfoot').detach();
			jqTable.append( tfoot );
		}

		settings.colgroup.remove();

		settings.aaSorting = [];
		settings.aaSortingFixed = [];
		_fnSortingClasses( settings );

		$('th, td', thead)
			.removeClass(
				orderClasses.canAsc + ' ' +
				orderClasses.canDesc + ' ' +
				orderClasses.isAsc + ' ' +
				orderClasses.isDesc
			)
			.css('width', '');

		// Add the TR elements back into the table in their original order
		jqTbody.children().detach();
		jqTbody.append( rows );

		var orig = settings.nTableWrapper.parentNode;
		var insertBefore = settings.nTableWrapper.nextSibling;

		// Remove the DataTables generated nodes, events and classes
		var removedMethod = remove ? 'remove' : 'detach';
		jqTable[ removedMethod ]();
		jqWrapper[ removedMethod ]();

		// If we need to reattach the table to the document
		if ( ! remove && orig ) {
			// insertBefore acts like appendChild if !arg[1]
			orig.insertBefore( table, insertBefore );

			// Restore the width of the original table - was read from the style property,
			// so we can restore directly to that
			jqTable
				.css( 'width', settings.sDestroyWidth )
				.removeClass( classes.table );
		}

		/* Remove the settings object from the settings array */
		var idx = DataTable.settings.indexOf(settings);
		if ( idx !== -1 ) {
			DataTable.settings.splice( idx, 1 );
		}
	} );
} );


// Add the `every()` method for rows, columns and cells in a compact form
$.each( [ 'column', 'row', 'cell' ], function ( i, type ) {
	_api_register( type+'s().every()', function ( fn ) {
		var opts = this.selector.opts;
		var api = this;
		var inst;
		var counter = 0;

		return this.iterator( 'every', function ( settings, selectedIdx, tableIdx ) {
			inst = api[ type ](selectedIdx, opts);

			if (type === 'cell') {
				fn.call(inst, inst[0][0].row, inst[0][0].column, tableIdx, counter);
			}
			else {
				fn.call(inst, selectedIdx, tableIdx, counter);
			}

			counter++;
		} );
	} );
} );


// i18n method for extensions to be able to use the language object from the
// DataTable
_api_register( 'i18n()', function ( token, def, plural ) {
	var ctx = this.context[0];
	var resolved = _fnGetObjectDataFn( token )( ctx.oLanguage );

	if ( resolved === undefined ) {
		resolved = def;
	}

	if ( $.isPlainObject( resolved ) ) {
		resolved = plural !== undefined && resolved[ plural ] !== undefined ?
			resolved[ plural ] :
			resolved._;
	}

	return typeof resolved === 'string'
		? resolved.replace( '%d', plural ) // nb: plural might be undefined,
		: resolved;
} );

/**
 * Version string for plug-ins to check compatibility. Allowed format is
 * `a.b.c-d` where: a:int, b:int, c:int, d:string(dev|beta|alpha). `d` is used
 * only for non-release builds. See https://semver.org/ for more information.
 *  @member
 *  @type string
 *  @default Version number
 */
DataTable.version = "2.0.3";

/**
 * Private data store, containing all of the settings objects that are
 * created for the tables on a given page.
 *
 * Note that the `DataTable.settings` object is aliased to
 * `jQuery.fn.dataTableExt` through which it may be accessed and
 * manipulated, or `jQuery.fn.dataTable.settings`.
 *  @member
 *  @type array
 *  @default []
 *  @private
 */
DataTable.settings = [];

/**
 * Object models container, for the various models that DataTables has
 * available to it. These models define the objects that are used to hold
 * the active state and configuration of the table.
 *  @namespace
 */
DataTable.models = {};



/**
 * Template object for the way in which DataTables holds information about
 * search information for the global filter and individual column filters.
 *  @namespace
 */
DataTable.models.oSearch = {
	/**
	 * Flag to indicate if the filtering should be case insensitive or not
	 */
	"caseInsensitive": true,

	/**
	 * Applied search term
	 */
	"search": "",

	/**
	 * Flag to indicate if the search term should be interpreted as a
	 * regular expression (true) or not (false) and therefore and special
	 * regex characters escaped.
	 */
	"regex": false,

	/**
	 * Flag to indicate if DataTables is to use its smart filtering or not.
	 */
	"smart": true,

	/**
	 * Flag to indicate if DataTables should only trigger a search when
	 * the return key is pressed.
	 */
	"return": false
};




/**
 * Template object for the way in which DataTables holds information about
 * each individual row. This is the object format used for the settings
 * aoData array.
 *  @namespace
 */
DataTable.models.oRow = {
	/**
	 * TR element for the row
	 */
	"nTr": null,

	/**
	 * Array of TD elements for each row. This is null until the row has been
	 * created.
	 */
	"anCells": null,

	/**
	 * Data object from the original data source for the row. This is either
	 * an array if using the traditional form of DataTables, or an object if
	 * using mData options. The exact type will depend on the passed in
	 * data from the data source, or will be an array if using DOM a data
	 * source.
	 */
	"_aData": [],

	/**
	 * Sorting data cache - this array is ostensibly the same length as the
	 * number of columns (although each index is generated only as it is
	 * needed), and holds the data that is used for sorting each column in the
	 * row. We do this cache generation at the start of the sort in order that
	 * the formatting of the sort data need be done only once for each cell
	 * per sort. This array should not be read from or written to by anything
	 * other than the master sorting methods.
	 */
	"_aSortData": null,

	/**
	 * Per cell filtering data cache. As per the sort data cache, used to
	 * increase the performance of the filtering in DataTables
	 */
	"_aFilterData": null,

	/**
	 * Filtering data cache. This is the same as the cell filtering cache, but
	 * in this case a string rather than an array. This is easily computed with
	 * a join on `_aFilterData`, but is provided as a cache so the join isn't
	 * needed on every search (memory traded for performance)
	 */
	"_sFilterRow": null,

	/**
	 * Denote if the original data source was from the DOM, or the data source
	 * object. This is used for invalidating data, so DataTables can
	 * automatically read data from the original source, unless uninstructed
	 * otherwise.
	 */
	"src": null,

	/**
	 * Index in the aoData array. This saves an indexOf lookup when we have the
	 * object, but want to know the index
	 */
	"idx": -1,

	/**
	 * Cached display value
	 */
	displayData: null
};


/**
 * Template object for the column information object in DataTables. This object
 * is held in the settings aoColumns array and contains all the information that
 * DataTables needs about each individual column.
 *
 * Note that this object is related to {@link DataTable.defaults.column}
 * but this one is the internal data store for DataTables's cache of columns.
 * It should NOT be manipulated outside of DataTables. Any configuration should
 * be done through the initialisation options.
 *  @namespace
 */
DataTable.models.oColumn = {
	/**
	 * Column index.
	 */
	"idx": null,

	/**
	 * A list of the columns that sorting should occur on when this column
	 * is sorted. That this property is an array allows multi-column sorting
	 * to be defined for a column (for example first name / last name columns
	 * would benefit from this). The values are integers pointing to the
	 * columns to be sorted on (typically it will be a single integer pointing
	 * at itself, but that doesn't need to be the case).
	 */
	"aDataSort": null,

	/**
	 * Define the sorting directions that are applied to the column, in sequence
	 * as the column is repeatedly sorted upon - i.e. the first value is used
	 * as the sorting direction when the column if first sorted (clicked on).
	 * Sort it again (click again) and it will move on to the next index.
	 * Repeat until loop.
	 */
	"asSorting": null,

	/**
	 * Flag to indicate if the column is searchable, and thus should be included
	 * in the filtering or not.
	 */
	"bSearchable": null,

	/**
	 * Flag to indicate if the column is sortable or not.
	 */
	"bSortable": null,

	/**
	 * Flag to indicate if the column is currently visible in the table or not
	 */
	"bVisible": null,

	/**
	 * Store for manual type assignment using the `column.type` option. This
	 * is held in store so we can manipulate the column's `sType` property.
	 */
	"_sManualType": null,

	/**
	 * Flag to indicate if HTML5 data attributes should be used as the data
	 * source for filtering or sorting. True is either are.
	 */
	"_bAttrSrc": false,

	/**
	 * Developer definable function that is called whenever a cell is created (Ajax source,
	 * etc) or processed for input (DOM source). This can be used as a compliment to mRender
	 * allowing you to modify the DOM element (add background colour for example) when the
	 * element is available.
	 */
	"fnCreatedCell": null,

	/**
	 * Function to get data from a cell in a column. You should <b>never</b>
	 * access data directly through _aData internally in DataTables - always use
	 * the method attached to this property. It allows mData to function as
	 * required. This function is automatically assigned by the column
	 * initialisation method
	 */
	"fnGetData": null,

	/**
	 * Function to set data for a cell in the column. You should <b>never</b>
	 * set the data directly to _aData internally in DataTables - always use
	 * this method. It allows mData to function as required. This function
	 * is automatically assigned by the column initialisation method
	 */
	"fnSetData": null,

	/**
	 * Property to read the value for the cells in the column from the data
	 * source array / object. If null, then the default content is used, if a
	 * function is given then the return from the function is used.
	 */
	"mData": null,

	/**
	 * Partner property to mData which is used (only when defined) to get
	 * the data - i.e. it is basically the same as mData, but without the
	 * 'set' option, and also the data fed to it is the result from mData.
	 * This is the rendering method to match the data method of mData.
	 */
	"mRender": null,

	/**
	 * The class to apply to all TD elements in the table's TBODY for the column
	 */
	"sClass": null,

	/**
	 * When DataTables calculates the column widths to assign to each column,
	 * it finds the longest string in each column and then constructs a
	 * temporary table and reads the widths from that. The problem with this
	 * is that "mmm" is much wider then "iiii", but the latter is a longer
	 * string - thus the calculation can go wrong (doing it properly and putting
	 * it into an DOM object and measuring that is horribly(!) slow). Thus as
	 * a "work around" we provide this option. It will append its value to the
	 * text that is found to be the longest string for the column - i.e. padding.
	 */
	"sContentPadding": null,

	/**
	 * Allows a default value to be given for a column's data, and will be used
	 * whenever a null data source is encountered (this can be because mData
	 * is set to null, or because the data source itself is null).
	 */
	"sDefaultContent": null,

	/**
	 * Name for the column, allowing reference to the column by name as well as
	 * by index (needs a lookup to work by name).
	 */
	"sName": null,

	/**
	 * Custom sorting data type - defines which of the available plug-ins in
	 * afnSortData the custom sorting will use - if any is defined.
	 */
	"sSortDataType": 'std',

	/**
	 * Class to be applied to the header element when sorting on this column
	 */
	"sSortingClass": null,

	/**
	 * Title of the column - what is seen in the TH element (nTh).
	 */
	"sTitle": null,

	/**
	 * Column sorting and filtering type
	 */
	"sType": null,

	/**
	 * Width of the column
	 */
	"sWidth": null,

	/**
	 * Width of the column when it was first "encountered"
	 */
	"sWidthOrig": null,

	/** Cached string which is the longest in the column */
	maxLenString: null,

	/**
	 * Store for named searches
	 */
	searchFixed: null
};


/*
 * Developer note: The properties of the object below are given in Hungarian
 * notation, that was used as the interface for DataTables prior to v1.10, however
 * from v1.10 onwards the primary interface is camel case. In order to avoid
 * breaking backwards compatibility utterly with this change, the Hungarian
 * version is still, internally the primary interface, but is is not documented
 * - hence the @name tags in each doc comment. This allows a Javascript function
 * to create a map from Hungarian notation to camel case (going the other direction
 * would require each property to be listed, which would add around 3K to the size
 * of DataTables, while this method is about a 0.5K hit).
 *
 * Ultimately this does pave the way for Hungarian notation to be dropped
 * completely, but that is a massive amount of work and will break current
 * installs (therefore is on-hold until v2).
 */

/**
 * Initialisation options that can be given to DataTables at initialisation
 * time.
 *  @namespace
 */
DataTable.defaults = {
	/**
	 * An array of data to use for the table, passed in at initialisation which
	 * will be used in preference to any data which is already in the DOM. This is
	 * particularly useful for constructing tables purely in Javascript, for
	 * example with a custom Ajax call.
	 */
	"aaData": null,


	/**
	 * If ordering is enabled, then DataTables will perform a first pass sort on
	 * initialisation. You can define which column(s) the sort is performed
	 * upon, and the sorting direction, with this variable. The `sorting` array
	 * should contain an array for each column to be sorted initially containing
	 * the column's index and a direction string ('asc' or 'desc').
	 */
	"aaSorting": [[0,'asc']],


	/**
	 * This parameter is basically identical to the `sorting` parameter, but
	 * cannot be overridden by user interaction with the table. What this means
	 * is that you could have a column (visible or hidden) which the sorting
	 * will always be forced on first - any sorting after that (from the user)
	 * will then be performed as required. This can be useful for grouping rows
	 * together.
	 */
	"aaSortingFixed": [],


	/**
	 * DataTables can be instructed to load data to display in the table from a
	 * Ajax source. This option defines how that Ajax call is made and where to.
	 *
	 * The `ajax` property has three different modes of operation, depending on
	 * how it is defined. These are:
	 *
	 * * `string` - Set the URL from where the data should be loaded from.
	 * * `object` - Define properties for `jQuery.ajax`.
	 * * `function` - Custom data get function
	 *
	 * `string`
	 * --------
	 *
	 * As a string, the `ajax` property simply defines the URL from which
	 * DataTables will load data.
	 *
	 * `object`
	 * --------
	 *
	 * As an object, the parameters in the object are passed to
	 * [jQuery.ajax](https://api.jquery.com/jQuery.ajax/) allowing fine control
	 * of the Ajax request. DataTables has a number of default parameters which
	 * you can override using this option. Please refer to the jQuery
	 * documentation for a full description of the options available, although
	 * the following parameters provide additional options in DataTables or
	 * require special consideration:
	 *
	 * * `data` - As with jQuery, `data` can be provided as an object, but it
	 *   can also be used as a function to manipulate the data DataTables sends
	 *   to the server. The function takes a single parameter, an object of
	 *   parameters with the values that DataTables has readied for sending. An
	 *   object may be returned which will be merged into the DataTables
	 *   defaults, or you can add the items to the object that was passed in and
	 *   not return anything from the function. This supersedes `fnServerParams`
	 *   from DataTables 1.9-.
	 *
	 * * `dataSrc` - By default DataTables will look for the property `data` (or
	 *   `aaData` for compatibility with DataTables 1.9-) when obtaining data
	 *   from an Ajax source or for server-side processing - this parameter
	 *   allows that property to be changed. You can use Javascript dotted
	 *   object notation to get a data source for multiple levels of nesting, or
	 *   it my be used as a function. As a function it takes a single parameter,
	 *   the JSON returned from the server, which can be manipulated as
	 *   required, with the returned value being that used by DataTables as the
	 *   data source for the table.
	 *
	 * * `success` - Should not be overridden it is used internally in
	 *   DataTables. To manipulate / transform the data returned by the server
	 *   use `ajax.dataSrc`, or use `ajax` as a function (see below).
	 *
	 * `function`
	 * ----------
	 *
	 * As a function, making the Ajax call is left up to yourself allowing
	 * complete control of the Ajax request. Indeed, if desired, a method other
	 * than Ajax could be used to obtain the required data, such as Web storage
	 * or an AIR database.
	 *
	 * The function is given four parameters and no return is required. The
	 * parameters are:
	 *
	 * 1. _object_ - Data to send to the server
	 * 2. _function_ - Callback function that must be executed when the required
	 *    data has been obtained. That data should be passed into the callback
	 *    as the only parameter
	 * 3. _object_ - DataTables settings object for the table
	 */
	"ajax": null,


	/**
	 * This parameter allows you to readily specify the entries in the length drop
	 * down menu that DataTables shows when pagination is enabled. It can be
	 * either a 1D array of options which will be used for both the displayed
	 * option and the value, or a 2D array which will use the array in the first
	 * position as the value, and the array in the second position as the
	 * displayed options (useful for language strings such as 'All').
	 *
	 * Note that the `pageLength` property will be automatically set to the
	 * first value given in this array, unless `pageLength` is also provided.
	 */
	"aLengthMenu": [ 10, 25, 50, 100 ],


	/**
	 * The `columns` option in the initialisation parameter allows you to define
	 * details about the way individual columns behave. For a full list of
	 * column options that can be set, please see
	 * {@link DataTable.defaults.column}. Note that if you use `columns` to
	 * define your columns, you must have an entry in the array for every single
	 * column that you have in your table (these can be null if you don't which
	 * to specify any options).
	 */
	"aoColumns": null,

	/**
	 * Very similar to `columns`, `columnDefs` allows you to target a specific
	 * column, multiple columns, or all columns, using the `targets` property of
	 * each object in the array. This allows great flexibility when creating
	 * tables, as the `columnDefs` arrays can be of any length, targeting the
	 * columns you specifically want. `columnDefs` may use any of the column
	 * options available: {@link DataTable.defaults.column}, but it _must_
	 * have `targets` defined in each object in the array. Values in the `targets`
	 * array may be:
	 *   <ul>
	 *     <li>a string - class name will be matched on the TH for the column</li>
	 *     <li>0 or a positive integer - column index counting from the left</li>
	 *     <li>a negative integer - column index counting from the right</li>
	 *     <li>the string "_all" - all columns (i.e. assign a default)</li>
	 *   </ul>
	 */
	"aoColumnDefs": null,


	/**
	 * Basically the same as `search`, this parameter defines the individual column
	 * filtering state at initialisation time. The array must be of the same size
	 * as the number of columns, and each element be an object with the parameters
	 * `search` and `escapeRegex` (the latter is optional). 'null' is also
	 * accepted and the default will be used.
	 */
	"aoSearchCols": [],


	/**
	 * Enable or disable automatic column width calculation. This can be disabled
	 * as an optimisation (it takes some time to calculate the widths) if the
	 * tables widths are passed in using `columns`.
	 */
	"bAutoWidth": true,


	/**
	 * Deferred rendering can provide DataTables with a huge speed boost when you
	 * are using an Ajax or JS data source for the table. This option, when set to
	 * true, will cause DataTables to defer the creation of the table elements for
	 * each row until they are needed for a draw - saving a significant amount of
	 * time.
	 */
	"bDeferRender": true,


	/**
	 * Replace a DataTable which matches the given selector and replace it with
	 * one which has the properties of the new initialisation object passed. If no
	 * table matches the selector, then the new DataTable will be constructed as
	 * per normal.
	 */
	"bDestroy": false,


	/**
	 * Enable or disable filtering of data. Filtering in DataTables is "smart" in
	 * that it allows the end user to input multiple words (space separated) and
	 * will match a row containing those words, even if not in the order that was
	 * specified (this allow matching across multiple columns). Note that if you
	 * wish to use filtering in DataTables this must remain 'true' - to remove the
	 * default filtering input box and retain filtering abilities, please use
	 * {@link DataTable.defaults.dom}.
	 */
	"bFilter": true,

	/**
	 * Used only for compatiblity with DT1
	 * @deprecated
	 */
	"bInfo": true,

	/**
	 * Used only for compatiblity with DT1
	 * @deprecated
	 */
	"bLengthChange": true,

	/**
	 * Enable or disable pagination.
	 */
	"bPaginate": true,


	/**
	 * Enable or disable the display of a 'processing' indicator when the table is
	 * being processed (e.g. a sort). This is particularly useful for tables with
	 * large amounts of data where it can take a noticeable amount of time to sort
	 * the entries.
	 */
	"bProcessing": false,


	/**
	 * Retrieve the DataTables object for the given selector. Note that if the
	 * table has already been initialised, this parameter will cause DataTables
	 * to simply return the object that has already been set up - it will not take
	 * account of any changes you might have made to the initialisation object
	 * passed to DataTables (setting this parameter to true is an acknowledgement
	 * that you understand this). `destroy` can be used to reinitialise a table if
	 * you need.
	 */
	"bRetrieve": false,


	/**
	 * When vertical (y) scrolling is enabled, DataTables will force the height of
	 * the table's viewport to the given height at all times (useful for layout).
	 * However, this can look odd when filtering data down to a small data set,
	 * and the footer is left "floating" further down. This parameter (when
	 * enabled) will cause DataTables to collapse the table's viewport down when
	 * the result set will fit within the given Y height.
	 */
	"bScrollCollapse": false,


	/**
	 * Configure DataTables to use server-side processing. Note that the
	 * `ajax` parameter must also be given in order to give DataTables a
	 * source to obtain the required data for each draw.
	 */
	"bServerSide": false,


	/**
	 * Enable or disable sorting of columns. Sorting of individual columns can be
	 * disabled by the `sortable` option for each column.
	 */
	"bSort": true,


	/**
	 * Enable or display DataTables' ability to sort multiple columns at the
	 * same time (activated by shift-click by the user).
	 */
	"bSortMulti": true,


	/**
	 * Allows control over whether DataTables should use the top (true) unique
	 * cell that is found for a single column, or the bottom (false - default).
	 * This is useful when using complex headers.
	 */
	"bSortCellsTop": null,


	/**
	 * Enable or disable the addition of the classes `sorting\_1`, `sorting\_2` and
	 * `sorting\_3` to the columns which are currently being sorted on. This is
	 * presented as a feature switch as it can increase processing time (while
	 * classes are removed and added) so for large data sets you might want to
	 * turn this off.
	 */
	"bSortClasses": true,


	/**
	 * Enable or disable state saving. When enabled HTML5 `localStorage` will be
	 * used to save table display information such as pagination information,
	 * display length, filtering and sorting. As such when the end user reloads
	 * the page the display display will match what thy had previously set up.
	 */
	"bStateSave": false,


	/**
	 * This function is called when a TR element is created (and all TD child
	 * elements have been inserted), or registered if using a DOM source, allowing
	 * manipulation of the TR element (adding classes etc).
	 */
	"fnCreatedRow": null,


	/**
	 * This function is called on every 'draw' event, and allows you to
	 * dynamically modify any aspect you want about the created DOM.
	 */
	"fnDrawCallback": null,


	/**
	 * Identical to fnHeaderCallback() but for the table footer this function
	 * allows you to modify the table footer on every 'draw' event.
	 */
	"fnFooterCallback": null,


	/**
	 * When rendering large numbers in the information element for the table
	 * (i.e. "Showing 1 to 10 of 57 entries") DataTables will render large numbers
	 * to have a comma separator for the 'thousands' units (e.g. 1 million is
	 * rendered as "1,000,000") to help readability for the end user. This
	 * function will override the default method DataTables uses.
	 */
	"fnFormatNumber": function ( toFormat ) {
		return toFormat.toString().replace(
			/\B(?=(\d{3})+(?!\d))/g,
			this.oLanguage.sThousands
		);
	},


	/**
	 * This function is called on every 'draw' event, and allows you to
	 * dynamically modify the header row. This can be used to calculate and
	 * display useful information about the table.
	 */
	"fnHeaderCallback": null,


	/**
	 * The information element can be used to convey information about the current
	 * state of the table. Although the internationalisation options presented by
	 * DataTables are quite capable of dealing with most customisations, there may
	 * be times where you wish to customise the string further. This callback
	 * allows you to do exactly that.
	 */
	"fnInfoCallback": null,


	/**
	 * Called when the table has been initialised. Normally DataTables will
	 * initialise sequentially and there will be no need for this function,
	 * however, this does not hold true when using external language information
	 * since that is obtained using an async XHR call.
	 */
	"fnInitComplete": null,


	/**
	 * Called at the very start of each table draw and can be used to cancel the
	 * draw by returning false, any other return (including undefined) results in
	 * the full draw occurring).
	 */
	"fnPreDrawCallback": null,


	/**
	 * This function allows you to 'post process' each row after it have been
	 * generated for each table draw, but before it is rendered on screen. This
	 * function might be used for setting the row class name etc.
	 */
	"fnRowCallback": null,


	/**
	 * Load the table state. With this function you can define from where, and how, the
	 * state of a table is loaded. By default DataTables will load from `localStorage`
	 * but you might wish to use a server-side database or cookies.
	 */
	"fnStateLoadCallback": function ( settings ) {
		try {
			return JSON.parse(
				(settings.iStateDuration === -1 ? sessionStorage : localStorage).getItem(
					'DataTables_'+settings.sInstance+'_'+location.pathname
				)
			);
		} catch (e) {
			return {};
		}
	},


	/**
	 * Callback which allows modification of the saved state prior to loading that state.
	 * This callback is called when the table is loading state from the stored data, but
	 * prior to the settings object being modified by the saved state. Note that for
	 * plug-in authors, you should use the `stateLoadParams` event to load parameters for
	 * a plug-in.
	 */
	"fnStateLoadParams": null,


	/**
	 * Callback that is called when the state has been loaded from the state saving method
	 * and the DataTables settings object has been modified as a result of the loaded state.
	 */
	"fnStateLoaded": null,


	/**
	 * Save the table state. This function allows you to define where and how the state
	 * information for the table is stored By default DataTables will use `localStorage`
	 * but you might wish to use a server-side database or cookies.
	 */
	"fnStateSaveCallback": function ( settings, data ) {
		try {
			(settings.iStateDuration === -1 ? sessionStorage : localStorage).setItem(
				'DataTables_'+settings.sInstance+'_'+location.pathname,
				JSON.stringify( data )
			);
		} catch (e) {
			// noop
		}
	},


	/**
	 * Callback which allows modification of the state to be saved. Called when the table
	 * has changed state a new state save is required. This method allows modification of
	 * the state saving object prior to actually doing the save, including addition or
	 * other state properties or modification. Note that for plug-in authors, you should
	 * use the `stateSaveParams` event to save parameters for a plug-in.
	 */
	"fnStateSaveParams": null,


	/**
	 * Duration for which the saved state information is considered valid. After this period
	 * has elapsed the state will be returned to the default.
	 * Value is given in seconds.
	 */
	"iStateDuration": 7200,


	/**
	 * Number of rows to display on a single page when using pagination. If
	 * feature enabled (`lengthChange`) then the end user will be able to override
	 * this to a custom setting using a pop-up menu.
	 */
	"iDisplayLength": 10,


	/**
	 * Define the starting point for data display when using DataTables with
	 * pagination. Note that this parameter is the number of records, rather than
	 * the page number, so if you have 10 records per page and want to start on
	 * the third page, it should be "20".
	 */
	"iDisplayStart": 0,


	/**
	 * By default DataTables allows keyboard navigation of the table (sorting, paging,
	 * and filtering) by adding a `tabindex` attribute to the required elements. This
	 * allows you to tab through the controls and press the enter key to activate them.
	 * The tabindex is default 0, meaning that the tab follows the flow of the document.
	 * You can overrule this using this parameter if you wish. Use a value of -1 to
	 * disable built-in keyboard navigation.
	 */
	"iTabIndex": 0,


	/**
	 * Classes that DataTables assigns to the various components and features
	 * that it adds to the HTML table. This allows classes to be configured
	 * during initialisation in addition to through the static
	 * {@link DataTable.ext.oStdClasses} object).
	 */
	"oClasses": {},


	/**
	 * All strings that DataTables uses in the user interface that it creates
	 * are defined in this object, allowing you to modified them individually or
	 * completely replace them all as required.
	 */
	"oLanguage": {
		/**
		 * Strings that are used for WAI-ARIA labels and controls only (these are not
		 * actually visible on the page, but will be read by screenreaders, and thus
		 * must be internationalised as well).
		 */
		"oAria": {
			/**
			 * ARIA label that is added to the table headers when the column may be sorted
			 */
			"orderable": ": Activate to sort",

			/**
			 * ARIA label that is added to the table headers when the column is currently being sorted
			 */
			"orderableReverse": ": Activate to invert sorting",

			/**
			 * ARIA label that is added to the table headers when the column is currently being 
			 * sorted and next step is to remove sorting
			 */
			"orderableRemove": ": Activate to remove sorting",

			paginate: {
				first: 'First',
				last: 'Last',
				next: 'Next',
				previous: 'Previous'
			}
		},

		/**
		 * Pagination string used by DataTables for the built-in pagination
		 * control types.
		 */
		"oPaginate": {
			/**
			 * Label and character for first page button
			 */
			"sFirst": "«",

			/**
			 * Last page button
			 */
			"sLast": "»",

			/**
			 * Next page button
			 */
			"sNext": "›",

			/**
			 * Previous page button
			 */
			"sPrevious": "‹",
		},

		/**
		 * Plural object for the data type the table is showing
		 */
		entries: {
			_: "entries",
			1: "entry"
		},

		/**
		 * This string is shown in preference to `zeroRecords` when the table is
		 * empty of data (regardless of filtering). Note that this is an optional
		 * parameter - if it is not given, the value of `zeroRecords` will be used
		 * instead (either the default or given value).
		 */
		"sEmptyTable": "No data available in table",


		/**
		 * This string gives information to the end user about the information
		 * that is current on display on the page. The following tokens can be
		 * used in the string and will be dynamically replaced as the table
		 * display updates. This tokens can be placed anywhere in the string, or
		 * removed as needed by the language requires:
		 *
		 * * `\_START\_` - Display index of the first record on the current page
		 * * `\_END\_` - Display index of the last record on the current page
		 * * `\_TOTAL\_` - Number of records in the table after filtering
		 * * `\_MAX\_` - Number of records in the table without filtering
		 * * `\_PAGE\_` - Current page number
		 * * `\_PAGES\_` - Total number of pages of data in the table
		 */
		"sInfo": "Showing _START_ to _END_ of _TOTAL_ _ENTRIES-TOTAL_",


		/**
		 * Display information string for when the table is empty. Typically the
		 * format of this string should match `info`.
		 */
		"sInfoEmpty": "Showing 0 to 0 of 0 _ENTRIES-TOTAL_",


		/**
		 * When a user filters the information in a table, this string is appended
		 * to the information (`info`) to give an idea of how strong the filtering
		 * is. The variable _MAX_ is dynamically updated.
		 */
		"sInfoFiltered": "(filtered from _MAX_ total _ENTRIES-MAX_)",


		/**
		 * If can be useful to append extra information to the info string at times,
		 * and this variable does exactly that. This information will be appended to
		 * the `info` (`infoEmpty` and `infoFiltered` in whatever combination they are
		 * being used) at all times.
		 */
		"sInfoPostFix": "",


		/**
		 * This decimal place operator is a little different from the other
		 * language options since DataTables doesn't output floating point
		 * numbers, so it won't ever use this for display of a number. Rather,
		 * what this parameter does is modify the sort methods of the table so
		 * that numbers which are in a format which has a character other than
		 * a period (`.`) as a decimal place will be sorted numerically.
		 *
		 * Note that numbers with different decimal places cannot be shown in
		 * the same table and still be sortable, the table must be consistent.
		 * However, multiple different tables on the page can use different
		 * decimal place characters.
		 */
		"sDecimal": "",


		/**
		 * DataTables has a build in number formatter (`formatNumber`) which is
		 * used to format large numbers that are used in the table information.
		 * By default a comma is used, but this can be trivially changed to any
		 * character you wish with this parameter.
		 */
		"sThousands": ",",


		/**
		 * Detail the action that will be taken when the drop down menu for the
		 * pagination length option is changed. The '_MENU_' variable is replaced
		 * with a default select list of 10, 25, 50 and 100, and can be replaced
		 * with a custom select box if required.
		 */
		"sLengthMenu": "_MENU_ _ENTRIES_ per page",


		/**
		 * When using Ajax sourced data and during the first draw when DataTables is
		 * gathering the data, this message is shown in an empty row in the table to
		 * indicate to the end user the the data is being loaded. Note that this
		 * parameter is not used when loading data by server-side processing, just
		 * Ajax sourced data with client-side processing.
		 */
		"sLoadingRecords": "Loading...",


		/**
		 * Text which is displayed when the table is processing a user action
		 * (usually a sort command or similar).
		 */
		"sProcessing": "",


		/**
		 * Details the actions that will be taken when the user types into the
		 * filtering input text box. The variable "_INPUT_", if used in the string,
		 * is replaced with the HTML text box for the filtering input allowing
		 * control over where it appears in the string. If "_INPUT_" is not given
		 * then the input box is appended to the string automatically.
		 */
		"sSearch": "Search:",


		/**
		 * Assign a `placeholder` attribute to the search `input` element
		 *  @type string
		 *  @default 
		 *
		 *  @dtopt Language
		 *  @name DataTable.defaults.language.searchPlaceholder
		 */
		"sSearchPlaceholder": "",


		/**
		 * All of the language information can be stored in a file on the
		 * server-side, which DataTables will look up if this parameter is passed.
		 * It must store the URL of the language file, which is in a JSON format,
		 * and the object has the same properties as the oLanguage object in the
		 * initialiser object (i.e. the above parameters). Please refer to one of
		 * the example language files to see how this works in action.
		 */
		"sUrl": "",


		/**
		 * Text shown inside the table records when the is no information to be
		 * displayed after filtering. `emptyTable` is shown when there is simply no
		 * information in the table at all (regardless of filtering).
		 */
		"sZeroRecords": "No matching records found"
	},


	/**
	 * This parameter allows you to have define the global filtering state at
	 * initialisation time. As an object the `search` parameter must be
	 * defined, but all other parameters are optional. When `regex` is true,
	 * the search string will be treated as a regular expression, when false
	 * (default) it will be treated as a straight string. When `smart`
	 * DataTables will use it's smart filtering methods (to word match at
	 * any point in the data), when false this will not be done.
	 */
	"oSearch": $.extend( {}, DataTable.models.oSearch ),


	/**
	 * Table and control layout. This replaces the legacy `dom` option.
	 */
	layout: {
		topStart: 'pageLength',
		topEnd: 'search',
		bottomStart: 'info',
		bottomEnd: 'paging'
	},


	/**
	 * Legacy DOM layout option
	 */
	"sDom": null,


	/**
	 * Search delay option. This will throttle full table searches that use the
	 * DataTables provided search input element (it does not effect calls to
	 * `dt-api search()`, providing a delay before the search is made.
	 */
	"searchDelay": null,


	/**
	 * DataTables features six different built-in options for the buttons to
	 * display for pagination control:
	 *
	 * * `numbers` - Page number buttons only
	 * * `simple` - 'Previous' and 'Next' buttons only
	 * * 'simple_numbers` - 'Previous' and 'Next' buttons, plus page numbers
	 * * `full` - 'First', 'Previous', 'Next' and 'Last' buttons
	 * * `full_numbers` - 'First', 'Previous', 'Next' and 'Last' buttons, plus page numbers
	 * * `first_last_numbers` - 'First' and 'Last' buttons, plus page numbers
	 */
	"sPaginationType": "full_numbers",


	/**
	 * Enable horizontal scrolling. When a table is too wide to fit into a
	 * certain layout, or you have a large number of columns in the table, you
	 * can enable x-scrolling to show the table in a viewport, which can be
	 * scrolled. This property can be `true` which will allow the table to
	 * scroll horizontally when needed, or any CSS unit, or a number (in which
	 * case it will be treated as a pixel measurement). Setting as simply `true`
	 * is recommended.
	 */
	"sScrollX": "",


	/**
	 * This property can be used to force a DataTable to use more width than it
	 * might otherwise do when x-scrolling is enabled. For example if you have a
	 * table which requires to be well spaced, this parameter is useful for
	 * "over-sizing" the table, and thus forcing scrolling. This property can by
	 * any CSS unit, or a number (in which case it will be treated as a pixel
	 * measurement).
	 */
	"sScrollXInner": "",


	/**
	 * Enable vertical scrolling. Vertical scrolling will constrain the DataTable
	 * to the given height, and enable scrolling for any data which overflows the
	 * current viewport. This can be used as an alternative to paging to display
	 * a lot of data in a small area (although paging and scrolling can both be
	 * enabled at the same time). This property can be any CSS unit, or a number
	 * (in which case it will be treated as a pixel measurement).
	 */
	"sScrollY": "",


	/**
	 * __Deprecated__ The functionality provided by this parameter has now been
	 * superseded by that provided through `ajax`, which should be used instead.
	 *
	 * Set the HTTP method that is used to make the Ajax call for server-side
	 * processing or Ajax sourced data.
	 */
	"sServerMethod": "GET",


	/**
	 * DataTables makes use of renderers when displaying HTML elements for
	 * a table. These renderers can be added or modified by plug-ins to
	 * generate suitable mark-up for a site. For example the Bootstrap
	 * integration plug-in for DataTables uses a paging button renderer to
	 * display pagination buttons in the mark-up required by Bootstrap.
	 *
	 * For further information about the renderers available see
	 * DataTable.ext.renderer
	 */
	"renderer": null,


	/**
	 * Set the data property name that DataTables should use to get a row's id
	 * to set as the `id` property in the node.
	 */
	"rowId": "DT_RowId",


	/**
	 * Caption value
	 */
	"caption": null
};

_fnHungarianMap( DataTable.defaults );



/*
 * Developer note - See note in model.defaults.js about the use of Hungarian
 * notation and camel case.
 */

/**
 * Column options that can be given to DataTables at initialisation time.
 *  @namespace
 */
DataTable.defaults.column = {
	/**
	 * Define which column(s) an order will occur on for this column. This
	 * allows a column's ordering to take multiple columns into account when
	 * doing a sort or use the data from a different column. For example first
	 * name / last name columns make sense to do a multi-column sort over the
	 * two columns.
	 */
	"aDataSort": null,
	"iDataSort": -1,

	ariaTitle: '',


	/**
	 * You can control the default ordering direction, and even alter the
	 * behaviour of the sort handler (i.e. only allow ascending ordering etc)
	 * using this parameter.
	 */
	"asSorting": [ 'asc', 'desc', '' ],


	/**
	 * Enable or disable filtering on the data in this column.
	 */
	"bSearchable": true,


	/**
	 * Enable or disable ordering on this column.
	 */
	"bSortable": true,


	/**
	 * Enable or disable the display of this column.
	 */
	"bVisible": true,


	/**
	 * Developer definable function that is called whenever a cell is created (Ajax source,
	 * etc) or processed for input (DOM source). This can be used as a compliment to mRender
	 * allowing you to modify the DOM element (add background colour for example) when the
	 * element is available.
	 */
	"fnCreatedCell": null,


	/**
	 * This property can be used to read data from any data source property,
	 * including deeply nested objects / properties. `data` can be given in a
	 * number of different ways which effect its behaviour:
	 *
	 * * `integer` - treated as an array index for the data source. This is the
	 *   default that DataTables uses (incrementally increased for each column).
	 * * `string` - read an object property from the data source. There are
	 *   three 'special' options that can be used in the string to alter how
	 *   DataTables reads the data from the source object:
	 *    * `.` - Dotted Javascript notation. Just as you use a `.` in
	 *      Javascript to read from nested objects, so to can the options
	 *      specified in `data`. For example: `browser.version` or
	 *      `browser.name`. If your object parameter name contains a period, use
	 *      `\\` to escape it - i.e. `first\\.name`.
	 *    * `[]` - Array notation. DataTables can automatically combine data
	 *      from and array source, joining the data with the characters provided
	 *      between the two brackets. For example: `name[, ]` would provide a
	 *      comma-space separated list from the source array. If no characters
	 *      are provided between the brackets, the original array source is
	 *      returned.
	 *    * `()` - Function notation. Adding `()` to the end of a parameter will
	 *      execute a function of the name given. For example: `browser()` for a
	 *      simple function on the data source, `browser.version()` for a
	 *      function in a nested property or even `browser().version` to get an
	 *      object property if the function called returns an object. Note that
	 *      function notation is recommended for use in `render` rather than
	 *      `data` as it is much simpler to use as a renderer.
	 * * `null` - use the original data source for the row rather than plucking
	 *   data directly from it. This action has effects on two other
	 *   initialisation options:
	 *    * `defaultContent` - When null is given as the `data` option and
	 *      `defaultContent` is specified for the column, the value defined by
	 *      `defaultContent` will be used for the cell.
	 *    * `render` - When null is used for the `data` option and the `render`
	 *      option is specified for the column, the whole data source for the
	 *      row is used for the renderer.
	 * * `function` - the function given will be executed whenever DataTables
	 *   needs to set or get the data for a cell in the column. The function
	 *   takes three parameters:
	 *    * Parameters:
	 *      * `{array|object}` The data source for the row
	 *      * `{string}` The type call data requested - this will be 'set' when
	 *        setting data or 'filter', 'display', 'type', 'sort' or undefined
	 *        when gathering data. Note that when `undefined` is given for the
	 *        type DataTables expects to get the raw data for the object back<
	 *      * `{*}` Data to set when the second parameter is 'set'.
	 *    * Return:
	 *      * The return value from the function is not required when 'set' is
	 *        the type of call, but otherwise the return is what will be used
	 *        for the data requested.
	 *
	 * Note that `data` is a getter and setter option. If you just require
	 * formatting of data for output, you will likely want to use `render` which
	 * is simply a getter and thus simpler to use.
	 *
	 * Note that prior to DataTables 1.9.2 `data` was called `mDataProp`. The
	 * name change reflects the flexibility of this property and is consistent
	 * with the naming of mRender. If 'mDataProp' is given, then it will still
	 * be used by DataTables, as it automatically maps the old name to the new
	 * if required.
	 */
	"mData": null,


	/**
	 * This property is the rendering partner to `data` and it is suggested that
	 * when you want to manipulate data for display (including filtering,
	 * sorting etc) without altering the underlying data for the table, use this
	 * property. `render` can be considered to be the the read only companion to
	 * `data` which is read / write (then as such more complex). Like `data`
	 * this option can be given in a number of different ways to effect its
	 * behaviour:
	 *
	 * * `integer` - treated as an array index for the data source. This is the
	 *   default that DataTables uses (incrementally increased for each column).
	 * * `string` - read an object property from the data source. There are
	 *   three 'special' options that can be used in the string to alter how
	 *   DataTables reads the data from the source object:
	 *    * `.` - Dotted Javascript notation. Just as you use a `.` in
	 *      Javascript to read from nested objects, so to can the options
	 *      specified in `data`. For example: `browser.version` or
	 *      `browser.name`. If your object parameter name contains a period, use
	 *      `\\` to escape it - i.e. `first\\.name`.
	 *    * `[]` - Array notation. DataTables can automatically combine data
	 *      from and array source, joining the data with the characters provided
	 *      between the two brackets. For example: `name[, ]` would provide a
	 *      comma-space separated list from the source array. If no characters
	 *      are provided between the brackets, the original array source is
	 *      returned.
	 *    * `()` - Function notation. Adding `()` to the end of a parameter will
	 *      execute a function of the name given. For example: `browser()` for a
	 *      simple function on the data source, `browser.version()` for a
	 *      function in a nested property or even `browser().version` to get an
	 *      object property if the function called returns an object.
	 * * `object` - use different data for the different data types requested by
	 *   DataTables ('filter', 'display', 'type' or 'sort'). The property names
	 *   of the object is the data type the property refers to and the value can
	 *   defined using an integer, string or function using the same rules as
	 *   `render` normally does. Note that an `_` option _must_ be specified.
	 *   This is the default value to use if you haven't specified a value for
	 *   the data type requested by DataTables.
	 * * `function` - the function given will be executed whenever DataTables
	 *   needs to set or get the data for a cell in the column. The function
	 *   takes three parameters:
	 *    * Parameters:
	 *      * {array|object} The data source for the row (based on `data`)
	 *      * {string} The type call data requested - this will be 'filter',
	 *        'display', 'type' or 'sort'.
	 *      * {array|object} The full data source for the row (not based on
	 *        `data`)
	 *    * Return:
	 *      * The return value from the function is what will be used for the
	 *        data requested.
	 */
	"mRender": null,


	/**
	 * Change the cell type created for the column - either TD cells or TH cells. This
	 * can be useful as TH cells have semantic meaning in the table body, allowing them
	 * to act as a header for a row (you may wish to add scope='row' to the TH elements).
	 */
	"sCellType": "td",


	/**
	 * Class to give to each cell in this column.
	 */
	"sClass": "",

	/**
	 * When DataTables calculates the column widths to assign to each column,
	 * it finds the longest string in each column and then constructs a
	 * temporary table and reads the widths from that. The problem with this
	 * is that "mmm" is much wider then "iiii", but the latter is a longer
	 * string - thus the calculation can go wrong (doing it properly and putting
	 * it into an DOM object and measuring that is horribly(!) slow). Thus as
	 * a "work around" we provide this option. It will append its value to the
	 * text that is found to be the longest string for the column - i.e. padding.
	 * Generally you shouldn't need this!
	 */
	"sContentPadding": "",


	/**
	 * Allows a default value to be given for a column's data, and will be used
	 * whenever a null data source is encountered (this can be because `data`
	 * is set to null, or because the data source itself is null).
	 */
	"sDefaultContent": null,


	/**
	 * This parameter is only used in DataTables' server-side processing. It can
	 * be exceptionally useful to know what columns are being displayed on the
	 * client side, and to map these to database fields. When defined, the names
	 * also allow DataTables to reorder information from the server if it comes
	 * back in an unexpected order (i.e. if you switch your columns around on the
	 * client-side, your server-side code does not also need updating).
	 */
	"sName": "",


	/**
	 * Defines a data source type for the ordering which can be used to read
	 * real-time information from the table (updating the internally cached
	 * version) prior to ordering. This allows ordering to occur on user
	 * editable elements such as form inputs.
	 */
	"sSortDataType": "std",


	/**
	 * The title of this column.
	 */
	"sTitle": null,


	/**
	 * The type allows you to specify how the data for this column will be
	 * ordered. Four types (string, numeric, date and html (which will strip
	 * HTML tags before ordering)) are currently available. Note that only date
	 * formats understood by Javascript's Date() object will be accepted as type
	 * date. For example: "Mar 26, 2008 5:03 PM". May take the values: 'string',
	 * 'numeric', 'date' or 'html' (by default). Further types can be adding
	 * through plug-ins.
	 */
	"sType": null,


	/**
	 * Defining the width of the column, this parameter may take any CSS value
	 * (3em, 20px etc). DataTables applies 'smart' widths to columns which have not
	 * been given a specific width through this interface ensuring that the table
	 * remains readable.
	 */
	"sWidth": null
};

_fnHungarianMap( DataTable.defaults.column );



/**
 * DataTables settings object - this holds all the information needed for a
 * given table, including configuration, data and current application of the
 * table options. DataTables does not have a single instance for each DataTable
 * with the settings attached to that instance, but rather instances of the
 * DataTable "class" are created on-the-fly as needed (typically by a
 * $().dataTable() call) and the settings object is then applied to that
 * instance.
 *
 * Note that this object is related to {@link DataTable.defaults} but this
 * one is the internal data store for DataTables's cache of columns. It should
 * NOT be manipulated outside of DataTables. Any configuration should be done
 * through the initialisation options.
 */
DataTable.models.oSettings = {
	/**
	 * Primary features of DataTables and their enablement state.
	 */
	"oFeatures": {

		/**
		 * Flag to say if DataTables should automatically try to calculate the
		 * optimum table and columns widths (true) or not (false).
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bAutoWidth": null,

		/**
		 * Delay the creation of TR and TD elements until they are actually
		 * needed by a driven page draw. This can give a significant speed
		 * increase for Ajax source and Javascript source data, but makes no
		 * difference at all for DOM and server-side processing tables.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bDeferRender": null,

		/**
		 * Enable filtering on the table or not. Note that if this is disabled
		 * then there is no filtering at all on the table, including fnFilter.
		 * To just remove the filtering input use sDom and remove the 'f' option.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bFilter": null,

		/**
		 * Used only for compatiblity with DT1
		 * @deprecated
		 */
		"bInfo": true,

		/**
		 * Used only for compatiblity with DT1
		 * @deprecated
		 */
		"bLengthChange": true,

		/**
		 * Pagination enabled or not. Note that if this is disabled then length
		 * changing must also be disabled.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bPaginate": null,

		/**
		 * Processing indicator enable flag whenever DataTables is enacting a
		 * user request - typically an Ajax request for server-side processing.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bProcessing": null,

		/**
		 * Server-side processing enabled flag - when enabled DataTables will
		 * get all data from the server for every draw - there is no filtering,
		 * sorting or paging done on the client-side.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bServerSide": null,

		/**
		 * Sorting enablement flag.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSort": null,

		/**
		 * Multi-column sorting
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSortMulti": null,

		/**
		 * Apply a class to the columns which are being sorted to provide a
		 * visual highlight or not. This can slow things down when enabled since
		 * there is a lot of DOM interaction.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bSortClasses": null,

		/**
		 * State saving enablement flag.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bStateSave": null
	},


	/**
	 * Scrolling settings for a table.
	 */
	"oScroll": {
		/**
		 * When the table is shorter in height than sScrollY, collapse the
		 * table container down to the height of the table (when true).
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"bCollapse": null,

		/**
		 * Width of the scrollbar for the web-browser's platform. Calculated
		 * during table initialisation.
		 */
		"iBarWidth": 0,

		/**
		 * Viewport width for horizontal scrolling. Horizontal scrolling is
		 * disabled if an empty string.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"sX": null,

		/**
		 * Width to expand the table to when using x-scrolling. Typically you
		 * should not need to use this.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 *  @deprecated
		 */
		"sXInner": null,

		/**
		 * Viewport height for vertical scrolling. Vertical scrolling is disabled
		 * if an empty string.
		 * Note that this parameter will be set by the initialisation routine. To
		 * set a default use {@link DataTable.defaults}.
		 */
		"sY": null
	},

	/**
	 * Language information for the table.
	 */
	"oLanguage": {
		/**
		 * Information callback function. See
		 * {@link DataTable.defaults.fnInfoCallback}
		 */
		"fnInfoCallback": null
	},

	/**
	 * Browser support parameters
	 */
	"oBrowser": {
		/**
		 * Determine if the vertical scrollbar is on the right or left of the
		 * scrolling container - needed for rtl language layout, although not
		 * all browsers move the scrollbar (Safari).
		 */
		"bScrollbarLeft": false,

		/**
		 * Browser scrollbar width
		 */
		"barWidth": 0
	},


	"ajax": null,


	/**
	 * Array referencing the nodes which are used for the features. The
	 * parameters of this object match what is allowed by sDom - i.e.
	 *   <ul>
	 *     <li>'l' - Length changing</li>
	 *     <li>'f' - Filtering input</li>
	 *     <li>'t' - The table!</li>
	 *     <li>'i' - Information</li>
	 *     <li>'p' - Pagination</li>
	 *     <li>'r' - pRocessing</li>
	 *   </ul>
	 */
	"aanFeatures": [],

	/**
	 * Store data information - see {@link DataTable.models.oRow} for detailed
	 * information.
	 */
	"aoData": [],

	/**
	 * Array of indexes which are in the current display (after filtering etc)
	 */
	"aiDisplay": [],

	/**
	 * Array of indexes for display - no filtering
	 */
	"aiDisplayMaster": [],

	/**
	 * Map of row ids to data indexes
	 */
	"aIds": {},

	/**
	 * Store information about each column that is in use
	 */
	"aoColumns": [],

	/**
	 * Store information about the table's header
	 */
	"aoHeader": [],

	/**
	 * Store information about the table's footer
	 */
	"aoFooter": [],

	/**
	 * Store the applied global search information in case we want to force a
	 * research or compare the old search to a new one.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"oPreviousSearch": {},

	/**
	 * Store for named searches
	 */
	searchFixed: {},

	/**
	 * Store the applied search for each column - see
	 * {@link DataTable.models.oSearch} for the format that is used for the
	 * filtering information for each column.
	 */
	"aoPreSearchCols": [],

	/**
	 * Sorting that is applied to the table. Note that the inner arrays are
	 * used in the following manner:
	 * <ul>
	 *   <li>Index 0 - column number</li>
	 *   <li>Index 1 - current sorting direction</li>
	 * </ul>
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aaSorting": null,

	/**
	 * Sorting that is always applied to the table (i.e. prefixed in front of
	 * aaSorting).
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aaSortingFixed": [],

	/**
	 * If restoring a table - we should restore its width
	 */
	"sDestroyWidth": 0,

	/**
	 * Callback functions array for every time a row is inserted (i.e. on a draw).
	 */
	"aoRowCallback": [],

	/**
	 * Callback functions for the header on each draw.
	 */
	"aoHeaderCallback": [],

	/**
	 * Callback function for the footer on each draw.
	 */
	"aoFooterCallback": [],

	/**
	 * Array of callback functions for draw callback functions
	 */
	"aoDrawCallback": [],

	/**
	 * Array of callback functions for row created function
	 */
	"aoRowCreatedCallback": [],

	/**
	 * Callback functions for just before the table is redrawn. A return of
	 * false will be used to cancel the draw.
	 */
	"aoPreDrawCallback": [],

	/**
	 * Callback functions for when the table has been initialised.
	 */
	"aoInitComplete": [],


	/**
	 * Callbacks for modifying the settings to be stored for state saving, prior to
	 * saving state.
	 */
	"aoStateSaveParams": [],

	/**
	 * Callbacks for modifying the settings that have been stored for state saving
	 * prior to using the stored values to restore the state.
	 */
	"aoStateLoadParams": [],

	/**
	 * Callbacks for operating on the settings object once the saved state has been
	 * loaded
	 */
	"aoStateLoaded": [],

	/**
	 * Cache the table ID for quick access
	 */
	"sTableId": "",

	/**
	 * The TABLE node for the main table
	 */
	"nTable": null,

	/**
	 * Permanent ref to the thead element
	 */
	"nTHead": null,

	/**
	 * Permanent ref to the tfoot element - if it exists
	 */
	"nTFoot": null,

	/**
	 * Permanent ref to the tbody element
	 */
	"nTBody": null,

	/**
	 * Cache the wrapper node (contains all DataTables controlled elements)
	 */
	"nTableWrapper": null,

	/**
	 * Indicate if all required information has been read in
	 */
	"bInitialised": false,

	/**
	 * Information about open rows. Each object in the array has the parameters
	 * 'nTr' and 'nParent'
	 */
	"aoOpenRows": [],

	/**
	 * Dictate the positioning of DataTables' control elements - see
	 * {@link DataTable.model.oInit.sDom}.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sDom": null,

	/**
	 * Search delay (in mS)
	 */
	"searchDelay": null,

	/**
	 * Which type of pagination should be used.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sPaginationType": "two_button",

	/**
	 * Number of paging controls on the page. Only used for backwards compatibility
	 */
	pagingControls: 0,

	/**
	 * The state duration (for `stateSave`) in seconds.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"iStateDuration": 0,

	/**
	 * Array of callback functions for state saving. Each array element is an
	 * object with the following parameters:
	 *   <ul>
	 *     <li>function:fn - function to call. Takes two parameters, oSettings
	 *       and the JSON string to save that has been thus far created. Returns
	 *       a JSON string to be inserted into a json object
	 *       (i.e. '"param": [ 0, 1, 2]')</li>
	 *     <li>string:sName - name of callback</li>
	 *   </ul>
	 */
	"aoStateSave": [],

	/**
	 * Array of callback functions for state loading. Each array element is an
	 * object with the following parameters:
	 *   <ul>
	 *     <li>function:fn - function to call. Takes two parameters, oSettings
	 *       and the object stored. May return false to cancel state loading</li>
	 *     <li>string:sName - name of callback</li>
	 *   </ul>
	 */
	"aoStateLoad": [],

	/**
	 * State that was saved. Useful for back reference
	 */
	"oSavedState": null,

	/**
	 * State that was loaded. Useful for back reference
	 */
	"oLoadedState": null,

	/**
	 * Note if draw should be blocked while getting data
	 */
	"bAjaxDataGet": true,

	/**
	 * The last jQuery XHR object that was used for server-side data gathering.
	 * This can be used for working with the XHR information in one of the
	 * callbacks
	 */
	"jqXHR": null,

	/**
	 * JSON returned from the server in the last Ajax request
	 */
	"json": undefined,

	/**
	 * Data submitted as part of the last Ajax request
	 */
	"oAjaxData": undefined,

	/**
	 * Send the XHR HTTP method - GET or POST (could be PUT or DELETE if
	 * required).
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"sServerMethod": null,

	/**
	 * Format numbers for display.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"fnFormatNumber": null,

	/**
	 * List of options that can be used for the user selectable length menu.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"aLengthMenu": null,

	/**
	 * Counter for the draws that the table does. Also used as a tracker for
	 * server-side processing
	 */
	"iDraw": 0,

	/**
	 * Indicate if a redraw is being done - useful for Ajax
	 */
	"bDrawing": false,

	/**
	 * Draw index (iDraw) of the last error when parsing the returned data
	 */
	"iDrawError": -1,

	/**
	 * Paging display length
	 */
	"_iDisplayLength": 10,

	/**
	 * Paging start point - aiDisplay index
	 */
	"_iDisplayStart": 0,

	/**
	 * Server-side processing - number of records in the result set
	 * (i.e. before filtering), Use fnRecordsTotal rather than
	 * this property to get the value of the number of records, regardless of
	 * the server-side processing setting.
	 */
	"_iRecordsTotal": 0,

	/**
	 * Server-side processing - number of records in the current display set
	 * (i.e. after filtering). Use fnRecordsDisplay rather than
	 * this property to get the value of the number of records, regardless of
	 * the server-side processing setting.
	 */
	"_iRecordsDisplay": 0,

	/**
	 * The classes to use for the table
	 */
	"oClasses": {},

	/**
	 * Flag attached to the settings object so you can check in the draw
	 * callback if filtering has been done in the draw. Deprecated in favour of
	 * events.
	 *  @deprecated
	 */
	"bFiltered": false,

	/**
	 * Flag attached to the settings object so you can check in the draw
	 * callback if sorting has been done in the draw. Deprecated in favour of
	 * events.
	 *  @deprecated
	 */
	"bSorted": false,

	/**
	 * Indicate that if multiple rows are in the header and there is more than
	 * one unique cell per column, if the top one (true) or bottom one (false)
	 * should be used for sorting / title by DataTables.
	 * Note that this parameter will be set by the initialisation routine. To
	 * set a default use {@link DataTable.defaults}.
	 */
	"bSortCellsTop": null,

	/**
	 * Initialisation object that is used for the table
	 */
	"oInit": null,

	/**
	 * Destroy callback functions - for plug-ins to attach themselves to the
	 * destroy so they can clean up markup and events.
	 */
	"aoDestroyCallback": [],


	/**
	 * Get the number of records in the current record set, before filtering
	 */
	"fnRecordsTotal": function ()
	{
		return _fnDataSource( this ) == 'ssp' ?
			this._iRecordsTotal * 1 :
			this.aiDisplayMaster.length;
	},

	/**
	 * Get the number of records in the current record set, after filtering
	 */
	"fnRecordsDisplay": function ()
	{
		return _fnDataSource( this ) == 'ssp' ?
			this._iRecordsDisplay * 1 :
			this.aiDisplay.length;
	},

	/**
	 * Get the display end point - aiDisplay index
	 */
	"fnDisplayEnd": function ()
	{
		var
			len      = this._iDisplayLength,
			start    = this._iDisplayStart,
			calc     = start + len,
			records  = this.aiDisplay.length,
			features = this.oFeatures,
			paginate = features.bPaginate;

		if ( features.bServerSide ) {
			return paginate === false || len === -1 ?
				start + records :
				Math.min( start+len, this._iRecordsDisplay );
		}
		else {
			return ! paginate || calc>records || len===-1 ?
				records :
				calc;
		}
	},

	/**
	 * The DataTables object for this table
	 */
	"oInstance": null,

	/**
	 * Unique identifier for each instance of the DataTables object. If there
	 * is an ID on the table node, then it takes that value, otherwise an
	 * incrementing internal counter is used.
	 */
	"sInstance": null,

	/**
	 * tabindex attribute value that is added to DataTables control elements, allowing
	 * keyboard navigation of the table and its controls.
	 */
	"iTabIndex": 0,

	/**
	 * DIV container for the footer scrolling table if scrolling
	 */
	"nScrollHead": null,

	/**
	 * DIV container for the footer scrolling table if scrolling
	 */
	"nScrollFoot": null,

	/**
	 * Last applied sort
	 */
	"aLastSort": [],

	/**
	 * Stored plug-in instances
	 */
	"oPlugins": {},

	/**
	 * Function used to get a row's id from the row's data
	 */
	"rowIdFn": null,

	/**
	 * Data location where to store a row's id
	 */
	"rowId": null,

	caption: '',

	captionNode: null,

	colgroup: null
};

/**
 * Extension object for DataTables that is used to provide all extension
 * options.
 *
 * Note that the `DataTable.ext` object is available through
 * `jQuery.fn.dataTable.ext` where it may be accessed and manipulated. It is
 * also aliased to `jQuery.fn.dataTableExt` for historic reasons.
 *  @namespace
 *  @extends DataTable.models.ext
 */


/**
 * DataTables extensions
 * 
 * This namespace acts as a collection area for plug-ins that can be used to
 * extend DataTables capabilities. Indeed many of the build in methods
 * use this method to provide their own capabilities (sorting methods for
 * example).
 *
 * Note that this namespace is aliased to `jQuery.fn.dataTableExt` for legacy
 * reasons
 *
 *  @namespace
 */
DataTable.ext = _ext = {
	/**
	 * Buttons. For use with the Buttons extension for DataTables. This is
	 * defined here so other extensions can define buttons regardless of load
	 * order. It is _not_ used by DataTables core.
	 *
	 *  @type object
	 *  @default {}
	 */
	buttons: {},


	/**
	 * Element class names
	 *
	 *  @type object
	 *  @default {}
	 */
	classes: {},


	/**
	 * DataTables build type (expanded by the download builder)
	 *
	 *  @type string
	 */
	builder: "-source-",


	/**
	 * Error reporting.
	 * 
	 * How should DataTables report an error. Can take the value 'alert',
	 * 'throw', 'none' or a function.
	 *
	 *  @type string|function
	 *  @default alert
	 */
	errMode: "alert",


	/**
	 * Legacy so v1 plug-ins don't throw js errors on load
	 */
	feature: [],

	/**
	 * Feature plug-ins.
	 * 
	 * This is an object of callbacks which provide the features for DataTables
	 * to be initialised via the `layout` option.
	 */
	features: {},


	/**
	 * Row searching.
	 * 
	 * This method of searching is complimentary to the default type based
	 * searching, and a lot more comprehensive as it allows you complete control
	 * over the searching logic. Each element in this array is a function
	 * (parameters described below) that is called for every row in the table,
	 * and your logic decides if it should be included in the searching data set
	 * or not.
	 *
	 * Searching functions have the following input parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{array|object}` Data for the row to be processed (same as the
	 *    original format that was passed in as the data source, or an array
	 *    from a DOM data source
	 * 3. `{int}` Row index ({@link DataTable.models.oSettings.aoData}), which
	 *    can be useful to retrieve the `TR` element if you need DOM interaction.
	 *
	 * And the following return is expected:
	 *
	 * * {boolean} Include the row in the searched result set (true) or not
	 *   (false)
	 *
	 * Note that as with the main search ability in DataTables, technically this
	 * is "filtering", since it is subtractive. However, for consistency in
	 * naming we call it searching here.
	 *
	 *  @type array
	 *  @default []
	 *
	 *  @example
	 *    // The following example shows custom search being applied to the
	 *    // fourth column (i.e. the data[3] index) based on two input values
	 *    // from the end-user, matching the data in a certain range.
	 *    $.fn.dataTable.ext.search.push(
	 *      function( settings, data, dataIndex ) {
	 *        var min = document.getElementById('min').value * 1;
	 *        var max = document.getElementById('max').value * 1;
	 *        var version = data[3] == "-" ? 0 : data[3]*1;
	 *
	 *        if ( min == "" && max == "" ) {
	 *          return true;
	 *        }
	 *        else if ( min == "" && version < max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && "" == max ) {
	 *          return true;
	 *        }
	 *        else if ( min < version && version < max ) {
	 *          return true;
	 *        }
	 *        return false;
	 *      }
	 *    );
	 */
	search: [],


	/**
	 * Selector extensions
	 *
	 * The `selector` option can be used to extend the options available for the
	 * selector modifier options (`selector-modifier` object data type) that
	 * each of the three built in selector types offer (row, column and cell +
	 * their plural counterparts). For example the Select extension uses this
	 * mechanism to provide an option to select only rows, columns and cells
	 * that have been marked as selected by the end user (`{selected: true}`),
	 * which can be used in conjunction with the existing built in selector
	 * options.
	 *
	 * Each property is an array to which functions can be pushed. The functions
	 * take three attributes:
	 *
	 * * Settings object for the host table
	 * * Options object (`selector-modifier` object type)
	 * * Array of selected item indexes
	 *
	 * The return is an array of the resulting item indexes after the custom
	 * selector has been applied.
	 *
	 *  @type object
	 */
	selector: {
		cell: [],
		column: [],
		row: []
	},


	/**
	 * Legacy configuration options. Enable and disable legacy options that
	 * are available in DataTables.
	 *
	 *  @type object
	 */
	legacy: {
		/**
		 * Enable / disable DataTables 1.9 compatible server-side processing
		 * requests
		 *
		 *  @type boolean
		 *  @default null
		 */
		ajax: null
	},


	/**
	 * Pagination plug-in methods.
	 * 
	 * Each entry in this object is a function and defines which buttons should
	 * be shown by the pagination rendering method that is used for the table:
	 * {@link DataTable.ext.renderer.pageButton}. The renderer addresses how the
	 * buttons are displayed in the document, while the functions here tell it
	 * what buttons to display. This is done by returning an array of button
	 * descriptions (what each button will do).
	 *
	 * Pagination types (the four built in options and any additional plug-in
	 * options defined here) can be used through the `paginationType`
	 * initialisation parameter.
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{int} page` The current page index
	 * 2. `{int} pages` The number of pages in the table
	 *
	 * Each function is expected to return an array where each element of the
	 * array can be one of:
	 *
	 * * `first` - Jump to first page when activated
	 * * `last` - Jump to last page when activated
	 * * `previous` - Show previous page when activated
	 * * `next` - Show next page when activated
	 * * `{int}` - Show page of the index given
	 * * `{array}` - A nested array containing the above elements to add a
	 *   containing 'DIV' element (might be useful for styling).
	 *
	 * Note that DataTables v1.9- used this object slightly differently whereby
	 * an object with two functions would be defined for each plug-in. That
	 * ability is still supported by DataTables 1.10+ to provide backwards
	 * compatibility, but this option of use is now decremented and no longer
	 * documented in DataTables 1.10+.
	 *
	 *  @type object
	 *  @default {}
	 *
	 *  @example
	 *    // Show previous, next and current page buttons only
	 *    $.fn.dataTableExt.oPagination.current = function ( page, pages ) {
	 *      return [ 'previous', page, 'next' ];
	 *    };
	 */
	pager: {},


	renderer: {
		pageButton: {},
		header: {}
	},


	/**
	 * Ordering plug-ins - custom data source
	 * 
	 * The extension options for ordering of data available here is complimentary
	 * to the default type based ordering that DataTables typically uses. It
	 * allows much greater control over the the data that is being used to
	 * order a column, but is necessarily therefore more complex.
	 * 
	 * This type of ordering is useful if you want to do ordering based on data
	 * live from the DOM (for example the contents of an 'input' element) rather
	 * than just the static string that DataTables knows of.
	 * 
	 * The way these plug-ins work is that you create an array of the values you
	 * wish to be ordering for the column in question and then return that
	 * array. The data in the array much be in the index order of the rows in
	 * the table (not the currently ordering order!). Which order data gathering
	 * function is run here depends on the `dt-init columns.orderDataType`
	 * parameter that is used for the column (if any).
	 *
	 * The functions defined take two parameters:
	 *
	 * 1. `{object}` DataTables settings object: see
	 *    {@link DataTable.models.oSettings}
	 * 2. `{int}` Target column index
	 *
	 * Each function is expected to return an array:
	 *
	 * * `{array}` Data for the column to be ordering upon
	 *
	 *  @type array
	 *
	 *  @example
	 *    // Ordering using `input` node values
	 *    $.fn.dataTable.ext.order['dom-text'] = function  ( settings, col )
	 *    {
	 *      return this.api().column( col, {order:'index'} ).nodes().map( function ( td, i ) {
	 *        return $('input', td).val();
	 *      } );
	 *    }
	 */
	order: {},


	/**
	 * Type based plug-ins.
	 *
	 * Each column in DataTables has a type assigned to it, either by automatic
	 * detection or by direct assignment using the `type` option for the column.
	 * The type of a column will effect how it is ordering and search (plug-ins
	 * can also make use of the column type if required).
	 *
	 * @namespace
	 */
	type: {
		/**
		 * Automatic column class assignment
		 */
		className: {},

		/**
		 * Type detection functions.
		 *
		 * The functions defined in this object are used to automatically detect
		 * a column's type, making initialisation of DataTables super easy, even
		 * when complex data is in the table.
		 *
		 * The functions defined take two parameters:
		 *
	     *  1. `{*}` Data from the column cell to be analysed
	     *  2. `{settings}` DataTables settings object. This can be used to
	     *     perform context specific type detection - for example detection
	     *     based on language settings such as using a comma for a decimal
	     *     place. Generally speaking the options from the settings will not
	     *     be required
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Data type detected, or null if unknown (and thus
		 *   pass it on to the other type detection functions.
		 *
		 *  @type array
		 *
		 *  @example
		 *    // Currency type detection plug-in:
		 *    $.fn.dataTable.ext.type.detect.push(
		 *      function ( data, settings ) {
		 *        // Check the numeric part
		 *        if ( ! data.substring(1).match(/[0-9]/) ) {
		 *          return null;
		 *        }
		 *
		 *        // Check prefixed by currency
		 *        if ( data.charAt(0) == '$' || data.charAt(0) == '&pound;' ) {
		 *          return 'currency';
		 *        }
		 *        return null;
		 *      }
		 *    );
		 */
		detect: [],

		/**
		 * Automatic renderer assignment
		 */
		render: {},


		/**
		 * Type based search formatting.
		 *
		 * The type based searching functions can be used to pre-format the
		 * data to be search on. For example, it can be used to strip HTML
		 * tags or to de-format telephone numbers for numeric only searching.
		 *
		 * Note that is a search is not defined for a column of a given type,
		 * no search formatting will be performed.
		 * 
		 * Pre-processing of searching data plug-ins - When you assign the sType
		 * for a column (or have it automatically detected for you by DataTables
		 * or a type detection plug-in), you will typically be using this for
		 * custom sorting, but it can also be used to provide custom searching
		 * by allowing you to pre-processing the data and returning the data in
		 * the format that should be searched upon. This is done by adding
		 * functions this object with a parameter name which matches the sType
		 * for that target column. This is the corollary of <i>afnSortData</i>
		 * for searching data.
		 *
		 * The functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for searching
		 *
		 * Each function is expected to return:
		 *
		 * * `{string|null}` Formatted string that will be used for the searching.
		 *
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    $.fn.dataTable.ext.type.search['title-numeric'] = function ( d ) {
		 *      return d.replace(/\n/g," ").replace( /<.*?>/g, "" );
		 *    }
		 */
		search: {},


		/**
		 * Type based ordering.
		 *
		 * The column type tells DataTables what ordering to apply to the table
		 * when a column is sorted upon. The order for each type that is defined,
		 * is defined by the functions available in this object.
		 *
		 * Each ordering option can be described by three properties added to
		 * this object:
		 *
		 * * `{type}-pre` - Pre-formatting function
		 * * `{type}-asc` - Ascending order function
		 * * `{type}-desc` - Descending order function
		 *
		 * All three can be used together, only `{type}-pre` or only
		 * `{type}-asc` and `{type}-desc` together. It is generally recommended
		 * that only `{type}-pre` is used, as this provides the optimal
		 * implementation in terms of speed, although the others are provided
		 * for compatibility with existing Javascript sort functions.
		 *
		 * `{type}-pre`: Functions defined take a single parameter:
		 *
	     *  1. `{*}` Data from the column cell to be prepared for ordering
		 *
		 * And return:
		 *
		 * * `{*}` Data to be sorted upon
		 *
		 * `{type}-asc` and `{type}-desc`: Functions are typical Javascript sort
		 * functions, taking two parameters:
		 *
	     *  1. `{*}` Data to compare to the second parameter
	     *  2. `{*}` Data to compare to the first parameter
		 *
		 * And returning:
		 *
		 * * `{*}` Ordering match: <0 if first parameter should be sorted lower
		 *   than the second parameter, ===0 if the two parameters are equal and
		 *   >0 if the first parameter should be sorted height than the second
		 *   parameter.
		 * 
		 *  @type object
		 *  @default {}
		 *
		 *  @example
		 *    // Numeric ordering of formatted numbers with a pre-formatter
		 *    $.extend( $.fn.dataTable.ext.type.order, {
		 *      "string-pre": function(x) {
		 *        a = (a === "-" || a === "") ? 0 : a.replace( /[^\d\-\.]/g, "" );
		 *        return parseFloat( a );
		 *      }
		 *    } );
		 *
		 *  @example
		 *    // Case-sensitive string ordering, with no pre-formatting method
		 *    $.extend( $.fn.dataTable.ext.order, {
		 *      "string-case-asc": function(x,y) {
		 *        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		 *      },
		 *      "string-case-desc": function(x,y) {
		 *        return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		 *      }
		 *    } );
		 */
		order: {}
	},

	/**
	 * Unique DataTables instance counter
	 *
	 * @type int
	 * @private
	 */
	_unique: 0,


	//
	// Depreciated
	// The following properties are retained for backwards compatibility only.
	// The should not be used in new projects and will be removed in a future
	// version
	//

	/**
	 * Version check function.
	 *  @type function
	 *  @depreciated Since 1.10
	 */
	fnVersionCheck: DataTable.fnVersionCheck,


	/**
	 * Index for what 'this' index API functions should use
	 *  @type int
	 *  @deprecated Since v1.10
	 */
	iApiIndex: 0,


	/**
	 * Software version
	 *  @type string
	 *  @deprecated Since v1.10
	 */
	sVersion: DataTable.version
};


//
// Backwards compatibility. Alias to pre 1.10 Hungarian notation counter parts
//
$.extend( _ext, {
	afnFiltering: _ext.search,
	aTypes:       _ext.type.detect,
	ofnSearch:    _ext.type.search,
	oSort:        _ext.type.order,
	afnSortData:  _ext.order,
	aoFeatures:   _ext.feature,
	oStdClasses:  _ext.classes,
	oPagination:  _ext.pager
} );


$.extend( DataTable.ext.classes, {
	container: 'dt-container',
	empty: {
		row: 'dt-empty'
	},
	info: {
		container: 'dt-info'
	},
	length: {
		container: 'dt-length',
		select: 'dt-input'
	},
	order: {
		canAsc: 'dt-orderable-asc',
		canDesc: 'dt-orderable-desc',
		isAsc: 'dt-ordering-asc',
		isDesc: 'dt-ordering-desc',
		none: 'dt-orderable-none',
		position: 'sorting_'
	},
	processing: {
		container: 'dt-processing'
	},
	scrolling: {
		body: 'dt-scroll-body',
		container: 'dt-scroll',
		footer: {
			self: 'dt-scroll-foot',
			inner: 'dt-scroll-footInner'
		},
		header: {
			self: 'dt-scroll-head',
			inner: 'dt-scroll-headInner'
		}
	},
	search: {
		container: 'dt-search',
		input: 'dt-input'
	},
	table: 'dataTable',	
	tbody: {
		cell: '',
		row: ''
	},
	thead: {
		cell: '',
		row: ''
	},
	tfoot: {
		cell: '',
		row: ''
	},
	paging: {
		active: 'current',
		button: 'dt-paging-button',
		container: 'dt-paging',
		disabled: 'disabled'
	}
} );


var extPagination = DataTable.ext.pager;

// Paging buttons configuration
$.extend( extPagination, {
	simple: function () {
		return [ 'previous', 'next' ];
	},

	full: function () {
		return [  'first', 'previous', 'next', 'last' ];
	},

	numbers: function () {
		return [ 'numbers' ];
	},

	simple_numbers: function () {
		return [ 'previous', 'numbers', 'next' ];
	},

	full_numbers: function () {
		return [ 'first', 'previous', 'numbers', 'next', 'last' ];
	},
	
	first_last: function () {
		return ['first', 'last'];
	},
	
	first_last_numbers: function () {
		return ['first', 'numbers', 'last'];
	},

	// For testing and plug-ins to use
	_numbers: _pagingNumbers,

	// Number of number buttons - legacy, use `numbers` option for paging feature
	numbers_length: 7
} );


$.extend( true, DataTable.ext.renderer, {
	pagingButton: {
		_: function (settings, buttonType, content, active, disabled) {
			var classes = settings.oClasses.paging;
			var btnClasses = [classes.button];
			var btn;

			if (active) {
				btnClasses.push(classes.active);
			}

			if (disabled) {
				btnClasses.push(classes.disabled)
			}

			if (buttonType === 'ellipsis') {
				btn = $('<span class="ellipsis"></span>').html(content)[0];
			}
			else {
				btn = $('<button>', {
					class: btnClasses.join(' '),
					role: 'link',
					type: 'button'
				}).html(content);
			}

			return {
				display: btn,
				clicker: btn
			}
		}
	},

	pagingContainer: {
		_: function (settings, buttons) {
			// No wrapping element - just append directly to the host
			return buttons;
		}
	}
} );

// Common function to remove new lines, strip HTML and diacritic control
var _filterString = function (stripHtml, normalize) {
	return function (str) {
		if (_empty(str) || typeof str !== 'string') {
			return str;
		}

		str = str.replace( _re_new_lines, " " );

		if (stripHtml) {
			str = _stripHtml(str);
		}

		if (normalize) {
			str = _normalize(str, false);
		}

		return str;
	};
}

/*
 * Public helper functions. These aren't used internally by DataTables, or
 * called by any of the options passed into DataTables, but they can be used
 * externally by developers working with DataTables. They are helper functions
 * to make working with DataTables a little bit easier.
 */

function __mldFnName(name) {
	return name.replace(/[\W]/g, '_')
}

// Common logic for moment, luxon or a date action
function __mld( dt, momentFn, luxonFn, dateFn, arg1 ) {
	if (window.moment) {
		return dt[momentFn]( arg1 );
	}
	else if (window.luxon) {
		return dt[luxonFn]( arg1 );
	}
	
	return dateFn ? dt[dateFn]( arg1 ) : dt;
}


var __mlWarning = false;
function __mldObj (d, format, locale) {
	var dt;

	if (window.moment) {
		dt = window.moment.utc( d, format, locale, true );

		if (! dt.isValid()) {
			return null;
		}
	}
	else if (window.luxon) {
		dt = format && typeof d === 'string'
			? window.luxon.DateTime.fromFormat( d, format )
			: window.luxon.DateTime.fromISO( d );

		if (! dt.isValid) {
			return null;
		}

		dt.setLocale(locale);
	}
	else if (! format) {
		// No format given, must be ISO
		dt = new Date(d);
	}
	else {
		if (! __mlWarning) {
			alert('DataTables warning: Formatted date without Moment.js or Luxon - https://datatables.net/tn/17');
		}

		__mlWarning = true;
	}

	return dt;
}

// Wrapper for date, datetime and time which all operate the same way with the exception of
// the output string for auto locale support
function __mlHelper (localeString) {
	return function ( from, to, locale, def ) {
		// Luxon and Moment support
		// Argument shifting
		if ( arguments.length === 0 ) {
			locale = 'en';
			to = null; // means toLocaleString
			from = null; // means iso8601
		}
		else if ( arguments.length === 1 ) {
			locale = 'en';
			to = from;
			from = null;
		}
		else if ( arguments.length === 2 ) {
			locale = to;
			to = from;
			from = null;
		}

		var typeName = 'datetime' + (to ? '-' + __mldFnName(to) : '');

		// Add type detection and sorting specific to this date format - we need to be able to identify
		// date type columns as such, rather than as numbers in extensions. Hence the need for this.
		if (! DataTable.ext.type.order[typeName]) {
			DataTable.type(typeName, {
				detect: function (d) {
					// The renderer will give the value to type detect as the type!
					return d === typeName ? typeName : false;
				},
				order: {
					pre: function (d) {
						// The renderer gives us Moment, Luxon or Date obects for the sorting, all of which have a
						// `valueOf` which gives milliseconds epoch
						return d.valueOf();
					}
				},
				className: 'dt-right'
			});
		}
	
		return function ( d, type ) {
			// Allow for a default value
			if (d === null || d === undefined) {
				if (def === '--now') {
					// We treat everything as UTC further down, so no changes are
					// made, as such need to get the local date / time as if it were
					// UTC
					var local = new Date();
					d = new Date( Date.UTC(
						local.getFullYear(), local.getMonth(), local.getDate(),
						local.getHours(), local.getMinutes(), local.getSeconds()
					) );
				}
				else {
					d = '';
				}
			}

			if (type === 'type') {
				// Typing uses the type name for fast matching
				return typeName;
			}

			if (d === '') {
				return type !== 'sort'
					? ''
					: __mldObj('0000-01-01 00:00:00', null, locale);
			}

			// Shortcut. If `from` and `to` are the same, we are using the renderer to
			// format for ordering, not display - its already in the display format.
			if ( to !== null && from === to && type !== 'sort' && type !== 'type' && ! (d instanceof Date) ) {
				return d;
			}

			var dt = __mldObj(d, from, locale);

			if (dt === null) {
				return d;
			}

			if (type === 'sort') {
				return dt;
			}
			
			var formatted = to === null
				? __mld(dt, 'toDate', 'toJSDate', '')[localeString]()
				: __mld(dt, 'format', 'toFormat', 'toISOString', to);

			// XSS protection
			return type === 'display' ?
				_escapeHtml( formatted ) :
				formatted;
		};
	}
}

// Based on locale, determine standard number formatting
// Fallback for legacy browsers is US English
var __thousands = ',';
var __decimal = '.';

if (window.Intl !== undefined) {
	try {
		var num = new Intl.NumberFormat().formatToParts(100000.1);
	
		for (var i=0 ; i<num.length ; i++) {
			if (num[i].type === 'group') {
				__thousands = num[i].value;
			}
			else if (num[i].type === 'decimal') {
				__decimal = num[i].value;
			}
		}
	}
	catch (e) {
		// noop
	}
}

// Formatted date time detection - use by declaring the formats you are going to use
DataTable.datetime = function ( format, locale ) {
	var typeName = 'datetime-detect-' + __mldFnName(format);

	if (! locale) {
		locale = 'en';
	}

	if (! DataTable.ext.type.order[typeName]) {
		DataTable.type(typeName, {
			detect: function (d) {
				var dt = __mldObj(d, format, locale);
				return d === '' || dt ? typeName : false;
			},
			order: {
				pre: function (d) {
					return __mldObj(d, format, locale) || 0;
				}
			},
			className: 'dt-right'
		});
	}
}

/**
 * Helpers for `columns.render`.
 *
 * The options defined here can be used with the `columns.render` initialisation
 * option to provide a display renderer. The following functions are defined:
 *
 * * `moment` - Uses the MomentJS library to convert from a given format into another.
 * This renderer has three overloads:
 *   * 1 parameter:
 *     * `string` - Format to convert to (assumes input is ISO8601 and locale is `en`)
 *   * 2 parameters:
 *     * `string` - Format to convert from
 *     * `string` - Format to convert to. Assumes `en` locale
 *   * 3 parameters:
 *     * `string` - Format to convert from
 *     * `string` - Format to convert to
 *     * `string` - Locale
 * * `number` - Will format numeric data (defined by `columns.data`) for
 *   display, retaining the original unformatted data for sorting and filtering.
 *   It takes 5 parameters:
 *   * `string` - Thousands grouping separator
 *   * `string` - Decimal point indicator
 *   * `integer` - Number of decimal points to show
 *   * `string` (optional) - Prefix.
 *   * `string` (optional) - Postfix (/suffix).
 * * `text` - Escape HTML to help prevent XSS attacks. It has no optional
 *   parameters.
 *
 * @example
 *   // Column definition using the number renderer
 *   {
 *     data: "salary",
 *     render: $.fn.dataTable.render.number( '\'', '.', 0, '$' )
 *   }
 *
 * @namespace
 */
DataTable.render = {
	date: __mlHelper('toLocaleDateString'),
	datetime: __mlHelper('toLocaleString'),
	time: __mlHelper('toLocaleTimeString'),
	number: function ( thousands, decimal, precision, prefix, postfix ) {
		// Auto locale detection
		if (thousands === null || thousands === undefined) {
			thousands = __thousands;
		}

		if (decimal === null || decimal === undefined) {
			decimal = __decimal;
		}

		return {
			display: function ( d ) {
				if ( typeof d !== 'number' && typeof d !== 'string' ) {
					return d;
				}

				if (d === '' || d === null) {
					return d;
				}

				var negative = d < 0 ? '-' : '';
				var flo = parseFloat( d );
				var abs = Math.abs(flo);

				// Scientific notation for large and small numbers
				if (abs >= 100000000000 || (abs < 0.0001 && abs !== 0) ) {
					var exp = flo.toExponential(precision).split(/e\+?/);
					return exp[0] + ' x 10<sup>' + exp[1] + '</sup>';
				}

				// If NaN then there isn't much formatting that we can do - just
				// return immediately, escaping any HTML (this was supposed to
				// be a number after all)
				if ( isNaN( flo ) ) {
					return _escapeHtml( d );
				}

				flo = flo.toFixed( precision );
				d = Math.abs( flo );

				var intPart = parseInt( d, 10 );
				var floatPart = precision ?
					decimal+(d - intPart).toFixed( precision ).substring( 2 ):
					'';

				// If zero, then can't have a negative prefix
				if (intPart === 0 && parseFloat(floatPart) === 0) {
					negative = '';
				}

				return negative + (prefix||'') +
					intPart.toString().replace(
						/\B(?=(\d{3})+(?!\d))/g, thousands
					) +
					floatPart +
					(postfix||'');
			}
		};
	},

	text: function () {
		return {
			display: _escapeHtml,
			filter: _escapeHtml
		};
	}
};


var _extTypes = DataTable.ext.type;

// Get / set type
DataTable.type = function (name, prop, val) {
	if (! prop) {
		return {
			className: _extTypes.className[name],
			detect: _extTypes.detect.find(function (fn) {
				return fn.name === name;
			}),
			order: {
				pre: _extTypes.order[name + '-pre'],
				asc: _extTypes.order[name + '-asc'],
				desc: _extTypes.order[name + '-desc']
			},
			render: _extTypes.render[name],
			search: _extTypes.search[name]
		};
	}

	var setProp = function(prop, propVal) {
		_extTypes[prop][name] = propVal;
	};
	var setDetect = function (fn) {
		// Wrap to allow the function to return `true` rather than
		// specifying the type name.
		var cb = function (d, s) {
			var ret = fn(d, s);

			return ret === true
				? name
				: ret;
		};
		Object.defineProperty(cb, "name", {value: name});

		var idx = _extTypes.detect.findIndex(function (fn) {
			return fn.name === name;
		});

		if (idx === -1) {
			_extTypes.detect.unshift(cb);
		}
		else {
			_extTypes.detect.splice(idx, 1, cb);
		}
	};
	var setOrder = function (obj) {
		_extTypes.order[name + '-pre'] = obj.pre; // can be undefined
		_extTypes.order[name + '-asc'] = obj.asc; // can be undefined
		_extTypes.order[name + '-desc'] = obj.desc; // can be undefined
	};

	// prop is optional
	if (val === undefined) {
		val = prop;
		prop = null;
	}

	if (prop === 'className') {
		setProp('className', val);
	}
	else if (prop === 'detect') {
		setDetect(val);
	}
	else if (prop === 'order') {
		setOrder(val);
	}
	else if (prop === 'render') {
		setProp('render', val);
	}
	else if (prop === 'search') {
		setProp('search', val);
	}
	else if (! prop) {
		if (val.className) {
			setProp('className', val.className);
		}

		if (val.detect !== undefined) {
			setDetect(val.detect);
		}

		if (val.order) {
			setOrder(val.order);
		}

		if (val.render !== undefined) {
			setProp('render', val.render);
		}

		if (val.search !== undefined) {
			setProp('search', val.search);
		}
	}
}

// Get a list of types
DataTable.types = function () {
	return _extTypes.detect.map(function (fn) {
		return fn.name;
	});
};

//
// Built in data types
//

DataTable.type('string', {
	detect: function () {
		return 'string';
	},
	order: {
		pre: function ( a ) {
			// This is a little complex, but faster than always calling toString,
			// http://jsperf.com/tostring-v-check
			return _empty(a) ?
				'' :
				typeof a === 'string' ?
					a.toLowerCase() :
					! a.toString ?
						'' :
						a.toString();
		}
	},
	search: _filterString(false, true)
});


DataTable.type('html', {
	detect: function ( d ) {
		return _empty( d ) || (typeof d === 'string' && d.indexOf('<') !== -1) ?
			'html' : null;
	},
	order: {
		pre: function ( a ) {
			return _empty(a) ?
				'' :
				a.replace ?
					_stripHtml(a).trim().toLowerCase() :
					a+'';
		}
	},
	search: _filterString(true, true)
});


DataTable.type('date', {
	className: 'dt-type-date',
	detect: function ( d )
	{
		// V8 tries _very_ hard to make a string passed into `Date.parse()`
		// valid, so we need to use a regex to restrict date formats. Use a
		// plug-in for anything other than ISO8601 style strings
		if ( d && !(d instanceof Date) && ! _re_date.test(d) ) {
			return null;
		}
		var parsed = Date.parse(d);
		return (parsed !== null && !isNaN(parsed)) || _empty(d) ? 'date' : null;
	},
	order: {
		pre: function ( d ) {
			var ts = Date.parse( d );
			return isNaN(ts) ? -Infinity : ts;
		}
	}
});


DataTable.type('html-num-fmt', {
	className: 'dt-type-numeric',
	detect: function ( d, settings )
	{
		var decimal = settings.oLanguage.sDecimal;
		return _htmlNumeric( d, decimal, true ) ? 'html-num-fmt' : null;
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_html, _re_formatted_numeric );
		}
	},
	search: _filterString(true, true)
});


DataTable.type('html-num', {
	className: 'dt-type-numeric',
	detect: function ( d, settings )
	{
		var decimal = settings.oLanguage.sDecimal;
		return _htmlNumeric( d, decimal ) ? 'html-num' : null;
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_html );
		}
	},
	search: _filterString(true, true)
});


DataTable.type('num-fmt', {
	className: 'dt-type-numeric',
	detect: function ( d, settings )
	{
		var decimal = settings.oLanguage.sDecimal;
		return _isNumber( d, decimal, true ) ? 'num-fmt' : null;
	},
	order: {
		pre: function ( d, s ) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp, _re_formatted_numeric );
		}
	}
});


DataTable.type('num', {
	className: 'dt-type-numeric',
	detect: function ( d, settings )
	{
		var decimal = settings.oLanguage.sDecimal;
		return _isNumber( d, decimal ) ? 'num' : null;
	},
	order: {
		pre: function (d, s) {
			var dp = s.oLanguage.sDecimal;
			return __numericReplace( d, dp );
		}
	}
});




var __numericReplace = function ( d, decimalPlace, re1, re2 ) {
	if ( d !== 0 && (!d || d === '-') ) {
		return -Infinity;
	}
	
	var type = typeof d;

	if (type === 'number' || type === 'bigint') {
		return d;
	}

	// If a decimal place other than `.` is used, it needs to be given to the
	// function so we can detect it and replace with a `.` which is the only
	// decimal place Javascript recognises - it is not locale aware.
	if ( decimalPlace ) {
		d = _numToDecimal( d, decimalPlace );
	}

	if ( d.replace ) {
		if ( re1 ) {
			d = d.replace( re1, '' );
		}

		if ( re2 ) {
			d = d.replace( re2, '' );
		}
	}

	return d * 1;
};


$.extend( true, DataTable.ext.renderer, {
	footer: {
		_: function ( settings, cell, classes ) {
			cell.addClass(classes.tfoot.cell);
		}
	},

	header: {
		_: function ( settings, cell, classes ) {
			cell.addClass(classes.thead.cell);

			if (! settings.oFeatures.bSort) {
				cell.addClass(classes.order.none);
			}

			var legacyTop = settings.bSortCellsTop;
			var headerRows = cell.closest('thead').find('tr');
			var rowIdx = cell.parent().index();

			// Conditions to not apply the ordering icons
			if (
				// Cells and rows which have the attribute to disable the icons
				cell.attr('data-dt-order') === 'disable' ||
				cell.parent().attr('data-dt-order') === 'disable' ||

				// Legacy support for `orderCellsTop`. If it is set, then cells
				// which are not in the top or bottom row of the header (depending
				// on the value) do not get the sorting classes applied to them
				(legacyTop === true && rowIdx !== 0) ||
				(legacyTop === false && rowIdx !== headerRows.length - 1)
			) {
				return;
			}

			// No additional mark-up required
			// Attach a sort listener to update on sort - note that using the
			// `DT` namespace will allow the event to be removed automatically
			// on destroy, while the `dt` namespaced event is the one we are
			// listening for
			$(settings.nTable).on( 'order.dt.DT', function ( e, ctx, sorting ) {
				if ( settings !== ctx ) { // need to check this this is the host
					return;               // table, not a nested one
				}

				var orderClasses = classes.order;
				var columns = ctx.api.columns( cell );
				var col = settings.aoColumns[columns.flatten()[0]];
				var orderable = columns.orderable().includes(true);
				var ariaType = '';
				var indexes = columns.indexes();
				var sortDirs = columns.orderable(true).flatten();
				var orderedColumns = ',' + sorting.map( function (val) {
					return val.col;
				} ).join(',') + ',';

				cell
					.removeClass(
						orderClasses.isAsc +' '+
						orderClasses.isDesc
					)
					.toggleClass( orderClasses.none, ! orderable )
					.toggleClass( orderClasses.canAsc, orderable && sortDirs.includes('asc') )
					.toggleClass( orderClasses.canDesc, orderable && sortDirs.includes('desc') );
				
				var sortIdx = orderedColumns.indexOf( ',' + indexes.toArray().join(',') + ',' );

				if ( sortIdx !== -1 ) {
					// Get the ordering direction for the columns under this cell
					// Note that it is possible for a cell to be asc and desc sorting
					// (column spanning cells)
					var orderDirs = columns.order();

					cell.addClass(
						orderDirs.includes('asc') ? orderClasses.isAsc : '' +
						orderDirs.includes('desc') ? orderClasses.isDesc : ''
					);
				}

				// The ARIA spec says that only one column should be marked with aria-sort
				if ( sortIdx === 0 ) {
					var firstSort = sorting[0];
					var sortOrder = col.asSorting;

					cell.attr('aria-sort', firstSort.dir === 'asc' ? 'ascending' : 'descending');

					// Determine if the next click will remove sorting or change the sort
					ariaType = ! sortOrder[firstSort.index + 1] ? 'Remove' : 'Reverse';
				}
				else {
					cell.removeAttr('aria-sort');
				}

				cell.attr('aria-label', orderable
					? col.ariaTitle + ctx.api.i18n('oAria.orderable' + ariaType)
					: col.ariaTitle
				);

				if (orderable) {
					cell.find('.dt-column-title').attr('role', 'button');
					cell.attr('tabindex', 0)
				}
			} );
		}
	},

	layout: {
		_: function ( settings, container, items ) {
			var row = $('<div/>')
				.addClass('dt-layout-row')
				.appendTo( container );

			$.each( items, function (key, val) {
				var klass = ! val.table ?
					'dt-'+key+' ' :
					'';

				if (val.table) {
					row.addClass('dt-layout-table');
				}

				$('<div/>')
					.attr({
						id: val.id || null,
						"class": 'dt-layout-cell '+klass+(val.className || '')
					})
					.append( val.contents )
					.appendTo( row );
			} );
		}
	}
} );


DataTable.feature = {};

// Third parameter is internal only!
DataTable.feature.register = function ( name, cb, legacy ) {
	DataTable.ext.features[ name ] = cb;

	if (legacy) {
		_ext.feature.push({
			cFeature: legacy,
			fnInit: cb
		});
	}
};

DataTable.feature.register( 'info', function ( settings, opts ) {
	// For compatibility with the legacy `info` top level option
	if (! settings.oFeatures.bInfo) {
		return null;
	}

	var
		lang  = settings.oLanguage,
		tid = settings.sTableId,
		n = $('<div/>', {
			'class': settings.oClasses.info.container,
		} );

	opts = $.extend({
		callback: lang.fnInfoCallback,
		empty: lang.sInfoEmpty,
		postfix: lang.sInfoPostFix,
		search: lang.sInfoFiltered,
		text: lang.sInfo,
	}, opts);


	// Update display on each draw
	settings.aoDrawCallback.push(function (s) {
		_fnUpdateInfo(s, opts, n);
	});

	// For the first info display in the table, we add a callback and aria information.
	if (! $('#' + tid+'_info', settings.nWrapper).length) {
		n.attr({
			'aria-live': 'polite',
			id: tid+'_info',
			role: 'status'
		});

		// Table is described by our info div
		$(settings.nTable).attr( 'aria-describedby', tid+'_info' );
	}

	return n;
}, 'i' );

/**
 * Update the information elements in the display
 *  @param {object} settings dataTables settings object
 *  @memberof DataTable#oApi
 */
function _fnUpdateInfo ( settings, opts, node )
{
	var
		start = settings._iDisplayStart+1,
		end   = settings.fnDisplayEnd(),
		max   = settings.fnRecordsTotal(),
		total = settings.fnRecordsDisplay(),
		out   = total
			? opts.text
			: opts.empty;

	if ( total !== max ) {
		// Record set after filtering
		out += ' ' + opts.search;
	}

	// Convert the macros
	out += opts.postfix;
	out = _fnMacros( settings, out );

	if ( opts.callback ) {
		out = opts.callback.call( settings.oInstance,
			settings, start, end, max, total, out
		);
	}

	node.html( out );

	_fnCallbackFire(settings, null, 'info', [settings, node[0], out]);
}

var __searchCounter = 0;

// opts
// - text
// - placeholder
DataTable.feature.register( 'search', function ( settings, opts ) {
	// Don't show the input if filtering isn't available on the table
	if (! settings.oFeatures.bFilter) {
		return null;
	}

	var classes = settings.oClasses.search;
	var tableId = settings.sTableId;
	var language = settings.oLanguage;
	var previousSearch = settings.oPreviousSearch;
	var input = '<input type="search" class="'+classes.input+'"/>';

	opts = $.extend({
		placeholder: language.sSearchPlaceholder,
		text: language.sSearch
	}, opts);

	// The _INPUT_ is optional - is appended if not present
	if (opts.text.indexOf('_INPUT_') === -1) {
		opts.text += '_INPUT_';
	}

	opts.text = _fnMacros(settings, opts.text);

	// We can put the <input> outside of the label if it is at the start or end
	// which helps improve accessability (not all screen readers like implicit
	// for elements).
	var end = opts.text.match(/_INPUT_$/);
	var start = opts.text.match(/^_INPUT_/);
	var removed = opts.text.replace(/_INPUT_/, '');
	var str = '<label>' + opts.text + '</label>';

	if (start) {
		str = '_INPUT_<label>' + removed + '</label>';
	}
	else if (end) {
		str = '<label>' + removed + '</label>_INPUT_';
	}

	var filter = $('<div>')
		.addClass(classes.container)
		.append(str.replace(/_INPUT_/, input));

	// add for and id to label and input
	filter.find('label').attr('for', 'dt-search-' + __searchCounter);
	filter.find('input').attr('id', 'dt-search-' + __searchCounter);
	__searchCounter++;

	var searchFn = function(event) {
		var val = this.value;

		if(previousSearch.return && event.key !== "Enter") {
			return;
		}

		/* Now do the filter */
		if ( val != previousSearch.search ) {
			previousSearch.search = val;

			_fnFilterComplete( settings, previousSearch );

			// Need to redraw, without resorting
			settings._iDisplayStart = 0;
			_fnDraw( settings );
		}
	};

	var searchDelay = settings.searchDelay !== null ?
		settings.searchDelay :
		0;

	var jqFilter = $('input', filter)
		.val( previousSearch.search )
		.attr( 'placeholder', opts.placeholder )
		.on(
			'keyup.DT search.DT input.DT paste.DT cut.DT',
			searchDelay ?
				DataTable.util.debounce( searchFn, searchDelay ) :
				searchFn
		)
		.on( 'mouseup.DT', function(e) {
			// Edge fix! Edge 17 does not trigger anything other than mouse events when clicking
			// on the clear icon (Edge bug 17584515). This is safe in other browsers as `searchFn`
			// checks the value to see if it has changed. In other browsers it won't have.
			setTimeout( function () {
				searchFn.call(jqFilter[0], e);
			}, 10);
		} )
		.on( 'keypress.DT', function(e) {
			/* Prevent form submission */
			if ( e.keyCode == 13 ) {
				return false;
			}
		} )
		.attr('aria-controls', tableId);

	// Update the input elements whenever the table is filtered
	$(settings.nTable).on( 'search.dt.DT', function ( ev, s ) {
		if ( settings === s && jqFilter[0] !== document.activeElement ) {
			jqFilter.val( typeof previousSearch.search !== 'function'
				? previousSearch.search
				: ''
			);
		}
	} );

	return filter;
}, 'f' );

// opts
// - type - button configuration
// - numbers - number of buttons to show - must be odd
DataTable.feature.register( 'paging', function ( settings, opts ) {
	// Don't show the paging input if the table doesn't have paging enabled
	if (! settings.oFeatures.bPaginate) {
		return null;
	}

	opts = $.extend({
		numbers: DataTable.ext.pager.numbers_length,
		type: settings.sPaginationType
	}, opts)

	var host = $('<div/>').addClass( settings.oClasses.paging.container + ' paging_' + opts.type );
	var draw = function () {
		_pagingDraw(settings, host, opts);
	};

	settings.aoDrawCallback.push(draw);

	// Responsive redraw of paging control
	$(settings.nTable).on('column-sizing.dt.DT', draw);

	return host;
}, 'p' );

function _pagingDraw(settings, host, opts) {
	if (! settings._bInitComplete) {
		return;
	}

	var
		plugin = DataTable.ext.pager[ opts.type ],
		aria = settings.oLanguage.oAria.paginate || {},
		start      = settings._iDisplayStart,
		len        = settings._iDisplayLength,
		visRecords = settings.fnRecordsDisplay(),
		all        = len === -1,
		page = all ? 0 : Math.ceil( start / len ),
		pages = all ? 1 : Math.ceil( visRecords / len ),
		buttons = plugin()
			.map(function (val) {
				return val === 'numbers'
					? _pagingNumbers(page, pages, opts.numbers)
					: val;
			})
			.flat();

	var buttonEls = [];

	for (var i=0 ; i<buttons.length ; i++) {
		var button = buttons[i];

		var btnInfo = _pagingButtonInfo(settings, button, page, pages);
		var btn = _fnRenderer( settings, 'pagingButton' )(
			settings,
			button,
			btnInfo.display,
			btnInfo.active,
			btnInfo.disabled
		);

		// Common attributes
		$(btn.clicker).attr({
			'aria-controls': settings.sTableId,
			'aria-disabled': btnInfo.disabled ? 'true' : null,
			'aria-current': btnInfo.active ? 'page' : null,
			'aria-label': aria[ button ],
			'data-dt-idx': button,
			'tabIndex': btnInfo.disabled ? -1 : settings.iTabIndex,
		});

		if (typeof button !== 'number') {
			$(btn.clicker).addClass(button);
		}

		_fnBindAction(
			btn.clicker, {action: button}, function(e) {
				e.preventDefault();

				_fnPageChange( settings, e.data.action, true );
			}
		);

		buttonEls.push(btn.display);
	}

	var wrapped = _fnRenderer(settings, 'pagingContainer')(
		settings, buttonEls
	);

	var activeEl = host.find(document.activeElement).data('dt-idx');

	host.empty().append(wrapped);

	if ( activeEl !== undefined ) {
		host.find( '[data-dt-idx='+activeEl+']' ).trigger('focus');
	}

	// Responsive - check if the buttons are over two lines based on the
	// height of the buttons and the container.
	if (
		buttonEls.length && // any buttons
		opts.numbers > 1 && // prevent infinite
		$(host).height() >= ($(buttonEls[0]).outerHeight() * 2) - 10
	) {
		_pagingDraw(settings, host, $.extend({}, opts, { numbers: opts.numbers - 2 }));
	}
}

/**
 * Get properties for a button based on the current paging state of the table
 *
 * @param {*} settings DT settings object
 * @param {*} button The button type in question
 * @param {*} page Table's current page
 * @param {*} pages Number of pages
 * @returns Info object
 */
function _pagingButtonInfo(settings, button, page, pages) {
	var lang = settings.oLanguage.oPaginate;
	var o = {
		display: '',
		active: false,
		disabled: false
	};

	switch ( button ) {
		case 'ellipsis':
			o.display = '&#x2026;';
			o.disabled = true;
			break;

		case 'first':
			o.display = lang.sFirst;

			if (page === 0) {
				o.disabled = true;
			}
			break;

		case 'previous':
			o.display = lang.sPrevious;

			if ( page === 0 ) {
				o.disabled = true;
			}
			break;

		case 'next':
			o.display = lang.sNext;

			if ( pages === 0 || page === pages-1 ) {
				o.disabled = true;
			}
			break;

		case 'last':
			o.display = lang.sLast;

			if ( pages === 0 || page === pages-1 ) {
				o.disabled = true;
			}
			break;

		default:
			if ( typeof button === 'number' ) {
				o.display = settings.fnFormatNumber( button + 1 );
				
				if (page === button) {
					o.active = true;
				}
			}
			break;
	}

	return o;
}

/**
 * Compute what number buttons to show in the paging control
 *
 * @param {*} page Current page
 * @param {*} pages Total number of pages
 * @param {*} buttons Target number of number buttons
 * @returns Buttons to show
 */
function _pagingNumbers ( page, pages, buttons ) {
	var
		numbers = [],
		half = Math.floor(buttons / 2);

	if ( pages <= buttons ) {
		numbers = _range(0, pages);
	}
	else if (buttons === 1) {
		// Single button - current page only
		numbers = [page];
	}
	else if (buttons === 3) {
		// Special logic for just three buttons
		if (page <= 1) {
			numbers = [0, 1, 'ellipsis'];
		}
		else if (page >= pages - 2) {
			numbers = _range(pages-2, pages);
			numbers.unshift('ellipsis');
		}
		else {
			numbers = ['ellipsis', page, 'ellipsis'];
		}
	}
	else if ( page <= half ) {
		numbers = _range(0, buttons-2);
		numbers.push('ellipsis', pages-1);
	}
	else if ( page >= pages - 1 - half ) {
		numbers = _range(pages-(buttons-2), pages);
		numbers.unshift(0, 'ellipsis');
	}
	else {
		numbers = _range(page-half+2, page+half-1);
		numbers.push('ellipsis', pages-1);
		numbers.unshift(0, 'ellipsis');
	}

	return numbers;
}

var __lengthCounter = 0;

// opts
// - menu
// - text
DataTable.feature.register( 'pageLength', function ( settings, opts ) {
	var features = settings.oFeatures;

	// For compatibility with the legacy `pageLength` top level option
	if (! features.bPaginate || ! features.bLengthChange) {
		return null;
	}

	opts = $.extend({
		menu: settings.aLengthMenu,
		text: settings.oLanguage.sLengthMenu
	}, opts);

	var
		classes  = settings.oClasses.length,
		tableId  = settings.sTableId,
		menu     = opts.menu,
		lengths  = [],
		language = [],
		i;

	// Options can be given in a number of ways
	if (Array.isArray( menu[0] )) {
		// Old 1.x style - 2D array
		lengths = menu[0];
		language = menu[1];
	}
	else {
		for ( i=0 ; i<menu.length ; i++ ) {
			// An object with different label and value
			if ($.isPlainObject(menu[i])) {
				lengths.push(menu[i].value);
				language.push(menu[i].label);
			}
			else {
				// Or just a number to display and use
				lengths.push(menu[i]);
				language.push(menu[i]);
			}
		}
	}

	// We can put the <select> outside of the label if it is at the start or
	// end which helps improve accessability (not all screen readers like
	// implicit for elements).
	var end = opts.text.match(/_MENU_$/);
	var start = opts.text.match(/^_MENU_/);
	var removed = opts.text.replace(/_MENU_/, '');
	var str = '<label>' + opts.text + '</label>';

	if (start) {
		str = '_MENU_<label>' + removed + '</label>';
	}
	else if (end) {
		str = '<label>' + removed + '</label>_MENU_';
	}

	// Wrapper element - use a span as a holder for where the select will go
	var div = $('<div/>')
		.addClass( classes.container )
		.append(
			str.replace( '_MENU_', '<span></span>' )
		);

	// Save text node content for macro updating
	var textNodes = [];
	div.find('label')[0].childNodes.forEach(function (el) {
		if (el.nodeType === Node.TEXT_NODE) {
			textNodes.push({
				el: el,
				text: el.textContent
			});
		}
	})

	// Update the label text in case it has an entries value
	var updateEntries = function (len) {
		textNodes.forEach(function (node) {
			node.el.textContent = _fnMacros(settings, node.text, len);
		});
	}

	// Next, the select itself, along with the options
	var select = $('<select/>', {
		'name':          tableId+'_length',
		'aria-controls': tableId,
		'class':         classes.select
	} );

	for ( i=0 ; i<lengths.length ; i++ ) {
		select[0][ i ] = new Option(
			typeof language[i] === 'number' ?
				settings.fnFormatNumber( language[i] ) :
				language[i],
			lengths[i]
		);
	}

	// add for and id to label and input
	div.find('label').attr('for', 'dt-length-' + __lengthCounter);
	select.attr('id', 'dt-length-' + __lengthCounter);
	__lengthCounter++;

	// Swap in the select list
	div.find('span').replaceWith(select);

	// Can't use `select` variable as user might provide their own and the
	// reference is broken by the use of outerHTML
	$('select', div)
		.val( settings._iDisplayLength )
		.on( 'change.DT', function() {
			_fnLengthChange( settings, $(this).val() );
			_fnDraw( settings );
		} );

	// Update node value whenever anything changes the table's length
	$(settings.nTable).on( 'length.dt.DT', function (e, s, len) {
		if ( settings === s ) {
			$('select', div).val( len );

			// Resolve plurals in the text for the new length
			updateEntries(len);
		}
	} );

	updateEntries(settings._iDisplayLength);

	return div;
}, 'l' );

// jQuery access
$.fn.dataTable = DataTable;

// Provide access to the host jQuery object (circular reference)
DataTable.$ = $;

// Legacy aliases
$.fn.dataTableSettings = DataTable.settings;
$.fn.dataTableExt = DataTable.ext;

// With a capital `D` we return a DataTables API instance rather than a
// jQuery object
$.fn.DataTable = function ( opts ) {
	return $(this).dataTable( opts ).api();
};

// All properties that are available to $.fn.dataTable should also be
// available on $.fn.DataTable
$.each( DataTable, function ( prop, val ) {
	$.fn.DataTable[ prop ] = val;
} );

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DataTable);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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