"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_hotwired_turbo_dist_turbo_es2017-esm_js"],{

/***/ "./node_modules/@hotwired/turbo/dist/turbo.es2017-esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@hotwired/turbo/dist/turbo.es2017-esm.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FetchEnctype: () => (/* binding */ FetchEnctype),
/* harmony export */   FetchMethod: () => (/* binding */ FetchMethod),
/* harmony export */   FetchRequest: () => (/* binding */ FetchRequest),
/* harmony export */   FetchResponse: () => (/* binding */ FetchResponse),
/* harmony export */   FrameElement: () => (/* binding */ FrameElement),
/* harmony export */   FrameLoadingStyle: () => (/* binding */ FrameLoadingStyle),
/* harmony export */   FrameRenderer: () => (/* binding */ FrameRenderer),
/* harmony export */   PageRenderer: () => (/* binding */ PageRenderer),
/* harmony export */   PageSnapshot: () => (/* binding */ PageSnapshot),
/* harmony export */   StreamActions: () => (/* binding */ StreamActions),
/* harmony export */   StreamElement: () => (/* binding */ StreamElement),
/* harmony export */   StreamSourceElement: () => (/* binding */ StreamSourceElement),
/* harmony export */   cache: () => (/* binding */ cache),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   connectStreamSource: () => (/* binding */ connectStreamSource),
/* harmony export */   disconnectStreamSource: () => (/* binding */ disconnectStreamSource),
/* harmony export */   fetch: () => (/* binding */ fetchWithTurboHeaders),
/* harmony export */   fetchEnctypeFromString: () => (/* binding */ fetchEnctypeFromString),
/* harmony export */   fetchMethodFromString: () => (/* binding */ fetchMethodFromString),
/* harmony export */   isSafe: () => (/* binding */ isSafe),
/* harmony export */   navigator: () => (/* binding */ navigator$1),
/* harmony export */   registerAdapter: () => (/* binding */ registerAdapter),
/* harmony export */   renderStreamMessage: () => (/* binding */ renderStreamMessage),
/* harmony export */   session: () => (/* binding */ session),
/* harmony export */   setConfirmMethod: () => (/* binding */ setConfirmMethod),
/* harmony export */   setFormMode: () => (/* binding */ setFormMode),
/* harmony export */   setProgressBarDelay: () => (/* binding */ setProgressBarDelay),
/* harmony export */   start: () => (/* binding */ start),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/*!
Turbo 8.0.4
Copyright © 2024 37signals LLC
 */
/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2019 Javan Makhmali
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

(function (prototype) {
  if (typeof prototype.requestSubmit == "function") return

  prototype.requestSubmit = function (submitter) {
    if (submitter) {
      validateSubmitter(submitter, this);
      submitter.click();
    } else {
      submitter = document.createElement("input");
      submitter.type = "submit";
      submitter.hidden = true;
      this.appendChild(submitter);
      submitter.click();
      this.removeChild(submitter);
    }
  };

  function validateSubmitter(submitter, form) {
    submitter instanceof HTMLElement || raise(TypeError, "parameter 1 is not of type 'HTMLElement'");
    submitter.type == "submit" || raise(TypeError, "The specified element is not a submit button");
    submitter.form == form ||
      raise(DOMException, "The specified element is not owned by this form element", "NotFoundError");
  }

  function raise(errorConstructor, message, name) {
    throw new errorConstructor("Failed to execute 'requestSubmit' on 'HTMLFormElement': " + message + ".", name)
  }
})(HTMLFormElement.prototype);

const submittersByForm = new WeakMap();

function findSubmitterFromClickTarget(target) {
  const element = target instanceof Element ? target : target instanceof Node ? target.parentElement : null;
  const candidate = element ? element.closest("input, button") : null;
  return candidate?.type == "submit" ? candidate : null
}

function clickCaptured(event) {
  const submitter = findSubmitterFromClickTarget(event.target);

  if (submitter && submitter.form) {
    submittersByForm.set(submitter.form, submitter);
  }
}

(function () {
  if ("submitter" in Event.prototype) return

  let prototype = window.Event.prototype;
  // Certain versions of Safari 15 have a bug where they won't
  // populate the submitter. This hurts TurboDrive's enable/disable detection.
  // See https://bugs.webkit.org/show_bug.cgi?id=229660
  if ("SubmitEvent" in window) {
    const prototypeOfSubmitEvent = window.SubmitEvent.prototype;

    if (/Apple Computer/.test(navigator.vendor) && !("submitter" in prototypeOfSubmitEvent)) {
      prototype = prototypeOfSubmitEvent;
    } else {
      return // polyfill not needed
    }
  }

  addEventListener("click", clickCaptured, true);

  Object.defineProperty(prototype, "submitter", {
    get() {
      if (this.type == "submit" && this.target instanceof HTMLFormElement) {
        return submittersByForm.get(this.target)
      }
    }
  });
})();

const FrameLoadingStyle = {
  eager: "eager",
  lazy: "lazy"
};

/**
 * Contains a fragment of HTML which is updated based on navigation within
 * it (e.g. via links or form submissions).
 *
 * @customElement turbo-frame
 * @example
 *   <turbo-frame id="messages">
 *     <a href="/messages/expanded">
 *       Show all expanded messages in this frame.
 *     </a>
 *
 *     <form action="/messages">
 *       Show response from this form within this frame.
 *     </form>
 *   </turbo-frame>
 */
class FrameElement extends HTMLElement {
  static delegateConstructor = undefined

  loaded = Promise.resolve()

  static get observedAttributes() {
    return ["disabled", "loading", "src"]
  }

  constructor() {
    super();
    this.delegate = new FrameElement.delegateConstructor(this);
  }

  connectedCallback() {
    this.delegate.connect();
  }

  disconnectedCallback() {
    this.delegate.disconnect();
  }

  reload() {
    return this.delegate.sourceURLReloaded()
  }

  attributeChangedCallback(name) {
    if (name == "loading") {
      this.delegate.loadingStyleChanged();
    } else if (name == "src") {
      this.delegate.sourceURLChanged();
    } else if (name == "disabled") {
      this.delegate.disabledChanged();
    }
  }

  /**
   * Gets the URL to lazily load source HTML from
   */
  get src() {
    return this.getAttribute("src")
  }

  /**
   * Sets the URL to lazily load source HTML from
   */
  set src(value) {
    if (value) {
      this.setAttribute("src", value);
    } else {
      this.removeAttribute("src");
    }
  }

  /**
   * Gets the refresh mode for the frame.
   */
  get refresh() {
    return this.getAttribute("refresh")
  }

  /**
   * Sets the refresh mode for the frame.
   */
  set refresh(value) {
    if (value) {
      this.setAttribute("refresh", value);
    } else {
      this.removeAttribute("refresh");
    }
  }

  /**
   * Determines if the element is loading
   */
  get loading() {
    return frameLoadingStyleFromString(this.getAttribute("loading") || "")
  }

  /**
   * Sets the value of if the element is loading
   */
  set loading(value) {
    if (value) {
      this.setAttribute("loading", value);
    } else {
      this.removeAttribute("loading");
    }
  }

  /**
   * Gets the disabled state of the frame.
   *
   * If disabled, no requests will be intercepted by the frame.
   */
  get disabled() {
    return this.hasAttribute("disabled")
  }

  /**
   * Sets the disabled state of the frame.
   *
   * If disabled, no requests will be intercepted by the frame.
   */
  set disabled(value) {
    if (value) {
      this.setAttribute("disabled", "");
    } else {
      this.removeAttribute("disabled");
    }
  }

  /**
   * Gets the autoscroll state of the frame.
   *
   * If true, the frame will be scrolled into view automatically on update.
   */
  get autoscroll() {
    return this.hasAttribute("autoscroll")
  }

  /**
   * Sets the autoscroll state of the frame.
   *
   * If true, the frame will be scrolled into view automatically on update.
   */
  set autoscroll(value) {
    if (value) {
      this.setAttribute("autoscroll", "");
    } else {
      this.removeAttribute("autoscroll");
    }
  }

  /**
   * Determines if the element has finished loading
   */
  get complete() {
    return !this.delegate.isLoading
  }

  /**
   * Gets the active state of the frame.
   *
   * If inactive, source changes will not be observed.
   */
  get isActive() {
    return this.ownerDocument === document && !this.isPreview
  }

  /**
   * Sets the active state of the frame.
   *
   * If inactive, source changes will not be observed.
   */
  get isPreview() {
    return this.ownerDocument?.documentElement?.hasAttribute("data-turbo-preview")
  }
}

function frameLoadingStyleFromString(style) {
  switch (style.toLowerCase()) {
    case "lazy":
      return FrameLoadingStyle.lazy
    default:
      return FrameLoadingStyle.eager
  }
}

function expandURL(locatable) {
  return new URL(locatable.toString(), document.baseURI)
}

function getAnchor(url) {
  let anchorMatch;
  if (url.hash) {
    return url.hash.slice(1)
    // eslint-disable-next-line no-cond-assign
  } else if ((anchorMatch = url.href.match(/#(.*)$/))) {
    return anchorMatch[1]
  }
}

function getAction$1(form, submitter) {
  const action = submitter?.getAttribute("formaction") || form.getAttribute("action") || form.action;

  return expandURL(action)
}

function getExtension(url) {
  return (getLastPathComponent(url).match(/\.[^.]*$/) || [])[0] || ""
}

function isHTML(url) {
  return !!getExtension(url).match(/^(?:|\.(?:htm|html|xhtml|php))$/)
}

function isPrefixedBy(baseURL, url) {
  const prefix = getPrefix(url);
  return baseURL.href === expandURL(prefix).href || baseURL.href.startsWith(prefix)
}

function locationIsVisitable(location, rootLocation) {
  return isPrefixedBy(location, rootLocation) && isHTML(location)
}

function getRequestURL(url) {
  const anchor = getAnchor(url);
  return anchor != null ? url.href.slice(0, -(anchor.length + 1)) : url.href
}

function toCacheKey(url) {
  return getRequestURL(url)
}

function urlsAreEqual(left, right) {
  return expandURL(left).href == expandURL(right).href
}

function getPathComponents(url) {
  return url.pathname.split("/").slice(1)
}

function getLastPathComponent(url) {
  return getPathComponents(url).slice(-1)[0]
}

function getPrefix(url) {
  return addTrailingSlash(url.origin + url.pathname)
}

function addTrailingSlash(value) {
  return value.endsWith("/") ? value : value + "/"
}

class FetchResponse {
  constructor(response) {
    this.response = response;
  }

  get succeeded() {
    return this.response.ok
  }

  get failed() {
    return !this.succeeded
  }

  get clientError() {
    return this.statusCode >= 400 && this.statusCode <= 499
  }

  get serverError() {
    return this.statusCode >= 500 && this.statusCode <= 599
  }

  get redirected() {
    return this.response.redirected
  }

  get location() {
    return expandURL(this.response.url)
  }

  get isHTML() {
    return this.contentType && this.contentType.match(/^(?:text\/([^\s;,]+\b)?html|application\/xhtml\+xml)\b/)
  }

  get statusCode() {
    return this.response.status
  }

  get contentType() {
    return this.header("Content-Type")
  }

  get responseText() {
    return this.response.clone().text()
  }

  get responseHTML() {
    if (this.isHTML) {
      return this.response.clone().text()
    } else {
      return Promise.resolve(undefined)
    }
  }

  header(name) {
    return this.response.headers.get(name)
  }
}

function activateScriptElement(element) {
  if (element.getAttribute("data-turbo-eval") == "false") {
    return element
  } else {
    const createdScriptElement = document.createElement("script");
    const cspNonce = getMetaContent("csp-nonce");
    if (cspNonce) {
      createdScriptElement.nonce = cspNonce;
    }
    createdScriptElement.textContent = element.textContent;
    createdScriptElement.async = false;
    copyElementAttributes(createdScriptElement, element);
    return createdScriptElement
  }
}

function copyElementAttributes(destinationElement, sourceElement) {
  for (const { name, value } of sourceElement.attributes) {
    destinationElement.setAttribute(name, value);
  }
}

function createDocumentFragment(html) {
  const template = document.createElement("template");
  template.innerHTML = html;
  return template.content
}

function dispatch(eventName, { target, cancelable, detail } = {}) {
  const event = new CustomEvent(eventName, {
    cancelable,
    bubbles: true,
    composed: true,
    detail
  });

  if (target && target.isConnected) {
    target.dispatchEvent(event);
  } else {
    document.documentElement.dispatchEvent(event);
  }

  return event
}

function nextRepaint() {
  if (document.visibilityState === "hidden") {
    return nextEventLoopTick()
  } else {
    return nextAnimationFrame()
  }
}

function nextAnimationFrame() {
  return new Promise((resolve) => requestAnimationFrame(() => resolve()))
}

function nextEventLoopTick() {
  return new Promise((resolve) => setTimeout(() => resolve(), 0))
}

function nextMicrotask() {
  return Promise.resolve()
}

function parseHTMLDocument(html = "") {
  return new DOMParser().parseFromString(html, "text/html")
}

function unindent(strings, ...values) {
  const lines = interpolate(strings, values).replace(/^\n/, "").split("\n");
  const match = lines[0].match(/^\s+/);
  const indent = match ? match[0].length : 0;
  return lines.map((line) => line.slice(indent)).join("\n")
}

function interpolate(strings, values) {
  return strings.reduce((result, string, i) => {
    const value = values[i] == undefined ? "" : values[i];
    return result + string + value
  }, "")
}

function uuid() {
  return Array.from({ length: 36 })
    .map((_, i) => {
      if (i == 8 || i == 13 || i == 18 || i == 23) {
        return "-"
      } else if (i == 14) {
        return "4"
      } else if (i == 19) {
        return (Math.floor(Math.random() * 4) + 8).toString(16)
      } else {
        return Math.floor(Math.random() * 15).toString(16)
      }
    })
    .join("")
}

function getAttribute(attributeName, ...elements) {
  for (const value of elements.map((element) => element?.getAttribute(attributeName))) {
    if (typeof value == "string") return value
  }

  return null
}

function hasAttribute(attributeName, ...elements) {
  return elements.some((element) => element && element.hasAttribute(attributeName))
}

function markAsBusy(...elements) {
  for (const element of elements) {
    if (element.localName == "turbo-frame") {
      element.setAttribute("busy", "");
    }
    element.setAttribute("aria-busy", "true");
  }
}

function clearBusyState(...elements) {
  for (const element of elements) {
    if (element.localName == "turbo-frame") {
      element.removeAttribute("busy");
    }

    element.removeAttribute("aria-busy");
  }
}

function waitForLoad(element, timeoutInMilliseconds = 2000) {
  return new Promise((resolve) => {
    const onComplete = () => {
      element.removeEventListener("error", onComplete);
      element.removeEventListener("load", onComplete);
      resolve();
    };

    element.addEventListener("load", onComplete, { once: true });
    element.addEventListener("error", onComplete, { once: true });
    setTimeout(resolve, timeoutInMilliseconds);
  })
}

function getHistoryMethodForAction(action) {
  switch (action) {
    case "replace":
      return history.replaceState
    case "advance":
    case "restore":
      return history.pushState
  }
}

function isAction(action) {
  return action == "advance" || action == "replace" || action == "restore"
}

function getVisitAction(...elements) {
  const action = getAttribute("data-turbo-action", ...elements);

  return isAction(action) ? action : null
}

function getMetaElement(name) {
  return document.querySelector(`meta[name="${name}"]`)
}

function getMetaContent(name) {
  const element = getMetaElement(name);
  return element && element.content
}

function setMetaContent(name, content) {
  let element = getMetaElement(name);

  if (!element) {
    element = document.createElement("meta");
    element.setAttribute("name", name);

    document.head.appendChild(element);
  }

  element.setAttribute("content", content);

  return element
}

function findClosestRecursively(element, selector) {
  if (element instanceof Element) {
    return (
      element.closest(selector) || findClosestRecursively(element.assignedSlot || element.getRootNode()?.host, selector)
    )
  }
}

function elementIsFocusable(element) {
  const inertDisabledOrHidden = "[inert], :disabled, [hidden], details:not([open]), dialog:not([open])";

  return !!element && element.closest(inertDisabledOrHidden) == null && typeof element.focus == "function"
}

function queryAutofocusableElement(elementOrDocumentFragment) {
  return Array.from(elementOrDocumentFragment.querySelectorAll("[autofocus]")).find(elementIsFocusable)
}

async function around(callback, reader) {
  const before = reader();

  callback();

  await nextAnimationFrame();

  const after = reader();

  return [before, after]
}

function doesNotTargetIFrame(anchor) {
  if (anchor.hasAttribute("target")) {
    for (const element of document.getElementsByName(anchor.target)) {
      if (element instanceof HTMLIFrameElement) return false
    }
  }

  return true
}

function findLinkFromClickTarget(target) {
  return findClosestRecursively(target, "a[href]:not([target^=_]):not([download])")
}

function getLocationForLink(link) {
  return expandURL(link.getAttribute("href") || "")
}

function debounce(fn, delay) {
  let timeoutId = null;

  return (...args) => {
    const callback = () => fn.apply(this, args);
    clearTimeout(timeoutId);
    timeoutId = setTimeout(callback, delay);
  }
}

class LimitedSet extends Set {
  constructor(maxSize) {
    super();
    this.maxSize = maxSize;
  }

  add(value) {
    if (this.size >= this.maxSize) {
      const iterator = this.values();
      const oldestValue = iterator.next().value;
      this.delete(oldestValue);
    }
    super.add(value);
  }
}

const recentRequests = new LimitedSet(20);

const nativeFetch = window.fetch;

function fetchWithTurboHeaders(url, options = {}) {
  const modifiedHeaders = new Headers(options.headers || {});
  const requestUID = uuid();
  recentRequests.add(requestUID);
  modifiedHeaders.append("X-Turbo-Request-Id", requestUID);

  return nativeFetch(url, {
    ...options,
    headers: modifiedHeaders
  })
}

function fetchMethodFromString(method) {
  switch (method.toLowerCase()) {
    case "get":
      return FetchMethod.get
    case "post":
      return FetchMethod.post
    case "put":
      return FetchMethod.put
    case "patch":
      return FetchMethod.patch
    case "delete":
      return FetchMethod.delete
  }
}

const FetchMethod = {
  get: "get",
  post: "post",
  put: "put",
  patch: "patch",
  delete: "delete"
};

function fetchEnctypeFromString(encoding) {
  switch (encoding.toLowerCase()) {
    case FetchEnctype.multipart:
      return FetchEnctype.multipart
    case FetchEnctype.plain:
      return FetchEnctype.plain
    default:
      return FetchEnctype.urlEncoded
  }
}

const FetchEnctype = {
  urlEncoded: "application/x-www-form-urlencoded",
  multipart: "multipart/form-data",
  plain: "text/plain"
};

class FetchRequest {
  abortController = new AbortController()
  #resolveRequestPromise = (_value) => {}

  constructor(delegate, method, location, requestBody = new URLSearchParams(), target = null, enctype = FetchEnctype.urlEncoded) {
    const [url, body] = buildResourceAndBody(expandURL(location), method, requestBody, enctype);

    this.delegate = delegate;
    this.url = url;
    this.target = target;
    this.fetchOptions = {
      credentials: "same-origin",
      redirect: "follow",
      method: method,
      headers: { ...this.defaultHeaders },
      body: body,
      signal: this.abortSignal,
      referrer: this.delegate.referrer?.href
    };
    this.enctype = enctype;
  }

  get method() {
    return this.fetchOptions.method
  }

  set method(value) {
    const fetchBody = this.isSafe ? this.url.searchParams : this.fetchOptions.body || new FormData();
    const fetchMethod = fetchMethodFromString(value) || FetchMethod.get;

    this.url.search = "";

    const [url, body] = buildResourceAndBody(this.url, fetchMethod, fetchBody, this.enctype);

    this.url = url;
    this.fetchOptions.body = body;
    this.fetchOptions.method = fetchMethod;
  }

  get headers() {
    return this.fetchOptions.headers
  }

  set headers(value) {
    this.fetchOptions.headers = value;
  }

  get body() {
    if (this.isSafe) {
      return this.url.searchParams
    } else {
      return this.fetchOptions.body
    }
  }

  set body(value) {
    this.fetchOptions.body = value;
  }

  get location() {
    return this.url
  }

  get params() {
    return this.url.searchParams
  }

  get entries() {
    return this.body ? Array.from(this.body.entries()) : []
  }

  cancel() {
    this.abortController.abort();
  }

  async perform() {
    const { fetchOptions } = this;
    this.delegate.prepareRequest(this);
    const event = await this.#allowRequestToBeIntercepted(fetchOptions);
    try {
      this.delegate.requestStarted(this);

      if (event.detail.fetchRequest) {
        this.response = event.detail.fetchRequest.response;
      } else {
        this.response = fetchWithTurboHeaders(this.url.href, fetchOptions);
      }

      const response = await this.response;
      return await this.receive(response)
    } catch (error) {
      if (error.name !== "AbortError") {
        if (this.#willDelegateErrorHandling(error)) {
          this.delegate.requestErrored(this, error);
        }
        throw error
      }
    } finally {
      this.delegate.requestFinished(this);
    }
  }

  async receive(response) {
    const fetchResponse = new FetchResponse(response);
    const event = dispatch("turbo:before-fetch-response", {
      cancelable: true,
      detail: { fetchResponse },
      target: this.target
    });
    if (event.defaultPrevented) {
      this.delegate.requestPreventedHandlingResponse(this, fetchResponse);
    } else if (fetchResponse.succeeded) {
      this.delegate.requestSucceededWithResponse(this, fetchResponse);
    } else {
      this.delegate.requestFailedWithResponse(this, fetchResponse);
    }
    return fetchResponse
  }

  get defaultHeaders() {
    return {
      Accept: "text/html, application/xhtml+xml"
    }
  }

  get isSafe() {
    return isSafe(this.method)
  }

  get abortSignal() {
    return this.abortController.signal
  }

  acceptResponseType(mimeType) {
    this.headers["Accept"] = [mimeType, this.headers["Accept"]].join(", ");
  }

  async #allowRequestToBeIntercepted(fetchOptions) {
    const requestInterception = new Promise((resolve) => (this.#resolveRequestPromise = resolve));
    const event = dispatch("turbo:before-fetch-request", {
      cancelable: true,
      detail: {
        fetchOptions,
        url: this.url,
        resume: this.#resolveRequestPromise
      },
      target: this.target
    });
    this.url = event.detail.url;
    if (event.defaultPrevented) await requestInterception;

    return event
  }

  #willDelegateErrorHandling(error) {
    const event = dispatch("turbo:fetch-request-error", {
      target: this.target,
      cancelable: true,
      detail: { request: this, error: error }
    });

    return !event.defaultPrevented
  }
}

function isSafe(fetchMethod) {
  return fetchMethodFromString(fetchMethod) == FetchMethod.get
}

function buildResourceAndBody(resource, method, requestBody, enctype) {
  const searchParams =
    Array.from(requestBody).length > 0 ? new URLSearchParams(entriesExcludingFiles(requestBody)) : resource.searchParams;

  if (isSafe(method)) {
    return [mergeIntoURLSearchParams(resource, searchParams), null]
  } else if (enctype == FetchEnctype.urlEncoded) {
    return [resource, searchParams]
  } else {
    return [resource, requestBody]
  }
}

function entriesExcludingFiles(requestBody) {
  const entries = [];

  for (const [name, value] of requestBody) {
    if (value instanceof File) continue
    else entries.push([name, value]);
  }

  return entries
}

function mergeIntoURLSearchParams(url, requestBody) {
  const searchParams = new URLSearchParams(entriesExcludingFiles(requestBody));

  url.search = searchParams.toString();

  return url
}

class AppearanceObserver {
  started = false

  constructor(delegate, element) {
    this.delegate = delegate;
    this.element = element;
    this.intersectionObserver = new IntersectionObserver(this.intersect);
  }

  start() {
    if (!this.started) {
      this.started = true;
      this.intersectionObserver.observe(this.element);
    }
  }

  stop() {
    if (this.started) {
      this.started = false;
      this.intersectionObserver.unobserve(this.element);
    }
  }

  intersect = (entries) => {
    const lastEntry = entries.slice(-1)[0];
    if (lastEntry?.isIntersecting) {
      this.delegate.elementAppearedInViewport(this.element);
    }
  }
}

class StreamMessage {
  static contentType = "text/vnd.turbo-stream.html"

  static wrap(message) {
    if (typeof message == "string") {
      return new this(createDocumentFragment(message))
    } else {
      return message
    }
  }

  constructor(fragment) {
    this.fragment = importStreamElements(fragment);
  }
}

function importStreamElements(fragment) {
  for (const element of fragment.querySelectorAll("turbo-stream")) {
    const streamElement = document.importNode(element, true);

    for (const inertScriptElement of streamElement.templateElement.content.querySelectorAll("script")) {
      inertScriptElement.replaceWith(activateScriptElement(inertScriptElement));
    }

    element.replaceWith(streamElement);
  }

  return fragment
}

const PREFETCH_DELAY = 100;

class PrefetchCache {
  #prefetchTimeout = null
  #prefetched = null

  get(url) {
    if (this.#prefetched && this.#prefetched.url === url && this.#prefetched.expire > Date.now()) {
      return this.#prefetched.request
    }
  }

  setLater(url, request, ttl) {
    this.clear();

    this.#prefetchTimeout = setTimeout(() => {
      request.perform();
      this.set(url, request, ttl);
      this.#prefetchTimeout = null;
    }, PREFETCH_DELAY);
  }

  set(url, request, ttl) {
    this.#prefetched = { url, request, expire: new Date(new Date().getTime() + ttl) };
  }

  clear() {
    if (this.#prefetchTimeout) clearTimeout(this.#prefetchTimeout);
    this.#prefetched = null;
  }
}

const cacheTtl = 10 * 1000;
const prefetchCache = new PrefetchCache();

const FormSubmissionState = {
  initialized: "initialized",
  requesting: "requesting",
  waiting: "waiting",
  receiving: "receiving",
  stopping: "stopping",
  stopped: "stopped"
};

class FormSubmission {
  state = FormSubmissionState.initialized

  static confirmMethod(message, _element, _submitter) {
    return Promise.resolve(confirm(message))
  }

  constructor(delegate, formElement, submitter, mustRedirect = false) {
    const method = getMethod(formElement, submitter);
    const action = getAction(getFormAction(formElement, submitter), method);
    const body = buildFormData(formElement, submitter);
    const enctype = getEnctype(formElement, submitter);

    this.delegate = delegate;
    this.formElement = formElement;
    this.submitter = submitter;
    this.fetchRequest = new FetchRequest(this, method, action, body, formElement, enctype);
    this.mustRedirect = mustRedirect;
  }

  get method() {
    return this.fetchRequest.method
  }

  set method(value) {
    this.fetchRequest.method = value;
  }

  get action() {
    return this.fetchRequest.url.toString()
  }

  set action(value) {
    this.fetchRequest.url = expandURL(value);
  }

  get body() {
    return this.fetchRequest.body
  }

  get enctype() {
    return this.fetchRequest.enctype
  }

  get isSafe() {
    return this.fetchRequest.isSafe
  }

  get location() {
    return this.fetchRequest.url
  }

  // The submission process

  async start() {
    const { initialized, requesting } = FormSubmissionState;
    const confirmationMessage = getAttribute("data-turbo-confirm", this.submitter, this.formElement);

    if (typeof confirmationMessage === "string") {
      const answer = await FormSubmission.confirmMethod(confirmationMessage, this.formElement, this.submitter);
      if (!answer) {
        return
      }
    }

    if (this.state == initialized) {
      this.state = requesting;
      return this.fetchRequest.perform()
    }
  }

  stop() {
    const { stopping, stopped } = FormSubmissionState;
    if (this.state != stopping && this.state != stopped) {
      this.state = stopping;
      this.fetchRequest.cancel();
      return true
    }
  }

  // Fetch request delegate

  prepareRequest(request) {
    if (!request.isSafe) {
      const token = getCookieValue(getMetaContent("csrf-param")) || getMetaContent("csrf-token");
      if (token) {
        request.headers["X-CSRF-Token"] = token;
      }
    }

    if (this.requestAcceptsTurboStreamResponse(request)) {
      request.acceptResponseType(StreamMessage.contentType);
    }
  }

  requestStarted(_request) {
    this.state = FormSubmissionState.waiting;
    this.submitter?.setAttribute("disabled", "");
    this.setSubmitsWith();
    markAsBusy(this.formElement);
    dispatch("turbo:submit-start", {
      target: this.formElement,
      detail: { formSubmission: this }
    });
    this.delegate.formSubmissionStarted(this);
  }

  requestPreventedHandlingResponse(request, response) {
    prefetchCache.clear();

    this.result = { success: response.succeeded, fetchResponse: response };
  }

  requestSucceededWithResponse(request, response) {
    if (response.clientError || response.serverError) {
      this.delegate.formSubmissionFailedWithResponse(this, response);
      return
    }

    prefetchCache.clear();

    if (this.requestMustRedirect(request) && responseSucceededWithoutRedirect(response)) {
      const error = new Error("Form responses must redirect to another location");
      this.delegate.formSubmissionErrored(this, error);
    } else {
      this.state = FormSubmissionState.receiving;
      this.result = { success: true, fetchResponse: response };
      this.delegate.formSubmissionSucceededWithResponse(this, response);
    }
  }

  requestFailedWithResponse(request, response) {
    this.result = { success: false, fetchResponse: response };
    this.delegate.formSubmissionFailedWithResponse(this, response);
  }

  requestErrored(request, error) {
    this.result = { success: false, error };
    this.delegate.formSubmissionErrored(this, error);
  }

  requestFinished(_request) {
    this.state = FormSubmissionState.stopped;
    this.submitter?.removeAttribute("disabled");
    this.resetSubmitterText();
    clearBusyState(this.formElement);
    dispatch("turbo:submit-end", {
      target: this.formElement,
      detail: { formSubmission: this, ...this.result }
    });
    this.delegate.formSubmissionFinished(this);
  }

  // Private

  setSubmitsWith() {
    if (!this.submitter || !this.submitsWith) return

    if (this.submitter.matches("button")) {
      this.originalSubmitText = this.submitter.innerHTML;
      this.submitter.innerHTML = this.submitsWith;
    } else if (this.submitter.matches("input")) {
      const input = this.submitter;
      this.originalSubmitText = input.value;
      input.value = this.submitsWith;
    }
  }

  resetSubmitterText() {
    if (!this.submitter || !this.originalSubmitText) return

    if (this.submitter.matches("button")) {
      this.submitter.innerHTML = this.originalSubmitText;
    } else if (this.submitter.matches("input")) {
      const input = this.submitter;
      input.value = this.originalSubmitText;
    }
  }

  requestMustRedirect(request) {
    return !request.isSafe && this.mustRedirect
  }

  requestAcceptsTurboStreamResponse(request) {
    return !request.isSafe || hasAttribute("data-turbo-stream", this.submitter, this.formElement)
  }

  get submitsWith() {
    return this.submitter?.getAttribute("data-turbo-submits-with")
  }
}

function buildFormData(formElement, submitter) {
  const formData = new FormData(formElement);
  const name = submitter?.getAttribute("name");
  const value = submitter?.getAttribute("value");

  if (name) {
    formData.append(name, value || "");
  }

  return formData
}

function getCookieValue(cookieName) {
  if (cookieName != null) {
    const cookies = document.cookie ? document.cookie.split("; ") : [];
    const cookie = cookies.find((cookie) => cookie.startsWith(cookieName));
    if (cookie) {
      const value = cookie.split("=").slice(1).join("=");
      return value ? decodeURIComponent(value) : undefined
    }
  }
}

function responseSucceededWithoutRedirect(response) {
  return response.statusCode == 200 && !response.redirected
}

function getFormAction(formElement, submitter) {
  const formElementAction = typeof formElement.action === "string" ? formElement.action : null;

  if (submitter?.hasAttribute("formaction")) {
    return submitter.getAttribute("formaction") || ""
  } else {
    return formElement.getAttribute("action") || formElementAction || ""
  }
}

function getAction(formAction, fetchMethod) {
  const action = expandURL(formAction);

  if (isSafe(fetchMethod)) {
    action.search = "";
  }

  return action
}

function getMethod(formElement, submitter) {
  const method = submitter?.getAttribute("formmethod") || formElement.getAttribute("method") || "";
  return fetchMethodFromString(method.toLowerCase()) || FetchMethod.get
}

function getEnctype(formElement, submitter) {
  return fetchEnctypeFromString(submitter?.getAttribute("formenctype") || formElement.enctype)
}

class Snapshot {
  constructor(element) {
    this.element = element;
  }

  get activeElement() {
    return this.element.ownerDocument.activeElement
  }

  get children() {
    return [...this.element.children]
  }

  hasAnchor(anchor) {
    return this.getElementForAnchor(anchor) != null
  }

  getElementForAnchor(anchor) {
    return anchor ? this.element.querySelector(`[id='${anchor}'], a[name='${anchor}']`) : null
  }

  get isConnected() {
    return this.element.isConnected
  }

  get firstAutofocusableElement() {
    return queryAutofocusableElement(this.element)
  }

  get permanentElements() {
    return queryPermanentElementsAll(this.element)
  }

  getPermanentElementById(id) {
    return getPermanentElementById(this.element, id)
  }

  getPermanentElementMapForSnapshot(snapshot) {
    const permanentElementMap = {};

    for (const currentPermanentElement of this.permanentElements) {
      const { id } = currentPermanentElement;
      const newPermanentElement = snapshot.getPermanentElementById(id);
      if (newPermanentElement) {
        permanentElementMap[id] = [currentPermanentElement, newPermanentElement];
      }
    }

    return permanentElementMap
  }
}

function getPermanentElementById(node, id) {
  return node.querySelector(`#${id}[data-turbo-permanent]`)
}

function queryPermanentElementsAll(node) {
  return node.querySelectorAll("[id][data-turbo-permanent]")
}

class FormSubmitObserver {
  started = false

  constructor(delegate, eventTarget) {
    this.delegate = delegate;
    this.eventTarget = eventTarget;
  }

  start() {
    if (!this.started) {
      this.eventTarget.addEventListener("submit", this.submitCaptured, true);
      this.started = true;
    }
  }

  stop() {
    if (this.started) {
      this.eventTarget.removeEventListener("submit", this.submitCaptured, true);
      this.started = false;
    }
  }

  submitCaptured = () => {
    this.eventTarget.removeEventListener("submit", this.submitBubbled, false);
    this.eventTarget.addEventListener("submit", this.submitBubbled, false);
  }

  submitBubbled = (event) => {
    if (!event.defaultPrevented) {
      const form = event.target instanceof HTMLFormElement ? event.target : undefined;
      const submitter = event.submitter || undefined;

      if (
        form &&
        submissionDoesNotDismissDialog(form, submitter) &&
        submissionDoesNotTargetIFrame(form, submitter) &&
        this.delegate.willSubmitForm(form, submitter)
      ) {
        event.preventDefault();
        event.stopImmediatePropagation();
        this.delegate.formSubmitted(form, submitter);
      }
    }
  }
}

function submissionDoesNotDismissDialog(form, submitter) {
  const method = submitter?.getAttribute("formmethod") || form.getAttribute("method");

  return method != "dialog"
}

function submissionDoesNotTargetIFrame(form, submitter) {
  if (submitter?.hasAttribute("formtarget") || form.hasAttribute("target")) {
    const target = submitter?.getAttribute("formtarget") || form.target;

    for (const element of document.getElementsByName(target)) {
      if (element instanceof HTMLIFrameElement) return false
    }

    return true
  } else {
    return true
  }
}

class View {
  #resolveRenderPromise = (_value) => {}
  #resolveInterceptionPromise = (_value) => {}

  constructor(delegate, element) {
    this.delegate = delegate;
    this.element = element;
  }

  // Scrolling

  scrollToAnchor(anchor) {
    const element = this.snapshot.getElementForAnchor(anchor);
    if (element) {
      this.scrollToElement(element);
      this.focusElement(element);
    } else {
      this.scrollToPosition({ x: 0, y: 0 });
    }
  }

  scrollToAnchorFromLocation(location) {
    this.scrollToAnchor(getAnchor(location));
  }

  scrollToElement(element) {
    element.scrollIntoView();
  }

  focusElement(element) {
    if (element instanceof HTMLElement) {
      if (element.hasAttribute("tabindex")) {
        element.focus();
      } else {
        element.setAttribute("tabindex", "-1");
        element.focus();
        element.removeAttribute("tabindex");
      }
    }
  }

  scrollToPosition({ x, y }) {
    this.scrollRoot.scrollTo(x, y);
  }

  scrollToTop() {
    this.scrollToPosition({ x: 0, y: 0 });
  }

  get scrollRoot() {
    return window
  }

  // Rendering

  async render(renderer) {
    const { isPreview, shouldRender, willRender, newSnapshot: snapshot } = renderer;

    // A workaround to ignore tracked element mismatch reloads when performing
    // a promoted Visit from a frame navigation
    const shouldInvalidate = willRender;

    if (shouldRender) {
      try {
        this.renderPromise = new Promise((resolve) => (this.#resolveRenderPromise = resolve));
        this.renderer = renderer;
        await this.prepareToRenderSnapshot(renderer);

        const renderInterception = new Promise((resolve) => (this.#resolveInterceptionPromise = resolve));
        const options = { resume: this.#resolveInterceptionPromise, render: this.renderer.renderElement, renderMethod: this.renderer.renderMethod };
        const immediateRender = this.delegate.allowsImmediateRender(snapshot, options);
        if (!immediateRender) await renderInterception;

        await this.renderSnapshot(renderer);
        this.delegate.viewRenderedSnapshot(snapshot, isPreview, this.renderer.renderMethod);
        this.delegate.preloadOnLoadLinksForView(this.element);
        this.finishRenderingSnapshot(renderer);
      } finally {
        delete this.renderer;
        this.#resolveRenderPromise(undefined);
        delete this.renderPromise;
      }
    } else if (shouldInvalidate) {
      this.invalidate(renderer.reloadReason);
    }
  }

  invalidate(reason) {
    this.delegate.viewInvalidated(reason);
  }

  async prepareToRenderSnapshot(renderer) {
    this.markAsPreview(renderer.isPreview);
    await renderer.prepareToRender();
  }

  markAsPreview(isPreview) {
    if (isPreview) {
      this.element.setAttribute("data-turbo-preview", "");
    } else {
      this.element.removeAttribute("data-turbo-preview");
    }
  }

  markVisitDirection(direction) {
    this.element.setAttribute("data-turbo-visit-direction", direction);
  }

  unmarkVisitDirection() {
    this.element.removeAttribute("data-turbo-visit-direction");
  }

  async renderSnapshot(renderer) {
    await renderer.render();
  }

  finishRenderingSnapshot(renderer) {
    renderer.finishRendering();
  }
}

class FrameView extends View {
  missing() {
    this.element.innerHTML = `<strong class="turbo-frame-error">Content missing</strong>`;
  }

  get snapshot() {
    return new Snapshot(this.element)
  }
}

class LinkInterceptor {
  constructor(delegate, element) {
    this.delegate = delegate;
    this.element = element;
  }

  start() {
    this.element.addEventListener("click", this.clickBubbled);
    document.addEventListener("turbo:click", this.linkClicked);
    document.addEventListener("turbo:before-visit", this.willVisit);
  }

  stop() {
    this.element.removeEventListener("click", this.clickBubbled);
    document.removeEventListener("turbo:click", this.linkClicked);
    document.removeEventListener("turbo:before-visit", this.willVisit);
  }

  clickBubbled = (event) => {
    if (this.respondsToEventTarget(event.target)) {
      this.clickEvent = event;
    } else {
      delete this.clickEvent;
    }
  }

  linkClicked = (event) => {
    if (this.clickEvent && this.respondsToEventTarget(event.target) && event.target instanceof Element) {
      if (this.delegate.shouldInterceptLinkClick(event.target, event.detail.url, event.detail.originalEvent)) {
        this.clickEvent.preventDefault();
        event.preventDefault();
        this.delegate.linkClickIntercepted(event.target, event.detail.url, event.detail.originalEvent);
      }
    }
    delete this.clickEvent;
  }

  willVisit = (_event) => {
    delete this.clickEvent;
  }

  respondsToEventTarget(target) {
    const element = target instanceof Element ? target : target instanceof Node ? target.parentElement : null;
    return element && element.closest("turbo-frame, html") == this.element
  }
}

class LinkClickObserver {
  started = false

  constructor(delegate, eventTarget) {
    this.delegate = delegate;
    this.eventTarget = eventTarget;
  }

  start() {
    if (!this.started) {
      this.eventTarget.addEventListener("click", this.clickCaptured, true);
      this.started = true;
    }
  }

  stop() {
    if (this.started) {
      this.eventTarget.removeEventListener("click", this.clickCaptured, true);
      this.started = false;
    }
  }

  clickCaptured = () => {
    this.eventTarget.removeEventListener("click", this.clickBubbled, false);
    this.eventTarget.addEventListener("click", this.clickBubbled, false);
  }

  clickBubbled = (event) => {
    if (event instanceof MouseEvent && this.clickEventIsSignificant(event)) {
      const target = (event.composedPath && event.composedPath()[0]) || event.target;
      const link = findLinkFromClickTarget(target);
      if (link && doesNotTargetIFrame(link)) {
        const location = getLocationForLink(link);
        if (this.delegate.willFollowLinkToLocation(link, location, event)) {
          event.preventDefault();
          this.delegate.followedLinkToLocation(link, location);
        }
      }
    }
  }

  clickEventIsSignificant(event) {
    return !(
      (event.target && event.target.isContentEditable) ||
      event.defaultPrevented ||
      event.which > 1 ||
      event.altKey ||
      event.ctrlKey ||
      event.metaKey ||
      event.shiftKey
    )
  }
}

class FormLinkClickObserver {
  constructor(delegate, element) {
    this.delegate = delegate;
    this.linkInterceptor = new LinkClickObserver(this, element);
  }

  start() {
    this.linkInterceptor.start();
  }

  stop() {
    this.linkInterceptor.stop();
  }

  // Link hover observer delegate

  canPrefetchRequestToLocation(link, location) {
    return false
  }

  prefetchAndCacheRequestToLocation(link, location) {
    return
  }

  // Link click observer delegate

  willFollowLinkToLocation(link, location, originalEvent) {
    return (
      this.delegate.willSubmitFormLinkToLocation(link, location, originalEvent) &&
      (link.hasAttribute("data-turbo-method") || link.hasAttribute("data-turbo-stream"))
    )
  }

  followedLinkToLocation(link, location) {
    const form = document.createElement("form");

    const type = "hidden";
    for (const [name, value] of location.searchParams) {
      form.append(Object.assign(document.createElement("input"), { type, name, value }));
    }

    const action = Object.assign(location, { search: "" });
    form.setAttribute("data-turbo", "true");
    form.setAttribute("action", action.href);
    form.setAttribute("hidden", "");

    const method = link.getAttribute("data-turbo-method");
    if (method) form.setAttribute("method", method);

    const turboFrame = link.getAttribute("data-turbo-frame");
    if (turboFrame) form.setAttribute("data-turbo-frame", turboFrame);

    const turboAction = getVisitAction(link);
    if (turboAction) form.setAttribute("data-turbo-action", turboAction);

    const turboConfirm = link.getAttribute("data-turbo-confirm");
    if (turboConfirm) form.setAttribute("data-turbo-confirm", turboConfirm);

    const turboStream = link.hasAttribute("data-turbo-stream");
    if (turboStream) form.setAttribute("data-turbo-stream", "");

    this.delegate.submittedFormLinkToLocation(link, location, form);

    document.body.appendChild(form);
    form.addEventListener("turbo:submit-end", () => form.remove(), { once: true });
    requestAnimationFrame(() => form.requestSubmit());
  }
}

class Bardo {
  static async preservingPermanentElements(delegate, permanentElementMap, callback) {
    const bardo = new this(delegate, permanentElementMap);
    bardo.enter();
    await callback();
    bardo.leave();
  }

  constructor(delegate, permanentElementMap) {
    this.delegate = delegate;
    this.permanentElementMap = permanentElementMap;
  }

  enter() {
    for (const id in this.permanentElementMap) {
      const [currentPermanentElement, newPermanentElement] = this.permanentElementMap[id];
      this.delegate.enteringBardo(currentPermanentElement, newPermanentElement);
      this.replaceNewPermanentElementWithPlaceholder(newPermanentElement);
    }
  }

  leave() {
    for (const id in this.permanentElementMap) {
      const [currentPermanentElement] = this.permanentElementMap[id];
      this.replaceCurrentPermanentElementWithClone(currentPermanentElement);
      this.replacePlaceholderWithPermanentElement(currentPermanentElement);
      this.delegate.leavingBardo(currentPermanentElement);
    }
  }

  replaceNewPermanentElementWithPlaceholder(permanentElement) {
    const placeholder = createPlaceholderForPermanentElement(permanentElement);
    permanentElement.replaceWith(placeholder);
  }

  replaceCurrentPermanentElementWithClone(permanentElement) {
    const clone = permanentElement.cloneNode(true);
    permanentElement.replaceWith(clone);
  }

  replacePlaceholderWithPermanentElement(permanentElement) {
    const placeholder = this.getPlaceholderById(permanentElement.id);
    placeholder?.replaceWith(permanentElement);
  }

  getPlaceholderById(id) {
    return this.placeholders.find((element) => element.content == id)
  }

  get placeholders() {
    return [...document.querySelectorAll("meta[name=turbo-permanent-placeholder][content]")]
  }
}

function createPlaceholderForPermanentElement(permanentElement) {
  const element = document.createElement("meta");
  element.setAttribute("name", "turbo-permanent-placeholder");
  element.setAttribute("content", permanentElement.id);
  return element
}

class Renderer {
  #activeElement = null

  constructor(currentSnapshot, newSnapshot, renderElement, isPreview, willRender = true) {
    this.currentSnapshot = currentSnapshot;
    this.newSnapshot = newSnapshot;
    this.isPreview = isPreview;
    this.willRender = willRender;
    this.renderElement = renderElement;
    this.promise = new Promise((resolve, reject) => (this.resolvingFunctions = { resolve, reject }));
  }

  get shouldRender() {
    return true
  }

  get reloadReason() {
    return
  }

  prepareToRender() {
    return
  }

  render() {
    // Abstract method
  }

  finishRendering() {
    if (this.resolvingFunctions) {
      this.resolvingFunctions.resolve();
      delete this.resolvingFunctions;
    }
  }

  async preservingPermanentElements(callback) {
    await Bardo.preservingPermanentElements(this, this.permanentElementMap, callback);
  }

  focusFirstAutofocusableElement() {
    const element = this.connectedSnapshot.firstAutofocusableElement;
    if (element) {
      element.focus();
    }
  }

  // Bardo delegate

  enteringBardo(currentPermanentElement) {
    if (this.#activeElement) return

    if (currentPermanentElement.contains(this.currentSnapshot.activeElement)) {
      this.#activeElement = this.currentSnapshot.activeElement;
    }
  }

  leavingBardo(currentPermanentElement) {
    if (currentPermanentElement.contains(this.#activeElement) && this.#activeElement instanceof HTMLElement) {
      this.#activeElement.focus();

      this.#activeElement = null;
    }
  }

  get connectedSnapshot() {
    return this.newSnapshot.isConnected ? this.newSnapshot : this.currentSnapshot
  }

  get currentElement() {
    return this.currentSnapshot.element
  }

  get newElement() {
    return this.newSnapshot.element
  }

  get permanentElementMap() {
    return this.currentSnapshot.getPermanentElementMapForSnapshot(this.newSnapshot)
  }

  get renderMethod() {
    return "replace"
  }
}

class FrameRenderer extends Renderer {
  static renderElement(currentElement, newElement) {
    const destinationRange = document.createRange();
    destinationRange.selectNodeContents(currentElement);
    destinationRange.deleteContents();

    const frameElement = newElement;
    const sourceRange = frameElement.ownerDocument?.createRange();
    if (sourceRange) {
      sourceRange.selectNodeContents(frameElement);
      currentElement.appendChild(sourceRange.extractContents());
    }
  }

  constructor(delegate, currentSnapshot, newSnapshot, renderElement, isPreview, willRender = true) {
    super(currentSnapshot, newSnapshot, renderElement, isPreview, willRender);
    this.delegate = delegate;
  }

  get shouldRender() {
    return true
  }

  async render() {
    await nextRepaint();
    this.preservingPermanentElements(() => {
      this.loadFrameElement();
    });
    this.scrollFrameIntoView();
    await nextRepaint();
    this.focusFirstAutofocusableElement();
    await nextRepaint();
    this.activateScriptElements();
  }

  loadFrameElement() {
    this.delegate.willRenderFrame(this.currentElement, this.newElement);
    this.renderElement(this.currentElement, this.newElement);
  }

  scrollFrameIntoView() {
    if (this.currentElement.autoscroll || this.newElement.autoscroll) {
      const element = this.currentElement.firstElementChild;
      const block = readScrollLogicalPosition(this.currentElement.getAttribute("data-autoscroll-block"), "end");
      const behavior = readScrollBehavior(this.currentElement.getAttribute("data-autoscroll-behavior"), "auto");

      if (element) {
        element.scrollIntoView({ block, behavior });
        return true
      }
    }
    return false
  }

  activateScriptElements() {
    for (const inertScriptElement of this.newScriptElements) {
      const activatedScriptElement = activateScriptElement(inertScriptElement);
      inertScriptElement.replaceWith(activatedScriptElement);
    }
  }

  get newScriptElements() {
    return this.currentElement.querySelectorAll("script")
  }
}

function readScrollLogicalPosition(value, defaultValue) {
  if (value == "end" || value == "start" || value == "center" || value == "nearest") {
    return value
  } else {
    return defaultValue
  }
}

function readScrollBehavior(value, defaultValue) {
  if (value == "auto" || value == "smooth") {
    return value
  } else {
    return defaultValue
  }
}

class ProgressBar {
  static animationDuration = 300 /*ms*/

  static get defaultCSS() {
    return unindent`
      .turbo-progress-bar {
        position: fixed;
        display: block;
        top: 0;
        left: 0;
        height: 3px;
        background: #0076ff;
        z-index: 2147483647;
        transition:
          width ${ProgressBar.animationDuration}ms ease-out,
          opacity ${ProgressBar.animationDuration / 2}ms ${ProgressBar.animationDuration / 2}ms ease-in;
        transform: translate3d(0, 0, 0);
      }
    `
  }

  hiding = false
  value = 0
  visible = false

  constructor() {
    this.stylesheetElement = this.createStylesheetElement();
    this.progressElement = this.createProgressElement();
    this.installStylesheetElement();
    this.setValue(0);
  }

  show() {
    if (!this.visible) {
      this.visible = true;
      this.installProgressElement();
      this.startTrickling();
    }
  }

  hide() {
    if (this.visible && !this.hiding) {
      this.hiding = true;
      this.fadeProgressElement(() => {
        this.uninstallProgressElement();
        this.stopTrickling();
        this.visible = false;
        this.hiding = false;
      });
    }
  }

  setValue(value) {
    this.value = value;
    this.refresh();
  }

  // Private

  installStylesheetElement() {
    document.head.insertBefore(this.stylesheetElement, document.head.firstChild);
  }

  installProgressElement() {
    this.progressElement.style.width = "0";
    this.progressElement.style.opacity = "1";
    document.documentElement.insertBefore(this.progressElement, document.body);
    this.refresh();
  }

  fadeProgressElement(callback) {
    this.progressElement.style.opacity = "0";
    setTimeout(callback, ProgressBar.animationDuration * 1.5);
  }

  uninstallProgressElement() {
    if (this.progressElement.parentNode) {
      document.documentElement.removeChild(this.progressElement);
    }
  }

  startTrickling() {
    if (!this.trickleInterval) {
      this.trickleInterval = window.setInterval(this.trickle, ProgressBar.animationDuration);
    }
  }

  stopTrickling() {
    window.clearInterval(this.trickleInterval);
    delete this.trickleInterval;
  }

  trickle = () => {
    this.setValue(this.value + Math.random() / 100);
  }

  refresh() {
    requestAnimationFrame(() => {
      this.progressElement.style.width = `${10 + this.value * 90}%`;
    });
  }

  createStylesheetElement() {
    const element = document.createElement("style");
    element.type = "text/css";
    element.textContent = ProgressBar.defaultCSS;
    if (this.cspNonce) {
      element.nonce = this.cspNonce;
    }
    return element
  }

  createProgressElement() {
    const element = document.createElement("div");
    element.className = "turbo-progress-bar";
    return element
  }

  get cspNonce() {
    return getMetaContent("csp-nonce")
  }
}

class HeadSnapshot extends Snapshot {
  detailsByOuterHTML = this.children
    .filter((element) => !elementIsNoscript(element))
    .map((element) => elementWithoutNonce(element))
    .reduce((result, element) => {
      const { outerHTML } = element;
      const details =
        outerHTML in result
          ? result[outerHTML]
          : {
              type: elementType(element),
              tracked: elementIsTracked(element),
              elements: []
            };
      return {
        ...result,
        [outerHTML]: {
          ...details,
          elements: [...details.elements, element]
        }
      }
    }, {})

  get trackedElementSignature() {
    return Object.keys(this.detailsByOuterHTML)
      .filter((outerHTML) => this.detailsByOuterHTML[outerHTML].tracked)
      .join("")
  }

  getScriptElementsNotInSnapshot(snapshot) {
    return this.getElementsMatchingTypeNotInSnapshot("script", snapshot)
  }

  getStylesheetElementsNotInSnapshot(snapshot) {
    return this.getElementsMatchingTypeNotInSnapshot("stylesheet", snapshot)
  }

  getElementsMatchingTypeNotInSnapshot(matchedType, snapshot) {
    return Object.keys(this.detailsByOuterHTML)
      .filter((outerHTML) => !(outerHTML in snapshot.detailsByOuterHTML))
      .map((outerHTML) => this.detailsByOuterHTML[outerHTML])
      .filter(({ type }) => type == matchedType)
      .map(({ elements: [element] }) => element)
  }

  get provisionalElements() {
    return Object.keys(this.detailsByOuterHTML).reduce((result, outerHTML) => {
      const { type, tracked, elements } = this.detailsByOuterHTML[outerHTML];
      if (type == null && !tracked) {
        return [...result, ...elements]
      } else if (elements.length > 1) {
        return [...result, ...elements.slice(1)]
      } else {
        return result
      }
    }, [])
  }

  getMetaValue(name) {
    const element = this.findMetaElementByName(name);
    return element ? element.getAttribute("content") : null
  }

  findMetaElementByName(name) {
    return Object.keys(this.detailsByOuterHTML).reduce((result, outerHTML) => {
      const {
        elements: [element]
      } = this.detailsByOuterHTML[outerHTML];
      return elementIsMetaElementWithName(element, name) ? element : result
    }, undefined | undefined)
  }
}

function elementType(element) {
  if (elementIsScript(element)) {
    return "script"
  } else if (elementIsStylesheet(element)) {
    return "stylesheet"
  }
}

function elementIsTracked(element) {
  return element.getAttribute("data-turbo-track") == "reload"
}

function elementIsScript(element) {
  const tagName = element.localName;
  return tagName == "script"
}

function elementIsNoscript(element) {
  const tagName = element.localName;
  return tagName == "noscript"
}

function elementIsStylesheet(element) {
  const tagName = element.localName;
  return tagName == "style" || (tagName == "link" && element.getAttribute("rel") == "stylesheet")
}

function elementIsMetaElementWithName(element, name) {
  const tagName = element.localName;
  return tagName == "meta" && element.getAttribute("name") == name
}

function elementWithoutNonce(element) {
  if (element.hasAttribute("nonce")) {
    element.setAttribute("nonce", "");
  }

  return element
}

class PageSnapshot extends Snapshot {
  static fromHTMLString(html = "") {
    return this.fromDocument(parseHTMLDocument(html))
  }

  static fromElement(element) {
    return this.fromDocument(element.ownerDocument)
  }

  static fromDocument({ documentElement, body, head }) {
    return new this(documentElement, body, new HeadSnapshot(head))
  }

  constructor(documentElement, body, headSnapshot) {
    super(body);
    this.documentElement = documentElement;
    this.headSnapshot = headSnapshot;
  }

  clone() {
    const clonedElement = this.element.cloneNode(true);

    const selectElements = this.element.querySelectorAll("select");
    const clonedSelectElements = clonedElement.querySelectorAll("select");

    for (const [index, source] of selectElements.entries()) {
      const clone = clonedSelectElements[index];
      for (const option of clone.selectedOptions) option.selected = false;
      for (const option of source.selectedOptions) clone.options[option.index].selected = true;
    }

    for (const clonedPasswordInput of clonedElement.querySelectorAll('input[type="password"]')) {
      clonedPasswordInput.value = "";
    }

    return new PageSnapshot(this.documentElement, clonedElement, this.headSnapshot)
  }

  get lang() {
    return this.documentElement.getAttribute("lang")
  }

  get headElement() {
    return this.headSnapshot.element
  }

  get rootLocation() {
    const root = this.getSetting("root") ?? "/";
    return expandURL(root)
  }

  get cacheControlValue() {
    return this.getSetting("cache-control")
  }

  get isPreviewable() {
    return this.cacheControlValue != "no-preview"
  }

  get isCacheable() {
    return this.cacheControlValue != "no-cache"
  }

  get isVisitable() {
    return this.getSetting("visit-control") != "reload"
  }

  get prefersViewTransitions() {
    return this.headSnapshot.getMetaValue("view-transition") === "same-origin"
  }

  get shouldMorphPage() {
    return this.getSetting("refresh-method") === "morph"
  }

  get shouldPreserveScrollPosition() {
    return this.getSetting("refresh-scroll") === "preserve"
  }

  // Private

  getSetting(name) {
    return this.headSnapshot.getMetaValue(`turbo-${name}`)
  }
}

class ViewTransitioner {
  #viewTransitionStarted = false
  #lastOperation = Promise.resolve()

  renderChange(useViewTransition, render) {
    if (useViewTransition && this.viewTransitionsAvailable && !this.#viewTransitionStarted) {
      this.#viewTransitionStarted = true;
      this.#lastOperation = this.#lastOperation.then(async () => {
        await document.startViewTransition(render).finished;
      });
    } else {
      this.#lastOperation = this.#lastOperation.then(render);
    }

    return this.#lastOperation
  }

  get viewTransitionsAvailable() {
    return document.startViewTransition
  }
}

const defaultOptions = {
  action: "advance",
  historyChanged: false,
  visitCachedSnapshot: () => {},
  willRender: true,
  updateHistory: true,
  shouldCacheSnapshot: true,
  acceptsStreamResponse: false
};

const TimingMetric = {
  visitStart: "visitStart",
  requestStart: "requestStart",
  requestEnd: "requestEnd",
  visitEnd: "visitEnd"
};

const VisitState = {
  initialized: "initialized",
  started: "started",
  canceled: "canceled",
  failed: "failed",
  completed: "completed"
};

const SystemStatusCode = {
  networkFailure: 0,
  timeoutFailure: -1,
  contentTypeMismatch: -2
};

const Direction = {
  advance: "forward",
  restore: "back",
  replace: "none"
};

class Visit {
  identifier = uuid() // Required by turbo-ios
  timingMetrics = {}

  followedRedirect = false
  historyChanged = false
  scrolled = false
  shouldCacheSnapshot = true
  acceptsStreamResponse = false
  snapshotCached = false
  state = VisitState.initialized
  viewTransitioner = new ViewTransitioner()

  constructor(delegate, location, restorationIdentifier, options = {}) {
    this.delegate = delegate;
    this.location = location;
    this.restorationIdentifier = restorationIdentifier || uuid();

    const {
      action,
      historyChanged,
      referrer,
      snapshot,
      snapshotHTML,
      response,
      visitCachedSnapshot,
      willRender,
      updateHistory,
      shouldCacheSnapshot,
      acceptsStreamResponse,
      direction
    } = {
      ...defaultOptions,
      ...options
    };
    this.action = action;
    this.historyChanged = historyChanged;
    this.referrer = referrer;
    this.snapshot = snapshot;
    this.snapshotHTML = snapshotHTML;
    this.response = response;
    this.isSamePage = this.delegate.locationWithActionIsSamePage(this.location, this.action);
    this.isPageRefresh = this.view.isPageRefresh(this);
    this.visitCachedSnapshot = visitCachedSnapshot;
    this.willRender = willRender;
    this.updateHistory = updateHistory;
    this.scrolled = !willRender;
    this.shouldCacheSnapshot = shouldCacheSnapshot;
    this.acceptsStreamResponse = acceptsStreamResponse;
    this.direction = direction || Direction[action];
  }

  get adapter() {
    return this.delegate.adapter
  }

  get view() {
    return this.delegate.view
  }

  get history() {
    return this.delegate.history
  }

  get restorationData() {
    return this.history.getRestorationDataForIdentifier(this.restorationIdentifier)
  }

  get silent() {
    return this.isSamePage
  }

  start() {
    if (this.state == VisitState.initialized) {
      this.recordTimingMetric(TimingMetric.visitStart);
      this.state = VisitState.started;
      this.adapter.visitStarted(this);
      this.delegate.visitStarted(this);
    }
  }

  cancel() {
    if (this.state == VisitState.started) {
      if (this.request) {
        this.request.cancel();
      }
      this.cancelRender();
      this.state = VisitState.canceled;
    }
  }

  complete() {
    if (this.state == VisitState.started) {
      this.recordTimingMetric(TimingMetric.visitEnd);
      this.adapter.visitCompleted(this);
      this.state = VisitState.completed;
      this.followRedirect();

      if (!this.followedRedirect) {
        this.delegate.visitCompleted(this);
      }
    }
  }

  fail() {
    if (this.state == VisitState.started) {
      this.state = VisitState.failed;
      this.adapter.visitFailed(this);
      this.delegate.visitCompleted(this);
    }
  }

  changeHistory() {
    if (!this.historyChanged && this.updateHistory) {
      const actionForHistory = this.location.href === this.referrer?.href ? "replace" : this.action;
      const method = getHistoryMethodForAction(actionForHistory);
      this.history.update(method, this.location, this.restorationIdentifier);
      this.historyChanged = true;
    }
  }

  issueRequest() {
    if (this.hasPreloadedResponse()) {
      this.simulateRequest();
    } else if (this.shouldIssueRequest() && !this.request) {
      this.request = new FetchRequest(this, FetchMethod.get, this.location);
      this.request.perform();
    }
  }

  simulateRequest() {
    if (this.response) {
      this.startRequest();
      this.recordResponse();
      this.finishRequest();
    }
  }

  startRequest() {
    this.recordTimingMetric(TimingMetric.requestStart);
    this.adapter.visitRequestStarted(this);
  }

  recordResponse(response = this.response) {
    this.response = response;
    if (response) {
      const { statusCode } = response;
      if (isSuccessful(statusCode)) {
        this.adapter.visitRequestCompleted(this);
      } else {
        this.adapter.visitRequestFailedWithStatusCode(this, statusCode);
      }
    }
  }

  finishRequest() {
    this.recordTimingMetric(TimingMetric.requestEnd);
    this.adapter.visitRequestFinished(this);
  }

  loadResponse() {
    if (this.response) {
      const { statusCode, responseHTML } = this.response;
      this.render(async () => {
        if (this.shouldCacheSnapshot) this.cacheSnapshot();
        if (this.view.renderPromise) await this.view.renderPromise;

        if (isSuccessful(statusCode) && responseHTML != null) {
          const snapshot = PageSnapshot.fromHTMLString(responseHTML);
          await this.renderPageSnapshot(snapshot, false);

          this.adapter.visitRendered(this);
          this.complete();
        } else {
          await this.view.renderError(PageSnapshot.fromHTMLString(responseHTML), this);
          this.adapter.visitRendered(this);
          this.fail();
        }
      });
    }
  }

  getCachedSnapshot() {
    const snapshot = this.view.getCachedSnapshotForLocation(this.location) || this.getPreloadedSnapshot();

    if (snapshot && (!getAnchor(this.location) || snapshot.hasAnchor(getAnchor(this.location)))) {
      if (this.action == "restore" || snapshot.isPreviewable) {
        return snapshot
      }
    }
  }

  getPreloadedSnapshot() {
    if (this.snapshotHTML) {
      return PageSnapshot.fromHTMLString(this.snapshotHTML)
    }
  }

  hasCachedSnapshot() {
    return this.getCachedSnapshot() != null
  }

  loadCachedSnapshot() {
    const snapshot = this.getCachedSnapshot();
    if (snapshot) {
      const isPreview = this.shouldIssueRequest();
      this.render(async () => {
        this.cacheSnapshot();
        if (this.isSamePage || this.isPageRefresh) {
          this.adapter.visitRendered(this);
        } else {
          if (this.view.renderPromise) await this.view.renderPromise;

          await this.renderPageSnapshot(snapshot, isPreview);

          this.adapter.visitRendered(this);
          if (!isPreview) {
            this.complete();
          }
        }
      });
    }
  }

  followRedirect() {
    if (this.redirectedToLocation && !this.followedRedirect && this.response?.redirected) {
      this.adapter.visitProposedToLocation(this.redirectedToLocation, {
        action: "replace",
        response: this.response,
        shouldCacheSnapshot: false,
        willRender: false
      });
      this.followedRedirect = true;
    }
  }

  goToSamePageAnchor() {
    if (this.isSamePage) {
      this.render(async () => {
        this.cacheSnapshot();
        this.performScroll();
        this.changeHistory();
        this.adapter.visitRendered(this);
      });
    }
  }

  // Fetch request delegate

  prepareRequest(request) {
    if (this.acceptsStreamResponse) {
      request.acceptResponseType(StreamMessage.contentType);
    }
  }

  requestStarted() {
    this.startRequest();
  }

  requestPreventedHandlingResponse(_request, _response) {}

  async requestSucceededWithResponse(request, response) {
    const responseHTML = await response.responseHTML;
    const { redirected, statusCode } = response;
    if (responseHTML == undefined) {
      this.recordResponse({
        statusCode: SystemStatusCode.contentTypeMismatch,
        redirected
      });
    } else {
      this.redirectedToLocation = response.redirected ? response.location : undefined;
      this.recordResponse({ statusCode: statusCode, responseHTML, redirected });
    }
  }

  async requestFailedWithResponse(request, response) {
    const responseHTML = await response.responseHTML;
    const { redirected, statusCode } = response;
    if (responseHTML == undefined) {
      this.recordResponse({
        statusCode: SystemStatusCode.contentTypeMismatch,
        redirected
      });
    } else {
      this.recordResponse({ statusCode: statusCode, responseHTML, redirected });
    }
  }

  requestErrored(_request, _error) {
    this.recordResponse({
      statusCode: SystemStatusCode.networkFailure,
      redirected: false
    });
  }

  requestFinished() {
    this.finishRequest();
  }

  // Scrolling

  performScroll() {
    if (!this.scrolled && !this.view.forceReloaded && !this.view.shouldPreserveScrollPosition(this)) {
      if (this.action == "restore") {
        this.scrollToRestoredPosition() || this.scrollToAnchor() || this.view.scrollToTop();
      } else {
        this.scrollToAnchor() || this.view.scrollToTop();
      }
      if (this.isSamePage) {
        this.delegate.visitScrolledToSamePageLocation(this.view.lastRenderedLocation, this.location);
      }

      this.scrolled = true;
    }
  }

  scrollToRestoredPosition() {
    const { scrollPosition } = this.restorationData;
    if (scrollPosition) {
      this.view.scrollToPosition(scrollPosition);
      return true
    }
  }

  scrollToAnchor() {
    const anchor = getAnchor(this.location);
    if (anchor != null) {
      this.view.scrollToAnchor(anchor);
      return true
    }
  }

  // Instrumentation

  recordTimingMetric(metric) {
    this.timingMetrics[metric] = new Date().getTime();
  }

  getTimingMetrics() {
    return { ...this.timingMetrics }
  }

  // Private

  getHistoryMethodForAction(action) {
    switch (action) {
      case "replace":
        return history.replaceState
      case "advance":
      case "restore":
        return history.pushState
    }
  }

  hasPreloadedResponse() {
    return typeof this.response == "object"
  }

  shouldIssueRequest() {
    if (this.isSamePage) {
      return false
    } else if (this.action == "restore") {
      return !this.hasCachedSnapshot()
    } else {
      return this.willRender
    }
  }

  cacheSnapshot() {
    if (!this.snapshotCached) {
      this.view.cacheSnapshot(this.snapshot).then((snapshot) => snapshot && this.visitCachedSnapshot(snapshot));
      this.snapshotCached = true;
    }
  }

  async render(callback) {
    this.cancelRender();
    this.frame = await nextRepaint();
    await callback();
    delete this.frame;
  }

  async renderPageSnapshot(snapshot, isPreview) {
    await this.viewTransitioner.renderChange(this.view.shouldTransitionTo(snapshot), async () => {
      await this.view.renderPage(snapshot, isPreview, this.willRender, this);
      this.performScroll();
    });
  }

  cancelRender() {
    if (this.frame) {
      cancelAnimationFrame(this.frame);
      delete this.frame;
    }
  }
}

function isSuccessful(statusCode) {
  return statusCode >= 200 && statusCode < 300
}

class BrowserAdapter {
  progressBar = new ProgressBar()

  constructor(session) {
    this.session = session;
  }

  visitProposedToLocation(location, options) {
    if (locationIsVisitable(location, this.navigator.rootLocation)) {
      this.navigator.startVisit(location, options?.restorationIdentifier || uuid(), options);
    } else {
      window.location.href = location.toString();
    }
  }

  visitStarted(visit) {
    this.location = visit.location;
    visit.loadCachedSnapshot();
    visit.issueRequest();
    visit.goToSamePageAnchor();
  }

  visitRequestStarted(visit) {
    this.progressBar.setValue(0);
    if (visit.hasCachedSnapshot() || visit.action != "restore") {
      this.showVisitProgressBarAfterDelay();
    } else {
      this.showProgressBar();
    }
  }

  visitRequestCompleted(visit) {
    visit.loadResponse();
  }

  visitRequestFailedWithStatusCode(visit, statusCode) {
    switch (statusCode) {
      case SystemStatusCode.networkFailure:
      case SystemStatusCode.timeoutFailure:
      case SystemStatusCode.contentTypeMismatch:
        return this.reload({
          reason: "request_failed",
          context: {
            statusCode
          }
        })
      default:
        return visit.loadResponse()
    }
  }

  visitRequestFinished(_visit) {}

  visitCompleted(_visit) {
    this.progressBar.setValue(1);
    this.hideVisitProgressBar();
  }

  pageInvalidated(reason) {
    this.reload(reason);
  }

  visitFailed(_visit) {
    this.progressBar.setValue(1);
    this.hideVisitProgressBar();
  }

  visitRendered(_visit) {}

  // Form Submission Delegate

  formSubmissionStarted(_formSubmission) {
    this.progressBar.setValue(0);
    this.showFormProgressBarAfterDelay();
  }

  formSubmissionFinished(_formSubmission) {
    this.progressBar.setValue(1);
    this.hideFormProgressBar();
  }

  // Private

  showVisitProgressBarAfterDelay() {
    this.visitProgressBarTimeout = window.setTimeout(this.showProgressBar, this.session.progressBarDelay);
  }

  hideVisitProgressBar() {
    this.progressBar.hide();
    if (this.visitProgressBarTimeout != null) {
      window.clearTimeout(this.visitProgressBarTimeout);
      delete this.visitProgressBarTimeout;
    }
  }

  showFormProgressBarAfterDelay() {
    if (this.formProgressBarTimeout == null) {
      this.formProgressBarTimeout = window.setTimeout(this.showProgressBar, this.session.progressBarDelay);
    }
  }

  hideFormProgressBar() {
    this.progressBar.hide();
    if (this.formProgressBarTimeout != null) {
      window.clearTimeout(this.formProgressBarTimeout);
      delete this.formProgressBarTimeout;
    }
  }

  showProgressBar = () => {
    this.progressBar.show();
  }

  reload(reason) {
    dispatch("turbo:reload", { detail: reason });

    window.location.href = this.location?.toString() || window.location.href;
  }

  get navigator() {
    return this.session.navigator
  }
}

class CacheObserver {
  selector = "[data-turbo-temporary]"
  deprecatedSelector = "[data-turbo-cache=false]"

  started = false

  start() {
    if (!this.started) {
      this.started = true;
      addEventListener("turbo:before-cache", this.removeTemporaryElements, false);
    }
  }

  stop() {
    if (this.started) {
      this.started = false;
      removeEventListener("turbo:before-cache", this.removeTemporaryElements, false);
    }
  }

  removeTemporaryElements = (_event) => {
    for (const element of this.temporaryElements) {
      element.remove();
    }
  }

  get temporaryElements() {
    return [...document.querySelectorAll(this.selector), ...this.temporaryElementsWithDeprecation]
  }

  get temporaryElementsWithDeprecation() {
    const elements = document.querySelectorAll(this.deprecatedSelector);

    if (elements.length) {
      console.warn(
        `The ${this.deprecatedSelector} selector is deprecated and will be removed in a future version. Use ${this.selector} instead.`
      );
    }

    return [...elements]
  }
}

class FrameRedirector {
  constructor(session, element) {
    this.session = session;
    this.element = element;
    this.linkInterceptor = new LinkInterceptor(this, element);
    this.formSubmitObserver = new FormSubmitObserver(this, element);
  }

  start() {
    this.linkInterceptor.start();
    this.formSubmitObserver.start();
  }

  stop() {
    this.linkInterceptor.stop();
    this.formSubmitObserver.stop();
  }

  // Link interceptor delegate

  shouldInterceptLinkClick(element, _location, _event) {
    return this.#shouldRedirect(element)
  }

  linkClickIntercepted(element, url, event) {
    const frame = this.#findFrameElement(element);
    if (frame) {
      frame.delegate.linkClickIntercepted(element, url, event);
    }
  }

  // Form submit observer delegate

  willSubmitForm(element, submitter) {
    return (
      element.closest("turbo-frame") == null &&
      this.#shouldSubmit(element, submitter) &&
      this.#shouldRedirect(element, submitter)
    )
  }

  formSubmitted(element, submitter) {
    const frame = this.#findFrameElement(element, submitter);
    if (frame) {
      frame.delegate.formSubmitted(element, submitter);
    }
  }

  #shouldSubmit(form, submitter) {
    const action = getAction$1(form, submitter);
    const meta = this.element.ownerDocument.querySelector(`meta[name="turbo-root"]`);
    const rootLocation = expandURL(meta?.content ?? "/");

    return this.#shouldRedirect(form, submitter) && locationIsVisitable(action, rootLocation)
  }

  #shouldRedirect(element, submitter) {
    const isNavigatable =
      element instanceof HTMLFormElement
        ? this.session.submissionIsNavigatable(element, submitter)
        : this.session.elementIsNavigatable(element);

    if (isNavigatable) {
      const frame = this.#findFrameElement(element, submitter);
      return frame ? frame != element.closest("turbo-frame") : false
    } else {
      return false
    }
  }

  #findFrameElement(element, submitter) {
    const id = submitter?.getAttribute("data-turbo-frame") || element.getAttribute("data-turbo-frame");
    if (id && id != "_top") {
      const frame = this.element.querySelector(`#${id}:not([disabled])`);
      if (frame instanceof FrameElement) {
        return frame
      }
    }
  }
}

class History {
  location
  restorationIdentifier = uuid()
  restorationData = {}
  started = false
  pageLoaded = false
  currentIndex = 0

  constructor(delegate) {
    this.delegate = delegate;
  }

  start() {
    if (!this.started) {
      addEventListener("popstate", this.onPopState, false);
      addEventListener("load", this.onPageLoad, false);
      this.currentIndex = history.state?.turbo?.restorationIndex || 0;
      this.started = true;
      this.replace(new URL(window.location.href));
    }
  }

  stop() {
    if (this.started) {
      removeEventListener("popstate", this.onPopState, false);
      removeEventListener("load", this.onPageLoad, false);
      this.started = false;
    }
  }

  push(location, restorationIdentifier) {
    this.update(history.pushState, location, restorationIdentifier);
  }

  replace(location, restorationIdentifier) {
    this.update(history.replaceState, location, restorationIdentifier);
  }

  update(method, location, restorationIdentifier = uuid()) {
    if (method === history.pushState) ++this.currentIndex;

    const state = { turbo: { restorationIdentifier, restorationIndex: this.currentIndex } };
    method.call(history, state, "", location.href);
    this.location = location;
    this.restorationIdentifier = restorationIdentifier;
  }

  // Restoration data

  getRestorationDataForIdentifier(restorationIdentifier) {
    return this.restorationData[restorationIdentifier] || {}
  }

  updateRestorationData(additionalData) {
    const { restorationIdentifier } = this;
    const restorationData = this.restorationData[restorationIdentifier];
    this.restorationData[restorationIdentifier] = {
      ...restorationData,
      ...additionalData
    };
  }

  // Scroll restoration

  assumeControlOfScrollRestoration() {
    if (!this.previousScrollRestoration) {
      this.previousScrollRestoration = history.scrollRestoration ?? "auto";
      history.scrollRestoration = "manual";
    }
  }

  relinquishControlOfScrollRestoration() {
    if (this.previousScrollRestoration) {
      history.scrollRestoration = this.previousScrollRestoration;
      delete this.previousScrollRestoration;
    }
  }

  // Event handlers

  onPopState = (event) => {
    if (this.shouldHandlePopState()) {
      const { turbo } = event.state || {};
      if (turbo) {
        this.location = new URL(window.location.href);
        const { restorationIdentifier, restorationIndex } = turbo;
        this.restorationIdentifier = restorationIdentifier;
        const direction = restorationIndex > this.currentIndex ? "forward" : "back";
        this.delegate.historyPoppedToLocationWithRestorationIdentifierAndDirection(this.location, restorationIdentifier, direction);
        this.currentIndex = restorationIndex;
      }
    }
  }

  onPageLoad = async (_event) => {
    await nextMicrotask();
    this.pageLoaded = true;
  }

  // Private

  shouldHandlePopState() {
    // Safari dispatches a popstate event after window's load event, ignore it
    return this.pageIsLoaded()
  }

  pageIsLoaded() {
    return this.pageLoaded || document.readyState == "complete"
  }
}

class LinkPrefetchObserver {
  started = false
  #prefetchedLink = null

  constructor(delegate, eventTarget) {
    this.delegate = delegate;
    this.eventTarget = eventTarget;
  }

  start() {
    if (this.started) return

    if (this.eventTarget.readyState === "loading") {
      this.eventTarget.addEventListener("DOMContentLoaded", this.#enable, { once: true });
    } else {
      this.#enable();
    }
  }

  stop() {
    if (!this.started) return

    this.eventTarget.removeEventListener("mouseenter", this.#tryToPrefetchRequest, {
      capture: true,
      passive: true
    });
    this.eventTarget.removeEventListener("mouseleave", this.#cancelRequestIfObsolete, {
      capture: true,
      passive: true
    });

    this.eventTarget.removeEventListener("turbo:before-fetch-request", this.#tryToUsePrefetchedRequest, true);
    this.started = false;
  }

  #enable = () => {
    this.eventTarget.addEventListener("mouseenter", this.#tryToPrefetchRequest, {
      capture: true,
      passive: true
    });
    this.eventTarget.addEventListener("mouseleave", this.#cancelRequestIfObsolete, {
      capture: true,
      passive: true
    });

    this.eventTarget.addEventListener("turbo:before-fetch-request", this.#tryToUsePrefetchedRequest, true);
    this.started = true;
  }

  #tryToPrefetchRequest = (event) => {
    if (getMetaContent("turbo-prefetch") === "false") return

    const target = event.target;
    const isLink = target.matches && target.matches("a[href]:not([target^=_]):not([download])");

    if (isLink && this.#isPrefetchable(target)) {
      const link = target;
      const location = getLocationForLink(link);

      if (this.delegate.canPrefetchRequestToLocation(link, location)) {
        this.#prefetchedLink = link;

        const fetchRequest = new FetchRequest(
          this,
          FetchMethod.get,
          location,
          new URLSearchParams(),
          target
        );

        prefetchCache.setLater(location.toString(), fetchRequest, this.#cacheTtl);
      }
    }
  }

  #cancelRequestIfObsolete = (event) => {
    if (event.target === this.#prefetchedLink) this.#cancelPrefetchRequest();
  }

  #cancelPrefetchRequest = () => {
    prefetchCache.clear();
    this.#prefetchedLink = null;
  }

  #tryToUsePrefetchedRequest = (event) => {
    if (event.target.tagName !== "FORM" && event.detail.fetchOptions.method === "get") {
      const cached = prefetchCache.get(event.detail.url.toString());

      if (cached) {
        // User clicked link, use cache response
        event.detail.fetchRequest = cached;
      }

      prefetchCache.clear();
    }
  }

  prepareRequest(request) {
    const link = request.target;

    request.headers["X-Sec-Purpose"] = "prefetch";

    const turboFrame = link.closest("turbo-frame");
    const turboFrameTarget = link.getAttribute("data-turbo-frame") || turboFrame?.getAttribute("target") || turboFrame?.id;

    if (turboFrameTarget && turboFrameTarget !== "_top") {
      request.headers["Turbo-Frame"] = turboFrameTarget;
    }
  }

  // Fetch request interface

  requestSucceededWithResponse() {}

  requestStarted(fetchRequest) {}

  requestErrored(fetchRequest) {}

  requestFinished(fetchRequest) {}

  requestPreventedHandlingResponse(fetchRequest, fetchResponse) {}

  requestFailedWithResponse(fetchRequest, fetchResponse) {}

  get #cacheTtl() {
    return Number(getMetaContent("turbo-prefetch-cache-time")) || cacheTtl
  }

  #isPrefetchable(link) {
    const href = link.getAttribute("href");

    if (!href) return false

    if (unfetchableLink(link)) return false
    if (linkToTheSamePage(link)) return false
    if (linkOptsOut(link)) return false
    if (nonSafeLink(link)) return false
    if (eventPrevented(link)) return false

    return true
  }
}

const unfetchableLink = (link) => {
  return link.origin !== document.location.origin || !["http:", "https:"].includes(link.protocol) || link.hasAttribute("target")
};

const linkToTheSamePage = (link) => {
  return (link.pathname + link.search === document.location.pathname + document.location.search) || link.href.startsWith("#")
};

const linkOptsOut = (link) => {
  if (link.getAttribute("data-turbo-prefetch") === "false") return true
  if (link.getAttribute("data-turbo") === "false") return true

  const turboPrefetchParent = findClosestRecursively(link, "[data-turbo-prefetch]");
  if (turboPrefetchParent && turboPrefetchParent.getAttribute("data-turbo-prefetch") === "false") return true

  return false
};

const nonSafeLink = (link) => {
  const turboMethod = link.getAttribute("data-turbo-method");
  if (turboMethod && turboMethod.toLowerCase() !== "get") return true

  if (isUJS(link)) return true
  if (link.hasAttribute("data-turbo-confirm")) return true
  if (link.hasAttribute("data-turbo-stream")) return true

  return false
};

const isUJS = (link) => {
  return link.hasAttribute("data-remote") || link.hasAttribute("data-behavior") || link.hasAttribute("data-confirm") || link.hasAttribute("data-method")
};

const eventPrevented = (link) => {
  const event = dispatch("turbo:before-prefetch", { target: link, cancelable: true });
  return event.defaultPrevented
};

class Navigator {
  constructor(delegate) {
    this.delegate = delegate;
  }

  proposeVisit(location, options = {}) {
    if (this.delegate.allowsVisitingLocationWithAction(location, options.action)) {
      this.delegate.visitProposedToLocation(location, options);
    }
  }

  startVisit(locatable, restorationIdentifier, options = {}) {
    this.stop();
    this.currentVisit = new Visit(this, expandURL(locatable), restorationIdentifier, {
      referrer: this.location,
      ...options
    });
    this.currentVisit.start();
  }

  submitForm(form, submitter) {
    this.stop();
    this.formSubmission = new FormSubmission(this, form, submitter, true);

    this.formSubmission.start();
  }

  stop() {
    if (this.formSubmission) {
      this.formSubmission.stop();
      delete this.formSubmission;
    }

    if (this.currentVisit) {
      this.currentVisit.cancel();
      delete this.currentVisit;
    }
  }

  get adapter() {
    return this.delegate.adapter
  }

  get view() {
    return this.delegate.view
  }

  get rootLocation() {
    return this.view.snapshot.rootLocation
  }

  get history() {
    return this.delegate.history
  }

  // Form submission delegate

  formSubmissionStarted(formSubmission) {
    // Not all adapters implement formSubmissionStarted
    if (typeof this.adapter.formSubmissionStarted === "function") {
      this.adapter.formSubmissionStarted(formSubmission);
    }
  }

  async formSubmissionSucceededWithResponse(formSubmission, fetchResponse) {
    if (formSubmission == this.formSubmission) {
      const responseHTML = await fetchResponse.responseHTML;
      if (responseHTML) {
        const shouldCacheSnapshot = formSubmission.isSafe;
        if (!shouldCacheSnapshot) {
          this.view.clearSnapshotCache();
        }

        const { statusCode, redirected } = fetchResponse;
        const action = this.#getActionForFormSubmission(formSubmission, fetchResponse);
        const visitOptions = {
          action,
          shouldCacheSnapshot,
          response: { statusCode, responseHTML, redirected }
        };
        this.proposeVisit(fetchResponse.location, visitOptions);
      }
    }
  }

  async formSubmissionFailedWithResponse(formSubmission, fetchResponse) {
    const responseHTML = await fetchResponse.responseHTML;

    if (responseHTML) {
      const snapshot = PageSnapshot.fromHTMLString(responseHTML);
      if (fetchResponse.serverError) {
        await this.view.renderError(snapshot, this.currentVisit);
      } else {
        await this.view.renderPage(snapshot, false, true, this.currentVisit);
      }
      if(!snapshot.shouldPreserveScrollPosition) {
        this.view.scrollToTop();
      }
      this.view.clearSnapshotCache();
    }
  }

  formSubmissionErrored(formSubmission, error) {
    console.error(error);
  }

  formSubmissionFinished(formSubmission) {
    // Not all adapters implement formSubmissionFinished
    if (typeof this.adapter.formSubmissionFinished === "function") {
      this.adapter.formSubmissionFinished(formSubmission);
    }
  }

  // Visit delegate

  visitStarted(visit) {
    this.delegate.visitStarted(visit);
  }

  visitCompleted(visit) {
    this.delegate.visitCompleted(visit);
  }

  locationWithActionIsSamePage(location, action) {
    const anchor = getAnchor(location);
    const currentAnchor = getAnchor(this.view.lastRenderedLocation);
    const isRestorationToTop = action === "restore" && typeof anchor === "undefined";

    return (
      action !== "replace" &&
      getRequestURL(location) === getRequestURL(this.view.lastRenderedLocation) &&
      (isRestorationToTop || (anchor != null && anchor !== currentAnchor))
    )
  }

  visitScrolledToSamePageLocation(oldURL, newURL) {
    this.delegate.visitScrolledToSamePageLocation(oldURL, newURL);
  }

  // Visits

  get location() {
    return this.history.location
  }

  get restorationIdentifier() {
    return this.history.restorationIdentifier
  }

  #getActionForFormSubmission(formSubmission, fetchResponse) {
    const { submitter, formElement } = formSubmission;
    return getVisitAction(submitter, formElement) || this.#getDefaultAction(fetchResponse)
  }

  #getDefaultAction(fetchResponse) {
    const sameLocationRedirect = fetchResponse.redirected && fetchResponse.location.href === this.location?.href;
    return sameLocationRedirect ? "replace" : "advance"
  }
}

const PageStage = {
  initial: 0,
  loading: 1,
  interactive: 2,
  complete: 3
};

class PageObserver {
  stage = PageStage.initial
  started = false

  constructor(delegate) {
    this.delegate = delegate;
  }

  start() {
    if (!this.started) {
      if (this.stage == PageStage.initial) {
        this.stage = PageStage.loading;
      }
      document.addEventListener("readystatechange", this.interpretReadyState, false);
      addEventListener("pagehide", this.pageWillUnload, false);
      this.started = true;
    }
  }

  stop() {
    if (this.started) {
      document.removeEventListener("readystatechange", this.interpretReadyState, false);
      removeEventListener("pagehide", this.pageWillUnload, false);
      this.started = false;
    }
  }

  interpretReadyState = () => {
    const { readyState } = this;
    if (readyState == "interactive") {
      this.pageIsInteractive();
    } else if (readyState == "complete") {
      this.pageIsComplete();
    }
  }

  pageIsInteractive() {
    if (this.stage == PageStage.loading) {
      this.stage = PageStage.interactive;
      this.delegate.pageBecameInteractive();
    }
  }

  pageIsComplete() {
    this.pageIsInteractive();
    if (this.stage == PageStage.interactive) {
      this.stage = PageStage.complete;
      this.delegate.pageLoaded();
    }
  }

  pageWillUnload = () => {
    this.delegate.pageWillUnload();
  }

  get readyState() {
    return document.readyState
  }
}

class ScrollObserver {
  started = false

  constructor(delegate) {
    this.delegate = delegate;
  }

  start() {
    if (!this.started) {
      addEventListener("scroll", this.onScroll, false);
      this.onScroll();
      this.started = true;
    }
  }

  stop() {
    if (this.started) {
      removeEventListener("scroll", this.onScroll, false);
      this.started = false;
    }
  }

  onScroll = () => {
    this.updatePosition({ x: window.pageXOffset, y: window.pageYOffset });
  }

  // Private

  updatePosition(position) {
    this.delegate.scrollPositionChanged(position);
  }
}

class StreamMessageRenderer {
  render({ fragment }) {
    Bardo.preservingPermanentElements(this, getPermanentElementMapForFragment(fragment), () => {
      withAutofocusFromFragment(fragment, () => {
        withPreservedFocus(() => {
          document.documentElement.appendChild(fragment);
        });
      });
    });
  }

  // Bardo delegate

  enteringBardo(currentPermanentElement, newPermanentElement) {
    newPermanentElement.replaceWith(currentPermanentElement.cloneNode(true));
  }

  leavingBardo() {}
}

function getPermanentElementMapForFragment(fragment) {
  const permanentElementsInDocument = queryPermanentElementsAll(document.documentElement);
  const permanentElementMap = {};
  for (const permanentElementInDocument of permanentElementsInDocument) {
    const { id } = permanentElementInDocument;

    for (const streamElement of fragment.querySelectorAll("turbo-stream")) {
      const elementInStream = getPermanentElementById(streamElement.templateElement.content, id);

      if (elementInStream) {
        permanentElementMap[id] = [permanentElementInDocument, elementInStream];
      }
    }
  }

  return permanentElementMap
}

async function withAutofocusFromFragment(fragment, callback) {
  const generatedID = `turbo-stream-autofocus-${uuid()}`;
  const turboStreams = fragment.querySelectorAll("turbo-stream");
  const elementWithAutofocus = firstAutofocusableElementInStreams(turboStreams);
  let willAutofocusId = null;

  if (elementWithAutofocus) {
    if (elementWithAutofocus.id) {
      willAutofocusId = elementWithAutofocus.id;
    } else {
      willAutofocusId = generatedID;
    }

    elementWithAutofocus.id = willAutofocusId;
  }

  callback();
  await nextRepaint();

  const hasNoActiveElement = document.activeElement == null || document.activeElement == document.body;

  if (hasNoActiveElement && willAutofocusId) {
    const elementToAutofocus = document.getElementById(willAutofocusId);

    if (elementIsFocusable(elementToAutofocus)) {
      elementToAutofocus.focus();
    }
    if (elementToAutofocus && elementToAutofocus.id == generatedID) {
      elementToAutofocus.removeAttribute("id");
    }
  }
}

async function withPreservedFocus(callback) {
  const [activeElementBeforeRender, activeElementAfterRender] = await around(callback, () => document.activeElement);

  const restoreFocusTo = activeElementBeforeRender && activeElementBeforeRender.id;

  if (restoreFocusTo) {
    const elementToFocus = document.getElementById(restoreFocusTo);

    if (elementIsFocusable(elementToFocus) && elementToFocus != activeElementAfterRender) {
      elementToFocus.focus();
    }
  }
}

function firstAutofocusableElementInStreams(nodeListOfStreamElements) {
  for (const streamElement of nodeListOfStreamElements) {
    const elementWithAutofocus = queryAutofocusableElement(streamElement.templateElement.content);

    if (elementWithAutofocus) return elementWithAutofocus
  }

  return null
}

class StreamObserver {
  sources = new Set()
  #started = false

  constructor(delegate) {
    this.delegate = delegate;
  }

  start() {
    if (!this.#started) {
      this.#started = true;
      addEventListener("turbo:before-fetch-response", this.inspectFetchResponse, false);
    }
  }

  stop() {
    if (this.#started) {
      this.#started = false;
      removeEventListener("turbo:before-fetch-response", this.inspectFetchResponse, false);
    }
  }

  connectStreamSource(source) {
    if (!this.streamSourceIsConnected(source)) {
      this.sources.add(source);
      source.addEventListener("message", this.receiveMessageEvent, false);
    }
  }

  disconnectStreamSource(source) {
    if (this.streamSourceIsConnected(source)) {
      this.sources.delete(source);
      source.removeEventListener("message", this.receiveMessageEvent, false);
    }
  }

  streamSourceIsConnected(source) {
    return this.sources.has(source)
  }

  inspectFetchResponse = (event) => {
    const response = fetchResponseFromEvent(event);
    if (response && fetchResponseIsStream(response)) {
      event.preventDefault();
      this.receiveMessageResponse(response);
    }
  }

  receiveMessageEvent = (event) => {
    if (this.#started && typeof event.data == "string") {
      this.receiveMessageHTML(event.data);
    }
  }

  async receiveMessageResponse(response) {
    const html = await response.responseHTML;
    if (html) {
      this.receiveMessageHTML(html);
    }
  }

  receiveMessageHTML(html) {
    this.delegate.receivedMessageFromStream(StreamMessage.wrap(html));
  }
}

function fetchResponseFromEvent(event) {
  const fetchResponse = event.detail?.fetchResponse;
  if (fetchResponse instanceof FetchResponse) {
    return fetchResponse
  }
}

function fetchResponseIsStream(response) {
  const contentType = response.contentType ?? "";
  return contentType.startsWith(StreamMessage.contentType)
}

class ErrorRenderer extends Renderer {
  static renderElement(currentElement, newElement) {
    const { documentElement, body } = document;

    documentElement.replaceChild(newElement, body);
  }

  async render() {
    this.replaceHeadAndBody();
    this.activateScriptElements();
  }

  replaceHeadAndBody() {
    const { documentElement, head } = document;
    documentElement.replaceChild(this.newHead, head);
    this.renderElement(this.currentElement, this.newElement);
  }

  activateScriptElements() {
    for (const replaceableElement of this.scriptElements) {
      const parentNode = replaceableElement.parentNode;
      if (parentNode) {
        const element = activateScriptElement(replaceableElement);
        parentNode.replaceChild(element, replaceableElement);
      }
    }
  }

  get newHead() {
    return this.newSnapshot.headSnapshot.element
  }

  get scriptElements() {
    return document.documentElement.querySelectorAll("script")
  }
}

// base IIFE to define idiomorph
var Idiomorph = (function () {

        //=============================================================================
        // AND NOW IT BEGINS...
        //=============================================================================
        let EMPTY_SET = new Set();

        // default configuration values, updatable by users now
        let defaults = {
            morphStyle: "outerHTML",
            callbacks : {
                beforeNodeAdded: noOp,
                afterNodeAdded: noOp,
                beforeNodeMorphed: noOp,
                afterNodeMorphed: noOp,
                beforeNodeRemoved: noOp,
                afterNodeRemoved: noOp,
                beforeAttributeUpdated: noOp,

            },
            head: {
                style: 'merge',
                shouldPreserve: function (elt) {
                    return elt.getAttribute("im-preserve") === "true";
                },
                shouldReAppend: function (elt) {
                    return elt.getAttribute("im-re-append") === "true";
                },
                shouldRemove: noOp,
                afterHeadMorphed: noOp,
            }
        };

        //=============================================================================
        // Core Morphing Algorithm - morph, morphNormalizedContent, morphOldNodeTo, morphChildren
        //=============================================================================
        function morph(oldNode, newContent, config = {}) {

            if (oldNode instanceof Document) {
                oldNode = oldNode.documentElement;
            }

            if (typeof newContent === 'string') {
                newContent = parseContent(newContent);
            }

            let normalizedContent = normalizeContent(newContent);

            let ctx = createMorphContext(oldNode, normalizedContent, config);

            return morphNormalizedContent(oldNode, normalizedContent, ctx);
        }

        function morphNormalizedContent(oldNode, normalizedNewContent, ctx) {
            if (ctx.head.block) {
                let oldHead = oldNode.querySelector('head');
                let newHead = normalizedNewContent.querySelector('head');
                if (oldHead && newHead) {
                    let promises = handleHeadElement(newHead, oldHead, ctx);
                    // when head promises resolve, call morph again, ignoring the head tag
                    Promise.all(promises).then(function () {
                        morphNormalizedContent(oldNode, normalizedNewContent, Object.assign(ctx, {
                            head: {
                                block: false,
                                ignore: true
                            }
                        }));
                    });
                    return;
                }
            }

            if (ctx.morphStyle === "innerHTML") {

                // innerHTML, so we are only updating the children
                morphChildren(normalizedNewContent, oldNode, ctx);
                return oldNode.children;

            } else if (ctx.morphStyle === "outerHTML" || ctx.morphStyle == null) {
                // otherwise find the best element match in the new content, morph that, and merge its siblings
                // into either side of the best match
                let bestMatch = findBestNodeMatch(normalizedNewContent, oldNode, ctx);

                // stash the siblings that will need to be inserted on either side of the best match
                let previousSibling = bestMatch?.previousSibling;
                let nextSibling = bestMatch?.nextSibling;

                // morph it
                let morphedNode = morphOldNodeTo(oldNode, bestMatch, ctx);

                if (bestMatch) {
                    // if there was a best match, merge the siblings in too and return the
                    // whole bunch
                    return insertSiblings(previousSibling, morphedNode, nextSibling);
                } else {
                    // otherwise nothing was added to the DOM
                    return []
                }
            } else {
                throw "Do not understand how to morph style " + ctx.morphStyle;
            }
        }


        /**
         * @param possibleActiveElement
         * @param ctx
         * @returns {boolean}
         */
        function ignoreValueOfActiveElement(possibleActiveElement, ctx) {
            return ctx.ignoreActiveValue && possibleActiveElement === document.activeElement && possibleActiveElement !== document.body;
        }

        /**
         * @param oldNode root node to merge content into
         * @param newContent new content to merge
         * @param ctx the merge context
         * @returns {Element} the element that ended up in the DOM
         */
        function morphOldNodeTo(oldNode, newContent, ctx) {
            if (ctx.ignoreActive && oldNode === document.activeElement) ; else if (newContent == null) {
                if (ctx.callbacks.beforeNodeRemoved(oldNode) === false) return oldNode;

                oldNode.remove();
                ctx.callbacks.afterNodeRemoved(oldNode);
                return null;
            } else if (!isSoftMatch(oldNode, newContent)) {
                if (ctx.callbacks.beforeNodeRemoved(oldNode) === false) return oldNode;
                if (ctx.callbacks.beforeNodeAdded(newContent) === false) return oldNode;

                oldNode.parentElement.replaceChild(newContent, oldNode);
                ctx.callbacks.afterNodeAdded(newContent);
                ctx.callbacks.afterNodeRemoved(oldNode);
                return newContent;
            } else {
                if (ctx.callbacks.beforeNodeMorphed(oldNode, newContent) === false) return oldNode;

                if (oldNode instanceof HTMLHeadElement && ctx.head.ignore) ; else if (oldNode instanceof HTMLHeadElement && ctx.head.style !== "morph") {
                    handleHeadElement(newContent, oldNode, ctx);
                } else {
                    syncNodeFrom(newContent, oldNode, ctx);
                    if (!ignoreValueOfActiveElement(oldNode, ctx)) {
                        morphChildren(newContent, oldNode, ctx);
                    }
                }
                ctx.callbacks.afterNodeMorphed(oldNode, newContent);
                return oldNode;
            }
        }

        /**
         * This is the core algorithm for matching up children.  The idea is to use id sets to try to match up
         * nodes as faithfully as possible.  We greedily match, which allows us to keep the algorithm fast, but
         * by using id sets, we are able to better match up with content deeper in the DOM.
         *
         * Basic algorithm is, for each node in the new content:
         *
         * - if we have reached the end of the old parent, append the new content
         * - if the new content has an id set match with the current insertion point, morph
         * - search for an id set match
         * - if id set match found, morph
         * - otherwise search for a "soft" match
         * - if a soft match is found, morph
         * - otherwise, prepend the new node before the current insertion point
         *
         * The two search algorithms terminate if competing node matches appear to outweigh what can be achieved
         * with the current node.  See findIdSetMatch() and findSoftMatch() for details.
         *
         * @param {Element} newParent the parent element of the new content
         * @param {Element } oldParent the old content that we are merging the new content into
         * @param ctx the merge context
         */
        function morphChildren(newParent, oldParent, ctx) {

            let nextNewChild = newParent.firstChild;
            let insertionPoint = oldParent.firstChild;
            let newChild;

            // run through all the new content
            while (nextNewChild) {

                newChild = nextNewChild;
                nextNewChild = newChild.nextSibling;

                // if we are at the end of the exiting parent's children, just append
                if (insertionPoint == null) {
                    if (ctx.callbacks.beforeNodeAdded(newChild) === false) return;

                    oldParent.appendChild(newChild);
                    ctx.callbacks.afterNodeAdded(newChild);
                    removeIdsFromConsideration(ctx, newChild);
                    continue;
                }

                // if the current node has an id set match then morph
                if (isIdSetMatch(newChild, insertionPoint, ctx)) {
                    morphOldNodeTo(insertionPoint, newChild, ctx);
                    insertionPoint = insertionPoint.nextSibling;
                    removeIdsFromConsideration(ctx, newChild);
                    continue;
                }

                // otherwise search forward in the existing old children for an id set match
                let idSetMatch = findIdSetMatch(newParent, oldParent, newChild, insertionPoint, ctx);

                // if we found a potential match, remove the nodes until that point and morph
                if (idSetMatch) {
                    insertionPoint = removeNodesBetween(insertionPoint, idSetMatch, ctx);
                    morphOldNodeTo(idSetMatch, newChild, ctx);
                    removeIdsFromConsideration(ctx, newChild);
                    continue;
                }

                // no id set match found, so scan forward for a soft match for the current node
                let softMatch = findSoftMatch(newParent, oldParent, newChild, insertionPoint, ctx);

                // if we found a soft match for the current node, morph
                if (softMatch) {
                    insertionPoint = removeNodesBetween(insertionPoint, softMatch, ctx);
                    morphOldNodeTo(softMatch, newChild, ctx);
                    removeIdsFromConsideration(ctx, newChild);
                    continue;
                }

                // abandon all hope of morphing, just insert the new child before the insertion point
                // and move on
                if (ctx.callbacks.beforeNodeAdded(newChild) === false) return;

                oldParent.insertBefore(newChild, insertionPoint);
                ctx.callbacks.afterNodeAdded(newChild);
                removeIdsFromConsideration(ctx, newChild);
            }

            // remove any remaining old nodes that didn't match up with new content
            while (insertionPoint !== null) {

                let tempNode = insertionPoint;
                insertionPoint = insertionPoint.nextSibling;
                removeNode(tempNode, ctx);
            }
        }

        //=============================================================================
        // Attribute Syncing Code
        //=============================================================================

        /**
         * @param attr {String} the attribute to be mutated
         * @param to {Element} the element that is going to be updated
         * @param updateType {("update"|"remove")}
         * @param ctx the merge context
         * @returns {boolean} true if the attribute should be ignored, false otherwise
         */
        function ignoreAttribute(attr, to, updateType, ctx) {
            if(attr === 'value' && ctx.ignoreActiveValue && to === document.activeElement){
                return true;
            }
            return ctx.callbacks.beforeAttributeUpdated(attr, to, updateType) === false;
        }

        /**
         * syncs a given node with another node, copying over all attributes and
         * inner element state from the 'from' node to the 'to' node
         *
         * @param {Element} from the element to copy attributes & state from
         * @param {Element} to the element to copy attributes & state to
         * @param ctx the merge context
         */
        function syncNodeFrom(from, to, ctx) {
            let type = from.nodeType;

            // if is an element type, sync the attributes from the
            // new node into the new node
            if (type === 1 /* element type */) {
                const fromAttributes = from.attributes;
                const toAttributes = to.attributes;
                for (const fromAttribute of fromAttributes) {
                    if (ignoreAttribute(fromAttribute.name, to, 'update', ctx)) {
                        continue;
                    }
                    if (to.getAttribute(fromAttribute.name) !== fromAttribute.value) {
                        to.setAttribute(fromAttribute.name, fromAttribute.value);
                    }
                }
                // iterate backwards to avoid skipping over items when a delete occurs
                for (let i = toAttributes.length - 1; 0 <= i; i--) {
                    const toAttribute = toAttributes[i];
                    if (ignoreAttribute(toAttribute.name, to, 'remove', ctx)) {
                        continue;
                    }
                    if (!from.hasAttribute(toAttribute.name)) {
                        to.removeAttribute(toAttribute.name);
                    }
                }
            }

            // sync text nodes
            if (type === 8 /* comment */ || type === 3 /* text */) {
                if (to.nodeValue !== from.nodeValue) {
                    to.nodeValue = from.nodeValue;
                }
            }

            if (!ignoreValueOfActiveElement(to, ctx)) {
                // sync input values
                syncInputValue(from, to, ctx);
            }
        }

        /**
         * @param from {Element} element to sync the value from
         * @param to {Element} element to sync the value to
         * @param attributeName {String} the attribute name
         * @param ctx the merge context
         */
        function syncBooleanAttribute(from, to, attributeName, ctx) {
            if (from[attributeName] !== to[attributeName]) {
                let ignoreUpdate = ignoreAttribute(attributeName, to, 'update', ctx);
                if (!ignoreUpdate) {
                    to[attributeName] = from[attributeName];
                }
                if (from[attributeName]) {
                    if (!ignoreUpdate) {
                        to.setAttribute(attributeName, from[attributeName]);
                    }
                } else {
                    if (!ignoreAttribute(attributeName, to, 'remove', ctx)) {
                        to.removeAttribute(attributeName);
                    }
                }
            }
        }

        /**
         * NB: many bothans died to bring us information:
         *
         *  https://github.com/patrick-steele-idem/morphdom/blob/master/src/specialElHandlers.js
         *  https://github.com/choojs/nanomorph/blob/master/lib/morph.jsL113
         *
         * @param from {Element} the element to sync the input value from
         * @param to {Element} the element to sync the input value to
         * @param ctx the merge context
         */
        function syncInputValue(from, to, ctx) {
            if (from instanceof HTMLInputElement &&
                to instanceof HTMLInputElement &&
                from.type !== 'file') {

                let fromValue = from.value;
                let toValue = to.value;

                // sync boolean attributes
                syncBooleanAttribute(from, to, 'checked', ctx);
                syncBooleanAttribute(from, to, 'disabled', ctx);

                if (!from.hasAttribute('value')) {
                    if (!ignoreAttribute('value', to, 'remove', ctx)) {
                        to.value = '';
                        to.removeAttribute('value');
                    }
                } else if (fromValue !== toValue) {
                    if (!ignoreAttribute('value', to, 'update', ctx)) {
                        to.setAttribute('value', fromValue);
                        to.value = fromValue;
                    }
                }
            } else if (from instanceof HTMLOptionElement) {
                syncBooleanAttribute(from, to, 'selected', ctx);
            } else if (from instanceof HTMLTextAreaElement && to instanceof HTMLTextAreaElement) {
                let fromValue = from.value;
                let toValue = to.value;
                if (ignoreAttribute('value', to, 'update', ctx)) {
                    return;
                }
                if (fromValue !== toValue) {
                    to.value = fromValue;
                }
                if (to.firstChild && to.firstChild.nodeValue !== fromValue) {
                    to.firstChild.nodeValue = fromValue;
                }
            }
        }

        //=============================================================================
        // the HEAD tag can be handled specially, either w/ a 'merge' or 'append' style
        //=============================================================================
        function handleHeadElement(newHeadTag, currentHead, ctx) {

            let added = [];
            let removed = [];
            let preserved = [];
            let nodesToAppend = [];

            let headMergeStyle = ctx.head.style;

            // put all new head elements into a Map, by their outerHTML
            let srcToNewHeadNodes = new Map();
            for (const newHeadChild of newHeadTag.children) {
                srcToNewHeadNodes.set(newHeadChild.outerHTML, newHeadChild);
            }

            // for each elt in the current head
            for (const currentHeadElt of currentHead.children) {

                // If the current head element is in the map
                let inNewContent = srcToNewHeadNodes.has(currentHeadElt.outerHTML);
                let isReAppended = ctx.head.shouldReAppend(currentHeadElt);
                let isPreserved = ctx.head.shouldPreserve(currentHeadElt);
                if (inNewContent || isPreserved) {
                    if (isReAppended) {
                        // remove the current version and let the new version replace it and re-execute
                        removed.push(currentHeadElt);
                    } else {
                        // this element already exists and should not be re-appended, so remove it from
                        // the new content map, preserving it in the DOM
                        srcToNewHeadNodes.delete(currentHeadElt.outerHTML);
                        preserved.push(currentHeadElt);
                    }
                } else {
                    if (headMergeStyle === "append") {
                        // we are appending and this existing element is not new content
                        // so if and only if it is marked for re-append do we do anything
                        if (isReAppended) {
                            removed.push(currentHeadElt);
                            nodesToAppend.push(currentHeadElt);
                        }
                    } else {
                        // if this is a merge, we remove this content since it is not in the new head
                        if (ctx.head.shouldRemove(currentHeadElt) !== false) {
                            removed.push(currentHeadElt);
                        }
                    }
                }
            }

            // Push the remaining new head elements in the Map into the
            // nodes to append to the head tag
            nodesToAppend.push(...srcToNewHeadNodes.values());

            let promises = [];
            for (const newNode of nodesToAppend) {
                let newElt = document.createRange().createContextualFragment(newNode.outerHTML).firstChild;
                if (ctx.callbacks.beforeNodeAdded(newElt) !== false) {
                    if (newElt.href || newElt.src) {
                        let resolve = null;
                        let promise = new Promise(function (_resolve) {
                            resolve = _resolve;
                        });
                        newElt.addEventListener('load', function () {
                            resolve();
                        });
                        promises.push(promise);
                    }
                    currentHead.appendChild(newElt);
                    ctx.callbacks.afterNodeAdded(newElt);
                    added.push(newElt);
                }
            }

            // remove all removed elements, after we have appended the new elements to avoid
            // additional network requests for things like style sheets
            for (const removedElement of removed) {
                if (ctx.callbacks.beforeNodeRemoved(removedElement) !== false) {
                    currentHead.removeChild(removedElement);
                    ctx.callbacks.afterNodeRemoved(removedElement);
                }
            }

            ctx.head.afterHeadMorphed(currentHead, {added: added, kept: preserved, removed: removed});
            return promises;
        }

        function noOp() {
        }

        /*
          Deep merges the config object and the Idiomoroph.defaults object to
          produce a final configuration object
         */
        function mergeDefaults(config) {
            let finalConfig = {};
            // copy top level stuff into final config
            Object.assign(finalConfig, defaults);
            Object.assign(finalConfig, config);

            // copy callbacks into final config (do this to deep merge the callbacks)
            finalConfig.callbacks = {};
            Object.assign(finalConfig.callbacks, defaults.callbacks);
            Object.assign(finalConfig.callbacks, config.callbacks);

            // copy head config into final config  (do this to deep merge the head)
            finalConfig.head = {};
            Object.assign(finalConfig.head, defaults.head);
            Object.assign(finalConfig.head, config.head);
            return finalConfig;
        }

        function createMorphContext(oldNode, newContent, config) {
            config = mergeDefaults(config);
            return {
                target: oldNode,
                newContent: newContent,
                config: config,
                morphStyle: config.morphStyle,
                ignoreActive: config.ignoreActive,
                ignoreActiveValue: config.ignoreActiveValue,
                idMap: createIdMap(oldNode, newContent),
                deadIds: new Set(),
                callbacks: config.callbacks,
                head: config.head
            }
        }

        function isIdSetMatch(node1, node2, ctx) {
            if (node1 == null || node2 == null) {
                return false;
            }
            if (node1.nodeType === node2.nodeType && node1.tagName === node2.tagName) {
                if (node1.id !== "" && node1.id === node2.id) {
                    return true;
                } else {
                    return getIdIntersectionCount(ctx, node1, node2) > 0;
                }
            }
            return false;
        }

        function isSoftMatch(node1, node2) {
            if (node1 == null || node2 == null) {
                return false;
            }
            return node1.nodeType === node2.nodeType && node1.tagName === node2.tagName
        }

        function removeNodesBetween(startInclusive, endExclusive, ctx) {
            while (startInclusive !== endExclusive) {
                let tempNode = startInclusive;
                startInclusive = startInclusive.nextSibling;
                removeNode(tempNode, ctx);
            }
            removeIdsFromConsideration(ctx, endExclusive);
            return endExclusive.nextSibling;
        }

        //=============================================================================
        // Scans forward from the insertionPoint in the old parent looking for a potential id match
        // for the newChild.  We stop if we find a potential id match for the new child OR
        // if the number of potential id matches we are discarding is greater than the
        // potential id matches for the new child
        //=============================================================================
        function findIdSetMatch(newContent, oldParent, newChild, insertionPoint, ctx) {

            // max id matches we are willing to discard in our search
            let newChildPotentialIdCount = getIdIntersectionCount(ctx, newChild, oldParent);

            let potentialMatch = null;

            // only search forward if there is a possibility of an id match
            if (newChildPotentialIdCount > 0) {
                let potentialMatch = insertionPoint;
                // if there is a possibility of an id match, scan forward
                // keep track of the potential id match count we are discarding (the
                // newChildPotentialIdCount must be greater than this to make it likely
                // worth it)
                let otherMatchCount = 0;
                while (potentialMatch != null) {

                    // If we have an id match, return the current potential match
                    if (isIdSetMatch(newChild, potentialMatch, ctx)) {
                        return potentialMatch;
                    }

                    // computer the other potential matches of this new content
                    otherMatchCount += getIdIntersectionCount(ctx, potentialMatch, newContent);
                    if (otherMatchCount > newChildPotentialIdCount) {
                        // if we have more potential id matches in _other_ content, we
                        // do not have a good candidate for an id match, so return null
                        return null;
                    }

                    // advanced to the next old content child
                    potentialMatch = potentialMatch.nextSibling;
                }
            }
            return potentialMatch;
        }

        //=============================================================================
        // Scans forward from the insertionPoint in the old parent looking for a potential soft match
        // for the newChild.  We stop if we find a potential soft match for the new child OR
        // if we find a potential id match in the old parents children OR if we find two
        // potential soft matches for the next two pieces of new content
        //=============================================================================
        function findSoftMatch(newContent, oldParent, newChild, insertionPoint, ctx) {

            let potentialSoftMatch = insertionPoint;
            let nextSibling = newChild.nextSibling;
            let siblingSoftMatchCount = 0;

            while (potentialSoftMatch != null) {

                if (getIdIntersectionCount(ctx, potentialSoftMatch, newContent) > 0) {
                    // the current potential soft match has a potential id set match with the remaining new
                    // content so bail out of looking
                    return null;
                }

                // if we have a soft match with the current node, return it
                if (isSoftMatch(newChild, potentialSoftMatch)) {
                    return potentialSoftMatch;
                }

                if (isSoftMatch(nextSibling, potentialSoftMatch)) {
                    // the next new node has a soft match with this node, so
                    // increment the count of future soft matches
                    siblingSoftMatchCount++;
                    nextSibling = nextSibling.nextSibling;

                    // If there are two future soft matches, bail to allow the siblings to soft match
                    // so that we don't consume future soft matches for the sake of the current node
                    if (siblingSoftMatchCount >= 2) {
                        return null;
                    }
                }

                // advanced to the next old content child
                potentialSoftMatch = potentialSoftMatch.nextSibling;
            }

            return potentialSoftMatch;
        }

        function parseContent(newContent) {
            let parser = new DOMParser();

            // remove svgs to avoid false-positive matches on head, etc.
            let contentWithSvgsRemoved = newContent.replace(/<svg(\s[^>]*>|>)([\s\S]*?)<\/svg>/gim, '');

            // if the newContent contains a html, head or body tag, we can simply parse it w/o wrapping
            if (contentWithSvgsRemoved.match(/<\/html>/) || contentWithSvgsRemoved.match(/<\/head>/) || contentWithSvgsRemoved.match(/<\/body>/)) {
                let content = parser.parseFromString(newContent, "text/html");
                // if it is a full HTML document, return the document itself as the parent container
                if (contentWithSvgsRemoved.match(/<\/html>/)) {
                    content.generatedByIdiomorph = true;
                    return content;
                } else {
                    // otherwise return the html element as the parent container
                    let htmlElement = content.firstChild;
                    if (htmlElement) {
                        htmlElement.generatedByIdiomorph = true;
                        return htmlElement;
                    } else {
                        return null;
                    }
                }
            } else {
                // if it is partial HTML, wrap it in a template tag to provide a parent element and also to help
                // deal with touchy tags like tr, tbody, etc.
                let responseDoc = parser.parseFromString("<body><template>" + newContent + "</template></body>", "text/html");
                let content = responseDoc.body.querySelector('template').content;
                content.generatedByIdiomorph = true;
                return content
            }
        }

        function normalizeContent(newContent) {
            if (newContent == null) {
                // noinspection UnnecessaryLocalVariableJS
                const dummyParent = document.createElement('div');
                return dummyParent;
            } else if (newContent.generatedByIdiomorph) {
                // the template tag created by idiomorph parsing can serve as a dummy parent
                return newContent;
            } else if (newContent instanceof Node) {
                // a single node is added as a child to a dummy parent
                const dummyParent = document.createElement('div');
                dummyParent.append(newContent);
                return dummyParent;
            } else {
                // all nodes in the array or HTMLElement collection are consolidated under
                // a single dummy parent element
                const dummyParent = document.createElement('div');
                for (const elt of [...newContent]) {
                    dummyParent.append(elt);
                }
                return dummyParent;
            }
        }

        function insertSiblings(previousSibling, morphedNode, nextSibling) {
            let stack = [];
            let added = [];
            while (previousSibling != null) {
                stack.push(previousSibling);
                previousSibling = previousSibling.previousSibling;
            }
            while (stack.length > 0) {
                let node = stack.pop();
                added.push(node); // push added preceding siblings on in order and insert
                morphedNode.parentElement.insertBefore(node, morphedNode);
            }
            added.push(morphedNode);
            while (nextSibling != null) {
                stack.push(nextSibling);
                added.push(nextSibling); // here we are going in order, so push on as we scan, rather than add
                nextSibling = nextSibling.nextSibling;
            }
            while (stack.length > 0) {
                morphedNode.parentElement.insertBefore(stack.pop(), morphedNode.nextSibling);
            }
            return added;
        }

        function findBestNodeMatch(newContent, oldNode, ctx) {
            let currentElement;
            currentElement = newContent.firstChild;
            let bestElement = currentElement;
            let score = 0;
            while (currentElement) {
                let newScore = scoreElement(currentElement, oldNode, ctx);
                if (newScore > score) {
                    bestElement = currentElement;
                    score = newScore;
                }
                currentElement = currentElement.nextSibling;
            }
            return bestElement;
        }

        function scoreElement(node1, node2, ctx) {
            if (isSoftMatch(node1, node2)) {
                return .5 + getIdIntersectionCount(ctx, node1, node2);
            }
            return 0;
        }

        function removeNode(tempNode, ctx) {
            removeIdsFromConsideration(ctx, tempNode);
            if (ctx.callbacks.beforeNodeRemoved(tempNode) === false) return;

            tempNode.remove();
            ctx.callbacks.afterNodeRemoved(tempNode);
        }

        //=============================================================================
        // ID Set Functions
        //=============================================================================

        function isIdInConsideration(ctx, id) {
            return !ctx.deadIds.has(id);
        }

        function idIsWithinNode(ctx, id, targetNode) {
            let idSet = ctx.idMap.get(targetNode) || EMPTY_SET;
            return idSet.has(id);
        }

        function removeIdsFromConsideration(ctx, node) {
            let idSet = ctx.idMap.get(node) || EMPTY_SET;
            for (const id of idSet) {
                ctx.deadIds.add(id);
            }
        }

        function getIdIntersectionCount(ctx, node1, node2) {
            let sourceSet = ctx.idMap.get(node1) || EMPTY_SET;
            let matchCount = 0;
            for (const id of sourceSet) {
                // a potential match is an id in the source and potentialIdsSet, but
                // that has not already been merged into the DOM
                if (isIdInConsideration(ctx, id) && idIsWithinNode(ctx, id, node2)) {
                    ++matchCount;
                }
            }
            return matchCount;
        }

        /**
         * A bottom up algorithm that finds all elements with ids inside of the node
         * argument and populates id sets for those nodes and all their parents, generating
         * a set of ids contained within all nodes for the entire hierarchy in the DOM
         *
         * @param node {Element}
         * @param {Map<Node, Set<String>>} idMap
         */
        function populateIdMapForNode(node, idMap) {
            let nodeParent = node.parentElement;
            // find all elements with an id property
            let idElements = node.querySelectorAll('[id]');
            for (const elt of idElements) {
                let current = elt;
                // walk up the parent hierarchy of that element, adding the id
                // of element to the parent's id set
                while (current !== nodeParent && current != null) {
                    let idSet = idMap.get(current);
                    // if the id set doesn't exist, create it and insert it in the  map
                    if (idSet == null) {
                        idSet = new Set();
                        idMap.set(current, idSet);
                    }
                    idSet.add(elt.id);
                    current = current.parentElement;
                }
            }
        }

        /**
         * This function computes a map of nodes to all ids contained within that node (inclusive of the
         * node).  This map can be used to ask if two nodes have intersecting sets of ids, which allows
         * for a looser definition of "matching" than tradition id matching, and allows child nodes
         * to contribute to a parent nodes matching.
         *
         * @param {Element} oldContent  the old content that will be morphed
         * @param {Element} newContent  the new content to morph to
         * @returns {Map<Node, Set<String>>} a map of nodes to id sets for the
         */
        function createIdMap(oldContent, newContent) {
            let idMap = new Map();
            populateIdMapForNode(oldContent, idMap);
            populateIdMapForNode(newContent, idMap);
            return idMap;
        }

        //=============================================================================
        // This is what ends up becoming the Idiomorph global object
        //=============================================================================
        return {
            morph,
            defaults
        }
    })();

class PageRenderer extends Renderer {
  static renderElement(currentElement, newElement) {
    if (document.body && newElement instanceof HTMLBodyElement) {
      document.body.replaceWith(newElement);
    } else {
      document.documentElement.appendChild(newElement);
    }
  }

  get shouldRender() {
    return this.newSnapshot.isVisitable && this.trackedElementsAreIdentical
  }

  get reloadReason() {
    if (!this.newSnapshot.isVisitable) {
      return {
        reason: "turbo_visit_control_is_reload"
      }
    }

    if (!this.trackedElementsAreIdentical) {
      return {
        reason: "tracked_element_mismatch"
      }
    }
  }

  async prepareToRender() {
    this.#setLanguage();
    await this.mergeHead();
  }

  async render() {
    if (this.willRender) {
      await this.replaceBody();
    }
  }

  finishRendering() {
    super.finishRendering();
    if (!this.isPreview) {
      this.focusFirstAutofocusableElement();
    }
  }

  get currentHeadSnapshot() {
    return this.currentSnapshot.headSnapshot
  }

  get newHeadSnapshot() {
    return this.newSnapshot.headSnapshot
  }

  get newElement() {
    return this.newSnapshot.element
  }

  #setLanguage() {
    const { documentElement } = this.currentSnapshot;
    const { lang } = this.newSnapshot;

    if (lang) {
      documentElement.setAttribute("lang", lang);
    } else {
      documentElement.removeAttribute("lang");
    }
  }

  async mergeHead() {
    const mergedHeadElements = this.mergeProvisionalElements();
    const newStylesheetElements = this.copyNewHeadStylesheetElements();
    this.copyNewHeadScriptElements();

    await mergedHeadElements;
    await newStylesheetElements;

    if (this.willRender) {
      this.removeUnusedDynamicStylesheetElements();
    }
  }

  async replaceBody() {
    await this.preservingPermanentElements(async () => {
      this.activateNewBody();
      await this.assignNewBody();
    });
  }

  get trackedElementsAreIdentical() {
    return this.currentHeadSnapshot.trackedElementSignature == this.newHeadSnapshot.trackedElementSignature
  }

  async copyNewHeadStylesheetElements() {
    const loadingElements = [];

    for (const element of this.newHeadStylesheetElements) {
      loadingElements.push(waitForLoad(element));

      document.head.appendChild(element);
    }

    await Promise.all(loadingElements);
  }

  copyNewHeadScriptElements() {
    for (const element of this.newHeadScriptElements) {
      document.head.appendChild(activateScriptElement(element));
    }
  }

  removeUnusedDynamicStylesheetElements() {
    for (const element of this.unusedDynamicStylesheetElements) {
      document.head.removeChild(element);
    }
  }

  async mergeProvisionalElements() {
    const newHeadElements = [...this.newHeadProvisionalElements];

    for (const element of this.currentHeadProvisionalElements) {
      if (!this.isCurrentElementInElementList(element, newHeadElements)) {
        document.head.removeChild(element);
      }
    }

    for (const element of newHeadElements) {
      document.head.appendChild(element);
    }
  }

  isCurrentElementInElementList(element, elementList) {
    for (const [index, newElement] of elementList.entries()) {
      // if title element...
      if (element.tagName == "TITLE") {
        if (newElement.tagName != "TITLE") {
          continue
        }
        if (element.innerHTML == newElement.innerHTML) {
          elementList.splice(index, 1);
          return true
        }
      }

      // if any other element...
      if (newElement.isEqualNode(element)) {
        elementList.splice(index, 1);
        return true
      }
    }

    return false
  }

  removeCurrentHeadProvisionalElements() {
    for (const element of this.currentHeadProvisionalElements) {
      document.head.removeChild(element);
    }
  }

  copyNewHeadProvisionalElements() {
    for (const element of this.newHeadProvisionalElements) {
      document.head.appendChild(element);
    }
  }

  activateNewBody() {
    document.adoptNode(this.newElement);
    this.activateNewBodyScriptElements();
  }

  activateNewBodyScriptElements() {
    for (const inertScriptElement of this.newBodyScriptElements) {
      const activatedScriptElement = activateScriptElement(inertScriptElement);
      inertScriptElement.replaceWith(activatedScriptElement);
    }
  }

  async assignNewBody() {
    await this.renderElement(this.currentElement, this.newElement);
  }

  get unusedDynamicStylesheetElements() {
    return this.oldHeadStylesheetElements.filter((element) => {
      return element.getAttribute("data-turbo-track") === "dynamic"
    })
  }

  get oldHeadStylesheetElements() {
    return this.currentHeadSnapshot.getStylesheetElementsNotInSnapshot(this.newHeadSnapshot)
  }

  get newHeadStylesheetElements() {
    return this.newHeadSnapshot.getStylesheetElementsNotInSnapshot(this.currentHeadSnapshot)
  }

  get newHeadScriptElements() {
    return this.newHeadSnapshot.getScriptElementsNotInSnapshot(this.currentHeadSnapshot)
  }

  get currentHeadProvisionalElements() {
    return this.currentHeadSnapshot.provisionalElements
  }

  get newHeadProvisionalElements() {
    return this.newHeadSnapshot.provisionalElements
  }

  get newBodyScriptElements() {
    return this.newElement.querySelectorAll("script")
  }
}

class MorphRenderer extends PageRenderer {
  async render() {
    if (this.willRender) await this.#morphBody();
  }

  get renderMethod() {
    return "morph"
  }

  // Private

  async #morphBody() {
    this.#morphElements(this.currentElement, this.newElement);
    this.#reloadRemoteFrames();

    dispatch("turbo:morph", {
      detail: {
        currentElement: this.currentElement,
        newElement: this.newElement
      }
    });
  }

  #morphElements(currentElement, newElement, morphStyle = "outerHTML") {
    this.isMorphingTurboFrame = this.#isFrameReloadedWithMorph(currentElement);

    Idiomorph.morph(currentElement, newElement, {
      morphStyle: morphStyle,
      callbacks: {
        beforeNodeAdded: this.#shouldAddElement,
        beforeNodeMorphed: this.#shouldMorphElement,
        beforeAttributeUpdated: this.#shouldUpdateAttribute,
        beforeNodeRemoved: this.#shouldRemoveElement,
        afterNodeMorphed: this.#didMorphElement
      }
    });
  }

  #shouldAddElement = (node) => {
    return !(node.id && node.hasAttribute("data-turbo-permanent") && document.getElementById(node.id))
  }

  #shouldMorphElement = (oldNode, newNode) => {
    if (oldNode instanceof HTMLElement) {
      if (!oldNode.hasAttribute("data-turbo-permanent") && (this.isMorphingTurboFrame || !this.#isFrameReloadedWithMorph(oldNode))) {
        const event = dispatch("turbo:before-morph-element", {
          cancelable: true,
          target: oldNode,
          detail: {
            newElement: newNode
          }
        });

        return !event.defaultPrevented
      } else {
        return false
      }
    }
  }

  #shouldUpdateAttribute = (attributeName, target, mutationType) => {
    const event = dispatch("turbo:before-morph-attribute", { cancelable: true, target, detail: { attributeName, mutationType } });

    return !event.defaultPrevented
  }

  #didMorphElement = (oldNode, newNode) => {
    if (newNode instanceof HTMLElement) {
      dispatch("turbo:morph-element", {
        target: oldNode,
        detail: {
          newElement: newNode
        }
      });
    }
  }

  #shouldRemoveElement = (node) => {
    return this.#shouldMorphElement(node)
  }

  #reloadRemoteFrames() {
    this.#remoteFrames().forEach((frame) => {
      if (this.#isFrameReloadedWithMorph(frame)) {
        this.#renderFrameWithMorph(frame);
        frame.reload();
      }
    });
  }

  #renderFrameWithMorph(frame) {
    frame.addEventListener("turbo:before-frame-render", (event) => {
      event.detail.render = this.#morphFrameUpdate;
    }, { once: true });
  }

  #morphFrameUpdate = (currentElement, newElement) => {
    dispatch("turbo:before-frame-morph", {
      target: currentElement,
      detail: { currentElement, newElement }
    });
    this.#morphElements(currentElement, newElement.children, "innerHTML");
  }

  #isFrameReloadedWithMorph(element) {
    return element.src && element.refresh === "morph"
  }

  #remoteFrames() {
    return Array.from(document.querySelectorAll('turbo-frame[src]')).filter(frame => {
      return !frame.closest('[data-turbo-permanent]')
    })
  }
}

class SnapshotCache {
  keys = []
  snapshots = {}

  constructor(size) {
    this.size = size;
  }

  has(location) {
    return toCacheKey(location) in this.snapshots
  }

  get(location) {
    if (this.has(location)) {
      const snapshot = this.read(location);
      this.touch(location);
      return snapshot
    }
  }

  put(location, snapshot) {
    this.write(location, snapshot);
    this.touch(location);
    return snapshot
  }

  clear() {
    this.snapshots = {};
  }

  // Private

  read(location) {
    return this.snapshots[toCacheKey(location)]
  }

  write(location, snapshot) {
    this.snapshots[toCacheKey(location)] = snapshot;
  }

  touch(location) {
    const key = toCacheKey(location);
    const index = this.keys.indexOf(key);
    if (index > -1) this.keys.splice(index, 1);
    this.keys.unshift(key);
    this.trim();
  }

  trim() {
    for (const key of this.keys.splice(this.size)) {
      delete this.snapshots[key];
    }
  }
}

class PageView extends View {
  snapshotCache = new SnapshotCache(10)
  lastRenderedLocation = new URL(location.href)
  forceReloaded = false

  shouldTransitionTo(newSnapshot) {
    return this.snapshot.prefersViewTransitions && newSnapshot.prefersViewTransitions
  }

  renderPage(snapshot, isPreview = false, willRender = true, visit) {
    const shouldMorphPage = this.isPageRefresh(visit) && this.snapshot.shouldMorphPage;
    const rendererClass = shouldMorphPage ? MorphRenderer : PageRenderer;

    const renderer = new rendererClass(this.snapshot, snapshot, PageRenderer.renderElement, isPreview, willRender);

    if (!renderer.shouldRender) {
      this.forceReloaded = true;
    } else {
      visit?.changeHistory();
    }

    return this.render(renderer)
  }

  renderError(snapshot, visit) {
    visit?.changeHistory();
    const renderer = new ErrorRenderer(this.snapshot, snapshot, ErrorRenderer.renderElement, false);
    return this.render(renderer)
  }

  clearSnapshotCache() {
    this.snapshotCache.clear();
  }

  async cacheSnapshot(snapshot = this.snapshot) {
    if (snapshot.isCacheable) {
      this.delegate.viewWillCacheSnapshot();
      const { lastRenderedLocation: location } = this;
      await nextEventLoopTick();
      const cachedSnapshot = snapshot.clone();
      this.snapshotCache.put(location, cachedSnapshot);
      return cachedSnapshot
    }
  }

  getCachedSnapshotForLocation(location) {
    return this.snapshotCache.get(location)
  }

  isPageRefresh(visit) {
    return !visit || (this.lastRenderedLocation.pathname === visit.location.pathname && visit.action === "replace")
  }

  shouldPreserveScrollPosition(visit) {
    return this.isPageRefresh(visit) && this.snapshot.shouldPreserveScrollPosition
  }

  get snapshot() {
    return PageSnapshot.fromElement(this.element)
  }
}

class Preloader {
  selector = "a[data-turbo-preload]"

  constructor(delegate, snapshotCache) {
    this.delegate = delegate;
    this.snapshotCache = snapshotCache;
  }

  start() {
    if (document.readyState === "loading") {
      document.addEventListener("DOMContentLoaded", this.#preloadAll);
    } else {
      this.preloadOnLoadLinksForView(document.body);
    }
  }

  stop() {
    document.removeEventListener("DOMContentLoaded", this.#preloadAll);
  }

  preloadOnLoadLinksForView(element) {
    for (const link of element.querySelectorAll(this.selector)) {
      if (this.delegate.shouldPreloadLink(link)) {
        this.preloadURL(link);
      }
    }
  }

  async preloadURL(link) {
    const location = new URL(link.href);

    if (this.snapshotCache.has(location)) {
      return
    }

    const fetchRequest = new FetchRequest(this, FetchMethod.get, location, new URLSearchParams(), link);
    await fetchRequest.perform();
  }

  // Fetch request delegate

  prepareRequest(fetchRequest) {
    fetchRequest.headers["X-Sec-Purpose"] = "prefetch";
  }

  async requestSucceededWithResponse(fetchRequest, fetchResponse) {
    try {
      const responseHTML = await fetchResponse.responseHTML;
      const snapshot = PageSnapshot.fromHTMLString(responseHTML);

      this.snapshotCache.put(fetchRequest.url, snapshot);
    } catch (_) {
      // If we cannot preload that is ok!
    }
  }

  requestStarted(fetchRequest) {}

  requestErrored(fetchRequest) {}

  requestFinished(fetchRequest) {}

  requestPreventedHandlingResponse(fetchRequest, fetchResponse) {}

  requestFailedWithResponse(fetchRequest, fetchResponse) {}

  #preloadAll = () => {
    this.preloadOnLoadLinksForView(document.body);
  }
}

class Cache {
  constructor(session) {
    this.session = session;
  }

  clear() {
    this.session.clearCache();
  }

  resetCacheControl() {
    this.#setCacheControl("");
  }

  exemptPageFromCache() {
    this.#setCacheControl("no-cache");
  }

  exemptPageFromPreview() {
    this.#setCacheControl("no-preview");
  }

  #setCacheControl(value) {
    setMetaContent("turbo-cache-control", value);
  }
}

class Session {
  navigator = new Navigator(this)
  history = new History(this)
  view = new PageView(this, document.documentElement)
  adapter = new BrowserAdapter(this)

  pageObserver = new PageObserver(this)
  cacheObserver = new CacheObserver()
  linkPrefetchObserver = new LinkPrefetchObserver(this, document)
  linkClickObserver = new LinkClickObserver(this, window)
  formSubmitObserver = new FormSubmitObserver(this, document)
  scrollObserver = new ScrollObserver(this)
  streamObserver = new StreamObserver(this)
  formLinkClickObserver = new FormLinkClickObserver(this, document.documentElement)
  frameRedirector = new FrameRedirector(this, document.documentElement)
  streamMessageRenderer = new StreamMessageRenderer()
  cache = new Cache(this)

  drive = true
  enabled = true
  progressBarDelay = 500
  started = false
  formMode = "on"
  #pageRefreshDebouncePeriod = 150

  constructor(recentRequests) {
    this.recentRequests = recentRequests;
    this.preloader = new Preloader(this, this.view.snapshotCache);
    this.debouncedRefresh = this.refresh;
    this.pageRefreshDebouncePeriod = this.pageRefreshDebouncePeriod;
  }

  start() {
    if (!this.started) {
      this.pageObserver.start();
      this.cacheObserver.start();
      this.linkPrefetchObserver.start();
      this.formLinkClickObserver.start();
      this.linkClickObserver.start();
      this.formSubmitObserver.start();
      this.scrollObserver.start();
      this.streamObserver.start();
      this.frameRedirector.start();
      this.history.start();
      this.preloader.start();
      this.started = true;
      this.enabled = true;
    }
  }

  disable() {
    this.enabled = false;
  }

  stop() {
    if (this.started) {
      this.pageObserver.stop();
      this.cacheObserver.stop();
      this.linkPrefetchObserver.stop();
      this.formLinkClickObserver.stop();
      this.linkClickObserver.stop();
      this.formSubmitObserver.stop();
      this.scrollObserver.stop();
      this.streamObserver.stop();
      this.frameRedirector.stop();
      this.history.stop();
      this.preloader.stop();
      this.started = false;
    }
  }

  registerAdapter(adapter) {
    this.adapter = adapter;
  }

  visit(location, options = {}) {
    const frameElement = options.frame ? document.getElementById(options.frame) : null;

    if (frameElement instanceof FrameElement) {
      const action = options.action || getVisitAction(frameElement);

      frameElement.delegate.proposeVisitIfNavigatedWithAction(frameElement, action);
      frameElement.src = location.toString();
    } else {
      this.navigator.proposeVisit(expandURL(location), options);
    }
  }

  refresh(url, requestId) {
    const isRecentRequest = requestId && this.recentRequests.has(requestId);
    if (!isRecentRequest) {
      this.visit(url, { action: "replace", shouldCacheSnapshot: false });
    }
  }

  connectStreamSource(source) {
    this.streamObserver.connectStreamSource(source);
  }

  disconnectStreamSource(source) {
    this.streamObserver.disconnectStreamSource(source);
  }

  renderStreamMessage(message) {
    this.streamMessageRenderer.render(StreamMessage.wrap(message));
  }

  clearCache() {
    this.view.clearSnapshotCache();
  }

  setProgressBarDelay(delay) {
    this.progressBarDelay = delay;
  }

  setFormMode(mode) {
    this.formMode = mode;
  }

  get location() {
    return this.history.location
  }

  get restorationIdentifier() {
    return this.history.restorationIdentifier
  }

  get pageRefreshDebouncePeriod() {
    return this.#pageRefreshDebouncePeriod
  }

  set pageRefreshDebouncePeriod(value) {
    this.refresh = debounce(this.debouncedRefresh.bind(this), value);
    this.#pageRefreshDebouncePeriod = value;
  }

  // Preloader delegate

  shouldPreloadLink(element) {
    const isUnsafe = element.hasAttribute("data-turbo-method");
    const isStream = element.hasAttribute("data-turbo-stream");
    const frameTarget = element.getAttribute("data-turbo-frame");
    const frame = frameTarget == "_top" ?
      null :
      document.getElementById(frameTarget) || findClosestRecursively(element, "turbo-frame:not([disabled])");

    if (isUnsafe || isStream || frame instanceof FrameElement) {
      return false
    } else {
      const location = new URL(element.href);

      return this.elementIsNavigatable(element) && locationIsVisitable(location, this.snapshot.rootLocation)
    }
  }

  // History delegate

  historyPoppedToLocationWithRestorationIdentifierAndDirection(location, restorationIdentifier, direction) {
    if (this.enabled) {
      this.navigator.startVisit(location, restorationIdentifier, {
        action: "restore",
        historyChanged: true,
        direction
      });
    } else {
      this.adapter.pageInvalidated({
        reason: "turbo_disabled"
      });
    }
  }

  // Scroll observer delegate

  scrollPositionChanged(position) {
    this.history.updateRestorationData({ scrollPosition: position });
  }

  // Form click observer delegate

  willSubmitFormLinkToLocation(link, location) {
    return this.elementIsNavigatable(link) && locationIsVisitable(location, this.snapshot.rootLocation)
  }

  submittedFormLinkToLocation() {}

  // Link hover observer delegate

  canPrefetchRequestToLocation(link, location) {
    return (
      this.elementIsNavigatable(link) &&
        locationIsVisitable(location, this.snapshot.rootLocation)
    )
  }

  // Link click observer delegate

  willFollowLinkToLocation(link, location, event) {
    return (
      this.elementIsNavigatable(link) &&
      locationIsVisitable(location, this.snapshot.rootLocation) &&
      this.applicationAllowsFollowingLinkToLocation(link, location, event)
    )
  }

  followedLinkToLocation(link, location) {
    const action = this.getActionForLink(link);
    const acceptsStreamResponse = link.hasAttribute("data-turbo-stream");

    this.visit(location.href, { action, acceptsStreamResponse });
  }

  // Navigator delegate

  allowsVisitingLocationWithAction(location, action) {
    return this.locationWithActionIsSamePage(location, action) || this.applicationAllowsVisitingLocation(location)
  }

  visitProposedToLocation(location, options) {
    extendURLWithDeprecatedProperties(location);
    this.adapter.visitProposedToLocation(location, options);
  }

  // Visit delegate

  visitStarted(visit) {
    if (!visit.acceptsStreamResponse) {
      markAsBusy(document.documentElement);
      this.view.markVisitDirection(visit.direction);
    }
    extendURLWithDeprecatedProperties(visit.location);
    if (!visit.silent) {
      this.notifyApplicationAfterVisitingLocation(visit.location, visit.action);
    }
  }

  visitCompleted(visit) {
    this.view.unmarkVisitDirection();
    clearBusyState(document.documentElement);
    this.notifyApplicationAfterPageLoad(visit.getTimingMetrics());
  }

  locationWithActionIsSamePage(location, action) {
    return this.navigator.locationWithActionIsSamePage(location, action)
  }

  visitScrolledToSamePageLocation(oldURL, newURL) {
    this.notifyApplicationAfterVisitingSamePageLocation(oldURL, newURL);
  }

  // Form submit observer delegate

  willSubmitForm(form, submitter) {
    const action = getAction$1(form, submitter);

    return (
      this.submissionIsNavigatable(form, submitter) &&
      locationIsVisitable(expandURL(action), this.snapshot.rootLocation)
    )
  }

  formSubmitted(form, submitter) {
    this.navigator.submitForm(form, submitter);
  }

  // Page observer delegate

  pageBecameInteractive() {
    this.view.lastRenderedLocation = this.location;
    this.notifyApplicationAfterPageLoad();
  }

  pageLoaded() {
    this.history.assumeControlOfScrollRestoration();
  }

  pageWillUnload() {
    this.history.relinquishControlOfScrollRestoration();
  }

  // Stream observer delegate

  receivedMessageFromStream(message) {
    this.renderStreamMessage(message);
  }

  // Page view delegate

  viewWillCacheSnapshot() {
    if (!this.navigator.currentVisit?.silent) {
      this.notifyApplicationBeforeCachingSnapshot();
    }
  }

  allowsImmediateRender({ element }, options) {
    const event = this.notifyApplicationBeforeRender(element, options);
    const {
      defaultPrevented,
      detail: { render }
    } = event;

    if (this.view.renderer && render) {
      this.view.renderer.renderElement = render;
    }

    return !defaultPrevented
  }

  viewRenderedSnapshot(_snapshot, _isPreview, renderMethod) {
    this.view.lastRenderedLocation = this.history.location;
    this.notifyApplicationAfterRender(renderMethod);
  }

  preloadOnLoadLinksForView(element) {
    this.preloader.preloadOnLoadLinksForView(element);
  }

  viewInvalidated(reason) {
    this.adapter.pageInvalidated(reason);
  }

  // Frame element

  frameLoaded(frame) {
    this.notifyApplicationAfterFrameLoad(frame);
  }

  frameRendered(fetchResponse, frame) {
    this.notifyApplicationAfterFrameRender(fetchResponse, frame);
  }

  // Application events

  applicationAllowsFollowingLinkToLocation(link, location, ev) {
    const event = this.notifyApplicationAfterClickingLinkToLocation(link, location, ev);
    return !event.defaultPrevented
  }

  applicationAllowsVisitingLocation(location) {
    const event = this.notifyApplicationBeforeVisitingLocation(location);
    return !event.defaultPrevented
  }

  notifyApplicationAfterClickingLinkToLocation(link, location, event) {
    return dispatch("turbo:click", {
      target: link,
      detail: { url: location.href, originalEvent: event },
      cancelable: true
    })
  }

  notifyApplicationBeforeVisitingLocation(location) {
    return dispatch("turbo:before-visit", {
      detail: { url: location.href },
      cancelable: true
    })
  }

  notifyApplicationAfterVisitingLocation(location, action) {
    return dispatch("turbo:visit", { detail: { url: location.href, action } })
  }

  notifyApplicationBeforeCachingSnapshot() {
    return dispatch("turbo:before-cache")
  }

  notifyApplicationBeforeRender(newBody, options) {
    return dispatch("turbo:before-render", {
      detail: { newBody, ...options },
      cancelable: true
    })
  }

  notifyApplicationAfterRender(renderMethod) {
    return dispatch("turbo:render", { detail: { renderMethod } })
  }

  notifyApplicationAfterPageLoad(timing = {}) {
    return dispatch("turbo:load", {
      detail: { url: this.location.href, timing }
    })
  }

  notifyApplicationAfterVisitingSamePageLocation(oldURL, newURL) {
    dispatchEvent(
      new HashChangeEvent("hashchange", {
        oldURL: oldURL.toString(),
        newURL: newURL.toString()
      })
    );
  }

  notifyApplicationAfterFrameLoad(frame) {
    return dispatch("turbo:frame-load", { target: frame })
  }

  notifyApplicationAfterFrameRender(fetchResponse, frame) {
    return dispatch("turbo:frame-render", {
      detail: { fetchResponse },
      target: frame,
      cancelable: true
    })
  }

  // Helpers

  submissionIsNavigatable(form, submitter) {
    if (this.formMode == "off") {
      return false
    } else {
      const submitterIsNavigatable = submitter ? this.elementIsNavigatable(submitter) : true;

      if (this.formMode == "optin") {
        return submitterIsNavigatable && form.closest('[data-turbo="true"]') != null
      } else {
        return submitterIsNavigatable && this.elementIsNavigatable(form)
      }
    }
  }

  elementIsNavigatable(element) {
    const container = findClosestRecursively(element, "[data-turbo]");
    const withinFrame = findClosestRecursively(element, "turbo-frame");

    // Check if Drive is enabled on the session or we're within a Frame.
    if (this.drive || withinFrame) {
      // Element is navigatable by default, unless `data-turbo="false"`.
      if (container) {
        return container.getAttribute("data-turbo") != "false"
      } else {
        return true
      }
    } else {
      // Element isn't navigatable by default, unless `data-turbo="true"`.
      if (container) {
        return container.getAttribute("data-turbo") == "true"
      } else {
        return false
      }
    }
  }

  // Private

  getActionForLink(link) {
    return getVisitAction(link) || "advance"
  }

  get snapshot() {
    return this.view.snapshot
  }
}

// Older versions of the Turbo Native adapters referenced the
// `Location#absoluteURL` property in their implementations of
// the `Adapter#visitProposedToLocation()` and `#visitStarted()`
// methods. The Location class has since been removed in favor
// of the DOM URL API, and accordingly all Adapter methods now
// receive URL objects.
//
// We alias #absoluteURL to #toString() here to avoid crashing
// older adapters which do not expect URL objects. We should
// consider removing this support at some point in the future.

function extendURLWithDeprecatedProperties(url) {
  Object.defineProperties(url, deprecatedLocationPropertyDescriptors);
}

const deprecatedLocationPropertyDescriptors = {
  absoluteURL: {
    get() {
      return this.toString()
    }
  }
};

const session = new Session(recentRequests);
const { cache, navigator: navigator$1 } = session;

/**
 * Starts the main session.
 * This initialises any necessary observers such as those to monitor
 * link interactions.
 */
function start() {
  session.start();
}

/**
 * Registers an adapter for the main session.
 *
 * @param adapter Adapter to register
 */
function registerAdapter(adapter) {
  session.registerAdapter(adapter);
}

/**
 * Performs an application visit to the given location.
 *
 * @param location Location to visit (a URL or path)
 * @param options Options to apply
 * @param options.action Type of history navigation to apply ("restore",
 * "replace" or "advance")
 * @param options.historyChanged Specifies whether the browser history has
 * already been changed for this visit or not
 * @param options.referrer Specifies the referrer of this visit such that
 * navigations to the same page will not result in a new history entry.
 * @param options.snapshotHTML Cached snapshot to render
 * @param options.response Response of the specified location
 */
function visit(location, options) {
  session.visit(location, options);
}

/**
 * Connects a stream source to the main session.
 *
 * @param source Stream source to connect
 */
function connectStreamSource(source) {
  session.connectStreamSource(source);
}

/**
 * Disconnects a stream source from the main session.
 *
 * @param source Stream source to disconnect
 */
function disconnectStreamSource(source) {
  session.disconnectStreamSource(source);
}

/**
 * Renders a stream message to the main session by appending it to the
 * current document.
 *
 * @param message Message to render
 */
function renderStreamMessage(message) {
  session.renderStreamMessage(message);
}

/**
 * Removes all entries from the Turbo Drive page cache.
 * Call this when state has changed on the server that may affect cached pages.
 *
 * @deprecated since version 7.2.0 in favor of `Turbo.cache.clear()`
 */
function clearCache() {
  console.warn(
    "Please replace `Turbo.clearCache()` with `Turbo.cache.clear()`. The top-level function is deprecated and will be removed in a future version of Turbo.`"
  );
  session.clearCache();
}

/**
 * Sets the delay after which the progress bar will appear during navigation.
 *
 * The progress bar appears after 500ms by default.
 *
 * Note that this method has no effect when used with the iOS or Android
 * adapters.
 *
 * @param delay Time to delay in milliseconds
 */
function setProgressBarDelay(delay) {
  session.setProgressBarDelay(delay);
}

function setConfirmMethod(confirmMethod) {
  FormSubmission.confirmMethod = confirmMethod;
}

function setFormMode(mode) {
  session.setFormMode(mode);
}

var Turbo = /*#__PURE__*/Object.freeze({
  __proto__: null,
  navigator: navigator$1,
  session: session,
  cache: cache,
  PageRenderer: PageRenderer,
  PageSnapshot: PageSnapshot,
  FrameRenderer: FrameRenderer,
  fetch: fetchWithTurboHeaders,
  start: start,
  registerAdapter: registerAdapter,
  visit: visit,
  connectStreamSource: connectStreamSource,
  disconnectStreamSource: disconnectStreamSource,
  renderStreamMessage: renderStreamMessage,
  clearCache: clearCache,
  setProgressBarDelay: setProgressBarDelay,
  setConfirmMethod: setConfirmMethod,
  setFormMode: setFormMode
});

class TurboFrameMissingError extends Error {}

class FrameController {
  fetchResponseLoaded = (_fetchResponse) => Promise.resolve()
  #currentFetchRequest = null
  #resolveVisitPromise = () => {}
  #connected = false
  #hasBeenLoaded = false
  #ignoredAttributes = new Set()
  action = null

  constructor(element) {
    this.element = element;
    this.view = new FrameView(this, this.element);
    this.appearanceObserver = new AppearanceObserver(this, this.element);
    this.formLinkClickObserver = new FormLinkClickObserver(this, this.element);
    this.linkInterceptor = new LinkInterceptor(this, this.element);
    this.restorationIdentifier = uuid();
    this.formSubmitObserver = new FormSubmitObserver(this, this.element);
  }

  // Frame delegate

  connect() {
    if (!this.#connected) {
      this.#connected = true;
      if (this.loadingStyle == FrameLoadingStyle.lazy) {
        this.appearanceObserver.start();
      } else {
        this.#loadSourceURL();
      }
      this.formLinkClickObserver.start();
      this.linkInterceptor.start();
      this.formSubmitObserver.start();
    }
  }

  disconnect() {
    if (this.#connected) {
      this.#connected = false;
      this.appearanceObserver.stop();
      this.formLinkClickObserver.stop();
      this.linkInterceptor.stop();
      this.formSubmitObserver.stop();
    }
  }

  disabledChanged() {
    if (this.loadingStyle == FrameLoadingStyle.eager) {
      this.#loadSourceURL();
    }
  }

  sourceURLChanged() {
    if (this.#isIgnoringChangesTo("src")) return

    if (this.element.isConnected) {
      this.complete = false;
    }

    if (this.loadingStyle == FrameLoadingStyle.eager || this.#hasBeenLoaded) {
      this.#loadSourceURL();
    }
  }

  sourceURLReloaded() {
    const { src } = this.element;
    this.element.removeAttribute("complete");
    this.element.src = null;
    this.element.src = src;
    return this.element.loaded
  }

  loadingStyleChanged() {
    if (this.loadingStyle == FrameLoadingStyle.lazy) {
      this.appearanceObserver.start();
    } else {
      this.appearanceObserver.stop();
      this.#loadSourceURL();
    }
  }

  async #loadSourceURL() {
    if (this.enabled && this.isActive && !this.complete && this.sourceURL) {
      this.element.loaded = this.#visit(expandURL(this.sourceURL));
      this.appearanceObserver.stop();
      await this.element.loaded;
      this.#hasBeenLoaded = true;
    }
  }

  async loadResponse(fetchResponse) {
    if (fetchResponse.redirected || (fetchResponse.succeeded && fetchResponse.isHTML)) {
      this.sourceURL = fetchResponse.response.url;
    }

    try {
      const html = await fetchResponse.responseHTML;
      if (html) {
        const document = parseHTMLDocument(html);
        const pageSnapshot = PageSnapshot.fromDocument(document);

        if (pageSnapshot.isVisitable) {
          await this.#loadFrameResponse(fetchResponse, document);
        } else {
          await this.#handleUnvisitableFrameResponse(fetchResponse);
        }
      }
    } finally {
      this.fetchResponseLoaded = () => Promise.resolve();
    }
  }

  // Appearance observer delegate

  elementAppearedInViewport(element) {
    this.proposeVisitIfNavigatedWithAction(element, getVisitAction(element));
    this.#loadSourceURL();
  }

  // Form link click observer delegate

  willSubmitFormLinkToLocation(link) {
    return this.#shouldInterceptNavigation(link)
  }

  submittedFormLinkToLocation(link, _location, form) {
    const frame = this.#findFrameElement(link);
    if (frame) form.setAttribute("data-turbo-frame", frame.id);
  }

  // Link interceptor delegate

  shouldInterceptLinkClick(element, _location, _event) {
    return this.#shouldInterceptNavigation(element)
  }

  linkClickIntercepted(element, location) {
    this.#navigateFrame(element, location);
  }

  // Form submit observer delegate

  willSubmitForm(element, submitter) {
    return element.closest("turbo-frame") == this.element && this.#shouldInterceptNavigation(element, submitter)
  }

  formSubmitted(element, submitter) {
    if (this.formSubmission) {
      this.formSubmission.stop();
    }

    this.formSubmission = new FormSubmission(this, element, submitter);
    const { fetchRequest } = this.formSubmission;
    this.prepareRequest(fetchRequest);
    this.formSubmission.start();
  }

  // Fetch request delegate

  prepareRequest(request) {
    request.headers["Turbo-Frame"] = this.id;

    if (this.currentNavigationElement?.hasAttribute("data-turbo-stream")) {
      request.acceptResponseType(StreamMessage.contentType);
    }
  }

  requestStarted(_request) {
    markAsBusy(this.element);
  }

  requestPreventedHandlingResponse(_request, _response) {
    this.#resolveVisitPromise();
  }

  async requestSucceededWithResponse(request, response) {
    await this.loadResponse(response);
    this.#resolveVisitPromise();
  }

  async requestFailedWithResponse(request, response) {
    await this.loadResponse(response);
    this.#resolveVisitPromise();
  }

  requestErrored(request, error) {
    console.error(error);
    this.#resolveVisitPromise();
  }

  requestFinished(_request) {
    clearBusyState(this.element);
  }

  // Form submission delegate

  formSubmissionStarted({ formElement }) {
    markAsBusy(formElement, this.#findFrameElement(formElement));
  }

  formSubmissionSucceededWithResponse(formSubmission, response) {
    const frame = this.#findFrameElement(formSubmission.formElement, formSubmission.submitter);

    frame.delegate.proposeVisitIfNavigatedWithAction(frame, getVisitAction(formSubmission.submitter, formSubmission.formElement, frame));
    frame.delegate.loadResponse(response);

    if (!formSubmission.isSafe) {
      session.clearCache();
    }
  }

  formSubmissionFailedWithResponse(formSubmission, fetchResponse) {
    this.element.delegate.loadResponse(fetchResponse);
    session.clearCache();
  }

  formSubmissionErrored(formSubmission, error) {
    console.error(error);
  }

  formSubmissionFinished({ formElement }) {
    clearBusyState(formElement, this.#findFrameElement(formElement));
  }

  // View delegate

  allowsImmediateRender({ element: newFrame }, options) {
    const event = dispatch("turbo:before-frame-render", {
      target: this.element,
      detail: { newFrame, ...options },
      cancelable: true
    });
    const {
      defaultPrevented,
      detail: { render }
    } = event;

    if (this.view.renderer && render) {
      this.view.renderer.renderElement = render;
    }

    return !defaultPrevented
  }

  viewRenderedSnapshot(_snapshot, _isPreview, _renderMethod) {}

  preloadOnLoadLinksForView(element) {
    session.preloadOnLoadLinksForView(element);
  }

  viewInvalidated() {}

  // Frame renderer delegate

  willRenderFrame(currentElement, _newElement) {
    this.previousFrameElement = currentElement.cloneNode(true);
  }

  visitCachedSnapshot = ({ element }) => {
    const frame = element.querySelector("#" + this.element.id);

    if (frame && this.previousFrameElement) {
      frame.replaceChildren(...this.previousFrameElement.children);
    }

    delete this.previousFrameElement;
  }

  // Private

  async #loadFrameResponse(fetchResponse, document) {
    const newFrameElement = await this.extractForeignFrameElement(document.body);

    if (newFrameElement) {
      const snapshot = new Snapshot(newFrameElement);
      const renderer = new FrameRenderer(this, this.view.snapshot, snapshot, FrameRenderer.renderElement, false, false);
      if (this.view.renderPromise) await this.view.renderPromise;
      this.changeHistory();

      await this.view.render(renderer);
      this.complete = true;
      session.frameRendered(fetchResponse, this.element);
      session.frameLoaded(this.element);
      await this.fetchResponseLoaded(fetchResponse);
    } else if (this.#willHandleFrameMissingFromResponse(fetchResponse)) {
      this.#handleFrameMissingFromResponse(fetchResponse);
    }
  }

  async #visit(url) {
    const request = new FetchRequest(this, FetchMethod.get, url, new URLSearchParams(), this.element);

    this.#currentFetchRequest?.cancel();
    this.#currentFetchRequest = request;

    return new Promise((resolve) => {
      this.#resolveVisitPromise = () => {
        this.#resolveVisitPromise = () => {};
        this.#currentFetchRequest = null;
        resolve();
      };
      request.perform();
    })
  }

  #navigateFrame(element, url, submitter) {
    const frame = this.#findFrameElement(element, submitter);

    frame.delegate.proposeVisitIfNavigatedWithAction(frame, getVisitAction(submitter, element, frame));

    this.#withCurrentNavigationElement(element, () => {
      frame.src = url;
    });
  }

  proposeVisitIfNavigatedWithAction(frame, action = null) {
    this.action = action;

    if (this.action) {
      const pageSnapshot = PageSnapshot.fromElement(frame).clone();
      const { visitCachedSnapshot } = frame.delegate;

      frame.delegate.fetchResponseLoaded = async (fetchResponse) => {
        if (frame.src) {
          const { statusCode, redirected } = fetchResponse;
          const responseHTML = await fetchResponse.responseHTML;
          const response = { statusCode, redirected, responseHTML };
          const options = {
            response,
            visitCachedSnapshot,
            willRender: false,
            updateHistory: false,
            restorationIdentifier: this.restorationIdentifier,
            snapshot: pageSnapshot
          };

          if (this.action) options.action = this.action;

          session.visit(frame.src, options);
        }
      };
    }
  }

  changeHistory() {
    if (this.action) {
      const method = getHistoryMethodForAction(this.action);
      session.history.update(method, expandURL(this.element.src || ""), this.restorationIdentifier);
    }
  }

  async #handleUnvisitableFrameResponse(fetchResponse) {
    console.warn(
      `The response (${fetchResponse.statusCode}) from <turbo-frame id="${this.element.id}"> is performing a full page visit due to turbo-visit-control.`
    );

    await this.#visitResponse(fetchResponse.response);
  }

  #willHandleFrameMissingFromResponse(fetchResponse) {
    this.element.setAttribute("complete", "");

    const response = fetchResponse.response;
    const visit = async (url, options) => {
      if (url instanceof Response) {
        this.#visitResponse(url);
      } else {
        session.visit(url, options);
      }
    };

    const event = dispatch("turbo:frame-missing", {
      target: this.element,
      detail: { response, visit },
      cancelable: true
    });

    return !event.defaultPrevented
  }

  #handleFrameMissingFromResponse(fetchResponse) {
    this.view.missing();
    this.#throwFrameMissingError(fetchResponse);
  }

  #throwFrameMissingError(fetchResponse) {
    const message = `The response (${fetchResponse.statusCode}) did not contain the expected <turbo-frame id="${this.element.id}"> and will be ignored. To perform a full page visit instead, set turbo-visit-control to reload.`;
    throw new TurboFrameMissingError(message)
  }

  async #visitResponse(response) {
    const wrapped = new FetchResponse(response);
    const responseHTML = await wrapped.responseHTML;
    const { location, redirected, statusCode } = wrapped;

    return session.visit(location, { response: { redirected, statusCode, responseHTML } })
  }

  #findFrameElement(element, submitter) {
    const id = getAttribute("data-turbo-frame", submitter, element) || this.element.getAttribute("target");
    return getFrameElementById(id) ?? this.element
  }

  async extractForeignFrameElement(container) {
    let element;
    const id = CSS.escape(this.id);

    try {
      element = activateElement(container.querySelector(`turbo-frame#${id}`), this.sourceURL);
      if (element) {
        return element
      }

      element = activateElement(container.querySelector(`turbo-frame[src][recurse~=${id}]`), this.sourceURL);
      if (element) {
        await element.loaded;
        return await this.extractForeignFrameElement(element)
      }
    } catch (error) {
      console.error(error);
      return new FrameElement()
    }

    return null
  }

  #formActionIsVisitable(form, submitter) {
    const action = getAction$1(form, submitter);

    return locationIsVisitable(expandURL(action), this.rootLocation)
  }

  #shouldInterceptNavigation(element, submitter) {
    const id = getAttribute("data-turbo-frame", submitter, element) || this.element.getAttribute("target");

    if (element instanceof HTMLFormElement && !this.#formActionIsVisitable(element, submitter)) {
      return false
    }

    if (!this.enabled || id == "_top") {
      return false
    }

    if (id) {
      const frameElement = getFrameElementById(id);
      if (frameElement) {
        return !frameElement.disabled
      }
    }

    if (!session.elementIsNavigatable(element)) {
      return false
    }

    if (submitter && !session.elementIsNavigatable(submitter)) {
      return false
    }

    return true
  }

  // Computed properties

  get id() {
    return this.element.id
  }

  get enabled() {
    return !this.element.disabled
  }

  get sourceURL() {
    if (this.element.src) {
      return this.element.src
    }
  }

  set sourceURL(sourceURL) {
    this.#ignoringChangesToAttribute("src", () => {
      this.element.src = sourceURL ?? null;
    });
  }

  get loadingStyle() {
    return this.element.loading
  }

  get isLoading() {
    return this.formSubmission !== undefined || this.#resolveVisitPromise() !== undefined
  }

  get complete() {
    return this.element.hasAttribute("complete")
  }

  set complete(value) {
    if (value) {
      this.element.setAttribute("complete", "");
    } else {
      this.element.removeAttribute("complete");
    }
  }

  get isActive() {
    return this.element.isActive && this.#connected
  }

  get rootLocation() {
    const meta = this.element.ownerDocument.querySelector(`meta[name="turbo-root"]`);
    const root = meta?.content ?? "/";
    return expandURL(root)
  }

  #isIgnoringChangesTo(attributeName) {
    return this.#ignoredAttributes.has(attributeName)
  }

  #ignoringChangesToAttribute(attributeName, callback) {
    this.#ignoredAttributes.add(attributeName);
    callback();
    this.#ignoredAttributes.delete(attributeName);
  }

  #withCurrentNavigationElement(element, callback) {
    this.currentNavigationElement = element;
    callback();
    delete this.currentNavigationElement;
  }
}

function getFrameElementById(id) {
  if (id != null) {
    const element = document.getElementById(id);
    if (element instanceof FrameElement) {
      return element
    }
  }
}

function activateElement(element, currentURL) {
  if (element) {
    const src = element.getAttribute("src");
    if (src != null && currentURL != null && urlsAreEqual(src, currentURL)) {
      throw new Error(`Matching <turbo-frame id="${element.id}"> element has a source URL which references itself`)
    }
    if (element.ownerDocument !== document) {
      element = document.importNode(element, true);
    }

    if (element instanceof FrameElement) {
      element.connectedCallback();
      element.disconnectedCallback();
      return element
    }
  }
}

const StreamActions = {
  after() {
    this.targetElements.forEach((e) => e.parentElement?.insertBefore(this.templateContent, e.nextSibling));
  },

  append() {
    this.removeDuplicateTargetChildren();
    this.targetElements.forEach((e) => e.append(this.templateContent));
  },

  before() {
    this.targetElements.forEach((e) => e.parentElement?.insertBefore(this.templateContent, e));
  },

  prepend() {
    this.removeDuplicateTargetChildren();
    this.targetElements.forEach((e) => e.prepend(this.templateContent));
  },

  remove() {
    this.targetElements.forEach((e) => e.remove());
  },

  replace() {
    this.targetElements.forEach((e) => e.replaceWith(this.templateContent));
  },

  update() {
    this.targetElements.forEach((targetElement) => {
      targetElement.innerHTML = "";
      targetElement.append(this.templateContent);
    });
  },

  refresh() {
    session.refresh(this.baseURI, this.requestId);
  }
};

// <turbo-stream action=replace target=id><template>...

/**
 * Renders updates to the page from a stream of messages.
 *
 * Using the `action` attribute, this can be configured one of four ways:
 *
 * - `append` - appends the result to the container
 * - `prepend` - prepends the result to the container
 * - `replace` - replaces the contents of the container
 * - `remove` - removes the container
 * - `before` - inserts the result before the target
 * - `after` - inserts the result after the target
 *
 * @customElement turbo-stream
 * @example
 *   <turbo-stream action="append" target="dom_id">
 *     <template>
 *       Content to append to container designated with the dom_id.
 *     </template>
 *   </turbo-stream>
 */
class StreamElement extends HTMLElement {
  static async renderElement(newElement) {
    await newElement.performAction();
  }

  async connectedCallback() {
    try {
      await this.render();
    } catch (error) {
      console.error(error);
    } finally {
      this.disconnect();
    }
  }

  async render() {
    return (this.renderPromise ??= (async () => {
      const event = this.beforeRenderEvent;

      if (this.dispatchEvent(event)) {
        await nextRepaint();
        await event.detail.render(this);
      }
    })())
  }

  disconnect() {
    try {
      this.remove();
      // eslint-disable-next-line no-empty
    } catch {}
  }

  /**
   * Removes duplicate children (by ID)
   */
  removeDuplicateTargetChildren() {
    this.duplicateChildren.forEach((c) => c.remove());
  }

  /**
   * Gets the list of duplicate children (i.e. those with the same ID)
   */
  get duplicateChildren() {
    const existingChildren = this.targetElements.flatMap((e) => [...e.children]).filter((c) => !!c.id);
    const newChildrenIds = [...(this.templateContent?.children || [])].filter((c) => !!c.id).map((c) => c.id);

    return existingChildren.filter((c) => newChildrenIds.includes(c.id))
  }

  /**
   * Gets the action function to be performed.
   */
  get performAction() {
    if (this.action) {
      const actionFunction = StreamActions[this.action];
      if (actionFunction) {
        return actionFunction
      }
      this.#raise("unknown action");
    }
    this.#raise("action attribute is missing");
  }

  /**
   * Gets the target elements which the template will be rendered to.
   */
  get targetElements() {
    if (this.target) {
      return this.targetElementsById
    } else if (this.targets) {
      return this.targetElementsByQuery
    } else {
      this.#raise("target or targets attribute is missing");
    }
  }

  /**
   * Gets the contents of the main `<template>`.
   */
  get templateContent() {
    return this.templateElement.content.cloneNode(true)
  }

  /**
   * Gets the main `<template>` used for rendering
   */
  get templateElement() {
    if (this.firstElementChild === null) {
      const template = this.ownerDocument.createElement("template");
      this.appendChild(template);
      return template
    } else if (this.firstElementChild instanceof HTMLTemplateElement) {
      return this.firstElementChild
    }
    this.#raise("first child element must be a <template> element");
  }

  /**
   * Gets the current action.
   */
  get action() {
    return this.getAttribute("action")
  }

  /**
   * Gets the current target (an element ID) to which the result will
   * be rendered.
   */
  get target() {
    return this.getAttribute("target")
  }

  /**
   * Gets the current "targets" selector (a CSS selector)
   */
  get targets() {
    return this.getAttribute("targets")
  }

  /**
   * Reads the request-id attribute
   */
  get requestId() {
    return this.getAttribute("request-id")
  }

  #raise(message) {
    throw new Error(`${this.description}: ${message}`)
  }

  get description() {
    return (this.outerHTML.match(/<[^>]+>/) ?? [])[0] ?? "<turbo-stream>"
  }

  get beforeRenderEvent() {
    return new CustomEvent("turbo:before-stream-render", {
      bubbles: true,
      cancelable: true,
      detail: { newStream: this, render: StreamElement.renderElement }
    })
  }

  get targetElementsById() {
    const element = this.ownerDocument?.getElementById(this.target);

    if (element !== null) {
      return [element]
    } else {
      return []
    }
  }

  get targetElementsByQuery() {
    const elements = this.ownerDocument?.querySelectorAll(this.targets);

    if (elements.length !== 0) {
      return Array.prototype.slice.call(elements)
    } else {
      return []
    }
  }
}

class StreamSourceElement extends HTMLElement {
  streamSource = null

  connectedCallback() {
    this.streamSource = this.src.match(/^ws{1,2}:/) ? new WebSocket(this.src) : new EventSource(this.src);

    connectStreamSource(this.streamSource);
  }

  disconnectedCallback() {
    if (this.streamSource) {
      this.streamSource.close();

      disconnectStreamSource(this.streamSource);
    }
  }

  get src() {
    return this.getAttribute("src") || ""
  }
}

FrameElement.delegateConstructor = FrameController;

if (customElements.get("turbo-frame") === undefined) {
  customElements.define("turbo-frame", FrameElement);
}

if (customElements.get("turbo-stream") === undefined) {
  customElements.define("turbo-stream", StreamElement);
}

if (customElements.get("turbo-stream-source") === undefined) {
  customElements.define("turbo-stream-source", StreamSourceElement);
}

(() => {
  let element = document.currentScript;
  if (!element) return
  if (element.hasAttribute("data-turbo-suppress-warning")) return

  element = element.parentElement;
  while (element) {
    if (element == document.body) {
      return console.warn(
        unindent`
        You are loading Turbo from a <script> element inside the <body> element. This is probably not what you meant to do!

        Load your application’s JavaScript bundle inside the <head> element instead. <script> elements in <body> are evaluated with each page change.

        For more information, see: https://turbo.hotwired.dev/handbook/building#working-with-script-elements

        ——
        Suppress this warning by adding a "data-turbo-suppress-warning" attribute to: %s
      `,
        element.outerHTML
      )
    }

    element = element.parentElement;
  }
})();

window.Turbo = { ...Turbo, StreamActions };
start();




/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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