(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_symfony_stimulus-bridge_dist_index_js-node_modules_tom-select_dist_css_t-eb4bfa"],{

/***/ "./node_modules/@hotwired/stimulus/dist/stimulus.js":
/*!**********************************************************!*\
  !*** ./node_modules/@hotwired/stimulus/dist/stimulus.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Application: () => (/* binding */ Application),
/* harmony export */   AttributeObserver: () => (/* binding */ AttributeObserver),
/* harmony export */   Context: () => (/* binding */ Context),
/* harmony export */   Controller: () => (/* binding */ Controller),
/* harmony export */   ElementObserver: () => (/* binding */ ElementObserver),
/* harmony export */   IndexedMultimap: () => (/* binding */ IndexedMultimap),
/* harmony export */   Multimap: () => (/* binding */ Multimap),
/* harmony export */   SelectorObserver: () => (/* binding */ SelectorObserver),
/* harmony export */   StringMapObserver: () => (/* binding */ StringMapObserver),
/* harmony export */   TokenListObserver: () => (/* binding */ TokenListObserver),
/* harmony export */   ValueListObserver: () => (/* binding */ ValueListObserver),
/* harmony export */   add: () => (/* binding */ add),
/* harmony export */   defaultSchema: () => (/* binding */ defaultSchema),
/* harmony export */   del: () => (/* binding */ del),
/* harmony export */   fetch: () => (/* binding */ fetch),
/* harmony export */   prune: () => (/* binding */ prune)
/* harmony export */ });
/*
Stimulus 3.2.1
Copyright © 2023 Basecamp, LLC
 */
class EventListener {
    constructor(eventTarget, eventName, eventOptions) {
        this.eventTarget = eventTarget;
        this.eventName = eventName;
        this.eventOptions = eventOptions;
        this.unorderedBindings = new Set();
    }
    connect() {
        this.eventTarget.addEventListener(this.eventName, this, this.eventOptions);
    }
    disconnect() {
        this.eventTarget.removeEventListener(this.eventName, this, this.eventOptions);
    }
    bindingConnected(binding) {
        this.unorderedBindings.add(binding);
    }
    bindingDisconnected(binding) {
        this.unorderedBindings.delete(binding);
    }
    handleEvent(event) {
        const extendedEvent = extendEvent(event);
        for (const binding of this.bindings) {
            if (extendedEvent.immediatePropagationStopped) {
                break;
            }
            else {
                binding.handleEvent(extendedEvent);
            }
        }
    }
    hasBindings() {
        return this.unorderedBindings.size > 0;
    }
    get bindings() {
        return Array.from(this.unorderedBindings).sort((left, right) => {
            const leftIndex = left.index, rightIndex = right.index;
            return leftIndex < rightIndex ? -1 : leftIndex > rightIndex ? 1 : 0;
        });
    }
}
function extendEvent(event) {
    if ("immediatePropagationStopped" in event) {
        return event;
    }
    else {
        const { stopImmediatePropagation } = event;
        return Object.assign(event, {
            immediatePropagationStopped: false,
            stopImmediatePropagation() {
                this.immediatePropagationStopped = true;
                stopImmediatePropagation.call(this);
            },
        });
    }
}

class Dispatcher {
    constructor(application) {
        this.application = application;
        this.eventListenerMaps = new Map();
        this.started = false;
    }
    start() {
        if (!this.started) {
            this.started = true;
            this.eventListeners.forEach((eventListener) => eventListener.connect());
        }
    }
    stop() {
        if (this.started) {
            this.started = false;
            this.eventListeners.forEach((eventListener) => eventListener.disconnect());
        }
    }
    get eventListeners() {
        return Array.from(this.eventListenerMaps.values()).reduce((listeners, map) => listeners.concat(Array.from(map.values())), []);
    }
    bindingConnected(binding) {
        this.fetchEventListenerForBinding(binding).bindingConnected(binding);
    }
    bindingDisconnected(binding, clearEventListeners = false) {
        this.fetchEventListenerForBinding(binding).bindingDisconnected(binding);
        if (clearEventListeners)
            this.clearEventListenersForBinding(binding);
    }
    handleError(error, message, detail = {}) {
        this.application.handleError(error, `Error ${message}`, detail);
    }
    clearEventListenersForBinding(binding) {
        const eventListener = this.fetchEventListenerForBinding(binding);
        if (!eventListener.hasBindings()) {
            eventListener.disconnect();
            this.removeMappedEventListenerFor(binding);
        }
    }
    removeMappedEventListenerFor(binding) {
        const { eventTarget, eventName, eventOptions } = binding;
        const eventListenerMap = this.fetchEventListenerMapForEventTarget(eventTarget);
        const cacheKey = this.cacheKey(eventName, eventOptions);
        eventListenerMap.delete(cacheKey);
        if (eventListenerMap.size == 0)
            this.eventListenerMaps.delete(eventTarget);
    }
    fetchEventListenerForBinding(binding) {
        const { eventTarget, eventName, eventOptions } = binding;
        return this.fetchEventListener(eventTarget, eventName, eventOptions);
    }
    fetchEventListener(eventTarget, eventName, eventOptions) {
        const eventListenerMap = this.fetchEventListenerMapForEventTarget(eventTarget);
        const cacheKey = this.cacheKey(eventName, eventOptions);
        let eventListener = eventListenerMap.get(cacheKey);
        if (!eventListener) {
            eventListener = this.createEventListener(eventTarget, eventName, eventOptions);
            eventListenerMap.set(cacheKey, eventListener);
        }
        return eventListener;
    }
    createEventListener(eventTarget, eventName, eventOptions) {
        const eventListener = new EventListener(eventTarget, eventName, eventOptions);
        if (this.started) {
            eventListener.connect();
        }
        return eventListener;
    }
    fetchEventListenerMapForEventTarget(eventTarget) {
        let eventListenerMap = this.eventListenerMaps.get(eventTarget);
        if (!eventListenerMap) {
            eventListenerMap = new Map();
            this.eventListenerMaps.set(eventTarget, eventListenerMap);
        }
        return eventListenerMap;
    }
    cacheKey(eventName, eventOptions) {
        const parts = [eventName];
        Object.keys(eventOptions)
            .sort()
            .forEach((key) => {
            parts.push(`${eventOptions[key] ? "" : "!"}${key}`);
        });
        return parts.join(":");
    }
}

const defaultActionDescriptorFilters = {
    stop({ event, value }) {
        if (value)
            event.stopPropagation();
        return true;
    },
    prevent({ event, value }) {
        if (value)
            event.preventDefault();
        return true;
    },
    self({ event, value, element }) {
        if (value) {
            return element === event.target;
        }
        else {
            return true;
        }
    },
};
const descriptorPattern = /^(?:(?:([^.]+?)\+)?(.+?)(?:\.(.+?))?(?:@(window|document))?->)?(.+?)(?:#([^:]+?))(?::(.+))?$/;
function parseActionDescriptorString(descriptorString) {
    const source = descriptorString.trim();
    const matches = source.match(descriptorPattern) || [];
    let eventName = matches[2];
    let keyFilter = matches[3];
    if (keyFilter && !["keydown", "keyup", "keypress"].includes(eventName)) {
        eventName += `.${keyFilter}`;
        keyFilter = "";
    }
    return {
        eventTarget: parseEventTarget(matches[4]),
        eventName,
        eventOptions: matches[7] ? parseEventOptions(matches[7]) : {},
        identifier: matches[5],
        methodName: matches[6],
        keyFilter: matches[1] || keyFilter,
    };
}
function parseEventTarget(eventTargetName) {
    if (eventTargetName == "window") {
        return window;
    }
    else if (eventTargetName == "document") {
        return document;
    }
}
function parseEventOptions(eventOptions) {
    return eventOptions
        .split(":")
        .reduce((options, token) => Object.assign(options, { [token.replace(/^!/, "")]: !/^!/.test(token) }), {});
}
function stringifyEventTarget(eventTarget) {
    if (eventTarget == window) {
        return "window";
    }
    else if (eventTarget == document) {
        return "document";
    }
}

function camelize(value) {
    return value.replace(/(?:[_-])([a-z0-9])/g, (_, char) => char.toUpperCase());
}
function namespaceCamelize(value) {
    return camelize(value.replace(/--/g, "-").replace(/__/g, "_"));
}
function capitalize(value) {
    return value.charAt(0).toUpperCase() + value.slice(1);
}
function dasherize(value) {
    return value.replace(/([A-Z])/g, (_, char) => `-${char.toLowerCase()}`);
}
function tokenize(value) {
    return value.match(/[^\s]+/g) || [];
}

function isSomething(object) {
    return object !== null && object !== undefined;
}
function hasProperty(object, property) {
    return Object.prototype.hasOwnProperty.call(object, property);
}

const allModifiers = ["meta", "ctrl", "alt", "shift"];
class Action {
    constructor(element, index, descriptor, schema) {
        this.element = element;
        this.index = index;
        this.eventTarget = descriptor.eventTarget || element;
        this.eventName = descriptor.eventName || getDefaultEventNameForElement(element) || error("missing event name");
        this.eventOptions = descriptor.eventOptions || {};
        this.identifier = descriptor.identifier || error("missing identifier");
        this.methodName = descriptor.methodName || error("missing method name");
        this.keyFilter = descriptor.keyFilter || "";
        this.schema = schema;
    }
    static forToken(token, schema) {
        return new this(token.element, token.index, parseActionDescriptorString(token.content), schema);
    }
    toString() {
        const eventFilter = this.keyFilter ? `.${this.keyFilter}` : "";
        const eventTarget = this.eventTargetName ? `@${this.eventTargetName}` : "";
        return `${this.eventName}${eventFilter}${eventTarget}->${this.identifier}#${this.methodName}`;
    }
    shouldIgnoreKeyboardEvent(event) {
        if (!this.keyFilter) {
            return false;
        }
        const filters = this.keyFilter.split("+");
        if (this.keyFilterDissatisfied(event, filters)) {
            return true;
        }
        const standardFilter = filters.filter((key) => !allModifiers.includes(key))[0];
        if (!standardFilter) {
            return false;
        }
        if (!hasProperty(this.keyMappings, standardFilter)) {
            error(`contains unknown key filter: ${this.keyFilter}`);
        }
        return this.keyMappings[standardFilter].toLowerCase() !== event.key.toLowerCase();
    }
    shouldIgnoreMouseEvent(event) {
        if (!this.keyFilter) {
            return false;
        }
        const filters = [this.keyFilter];
        if (this.keyFilterDissatisfied(event, filters)) {
            return true;
        }
        return false;
    }
    get params() {
        const params = {};
        const pattern = new RegExp(`^data-${this.identifier}-(.+)-param$`, "i");
        for (const { name, value } of Array.from(this.element.attributes)) {
            const match = name.match(pattern);
            const key = match && match[1];
            if (key) {
                params[camelize(key)] = typecast(value);
            }
        }
        return params;
    }
    get eventTargetName() {
        return stringifyEventTarget(this.eventTarget);
    }
    get keyMappings() {
        return this.schema.keyMappings;
    }
    keyFilterDissatisfied(event, filters) {
        const [meta, ctrl, alt, shift] = allModifiers.map((modifier) => filters.includes(modifier));
        return event.metaKey !== meta || event.ctrlKey !== ctrl || event.altKey !== alt || event.shiftKey !== shift;
    }
}
const defaultEventNames = {
    a: () => "click",
    button: () => "click",
    form: () => "submit",
    details: () => "toggle",
    input: (e) => (e.getAttribute("type") == "submit" ? "click" : "input"),
    select: () => "change",
    textarea: () => "input",
};
function getDefaultEventNameForElement(element) {
    const tagName = element.tagName.toLowerCase();
    if (tagName in defaultEventNames) {
        return defaultEventNames[tagName](element);
    }
}
function error(message) {
    throw new Error(message);
}
function typecast(value) {
    try {
        return JSON.parse(value);
    }
    catch (o_O) {
        return value;
    }
}

class Binding {
    constructor(context, action) {
        this.context = context;
        this.action = action;
    }
    get index() {
        return this.action.index;
    }
    get eventTarget() {
        return this.action.eventTarget;
    }
    get eventOptions() {
        return this.action.eventOptions;
    }
    get identifier() {
        return this.context.identifier;
    }
    handleEvent(event) {
        const actionEvent = this.prepareActionEvent(event);
        if (this.willBeInvokedByEvent(event) && this.applyEventModifiers(actionEvent)) {
            this.invokeWithEvent(actionEvent);
        }
    }
    get eventName() {
        return this.action.eventName;
    }
    get method() {
        const method = this.controller[this.methodName];
        if (typeof method == "function") {
            return method;
        }
        throw new Error(`Action "${this.action}" references undefined method "${this.methodName}"`);
    }
    applyEventModifiers(event) {
        const { element } = this.action;
        const { actionDescriptorFilters } = this.context.application;
        const { controller } = this.context;
        let passes = true;
        for (const [name, value] of Object.entries(this.eventOptions)) {
            if (name in actionDescriptorFilters) {
                const filter = actionDescriptorFilters[name];
                passes = passes && filter({ name, value, event, element, controller });
            }
            else {
                continue;
            }
        }
        return passes;
    }
    prepareActionEvent(event) {
        return Object.assign(event, { params: this.action.params });
    }
    invokeWithEvent(event) {
        const { target, currentTarget } = event;
        try {
            this.method.call(this.controller, event);
            this.context.logDebugActivity(this.methodName, { event, target, currentTarget, action: this.methodName });
        }
        catch (error) {
            const { identifier, controller, element, index } = this;
            const detail = { identifier, controller, element, index, event };
            this.context.handleError(error, `invoking action "${this.action}"`, detail);
        }
    }
    willBeInvokedByEvent(event) {
        const eventTarget = event.target;
        if (event instanceof KeyboardEvent && this.action.shouldIgnoreKeyboardEvent(event)) {
            return false;
        }
        if (event instanceof MouseEvent && this.action.shouldIgnoreMouseEvent(event)) {
            return false;
        }
        if (this.element === eventTarget) {
            return true;
        }
        else if (eventTarget instanceof Element && this.element.contains(eventTarget)) {
            return this.scope.containsElement(eventTarget);
        }
        else {
            return this.scope.containsElement(this.action.element);
        }
    }
    get controller() {
        return this.context.controller;
    }
    get methodName() {
        return this.action.methodName;
    }
    get element() {
        return this.scope.element;
    }
    get scope() {
        return this.context.scope;
    }
}

class ElementObserver {
    constructor(element, delegate) {
        this.mutationObserverInit = { attributes: true, childList: true, subtree: true };
        this.element = element;
        this.started = false;
        this.delegate = delegate;
        this.elements = new Set();
        this.mutationObserver = new MutationObserver((mutations) => this.processMutations(mutations));
    }
    start() {
        if (!this.started) {
            this.started = true;
            this.mutationObserver.observe(this.element, this.mutationObserverInit);
            this.refresh();
        }
    }
    pause(callback) {
        if (this.started) {
            this.mutationObserver.disconnect();
            this.started = false;
        }
        callback();
        if (!this.started) {
            this.mutationObserver.observe(this.element, this.mutationObserverInit);
            this.started = true;
        }
    }
    stop() {
        if (this.started) {
            this.mutationObserver.takeRecords();
            this.mutationObserver.disconnect();
            this.started = false;
        }
    }
    refresh() {
        if (this.started) {
            const matches = new Set(this.matchElementsInTree());
            for (const element of Array.from(this.elements)) {
                if (!matches.has(element)) {
                    this.removeElement(element);
                }
            }
            for (const element of Array.from(matches)) {
                this.addElement(element);
            }
        }
    }
    processMutations(mutations) {
        if (this.started) {
            for (const mutation of mutations) {
                this.processMutation(mutation);
            }
        }
    }
    processMutation(mutation) {
        if (mutation.type == "attributes") {
            this.processAttributeChange(mutation.target, mutation.attributeName);
        }
        else if (mutation.type == "childList") {
            this.processRemovedNodes(mutation.removedNodes);
            this.processAddedNodes(mutation.addedNodes);
        }
    }
    processAttributeChange(element, attributeName) {
        if (this.elements.has(element)) {
            if (this.delegate.elementAttributeChanged && this.matchElement(element)) {
                this.delegate.elementAttributeChanged(element, attributeName);
            }
            else {
                this.removeElement(element);
            }
        }
        else if (this.matchElement(element)) {
            this.addElement(element);
        }
    }
    processRemovedNodes(nodes) {
        for (const node of Array.from(nodes)) {
            const element = this.elementFromNode(node);
            if (element) {
                this.processTree(element, this.removeElement);
            }
        }
    }
    processAddedNodes(nodes) {
        for (const node of Array.from(nodes)) {
            const element = this.elementFromNode(node);
            if (element && this.elementIsActive(element)) {
                this.processTree(element, this.addElement);
            }
        }
    }
    matchElement(element) {
        return this.delegate.matchElement(element);
    }
    matchElementsInTree(tree = this.element) {
        return this.delegate.matchElementsInTree(tree);
    }
    processTree(tree, processor) {
        for (const element of this.matchElementsInTree(tree)) {
            processor.call(this, element);
        }
    }
    elementFromNode(node) {
        if (node.nodeType == Node.ELEMENT_NODE) {
            return node;
        }
    }
    elementIsActive(element) {
        if (element.isConnected != this.element.isConnected) {
            return false;
        }
        else {
            return this.element.contains(element);
        }
    }
    addElement(element) {
        if (!this.elements.has(element)) {
            if (this.elementIsActive(element)) {
                this.elements.add(element);
                if (this.delegate.elementMatched) {
                    this.delegate.elementMatched(element);
                }
            }
        }
    }
    removeElement(element) {
        if (this.elements.has(element)) {
            this.elements.delete(element);
            if (this.delegate.elementUnmatched) {
                this.delegate.elementUnmatched(element);
            }
        }
    }
}

class AttributeObserver {
    constructor(element, attributeName, delegate) {
        this.attributeName = attributeName;
        this.delegate = delegate;
        this.elementObserver = new ElementObserver(element, this);
    }
    get element() {
        return this.elementObserver.element;
    }
    get selector() {
        return `[${this.attributeName}]`;
    }
    start() {
        this.elementObserver.start();
    }
    pause(callback) {
        this.elementObserver.pause(callback);
    }
    stop() {
        this.elementObserver.stop();
    }
    refresh() {
        this.elementObserver.refresh();
    }
    get started() {
        return this.elementObserver.started;
    }
    matchElement(element) {
        return element.hasAttribute(this.attributeName);
    }
    matchElementsInTree(tree) {
        const match = this.matchElement(tree) ? [tree] : [];
        const matches = Array.from(tree.querySelectorAll(this.selector));
        return match.concat(matches);
    }
    elementMatched(element) {
        if (this.delegate.elementMatchedAttribute) {
            this.delegate.elementMatchedAttribute(element, this.attributeName);
        }
    }
    elementUnmatched(element) {
        if (this.delegate.elementUnmatchedAttribute) {
            this.delegate.elementUnmatchedAttribute(element, this.attributeName);
        }
    }
    elementAttributeChanged(element, attributeName) {
        if (this.delegate.elementAttributeValueChanged && this.attributeName == attributeName) {
            this.delegate.elementAttributeValueChanged(element, attributeName);
        }
    }
}

function add(map, key, value) {
    fetch(map, key).add(value);
}
function del(map, key, value) {
    fetch(map, key).delete(value);
    prune(map, key);
}
function fetch(map, key) {
    let values = map.get(key);
    if (!values) {
        values = new Set();
        map.set(key, values);
    }
    return values;
}
function prune(map, key) {
    const values = map.get(key);
    if (values != null && values.size == 0) {
        map.delete(key);
    }
}

class Multimap {
    constructor() {
        this.valuesByKey = new Map();
    }
    get keys() {
        return Array.from(this.valuesByKey.keys());
    }
    get values() {
        const sets = Array.from(this.valuesByKey.values());
        return sets.reduce((values, set) => values.concat(Array.from(set)), []);
    }
    get size() {
        const sets = Array.from(this.valuesByKey.values());
        return sets.reduce((size, set) => size + set.size, 0);
    }
    add(key, value) {
        add(this.valuesByKey, key, value);
    }
    delete(key, value) {
        del(this.valuesByKey, key, value);
    }
    has(key, value) {
        const values = this.valuesByKey.get(key);
        return values != null && values.has(value);
    }
    hasKey(key) {
        return this.valuesByKey.has(key);
    }
    hasValue(value) {
        const sets = Array.from(this.valuesByKey.values());
        return sets.some((set) => set.has(value));
    }
    getValuesForKey(key) {
        const values = this.valuesByKey.get(key);
        return values ? Array.from(values) : [];
    }
    getKeysForValue(value) {
        return Array.from(this.valuesByKey)
            .filter(([_key, values]) => values.has(value))
            .map(([key, _values]) => key);
    }
}

class IndexedMultimap extends Multimap {
    constructor() {
        super();
        this.keysByValue = new Map();
    }
    get values() {
        return Array.from(this.keysByValue.keys());
    }
    add(key, value) {
        super.add(key, value);
        add(this.keysByValue, value, key);
    }
    delete(key, value) {
        super.delete(key, value);
        del(this.keysByValue, value, key);
    }
    hasValue(value) {
        return this.keysByValue.has(value);
    }
    getKeysForValue(value) {
        const set = this.keysByValue.get(value);
        return set ? Array.from(set) : [];
    }
}

class SelectorObserver {
    constructor(element, selector, delegate, details) {
        this._selector = selector;
        this.details = details;
        this.elementObserver = new ElementObserver(element, this);
        this.delegate = delegate;
        this.matchesByElement = new Multimap();
    }
    get started() {
        return this.elementObserver.started;
    }
    get selector() {
        return this._selector;
    }
    set selector(selector) {
        this._selector = selector;
        this.refresh();
    }
    start() {
        this.elementObserver.start();
    }
    pause(callback) {
        this.elementObserver.pause(callback);
    }
    stop() {
        this.elementObserver.stop();
    }
    refresh() {
        this.elementObserver.refresh();
    }
    get element() {
        return this.elementObserver.element;
    }
    matchElement(element) {
        const { selector } = this;
        if (selector) {
            const matches = element.matches(selector);
            if (this.delegate.selectorMatchElement) {
                return matches && this.delegate.selectorMatchElement(element, this.details);
            }
            return matches;
        }
        else {
            return false;
        }
    }
    matchElementsInTree(tree) {
        const { selector } = this;
        if (selector) {
            const match = this.matchElement(tree) ? [tree] : [];
            const matches = Array.from(tree.querySelectorAll(selector)).filter((match) => this.matchElement(match));
            return match.concat(matches);
        }
        else {
            return [];
        }
    }
    elementMatched(element) {
        const { selector } = this;
        if (selector) {
            this.selectorMatched(element, selector);
        }
    }
    elementUnmatched(element) {
        const selectors = this.matchesByElement.getKeysForValue(element);
        for (const selector of selectors) {
            this.selectorUnmatched(element, selector);
        }
    }
    elementAttributeChanged(element, _attributeName) {
        const { selector } = this;
        if (selector) {
            const matches = this.matchElement(element);
            const matchedBefore = this.matchesByElement.has(selector, element);
            if (matches && !matchedBefore) {
                this.selectorMatched(element, selector);
            }
            else if (!matches && matchedBefore) {
                this.selectorUnmatched(element, selector);
            }
        }
    }
    selectorMatched(element, selector) {
        this.delegate.selectorMatched(element, selector, this.details);
        this.matchesByElement.add(selector, element);
    }
    selectorUnmatched(element, selector) {
        this.delegate.selectorUnmatched(element, selector, this.details);
        this.matchesByElement.delete(selector, element);
    }
}

class StringMapObserver {
    constructor(element, delegate) {
        this.element = element;
        this.delegate = delegate;
        this.started = false;
        this.stringMap = new Map();
        this.mutationObserver = new MutationObserver((mutations) => this.processMutations(mutations));
    }
    start() {
        if (!this.started) {
            this.started = true;
            this.mutationObserver.observe(this.element, { attributes: true, attributeOldValue: true });
            this.refresh();
        }
    }
    stop() {
        if (this.started) {
            this.mutationObserver.takeRecords();
            this.mutationObserver.disconnect();
            this.started = false;
        }
    }
    refresh() {
        if (this.started) {
            for (const attributeName of this.knownAttributeNames) {
                this.refreshAttribute(attributeName, null);
            }
        }
    }
    processMutations(mutations) {
        if (this.started) {
            for (const mutation of mutations) {
                this.processMutation(mutation);
            }
        }
    }
    processMutation(mutation) {
        const attributeName = mutation.attributeName;
        if (attributeName) {
            this.refreshAttribute(attributeName, mutation.oldValue);
        }
    }
    refreshAttribute(attributeName, oldValue) {
        const key = this.delegate.getStringMapKeyForAttribute(attributeName);
        if (key != null) {
            if (!this.stringMap.has(attributeName)) {
                this.stringMapKeyAdded(key, attributeName);
            }
            const value = this.element.getAttribute(attributeName);
            if (this.stringMap.get(attributeName) != value) {
                this.stringMapValueChanged(value, key, oldValue);
            }
            if (value == null) {
                const oldValue = this.stringMap.get(attributeName);
                this.stringMap.delete(attributeName);
                if (oldValue)
                    this.stringMapKeyRemoved(key, attributeName, oldValue);
            }
            else {
                this.stringMap.set(attributeName, value);
            }
        }
    }
    stringMapKeyAdded(key, attributeName) {
        if (this.delegate.stringMapKeyAdded) {
            this.delegate.stringMapKeyAdded(key, attributeName);
        }
    }
    stringMapValueChanged(value, key, oldValue) {
        if (this.delegate.stringMapValueChanged) {
            this.delegate.stringMapValueChanged(value, key, oldValue);
        }
    }
    stringMapKeyRemoved(key, attributeName, oldValue) {
        if (this.delegate.stringMapKeyRemoved) {
            this.delegate.stringMapKeyRemoved(key, attributeName, oldValue);
        }
    }
    get knownAttributeNames() {
        return Array.from(new Set(this.currentAttributeNames.concat(this.recordedAttributeNames)));
    }
    get currentAttributeNames() {
        return Array.from(this.element.attributes).map((attribute) => attribute.name);
    }
    get recordedAttributeNames() {
        return Array.from(this.stringMap.keys());
    }
}

class TokenListObserver {
    constructor(element, attributeName, delegate) {
        this.attributeObserver = new AttributeObserver(element, attributeName, this);
        this.delegate = delegate;
        this.tokensByElement = new Multimap();
    }
    get started() {
        return this.attributeObserver.started;
    }
    start() {
        this.attributeObserver.start();
    }
    pause(callback) {
        this.attributeObserver.pause(callback);
    }
    stop() {
        this.attributeObserver.stop();
    }
    refresh() {
        this.attributeObserver.refresh();
    }
    get element() {
        return this.attributeObserver.element;
    }
    get attributeName() {
        return this.attributeObserver.attributeName;
    }
    elementMatchedAttribute(element) {
        this.tokensMatched(this.readTokensForElement(element));
    }
    elementAttributeValueChanged(element) {
        const [unmatchedTokens, matchedTokens] = this.refreshTokensForElement(element);
        this.tokensUnmatched(unmatchedTokens);
        this.tokensMatched(matchedTokens);
    }
    elementUnmatchedAttribute(element) {
        this.tokensUnmatched(this.tokensByElement.getValuesForKey(element));
    }
    tokensMatched(tokens) {
        tokens.forEach((token) => this.tokenMatched(token));
    }
    tokensUnmatched(tokens) {
        tokens.forEach((token) => this.tokenUnmatched(token));
    }
    tokenMatched(token) {
        this.delegate.tokenMatched(token);
        this.tokensByElement.add(token.element, token);
    }
    tokenUnmatched(token) {
        this.delegate.tokenUnmatched(token);
        this.tokensByElement.delete(token.element, token);
    }
    refreshTokensForElement(element) {
        const previousTokens = this.tokensByElement.getValuesForKey(element);
        const currentTokens = this.readTokensForElement(element);
        const firstDifferingIndex = zip(previousTokens, currentTokens).findIndex(([previousToken, currentToken]) => !tokensAreEqual(previousToken, currentToken));
        if (firstDifferingIndex == -1) {
            return [[], []];
        }
        else {
            return [previousTokens.slice(firstDifferingIndex), currentTokens.slice(firstDifferingIndex)];
        }
    }
    readTokensForElement(element) {
        const attributeName = this.attributeName;
        const tokenString = element.getAttribute(attributeName) || "";
        return parseTokenString(tokenString, element, attributeName);
    }
}
function parseTokenString(tokenString, element, attributeName) {
    return tokenString
        .trim()
        .split(/\s+/)
        .filter((content) => content.length)
        .map((content, index) => ({ element, attributeName, content, index }));
}
function zip(left, right) {
    const length = Math.max(left.length, right.length);
    return Array.from({ length }, (_, index) => [left[index], right[index]]);
}
function tokensAreEqual(left, right) {
    return left && right && left.index == right.index && left.content == right.content;
}

class ValueListObserver {
    constructor(element, attributeName, delegate) {
        this.tokenListObserver = new TokenListObserver(element, attributeName, this);
        this.delegate = delegate;
        this.parseResultsByToken = new WeakMap();
        this.valuesByTokenByElement = new WeakMap();
    }
    get started() {
        return this.tokenListObserver.started;
    }
    start() {
        this.tokenListObserver.start();
    }
    stop() {
        this.tokenListObserver.stop();
    }
    refresh() {
        this.tokenListObserver.refresh();
    }
    get element() {
        return this.tokenListObserver.element;
    }
    get attributeName() {
        return this.tokenListObserver.attributeName;
    }
    tokenMatched(token) {
        const { element } = token;
        const { value } = this.fetchParseResultForToken(token);
        if (value) {
            this.fetchValuesByTokenForElement(element).set(token, value);
            this.delegate.elementMatchedValue(element, value);
        }
    }
    tokenUnmatched(token) {
        const { element } = token;
        const { value } = this.fetchParseResultForToken(token);
        if (value) {
            this.fetchValuesByTokenForElement(element).delete(token);
            this.delegate.elementUnmatchedValue(element, value);
        }
    }
    fetchParseResultForToken(token) {
        let parseResult = this.parseResultsByToken.get(token);
        if (!parseResult) {
            parseResult = this.parseToken(token);
            this.parseResultsByToken.set(token, parseResult);
        }
        return parseResult;
    }
    fetchValuesByTokenForElement(element) {
        let valuesByToken = this.valuesByTokenByElement.get(element);
        if (!valuesByToken) {
            valuesByToken = new Map();
            this.valuesByTokenByElement.set(element, valuesByToken);
        }
        return valuesByToken;
    }
    parseToken(token) {
        try {
            const value = this.delegate.parseValueForToken(token);
            return { value };
        }
        catch (error) {
            return { error };
        }
    }
}

class BindingObserver {
    constructor(context, delegate) {
        this.context = context;
        this.delegate = delegate;
        this.bindingsByAction = new Map();
    }
    start() {
        if (!this.valueListObserver) {
            this.valueListObserver = new ValueListObserver(this.element, this.actionAttribute, this);
            this.valueListObserver.start();
        }
    }
    stop() {
        if (this.valueListObserver) {
            this.valueListObserver.stop();
            delete this.valueListObserver;
            this.disconnectAllActions();
        }
    }
    get element() {
        return this.context.element;
    }
    get identifier() {
        return this.context.identifier;
    }
    get actionAttribute() {
        return this.schema.actionAttribute;
    }
    get schema() {
        return this.context.schema;
    }
    get bindings() {
        return Array.from(this.bindingsByAction.values());
    }
    connectAction(action) {
        const binding = new Binding(this.context, action);
        this.bindingsByAction.set(action, binding);
        this.delegate.bindingConnected(binding);
    }
    disconnectAction(action) {
        const binding = this.bindingsByAction.get(action);
        if (binding) {
            this.bindingsByAction.delete(action);
            this.delegate.bindingDisconnected(binding);
        }
    }
    disconnectAllActions() {
        this.bindings.forEach((binding) => this.delegate.bindingDisconnected(binding, true));
        this.bindingsByAction.clear();
    }
    parseValueForToken(token) {
        const action = Action.forToken(token, this.schema);
        if (action.identifier == this.identifier) {
            return action;
        }
    }
    elementMatchedValue(element, action) {
        this.connectAction(action);
    }
    elementUnmatchedValue(element, action) {
        this.disconnectAction(action);
    }
}

class ValueObserver {
    constructor(context, receiver) {
        this.context = context;
        this.receiver = receiver;
        this.stringMapObserver = new StringMapObserver(this.element, this);
        this.valueDescriptorMap = this.controller.valueDescriptorMap;
    }
    start() {
        this.stringMapObserver.start();
        this.invokeChangedCallbacksForDefaultValues();
    }
    stop() {
        this.stringMapObserver.stop();
    }
    get element() {
        return this.context.element;
    }
    get controller() {
        return this.context.controller;
    }
    getStringMapKeyForAttribute(attributeName) {
        if (attributeName in this.valueDescriptorMap) {
            return this.valueDescriptorMap[attributeName].name;
        }
    }
    stringMapKeyAdded(key, attributeName) {
        const descriptor = this.valueDescriptorMap[attributeName];
        if (!this.hasValue(key)) {
            this.invokeChangedCallback(key, descriptor.writer(this.receiver[key]), descriptor.writer(descriptor.defaultValue));
        }
    }
    stringMapValueChanged(value, name, oldValue) {
        const descriptor = this.valueDescriptorNameMap[name];
        if (value === null)
            return;
        if (oldValue === null) {
            oldValue = descriptor.writer(descriptor.defaultValue);
        }
        this.invokeChangedCallback(name, value, oldValue);
    }
    stringMapKeyRemoved(key, attributeName, oldValue) {
        const descriptor = this.valueDescriptorNameMap[key];
        if (this.hasValue(key)) {
            this.invokeChangedCallback(key, descriptor.writer(this.receiver[key]), oldValue);
        }
        else {
            this.invokeChangedCallback(key, descriptor.writer(descriptor.defaultValue), oldValue);
        }
    }
    invokeChangedCallbacksForDefaultValues() {
        for (const { key, name, defaultValue, writer } of this.valueDescriptors) {
            if (defaultValue != undefined && !this.controller.data.has(key)) {
                this.invokeChangedCallback(name, writer(defaultValue), undefined);
            }
        }
    }
    invokeChangedCallback(name, rawValue, rawOldValue) {
        const changedMethodName = `${name}Changed`;
        const changedMethod = this.receiver[changedMethodName];
        if (typeof changedMethod == "function") {
            const descriptor = this.valueDescriptorNameMap[name];
            try {
                const value = descriptor.reader(rawValue);
                let oldValue = rawOldValue;
                if (rawOldValue) {
                    oldValue = descriptor.reader(rawOldValue);
                }
                changedMethod.call(this.receiver, value, oldValue);
            }
            catch (error) {
                if (error instanceof TypeError) {
                    error.message = `Stimulus Value "${this.context.identifier}.${descriptor.name}" - ${error.message}`;
                }
                throw error;
            }
        }
    }
    get valueDescriptors() {
        const { valueDescriptorMap } = this;
        return Object.keys(valueDescriptorMap).map((key) => valueDescriptorMap[key]);
    }
    get valueDescriptorNameMap() {
        const descriptors = {};
        Object.keys(this.valueDescriptorMap).forEach((key) => {
            const descriptor = this.valueDescriptorMap[key];
            descriptors[descriptor.name] = descriptor;
        });
        return descriptors;
    }
    hasValue(attributeName) {
        const descriptor = this.valueDescriptorNameMap[attributeName];
        const hasMethodName = `has${capitalize(descriptor.name)}`;
        return this.receiver[hasMethodName];
    }
}

class TargetObserver {
    constructor(context, delegate) {
        this.context = context;
        this.delegate = delegate;
        this.targetsByName = new Multimap();
    }
    start() {
        if (!this.tokenListObserver) {
            this.tokenListObserver = new TokenListObserver(this.element, this.attributeName, this);
            this.tokenListObserver.start();
        }
    }
    stop() {
        if (this.tokenListObserver) {
            this.disconnectAllTargets();
            this.tokenListObserver.stop();
            delete this.tokenListObserver;
        }
    }
    tokenMatched({ element, content: name }) {
        if (this.scope.containsElement(element)) {
            this.connectTarget(element, name);
        }
    }
    tokenUnmatched({ element, content: name }) {
        this.disconnectTarget(element, name);
    }
    connectTarget(element, name) {
        var _a;
        if (!this.targetsByName.has(name, element)) {
            this.targetsByName.add(name, element);
            (_a = this.tokenListObserver) === null || _a === void 0 ? void 0 : _a.pause(() => this.delegate.targetConnected(element, name));
        }
    }
    disconnectTarget(element, name) {
        var _a;
        if (this.targetsByName.has(name, element)) {
            this.targetsByName.delete(name, element);
            (_a = this.tokenListObserver) === null || _a === void 0 ? void 0 : _a.pause(() => this.delegate.targetDisconnected(element, name));
        }
    }
    disconnectAllTargets() {
        for (const name of this.targetsByName.keys) {
            for (const element of this.targetsByName.getValuesForKey(name)) {
                this.disconnectTarget(element, name);
            }
        }
    }
    get attributeName() {
        return `data-${this.context.identifier}-target`;
    }
    get element() {
        return this.context.element;
    }
    get scope() {
        return this.context.scope;
    }
}

function readInheritableStaticArrayValues(constructor, propertyName) {
    const ancestors = getAncestorsForConstructor(constructor);
    return Array.from(ancestors.reduce((values, constructor) => {
        getOwnStaticArrayValues(constructor, propertyName).forEach((name) => values.add(name));
        return values;
    }, new Set()));
}
function readInheritableStaticObjectPairs(constructor, propertyName) {
    const ancestors = getAncestorsForConstructor(constructor);
    return ancestors.reduce((pairs, constructor) => {
        pairs.push(...getOwnStaticObjectPairs(constructor, propertyName));
        return pairs;
    }, []);
}
function getAncestorsForConstructor(constructor) {
    const ancestors = [];
    while (constructor) {
        ancestors.push(constructor);
        constructor = Object.getPrototypeOf(constructor);
    }
    return ancestors.reverse();
}
function getOwnStaticArrayValues(constructor, propertyName) {
    const definition = constructor[propertyName];
    return Array.isArray(definition) ? definition : [];
}
function getOwnStaticObjectPairs(constructor, propertyName) {
    const definition = constructor[propertyName];
    return definition ? Object.keys(definition).map((key) => [key, definition[key]]) : [];
}

class OutletObserver {
    constructor(context, delegate) {
        this.started = false;
        this.context = context;
        this.delegate = delegate;
        this.outletsByName = new Multimap();
        this.outletElementsByName = new Multimap();
        this.selectorObserverMap = new Map();
        this.attributeObserverMap = new Map();
    }
    start() {
        if (!this.started) {
            this.outletDefinitions.forEach((outletName) => {
                this.setupSelectorObserverForOutlet(outletName);
                this.setupAttributeObserverForOutlet(outletName);
            });
            this.started = true;
            this.dependentContexts.forEach((context) => context.refresh());
        }
    }
    refresh() {
        this.selectorObserverMap.forEach((observer) => observer.refresh());
        this.attributeObserverMap.forEach((observer) => observer.refresh());
    }
    stop() {
        if (this.started) {
            this.started = false;
            this.disconnectAllOutlets();
            this.stopSelectorObservers();
            this.stopAttributeObservers();
        }
    }
    stopSelectorObservers() {
        if (this.selectorObserverMap.size > 0) {
            this.selectorObserverMap.forEach((observer) => observer.stop());
            this.selectorObserverMap.clear();
        }
    }
    stopAttributeObservers() {
        if (this.attributeObserverMap.size > 0) {
            this.attributeObserverMap.forEach((observer) => observer.stop());
            this.attributeObserverMap.clear();
        }
    }
    selectorMatched(element, _selector, { outletName }) {
        const outlet = this.getOutlet(element, outletName);
        if (outlet) {
            this.connectOutlet(outlet, element, outletName);
        }
    }
    selectorUnmatched(element, _selector, { outletName }) {
        const outlet = this.getOutletFromMap(element, outletName);
        if (outlet) {
            this.disconnectOutlet(outlet, element, outletName);
        }
    }
    selectorMatchElement(element, { outletName }) {
        const selector = this.selector(outletName);
        const hasOutlet = this.hasOutlet(element, outletName);
        const hasOutletController = element.matches(`[${this.schema.controllerAttribute}~=${outletName}]`);
        if (selector) {
            return hasOutlet && hasOutletController && element.matches(selector);
        }
        else {
            return false;
        }
    }
    elementMatchedAttribute(_element, attributeName) {
        const outletName = this.getOutletNameFromOutletAttributeName(attributeName);
        if (outletName) {
            this.updateSelectorObserverForOutlet(outletName);
        }
    }
    elementAttributeValueChanged(_element, attributeName) {
        const outletName = this.getOutletNameFromOutletAttributeName(attributeName);
        if (outletName) {
            this.updateSelectorObserverForOutlet(outletName);
        }
    }
    elementUnmatchedAttribute(_element, attributeName) {
        const outletName = this.getOutletNameFromOutletAttributeName(attributeName);
        if (outletName) {
            this.updateSelectorObserverForOutlet(outletName);
        }
    }
    connectOutlet(outlet, element, outletName) {
        var _a;
        if (!this.outletElementsByName.has(outletName, element)) {
            this.outletsByName.add(outletName, outlet);
            this.outletElementsByName.add(outletName, element);
            (_a = this.selectorObserverMap.get(outletName)) === null || _a === void 0 ? void 0 : _a.pause(() => this.delegate.outletConnected(outlet, element, outletName));
        }
    }
    disconnectOutlet(outlet, element, outletName) {
        var _a;
        if (this.outletElementsByName.has(outletName, element)) {
            this.outletsByName.delete(outletName, outlet);
            this.outletElementsByName.delete(outletName, element);
            (_a = this.selectorObserverMap
                .get(outletName)) === null || _a === void 0 ? void 0 : _a.pause(() => this.delegate.outletDisconnected(outlet, element, outletName));
        }
    }
    disconnectAllOutlets() {
        for (const outletName of this.outletElementsByName.keys) {
            for (const element of this.outletElementsByName.getValuesForKey(outletName)) {
                for (const outlet of this.outletsByName.getValuesForKey(outletName)) {
                    this.disconnectOutlet(outlet, element, outletName);
                }
            }
        }
    }
    updateSelectorObserverForOutlet(outletName) {
        const observer = this.selectorObserverMap.get(outletName);
        if (observer) {
            observer.selector = this.selector(outletName);
        }
    }
    setupSelectorObserverForOutlet(outletName) {
        const selector = this.selector(outletName);
        const selectorObserver = new SelectorObserver(document.body, selector, this, { outletName });
        this.selectorObserverMap.set(outletName, selectorObserver);
        selectorObserver.start();
    }
    setupAttributeObserverForOutlet(outletName) {
        const attributeName = this.attributeNameForOutletName(outletName);
        const attributeObserver = new AttributeObserver(this.scope.element, attributeName, this);
        this.attributeObserverMap.set(outletName, attributeObserver);
        attributeObserver.start();
    }
    selector(outletName) {
        return this.scope.outlets.getSelectorForOutletName(outletName);
    }
    attributeNameForOutletName(outletName) {
        return this.scope.schema.outletAttributeForScope(this.identifier, outletName);
    }
    getOutletNameFromOutletAttributeName(attributeName) {
        return this.outletDefinitions.find((outletName) => this.attributeNameForOutletName(outletName) === attributeName);
    }
    get outletDependencies() {
        const dependencies = new Multimap();
        this.router.modules.forEach((module) => {
            const constructor = module.definition.controllerConstructor;
            const outlets = readInheritableStaticArrayValues(constructor, "outlets");
            outlets.forEach((outlet) => dependencies.add(outlet, module.identifier));
        });
        return dependencies;
    }
    get outletDefinitions() {
        return this.outletDependencies.getKeysForValue(this.identifier);
    }
    get dependentControllerIdentifiers() {
        return this.outletDependencies.getValuesForKey(this.identifier);
    }
    get dependentContexts() {
        const identifiers = this.dependentControllerIdentifiers;
        return this.router.contexts.filter((context) => identifiers.includes(context.identifier));
    }
    hasOutlet(element, outletName) {
        return !!this.getOutlet(element, outletName) || !!this.getOutletFromMap(element, outletName);
    }
    getOutlet(element, outletName) {
        return this.application.getControllerForElementAndIdentifier(element, outletName);
    }
    getOutletFromMap(element, outletName) {
        return this.outletsByName.getValuesForKey(outletName).find((outlet) => outlet.element === element);
    }
    get scope() {
        return this.context.scope;
    }
    get schema() {
        return this.context.schema;
    }
    get identifier() {
        return this.context.identifier;
    }
    get application() {
        return this.context.application;
    }
    get router() {
        return this.application.router;
    }
}

class Context {
    constructor(module, scope) {
        this.logDebugActivity = (functionName, detail = {}) => {
            const { identifier, controller, element } = this;
            detail = Object.assign({ identifier, controller, element }, detail);
            this.application.logDebugActivity(this.identifier, functionName, detail);
        };
        this.module = module;
        this.scope = scope;
        this.controller = new module.controllerConstructor(this);
        this.bindingObserver = new BindingObserver(this, this.dispatcher);
        this.valueObserver = new ValueObserver(this, this.controller);
        this.targetObserver = new TargetObserver(this, this);
        this.outletObserver = new OutletObserver(this, this);
        try {
            this.controller.initialize();
            this.logDebugActivity("initialize");
        }
        catch (error) {
            this.handleError(error, "initializing controller");
        }
    }
    connect() {
        this.bindingObserver.start();
        this.valueObserver.start();
        this.targetObserver.start();
        this.outletObserver.start();
        try {
            this.controller.connect();
            this.logDebugActivity("connect");
        }
        catch (error) {
            this.handleError(error, "connecting controller");
        }
    }
    refresh() {
        this.outletObserver.refresh();
    }
    disconnect() {
        try {
            this.controller.disconnect();
            this.logDebugActivity("disconnect");
        }
        catch (error) {
            this.handleError(error, "disconnecting controller");
        }
        this.outletObserver.stop();
        this.targetObserver.stop();
        this.valueObserver.stop();
        this.bindingObserver.stop();
    }
    get application() {
        return this.module.application;
    }
    get identifier() {
        return this.module.identifier;
    }
    get schema() {
        return this.application.schema;
    }
    get dispatcher() {
        return this.application.dispatcher;
    }
    get element() {
        return this.scope.element;
    }
    get parentElement() {
        return this.element.parentElement;
    }
    handleError(error, message, detail = {}) {
        const { identifier, controller, element } = this;
        detail = Object.assign({ identifier, controller, element }, detail);
        this.application.handleError(error, `Error ${message}`, detail);
    }
    targetConnected(element, name) {
        this.invokeControllerMethod(`${name}TargetConnected`, element);
    }
    targetDisconnected(element, name) {
        this.invokeControllerMethod(`${name}TargetDisconnected`, element);
    }
    outletConnected(outlet, element, name) {
        this.invokeControllerMethod(`${namespaceCamelize(name)}OutletConnected`, outlet, element);
    }
    outletDisconnected(outlet, element, name) {
        this.invokeControllerMethod(`${namespaceCamelize(name)}OutletDisconnected`, outlet, element);
    }
    invokeControllerMethod(methodName, ...args) {
        const controller = this.controller;
        if (typeof controller[methodName] == "function") {
            controller[methodName](...args);
        }
    }
}

function bless(constructor) {
    return shadow(constructor, getBlessedProperties(constructor));
}
function shadow(constructor, properties) {
    const shadowConstructor = extend(constructor);
    const shadowProperties = getShadowProperties(constructor.prototype, properties);
    Object.defineProperties(shadowConstructor.prototype, shadowProperties);
    return shadowConstructor;
}
function getBlessedProperties(constructor) {
    const blessings = readInheritableStaticArrayValues(constructor, "blessings");
    return blessings.reduce((blessedProperties, blessing) => {
        const properties = blessing(constructor);
        for (const key in properties) {
            const descriptor = blessedProperties[key] || {};
            blessedProperties[key] = Object.assign(descriptor, properties[key]);
        }
        return blessedProperties;
    }, {});
}
function getShadowProperties(prototype, properties) {
    return getOwnKeys(properties).reduce((shadowProperties, key) => {
        const descriptor = getShadowedDescriptor(prototype, properties, key);
        if (descriptor) {
            Object.assign(shadowProperties, { [key]: descriptor });
        }
        return shadowProperties;
    }, {});
}
function getShadowedDescriptor(prototype, properties, key) {
    const shadowingDescriptor = Object.getOwnPropertyDescriptor(prototype, key);
    const shadowedByValue = shadowingDescriptor && "value" in shadowingDescriptor;
    if (!shadowedByValue) {
        const descriptor = Object.getOwnPropertyDescriptor(properties, key).value;
        if (shadowingDescriptor) {
            descriptor.get = shadowingDescriptor.get || descriptor.get;
            descriptor.set = shadowingDescriptor.set || descriptor.set;
        }
        return descriptor;
    }
}
const getOwnKeys = (() => {
    if (typeof Object.getOwnPropertySymbols == "function") {
        return (object) => [...Object.getOwnPropertyNames(object), ...Object.getOwnPropertySymbols(object)];
    }
    else {
        return Object.getOwnPropertyNames;
    }
})();
const extend = (() => {
    function extendWithReflect(constructor) {
        function extended() {
            return Reflect.construct(constructor, arguments, new.target);
        }
        extended.prototype = Object.create(constructor.prototype, {
            constructor: { value: extended },
        });
        Reflect.setPrototypeOf(extended, constructor);
        return extended;
    }
    function testReflectExtension() {
        const a = function () {
            this.a.call(this);
        };
        const b = extendWithReflect(a);
        b.prototype.a = function () { };
        return new b();
    }
    try {
        testReflectExtension();
        return extendWithReflect;
    }
    catch (error) {
        return (constructor) => class extended extends constructor {
        };
    }
})();

function blessDefinition(definition) {
    return {
        identifier: definition.identifier,
        controllerConstructor: bless(definition.controllerConstructor),
    };
}

class Module {
    constructor(application, definition) {
        this.application = application;
        this.definition = blessDefinition(definition);
        this.contextsByScope = new WeakMap();
        this.connectedContexts = new Set();
    }
    get identifier() {
        return this.definition.identifier;
    }
    get controllerConstructor() {
        return this.definition.controllerConstructor;
    }
    get contexts() {
        return Array.from(this.connectedContexts);
    }
    connectContextForScope(scope) {
        const context = this.fetchContextForScope(scope);
        this.connectedContexts.add(context);
        context.connect();
    }
    disconnectContextForScope(scope) {
        const context = this.contextsByScope.get(scope);
        if (context) {
            this.connectedContexts.delete(context);
            context.disconnect();
        }
    }
    fetchContextForScope(scope) {
        let context = this.contextsByScope.get(scope);
        if (!context) {
            context = new Context(this, scope);
            this.contextsByScope.set(scope, context);
        }
        return context;
    }
}

class ClassMap {
    constructor(scope) {
        this.scope = scope;
    }
    has(name) {
        return this.data.has(this.getDataKey(name));
    }
    get(name) {
        return this.getAll(name)[0];
    }
    getAll(name) {
        const tokenString = this.data.get(this.getDataKey(name)) || "";
        return tokenize(tokenString);
    }
    getAttributeName(name) {
        return this.data.getAttributeNameForKey(this.getDataKey(name));
    }
    getDataKey(name) {
        return `${name}-class`;
    }
    get data() {
        return this.scope.data;
    }
}

class DataMap {
    constructor(scope) {
        this.scope = scope;
    }
    get element() {
        return this.scope.element;
    }
    get identifier() {
        return this.scope.identifier;
    }
    get(key) {
        const name = this.getAttributeNameForKey(key);
        return this.element.getAttribute(name);
    }
    set(key, value) {
        const name = this.getAttributeNameForKey(key);
        this.element.setAttribute(name, value);
        return this.get(key);
    }
    has(key) {
        const name = this.getAttributeNameForKey(key);
        return this.element.hasAttribute(name);
    }
    delete(key) {
        if (this.has(key)) {
            const name = this.getAttributeNameForKey(key);
            this.element.removeAttribute(name);
            return true;
        }
        else {
            return false;
        }
    }
    getAttributeNameForKey(key) {
        return `data-${this.identifier}-${dasherize(key)}`;
    }
}

class Guide {
    constructor(logger) {
        this.warnedKeysByObject = new WeakMap();
        this.logger = logger;
    }
    warn(object, key, message) {
        let warnedKeys = this.warnedKeysByObject.get(object);
        if (!warnedKeys) {
            warnedKeys = new Set();
            this.warnedKeysByObject.set(object, warnedKeys);
        }
        if (!warnedKeys.has(key)) {
            warnedKeys.add(key);
            this.logger.warn(message, object);
        }
    }
}

function attributeValueContainsToken(attributeName, token) {
    return `[${attributeName}~="${token}"]`;
}

class TargetSet {
    constructor(scope) {
        this.scope = scope;
    }
    get element() {
        return this.scope.element;
    }
    get identifier() {
        return this.scope.identifier;
    }
    get schema() {
        return this.scope.schema;
    }
    has(targetName) {
        return this.find(targetName) != null;
    }
    find(...targetNames) {
        return targetNames.reduce((target, targetName) => target || this.findTarget(targetName) || this.findLegacyTarget(targetName), undefined);
    }
    findAll(...targetNames) {
        return targetNames.reduce((targets, targetName) => [
            ...targets,
            ...this.findAllTargets(targetName),
            ...this.findAllLegacyTargets(targetName),
        ], []);
    }
    findTarget(targetName) {
        const selector = this.getSelectorForTargetName(targetName);
        return this.scope.findElement(selector);
    }
    findAllTargets(targetName) {
        const selector = this.getSelectorForTargetName(targetName);
        return this.scope.findAllElements(selector);
    }
    getSelectorForTargetName(targetName) {
        const attributeName = this.schema.targetAttributeForScope(this.identifier);
        return attributeValueContainsToken(attributeName, targetName);
    }
    findLegacyTarget(targetName) {
        const selector = this.getLegacySelectorForTargetName(targetName);
        return this.deprecate(this.scope.findElement(selector), targetName);
    }
    findAllLegacyTargets(targetName) {
        const selector = this.getLegacySelectorForTargetName(targetName);
        return this.scope.findAllElements(selector).map((element) => this.deprecate(element, targetName));
    }
    getLegacySelectorForTargetName(targetName) {
        const targetDescriptor = `${this.identifier}.${targetName}`;
        return attributeValueContainsToken(this.schema.targetAttribute, targetDescriptor);
    }
    deprecate(element, targetName) {
        if (element) {
            const { identifier } = this;
            const attributeName = this.schema.targetAttribute;
            const revisedAttributeName = this.schema.targetAttributeForScope(identifier);
            this.guide.warn(element, `target:${targetName}`, `Please replace ${attributeName}="${identifier}.${targetName}" with ${revisedAttributeName}="${targetName}". ` +
                `The ${attributeName} attribute is deprecated and will be removed in a future version of Stimulus.`);
        }
        return element;
    }
    get guide() {
        return this.scope.guide;
    }
}

class OutletSet {
    constructor(scope, controllerElement) {
        this.scope = scope;
        this.controllerElement = controllerElement;
    }
    get element() {
        return this.scope.element;
    }
    get identifier() {
        return this.scope.identifier;
    }
    get schema() {
        return this.scope.schema;
    }
    has(outletName) {
        return this.find(outletName) != null;
    }
    find(...outletNames) {
        return outletNames.reduce((outlet, outletName) => outlet || this.findOutlet(outletName), undefined);
    }
    findAll(...outletNames) {
        return outletNames.reduce((outlets, outletName) => [...outlets, ...this.findAllOutlets(outletName)], []);
    }
    getSelectorForOutletName(outletName) {
        const attributeName = this.schema.outletAttributeForScope(this.identifier, outletName);
        return this.controllerElement.getAttribute(attributeName);
    }
    findOutlet(outletName) {
        const selector = this.getSelectorForOutletName(outletName);
        if (selector)
            return this.findElement(selector, outletName);
    }
    findAllOutlets(outletName) {
        const selector = this.getSelectorForOutletName(outletName);
        return selector ? this.findAllElements(selector, outletName) : [];
    }
    findElement(selector, outletName) {
        const elements = this.scope.queryElements(selector);
        return elements.filter((element) => this.matchesElement(element, selector, outletName))[0];
    }
    findAllElements(selector, outletName) {
        const elements = this.scope.queryElements(selector);
        return elements.filter((element) => this.matchesElement(element, selector, outletName));
    }
    matchesElement(element, selector, outletName) {
        const controllerAttribute = element.getAttribute(this.scope.schema.controllerAttribute) || "";
        return element.matches(selector) && controllerAttribute.split(" ").includes(outletName);
    }
}

class Scope {
    constructor(schema, element, identifier, logger) {
        this.targets = new TargetSet(this);
        this.classes = new ClassMap(this);
        this.data = new DataMap(this);
        this.containsElement = (element) => {
            return element.closest(this.controllerSelector) === this.element;
        };
        this.schema = schema;
        this.element = element;
        this.identifier = identifier;
        this.guide = new Guide(logger);
        this.outlets = new OutletSet(this.documentScope, element);
    }
    findElement(selector) {
        return this.element.matches(selector) ? this.element : this.queryElements(selector).find(this.containsElement);
    }
    findAllElements(selector) {
        return [
            ...(this.element.matches(selector) ? [this.element] : []),
            ...this.queryElements(selector).filter(this.containsElement),
        ];
    }
    queryElements(selector) {
        return Array.from(this.element.querySelectorAll(selector));
    }
    get controllerSelector() {
        return attributeValueContainsToken(this.schema.controllerAttribute, this.identifier);
    }
    get isDocumentScope() {
        return this.element === document.documentElement;
    }
    get documentScope() {
        return this.isDocumentScope
            ? this
            : new Scope(this.schema, document.documentElement, this.identifier, this.guide.logger);
    }
}

class ScopeObserver {
    constructor(element, schema, delegate) {
        this.element = element;
        this.schema = schema;
        this.delegate = delegate;
        this.valueListObserver = new ValueListObserver(this.element, this.controllerAttribute, this);
        this.scopesByIdentifierByElement = new WeakMap();
        this.scopeReferenceCounts = new WeakMap();
    }
    start() {
        this.valueListObserver.start();
    }
    stop() {
        this.valueListObserver.stop();
    }
    get controllerAttribute() {
        return this.schema.controllerAttribute;
    }
    parseValueForToken(token) {
        const { element, content: identifier } = token;
        return this.parseValueForElementAndIdentifier(element, identifier);
    }
    parseValueForElementAndIdentifier(element, identifier) {
        const scopesByIdentifier = this.fetchScopesByIdentifierForElement(element);
        let scope = scopesByIdentifier.get(identifier);
        if (!scope) {
            scope = this.delegate.createScopeForElementAndIdentifier(element, identifier);
            scopesByIdentifier.set(identifier, scope);
        }
        return scope;
    }
    elementMatchedValue(element, value) {
        const referenceCount = (this.scopeReferenceCounts.get(value) || 0) + 1;
        this.scopeReferenceCounts.set(value, referenceCount);
        if (referenceCount == 1) {
            this.delegate.scopeConnected(value);
        }
    }
    elementUnmatchedValue(element, value) {
        const referenceCount = this.scopeReferenceCounts.get(value);
        if (referenceCount) {
            this.scopeReferenceCounts.set(value, referenceCount - 1);
            if (referenceCount == 1) {
                this.delegate.scopeDisconnected(value);
            }
        }
    }
    fetchScopesByIdentifierForElement(element) {
        let scopesByIdentifier = this.scopesByIdentifierByElement.get(element);
        if (!scopesByIdentifier) {
            scopesByIdentifier = new Map();
            this.scopesByIdentifierByElement.set(element, scopesByIdentifier);
        }
        return scopesByIdentifier;
    }
}

class Router {
    constructor(application) {
        this.application = application;
        this.scopeObserver = new ScopeObserver(this.element, this.schema, this);
        this.scopesByIdentifier = new Multimap();
        this.modulesByIdentifier = new Map();
    }
    get element() {
        return this.application.element;
    }
    get schema() {
        return this.application.schema;
    }
    get logger() {
        return this.application.logger;
    }
    get controllerAttribute() {
        return this.schema.controllerAttribute;
    }
    get modules() {
        return Array.from(this.modulesByIdentifier.values());
    }
    get contexts() {
        return this.modules.reduce((contexts, module) => contexts.concat(module.contexts), []);
    }
    start() {
        this.scopeObserver.start();
    }
    stop() {
        this.scopeObserver.stop();
    }
    loadDefinition(definition) {
        this.unloadIdentifier(definition.identifier);
        const module = new Module(this.application, definition);
        this.connectModule(module);
        const afterLoad = definition.controllerConstructor.afterLoad;
        if (afterLoad) {
            afterLoad.call(definition.controllerConstructor, definition.identifier, this.application);
        }
    }
    unloadIdentifier(identifier) {
        const module = this.modulesByIdentifier.get(identifier);
        if (module) {
            this.disconnectModule(module);
        }
    }
    getContextForElementAndIdentifier(element, identifier) {
        const module = this.modulesByIdentifier.get(identifier);
        if (module) {
            return module.contexts.find((context) => context.element == element);
        }
    }
    proposeToConnectScopeForElementAndIdentifier(element, identifier) {
        const scope = this.scopeObserver.parseValueForElementAndIdentifier(element, identifier);
        if (scope) {
            this.scopeObserver.elementMatchedValue(scope.element, scope);
        }
        else {
            console.error(`Couldn't find or create scope for identifier: "${identifier}" and element:`, element);
        }
    }
    handleError(error, message, detail) {
        this.application.handleError(error, message, detail);
    }
    createScopeForElementAndIdentifier(element, identifier) {
        return new Scope(this.schema, element, identifier, this.logger);
    }
    scopeConnected(scope) {
        this.scopesByIdentifier.add(scope.identifier, scope);
        const module = this.modulesByIdentifier.get(scope.identifier);
        if (module) {
            module.connectContextForScope(scope);
        }
    }
    scopeDisconnected(scope) {
        this.scopesByIdentifier.delete(scope.identifier, scope);
        const module = this.modulesByIdentifier.get(scope.identifier);
        if (module) {
            module.disconnectContextForScope(scope);
        }
    }
    connectModule(module) {
        this.modulesByIdentifier.set(module.identifier, module);
        const scopes = this.scopesByIdentifier.getValuesForKey(module.identifier);
        scopes.forEach((scope) => module.connectContextForScope(scope));
    }
    disconnectModule(module) {
        this.modulesByIdentifier.delete(module.identifier);
        const scopes = this.scopesByIdentifier.getValuesForKey(module.identifier);
        scopes.forEach((scope) => module.disconnectContextForScope(scope));
    }
}

const defaultSchema = {
    controllerAttribute: "data-controller",
    actionAttribute: "data-action",
    targetAttribute: "data-target",
    targetAttributeForScope: (identifier) => `data-${identifier}-target`,
    outletAttributeForScope: (identifier, outlet) => `data-${identifier}-${outlet}-outlet`,
    keyMappings: Object.assign(Object.assign({ enter: "Enter", tab: "Tab", esc: "Escape", space: " ", up: "ArrowUp", down: "ArrowDown", left: "ArrowLeft", right: "ArrowRight", home: "Home", end: "End", page_up: "PageUp", page_down: "PageDown" }, objectFromEntries("abcdefghijklmnopqrstuvwxyz".split("").map((c) => [c, c]))), objectFromEntries("0123456789".split("").map((n) => [n, n]))),
};
function objectFromEntries(array) {
    return array.reduce((memo, [k, v]) => (Object.assign(Object.assign({}, memo), { [k]: v })), {});
}

class Application {
    constructor(element = document.documentElement, schema = defaultSchema) {
        this.logger = console;
        this.debug = false;
        this.logDebugActivity = (identifier, functionName, detail = {}) => {
            if (this.debug) {
                this.logFormattedMessage(identifier, functionName, detail);
            }
        };
        this.element = element;
        this.schema = schema;
        this.dispatcher = new Dispatcher(this);
        this.router = new Router(this);
        this.actionDescriptorFilters = Object.assign({}, defaultActionDescriptorFilters);
    }
    static start(element, schema) {
        const application = new this(element, schema);
        application.start();
        return application;
    }
    async start() {
        await domReady();
        this.logDebugActivity("application", "starting");
        this.dispatcher.start();
        this.router.start();
        this.logDebugActivity("application", "start");
    }
    stop() {
        this.logDebugActivity("application", "stopping");
        this.dispatcher.stop();
        this.router.stop();
        this.logDebugActivity("application", "stop");
    }
    register(identifier, controllerConstructor) {
        this.load({ identifier, controllerConstructor });
    }
    registerActionOption(name, filter) {
        this.actionDescriptorFilters[name] = filter;
    }
    load(head, ...rest) {
        const definitions = Array.isArray(head) ? head : [head, ...rest];
        definitions.forEach((definition) => {
            if (definition.controllerConstructor.shouldLoad) {
                this.router.loadDefinition(definition);
            }
        });
    }
    unload(head, ...rest) {
        const identifiers = Array.isArray(head) ? head : [head, ...rest];
        identifiers.forEach((identifier) => this.router.unloadIdentifier(identifier));
    }
    get controllers() {
        return this.router.contexts.map((context) => context.controller);
    }
    getControllerForElementAndIdentifier(element, identifier) {
        const context = this.router.getContextForElementAndIdentifier(element, identifier);
        return context ? context.controller : null;
    }
    handleError(error, message, detail) {
        var _a;
        this.logger.error(`%s\n\n%o\n\n%o`, message, error, detail);
        (_a = window.onerror) === null || _a === void 0 ? void 0 : _a.call(window, message, "", 0, 0, error);
    }
    logFormattedMessage(identifier, functionName, detail = {}) {
        detail = Object.assign({ application: this }, detail);
        this.logger.groupCollapsed(`${identifier} #${functionName}`);
        this.logger.log("details:", Object.assign({}, detail));
        this.logger.groupEnd();
    }
}
function domReady() {
    return new Promise((resolve) => {
        if (document.readyState == "loading") {
            document.addEventListener("DOMContentLoaded", () => resolve());
        }
        else {
            resolve();
        }
    });
}

function ClassPropertiesBlessing(constructor) {
    const classes = readInheritableStaticArrayValues(constructor, "classes");
    return classes.reduce((properties, classDefinition) => {
        return Object.assign(properties, propertiesForClassDefinition(classDefinition));
    }, {});
}
function propertiesForClassDefinition(key) {
    return {
        [`${key}Class`]: {
            get() {
                const { classes } = this;
                if (classes.has(key)) {
                    return classes.get(key);
                }
                else {
                    const attribute = classes.getAttributeName(key);
                    throw new Error(`Missing attribute "${attribute}"`);
                }
            },
        },
        [`${key}Classes`]: {
            get() {
                return this.classes.getAll(key);
            },
        },
        [`has${capitalize(key)}Class`]: {
            get() {
                return this.classes.has(key);
            },
        },
    };
}

function OutletPropertiesBlessing(constructor) {
    const outlets = readInheritableStaticArrayValues(constructor, "outlets");
    return outlets.reduce((properties, outletDefinition) => {
        return Object.assign(properties, propertiesForOutletDefinition(outletDefinition));
    }, {});
}
function getOutletController(controller, element, identifier) {
    return controller.application.getControllerForElementAndIdentifier(element, identifier);
}
function getControllerAndEnsureConnectedScope(controller, element, outletName) {
    let outletController = getOutletController(controller, element, outletName);
    if (outletController)
        return outletController;
    controller.application.router.proposeToConnectScopeForElementAndIdentifier(element, outletName);
    outletController = getOutletController(controller, element, outletName);
    if (outletController)
        return outletController;
}
function propertiesForOutletDefinition(name) {
    const camelizedName = namespaceCamelize(name);
    return {
        [`${camelizedName}Outlet`]: {
            get() {
                const outletElement = this.outlets.find(name);
                const selector = this.outlets.getSelectorForOutletName(name);
                if (outletElement) {
                    const outletController = getControllerAndEnsureConnectedScope(this, outletElement, name);
                    if (outletController)
                        return outletController;
                    throw new Error(`The provided outlet element is missing an outlet controller "${name}" instance for host controller "${this.identifier}"`);
                }
                throw new Error(`Missing outlet element "${name}" for host controller "${this.identifier}". Stimulus couldn't find a matching outlet element using selector "${selector}".`);
            },
        },
        [`${camelizedName}Outlets`]: {
            get() {
                const outlets = this.outlets.findAll(name);
                if (outlets.length > 0) {
                    return outlets
                        .map((outletElement) => {
                        const outletController = getControllerAndEnsureConnectedScope(this, outletElement, name);
                        if (outletController)
                            return outletController;
                        console.warn(`The provided outlet element is missing an outlet controller "${name}" instance for host controller "${this.identifier}"`, outletElement);
                    })
                        .filter((controller) => controller);
                }
                return [];
            },
        },
        [`${camelizedName}OutletElement`]: {
            get() {
                const outletElement = this.outlets.find(name);
                const selector = this.outlets.getSelectorForOutletName(name);
                if (outletElement) {
                    return outletElement;
                }
                else {
                    throw new Error(`Missing outlet element "${name}" for host controller "${this.identifier}". Stimulus couldn't find a matching outlet element using selector "${selector}".`);
                }
            },
        },
        [`${camelizedName}OutletElements`]: {
            get() {
                return this.outlets.findAll(name);
            },
        },
        [`has${capitalize(camelizedName)}Outlet`]: {
            get() {
                return this.outlets.has(name);
            },
        },
    };
}

function TargetPropertiesBlessing(constructor) {
    const targets = readInheritableStaticArrayValues(constructor, "targets");
    return targets.reduce((properties, targetDefinition) => {
        return Object.assign(properties, propertiesForTargetDefinition(targetDefinition));
    }, {});
}
function propertiesForTargetDefinition(name) {
    return {
        [`${name}Target`]: {
            get() {
                const target = this.targets.find(name);
                if (target) {
                    return target;
                }
                else {
                    throw new Error(`Missing target element "${name}" for "${this.identifier}" controller`);
                }
            },
        },
        [`${name}Targets`]: {
            get() {
                return this.targets.findAll(name);
            },
        },
        [`has${capitalize(name)}Target`]: {
            get() {
                return this.targets.has(name);
            },
        },
    };
}

function ValuePropertiesBlessing(constructor) {
    const valueDefinitionPairs = readInheritableStaticObjectPairs(constructor, "values");
    const propertyDescriptorMap = {
        valueDescriptorMap: {
            get() {
                return valueDefinitionPairs.reduce((result, valueDefinitionPair) => {
                    const valueDescriptor = parseValueDefinitionPair(valueDefinitionPair, this.identifier);
                    const attributeName = this.data.getAttributeNameForKey(valueDescriptor.key);
                    return Object.assign(result, { [attributeName]: valueDescriptor });
                }, {});
            },
        },
    };
    return valueDefinitionPairs.reduce((properties, valueDefinitionPair) => {
        return Object.assign(properties, propertiesForValueDefinitionPair(valueDefinitionPair));
    }, propertyDescriptorMap);
}
function propertiesForValueDefinitionPair(valueDefinitionPair, controller) {
    const definition = parseValueDefinitionPair(valueDefinitionPair, controller);
    const { key, name, reader: read, writer: write } = definition;
    return {
        [name]: {
            get() {
                const value = this.data.get(key);
                if (value !== null) {
                    return read(value);
                }
                else {
                    return definition.defaultValue;
                }
            },
            set(value) {
                if (value === undefined) {
                    this.data.delete(key);
                }
                else {
                    this.data.set(key, write(value));
                }
            },
        },
        [`has${capitalize(name)}`]: {
            get() {
                return this.data.has(key) || definition.hasCustomDefaultValue;
            },
        },
    };
}
function parseValueDefinitionPair([token, typeDefinition], controller) {
    return valueDescriptorForTokenAndTypeDefinition({
        controller,
        token,
        typeDefinition,
    });
}
function parseValueTypeConstant(constant) {
    switch (constant) {
        case Array:
            return "array";
        case Boolean:
            return "boolean";
        case Number:
            return "number";
        case Object:
            return "object";
        case String:
            return "string";
    }
}
function parseValueTypeDefault(defaultValue) {
    switch (typeof defaultValue) {
        case "boolean":
            return "boolean";
        case "number":
            return "number";
        case "string":
            return "string";
    }
    if (Array.isArray(defaultValue))
        return "array";
    if (Object.prototype.toString.call(defaultValue) === "[object Object]")
        return "object";
}
function parseValueTypeObject(payload) {
    const { controller, token, typeObject } = payload;
    const hasType = isSomething(typeObject.type);
    const hasDefault = isSomething(typeObject.default);
    const fullObject = hasType && hasDefault;
    const onlyType = hasType && !hasDefault;
    const onlyDefault = !hasType && hasDefault;
    const typeFromObject = parseValueTypeConstant(typeObject.type);
    const typeFromDefaultValue = parseValueTypeDefault(payload.typeObject.default);
    if (onlyType)
        return typeFromObject;
    if (onlyDefault)
        return typeFromDefaultValue;
    if (typeFromObject !== typeFromDefaultValue) {
        const propertyPath = controller ? `${controller}.${token}` : token;
        throw new Error(`The specified default value for the Stimulus Value "${propertyPath}" must match the defined type "${typeFromObject}". The provided default value of "${typeObject.default}" is of type "${typeFromDefaultValue}".`);
    }
    if (fullObject)
        return typeFromObject;
}
function parseValueTypeDefinition(payload) {
    const { controller, token, typeDefinition } = payload;
    const typeObject = { controller, token, typeObject: typeDefinition };
    const typeFromObject = parseValueTypeObject(typeObject);
    const typeFromDefaultValue = parseValueTypeDefault(typeDefinition);
    const typeFromConstant = parseValueTypeConstant(typeDefinition);
    const type = typeFromObject || typeFromDefaultValue || typeFromConstant;
    if (type)
        return type;
    const propertyPath = controller ? `${controller}.${typeDefinition}` : token;
    throw new Error(`Unknown value type "${propertyPath}" for "${token}" value`);
}
function defaultValueForDefinition(typeDefinition) {
    const constant = parseValueTypeConstant(typeDefinition);
    if (constant)
        return defaultValuesByType[constant];
    const hasDefault = hasProperty(typeDefinition, "default");
    const hasType = hasProperty(typeDefinition, "type");
    const typeObject = typeDefinition;
    if (hasDefault)
        return typeObject.default;
    if (hasType) {
        const { type } = typeObject;
        const constantFromType = parseValueTypeConstant(type);
        if (constantFromType)
            return defaultValuesByType[constantFromType];
    }
    return typeDefinition;
}
function valueDescriptorForTokenAndTypeDefinition(payload) {
    const { token, typeDefinition } = payload;
    const key = `${dasherize(token)}-value`;
    const type = parseValueTypeDefinition(payload);
    return {
        type,
        key,
        name: camelize(key),
        get defaultValue() {
            return defaultValueForDefinition(typeDefinition);
        },
        get hasCustomDefaultValue() {
            return parseValueTypeDefault(typeDefinition) !== undefined;
        },
        reader: readers[type],
        writer: writers[type] || writers.default,
    };
}
const defaultValuesByType = {
    get array() {
        return [];
    },
    boolean: false,
    number: 0,
    get object() {
        return {};
    },
    string: "",
};
const readers = {
    array(value) {
        const array = JSON.parse(value);
        if (!Array.isArray(array)) {
            throw new TypeError(`expected value of type "array" but instead got value "${value}" of type "${parseValueTypeDefault(array)}"`);
        }
        return array;
    },
    boolean(value) {
        return !(value == "0" || String(value).toLowerCase() == "false");
    },
    number(value) {
        return Number(value.replace(/_/g, ""));
    },
    object(value) {
        const object = JSON.parse(value);
        if (object === null || typeof object != "object" || Array.isArray(object)) {
            throw new TypeError(`expected value of type "object" but instead got value "${value}" of type "${parseValueTypeDefault(object)}"`);
        }
        return object;
    },
    string(value) {
        return value;
    },
};
const writers = {
    default: writeString,
    array: writeJSON,
    object: writeJSON,
};
function writeJSON(value) {
    return JSON.stringify(value);
}
function writeString(value) {
    return `${value}`;
}

class Controller {
    constructor(context) {
        this.context = context;
    }
    static get shouldLoad() {
        return true;
    }
    static afterLoad(_identifier, _application) {
        return;
    }
    get application() {
        return this.context.application;
    }
    get scope() {
        return this.context.scope;
    }
    get element() {
        return this.scope.element;
    }
    get identifier() {
        return this.scope.identifier;
    }
    get targets() {
        return this.scope.targets;
    }
    get outlets() {
        return this.scope.outlets;
    }
    get classes() {
        return this.scope.classes;
    }
    get data() {
        return this.scope.data;
    }
    initialize() {
    }
    connect() {
    }
    disconnect() {
    }
    dispatch(eventName, { target = this.element, detail = {}, prefix = this.identifier, bubbles = true, cancelable = true, } = {}) {
        const type = prefix ? `${prefix}:${eventName}` : eventName;
        const event = new CustomEvent(type, { detail, bubbles, cancelable });
        target.dispatchEvent(event);
        return event;
    }
}
Controller.blessings = [
    ClassPropertiesBlessing,
    TargetPropertiesBlessing,
    ValuePropertiesBlessing,
    OutletPropertiesBlessing,
];
Controller.targets = [];
Controller.outlets = [];
Controller.values = {};




/***/ }),

/***/ "./node_modules/@symfony/stimulus-bridge/dist/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@symfony/stimulus-bridge/dist/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startStimulusApp: () => (/* binding */ startStimulusApp)
/* harmony export */ });
/* harmony import */ var _hotwired_stimulus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @hotwired/stimulus */ "./node_modules/@hotwired/stimulus/dist/stimulus.js");
/* harmony import */ var _webpack_loader_symfony_stimulus_bridge_controllers_json__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./webpack/loader!@symfony/stimulus-bridge/controllers.json */ "./node_modules/@symfony/stimulus-bridge/dist/webpack/loader.js!./assets/controllers.json");



/*
Stimulus Webpack Helpers 1.0.0
Copyright © 2021 Basecamp, LLC
 */
function definitionsFromContext(context) {
    return context.keys()
        .map((key) => definitionForModuleWithContextAndKey(context, key))
        .filter((value) => value);
}
function definitionForModuleWithContextAndKey(context, key) {
    const identifier = identifierForContextKey(key);
    if (identifier) {
        return definitionForModuleAndIdentifier(context(key), identifier);
    }
}
function definitionForModuleAndIdentifier(module, identifier) {
    const controllerConstructor = module.default;
    if (typeof controllerConstructor == "function") {
        return { identifier, controllerConstructor };
    }
}
function identifierForContextKey(key) {
    const logicalName = (key.match(/^(?:\.\/)?(.+)(?:[_-]controller\..+?)$/) || [])[1];
    if (logicalName) {
        return logicalName.replace(/_/g, "-").replace(/\//g, "--");
    }
}

function startStimulusApp(context) {
    const application = _hotwired_stimulus__WEBPACK_IMPORTED_MODULE_0__.Application.start();
    if (true) {
        application.debug = true;
    }
    if (context) {
        application.load(definitionsFromContext(context));
    }
    for (const controllerName in _webpack_loader_symfony_stimulus_bridge_controllers_json__WEBPACK_IMPORTED_MODULE_1__["default"]) {
        if (!_webpack_loader_symfony_stimulus_bridge_controllers_json__WEBPACK_IMPORTED_MODULE_1__["default"].hasOwnProperty(controllerName)) {
            continue;
        }
        application.register(controllerName, _webpack_loader_symfony_stimulus_bridge_controllers_json__WEBPACK_IMPORTED_MODULE_1__["default"][controllerName]);
    }
    return application;
}




/***/ }),

/***/ "./node_modules/tom-select/dist/css/tom-select.default.css":
/*!*****************************************************************!*\
  !*** ./node_modules/tom-select/dist/css/tom-select.default.css ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/tom-select/dist/js/tom-select.complete.js":
/*!****************************************************************!*\
  !*** ./node_modules/tom-select/dist/js/tom-select.complete.js ***!
  \****************************************************************/
/***/ (function(module) {

/**
* Tom Select v2.3.1
* Licensed under the Apache License, Version 2.0 (the "License");
*/

(function (global, factory) {
	 true ? module.exports = factory() :
	0;
})(this, (function () { 'use strict';

	/**
	 * MicroEvent - to make any js object an event emitter
	 *
	 * - pure javascript - server compatible, browser compatible
	 * - dont rely on the browser doms
	 * - super simple - you get it immediatly, no mistery, no magic involved
	 *
	 * @author Jerome Etienne (https://github.com/jeromeetienne)
	 */

	/**
	 * Execute callback for each event in space separated list of event names
	 *
	 */
	function forEvents(events, callback) {
	  events.split(/\s+/).forEach(event => {
	    callback(event);
	  });
	}
	class MicroEvent {
	  constructor() {
	    this._events = void 0;
	    this._events = {};
	  }
	  on(events, fct) {
	    forEvents(events, event => {
	      const event_array = this._events[event] || [];
	      event_array.push(fct);
	      this._events[event] = event_array;
	    });
	  }
	  off(events, fct) {
	    var n = arguments.length;
	    if (n === 0) {
	      this._events = {};
	      return;
	    }
	    forEvents(events, event => {
	      if (n === 1) {
	        delete this._events[event];
	        return;
	      }
	      const event_array = this._events[event];
	      if (event_array === undefined) return;
	      event_array.splice(event_array.indexOf(fct), 1);
	      this._events[event] = event_array;
	    });
	  }
	  trigger(events, ...args) {
	    var self = this;
	    forEvents(events, event => {
	      const event_array = self._events[event];
	      if (event_array === undefined) return;
	      event_array.forEach(fct => {
	        fct.apply(self, args);
	      });
	    });
	  }
	}

	/**
	 * microplugin.js
	 * Copyright (c) 2013 Brian Reavis & contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 * @author Brian Reavis <brian@thirdroute.com>
	 */

	function MicroPlugin(Interface) {
	  Interface.plugins = {};
	  return class extends Interface {
	    constructor(...args) {
	      super(...args);
	      this.plugins = {
	        names: [],
	        settings: {},
	        requested: {},
	        loaded: {}
	      };
	    }
	    /**
	     * Registers a plugin.
	     *
	     * @param {function} fn
	     */
	    static define(name, fn) {
	      Interface.plugins[name] = {
	        'name': name,
	        'fn': fn
	      };
	    }

	    /**
	     * Initializes the listed plugins (with options).
	     * Acceptable formats:
	     *
	     * List (without options):
	     *   ['a', 'b', 'c']
	     *
	     * List (with options):
	     *   [{'name': 'a', options: {}}, {'name': 'b', options: {}}]
	     *
	     * Hash (with options):
	     *   {'a': { ... }, 'b': { ... }, 'c': { ... }}
	     *
	     * @param {array|object} plugins
	     */
	    initializePlugins(plugins) {
	      var key, name;
	      const self = this;
	      const queue = [];
	      if (Array.isArray(plugins)) {
	        plugins.forEach(plugin => {
	          if (typeof plugin === 'string') {
	            queue.push(plugin);
	          } else {
	            self.plugins.settings[plugin.name] = plugin.options;
	            queue.push(plugin.name);
	          }
	        });
	      } else if (plugins) {
	        for (key in plugins) {
	          if (plugins.hasOwnProperty(key)) {
	            self.plugins.settings[key] = plugins[key];
	            queue.push(key);
	          }
	        }
	      }
	      while (name = queue.shift()) {
	        self.require(name);
	      }
	    }
	    loadPlugin(name) {
	      var self = this;
	      var plugins = self.plugins;
	      var plugin = Interface.plugins[name];
	      if (!Interface.plugins.hasOwnProperty(name)) {
	        throw new Error('Unable to find "' + name + '" plugin');
	      }
	      plugins.requested[name] = true;
	      plugins.loaded[name] = plugin.fn.apply(self, [self.plugins.settings[name] || {}]);
	      plugins.names.push(name);
	    }

	    /**
	     * Initializes a plugin.
	     *
	     */
	    require(name) {
	      var self = this;
	      var plugins = self.plugins;
	      if (!self.plugins.loaded.hasOwnProperty(name)) {
	        if (plugins.requested[name]) {
	          throw new Error('Plugin has circular dependency ("' + name + '")');
	        }
	        self.loadPlugin(name);
	      }
	      return plugins.loaded[name];
	    }
	  };
	}

	/*! @orchidjs/unicode-variants | https://github.com/orchidjs/unicode-variants | Apache License (v2) */
	/**
	 * Convert array of strings to a regular expression
	 *	ex ['ab','a'] => (?:ab|a)
	 * 	ex ['a','b'] => [ab]
	 * @param {string[]} chars
	 * @return {string}
	 */
	const arrayToPattern = chars => {
	  chars = chars.filter(Boolean);

	  if (chars.length < 2) {
	    return chars[0] || '';
	  }

	  return maxValueLength(chars) == 1 ? '[' + chars.join('') + ']' : '(?:' + chars.join('|') + ')';
	};
	/**
	 * @param {string[]} array
	 * @return {string}
	 */

	const sequencePattern = array => {
	  if (!hasDuplicates(array)) {
	    return array.join('');
	  }

	  let pattern = '';
	  let prev_char_count = 0;

	  const prev_pattern = () => {
	    if (prev_char_count > 1) {
	      pattern += '{' + prev_char_count + '}';
	    }
	  };

	  array.forEach((char, i) => {
	    if (char === array[i - 1]) {
	      prev_char_count++;
	      return;
	    }

	    prev_pattern();
	    pattern += char;
	    prev_char_count = 1;
	  });
	  prev_pattern();
	  return pattern;
	};
	/**
	 * Convert array of strings to a regular expression
	 *	ex ['ab','a'] => (?:ab|a)
	 * 	ex ['a','b'] => [ab]
	 * @param {Set<string>} chars
	 * @return {string}
	 */

	const setToPattern = chars => {
	  let array = toArray(chars);
	  return arrayToPattern(array);
	};
	/**
	 *
	 * https://stackoverflow.com/questions/7376598/in-javascript-how-do-i-check-if-an-array-has-duplicate-values
	 * @param {any[]} array
	 */

	const hasDuplicates = array => {
	  return new Set(array).size !== array.length;
	};
	/**
	 * https://stackoverflow.com/questions/63006601/why-does-u-throw-an-invalid-escape-error
	 * @param {string} str
	 * @return {string}
	 */

	const escape_regex = str => {
	  return (str + '').replace(/([\$\(\)\*\+\.\?\[\]\^\{\|\}\\])/gu, '\\$1');
	};
	/**
	 * Return the max length of array values
	 * @param {string[]} array
	 *
	 */

	const maxValueLength = array => {
	  return array.reduce((longest, value) => Math.max(longest, unicodeLength(value)), 0);
	};
	/**
	 * @param {string} str
	 */

	const unicodeLength = str => {
	  return toArray(str).length;
	};
	/**
	 * @param {any} p
	 * @return {any[]}
	 */

	const toArray = p => Array.from(p);

	/*! @orchidjs/unicode-variants | https://github.com/orchidjs/unicode-variants | Apache License (v2) */
	/**
	 * Get all possible combinations of substrings that add up to the given string
	 * https://stackoverflow.com/questions/30169587/find-all-the-combination-of-substrings-that-add-up-to-the-given-string
	 * @param {string} input
	 * @return {string[][]}
	 */
	const allSubstrings = input => {
	  if (input.length === 1) return [[input]];
	  /** @type {string[][]} */

	  let result = [];
	  const start = input.substring(1);
	  const suba = allSubstrings(start);
	  suba.forEach(function (subresult) {
	    let tmp = subresult.slice(0);
	    tmp[0] = input.charAt(0) + tmp[0];
	    result.push(tmp);
	    tmp = subresult.slice(0);
	    tmp.unshift(input.charAt(0));
	    result.push(tmp);
	  });
	  return result;
	};

	/*! @orchidjs/unicode-variants | https://github.com/orchidjs/unicode-variants | Apache License (v2) */

	/**
	 * @typedef {{[key:string]:string}} TUnicodeMap
	 * @typedef {{[key:string]:Set<string>}} TUnicodeSets
	 * @typedef {[[number,number]]} TCodePoints
	 * @typedef {{folded:string,composed:string,code_point:number}} TCodePointObj
	 * @typedef {{start:number,end:number,length:number,substr:string}} TSequencePart
	 */
	/** @type {TCodePoints} */

	const code_points = [[0, 65535]];
	const accent_pat = '[\u0300-\u036F\u{b7}\u{2be}\u{2bc}]';
	/** @type {TUnicodeMap} */

	let unicode_map;
	/** @type {RegExp} */

	let multi_char_reg;
	const max_char_length = 3;
	/** @type {TUnicodeMap} */

	const latin_convert = {};
	/** @type {TUnicodeMap} */

	const latin_condensed = {
	  '/': '⁄∕',
	  '0': '߀',
	  "a": "ⱥɐɑ",
	  "aa": "ꜳ",
	  "ae": "æǽǣ",
	  "ao": "ꜵ",
	  "au": "ꜷ",
	  "av": "ꜹꜻ",
	  "ay": "ꜽ",
	  "b": "ƀɓƃ",
	  "c": "ꜿƈȼↄ",
	  "d": "đɗɖᴅƌꮷԁɦ",
	  "e": "ɛǝᴇɇ",
	  "f": "ꝼƒ",
	  "g": "ǥɠꞡᵹꝿɢ",
	  "h": "ħⱨⱶɥ",
	  "i": "ɨı",
	  "j": "ɉȷ",
	  "k": "ƙⱪꝁꝃꝅꞣ",
	  "l": "łƚɫⱡꝉꝇꞁɭ",
	  "m": "ɱɯϻ",
	  "n": "ꞥƞɲꞑᴎлԉ",
	  "o": "øǿɔɵꝋꝍᴑ",
	  "oe": "œ",
	  "oi": "ƣ",
	  "oo": "ꝏ",
	  "ou": "ȣ",
	  "p": "ƥᵽꝑꝓꝕρ",
	  "q": "ꝗꝙɋ",
	  "r": "ɍɽꝛꞧꞃ",
	  "s": "ßȿꞩꞅʂ",
	  "t": "ŧƭʈⱦꞇ",
	  "th": "þ",
	  "tz": "ꜩ",
	  "u": "ʉ",
	  "v": "ʋꝟʌ",
	  "vy": "ꝡ",
	  "w": "ⱳ",
	  "y": "ƴɏỿ",
	  "z": "ƶȥɀⱬꝣ",
	  "hv": "ƕ"
	};

	for (let latin in latin_condensed) {
	  let unicode = latin_condensed[latin] || '';

	  for (let i = 0; i < unicode.length; i++) {
	    let char = unicode.substring(i, i + 1);
	    latin_convert[char] = latin;
	  }
	}

	const convert_pat = new RegExp(Object.keys(latin_convert).join('|') + '|' + accent_pat, 'gu');
	/**
	 * Initialize the unicode_map from the give code point ranges
	 *
	 * @param {TCodePoints=} _code_points
	 */

	const initialize = _code_points => {
	  if (unicode_map !== undefined) return;
	  unicode_map = generateMap(_code_points || code_points);
	};
	/**
	 * Helper method for normalize a string
	 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/normalize
	 * @param {string} str
	 * @param {string} form
	 */

	const normalize = (str, form = 'NFKD') => str.normalize(form);
	/**
	 * Remove accents without reordering string
	 * calling str.normalize('NFKD') on \u{594}\u{595}\u{596} becomes \u{596}\u{594}\u{595}
	 * via https://github.com/krisk/Fuse/issues/133#issuecomment-318692703
	 * @param {string} str
	 * @return {string}
	 */

	const asciifold = str => {
	  return toArray(str).reduce(
	  /**
	   * @param {string} result
	   * @param {string} char
	   */
	  (result, char) => {
	    return result + _asciifold(char);
	  }, '');
	};
	/**
	 * @param {string} str
	 * @return {string}
	 */

	const _asciifold = str => {
	  str = normalize(str).toLowerCase().replace(convert_pat, (
	  /** @type {string} */
	  char) => {
	    return latin_convert[char] || '';
	  }); //return str;

	  return normalize(str, 'NFC');
	};
	/**
	 * Generate a list of unicode variants from the list of code points
	 * @param {TCodePoints} code_points
	 * @yield {TCodePointObj}
	 */

	function* generator(code_points) {
	  for (const [code_point_min, code_point_max] of code_points) {
	    for (let i = code_point_min; i <= code_point_max; i++) {
	      let composed = String.fromCharCode(i);
	      let folded = asciifold(composed);

	      if (folded == composed.toLowerCase()) {
	        continue;
	      } // skip when folded is a string longer than 3 characters long
	      // bc the resulting regex patterns will be long
	      // eg:
	      // folded صلى الله عليه وسلم length 18 code point 65018
	      // folded جل جلاله length 8 code point 65019


	      if (folded.length > max_char_length) {
	        continue;
	      }

	      if (folded.length == 0) {
	        continue;
	      }

	      yield {
	        folded: folded,
	        composed: composed,
	        code_point: i
	      };
	    }
	  }
	}
	/**
	 * Generate a unicode map from the list of code points
	 * @param {TCodePoints} code_points
	 * @return {TUnicodeSets}
	 */

	const generateSets = code_points => {
	  /** @type {{[key:string]:Set<string>}} */
	  const unicode_sets = {};
	  /**
	   * @param {string} folded
	   * @param {string} to_add
	   */

	  const addMatching = (folded, to_add) => {
	    /** @type {Set<string>} */
	    const folded_set = unicode_sets[folded] || new Set();
	    const patt = new RegExp('^' + setToPattern(folded_set) + '$', 'iu');

	    if (to_add.match(patt)) {
	      return;
	    }

	    folded_set.add(escape_regex(to_add));
	    unicode_sets[folded] = folded_set;
	  };

	  for (let value of generator(code_points)) {
	    addMatching(value.folded, value.folded);
	    addMatching(value.folded, value.composed);
	  }

	  return unicode_sets;
	};
	/**
	 * Generate a unicode map from the list of code points
	 * ae => (?:(?:ae|Æ|Ǽ|Ǣ)|(?:A|Ⓐ|Ａ...)(?:E|ɛ|Ⓔ...))
	 *
	 * @param {TCodePoints} code_points
	 * @return {TUnicodeMap}
	 */

	const generateMap = code_points => {
	  /** @type {TUnicodeSets} */
	  const unicode_sets = generateSets(code_points);
	  /** @type {TUnicodeMap} */

	  const unicode_map = {};
	  /** @type {string[]} */

	  let multi_char = [];

	  for (let folded in unicode_sets) {
	    let set = unicode_sets[folded];

	    if (set) {
	      unicode_map[folded] = setToPattern(set);
	    }

	    if (folded.length > 1) {
	      multi_char.push(escape_regex(folded));
	    }
	  }

	  multi_char.sort((a, b) => b.length - a.length);
	  const multi_char_patt = arrayToPattern(multi_char);
	  multi_char_reg = new RegExp('^' + multi_char_patt, 'u');
	  return unicode_map;
	};
	/**
	 * Map each element of an array from it's folded value to all possible unicode matches
	 * @param {string[]} strings
	 * @param {number} min_replacement
	 * @return {string}
	 */

	const mapSequence = (strings, min_replacement = 1) => {
	  let chars_replaced = 0;
	  strings = strings.map(str => {
	    if (unicode_map[str]) {
	      chars_replaced += str.length;
	    }

	    return unicode_map[str] || str;
	  });

	  if (chars_replaced >= min_replacement) {
	    return sequencePattern(strings);
	  }

	  return '';
	};
	/**
	 * Convert a short string and split it into all possible patterns
	 * Keep a pattern only if min_replacement is met
	 *
	 * 'abc'
	 * 		=> [['abc'],['ab','c'],['a','bc'],['a','b','c']]
	 *		=> ['abc-pattern','ab-c-pattern'...]
	 *
	 *
	 * @param {string} str
	 * @param {number} min_replacement
	 * @return {string}
	 */

	const substringsToPattern = (str, min_replacement = 1) => {
	  min_replacement = Math.max(min_replacement, str.length - 1);
	  return arrayToPattern(allSubstrings(str).map(sub_pat => {
	    return mapSequence(sub_pat, min_replacement);
	  }));
	};
	/**
	 * Convert an array of sequences into a pattern
	 * [{start:0,end:3,length:3,substr:'iii'}...] => (?:iii...)
	 *
	 * @param {Sequence[]} sequences
	 * @param {boolean} all
	 */

	const sequencesToPattern = (sequences, all = true) => {
	  let min_replacement = sequences.length > 1 ? 1 : 0;
	  return arrayToPattern(sequences.map(sequence => {
	    let seq = [];
	    const len = all ? sequence.length() : sequence.length() - 1;

	    for (let j = 0; j < len; j++) {
	      seq.push(substringsToPattern(sequence.substrs[j] || '', min_replacement));
	    }

	    return sequencePattern(seq);
	  }));
	};
	/**
	 * Return true if the sequence is already in the sequences
	 * @param {Sequence} needle_seq
	 * @param {Sequence[]} sequences
	 */


	const inSequences = (needle_seq, sequences) => {
	  for (const seq of sequences) {
	    if (seq.start != needle_seq.start || seq.end != needle_seq.end) {
	      continue;
	    }

	    if (seq.substrs.join('') !== needle_seq.substrs.join('')) {
	      continue;
	    }

	    let needle_parts = needle_seq.parts;
	    /**
	     * @param {TSequencePart} part
	     */

	    const filter = part => {
	      for (const needle_part of needle_parts) {
	        if (needle_part.start === part.start && needle_part.substr === part.substr) {
	          return false;
	        }

	        if (part.length == 1 || needle_part.length == 1) {
	          continue;
	        } // check for overlapping parts
	        // a = ['::=','==']
	        // b = ['::','===']
	        // a = ['r','sm']
	        // b = ['rs','m']


	        if (part.start < needle_part.start && part.end > needle_part.start) {
	          return true;
	        }

	        if (needle_part.start < part.start && needle_part.end > part.start) {
	          return true;
	        }
	      }

	      return false;
	    };

	    let filtered = seq.parts.filter(filter);

	    if (filtered.length > 0) {
	      continue;
	    }

	    return true;
	  }

	  return false;
	};

	class Sequence {
	  constructor() {
	    /** @type {TSequencePart[]} */
	    this.parts = [];
	    /** @type {string[]} */

	    this.substrs = [];
	    this.start = 0;
	    this.end = 0;
	  }
	  /**
	   * @param {TSequencePart|undefined} part
	   */


	  add(part) {
	    if (part) {
	      this.parts.push(part);
	      this.substrs.push(part.substr);
	      this.start = Math.min(part.start, this.start);
	      this.end = Math.max(part.end, this.end);
	    }
	  }

	  last() {
	    return this.parts[this.parts.length - 1];
	  }

	  length() {
	    return this.parts.length;
	  }
	  /**
	   * @param {number} position
	   * @param {TSequencePart} last_piece
	   */


	  clone(position, last_piece) {
	    let clone = new Sequence();
	    let parts = JSON.parse(JSON.stringify(this.parts));
	    let last_part = parts.pop();

	    for (const part of parts) {
	      clone.add(part);
	    }

	    let last_substr = last_piece.substr.substring(0, position - last_part.start);
	    let clone_last_len = last_substr.length;
	    clone.add({
	      start: last_part.start,
	      end: last_part.start + clone_last_len,
	      length: clone_last_len,
	      substr: last_substr
	    });
	    return clone;
	  }

	}
	/**
	 * Expand a regular expression pattern to include unicode variants
	 * 	eg /a/ becomes /aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐɑAⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ/
	 *
	 * Issue:
	 *  ﺊﺋ [ 'ﺊ = \\u{fe8a}', 'ﺋ = \\u{fe8b}' ]
	 *	becomes:	ئئ [ 'ي = \\u{64a}', 'ٔ = \\u{654}', 'ي = \\u{64a}', 'ٔ = \\u{654}' ]
	 *
	 *	İĲ = IIJ = ⅡJ
	 *
	 * 	1/2/4
	 *
	 * @param {string} str
	 * @return {string|undefined}
	 */


	const getPattern = str => {
	  initialize();
	  str = asciifold(str);
	  let pattern = '';
	  let sequences = [new Sequence()];

	  for (let i = 0; i < str.length; i++) {
	    let substr = str.substring(i);
	    let match = substr.match(multi_char_reg);
	    const char = str.substring(i, i + 1);
	    const match_str = match ? match[0] : null; // loop through sequences
	    // add either the char or multi_match

	    let overlapping = [];
	    let added_types = new Set();

	    for (const sequence of sequences) {
	      const last_piece = sequence.last();

	      if (!last_piece || last_piece.length == 1 || last_piece.end <= i) {
	        // if we have a multi match
	        if (match_str) {
	          const len = match_str.length;
	          sequence.add({
	            start: i,
	            end: i + len,
	            length: len,
	            substr: match_str
	          });
	          added_types.add('1');
	        } else {
	          sequence.add({
	            start: i,
	            end: i + 1,
	            length: 1,
	            substr: char
	          });
	          added_types.add('2');
	        }
	      } else if (match_str) {
	        let clone = sequence.clone(i, last_piece);
	        const len = match_str.length;
	        clone.add({
	          start: i,
	          end: i + len,
	          length: len,
	          substr: match_str
	        });
	        overlapping.push(clone);
	      } else {
	        // don't add char
	        // adding would create invalid patterns: 234 => [2,34,4]
	        added_types.add('3');
	      }
	    } // if we have overlapping


	    if (overlapping.length > 0) {
	      // ['ii','iii'] before ['i','i','iii']
	      overlapping = overlapping.sort((a, b) => {
	        return a.length() - b.length();
	      });

	      for (let clone of overlapping) {
	        // don't add if we already have an equivalent sequence
	        if (inSequences(clone, sequences)) {
	          continue;
	        }

	        sequences.push(clone);
	      }

	      continue;
	    } // if we haven't done anything unique
	    // clean up the patterns
	    // helps keep patterns smaller
	    // if str = 'r₨㎧aarss', pattern will be 446 instead of 655


	    if (i > 0 && added_types.size == 1 && !added_types.has('3')) {
	      pattern += sequencesToPattern(sequences, false);
	      let new_seq = new Sequence();
	      const old_seq = sequences[0];

	      if (old_seq) {
	        new_seq.add(old_seq.last());
	      }

	      sequences = [new_seq];
	    }
	  }

	  pattern += sequencesToPattern(sequences, true);
	  return pattern;
	};

	/*! sifter.js | https://github.com/orchidjs/sifter.js | Apache License (v2) */

	/**
	 * A property getter resolving dot-notation
	 * @param  {Object}  obj     The root object to fetch property on
	 * @param  {String}  name    The optionally dotted property name to fetch
	 * @return {Object}          The resolved property value
	 */
	const getAttr = (obj, name) => {
	  if (!obj) return;
	  return obj[name];
	};
	/**
	 * A property getter resolving dot-notation
	 * @param  {Object}  obj     The root object to fetch property on
	 * @param  {String}  name    The optionally dotted property name to fetch
	 * @return {Object}          The resolved property value
	 */

	const getAttrNesting = (obj, name) => {
	  if (!obj) return;
	  var part,
	      names = name.split(".");

	  while ((part = names.shift()) && (obj = obj[part]));

	  return obj;
	};
	/**
	 * Calculates how close of a match the
	 * given value is against a search token.
	 *
	 */

	const scoreValue = (value, token, weight) => {
	  var score, pos;
	  if (!value) return 0;
	  value = value + '';
	  if (token.regex == null) return 0;
	  pos = value.search(token.regex);
	  if (pos === -1) return 0;
	  score = token.string.length / value.length;
	  if (pos === 0) score += 0.5;
	  return score * weight;
	};
	/**
	 * Cast object property to an array if it exists and has a value
	 *
	 */

	const propToArray = (obj, key) => {
	  var value = obj[key];
	  if (typeof value == 'function') return value;

	  if (value && !Array.isArray(value)) {
	    obj[key] = [value];
	  }
	};
	/**
	 * Iterates over arrays and hashes.
	 *
	 * ```
	 * iterate(this.items, function(item, id) {
	 *    // invoked for each item
	 * });
	 * ```
	 *
	 */

	const iterate$1 = (object, callback) => {
	  if (Array.isArray(object)) {
	    object.forEach(callback);
	  } else {
	    for (var key in object) {
	      if (object.hasOwnProperty(key)) {
	        callback(object[key], key);
	      }
	    }
	  }
	};
	const cmp = (a, b) => {
	  if (typeof a === 'number' && typeof b === 'number') {
	    return a > b ? 1 : a < b ? -1 : 0;
	  }

	  a = asciifold(a + '').toLowerCase();
	  b = asciifold(b + '').toLowerCase();
	  if (a > b) return 1;
	  if (b > a) return -1;
	  return 0;
	};

	/*! sifter.js | https://github.com/orchidjs/sifter.js | Apache License (v2) */

	/**
	 * sifter.js
	 * Copyright (c) 2013–2020 Brian Reavis & contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 * @author Brian Reavis <brian@thirdroute.com>
	 */

	class Sifter {
	  // []|{};

	  /**
	   * Textually searches arrays and hashes of objects
	   * by property (or multiple properties). Designed
	   * specifically for autocomplete.
	   *
	   */
	  constructor(items, settings) {
	    this.items = void 0;
	    this.settings = void 0;
	    this.items = items;
	    this.settings = settings || {
	      diacritics: true
	    };
	  }

	  /**
	   * Splits a search string into an array of individual
	   * regexps to be used to match results.
	   *
	   */
	  tokenize(query, respect_word_boundaries, weights) {
	    if (!query || !query.length) return [];
	    const tokens = [];
	    const words = query.split(/\s+/);
	    var field_regex;

	    if (weights) {
	      field_regex = new RegExp('^(' + Object.keys(weights).map(escape_regex).join('|') + ')\:(.*)$');
	    }

	    words.forEach(word => {
	      let field_match;
	      let field = null;
	      let regex = null; // look for "field:query" tokens

	      if (field_regex && (field_match = word.match(field_regex))) {
	        field = field_match[1];
	        word = field_match[2];
	      }

	      if (word.length > 0) {
	        if (this.settings.diacritics) {
	          regex = getPattern(word) || null;
	        } else {
	          regex = escape_regex(word);
	        }

	        if (regex && respect_word_boundaries) regex = "\\b" + regex;
	      }

	      tokens.push({
	        string: word,
	        regex: regex ? new RegExp(regex, 'iu') : null,
	        field: field
	      });
	    });
	    return tokens;
	  }

	  /**
	   * Returns a function to be used to score individual results.
	   *
	   * Good matches will have a higher score than poor matches.
	   * If an item is not a match, 0 will be returned by the function.
	   *
	   * @returns {T.ScoreFn}
	   */
	  getScoreFunction(query, options) {
	    var search = this.prepareSearch(query, options);
	    return this._getScoreFunction(search);
	  }
	  /**
	   * @returns {T.ScoreFn}
	   *
	   */


	  _getScoreFunction(search) {
	    const tokens = search.tokens,
	          token_count = tokens.length;

	    if (!token_count) {
	      return function () {
	        return 0;
	      };
	    }

	    const fields = search.options.fields,
	          weights = search.weights,
	          field_count = fields.length,
	          getAttrFn = search.getAttrFn;

	    if (!field_count) {
	      return function () {
	        return 1;
	      };
	    }
	    /**
	     * Calculates the score of an object
	     * against the search query.
	     *
	     */


	    const scoreObject = function () {
	      if (field_count === 1) {
	        return function (token, data) {
	          const field = fields[0].field;
	          return scoreValue(getAttrFn(data, field), token, weights[field] || 1);
	        };
	      }

	      return function (token, data) {
	        var sum = 0; // is the token specific to a field?

	        if (token.field) {
	          const value = getAttrFn(data, token.field);

	          if (!token.regex && value) {
	            sum += 1 / field_count;
	          } else {
	            sum += scoreValue(value, token, 1);
	          }
	        } else {
	          iterate$1(weights, (weight, field) => {
	            sum += scoreValue(getAttrFn(data, field), token, weight);
	          });
	        }

	        return sum / field_count;
	      };
	    }();

	    if (token_count === 1) {
	      return function (data) {
	        return scoreObject(tokens[0], data);
	      };
	    }

	    if (search.options.conjunction === 'and') {
	      return function (data) {
	        var score,
	            sum = 0;

	        for (let token of tokens) {
	          score = scoreObject(token, data);
	          if (score <= 0) return 0;
	          sum += score;
	        }

	        return sum / token_count;
	      };
	    } else {
	      return function (data) {
	        var sum = 0;
	        iterate$1(tokens, token => {
	          sum += scoreObject(token, data);
	        });
	        return sum / token_count;
	      };
	    }
	  }

	  /**
	   * Returns a function that can be used to compare two
	   * results, for sorting purposes. If no sorting should
	   * be performed, `null` will be returned.
	   *
	   * @return function(a,b)
	   */
	  getSortFunction(query, options) {
	    var search = this.prepareSearch(query, options);
	    return this._getSortFunction(search);
	  }

	  _getSortFunction(search) {
	    var implicit_score,
	        sort_flds = [];
	    const self = this,
	          options = search.options,
	          sort = !search.query && options.sort_empty ? options.sort_empty : options.sort;

	    if (typeof sort == 'function') {
	      return sort.bind(this);
	    }
	    /**
	     * Fetches the specified sort field value
	     * from a search result item.
	     *
	     */


	    const get_field = function get_field(name, result) {
	      if (name === '$score') return result.score;
	      return search.getAttrFn(self.items[result.id], name);
	    }; // parse options


	    if (sort) {
	      for (let s of sort) {
	        if (search.query || s.field !== '$score') {
	          sort_flds.push(s);
	        }
	      }
	    } // the "$score" field is implied to be the primary
	    // sort field, unless it's manually specified


	    if (search.query) {
	      implicit_score = true;

	      for (let fld of sort_flds) {
	        if (fld.field === '$score') {
	          implicit_score = false;
	          break;
	        }
	      }

	      if (implicit_score) {
	        sort_flds.unshift({
	          field: '$score',
	          direction: 'desc'
	        });
	      } // without a search.query, all items will have the same score

	    } else {
	      sort_flds = sort_flds.filter(fld => fld.field !== '$score');
	    } // build function


	    const sort_flds_count = sort_flds.length;

	    if (!sort_flds_count) {
	      return null;
	    }

	    return function (a, b) {
	      var result, field;

	      for (let sort_fld of sort_flds) {
	        field = sort_fld.field;
	        let multiplier = sort_fld.direction === 'desc' ? -1 : 1;
	        result = multiplier * cmp(get_field(field, a), get_field(field, b));
	        if (result) return result;
	      }

	      return 0;
	    };
	  }

	  /**
	   * Parses a search query and returns an object
	   * with tokens and fields ready to be populated
	   * with results.
	   *
	   */
	  prepareSearch(query, optsUser) {
	    const weights = {};
	    var options = Object.assign({}, optsUser);
	    propToArray(options, 'sort');
	    propToArray(options, 'sort_empty'); // convert fields to new format

	    if (options.fields) {
	      propToArray(options, 'fields');
	      const fields = [];
	      options.fields.forEach(field => {
	        if (typeof field == 'string') {
	          field = {
	            field: field,
	            weight: 1
	          };
	        }

	        fields.push(field);
	        weights[field.field] = 'weight' in field ? field.weight : 1;
	      });
	      options.fields = fields;
	    }

	    return {
	      options: options,
	      query: query.toLowerCase().trim(),
	      tokens: this.tokenize(query, options.respect_word_boundaries, weights),
	      total: 0,
	      items: [],
	      weights: weights,
	      getAttrFn: options.nesting ? getAttrNesting : getAttr
	    };
	  }

	  /**
	   * Searches through all items and returns a sorted array of matches.
	   *
	   */
	  search(query, options) {
	    var self = this,
	        score,
	        search;
	    search = this.prepareSearch(query, options);
	    options = search.options;
	    query = search.query; // generate result scoring function

	    const fn_score = options.score || self._getScoreFunction(search); // perform search and sort


	    if (query.length) {
	      iterate$1(self.items, (item, id) => {
	        score = fn_score(item);

	        if (options.filter === false || score > 0) {
	          search.items.push({
	            'score': score,
	            'id': id
	          });
	        }
	      });
	    } else {
	      iterate$1(self.items, (_, id) => {
	        search.items.push({
	          'score': 1,
	          'id': id
	        });
	      });
	    }

	    const fn_sort = self._getSortFunction(search);

	    if (fn_sort) search.items.sort(fn_sort); // apply limits

	    search.total = search.items.length;

	    if (typeof options.limit === 'number') {
	      search.items = search.items.slice(0, options.limit);
	    }

	    return search;
	  }

	}

	/**
	 * Iterates over arrays and hashes.
	 *
	 * ```
	 * iterate(this.items, function(item, id) {
	 *    // invoked for each item
	 * });
	 * ```
	 *
	 */
	const iterate = (object, callback) => {
	  if (Array.isArray(object)) {
	    object.forEach(callback);
	  } else {
	    for (var key in object) {
	      if (object.hasOwnProperty(key)) {
	        callback(object[key], key);
	      }
	    }
	  }
	};

	/**
	 * Return a dom element from either a dom query string, jQuery object, a dom element or html string
	 * https://stackoverflow.com/questions/494143/creating-a-new-dom-element-from-an-html-string-using-built-in-dom-methods-or-pro/35385518#35385518
	 *
	 * param query should be {}
	 */
	const getDom = query => {
	  if (query.jquery) {
	    return query[0];
	  }
	  if (query instanceof HTMLElement) {
	    return query;
	  }
	  if (isHtmlString(query)) {
	    var tpl = document.createElement('template');
	    tpl.innerHTML = query.trim(); // Never return a text node of whitespace as the result
	    return tpl.content.firstChild;
	  }
	  return document.querySelector(query);
	};
	const isHtmlString = arg => {
	  if (typeof arg === 'string' && arg.indexOf('<') > -1) {
	    return true;
	  }
	  return false;
	};
	const escapeQuery = query => {
	  return query.replace(/['"\\]/g, '\\$&');
	};

	/**
	 * Dispatch an event
	 *
	 */
	const triggerEvent = (dom_el, event_name) => {
	  var event = document.createEvent('HTMLEvents');
	  event.initEvent(event_name, true, false);
	  dom_el.dispatchEvent(event);
	};

	/**
	 * Apply CSS rules to a dom element
	 *
	 */
	const applyCSS = (dom_el, css) => {
	  Object.assign(dom_el.style, css);
	};

	/**
	 * Add css classes
	 *
	 */
	const addClasses = (elmts, ...classes) => {
	  var norm_classes = classesArray(classes);
	  elmts = castAsArray(elmts);
	  elmts.map(el => {
	    norm_classes.map(cls => {
	      el.classList.add(cls);
	    });
	  });
	};

	/**
	 * Remove css classes
	 *
	 */
	const removeClasses = (elmts, ...classes) => {
	  var norm_classes = classesArray(classes);
	  elmts = castAsArray(elmts);
	  elmts.map(el => {
	    norm_classes.map(cls => {
	      el.classList.remove(cls);
	    });
	  });
	};

	/**
	 * Return arguments
	 *
	 */
	const classesArray = args => {
	  var classes = [];
	  iterate(args, _classes => {
	    if (typeof _classes === 'string') {
	      _classes = _classes.trim().split(/[\11\12\14\15\40]/);
	    }
	    if (Array.isArray(_classes)) {
	      classes = classes.concat(_classes);
	    }
	  });
	  return classes.filter(Boolean);
	};

	/**
	 * Create an array from arg if it's not already an array
	 *
	 */
	const castAsArray = arg => {
	  if (!Array.isArray(arg)) {
	    arg = [arg];
	  }
	  return arg;
	};

	/**
	 * Get the closest node to the evt.target matching the selector
	 * Stops at wrapper
	 *
	 */
	const parentMatch = (target, selector, wrapper) => {
	  if (wrapper && !wrapper.contains(target)) {
	    return;
	  }
	  while (target && target.matches) {
	    if (target.matches(selector)) {
	      return target;
	    }
	    target = target.parentNode;
	  }
	};

	/**
	 * Get the first or last item from an array
	 *
	 * > 0 - right (last)
	 * <= 0 - left (first)
	 *
	 */
	const getTail = (list, direction = 0) => {
	  if (direction > 0) {
	    return list[list.length - 1];
	  }
	  return list[0];
	};

	/**
	 * Return true if an object is empty
	 *
	 */
	const isEmptyObject = obj => {
	  return Object.keys(obj).length === 0;
	};

	/**
	 * Get the index of an element amongst sibling nodes of the same type
	 *
	 */
	const nodeIndex = (el, amongst) => {
	  if (!el) return -1;
	  amongst = amongst || el.nodeName;
	  var i = 0;
	  while (el = el.previousElementSibling) {
	    if (el.matches(amongst)) {
	      i++;
	    }
	  }
	  return i;
	};

	/**
	 * Set attributes of an element
	 *
	 */
	const setAttr = (el, attrs) => {
	  iterate(attrs, (val, attr) => {
	    if (val == null) {
	      el.removeAttribute(attr);
	    } else {
	      el.setAttribute(attr, '' + val);
	    }
	  });
	};

	/**
	 * Replace a node
	 */
	const replaceNode = (existing, replacement) => {
	  if (existing.parentNode) existing.parentNode.replaceChild(replacement, existing);
	};

	/**
	 * highlight v3 | MIT license | Johann Burkard <jb@eaio.com>
	 * Highlights arbitrary terms in a node.
	 *
	 * - Modified by Marshal <beatgates@gmail.com> 2011-6-24 (added regex)
	 * - Modified by Brian Reavis <brian@thirdroute.com> 2012-8-27 (cleanup)
	 */

	const highlight = (element, regex) => {
	  if (regex === null) return;

	  // convet string to regex
	  if (typeof regex === 'string') {
	    if (!regex.length) return;
	    regex = new RegExp(regex, 'i');
	  }

	  // Wrap matching part of text node with highlighting <span>, e.g.
	  // Soccer  ->  <span class="highlight">Soc</span>cer  for regex = /soc/i
	  const highlightText = node => {
	    var match = node.data.match(regex);
	    if (match && node.data.length > 0) {
	      var spannode = document.createElement('span');
	      spannode.className = 'highlight';
	      var middlebit = node.splitText(match.index);
	      middlebit.splitText(match[0].length);
	      var middleclone = middlebit.cloneNode(true);
	      spannode.appendChild(middleclone);
	      replaceNode(middlebit, spannode);
	      return 1;
	    }
	    return 0;
	  };

	  // Recurse element node, looking for child text nodes to highlight, unless element
	  // is childless, <script>, <style>, or already highlighted: <span class="hightlight">
	  const highlightChildren = node => {
	    if (node.nodeType === 1 && node.childNodes && !/(script|style)/i.test(node.tagName) && (node.className !== 'highlight' || node.tagName !== 'SPAN')) {
	      Array.from(node.childNodes).forEach(element => {
	        highlightRecursive(element);
	      });
	    }
	  };
	  const highlightRecursive = node => {
	    if (node.nodeType === 3) {
	      return highlightText(node);
	    }
	    highlightChildren(node);
	    return 0;
	  };
	  highlightRecursive(element);
	};

	/**
	 * removeHighlight fn copied from highlight v5 and
	 * edited to remove with(), pass js strict mode, and use without jquery
	 */
	const removeHighlight = el => {
	  var elements = el.querySelectorAll("span.highlight");
	  Array.prototype.forEach.call(elements, function (el) {
	    var parent = el.parentNode;
	    parent.replaceChild(el.firstChild, el);
	    parent.normalize();
	  });
	};

	const KEY_A = 65;
	const KEY_RETURN = 13;
	const KEY_ESC = 27;
	const KEY_LEFT = 37;
	const KEY_UP = 38;
	const KEY_RIGHT = 39;
	const KEY_DOWN = 40;
	const KEY_BACKSPACE = 8;
	const KEY_DELETE = 46;
	const KEY_TAB = 9;
	const IS_MAC = typeof navigator === 'undefined' ? false : /Mac/.test(navigator.userAgent);
	const KEY_SHORTCUT = IS_MAC ? 'metaKey' : 'ctrlKey'; // ctrl key or apple key for ma

	var defaults = {
	  options: [],
	  optgroups: [],
	  plugins: [],
	  delimiter: ',',
	  splitOn: null,
	  // regexp or string for splitting up values from a paste command
	  persist: true,
	  diacritics: true,
	  create: null,
	  createOnBlur: false,
	  createFilter: null,
	  highlight: true,
	  openOnFocus: true,
	  shouldOpen: null,
	  maxOptions: 50,
	  maxItems: null,
	  hideSelected: null,
	  duplicates: false,
	  addPrecedence: false,
	  selectOnTab: false,
	  preload: null,
	  allowEmptyOption: false,
	  //closeAfterSelect: false,
	  refreshThrottle: 300,
	  loadThrottle: 300,
	  loadingClass: 'loading',
	  dataAttr: null,
	  //'data-data',
	  optgroupField: 'optgroup',
	  valueField: 'value',
	  labelField: 'text',
	  disabledField: 'disabled',
	  optgroupLabelField: 'label',
	  optgroupValueField: 'value',
	  lockOptgroupOrder: false,
	  sortField: '$order',
	  searchField: ['text'],
	  searchConjunction: 'and',
	  mode: null,
	  wrapperClass: 'ts-wrapper',
	  controlClass: 'ts-control',
	  dropdownClass: 'ts-dropdown',
	  dropdownContentClass: 'ts-dropdown-content',
	  itemClass: 'item',
	  optionClass: 'option',
	  dropdownParent: null,
	  controlInput: '<input type="text" autocomplete="off" size="1" />',
	  copyClassesToDropdown: false,
	  placeholder: null,
	  hidePlaceholder: null,
	  shouldLoad: function (query) {
	    return query.length > 0;
	  },
	  /*
	  load                 : null, // function(query, callback) { ... }
	  score                : null, // function(search) { ... }
	  onInitialize         : null, // function() { ... }
	  onChange             : null, // function(value) { ... }
	  onItemAdd            : null, // function(value, $item) { ... }
	  onItemRemove         : null, // function(value) { ... }
	  onClear              : null, // function() { ... }
	  onOptionAdd          : null, // function(value, data) { ... }
	  onOptionRemove       : null, // function(value) { ... }
	  onOptionClear        : null, // function() { ... }
	  onOptionGroupAdd     : null, // function(id, data) { ... }
	  onOptionGroupRemove  : null, // function(id) { ... }
	  onOptionGroupClear   : null, // function() { ... }
	  onDropdownOpen       : null, // function(dropdown) { ... }
	  onDropdownClose      : null, // function(dropdown) { ... }
	  onType               : null, // function(str) { ... }
	  onDelete             : null, // function(values) { ... }
	  */

	  render: {
	    /*
	    item: null,
	    optgroup: null,
	    optgroup_header: null,
	    option: null,
	    option_create: null
	    */
	  }
	};

	/**
	 * Converts a scalar to its best string representation
	 * for hash keys and HTML attribute values.
	 *
	 * Transformations:
	 *   'str'     -> 'str'
	 *   null      -> ''
	 *   undefined -> ''
	 *   true      -> '1'
	 *   false     -> '0'
	 *   0         -> '0'
	 *   1         -> '1'
	 *
	 */
	const hash_key = value => {
	  if (typeof value === 'undefined' || value === null) return null;
	  return get_hash(value);
	};
	const get_hash = value => {
	  if (typeof value === 'boolean') return value ? '1' : '0';
	  return value + '';
	};

	/**
	 * Escapes a string for use within HTML.
	 *
	 */
	const escape_html = str => {
	  return (str + '').replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
	};

	/**
	 * use setTimeout if timeout > 0 
	 */
	const timeout = (fn, timeout) => {
	  if (timeout > 0) {
	    return setTimeout(fn, timeout);
	  }
	  fn.call(null);
	  return null;
	};

	/**
	 * Debounce the user provided load function
	 *
	 */
	const loadDebounce = (fn, delay) => {
	  var timeout;
	  return function (value, callback) {
	    var self = this;
	    if (timeout) {
	      self.loading = Math.max(self.loading - 1, 0);
	      clearTimeout(timeout);
	    }
	    timeout = setTimeout(function () {
	      timeout = null;
	      self.loadedSearches[value] = true;
	      fn.call(self, value, callback);
	    }, delay);
	  };
	};

	/**
	 * Debounce all fired events types listed in `types`
	 * while executing the provided `fn`.
	 *
	 */
	const debounce_events = (self, types, fn) => {
	  var type;
	  var trigger = self.trigger;
	  var event_args = {};

	  // override trigger method
	  self.trigger = function () {
	    var type = arguments[0];
	    if (types.indexOf(type) !== -1) {
	      event_args[type] = arguments;
	    } else {
	      return trigger.apply(self, arguments);
	    }
	  };

	  // invoke provided function
	  fn.apply(self, []);
	  self.trigger = trigger;

	  // trigger queued events
	  for (type of types) {
	    if (type in event_args) {
	      trigger.apply(self, event_args[type]);
	    }
	  }
	};

	/**
	 * Determines the current selection within a text input control.
	 * Returns an object containing:
	 *   - start
	 *   - length
	 *
	 * Note: "selectionStart, selectionEnd ... apply only to inputs of types text, search, URL, tel and password"
	 * 	- https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/setSelectionRange
	 */
	const getSelection = input => {
	  return {
	    start: input.selectionStart || 0,
	    length: (input.selectionEnd || 0) - (input.selectionStart || 0)
	  };
	};

	/**
	 * Prevent default
	 *
	 */
	const preventDefault = (evt, stop = false) => {
	  if (evt) {
	    evt.preventDefault();
	    if (stop) {
	      evt.stopPropagation();
	    }
	  }
	};

	/**
	 * Add event helper
	 *
	 */
	const addEvent = (target, type, callback, options) => {
	  target.addEventListener(type, callback, options);
	};

	/**
	 * Return true if the requested key is down
	 * Will return false if more than one control character is pressed ( when [ctrl+shift+a] != [ctrl+a] )
	 * The current evt may not always set ( eg calling advanceSelection() )
	 *
	 */
	const isKeyDown = (key_name, evt) => {
	  if (!evt) {
	    return false;
	  }
	  if (!evt[key_name]) {
	    return false;
	  }
	  var count = (evt.altKey ? 1 : 0) + (evt.ctrlKey ? 1 : 0) + (evt.shiftKey ? 1 : 0) + (evt.metaKey ? 1 : 0);
	  if (count === 1) {
	    return true;
	  }
	  return false;
	};

	/**
	 * Get the id of an element
	 * If the id attribute is not set, set the attribute with the given id
	 *
	 */
	const getId = (el, id) => {
	  const existing_id = el.getAttribute('id');
	  if (existing_id) {
	    return existing_id;
	  }
	  el.setAttribute('id', id);
	  return id;
	};

	/**
	 * Returns a string with backslashes added before characters that need to be escaped.
	 */
	const addSlashes = str => {
	  return str.replace(/[\\"']/g, '\\$&');
	};

	/**
	 *
	 */
	const append = (parent, node) => {
	  if (node) parent.append(node);
	};

	function getSettings(input, settings_user) {
	  var settings = Object.assign({}, defaults, settings_user);
	  var attr_data = settings.dataAttr;
	  var field_label = settings.labelField;
	  var field_value = settings.valueField;
	  var field_disabled = settings.disabledField;
	  var field_optgroup = settings.optgroupField;
	  var field_optgroup_label = settings.optgroupLabelField;
	  var field_optgroup_value = settings.optgroupValueField;
	  var tag_name = input.tagName.toLowerCase();
	  var placeholder = input.getAttribute('placeholder') || input.getAttribute('data-placeholder');
	  if (!placeholder && !settings.allowEmptyOption) {
	    let option = input.querySelector('option[value=""]');
	    if (option) {
	      placeholder = option.textContent;
	    }
	  }
	  var settings_element = {
	    placeholder: placeholder,
	    options: [],
	    optgroups: [],
	    items: [],
	    maxItems: null
	  };

	  /**
	   * Initialize from a <select> element.
	   *
	   */
	  var init_select = () => {
	    var tagName;
	    var options = settings_element.options;
	    var optionsMap = {};
	    var group_count = 1;
	    let $order = 0;
	    var readData = el => {
	      var data = Object.assign({}, el.dataset); // get plain object from DOMStringMap
	      var json = attr_data && data[attr_data];
	      if (typeof json === 'string' && json.length) {
	        data = Object.assign(data, JSON.parse(json));
	      }
	      return data;
	    };
	    var addOption = (option, group) => {
	      var value = hash_key(option.value);
	      if (value == null) return;
	      if (!value && !settings.allowEmptyOption) return;

	      // if the option already exists, it's probably been
	      // duplicated in another optgroup. in this case, push
	      // the current group to the "optgroup" property on the
	      // existing option so that it's rendered in both places.
	      if (optionsMap.hasOwnProperty(value)) {
	        if (group) {
	          var arr = optionsMap[value][field_optgroup];
	          if (!arr) {
	            optionsMap[value][field_optgroup] = group;
	          } else if (!Array.isArray(arr)) {
	            optionsMap[value][field_optgroup] = [arr, group];
	          } else {
	            arr.push(group);
	          }
	        }
	      } else {
	        var option_data = readData(option);
	        option_data[field_label] = option_data[field_label] || option.textContent;
	        option_data[field_value] = option_data[field_value] || value;
	        option_data[field_disabled] = option_data[field_disabled] || option.disabled;
	        option_data[field_optgroup] = option_data[field_optgroup] || group;
	        option_data.$option = option;
	        option_data.$order = option_data.$order || ++$order;
	        optionsMap[value] = option_data;
	        options.push(option_data);
	      }
	      if (option.selected) {
	        settings_element.items.push(value);
	      }
	    };
	    var addGroup = optgroup => {
	      var id, optgroup_data;
	      optgroup_data = readData(optgroup);
	      optgroup_data[field_optgroup_label] = optgroup_data[field_optgroup_label] || optgroup.getAttribute('label') || '';
	      optgroup_data[field_optgroup_value] = optgroup_data[field_optgroup_value] || group_count++;
	      optgroup_data[field_disabled] = optgroup_data[field_disabled] || optgroup.disabled;
	      optgroup_data.$order = optgroup_data.$order || ++$order;
	      settings_element.optgroups.push(optgroup_data);
	      id = optgroup_data[field_optgroup_value];
	      iterate(optgroup.children, option => {
	        addOption(option, id);
	      });
	    };
	    settings_element.maxItems = input.hasAttribute('multiple') ? null : 1;
	    iterate(input.children, child => {
	      tagName = child.tagName.toLowerCase();
	      if (tagName === 'optgroup') {
	        addGroup(child);
	      } else if (tagName === 'option') {
	        addOption(child);
	      }
	    });
	  };

	  /**
	   * Initialize from a <input type="text"> element.
	   *
	   */
	  var init_textbox = () => {
	    const data_raw = input.getAttribute(attr_data);
	    if (!data_raw) {
	      var value = input.value.trim() || '';
	      if (!settings.allowEmptyOption && !value.length) return;
	      const values = value.split(settings.delimiter);
	      iterate(values, value => {
	        const option = {};
	        option[field_label] = value;
	        option[field_value] = value;
	        settings_element.options.push(option);
	      });
	      settings_element.items = values;
	    } else {
	      settings_element.options = JSON.parse(data_raw);
	      iterate(settings_element.options, opt => {
	        settings_element.items.push(opt[field_value]);
	      });
	    }
	  };
	  if (tag_name === 'select') {
	    init_select();
	  } else {
	    init_textbox();
	  }
	  return Object.assign({}, defaults, settings_element, settings_user);
	}

	var instance_i = 0;
	class TomSelect extends MicroPlugin(MicroEvent) {
	  constructor(input_arg, user_settings) {
	    super();
	    this.control_input = void 0;
	    this.wrapper = void 0;
	    this.dropdown = void 0;
	    this.control = void 0;
	    this.dropdown_content = void 0;
	    this.focus_node = void 0;
	    this.order = 0;
	    this.settings = void 0;
	    this.input = void 0;
	    this.tabIndex = void 0;
	    this.is_select_tag = void 0;
	    this.rtl = void 0;
	    this.inputId = void 0;
	    this._destroy = void 0;
	    this.sifter = void 0;
	    this.isOpen = false;
	    this.isDisabled = false;
	    this.isReadOnly = false;
	    this.isRequired = void 0;
	    this.isInvalid = false;
	    // @deprecated 1.8
	    this.isValid = true;
	    this.isLocked = false;
	    this.isFocused = false;
	    this.isInputHidden = false;
	    this.isSetup = false;
	    this.ignoreFocus = false;
	    this.ignoreHover = false;
	    this.hasOptions = false;
	    this.currentResults = void 0;
	    this.lastValue = '';
	    this.caretPos = 0;
	    this.loading = 0;
	    this.loadedSearches = {};
	    this.activeOption = null;
	    this.activeItems = [];
	    this.optgroups = {};
	    this.options = {};
	    this.userOptions = {};
	    this.items = [];
	    this.refreshTimeout = null;
	    instance_i++;
	    var dir;
	    var input = getDom(input_arg);
	    if (input.tomselect) {
	      throw new Error('Tom Select already initialized on this element');
	    }
	    input.tomselect = this;

	    // detect rtl environment
	    var computedStyle = window.getComputedStyle && window.getComputedStyle(input, null);
	    dir = computedStyle.getPropertyValue('direction');

	    // setup default state
	    const settings = getSettings(input, user_settings);
	    this.settings = settings;
	    this.input = input;
	    this.tabIndex = input.tabIndex || 0;
	    this.is_select_tag = input.tagName.toLowerCase() === 'select';
	    this.rtl = /rtl/i.test(dir);
	    this.inputId = getId(input, 'tomselect-' + instance_i);
	    this.isRequired = input.required;

	    // search system
	    this.sifter = new Sifter(this.options, {
	      diacritics: settings.diacritics
	    });

	    // option-dependent defaults
	    settings.mode = settings.mode || (settings.maxItems === 1 ? 'single' : 'multi');
	    if (typeof settings.hideSelected !== 'boolean') {
	      settings.hideSelected = settings.mode === 'multi';
	    }
	    if (typeof settings.hidePlaceholder !== 'boolean') {
	      settings.hidePlaceholder = settings.mode !== 'multi';
	    }

	    // set up createFilter callback
	    var filter = settings.createFilter;
	    if (typeof filter !== 'function') {
	      if (typeof filter === 'string') {
	        filter = new RegExp(filter);
	      }
	      if (filter instanceof RegExp) {
	        settings.createFilter = input => filter.test(input);
	      } else {
	        settings.createFilter = value => {
	          return this.settings.duplicates || !this.options[value];
	        };
	      }
	    }
	    this.initializePlugins(settings.plugins);
	    this.setupCallbacks();
	    this.setupTemplates();

	    // Create all elements
	    const wrapper = getDom('<div>');
	    const control = getDom('<div>');
	    const dropdown = this._render('dropdown');
	    const dropdown_content = getDom(`<div role="listbox" tabindex="-1">`);
	    const classes = this.input.getAttribute('class') || '';
	    const inputMode = settings.mode;
	    var control_input;
	    addClasses(wrapper, settings.wrapperClass, classes, inputMode);
	    addClasses(control, settings.controlClass);
	    append(wrapper, control);
	    addClasses(dropdown, settings.dropdownClass, inputMode);
	    if (settings.copyClassesToDropdown) {
	      addClasses(dropdown, classes);
	    }
	    addClasses(dropdown_content, settings.dropdownContentClass);
	    append(dropdown, dropdown_content);
	    getDom(settings.dropdownParent || wrapper).appendChild(dropdown);

	    // default controlInput
	    if (isHtmlString(settings.controlInput)) {
	      control_input = getDom(settings.controlInput);

	      // set attributes
	      var attrs = ['autocorrect', 'autocapitalize', 'autocomplete', 'spellcheck'];
	      iterate$1(attrs, attr => {
	        if (input.getAttribute(attr)) {
	          setAttr(control_input, {
	            [attr]: input.getAttribute(attr)
	          });
	        }
	      });
	      control_input.tabIndex = -1;
	      control.appendChild(control_input);
	      this.focus_node = control_input;

	      // dom element
	    } else if (settings.controlInput) {
	      control_input = getDom(settings.controlInput);
	      this.focus_node = control_input;
	    } else {
	      control_input = getDom('<input/>');
	      this.focus_node = control;
	    }
	    this.wrapper = wrapper;
	    this.dropdown = dropdown;
	    this.dropdown_content = dropdown_content;
	    this.control = control;
	    this.control_input = control_input;
	    this.setup();
	  }

	  /**
	   * set up event bindings.
	   *
	   */
	  setup() {
	    const self = this;
	    const settings = self.settings;
	    const control_input = self.control_input;
	    const dropdown = self.dropdown;
	    const dropdown_content = self.dropdown_content;
	    const wrapper = self.wrapper;
	    const control = self.control;
	    const input = self.input;
	    const focus_node = self.focus_node;
	    const passive_event = {
	      passive: true
	    };
	    const listboxId = self.inputId + '-ts-dropdown';
	    setAttr(dropdown_content, {
	      id: listboxId
	    });
	    setAttr(focus_node, {
	      role: 'combobox',
	      'aria-haspopup': 'listbox',
	      'aria-expanded': 'false',
	      'aria-controls': listboxId
	    });
	    const control_id = getId(focus_node, self.inputId + '-ts-control');
	    const query = "label[for='" + escapeQuery(self.inputId) + "']";
	    const label = document.querySelector(query);
	    const label_click = self.focus.bind(self);
	    if (label) {
	      addEvent(label, 'click', label_click);
	      setAttr(label, {
	        for: control_id
	      });
	      const label_id = getId(label, self.inputId + '-ts-label');
	      setAttr(focus_node, {
	        'aria-labelledby': label_id
	      });
	      setAttr(dropdown_content, {
	        'aria-labelledby': label_id
	      });
	    }
	    wrapper.style.width = input.style.width;
	    if (self.plugins.names.length) {
	      const classes_plugins = 'plugin-' + self.plugins.names.join(' plugin-');
	      addClasses([wrapper, dropdown], classes_plugins);
	    }
	    if ((settings.maxItems === null || settings.maxItems > 1) && self.is_select_tag) {
	      setAttr(input, {
	        multiple: 'multiple'
	      });
	    }
	    if (settings.placeholder) {
	      setAttr(control_input, {
	        placeholder: settings.placeholder
	      });
	    }

	    // if splitOn was not passed in, construct it from the delimiter to allow pasting universally
	    if (!settings.splitOn && settings.delimiter) {
	      settings.splitOn = new RegExp('\\s*' + escape_regex(settings.delimiter) + '+\\s*');
	    }

	    // debounce user defined load() if loadThrottle > 0
	    // after initializePlugins() so plugins can create/modify user defined loaders
	    if (settings.load && settings.loadThrottle) {
	      settings.load = loadDebounce(settings.load, settings.loadThrottle);
	    }
	    addEvent(dropdown, 'mousemove', () => {
	      self.ignoreHover = false;
	    });
	    addEvent(dropdown, 'mouseenter', e => {
	      var target_match = parentMatch(e.target, '[data-selectable]', dropdown);
	      if (target_match) self.onOptionHover(e, target_match);
	    }, {
	      capture: true
	    });

	    // clicking on an option should select it
	    addEvent(dropdown, 'click', evt => {
	      const option = parentMatch(evt.target, '[data-selectable]');
	      if (option) {
	        self.onOptionSelect(evt, option);
	        preventDefault(evt, true);
	      }
	    });
	    addEvent(control, 'click', evt => {
	      var target_match = parentMatch(evt.target, '[data-ts-item]', control);
	      if (target_match && self.onItemSelect(evt, target_match)) {
	        preventDefault(evt, true);
	        return;
	      }

	      // retain focus (see control_input mousedown)
	      if (control_input.value != '') {
	        return;
	      }
	      self.onClick();
	      preventDefault(evt, true);
	    });

	    // keydown on focus_node for arrow_down/arrow_up
	    addEvent(focus_node, 'keydown', e => self.onKeyDown(e));

	    // keypress and input/keyup
	    addEvent(control_input, 'keypress', e => self.onKeyPress(e));
	    addEvent(control_input, 'input', e => self.onInput(e));
	    addEvent(focus_node, 'blur', e => self.onBlur(e));
	    addEvent(focus_node, 'focus', e => self.onFocus(e));
	    addEvent(control_input, 'paste', e => self.onPaste(e));
	    const doc_mousedown = evt => {
	      // blur if target is outside of this instance
	      // dropdown is not always inside wrapper
	      const target = evt.composedPath()[0];
	      if (!wrapper.contains(target) && !dropdown.contains(target)) {
	        if (self.isFocused) {
	          self.blur();
	        }
	        self.inputState();
	        return;
	      }

	      // retain focus by preventing native handling. if the
	      // event target is the input it should not be modified.
	      // otherwise, text selection within the input won't work.
	      // Fixes bug #212 which is no covered by tests
	      if (target == control_input && self.isOpen) {
	        evt.stopPropagation();

	        // clicking anywhere in the control should not blur the control_input (which would close the dropdown)
	      } else {
	        preventDefault(evt, true);
	      }
	    };
	    const win_scroll = () => {
	      if (self.isOpen) {
	        self.positionDropdown();
	      }
	    };
	    addEvent(document, 'mousedown', doc_mousedown);
	    addEvent(window, 'scroll', win_scroll, passive_event);
	    addEvent(window, 'resize', win_scroll, passive_event);
	    this._destroy = () => {
	      document.removeEventListener('mousedown', doc_mousedown);
	      window.removeEventListener('scroll', win_scroll);
	      window.removeEventListener('resize', win_scroll);
	      if (label) label.removeEventListener('click', label_click);
	    };

	    // store original html and tab index so that they can be
	    // restored when the destroy() method is called.
	    this.revertSettings = {
	      innerHTML: input.innerHTML,
	      tabIndex: input.tabIndex
	    };
	    input.tabIndex = -1;
	    input.insertAdjacentElement('afterend', self.wrapper);
	    self.sync(false);
	    settings.items = [];
	    delete settings.optgroups;
	    delete settings.options;
	    addEvent(input, 'invalid', () => {
	      if (self.isValid) {
	        self.isValid = false;
	        self.isInvalid = true;
	        self.refreshState();
	      }
	    });
	    self.updateOriginalInput();
	    self.refreshItems();
	    self.close(false);
	    self.inputState();
	    self.isSetup = true;
	    if (input.disabled) {
	      self.disable();
	    } else if (input.readOnly) {
	      self.setReadOnly(true);
	    } else {
	      self.enable(); //sets tabIndex
	    }

	    self.on('change', this.onChange);
	    addClasses(input, 'tomselected', 'ts-hidden-accessible');
	    self.trigger('initialize');

	    // preload options
	    if (settings.preload === true) {
	      self.preload();
	    }
	  }

	  /**
	   * Register options and optgroups
	   *
	   */
	  setupOptions(options = [], optgroups = []) {
	    // build options table
	    this.addOptions(options);

	    // build optgroup table
	    iterate$1(optgroups, optgroup => {
	      this.registerOptionGroup(optgroup);
	    });
	  }

	  /**
	   * Sets up default rendering functions.
	   */
	  setupTemplates() {
	    var self = this;
	    var field_label = self.settings.labelField;
	    var field_optgroup = self.settings.optgroupLabelField;
	    var templates = {
	      'optgroup': data => {
	        let optgroup = document.createElement('div');
	        optgroup.className = 'optgroup';
	        optgroup.appendChild(data.options);
	        return optgroup;
	      },
	      'optgroup_header': (data, escape) => {
	        return '<div class="optgroup-header">' + escape(data[field_optgroup]) + '</div>';
	      },
	      'option': (data, escape) => {
	        return '<div>' + escape(data[field_label]) + '</div>';
	      },
	      'item': (data, escape) => {
	        return '<div>' + escape(data[field_label]) + '</div>';
	      },
	      'option_create': (data, escape) => {
	        return '<div class="create">Add <strong>' + escape(data.input) + '</strong>&hellip;</div>';
	      },
	      'no_results': () => {
	        return '<div class="no-results">No results found</div>';
	      },
	      'loading': () => {
	        return '<div class="spinner"></div>';
	      },
	      'not_loading': () => {},
	      'dropdown': () => {
	        return '<div></div>';
	      }
	    };
	    self.settings.render = Object.assign({}, templates, self.settings.render);
	  }

	  /**
	   * Maps fired events to callbacks provided
	   * in the settings used when creating the control.
	   */
	  setupCallbacks() {
	    var key, fn;
	    var callbacks = {
	      'initialize': 'onInitialize',
	      'change': 'onChange',
	      'item_add': 'onItemAdd',
	      'item_remove': 'onItemRemove',
	      'item_select': 'onItemSelect',
	      'clear': 'onClear',
	      'option_add': 'onOptionAdd',
	      'option_remove': 'onOptionRemove',
	      'option_clear': 'onOptionClear',
	      'optgroup_add': 'onOptionGroupAdd',
	      'optgroup_remove': 'onOptionGroupRemove',
	      'optgroup_clear': 'onOptionGroupClear',
	      'dropdown_open': 'onDropdownOpen',
	      'dropdown_close': 'onDropdownClose',
	      'type': 'onType',
	      'load': 'onLoad',
	      'focus': 'onFocus',
	      'blur': 'onBlur'
	    };
	    for (key in callbacks) {
	      fn = this.settings[callbacks[key]];
	      if (fn) this.on(key, fn);
	    }
	  }

	  /**
	   * Sync the Tom Select instance with the original input or select
	   *
	   */
	  sync(get_settings = true) {
	    const self = this;
	    const settings = get_settings ? getSettings(self.input, {
	      delimiter: self.settings.delimiter
	    }) : self.settings;
	    self.setupOptions(settings.options, settings.optgroups);
	    self.setValue(settings.items || [], true); // silent prevents recursion

	    self.lastQuery = null; // so updated options will be displayed in dropdown
	  }

	  /**
	   * Triggered when the main control element
	   * has a click event.
	   *
	   */
	  onClick() {
	    var self = this;
	    if (self.activeItems.length > 0) {
	      self.clearActiveItems();
	      self.focus();
	      return;
	    }
	    if (self.isFocused && self.isOpen) {
	      self.blur();
	    } else {
	      self.focus();
	    }
	  }

	  /**
	   * @deprecated v1.7
	   *
	   */
	  onMouseDown() {}

	  /**
	   * Triggered when the value of the control has been changed.
	   * This should propagate the event to the original DOM
	   * input / select element.
	   */
	  onChange() {
	    triggerEvent(this.input, 'input');
	    triggerEvent(this.input, 'change');
	  }

	  /**
	   * Triggered on <input> paste.
	   *
	   */
	  onPaste(e) {
	    var self = this;
	    if (self.isInputHidden || self.isLocked) {
	      preventDefault(e);
	      return;
	    }

	    // If a regex or string is included, this will split the pasted
	    // input and create Items for each separate value
	    if (!self.settings.splitOn) {
	      return;
	    }

	    // Wait for pasted text to be recognized in value
	    setTimeout(() => {
	      var pastedText = self.inputValue();
	      if (!pastedText.match(self.settings.splitOn)) {
	        return;
	      }
	      var splitInput = pastedText.trim().split(self.settings.splitOn);
	      iterate$1(splitInput, piece => {
	        const hash = hash_key(piece);
	        if (hash) {
	          if (this.options[piece]) {
	            self.addItem(piece);
	          } else {
	            self.createItem(piece);
	          }
	        }
	      });
	    }, 0);
	  }

	  /**
	   * Triggered on <input> keypress.
	   *
	   */
	  onKeyPress(e) {
	    var self = this;
	    if (self.isLocked) {
	      preventDefault(e);
	      return;
	    }
	    var character = String.fromCharCode(e.keyCode || e.which);
	    if (self.settings.create && self.settings.mode === 'multi' && character === self.settings.delimiter) {
	      self.createItem();
	      preventDefault(e);
	      return;
	    }
	  }

	  /**
	   * Triggered on <input> keydown.
	   *
	   */
	  onKeyDown(e) {
	    var self = this;
	    self.ignoreHover = true;
	    if (self.isLocked) {
	      if (e.keyCode !== KEY_TAB) {
	        preventDefault(e);
	      }
	      return;
	    }
	    switch (e.keyCode) {
	      // ctrl+A: select all
	      case KEY_A:
	        if (isKeyDown(KEY_SHORTCUT, e)) {
	          if (self.control_input.value == '') {
	            preventDefault(e);
	            self.selectAll();
	            return;
	          }
	        }
	        break;

	      // esc: close dropdown
	      case KEY_ESC:
	        if (self.isOpen) {
	          preventDefault(e, true);
	          self.close();
	        }
	        self.clearActiveItems();
	        return;

	      // down: open dropdown or move selection down
	      case KEY_DOWN:
	        if (!self.isOpen && self.hasOptions) {
	          self.open();
	        } else if (self.activeOption) {
	          let next = self.getAdjacent(self.activeOption, 1);
	          if (next) self.setActiveOption(next);
	        }
	        preventDefault(e);
	        return;

	      // up: move selection up
	      case KEY_UP:
	        if (self.activeOption) {
	          let prev = self.getAdjacent(self.activeOption, -1);
	          if (prev) self.setActiveOption(prev);
	        }
	        preventDefault(e);
	        return;

	      // return: select active option
	      case KEY_RETURN:
	        if (self.canSelect(self.activeOption)) {
	          self.onOptionSelect(e, self.activeOption);
	          preventDefault(e);

	          // if the option_create=null, the dropdown might be closed
	        } else if (self.settings.create && self.createItem()) {
	          preventDefault(e);

	          // don't submit form when searching for a value
	        } else if (document.activeElement == self.control_input && self.isOpen) {
	          preventDefault(e);
	        }
	        return;

	      // left: modifiy item selection to the left
	      case KEY_LEFT:
	        self.advanceSelection(-1, e);
	        return;

	      // right: modifiy item selection to the right
	      case KEY_RIGHT:
	        self.advanceSelection(1, e);
	        return;

	      // tab: select active option and/or create item
	      case KEY_TAB:
	        if (self.settings.selectOnTab) {
	          if (self.canSelect(self.activeOption)) {
	            self.onOptionSelect(e, self.activeOption);

	            // prevent default [tab] behaviour of jump to the next field
	            // if select isFull, then the dropdown won't be open and [tab] will work normally
	            preventDefault(e);
	          }
	          if (self.settings.create && self.createItem()) {
	            preventDefault(e);
	          }
	        }
	        return;

	      // delete|backspace: delete items
	      case KEY_BACKSPACE:
	      case KEY_DELETE:
	        self.deleteSelection(e);
	        return;
	    }

	    // don't enter text in the control_input when active items are selected
	    if (self.isInputHidden && !isKeyDown(KEY_SHORTCUT, e)) {
	      preventDefault(e);
	    }
	  }

	  /**
	   * Triggered on <input> keyup.
	   *
	   */
	  onInput(e) {
	    if (this.isLocked) {
	      return;
	    }
	    const value = this.inputValue();
	    if (this.lastValue === value) return;
	    this.lastValue = value;
	    if (value == '') {
	      this._onInput();
	      return;
	    }
	    if (this.refreshTimeout) {
	      clearTimeout(this.refreshTimeout);
	    }
	    this.refreshTimeout = timeout(() => {
	      this.refreshTimeout = null;
	      this._onInput();
	    }, this.settings.refreshThrottle);
	  }
	  _onInput() {
	    const value = this.lastValue;
	    if (this.settings.shouldLoad.call(this, value)) {
	      this.load(value);
	    }
	    this.refreshOptions();
	    this.trigger('type', value);
	  }

	  /**
	   * Triggered when the user rolls over
	   * an option in the autocomplete dropdown menu.
	   *
	   */
	  onOptionHover(evt, option) {
	    if (this.ignoreHover) return;
	    this.setActiveOption(option, false);
	  }

	  /**
	   * Triggered on <input> focus.
	   *
	   */
	  onFocus(e) {
	    var self = this;
	    var wasFocused = self.isFocused;
	    if (self.isDisabled || self.isReadOnly) {
	      self.blur();
	      preventDefault(e);
	      return;
	    }
	    if (self.ignoreFocus) return;
	    self.isFocused = true;
	    if (self.settings.preload === 'focus') self.preload();
	    if (!wasFocused) self.trigger('focus');
	    if (!self.activeItems.length) {
	      self.inputState();
	      self.refreshOptions(!!self.settings.openOnFocus);
	    }
	    self.refreshState();
	  }

	  /**
	   * Triggered on <input> blur.
	   *
	   */
	  onBlur(e) {
	    if (document.hasFocus() === false) return;
	    var self = this;
	    if (!self.isFocused) return;
	    self.isFocused = false;
	    self.ignoreFocus = false;
	    var deactivate = () => {
	      self.close();
	      self.setActiveItem();
	      self.setCaret(self.items.length);
	      self.trigger('blur');
	    };
	    if (self.settings.create && self.settings.createOnBlur) {
	      self.createItem(null, deactivate);
	    } else {
	      deactivate();
	    }
	  }

	  /**
	   * Triggered when the user clicks on an option
	   * in the autocomplete dropdown menu.
	   *
	   */
	  onOptionSelect(evt, option) {
	    var value,
	      self = this;

	    // should not be possible to trigger a option under a disabled optgroup
	    if (option.parentElement && option.parentElement.matches('[data-disabled]')) {
	      return;
	    }
	    if (option.classList.contains('create')) {
	      self.createItem(null, () => {
	        if (self.settings.closeAfterSelect) {
	          self.close();
	        }
	      });
	    } else {
	      value = option.dataset.value;
	      if (typeof value !== 'undefined') {
	        self.lastQuery = null;
	        self.addItem(value);
	        if (self.settings.closeAfterSelect) {
	          self.close();
	        }
	        if (!self.settings.hideSelected && evt.type && /click/.test(evt.type)) {
	          self.setActiveOption(option);
	        }
	      }
	    }
	  }

	  /**
	   * Return true if the given option can be selected
	   *
	   */
	  canSelect(option) {
	    if (this.isOpen && option && this.dropdown_content.contains(option)) {
	      return true;
	    }
	    return false;
	  }

	  /**
	   * Triggered when the user clicks on an item
	   * that has been selected.
	   *
	   */
	  onItemSelect(evt, item) {
	    var self = this;
	    if (!self.isLocked && self.settings.mode === 'multi') {
	      preventDefault(evt);
	      self.setActiveItem(item, evt);
	      return true;
	    }
	    return false;
	  }

	  /**
	   * Determines whether or not to invoke
	   * the user-provided option provider / loader
	   *
	   * Note, there is a subtle difference between
	   * this.canLoad() and this.settings.shouldLoad();
	   *
	   *	- settings.shouldLoad() is a user-input validator.
	   *	When false is returned, the not_loading template
	   *	will be added to the dropdown
	   *
	   *	- canLoad() is lower level validator that checks
	   * 	the Tom Select instance. There is no inherent user
	   *	feedback when canLoad returns false
	   *
	   */
	  canLoad(value) {
	    if (!this.settings.load) return false;
	    if (this.loadedSearches.hasOwnProperty(value)) return false;
	    return true;
	  }

	  /**
	   * Invokes the user-provided option provider / loader.
	   *
	   */
	  load(value) {
	    const self = this;
	    if (!self.canLoad(value)) return;
	    addClasses(self.wrapper, self.settings.loadingClass);
	    self.loading++;
	    const callback = self.loadCallback.bind(self);
	    self.settings.load.call(self, value, callback);
	  }

	  /**
	   * Invoked by the user-provided option provider
	   *
	   */
	  loadCallback(options, optgroups) {
	    const self = this;
	    self.loading = Math.max(self.loading - 1, 0);
	    self.lastQuery = null;
	    self.clearActiveOption(); // when new results load, focus should be on first option
	    self.setupOptions(options, optgroups);
	    self.refreshOptions(self.isFocused && !self.isInputHidden);
	    if (!self.loading) {
	      removeClasses(self.wrapper, self.settings.loadingClass);
	    }
	    self.trigger('load', options, optgroups);
	  }
	  preload() {
	    var classList = this.wrapper.classList;
	    if (classList.contains('preloaded')) return;
	    classList.add('preloaded');
	    this.load('');
	  }

	  /**
	   * Sets the input field of the control to the specified value.
	   *
	   */
	  setTextboxValue(value = '') {
	    var input = this.control_input;
	    var changed = input.value !== value;
	    if (changed) {
	      input.value = value;
	      triggerEvent(input, 'update');
	      this.lastValue = value;
	    }
	  }

	  /**
	   * Returns the value of the control. If multiple items
	   * can be selected (e.g. <select multiple>), this returns
	   * an array. If only one item can be selected, this
	   * returns a string.
	   *
	   */
	  getValue() {
	    if (this.is_select_tag && this.input.hasAttribute('multiple')) {
	      return this.items;
	    }
	    return this.items.join(this.settings.delimiter);
	  }

	  /**
	   * Resets the selected items to the given value.
	   *
	   */
	  setValue(value, silent) {
	    var events = silent ? [] : ['change'];
	    debounce_events(this, events, () => {
	      this.clear(silent);
	      this.addItems(value, silent);
	    });
	  }

	  /**
	   * Resets the number of max items to the given value
	   *
	   */
	  setMaxItems(value) {
	    if (value === 0) value = null; //reset to unlimited items.
	    this.settings.maxItems = value;
	    this.refreshState();
	  }

	  /**
	   * Sets the selected item.
	   *
	   */
	  setActiveItem(item, e) {
	    var self = this;
	    var eventName;
	    var i, begin, end, swap;
	    var last;
	    if (self.settings.mode === 'single') return;

	    // clear the active selection
	    if (!item) {
	      self.clearActiveItems();
	      if (self.isFocused) {
	        self.inputState();
	      }
	      return;
	    }

	    // modify selection
	    eventName = e && e.type.toLowerCase();
	    if (eventName === 'click' && isKeyDown('shiftKey', e) && self.activeItems.length) {
	      last = self.getLastActive();
	      begin = Array.prototype.indexOf.call(self.control.children, last);
	      end = Array.prototype.indexOf.call(self.control.children, item);
	      if (begin > end) {
	        swap = begin;
	        begin = end;
	        end = swap;
	      }
	      for (i = begin; i <= end; i++) {
	        item = self.control.children[i];
	        if (self.activeItems.indexOf(item) === -1) {
	          self.setActiveItemClass(item);
	        }
	      }
	      preventDefault(e);
	    } else if (eventName === 'click' && isKeyDown(KEY_SHORTCUT, e) || eventName === 'keydown' && isKeyDown('shiftKey', e)) {
	      if (item.classList.contains('active')) {
	        self.removeActiveItem(item);
	      } else {
	        self.setActiveItemClass(item);
	      }
	    } else {
	      self.clearActiveItems();
	      self.setActiveItemClass(item);
	    }

	    // ensure control has focus
	    self.inputState();
	    if (!self.isFocused) {
	      self.focus();
	    }
	  }

	  /**
	   * Set the active and last-active classes
	   *
	   */
	  setActiveItemClass(item) {
	    const self = this;
	    const last_active = self.control.querySelector('.last-active');
	    if (last_active) removeClasses(last_active, 'last-active');
	    addClasses(item, 'active last-active');
	    self.trigger('item_select', item);
	    if (self.activeItems.indexOf(item) == -1) {
	      self.activeItems.push(item);
	    }
	  }

	  /**
	   * Remove active item
	   *
	   */
	  removeActiveItem(item) {
	    var idx = this.activeItems.indexOf(item);
	    this.activeItems.splice(idx, 1);
	    removeClasses(item, 'active');
	  }

	  /**
	   * Clears all the active items
	   *
	   */
	  clearActiveItems() {
	    removeClasses(this.activeItems, 'active');
	    this.activeItems = [];
	  }

	  /**
	   * Sets the selected item in the dropdown menu
	   * of available options.
	   *
	   */
	  setActiveOption(option, scroll = true) {
	    if (option === this.activeOption) {
	      return;
	    }
	    this.clearActiveOption();
	    if (!option) return;
	    this.activeOption = option;
	    setAttr(this.focus_node, {
	      'aria-activedescendant': option.getAttribute('id')
	    });
	    setAttr(option, {
	      'aria-selected': 'true'
	    });
	    addClasses(option, 'active');
	    if (scroll) this.scrollToOption(option);
	  }

	  /**
	   * Sets the dropdown_content scrollTop to display the option
	   *
	   */
	  scrollToOption(option, behavior) {
	    if (!option) return;
	    const content = this.dropdown_content;
	    const height_menu = content.clientHeight;
	    const scrollTop = content.scrollTop || 0;
	    const height_item = option.offsetHeight;
	    const y = option.getBoundingClientRect().top - content.getBoundingClientRect().top + scrollTop;
	    if (y + height_item > height_menu + scrollTop) {
	      this.scroll(y - height_menu + height_item, behavior);
	    } else if (y < scrollTop) {
	      this.scroll(y, behavior);
	    }
	  }

	  /**
	   * Scroll the dropdown to the given position
	   *
	   */
	  scroll(scrollTop, behavior) {
	    const content = this.dropdown_content;
	    if (behavior) {
	      content.style.scrollBehavior = behavior;
	    }
	    content.scrollTop = scrollTop;
	    content.style.scrollBehavior = '';
	  }

	  /**
	   * Clears the active option
	   *
	   */
	  clearActiveOption() {
	    if (this.activeOption) {
	      removeClasses(this.activeOption, 'active');
	      setAttr(this.activeOption, {
	        'aria-selected': null
	      });
	    }
	    this.activeOption = null;
	    setAttr(this.focus_node, {
	      'aria-activedescendant': null
	    });
	  }

	  /**
	   * Selects all items (CTRL + A).
	   */
	  selectAll() {
	    const self = this;
	    if (self.settings.mode === 'single') return;
	    const activeItems = self.controlChildren();
	    if (!activeItems.length) return;
	    self.inputState();
	    self.close();
	    self.activeItems = activeItems;
	    iterate$1(activeItems, item => {
	      self.setActiveItemClass(item);
	    });
	  }

	  /**
	   * Determines if the control_input should be in a hidden or visible state
	   *
	   */
	  inputState() {
	    var self = this;
	    if (!self.control.contains(self.control_input)) return;
	    setAttr(self.control_input, {
	      placeholder: self.settings.placeholder
	    });
	    if (self.activeItems.length > 0 || !self.isFocused && self.settings.hidePlaceholder && self.items.length > 0) {
	      self.setTextboxValue();
	      self.isInputHidden = true;
	    } else {
	      if (self.settings.hidePlaceholder && self.items.length > 0) {
	        setAttr(self.control_input, {
	          placeholder: ''
	        });
	      }
	      self.isInputHidden = false;
	    }
	    self.wrapper.classList.toggle('input-hidden', self.isInputHidden);
	  }

	  /**
	   * Get the input value
	   */
	  inputValue() {
	    return this.control_input.value.trim();
	  }

	  /**
	   * Gives the control focus.
	   */
	  focus() {
	    var self = this;
	    if (self.isDisabled || self.isReadOnly) return;
	    self.ignoreFocus = true;
	    if (self.control_input.offsetWidth) {
	      self.control_input.focus();
	    } else {
	      self.focus_node.focus();
	    }
	    setTimeout(() => {
	      self.ignoreFocus = false;
	      self.onFocus();
	    }, 0);
	  }

	  /**
	   * Forces the control out of focus.
	   *
	   */
	  blur() {
	    this.focus_node.blur();
	    this.onBlur();
	  }

	  /**
	   * Returns a function that scores an object
	   * to show how good of a match it is to the
	   * provided query.
	   *
	   * @return {function}
	   */
	  getScoreFunction(query) {
	    return this.sifter.getScoreFunction(query, this.getSearchOptions());
	  }

	  /**
	   * Returns search options for sifter (the system
	   * for scoring and sorting results).
	   *
	   * @see https://github.com/orchidjs/sifter.js
	   * @return {object}
	   */
	  getSearchOptions() {
	    var settings = this.settings;
	    var sort = settings.sortField;
	    if (typeof settings.sortField === 'string') {
	      sort = [{
	        field: settings.sortField
	      }];
	    }
	    return {
	      fields: settings.searchField,
	      conjunction: settings.searchConjunction,
	      sort: sort,
	      nesting: settings.nesting
	    };
	  }

	  /**
	   * Searches through available options and returns
	   * a sorted array of matches.
	   *
	   */
	  search(query) {
	    var result, calculateScore;
	    var self = this;
	    var options = this.getSearchOptions();

	    // validate user-provided result scoring function
	    if (self.settings.score) {
	      calculateScore = self.settings.score.call(self, query);
	      if (typeof calculateScore !== 'function') {
	        throw new Error('Tom Select "score" setting must be a function that returns a function');
	      }
	    }

	    // perform search
	    if (query !== self.lastQuery) {
	      self.lastQuery = query;
	      result = self.sifter.search(query, Object.assign(options, {
	        score: calculateScore
	      }));
	      self.currentResults = result;
	    } else {
	      result = Object.assign({}, self.currentResults);
	    }

	    // filter out selected items
	    if (self.settings.hideSelected) {
	      result.items = result.items.filter(item => {
	        let hashed = hash_key(item.id);
	        return !(hashed && self.items.indexOf(hashed) !== -1);
	      });
	    }
	    return result;
	  }

	  /**
	   * Refreshes the list of available options shown
	   * in the autocomplete dropdown menu.
	   *
	   */
	  refreshOptions(triggerDropdown = true) {
	    var i, j, k, n, optgroup, optgroups, html, has_create_option, active_group;
	    var create;
	    const groups = {};
	    const groups_order = [];
	    var self = this;
	    var query = self.inputValue();
	    const same_query = query === self.lastQuery || query == '' && self.lastQuery == null;
	    var results = self.search(query);
	    var active_option = null;
	    var show_dropdown = self.settings.shouldOpen || false;
	    var dropdown_content = self.dropdown_content;
	    if (same_query) {
	      active_option = self.activeOption;
	      if (active_option) {
	        active_group = active_option.closest('[data-group]');
	      }
	    }

	    // build markup
	    n = results.items.length;
	    if (typeof self.settings.maxOptions === 'number') {
	      n = Math.min(n, self.settings.maxOptions);
	    }
	    if (n > 0) {
	      show_dropdown = true;
	    }

	    // get fragment for group and the position of the group in group_order
	    const getGroupFragment = (optgroup, order) => {
	      let group_order_i = groups[optgroup];
	      if (group_order_i !== undefined) {
	        let order_group = groups_order[group_order_i];
	        if (order_group !== undefined) {
	          return [group_order_i, order_group.fragment];
	        }
	      }
	      let group_fragment = document.createDocumentFragment();
	      group_order_i = groups_order.length;
	      groups_order.push({
	        fragment: group_fragment,
	        order,
	        optgroup
	      });
	      return [group_order_i, group_fragment];
	    };

	    // render and group available options individually
	    for (i = 0; i < n; i++) {
	      // get option dom element
	      let item = results.items[i];
	      if (!item) continue;
	      let opt_value = item.id;
	      let option = self.options[opt_value];
	      if (option === undefined) continue;
	      let opt_hash = get_hash(opt_value);
	      let option_el = self.getOption(opt_hash, true);

	      // toggle 'selected' class
	      if (!self.settings.hideSelected) {
	        option_el.classList.toggle('selected', self.items.includes(opt_hash));
	      }
	      optgroup = option[self.settings.optgroupField] || '';
	      optgroups = Array.isArray(optgroup) ? optgroup : [optgroup];
	      for (j = 0, k = optgroups && optgroups.length; j < k; j++) {
	        optgroup = optgroups[j];
	        let order = option.$order;
	        let self_optgroup = self.optgroups[optgroup];
	        if (self_optgroup === undefined) {
	          optgroup = '';
	        } else {
	          order = self_optgroup.$order;
	        }
	        const [group_order_i, group_fragment] = getGroupFragment(optgroup, order);

	        // nodes can only have one parent, so if the option is in mutple groups, we need a clone
	        if (j > 0) {
	          option_el = option_el.cloneNode(true);
	          setAttr(option_el, {
	            id: option.$id + '-clone-' + j,
	            'aria-selected': null
	          });
	          option_el.classList.add('ts-cloned');
	          removeClasses(option_el, 'active');

	          // make sure we keep the activeOption in the same group
	          if (self.activeOption && self.activeOption.dataset.value == opt_value) {
	            if (active_group && active_group.dataset.group === optgroup.toString()) {
	              active_option = option_el;
	            }
	          }
	        }
	        group_fragment.appendChild(option_el);
	        if (optgroup != '') {
	          groups[optgroup] = group_order_i;
	        }
	      }
	    }

	    // sort optgroups
	    if (self.settings.lockOptgroupOrder) {
	      groups_order.sort((a, b) => {
	        return a.order - b.order;
	      });
	    }

	    // render optgroup headers & join groups
	    html = document.createDocumentFragment();
	    iterate$1(groups_order, group_order => {
	      let group_fragment = group_order.fragment;
	      let optgroup = group_order.optgroup;
	      if (!group_fragment || !group_fragment.children.length) return;
	      let group_heading = self.optgroups[optgroup];
	      if (group_heading !== undefined) {
	        let group_options = document.createDocumentFragment();
	        let header = self.render('optgroup_header', group_heading);
	        append(group_options, header);
	        append(group_options, group_fragment);
	        let group_html = self.render('optgroup', {
	          group: group_heading,
	          options: group_options
	        });
	        append(html, group_html);
	      } else {
	        append(html, group_fragment);
	      }
	    });
	    dropdown_content.innerHTML = '';
	    append(dropdown_content, html);

	    // highlight matching terms inline
	    if (self.settings.highlight) {
	      removeHighlight(dropdown_content);
	      if (results.query.length && results.tokens.length) {
	        iterate$1(results.tokens, tok => {
	          highlight(dropdown_content, tok.regex);
	        });
	      }
	    }

	    // helper method for adding templates to dropdown
	    var add_template = template => {
	      let content = self.render(template, {
	        input: query
	      });
	      if (content) {
	        show_dropdown = true;
	        dropdown_content.insertBefore(content, dropdown_content.firstChild);
	      }
	      return content;
	    };

	    // add loading message
	    if (self.loading) {
	      add_template('loading');

	      // invalid query
	    } else if (!self.settings.shouldLoad.call(self, query)) {
	      add_template('not_loading');

	      // add no_results message
	    } else if (results.items.length === 0) {
	      add_template('no_results');
	    }

	    // add create option
	    has_create_option = self.canCreate(query);
	    if (has_create_option) {
	      create = add_template('option_create');
	    }

	    // activate
	    self.hasOptions = results.items.length > 0 || has_create_option;
	    if (show_dropdown) {
	      if (results.items.length > 0) {
	        if (!active_option && self.settings.mode === 'single' && self.items[0] != undefined) {
	          active_option = self.getOption(self.items[0]);
	        }
	        if (!dropdown_content.contains(active_option)) {
	          let active_index = 0;
	          if (create && !self.settings.addPrecedence) {
	            active_index = 1;
	          }
	          active_option = self.selectable()[active_index];
	        }
	      } else if (create) {
	        active_option = create;
	      }
	      if (triggerDropdown && !self.isOpen) {
	        self.open();
	        self.scrollToOption(active_option, 'auto');
	      }
	      self.setActiveOption(active_option);
	    } else {
	      self.clearActiveOption();
	      if (triggerDropdown && self.isOpen) {
	        self.close(false); // if create_option=null, we want the dropdown to close but not reset the textbox value
	      }
	    }
	  }

	  /**
	   * Return list of selectable options
	   *
	   */
	  selectable() {
	    return this.dropdown_content.querySelectorAll('[data-selectable]');
	  }

	  /**
	   * Adds an available option. If it already exists,
	   * nothing will happen. Note: this does not refresh
	   * the options list dropdown (use `refreshOptions`
	   * for that).
	   *
	   * Usage:
	   *
	   *   this.addOption(data)
	   *
	   */
	  addOption(data, user_created = false) {
	    const self = this;

	    // @deprecated 1.7.7
	    // use addOptions( array, user_created ) for adding multiple options
	    if (Array.isArray(data)) {
	      self.addOptions(data, user_created);
	      return false;
	    }
	    const key = hash_key(data[self.settings.valueField]);
	    if (key === null || self.options.hasOwnProperty(key)) {
	      return false;
	    }
	    data.$order = data.$order || ++self.order;
	    data.$id = self.inputId + '-opt-' + data.$order;
	    self.options[key] = data;
	    self.lastQuery = null;
	    if (user_created) {
	      self.userOptions[key] = user_created;
	      self.trigger('option_add', key, data);
	    }
	    return key;
	  }

	  /**
	   * Add multiple options
	   *
	   */
	  addOptions(data, user_created = false) {
	    iterate$1(data, dat => {
	      this.addOption(dat, user_created);
	    });
	  }

	  /**
	   * @deprecated 1.7.7
	   */
	  registerOption(data) {
	    return this.addOption(data);
	  }

	  /**
	   * Registers an option group to the pool of option groups.
	   *
	   * @return {boolean|string}
	   */
	  registerOptionGroup(data) {
	    var key = hash_key(data[this.settings.optgroupValueField]);
	    if (key === null) return false;
	    data.$order = data.$order || ++this.order;
	    this.optgroups[key] = data;
	    return key;
	  }

	  /**
	   * Registers a new optgroup for options
	   * to be bucketed into.
	   *
	   */
	  addOptionGroup(id, data) {
	    var hashed_id;
	    data[this.settings.optgroupValueField] = id;
	    if (hashed_id = this.registerOptionGroup(data)) {
	      this.trigger('optgroup_add', hashed_id, data);
	    }
	  }

	  /**
	   * Removes an existing option group.
	   *
	   */
	  removeOptionGroup(id) {
	    if (this.optgroups.hasOwnProperty(id)) {
	      delete this.optgroups[id];
	      this.clearCache();
	      this.trigger('optgroup_remove', id);
	    }
	  }

	  /**
	   * Clears all existing option groups.
	   */
	  clearOptionGroups() {
	    this.optgroups = {};
	    this.clearCache();
	    this.trigger('optgroup_clear');
	  }

	  /**
	   * Updates an option available for selection. If
	   * it is visible in the selected items or options
	   * dropdown, it will be re-rendered automatically.
	   *
	   */
	  updateOption(value, data) {
	    const self = this;
	    var item_new;
	    var index_item;
	    const value_old = hash_key(value);
	    const value_new = hash_key(data[self.settings.valueField]);

	    // sanity checks
	    if (value_old === null) return;
	    const data_old = self.options[value_old];
	    if (data_old == undefined) return;
	    if (typeof value_new !== 'string') throw new Error('Value must be set in option data');
	    const option = self.getOption(value_old);
	    const item = self.getItem(value_old);
	    data.$order = data.$order || data_old.$order;
	    delete self.options[value_old];

	    // invalidate render cache
	    // don't remove existing node yet, we'll remove it after replacing it
	    self.uncacheValue(value_new);
	    self.options[value_new] = data;

	    // update the option if it's in the dropdown
	    if (option) {
	      if (self.dropdown_content.contains(option)) {
	        const option_new = self._render('option', data);
	        replaceNode(option, option_new);
	        if (self.activeOption === option) {
	          self.setActiveOption(option_new);
	        }
	      }
	      option.remove();
	    }

	    // update the item if we have one
	    if (item) {
	      index_item = self.items.indexOf(value_old);
	      if (index_item !== -1) {
	        self.items.splice(index_item, 1, value_new);
	      }
	      item_new = self._render('item', data);
	      if (item.classList.contains('active')) addClasses(item_new, 'active');
	      replaceNode(item, item_new);
	    }

	    // invalidate last query because we might have updated the sortField
	    self.lastQuery = null;
	  }

	  /**
	   * Removes a single option.
	   *
	   */
	  removeOption(value, silent) {
	    const self = this;
	    value = get_hash(value);
	    self.uncacheValue(value);
	    delete self.userOptions[value];
	    delete self.options[value];
	    self.lastQuery = null;
	    self.trigger('option_remove', value);
	    self.removeItem(value, silent);
	  }

	  /**
	   * Clears all options.
	   */
	  clearOptions(filter) {
	    const boundFilter = (filter || this.clearFilter).bind(this);
	    this.loadedSearches = {};
	    this.userOptions = {};
	    this.clearCache();
	    const selected = {};
	    iterate$1(this.options, (option, key) => {
	      if (boundFilter(option, key)) {
	        selected[key] = option;
	      }
	    });
	    this.options = this.sifter.items = selected;
	    this.lastQuery = null;
	    this.trigger('option_clear');
	  }

	  /**
	   * Used by clearOptions() to decide whether or not an option should be removed
	   * Return true to keep an option, false to remove
	   *
	   */
	  clearFilter(option, value) {
	    if (this.items.indexOf(value) >= 0) {
	      return true;
	    }
	    return false;
	  }

	  /**
	   * Returns the dom element of the option
	   * matching the given value.
	   *
	   */
	  getOption(value, create = false) {
	    const hashed = hash_key(value);
	    if (hashed === null) return null;
	    const option = this.options[hashed];
	    if (option != undefined) {
	      if (option.$div) {
	        return option.$div;
	      }
	      if (create) {
	        return this._render('option', option);
	      }
	    }
	    return null;
	  }

	  /**
	   * Returns the dom element of the next or previous dom element of the same type
	   * Note: adjacent options may not be adjacent DOM elements (optgroups)
	   *
	   */
	  getAdjacent(option, direction, type = 'option') {
	    var self = this,
	      all;
	    if (!option) {
	      return null;
	    }
	    if (type == 'item') {
	      all = self.controlChildren();
	    } else {
	      all = self.dropdown_content.querySelectorAll('[data-selectable]');
	    }
	    for (let i = 0; i < all.length; i++) {
	      if (all[i] != option) {
	        continue;
	      }
	      if (direction > 0) {
	        return all[i + 1];
	      }
	      return all[i - 1];
	    }
	    return null;
	  }

	  /**
	   * Returns the dom element of the item
	   * matching the given value.
	   *
	   */
	  getItem(item) {
	    if (typeof item == 'object') {
	      return item;
	    }
	    var value = hash_key(item);
	    return value !== null ? this.control.querySelector(`[data-value="${addSlashes(value)}"]`) : null;
	  }

	  /**
	   * "Selects" multiple items at once. Adds them to the list
	   * at the current caret position.
	   *
	   */
	  addItems(values, silent) {
	    var self = this;
	    var items = Array.isArray(values) ? values : [values];
	    items = items.filter(x => self.items.indexOf(x) === -1);
	    const last_item = items[items.length - 1];
	    items.forEach(item => {
	      self.isPending = item !== last_item;
	      self.addItem(item, silent);
	    });
	  }

	  /**
	   * "Selects" an item. Adds it to the list
	   * at the current caret position.
	   *
	   */
	  addItem(value, silent) {
	    var events = silent ? [] : ['change', 'dropdown_close'];
	    debounce_events(this, events, () => {
	      var item, wasFull;
	      const self = this;
	      const inputMode = self.settings.mode;
	      const hashed = hash_key(value);
	      if (hashed && self.items.indexOf(hashed) !== -1) {
	        if (inputMode === 'single') {
	          self.close();
	        }
	        if (inputMode === 'single' || !self.settings.duplicates) {
	          return;
	        }
	      }
	      if (hashed === null || !self.options.hasOwnProperty(hashed)) return;
	      if (inputMode === 'single') self.clear(silent);
	      if (inputMode === 'multi' && self.isFull()) return;
	      item = self._render('item', self.options[hashed]);
	      if (self.control.contains(item)) {
	        // duplicates
	        item = item.cloneNode(true);
	      }
	      wasFull = self.isFull();
	      self.items.splice(self.caretPos, 0, hashed);
	      self.insertAtCaret(item);
	      if (self.isSetup) {
	        // update menu / remove the option (if this is not one item being added as part of series)
	        if (!self.isPending && self.settings.hideSelected) {
	          let option = self.getOption(hashed);
	          let next = self.getAdjacent(option, 1);
	          if (next) {
	            self.setActiveOption(next);
	          }
	        }

	        // refreshOptions after setActiveOption(),
	        // otherwise setActiveOption() will be called by refreshOptions() with the wrong value
	        if (!self.isPending && !self.settings.closeAfterSelect) {
	          self.refreshOptions(self.isFocused && inputMode !== 'single');
	        }

	        // hide the menu if the maximum number of items have been selected or no options are left
	        if (self.settings.closeAfterSelect != false && self.isFull()) {
	          self.close();
	        } else if (!self.isPending) {
	          self.positionDropdown();
	        }
	        self.trigger('item_add', hashed, item);
	        if (!self.isPending) {
	          self.updateOriginalInput({
	            silent: silent
	          });
	        }
	      }
	      if (!self.isPending || !wasFull && self.isFull()) {
	        self.inputState();
	        self.refreshState();
	      }
	    });
	  }

	  /**
	   * Removes the selected item matching
	   * the provided value.
	   *
	   */
	  removeItem(item = null, silent) {
	    const self = this;
	    item = self.getItem(item);
	    if (!item) return;
	    var i, idx;
	    const value = item.dataset.value;
	    i = nodeIndex(item);
	    item.remove();
	    if (item.classList.contains('active')) {
	      idx = self.activeItems.indexOf(item);
	      self.activeItems.splice(idx, 1);
	      removeClasses(item, 'active');
	    }
	    self.items.splice(i, 1);
	    self.lastQuery = null;
	    if (!self.settings.persist && self.userOptions.hasOwnProperty(value)) {
	      self.removeOption(value, silent);
	    }
	    if (i < self.caretPos) {
	      self.setCaret(self.caretPos - 1);
	    }
	    self.updateOriginalInput({
	      silent: silent
	    });
	    self.refreshState();
	    self.positionDropdown();
	    self.trigger('item_remove', value, item);
	  }

	  /**
	   * Invokes the `create` method provided in the
	   * TomSelect options that should provide the data
	   * for the new item, given the user input.
	   *
	   * Once this completes, it will be added
	   * to the item list.
	   *
	   */
	  createItem(input = null, callback = () => {}) {
	    // triggerDropdown parameter @deprecated 2.1.1
	    if (arguments.length === 3) {
	      callback = arguments[2];
	    }
	    if (typeof callback != 'function') {
	      callback = () => {};
	    }
	    var self = this;
	    var caret = self.caretPos;
	    var output;
	    input = input || self.inputValue();
	    if (!self.canCreate(input)) {
	      callback();
	      return false;
	    }
	    self.lock();
	    var created = false;
	    var create = data => {
	      self.unlock();
	      if (!data || typeof data !== 'object') return callback();
	      var value = hash_key(data[self.settings.valueField]);
	      if (typeof value !== 'string') {
	        return callback();
	      }
	      self.setTextboxValue();
	      self.addOption(data, true);
	      self.setCaret(caret);
	      self.addItem(value);
	      callback(data);
	      created = true;
	    };
	    if (typeof self.settings.create === 'function') {
	      output = self.settings.create.call(this, input, create);
	    } else {
	      output = {
	        [self.settings.labelField]: input,
	        [self.settings.valueField]: input
	      };
	    }
	    if (!created) {
	      create(output);
	    }
	    return true;
	  }

	  /**
	   * Re-renders the selected item lists.
	   */
	  refreshItems() {
	    var self = this;
	    self.lastQuery = null;
	    if (self.isSetup) {
	      self.addItems(self.items);
	    }
	    self.updateOriginalInput();
	    self.refreshState();
	  }

	  /**
	   * Updates all state-dependent attributes
	   * and CSS classes.
	   */
	  refreshState() {
	    const self = this;
	    self.refreshValidityState();
	    const isFull = self.isFull();
	    const isLocked = self.isLocked;
	    self.wrapper.classList.toggle('rtl', self.rtl);
	    const wrap_classList = self.wrapper.classList;
	    wrap_classList.toggle('focus', self.isFocused);
	    wrap_classList.toggle('disabled', self.isDisabled);
	    wrap_classList.toggle('readonly', self.isReadOnly);
	    wrap_classList.toggle('required', self.isRequired);
	    wrap_classList.toggle('invalid', !self.isValid);
	    wrap_classList.toggle('locked', isLocked);
	    wrap_classList.toggle('full', isFull);
	    wrap_classList.toggle('input-active', self.isFocused && !self.isInputHidden);
	    wrap_classList.toggle('dropdown-active', self.isOpen);
	    wrap_classList.toggle('has-options', isEmptyObject(self.options));
	    wrap_classList.toggle('has-items', self.items.length > 0);
	  }

	  /**
	   * Update the `required` attribute of both input and control input.
	   *
	   * The `required` property needs to be activated on the control input
	   * for the error to be displayed at the right place. `required` also
	   * needs to be temporarily deactivated on the input since the input is
	   * hidden and can't show errors.
	   */
	  refreshValidityState() {
	    var self = this;
	    if (!self.input.validity) {
	      return;
	    }
	    self.isValid = self.input.validity.valid;
	    self.isInvalid = !self.isValid;
	  }

	  /**
	   * Determines whether or not more items can be added
	   * to the control without exceeding the user-defined maximum.
	   *
	   * @returns {boolean}
	   */
	  isFull() {
	    return this.settings.maxItems !== null && this.items.length >= this.settings.maxItems;
	  }

	  /**
	   * Refreshes the original <select> or <input>
	   * element to reflect the current state.
	   *
	   */
	  updateOriginalInput(opts = {}) {
	    const self = this;
	    var option, label;
	    const empty_option = self.input.querySelector('option[value=""]');
	    if (self.is_select_tag) {
	      const selected = [];
	      const has_selected = self.input.querySelectorAll('option:checked').length;
	      function AddSelected(option_el, value, label) {
	        if (!option_el) {
	          option_el = getDom('<option value="' + escape_html(value) + '">' + escape_html(label) + '</option>');
	        }

	        // don't move empty option from top of list
	        // fixes bug in firefox https://bugzilla.mozilla.org/show_bug.cgi?id=1725293
	        if (option_el != empty_option) {
	          self.input.append(option_el);
	        }
	        selected.push(option_el);

	        // marking empty option as selected can break validation
	        // fixes https://github.com/orchidjs/tom-select/issues/303
	        if (option_el != empty_option || has_selected > 0) {
	          option_el.selected = true;
	        }
	        return option_el;
	      }

	      // unselect all selected options
	      self.input.querySelectorAll('option:checked').forEach(option_el => {
	        option_el.selected = false;
	      });

	      // nothing selected?
	      if (self.items.length == 0 && self.settings.mode == 'single') {
	        AddSelected(empty_option, "", "");

	        // order selected <option> tags for values in self.items
	      } else {
	        self.items.forEach(value => {
	          option = self.options[value];
	          label = option[self.settings.labelField] || '';
	          if (selected.includes(option.$option)) {
	            const reuse_opt = self.input.querySelector(`option[value="${addSlashes(value)}"]:not(:checked)`);
	            AddSelected(reuse_opt, value, label);
	          } else {
	            option.$option = AddSelected(option.$option, value, label);
	          }
	        });
	      }
	    } else {
	      self.input.value = self.getValue();
	    }
	    if (self.isSetup) {
	      if (!opts.silent) {
	        self.trigger('change', self.getValue());
	      }
	    }
	  }

	  /**
	   * Shows the autocomplete dropdown containing
	   * the available options.
	   */
	  open() {
	    var self = this;
	    if (self.isLocked || self.isOpen || self.settings.mode === 'multi' && self.isFull()) return;
	    self.isOpen = true;
	    setAttr(self.focus_node, {
	      'aria-expanded': 'true'
	    });
	    self.refreshState();
	    applyCSS(self.dropdown, {
	      visibility: 'hidden',
	      display: 'block'
	    });
	    self.positionDropdown();
	    applyCSS(self.dropdown, {
	      visibility: 'visible',
	      display: 'block'
	    });
	    self.focus();
	    self.trigger('dropdown_open', self.dropdown);
	  }

	  /**
	   * Closes the autocomplete dropdown menu.
	   */
	  close(setTextboxValue = true) {
	    var self = this;
	    var trigger = self.isOpen;
	    if (setTextboxValue) {
	      // before blur() to prevent form onchange event
	      self.setTextboxValue();
	      if (self.settings.mode === 'single' && self.items.length) {
	        self.inputState();
	      }
	    }
	    self.isOpen = false;
	    setAttr(self.focus_node, {
	      'aria-expanded': 'false'
	    });
	    applyCSS(self.dropdown, {
	      display: 'none'
	    });
	    if (self.settings.hideSelected) {
	      self.clearActiveOption();
	    }
	    self.refreshState();
	    if (trigger) self.trigger('dropdown_close', self.dropdown);
	  }

	  /**
	   * Calculates and applies the appropriate
	   * position of the dropdown if dropdownParent = 'body'.
	   * Otherwise, position is determined by css
	   */
	  positionDropdown() {
	    if (this.settings.dropdownParent !== 'body') {
	      return;
	    }
	    var context = this.control;
	    var rect = context.getBoundingClientRect();
	    var top = context.offsetHeight + rect.top + window.scrollY;
	    var left = rect.left + window.scrollX;
	    applyCSS(this.dropdown, {
	      width: rect.width + 'px',
	      top: top + 'px',
	      left: left + 'px'
	    });
	  }

	  /**
	   * Resets / clears all selected items
	   * from the control.
	   *
	   */
	  clear(silent) {
	    var self = this;
	    if (!self.items.length) return;
	    var items = self.controlChildren();
	    iterate$1(items, item => {
	      self.removeItem(item, true);
	    });
	    self.inputState();
	    if (!silent) self.updateOriginalInput();
	    self.trigger('clear');
	  }

	  /**
	   * A helper method for inserting an element
	   * at the current caret position.
	   *
	   */
	  insertAtCaret(el) {
	    const self = this;
	    const caret = self.caretPos;
	    const target = self.control;
	    target.insertBefore(el, target.children[caret] || null);
	    self.setCaret(caret + 1);
	  }

	  /**
	   * Removes the current selected item(s).
	   *
	   */
	  deleteSelection(e) {
	    var direction, selection, caret, tail;
	    var self = this;
	    direction = e && e.keyCode === KEY_BACKSPACE ? -1 : 1;
	    selection = getSelection(self.control_input);

	    // determine items that will be removed
	    const rm_items = [];
	    if (self.activeItems.length) {
	      tail = getTail(self.activeItems, direction);
	      caret = nodeIndex(tail);
	      if (direction > 0) {
	        caret++;
	      }
	      iterate$1(self.activeItems, item => rm_items.push(item));
	    } else if ((self.isFocused || self.settings.mode === 'single') && self.items.length) {
	      const items = self.controlChildren();
	      let rm_item;
	      if (direction < 0 && selection.start === 0 && selection.length === 0) {
	        rm_item = items[self.caretPos - 1];
	      } else if (direction > 0 && selection.start === self.inputValue().length) {
	        rm_item = items[self.caretPos];
	      }
	      if (rm_item !== undefined) {
	        rm_items.push(rm_item);
	      }
	    }
	    if (!self.shouldDelete(rm_items, e)) {
	      return false;
	    }
	    preventDefault(e, true);

	    // perform removal
	    if (typeof caret !== 'undefined') {
	      self.setCaret(caret);
	    }
	    while (rm_items.length) {
	      self.removeItem(rm_items.pop());
	    }
	    self.inputState();
	    self.positionDropdown();
	    self.refreshOptions(false);
	    return true;
	  }

	  /**
	   * Return true if the items should be deleted
	   */
	  shouldDelete(items, evt) {
	    const values = items.map(item => item.dataset.value);

	    // allow the callback to abort
	    if (!values.length || typeof this.settings.onDelete === 'function' && this.settings.onDelete(values, evt) === false) {
	      return false;
	    }
	    return true;
	  }

	  /**
	   * Selects the previous / next item (depending on the `direction` argument).
	   *
	   * > 0 - right
	   * < 0 - left
	   *
	   */
	  advanceSelection(direction, e) {
	    var last_active,
	      adjacent,
	      self = this;
	    if (self.rtl) direction *= -1;
	    if (self.inputValue().length) return;

	    // add or remove to active items
	    if (isKeyDown(KEY_SHORTCUT, e) || isKeyDown('shiftKey', e)) {
	      last_active = self.getLastActive(direction);
	      if (last_active) {
	        if (!last_active.classList.contains('active')) {
	          adjacent = last_active;
	        } else {
	          adjacent = self.getAdjacent(last_active, direction, 'item');
	        }

	        // if no active item, get items adjacent to the control input
	      } else if (direction > 0) {
	        adjacent = self.control_input.nextElementSibling;
	      } else {
	        adjacent = self.control_input.previousElementSibling;
	      }
	      if (adjacent) {
	        if (adjacent.classList.contains('active')) {
	          self.removeActiveItem(last_active);
	        }
	        self.setActiveItemClass(adjacent); // mark as last_active !! after removeActiveItem() on last_active
	      }

	      // move caret to the left or right
	    } else {
	      self.moveCaret(direction);
	    }
	  }
	  moveCaret(direction) {}

	  /**
	   * Get the last active item
	   *
	   */
	  getLastActive(direction) {
	    let last_active = this.control.querySelector('.last-active');
	    if (last_active) {
	      return last_active;
	    }
	    var result = this.control.querySelectorAll('.active');
	    if (result) {
	      return getTail(result, direction);
	    }
	  }

	  /**
	   * Moves the caret to the specified index.
	   *
	   * The input must be moved by leaving it in place and moving the
	   * siblings, due to the fact that focus cannot be restored once lost
	   * on mobile webkit devices
	   *
	   */
	  setCaret(new_pos) {
	    this.caretPos = this.items.length;
	  }

	  /**
	   * Return list of item dom elements
	   *
	   */
	  controlChildren() {
	    return Array.from(this.control.querySelectorAll('[data-ts-item]'));
	  }

	  /**
	   * Disables user input on the control. Used while
	   * items are being asynchronously created.
	   */
	  lock() {
	    this.setLocked(true);
	  }

	  /**
	   * Re-enables user input on the control.
	   */
	  unlock() {
	    this.setLocked(false);
	  }

	  /**
	   * Disable or enable user input on the control
	   */
	  setLocked(lock = this.isReadOnly || this.isDisabled) {
	    this.isLocked = lock;
	    this.refreshState();
	  }

	  /**
	   * Disables user input on the control completely.
	   * While disabled, it cannot receive focus.
	   */
	  disable() {
	    this.setDisabled(true);
	    this.close();
	  }

	  /**
	   * Enables the control so that it can respond
	   * to focus and user input.
	   */
	  enable() {
	    this.setDisabled(false);
	  }
	  setDisabled(disabled) {
	    this.focus_node.tabIndex = disabled ? -1 : this.tabIndex;
	    this.isDisabled = disabled;
	    this.input.disabled = disabled;
	    this.control_input.disabled = disabled;
	    this.setLocked();
	  }
	  setReadOnly(isReadOnly) {
	    this.isReadOnly = isReadOnly;
	    this.input.readOnly = isReadOnly;
	    this.control_input.readOnly = isReadOnly;
	    this.setLocked();
	  }

	  /**
	   * Completely destroys the control and
	   * unbinds all event listeners so that it can
	   * be garbage collected.
	   */
	  destroy() {
	    var self = this;
	    var revertSettings = self.revertSettings;
	    self.trigger('destroy');
	    self.off();
	    self.wrapper.remove();
	    self.dropdown.remove();
	    self.input.innerHTML = revertSettings.innerHTML;
	    self.input.tabIndex = revertSettings.tabIndex;
	    removeClasses(self.input, 'tomselected', 'ts-hidden-accessible');
	    self._destroy();
	    delete self.input.tomselect;
	  }

	  /**
	   * A helper method for rendering "item" and
	   * "option" templates, given the data.
	   *
	   */
	  render(templateName, data) {
	    var id, html;
	    const self = this;
	    if (typeof this.settings.render[templateName] !== 'function') {
	      return null;
	    }

	    // render markup
	    html = self.settings.render[templateName].call(this, data, escape_html);
	    if (!html) {
	      return null;
	    }
	    html = getDom(html);

	    // add mandatory attributes
	    if (templateName === 'option' || templateName === 'option_create') {
	      if (data[self.settings.disabledField]) {
	        setAttr(html, {
	          'aria-disabled': 'true'
	        });
	      } else {
	        setAttr(html, {
	          'data-selectable': ''
	        });
	      }
	    } else if (templateName === 'optgroup') {
	      id = data.group[self.settings.optgroupValueField];
	      setAttr(html, {
	        'data-group': id
	      });
	      if (data.group[self.settings.disabledField]) {
	        setAttr(html, {
	          'data-disabled': ''
	        });
	      }
	    }
	    if (templateName === 'option' || templateName === 'item') {
	      const value = get_hash(data[self.settings.valueField]);
	      setAttr(html, {
	        'data-value': value
	      });

	      // make sure we have some classes if a template is overwritten
	      if (templateName === 'item') {
	        addClasses(html, self.settings.itemClass);
	        setAttr(html, {
	          'data-ts-item': ''
	        });
	      } else {
	        addClasses(html, self.settings.optionClass);
	        setAttr(html, {
	          role: 'option',
	          id: data.$id
	        });

	        // update cache
	        data.$div = html;
	        self.options[value] = data;
	      }
	    }
	    return html;
	  }

	  /**
	   * Type guarded rendering
	   *
	   */
	  _render(templateName, data) {
	    const html = this.render(templateName, data);
	    if (html == null) {
	      throw 'HTMLElement expected';
	    }
	    return html;
	  }

	  /**
	   * Clears the render cache for a template. If
	   * no template is given, clears all render
	   * caches.
	   *
	   */
	  clearCache() {
	    iterate$1(this.options, option => {
	      if (option.$div) {
	        option.$div.remove();
	        delete option.$div;
	      }
	    });
	  }

	  /**
	   * Removes a value from item and option caches
	   *
	   */
	  uncacheValue(value) {
	    const option_el = this.getOption(value);
	    if (option_el) option_el.remove();
	  }

	  /**
	   * Determines whether or not to display the
	   * create item prompt, given a user input.
	   *
	   */
	  canCreate(input) {
	    return this.settings.create && input.length > 0 && this.settings.createFilter.call(this, input);
	  }

	  /**
	   * Wraps this.`method` so that `new_fn` can be invoked 'before', 'after', or 'instead' of the original method
	   *
	   * this.hook('instead','onKeyDown',function( arg1, arg2 ...){
	   *
	   * });
	   */
	  hook(when, method, new_fn) {
	    var self = this;
	    var orig_method = self[method];
	    self[method] = function () {
	      var result, result_new;
	      if (when === 'after') {
	        result = orig_method.apply(self, arguments);
	      }
	      result_new = new_fn.apply(self, arguments);
	      if (when === 'instead') {
	        return result_new;
	      }
	      if (when === 'before') {
	        result = orig_method.apply(self, arguments);
	      }
	      return result;
	    };
	  }
	}

	/**
	 * Plugin: "change_listener" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function change_listener () {
	  addEvent(this.input, 'change', () => {
	    this.sync();
	  });
	}

	/**
	 * Plugin: "checkbox_options" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function checkbox_options (userOptions) {
	  var self = this;
	  var orig_onOptionSelect = self.onOptionSelect;
	  self.settings.hideSelected = false;
	  const cbOptions = Object.assign({
	    // so that the user may add different ones as well
	    className: "tomselect-checkbox",
	    // the following default to the historic plugin's values
	    checkedClassNames: undefined,
	    uncheckedClassNames: undefined
	  }, userOptions);
	  var UpdateChecked = function UpdateChecked(checkbox, toCheck) {
	    if (toCheck) {
	      checkbox.checked = true;
	      if (cbOptions.uncheckedClassNames) {
	        checkbox.classList.remove(...cbOptions.uncheckedClassNames);
	      }
	      if (cbOptions.checkedClassNames) {
	        checkbox.classList.add(...cbOptions.checkedClassNames);
	      }
	    } else {
	      checkbox.checked = false;
	      if (cbOptions.checkedClassNames) {
	        checkbox.classList.remove(...cbOptions.checkedClassNames);
	      }
	      if (cbOptions.uncheckedClassNames) {
	        checkbox.classList.add(...cbOptions.uncheckedClassNames);
	      }
	    }
	  };

	  // update the checkbox for an option
	  var UpdateCheckbox = function UpdateCheckbox(option) {
	    setTimeout(() => {
	      var checkbox = option.querySelector('input.' + cbOptions.className);
	      if (checkbox instanceof HTMLInputElement) {
	        UpdateChecked(checkbox, option.classList.contains('selected'));
	      }
	    }, 1);
	  };

	  // add checkbox to option template
	  self.hook('after', 'setupTemplates', () => {
	    var orig_render_option = self.settings.render.option;
	    self.settings.render.option = (data, escape_html) => {
	      var rendered = getDom(orig_render_option.call(self, data, escape_html));
	      var checkbox = document.createElement('input');
	      if (cbOptions.className) {
	        checkbox.classList.add(cbOptions.className);
	      }
	      checkbox.addEventListener('click', function (evt) {
	        preventDefault(evt);
	      });
	      checkbox.type = 'checkbox';
	      const hashed = hash_key(data[self.settings.valueField]);
	      UpdateChecked(checkbox, !!(hashed && self.items.indexOf(hashed) > -1));
	      rendered.prepend(checkbox);
	      return rendered;
	    };
	  });

	  // uncheck when item removed
	  self.on('item_remove', value => {
	    var option = self.getOption(value);
	    if (option) {
	      // if dropdown hasn't been opened yet, the option won't exist
	      option.classList.remove('selected'); // selected class won't be removed yet
	      UpdateCheckbox(option);
	    }
	  });

	  // check when item added
	  self.on('item_add', value => {
	    var option = self.getOption(value);
	    if (option) {
	      // if dropdown hasn't been opened yet, the option won't exist
	      UpdateCheckbox(option);
	    }
	  });

	  // remove items when selected option is clicked
	  self.hook('instead', 'onOptionSelect', (evt, option) => {
	    if (option.classList.contains('selected')) {
	      option.classList.remove('selected');
	      self.removeItem(option.dataset.value);
	      self.refreshOptions();
	      preventDefault(evt, true);
	      return;
	    }
	    orig_onOptionSelect.call(self, evt, option);
	    UpdateCheckbox(option);
	  });
	}

	/**
	 * Plugin: "dropdown_header" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function clear_button (userOptions) {
	  const self = this;
	  const options = Object.assign({
	    className: 'clear-button',
	    title: 'Clear All',
	    html: data => {
	      return `<div class="${data.className}" title="${data.title}">&#10799;</div>`;
	    }
	  }, userOptions);
	  self.on('initialize', () => {
	    var button = getDom(options.html(options));
	    button.addEventListener('click', evt => {
	      if (self.isLocked) return;
	      self.clear();
	      if (self.settings.mode === 'single' && self.settings.allowEmptyOption) {
	        self.addItem('');
	      }
	      evt.preventDefault();
	      evt.stopPropagation();
	    });
	    self.control.appendChild(button);
	  });
	}

	/**
	 * Plugin: "drag_drop" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	const insertAfter = (referenceNode, newNode) => {
	  var _referenceNode$parent;
	  (_referenceNode$parent = referenceNode.parentNode) == null || _referenceNode$parent.insertBefore(newNode, referenceNode.nextSibling);
	};
	const insertBefore = (referenceNode, newNode) => {
	  var _referenceNode$parent2;
	  (_referenceNode$parent2 = referenceNode.parentNode) == null || _referenceNode$parent2.insertBefore(newNode, referenceNode);
	};
	const isBefore = (referenceNode, newNode) => {
	  do {
	    var _newNode;
	    newNode = (_newNode = newNode) == null ? void 0 : _newNode.previousElementSibling;
	    if (referenceNode == newNode) {
	      return true;
	    }
	  } while (newNode && newNode.previousElementSibling);
	  return false;
	};
	function drag_drop () {
	  var self = this;
	  if (self.settings.mode !== 'multi') return;
	  var orig_lock = self.lock;
	  var orig_unlock = self.unlock;
	  let sortable = true;
	  let drag_item;

	  /**
	   * Add draggable attribute to item
	   */
	  self.hook('after', 'setupTemplates', () => {
	    var orig_render_item = self.settings.render.item;
	    self.settings.render.item = (data, escape) => {
	      const item = getDom(orig_render_item.call(self, data, escape));
	      setAttr(item, {
	        'draggable': 'true'
	      });

	      // prevent doc_mousedown (see tom-select.ts)
	      const mousedown = evt => {
	        if (!sortable) preventDefault(evt);
	        evt.stopPropagation();
	      };
	      const dragStart = evt => {
	        drag_item = item;
	        setTimeout(() => {
	          item.classList.add('ts-dragging');
	        }, 0);
	      };
	      const dragOver = evt => {
	        evt.preventDefault();
	        item.classList.add('ts-drag-over');
	        moveitem(item, drag_item);
	      };
	      const dragLeave = () => {
	        item.classList.remove('ts-drag-over');
	      };
	      const moveitem = (targetitem, dragitem) => {
	        if (dragitem === undefined) return;
	        if (isBefore(dragitem, item)) {
	          insertAfter(targetitem, dragitem);
	        } else {
	          insertBefore(targetitem, dragitem);
	        }
	      };
	      const dragend = () => {
	        var _drag_item;
	        document.querySelectorAll('.ts-drag-over').forEach(el => el.classList.remove('ts-drag-over'));
	        (_drag_item = drag_item) == null || _drag_item.classList.remove('ts-dragging');
	        drag_item = undefined;
	        var values = [];
	        self.control.querySelectorAll(`[data-value]`).forEach(el => {
	          if (el.dataset.value) {
	            let value = el.dataset.value;
	            if (value) {
	              values.push(value);
	            }
	          }
	        });
	        self.setValue(values);
	      };
	      addEvent(item, 'mousedown', mousedown);
	      addEvent(item, 'dragstart', dragStart);
	      addEvent(item, 'dragenter', dragOver);
	      addEvent(item, 'dragover', dragOver);
	      addEvent(item, 'dragleave', dragLeave);
	      addEvent(item, 'dragend', dragend);
	      return item;
	    };
	  });
	  self.hook('instead', 'lock', () => {
	    sortable = false;
	    return orig_lock.call(self);
	  });
	  self.hook('instead', 'unlock', () => {
	    sortable = true;
	    return orig_unlock.call(self);
	  });
	}

	/**
	 * Plugin: "dropdown_header" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function dropdown_header (userOptions) {
	  const self = this;
	  const options = Object.assign({
	    title: 'Untitled',
	    headerClass: 'dropdown-header',
	    titleRowClass: 'dropdown-header-title',
	    labelClass: 'dropdown-header-label',
	    closeClass: 'dropdown-header-close',
	    html: data => {
	      return '<div class="' + data.headerClass + '">' + '<div class="' + data.titleRowClass + '">' + '<span class="' + data.labelClass + '">' + data.title + '</span>' + '<a class="' + data.closeClass + '">&times;</a>' + '</div>' + '</div>';
	    }
	  }, userOptions);
	  self.on('initialize', () => {
	    var header = getDom(options.html(options));
	    var close_link = header.querySelector('.' + options.closeClass);
	    if (close_link) {
	      close_link.addEventListener('click', evt => {
	        preventDefault(evt, true);
	        self.close();
	      });
	    }
	    self.dropdown.insertBefore(header, self.dropdown.firstChild);
	  });
	}

	/**
	 * Plugin: "dropdown_input" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function caret_position () {
	  var self = this;

	  /**
	   * Moves the caret to the specified index.
	   *
	   * The input must be moved by leaving it in place and moving the
	   * siblings, due to the fact that focus cannot be restored once lost
	   * on mobile webkit devices
	   *
	   */
	  self.hook('instead', 'setCaret', new_pos => {
	    if (self.settings.mode === 'single' || !self.control.contains(self.control_input)) {
	      new_pos = self.items.length;
	    } else {
	      new_pos = Math.max(0, Math.min(self.items.length, new_pos));
	      if (new_pos != self.caretPos && !self.isPending) {
	        self.controlChildren().forEach((child, j) => {
	          if (j < new_pos) {
	            self.control_input.insertAdjacentElement('beforebegin', child);
	          } else {
	            self.control.appendChild(child);
	          }
	        });
	      }
	    }
	    self.caretPos = new_pos;
	  });
	  self.hook('instead', 'moveCaret', direction => {
	    if (!self.isFocused) return;

	    // move caret before or after selected items
	    const last_active = self.getLastActive(direction);
	    if (last_active) {
	      const idx = nodeIndex(last_active);
	      self.setCaret(direction > 0 ? idx + 1 : idx);
	      self.setActiveItem();
	      removeClasses(last_active, 'last-active');

	      // move caret left or right of current position
	    } else {
	      self.setCaret(self.caretPos + direction);
	    }
	  });
	}

	/**
	 * Plugin: "dropdown_input" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function dropdown_input () {
	  const self = this;
	  self.settings.shouldOpen = true; // make sure the input is shown even if there are no options to display in the dropdown

	  self.hook('before', 'setup', () => {
	    self.focus_node = self.control;
	    addClasses(self.control_input, 'dropdown-input');
	    const div = getDom('<div class="dropdown-input-wrap">');
	    div.append(self.control_input);
	    self.dropdown.insertBefore(div, self.dropdown.firstChild);

	    // set a placeholder in the select control
	    const placeholder = getDom('<input class="items-placeholder" tabindex="-1" />');
	    placeholder.placeholder = self.settings.placeholder || '';
	    self.control.append(placeholder);
	  });
	  self.on('initialize', () => {
	    // set tabIndex on control to -1, otherwise [shift+tab] will put focus right back on control_input
	    self.control_input.addEventListener('keydown', evt => {
	      //addEvent(self.control_input,'keydown' as const,(evt:KeyboardEvent) =>{
	      switch (evt.keyCode) {
	        case KEY_ESC:
	          if (self.isOpen) {
	            preventDefault(evt, true);
	            self.close();
	          }
	          self.clearActiveItems();
	          return;
	        case KEY_TAB:
	          self.focus_node.tabIndex = -1;
	          break;
	      }
	      return self.onKeyDown.call(self, evt);
	    });
	    self.on('blur', () => {
	      self.focus_node.tabIndex = self.isDisabled ? -1 : self.tabIndex;
	    });

	    // give the control_input focus when the dropdown is open
	    self.on('dropdown_open', () => {
	      self.control_input.focus();
	    });

	    // prevent onBlur from closing when focus is on the control_input
	    const orig_onBlur = self.onBlur;
	    self.hook('instead', 'onBlur', evt => {
	      if (evt && evt.relatedTarget == self.control_input) return;
	      return orig_onBlur.call(self);
	    });
	    addEvent(self.control_input, 'blur', () => self.onBlur());

	    // return focus to control to allow further keyboard input
	    self.hook('before', 'close', () => {
	      if (!self.isOpen) return;
	      self.focus_node.focus({
	        preventScroll: true
	      });
	    });
	  });
	}

	/**
	 * Plugin: "input_autogrow" (Tom Select)
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function input_autogrow () {
	  var self = this;
	  self.on('initialize', () => {
	    var test_input = document.createElement('span');
	    var control = self.control_input;
	    test_input.style.cssText = 'position:absolute; top:-99999px; left:-99999px; width:auto; padding:0; white-space:pre; ';
	    self.wrapper.appendChild(test_input);
	    var transfer_styles = ['letterSpacing', 'fontSize', 'fontFamily', 'fontWeight', 'textTransform'];
	    for (const style_name of transfer_styles) {
	      // @ts-ignore TS7015 https://stackoverflow.com/a/50506154/697576
	      test_input.style[style_name] = control.style[style_name];
	    }

	    /**
	     * Set the control width
	     *
	     */
	    var resize = () => {
	      test_input.textContent = control.value;
	      control.style.width = test_input.clientWidth + 'px';
	    };
	    resize();
	    self.on('update item_add item_remove', resize);
	    addEvent(control, 'input', resize);
	    addEvent(control, 'keyup', resize);
	    addEvent(control, 'blur', resize);
	    addEvent(control, 'update', resize);
	  });
	}

	/**
	 * Plugin: "input_autogrow" (Tom Select)
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function no_backspace_delete () {
	  var self = this;
	  var orig_deleteSelection = self.deleteSelection;
	  this.hook('instead', 'deleteSelection', evt => {
	    if (self.activeItems.length) {
	      return orig_deleteSelection.call(self, evt);
	    }
	    return false;
	  });
	}

	/**
	 * Plugin: "no_active_items" (Tom Select)
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function no_active_items () {
	  this.hook('instead', 'setActiveItem', () => {});
	  this.hook('instead', 'selectAll', () => {});
	}

	/**
	 * Plugin: "optgroup_columns" (Tom Select.js)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function optgroup_columns () {
	  var self = this;
	  var orig_keydown = self.onKeyDown;
	  self.hook('instead', 'onKeyDown', evt => {
	    var index, option, options, optgroup;
	    if (!self.isOpen || !(evt.keyCode === KEY_LEFT || evt.keyCode === KEY_RIGHT)) {
	      return orig_keydown.call(self, evt);
	    }
	    self.ignoreHover = true;
	    optgroup = parentMatch(self.activeOption, '[data-group]');
	    index = nodeIndex(self.activeOption, '[data-selectable]');
	    if (!optgroup) {
	      return;
	    }
	    if (evt.keyCode === KEY_LEFT) {
	      optgroup = optgroup.previousSibling;
	    } else {
	      optgroup = optgroup.nextSibling;
	    }
	    if (!optgroup) {
	      return;
	    }
	    options = optgroup.querySelectorAll('[data-selectable]');
	    option = options[Math.min(options.length - 1, index)];
	    if (option) {
	      self.setActiveOption(option);
	    }
	  });
	}

	/**
	 * Plugin: "remove_button" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function remove_button (userOptions) {
	  const options = Object.assign({
	    label: '&times;',
	    title: 'Remove',
	    className: 'remove',
	    append: true
	  }, userOptions);

	  //options.className = 'remove-single';
	  var self = this;

	  // override the render method to add remove button to each item
	  if (!options.append) {
	    return;
	  }
	  var html = '<a href="javascript:void(0)" class="' + options.className + '" tabindex="-1" title="' + escape_html(options.title) + '">' + options.label + '</a>';
	  self.hook('after', 'setupTemplates', () => {
	    var orig_render_item = self.settings.render.item;
	    self.settings.render.item = (data, escape) => {
	      var item = getDom(orig_render_item.call(self, data, escape));
	      var close_button = getDom(html);
	      item.appendChild(close_button);
	      addEvent(close_button, 'mousedown', evt => {
	        preventDefault(evt, true);
	      });
	      addEvent(close_button, 'click', evt => {
	        if (self.isLocked) return;

	        // propagating will trigger the dropdown to show for single mode
	        preventDefault(evt, true);
	        if (self.isLocked) return;
	        if (!self.shouldDelete([item], evt)) return;
	        self.removeItem(item);
	        self.refreshOptions(false);
	        self.inputState();
	      });
	      return item;
	    };
	  });
	}

	/**
	 * Plugin: "restore_on_backspace" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function restore_on_backspace (userOptions) {
	  const self = this;
	  const options = Object.assign({
	    text: option => {
	      return option[self.settings.labelField];
	    }
	  }, userOptions);
	  self.on('item_remove', function (value) {
	    if (!self.isFocused) {
	      return;
	    }
	    if (self.control_input.value.trim() === '') {
	      var option = self.options[value];
	      if (option) {
	        self.setTextboxValue(options.text.call(self, option));
	      }
	    }
	  });
	}

	/**
	 * Plugin: "restore_on_backspace" (Tom Select)
	 * Copyright (c) contributors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
	 * file except in compliance with the License. You may obtain a copy of the License at:
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software distributed under
	 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
	 * ANY KIND, either express or implied. See the License for the specific language
	 * governing permissions and limitations under the License.
	 *
	 */

	function virtual_scroll () {
	  const self = this;
	  const orig_canLoad = self.canLoad;
	  const orig_clearActiveOption = self.clearActiveOption;
	  const orig_loadCallback = self.loadCallback;
	  var pagination = {};
	  var dropdown_content;
	  var loading_more = false;
	  var load_more_opt;
	  var default_values = [];
	  if (!self.settings.shouldLoadMore) {
	    // return true if additional results should be loaded
	    self.settings.shouldLoadMore = () => {
	      const scroll_percent = dropdown_content.clientHeight / (dropdown_content.scrollHeight - dropdown_content.scrollTop);
	      if (scroll_percent > 0.9) {
	        return true;
	      }
	      if (self.activeOption) {
	        var selectable = self.selectable();
	        var index = Array.from(selectable).indexOf(self.activeOption);
	        if (index >= selectable.length - 2) {
	          return true;
	        }
	      }
	      return false;
	    };
	  }
	  if (!self.settings.firstUrl) {
	    throw 'virtual_scroll plugin requires a firstUrl() method';
	  }

	  // in order for virtual scrolling to work,
	  // options need to be ordered the same way they're returned from the remote data source
	  self.settings.sortField = [{
	    field: '$order'
	  }, {
	    field: '$score'
	  }];

	  // can we load more results for given query?
	  const canLoadMore = query => {
	    if (typeof self.settings.maxOptions === 'number' && dropdown_content.children.length >= self.settings.maxOptions) {
	      return false;
	    }
	    if (query in pagination && pagination[query]) {
	      return true;
	    }
	    return false;
	  };
	  const clearFilter = (option, value) => {
	    if (self.items.indexOf(value) >= 0 || default_values.indexOf(value) >= 0) {
	      return true;
	    }
	    return false;
	  };

	  // set the next url that will be
	  self.setNextUrl = (value, next_url) => {
	    pagination[value] = next_url;
	  };

	  // getUrl() to be used in settings.load()
	  self.getUrl = query => {
	    if (query in pagination) {
	      const next_url = pagination[query];
	      pagination[query] = false;
	      return next_url;
	    }

	    // if the user goes back to a previous query
	    // we need to load the first page again
	    self.clearPagination();
	    return self.settings.firstUrl.call(self, query);
	  };

	  // clear pagination
	  self.clearPagination = () => {
	    pagination = {};
	  };

	  // don't clear the active option (and cause unwanted dropdown scroll)
	  // while loading more results
	  self.hook('instead', 'clearActiveOption', () => {
	    if (loading_more) {
	      return;
	    }
	    return orig_clearActiveOption.call(self);
	  });

	  // override the canLoad method
	  self.hook('instead', 'canLoad', query => {
	    // first time the query has been seen
	    if (!(query in pagination)) {
	      return orig_canLoad.call(self, query);
	    }
	    return canLoadMore(query);
	  });

	  // wrap the load
	  self.hook('instead', 'loadCallback', (options, optgroups) => {
	    if (!loading_more) {
	      self.clearOptions(clearFilter);
	    } else if (load_more_opt) {
	      const first_option = options[0];
	      if (first_option !== undefined) {
	        load_more_opt.dataset.value = first_option[self.settings.valueField];
	      }
	    }
	    orig_loadCallback.call(self, options, optgroups);
	    loading_more = false;
	  });

	  // add templates to dropdown
	  //	loading_more if we have another url in the queue
	  //	no_more_results if we don't have another url in the queue
	  self.hook('after', 'refreshOptions', () => {
	    const query = self.lastValue;
	    var option;
	    if (canLoadMore(query)) {
	      option = self.render('loading_more', {
	        query: query
	      });
	      if (option) {
	        option.setAttribute('data-selectable', ''); // so that navigating dropdown with [down] keypresses can navigate to this node
	        load_more_opt = option;
	      }
	    } else if (query in pagination && !dropdown_content.querySelector('.no-results')) {
	      option = self.render('no_more_results', {
	        query: query
	      });
	    }
	    if (option) {
	      addClasses(option, self.settings.optionClass);
	      dropdown_content.append(option);
	    }
	  });

	  // add scroll listener and default templates
	  self.on('initialize', () => {
	    default_values = Object.keys(self.options);
	    dropdown_content = self.dropdown_content;

	    // default templates
	    self.settings.render = Object.assign({}, {
	      loading_more: () => {
	        return `<div class="loading-more-results">Loading more results ... </div>`;
	      },
	      no_more_results: () => {
	        return `<div class="no-more-results">No more results</div>`;
	      }
	    }, self.settings.render);

	    // watch dropdown content scroll position
	    dropdown_content.addEventListener('scroll', () => {
	      if (!self.settings.shouldLoadMore.call(self)) {
	        return;
	      }

	      // !important: this will get checked again in load() but we still need to check here otherwise loading_more will be set to true
	      if (!canLoadMore(self.lastValue)) {
	        return;
	      }

	      // don't call load() too much
	      if (loading_more) return;
	      loading_more = true;
	      self.load.call(self, self.lastValue);
	    });
	  });
	}

	TomSelect.define('change_listener', change_listener);
	TomSelect.define('checkbox_options', checkbox_options);
	TomSelect.define('clear_button', clear_button);
	TomSelect.define('drag_drop', drag_drop);
	TomSelect.define('dropdown_header', dropdown_header);
	TomSelect.define('caret_position', caret_position);
	TomSelect.define('dropdown_input', dropdown_input);
	TomSelect.define('input_autogrow', input_autogrow);
	TomSelect.define('no_backspace_delete', no_backspace_delete);
	TomSelect.define('no_active_items', no_active_items);
	TomSelect.define('optgroup_columns', optgroup_columns);
	TomSelect.define('remove_button', remove_button);
	TomSelect.define('restore_on_backspace', restore_on_backspace);
	TomSelect.define('virtual_scroll', virtual_scroll);

	return TomSelect;

}));
var tomSelect=function(el,opts){return new TomSelect(el,opts);} 
//# sourceMappingURL=tom-select.complete.js.map


/***/ }),

/***/ "./node_modules/core-js/internals/collection-weak.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/internals/collection-weak.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this */ "./node_modules/core-js/internals/function-uncurry-this.js");
var defineBuiltIns = __webpack_require__(/*! ../internals/define-built-ins */ "./node_modules/core-js/internals/define-built-ins.js");
var getWeakData = (__webpack_require__(/*! ../internals/internal-metadata */ "./node_modules/core-js/internals/internal-metadata.js").getWeakData);
var anInstance = __webpack_require__(/*! ../internals/an-instance */ "./node_modules/core-js/internals/an-instance.js");
var anObject = __webpack_require__(/*! ../internals/an-object */ "./node_modules/core-js/internals/an-object.js");
var isNullOrUndefined = __webpack_require__(/*! ../internals/is-null-or-undefined */ "./node_modules/core-js/internals/is-null-or-undefined.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "./node_modules/core-js/internals/is-object.js");
var iterate = __webpack_require__(/*! ../internals/iterate */ "./node_modules/core-js/internals/iterate.js");
var ArrayIterationModule = __webpack_require__(/*! ../internals/array-iteration */ "./node_modules/core-js/internals/array-iteration.js");
var hasOwn = __webpack_require__(/*! ../internals/has-own-property */ "./node_modules/core-js/internals/has-own-property.js");
var InternalStateModule = __webpack_require__(/*! ../internals/internal-state */ "./node_modules/core-js/internals/internal-state.js");

var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
var find = ArrayIterationModule.find;
var findIndex = ArrayIterationModule.findIndex;
var splice = uncurryThis([].splice);
var id = 0;

// fallback for uncaught frozen keys
var uncaughtFrozenStore = function (state) {
  return state.frozen || (state.frozen = new UncaughtFrozenStore());
};

var UncaughtFrozenStore = function () {
  this.entries = [];
};

var findUncaughtFrozen = function (store, key) {
  return find(store.entries, function (it) {
    return it[0] === key;
  });
};

UncaughtFrozenStore.prototype = {
  get: function (key) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) return entry[1];
  },
  has: function (key) {
    return !!findUncaughtFrozen(this, key);
  },
  set: function (key, value) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) entry[1] = value;
    else this.entries.push([key, value]);
  },
  'delete': function (key) {
    var index = findIndex(this.entries, function (it) {
      return it[0] === key;
    });
    if (~index) splice(this.entries, index, 1);
    return !!~index;
  }
};

module.exports = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var Constructor = wrapper(function (that, iterable) {
      anInstance(that, Prototype);
      setInternalState(that, {
        type: CONSTRUCTOR_NAME,
        id: id++,
        frozen: undefined
      });
      if (!isNullOrUndefined(iterable)) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var Prototype = Constructor.prototype;

    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var data = getWeakData(anObject(key), true);
      if (data === true) uncaughtFrozenStore(state).set(key, value);
      else data[state.id] = value;
      return that;
    };

    defineBuiltIns(Prototype, {
      // `{ WeakMap, WeakSet }.prototype.delete(key)` methods
      // https://tc39.es/ecma262/#sec-weakmap.prototype.delete
      // https://tc39.es/ecma262/#sec-weakset.prototype.delete
      'delete': function (key) {
        var state = getInternalState(this);
        if (!isObject(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state)['delete'](key);
        return data && hasOwn(data, state.id) && delete data[state.id];
      },
      // `{ WeakMap, WeakSet }.prototype.has(key)` methods
      // https://tc39.es/ecma262/#sec-weakmap.prototype.has
      // https://tc39.es/ecma262/#sec-weakset.prototype.has
      has: function has(key) {
        var state = getInternalState(this);
        if (!isObject(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state).has(key);
        return data && hasOwn(data, state.id);
      }
    });

    defineBuiltIns(Prototype, IS_MAP ? {
      // `WeakMap.prototype.get(key)` method
      // https://tc39.es/ecma262/#sec-weakmap.prototype.get
      get: function get(key) {
        var state = getInternalState(this);
        if (isObject(key)) {
          var data = getWeakData(key);
          if (data === true) return uncaughtFrozenStore(state).get(key);
          return data ? data[state.id] : undefined;
        }
      },
      // `WeakMap.prototype.set(key, value)` method
      // https://tc39.es/ecma262/#sec-weakmap.prototype.set
      set: function set(key, value) {
        return define(this, key, value);
      }
    } : {
      // `WeakSet.prototype.add(value)` method
      // https://tc39.es/ecma262/#sec-weakset.prototype.add
      add: function add(value) {
        return define(this, value, true);
      }
    });

    return Constructor;
  }
};


/***/ }),

/***/ "./node_modules/core-js/internals/object-to-array.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/internals/object-to-array.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "./node_modules/core-js/internals/descriptors.js");
var fails = __webpack_require__(/*! ../internals/fails */ "./node_modules/core-js/internals/fails.js");
var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this */ "./node_modules/core-js/internals/function-uncurry-this.js");
var objectGetPrototypeOf = __webpack_require__(/*! ../internals/object-get-prototype-of */ "./node_modules/core-js/internals/object-get-prototype-of.js");
var objectKeys = __webpack_require__(/*! ../internals/object-keys */ "./node_modules/core-js/internals/object-keys.js");
var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "./node_modules/core-js/internals/to-indexed-object.js");
var $propertyIsEnumerable = (__webpack_require__(/*! ../internals/object-property-is-enumerable */ "./node_modules/core-js/internals/object-property-is-enumerable.js").f);

var propertyIsEnumerable = uncurryThis($propertyIsEnumerable);
var push = uncurryThis([].push);

// in some IE versions, `propertyIsEnumerable` returns incorrect result on integer keys
// of `null` prototype objects
var IE_BUG = DESCRIPTORS && fails(function () {
  // eslint-disable-next-line es/no-object-create -- safe
  var O = Object.create(null);
  O[2] = 2;
  return !propertyIsEnumerable(O, 2);
});

// `Object.{ entries, values }` methods implementation
var createMethod = function (TO_ENTRIES) {
  return function (it) {
    var O = toIndexedObject(it);
    var keys = objectKeys(O);
    var IE_WORKAROUND = IE_BUG && objectGetPrototypeOf(O) === null;
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;
    while (length > i) {
      key = keys[i++];
      if (!DESCRIPTORS || (IE_WORKAROUND ? key in O : propertyIsEnumerable(O, key))) {
        push(result, TO_ENTRIES ? [key, O[key]] : O[key]);
      }
    }
    return result;
  };
};

module.exports = {
  // `Object.entries` method
  // https://tc39.es/ecma262/#sec-object.entries
  entries: createMethod(true),
  // `Object.values` method
  // https://tc39.es/ecma262/#sec-object.values
  values: createMethod(false)
};


/***/ }),

/***/ "./node_modules/core-js/modules/es.object.entries.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/modules/es.object.entries.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(/*! ../internals/export */ "./node_modules/core-js/internals/export.js");
var $entries = (__webpack_require__(/*! ../internals/object-to-array */ "./node_modules/core-js/internals/object-to-array.js").entries);

// `Object.entries` method
// https://tc39.es/ecma262/#sec-object.entries
$({ target: 'Object', stat: true }, {
  entries: function entries(O) {
    return $entries(O);
  }
});


/***/ }),

/***/ "./node_modules/core-js/modules/es.weak-set.constructor.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/modules/es.weak-set.constructor.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var collection = __webpack_require__(/*! ../internals/collection */ "./node_modules/core-js/internals/collection.js");
var collectionWeak = __webpack_require__(/*! ../internals/collection-weak */ "./node_modules/core-js/internals/collection-weak.js");

// `WeakSet` constructor
// https://tc39.es/ecma262/#sec-weakset-constructor
collection('WeakSet', function (init) {
  return function WeakSet() { return init(this, arguments.length ? arguments[0] : undefined); };
}, collectionWeak);


/***/ }),

/***/ "./node_modules/core-js/modules/es.weak-set.js":
/*!*****************************************************!*\
  !*** ./node_modules/core-js/modules/es.weak-set.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: Remove this module from `core-js@4` since it's replaced to module below
__webpack_require__(/*! ../modules/es.weak-set.constructor */ "./node_modules/core-js/modules/es.weak-set.constructor.js");


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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