<?php

namespace App\Controller;

use App\Entity\ChauffeurVoyage;
use App\Form\ChauffeurVoyageForm;
use App\Repository\ChauffeurVoyageRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/chauffeur/voyage')]
final class ChauffeurVoyageController extends AbstractController
{
    #[Route(name: 'app_chauffeur_voyage_index', methods: ['GET'])]
    public function index(ChauffeurVoyageRepository $chauffeurVoyageRepository): Response
    {
        return $this->render('chauffeur_voyage/index.html.twig', [
            'chauffeur_voyages' => $chauffeurVoyageRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_chauffeur_voyage_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $chauffeurVoyage = new ChauffeurVoyage();
        $form = $this->createForm(ChauffeurVoyageForm::class, $chauffeurVoyage);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($chauffeurVoyage);
            $entityManager->flush();

            return $this->redirectToRoute('app_chauffeur_voyage_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('chauffeur_voyage/new.html.twig', [
            'chauffeur_voyage' => $chauffeurVoyage,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_chauffeur_voyage_show', methods: ['GET'])]
    public function show(ChauffeurVoyage $chauffeurVoyage): Response
    {
        return $this->render('chauffeur_voyage/show.html.twig', [
            'chauffeur_voyage' => $chauffeurVoyage,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_chauffeur_voyage_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, ChauffeurVoyage $chauffeurVoyage, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(ChauffeurVoyageForm::class, $chauffeurVoyage);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_chauffeur_voyage_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('chauffeur_voyage/edit.html.twig', [
            'chauffeur_voyage' => $chauffeurVoyage,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_chauffeur_voyage_delete', methods: ['POST'])]
    public function delete(Request $request, ChauffeurVoyage $chauffeurVoyage, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$chauffeurVoyage->getId(), $request->getPayload()->getString('_token'))) {
            $entityManager->remove($chauffeurVoyage);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_chauffeur_voyage_index', [], Response::HTTP_SEE_OTHER);
    }
}
