<?php

namespace App\Controller;

use App\Entity\Client;
use App\Entity\Reservation;
use App\Entity\Transit;
use App\Entity\Ville;
use App\Entity\Voyage;
use App\Form\ClientType;
use App\Form\TransitSearchType;
use App\Form\TransitType;
use App\Repository\PaysRepository;
use App\Repository\TransitRepository;
use App\Repository\VoyageRepository;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Validator\Constraints\DateTime;


use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;

use Endroid\QrCode\Writer\WriterInterface;


class HomeController extends AbstractController
{


    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    #[Route(path: '/', name: 'app_home')]
    public function index(): Response
    {
        return $this->redirectToRoute('app_home_index');

    }


    #[Route('/home/user/', name: 'app_home_index', methods: ['GET', 'POST'])]
    public function indexAa(Request           $request,
                            PaysRepository    $paysRepository,
                            TransitRepository $transitRepository): Response
    {

        $transit = new Transit();

        $form = $this->createForm(TransitSearchType::class, $transit)
            ->add('ville', EntityType::class, [
                'class' => Ville::class,
                'choice_label' => 'nom',
                'query_builder' => function (EntityRepository $er) {

                    $societe = $this->entityManager->getRepository("App\Entity\UserSociete")->findOneBy(array('user' => $this->getUser()));

                    $societe = "1";

                    return $er->createQueryBuilder('s')
                        ->select('v')
                        ->from('App\Entity\Ville', 'v')
                        ->andWhere('v.societe= :societe')
                        ->setParameter('societe', $societe);

                }
            ])
            ->add('villearrive', EntityType::class, [
                'class' => Ville::class,
                'choice_label' => 'nom',
                'query_builder' => function (EntityRepository $er) {

                    $societe = $this->entityManager->getRepository("App\Entity\UserSociete")->findOneBy(array('user' => $this->getUser()));
                    $societe = "1";


                    return $er->createQueryBuilder('s')
                        ->select('v')
                        ->from('App\Entity\Ville', 'v')
                        ->andWhere('v.societe= :societe')
                        ->setParameter('societe', $societe);

                }
            ])
            ->add('datedepart', null, [
                'widget' => 'single_text',
            ]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $voyages = $transitRepository->findBy(array('ville' => $transit->getVille(), 'villearrive' => $transit->getVillearrive(), 'datedepart' => $transit->getDatedepart()));

            $date_a = $transit->getDatedepart();

            $stringDateTime = $date_a->format('Y-m-d H:i:s');


            return $this->redirectToRoute('app_home_result_search', [
                'depart' => $transit->getVille()->getId(),
                'arrive' => $transit->getVillearrive()->getId(),
                'date_a' => $stringDateTime,
//                'voyages' => $voyages,
            ], Response::HTTP_SEE_OTHER);

        }

        return $this->render('home/indexSearch.html.twig', [
            'form' => $form,

//            'pays' => $paysRepository->findBy(array('statut' => '1')),
        ]);
    }

    #[Route(path: '/{depart}/{arrive}/{date_a}/result/search', name: 'app_home_result_search', methods: ['GET'])]
    public function indexResultSearch(TransitRepository $transitRepository,
                                                        $depart,
                                                        $arrive,
                                                        $date_a,
                                      VoyageRepository  $voyageRepository): Response
    {


        $date = new DateTime($date_a);
        $dobReconverted = \DateTime::createFromFormat('Y-m-d H:i:s', $date_a);


        // echo $date->format('Y-m-d H:i:s');
        $voyagess = $transitRepository->findBy(array('ville' => $depart, 'villearrive' => $arrive, 'datedepart' => $dobReconverted));

        $voyages = $transitRepository->findByVoyage($depart, $arrive, $dobReconverted);

        // dd($voyagess);

        return $this->render('home/resultSearch.html.twig', [
            'voyages' => $voyages,
        ]);
    }


    #[Route(path: '/{id}/detail/result/search', name: 'app_home_result_detail_search', methods: ['GET'])]
    public function indexResultDeatailSearch(TransitRepository $transitRepository,
                                             Transit           $transit,
                                             VoyageRepository  $voyageRepository): Response
    {


//        $dobReconverted = \DateTime::createFromFormat('Y-m-d H:i:s', $date_a);

//        $voyages = $transitRepository->findBy(array('ville' => $depart, 'villearrive' => $arrive, 'datedepart' => $dobReconverted));

        $detail = $transitRepository->findByEtape($transit->getNumeroetape(), $transit->getVoyage()->getId());


        return $this->render('home/detailSearch.html.twig', [
            'detail' => $detail,
            'voyage' => $transit
        ]);
    }


    #[Route(path: '/{id}/1/info/1/paiement', name: 'app_home_info_paiement', methods: ['GET', 'POST'])]
    public function indexInfoPaiement(Request                $request, TransitRepository $transitRepository,
                                      Transit                $transit,
                                      VoyageRepository       $voyageRepository,
                                      EntityManagerInterface $entityManager): Response
    {

        $client = new Client();
        $reservation = new Reservation();
        $today = new \DateTime();
        $dateString = $today->format('dmY');
        $voyages = $transitRepository->findBy(array('id' => $transit->getId()));

        $form = $this->createForm(ClientType::class, $client);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            $client->setSociete($transit->getVoyage()->getSociete());
            $client->setStatut(1);
            $entityManager->persist($client);
            $entityManager->flush();


            $billnumber = $transit->getVoyage()->getSociete()->getId() . '' . $client->getId() . '' . $dateString;

            $reservation->setClient($client);
            $reservation->setTransit($transit);
            $reservation->setSociete($transit->getVoyage()->getSociete());
            $reservation->setDateReservation($today);
            $reservation->setStatut(1);
            $reservation->setBillnumber($billnumber);
            $reservation->setPaied(1);

            $entityManager->persist($reservation);
            $entityManager->flush();


            return $this->redirectToRoute('app_home_success_paiement', [
                'transit' => $transit->getId(),
                'reservation' => $reservation->getId()


            ], Response::HTTP_SEE_OTHER);
        }


//        $dobReconverted = \DateTime::createFromFormat('Y-m-d H:i:s', $date_a);


        // $detail = $transitRepository->findByEtape($transit->getNumeroetape(), $transit->getVoyage()->getId());


        return $this->render('home/infoPaiement.html.twig', [
            'detail' => $voyages,
            'voyage' => $transit,
            'form' => $form,
            'reservation' => $reservation

        ]);
    }

    #[Route(path: '{transit}/{reservation}/success/paiement/success/paiement', name: 'app_home_success_paiement')]
    public function indexSuccessPaiement(Transit $transit, Reservation $reservation): Response
    {


        $qrCode = QrCode::create($reservation->getBillnumber())
            ->setEncoding(new Encoding('UTF-8'))
            ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
            ->setSize(200)
            ->setMargin(10)
            ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
            ->setForegroundColor(new Color(0, 0, 0))
            ->setBackgroundColor(new Color(255, 255, 255));
        $qrCodeData = $qrCode->getData(); // Assuming you have generateData
        $writer = new PngWriter();
        $result = $writer->write($qrCode);

        // Access the data string from the PngResult object
        $qrCodeImage = $result->getString(); // Replace with appropriate method

        $qrCodeImage = base64_encode($qrCodeImage);




        /*
                $writer = new PngWriter();

        // Create QR code
                $qrCode = QrCode::create('Life is too short to be generating QR codes')
                    ->setEncoding(new Encoding('UTF-8'))
                    ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
                    ->setSize(300)
                    ->setMargin(10)
                    ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
                    ->setForegroundColor(new Color(0, 0, 0))
                    ->setBackgroundColor(new Color(255, 255, 255));

        // Create generic logo
                $logo = Logo::create(__DIR__.'/assets/symfony.png')
                    ->setResizeToWidth(50)
                    ->setPunchoutBackground(true)
                ;

        // Create generic label
                $label = Label::create('Label')
                    ->setTextColor(new Color(255, 0, 0));

                $result = $writer->write($qrCode, $logo, $label);

        // Validate the result
                $writer->validateResult($result, 'Life is too short to be generating QR codes');

        // Save it to a file
                $result->saveToFile(__DIR__.'/assets/qrcode/qrcode.png');

                $dataUri = $result->getDataUri();*/


        return $this->render('home/successPaiement.html.twig', [
            'voyage' => $transit,
            'reservation' => $reservation,
            'qr_code_image' => $qrCodeImage,
            'qrCodeImage' => $qrCodeImage,
        ]);

    }


}
