<?php

namespace App\Controller;

use App\Entity\Personnel;
use App\Entity\UserRole;
use App\Form\PersonnelForm;
use App\Repository\PersonnelRepository;
use App\Repository\RoleRepository;
use App\Repository\UserRoleRepository;
use App\Util\Miscelleneous;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Validator\Constraints\IsTrue;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use App\Entity\User;



#[Route('/personnel')]
final class PersonnelController extends AbstractController
{
    #[Route(name: 'app_personnel_index', methods: ['GET'])]
    public function index(PersonnelRepository $personnelRepository): Response
    {
        $canView = $this->isGranted('PERSONNEL_VIEW');          // ou $this->isGranted('VOYAGE_VIEW', $subject)
        $canCreate = $this->isGranted('PERSONNEL_CREATE');          // ou $this->isGranted('VOYAGE_LIST', $subject)
        $canUpdate = $this->isGranted('PERSONNEL_UPDATE');
        $canDelete = $this->isGranted('PERSONNEL_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canView && !$canCreate && !$canUpdate && !$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }

        return $this->render('personnel/index.html.twig', [
            'personnels' => $personnelRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_personnel_new', methods: ['GET', 'POST'])]
    public function new(
        Request $request,
        EntityManagerInterface $entityManager,
        UserPasswordHasherInterface $passwordHasher,
        RoleRepository $roleRepository
    ): Response {

        $canCreate = $this->isGranted('PERSONNEL_CREATE');          // ou $this->isGranted('VOYAGE_LIST', $subject)
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canCreate && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        $personnel = new Personnel();
//        $userole= new UserRole();

        // s’assurer que le sous-form aura un objet User
        if (null === $personnel->getUser()) {
            $personnel->setUser(new User());
        }

        $form = $this->createForm(PersonnelForm::class, $personnel);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $user = $personnel->getUser();

          /*  $userole->setUser($personnel->getUser());
            $userole->setRole();*/

            // récupérer le plainPassword unmapped
            $plainPassword = $form->get('user')->get('plainPassword')->getData();
            if ($plainPassword) {
                $hash = $passwordHasher->hashPassword($user, $plainPassword);
                $user->setPassword($hash);
            }

            $user->setStatut(true);
            $personnel->setStatut(true);

            // 2) récupérer les codes des rôles cochés (array de strings)
            /** @var string[] $roleCodes */
            $roleCodes = (array) $form->get('user')->get('roles')->getData();


            // 3) créer UNE ligne UserRole par rôle
            foreach ($roleCodes as $code) {
                $roleEntity = $roleRepository->findOneBy(['code' => $code]); // adapte champ 'code'
                if (!$roleEntity) {
                    // si ta table Role n'a pas "code", adapte (label, slug, etc.)
                    continue;
                }

                $link = new UserRole();
                $link->setUser($user);
                $link->setRole($roleEntity);
                $entityManager->persist($link);
            }



            // Persister (si pas de cascade persist sur la relation, persist() $user d'abord)
            $entityManager->persist($personnel);
            // $entityManager->persist($user); // si nécessaire selon ton mapping
            $entityManager->flush();

            return $this->redirectToRoute('app_personnel_index');
        }

        return $this->render('personnel/new.html.twig', [
            'personnel' => $personnel,
            'form' => $form->createView(),
        ]);
    }
    #[Route('/{id}', name: 'app_personnel_show', methods: ['GET'])]
    public function show(Personnel $personnel,UserRoleRepository $userRoleRepository): Response
    {

        $canView = $this->isGranted('PERSONNEL_VIEW');          // ou $this->isGranted('VOYAGE_VIEW', $subject)
        $canCreate = $this->isGranted('PERSONNEL_CREATE');          // ou $this->isGranted('VOYAGE_LIST', $subject)
        $canUpdate = $this->isGranted('PERSONNEL_UPDATE');
        $canDelete = $this->isGranted('PERSONNEL_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canView && !$canCreate && !$canUpdate && !$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }

        $userroles=$userRoleRepository->findBy(array('user'=>$personnel->getUser()->getId()));

        if (!$canView && !$canCreate && !$canUpdate && !$canDelete) {
            throw $this->createAccessDeniedException();
        }
        return $this->render('personnel/show.html.twig', [
            'personnel' => $personnel,
            'userroles'=>$userroles
        ]);
    }

    #[Route('/{id}/edit', name: 'app_personnel_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Personnel $personnel, EntityManagerInterface $entityManager): Response
    {

        $canUpdate = $this->isGranted('PERSONNEL_UPDATE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canUpdate && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        $form = $this->createForm(PersonnelForm::class, $personnel);
        $form->remove('user');
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_personnel_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('personnel/edit.html.twig', [
            'personnel' => $personnel,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_personnel_delete', methods: ['POST'])]
    public function delete(Request $request, Personnel $personnel, EntityManagerInterface $entityManager): Response
    {

        $canDelete = $this->isGranted('PERSONNEL_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }

        if ($this->isCsrfTokenValid('delete'.$personnel->getId(), $request->getPayload()->getString('_token'))) {
            $entityManager->remove($personnel);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_personnel_index', [], Response::HTTP_SEE_OTHER);
    }
}
