<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

class SecurityController extends AbstractController
{
    #[Route(path: '/login', name: 'app_login')]
    public function login(Request $request, AuthenticationUtils $authenticationUtils): Response
    {
        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();

        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();


        // Check if the form is submitted
        if ($request->isMethod('POST')) {
            // Get the submitted data
            $formData = $request->request->all();

            // Determine if the submitted data is an email or a username
            $usernameOrEmail = $formData['_username'];

            // Check if the submitted data is an email
            if (filter_var($usernameOrEmail, FILTER_VALIDATE_EMAIL)) {
                // Data is an email, handle accordingly
                $credentials = [
                    'email' => $usernameOrEmail,
                    'password' => $formData['_password'],
                ];
            } else {
                // Data is a username, handle accordingly
                $credentials = [
                    'username' => $usernameOrEmail,
                    'password' => $formData['_password'],
                ];
            }
        }


        return $this->render('security/login.html.twig', [
            'last_username' => $lastUsername,
            'error' => $error,
        ]);
    }


    #[
        Route(path: '/logout', name: 'app_logout')]
    public function logout(): void
    {
        throw new \LogicException('This method can be blank - it will be intercepted by the logout key on your firewall.');
    }
}
