<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

#[Route('/test')]
class TestController extends AbstractController
{
    #[Route('', name: 'app_test_index', methods: ['GET'])]
    public function index(): Response
    {
        return $this->render('test/index.html.twig');
    }

    #[Route('/submit', name: 'app_test_submit', methods: ['POST'])]
    public function submit(Request $request, SessionInterface $session): Response
    {
        $name = trim((string) $request->request->get('name', ''));
        if ($name === '') {
            return new Response('Nom vide', 400);
        }

        $names = $session->get('submitted_names', []);
        $names[] = $name;
        $session->set('submitted_names', $names);

        // OK simple
        return new Response('OK');
    }

    #[Route('/table', name: 'app_test_table', methods: ['GET'])]
    public function table(SessionInterface $session): Response
    {
        $names = $session->get('submitted_names', []);
        return $this->render('test/_table.html.twig', [
            'names' => $names,
        ]);
    }
}
