<?php

namespace App\Controller;

use App\Entity\Transit;
use App\Entity\Ville;
use App\Entity\Voyage;
use App\Form\TransitType;
use App\Repository\TransitRepository;
use App\Repository\UserSocieteRepository;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use function PHPUnit\Framework\isEmpty;

#[Route('/transit')]
class TransitController extends AbstractController
{


    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    #[Route('/{id}', name: 'app_transit_index', methods: ['GET', 'POST'])]
    public function index(Request               $request,
                          TransitRepository     $transitRepository,
                          Voyage                $voyage,
                          UserSocieteRepository $userSocieteRepository): Response
    {
        $transit = new Transit();
        $societe = $userSocieteRepository->findBy(array('user' => $this->getUser()));

        $form = $this->createForm(TransitType::class, $transit);
        $form->remove('numeroetape');
        $form->remove('datearrive');
        $form->remove('datedepart');
        $form->remove('heurearrive');
        $form->remove('heuredepart');
        $form->remove('terminus');
        $form->remove('prix');

        $form->handleRequest($request);


        $transits = $transitRepository->findBy(array('voyage' => $voyage));


        if ($form->isSubmitted() && $form->isValid()) {

            $dateDebut = $request->request->get("datedebut");
            $dateFin = $request->request->get("datefin");

            if (empty($dateDebut) || empty($dateFin)) {

                return $this->redirectToRoute('app_transit_index', [
                    'id' => $voyage->getId(),
                ], Response::HTTP_SEE_OTHER);
            }



            return $this->redirectToRoute('app_transit_index_search', [
                'id' => $voyage->getId(),
                'dateDebut' => $dateDebut,
                'dateFin' => $dateFin,
                // 'voyages' => $voyages,
                //  'form' => $form,

            ], Response::HTTP_SEE_OTHER);


        }


        return $this->render('transit/index.html.twig', [
            'transits' => $transits,
            'voyage' => $voyage,
            'form' => $form,
            'testeur'=>0,

        ]);
    }


    #[Route('/{id}/{dateDebut}/{dateFin}/transit/index/search/', name: 'app_transit_index_search', methods: ['GET', 'POST'])]
    public function indexSearch(Request               $request,
                                TransitRepository     $transitRepository,
                                Voyage                $voyage,
                                UserSocieteRepository $userSocieteRepository,
                                                      $dateDebut,
                                                      $dateFin): Response
    {
        $transit = new Transit();
        $societe = $userSocieteRepository->findBy(array('user' => $this->getUser()));

        $form = $this->createForm(TransitType::class, $transit);
        $form->remove('numeroetape');
        $form->remove('datearrive');
        $form->remove('datedepart');
        $form->remove('heurearrive');
        $form->remove('heuredepart');
        $form->remove('terminus');
        $form->remove('prix');

        $form->handleRequest($request);



        $transits = $this->entityManager->getRepository(Transit::class)
            ->createQueryBuilder('v')
            ->where('v.datedepart BETWEEN :dateDebut AND :dateFin')
            ->andWhere('v.voyage=:voyage')
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)
            ->setParameter('voyage', $voyage)
            ->getQuery()
            ->getResult();


        if ($form->isSubmitted() && $form->isValid()) {

            $dateDebut = $request->request->get("datedebut");
            $dateFin = $request->request->get("datefin");

            if (empty($dateDebut) || empty($dateFin)) {
                return $this->redirectToRoute('app_transit_index', [
                    'id' => $voyage->getId(),
                ], Response::HTTP_SEE_OTHER);
            }


            return $this->redirectToRoute('app_transit_index_search', [
                'id' => $voyage->getId(),
                'dateDebut' => $dateDebut,
                'dateFin' => $dateFin,
                // 'voyages' => $voyages,
                //  'form' => $form,

            ], Response::HTTP_SEE_OTHER);


        }


        return $this->render('transit/index.html.twig', [
            'transits' => $transits,
            'voyage' => $voyage,
            'form' => $form,
            'debut'=>$dateDebut,
            'fin'=>$dateFin,
            'testeur'=>1,


        ]);
    }


    #[Route('/new/{id}', name: 'app_transit_new', methods: ['GET', 'POST'])]
    public function new(Request                $request,
                        EntityManagerInterface $entityManager,
                        Voyage                 $voyage,
    TransitRepository  $transitRepository): Response
    {

        $transits=$transitRepository->findBy(array('voyage'=>$voyage));

        $transit = new Transit();
        $form = $this->createForm(TransitType::class, $transit)
            ->add('ville', EntityType::class, [
                'class' => Ville::class,
                'choice_label' => 'nom',
                'query_builder' => function (EntityRepository $er) {

                    $societe = $this->entityManager->getRepository("App\Entity\UserSociete")->findOneBy(array('user' => $this->getUser()));

                    return $er->createQueryBuilder('s')
                        ->select('v')
                        ->from('App\Entity\Ville', 'v')
                        ->andWhere('v.societe= :societe')
                        ->setParameter('societe', $societe->getSociete());

                }
            ])
            ->add('villearrive', EntityType::class, [
                'class' => Ville::class,
                'choice_label' => 'nom',
                'query_builder' => function (EntityRepository $er) {

                    $societe = $this->entityManager->getRepository("App\Entity\UserSociete")->findOneBy(array('user' => $this->getUser()));


                    return $er->createQueryBuilder('s')
                        ->select('v')
                        ->from('App\Entity\Ville', 'v')
                        ->andWhere('v.societe= :societe')
                        ->setParameter('societe', $societe->getSociete());

                }
            ]);
        $form->handleRequest($request);
        $today = new \DateTime();


        if ($form->isSubmitted() && $form->isValid()) {

            $transit->setStatut(1);
            $transit->setVoyage($voyage);
            $transit->setDatecreation($today);
            $entityManager->persist($transit);
            $entityManager->flush();

            return $this->redirectToRoute('app_transit_index', [
                'id' => $voyage->getId(),
            ], Response::HTTP_SEE_OTHER);
        }

        $response = new Response(null, $form->isSubmitted() ? 422 : 200);


        return $this->render('transit/new.html.twig', [
            'transit' => $transit,
            'form' => $form,
            'voyage' => $voyage
        ], $response);
    }

    #[Route('/{id}', name: 'app_transit_show', methods: ['GET'])]
    public function show(Transit $transit): Response
    {
        return $this->render('transit/show.html.twig', [
            'transit' => $transit,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_transit_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Transit $transit, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(TransitType::class, $transit);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_transit_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('transit/edit.html.twig', [
            'transit' => $transit,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_transit_delete', methods: ['POST'])]
    public function delete(Request $request, Transit $transit, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete' . $transit->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($transit);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_transit_index', [
            'id'=>$transit->getVoyage()->getId(),
        ], Response::HTTP_SEE_OTHER);
    }
}
