<?php

namespace App\Controller;

use App\Entity\TypeVehicule;
use App\Form\TypeVehiculeType;
use App\Repository\TypeVehiculeRepository;
use App\Repository\UserSocieteRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/type/vehicule')]
class TypeVehiculeController extends AbstractController
{
    #[Route('/', name: 'app_type_vehicule_index', methods: ['GET'])]
    public function index(TypeVehiculeRepository $typeVehiculeRepository,
                          UserSocieteRepository  $userSocieteRepository): Response
    {
        $canView = $this->isGranted('TYPEVEHICULE_VIEW');          // ou $this->isGranted('VOYAGE_VIEW', $subject)
        $canCreate = $this->isGranted('TYPEVEHICULE_CREATE');          // ou $this->isGranted('VOYAGE_LIST', $subject)
        $canUpdate = $this->isGranted('TYPEVEHICULE_UPDATE');
        $canDelete = $this->isGranted('TYPEVEHICULE_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canView && !$canCreate && !$canUpdate && !$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }

        $societe = $userSocieteRepository->findOneBy(array('user' => $this->getUser()));

        return $this->render('type_vehicule/index.html.twig', [
            'type_vehicules' => $typeVehiculeRepository->findBy(array('societe' => $societe->getSociete(), 'statut' => 1)),
        ]);
    }

    #[Route('/new', name: 'app_type_vehicule_new', methods: ['GET', 'POST'])]
    public function new(Request                $request,
                        EntityManagerInterface $entityManager,
                        UserSocieteRepository  $userSocieteRepository): Response
    {

        $canCreate = $this->isGranted('TYPEVEHICULE_CREATE');
        $superAmin = $this->isGranted('SUPER_ADMIN');
// ou $this->isGranted('VOYAGE_LIST', $subject)


        if (!$canCreate && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        $societe = $userSocieteRepository->findOneBy(array('user' => $this->getUser()));

        $typeVehicule = new TypeVehicule();
        $form = $this->createForm(TypeVehiculeType::class, $typeVehicule);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {


            $typeVehicule->setSociete($societe->getSociete());
            $typeVehicule->setStatut(1);
            $entityManager->persist($typeVehicule);
            $entityManager->flush();

            return $this->redirectToRoute('app_type_vehicule_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('type_vehicule/new.html.twig', [
            'type_vehicule' => $typeVehicule,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_type_vehicule_show', methods: ['GET'])]
    public function show(TypeVehicule $typeVehicule): Response
    {
        $canView = $this->isGranted('TYPEVEHICULE_VIEW');          // ou $this->isGranted('VOYAGE_VIEW', $subject)
        $canCreate = $this->isGranted('TYPEVEHICULE_CREATE');          // ou $this->isGranted('VOYAGE_LIST', $subject)
        $canUpdate = $this->isGranted('TYPEVEHICULE_UPDATE');
        $canDelete = $this->isGranted('TYPEVEHICULE_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canView && !$canCreate && !$canUpdate && !$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        return $this->render('type_vehicule/show.html.twig', [
            'type_vehicule' => $typeVehicule,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_type_vehicule_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, TypeVehicule $typeVehicule, EntityManagerInterface $entityManager): Response
    {

        $canUpdate = $this->isGranted('TYPEVEHICULE_UPDATE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canUpdate && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        $form = $this->createForm(TypeVehiculeType::class, $typeVehicule);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_type_vehicule_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('type_vehicule/edit.html.twig', [
            'type_vehicule' => $typeVehicule,
            'form' => $form,
        ]);
    }



    #[Route('/{id}/typevehicule/typevehicule', name: 'app_type_vehicule_edit_delete', methods: ['GET', 'POST'])]
    public function editDelete(Request $request, TypeVehicule $typeVehicule, EntityManagerInterface $entityManager): Response
    {

        $canDelete = $this->isGranted('TYPEVEHICULE_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if ( !$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }
        $typeVehicule->setStatut(false);
        $entityManager->flush();

        return $this->redirectToRoute('app_type_vehicule_index', [], Response::HTTP_SEE_OTHER);

    }

    #[Route('/{id}', name: 'app_type_vehicule_delete', methods: ['POST'])]
    public function delete(Request $request, TypeVehicule $typeVehicule, EntityManagerInterface $entityManager): Response
    {

        $canDelete = $this->isGranted('TYPEVEHICULE_DELETE');
        $superAmin = $this->isGranted('SUPER_ADMIN');


        if (!$canDelete && !$superAmin) {
            throw $this->createAccessDeniedException();
        }

        if ($this->isCsrfTokenValid('delete' . $typeVehicule->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($typeVehicule);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_type_vehicule_index', [], Response::HTTP_SEE_OTHER);
    }
}
