<?php

namespace App\Controller;

use App\Entity\Charge;
use App\Entity\Reservation;
use App\Entity\Societe;
use App\Entity\UserSociete;
use App\Form\UserSocieteType;
use App\Repository\UserSocieteRepository;
use App\Repository\VoyageRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Routing\Attribute\Route;

use Symfony\Component\Debug\DebugBar\DebugBar;
use Symfony\Bundle\VarDumperBundle\VarDumperBundle;


#[Route('/user/societe')]
class UserSocieteController extends AbstractController
{
    /* private $debugBar;

     public function __construct(DebugBar $debugBar)
     {
         $this->debugBar = $debugBar;
     }*/


    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    #[Route('/{id}', name: 'app_user_societe_index', methods: ['GET'])]
    public function index(UserSocieteRepository $userSocieteRepository, Societe $societe): Response
    {

        return $this->render('user_societe/index.html.twig', [
            'user_societes' => $userSocieteRepository->findBy(array('societe' => $societe)),
            'societe' => $societe
        ]);
    }


    #[Route('/user/profile', name: 'app_user_profile', methods: ['GET'])]
    public function indexUserProfile(UserSocieteRepository $userSocieteRepository,
                                     VoyageRepository      $voyageRepository): Response
    {
        $today = new \DateTime();  // Récupère la date actuelle


        if ($this->isGranted('SUPER_ADMIN')){

        $reservations = $voyageRepository->getVoyageDetailsAdmin( $today->format('Y-m-d'));

        $totalTicketsVendusPrix = $this->entityManager->createQueryBuilder()
            ->select('SUM(t.prix) as totalPrix')
            ->from(Reservation::class, 'r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('r.dateReservation >= :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();


        $totalTicketsVendus = $this->entityManager->createQueryBuilder()
            ->select('COUNT(t.id) as total')
            ->from(Reservation::class, 'r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('r.dateReservation >= :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();

        $totalChargeVoyage = $this->entityManager->createQueryBuilder()
            ->select('SUM(c.montant) as totalMontant')
            ->from(Charge::class, 'c')
            /* ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
             ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')*/

            ->andWhere('c.dateCharge >= :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();
    } else {
        $reservations = $voyageRepository->getVoyageDetails($this->getUser(), $today->format('Y-m-d'));


        $totalTicketsVendusPrix = $this->entityManager->createQueryBuilder()
            ->select('SUM(t.prix) as totalPrix')
            ->from(Reservation::class, 'r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('r.user = :user')
            ->andWhere('r.dateReservation >= :today')
            ->setParameter('user', $this->getUser())
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();


        $totalTicketsVendus = $this->entityManager->createQueryBuilder()
            ->select('COUNT(t.id) as total')
            ->from(Reservation::class, 'r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('r.user = :user')
            ->andWhere('r.dateReservation >= :today')
            ->setParameter('user', $this->getUser())
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();

        $totalChargeVoyage = $this->entityManager->createQueryBuilder()
            ->select('SUM(c.montant) as totalMontant')
            ->from(Charge::class, 'c')
            /* ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
             ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')*/

            ->andWhere('c.user = :user')
            ->andWhere('c.dateCharge >= :today')
            ->setParameter('user', $this->getUser())
            ->setParameter('today', $today->format('Y-m-d'))
            ->getQuery()
            ->getSingleScalarResult();


    }


        return $this->render('user_societe/profile.html.twig', [
            /* 'user_societes' => $userSocieteRepository->findBy(array('societe'=>$societe)),
             'societe'=>$societe*/
            'totalTicketsVendusPrix' => $totalTicketsVendusPrix,
            'totalTicketsVendus' => $totalTicketsVendus,
            'totalmontant' => $totalChargeVoyage,
            'reservations' => $reservations


        ]);
    }

    #[Route('/new/{id}', name: 'app_user_societe_new', methods: ['GET', 'POST'])]
    public function new(Request                     $request, EntityManagerInterface $entityManager,
                        Societe                     $societe,
                        UserPasswordHasherInterface $userPasswordHasher): Response
    {
        $userSociete = new UserSociete();
        $form = $this->createForm(UserSocieteType::class, $userSociete);
        $form->handleRequest($request);


        if ($form->isSubmitted() && $form->isValid()) {

            $userSociete->setSociete($societe);
            $userSociete->setStatut(1);

            $user = $userSociete->getUser();
            // $user->setUsername($userSociete->getUser()->getUsername());
            //   $user->setEmail($userSociete->getUser()->getEmail());
            // $user->setPassword($userSociete->getUser()->getPassword());

            $userSociete->getUser()->setPassword(
                $userPasswordHasher->hashPassword(
                    $user,
                    $form->get('user')->get('plainPassword')->getData()
                )
            );
            $userSociete->getUser()->setStatut(1);
            $userSociete->getUser()->setRoles(['ROLE_ADMIN']);

            $entityManager->persist($userSociete);

            // dd($userSociete);
            // $entityManager->persist($user);

            $entityManager->flush();

            return $this->redirectToRoute('app_user_societe_index', [
                'id' => $societe->getId(),
            ], Response::HTTP_SEE_OTHER);
        }

        $response = new Response(null, $form->isSubmitted() ? 422 : 200);


        return $this->render('user_societe/new.html.twig', [
            'user_societe' => $userSociete,
            'form' => $form,
            'societe' => $societe,
        ], $response);
    }

    #[Route('/{id}', name: 'app_user_societe_show', methods: ['GET'])]
    public function show(UserSociete $userSociete): Response
    {
        return $this->render('user_societe/show.html.twig', [
            'user_societe' => $userSociete,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_user_societe_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, UserSociete $userSociete, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(UserSocieteType::class, $userSociete);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_user_societe_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('user_societe/edit.html.twig', [
            'user_societe' => $userSociete,
            'form' => $form,
        ]);
    }


    #[Route('/{id}/edit/edit', name: 'app_user_societe_edit_delete', methods: ['GET', 'POST'])]
    public function editDelete(Request $request, UserSociete $userSociete, EntityManagerInterface $entityManager): Response
    {

        $userSociete->setStatut(false);
        $entityManager->flush();

        return $this->redirectToRoute('app_user_societe_index', [], Response::HTTP_SEE_OTHER);

    }

    #[Route('/{id}', name: 'app_user_societe_delete', methods: ['POST'])]
    public function delete(Request $request, UserSociete $userSociete, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete' . $userSociete->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($userSociete);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_user_societe_index', [], Response::HTTP_SEE_OTHER);
    }
}
