<?php

namespace App\Entity;

use App\Repository\CharoitRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: CharoitRepository::class)]
class Charoit
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'charoits')]
    private ?TypeCharoit $typecharoit = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $marque = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $model = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $numerochassis = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $numeroplaque = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\ManyToOne(inversedBy: 'charoits')]
    private ?Societe $societe = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTypecharoit(): ?TypeCharoit
    {
        return $this->typecharoit;
    }

    public function setTypecharoit(?TypeCharoit $typecharoit): static
    {
        $this->typecharoit = $typecharoit;

        return $this;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getMarque(): ?string
    {
        return $this->marque;
    }

    public function setMarque(?string $marque): static
    {
        $this->marque = $marque;

        return $this;
    }

    public function getModel(): ?string
    {
        return $this->model;
    }

    public function setModel(?string $model): static
    {
        $this->model = $model;

        return $this;
    }

    public function getNumerochassis(): ?string
    {
        return $this->numerochassis;
    }

    public function setNumerochassis(?string $numerochassis): static
    {
        $this->numerochassis = $numerochassis;

        return $this;
    }

    public function getNumeroplaque(): ?string
    {
        return $this->numeroplaque;
    }

    public function setNumeroplaque(?string $numeroplaque): static
    {
        $this->numeroplaque = $numeroplaque;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }
}
