<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use App\Repository\ChauffeurRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ChauffeurRepository::class)]
#[ApiResource]

class Chauffeur
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $postnom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $prenom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $sexe = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $telephone = null;


    #[ORM\ManyToOne(inversedBy: 'chauffeurs')]
    private ?Societe $societe = null;

    #[ORM\ManyToOne(cascade: ["persist"],inversedBy: 'chauffeurs')]
    private ?User $user = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    /**
     * @var Collection<int, ChauffeurVoyage>
     */
    #[ORM\OneToMany(targetEntity: ChauffeurVoyage::class, mappedBy: 'chauffeur', cascade: ['persist'], orphanRemoval: true)]
    private Collection $chauffeurVoyages;

    public function __construct()
    {
        $this->chauffeurVoyages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getPostnom(): ?string
    {
        return $this->postnom;
    }

    public function setPostnom(?string $postnom): static
    {
        $this->postnom = $postnom;

        return $this;
    }

    public function getPrenom(): ?string
    {
        return $this->prenom;
    }

    public function setPrenom(?string $prenom): static
    {
        $this->prenom = $prenom;

        return $this;
    }

    public function getSexe(): ?string
    {
        return $this->sexe;
    }

    public function setSexe(?string $sexe): static
    {
        $this->sexe = $sexe;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(?string $telephone): static
    {
        $this->telephone = $telephone;

        return $this;
    }


    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): static
    {
        $this->user = $user;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * @return Collection<int, ChauffeurVoyage>
     */
    public function getChauffeurVoyages(): Collection
    {
        return $this->chauffeurVoyages;
    }

    public function addChauffeurVoyage(ChauffeurVoyage $chauffeurVoyage): static
    {
        if (!$this->chauffeurVoyages->contains($chauffeurVoyage)) {
            $this->chauffeurVoyages->add($chauffeurVoyage);
            $chauffeurVoyage->setChauffeur($this);
        }

        return $this;
    }

    public function removeChauffeurVoyage(ChauffeurVoyage $chauffeurVoyage): static
    {
        if ($this->chauffeurVoyages->removeElement($chauffeurVoyage)) {
            // set the owning side to null (unless already changed)
            if ($chauffeurVoyage->getChauffeur() === $this) {
                $chauffeurVoyage->setChauffeur(null);
            }
        }

        return $this;
    }
}
