<?php

namespace App\Entity;

use App\Repository\DeviseRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: DeviseRepository::class)]
class Devise
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $code = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    /**
     * @var Collection<int, Charge>
     */
    #[ORM\OneToMany(targetEntity: Charge::class, mappedBy: 'devise')]
    private Collection $charges;

    /**
     * @var Collection<int, Transit>
     */
    #[ORM\OneToMany(targetEntity: Transit::class, mappedBy: 'devise')]
    private Collection $transits;

    public function __construct()
    {
        $this->charges = new ArrayCollection();
        $this->transits = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * @return Collection<int, Charge>
     */
    public function getCharges(): Collection
    {
        return $this->charges;
    }

    public function addCharge(Charge $charge): static
    {
        if (!$this->charges->contains($charge)) {
            $this->charges->add($charge);
            $charge->setDevise($this);
        }

        return $this;
    }

    public function removeCharge(Charge $charge): static
    {
        if ($this->charges->removeElement($charge)) {
            // set the owning side to null (unless already changed)
            if ($charge->getDevise() === $this) {
                $charge->setDevise(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Transit>
     */
    public function getTransits(): Collection
    {
        return $this->transits;
    }

    public function addTransit(Transit $transit): static
    {
        if (!$this->transits->contains($transit)) {
            $this->transits->add($transit);
            $transit->setDevise($this);
        }

        return $this;
    }

    public function removeTransit(Transit $transit): static
    {
        if ($this->transits->removeElement($transit)) {
            // set the owning side to null (unless already changed)
            if ($transit->getDevise() === $this) {
                $transit->setDevise(null);
            }
        }

        return $this;
    }
}
