<?php

namespace App\Entity;

use App\Repository\PaysRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PaysRepository::class)]
class Pays
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $initial = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\OneToMany(targetEntity: Province::class, mappedBy: 'pays')]
    private Collection $provinces;

    #[ORM\OneToMany(targetEntity: Societe::class, mappedBy: 'pays')]
    private Collection $societes;

    #[ORM\ManyToOne(inversedBy: 'pays')]
    private ?User $createby = null;

    #[ORM\ManyToOne(inversedBy: 'pays')]
    private ?User $editby = null;

    #[ORM\ManyToOne(inversedBy: 'pays')]
    private ?User $deleteby = null;

    public function __construct()
    {
        $this->societes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getInitial(): ?string
    {
        return $this->initial;
    }

    public function setInitial(?string $initial): static
    {
        $this->initial = $initial;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }



    /**
     * @return Collection<int, Societe>
     */
    public function getSocietes(): Collection
    {
        return $this->societes;
    }

    public function addSociete(Societe $societe): static
    {
        if (!$this->societes->contains($societe)) {
            $this->societes->add($societe);
            $societe->setPays($this);
        }

        return $this;
    }

    public function removeSociete(Societe $societe): static
    {
        if ($this->societes->removeElement($societe)) {
            // set the owning side to null (unless already changed)
            if ($societe->getPays() === $this) {
                $societe->setPays(null);
            }
        }

        return $this;
    }

    public function getCreateby(): ?User
    {
        return $this->createby;
    }

    public function setCreateby(?User $createby): static
    {
        $this->createby = $createby;

        return $this;
    }

    public function getEditby(): ?User
    {
        return $this->editby;
    }

    public function setEditby(?User $editby): static
    {
        $this->editby = $editby;

        return $this;
    }

    public function getDeleteby(): ?User
    {
        return $this->deleteby;
    }

    public function setDeleteby(?User $deleteby): static
    {
        $this->deleteby = $deleteby;

        return $this;
    }
}
