<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use App\Repository\SocieteRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SocieteRepository::class)]
#[ApiResource]

class Societe
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'societes')]
    private ?Pays $pays = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $adresse = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $telephone = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $email = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\OneToMany(targetEntity: TypeCharoit::class, mappedBy: 'societe')]
    private Collection $typeCharoits;

    #[ORM\OneToMany(targetEntity: Province::class, mappedBy: 'societe')]
    private Collection $provinces;

    #[ORM\OneToMany(targetEntity: Charoit::class, mappedBy: 'societe')]
    private Collection $charoits;

    #[ORM\OneToMany(targetEntity: Ville::class, mappedBy: 'societe')]
    private Collection $villes;

    #[ORM\OneToMany(targetEntity: Voyage::class, mappedBy: 'societe')]
    private Collection $voyages;

    #[ORM\OneToMany(targetEntity: UserSociete::class, mappedBy: 'societe')]
    private Collection $userSocietes;

    #[ORM\ManyToOne(inversedBy: 'societes')]
    private ?User $createby = null;

    #[ORM\ManyToOne(inversedBy: 'societes')]
    private ?User $editby = null;

    #[ORM\ManyToOne(inversedBy: 'societes')]
    private ?User $deleteby = null;

    #[ORM\OneToMany(targetEntity: TypeVehicule::class, mappedBy: 'societe')]
    private Collection $typeVehicules;

    #[ORM\OneToMany(targetEntity: Vehicule::class, mappedBy: 'societe')]
    private Collection $vehicules;

    #[ORM\OneToMany(targetEntity: Chauffeur::class, mappedBy: 'societe')]
    private Collection $chauffeurs;

    #[ORM\OneToMany(targetEntity: Client::class, mappedBy: 'societe')]
    private Collection $clients;

    #[ORM\OneToMany(targetEntity: Reservation::class, mappedBy: 'societe')]
    private Collection $reservations;

    /**
     * @var Collection<int, Personnel>
     */
    #[ORM\OneToMany(targetEntity: Personnel::class, mappedBy: 'societe')]
    private Collection $personnels;

    public function __construct()
    {
        $this->typeCharoits = new ArrayCollection();
        $this->provinces = new ArrayCollection();
        $this->charoits = new ArrayCollection();
        $this->villes = new ArrayCollection();
        $this->voyages = new ArrayCollection();
        $this->userSocietes = new ArrayCollection();
        $this->typeVehicules = new ArrayCollection();
        $this->vehicules = new ArrayCollection();
        $this->chauffeurs = new ArrayCollection();
        $this->clients = new ArrayCollection();
        $this->reservations = new ArrayCollection();
        $this->personnels = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPays(): ?Pays
    {
        return $this->pays;
    }

    public function setPays(?Pays $pays): static
    {
        $this->pays = $pays;

        return $this;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getAdresse(): ?string
    {
        return $this->adresse;
    }

    public function setAdresse(?string $adresse): static
    {
        $this->adresse = $adresse;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(?string $telephone): static
    {
        $this->telephone = $telephone;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): static
    {
        $this->email = $email;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * @return Collection<int, TypeCharoit>
     */
    public function getTypeCharoits(): Collection
    {
        return $this->typeCharoits;
    }

    public function addTypeCharoit(TypeCharoit $typeCharoit): static
    {
        if (!$this->typeCharoits->contains($typeCharoit)) {
            $this->typeCharoits->add($typeCharoit);
            $typeCharoit->setSociete($this);
        }

        return $this;
    }

    public function removeTypeCharoit(TypeCharoit $typeCharoit): static
    {
        if ($this->typeCharoits->removeElement($typeCharoit)) {
            // set the owning side to null (unless already changed)
            if ($typeCharoit->getSociete() === $this) {
                $typeCharoit->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Province>
     */
    public function getProvinces(): Collection
    {
        return $this->provinces;
    }

    public function addProvince(Province $province): static
    {
        if (!$this->provinces->contains($province)) {
            $this->provinces->add($province);
            $province->setSociete($this);
        }

        return $this;
    }

    public function removeProvince(Province $province): static
    {
        if ($this->provinces->removeElement($province)) {
            // set the owning side to null (unless already changed)
            if ($province->getSociete() === $this) {
                $province->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Charoit>
     */
    public function getCharoits(): Collection
    {
        return $this->charoits;
    }

    public function addCharoit(Charoit $charoit): static
    {
        if (!$this->charoits->contains($charoit)) {
            $this->charoits->add($charoit);
            $charoit->setSociete($this);
        }

        return $this;
    }

    public function removeCharoit(Charoit $charoit): static
    {
        if ($this->charoits->removeElement($charoit)) {
            // set the owning side to null (unless already changed)
            if ($charoit->getSociete() === $this) {
                $charoit->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Ville>
     */
    public function getVilles(): Collection
    {
        return $this->villes;
    }

    public function addVille(Ville $ville): static
    {
        if (!$this->villes->contains($ville)) {
            $this->villes->add($ville);
            $ville->setSociete($this);
        }

        return $this;
    }

    public function removeVille(Ville $ville): static
    {
        if ($this->villes->removeElement($ville)) {
            // set the owning side to null (unless already changed)
            if ($ville->getSociete() === $this) {
                $ville->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Voyage>
     */
    public function getVoyages(): Collection
    {
        return $this->voyages;
    }

    public function addVoyage(Voyage $voyage): static
    {
        if (!$this->voyages->contains($voyage)) {
            $this->voyages->add($voyage);
            $voyage->setSociete($this);
        }

        return $this;
    }

    public function removeVoyage(Voyage $voyage): static
    {
        if ($this->voyages->removeElement($voyage)) {
            // set the owning side to null (unless already changed)
            if ($voyage->getSociete() === $this) {
                $voyage->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, UserSociete>
     */
    public function getUserSocietes(): Collection
    {
        return $this->userSocietes;
    }

    public function addUserSociete(UserSociete $userSociete): static
    {
        if (!$this->userSocietes->contains($userSociete)) {
            $this->userSocietes->add($userSociete);
            $userSociete->setSociete($this);
        }

        return $this;
    }

    public function removeUserSociete(UserSociete $userSociete): static
    {
        if ($this->userSocietes->removeElement($userSociete)) {
            // set the owning side to null (unless already changed)
            if ($userSociete->getSociete() === $this) {
                $userSociete->setSociete(null);
            }
        }

        return $this;
    }

    public function getCreateby(): ?User
    {
        return $this->createby;
    }

    public function setCreateby(?User $createby): static
    {
        $this->createby = $createby;

        return $this;
    }

    public function getEditby(): ?User
    {
        return $this->editby;
    }

    public function setEditby(?User $editby): static
    {
        $this->editby = $editby;

        return $this;
    }

    public function getDeleteby(): ?User
    {
        return $this->deleteby;
    }

    public function setDeleteby(?User $deleteby): static
    {
        $this->deleteby = $deleteby;

        return $this;
    }

    /**
     * @return Collection<int, TypeVehicule>
     */
    public function getTypeVehicules(): Collection
    {
        return $this->typeVehicules;
    }

    public function addTypeVehicule(TypeVehicule $typeVehicule): static
    {
        if (!$this->typeVehicules->contains($typeVehicule)) {
            $this->typeVehicules->add($typeVehicule);
            $typeVehicule->setSociete($this);
        }

        return $this;
    }

    public function removeTypeVehicule(TypeVehicule $typeVehicule): static
    {
        if ($this->typeVehicules->removeElement($typeVehicule)) {
            // set the owning side to null (unless already changed)
            if ($typeVehicule->getSociete() === $this) {
                $typeVehicule->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Vehicule>
     */
    public function getVehicules(): Collection
    {
        return $this->vehicules;
    }

    public function addVehicule(Vehicule $vehicule): static
    {
        if (!$this->vehicules->contains($vehicule)) {
            $this->vehicules->add($vehicule);
            $vehicule->setSociete($this);
        }

        return $this;
    }

    public function removeVehicule(Vehicule $vehicule): static
    {
        if ($this->vehicules->removeElement($vehicule)) {
            // set the owning side to null (unless already changed)
            if ($vehicule->getSociete() === $this) {
                $vehicule->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Chauffeur>
     */
    public function getChauffeurs(): Collection
    {
        return $this->chauffeurs;
    }

    public function addChauffeur(Chauffeur $chauffeur): static
    {
        if (!$this->chauffeurs->contains($chauffeur)) {
            $this->chauffeurs->add($chauffeur);
            $chauffeur->setSociete($this);
        }

        return $this;
    }

    public function removeChauffeur(Chauffeur $chauffeur): static
    {
        if ($this->chauffeurs->removeElement($chauffeur)) {
            // set the owning side to null (unless already changed)
            if ($chauffeur->getSociete() === $this) {
                $chauffeur->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Client>
     */
    public function getClients(): Collection
    {
        return $this->clients;
    }

    public function addClient(Client $client): static
    {
        if (!$this->clients->contains($client)) {
            $this->clients->add($client);
            $client->setSociete($this);
        }

        return $this;
    }

    public function removeClient(Client $client): static
    {
        if ($this->clients->removeElement($client)) {
            // set the owning side to null (unless already changed)
            if ($client->getSociete() === $this) {
                $client->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Reservation>
     */
    public function getReservations(): Collection
    {
        return $this->reservations;
    }

    public function addReservation(Reservation $reservation): static
    {
        if (!$this->reservations->contains($reservation)) {
            $this->reservations->add($reservation);
            $reservation->setSociete($this);
        }

        return $this;
    }

    public function removeReservation(Reservation $reservation): static
    {
        if ($this->reservations->removeElement($reservation)) {
            // set the owning side to null (unless already changed)
            if ($reservation->getSociete() === $this) {
                $reservation->setSociete(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Personnel>
     */
    public function getPersonnels(): Collection
    {
        return $this->personnels;
    }

    public function addPersonnel(Personnel $personnel): static
    {
        if (!$this->personnels->contains($personnel)) {
            $this->personnels->add($personnel);
            $personnel->setSociete($this);
        }

        return $this;
    }

    public function removePersonnel(Personnel $personnel): static
    {
        if ($this->personnels->removeElement($personnel)) {
            // set the owning side to null (unless already changed)
            if ($personnel->getSociete() === $this) {
                $personnel->setSociete(null);
            }
        }

        return $this;
    }
}
