<?php

namespace App\Entity;

use App\Repository\TransitRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TransitRepository::class)]
class Transit
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'transits')]
    private ?Voyage $voyage = null;

    #[ORM\Column(nullable: true)]
    private ?int $numeroetape = null;

    #[ORM\ManyToOne(inversedBy: 'transites')]
    private ?Ville $ville = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datearrive = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datedepart = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $heurearrive = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $heuredepart = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $terminus = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\ManyToOne(inversedBy: 'transites')]
    private ?Ville $villearrive = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $prix = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datecreation = null;

    #[ORM\OneToMany(targetEntity: Reservation::class, mappedBy: 'transit')]
    private Collection $reservations;

    #[ORM\ManyToOne(inversedBy: 'transits')]
    private ?Devise $devise = null;

    #[ORM\Column(nullable: true)]
    private ?bool $actif = null;

    public function __construct()
    {
        $this->reservations = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getVoyage(): ?Voyage
    {
        return $this->voyage;
    }

    public function setVoyage(?Voyage $voyage): static
    {
        $this->voyage = $voyage;

        return $this;
    }

    public function getNumeroetape(): ?int
    {
        return $this->numeroetape;
    }

    public function setNumeroetape(?int $numeroetape): static
    {
        $this->numeroetape = $numeroetape;

        return $this;
    }

    public function getVille(): ?Ville
    {
        return $this->ville;
    }

    public function setVille(?Ville $ville): static
    {
        $this->ville = $ville;

        return $this;
    }

    public function getDatearrive(): ?\DateTimeInterface
    {
        return $this->datearrive;
    }

    public function setDatearrive(?\DateTimeInterface $datearrive): static
    {
        $this->datearrive = $datearrive;

        return $this;
    }

    public function getDatedepart(): ?\DateTimeInterface
    {
        return $this->datedepart;
    }

    public function setDatedepart(?\DateTimeInterface $datedepart): static
    {
        $this->datedepart = $datedepart;

        return $this;
    }

    public function getHeurearrive(): ?string
    {
        return $this->heurearrive;
    }

    public function setHeurearrive(?string $heurearrive): static
    {
        $this->heurearrive = $heurearrive;

        return $this;
    }

    public function getHeuredepart(): ?string
    {
        return $this->heuredepart;
    }

    public function setHeuredepart(?string $heuredepart): static
    {
        $this->heuredepart = $heuredepart;

        return $this;
    }

    public function getTerminus(): ?string
    {
        return $this->terminus;
    }

    public function setTerminus(?string $terminus): static
    {
        $this->terminus = $terminus;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    public function getVillearrive(): ?Ville
    {
        return $this->villearrive;
    }

    public function setVillearrive(?Ville $villearrive): static
    {
        $this->villearrive = $villearrive;

        return $this;
    }

    public function getPrix(): ?string
    {
        return $this->prix;
    }

    public function setPrix(?string $prix): static
    {
        $this->prix = $prix;

        return $this;
    }

    public function getDatecreation(): ?\DateTimeInterface
    {
        return $this->datecreation;
    }

    public function setDatecreation(?\DateTimeInterface $datecreation): static
    {
        $this->datecreation = $datecreation;

        return $this;
    }

    /**
     * @return Collection<int, Reservation>
     */
    public function getReservations(): Collection
    {
        return $this->reservations;
    }

    public function addReservation(Reservation $reservation): static
    {
        if (!$this->reservations->contains($reservation)) {
            $this->reservations->add($reservation);
            $reservation->setTransit($this);
        }

        return $this;
    }

    public function removeReservation(Reservation $reservation): static
    {
        if ($this->reservations->removeElement($reservation)) {
            // set the owning side to null (unless already changed)
            if ($reservation->getTransit() === $this) {
                $reservation->setTransit(null);
            }
        }

        return $this;
    }

    public function getDevise(): ?Devise
    {
        return $this->devise;
    }

    public function setDevise(?Devise $devise): static
    {
        $this->devise = $devise;

        return $this;
    }

    public function isActif(): ?bool
    {
        return $this->actif;
    }

    public function setActif(?bool $actif): static
    {
        $this->actif = $actif;

        return $this;
    }
}
