<?php

namespace App\Entity;

use App\Repository\TypeCharoitRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TypeCharoitRepository::class)]
class TypeCharoit
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\ManyToOne(inversedBy: 'typeCharoits')]
    private ?Societe $societe = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\OneToMany(targetEntity: Charoit::class, mappedBy: 'typecharoit')]
    private Collection $charoits;

    public function __construct()
    {
        $this->charoits = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * @return Collection<int, Charoit>
     */
    public function getCharoits(): Collection
    {
        return $this->charoits;
    }

    public function addCharoit(Charoit $charoit): static
    {
        if (!$this->charoits->contains($charoit)) {
            $this->charoits->add($charoit);
            $charoit->setTypecharoit($this);
        }

        return $this;
    }

    public function removeCharoit(Charoit $charoit): static
    {
        if ($this->charoits->removeElement($charoit)) {
            // set the owning side to null (unless already changed)
            if ($charoit->getTypecharoit() === $this) {
                $charoit->setTypecharoit(null);
            }
        }

        return $this;
    }
}
