<?php

namespace App\Entity;

use App\Repository\VehiculeRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: VehiculeRepository::class)]
class Vehicule
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'vehicules')]
    private ?TypeVehicule $typevehicule = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $marque = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $modele = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $annee = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $couleur = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $immatriculation = null;

    #[ORM\Column(nullable: true)]
    private ?int $capacite = null;

    #[ORM\ManyToOne(inversedBy: 'vehicules')]
    private ?Societe $societe = null;

    #[ORM\Column]
    private ?bool $statut = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $numerochasis = null;

    #[ORM\OneToMany(targetEntity: Voyage::class, mappedBy: 'vehicule')]
    private Collection $voyages;

    /**
     * @var Collection<int, VehiculeSiege>
     */
    #[ORM\OneToMany(targetEntity: VehiculeSiege::class, cascade: ['persist'], mappedBy: 'vehicule')]
    private Collection $vehiculeSieges;

    public function __construct()
    {
        $this->voyages = new ArrayCollection();
        $this->vehiculeSieges = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTypevehicule(): ?TypeVehicule
    {
        return $this->typevehicule;
    }

    public function setTypevehicule(?TypeVehicule $typevehicule): static
    {
        $this->typevehicule = $typevehicule;

        return $this;
    }

    public function getMarque(): ?string
    {
        return $this->marque;
    }

    public function setMarque(?string $marque): static
    {
        $this->marque = $marque;

        return $this;
    }

    public function getModele(): ?string
    {
        return $this->modele;
    }

    public function setModele(?string $modele): static
    {
        $this->modele = $modele;

        return $this;
    }

    public function getAnnee(): ?string
    {
        return $this->annee;
    }

    public function setAnnee(?string $annee): static
    {
        $this->annee = $annee;

        return $this;
    }

    public function getCouleur(): ?string
    {
        return $this->couleur;
    }

    public function setCouleur(?string $couleur): static
    {
        $this->couleur = $couleur;

        return $this;
    }

    public function getImmatriculation(): ?string
    {
        return $this->immatriculation;
    }

    public function setImmatriculation(?string $immatriculation): static
    {
        $this->immatriculation = $immatriculation;

        return $this;
    }

    public function getCapacite(): ?int
    {
        return $this->capacite;
    }

    public function setCapacite(?int $capacite): static
    {
        $this->capacite = $capacite;

        return $this;
    }

    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    public function getNumerochasis(): ?string
    {
        return $this->numerochasis;
    }

    public function setNumerochasis(?string $numerochasis): static
    {
        $this->numerochasis = $numerochasis;

        return $this;
    }

    /**
     * @return Collection<int, Voyage>
     */
    public function getVoyages(): Collection
    {
        return $this->voyages;
    }

    public function addVoyage(Voyage $voyage): static
    {
        if (!$this->voyages->contains($voyage)) {
            $this->voyages->add($voyage);
            $voyage->setVehicule($this);
        }

        return $this;
    }

    public function removeVoyage(Voyage $voyage): static
    {
        if ($this->voyages->removeElement($voyage)) {
            // set the owning side to null (unless already changed)
            if ($voyage->getVehicule() === $this) {
                $voyage->setVehicule(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, VehiculeSiege>
     */
    public function getVehiculeSieges(): Collection
    {
        return $this->vehiculeSieges;
    }

    public function addVehiculeSiege(VehiculeSiege $vehiculeSiege): static
    {
        if (!$this->vehiculeSieges->contains($vehiculeSiege)) {
            $this->vehiculeSieges->add($vehiculeSiege);
            $vehiculeSiege->setVehicule($this);
        }

        return $this;
    }

    public function removeVehiculeSiege(VehiculeSiege $vehiculeSiege): static
    {
        if ($this->vehiculeSieges->removeElement($vehiculeSiege)) {
            // set the owning side to null (unless already changed)
            if ($vehiculeSiege->getVehicule() === $this) {
                $vehiculeSiege->setVehicule(null);
            }
        }

        return $this;
    }
}
