<?php

namespace App\Entity;

use App\Repository\VilleRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: VilleRepository::class)]
class Ville
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'villes')]
    private ?Province $province = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nom = null;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\OneToMany(targetEntity: Voyage::class, mappedBy: 'villedepart')]
    private Collection $voyages;

    #[ORM\ManyToOne(inversedBy: 'villes')]
    private ?Societe $societe = null;

    #[ORM\OneToMany(targetEntity: Transit::class, mappedBy: 'ville')]
    private Collection $transits;

    #[ORM\OneToMany(targetEntity: Transit::class, mappedBy: 'villearrive�')]
    private Collection $transites;

    public function __construct()
    {
        $this->voyages = new ArrayCollection();
        $this->transits = new ArrayCollection();
        $this->transites = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getProvince(): ?Province
    {
        return $this->province;
    }

    public function setProvince(?Province $province): static
    {
        $this->province = $province;

        return $this;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(?string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * @return Collection<int, Voyage>
     */
    public function getVoyages(): Collection
    {
        return $this->voyages;
    }

    public function addVoyage(Voyage $voyage): static
    {
        if (!$this->voyages->contains($voyage)) {
            $this->voyages->add($voyage);
            $voyage->setVilledepart($this);
        }

        return $this;
    }

    public function removeVoyage(Voyage $voyage): static
    {
        if ($this->voyages->removeElement($voyage)) {
            // set the owning side to null (unless already changed)
            if ($voyage->getVilledepart() === $this) {
                $voyage->setVilledepart(null);
            }
        }

        return $this;
    }

    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }

    /**
     * @return Collection<int, Transit>
     */
    public function getTransits(): Collection
    {
        return $this->transits;
    }

    public function addTransits(Transit $transits): static
    {
        if (!$this->transits->contains($transits)) {
            $this->transits->add($transits);
            $transits->setVille($this);
        }

        return $this;
    }

    public function removeTransits(Transit $transits): static
    {
        if ($this->transits->removeElement($transits)) {
            // set the owning side to null (unless already changed)
            if ($transits->getVille() === $this) {
                $transits->setVille(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Transit>
     */
    public function getTransites(): Collection
    {
        return $this->transites;
    }

    public function addTransite(Transit $transite): static
    {
        if (!$this->transites->contains($transite)) {
            $this->transites->add($transite);
            $transite->setVillearrive($this);
        }

        return $this;
    }

    public function removeTransite(Transit $transite): static
    {
        if ($this->transites->removeElement($transite)) {
            // set the owning side to null (unless already changed)
            if ($transite->getVillearrive() === $this) {
                $transite->setVillearrive(null);
            }
        }

        return $this;
    }
}
