<?php

namespace App\Entity;

use App\Repository\VoyageRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: VoyageRepository::class)]
class Voyage
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'voyages')]
    private ?Ville $villedepart = null;

    #[ORM\ManyToOne(inversedBy: 'voyages')]
    private ?Ville $villearrive = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datedepart = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datearrive = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $reference = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datecreation = null;

    #[ORM\ManyToOne(inversedBy: 'voyages')]
    private ?Societe $societe = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $heuredepart = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $heurearrivee = null;

    #[ORM\OneToMany(targetEntity: Transit::class, mappedBy: 'voyage')]
    private Collection $transits;

    #[ORM\Column(nullable: true)]
    private ?bool $statut = null;

    #[ORM\ManyToOne(inversedBy: 'voyages')]
    private ?Vehicule $vehicule = null;

    /**
     * @var Collection<int, Charge>
     */
    #[ORM\OneToMany(targetEntity: Charge::class, mappedBy: 'voyage')]
    private Collection $charges;

    #[ORM\Column(nullable: true)]
    private ?bool $actif = null;

    /**
     * @var Collection<int, ChauffeurVoyage>
     */
    #[ORM\OneToMany(targetEntity: ChauffeurVoyage::class, mappedBy: 'voyage',cascade: ['persist'], orphanRemoval: true)]
    private Collection $chauffeurVoyages;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $available = null;

    public function __construct()
    {
        $this->transits = new ArrayCollection();
        $this->charges = new ArrayCollection();
        $this->chauffeurVoyages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getVilledepart(): ?Ville
    {
        return $this->villedepart;
    }

    public function setVilledepart(?Ville $villedepart): static
    {
        $this->villedepart = $villedepart;

        return $this;
    }

    public function getVillearrive(): ?Ville
    {
        return $this->villearrive;
    }

    public function setVillearrive(?Ville $villearrive): static
    {
        $this->villearrive = $villearrive;

        return $this;
    }

    public function getDatedepart(): ?\DateTimeInterface
    {
        return $this->datedepart;
    }

    public function setDatedepart(?\DateTimeInterface $datedepart): static
    {
        $this->datedepart = $datedepart;

        return $this;
    }

    public function getDatearrive(): ?\DateTimeInterface
    {
        return $this->datearrive;
    }

    public function setDatearrive(?\DateTimeInterface $datearrive): static
    {
        $this->datearrive = $datearrive;

        return $this;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function setReference(?string $reference): static
    {
        $this->reference = $reference;

        return $this;
    }

    public function getDatecreation(): ?\DateTimeInterface
    {
        return $this->datecreation;
    }

    public function setDatecreation(?\DateTimeInterface $datecreation): static
    {
        $this->datecreation = $datecreation;

        return $this;
    }

    public function getSociete(): ?Societe
    {
        return $this->societe;
    }

    public function setSociete(?Societe $societe): static
    {
        $this->societe = $societe;

        return $this;
    }

    public function getHeuredepart(): ?string
    {
        return $this->heuredepart;
    }

    public function setHeuredepart(?string $heuredepart): static
    {
        $this->heuredepart = $heuredepart;

        return $this;
    }

    public function getHeurearrivee(): ?string
    {
        return $this->heurearrivee;
    }

    public function setHeurearrivee(?string $heurearrivee): static
    {
        $this->heurearrivee = $heurearrivee;

        return $this;
    }

    /**
     * @return Collection<int, Transit>
     */
    public function getTransits(): Collection
    {
        return $this->transits;
    }

    public function addTransit(Transit $transit): static
    {
        if (!$this->transits->contains($transit)) {
            $this->transits->add($transit);
            $transit->setVoyage($this);
        }

        return $this;
    }

    public function removeTransit(Transit $transit): static
    {
        if ($this->transits->removeElement($transit)) {
            // set the owning side to null (unless already changed)
            if ($transit->getVoyage() === $this) {
                $transit->setVoyage(null);
            }
        }

        return $this;
    }

    public function isStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(?bool $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    public function getVehicule(): ?Vehicule
    {
        return $this->vehicule;
    }

    public function setVehicule(?Vehicule $vehicule): static
    {
        $this->vehicule = $vehicule;

        return $this;
    }

    /**
     * @return Collection<int, Charge>
     */
    public function getCharges(): Collection
    {
        return $this->charges;
    }

    public function addCharge(Charge $charge): static
    {
        if (!$this->charges->contains($charge)) {
            $this->charges->add($charge);
            $charge->setVoyage($this);
        }

        return $this;
    }

    public function removeCharge(Charge $charge): static
    {
        if ($this->charges->removeElement($charge)) {
            // set the owning side to null (unless already changed)
            if ($charge->getVoyage() === $this) {
                $charge->setVoyage(null);
            }
        }

        return $this;
    }

    public function isActif(): ?bool
    {
        return $this->actif;
    }

    public function setActif(?bool $actif): static
    {
        $this->actif = $actif;

        return $this;
    }

    /**
     * @return Collection<int, ChauffeurVoyage>
     */
    public function getChauffeurVoyages(): Collection
    {
        return $this->chauffeurVoyages;
    }

    public function addChauffeurVoyage(ChauffeurVoyage $chauffeurVoyage): static
    {
        if (!$this->chauffeurVoyages->contains($chauffeurVoyage)) {
            $this->chauffeurVoyages->add($chauffeurVoyage);
            $chauffeurVoyage->setVoyage($this);
        }

        return $this;
    }

    public function removeChauffeurVoyage(ChauffeurVoyage $chauffeurVoyage): static
    {
        if ($this->chauffeurVoyages->removeElement($chauffeurVoyage)) {
            // set the owning side to null (unless already changed)
            if ($chauffeurVoyage->getVoyage() === $this) {
                $chauffeurVoyage->setVoyage(null);
            }
        }

        return $this;
    }

    public function getAvailable(): ?string
    {
        return $this->available;
    }

    public function setAvailable(?string $available): static
    {
        $this->available = $available;

        return $this;
    }
}
