<?php

namespace App\Form;

use App\Entity\Chauffeur;
use App\Entity\Societe;
use App\Entity\User;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ChauffeurType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom')
            ->add('postnom')
            ->add('prenom')
            ->add('sexe', ChoiceType::class, ['label' => 'Sexe',
                'choices' => array(
                    'M' => 'M',
                    'F' => 'F'
                )])
            ->add('telephone')
            ->add('user', RegistrationSocieteFormType::class, ['label' => 'Compte Utlisateur', 'required' => false,]);;

        /* ->add('statut')
         ->add('societe', EntityType::class, [
             'class' => Societe::class,
             'choice_label' => 'id',
         ])
         ->add('user', EntityType::class, [
             'class' => User::class,
             'choice_label' => 'id',
         ])*/
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Chauffeur::class,
        ]);
    }
}
