<?php

namespace App\Form;

use App\Entity\Chauffeur;
use App\Entity\ChauffeurVoyage;
use App\Entity\Voyage;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;


class ChauffeurVoyageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('chauffeur', EntityType::class, [
            'class' => Chauffeur::class,
            'choice_label' => function (Chauffeur $chauffeur) {
                return $chauffeur->getNom() . ' ' . $chauffeur->getPrenom();
            },
            'placeholder' => 'Choisir un chauffeur',
        ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ChauffeurVoyage::class,
        ]);
    }
}
