<?php

namespace App\Form;

use App\Entity\Client;
use App\Entity\Societe;
use App\Entity\Transit;
use App\Entity\VehiculeSiege;
use App\Repository\VehiculeSiegeRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ClientType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        /** @var Transit $transit */
        $transit = $options['transit'];
        $builder
            ->add('nom')
            ->add('prenom')
            ->add('email')
            ->add('telephone')
            ->add('vehiculesiege', EntityType::class, [
                'class' => VehiculeSiege::class,
                'mapped' => false, // IMPORTANT: ce champ n'existe pas dans Client
                'placeholder' => 'Choisir un siège disponible',
                'choice_label' => fn(VehiculeSiege $s) => 'Siège ' . $s->getNumerosiege(),
                'query_builder' => function (VehiculeSiegeRepository $repo) use ($transit) {
                    // QueryBuilder version de la méthode repo
                    $vehicule = $transit->getVoyage()->getVehicule();

                    return $repo->createQueryBuilder('vs')
                        ->where('vs.vehicule = :vehicule')
                        ->andWhere('vs.id NOT IN (
                        SELECT IDENTITY(r.vehiculesiege)
                        FROM App\Entity\Reservation r
                        WHERE r.transit = :transit
                        AND r.vehiculesiege IS NOT NULL
                    )')
                        ->setParameter('vehicule', $vehicule)
                        ->setParameter('transit', $transit)
                        ->orderBy('vs.numerosiege', 'ASC');
                },
            ])


        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Client::class,
            'transit' => null,

        ]);

        $resolver->setRequired('transit');
        $resolver->setAllowedTypes('transit', [Transit::class]);
    }
}
