<?php
namespace App\Form\Model;

use App\Entity\Permission;
use App\Entity\Role;

class UserRoleDTO
{
    /** @var Role[] */
    private array $roles = [];

    public function getRoles(): array
    {
        return $this->roles;
    }

    // ✅ Ici on accepte n'importe quel iterable (array OU ArrayCollection)
    public function setRoles(iterable $roles): void
    {
        $this->roles = is_array($roles) ? $roles : iterator_to_array($roles);
    }
}