<?php

namespace App\Form;

use App\Entity\Permission;
use App\Form\Model\RolePermissionDTO;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RolePermissionMassFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('permissions', EntityType::class, [
            'class' => Permission::class,
            'choice_label' => 'label',
            'multiple' => true,
            'expanded' => true,
            'by_reference' => false,
        ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => RolePermissionDTO::class,
            'csrf_protection' => false, // pour faciliter l'AJAX sans token
        ]);
    }
}
