<?php

namespace App\Form;

use App\Entity\Permission;
use App\Entity\Role;
use App\Entity\RolePermission;
use App\Form\Model\RolePermissionDTO;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RolePermissionRoleForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

            ->add('permission', EntityType::class, [
                'class' => Permission::class,
                'choice_label' => 'label',
                'multiple' => true,         // Permet la sélection multiple
                'expanded' => true,         // Transforme en cases à cocher (au lieu d'un <select multiple>)
                'by_reference' => false     // Important si c'est une relation ManyToMany et que tu veux que le setter soit utilisé
            ]);

    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => RolePermissionDTO::class,
        ]);
    }
}
