<?php

namespace App\Form;

use App\Entity\Role;
use App\Entity\User;
use App\Entity\UserRole;
use App\Form\Model\UserRoleDTO;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserRoleMassForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('roles', EntityType::class, [
                'class' => Role::class,
                'choice_label' => 'label',
                'multiple' => true,
                'expanded' => true,
                'by_reference' => false,
            ]);
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => UserRoleDTO::class,
            'csrf_protection' => false, // pour faciliter l'AJAX sans token

        ]);
    }
}
