<?php

namespace App\Form;

use App\Entity\Societe;
use App\Entity\TypeVehicule;
use App\Entity\Vehicule;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class VehiculeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('marque')
            ->add('modele')
            ->add('annee')
            ->add('couleur')
            ->add('immatriculation')
            ->add('capacite')
            /*->add('statut')
            ->add('typevehicule', EntityType::class, [
                'class' => TypeVehicule::class,
                'choice_label' => 'id',
            ])
            ->add('societe', EntityType::class, [
                'class' => Societe::class,
                'choice_label' => 'id',
            ])*/
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Vehicule::class,
        ]);
    }
}
