<?php

namespace App\Repository;

use App\Entity\Reservation;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Reservation>
 *
 * @method Reservation|null find($id, $lockMode = null, $lockVersion = null)
 * @method Reservation|null findOneBy(array $criteria, array $orderBy = null)
 * @method Reservation[]    findAll()
 * @method Reservation[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ReservationRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Reservation::class);
    }

    /**
     * @return Reservation[] Returns an array of Reservation objects
     */
    public function findByVoyage($value,$user): array
    {
        $today = new \DateTime();  // Récupère la date actuelle
       // $today->format('Y-m-d');

        return $this->createQueryBuilder('r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->join('App\Entity\User', 'u', 'WITH', 'u.id = r.user')
            ->andWhere('v.id = :val')
            ->andWhere('r.dateReservation = :today')
            ->andWhere('u.id = :user')
            ->setParameter('user', $user)
            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getResult();
    }

    public function findByVoyageAdmin($value): array
    {
        $today = new \DateTime();  // Récupère la date actuelle
        // $today->format('Y-m-d');

        return $this->createQueryBuilder('r')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('v.id = :val')
//            ->andWhere('r.dateReservation = :today')
//            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getResult();
    }


    public function totaltickesvendusVoyagePrix($value): array
    {

        $today = new \DateTime();  // Récupère la date actuelle

        return $this->createQueryBuilder('r')
            ->select('SUM(t.prix) as total')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('v.id = :val')
            ->andWhere('r.dateReservation = :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getArrayResult();
    }

    public function totaltickesvendusTransitPrix($value): array
    {
        $today = new \DateTime();  // Récupère la date actuelle

        return $this->createQueryBuilder('r')
            ->select('SUM(t.prix) as total')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('v.id = :val')
            ->andWhere('r.dateReservation = :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getArrayResult();
    }

    public function totaltickesvendusVoyage($value): array
    {
        $today = new \DateTime();  // Récupère la date actuelle

        return $this->createQueryBuilder('r')
            ->select('COUNT(t.prix) as total')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('v.id = :val')
            ->andWhere('r.dateReservation = :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getArrayResult();
    }

    public function totaltickesvendusTransit($value): array
    {
        $today = new \DateTime();  // Récupère la date actuelle

        return $this->createQueryBuilder('r')
            ->select('COUNT(t.prix) as total')
            ->Join('App\Entity\Transit', 't', 'WITH', 't.id = r.transit')
            ->Join('App\Entity\Voyage', 'v', 'WITH', 'v.id = t.voyage')
            ->andWhere('v.id = :val')
            ->andWhere('r.dateReservation = :today')
            ->setParameter('today', $today->format('Y-m-d'))
            ->setParameter('val', $value)
            ->getQuery()
            ->getArrayResult();
    }

    //    public function findOneBySomeField($value): ?Reservation
    //    {
    //        return $this->createQueryBuilder('r')
    //            ->andWhere('r.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
