<?php

namespace App\Repository;

use App\Entity\Transit;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Transit>
 *
 * @method Transit|null find($id, $lockMode = null, $lockVersion = null)
 * @method Transit|null findOneBy(array $criteria, array $orderBy = null)
 * @method Transit[]    findAll()
 * @method Transit[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TransitRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Transit::class);
    }

    /**
     * @return Transit[] Returns an array of Transit objects
     */
    public function findByEtape($value, $valeure): array
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.numeroetape >= :val')
            ->andWhere('t.voyage >= :valeure')
            ->setParameter('val', $value)
            ->setParameter('valeure', $valeure)
            ->orderBy('t.numeroetape', 'ASC')
            ->getQuery()
            ->getResult();
    }


    /**
     * @return Transit[] Returns an array of Transit objects
     */
    public function findByVoyage($villeDepart, $villeArrivee, $dateDepart): array
    {
        return $this->createQueryBuilder('v')
            ->andWhere('v.ville = :ville')
            ->andWhere('v.villearrive = :villearrive')
            ->andWhere('v.datedepart BETWEEN DATE_SUB(:datedepart, 2, \'DAY\') AND DATE_ADD(:datedepart, 2, \'DAY\')')
            ->setParameter('ville', $villeDepart)
            ->setParameter('villearrive', $villeArrivee)
            ->setParameter('datedepart', $dateDepart)
            ->getQuery()
            ->getResult();
    }





    //    public function findOneBySomeField($value): ?Transit
    //    {
    //        return $this->createQueryBuilder('t')
    //            ->andWhere('t.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
