<?php

namespace App\Repository;

use App\Entity\VehiculeSiege;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<VehiculeSiege>
 */
class VehiculeSiegeRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, VehiculeSiege::class);
    }

    //    /**
    //     * @return VehiculeSiege[] Returns an array of VehiculeSiege objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('v')
    //            ->andWhere('v.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('v.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?VehiculeSiege
    //    {
    //        return $this->createQueryBuilder('v')
    //            ->andWhere('v.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }

/*

    public function findAvailableForTransit(Transit $transit): array
    {
        return $this->createQueryBuilder('vs')
            ->innerJoin('vs.vehicule', 'v')
            ->innerJoin('transit.voyage', 'voy')
            ->innerJoin('voy.vehicule', 'vv')
            ->leftJoin(
                'App\Entity\Reservation',
                'r',
                'WITH',
                'r.transit = :transit AND r.vehiculesiege = vs'
            )
            ->where('vv = v')
            ->andWhere('r.id IS NULL') // pas encore réservé pour ce transit
            ->setParameter('transit', $transit)
            ->orderBy('vs.numerosiege', 'ASC')
            ->getQuery()
            ->getResult();
    }*/



    /**
     * @return VehiculeSiege[]
     */
    public function findAvailableByTransit(Transit $transit): array
    {
        $vehicule = $transit->getVoyage()->getVehicule();

        return $this->createQueryBuilder('vs')
            ->where('vs.vehicule = :vehicule')
            ->andWhere('vs.id NOT IN (
                SELECT IDENTITY(r.vehiculesiege)
                FROM App\Entity\Reservation r
                WHERE r.transit = :transit
                AND r.vehiculesiege IS NOT NULL
            )')
            ->setParameter('vehicule', $vehicule)
            ->setParameter('transit', $transit)
            ->orderBy('vs.numerosiege', 'ASC')
            ->getQuery()
            ->getResult();
    }
}
