<?php

namespace App\Repository;

use App\Entity\Voyage;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Voyage>
 *
 * @method Voyage|null find($id, $lockMode = null, $lockVersion = null)
 * @method Voyage|null findOneBy(array $criteria, array $orderBy = null)
 * @method Voyage[]    findAll()
 * @method Voyage[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class VoyageRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Voyage::class);
    }

        /**
         * @return Voyage[] Returns an array of Voyage objects
         */
        public function findByExampleField($value): array
        {
            return $this->createQueryBuilder('v')
                ->andWhere('v.exampleField = :val')
                ->setParameter('val', $value)
                ->orderBy('v.id', 'ASC')
                ->setMaxResults(10)
                ->getQuery()
                ->getResult()
            ;
        }


    public function getVoyageDetails($user,$today)
    {

        $qb = $this->createQueryBuilder('v')
            // Jointure explicite entre Voyage et Transit
            ->join('App\Entity\Transit', 't', 'WITH', 'v.id = t.voyage')
            // Jointure explicite entre Transit et Reservation
            ->join('App\Entity\Reservation', 'r', 'WITH', 't.id = r.transit')
            ->join('App\Entity\Ville', 'c', 'WITH', 'c.id = t.ville')
            ->join('App\Entity\Ville', 'f', 'WITH', 'f.id = t.villearrive')
            ->leftJoin('App\Entity\Charge', 'charge', 'WITH', 'charge.id = v.id')
            ->join('App\Entity\User', 'u', 'WITH', 'u.id = r.user')



            ->where('r.dateReservation >= :today')
            ->andWhere('r.user = :user')
            ->setParameter('today', $today)  // Paramètre de la date de la réservation du jour
            ->setParameter('user', $user)  // Paramètre de la date de la réservation du jour

            // Sélectionner les informations nécessaires
            ->select(
                'v.id AS voyage',
                't.id AS transit',
                'c.id AS ville',
                'u.id AS user',
                'v.datedepart AS dateDepart',
                'c.nom AS villeDepart',
                'f.nom AS villeArrivee',  // Accès à la propriété "nom" de Ville pour la ville d'arrivée
                'COUNT(r.id) AS nombreReservations',
                'SUM(t.prix) AS sommeArgent',
                'COALESCE(SUM(charge.montant), 0) AS sommeCharges'  // Somme des charges, 0 si null

            )
            // Groupement des résultats par voyage, transit, date et villes
            ->groupBy('v.id, t.id, v.datedepart, c.nom,f.nom');  // Groupement avec les alias uniques

        return $qb->getQuery()->getResult();
    }


    public function getVoyageDetailsAdmin($today)
    {

        $qb = $this->createQueryBuilder('v')
            // Jointure explicite entre Voyage et Transit
            ->join('App\Entity\Transit', 't', 'WITH', 'v.id = t.voyage')
            // Jointure explicite entre Transit et Reservation
            ->join('App\Entity\Reservation', 'r', 'WITH', 't.id = r.transit')
            ->join('App\Entity\Ville', 'c', 'WITH', 'c.id = t.ville')
            ->join('App\Entity\Ville', 'f', 'WITH', 'f.id = t.villearrive')
            ->leftJoin('App\Entity\Charge', 'charge', 'WITH', 'charge.id = v.id')
            ->join('App\Entity\User', 'u', 'WITH', 'u.id = r.user')


            ->where('r.dateReservation >= :today')
            ->setParameter('today', $today)  // Paramètre de la date de la réservation du jour

            // Sélectionner les informations nécessaires
            ->select(
                'v.id AS voyage',
                't.id AS transit',
                'c.id AS ville',
                'u.id AS user',
                'v.datedepart AS dateDepart',
                'c.nom AS villeDepart',
                'f.nom AS villeArrivee',  // Accès à la propriété "nom" de Ville pour la ville d'arrivée
                'COUNT(r.id) AS nombreReservations',
                'SUM(t.prix) AS sommeArgent',
                'COALESCE(SUM(charge.montant), 0) AS sommeCharges'  // Somme des charges, 0 si null

            )
            // Groupement des résultats par voyage, transit, date et villes
            ->groupBy('v.id, t.id, v.datedepart, c.nom,f.nom');  // Groupement avec les alias uniques

        return $qb->getQuery()->getResult();
    }



    public function getVoyageDetailsSearch($user,$dateDebut,$dateFin)
    {

        $qb = $this->createQueryBuilder('v')
            // Jointure explicite entre Voyage et Transit
            ->join('App\Entity\Transit', 't', 'WITH', 'v.id = t.voyage')
            // Jointure explicite entre Transit et Reservation
            ->join('App\Entity\Reservation', 'r', 'WITH', 't.id = r.transit')
            ->join('App\Entity\Ville', 'c', 'WITH', 'c.id = t.ville')
            ->join('App\Entity\Ville', 'f', 'WITH', 'f.id = t.villearrive')
            ->leftJoin('App\Entity\Charge', 'charge', 'WITH', 'charge.id = v.id')
            ->join('App\Entity\User', 'u', 'WITH', 'u.id = r.user')



            ->where('r.dateReservation BETWEEN :dateDebut AND :dateFin')
            ->andWhere('r.user = :user')
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)
            ->setParameter('user', $user)  // Paramètre de la date de la réservation du jour

            // Sélectionner les informations nécessaires
            ->select(
                'v.id AS voyage',
                't.id AS transit',
                'c.id AS ville',
                'u.id AS user',
                'v.datedepart AS dateDepart',
                'c.nom AS villeDepart',
                'f.nom AS villeArrivee',  // Accès à la propriété "nom" de Ville pour la ville d'arrivée
                'COUNT(r.id) AS nombreReservations',
                'SUM(t.prix) AS sommeArgent',
                'COALESCE(SUM(charge.montant), 0) AS sommeCharges'  // Somme des charges, 0 si null
            )
            // Groupement des résultats par voyage, transit, date et villes
            ->groupBy('v.id, t.id, v.datedepart, c.nom,f.nom');  // Groupement avec les alias uniques

        return $qb->getQuery()->getResult();
    }



    public function getVoyageDetailsSearchAdmin($dateDebut,$dateFin)
    {

        $qb = $this->createQueryBuilder('v')
            // Jointure explicite entre Voyage et Transit
            ->join('App\Entity\Transit', 't', 'WITH', 'v.id = t.voyage')
            // Jointure explicite entre Transit et Reservation
            ->join('App\Entity\Reservation', 'r', 'WITH', 't.id = r.transit')
            ->join('App\Entity\Ville', 'c', 'WITH', 'c.id = t.ville')
            ->join('App\Entity\Ville', 'f', 'WITH', 'f.id = t.villearrive')
            ->leftJoin('App\Entity\Charge', 'charge', 'WITH', 'charge.id = v.id')
            ->join('App\Entity\User', 'u', 'WITH', 'u.id = r.user')



            ->where('r.dateReservation BETWEEN :dateDebut AND :dateFin')
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)

            // Sélectionner les informations nécessaires
            ->select(
                'v.id AS voyage',
                't.id AS transit',
                'c.id AS ville',
                'u.id AS user',
                'v.datedepart AS dateDepart',
                'c.nom AS villeDepart',
                'f.nom AS villeArrivee',  // Accès à la propriété "nom" de Ville pour la ville d'arrivée
                'COUNT(r.id) AS nombreReservations',
                'SUM(t.prix) AS sommeArgent',
                'COALESCE(SUM(charge.montant), 0) AS sommeCharges'  // Somme des charges, 0 si null
            )
            // Groupement des résultats par voyage, transit, date et villes
            ->groupBy('v.id, t.id, v.datedepart, c.nom,f.nom');  // Groupement avec les alias uniques

        return $qb->getQuery()->getResult();
    }







    //    public function findOneBySomeField($value): ?Voyage
    //    {
    //        return $this->createQueryBuilder('v')
    //            ->andWhere('v.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
