<?php
// src/Security/AccessDeniedHandler.php

namespace App\Security;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response; // <- important
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Security\Http\Authorization\AccessDeniedHandlerInterface;

final class AccessDeniedHandler implements AccessDeniedHandlerInterface
{
    public function __construct(private RouterInterface $router) {}

    /**
     * Must match the interface exactly:
     * handle(Request $request, AccessDeniedException $accessDeniedException): ?Response
     */
    public function handle(Request $request, AccessDeniedException $accessDeniedException): ?Response
    {
        // message flash (si session dispo)
        $request->getSession()?->getFlashBag()->add('danger', 'Accès refusé : droits insuffisants.');

        // redirection où tu veux (ex: page d’accueil)
        return new RedirectResponse($this->router->generate('app_user_profile'));
    }
}
