<?php

namespace App\Security;

use Symfony\Component\Security\Http\Authentication\AuthenticationSuccessHandlerInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class CustomAuthenticationSuccessHandler implements AuthenticationSuccessHandlerInterface
{
    private $urlGenerator;

    public function __construct(UrlGeneratorInterface $urlGenerator)
    {
        $this->urlGenerator = $urlGenerator;
    }

    public function onAuthenticationSuccess(Request $request, TokenInterface $token): RedirectResponse
    {
        // Rediriger vers la page d'accueil par défaut
//        $targetPaths = $this->urlGenerator->generate('app_user_profile');

        $targetPaths = $this->urlGenerator->generate('app_user_profile');


        // Rediriger vers une page spécifique en fonction du rôle de l'utilisateur
       /* if ($token->getUser()->hasRole('ROLE_ADMIN')) {
            $targetPath = $this->urlGenerator->generate('admin_dashboard');
        }*/




        return new RedirectResponse($targetPaths);
    }
}
