<?php

// src/Security/Voter/PermissionVoter.php

namespace App\Security\Voter;

use App\Entity\User;
use App\Service\AccessManager;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class PermissionVoter extends Voter
{
    public function __construct(
        private AccessManager $accessManager
    ) {}

    protected function supports(string $attribute, mixed $subject): bool
    {
        // On considère comme permission tout string en MAJUSCULE avec underscore
        return is_string($attribute) && preg_match('/^[A-Z0-9_]+$/', $attribute);
    }

    protected function voteOnAttribute(string $attribute, mixed $subject, TokenInterface $token): bool
    {
        $user = $token->getUser();

        if (!$user instanceof User) {
            return false;
        }

        return $this->accessManager->userHasPermission($user, $attribute);
    }
}
