<?php


// src/Service/AccessManager.php

namespace App\Service;

use App\Entity\User;
use Doctrine\ORM\EntityManagerInterface;

class AccessManager
{
    public function __construct(private EntityManagerInterface $em) {}

    public function userHasPermission(User $user, string $permissionCode): bool
    {
        $qb = $this->em->createQueryBuilder();

        $qb->select('p.id')
            ->from('App\Entity\Permission', 'p')
            ->join('App\Entity\RolePermission', 'rp', 'WITH', 'rp.permission = p')
            ->join('App\Entity\UserRole', 'ur', 'WITH', 'ur.role = rp.role')
            ->where('ur.user = :user')
            ->andWhere('p.code = :code')
            ->setParameter('user', $user)
            ->setParameter('code', $permissionCode)
            ->setMaxResults(1);

        return (bool) $qb->getQuery()->getOneOrNullResult();
    }
}
