<?php

namespace App\Test\Controller;

use App\Entity\Vehicule;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class VehiculeControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private EntityManagerInterface $manager;
    private EntityRepository $repository;
    private string $path = '/vehicule/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->manager = static::getContainer()->get('doctrine')->getManager();
        $this->repository = $this->manager->getRepository(Vehicule::class);

        foreach ($this->repository->findAll() as $object) {
            $this->manager->remove($object);
        }

        $this->manager->flush();
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Vehicule index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'vehicule[marque]' => 'Testing',
            'vehicule[modele]' => 'Testing',
            'vehicule[annee]' => 'Testing',
            'vehicule[couleur]' => 'Testing',
            'vehicule[immatriculation]' => 'Testing',
            'vehicule[capacite]' => 'Testing',
            'vehicule[statut]' => 'Testing',
            'vehicule[typevehicule]' => 'Testing',
            'vehicule[societe]' => 'Testing',
        ]);

        self::assertResponseRedirects($this->path);

        self::assertSame(1, $this->repository->count([]));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new Vehicule();
        $fixture->setMarque('My Title');
        $fixture->setModele('My Title');
        $fixture->setAnnee('My Title');
        $fixture->setCouleur('My Title');
        $fixture->setImmatriculation('My Title');
        $fixture->setCapacite('My Title');
        $fixture->setStatut('My Title');
        $fixture->setTypevehicule('My Title');
        $fixture->setSociete('My Title');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Vehicule');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new Vehicule();
        $fixture->setMarque('Value');
        $fixture->setModele('Value');
        $fixture->setAnnee('Value');
        $fixture->setCouleur('Value');
        $fixture->setImmatriculation('Value');
        $fixture->setCapacite('Value');
        $fixture->setStatut('Value');
        $fixture->setTypevehicule('Value');
        $fixture->setSociete('Value');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'vehicule[marque]' => 'Something New',
            'vehicule[modele]' => 'Something New',
            'vehicule[annee]' => 'Something New',
            'vehicule[couleur]' => 'Something New',
            'vehicule[immatriculation]' => 'Something New',
            'vehicule[capacite]' => 'Something New',
            'vehicule[statut]' => 'Something New',
            'vehicule[typevehicule]' => 'Something New',
            'vehicule[societe]' => 'Something New',
        ]);

        self::assertResponseRedirects('/vehicule/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getMarque());
        self::assertSame('Something New', $fixture[0]->getModele());
        self::assertSame('Something New', $fixture[0]->getAnnee());
        self::assertSame('Something New', $fixture[0]->getCouleur());
        self::assertSame('Something New', $fixture[0]->getImmatriculation());
        self::assertSame('Something New', $fixture[0]->getCapacite());
        self::assertSame('Something New', $fixture[0]->getStatut());
        self::assertSame('Something New', $fixture[0]->getTypevehicule());
        self::assertSame('Something New', $fixture[0]->getSociete());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();
        $fixture = new Vehicule();
        $fixture->setMarque('Value');
        $fixture->setModele('Value');
        $fixture->setAnnee('Value');
        $fixture->setCouleur('Value');
        $fixture->setImmatriculation('Value');
        $fixture->setCapacite('Value');
        $fixture->setStatut('Value');
        $fixture->setTypevehicule('Value');
        $fixture->setSociete('Value');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertResponseRedirects('/vehicule/');
        self::assertSame(0, $this->repository->count([]));
    }
}
