const Encore = require('@symfony/webpack-encore');

// Manually configure the runtime environment if not already configured yet by the "encore" command.
// It's useful when you use tools that rely on webpack.config.js file.
if (!Encore.isRuntimeEnvironmentConfigured()) {
    Encore.configureRuntimeEnvironment(process.env.NODE_ENV || 'dev');
}

Encore
    // directory where compiled assets will be stored
    .setOutputPath('public/build/')
    // public path used by the web server to access the output path
    .setPublicPath('/build')
    // only needed for CDN's or subdirectory deploy
    //.setManifestKeyPrefix('build/')
    .copyFiles({
        from: './assets/images',
    })
    /*
     * ENTRY CONFIG
     *
     * Each entry will result in one JavaScript file (e.g. app.js)
     * and one CSS file (e.g. app.css) if your JavaScript imports CSS.
     */
    .addEntry('app', './assets/js/app.js')
    .addEntry('apps', './assets/js/apps.js')
    .addEntry('app_test', './assets/js/app_test.js')
    .addEntry('apps_test', './assets/js/apps_test.js')
    .addEntry('app_table', './assets/js/app_table.js')
    .addEntry('apps_table', './assets/js/apps_table.js')
    .addEntry('login', './assets/js/pages/login.js')
    .addEntry('logins', './assets/js/pages/logins.js')
    .addEntry('bases', './assets/js/pages/bases.js')
    .addEntry('base', './assets/js/pages/base.js')
    .addEntry('pagetable', './assets/js/pages/pagetable.js')
    .addEntry('page_option', './assets/js/pages/page_option.js')
    .addEntry('employee_new', './assets/js/pages/employee/employee_new')
    .addEntry('chapter_new', './assets/js/pages/chapter/chapter_new')
    .addEntry('commande_new', './assets/js/pages/chapter/commande_new')
    .addEntry('vidcall', './assets/js/pages/vidcall/vidcall')


    // When enabled, Webpack "splits" your files into smaller pieces for greater optimization.
    .splitEntryChunks()

    // enables the Symfony UX Stimulus bridge (used in assets/bootstrap.js)
    // .enableStimulusBridge('./assets/controllers.json')

    // will require an extra script tag for runtime.js
    // but, you probably want this, unless you're building a single-page app
    .enableSingleRuntimeChunk()

    /*
     * FEATURE CONFIG
     *
     * Enable & configure other features below. For a full
     * list of features, see:
     * https://symfony.com/doc/current/frontend.html#adding-more-features
     */
    .cleanupOutputBeforeBuild()
    .enableBuildNotifications()
    .enableSourceMaps(!Encore.isProduction())
    // enables hashed filenames (e.g. app.abc123.css)
    .enableVersioning(Encore.isProduction())
    .enableStimulusBridge('./assets/controllers.json')

    // configure Babel
    // .configureBabel((config) => {
    //     config.plugins.push('@babel/a-babel-plugin');
    // })

    // enables and configure @babel/preset-env polyfills
    .configureBabelPresetEnv((config) => {
        config.useBuiltIns = 'usage';
        config.corejs = '3.23';
    })
    .autoProvidejQuery()


    // enables Sass/SCSS support
    //.enableSassLoader()

    // uncomment if you use TypeScript
    //.enableTypeScriptLoader()

    // uncomment if you use React
    //.enableReactPreset()

    // uncomment to get integrity="..." attributes on your script & link tags
    // requires WebpackEncoreBundle 1.4 or higher
    //.enableIntegrityHashes(Encore.isProduction())

    // uncomment if you're having problems with a jQuery plugin
    //.autoProvidejQuery()
;



module.exports = {
    // ...
    module: {
        rules: [
            // ...
            {
                test: /\.(png|woff|woff2|eot|ttf|otf|html)$/,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: 'build/',
                        },
                    },
                ],
            },
        ],
    },
};
module.exports = Encore.getWebpackConfig();
