<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Validator\Exception;

class MissingOptionsException extends ValidatorException
{
    private array $options;

    public function __construct(string $message, array $options)
    {
        parent::__construct($message);

        $this->options = $options;
    }

    public function getOptions(): array
    {
        return $this->options;
    }
}
